/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.MathUtils;
import android.util.Property;
import android.view.MagnificationSpec;
import android.view.WindowManagerInternal;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.SomeArgs;
import com.android.server.LocalServices;
import com.android.server.accessibility.AccessibilityManagerService;
import java.util.Locale;

class MagnificationController {
    private static final String LOG_TAG = "MagnificationController";
    private static final boolean DEBUG_SET_MAGNIFICATION_SPEC = false;
    private static final int DEFAULT_SCREEN_MAGNIFICATION_AUTO_UPDATE = 1;
    private static final int INVALID_ID = -1;
    private static final float DEFAULT_MAGNIFICATION_SCALE = 2.0f;
    private static final float MIN_SCALE = 1.0f;
    private static final float MAX_SCALE = 5.0f;
    private static final float MIN_PERSISTED_SCALE = 2.0f;
    private final Object mLock;
    private final MagnificationSpec mCurrentMagnificationSpec = MagnificationSpec.obtain();
    private final Region mMagnificationRegion = Region.obtain();
    private final Rect mMagnificationBounds = new Rect();
    private final Rect mTempRect = new Rect();
    private final Rect mTempRect1 = new Rect();
    private final AccessibilityManagerService mAms;
    private final ContentResolver mContentResolver;
    private final ScreenStateObserver mScreenStateObserver;
    private final WindowStateObserver mWindowStateObserver;
    private final SpecAnimationBridge mSpecAnimationBridge;
    private int mUserId;
    private int mIdOfLastServiceToMagnify = -1;
    private boolean mRegistered;
    private boolean mUnregisterPending;

    public MagnificationController(Context context, AccessibilityManagerService ams, Object lock) {
        this.mAms = ams;
        this.mContentResolver = context.getContentResolver();
        this.mScreenStateObserver = new ScreenStateObserver(context, this);
        this.mWindowStateObserver = new WindowStateObserver(context, this);
        this.mLock = lock;
        this.mSpecAnimationBridge = new SpecAnimationBridge(context, this.mLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                this.mScreenStateObserver.register();
                this.mWindowStateObserver.register();
                this.mSpecAnimationBridge.setEnabled(true);
                this.mWindowStateObserver.getMagnificationRegion(this.mMagnificationRegion);
                this.mMagnificationRegion.getBounds(this.mMagnificationBounds);
                this.mRegistered = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isMagnifying()) {
                this.unregisterInternalLocked();
            } else {
                this.mUnregisterPending = true;
                this.resetLocked(true);
            }
        }
    }

    public boolean isRegisteredLocked() {
        return this.mRegistered;
    }

    private void unregisterInternalLocked() {
        if (this.mRegistered) {
            this.mSpecAnimationBridge.setEnabled(false);
            this.mScreenStateObserver.unregister();
            this.mWindowStateObserver.unregister();
            this.mMagnificationRegion.setEmpty();
            this.mRegistered = false;
        }
        this.mUnregisterPending = false;
    }

    public boolean isMagnifying() {
        return this.mCurrentMagnificationSpec.scale > 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMagnificationRegionChanged(Region magnified, boolean updateSpec) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return;
            }
            boolean magnificationChanged = false;
            boolean boundsChanged = false;
            if (!this.mMagnificationRegion.equals(magnified)) {
                this.mMagnificationRegion.set(magnified);
                this.mMagnificationRegion.getBounds(this.mMagnificationBounds);
                boundsChanged = true;
            }
            if (updateSpec) {
                MagnificationSpec sentSpec = this.mSpecAnimationBridge.mSentMagnificationSpec;
                float scale = sentSpec.scale;
                float offsetX = sentSpec.offsetX;
                float offsetY = sentSpec.offsetY;
                float centerX = ((float)this.mMagnificationBounds.width() / 2.0f + (float)this.mMagnificationBounds.left - offsetX) / scale;
                float centerY = ((float)this.mMagnificationBounds.height() / 2.0f + (float)this.mMagnificationBounds.top - offsetY) / scale;
                magnificationChanged = this.setScaleAndCenterLocked(scale, centerX, centerY, false, -1);
            }
            if (boundsChanged && updateSpec && !magnificationChanged) {
                this.onMagnificationChangedLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean magnificationRegionContains(float x, float y) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMagnificationRegion.contains((int)x, (int)y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMagnificationBounds(Rect outBounds) {
        Object object = this.mLock;
        synchronized (object) {
            outBounds.set(this.mMagnificationBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMagnificationRegion(Region outRegion) {
        Object object = this.mLock;
        synchronized (object) {
            outRegion.set(this.mMagnificationRegion);
        }
    }

    public float getScale() {
        return this.mCurrentMagnificationSpec.scale;
    }

    public float getOffsetX() {
        return this.mCurrentMagnificationSpec.offsetX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCenterX() {
        Object object = this.mLock;
        synchronized (object) {
            return ((float)this.mMagnificationBounds.width() / 2.0f + (float)this.mMagnificationBounds.left - this.getOffsetX()) / this.getScale();
        }
    }

    public float getOffsetY() {
        return this.mCurrentMagnificationSpec.offsetY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCenterY() {
        Object object = this.mLock;
        synchronized (object) {
            return ((float)this.mMagnificationBounds.height() / 2.0f + (float)this.mMagnificationBounds.top - this.getOffsetY()) / this.getScale();
        }
    }

    public float getSentScale() {
        return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.scale;
    }

    public float getSentOffsetX() {
        return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.offsetX;
    }

    public float getSentOffsetY() {
        return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.offsetY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reset(boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            return this.resetLocked(animate);
        }
    }

    private boolean resetLocked(boolean animate) {
        boolean changed;
        if (!this.mRegistered) {
            return false;
        }
        MagnificationSpec spec = this.mCurrentMagnificationSpec;
        boolean bl = changed = !spec.isNop();
        if (changed) {
            spec.clear();
            this.onMagnificationChangedLocked();
        }
        this.mIdOfLastServiceToMagnify = -1;
        this.mSpecAnimationBridge.updateSentSpec(spec, animate);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScale(float scale, float pivotX, float pivotY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return false;
            }
            scale = MathUtils.constrain(scale, 1.0f, 5.0f);
            Rect viewport = this.mTempRect;
            this.mMagnificationRegion.getBounds(viewport);
            MagnificationSpec spec = this.mCurrentMagnificationSpec;
            float oldScale = spec.scale;
            float oldCenterX = ((float)viewport.width() / 2.0f - spec.offsetX) / oldScale;
            float oldCenterY = ((float)viewport.height() / 2.0f - spec.offsetY) / oldScale;
            float normPivotX = (pivotX - spec.offsetX) / oldScale;
            float normPivotY = (pivotY - spec.offsetY) / oldScale;
            float offsetX = (oldCenterX - normPivotX) * (oldScale / scale);
            float offsetY = (oldCenterY - normPivotY) * (oldScale / scale);
            float centerX = normPivotX + offsetX;
            float centerY = normPivotY + offsetY;
            this.mIdOfLastServiceToMagnify = id2;
            return this.setScaleAndCenterLocked(scale, centerX, centerY, animate, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCenter(float centerX, float centerY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return false;
            }
            return this.setScaleAndCenterLocked(Float.NaN, centerX, centerY, animate, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScaleAndCenter(float scale, float centerX, float centerY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return false;
            }
            return this.setScaleAndCenterLocked(scale, centerX, centerY, animate, id2);
        }
    }

    private boolean setScaleAndCenterLocked(float scale, float centerX, float centerY, boolean animate, int id2) {
        boolean changed = this.updateMagnificationSpecLocked(scale, centerX, centerY);
        this.mSpecAnimationBridge.updateSentSpec(this.mCurrentMagnificationSpec, animate);
        if (this.isMagnifying() && id2 != -1) {
            this.mIdOfLastServiceToMagnify = id2;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offsetMagnifiedRegionCenter(float offsetX, float offsetY, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRegistered) {
                return;
            }
            MagnificationSpec currSpec = this.mCurrentMagnificationSpec;
            float nonNormOffsetX = currSpec.offsetX - offsetX;
            currSpec.offsetX = MathUtils.constrain(nonNormOffsetX, this.getMinOffsetXLocked(), 0.0f);
            float nonNormOffsetY = currSpec.offsetY - offsetY;
            currSpec.offsetY = MathUtils.constrain(nonNormOffsetY, this.getMinOffsetYLocked(), 0.0f);
            if (id2 != -1) {
                this.mIdOfLastServiceToMagnify = id2;
            }
            this.mSpecAnimationBridge.updateSentSpec(currSpec, false);
        }
    }

    public int getIdOfLastServiceToMagnify() {
        return this.mIdOfLastServiceToMagnify;
    }

    private void onMagnificationChangedLocked() {
        this.mAms.onMagnificationStateChanged();
        this.mAms.notifyMagnificationChanged(this.mMagnificationRegion, this.getScale(), this.getCenterX(), this.getCenterY());
        if (this.mUnregisterPending && !this.isMagnifying()) {
            this.unregisterInternalLocked();
        }
    }

    public void persistScale() {
        final float scale = this.mCurrentMagnificationSpec.scale;
        final int userId = this.mUserId;
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                Settings.Secure.putFloatForUser(MagnificationController.this.mContentResolver, "accessibility_display_magnification_scale", scale, userId);
                return null;
            }
        }.execute(new Void[0]);
    }

    public float getPersistedScale() {
        return Settings.Secure.getFloatForUser(this.mContentResolver, "accessibility_display_magnification_scale", 2.0f, this.mUserId);
    }

    private boolean updateMagnificationSpecLocked(float scale, float centerX, float centerY) {
        float nonNormOffsetY;
        float offsetY;
        float nonNormOffsetX;
        float offsetX;
        if (Float.isNaN(centerX)) {
            centerX = this.getCenterX();
        }
        if (Float.isNaN(centerY)) {
            centerY = this.getCenterY();
        }
        if (Float.isNaN(scale)) {
            scale = this.getScale();
        }
        if (!this.magnificationRegionContains(centerX, centerY)) {
            return false;
        }
        MagnificationSpec currSpec = this.mCurrentMagnificationSpec;
        boolean changed = false;
        float normScale = MathUtils.constrain(scale, 1.0f, 5.0f);
        if (Float.compare(currSpec.scale, normScale) != 0) {
            currSpec.scale = normScale;
            changed = true;
        }
        if (Float.compare(currSpec.offsetX, offsetX = MathUtils.constrain(nonNormOffsetX = (float)this.mMagnificationBounds.width() / 2.0f + (float)this.mMagnificationBounds.left - centerX * scale, this.getMinOffsetXLocked(), 0.0f)) != 0) {
            currSpec.offsetX = offsetX;
            changed = true;
        }
        if (Float.compare(currSpec.offsetY, offsetY = MathUtils.constrain(nonNormOffsetY = (float)this.mMagnificationBounds.height() / 2.0f + (float)this.mMagnificationBounds.top - centerY * scale, this.getMinOffsetYLocked(), 0.0f)) != 0) {
            currSpec.offsetY = offsetY;
            changed = true;
        }
        if (changed) {
            this.onMagnificationChangedLocked();
        }
        return changed;
    }

    private float getMinOffsetXLocked() {
        float viewportWidth = this.mMagnificationBounds.width();
        return viewportWidth - viewportWidth * this.mCurrentMagnificationSpec.scale;
    }

    private float getMinOffsetYLocked() {
        float viewportHeight = this.mMagnificationBounds.height();
        return viewportHeight - viewportHeight * this.mCurrentMagnificationSpec.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserId(int userId) {
        if (this.mUserId != userId) {
            this.mUserId = userId;
            Object object = this.mLock;
            synchronized (object) {
                if (this.isMagnifying()) {
                    this.reset(false);
                }
            }
        }
    }

    private boolean isScreenMagnificationAutoUpdateEnabled() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_display_magnification_auto_update", 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resetIfNeeded(boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isMagnifying() && this.isScreenMagnificationAutoUpdateEnabled()) {
                this.reset(animate);
                return true;
            }
            return false;
        }
    }

    private void getMagnifiedFrameInContentCoordsLocked(Rect outFrame) {
        float scale = this.getSentScale();
        float offsetX = this.getSentOffsetX();
        float offsetY = this.getSentOffsetY();
        this.getMagnificationBounds(outFrame);
        outFrame.offset((int)(-offsetX), (int)(-offsetY));
        outFrame.scale(1.0f / scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestRectangleOnScreen(int left, int top, int right, int bottom) {
        Object object = this.mLock;
        synchronized (object) {
            int direction;
            Rect magnifiedFrame = this.mTempRect;
            this.getMagnificationBounds(magnifiedFrame);
            if (!magnifiedFrame.intersects(left, top, right, bottom)) {
                return;
            }
            Rect magnifFrameInScreenCoords = this.mTempRect1;
            this.getMagnifiedFrameInContentCoordsLocked(magnifFrameInScreenCoords);
            float scrollX = right - left > magnifFrameInScreenCoords.width() ? ((direction = TextUtils.getLayoutDirectionFromLocale(Locale.getDefault())) == 0 ? (float)(left - magnifFrameInScreenCoords.left) : (float)(right - magnifFrameInScreenCoords.right)) : (left < magnifFrameInScreenCoords.left ? (float)(left - magnifFrameInScreenCoords.left) : (right > magnifFrameInScreenCoords.right ? (float)(right - magnifFrameInScreenCoords.right) : 0.0f));
            float scrollY = bottom - top > magnifFrameInScreenCoords.height() ? (float)(top - magnifFrameInScreenCoords.top) : (top < magnifFrameInScreenCoords.top ? (float)(top - magnifFrameInScreenCoords.top) : (bottom > magnifFrameInScreenCoords.bottom ? (float)(bottom - magnifFrameInScreenCoords.bottom) : 0.0f));
            float scale = this.getScale();
            this.offsetMagnifiedRegionCenter(scrollX * scale, scrollY * scale, -1);
        }
    }

    private static class WindowStateObserver
    implements WindowManagerInternal.MagnificationCallbacks {
        private static final int MESSAGE_ON_MAGNIFIED_BOUNDS_CHANGED = 1;
        private static final int MESSAGE_ON_RECTANGLE_ON_SCREEN_REQUESTED = 2;
        private static final int MESSAGE_ON_USER_CONTEXT_CHANGED = 3;
        private static final int MESSAGE_ON_ROTATION_CHANGED = 4;
        private final MagnificationController mController;
        private final WindowManagerInternal mWindowManager;
        private final Handler mHandler;
        private boolean mSpecIsDirty;

        public WindowStateObserver(Context context, MagnificationController controller) {
            this.mController = controller;
            this.mWindowManager = LocalServices.getService(WindowManagerInternal.class);
            this.mHandler = new CallbackHandler(context);
        }

        public void register() {
            this.mWindowManager.setMagnificationCallbacks(this);
        }

        public void unregister() {
            this.mWindowManager.setMagnificationCallbacks(null);
        }

        @Override
        public void onMagnificationRegionChanged(Region magnificationRegion) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = Region.obtain(magnificationRegion);
            this.mHandler.obtainMessage(1, args).sendToTarget();
        }

        private void handleOnMagnifiedBoundsChanged(Region magnificationRegion) {
            this.mController.onMagnificationRegionChanged(magnificationRegion, this.mSpecIsDirty);
            this.mSpecIsDirty = false;
        }

        @Override
        public void onRectangleOnScreenRequested(int left, int top, int right, int bottom) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = left;
            args.argi2 = top;
            args.argi3 = right;
            args.argi4 = bottom;
            this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        private void handleOnRectangleOnScreenRequested(int left, int top, int right, int bottom) {
            this.mController.requestRectangleOnScreen(left, top, right, bottom);
        }

        @Override
        public void onRotationChanged(int rotation) {
            this.mHandler.obtainMessage(4, rotation, 0).sendToTarget();
        }

        private void handleOnRotationChanged() {
            this.mSpecIsDirty = !this.mController.resetIfNeeded(true);
        }

        @Override
        public void onUserContextChanged() {
            this.mHandler.sendEmptyMessage(3);
        }

        private void handleOnUserContextChanged() {
            this.mController.resetIfNeeded(true);
        }

        public void getMagnificationRegion(Region outMagnificationRegion) {
            this.mWindowManager.getMagnificationRegion(outMagnificationRegion);
        }

        private class CallbackHandler
        extends Handler {
            public CallbackHandler(Context context) {
                super(context.getMainLooper());
            }

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        SomeArgs args = (SomeArgs)message.obj;
                        Region magnifiedBounds = (Region)args.arg1;
                        WindowStateObserver.this.handleOnMagnifiedBoundsChanged(magnifiedBounds);
                        magnifiedBounds.recycle();
                        break;
                    }
                    case 2: {
                        SomeArgs args = (SomeArgs)message.obj;
                        int left = args.argi1;
                        int top = args.argi2;
                        int right = args.argi3;
                        int bottom = args.argi4;
                        WindowStateObserver.this.handleOnRectangleOnScreenRequested(left, top, right, bottom);
                        args.recycle();
                        break;
                    }
                    case 3: {
                        WindowStateObserver.this.handleOnUserContextChanged();
                        break;
                    }
                    case 4: {
                        WindowStateObserver.this.handleOnRotationChanged();
                    }
                }
            }
        }
    }

    private static class ScreenStateObserver
    extends BroadcastReceiver {
        private static final int MESSAGE_ON_SCREEN_STATE_CHANGE = 1;
        private final Context mContext;
        private final MagnificationController mController;
        private final Handler mHandler;

        public ScreenStateObserver(Context context, MagnificationController controller) {
            this.mContext = context;
            this.mController = controller;
            this.mHandler = new StateChangeHandler(context);
        }

        public void register() {
            this.mContext.registerReceiver(this, new IntentFilter("android.intent.action.SCREEN_OFF"));
        }

        public void unregister() {
            this.mContext.unregisterReceiver(this);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.mHandler.obtainMessage(1, intent.getAction()).sendToTarget();
        }

        private void handleOnScreenStateChange() {
            this.mController.resetIfNeeded(false);
        }

        private class StateChangeHandler
        extends Handler {
            public StateChangeHandler(Context context) {
                super(context.getMainLooper());
            }

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        ScreenStateObserver.this.handleOnScreenStateChange();
                    }
                }
            }
        }
    }

    private static class SpecAnimationBridge {
        private static final int ACTION_UPDATE_SPEC = 1;
        private final Handler mHandler;
        private final WindowManagerInternal mWindowManager;
        private final MagnificationSpec mSentMagnificationSpec = MagnificationSpec.obtain();
        private final ValueAnimator mTransformationAnimator;
        private final long mMainThreadId;
        private final Object mLock;
        @GuardedBy(value="mLock")
        private boolean mEnabled = false;

        private SpecAnimationBridge(Context context, Object lock) {
            this.mLock = lock;
            Looper mainLooper = context.getMainLooper();
            this.mMainThreadId = mainLooper.getThread().getId();
            this.mHandler = new UpdateHandler(context);
            this.mWindowManager = LocalServices.getService(WindowManagerInternal.class);
            MagnificationSpecProperty property = new MagnificationSpecProperty();
            MagnificationSpecEvaluator evaluator = new MagnificationSpecEvaluator();
            long animationDuration = context.getResources().getInteger(17694722);
            this.mTransformationAnimator = ObjectAnimator.ofObject(this, property, evaluator, this.mSentMagnificationSpec);
            this.mTransformationAnimator.setDuration(animationDuration);
            this.mTransformationAnimator.setInterpolator(new DecelerateInterpolator(2.5f));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            Object object = this.mLock;
            synchronized (object) {
                if (enabled != this.mEnabled) {
                    this.mEnabled = enabled;
                    if (!this.mEnabled) {
                        this.mSentMagnificationSpec.clear();
                        this.mWindowManager.setMagnificationSpec(this.mSentMagnificationSpec);
                    }
                }
            }
        }

        public void updateSentSpec(MagnificationSpec spec, boolean animate) {
            if (Thread.currentThread().getId() == this.mMainThreadId) {
                this.updateSentSpecInternal(spec, animate);
            } else {
                this.mHandler.obtainMessage(1, animate ? 1 : 0, 0, spec).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSentSpecInternal(MagnificationSpec spec, boolean animate) {
            if (this.mTransformationAnimator.isRunning()) {
                this.mTransformationAnimator.cancel();
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean changed;
                boolean bl = changed = !this.mSentMagnificationSpec.equals(spec);
                if (changed) {
                    if (animate) {
                        this.animateMagnificationSpecLocked(spec);
                    } else {
                        this.setMagnificationSpecLocked(spec);
                    }
                }
            }
        }

        private void animateMagnificationSpecLocked(MagnificationSpec toSpec) {
            this.mTransformationAnimator.setObjectValues(this.mSentMagnificationSpec, toSpec);
            this.mTransformationAnimator.start();
        }

        private void setMagnificationSpecLocked(MagnificationSpec spec) {
            if (this.mEnabled) {
                this.mSentMagnificationSpec.setTo(spec);
                this.mWindowManager.setMagnificationSpec(spec);
            }
        }

        private static class MagnificationSpecEvaluator
        implements TypeEvaluator<MagnificationSpec> {
            private final MagnificationSpec mTempSpec = MagnificationSpec.obtain();

            private MagnificationSpecEvaluator() {
            }

            @Override
            public MagnificationSpec evaluate(float fraction2, MagnificationSpec fromSpec, MagnificationSpec toSpec) {
                MagnificationSpec result = this.mTempSpec;
                result.scale = fromSpec.scale + (toSpec.scale - fromSpec.scale) * fraction2;
                result.offsetX = fromSpec.offsetX + (toSpec.offsetX - fromSpec.offsetX) * fraction2;
                result.offsetY = fromSpec.offsetY + (toSpec.offsetY - fromSpec.offsetY) * fraction2;
                return result;
            }
        }

        private static class MagnificationSpecProperty
        extends Property<SpecAnimationBridge, MagnificationSpec> {
            public MagnificationSpecProperty() {
                super(MagnificationSpec.class, "spec");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MagnificationSpec get(SpecAnimationBridge object) {
                Object object2 = object.mLock;
                synchronized (object2) {
                    return object.mSentMagnificationSpec;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(SpecAnimationBridge object, MagnificationSpec value) {
                Object object2 = object.mLock;
                synchronized (object2) {
                    object.setMagnificationSpecLocked(value);
                }
            }
        }

        private class UpdateHandler
        extends Handler {
            public UpdateHandler(Context context) {
                super(context.getMainLooper());
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        boolean animate = msg.arg1 == 1;
                        MagnificationSpec spec = (MagnificationSpec)msg.obj;
                        SpecAnimationBridge.this.updateSentSpecInternal(spec, animate);
                    }
                }
            }
        }
    }
}

