/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.IUiModeManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.dreams.Sandman;
import android.util.Slog;
import com.android.internal.app.DisableCarModeActivity;
import com.android.server.SystemService;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.io.FileDescriptor;
import java.io.PrintWriter;

final class UiModeManagerService
extends SystemService {
    private static final String TAG = UiModeManager.class.getSimpleName();
    private static final boolean LOG = false;
    private static final boolean ENABLE_LAUNCH_DESK_DOCK_APP = true;
    final Object mLock = new Object();
    private int mDockState = 0;
    private int mLastBroadcastState = 0;
    private int mNightMode = 1;
    private boolean mCarModeEnabled = false;
    private boolean mCharging = false;
    private int mDefaultUiModeType;
    private boolean mCarModeKeepsScreenOn;
    private boolean mDeskModeKeepsScreenOn;
    private boolean mTelevision;
    private boolean mWatch;
    private boolean mComputedNightMode;
    private int mCarModeEnableFlags;
    private boolean mEnableCarDockLaunch = true;
    private boolean mUiModeLocked = false;
    private boolean mNightModeLocked = false;
    int mCurUiMode = 0;
    private int mSetUiMode = 0;
    private boolean mHoldingConfiguration = false;
    private Configuration mConfiguration = new Configuration();
    boolean mSystemReady;
    private final Handler mHandler = new Handler();
    private TwilightManager mTwilightManager;
    private NotificationManager mNotificationManager;
    private StatusBarManager mStatusBarManager;
    private PowerManager.WakeLock mWakeLock;
    private final BroadcastReceiver mResultReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (this.getResultCode() != -1) {
                return;
            }
            int enableFlags = intent.getIntExtra("enableFlags", 0);
            int disableFlags = intent.getIntExtra("disableFlags", 0);
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                UiModeManagerService.this.updateAfterBroadcastLocked(intent.getAction(), enableFlags, disableFlags);
            }
        }
    };
    private final BroadcastReceiver mDockModeReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            UiModeManagerService.this.updateDockState(state);
        }
    };
    private final BroadcastReceiver mBatteryReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            UiModeManagerService.this.mCharging = intent.getIntExtra("plugged", 0) != 0;
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                if (UiModeManagerService.this.mSystemReady) {
                    UiModeManagerService.this.updateLocked(0, 0);
                }
            }
        }
    };
    private final TwilightListener mTwilightListener = new TwilightListener(){

        @Override
        public void onTwilightStateChanged() {
            UiModeManagerService.this.updateTwilight();
        }
    };
    private final IBinder mService = new IUiModeManager.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enableCarMode(int flags) {
            if (this.isUiModeLocked()) {
                Slog.e(TAG, "enableCarMode while UI mode is locked");
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = UiModeManagerService.this.mLock;
                synchronized (object) {
                    UiModeManagerService.this.setCarModeLocked(true, flags);
                    if (UiModeManagerService.this.mSystemReady) {
                        UiModeManagerService.this.updateLocked(flags, 0);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disableCarMode(int flags) {
            if (this.isUiModeLocked()) {
                Slog.e(TAG, "disableCarMode while UI mode is locked");
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = UiModeManagerService.this.mLock;
                synchronized (object) {
                    UiModeManagerService.this.setCarModeLocked(false, 0);
                    if (UiModeManagerService.this.mSystemReady) {
                        UiModeManagerService.this.updateLocked(0, flags);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCurrentModeType() {
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = UiModeManagerService.this.mLock;
                synchronized (object) {
                    int n = UiModeManagerService.this.mCurUiMode & 0xF;
                    return n;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNightMode(int mode) {
            if (this.isNightModeLocked() && UiModeManagerService.this.getContext().checkCallingOrSelfPermission("android.permission.MODIFY_DAY_NIGHT_MODE") != 0) {
                Slog.e(TAG, "Night mode locked, requires MODIFY_DAY_NIGHT_MODE permission");
                return;
            }
            switch (mode) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode: " + mode);
                }
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = UiModeManagerService.this.mLock;
                synchronized (object) {
                    if (UiModeManagerService.this.mNightMode != mode) {
                        Settings.Secure.putInt(UiModeManagerService.this.getContext().getContentResolver(), "ui_night_mode", mode);
                        UiModeManagerService.this.mNightMode = mode;
                        UiModeManagerService.this.updateLocked(0, 0);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNightMode() {
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                return UiModeManagerService.this.mNightMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUiModeLocked() {
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                return UiModeManagerService.this.mUiModeLocked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isNightModeLocked() {
            Object object = UiModeManagerService.this.mLock;
            synchronized (object) {
                return UiModeManagerService.this.mNightModeLocked;
            }
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (UiModeManagerService.this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump uimode service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            UiModeManagerService.this.dumpImpl(pw);
        }
    };

    public UiModeManagerService(Context context) {
        super(context);
    }

    private static Intent buildHomeIntent(String category) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory(category);
        intent.setFlags(0x10200000);
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        Context context = this.getContext();
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(26, TAG);
        context.registerReceiver(this.mDockModeReceiver, new IntentFilter("android.intent.action.DOCK_EVENT"));
        context.registerReceiver(this.mBatteryReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        this.mConfiguration.setToDefaults();
        Resources res = context.getResources();
        this.mDefaultUiModeType = res.getInteger(17694790);
        this.mCarModeKeepsScreenOn = res.getInteger(17694788) == 1;
        this.mDeskModeKeepsScreenOn = res.getInteger(17694786) == 1;
        this.mEnableCarDockLaunch = res.getBoolean(17956923);
        this.mUiModeLocked = res.getBoolean(17956924);
        this.mNightModeLocked = res.getBoolean(17956925);
        PackageManager pm = context.getPackageManager();
        this.mTelevision = pm.hasSystemFeature("android.hardware.type.television") || pm.hasSystemFeature("android.software.leanback");
        this.mWatch = pm.hasSystemFeature("android.hardware.type.watch");
        int defaultNightMode = res.getInteger(17694791);
        this.mNightMode = Settings.Secure.getInt(context.getContentResolver(), "ui_night_mode", defaultNightMode);
        UiModeManagerService uiModeManagerService = this;
        synchronized (uiModeManagerService) {
            this.updateConfigurationLocked();
            this.sendConfigurationLocked();
        }
        this.publishBinderService("uimode", this.mService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpImpl(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current UI Mode Service state:");
            pw.print("  mDockState=");
            pw.print(this.mDockState);
            pw.print(" mLastBroadcastState=");
            pw.println(this.mLastBroadcastState);
            pw.print("  mNightMode=");
            pw.print(this.mNightMode);
            pw.print(" mNightModeLocked=");
            pw.print(this.mNightModeLocked);
            pw.print(" mCarModeEnabled=");
            pw.print(this.mCarModeEnabled);
            pw.print(" mComputedNightMode=");
            pw.print(this.mComputedNightMode);
            pw.print(" mCarModeEnableFlags=");
            pw.print(this.mCarModeEnableFlags);
            pw.print(" mEnableCarDockLaunch=");
            pw.println(this.mEnableCarDockLaunch);
            pw.print("  mCurUiMode=0x");
            pw.print(Integer.toHexString(this.mCurUiMode));
            pw.print(" mUiModeLocked=");
            pw.print(this.mUiModeLocked);
            pw.print(" mSetUiMode=0x");
            pw.println(Integer.toHexString(this.mSetUiMode));
            pw.print("  mHoldingConfiguration=");
            pw.print(this.mHoldingConfiguration);
            pw.print(" mSystemReady=");
            pw.println(this.mSystemReady);
            if (this.mTwilightManager != null) {
                pw.print("  mTwilightService.getCurrentState()=");
                pw.println(this.mTwilightManager.getCurrentState());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            Object object = this.mLock;
            synchronized (object) {
                this.mTwilightManager = this.getLocalService(TwilightManager.class);
                if (this.mTwilightManager != null) {
                    this.mTwilightManager.registerListener(this.mTwilightListener, this.mHandler);
                }
                this.mSystemReady = true;
                this.mCarModeEnabled = this.mDockState == 2;
                this.updateComputedNightModeLocked();
                this.updateLocked(0, 0);
            }
        }
    }

    void setCarModeLocked(boolean enabled, int flags) {
        if (this.mCarModeEnabled != enabled) {
            this.mCarModeEnabled = enabled;
        }
        this.mCarModeEnableFlags = flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDockState(int newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (newState != this.mDockState) {
                this.mDockState = newState;
                this.setCarModeLocked(this.mDockState == 2, 0);
                if (this.mSystemReady) {
                    this.updateLocked(1, 0);
                }
            }
        }
    }

    private static boolean isDeskDockState(int state) {
        switch (state) {
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void updateConfigurationLocked() {
        int uiMode = this.mDefaultUiModeType;
        if (!this.mUiModeLocked) {
            if (this.mTelevision) {
                uiMode = 4;
            } else if (this.mWatch) {
                uiMode = 6;
            } else if (this.mCarModeEnabled) {
                uiMode = 3;
            } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
                uiMode = 2;
            }
        }
        if (this.mNightMode == 0) {
            this.updateComputedNightModeLocked();
            uiMode |= this.mComputedNightMode ? 32 : 16;
        } else {
            uiMode |= this.mNightMode << 4;
        }
        this.mCurUiMode = uiMode;
        if (!this.mHoldingConfiguration) {
            this.mConfiguration.uiMode = uiMode;
        }
    }

    private void sendConfigurationLocked() {
        if (this.mSetUiMode != this.mConfiguration.uiMode) {
            this.mSetUiMode = this.mConfiguration.uiMode;
            try {
                ActivityManagerNative.getDefault().updateConfiguration(this.mConfiguration);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failure communicating with activity manager", e);
            }
        }
    }

    void updateLocked(int enableFlags, int disableFlags) {
        boolean keepScreenOn;
        String action = null;
        String oldAction = null;
        if (this.mLastBroadcastState == 2) {
            this.adjustStatusBarCarModeLocked();
            oldAction = UiModeManager.ACTION_EXIT_CAR_MODE;
        } else if (UiModeManagerService.isDeskDockState(this.mLastBroadcastState)) {
            oldAction = UiModeManager.ACTION_EXIT_DESK_MODE;
        }
        if (this.mCarModeEnabled) {
            if (this.mLastBroadcastState != 2) {
                this.adjustStatusBarCarModeLocked();
                if (oldAction != null) {
                    this.getContext().sendBroadcastAsUser(new Intent(oldAction), UserHandle.ALL);
                }
                this.mLastBroadcastState = 2;
                action = UiModeManager.ACTION_ENTER_CAR_MODE;
            }
        } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
            if (!UiModeManagerService.isDeskDockState(this.mLastBroadcastState)) {
                if (oldAction != null) {
                    this.getContext().sendBroadcastAsUser(new Intent(oldAction), UserHandle.ALL);
                }
                this.mLastBroadcastState = this.mDockState;
                action = UiModeManager.ACTION_ENTER_DESK_MODE;
            }
        } else {
            this.mLastBroadcastState = 0;
            action = oldAction;
        }
        if (action != null) {
            Intent intent = new Intent(action);
            intent.putExtra("enableFlags", enableFlags);
            intent.putExtra("disableFlags", disableFlags);
            this.getContext().sendOrderedBroadcastAsUser(intent, UserHandle.CURRENT, null, this.mResultReceiver, null, -1, null, null);
            this.mHoldingConfiguration = true;
            this.updateConfigurationLocked();
        } else {
            String category = null;
            if (this.mCarModeEnabled) {
                if (this.mEnableCarDockLaunch && (enableFlags & 1) != 0) {
                    category = "android.intent.category.CAR_DOCK";
                }
            } else if (UiModeManagerService.isDeskDockState(this.mDockState)) {
                if ((enableFlags & 1) != 0) {
                    category = "android.intent.category.DESK_DOCK";
                }
            } else if ((disableFlags & 1) != 0) {
                category = "android.intent.category.HOME";
            }
            this.sendConfigurationAndStartDreamOrDockAppLocked(category);
        }
        boolean bl = keepScreenOn = this.mCharging && (this.mCarModeEnabled && this.mCarModeKeepsScreenOn && (this.mCarModeEnableFlags & 2) == 0 || this.mCurUiMode == 2 && this.mDeskModeKeepsScreenOn);
        if (keepScreenOn != this.mWakeLock.isHeld()) {
            if (keepScreenOn) {
                this.mWakeLock.acquire();
            } else {
                this.mWakeLock.release();
            }
        }
    }

    private void updateAfterBroadcastLocked(String action, int enableFlags, int disableFlags) {
        String category = null;
        if (UiModeManager.ACTION_ENTER_CAR_MODE.equals(action)) {
            if (this.mEnableCarDockLaunch && (enableFlags & 1) != 0) {
                category = "android.intent.category.CAR_DOCK";
            }
        } else if (UiModeManager.ACTION_ENTER_DESK_MODE.equals(action)) {
            if ((enableFlags & 1) != 0) {
                category = "android.intent.category.DESK_DOCK";
            }
        } else if ((disableFlags & 1) != 0) {
            category = "android.intent.category.HOME";
        }
        this.sendConfigurationAndStartDreamOrDockAppLocked(category);
    }

    private void sendConfigurationAndStartDreamOrDockAppLocked(String category) {
        this.mHoldingConfiguration = false;
        this.updateConfigurationLocked();
        boolean dockAppStarted = false;
        if (category != null) {
            Intent homeIntent = UiModeManagerService.buildHomeIntent(category);
            if (Sandman.shouldStartDockApp(this.getContext(), homeIntent)) {
                try {
                    int result = ActivityManagerNative.getDefault().startActivityWithConfig(null, null, homeIntent, null, null, null, 0, 0, this.mConfiguration, null, -2);
                    if (result >= 0) {
                        dockAppStarted = true;
                    } else if (result != -1) {
                        Slog.e(TAG, "Could not start dock app: " + homeIntent + ", startActivityWithConfig result " + result);
                    }
                }
                catch (RemoteException ex) {
                    Slog.e(TAG, "Could not start dock app: " + homeIntent, ex);
                }
            }
        }
        this.sendConfigurationLocked();
        if (category != null && !dockAppStarted) {
            Sandman.startDreamWhenDockedIfAppropriate(this.getContext());
        }
    }

    private void adjustStatusBarCarModeLocked() {
        Context context = this.getContext();
        if (this.mStatusBarManager == null) {
            this.mStatusBarManager = (StatusBarManager)context.getSystemService("statusbar");
        }
        if (this.mStatusBarManager != null) {
            this.mStatusBarManager.disable(this.mCarModeEnabled ? 524288 : 0);
        }
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
        }
        if (this.mNotificationManager != null) {
            if (this.mCarModeEnabled) {
                Intent carModeOffIntent = new Intent(context, DisableCarModeActivity.class);
                Notification.Builder n = new Notification.Builder(context).setSmallIcon(17303220).setDefaults(4).setOngoing(true).setWhen(0L).setColor(context.getColor(17170521)).setContentTitle(context.getString(17040504)).setContentText(context.getString(17040505)).setContentIntent(PendingIntent.getActivityAsUser(context, 0, carModeOffIntent, 0, null, UserHandle.CURRENT));
                this.mNotificationManager.notifyAsUser(null, 17040504, n.build(), UserHandle.ALL);
            } else {
                this.mNotificationManager.cancelAsUser(null, 17040504, UserHandle.ALL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTwilight() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNightMode == 0) {
                this.updateComputedNightModeLocked();
                this.updateLocked(0, 0);
            }
        }
    }

    private void updateComputedNightModeLocked() {
        TwilightState state;
        if (this.mTwilightManager != null && (state = this.mTwilightManager.getCurrentState()) != null) {
            this.mComputedNightMode = state.isNight();
        }
    }
}

