/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.INotificationManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.BaseBundle;
import android.os.Build;
import android.os.Environment;
import android.os.FactoryTest;
import android.os.FileUtils;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.storage.IMountService;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Slog;
import android.view.WindowManager;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.internal.widget.ILockSettings;
import com.android.server.AlarmManagerService;
import com.android.server.AssetAtlasService;
import com.android.server.AttributeCache;
import com.android.server.BatteryService;
import com.android.server.BluetoothService;
import com.android.server.CertBlacklister;
import com.android.server.CommonTimeManagementService;
import com.android.server.ConnectivityService;
import com.android.server.ConsumerIrService;
import com.android.server.ContextHubSystemService;
import com.android.server.CountryDetectorService;
import com.android.server.DeviceIdleController;
import com.android.server.DiskStatsService;
import com.android.server.DockObserver;
import com.android.server.DropBoxManagerService;
import com.android.server.EntropyMixer;
import com.android.server.GestureLauncherService;
import com.android.server.GraphicsStatsService;
import com.android.server.HardwarePropertiesManagerService;
import com.android.server.InputMethodManagerService;
import com.android.server.LocalServices;
import com.android.server.LocationManagerService;
import com.android.server.MmsServiceBroker;
import com.android.server.NetworkManagementService;
import com.android.server.NetworkScoreService;
import com.android.server.NetworkTimeUpdateService;
import com.android.server.NsdService;
import com.android.server.PersistentDataBlockService;
import com.android.server.PinnerService;
import com.android.server.RecoverySystemService;
import com.android.server.SamplingProfilerService;
import com.android.server.SensorNotificationService;
import com.android.server.SerialService;
import com.android.server.SystemConfig;
import com.android.server.SystemServiceManager;
import com.android.server.TelephonyRegistry;
import com.android.server.TextServicesManagerService;
import com.android.server.UiModeManagerService;
import com.android.server.UpdateLockService;
import com.android.server.VibratorService;
import com.android.server.Watchdog;
import com.android.server.WiredAccessoryManager;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.am.ActivityManagerService;
import com.android.server.audio.AudioService;
import com.android.server.camera.CameraService;
import com.android.server.clipboard.ClipboardService;
import com.android.server.connectivity.MetricsLoggerService;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import com.android.server.display.DisplayManagerService;
import com.android.server.dreams.DreamManagerService;
import com.android.server.fingerprint.FingerprintService;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.input.InputManagerService;
import com.android.server.job.JobSchedulerService;
import com.android.server.lights.LightsService;
import com.android.server.media.MediaResourceMonitorService;
import com.android.server.media.MediaRouterService;
import com.android.server.media.MediaSessionService;
import com.android.server.media.projection.MediaProjectionManagerService;
import com.android.server.net.NetworkPolicyManagerService;
import com.android.server.net.NetworkStatsService;
import com.android.server.notification.NotificationManagerService;
import com.android.server.os.SchedulingPolicyService;
import com.android.server.pm.BackgroundDexOptService;
import com.android.server.pm.Installer;
import com.android.server.pm.LauncherAppsService;
import com.android.server.pm.OtaDexoptService;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.ShortcutService;
import com.android.server.pm.UserManagerService;
import com.android.server.power.PowerManagerService;
import com.android.server.power.ShutdownThread;
import com.android.server.restrictions.RestrictionsManagerService;
import com.android.server.soundtrigger.SoundTriggerService;
import com.android.server.statusbar.StatusBarManagerService;
import com.android.server.storage.DeviceStorageMonitorService;
import com.android.server.telecom.TelecomLoaderService;
import com.android.server.trust.TrustManagerService;
import com.android.server.tv.TvInputManagerService;
import com.android.server.tv.TvRemoteService;
import com.android.server.twilight.TwilightService;
import com.android.server.usage.UsageStatsService;
import com.android.server.vr.VrManagerService;
import com.android.server.webkit.WebViewUpdateService;
import com.android.server.wm.WindowManagerService;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

public final class SystemServer {
    private static final String TAG = "SystemServer";
    private static final String ENCRYPTING_STATE = "trigger_restart_min_framework";
    private static final String ENCRYPTED_STATE = "1";
    private static final long SNAPSHOT_INTERVAL = 3600000L;
    private static final long EARLIEST_SUPPORTED_TIME = 86400000L;
    private static final String BACKUP_MANAGER_SERVICE_CLASS = "com.android.server.backup.BackupManagerService$Lifecycle";
    private static final String APPWIDGET_SERVICE_CLASS = "com.android.server.appwidget.AppWidgetService";
    private static final String VOICE_RECOGNITION_MANAGER_SERVICE_CLASS = "com.android.server.voiceinteraction.VoiceInteractionManagerService";
    private static final String PRINT_MANAGER_SERVICE_CLASS = "com.android.server.print.PrintManagerService";
    private static final String USB_SERVICE_CLASS = "com.android.server.usb.UsbService$Lifecycle";
    private static final String MIDI_SERVICE_CLASS = "com.android.server.midi.MidiService$Lifecycle";
    private static final String WIFI_SERVICE_CLASS = "com.android.server.wifi.WifiService";
    private static final String WIFI_NAN_SERVICE_CLASS = "com.android.server.wifi.nan.WifiNanService";
    private static final String WIFI_P2P_SERVICE_CLASS = "com.android.server.wifi.p2p.WifiP2pService";
    private static final String ETHERNET_SERVICE_CLASS = "com.android.server.ethernet.EthernetService";
    private static final String JOB_SCHEDULER_SERVICE_CLASS = "com.android.server.job.JobSchedulerService";
    private static final String LOCK_SETTINGS_SERVICE_CLASS = "com.android.server.LockSettingsService$Lifecycle";
    private static final String MOUNT_SERVICE_CLASS = "com.android.server.MountService$Lifecycle";
    private static final String SEARCH_MANAGER_SERVICE_CLASS = "com.android.server.search.SearchManagerService$Lifecycle";
    private static final String THERMAL_OBSERVER_CLASS = "com.google.android.clockwork.ThermalObserver";
    private static final String WEAR_BLUETOOTH_SERVICE_CLASS = "com.google.android.clockwork.bluetooth.WearBluetoothService";
    private static final String ACCOUNT_SERVICE_CLASS = "com.android.server.accounts.AccountManagerService$Lifecycle";
    private static final String CONTENT_SERVICE_CLASS = "com.android.server.content.ContentService$Lifecycle";
    private static final String WALLPAPER_SERVICE_CLASS = "com.android.server.wallpaper.WallpaperManagerService$Lifecycle";
    private static final String PERSISTENT_DATA_BLOCK_PROP = "ro.frp.pst";
    private static final String UNCRYPT_PACKAGE_FILE = "/cache/recovery/uncrypt_file";
    private static final String BLOCK_MAP_FILE = "/cache/recovery/block.map";
    private static final int sMaxBinderThreads = 31;
    private static final int DEFAULT_SYSTEM_THEME = 16974143;
    private final int mFactoryTestMode = FactoryTest.getMode();
    private Timer mProfilerSnapshotTimer;
    private Context mSystemContext;
    private SystemServiceManager mSystemServiceManager;
    private PowerManagerService mPowerManagerService;
    private ActivityManagerService mActivityManagerService;
    private WebViewUpdateService mWebViewUpdateService;
    private DisplayManagerService mDisplayManagerService;
    private PackageManagerService mPackageManagerService;
    private PackageManager mPackageManager;
    private ContentResolver mContentResolver;
    private EntropyMixer mEntropyMixer;
    private boolean mOnlyCore;
    private boolean mFirstBoot;

    private static native void startSensorService();

    public static void main(String[] args) {
        new SystemServer().run();
    }

    private void run() {
        try {
            Trace.traceBegin(524288L, "InitBeforeStartServices");
            if (System.currentTimeMillis() < 86400000L) {
                Slog.w(TAG, "System clock is before 1970; setting to 1970.");
                SystemClock.setCurrentTimeMillis(86400000L);
            }
            if (!SystemProperties.get("persist.sys.language").isEmpty()) {
                String languageTag = Locale.getDefault().toLanguageTag();
                SystemProperties.set("persist.sys.locale", languageTag);
                SystemProperties.set("persist.sys.language", "");
                SystemProperties.set("persist.sys.country", "");
                SystemProperties.set("persist.sys.localevar", "");
            }
            Slog.i(TAG, "Entered the Android system server!");
            EventLog.writeEvent(3010, SystemClock.uptimeMillis());
            SystemProperties.set("persist.sys.dalvik.vm.lib.2", VMRuntime.getRuntime().vmLibrary());
            if (SamplingProfilerIntegration.isEnabled()) {
                SamplingProfilerIntegration.start();
                this.mProfilerSnapshotTimer = new Timer();
                this.mProfilerSnapshotTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SamplingProfilerIntegration.writeSnapshot("system_server", null);
                    }
                }, 3600000L, 3600000L);
            }
            VMRuntime.getRuntime().clearGrowthLimit();
            VMRuntime.getRuntime().setTargetHeapUtilization(0.8f);
            Build.ensureFingerprintProperty();
            Environment.setUserRequired(true);
            BaseBundle.setShouldDefuse(true);
            BinderInternal.disableBackgroundScheduling(true);
            BinderInternal.setMaxThreads(31);
            Process.setThreadPriority(-2);
            Process.setCanSelfBackground(false);
            Looper.prepareMainLooper();
            System.loadLibrary("android_servers");
            this.performPendingShutdown();
            this.createSystemContext();
            this.mSystemServiceManager = new SystemServiceManager(this.mSystemContext);
            LocalServices.addService(SystemServiceManager.class, this.mSystemServiceManager);
        }
        finally {
            Trace.traceEnd(524288L);
        }
        try {
            Trace.traceBegin(524288L, "StartServices");
            this.startBootstrapServices();
            this.startCoreServices();
            this.startOtherServices();
        }
        catch (Throwable ex) {
            Slog.e("System", "******************************************");
            Slog.e("System", "************ Failure starting system services", ex);
            throw ex;
        }
        finally {
            Trace.traceEnd(524288L);
        }
        if (StrictMode.conditionallyEnableDebugLogging()) {
            Slog.i(TAG, "Enabled StrictMode for system server main thread.");
        }
        Looper.loop();
        throw new RuntimeException("Main thread loop unexpectedly exited");
    }

    private void reportWtf(String msg, Throwable e) {
        Slog.w(TAG, "***********************************************");
        Slog.wtf(TAG, "BOOT FAILURE " + msg, e);
    }

    private void performPendingShutdown() {
        String shutdownAction = SystemProperties.get("sys.shutdown.requested", "");
        if (shutdownAction != null && shutdownAction.length() > 0) {
            File packageFile;
            boolean reboot = shutdownAction.charAt(0) == '1';
            String reason = shutdownAction.length() > 1 ? shutdownAction.substring(1, shutdownAction.length()) : null;
            if ("recovery-update".equals(reason) && (packageFile = new File(UNCRYPT_PACKAGE_FILE)).exists()) {
                String filename = null;
                try {
                    filename = FileUtils.readTextFile(packageFile, 0, null);
                }
                catch (IOException e) {
                    Slog.e(TAG, "Error reading uncrypt package file", e);
                }
                if (filename != null && filename.startsWith("/data") && !new File(BLOCK_MAP_FILE).exists()) {
                    Slog.e(TAG, "Can't find block map file, uncrypt failed or unexpected runtime restart?");
                    return;
                }
            }
            ShutdownThread.rebootOrShutdown(null, reboot, reason);
        }
    }

    private void createSystemContext() {
        ActivityThread activityThread = ActivityThread.systemMain();
        this.mSystemContext = activityThread.getSystemContext();
        this.mSystemContext.setTheme(16974143);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBootstrapServices() {
        boolean disableOtaDexopt;
        Installer installer = this.mSystemServiceManager.startService(Installer.class);
        this.mActivityManagerService = this.mSystemServiceManager.startService(ActivityManagerService.Lifecycle.class).getService();
        this.mActivityManagerService.setSystemServiceManager(this.mSystemServiceManager);
        this.mActivityManagerService.setInstaller(installer);
        this.mPowerManagerService = this.mSystemServiceManager.startService(PowerManagerService.class);
        Trace.traceBegin(524288L, "InitPowerManagement");
        this.mActivityManagerService.initPowerManagement();
        Trace.traceEnd(524288L);
        this.mSystemServiceManager.startService(LightsService.class);
        this.mDisplayManagerService = this.mSystemServiceManager.startService(DisplayManagerService.class);
        this.mSystemServiceManager.startBootPhase(100);
        String cryptState = SystemProperties.get("vold.decrypt");
        if (ENCRYPTING_STATE.equals(cryptState)) {
            Slog.w(TAG, "Detected encryption in progress - only parsing core apps");
            this.mOnlyCore = true;
        } else if (ENCRYPTED_STATE.equals(cryptState)) {
            Slog.w(TAG, "Device encrypted - only parsing core apps");
            this.mOnlyCore = true;
        }
        SystemServer.traceBeginAndSlog("StartPackageManagerService");
        this.mPackageManagerService = PackageManagerService.main(this.mSystemContext, installer, this.mFactoryTestMode != 0, this.mOnlyCore);
        this.mFirstBoot = this.mPackageManagerService.isFirstBoot();
        this.mPackageManager = this.mSystemContext.getPackageManager();
        Trace.traceEnd(524288L);
        if (!this.mOnlyCore && !(disableOtaDexopt = SystemProperties.getBoolean("config.disable_otadexopt", false))) {
            SystemServer.traceBeginAndSlog("StartOtaDexOptService");
            try {
                OtaDexoptService.main(this.mSystemContext, this.mPackageManagerService);
            }
            catch (Throwable e) {
                this.reportWtf("starting OtaDexOptService", e);
            }
            finally {
                Trace.traceEnd(524288L);
            }
        }
        SystemServer.traceBeginAndSlog("StartUserManagerService");
        this.mSystemServiceManager.startService(UserManagerService.LifeCycle.class);
        Trace.traceEnd(524288L);
        AttributeCache.init(this.mSystemContext);
        this.mActivityManagerService.setSystemProcess();
        SystemServer.startSensorService();
    }

    private void startCoreServices() {
        this.mSystemServiceManager.startService(BatteryService.class);
        this.mSystemServiceManager.startService(UsageStatsService.class);
        this.mActivityManagerService.setUsageStatsManager(LocalServices.getService(UsageStatsManagerInternal.class));
        this.mWebViewUpdateService = this.mSystemServiceManager.startService(WebViewUpdateService.class);
    }

    private void startOtherServices() {
        boolean safeMode;
        final Context context = this.mSystemContext;
        VibratorService vibrator = null;
        IMountService mountService = null;
        NetworkManagementService networkManagement = null;
        NetworkStatsService networkStats = null;
        NetworkPolicyManagerService networkPolicy = null;
        ConnectivityService connectivity = null;
        NetworkScoreService networkScore = null;
        NsdService serviceDiscovery = null;
        WindowManagerService wm = null;
        SerialService serial = null;
        NetworkTimeUpdateService networkTimeUpdater = null;
        CommonTimeManagementService commonTimeMgmtService = null;
        InputManagerService inputManager = null;
        TelephonyRegistry telephonyRegistry = null;
        ConsumerIrService consumerIr = null;
        MmsServiceBroker mmsService = null;
        HardwarePropertiesManagerService hardwarePropertiesService = null;
        boolean disableStorage = SystemProperties.getBoolean("config.disable_storage", false);
        boolean disableBluetooth = SystemProperties.getBoolean("config.disable_bluetooth", false);
        boolean disableLocation = SystemProperties.getBoolean("config.disable_location", false);
        boolean disableSystemUI = SystemProperties.getBoolean("config.disable_systemui", false);
        boolean disableNonCoreServices = SystemProperties.getBoolean("config.disable_noncore", false);
        boolean disableNetwork = SystemProperties.getBoolean("config.disable_network", false);
        boolean disableNetworkTime = SystemProperties.getBoolean("config.disable_networktime", false);
        boolean disableRtt = SystemProperties.getBoolean("config.disable_rtt", false);
        boolean disableMediaProjection = SystemProperties.getBoolean("config.disable_mediaproj", false);
        boolean disableSerial = SystemProperties.getBoolean("config.disable_serial", false);
        boolean disableSearchManager = SystemProperties.getBoolean("config.disable_searchmanager", false);
        boolean disableTrustManager = SystemProperties.getBoolean("config.disable_trustmanager", false);
        boolean disableTextServices = SystemProperties.getBoolean("config.disable_textservices", false);
        boolean disableSamplingProfiler = SystemProperties.getBoolean("config.disable_samplingprof", false);
        boolean isEmulator = SystemProperties.get("ro.kernel.qemu").equals(ENCRYPTED_STATE);
        try {
            Slog.i(TAG, "Reading configuration...");
            SystemConfig.getInstance();
            SystemServer.traceBeginAndSlog("StartSchedulingPolicyService");
            ServiceManager.addService("scheduling_policy", new SchedulingPolicyService());
            Trace.traceEnd(524288L);
            this.mSystemServiceManager.startService(TelecomLoaderService.class);
            SystemServer.traceBeginAndSlog("StartTelephonyRegistry");
            telephonyRegistry = new TelephonyRegistry(context);
            ServiceManager.addService("telephony.registry", telephonyRegistry);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("StartEntropyMixer");
            this.mEntropyMixer = new EntropyMixer(context);
            Trace.traceEnd(524288L);
            this.mContentResolver = context.getContentResolver();
            Slog.i(TAG, "Camera Service");
            this.mSystemServiceManager.startService(CameraService.class);
            SystemServer.traceBeginAndSlog("StartAccountManagerService");
            this.mSystemServiceManager.startService(ACCOUNT_SERVICE_CLASS);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("StartContentService");
            this.mSystemServiceManager.startService(CONTENT_SERVICE_CLASS);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("InstallSystemProviders");
            this.mActivityManagerService.installSystemProviders();
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("StartVibratorService");
            vibrator = new VibratorService(context);
            ServiceManager.addService("vibrator", vibrator);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("StartConsumerIrService");
            consumerIr = new ConsumerIrService(context);
            ServiceManager.addService("consumer_ir", consumerIr);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("StartAlarmManagerService");
            this.mSystemServiceManager.startService(AlarmManagerService.class);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("InitWatchdog");
            Watchdog watchdog = Watchdog.getInstance();
            watchdog.init(context, this.mActivityManagerService);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("StartInputManagerService");
            inputManager = new InputManagerService(context);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("StartWindowManagerService");
            wm = WindowManagerService.main(context, inputManager, this.mFactoryTestMode != 1, !this.mFirstBoot, this.mOnlyCore);
            ServiceManager.addService("window", wm);
            ServiceManager.addService("input", inputManager);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("StartVrManagerService");
            this.mSystemServiceManager.startService(VrManagerService.class);
            Trace.traceEnd(524288L);
            this.mActivityManagerService.setWindowManager(wm);
            inputManager.setWindowManagerCallbacks(wm.getInputMonitor());
            inputManager.start();
            this.mDisplayManagerService.windowManagerAndInputReady();
            if (isEmulator) {
                Slog.i(TAG, "No Bluetooth Service (emulator)");
            } else if (this.mFactoryTestMode == 1) {
                Slog.i(TAG, "No Bluetooth Service (factory test)");
            } else if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                Slog.i(TAG, "No Bluetooth Service (Bluetooth Hardware Not Present)");
            } else if (disableBluetooth) {
                Slog.i(TAG, "Bluetooth Service disabled by config");
            } else {
                this.mSystemServiceManager.startService(BluetoothService.class);
            }
            SystemServer.traceBeginAndSlog("ConnectivityMetricsLoggerService");
            this.mSystemServiceManager.startService(MetricsLoggerService.class);
            Trace.traceEnd(524288L);
            SystemServer.traceBeginAndSlog("PinnerService");
            this.mSystemServiceManager.startService(PinnerService.class);
            Trace.traceEnd(524288L);
        }
        catch (RuntimeException e) {
            Slog.e("System", "******************************************");
            Slog.e("System", "************ Failure starting core service", e);
        }
        StatusBarManagerService statusBar = null;
        INotificationManager notification = null;
        LocationManagerService location = null;
        CountryDetectorService countryDetector = null;
        ILockSettings lockSettings = null;
        AssetAtlasService atlas = null;
        MediaRouterService mediaRouter = null;
        if (this.mFactoryTestMode != 1) {
            this.mSystemServiceManager.startService(InputMethodManagerService.Lifecycle.class);
            SystemServer.traceBeginAndSlog("StartAccessibilityManagerService");
            try {
                ServiceManager.addService("accessibility", new AccessibilityManagerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Accessibility Manager", e);
            }
            Trace.traceEnd(524288L);
        }
        try {
            wm.displayReady();
        }
        catch (Throwable e) {
            this.reportWtf("making display ready", e);
        }
        if (this.mFactoryTestMode != 1 && !disableStorage && !"0".equals(SystemProperties.get("system_init.startmountservice"))) {
            try {
                this.mSystemServiceManager.startService(MOUNT_SERVICE_CLASS);
                mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            }
            catch (Throwable e) {
                this.reportWtf("starting Mount Service", e);
            }
        }
        this.mSystemServiceManager.startService(UiModeManagerService.class);
        if (!this.mOnlyCore) {
            Trace.traceBegin(524288L, "UpdatePackagesIfNeeded");
            try {
                this.mPackageManagerService.updatePackagesIfNeeded();
            }
            catch (Throwable e) {
                this.reportWtf("update packages", e);
            }
            Trace.traceEnd(524288L);
        }
        Trace.traceBegin(524288L, "PerformFstrimIfNeeded");
        try {
            this.mPackageManagerService.performFstrimIfNeeded();
        }
        catch (Throwable e) {
            this.reportWtf("performing fstrim", e);
        }
        Trace.traceEnd(524288L);
        try {
            ActivityManagerNative.getDefault().showBootMessage(context.getResources().getText(17040302), false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (this.mFactoryTestMode != 1) {
            if (!disableNonCoreServices) {
                SystemServer.traceBeginAndSlog("StartLockSettingsService");
                try {
                    this.mSystemServiceManager.startService(LOCK_SETTINGS_SERVICE_CLASS);
                    lockSettings = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
                }
                catch (Throwable e) {
                    this.reportWtf("starting LockSettingsService service", e);
                }
                Trace.traceEnd(524288L);
                if (!SystemProperties.get(PERSISTENT_DATA_BLOCK_PROP).equals("")) {
                    this.mSystemServiceManager.startService(PersistentDataBlockService.class);
                }
                this.mSystemServiceManager.startService(DeviceIdleController.class);
                this.mSystemServiceManager.startService(DevicePolicyManagerService.Lifecycle.class);
            }
            if (!disableSystemUI) {
                SystemServer.traceBeginAndSlog("StartStatusBarManagerService");
                try {
                    statusBar = new StatusBarManagerService(context, wm);
                    ServiceManager.addService("statusbar", statusBar);
                }
                catch (Throwable e) {
                    this.reportWtf("starting StatusBarManagerService", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNonCoreServices) {
                SystemServer.traceBeginAndSlog("StartClipboardService");
                try {
                    ServiceManager.addService("clipboard", new ClipboardService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting Clipboard Service", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNetwork) {
                SystemServer.traceBeginAndSlog("StartNetworkManagementService");
                try {
                    networkManagement = NetworkManagementService.create(context);
                    ServiceManager.addService("network_management", networkManagement);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkManagement Service", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNonCoreServices && !disableTextServices) {
                this.mSystemServiceManager.startService(TextServicesManagerService.Lifecycle.class);
            }
            if (!disableNetwork) {
                SystemServer.traceBeginAndSlog("StartNetworkScoreService");
                try {
                    networkScore = new NetworkScoreService(context);
                    ServiceManager.addService("network_score", networkScore);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Network Score Service", e);
                }
                Trace.traceEnd(524288L);
                SystemServer.traceBeginAndSlog("StartNetworkStatsService");
                try {
                    networkStats = NetworkStatsService.create(context, networkManagement);
                    ServiceManager.addService("netstats", networkStats);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkStats Service", e);
                }
                Trace.traceEnd(524288L);
                SystemServer.traceBeginAndSlog("StartNetworkPolicyManagerService");
                try {
                    networkPolicy = new NetworkPolicyManagerService(context, this.mActivityManagerService, (IPowerManager)((Object)ServiceManager.getService("power")), networkStats, networkManagement);
                    ServiceManager.addService("netpolicy", networkPolicy);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkPolicy Service", e);
                }
                Trace.traceEnd(524288L);
                if (context.getPackageManager().hasSystemFeature("android.hardware.wifi.nan")) {
                    this.mSystemServiceManager.startService(WIFI_NAN_SERVICE_CLASS);
                } else {
                    Slog.i(TAG, "No Wi-Fi NAN Service (NAN support Not Present)");
                }
                this.mSystemServiceManager.startService(WIFI_P2P_SERVICE_CLASS);
                this.mSystemServiceManager.startService(WIFI_SERVICE_CLASS);
                this.mSystemServiceManager.startService("com.android.server.wifi.scanner.WifiScanningService");
                if (!disableRtt) {
                    this.mSystemServiceManager.startService("com.android.server.wifi.RttService");
                }
                if (this.mPackageManager.hasSystemFeature("android.hardware.ethernet") || this.mPackageManager.hasSystemFeature("android.hardware.usb.host")) {
                    this.mSystemServiceManager.startService(ETHERNET_SERVICE_CLASS);
                }
                SystemServer.traceBeginAndSlog("StartConnectivityService");
                try {
                    connectivity = new ConnectivityService(context, networkManagement, networkStats, networkPolicy);
                    ServiceManager.addService("connectivity", connectivity);
                    networkStats.bindConnectivityManager(connectivity);
                    networkPolicy.bindConnectivityManager(connectivity);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Connectivity Service", e);
                }
                Trace.traceEnd(524288L);
                SystemServer.traceBeginAndSlog("StartNsdService");
                try {
                    serviceDiscovery = NsdService.create(context);
                    ServiceManager.addService("servicediscovery", serviceDiscovery);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Service Discovery Service", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNonCoreServices) {
                SystemServer.traceBeginAndSlog("StartUpdateLockService");
                try {
                    ServiceManager.addService("updatelock", new UpdateLockService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting UpdateLockService", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNonCoreServices) {
                this.mSystemServiceManager.startService(RecoverySystemService.class);
            }
            if (mountService != null && !this.mOnlyCore) {
                Trace.traceBegin(524288L, "WaitForAsecScan");
                try {
                    mountService.waitForAsecScan();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                Trace.traceEnd(524288L);
            }
            this.mSystemServiceManager.startService(NotificationManagerService.class);
            notification = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
            networkPolicy.bindNotificationManager(notification);
            this.mSystemServiceManager.startService(DeviceStorageMonitorService.class);
            if (!disableLocation) {
                SystemServer.traceBeginAndSlog("StartLocationManagerService");
                try {
                    location = new LocationManagerService(context);
                    ServiceManager.addService("location", location);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Location Manager", e);
                }
                Trace.traceEnd(524288L);
                SystemServer.traceBeginAndSlog("StartCountryDetectorService");
                try {
                    countryDetector = new CountryDetectorService(context);
                    ServiceManager.addService("country_detector", countryDetector);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Country Detector", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNonCoreServices && !disableSearchManager) {
                SystemServer.traceBeginAndSlog("StartSearchManagerService");
                try {
                    this.mSystemServiceManager.startService(SEARCH_MANAGER_SERVICE_CLASS);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Search Service", e);
                }
                Trace.traceEnd(524288L);
            }
            this.mSystemServiceManager.startService(DropBoxManagerService.class);
            if (!disableNonCoreServices && context.getResources().getBoolean(17956941)) {
                SystemServer.traceBeginAndSlog("StartWallpaperManagerService");
                this.mSystemServiceManager.startService(WALLPAPER_SERVICE_CLASS);
                Trace.traceEnd(524288L);
            }
            SystemServer.traceBeginAndSlog("StartAudioService");
            this.mSystemServiceManager.startService(AudioService.Lifecycle.class);
            Trace.traceEnd(524288L);
            if (!disableNonCoreServices) {
                this.mSystemServiceManager.startService(DockObserver.class);
                if (context.getPackageManager().hasSystemFeature("android.hardware.type.watch")) {
                    this.mSystemServiceManager.startService(THERMAL_OBSERVER_CLASS);
                }
            }
            SystemServer.traceBeginAndSlog("StartWiredAccessoryManager");
            try {
                inputManager.setWiredAccessoryCallbacks(new WiredAccessoryManager(context, inputManager));
            }
            catch (Throwable e) {
                this.reportWtf("starting WiredAccessoryManager", e);
            }
            Trace.traceEnd(524288L);
            if (!disableNonCoreServices) {
                if (this.mPackageManager.hasSystemFeature("android.software.midi")) {
                    this.mSystemServiceManager.startService(MIDI_SERVICE_CLASS);
                }
                if (this.mPackageManager.hasSystemFeature("android.hardware.usb.host") || this.mPackageManager.hasSystemFeature("android.hardware.usb.accessory")) {
                    Trace.traceBegin(524288L, "StartUsbService");
                    this.mSystemServiceManager.startService(USB_SERVICE_CLASS);
                    Trace.traceEnd(524288L);
                }
                if (!disableSerial) {
                    SystemServer.traceBeginAndSlog("StartSerialService");
                    try {
                        serial = new SerialService(context);
                        ServiceManager.addService("serial", serial);
                    }
                    catch (Throwable e) {
                        Slog.e(TAG, "Failure starting SerialService", e);
                    }
                    Trace.traceEnd(524288L);
                }
                Trace.traceBegin(524288L, "StartHardwarePropertiesManagerService");
                try {
                    hardwarePropertiesService = new HardwarePropertiesManagerService(context);
                    ServiceManager.addService("hardware_properties", hardwarePropertiesService);
                }
                catch (Throwable e) {
                    Slog.e(TAG, "Failure starting HardwarePropertiesManagerService", e);
                }
                Trace.traceEnd(524288L);
            }
            this.mSystemServiceManager.startService(TwilightService.class);
            this.mSystemServiceManager.startService(JobSchedulerService.class);
            this.mSystemServiceManager.startService(SoundTriggerService.class);
            if (!disableNonCoreServices) {
                if (this.mPackageManager.hasSystemFeature("android.software.backup")) {
                    this.mSystemServiceManager.startService(BACKUP_MANAGER_SERVICE_CLASS);
                }
                if (this.mPackageManager.hasSystemFeature("android.software.app_widgets") || context.getResources().getBoolean(17957037)) {
                    this.mSystemServiceManager.startService(APPWIDGET_SERVICE_CLASS);
                }
                if (this.mPackageManager.hasSystemFeature("android.software.voice_recognizers")) {
                    this.mSystemServiceManager.startService(VOICE_RECOGNITION_MANAGER_SERVICE_CLASS);
                }
                if (GestureLauncherService.isGestureLauncherEnabled(context.getResources())) {
                    Slog.i(TAG, "Gesture Launcher Service");
                    this.mSystemServiceManager.startService(GestureLauncherService.class);
                }
                this.mSystemServiceManager.startService(SensorNotificationService.class);
                this.mSystemServiceManager.startService(ContextHubSystemService.class);
            }
            SystemServer.traceBeginAndSlog("StartDiskStatsService");
            try {
                ServiceManager.addService("diskstats", new DiskStatsService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting DiskStats Service", e);
            }
            Trace.traceEnd(524288L);
            if (!disableSamplingProfiler) {
                SystemServer.traceBeginAndSlog("StartSamplingProfilerService");
                try {
                    ServiceManager.addService("samplingprofiler", new SamplingProfilerService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting SamplingProfiler Service", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNetwork && !disableNetworkTime) {
                SystemServer.traceBeginAndSlog("StartNetworkTimeUpdateService");
                try {
                    networkTimeUpdater = new NetworkTimeUpdateService(context);
                    ServiceManager.addService("network_time_update_service", networkTimeUpdater);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkTimeUpdate service", e);
                }
                Trace.traceEnd(524288L);
            }
            SystemServer.traceBeginAndSlog("StartCommonTimeManagementService");
            try {
                commonTimeMgmtService = new CommonTimeManagementService(context);
                ServiceManager.addService("commontime_management", commonTimeMgmtService);
            }
            catch (Throwable e) {
                this.reportWtf("starting CommonTimeManagementService service", e);
            }
            Trace.traceEnd(524288L);
            if (!disableNetwork) {
                SystemServer.traceBeginAndSlog("CertBlacklister");
                try {
                    CertBlacklister e = new CertBlacklister(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting CertBlacklister", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNonCoreServices) {
                this.mSystemServiceManager.startService(DreamManagerService.class);
            }
            if (!disableNonCoreServices) {
                SystemServer.traceBeginAndSlog("StartAssetAtlasService");
                try {
                    atlas = new AssetAtlasService(context);
                    ServiceManager.addService("assetatlas", atlas);
                }
                catch (Throwable e) {
                    this.reportWtf("starting AssetAtlasService", e);
                }
                Trace.traceEnd(524288L);
            }
            if (!disableNonCoreServices) {
                ServiceManager.addService("graphicsstats", new GraphicsStatsService(context));
            }
            if (this.mPackageManager.hasSystemFeature("android.software.print")) {
                this.mSystemServiceManager.startService(PRINT_MANAGER_SERVICE_CLASS);
            }
            this.mSystemServiceManager.startService(RestrictionsManagerService.class);
            this.mSystemServiceManager.startService(MediaSessionService.class);
            if (this.mPackageManager.hasSystemFeature("android.hardware.hdmi.cec")) {
                this.mSystemServiceManager.startService(HdmiControlService.class);
            }
            if (this.mPackageManager.hasSystemFeature("android.software.live_tv")) {
                this.mSystemServiceManager.startService(TvInputManagerService.class);
            }
            if (this.mPackageManager.hasSystemFeature("android.software.picture_in_picture")) {
                this.mSystemServiceManager.startService(MediaResourceMonitorService.class);
            }
            if (this.mPackageManager.hasSystemFeature("android.software.leanback")) {
                this.mSystemServiceManager.startService(TvRemoteService.class);
            }
            if (!disableNonCoreServices) {
                SystemServer.traceBeginAndSlog("StartMediaRouterService");
                try {
                    mediaRouter = new MediaRouterService(context);
                    ServiceManager.addService("media_router", mediaRouter);
                }
                catch (Throwable e) {
                    this.reportWtf("starting MediaRouterService", e);
                }
                Trace.traceEnd(524288L);
                if (!disableTrustManager) {
                    this.mSystemServiceManager.startService(TrustManagerService.class);
                }
                if (this.mPackageManager.hasSystemFeature("android.hardware.fingerprint")) {
                    this.mSystemServiceManager.startService(FingerprintService.class);
                }
                SystemServer.traceBeginAndSlog("StartBackgroundDexOptService");
                try {
                    BackgroundDexOptService.schedule(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting BackgroundDexOptService", e);
                }
                Trace.traceEnd(524288L);
            }
            this.mSystemServiceManager.startService(ShortcutService.Lifecycle.class);
            this.mSystemServiceManager.startService(LauncherAppsService.class);
        }
        if (!disableNonCoreServices && !disableMediaProjection) {
            this.mSystemServiceManager.startService(MediaProjectionManagerService.class);
        }
        if (context.getPackageManager().hasSystemFeature("android.hardware.type.watch")) {
            this.mSystemServiceManager.startService(WEAR_BLUETOOTH_SERVICE_CLASS);
        }
        if (safeMode = wm.detectSafeMode()) {
            this.mActivityManagerService.enterSafeMode();
            VMRuntime.getRuntime().disableJitCompilation();
        } else {
            VMRuntime.getRuntime().startJitCompilation();
        }
        mmsService = this.mSystemServiceManager.startService(MmsServiceBroker.class);
        Trace.traceBegin(524288L, "MakeVibratorServiceReady");
        try {
            vibrator.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Vibrator Service ready", e);
        }
        Trace.traceEnd(524288L);
        Trace.traceBegin(524288L, "MakeLockSettingsServiceReady");
        if (lockSettings != null) {
            try {
                lockSettings.systemReady();
            }
            catch (Throwable e) {
                this.reportWtf("making Lock Settings Service ready", e);
            }
        }
        Trace.traceEnd(524288L);
        this.mSystemServiceManager.startBootPhase(480);
        this.mSystemServiceManager.startBootPhase(500);
        Trace.traceBegin(524288L, "MakeWindowManagerServiceReady");
        try {
            wm.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Window Manager Service ready", e);
        }
        Trace.traceEnd(524288L);
        if (safeMode) {
            this.mActivityManagerService.showSafeModeOverlay();
        }
        Configuration config = wm.computeNewConfiguration();
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager w = (WindowManager)context.getSystemService("window");
        w.getDefaultDisplay().getMetrics(metrics);
        context.getResources().updateConfiguration(config, metrics);
        Resources.Theme systemTheme = context.getTheme();
        if (systemTheme.getChangingConfigurations() != 0) {
            systemTheme.rebase();
        }
        Trace.traceBegin(524288L, "MakePowerManagerServiceReady");
        try {
            this.mPowerManagerService.systemReady(this.mActivityManagerService.getAppOpsService());
            Trace.traceEnd(524288L);
        }
        catch (Throwable e) {
            this.reportWtf("making Power Manager Service ready", e);
        }
        Trace.traceEnd(524288L);
        Trace.traceBegin(524288L, "MakePackageManagerServiceReady");
        try {
            this.mPackageManagerService.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Package Manager Service ready", e);
        }
        Trace.traceEnd(524288L);
        Trace.traceBegin(524288L, "MakeDisplayManagerServiceReady");
        try {
            this.mDisplayManagerService.systemReady(safeMode, this.mOnlyCore);
        }
        catch (Throwable e) {
            this.reportWtf("making Display Manager Service ready", e);
        }
        Trace.traceEnd(524288L);
        final NetworkManagementService networkManagementF = networkManagement;
        final NetworkStatsService networkStatsF = networkStats;
        final NetworkPolicyManagerService networkPolicyF = networkPolicy;
        final ConnectivityService connectivityF = connectivity;
        final NetworkScoreService networkScoreF = networkScore;
        final LocationManagerService locationF = location;
        final CountryDetectorService countryDetectorF = countryDetector;
        final NetworkTimeUpdateService networkTimeUpdaterF = networkTimeUpdater;
        final CommonTimeManagementService commonTimeMgmtServiceF = commonTimeMgmtService;
        final AssetAtlasService atlasF = atlas;
        final InputManagerService inputManagerF = inputManager;
        final TelephonyRegistry telephonyRegistryF = telephonyRegistry;
        final MediaRouterService mediaRouterF = mediaRouter;
        final MmsServiceBroker mmsServiceF = mmsService;
        this.mActivityManagerService.systemReady(new Runnable(){

            @Override
            public void run() {
                Slog.i(SystemServer.TAG, "Making services ready");
                SystemServer.this.mSystemServiceManager.startBootPhase(550);
                Trace.traceBegin(524288L, "PhaseActivityManagerReady");
                Trace.traceBegin(524288L, "StartObservingNativeCrashes");
                try {
                    SystemServer.this.mActivityManagerService.startObservingNativeCrashes();
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("observing native crashes", e);
                }
                Trace.traceEnd(524288L);
                if (!SystemServer.this.mOnlyCore) {
                    Slog.i(SystemServer.TAG, "WebViewFactory preparation");
                    Trace.traceBegin(524288L, "WebViewFactoryPreparation");
                    SystemServer.this.mWebViewUpdateService.prepareWebViewInSystemServer();
                    Trace.traceEnd(524288L);
                }
                Trace.traceBegin(524288L, "StartSystemUI");
                try {
                    SystemServer.startSystemUi(context);
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("starting System UI", e);
                }
                Trace.traceEnd(524288L);
                Trace.traceBegin(524288L, "MakeNetworkScoreReady");
                try {
                    if (networkScoreF != null) {
                        networkScoreF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Network Score Service ready", e);
                }
                Trace.traceEnd(524288L);
                Trace.traceBegin(524288L, "MakeNetworkManagementServiceReady");
                try {
                    if (networkManagementF != null) {
                        networkManagementF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Network Managment Service ready", e);
                }
                Trace.traceEnd(524288L);
                Trace.traceBegin(524288L, "MakeNetworkStatsServiceReady");
                try {
                    if (networkStatsF != null) {
                        networkStatsF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Network Stats Service ready", e);
                }
                Trace.traceEnd(524288L);
                Trace.traceBegin(524288L, "MakeNetworkPolicyServiceReady");
                try {
                    if (networkPolicyF != null) {
                        networkPolicyF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Network Policy Service ready", e);
                }
                Trace.traceEnd(524288L);
                Trace.traceBegin(524288L, "MakeConnectivityServiceReady");
                try {
                    if (connectivityF != null) {
                        connectivityF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Connectivity Service ready", e);
                }
                Trace.traceEnd(524288L);
                Watchdog.getInstance().start();
                Trace.traceEnd(524288L);
                Trace.traceBegin(524288L, "PhaseThirdPartyAppsCanStart");
                SystemServer.this.mSystemServiceManager.startBootPhase(600);
                try {
                    if (locationF != null) {
                        locationF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying Location Service running", e);
                }
                try {
                    if (countryDetectorF != null) {
                        countryDetectorF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying CountryDetectorService running", e);
                }
                try {
                    if (networkTimeUpdaterF != null) {
                        networkTimeUpdaterF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying NetworkTimeService running", e);
                }
                try {
                    if (commonTimeMgmtServiceF != null) {
                        commonTimeMgmtServiceF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying CommonTimeManagementService running", e);
                }
                try {
                    if (atlasF != null) {
                        atlasF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying AssetAtlasService running", e);
                }
                try {
                    if (inputManagerF != null) {
                        inputManagerF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying InputManagerService running", e);
                }
                try {
                    if (telephonyRegistryF != null) {
                        telephonyRegistryF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying TelephonyRegistry running", e);
                }
                try {
                    if (mediaRouterF != null) {
                        mediaRouterF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying MediaRouterService running", e);
                }
                try {
                    if (mmsServiceF != null) {
                        mmsServiceF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying MmsService running", e);
                }
                try {
                    if (networkScoreF != null) {
                        networkScoreF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying NetworkScoreService running", e);
                }
                Trace.traceEnd(524288L);
            }
        });
    }

    static final void startSystemUi(Context context) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.SystemUIService"));
        intent.addFlags(256);
        context.startServiceAsUser(intent, UserHandle.SYSTEM);
    }

    private static void traceBeginAndSlog(String name) {
        Trace.traceBegin(524288L, name);
        Slog.i(TAG, name);
    }
}

