/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.IRecoverySystem;
import android.os.IRecoverySystemProgressListener;
import android.os.RecoverySystem;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.server.SystemService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import libcore.io.IoUtils;

public final class RecoverySystemService
extends SystemService {
    private static final String TAG = "RecoverySystemService";
    private static final boolean DEBUG = false;
    private static final String UNCRYPT_SOCKET = "uncrypt";
    private static final int SOCKET_CONNECTION_MAX_RETRY = 30;
    private Context mContext;

    public RecoverySystemService(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    public void onStart() {
        this.publishBinderService("recovery", new BinderService());
    }

    private final class BinderService
    extends IRecoverySystem.Stub {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean uncrypt(String filename, IRecoverySystemProgressListener listener) {
            RecoverySystemService.access$100(RecoverySystemService.this).enforceCallingOrSelfPermission("android.permission.RECOVERY", null);
            RecoverySystem.UNCRYPT_PACKAGE_FILE.delete();
            try {
                uncryptFile = new FileWriter(RecoverySystem.UNCRYPT_PACKAGE_FILE);
                var4_5 = null;
                try {
                    uncryptFile.write(filename + "\n");
                }
                catch (Throwable var5_7) {
                    var4_5 = var5_7;
                    throw var5_7;
                }
                finally {
                    if (uncryptFile != null) {
                        if (var4_5 != null) {
                            try {
                                uncryptFile.close();
                            }
                            catch (Throwable var5_6) {
                                var4_5.addSuppressed(var5_6);
                            }
                        } else {
                            uncryptFile.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                Slog.e("RecoverySystemService", "IOException when writing \"" + RecoverySystem.UNCRYPT_PACKAGE_FILE + "\": ", e);
                return false;
            }
            SystemProperties.set("ctl.start", "uncrypt");
            socket = this.connectService();
            if (socket == null) {
                Slog.e("RecoverySystemService", "Failed to connect to uncrypt socket");
                return false;
            }
            dis = null;
            dos = null;
            try {
                block26: {
                    dis = new DataInputStream(socket.getInputStream());
                    dos = new DataOutputStream(socket.getOutputStream());
                    lastStatus = -2147483648;
                    while (true) {
                        if ((status = dis.readInt()) == lastStatus && lastStatus != -2147483648) {
                            continue;
                        }
                        lastStatus = status;
                        if (status < 0 || status > 100) break block26;
                        Slog.i("RecoverySystemService", "uncrypt read status: " + status);
                        if (listener != null) {
                            try {
                                listener.onProgress(status);
                            }
                            catch (RemoteException ignored) {
                                Slog.w("RecoverySystemService", "RemoteException when posting progress");
                            }
                        }
                        if (status == 100) break;
                    }
                    Slog.i("RecoverySystemService", "uncrypt successfully finished.");
                    dos.writeInt(0);
                    ** GOTO lbl82
                }
                Slog.e("RecoverySystemService", "uncrypt failed with status: " + status);
                dos.writeInt(0);
                var8_15 = false;
                ** GOTO lbl78
            }
            catch (IOException e) {
                try {
                    Slog.e("RecoverySystemService", "IOException when reading status: ", e);
                    var7_13 = false;
                }
                catch (Throwable var9_16) {
                    IoUtils.closeQuietly(dis);
                    IoUtils.closeQuietly(dos);
                    IoUtils.closeQuietly(socket);
                    throw var9_16;
                }
lbl78:
                // 1 sources

                IoUtils.closeQuietly(dis);
                IoUtils.closeQuietly(dos);
                IoUtils.closeQuietly(socket);
                return var8_15;
lbl82:
                // 1 sources

                IoUtils.closeQuietly(dis);
                IoUtils.closeQuietly(dos);
                IoUtils.closeQuietly(socket);
                return true;
                IoUtils.closeQuietly(dis);
                IoUtils.closeQuietly(dos);
                IoUtils.closeQuietly(socket);
                return var7_13;
            }
        }

        @Override
        public boolean clearBcb() {
            return this.setupOrClearBcb(false, null);
        }

        @Override
        public boolean setupBcb(String command) {
            return this.setupOrClearBcb(true, command);
        }

        private LocalSocket connectService() {
            LocalSocket socket = new LocalSocket();
            boolean done = false;
            for (int retry = 0; retry < 30; ++retry) {
                try {
                    socket.connect(new LocalSocketAddress(RecoverySystemService.UNCRYPT_SOCKET, LocalSocketAddress.Namespace.RESERVED));
                    done = true;
                    break;
                }
                catch (IOException ignored) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Slog.w(RecoverySystemService.TAG, "Interrupted: ", e);
                    }
                    continue;
                }
            }
            if (!done) {
                Slog.e(RecoverySystemService.TAG, "Timed out connecting to uncrypt socket");
                return null;
            }
            return socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setupOrClearBcb(boolean isSetup, String command) {
            DataOutputStream dos;
            DataInputStream dis;
            LocalSocket socket;
            block9: {
                boolean bl;
                RecoverySystemService.this.mContext.enforceCallingOrSelfPermission("android.permission.RECOVERY", null);
                if (isSetup) {
                    SystemProperties.set("ctl.start", "setup-bcb");
                } else {
                    SystemProperties.set("ctl.start", "clear-bcb");
                }
                socket = this.connectService();
                if (socket == null) {
                    Slog.e(RecoverySystemService.TAG, "Failed to connect to uncrypt socket");
                    return false;
                }
                dis = null;
                dos = null;
                try {
                    dis = new DataInputStream(socket.getInputStream());
                    dos = new DataOutputStream(socket.getOutputStream());
                    if (isSetup) {
                        dos.writeInt(command.length());
                        dos.writeBytes(command);
                        dos.flush();
                    }
                    int status = dis.readInt();
                    dos.writeInt(0);
                    if (status == 100) {
                        Slog.i(RecoverySystemService.TAG, "uncrypt " + (isSetup ? "setup" : "clear") + " bcb successfully finished.");
                        break block9;
                    }
                    Slog.e(RecoverySystemService.TAG, "uncrypt failed with status: " + status);
                    bl = false;
                }
                catch (IOException e) {
                    boolean bl2;
                    try {
                        Slog.e(RecoverySystemService.TAG, "IOException when communicating with uncrypt: ", e);
                        bl2 = false;
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(dis);
                        IoUtils.closeQuietly(dos);
                        IoUtils.closeQuietly(socket);
                        throw throwable;
                    }
                    IoUtils.closeQuietly(dis);
                    IoUtils.closeQuietly(dos);
                    IoUtils.closeQuietly(socket);
                    return bl2;
                }
                IoUtils.closeQuietly(dis);
                IoUtils.closeQuietly(dos);
                IoUtils.closeQuietly(socket);
                return bl;
            }
            IoUtils.closeQuietly(dis);
            IoUtils.closeQuietly(dos);
            IoUtils.closeQuietly(socket);
            return true;
        }
    }
}

