/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.os.Binder;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.Slog;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class PinnerService
extends SystemService {
    private static final boolean DEBUG = false;
    private static final String TAG = "PinnerService";
    private final Context mContext;
    private final ArrayList<String> mPinnedFiles = new ArrayList();
    private BinderService mBinderService;

    public PinnerService(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    public void onStart() {
        Slog.e(TAG, "Starting PinnerService");
        this.mBinderService = new BinderService();
        this.publishBinderService("pinner", this.mBinderService);
        String[] filesToPin = this.mContext.getResources().getStringArray(17236041);
        for (int i = 0; i < filesToPin.length; ++i) {
            boolean success = this.pinFile(filesToPin[i], 0L, 0L);
            if (success) {
                this.mPinnedFiles.add(filesToPin[i]);
                Slog.i(TAG, "Pinned file = " + filesToPin[i]);
                continue;
            }
            Slog.e(TAG, "Failed to pin file = " + filesToPin[i]);
        }
    }

    private boolean pinFile(String fileToPin, long offset, long length) {
        FileDescriptor fd = new FileDescriptor();
        try {
            fd = Os.open(fileToPin, OsConstants.O_RDONLY | OsConstants.O_CLOEXEC | OsConstants.O_NOFOLLOW, OsConstants.O_RDONLY);
            StructStat sb = Os.fstat(fd);
            if (offset + length > sb.st_size) {
                Os.close(fd);
                return false;
            }
            if (length == 0L) {
                length = sb.st_size - offset;
            }
            long address = Os.mmap(0L, length, OsConstants.PROT_READ, OsConstants.MAP_PRIVATE, fd, offset);
            Os.close(fd);
            Os.mlock(address, length);
            return true;
        }
        catch (ErrnoException e) {
            Slog.e(TAG, "Failed to pin file " + fileToPin + " with error " + e.getMessage());
            if (fd.valid()) {
                try {
                    Os.close(fd);
                }
                catch (ErrnoException eClose) {
                    Slog.e(TAG, "Failed to close fd, error = " + eClose.getMessage());
                }
            }
            return false;
        }
    }

    private final class BinderService
    extends Binder {
        private BinderService() {
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            PinnerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", PinnerService.TAG);
            pw.println("Pinned Files:");
            for (int i = 0; i < PinnerService.this.mPinnedFiles.size(); ++i) {
                pw.println((String)PinnerService.this.mPinnedFiles.get(i));
            }
        }
    }
}

