/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.backup.BackupManager;
import android.app.trust.IStrongAuthTracker;
import android.app.trust.TrustManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IProgressListener;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.security.keystore.AndroidKeyStoreProvider;
import android.security.keystore.KeyProtection;
import android.service.gatekeeper.GateKeeperResponse;
import android.service.gatekeeper.IGateKeeperService;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.VerifyCredentialResponse;
import com.android.server.LockSettingsStorage;
import com.android.server.LockSettingsStrongAuth;
import com.android.server.SystemService;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import libcore.util.HexEncoding;

public class LockSettingsService
extends ILockSettings.Stub {
    private static final String TAG = "LockSettingsService";
    private static final String PERMISSION = "android.permission.ACCESS_KEYGUARD_SECURE_STORAGE";
    private static final Intent ACTION_NULL;
    private static final int FBE_ENCRYPTED_NOTIFICATION = 0;
    private static final boolean DEBUG = false;
    private static final int PROFILE_KEY_IV_SIZE = 12;
    private static final String SEPARATE_PROFILE_CHALLENGE_KEY = "lockscreen.profilechallenge";
    private final Object mSeparateChallengeLock = new Object();
    private final Context mContext;
    private final Handler mHandler;
    private final LockSettingsStorage mStorage;
    private final LockSettingsStrongAuth mStrongAuth;
    private final SynchronizedStrongAuthTracker mStrongAuthTracker;
    private LockPatternUtils mLockPatternUtils;
    private boolean mFirstCallToVold;
    private IGateKeeperService mGateKeeperService;
    private NotificationManager mNotificationManager;
    private UserManager mUserManager;
    private final android.security.KeyStore mKeyStore = android.security.KeyStore.getInstance();
    private static final int[] SYSTEM_CREDENTIAL_UIDS;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int userHandle;
            if ("android.intent.action.USER_ADDED".equals(intent.getAction())) {
                int userHandle2 = intent.getIntExtra("android.intent.extra.user_handle", 0);
                if (userHandle2 > 0) {
                    LockSettingsService.this.removeUser(userHandle2, true);
                }
                android.security.KeyStore ks = android.security.KeyStore.getInstance();
                UserInfo parentInfo = LockSettingsService.this.mUserManager.getProfileParent(userHandle2);
                int parentHandle = parentInfo != null ? parentInfo.id : -1;
                ks.onUserAdded(userHandle2, parentHandle);
            } else if ("android.intent.action.USER_STARTING".equals(intent.getAction())) {
                int userHandle3 = intent.getIntExtra("android.intent.extra.user_handle", 0);
                LockSettingsService.this.mStorage.prefetchUser(userHandle3);
            } else if ("android.intent.action.USER_REMOVED".equals(intent.getAction()) && (userHandle = intent.getIntExtra("android.intent.extra.user_handle", 0)) > 0) {
                LockSettingsService.this.removeUser(userHandle, false);
            }
        }
    };
    private static final String[] VALID_SETTINGS;
    private static final String[] READ_CONTACTS_PROTECTED_SETTINGS;
    private static final String[] READ_PASSWORD_PROTECTED_SETTINGS;
    private static final String[] SETTINGS_TO_BACKUP;

    public void tieManagedProfileLockIfNecessary(int managedUserId, String managedUserPassword) {
        if (!UserManager.get(this.mContext).getUserInfo(managedUserId).isManagedProfile()) {
            return;
        }
        if (this.mLockPatternUtils.isSeparateProfileChallengeEnabled(managedUserId)) {
            return;
        }
        if (this.mStorage.hasChildProfileLock(managedUserId)) {
            return;
        }
        int parentId = this.mUserManager.getProfileParent((int)managedUserId).id;
        if (!this.mStorage.hasPassword(parentId) && !this.mStorage.hasPattern(parentId)) {
            return;
        }
        byte[] randomLockSeed = new byte[]{};
        try {
            randomLockSeed = SecureRandom.getInstance("SHA1PRNG").generateSeed(40);
            String newPassword = String.valueOf(HexEncoding.encode(randomLockSeed));
            this.setLockPasswordInternal(newPassword, managedUserPassword, managedUserId);
            this.setLong("lockscreen.password_type", 327680L, managedUserId);
            this.tieProfileLockToParent(managedUserId, newPassword);
        }
        catch (RemoteException | NoSuchAlgorithmException e) {
            Slog.e(TAG, "Fail to tie managed profile", e);
        }
    }

    public LockSettingsService(Context context) {
        this.mContext = context;
        this.mHandler = new Handler();
        this.mStrongAuth = new LockSettingsStrongAuth(context);
        this.mLockPatternUtils = new LockPatternUtils(context);
        this.mFirstCallToVold = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_STARTING");
        filter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, filter, null, null);
        this.mStorage = new LockSettingsStorage(context, new LockSettingsStorage.Callback(){

            @Override
            public void initialize(SQLiteDatabase db) {
                boolean lockScreenDisable = SystemProperties.getBoolean("ro.lockscreen.disable.default", false);
                if (lockScreenDisable) {
                    LockSettingsService.this.mStorage.writeKeyValue(db, "lockscreen.disabled", "1", 0);
                }
            }
        });
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mStrongAuthTracker = new SynchronizedStrongAuthTracker(this.mContext);
        this.mStrongAuthTracker.register();
    }

    private void maybeShowEncryptionNotifications() {
        List<UserInfo> users = this.mUserManager.getUsers();
        for (int i = 0; i < users.size(); ++i) {
            UserInfo user = users.get(i);
            UserHandle userHandle = user.getUserHandle();
            if (this.mUserManager.isUserUnlockingOrUnlocked(userHandle)) continue;
            if (!user.isManagedProfile()) {
                this.showEncryptionNotification(userHandle);
                continue;
            }
            UserInfo parent = this.mUserManager.getProfileParent(user.id);
            if (parent == null || !this.mUserManager.isUserUnlockingOrUnlocked(parent.getUserHandle()) || this.mUserManager.isQuietModeEnabled(userHandle)) continue;
            this.showEncryptionNotificationForProfile(userHandle);
        }
    }

    private void showEncryptionNotificationForProfile(UserHandle user) {
        Resources r = this.mContext.getResources();
        CharSequence title = r.getText(17040862);
        CharSequence message = r.getText(17040866);
        CharSequence detail = r.getText(17040865);
        KeyguardManager km = (KeyguardManager)this.mContext.getSystemService("keyguard");
        Intent unlockIntent = km.createConfirmDeviceCredentialIntent(null, null, user.getIdentifier());
        if (unlockIntent == null) {
            return;
        }
        unlockIntent.setFlags(0x10800000);
        PendingIntent intent = PendingIntent.getActivity(this.mContext, 0, unlockIntent, 0x8000000);
        this.showEncryptionNotification(user, title, message, detail, intent);
    }

    private void showEncryptionNotification(UserHandle user) {
        Resources r = this.mContext.getResources();
        CharSequence title = r.getText(17040862);
        CharSequence message = r.getText(17040863);
        CharSequence detail = r.getText(17040864);
        PendingIntent intent = PendingIntent.getBroadcast(this.mContext, 0, ACTION_NULL, 0x8000000);
        this.showEncryptionNotification(user, title, message, detail, intent);
    }

    private void showEncryptionNotification(UserHandle user, CharSequence title, CharSequence message, CharSequence detail, PendingIntent intent) {
        if (!StorageManager.isFileEncryptedNativeOrEmulated()) {
            return;
        }
        Notification notification = new Notification.Builder(this.mContext).setSmallIcon(17302578).setWhen(0L).setOngoing(true).setTicker(title).setDefaults(0).setPriority(2).setColor(this.mContext.getColor(17170521)).setContentTitle(title).setContentText(message).setSubText(detail).setVisibility(1).setContentIntent(intent).build();
        this.mNotificationManager.notifyAsUser(null, 0, notification, user);
    }

    public void hideEncryptionNotification(UserHandle userHandle) {
        this.mNotificationManager.cancelAsUser(null, 0, userHandle);
    }

    public void onCleanupUser(int userId) {
        this.hideEncryptionNotification(new UserHandle(userId));
    }

    public void onUnlockUser(final int userId) {
        this.hideEncryptionNotification(new UserHandle(userId));
        if (this.mUserManager.getUserInfo(userId).isManagedProfile()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    LockSettingsService.this.tieManagedProfileLockIfNecessary(userId, null);
                }
            });
        }
        List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
        for (int i = 0; i < profiles.size(); ++i) {
            UserHandle userHandle;
            UserInfo profile = profiles.get(i);
            if (!profile.isManagedProfile() || this.mUserManager.isUserUnlockingOrUnlocked(userHandle = profile.getUserHandle()) || this.mUserManager.isQuietModeEnabled(userHandle)) continue;
            this.showEncryptionNotificationForProfile(userHandle);
        }
    }

    @Override
    public void systemReady() {
        this.migrateOldData();
        try {
            this.getGateKeeperService();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failure retrieving IGateKeeperService", e);
        }
        this.mStorage.prefetchUser(0);
    }

    private void migrateOldData() {
        try {
            List<UserInfo> users;
            ContentResolver cr;
            if (this.getString("migrated", null, 0) == null) {
                cr = this.mContext.getContentResolver();
                for (String validSetting : VALID_SETTINGS) {
                    String value = Settings.Secure.getString(cr, validSetting);
                    if (value == null) continue;
                    this.setString(validSetting, value, 0);
                }
                this.setString("migrated", "true", 0);
                Slog.i(TAG, "Migrated lock settings to new location");
            }
            if (this.getString("migrated_user_specific", null, 0) == null) {
                cr = this.mContext.getContentResolver();
                List<UserInfo> users2 = this.mUserManager.getUsers();
                for (int user = 0; user < users2.size(); ++user) {
                    int userId;
                    block18: {
                        userId = users2.get((int)user).id;
                        String OWNER_INFO = "lock_screen_owner_info";
                        String ownerInfo = Settings.Secure.getStringForUser(cr, "lock_screen_owner_info", userId);
                        if (!TextUtils.isEmpty(ownerInfo)) {
                            this.setString("lock_screen_owner_info", ownerInfo, userId);
                            Settings.Secure.putStringForUser(cr, "lock_screen_owner_info", "", userId);
                        }
                        String OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
                        try {
                            int ivalue = Settings.Secure.getIntForUser(cr, "lock_screen_owner_info_enabled", userId);
                            boolean enabled = ivalue != 0;
                            this.setLong("lock_screen_owner_info_enabled", enabled ? 1L : 0L, userId);
                        }
                        catch (Settings.SettingNotFoundException e) {
                            if (TextUtils.isEmpty(ownerInfo)) break block18;
                            this.setLong("lock_screen_owner_info_enabled", 1L, userId);
                        }
                    }
                    Settings.Secure.putIntForUser(cr, "lock_screen_owner_info_enabled", 0, userId);
                }
                this.setString("migrated_user_specific", "true", 0);
                Slog.i(TAG, "Migrated per-user lock settings to new location");
            }
            if (this.getString("migrated_biometric_weak", null, 0) == null) {
                users = this.mUserManager.getUsers();
                for (int i = 0; i < users.size(); ++i) {
                    int userId = users.get((int)i).id;
                    long type = this.getLong("lockscreen.password_type", 0L, userId);
                    long alternateType = this.getLong("lockscreen.password_type_alternate", 0L, userId);
                    if (type == 32768L) {
                        this.setLong("lockscreen.password_type", alternateType, userId);
                    }
                    this.setLong("lockscreen.password_type_alternate", 0L, userId);
                }
                this.setString("migrated_biometric_weak", "true", 0);
                Slog.i(TAG, "Migrated biometric weak to use the fallback instead");
            }
            if (this.getString("migrated_lockscreen_disabled", null, 0) == null) {
                int i;
                users = this.mUserManager.getUsers();
                int userCount = users.size();
                int switchableUsers = 0;
                for (i = 0; i < userCount; ++i) {
                    if (!users.get(i).supportsSwitchTo()) continue;
                    ++switchableUsers;
                }
                if (switchableUsers > 1) {
                    for (i = 0; i < userCount; ++i) {
                        int id2 = users.get((int)i).id;
                        if (!this.getBoolean("lockscreen.disabled", false, id2)) continue;
                        this.setBoolean("lockscreen.disabled", false, id2);
                    }
                }
                this.setString("migrated_lockscreen_disabled", "true", 0);
                Slog.i(TAG, "Migrated lockscreen disabled flag");
            }
            users = this.mUserManager.getUsers();
            for (int i = 0; i < users.size(); ++i) {
                UserInfo userInfo = users.get(i);
                if (!userInfo.isManagedProfile() || !this.mStorage.hasChildProfileLock(userInfo.id)) continue;
                long quality = this.getLong("lockscreen.password_type", 0L, userInfo.id);
                if (quality == 0L) {
                    Slog.i(TAG, "Migrated tied profile lock type");
                    this.setLong("lockscreen.password_type", 327680L, userInfo.id);
                    continue;
                }
                if (quality == 327680L) continue;
                Slog.e(TAG, "Invalid tied profile lock type: " + quality);
            }
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to migrate old data", re);
        }
    }

    private final void checkWritePermission(int userId) {
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "LockSettingsWrite");
    }

    private final void checkPasswordReadPermission(int userId) {
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "LockSettingsRead");
    }

    private final void checkReadPermission(String requestedKey, int userId) {
        String key;
        int i;
        int callingUid = Binder.getCallingUid();
        for (i = 0; i < READ_CONTACTS_PROTECTED_SETTINGS.length; ++i) {
            key = READ_CONTACTS_PROTECTED_SETTINGS[i];
            if (!key.equals(requestedKey) || this.mContext.checkCallingOrSelfPermission("android.permission.READ_CONTACTS") == 0) continue;
            throw new SecurityException("uid=" + callingUid + " needs permission " + "android.permission.READ_CONTACTS" + " to read " + requestedKey + " for user " + userId);
        }
        for (i = 0; i < READ_PASSWORD_PROTECTED_SETTINGS.length; ++i) {
            key = READ_PASSWORD_PROTECTED_SETTINGS[i];
            if (!key.equals(requestedKey) || this.mContext.checkCallingOrSelfPermission(PERMISSION) == 0) continue;
            throw new SecurityException("uid=" + callingUid + " needs permission " + PERMISSION + " to read " + requestedKey + " for user " + userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSeparateProfileChallengeEnabled(int userId) throws RemoteException {
        this.checkReadPermission(SEPARATE_PROFILE_CHALLENGE_KEY, userId);
        Object object = this.mSeparateChallengeLock;
        synchronized (object) {
            return this.getBoolean(SEPARATE_PROFILE_CHALLENGE_KEY, false, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeparateProfileChallengeEnabled(int userId, boolean enabled, String managedUserPassword) throws RemoteException {
        this.checkWritePermission(userId);
        Object object = this.mSeparateChallengeLock;
        synchronized (object) {
            this.setBoolean(SEPARATE_PROFILE_CHALLENGE_KEY, enabled, userId);
            if (enabled) {
                this.mStorage.removeChildProfileLock(userId);
                this.removeKeystoreProfileKey(userId);
            } else {
                this.tieManagedProfileLockIfNecessary(userId, managedUserPassword);
            }
        }
    }

    @Override
    public void setBoolean(String key, boolean value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, value ? "1" : "0");
    }

    @Override
    public void setLong(String key, long value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, Long.toString(value));
    }

    @Override
    public void setString(String key, String value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, value);
    }

    private void setStringUnchecked(String key, int userId, String value) {
        this.mStorage.writeKeyValue(key, value, userId);
        if (ArrayUtils.contains(SETTINGS_TO_BACKUP, key)) {
            BackupManager.dataChanged("com.android.providers.settings");
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        String value = this.getStringUnchecked(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : value.equals("1") || value.equals("true");
    }

    @Override
    public long getLong(String key, long defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        String value = this.getStringUnchecked(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : Long.parseLong(value);
    }

    @Override
    public String getString(String key, String defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        return this.getStringUnchecked(key, defaultValue, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringUnchecked(String key, String defaultValue, int userId) {
        if ("lock_pattern_autolock".equals(key)) {
            long ident = Binder.clearCallingIdentity();
            try {
                String string2 = this.mLockPatternUtils.isLockPatternEnabled(userId) ? "1" : "0";
                return string2;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        if ("legacy_lock_pattern_enabled".equals(key)) {
            key = "lock_pattern_autolock";
        }
        return this.mStorage.readKeyValue(key, defaultValue, userId);
    }

    @Override
    public boolean havePassword(int userId) throws RemoteException {
        return this.mStorage.hasPassword(userId);
    }

    @Override
    public boolean havePattern(int userId) throws RemoteException {
        return this.mStorage.hasPattern(userId);
    }

    private void setKeystorePassword(String password, int userHandle) {
        android.security.KeyStore ks = android.security.KeyStore.getInstance();
        ks.onUserPasswordChanged(userHandle, password);
    }

    private void unlockKeystore(String password, int userHandle) {
        android.security.KeyStore ks = android.security.KeyStore.getInstance();
        ks.unlock(userHandle, password);
    }

    private String getDecryptedPasswordForTiedProfile(int userId) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, CertificateException, IOException {
        byte[] storedData = this.mStorage.readChildProfileLock(userId);
        if (storedData == null) {
            throw new FileNotFoundException("Child profile lock file not found");
        }
        byte[] iv = Arrays.copyOfRange(storedData, 0, 12);
        byte[] encryptedPassword = Arrays.copyOfRange(storedData, 12, storedData.length);
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        SecretKey decryptionKey = (SecretKey)keyStore.getKey("profile_key_name_decrypt_" + userId, null);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)decryptionKey, new GCMParameterSpec(128, iv));
        byte[] decryptionResult = cipher.doFinal(encryptedPassword);
        return new String(decryptionResult, StandardCharsets.UTF_8);
    }

    private void unlockChildProfile(int profileHandle) throws RemoteException {
        try {
            this.doVerifyPassword(this.getDecryptedPasswordForTiedProfile(profileHandle), false, 0L, profileHandle);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            if (e instanceof FileNotFoundException) {
                Slog.i(TAG, "Child profile key not found");
            }
            Slog.e(TAG, "Failed to decrypt child profile key", e);
        }
    }

    private void unlockUser(int userId, byte[] token, byte[] secret) {
        final CountDownLatch latch = new CountDownLatch(1);
        IProgressListener.Stub listener = new IProgressListener.Stub(){

            @Override
            public void onStarted(int id2, Bundle extras) throws RemoteException {
                Log.d(LockSettingsService.TAG, "unlockUser started");
            }

            @Override
            public void onProgress(int id2, int progress, Bundle extras) throws RemoteException {
                Log.d(LockSettingsService.TAG, "unlockUser progress " + progress);
            }

            @Override
            public void onFinished(int id2, Bundle extras) throws RemoteException {
                Log.d(LockSettingsService.TAG, "unlockUser finished");
                latch.countDown();
            }
        };
        try {
            ActivityManagerNative.getDefault().unlockUser(userId, token, secret, listener);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        try {
            latch.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            if (!this.mUserManager.getUserInfo(userId).isManagedProfile()) {
                List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
                for (UserInfo pi : profiles) {
                    if (!pi.isManagedProfile() || this.mLockPatternUtils.isSeparateProfileChallengeEnabled(pi.id) || !this.mStorage.hasChildProfileLock(pi.id)) continue;
                    this.unlockChildProfile(pi.id);
                }
            }
        }
        catch (RemoteException e) {
            Log.d(TAG, "Failed to unlock child profile", e);
        }
    }

    private byte[] getCurrentHandle(int userId) {
        byte[] currentHandle;
        int currentHandleType = this.mStorage.getStoredCredentialType(userId);
        switch (currentHandleType) {
            case 1: {
                LockSettingsStorage.CredentialHash credential = this.mStorage.readPatternHash(userId);
                currentHandle = credential != null ? credential.hash : null;
                break;
            }
            case 2: {
                LockSettingsStorage.CredentialHash credential = this.mStorage.readPasswordHash(userId);
                currentHandle = credential != null ? credential.hash : null;
                break;
            }
            default: {
                currentHandle = null;
            }
        }
        if (currentHandleType != -1 && currentHandle == null) {
            Slog.e(TAG, "Stored handle type [" + currentHandleType + "] but no handle available");
        }
        return currentHandle;
    }

    private void onUserLockChanged(int userId) throws RemoteException {
        if (this.mUserManager.getUserInfo(userId).isManagedProfile()) {
            return;
        }
        boolean isSecure = this.mStorage.hasPassword(userId) || this.mStorage.hasPattern(userId);
        List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
        int size = profiles.size();
        for (int i = 0; i < size; ++i) {
            int managedUserId;
            UserInfo profile = profiles.get(i);
            if (!profile.isManagedProfile() || this.mLockPatternUtils.isSeparateProfileChallengeEnabled(managedUserId = profile.id)) continue;
            if (isSecure) {
                this.tieManagedProfileLockIfNecessary(managedUserId, null);
                continue;
            }
            this.clearUserKeyProtection(managedUserId);
            this.getGateKeeperService().clearSecureUserId(managedUserId);
            this.mStorage.writePatternHash(null, managedUserId);
            this.setKeystorePassword(null, managedUserId);
            this.fixateNewestUserKeyAuth(managedUserId);
            this.mStorage.removeChildProfileLock(managedUserId);
            this.removeKeystoreProfileKey(managedUserId);
        }
    }

    private boolean isManagedProfileWithUnifiedLock(int userId) {
        return this.mUserManager.getUserInfo(userId).isManagedProfile() && !this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId);
    }

    private boolean isManagedProfileWithSeparatedLock(int userId) {
        return this.mUserManager.getUserInfo(userId).isManagedProfile() && this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockPattern(String pattern, String savedCredential, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        Object object = this.mSeparateChallengeLock;
        synchronized (object) {
            this.setLockPatternInternal(pattern, savedCredential, userId);
            this.setSeparateProfileChallengeEnabled(userId, true, null);
        }
    }

    private void setLockPatternInternal(String pattern, String savedCredential, int userId) throws RemoteException {
        byte[] enrolledHandle;
        byte[] currentHandle;
        block9: {
            currentHandle = this.getCurrentHandle(userId);
            if (pattern == null) {
                this.clearUserKeyProtection(userId);
                this.getGateKeeperService().clearSecureUserId(userId);
                this.mStorage.writePatternHash(null, userId);
                this.setKeystorePassword(null, userId);
                this.fixateNewestUserKeyAuth(userId);
                this.onUserLockChanged(userId);
                return;
            }
            if (this.isManagedProfileWithUnifiedLock(userId)) {
                try {
                    savedCredential = this.getDecryptedPasswordForTiedProfile(userId);
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    if (e instanceof FileNotFoundException) {
                        Slog.i(TAG, "Child profile key not found");
                        break block9;
                    }
                    Slog.e(TAG, "Failed to decrypt child profile key", e);
                }
            } else if (currentHandle == null) {
                if (savedCredential != null) {
                    Slog.w(TAG, "Saved credential provided, but none stored");
                }
                savedCredential = null;
            }
        }
        if ((enrolledHandle = this.enrollCredential(currentHandle, savedCredential, pattern, userId)) == null) {
            throw new RemoteException("Failed to enroll pattern");
        }
        LockSettingsStorage.CredentialHash willStore = new LockSettingsStorage.CredentialHash(enrolledHandle, 1);
        this.setUserKeyProtection(userId, pattern, this.doVerifyPattern(pattern, willStore, true, 0L, userId));
        this.mStorage.writePatternHash(enrolledHandle, userId);
        this.fixateNewestUserKeyAuth(userId);
        this.onUserLockChanged(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockPassword(String password, String savedCredential, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        Object object = this.mSeparateChallengeLock;
        synchronized (object) {
            this.setLockPasswordInternal(password, savedCredential, userId);
            this.setSeparateProfileChallengeEnabled(userId, true, null);
        }
    }

    private void setLockPasswordInternal(String password, String savedCredential, int userId) throws RemoteException {
        byte[] enrolledHandle;
        byte[] currentHandle = this.getCurrentHandle(userId);
        if (password == null) {
            this.clearUserKeyProtection(userId);
            this.getGateKeeperService().clearSecureUserId(userId);
            this.mStorage.writePasswordHash(null, userId);
            this.setKeystorePassword(null, userId);
            this.fixateNewestUserKeyAuth(userId);
            this.onUserLockChanged(userId);
            return;
        }
        if (this.isManagedProfileWithUnifiedLock(userId)) {
            try {
                savedCredential = this.getDecryptedPasswordForTiedProfile(userId);
            }
            catch (FileNotFoundException e) {
                Slog.i(TAG, "Child profile key not found");
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                Slog.e(TAG, "Failed to decrypt child profile key", e);
            }
        } else if (currentHandle == null) {
            if (savedCredential != null) {
                Slog.w(TAG, "Saved credential provided, but none stored");
            }
            savedCredential = null;
        }
        if ((enrolledHandle = this.enrollCredential(currentHandle, savedCredential, password, userId)) == null) {
            throw new RemoteException("Failed to enroll password");
        }
        LockSettingsStorage.CredentialHash willStore = new LockSettingsStorage.CredentialHash(enrolledHandle, 1);
        this.setUserKeyProtection(userId, password, this.doVerifyPassword(password, willStore, true, 0L, userId));
        this.mStorage.writePasswordHash(enrolledHandle, userId);
        this.fixateNewestUserKeyAuth(userId);
        this.onUserLockChanged(userId);
    }

    private void tieProfileLockToParent(int userId, String password) {
        byte[] iv;
        byte[] encryptionResult;
        byte[] randomLockSeed = password.getBytes(StandardCharsets.UTF_8);
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            keyStore.setEntry("profile_key_name_encrypt_" + userId, new KeyStore.SecretKeyEntry(secretKey), new KeyProtection.Builder(1).setBlockModes("GCM").setEncryptionPaddings("NoPadding").build());
            keyStore.setEntry("profile_key_name_decrypt_" + userId, new KeyStore.SecretKeyEntry(secretKey), new KeyProtection.Builder(2).setBlockModes("GCM").setEncryptionPaddings("NoPadding").setUserAuthenticationRequired(true).setUserAuthenticationValidityDurationSeconds(30).build());
            SecretKey keyStoreEncryptionKey = (SecretKey)keyStore.getKey("profile_key_name_encrypt_" + userId, null);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, keyStoreEncryptionKey);
            encryptionResult = cipher.doFinal(randomLockSeed);
            iv = cipher.getIV();
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("Failed to encrypt key", e);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (iv.length != 12) {
                throw new RuntimeException("Invalid iv length: " + iv.length);
            }
            outputStream.write(iv);
            outputStream.write(encryptionResult);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to concatenate byte arrays", e);
        }
        this.mStorage.writeChildProfileLock(userId, outputStream.toByteArray());
    }

    private byte[] enrollCredential(byte[] enrolledHandle, String enrolledCredential, String toEnroll, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        byte[] enrolledCredentialBytes = enrolledCredential == null ? null : enrolledCredential.getBytes();
        byte[] toEnrollBytes = toEnroll == null ? null : toEnroll.getBytes();
        GateKeeperResponse response = this.getGateKeeperService().enroll(userId, enrolledHandle, enrolledCredentialBytes, toEnrollBytes);
        if (response == null) {
            return null;
        }
        byte[] hash = response.getPayload();
        if (hash != null) {
            this.setKeystorePassword(toEnroll, userId);
        } else {
            Slog.e(TAG, "Throttled while enrolling a password");
        }
        return hash;
    }

    private void setUserKeyProtection(int userId, String credential, VerifyCredentialResponse vcr) throws RemoteException {
        if (vcr == null) {
            throw new RemoteException("Null response verifying a credential we just set");
        }
        if (vcr.getResponseCode() != 0) {
            throw new RemoteException("Non-OK response verifying a credential we just set: " + vcr.getResponseCode());
        }
        byte[] token = vcr.getPayload();
        if (token == null) {
            throw new RemoteException("Empty payload verifying a credential we just set");
        }
        this.addUserKeyAuth(userId, token, LockSettingsService.secretFromCredential(credential));
    }

    private void clearUserKeyProtection(int userId) throws RemoteException {
        this.addUserKeyAuth(userId, null, null);
    }

    private static byte[] secretFromCredential(String credential) throws RemoteException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] personalization = "Android FBE credential hash".getBytes(StandardCharsets.UTF_8);
            personalization = Arrays.copyOf(personalization, 128);
            digest.update(personalization);
            digest.update(credential.getBytes(StandardCharsets.UTF_8));
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithmException for SHA-512");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserKeyAuth(int userId, byte[] token, byte[] secret) throws RemoteException {
        UserInfo userInfo = UserManager.get(this.mContext).getUserInfo(userId);
        IMountService mountService = this.getMountService();
        long callingId = Binder.clearCallingIdentity();
        try {
            mountService.addUserKeyAuth(userId, userInfo.serialNumber, token, secret);
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixateNewestUserKeyAuth(int userId) throws RemoteException {
        IMountService mountService = this.getMountService();
        long callingId = Binder.clearCallingIdentity();
        try {
            mountService.fixateNewestUserKeyAuth(userId);
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetKeyStore(int userId) throws RemoteException {
        this.checkWritePermission(userId);
        int managedUserId = -1;
        String managedUserDecryptedPassword = null;
        List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
        for (UserInfo pi : profiles) {
            if (!pi.isManagedProfile() || this.mLockPatternUtils.isSeparateProfileChallengeEnabled(pi.id) || !this.mStorage.hasChildProfileLock(pi.id)) continue;
            try {
                if (managedUserId == -1) {
                    managedUserDecryptedPassword = this.getDecryptedPasswordForTiedProfile(pi.id);
                    managedUserId = pi.id;
                    continue;
                }
                Slog.e(TAG, "More than one managed profile, uid1:" + managedUserId + ", uid2:" + pi.id);
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                Slog.e(TAG, "Failed to decrypt child profile key", e);
            }
        }
        try {
            for (Object profileId : (Object)this.mUserManager.getProfileIdsWithDisabled(userId)) {
                for (int uid : SYSTEM_CREDENTIAL_UIDS) {
                    this.mKeyStore.clearUid(UserHandle.getUid((int)profileId, uid));
                }
            }
        }
        finally {
            if (managedUserId != -1 && managedUserDecryptedPassword != null) {
                this.tieProfileLockToParent(managedUserId, managedUserDecryptedPassword);
            }
        }
    }

    @Override
    public VerifyCredentialResponse checkPattern(String pattern, int userId) throws RemoteException {
        return this.doVerifyPattern(pattern, false, 0L, userId);
    }

    @Override
    public VerifyCredentialResponse verifyPattern(String pattern, long challenge, int userId) throws RemoteException {
        return this.doVerifyPattern(pattern, true, challenge, userId);
    }

    private VerifyCredentialResponse doVerifyPattern(String pattern, boolean hasChallenge, long challenge, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        LockSettingsStorage.CredentialHash storedHash = this.mStorage.readPatternHash(userId);
        return this.doVerifyPattern(pattern, storedHash, hasChallenge, challenge, userId);
    }

    private VerifyCredentialResponse doVerifyPattern(String pattern, LockSettingsStorage.CredentialHash storedHash, boolean hasChallenge, long challenge, int userId) throws RemoteException {
        boolean shouldReEnrollBaseZero = storedHash != null && storedHash.isBaseZeroPattern;
        String patternToVerify = shouldReEnrollBaseZero ? LockPatternUtils.patternStringToBaseZero(pattern) : pattern;
        VerifyCredentialResponse response = this.verifyCredential(userId, storedHash, patternToVerify, hasChallenge, challenge, new CredentialUtil(){

            @Override
            public void setCredential(String pattern, String oldPattern, int userId) throws RemoteException {
                LockSettingsService.this.setLockPatternInternal(pattern, oldPattern, userId);
            }

            @Override
            public byte[] toHash(String pattern, int userId) {
                return LockPatternUtils.patternToHash(LockPatternUtils.stringToPattern(pattern));
            }

            @Override
            public String adjustForKeystore(String pattern) {
                return LockPatternUtils.patternStringToBaseZero(pattern);
            }
        });
        if (response.getResponseCode() == 0 && shouldReEnrollBaseZero) {
            this.setLockPatternInternal(pattern, patternToVerify, userId);
        }
        return response;
    }

    @Override
    public VerifyCredentialResponse checkPassword(String password, int userId) throws RemoteException {
        return this.doVerifyPassword(password, false, 0L, userId);
    }

    @Override
    public VerifyCredentialResponse verifyPassword(String password, long challenge, int userId) throws RemoteException {
        return this.doVerifyPassword(password, true, challenge, userId);
    }

    @Override
    public VerifyCredentialResponse verifyTiedProfileChallenge(String password, boolean isPattern, long challenge, int userId) throws RemoteException {
        VerifyCredentialResponse parentResponse;
        this.checkPasswordReadPermission(userId);
        if (!this.isManagedProfileWithUnifiedLock(userId)) {
            throw new RemoteException("User id must be managed profile with unified lock");
        }
        int parentProfileId = this.mUserManager.getProfileParent((int)userId).id;
        VerifyCredentialResponse verifyCredentialResponse = parentResponse = isPattern ? this.doVerifyPattern(password, true, challenge, parentProfileId) : this.doVerifyPassword(password, true, challenge, parentProfileId);
        if (parentResponse.getResponseCode() != 0) {
            return parentResponse;
        }
        try {
            return this.doVerifyPassword(this.getDecryptedPasswordForTiedProfile(userId), true, challenge, userId);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            Slog.e(TAG, "Failed to decrypt child profile key", e);
            throw new RemoteException("Unable to get tied profile token");
        }
    }

    private VerifyCredentialResponse doVerifyPassword(String password, boolean hasChallenge, long challenge, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        LockSettingsStorage.CredentialHash storedHash = this.mStorage.readPasswordHash(userId);
        return this.doVerifyPassword(password, storedHash, hasChallenge, challenge, userId);
    }

    private VerifyCredentialResponse doVerifyPassword(String password, LockSettingsStorage.CredentialHash storedHash, boolean hasChallenge, long challenge, int userId) throws RemoteException {
        return this.verifyCredential(userId, storedHash, password, hasChallenge, challenge, new CredentialUtil(){

            @Override
            public void setCredential(String password, String oldPassword, int userId) throws RemoteException {
                LockSettingsService.this.setLockPasswordInternal(password, oldPassword, userId);
            }

            @Override
            public byte[] toHash(String password, int userId) {
                return LockSettingsService.this.mLockPatternUtils.passwordToHash(password, userId);
            }

            @Override
            public String adjustForKeystore(String password) {
                return password;
            }
        });
    }

    private VerifyCredentialResponse verifyCredential(int userId, LockSettingsStorage.CredentialHash storedHash, String credential, boolean hasChallenge, long challenge, CredentialUtil credentialUtil) throws RemoteException {
        VerifyCredentialResponse response;
        if ((storedHash == null || storedHash.hash.length == 0) && TextUtils.isEmpty(credential)) {
            return VerifyCredentialResponse.OK;
        }
        if (TextUtils.isEmpty(credential)) {
            return VerifyCredentialResponse.ERROR;
        }
        if (storedHash.version == 0) {
            byte[] hash = credentialUtil.toHash(credential, userId);
            if (Arrays.equals(hash, storedHash.hash)) {
                this.unlockKeystore(credentialUtil.adjustForKeystore(credential), userId);
                Slog.i(TAG, "Unlocking user with fake token: " + userId);
                byte[] fakeToken = String.valueOf(userId).getBytes();
                this.unlockUser(userId, fakeToken, fakeToken);
                credentialUtil.setCredential(credential, null, userId);
                if (!hasChallenge) {
                    return VerifyCredentialResponse.OK;
                }
            } else {
                return VerifyCredentialResponse.ERROR;
            }
        }
        boolean shouldReEnroll = false;
        GateKeeperResponse gateKeeperResponse = this.getGateKeeperService().verifyChallenge(userId, challenge, storedHash.hash, credential.getBytes());
        int responseCode = gateKeeperResponse.getResponseCode();
        if (responseCode == 1) {
            response = new VerifyCredentialResponse(gateKeeperResponse.getTimeout());
        } else if (responseCode == 0) {
            byte[] token = gateKeeperResponse.getPayload();
            if (token == null) {
                Slog.e(TAG, "verifyChallenge response had no associated payload");
                response = VerifyCredentialResponse.ERROR;
            } else {
                shouldReEnroll = gateKeeperResponse.getShouldReEnroll();
                response = new VerifyCredentialResponse(token);
            }
        } else {
            response = VerifyCredentialResponse.ERROR;
        }
        if (response.getResponseCode() == 0) {
            this.unlockKeystore(credential, userId);
            Slog.i(TAG, "Unlocking user " + userId + " with token length " + response.getPayload().length);
            this.unlockUser(userId, response.getPayload(), LockSettingsService.secretFromCredential(credential));
            if (this.isManagedProfileWithSeparatedLock(userId)) {
                TrustManager trustManager = (TrustManager)this.mContext.getSystemService("trust");
                trustManager.setDeviceLockedForUser(userId, false);
            }
            if (shouldReEnroll) {
                credentialUtil.setCredential(credential, credential, userId);
            }
        } else if (response.getResponseCode() == 1 && response.getTimeout() > 0) {
            this.requireStrongAuth(8, userId);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkVoldPassword(int userId) throws RemoteException {
        String password;
        if (!this.mFirstCallToVold) {
            return false;
        }
        this.mFirstCallToVold = false;
        this.checkPasswordReadPermission(userId);
        IMountService service = this.getMountService();
        long identity = Binder.clearCallingIdentity();
        try {
            password = service.getPassword();
            service.clearPassword();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (password == null) {
            return false;
        }
        try {
            if (this.mLockPatternUtils.isLockPatternEnabled(userId) && this.checkPattern(password, userId).getResponseCode() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.mLockPatternUtils.isLockPasswordEnabled(userId) && this.checkPassword(password, userId).getResponseCode() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void removeUser(int userId, boolean unknownUser) {
        this.mStorage.removeUser(userId);
        this.mStrongAuth.removeUser(userId);
        android.security.KeyStore ks = android.security.KeyStore.getInstance();
        ks.onUserRemoved(userId);
        try {
            IGateKeeperService gk = this.getGateKeeperService();
            if (gk != null) {
                gk.clearSecureUserId(userId);
            }
        }
        catch (RemoteException ex) {
            Slog.w(TAG, "unable to clear GK secure user id");
        }
        if (unknownUser || this.mUserManager.getUserInfo(userId).isManagedProfile()) {
            this.removeKeystoreProfileKey(userId);
        }
    }

    private void removeKeystoreProfileKey(int targetUserId) {
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            keyStore.deleteEntry("profile_key_name_encrypt_" + targetUserId);
            keyStore.deleteEntry("profile_key_name_decrypt_" + targetUserId);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Slog.e(TAG, "Unable to remove keystore profile key for user:" + targetUserId, e);
        }
    }

    @Override
    public void registerStrongAuthTracker(IStrongAuthTracker tracker) {
        this.checkPasswordReadPermission(-1);
        this.mStrongAuth.registerStrongAuthTracker(tracker);
    }

    @Override
    public void unregisterStrongAuthTracker(IStrongAuthTracker tracker) {
        this.checkPasswordReadPermission(-1);
        this.mStrongAuth.unregisterStrongAuthTracker(tracker);
    }

    @Override
    public void requireStrongAuth(int strongAuthReason, int userId) {
        this.checkWritePermission(userId);
        this.mStrongAuth.requireStrongAuth(strongAuthReason, userId);
    }

    @Override
    public void userPresent(int userId) {
        this.checkWritePermission(userId);
        this.mStrongAuth.reportUnlock(userId);
    }

    @Override
    public int getStrongAuthForUser(int userId) {
        this.checkPasswordReadPermission(userId);
        return this.mStrongAuthTracker.getStrongAuthForUser(userId);
    }

    private IMountService getMountService() {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IMountService.Stub.asInterface(service);
        }
        return null;
    }

    private synchronized IGateKeeperService getGateKeeperService() throws RemoteException {
        if (this.mGateKeeperService != null) {
            return this.mGateKeeperService;
        }
        IBinder service = ServiceManager.getService("android.service.gatekeeper.IGateKeeperService");
        if (service != null) {
            service.linkToDeath(new GateKeeperDiedRecipient(), 0);
            this.mGateKeeperService = IGateKeeperService.Stub.asInterface(service);
            return this.mGateKeeperService;
        }
        Slog.e(TAG, "Unable to acquire GateKeeperService");
        return null;
    }

    static {
        SYSTEM_CREDENTIAL_UIDS = new int[]{1010, 1016, 0, 1000};
        ACTION_NULL = new Intent("android.intent.action.MAIN");
        ACTION_NULL.addCategory("android.intent.category.HOME");
        VALID_SETTINGS = new String[]{"lockscreen.lockedoutpermanently", "lockscreen.lockoutattemptdeadline", "lockscreen.patterneverchosen", "lockscreen.password_type", "lockscreen.password_type_alternate", "lockscreen.password_salt", "lockscreen.disabled", "lockscreen.options", "lockscreen.biometric_weak_fallback", "lockscreen.biometricweakeverchosen", "lockscreen.power_button_instantly_locks", "lockscreen.passwordhistory", "lock_pattern_autolock", "lock_biometric_weak_flags", "lock_pattern_visible_pattern", "lock_pattern_tactile_feedback_enabled"};
        READ_CONTACTS_PROTECTED_SETTINGS = new String[]{"lock_screen_owner_info_enabled", "lock_screen_owner_info"};
        READ_PASSWORD_PROTECTED_SETTINGS = new String[]{"lockscreen.password_salt", "lockscreen.passwordhistory", "lockscreen.password_type", SEPARATE_PROFILE_CHALLENGE_KEY};
        SETTINGS_TO_BACKUP = new String[]{"lock_screen_owner_info_enabled", "lock_screen_owner_info"};
    }

    private class GateKeeperDiedRecipient
    implements IBinder.DeathRecipient {
        private GateKeeperDiedRecipient() {
        }

        @Override
        public void binderDied() {
            LockSettingsService.this.mGateKeeperService.asBinder().unlinkToDeath(this, 0);
            LockSettingsService.this.mGateKeeperService = null;
        }
    }

    private class SynchronizedStrongAuthTracker
    extends LockPatternUtils.StrongAuthTracker {
        public SynchronizedStrongAuthTracker(Context context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleStrongAuthRequiredChanged(int strongAuthFlags, int userId) {
            SynchronizedStrongAuthTracker synchronizedStrongAuthTracker = this;
            synchronized (synchronizedStrongAuthTracker) {
                super.handleStrongAuthRequiredChanged(strongAuthFlags, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getStrongAuthForUser(int userId) {
            SynchronizedStrongAuthTracker synchronizedStrongAuthTracker = this;
            synchronized (synchronizedStrongAuthTracker) {
                return super.getStrongAuthForUser(userId);
            }
        }

        void register() {
            LockSettingsService.this.mStrongAuth.registerStrongAuthTracker(this.mStub);
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private LockSettingsService mLockSettingsService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            AndroidKeyStoreProvider.install();
            this.mLockSettingsService = new LockSettingsService(this.getContext());
            this.publishBinderService("lock_settings", this.mLockSettingsService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mLockSettingsService.maybeShowEncryptionNotifications();
            } else if (phase == 1000) {
                // empty if block
            }
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mLockSettingsService.onUnlockUser(userHandle);
        }

        @Override
        public void onCleanupUser(int userHandle) {
            this.mLockSettingsService.onCleanupUser(userHandle);
        }
    }

    private static interface CredentialUtil {
        public void setCredential(String var1, String var2, int var3) throws RemoteException;

        public byte[] toHash(String var1, int var2);

        public String adjustForKeystore(String var1);
    }
}

