/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class LockGuard {
    private static final String TAG = "LockGuard";
    private static ArrayMap<Object, LockInfo> sKnown = new ArrayMap(0, true);

    private static LockInfo findOrCreateLockInfo(Object lock) {
        LockInfo info = sKnown.get(lock);
        if (info == null) {
            info = new LockInfo();
            info.label = "0x" + Integer.toHexString(System.identityHashCode(lock)) + " [" + new Throwable().getStackTrace()[2].toString() + "]";
            sKnown.put(lock, info);
        }
        return info;
    }

    public static Object guard(Object lock) {
        int i;
        if (lock == null || Thread.holdsLock(lock)) {
            return lock;
        }
        boolean triggered = false;
        LockInfo info = LockGuard.findOrCreateLockInfo(lock);
        for (i = 0; i < info.children.size(); ++i) {
            Object child = info.children.valueAt(i);
            if (child == null || !Thread.holdsLock(child)) continue;
            Slog.w(TAG, "Calling thread " + Thread.currentThread().getName() + " is holding " + LockGuard.lockToString(child) + " while trying to acquire " + LockGuard.lockToString(lock), new Throwable());
            triggered = true;
        }
        if (!triggered) {
            for (i = 0; i < sKnown.size(); ++i) {
                Object test = sKnown.keyAt(i);
                if (test == null || test == lock || !Thread.holdsLock(test)) continue;
                LockGuard.sKnown.valueAt((int)i).children.add(lock);
            }
        }
        return lock;
    }

    public static void installLock(Object lock, String label) {
        LockInfo info = LockGuard.findOrCreateLockInfo(lock);
        info.label = label;
    }

    private static String lockToString(Object lock) {
        LockInfo info = sKnown.get(lock);
        if (info != null) {
            return info.label;
        }
        return "0x" + Integer.toHexString(System.identityHashCode(lock));
    }

    public static void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        for (int i = 0; i < sKnown.size(); ++i) {
            Object lock = sKnown.keyAt(i);
            LockInfo info = sKnown.valueAt(i);
            pw.println("Lock " + LockGuard.lockToString(lock) + ":");
            for (int j = 0; j < info.children.size(); ++j) {
                pw.println("  Child " + LockGuard.lockToString(info.children.valueAt(j)));
            }
            pw.println();
        }
    }

    private static class LockInfo {
        public String label;
        public ArraySet<Object> children = new ArraySet(0, true);

        private LockInfo() {
        }
    }
}

