/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.location.ActivityRecognitionHardware;
import android.location.Address;
import android.location.Criteria;
import android.location.GeocoderParams;
import android.location.Geofence;
import android.location.IGnssMeasurementsListener;
import android.location.IGnssNavigationMessageListener;
import android.location.IGnssStatusListener;
import android.location.IGnssStatusProvider;
import android.location.IGpsGeofenceHardware;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.INetInitiatedListener;
import android.location.Location;
import android.location.LocationProvider;
import android.location.LocationRequest;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.Log;
import android.util.Slog;
import com.android.internal.content.PackageMonitor;
import com.android.internal.location.ProviderProperties;
import com.android.internal.location.ProviderRequest;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ArrayUtils;
import com.android.server.LocalServices;
import com.android.server.ServiceWatcher;
import com.android.server.location.ActivityRecognitionProxy;
import com.android.server.location.FlpHardwareProvider;
import com.android.server.location.FusedProxy;
import com.android.server.location.GeocoderProxy;
import com.android.server.location.GeofenceManager;
import com.android.server.location.GeofenceProxy;
import com.android.server.location.GnssLocationProvider;
import com.android.server.location.GnssMeasurementsProvider;
import com.android.server.location.GnssNavigationMessageProvider;
import com.android.server.location.LocationBlacklist;
import com.android.server.location.LocationFudger;
import com.android.server.location.LocationProviderInterface;
import com.android.server.location.LocationProviderProxy;
import com.android.server.location.LocationRequestStatistics;
import com.android.server.location.MockProvider;
import com.android.server.location.PassiveProvider;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocationManagerService
extends ILocationManager.Stub {
    private static final String TAG = "LocationManagerService";
    public static final boolean D = Log.isLoggable("LocationManagerService", 3);
    private static final String WAKELOCK_KEY = "LocationManagerService";
    private static final int RESOLUTION_LEVEL_NONE = 0;
    private static final int RESOLUTION_LEVEL_COARSE = 1;
    private static final int RESOLUTION_LEVEL_FINE = 2;
    private static final String ACCESS_MOCK_LOCATION = "android.permission.ACCESS_MOCK_LOCATION";
    private static final String ACCESS_LOCATION_EXTRA_COMMANDS = "android.permission.ACCESS_LOCATION_EXTRA_COMMANDS";
    private static final String INSTALL_LOCATION_PROVIDER = "android.permission.INSTALL_LOCATION_PROVIDER";
    private static final String NETWORK_LOCATION_SERVICE_ACTION = "com.android.location.service.v3.NetworkLocationProvider";
    private static final String FUSED_LOCATION_SERVICE_ACTION = "com.android.location.service.FusedLocationProvider";
    private static final int MSG_LOCATION_CHANGED = 1;
    private static final long NANOS_PER_MILLI = 1000000L;
    private static final long HIGH_POWER_INTERVAL_MS = 300000L;
    private static final int MAX_PROVIDER_SCHEDULING_JITTER_MS = 100;
    private static final LocationRequest DEFAULT_LOCATION_REQUEST = new LocationRequest();
    private final Context mContext;
    private final AppOpsManager mAppOps;
    private final Object mLock = new Object();
    private LocationFudger mLocationFudger;
    private GeofenceManager mGeofenceManager;
    private PackageManager mPackageManager;
    private PowerManager mPowerManager;
    private UserManager mUserManager;
    private GeocoderProxy mGeocodeProvider;
    private IGnssStatusProvider mGnssStatusProvider;
    private INetInitiatedListener mNetInitiatedListener;
    private LocationWorkerHandler mLocationHandler;
    private PassiveProvider mPassiveProvider;
    private LocationBlacklist mBlacklist;
    private GnssMeasurementsProvider mGnssMeasurementsProvider;
    private GnssNavigationMessageProvider mGnssNavigationMessageProvider;
    private IGpsGeofenceHardware mGpsGeofenceProxy;
    private final Set<String> mEnabledProviders = new HashSet<String>();
    private final Set<String> mDisabledProviders = new HashSet<String>();
    private final HashMap<String, MockProvider> mMockProviders = new HashMap();
    private final HashMap<Object, Receiver> mReceivers = new HashMap();
    private final ArrayList<LocationProviderInterface> mProviders = new ArrayList();
    private final HashMap<String, LocationProviderInterface> mRealProviders = new HashMap();
    private final HashMap<String, LocationProviderInterface> mProvidersByName = new HashMap();
    private final HashMap<String, ArrayList<UpdateRecord>> mRecordsByProvider = new HashMap();
    private final LocationRequestStatistics mRequestStatistics = new LocationRequestStatistics();
    private final HashMap<String, Location> mLastLocation = new HashMap();
    private final HashMap<String, Location> mLastLocationCoarseInterval = new HashMap();
    private final ArrayList<LocationProviderProxy> mProxyProviders = new ArrayList();
    private int mCurrentUserId = 0;
    private int[] mCurrentUserProfiles = new int[]{0};
    private GnssLocationProvider.GnssSystemInfoProvider mGnssSystemInfoProvider;
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageDisappeared(String packageName, int reason) {
            Object object = LocationManagerService.this.mLock;
            synchronized (object) {
                ArrayList<Receiver> deadReceivers = null;
                for (Receiver receiver : LocationManagerService.this.mReceivers.values()) {
                    if (!receiver.mPackageName.equals(packageName)) continue;
                    if (deadReceivers == null) {
                        deadReceivers = new ArrayList<Receiver>();
                    }
                    deadReceivers.add(receiver);
                }
                if (deadReceivers != null) {
                    for (Receiver receiver : deadReceivers) {
                        LocationManagerService.this.removeUpdatesLocked(receiver);
                    }
                }
            }
        }
    };

    public LocationManagerService(Context context) {
        this.mContext = context;
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        packageManagerInternal.setLocationPackagesProvider(new PackageManagerInternal.PackagesProvider(){

            @Override
            public String[] getPackages(int userId) {
                return LocationManagerService.this.mContext.getResources().getStringArray(17236012);
            }
        });
        if (D) {
            Log.d("LocationManagerService", "Constructed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemRunning() {
        Object object = this.mLock;
        synchronized (object) {
            if (D) {
                Log.d("LocationManagerService", "systemReady()");
            }
            this.mPackageManager = this.mContext.getPackageManager();
            this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
            this.mLocationHandler = new LocationWorkerHandler(BackgroundThread.get().getLooper());
            this.mLocationFudger = new LocationFudger(this.mContext, this.mLocationHandler);
            this.mBlacklist = new LocationBlacklist(this.mContext, this.mLocationHandler);
            this.mBlacklist.init();
            this.mGeofenceManager = new GeofenceManager(this.mContext, this.mBlacklist);
            AppOpsManager.OnOpChangedInternalListener callback = new AppOpsManager.OnOpChangedInternalListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onOpChanged(int op, String packageName) {
                    Object object = LocationManagerService.this.mLock;
                    synchronized (object) {
                        for (Receiver receiver : LocationManagerService.this.mReceivers.values()) {
                            receiver.updateMonitoring(true);
                        }
                        LocationManagerService.this.applyAllProviderRequirementsLocked();
                    }
                }
            };
            this.mAppOps.startWatchingMode(0, null, (AppOpsManager.OnOpChangedListener)callback);
            PackageManager.OnPermissionsChangedListener permissionListener = new PackageManager.OnPermissionsChangedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onPermissionsChanged(int uid) {
                    Object object = LocationManagerService.this.mLock;
                    synchronized (object) {
                        LocationManagerService.this.applyAllProviderRequirementsLocked();
                    }
                }
            };
            this.mPackageManager.addOnPermissionsChangeListener(permissionListener);
            this.mUserManager = (UserManager)this.mContext.getSystemService("user");
            this.updateUserProfiles(this.mCurrentUserId);
            this.loadProvidersLocked();
            this.updateProvidersLocked();
        }
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("location_providers_allowed"), true, new ContentObserver(this.mLocationHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationManagerService.this.updateProvidersLocked();
                }
            }
        }, -1);
        this.mPackageMonitor.register(this.mContext, this.mLocationHandler.getLooper(), true);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        intentFilter.addAction("android.intent.action.MANAGED_PROFILE_REMOVED");
        intentFilter.addAction("android.intent.action.ACTION_SHUTDOWN");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    LocationManagerService.this.switchUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.MANAGED_PROFILE_ADDED".equals(action) || "android.intent.action.MANAGED_PROFILE_REMOVED".equals(action)) {
                    LocationManagerService.this.updateUserProfiles(LocationManagerService.this.mCurrentUserId);
                } else if ("android.intent.action.ACTION_SHUTDOWN".equals(action)) {
                    LocationManagerService.this.shutdownComponents();
                }
            }
        }, UserHandle.ALL, intentFilter, null, this.mLocationHandler);
    }

    private void shutdownComponents() {
        LocationProviderInterface gpsProvider;
        if (D) {
            Log.d("LocationManagerService", "Shutting down components...");
        }
        if ((gpsProvider = this.mProvidersByName.get("gps")) != null && gpsProvider.isEnabled()) {
            gpsProvider.disable();
        }
        if (FlpHardwareProvider.isSupported()) {
            FlpHardwareProvider flpHardwareProvider = FlpHardwareProvider.getInstance(this.mContext);
            flpHardwareProvider.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUserProfiles(int currentUserId) {
        int[] profileIds = this.mUserManager.getProfileIdsWithDisabled(currentUserId);
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentUserProfiles = profileIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentProfile(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return ArrayUtils.contains(this.mCurrentUserProfiles, userId);
        }
    }

    private void ensureFallbackFusedProviderPresentLocked(ArrayList<String> pkgs) {
        PackageManager pm = this.mContext.getPackageManager();
        String systemPackageName = this.mContext.getPackageName();
        ArrayList<HashSet<Signature>> sigSets = ServiceWatcher.getSignatureSets(this.mContext, pkgs);
        List<ResolveInfo> rInfos = pm.queryIntentServicesAsUser(new Intent(FUSED_LOCATION_SERVICE_ACTION), 128, this.mCurrentUserId);
        for (ResolveInfo rInfo : rInfos) {
            String packageName;
            block9: {
                packageName = rInfo.serviceInfo.packageName;
                try {
                    PackageInfo pInfo = pm.getPackageInfo(packageName, 64);
                    if (!ServiceWatcher.isSignatureMatch(pInfo.signatures, sigSets)) {
                        Log.w("LocationManagerService", packageName + " resolves service " + FUSED_LOCATION_SERVICE_ACTION + ", but has wrong signature, ignoring");
                    }
                    break block9;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e("LocationManagerService", "missing package: " + packageName);
                }
                continue;
            }
            if (rInfo.serviceInfo.metaData == null) {
                Log.w("LocationManagerService", "Found fused provider without metadata: " + packageName);
                continue;
            }
            int version = rInfo.serviceInfo.metaData.getInt("serviceVersion", -1);
            if (version == 0) {
                if ((rInfo.serviceInfo.applicationInfo.flags & 1) == 0) {
                    if (!D) continue;
                    Log.d("LocationManagerService", "Fallback candidate not in /system: " + packageName);
                    continue;
                }
                if (pm.checkSignatures(systemPackageName, packageName) != 0) {
                    if (!D) continue;
                    Log.d("LocationManagerService", "Fallback candidate not signed the same as system: " + packageName);
                    continue;
                }
                if (D) {
                    Log.d("LocationManagerService", "Found fallback provider: " + packageName);
                }
                return;
            }
            if (!D) continue;
            Log.d("LocationManagerService", "Fallback candidate not version 0: " + packageName);
        }
        throw new IllegalStateException("Unable to find a fused location provider that is in the system partition with version 0 and signed with the platform certificate. Such a package is needed to provide a default fused location provider in the event that no other fused location provider has been installed or is currently available. For example, coreOnly boot mode when decrypting the data partition. The fallback must also be marked coreApp=\"true\" in the manifest");
    }

    private void loadProvidersLocked() {
        String[] testProviderStrings;
        FlpHardwareProvider flpHardwareProvider;
        PassiveProvider passiveProvider = new PassiveProvider(this);
        this.addProviderLocked(passiveProvider);
        this.mEnabledProviders.add(passiveProvider.getName());
        this.mPassiveProvider = passiveProvider;
        if (GnssLocationProvider.isSupported()) {
            GnssLocationProvider gnssProvider = new GnssLocationProvider(this.mContext, this, this.mLocationHandler.getLooper());
            this.mGnssSystemInfoProvider = gnssProvider.getGnssSystemInfoProvider();
            this.mGnssStatusProvider = gnssProvider.getGnssStatusProvider();
            this.mNetInitiatedListener = gnssProvider.getNetInitiatedListener();
            this.addProviderLocked(gnssProvider);
            this.mRealProviders.put("gps", gnssProvider);
            this.mGnssMeasurementsProvider = gnssProvider.getGnssMeasurementsProvider();
            this.mGnssNavigationMessageProvider = gnssProvider.getGnssNavigationMessageProvider();
            this.mGpsGeofenceProxy = gnssProvider.getGpsGeofenceProxy();
        }
        Resources resources = this.mContext.getResources();
        ArrayList<String> providerPackageNames = new ArrayList<String>();
        Object[] pkgs = resources.getStringArray(17236012);
        if (D) {
            Log.d("LocationManagerService", "certificates for location providers pulled from: " + Arrays.toString(pkgs));
        }
        if (pkgs != null) {
            providerPackageNames.addAll(Arrays.asList(pkgs));
        }
        this.ensureFallbackFusedProviderPresentLocked(providerPackageNames);
        LocationProviderProxy networkProvider = LocationProviderProxy.createAndBind(this.mContext, "network", NETWORK_LOCATION_SERVICE_ACTION, 17956942, 17039423, 17236012, this.mLocationHandler);
        if (networkProvider != null) {
            this.mRealProviders.put("network", networkProvider);
            this.mProxyProviders.add(networkProvider);
            this.addProviderLocked(networkProvider);
        } else {
            Slog.w("LocationManagerService", "no network location provider found");
        }
        LocationProviderProxy fusedLocationProvider = LocationProviderProxy.createAndBind(this.mContext, "fused", FUSED_LOCATION_SERVICE_ACTION, 17956943, 0x1040040, 17236012, this.mLocationHandler);
        if (fusedLocationProvider != null) {
            this.addProviderLocked(fusedLocationProvider);
            this.mProxyProviders.add(fusedLocationProvider);
            this.mEnabledProviders.add(fusedLocationProvider.getName());
            this.mRealProviders.put("fused", fusedLocationProvider);
        } else {
            Slog.e("LocationManagerService", "no fused location provider found", new IllegalStateException("Location service needs a fused location provider"));
        }
        this.mGeocodeProvider = GeocoderProxy.createAndBind(this.mContext, 17956945, 17039426, 17236012, this.mLocationHandler);
        if (this.mGeocodeProvider == null) {
            Slog.e("LocationManagerService", "no geocoder provider found");
        }
        if (FlpHardwareProvider.isSupported()) {
            flpHardwareProvider = FlpHardwareProvider.getInstance(this.mContext);
            FusedProxy fusedProxy = FusedProxy.createAndBind(this.mContext, this.mLocationHandler, flpHardwareProvider.getLocationHardware(), 17956944, 0x1040041, 17236012);
            if (fusedProxy == null) {
                Slog.d("LocationManagerService", "Unable to bind FusedProxy.");
            }
        } else {
            flpHardwareProvider = null;
            Slog.d("LocationManagerService", "FLP HAL not supported");
        }
        GeofenceProxy provider = GeofenceProxy.createAndBind(this.mContext, 17956946, 17039427, 17236012, this.mLocationHandler, this.mGpsGeofenceProxy, flpHardwareProvider != null ? flpHardwareProvider.getGeofenceHardware() : null);
        if (provider == null) {
            Slog.d("LocationManagerService", "Unable to bind FLP Geofence proxy.");
        }
        boolean activityRecognitionHardwareIsSupported = ActivityRecognitionHardware.isSupported();
        ActivityRecognitionHardware activityRecognitionHardware = null;
        if (activityRecognitionHardwareIsSupported) {
            activityRecognitionHardware = ActivityRecognitionHardware.getInstance(this.mContext);
        } else {
            Slog.d("LocationManagerService", "Hardware Activity-Recognition not supported.");
        }
        ActivityRecognitionProxy proxy = ActivityRecognitionProxy.createAndBind(this.mContext, this.mLocationHandler, activityRecognitionHardwareIsSupported, activityRecognitionHardware, 17956947, 0x1040044, 17236012);
        if (proxy == null) {
            Slog.d("LocationManagerService", "Unable to bind ActivityRecognitionProxy.");
        }
        for (String testProviderString : testProviderStrings = resources.getStringArray(17236013)) {
            String[] fragments = testProviderString.split(",");
            String name = fragments[0].trim();
            if (this.mProvidersByName.get(name) != null) {
                throw new IllegalArgumentException("Provider \"" + name + "\" already exists");
            }
            ProviderProperties properties = new ProviderProperties(Boolean.parseBoolean(fragments[1]), Boolean.parseBoolean(fragments[2]), Boolean.parseBoolean(fragments[3]), Boolean.parseBoolean(fragments[4]), Boolean.parseBoolean(fragments[5]), Boolean.parseBoolean(fragments[6]), Boolean.parseBoolean(fragments[7]), Integer.parseInt(fragments[8]), Integer.parseInt(fragments[9]));
            this.addTestProviderLocked(name, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchUser(int userId) {
        if (this.mCurrentUserId == userId) {
            return;
        }
        this.mBlacklist.switchUser(userId);
        this.mLocationHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            this.mLastLocation.clear();
            this.mLastLocationCoarseInterval.clear();
            for (LocationProviderInterface p : this.mProviders) {
                this.updateProviderListenersLocked(p.getName(), false);
            }
            this.mCurrentUserId = userId;
            this.updateUserProfiles(userId);
            this.updateProvidersLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locationCallbackFinished(ILocationListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            IBinder binder = listener.asBinder();
            Receiver receiver = this.mReceivers.get(binder);
            if (receiver != null) {
                Receiver receiver2 = receiver;
                synchronized (receiver2) {
                    long identity = Binder.clearCallingIdentity();
                    receiver.decrementPendingBroadcastsLocked();
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    @Override
    public int getGnssYearOfHardware() {
        if (this.mGnssNavigationMessageProvider != null) {
            return this.mGnssSystemInfoProvider.getGnssYearOfHardware();
        }
        return 0;
    }

    private void addProviderLocked(LocationProviderInterface provider) {
        this.mProviders.add(provider);
        this.mProvidersByName.put(provider.getName(), provider);
    }

    private void removeProviderLocked(LocationProviderInterface provider) {
        provider.disable();
        this.mProviders.remove(provider);
        this.mProvidersByName.remove(provider.getName());
    }

    private boolean isAllowedByCurrentUserSettingsLocked(String provider) {
        if (this.mEnabledProviders.contains(provider)) {
            return true;
        }
        if (this.mDisabledProviders.contains(provider)) {
            return false;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        return Settings.Secure.isLocationProviderEnabledForUser(resolver, provider, this.mCurrentUserId);
    }

    private boolean isAllowedByUserSettingsLocked(String provider, int uid) {
        if (!this.isCurrentProfile(UserHandle.getUserId(uid)) && !this.isUidALocationProvider(uid)) {
            return false;
        }
        return this.isAllowedByCurrentUserSettingsLocked(provider);
    }

    private String getResolutionPermission(int resolutionLevel) {
        switch (resolutionLevel) {
            case 2: {
                return "android.permission.ACCESS_FINE_LOCATION";
            }
            case 1: {
                return "android.permission.ACCESS_COARSE_LOCATION";
            }
        }
        return null;
    }

    private int getAllowedResolutionLevel(int pid, int uid) {
        if (this.mContext.checkPermission("android.permission.ACCESS_FINE_LOCATION", pid, uid) == 0) {
            return 2;
        }
        if (this.mContext.checkPermission("android.permission.ACCESS_COARSE_LOCATION", pid, uid) == 0) {
            return 1;
        }
        return 0;
    }

    private int getCallerAllowedResolutionLevel() {
        return this.getAllowedResolutionLevel(Binder.getCallingPid(), Binder.getCallingUid());
    }

    private void checkResolutionLevelIsSufficientForGeofenceUse(int allowedResolutionLevel) {
        if (allowedResolutionLevel < 2) {
            throw new SecurityException("Geofence usage requires ACCESS_FINE_LOCATION permission");
        }
    }

    private int getMinimumResolutionLevelForProviderUse(String provider) {
        ProviderProperties properties;
        if ("gps".equals(provider) || "passive".equals(provider)) {
            return 2;
        }
        if ("network".equals(provider) || "fused".equals(provider)) {
            return 1;
        }
        LocationProviderInterface lp = this.mMockProviders.get(provider);
        if (lp != null && (properties = lp.getProperties()) != null) {
            if (properties.mRequiresSatellite) {
                return 2;
            }
            if (properties.mRequiresNetwork || properties.mRequiresCell) {
                return 1;
            }
        }
        return 2;
    }

    private void checkResolutionLevelIsSufficientForProviderUse(int allowedResolutionLevel, String providerName) {
        int requiredResolutionLevel = this.getMinimumResolutionLevelForProviderUse(providerName);
        if (allowedResolutionLevel < requiredResolutionLevel) {
            switch (requiredResolutionLevel) {
                case 2: {
                    throw new SecurityException("\"" + providerName + "\" location provider requires ACCESS_FINE_LOCATION permission.");
                }
                case 1: {
                    throw new SecurityException("\"" + providerName + "\" location provider requires ACCESS_COARSE_LOCATION or ACCESS_FINE_LOCATION permission.");
                }
            }
            throw new SecurityException("Insufficient permission for \"" + providerName + "\" location provider.");
        }
    }

    private void checkDeviceStatsAllowed() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", null);
    }

    private void checkUpdateAppOpsAllowed() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_APP_OPS_STATS", null);
    }

    public static int resolutionLevelToOp(int allowedResolutionLevel) {
        if (allowedResolutionLevel != 0) {
            if (allowedResolutionLevel == 1) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    boolean reportLocationAccessNoThrow(int pid, int uid, String packageName, int allowedResolutionLevel) {
        int op = LocationManagerService.resolutionLevelToOp(allowedResolutionLevel);
        if (op >= 0 && this.mAppOps.noteOpNoThrow(op, uid, packageName) != 0) {
            return false;
        }
        return this.getAllowedResolutionLevel(pid, uid) >= allowedResolutionLevel;
    }

    boolean checkLocationAccess(int pid, int uid, String packageName, int allowedResolutionLevel) {
        int op = LocationManagerService.resolutionLevelToOp(allowedResolutionLevel);
        if (op >= 0 && this.mAppOps.checkOp(op, uid, packageName) != 0) {
            return false;
        }
        return this.getAllowedResolutionLevel(pid, uid) >= allowedResolutionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllProviders() {
        ArrayList<String> out;
        Object object = this.mLock;
        synchronized (object) {
            out = new ArrayList<String>(this.mProviders.size());
            for (LocationProviderInterface provider : this.mProviders) {
                String name = provider.getName();
                if ("fused".equals(name)) continue;
                out.add(name);
            }
        }
        if (D) {
            Log.d("LocationManagerService", "getAllProviders()=" + out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getProviders(Criteria criteria, boolean enabledOnly) {
        ArrayList<String> out;
        int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
        int uid = Binder.getCallingUid();
        long identity = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                out = new ArrayList<String>(this.mProviders.size());
                for (LocationProviderInterface provider : this.mProviders) {
                    String name = provider.getName();
                    if ("fused".equals(name) || allowedResolutionLevel < this.getMinimumResolutionLevelForProviderUse(name) || enabledOnly && !this.isAllowedByUserSettingsLocked(name, uid) || criteria != null && !LocationProvider.propertiesMeetCriteria(name, provider.getProperties(), criteria)) continue;
                    out.add(name);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (D) {
            Log.d("LocationManagerService", "getProviders()=" + out);
        }
        return out;
    }

    @Override
    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        String result = null;
        List<String> providers = this.getProviders(criteria, enabledOnly);
        if (!providers.isEmpty()) {
            result = this.pickBest(providers);
            if (D) {
                Log.d("LocationManagerService", "getBestProvider(" + criteria + ", " + enabledOnly + ")=" + result);
            }
            return result;
        }
        providers = this.getProviders(null, enabledOnly);
        if (!providers.isEmpty()) {
            result = this.pickBest(providers);
            if (D) {
                Log.d("LocationManagerService", "getBestProvider(" + criteria + ", " + enabledOnly + ")=" + result);
            }
            return result;
        }
        if (D) {
            Log.d("LocationManagerService", "getBestProvider(" + criteria + ", " + enabledOnly + ")=" + result);
        }
        return null;
    }

    private String pickBest(List<String> providers) {
        if (providers.contains("gps")) {
            return "gps";
        }
        if (providers.contains("network")) {
            return "network";
        }
        return providers.get(0);
    }

    @Override
    public boolean providerMeetsCriteria(String provider, Criteria criteria) {
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            throw new IllegalArgumentException("provider=" + provider);
        }
        boolean result = LocationProvider.propertiesMeetCriteria(p.getName(), p.getProperties(), criteria);
        if (D) {
            Log.d("LocationManagerService", "providerMeetsCriteria(" + provider + ", " + criteria + ")=" + result);
        }
        return result;
    }

    private void updateProvidersLocked() {
        boolean changesMade = false;
        for (int i = this.mProviders.size() - 1; i >= 0; --i) {
            LocationProviderInterface p = this.mProviders.get(i);
            boolean isEnabled = p.isEnabled();
            String name = p.getName();
            boolean shouldBeEnabled = this.isAllowedByCurrentUserSettingsLocked(name);
            if (isEnabled && !shouldBeEnabled) {
                this.updateProviderListenersLocked(name, false);
                this.mLastLocation.clear();
                this.mLastLocationCoarseInterval.clear();
                changesMade = true;
                continue;
            }
            if (isEnabled || !shouldBeEnabled) continue;
            this.updateProviderListenersLocked(name, true);
            changesMade = true;
        }
        if (changesMade) {
            this.mContext.sendBroadcastAsUser(new Intent("android.location.PROVIDERS_CHANGED"), UserHandle.ALL);
            this.mContext.sendBroadcastAsUser(new Intent("android.location.MODE_CHANGED"), UserHandle.ALL);
        }
    }

    private void updateProviderListenersLocked(String provider, boolean enabled) {
        int listeners = 0;
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            return;
        }
        ArrayList<Receiver> deadReceivers = null;
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider);
        if (records != null) {
            int N = records.size();
            for (int i = 0; i < N; ++i) {
                UpdateRecord record = records.get(i);
                if (!this.isCurrentProfile(UserHandle.getUserId(record.mReceiver.mUid))) continue;
                if (!record.mReceiver.callProviderEnabledLocked(provider, enabled)) {
                    if (deadReceivers == null) {
                        deadReceivers = new ArrayList<Receiver>();
                    }
                    deadReceivers.add(record.mReceiver);
                }
                ++listeners;
            }
        }
        if (deadReceivers != null) {
            for (int i = deadReceivers.size() - 1; i >= 0; --i) {
                this.removeUpdatesLocked((Receiver)deadReceivers.get(i));
            }
        }
        if (enabled) {
            p.enable();
            if (listeners > 0) {
                this.applyRequirementsLocked(provider);
            }
        } else {
            p.disable();
        }
    }

    private void applyRequirementsLocked(String provider) {
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            return;
        }
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider);
        WorkSource worksource = new WorkSource();
        ProviderRequest providerRequest = new ProviderRequest();
        if (records != null) {
            for (UpdateRecord record : records) {
                if (!this.isCurrentProfile(UserHandle.getUserId(record.mReceiver.mUid)) || !this.checkLocationAccess(record.mReceiver.mPid, record.mReceiver.mUid, record.mReceiver.mPackageName, record.mReceiver.mAllowedResolutionLevel)) continue;
                LocationRequest locationRequest = record.mRequest;
                providerRequest.locationRequests.add(locationRequest);
                if (locationRequest.getInterval() >= providerRequest.interval) continue;
                providerRequest.reportLocation = true;
                providerRequest.interval = locationRequest.getInterval();
            }
            if (providerRequest.reportLocation) {
                long thresholdInterval = (providerRequest.interval + 1000L) * 3L / 2L;
                for (UpdateRecord record : records) {
                    LocationRequest locationRequest;
                    if (!this.isCurrentProfile(UserHandle.getUserId(record.mReceiver.mUid)) || !providerRequest.locationRequests.contains(locationRequest = record.mRequest) || locationRequest.getInterval() > thresholdInterval) continue;
                    if (record.mReceiver.mWorkSource != null && record.mReceiver.mWorkSource.size() > 0 && record.mReceiver.mWorkSource.getName(0) != null) {
                        worksource.add(record.mReceiver.mWorkSource);
                        continue;
                    }
                    worksource.add(record.mReceiver.mUid, record.mReceiver.mPackageName);
                }
            }
        }
        if (D) {
            Log.d("LocationManagerService", "provider request: " + provider + " " + providerRequest);
        }
        p.setRequest(providerRequest, worksource);
    }

    private Receiver getReceiverLocked(ILocationListener listener, int pid, int uid, String packageName, WorkSource workSource, boolean hideFromAppOps) {
        IBinder binder = listener.asBinder();
        Receiver receiver = this.mReceivers.get(binder);
        if (receiver == null) {
            receiver = new Receiver(listener, null, pid, uid, packageName, workSource, hideFromAppOps);
            try {
                receiver.getListener().asBinder().linkToDeath(receiver, 0);
            }
            catch (RemoteException e) {
                Slog.e("LocationManagerService", "linkToDeath failed:", e);
                return null;
            }
            this.mReceivers.put(binder, receiver);
        }
        return receiver;
    }

    private Receiver getReceiverLocked(PendingIntent intent, int pid, int uid, String packageName, WorkSource workSource, boolean hideFromAppOps) {
        Receiver receiver = this.mReceivers.get(intent);
        if (receiver == null) {
            receiver = new Receiver(null, intent, pid, uid, packageName, workSource, hideFromAppOps);
            this.mReceivers.put(intent, receiver);
        }
        return receiver;
    }

    private LocationRequest createSanitizedRequest(LocationRequest request, int resolutionLevel) {
        LocationRequest sanitizedRequest = new LocationRequest(request);
        if (resolutionLevel < 2) {
            switch (sanitizedRequest.getQuality()) {
                case 100: {
                    sanitizedRequest.setQuality(102);
                    break;
                }
                case 203: {
                    sanitizedRequest.setQuality(201);
                }
            }
            if (sanitizedRequest.getInterval() < 600000L) {
                sanitizedRequest.setInterval(600000L);
            }
            if (sanitizedRequest.getFastestInterval() < 600000L) {
                sanitizedRequest.setFastestInterval(600000L);
            }
        }
        if (sanitizedRequest.getFastestInterval() > sanitizedRequest.getInterval()) {
            request.setFastestInterval(request.getInterval());
        }
        return sanitizedRequest;
    }

    private void checkPackageName(String packageName) {
        if (packageName == null) {
            throw new SecurityException("invalid package name: " + packageName);
        }
        int uid = Binder.getCallingUid();
        String[] packages = this.mPackageManager.getPackagesForUid(uid);
        if (packages == null) {
            throw new SecurityException("invalid UID " + uid);
        }
        for (String pkg : packages) {
            if (!packageName.equals(pkg)) continue;
            return;
        }
        throw new SecurityException("invalid package name: " + packageName);
    }

    private void checkPendingIntent(PendingIntent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("invalid pending intent: " + intent);
        }
    }

    private Receiver checkListenerOrIntentLocked(ILocationListener listener, PendingIntent intent, int pid, int uid, String packageName, WorkSource workSource, boolean hideFromAppOps) {
        if (intent == null && listener == null) {
            throw new IllegalArgumentException("need either listener or intent");
        }
        if (intent != null && listener != null) {
            throw new IllegalArgumentException("cannot register both listener and intent");
        }
        if (intent != null) {
            this.checkPendingIntent(intent);
            return this.getReceiverLocked(intent, pid, uid, packageName, workSource, hideFromAppOps);
        }
        return this.getReceiverLocked(listener, pid, uid, packageName, workSource, hideFromAppOps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestLocationUpdates(LocationRequest request, ILocationListener listener, PendingIntent intent, String packageName) {
        boolean hideFromAppOps;
        if (request == null) {
            request = DEFAULT_LOCATION_REQUEST;
        }
        this.checkPackageName(packageName);
        int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
        this.checkResolutionLevelIsSufficientForProviderUse(allowedResolutionLevel, request.getProvider());
        WorkSource workSource = request.getWorkSource();
        if (workSource != null && workSource.size() > 0) {
            this.checkDeviceStatsAllowed();
        }
        if (hideFromAppOps = request.getHideFromAppOps()) {
            this.checkUpdateAppOpsAllowed();
        }
        LocationRequest sanitizedRequest = this.createSanitizedRequest(request, allowedResolutionLevel);
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long identity = Binder.clearCallingIdentity();
        try {
            this.checkLocationAccess(pid, uid, packageName, allowedResolutionLevel);
            Object object = this.mLock;
            synchronized (object) {
                Receiver recevier = this.checkListenerOrIntentLocked(listener, intent, pid, uid, packageName, workSource, hideFromAppOps);
                this.requestLocationUpdatesLocked(sanitizedRequest, recevier, pid, uid, packageName);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void requestLocationUpdatesLocked(LocationRequest request, Receiver receiver, int pid, int uid, String packageName) {
        boolean isProviderEnabled;
        LocationProviderInterface provider;
        String name;
        if (request == null) {
            request = DEFAULT_LOCATION_REQUEST;
        }
        if ((name = request.getProvider()) == null) {
            throw new IllegalArgumentException("provider name must not be null");
        }
        if (D) {
            Log.d("LocationManagerService", "request " + Integer.toHexString(System.identityHashCode(receiver)) + " " + name + " " + request + " from " + packageName + "(" + uid + ")");
        }
        if ((provider = this.mProvidersByName.get(name)) == null) {
            throw new IllegalArgumentException("provider doesn't exist: " + name);
        }
        UpdateRecord record = new UpdateRecord(name, request, receiver);
        UpdateRecord oldRecord = receiver.mUpdateRecords.put(name, record);
        if (oldRecord != null) {
            oldRecord.disposeLocked(false);
        }
        if (isProviderEnabled = this.isAllowedByUserSettingsLocked(name, uid)) {
            this.applyRequirementsLocked(name);
        } else {
            receiver.callProviderEnabledLocked(name, false);
        }
        receiver.updateMonitoring(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdates(ILocationListener listener, PendingIntent intent, String packageName) {
        this.checkPackageName(packageName);
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        Object object = this.mLock;
        synchronized (object) {
            WorkSource workSource = null;
            boolean hideFromAppOps = false;
            Receiver receiver = this.checkListenerOrIntentLocked(listener, intent, pid, uid, packageName, workSource, hideFromAppOps);
            long identity = Binder.clearCallingIdentity();
            try {
                this.removeUpdatesLocked(receiver);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUpdatesLocked(Receiver receiver) {
        if (D) {
            Log.i("LocationManagerService", "remove " + Integer.toHexString(System.identityHashCode(receiver)));
        }
        if (this.mReceivers.remove(receiver.mKey) != null && receiver.isListener()) {
            receiver.getListener().asBinder().unlinkToDeath(receiver, 0);
            Receiver receiver2 = receiver;
            synchronized (receiver2) {
                receiver.clearPendingBroadcastsLocked();
            }
        }
        receiver.updateMonitoring(false);
        HashSet<String> providers = new HashSet<String>();
        HashMap<String, UpdateRecord> oldRecords = receiver.mUpdateRecords;
        if (oldRecords != null) {
            for (UpdateRecord record : oldRecords.values()) {
                record.disposeLocked(false);
            }
            providers.addAll(oldRecords.keySet());
        }
        for (String provider : providers) {
            if (!this.isAllowedByCurrentUserSettingsLocked(provider)) continue;
            this.applyRequirementsLocked(provider);
        }
    }

    private void applyAllProviderRequirementsLocked() {
        for (LocationProviderInterface p : this.mProviders) {
            if (!this.isAllowedByCurrentUserSettingsLocked(p.getName())) continue;
            this.applyRequirementsLocked(p.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Location getLastLocation(LocationRequest request, String packageName) {
        String name;
        Object object;
        long identity;
        int uid;
        int allowedResolutionLevel;
        block24: {
            LocationProviderInterface provider;
            block23: {
                int pid;
                block22: {
                    if (D) {
                        Log.d("LocationManagerService", "getLastLocation: " + request);
                    }
                    if (request == null) {
                        request = DEFAULT_LOCATION_REQUEST;
                    }
                    allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
                    this.checkPackageName(packageName);
                    this.checkResolutionLevelIsSufficientForProviderUse(allowedResolutionLevel, request.getProvider());
                    pid = Binder.getCallingPid();
                    uid = Binder.getCallingUid();
                    identity = Binder.clearCallingIdentity();
                    if (!this.mBlacklist.isBlacklisted(packageName)) break block22;
                    if (D) {
                        Log.d("LocationManagerService", "not returning last loc for blacklisted app: " + packageName);
                    }
                    Location location = null;
                    Binder.restoreCallingIdentity(identity);
                    return location;
                }
                if (this.reportLocationAccessNoThrow(pid, uid, packageName, allowedResolutionLevel)) break block23;
                if (D) {
                    Log.d("LocationManagerService", "not returning last loc for no op app: " + packageName);
                }
                Location location = null;
                Binder.restoreCallingIdentity(identity);
                return location;
            }
            object = this.mLock;
            // MONITORENTER : object
            name = request.getProvider();
            if (name == null) {
                name = "fused";
            }
            if ((provider = this.mProvidersByName.get(name)) != null) break block24;
            Location location = null;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(identity);
            return location;
        }
        if (!this.isAllowedByUserSettingsLocked(name, uid)) {
            Location location = null;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(identity);
            return location;
        }
        Location location = allowedResolutionLevel < 2 ? this.mLastLocationCoarseInterval.get(name) : this.mLastLocation.get(name);
        if (location == null) {
            Location location2 = null;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(identity);
            return location2;
        }
        if (allowedResolutionLevel >= 2) {
            Location location3 = new Location(location);
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(identity);
            return location3;
        }
        Location noGPSLocation = location.getExtraLocation("noGPSLocation");
        if (noGPSLocation != null) {
            Location location4 = new Location(this.mLocationFudger.getOrCreate(noGPSLocation));
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(identity);
            return location4;
        }
        try {
            // MONITOREXIT : object
            object = null;
            return object;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestGeofence(LocationRequest request, Geofence geofence, PendingIntent intent, String packageName) {
        int uid;
        if (request == null) {
            request = DEFAULT_LOCATION_REQUEST;
        }
        int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
        this.checkResolutionLevelIsSufficientForGeofenceUse(allowedResolutionLevel);
        this.checkPendingIntent(intent);
        this.checkPackageName(packageName);
        this.checkResolutionLevelIsSufficientForProviderUse(allowedResolutionLevel, request.getProvider());
        LocationRequest sanitizedRequest = this.createSanitizedRequest(request, allowedResolutionLevel);
        if (D) {
            Log.d("LocationManagerService", "requestGeofence: " + sanitizedRequest + " " + geofence + " " + intent);
        }
        if (UserHandle.getUserId(uid = Binder.getCallingUid()) != 0) {
            Log.w("LocationManagerService", "proximity alerts are currently available only to the primary user");
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mGeofenceManager.addFence(sanitizedRequest, geofence, intent, allowedResolutionLevel, uid, packageName);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGeofence(Geofence geofence, PendingIntent intent, String packageName) {
        this.checkPendingIntent(intent);
        this.checkPackageName(packageName);
        if (D) {
            Log.d("LocationManagerService", "removeGeofence: " + geofence + " " + intent);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mGeofenceManager.removeFence(geofence, intent);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerGnssStatusCallback(IGnssStatusListener callback, String packageName) {
        int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
        this.checkResolutionLevelIsSufficientForProviderUse(allowedResolutionLevel, "gps");
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        try {
            if (!this.checkLocationAccess(pid, uid, packageName, allowedResolutionLevel)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        if (this.mGnssStatusProvider == null) {
            return false;
        }
        try {
            this.mGnssStatusProvider.registerGnssStatusCallback(callback);
        }
        catch (RemoteException e) {
            Slog.e("LocationManagerService", "mGpsStatusProvider.registerGnssStatusCallback failed", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterGnssStatusCallback(IGnssStatusListener callback) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mGnssStatusProvider.unregisterGnssStatusCallback(callback);
            }
            catch (Exception e) {
                Slog.e("LocationManagerService", "mGpsStatusProvider.unregisterGnssStatusCallback failed", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addGnssMeasurementsListener(IGnssMeasurementsListener listener, String packageName) {
        boolean hasLocationAccess;
        int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
        this.checkResolutionLevelIsSufficientForProviderUse(allowedResolutionLevel, "gps");
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long identity = Binder.clearCallingIdentity();
        try {
            hasLocationAccess = this.checkLocationAccess(pid, uid, packageName, allowedResolutionLevel);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (!hasLocationAccess || this.mGnssMeasurementsProvider == null) {
            return false;
        }
        return this.mGnssMeasurementsProvider.addListener(listener);
    }

    @Override
    public void removeGnssMeasurementsListener(IGnssMeasurementsListener listener) {
        if (this.mGnssMeasurementsProvider != null) {
            this.mGnssMeasurementsProvider.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addGnssNavigationMessageListener(IGnssNavigationMessageListener listener, String packageName) {
        boolean hasLocationAccess;
        int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
        this.checkResolutionLevelIsSufficientForProviderUse(allowedResolutionLevel, "gps");
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long identity = Binder.clearCallingIdentity();
        try {
            hasLocationAccess = this.checkLocationAccess(pid, uid, packageName, allowedResolutionLevel);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (!hasLocationAccess || this.mGnssNavigationMessageProvider == null) {
            return false;
        }
        return this.mGnssNavigationMessageProvider.addListener(listener);
    }

    @Override
    public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener listener) {
        if (this.mGnssNavigationMessageProvider != null) {
            this.mGnssNavigationMessageProvider.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendExtraCommand(String provider, String command, Bundle extras) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.checkResolutionLevelIsSufficientForProviderUse(this.getCallerAllowedResolutionLevel(), provider);
        if (this.mContext.checkCallingOrSelfPermission(ACCESS_LOCATION_EXTRA_COMMANDS) != 0) {
            throw new SecurityException("Requires ACCESS_LOCATION_EXTRA_COMMANDS permission");
        }
        Object object = this.mLock;
        synchronized (object) {
            LocationProviderInterface p = this.mProvidersByName.get(provider);
            if (p == null) {
                return false;
            }
            return p.sendExtraCommand(command, extras);
        }
    }

    @Override
    public boolean sendNiResponse(int notifId, int userResponse) {
        if (Binder.getCallingUid() != Process.myUid()) {
            throw new SecurityException("calling sendNiResponse from outside of the system is not allowed");
        }
        try {
            return this.mNetInitiatedListener.sendNiResponse(notifId, userResponse);
        }
        catch (RemoteException e) {
            Slog.e("LocationManagerService", "RemoteException in LocationManagerService.sendNiResponse");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderProperties getProviderProperties(String provider) {
        LocationProviderInterface p;
        if (this.mProvidersByName.get(provider) == null) {
            return null;
        }
        this.checkResolutionLevelIsSufficientForProviderUse(this.getCallerAllowedResolutionLevel(), provider);
        Object object = this.mLock;
        synchronized (object) {
            p = this.mProvidersByName.get(provider);
        }
        if (p == null) {
            return null;
        }
        return p.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNetworkProviderPackage() {
        LocationProviderInterface p;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProvidersByName.get("network") == null) {
                return null;
            }
            p = this.mProvidersByName.get("network");
        }
        if (p instanceof LocationProviderProxy) {
            return ((LocationProviderProxy)p).getConnectedPackageName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean isProviderEnabled(String provider) {
        long identity;
        int uid;
        block7: {
            boolean bl;
            if ("fused".equals(provider)) {
                return false;
            }
            uid = Binder.getCallingUid();
            identity = Binder.clearCallingIdentity();
            try {
                Object object = this.mLock;
                // MONITORENTER : object
                LocationProviderInterface p = this.mProvidersByName.get(provider);
                if (p != null) break block7;
                bl = false;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
            return bl;
        }
        boolean bl = this.isAllowedByUserSettingsLocked(provider, uid);
        // MONITOREXIT : object
        Binder.restoreCallingIdentity(identity);
        return bl;
    }

    private boolean isUidALocationProvider(int uid) {
        if (uid == 1000) {
            return true;
        }
        if (this.mGeocodeProvider != null && this.doesUidHavePackage(uid, this.mGeocodeProvider.getConnectedPackageName())) {
            return true;
        }
        for (LocationProviderProxy proxy : this.mProxyProviders) {
            if (!this.doesUidHavePackage(uid, proxy.getConnectedPackageName())) continue;
            return true;
        }
        return false;
    }

    private void checkCallerIsProvider() {
        if (this.mContext.checkCallingOrSelfPermission(INSTALL_LOCATION_PROVIDER) == 0) {
            return;
        }
        if (this.isUidALocationProvider(Binder.getCallingUid())) {
            return;
        }
        throw new SecurityException("need INSTALL_LOCATION_PROVIDER permission, or UID of a currently bound location provider");
    }

    private boolean doesUidHavePackage(int uid, String packageName) {
        if (packageName == null) {
            return false;
        }
        String[] packageNames = this.mPackageManager.getPackagesForUid(uid);
        if (packageNames == null) {
            return false;
        }
        for (String name : packageNames) {
            if (!packageName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reportLocation(Location location, boolean passive) {
        this.checkCallerIsProvider();
        if (!location.isComplete()) {
            Log.w("LocationManagerService", "Dropping incomplete location: " + location);
            return;
        }
        this.mLocationHandler.removeMessages(1, location);
        Message m = Message.obtain(this.mLocationHandler, 1, location);
        m.arg1 = passive ? 1 : 0;
        this.mLocationHandler.sendMessageAtFrontOfQueue(m);
    }

    private static boolean shouldBroadcastSafe(Location loc, Location lastLoc, UpdateRecord record, long now) {
        if (lastLoc == null) {
            return true;
        }
        long minTime = record.mRequest.getFastestInterval();
        long delta = (loc.getElapsedRealtimeNanos() - lastLoc.getElapsedRealtimeNanos()) / 1000000L;
        if (delta < minTime - 100L) {
            return false;
        }
        double minDistance = record.mRequest.getSmallestDisplacement();
        if (minDistance > 0.0 && (double)loc.distanceTo(lastLoc) <= minDistance) {
            return false;
        }
        if (record.mRequest.getNumUpdates() <= 0) {
            return false;
        }
        return record.mRequest.getExpireAt() >= now;
    }

    private void handleLocationChangedLocked(Location location, boolean passive) {
        long timeDiffNanos;
        if (D) {
            Log.d("LocationManagerService", "incoming location: " + location);
        }
        long now = SystemClock.elapsedRealtime();
        String provider = passive ? "passive" : location.getProvider();
        LocationProviderInterface p = this.mProvidersByName.get(provider);
        if (p == null) {
            return;
        }
        Location noGPSLocation = location.getExtraLocation("noGPSLocation");
        Location lastNoGPSLocation = null;
        Location lastLocation = this.mLastLocation.get(provider);
        if (lastLocation == null) {
            lastLocation = new Location(provider);
            this.mLastLocation.put(provider, lastLocation);
        } else {
            lastNoGPSLocation = lastLocation.getExtraLocation("noGPSLocation");
            if (noGPSLocation == null && lastNoGPSLocation != null) {
                location.setExtraLocation("noGPSLocation", lastNoGPSLocation);
            }
        }
        lastLocation.set(location);
        Location lastLocationCoarseInterval = this.mLastLocationCoarseInterval.get(provider);
        if (lastLocationCoarseInterval == null) {
            lastLocationCoarseInterval = new Location(location);
            this.mLastLocationCoarseInterval.put(provider, lastLocationCoarseInterval);
        }
        if ((timeDiffNanos = location.getElapsedRealtimeNanos() - lastLocationCoarseInterval.getElapsedRealtimeNanos()) > 600000000000L) {
            lastLocationCoarseInterval.set(location);
        }
        noGPSLocation = lastLocationCoarseInterval.getExtraLocation("noGPSLocation");
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider);
        if (records == null || records.size() == 0) {
            return;
        }
        Location coarseLocation = null;
        if (noGPSLocation != null) {
            coarseLocation = this.mLocationFudger.getOrCreate(noGPSLocation);
        }
        long newStatusUpdateTime = p.getStatusUpdateTime();
        Bundle extras = new Bundle();
        int status = p.getStatus(extras);
        ArrayList<Receiver> deadReceivers = null;
        ArrayList<UpdateRecord> deadUpdateRecords = null;
        for (UpdateRecord r : records) {
            long prevStatusUpdateTime;
            Location lastLoc;
            Receiver receiver = r.mReceiver;
            boolean receiverDead = false;
            int receiverUserId = UserHandle.getUserId(receiver.mUid);
            if (!this.isCurrentProfile(receiverUserId) && !this.isUidALocationProvider(receiver.mUid)) {
                if (!D) continue;
                Log.d("LocationManagerService", "skipping loc update for background user " + receiverUserId + " (current user: " + this.mCurrentUserId + ", app: " + receiver.mPackageName + ")");
                continue;
            }
            if (this.mBlacklist.isBlacklisted(receiver.mPackageName)) {
                if (!D) continue;
                Log.d("LocationManagerService", "skipping loc update for blacklisted app: " + receiver.mPackageName);
                continue;
            }
            if (!this.reportLocationAccessNoThrow(receiver.mPid, receiver.mUid, receiver.mPackageName, receiver.mAllowedResolutionLevel)) {
                if (!D) continue;
                Log.d("LocationManagerService", "skipping loc update for no op app: " + receiver.mPackageName);
                continue;
            }
            Location notifyLocation = null;
            notifyLocation = receiver.mAllowedResolutionLevel < 2 ? coarseLocation : lastLocation;
            if (notifyLocation != null && ((lastLoc = r.mLastFixBroadcast) == null || LocationManagerService.shouldBroadcastSafe(notifyLocation, lastLoc, r, now))) {
                if (lastLoc == null) {
                    r.mLastFixBroadcast = lastLoc = new Location(notifyLocation);
                } else {
                    lastLoc.set(notifyLocation);
                }
                if (!receiver.callLocationChangedLocked(notifyLocation)) {
                    Slog.w("LocationManagerService", "RemoteException calling onLocationChanged on " + receiver);
                    receiverDead = true;
                }
                r.mRequest.decrementNumUpdates();
            }
            if (newStatusUpdateTime > (prevStatusUpdateTime = r.mLastStatusBroadcast) && (prevStatusUpdateTime != 0L || status != 2)) {
                r.mLastStatusBroadcast = newStatusUpdateTime;
                if (!receiver.callStatusChangedLocked(provider, status, extras)) {
                    receiverDead = true;
                    Slog.w("LocationManagerService", "RemoteException calling onStatusChanged on " + receiver);
                }
            }
            if (r.mRequest.getNumUpdates() <= 0 || r.mRequest.getExpireAt() < now) {
                if (deadUpdateRecords == null) {
                    deadUpdateRecords = new ArrayList<UpdateRecord>();
                }
                deadUpdateRecords.add(r);
            }
            if (!receiverDead) continue;
            if (deadReceivers == null) {
                deadReceivers = new ArrayList<Receiver>();
            }
            if (deadReceivers.contains(receiver)) continue;
            deadReceivers.add(receiver);
        }
        if (deadReceivers != null) {
            for (Receiver receiver : deadReceivers) {
                this.removeUpdatesLocked(receiver);
            }
        }
        if (deadUpdateRecords != null) {
            for (UpdateRecord r : deadUpdateRecords) {
                r.disposeLocked(true);
            }
            this.applyRequirementsLocked(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMockProvider(String provider) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMockProviders.containsKey(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLocationChanged(Location location, boolean passive) {
        Location myLocation = new Location(location);
        String provider = myLocation.getProvider();
        if (!myLocation.isFromMockProvider() && this.isMockProvider(provider)) {
            myLocation.setIsFromMockProvider(true);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isAllowedByCurrentUserSettingsLocked(provider)) {
                if (!passive) {
                    this.mPassiveProvider.updateLocation(myLocation);
                }
                this.handleLocationChangedLocked(myLocation, passive);
            }
        }
    }

    @Override
    public boolean geocoderIsPresent() {
        return this.mGeocodeProvider != null;
    }

    @Override
    public String getFromLocation(double latitude, double longitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        if (this.mGeocodeProvider != null) {
            return this.mGeocodeProvider.getFromLocation(latitude, longitude, maxResults, params, addrs);
        }
        return null;
    }

    @Override
    public String getFromLocationName(String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        if (this.mGeocodeProvider != null) {
            return this.mGeocodeProvider.getFromLocationName(locationName, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, maxResults, params, addrs);
        }
        return null;
    }

    private boolean canCallerAccessMockLocation(String opPackageName) {
        return this.mAppOps.noteOp(58, Binder.getCallingUid(), opPackageName) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTestProvider(String name, ProviderProperties properties, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        if ("passive".equals(name)) {
            throw new IllegalArgumentException("Cannot mock the passive location provider");
        }
        long identity = Binder.clearCallingIdentity();
        Object object = this.mLock;
        synchronized (object) {
            LocationProviderInterface p;
            if (("gps".equals(name) || "network".equals(name) || "fused".equals(name)) && (p = this.mProvidersByName.get(name)) != null) {
                this.removeProviderLocked(p);
            }
            this.addTestProviderLocked(name, properties);
            this.updateProvidersLocked();
        }
        Binder.restoreCallingIdentity(identity);
    }

    private void addTestProviderLocked(String name, ProviderProperties properties) {
        if (this.mProvidersByName.get(name) != null) {
            throw new IllegalArgumentException("Provider \"" + name + "\" already exists");
        }
        MockProvider provider = new MockProvider(name, this, properties);
        this.addProviderLocked(provider);
        this.mMockProviders.put(name, provider);
        this.mLastLocation.put(name, null);
        this.mLastLocationCoarseInterval.put(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTestProvider(String provider, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.clearTestProviderEnabled(provider, opPackageName);
            this.clearTestProviderLocation(provider, opPackageName);
            this.clearTestProviderStatus(provider, opPackageName);
            MockProvider mockProvider = this.mMockProviders.remove(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            long identity = Binder.clearCallingIdentity();
            this.removeProviderLocked(this.mProvidersByName.get(provider));
            LocationProviderInterface realProvider = this.mRealProviders.get(provider);
            if (realProvider != null) {
                this.addProviderLocked(realProvider);
            }
            this.mLastLocation.put(provider, null);
            this.mLastLocationCoarseInterval.put(provider, null);
            this.updateProvidersLocked();
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTestProviderLocation(String provider, Location loc, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            long identity = Binder.clearCallingIdentity();
            mockProvider.setLocation(loc);
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTestProviderLocation(String provider, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            mockProvider.clearLocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTestProviderEnabled(String provider, boolean enabled, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            long identity = Binder.clearCallingIdentity();
            if (enabled) {
                mockProvider.enable();
                this.mEnabledProviders.add(provider);
                this.mDisabledProviders.remove(provider);
            } else {
                mockProvider.disable();
                this.mEnabledProviders.remove(provider);
                this.mDisabledProviders.add(provider);
            }
            this.updateProvidersLocked();
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTestProviderEnabled(String provider, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            long identity = Binder.clearCallingIdentity();
            this.mEnabledProviders.remove(provider);
            this.mDisabledProviders.remove(provider);
            this.updateProvidersLocked();
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTestProviderStatus(String provider, int status, Bundle extras, long updateTime, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            mockProvider.setStatus(status, extras, updateTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTestProviderStatus(String provider, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            MockProvider mockProvider = this.mMockProviders.get(provider);
            if (mockProvider == null) {
                throw new IllegalArgumentException("Provider \"" + provider + "\" unknown");
            }
            mockProvider.clearStatus();
        }
    }

    private void log(String log) {
        if (Log.isLoggable("LocationManagerService", 2)) {
            Slog.d("LocationManagerService", log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump LocationManagerService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            Location location;
            String provider;
            pw.println("Current Location Manager state:");
            pw.println("  Location Listeners:");
            for (Receiver receiver : this.mReceivers.values()) {
                pw.println("    " + receiver);
            }
            pw.println("  Active Records by Provider:");
            for (Map.Entry entry : this.mRecordsByProvider.entrySet()) {
                pw.println("    " + (String)entry.getKey() + ":");
                for (UpdateRecord record : (ArrayList)entry.getValue()) {
                    pw.println("      " + record);
                }
            }
            pw.println("  Historical Records by Provider:");
            for (Map.Entry entry : this.mRequestStatistics.statistics.entrySet()) {
                LocationRequestStatistics.PackageProviderKey key = (LocationRequestStatistics.PackageProviderKey)entry.getKey();
                LocationRequestStatistics.PackageStatistics stats = (LocationRequestStatistics.PackageStatistics)entry.getValue();
                pw.println("    " + key.packageName + ": " + key.providerName + ": " + stats);
            }
            pw.println("  Last Known Locations:");
            for (Map.Entry entry : this.mLastLocation.entrySet()) {
                provider = (String)entry.getKey();
                location = (Location)entry.getValue();
                pw.println("    " + provider + ": " + location);
            }
            pw.println("  Last Known Locations Coarse Intervals:");
            for (Map.Entry entry : this.mLastLocationCoarseInterval.entrySet()) {
                provider = (String)entry.getKey();
                location = (Location)entry.getValue();
                pw.println("    " + provider + ": " + location);
            }
            this.mGeofenceManager.dump(pw);
            if (this.mEnabledProviders.size() > 0) {
                pw.println("  Enabled Providers:");
                for (String string2 : this.mEnabledProviders) {
                    pw.println("    " + string2);
                }
            }
            if (this.mDisabledProviders.size() > 0) {
                pw.println("  Disabled Providers:");
                for (String string3 : this.mDisabledProviders) {
                    pw.println("    " + string3);
                }
            }
            pw.append("  ");
            this.mBlacklist.dump(pw);
            if (this.mMockProviders.size() > 0) {
                pw.println("  Mock Providers:");
                for (Map.Entry entry : this.mMockProviders.entrySet()) {
                    ((MockProvider)entry.getValue()).dump(pw, "      ");
                }
            }
            pw.append("  fudger: ");
            this.mLocationFudger.dump(fd, pw, args);
            if (args.length > 0 && "short".equals(args[0])) {
                return;
            }
            for (LocationProviderInterface locationProviderInterface : this.mProviders) {
                pw.print(locationProviderInterface.getName() + " Internal State");
                if (locationProviderInterface instanceof LocationProviderProxy) {
                    LocationProviderProxy proxy = (LocationProviderProxy)locationProviderInterface;
                    pw.print(" (" + proxy.getConnectedPackageName() + ")");
                }
                pw.println(":");
                locationProviderInterface.dump(fd, pw, args);
            }
        }
    }

    private class LocationWorkerHandler
    extends Handler {
        public LocationWorkerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    LocationManagerService.this.handleLocationChanged((Location)msg.obj, msg.arg1 == 1);
                }
            }
        }
    }

    private class UpdateRecord {
        final String mProvider;
        final LocationRequest mRequest;
        final Receiver mReceiver;
        Location mLastFixBroadcast;
        long mLastStatusBroadcast;

        UpdateRecord(String provider, LocationRequest request, Receiver receiver) {
            this.mProvider = provider;
            this.mRequest = request;
            this.mReceiver = receiver;
            ArrayList<UpdateRecord> records = (ArrayList<UpdateRecord>)LocationManagerService.this.mRecordsByProvider.get(provider);
            if (records == null) {
                records = new ArrayList<UpdateRecord>();
                LocationManagerService.this.mRecordsByProvider.put(provider, records);
            }
            if (!records.contains(this)) {
                records.add(this);
            }
            LocationManagerService.this.mRequestStatistics.startRequesting(this.mReceiver.mPackageName, provider, request.getInterval());
        }

        void disposeLocked(boolean removeReceiver) {
            LocationManagerService.this.mRequestStatistics.stopRequesting(this.mReceiver.mPackageName, this.mProvider);
            ArrayList globalRecords = (ArrayList)LocationManagerService.this.mRecordsByProvider.get(this.mProvider);
            if (globalRecords != null) {
                globalRecords.remove(this);
            }
            if (!removeReceiver) {
                return;
            }
            HashMap<String, UpdateRecord> receiverRecords = this.mReceiver.mUpdateRecords;
            if (receiverRecords != null) {
                receiverRecords.remove(this.mProvider);
                if (removeReceiver && receiverRecords.size() == 0) {
                    LocationManagerService.this.removeUpdatesLocked(this.mReceiver);
                }
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("UpdateRecord[");
            s.append(this.mProvider);
            s.append(' ').append(this.mReceiver.mPackageName).append('(');
            s.append(this.mReceiver.mUid).append(')');
            s.append(' ').append(this.mRequest);
            s.append(']');
            return s.toString();
        }
    }

    private final class Receiver
    implements IBinder.DeathRecipient,
    PendingIntent.OnFinished {
        final int mUid;
        final int mPid;
        final String mPackageName;
        final int mAllowedResolutionLevel;
        final ILocationListener mListener;
        final PendingIntent mPendingIntent;
        final WorkSource mWorkSource;
        final boolean mHideFromAppOps;
        final Object mKey;
        final HashMap<String, UpdateRecord> mUpdateRecords = new HashMap();
        boolean mOpMonitoring;
        boolean mOpHighPowerMonitoring;
        int mPendingBroadcasts;
        PowerManager.WakeLock mWakeLock;

        Receiver(ILocationListener listener, PendingIntent intent, int pid, int uid, String packageName, WorkSource workSource, boolean hideFromAppOps) {
            this.mListener = listener;
            this.mPendingIntent = intent;
            this.mKey = listener != null ? listener.asBinder() : intent;
            this.mAllowedResolutionLevel = LocationManagerService.this.getAllowedResolutionLevel(pid, uid);
            this.mUid = uid;
            this.mPid = pid;
            this.mPackageName = packageName;
            if (workSource != null && workSource.size() <= 0) {
                workSource = null;
            }
            this.mWorkSource = workSource;
            this.mHideFromAppOps = hideFromAppOps;
            this.updateMonitoring(true);
            this.mWakeLock = LocationManagerService.this.mPowerManager.newWakeLock(1, "LocationManagerService");
            if (workSource == null) {
                workSource = new WorkSource(this.mUid, this.mPackageName);
            }
            this.mWakeLock.setWorkSource(workSource);
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof Receiver) {
                return this.mKey.equals(((Receiver)otherObj).mKey);
            }
            return false;
        }

        public int hashCode() {
            return this.mKey.hashCode();
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("Reciever[");
            s.append(Integer.toHexString(System.identityHashCode(this)));
            if (this.mListener != null) {
                s.append(" listener");
            } else {
                s.append(" intent");
            }
            for (String p : this.mUpdateRecords.keySet()) {
                s.append(" ").append(this.mUpdateRecords.get(p).toString());
            }
            s.append("]");
            return s.toString();
        }

        public void updateMonitoring(boolean allow) {
            if (this.mHideFromAppOps) {
                return;
            }
            boolean requestingLocation = false;
            boolean requestingHighPowerLocation = false;
            if (allow) {
                for (UpdateRecord updateRecord : this.mUpdateRecords.values()) {
                    if (!LocationManagerService.this.isAllowedByCurrentUserSettingsLocked(updateRecord.mProvider)) continue;
                    requestingLocation = true;
                    LocationProviderInterface locationProvider = (LocationProviderInterface)LocationManagerService.this.mProvidersByName.get(updateRecord.mProvider);
                    ProviderProperties properties = locationProvider != null ? locationProvider.getProperties() : null;
                    if (properties == null || properties.mPowerRequirement != 3 || updateRecord.mRequest.getInterval() >= 300000L) continue;
                    requestingHighPowerLocation = true;
                    break;
                }
            }
            this.mOpMonitoring = this.updateMonitoring(requestingLocation, this.mOpMonitoring, 41);
            boolean wasHighPowerMonitoring = this.mOpHighPowerMonitoring;
            this.mOpHighPowerMonitoring = this.updateMonitoring(requestingHighPowerLocation, this.mOpHighPowerMonitoring, 42);
            if (this.mOpHighPowerMonitoring != wasHighPowerMonitoring) {
                Intent intent = new Intent("android.location.HIGH_POWER_REQUEST_CHANGE");
                LocationManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            }
        }

        private boolean updateMonitoring(boolean allowMonitoring, boolean currentlyMonitoring, int op) {
            if (!currentlyMonitoring) {
                if (allowMonitoring) {
                    return LocationManagerService.this.mAppOps.startOpNoThrow(op, this.mUid, this.mPackageName) == 0;
                }
            } else if (!allowMonitoring || LocationManagerService.this.mAppOps.checkOpNoThrow(op, this.mUid, this.mPackageName) != 0) {
                LocationManagerService.this.mAppOps.finishOp(op, this.mUid, this.mPackageName);
                return false;
            }
            return currentlyMonitoring;
        }

        public boolean isListener() {
            return this.mListener != null;
        }

        public boolean isPendingIntent() {
            return this.mPendingIntent != null;
        }

        public ILocationListener getListener() {
            if (this.mListener != null) {
                return this.mListener;
            }
            throw new IllegalStateException("Request for non-existent listener");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean callStatusChangedLocked(String provider, int status, Bundle extras) {
            block11: {
                if (this.mListener != null) {
                    try {
                        Receiver receiver = this;
                        synchronized (receiver) {
                            this.mListener.onStatusChanged(provider, status, extras);
                            this.incrementPendingBroadcastsLocked();
                            break block11;
                        }
                    }
                    catch (RemoteException e) {
                        return false;
                    }
                }
                Intent statusChanged = new Intent();
                statusChanged.putExtras(new Bundle(extras));
                statusChanged.putExtra("status", status);
                try {
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.mPendingIntent.send(LocationManagerService.this.mContext, 0, statusChanged, this, LocationManagerService.this.mLocationHandler, LocationManagerService.this.getResolutionPermission(this.mAllowedResolutionLevel));
                        this.incrementPendingBroadcastsLocked();
                    }
                }
                catch (PendingIntent.CanceledException e) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean callLocationChangedLocked(Location location) {
            block11: {
                if (this.mListener != null) {
                    try {
                        Receiver receiver = this;
                        synchronized (receiver) {
                            this.mListener.onLocationChanged(new Location(location));
                            this.incrementPendingBroadcastsLocked();
                            break block11;
                        }
                    }
                    catch (RemoteException e) {
                        return false;
                    }
                }
                Intent locationChanged = new Intent();
                locationChanged.putExtra("location", new Location(location));
                try {
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.mPendingIntent.send(LocationManagerService.this.mContext, 0, locationChanged, this, LocationManagerService.this.mLocationHandler, LocationManagerService.this.getResolutionPermission(this.mAllowedResolutionLevel));
                        this.incrementPendingBroadcastsLocked();
                    }
                }
                catch (PendingIntent.CanceledException e) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean callProviderEnabledLocked(String provider, boolean enabled) {
            block13: {
                this.updateMonitoring(true);
                if (this.mListener != null) {
                    try {
                        Receiver receiver = this;
                        synchronized (receiver) {
                            if (enabled) {
                                this.mListener.onProviderEnabled(provider);
                            } else {
                                this.mListener.onProviderDisabled(provider);
                            }
                            this.incrementPendingBroadcastsLocked();
                            break block13;
                        }
                    }
                    catch (RemoteException e) {
                        return false;
                    }
                }
                Intent providerIntent = new Intent();
                providerIntent.putExtra("providerEnabled", enabled);
                try {
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.mPendingIntent.send(LocationManagerService.this.mContext, 0, providerIntent, this, LocationManagerService.this.mLocationHandler, LocationManagerService.this.getResolutionPermission(this.mAllowedResolutionLevel));
                        this.incrementPendingBroadcastsLocked();
                    }
                }
                catch (PendingIntent.CanceledException e) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            if (D) {
                Log.d("LocationManagerService", "Location listener died");
            }
            Object object = LocationManagerService.this.mLock;
            synchronized (object) {
                LocationManagerService.this.removeUpdatesLocked(this);
            }
            object = this;
            synchronized (object) {
                this.clearPendingBroadcastsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            Receiver receiver = this;
            synchronized (receiver) {
                this.decrementPendingBroadcastsLocked();
            }
        }

        private void incrementPendingBroadcastsLocked() {
            if (this.mPendingBroadcasts++ == 0) {
                this.mWakeLock.acquire();
            }
        }

        private void decrementPendingBroadcastsLocked() {
            if (--this.mPendingBroadcasts == 0 && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }

        public void clearPendingBroadcastsLocked() {
            if (this.mPendingBroadcasts > 0) {
                this.mPendingBroadcasts = 0;
                if (this.mWakeLock.isHeld()) {
                    this.mWakeLock.release();
                }
            }
        }
    }
}

