/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.CpuUsageInfo;
import android.os.IHardwarePropertiesManager;
import android.os.UserHandle;
import com.android.server.LocalServices;
import com.android.server.vr.VrManagerInternal;

public class HardwarePropertiesManagerService
extends IHardwarePropertiesManager.Stub {
    private final Context mContext;
    private final Object mLock = new Object();

    private static native void nativeInit();

    private static native float[] nativeGetFanSpeeds();

    private static native float[] nativeGetDeviceTemperatures(int var0, int var1);

    private static native CpuUsageInfo[] nativeGetCpuUsages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwarePropertiesManagerService(Context context) {
        this.mContext = context;
        Object object = this.mLock;
        synchronized (object) {
            HardwarePropertiesManagerService.nativeInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getDeviceTemperatures(String callingPackage, int type, int source) throws SecurityException {
        this.enforceHardwarePropertiesRetrievalAllowed(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            return HardwarePropertiesManagerService.nativeGetDeviceTemperatures(type, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuUsageInfo[] getCpuUsages(String callingPackage) throws SecurityException {
        this.enforceHardwarePropertiesRetrievalAllowed(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            return HardwarePropertiesManagerService.nativeGetCpuUsages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getFanSpeeds(String callingPackage) throws SecurityException {
        this.enforceHardwarePropertiesRetrievalAllowed(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            return HardwarePropertiesManagerService.nativeGetFanSpeeds();
        }
    }

    private void enforceHardwarePropertiesRetrievalAllowed(String callingPackage) throws SecurityException {
        PackageManager pm = this.mContext.getPackageManager();
        int uid = 0;
        try {
            uid = pm.getPackageUid(callingPackage, 0);
            if (Binder.getCallingUid() != uid) {
                throw new SecurityException("The caller has faked the package name.");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException("The caller has faked the package name.");
        }
        int userId = UserHandle.getUserId(uid);
        VrManagerInternal vrService = LocalServices.getService(VrManagerInternal.class);
        DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
        if (!(dpm.isDeviceOwnerApp(callingPackage) || dpm.isProfileOwnerApp(callingPackage) || vrService.isCurrentVrListener(callingPackage, userId))) {
            throw new SecurityException("The caller is not a device or profile owner or bound VrListenerService.");
        }
    }
}

