/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.NativeRef;
import com.android.org.conscrypt.OpenSSLKey;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class OpenSSLSignature
extends SignatureSpi {
    private NativeRef.EVP_MD_CTX ctx;
    private OpenSSLKey key;
    private final EngineType engineType;
    private final long evpMdRef;
    private final byte[] singleByte = new byte[1];
    private boolean signing;
    private long evpPkeyCtx;

    private OpenSSLSignature(long evpMdRef, EngineType engineType) {
        this.engineType = engineType;
        this.evpMdRef = evpMdRef;
    }

    private final void resetContext() {
        NativeRef.EVP_MD_CTX ctxLocal = new NativeRef.EVP_MD_CTX(NativeCrypto.EVP_MD_CTX_create());
        if (this.signing) {
            this.enableDSASignatureNonceHardeningIfApplicable();
            this.evpPkeyCtx = NativeCrypto.EVP_DigestSignInit(ctxLocal, this.evpMdRef, this.key.getNativeRef());
        } else {
            this.evpPkeyCtx = NativeCrypto.EVP_DigestVerifyInit(ctxLocal, this.evpMdRef, this.key.getNativeRef());
        }
        this.configureEVP_PKEY_CTX(this.evpPkeyCtx);
        this.ctx = ctxLocal;
    }

    protected void configureEVP_PKEY_CTX(long ctx) {
    }

    @Override
    protected void engineUpdate(byte input) {
        this.singleByte[0] = input;
        this.engineUpdate(this.singleByte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        NativeRef.EVP_MD_CTX ctxLocal = this.ctx;
        if (this.signing) {
            NativeCrypto.EVP_DigestSignUpdate(ctxLocal, input, offset, len);
        } else {
            NativeCrypto.EVP_DigestVerifyUpdate(ctxLocal, input, offset, len);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        if (!input.hasRemaining()) {
            return;
        }
        if (!input.isDirect()) {
            super.engineUpdate(input);
            return;
        }
        long baseAddress = NativeCrypto.getDirectBufferAddress(input);
        if (baseAddress == 0L) {
            super.engineUpdate(input);
            return;
        }
        int position = input.position();
        if (position < 0) {
            throw new RuntimeException("Negative position");
        }
        long ptr = baseAddress + (long)position;
        int len = input.remaining();
        if (len < 0) {
            throw new RuntimeException("Negative remaining amount");
        }
        NativeRef.EVP_MD_CTX ctxLocal = this.ctx;
        if (this.signing) {
            NativeCrypto.EVP_DigestSignUpdateDirect(ctxLocal, ptr, len);
        } else {
            NativeCrypto.EVP_DigestVerifyUpdateDirect(ctxLocal, ptr, len);
        }
        input.position(position + len);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    private void checkEngineType(OpenSSLKey pkey) throws InvalidKeyException {
        int pkeyType = NativeCrypto.EVP_PKEY_type(pkey.getNativeRef());
        switch (this.engineType) {
            case RSA: {
                if (pkeyType == 6) break;
                throw new InvalidKeyException("Signature initialized as " + (Object)((Object)this.engineType) + " (not RSA)");
            }
            case EC: {
                if (pkeyType == 408) break;
                throw new InvalidKeyException("Signature initialized as " + (Object)((Object)this.engineType) + " (not EC)");
            }
            default: {
                throw new InvalidKeyException("Key must be of type " + (Object)((Object)this.engineType));
            }
        }
    }

    private void initInternal(OpenSSLKey newKey, boolean signing) throws InvalidKeyException {
        this.checkEngineType(newKey);
        this.key = newKey;
        this.signing = signing;
        this.resetContext();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.initInternal(OpenSSLKey.fromPrivateKey(privateKey), true);
    }

    private void enableDSASignatureNonceHardeningIfApplicable() {
        OpenSSLKey key = this.key;
        switch (this.engineType) {
            case EC: {
                NativeCrypto.EC_KEY_set_nonce_from_hash(key.getNativeRef(), true);
                break;
            }
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.initInternal(OpenSSLKey.fromPublicKey(publicKey), false);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        NativeRef.EVP_MD_CTX ctxLocal = this.ctx;
        try {
            byte[] byArray = NativeCrypto.EVP_DigestSignFinal(ctxLocal);
            return byArray;
        }
        catch (Exception ex) {
            throw new SignatureException(ex);
        }
        finally {
            this.resetContext();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        NativeRef.EVP_MD_CTX ctxLocal = this.ctx;
        try {
            boolean bl = NativeCrypto.EVP_DigestVerifyFinal(ctxLocal, sigBytes, 0, sigBytes.length);
            return bl;
        }
        catch (Exception ex) {
            throw new SignatureException(ex);
        }
        finally {
            this.resetContext();
        }
    }

    protected final long getEVP_PKEY_CTX() {
        return this.evpPkeyCtx;
    }

    public static final class SHA512RSAPSS
    extends RSAPSSPadding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha512");

        public SHA512RSAPSS() {
            super(EVP_MD, "SHA-512", 64);
        }
    }

    public static final class SHA384RSAPSS
    extends RSAPSSPadding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha384");

        public SHA384RSAPSS() {
            super(EVP_MD, "SHA-384", 48);
        }
    }

    public static final class SHA256RSAPSS
    extends RSAPSSPadding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha256");

        public SHA256RSAPSS() {
            super(EVP_MD, "SHA-256", 32);
        }
    }

    public static final class SHA224RSAPSS
    extends RSAPSSPadding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha224");

        public SHA224RSAPSS() {
            super(EVP_MD, "SHA-224", 28);
        }
    }

    public static final class SHA1RSAPSS
    extends RSAPSSPadding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha1");

        public SHA1RSAPSS() {
            super(EVP_MD, "SHA-1", 20);
        }
    }

    static abstract class RSAPSSPadding
    extends OpenSSLSignature {
        private static final String MGF1_ALGORITHM_NAME = "MGF1";
        private static final String MGF1_OID = "1.2.840.113549.1.1.8";
        private static final int TRAILER_FIELD_BC_ID = 1;
        private final String contentDigestAlgorithm;
        private String mgf1DigestAlgorithm;
        private long mgf1EvpMdRef;
        private int saltSizeBytes;

        public RSAPSSPadding(long contentDigestEvpMdRef, String contentDigestAlgorithm, int saltSizeBytes) {
            super(contentDigestEvpMdRef, EngineType.RSA);
            this.contentDigestAlgorithm = contentDigestAlgorithm;
            this.mgf1DigestAlgorithm = contentDigestAlgorithm;
            this.mgf1EvpMdRef = contentDigestEvpMdRef;
            this.saltSizeBytes = saltSizeBytes;
        }

        @Override
        protected final void configureEVP_PKEY_CTX(long ctx) {
            NativeCrypto.EVP_PKEY_CTX_set_rsa_padding(ctx, 6);
            NativeCrypto.EVP_PKEY_CTX_set_rsa_mgf1_md(ctx, this.mgf1EvpMdRef);
            NativeCrypto.EVP_PKEY_CTX_set_rsa_pss_saltlen(ctx, this.saltSizeBytes);
        }

        @Override
        protected final void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            long specMgf1EvpMdRef;
            if (!(params instanceof PSSParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported parameter: " + params + ". Only " + PSSParameterSpec.class.getName() + " supported");
            }
            PSSParameterSpec spec = (PSSParameterSpec)params;
            String specContentDigest = RSAPSSPadding.getJcaDigestAlgorithmStandardName(spec.getDigestAlgorithm());
            if (specContentDigest == null) {
                throw new InvalidAlgorithmParameterException("Unsupported content digest algorithm: " + spec.getDigestAlgorithm());
            }
            if (!this.contentDigestAlgorithm.equalsIgnoreCase(specContentDigest)) {
                throw new InvalidAlgorithmParameterException("Changing content digest algorithm not supported");
            }
            String specMgfAlgorithm = spec.getMGFAlgorithm();
            if (!MGF1_ALGORITHM_NAME.equalsIgnoreCase(specMgfAlgorithm) && !MGF1_OID.equals(specMgfAlgorithm)) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF algorithm: " + specMgfAlgorithm + ". Only " + MGF1_ALGORITHM_NAME + " supported");
            }
            AlgorithmParameterSpec mgfSpec = spec.getMGFParameters();
            if (!(mgfSpec instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF parameters: " + mgfSpec + ". Only " + MGF1ParameterSpec.class.getName() + " supported");
            }
            MGF1ParameterSpec specMgf1Spec = (MGF1ParameterSpec)spec.getMGFParameters();
            String specMgf1Digest = RSAPSSPadding.getJcaDigestAlgorithmStandardName(specMgf1Spec.getDigestAlgorithm());
            if (specMgf1Digest == null) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF1 digest algorithm: " + specMgf1Spec.getDigestAlgorithm());
            }
            try {
                specMgf1EvpMdRef = RSAPSSPadding.getEVP_MDByJcaDigestAlgorithmStandardName(specMgf1Digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ProviderException("Failed to obtain EVP_MD for " + specMgf1Digest, e);
            }
            int specSaltSizeBytes = spec.getSaltLength();
            if (specSaltSizeBytes < 0) {
                throw new InvalidAlgorithmParameterException("Salt length must be non-negative: " + specSaltSizeBytes);
            }
            int specTrailer = spec.getTrailerField();
            if (specTrailer != 1) {
                throw new InvalidAlgorithmParameterException("Unsupported trailer field: " + specTrailer + ". Only " + 1 + " supported");
            }
            this.mgf1DigestAlgorithm = specMgf1Digest;
            this.mgf1EvpMdRef = specMgf1EvpMdRef;
            this.saltSizeBytes = specSaltSizeBytes;
            long ctx = this.getEVP_PKEY_CTX();
            if (ctx != 0L) {
                this.configureEVP_PKEY_CTX(ctx);
            }
        }

        @Override
        protected final AlgorithmParameters engineGetParameters() {
            try {
                AlgorithmParameters result = AlgorithmParameters.getInstance("PSS");
                result.init(new PSSParameterSpec(this.contentDigestAlgorithm, MGF1_ALGORITHM_NAME, new MGF1ParameterSpec(this.mgf1DigestAlgorithm), this.saltSizeBytes, 1));
                return result;
            }
            catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
                throw new ProviderException("Failed to create PSS AlgorithmParameters", e);
            }
        }

        private static String getJcaDigestAlgorithmStandardName(String algorithm) {
            if ("SHA-256".equalsIgnoreCase(algorithm) || "2.16.840.1.101.3.4.2.1".equals(algorithm)) {
                return "SHA-256";
            }
            if ("SHA-512".equalsIgnoreCase(algorithm) || "2.16.840.1.101.3.4.2.3".equals(algorithm)) {
                return "SHA-512";
            }
            if ("SHA-1".equalsIgnoreCase(algorithm) || "1.3.14.3.2.26".equals(algorithm)) {
                return "SHA-1";
            }
            if ("SHA-384".equalsIgnoreCase(algorithm) || "2.16.840.1.101.3.4.2.2".equals(algorithm)) {
                return "SHA-384";
            }
            if ("SHA-224".equalsIgnoreCase(algorithm) || "2.16.840.1.101.3.4.2.4".equals(algorithm)) {
                return "SHA-224";
            }
            return null;
        }

        private static long getEVP_MDByJcaDigestAlgorithmStandardName(String algorithm) throws NoSuchAlgorithmException {
            if ("SHA-256".equalsIgnoreCase(algorithm)) {
                return NativeCrypto.EVP_get_digestbyname("sha256");
            }
            if ("SHA-512".equalsIgnoreCase(algorithm)) {
                return NativeCrypto.EVP_get_digestbyname("sha512");
            }
            if ("SHA-1".equalsIgnoreCase(algorithm)) {
                return NativeCrypto.EVP_get_digestbyname("sha1");
            }
            if ("SHA-384".equalsIgnoreCase(algorithm)) {
                return NativeCrypto.EVP_get_digestbyname("sha384");
            }
            if ("SHA-224".equalsIgnoreCase(algorithm)) {
                return NativeCrypto.EVP_get_digestbyname("sha224");
            }
            throw new NoSuchAlgorithmException("Unsupported algorithm: " + algorithm);
        }
    }

    public static final class SHA512ECDSA
    extends OpenSSLSignature {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha512");

        public SHA512ECDSA() {
            super(EVP_MD, EngineType.EC);
        }
    }

    public static final class SHA384ECDSA
    extends OpenSSLSignature {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha384");

        public SHA384ECDSA() {
            super(EVP_MD, EngineType.EC);
        }
    }

    public static final class SHA256ECDSA
    extends OpenSSLSignature {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha256");

        public SHA256ECDSA() {
            super(EVP_MD, EngineType.EC);
        }
    }

    public static final class SHA224ECDSA
    extends OpenSSLSignature {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha224");

        public SHA224ECDSA() {
            super(EVP_MD, EngineType.EC);
        }
    }

    public static final class SHA1ECDSA
    extends OpenSSLSignature {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha1");

        public SHA1ECDSA() {
            super(EVP_MD, EngineType.EC);
        }
    }

    public static final class SHA512RSA
    extends RSAPKCS1Padding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha512");

        public SHA512RSA() {
            super(EVP_MD);
        }
    }

    public static final class SHA384RSA
    extends RSAPKCS1Padding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha384");

        public SHA384RSA() {
            super(EVP_MD);
        }
    }

    public static final class SHA256RSA
    extends RSAPKCS1Padding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha256");

        public SHA256RSA() {
            super(EVP_MD);
        }
    }

    public static final class SHA224RSA
    extends RSAPKCS1Padding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha224");

        public SHA224RSA() {
            super(EVP_MD);
        }
    }

    public static final class SHA1RSA
    extends RSAPKCS1Padding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("sha1");

        public SHA1RSA() {
            super(EVP_MD);
        }
    }

    public static final class MD5RSA
    extends RSAPKCS1Padding {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname("md5");

        public MD5RSA() {
            super(EVP_MD);
        }
    }

    static abstract class RSAPKCS1Padding
    extends OpenSSLSignature {
        RSAPKCS1Padding(long evpMdRef) {
            super(evpMdRef, EngineType.RSA);
        }

        @Override
        protected final void configureEVP_PKEY_CTX(long ctx) {
            NativeCrypto.EVP_PKEY_CTX_set_rsa_padding(ctx, 1);
        }
    }

    private static enum EngineType {
        RSA,
        EC;

    }
}

