/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.PinEntryException;
import com.android.org.conscrypt.PinListEntry;
import com.android.org.conscrypt.PinManagerException;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import libcore.io.IoUtils;
import libcore.util.BasicLruCache;

public class CertPinManager {
    private long lastModified;
    private final Map<String, PinListEntry> entries = new HashMap<String, PinListEntry>();
    private final BasicLruCache<String, String> hostnameCache = new BasicLruCache(10);
    private boolean initialized = false;
    private static final boolean DEBUG = false;
    private final File pinFile;
    private final TrustedCertificateStore certStore;

    public CertPinManager(TrustedCertificateStore store) throws PinManagerException {
        this.pinFile = new File("/data/misc/keychain/pins");
        this.certStore = store;
    }

    public CertPinManager(String path, TrustedCertificateStore store) throws PinManagerException {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        this.pinFile = new File(path);
        this.certStore = store;
    }

    public boolean isChainValid(String hostname, List<X509Certificate> chain) throws PinManagerException {
        PinListEntry entry = this.lookup(hostname);
        if (entry == null) {
            return true;
        }
        return entry.isChainValid(chain);
    }

    private synchronized boolean ensureInitialized() throws PinManagerException {
        if (this.initialized && this.isCacheValid()) {
            return true;
        }
        String pinFileContents = this.readPinFile();
        if (pinFileContents != null) {
            for (String entry : CertPinManager.getPinFileEntries(pinFileContents)) {
                try {
                    PinListEntry pin = new PinListEntry(entry, this.certStore);
                    this.entries.put(pin.getCommonName(), pin);
                }
                catch (PinEntryException e) {
                    CertPinManager.log("Pinlist contains a malformed pin: " + entry, e);
                }
            }
            this.hostnameCache.evictAll();
            this.lastModified = this.pinFile.lastModified();
            this.initialized = true;
        }
        return this.initialized;
    }

    private String readPinFile() throws PinManagerException {
        try {
            return IoUtils.readFileAsString(this.pinFile.getPath());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new PinManagerException("Unexpected error reading pin list; failing.", e);
        }
    }

    private static String[] getPinFileEntries(String pinFileContents) {
        return pinFileContents.split("\n");
    }

    private synchronized PinListEntry lookup(String hostname) throws PinManagerException {
        if (!this.ensureInitialized()) {
            return null;
        }
        String cn = this.hostnameCache.get(hostname);
        if (cn != null) {
            return this.entries.get(cn);
        }
        cn = this.getMatchingCN(hostname);
        if (cn != null) {
            this.hostnameCache.put(hostname, cn);
            return this.entries.get(cn);
        }
        return null;
    }

    private boolean isCacheValid() {
        return this.pinFile.lastModified() == this.lastModified;
    }

    private String getMatchingCN(String hostname) {
        String bestMatch = "";
        for (String cn : this.entries.keySet()) {
            if (cn.length() < bestMatch.length() || !CertPinManager.isHostnameMatchedBy(hostname, cn)) continue;
            bestMatch = cn;
        }
        return bestMatch;
    }

    private static boolean isHostnameMatchedBy(String hostName, String cn) {
        int dot;
        if (hostName == null || hostName.isEmpty() || cn == null || cn.isEmpty()) {
            return false;
        }
        if (!(cn = cn.toLowerCase(Locale.US)).contains("*")) {
            return hostName.equals(cn);
        }
        if (cn.startsWith("*.") && hostName.regionMatches(0, cn, 2, cn.length() - 2)) {
            return true;
        }
        int asterisk = cn.indexOf(42);
        if (asterisk > (dot = cn.indexOf(46))) {
            return false;
        }
        if (!hostName.regionMatches(0, cn, 0, asterisk)) {
            return false;
        }
        int suffixLength = cn.length() - (asterisk + 1);
        int suffixStart = hostName.length() - suffixLength;
        if (hostName.indexOf(46, asterisk) < suffixStart) {
            return false;
        }
        return hostName.regionMatches(suffixStart, cn, asterisk + 1, suffixLength);
    }

    private static void log(String s, Exception e) {
    }
}

