/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.Address;
import com.android.okhttp.Connection;
import com.android.okhttp.internal.Platform;
import com.android.okhttp.internal.Util;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    private static final long DEFAULT_KEEP_ALIVE_DURATION_MS = 300000L;
    private static final ConnectionPool systemDefault;
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final LinkedList<Connection> connections = new LinkedList();
    private Executor executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory("OkHttp ConnectionPool", true));
    private final Runnable connectionsCleanupRunnable = new Runnable(){

        @Override
        public void run() {
            ConnectionPool.this.runCleanupUntilPoolIsEmpty();
        }
    };

    public ConnectionPool(int maxIdleConnections, long keepAliveDurationMs) {
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDurationNs = keepAliveDurationMs * 1000L * 1000L;
    }

    public static ConnectionPool getDefault() {
        return systemDefault;
    }

    public synchronized int getConnectionCount() {
        return this.connections.size();
    }

    @Deprecated
    public synchronized int getSpdyConnectionCount() {
        return this.getMultiplexedConnectionCount();
    }

    public synchronized int getMultiplexedConnectionCount() {
        int total = 0;
        for (Connection connection : this.connections) {
            if (!connection.isFramed()) continue;
            ++total;
        }
        return total;
    }

    public synchronized int getHttpConnectionCount() {
        return this.connections.size() - this.getMultiplexedConnectionCount();
    }

    public synchronized Connection get(Address address) {
        Connection foundConnection = null;
        ListIterator<Connection> i = this.connections.listIterator(this.connections.size());
        while (i.hasPrevious()) {
            Connection connection = i.previous();
            if (!connection.getRoute().getAddress().equals(address) || !connection.isAlive() || System.nanoTime() - connection.getIdleStartTimeNs() >= this.keepAliveDurationNs) continue;
            i.remove();
            if (!connection.isFramed()) {
                try {
                    Platform.get().tagSocket(connection.getSocket());
                }
                catch (SocketException e) {
                    Util.closeQuietly(connection.getSocket());
                    Platform.get().logW("Unable to tagSocket(): " + e);
                    continue;
                }
            }
            foundConnection = connection;
            break;
        }
        if (foundConnection != null && foundConnection.isFramed()) {
            this.connections.addFirst(foundConnection);
        }
        return foundConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycle(Connection connection) {
        if (connection.isFramed()) {
            return;
        }
        if (!connection.clearOwner()) {
            return;
        }
        if (!connection.isAlive()) {
            Util.closeQuietly(connection.getSocket());
            return;
        }
        try {
            Platform.get().untagSocket(connection.getSocket());
        }
        catch (SocketException e) {
            Platform.get().logW("Unable to untagSocket(): " + e);
            Util.closeQuietly(connection.getSocket());
            return;
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.addConnection(connection);
            connection.incrementRecycleCount();
            connection.resetIdleStartTime();
        }
    }

    private void addConnection(Connection connection) {
        boolean empty = this.connections.isEmpty();
        this.connections.addFirst(connection);
        if (empty) {
            this.executor.execute(this.connectionsCleanupRunnable);
        } else {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void share(Connection connection) {
        if (!connection.isFramed()) {
            throw new IllegalArgumentException();
        }
        if (!connection.isAlive()) {
            return;
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.addConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        ArrayList<Connection> toEvict;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            toEvict = new ArrayList<Connection>(this.connections);
            this.connections.clear();
            this.notifyAll();
        }
        int size = toEvict.size();
        for (int i = 0; i < size; ++i) {
            Util.closeQuietly(((Connection)toEvict.get(i)).getSocket());
        }
    }

    private void runCleanupUntilPoolIsEmpty() {
        while (this.performCleanup()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean performCleanup() {
        ArrayList<Connection> evictableConnections;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            Connection connection;
            if (this.connections.isEmpty()) {
                return false;
            }
            evictableConnections = new ArrayList<Connection>();
            int idleConnectionCount = 0;
            long now = System.nanoTime();
            long nanosUntilNextEviction = this.keepAliveDurationNs;
            ListIterator<Connection> i = this.connections.listIterator(this.connections.size());
            while (i.hasPrevious()) {
                connection = i.previous();
                long nanosUntilEviction = connection.getIdleStartTimeNs() + this.keepAliveDurationNs - now;
                if (nanosUntilEviction <= 0L || !connection.isAlive()) {
                    i.remove();
                    evictableConnections.add(connection);
                    continue;
                }
                if (!connection.isIdle()) continue;
                ++idleConnectionCount;
                nanosUntilNextEviction = Math.min(nanosUntilNextEviction, nanosUntilEviction);
            }
            i = this.connections.listIterator(this.connections.size());
            while (i.hasPrevious() && idleConnectionCount > this.maxIdleConnections) {
                connection = i.previous();
                if (!connection.isIdle()) continue;
                evictableConnections.add(connection);
                i.remove();
                --idleConnectionCount;
            }
            if (evictableConnections.isEmpty()) {
                try {
                    long millisUntilNextEviction = nanosUntilNextEviction / 1000000L;
                    long remainderNanos = nanosUntilNextEviction - millisUntilNextEviction * 1000000L;
                    this.wait(millisUntilNextEviction, (int)remainderNanos);
                    return true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        int size = evictableConnections.size();
        for (int i = 0; i < size; ++i) {
            Connection expiredConnection = (Connection)evictableConnections.get(i);
            Util.closeQuietly(expiredConnection.getSocket());
        }
        return true;
    }

    void replaceCleanupExecutorForTests(Executor cleanupExecutor) {
        this.executor = cleanupExecutor;
    }

    synchronized List<Connection> getConnections() {
        return new ArrayList<Connection>(this.connections);
    }

    static {
        long keepAliveDurationMs;
        String keepAlive = System.getProperty("http.keepAlive");
        String keepAliveDuration = System.getProperty("http.keepAliveDuration");
        String maxIdleConnections = System.getProperty("http.maxConnections");
        long l = keepAliveDurationMs = keepAliveDuration != null ? Long.parseLong(keepAliveDuration) : 300000L;
        systemDefault = keepAlive != null && !Boolean.parseBoolean(keepAlive) ? new ConnectionPool(0, keepAliveDurationMs) : (maxIdleConnections != null ? new ConnectionPool(Integer.parseInt(maxIdleConnections), keepAliveDurationMs) : new ConnectionPool(5, keepAliveDurationMs));
    }
}

