/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.Callback;
import com.android.okhttp.Connection;
import com.android.okhttp.HttpUrl;
import com.android.okhttp.Interceptor;
import com.android.okhttp.MediaType;
import com.android.okhttp.OkHttpClient;
import com.android.okhttp.Request;
import com.android.okhttp.RequestBody;
import com.android.okhttp.Response;
import com.android.okhttp.internal.Internal;
import com.android.okhttp.internal.NamedRunnable;
import com.android.okhttp.internal.http.HttpEngine;
import com.android.okhttp.internal.http.RequestException;
import com.android.okhttp.internal.http.RouteException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.logging.Level;

public class Call {
    private final OkHttpClient client;
    private boolean executed;
    volatile boolean canceled;
    Request originalRequest;
    HttpEngine engine;

    protected Call(OkHttpClient client, Request originalRequest) {
        this.client = client.copyWithDefaults();
        this.originalRequest = originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute() throws IOException {
        Call call = this;
        synchronized (call) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        try {
            this.client.getDispatcher().executed(this);
            Response result = this.getResponseWithInterceptorChain(false);
            if (result == null) {
                throw new IOException("Canceled");
            }
            Response response = result;
            return response;
        }
        finally {
            this.client.getDispatcher().finished(this);
        }
    }

    Object tag() {
        return this.originalRequest.tag();
    }

    public void enqueue(Callback responseCallback) {
        this.enqueue(responseCallback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Callback responseCallback, boolean forWebSocket) {
        Call call = this;
        synchronized (call) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.client.getDispatcher().enqueue(new AsyncCall(responseCallback, forWebSocket));
    }

    public void cancel() {
        this.canceled = true;
        if (this.engine != null) {
            this.engine.disconnect();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private String toLoggableString() {
        String string2 = this.canceled ? "canceled call" : "call";
        HttpUrl redactedUrl = this.originalRequest.httpUrl().resolve("/...");
        return string2 + " to " + redactedUrl;
    }

    private Response getResponseWithInterceptorChain(boolean forWebSocket) throws IOException {
        ApplicationInterceptorChain chain = new ApplicationInterceptorChain(0, this.originalRequest, forWebSocket);
        return chain.proceed(this.originalRequest);
    }

    Response getResponse(Request request, boolean forWebSocket) throws IOException {
        RequestBody body = request.body();
        if (body != null) {
            long contentLength;
            Request.Builder requestBuilder = request.newBuilder();
            MediaType contentType = body.contentType();
            if (contentType != null) {
                requestBuilder.header("Content-Type", contentType.toString());
            }
            if ((contentLength = body.contentLength()) != -1L) {
                requestBuilder.header("Content-Length", Long.toString(contentLength));
                requestBuilder.removeHeader("Transfer-Encoding");
            } else {
                requestBuilder.header("Transfer-Encoding", "chunked");
                requestBuilder.removeHeader("Content-Length");
            }
            request = requestBuilder.build();
        }
        this.engine = new HttpEngine(this.client, request, false, false, forWebSocket, null, null, null, null);
        int followUpCount = 0;
        while (true) {
            HttpEngine retryEngine;
            if (this.canceled) {
                this.engine.releaseConnection();
                throw new IOException("Canceled");
            }
            try {
                this.engine.sendRequest();
                this.engine.readResponse();
            }
            catch (RequestException e) {
                throw e.getCause();
            }
            catch (RouteException e) {
                retryEngine = this.engine.recover(e);
                if (retryEngine != null) {
                    this.engine = retryEngine;
                    continue;
                }
                throw e.getLastConnectException();
            }
            catch (IOException e) {
                retryEngine = this.engine.recover(e, null);
                if (retryEngine != null) {
                    this.engine = retryEngine;
                    continue;
                }
                throw e;
            }
            Response response = this.engine.getResponse();
            Request followUp = this.engine.followUpRequest();
            if (followUp == null) {
                if (!forWebSocket) {
                    this.engine.releaseConnection();
                }
                return response;
            }
            if (++followUpCount > 20) {
                throw new ProtocolException("Too many follow-up requests: " + followUpCount);
            }
            if (!this.engine.sameConnection(followUp.httpUrl())) {
                this.engine.releaseConnection();
            }
            Connection connection = this.engine.close();
            request = followUp;
            this.engine = new HttpEngine(this.client, request, false, false, forWebSocket, connection, null, null, response);
        }
    }

    class ApplicationInterceptorChain
    implements Interceptor.Chain {
        private final int index;
        private final Request request;
        private final boolean forWebSocket;

        ApplicationInterceptorChain(int index, Request request, boolean forWebSocket) {
            this.index = index;
            this.request = request;
            this.forWebSocket = forWebSocket;
        }

        @Override
        public Connection connection() {
            return null;
        }

        @Override
        public Request request() {
            return this.request;
        }

        @Override
        public Response proceed(Request request) throws IOException {
            if (this.index < Call.this.client.interceptors().size()) {
                ApplicationInterceptorChain chain = new ApplicationInterceptorChain(this.index + 1, request, this.forWebSocket);
                return Call.this.client.interceptors().get(this.index).intercept(chain);
            }
            return Call.this.getResponse(request, this.forWebSocket);
        }
    }

    final class AsyncCall
    extends NamedRunnable {
        private final Callback responseCallback;
        private final boolean forWebSocket;

        private AsyncCall(Callback responseCallback, boolean forWebSocket) {
            super("OkHttp %s", Call.this.originalRequest.urlString());
            this.responseCallback = responseCallback;
            this.forWebSocket = forWebSocket;
        }

        String host() {
            return Call.this.originalRequest.httpUrl().host();
        }

        Request request() {
            return Call.this.originalRequest;
        }

        Object tag() {
            return Call.this.originalRequest.tag();
        }

        void cancel() {
            Call.this.cancel();
        }

        Call get() {
            return Call.this;
        }

        @Override
        protected void execute() {
            boolean signalledCallback = false;
            try {
                Response response = Call.this.getResponseWithInterceptorChain(this.forWebSocket);
                if (Call.this.canceled) {
                    signalledCallback = true;
                    this.responseCallback.onFailure(Call.this.originalRequest, new IOException("Canceled"));
                } else {
                    signalledCallback = true;
                    this.responseCallback.onResponse(response);
                }
            }
            catch (IOException e) {
                if (signalledCallback) {
                    Internal.logger.log(Level.INFO, "Callback failure for " + Call.this.toLoggableString(), e);
                } else {
                    this.responseCallback.onFailure(Call.this.engine.getRequest(), e);
                }
            }
            finally {
                Call.this.client.getDispatcher().finished(this);
            }
        }
    }
}

