/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.admin.DevicePolicyManager;
import android.app.trust.IStrongAuthTracker;
import android.app.trust.TrustManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.UserInfo;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternView;
import com.android.internal.widget.VerifyCredentialResponse;
import com.google.android.collect.Lists;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import libcore.util.HexEncoding;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LockPatternUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "LockPatternUtils";
    private static boolean DEBUG = false;
    public static String LEGACY_LOCK_PATTERN_ENABLED = "legacy_lock_pattern_enabled";
    public static int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static int FAILED_ATTEMPTS_BEFORE_WIPE_GRACE = 5;
    public static int MIN_LOCK_PATTERN_SIZE = 4;
    public static int MIN_LOCK_PASSWORD_SIZE = 4;
    public static int MIN_PATTERN_REGISTER_FAIL = 4;
    @Deprecated
    public static String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    public static String LOCKOUT_ATTEMPT_TIMEOUT_MS = "lockscreen.lockoutattempttimeoutmss";
    public static String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    public static String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    @Deprecated
    public static String PASSWORD_TYPE_ALTERNATE_KEY = "lockscreen.password_type_alternate";
    public static String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    public static String DISABLE_LOCKSCREEN_KEY = "lockscreen.disabled";
    public static String LOCKSCREEN_OPTIONS = "lockscreen.options";
    @Deprecated
    public static String LOCKSCREEN_BIOMETRIC_WEAK_FALLBACK = "lockscreen.biometric_weak_fallback";
    @Deprecated
    public static String BIOMETRIC_WEAK_EVER_CHOSEN_KEY = "lockscreen.biometricweakeverchosen";
    public static String LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS = "lockscreen.power_button_instantly_locks";
    @Deprecated
    public static String LOCKSCREEN_WIDGETS_ENABLED = "lockscreen.widgets_enabled";
    public static String PASSWORD_HISTORY_KEY = "lockscreen.passwordhistory";
    private static String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
    private static String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
    private static String LOCK_SCREEN_DEVICE_OWNER_INFO = "lockscreen.device_owner_info";
    private static String ENABLED_TRUST_AGENTS = "lockscreen.enabledtrustagents";
    private static String IS_TRUST_USUALLY_MANAGED = "lockscreen.istrustusuallymanaged";
    public static int MAX_ALLOWED_SEQUENCE = 3;
    public static String PROFILE_KEY_NAME_ENCRYPT = "profile_key_name_encrypt_";
    public static String PROFILE_KEY_NAME_DECRYPT = "profile_key_name_decrypt_";
    private Context mContext;
    private ContentResolver mContentResolver;
    private DevicePolicyManager mDevicePolicyManager;
    private ILockSettings mLockSettingsService;
    private UserManager mUserManager;

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isTrustUsuallyManaged(int userId) {
        if (!(this.mLockSettingsService instanceof ILockSettings.Stub)) {
            throw new IllegalStateException("May only be called by TrustManagerService. Use TrustManager.isTrustUsuallyManaged()");
        }
        try {
            return this.getLockSettings().getBoolean("lockscreen.istrustusuallymanaged", false, userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setTrustUsuallyManaged(boolean managed, int userId) {
        try {
            this.getLockSettings().setBoolean("lockscreen.istrustusuallymanaged", managed, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$userPresent(int userId) {
        try {
            this.getLockSettings().userPresent(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final DevicePolicyManager $$robo$$com_android_internal_widget_LockPatternUtils$getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e("LockPatternUtils", "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    private final UserManager $$robo$$com_android_internal_widget_LockPatternUtils$getUserManager() {
        if (this.mUserManager == null) {
            this.mUserManager = UserManager.get(this.mContext);
        }
        return this.mUserManager;
    }

    private final TrustManager $$robo$$com_android_internal_widget_LockPatternUtils$getTrustManager() {
        TrustManager trust = (TrustManager)this.mContext.getSystemService("trust");
        if (trust == null) {
            Log.e("LockPatternUtils", "Can't get TrustManagerService: is it running?", new IllegalStateException("Stack trace:"));
        }
        return trust;
    }

    private void $$robo$$com_android_internal_widget_LockPatternUtils$__constructor__(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
    }

    private final ILockSettings $$robo$$com_android_internal_widget_LockPatternUtils$getLockSettings() {
        if (this.mLockSettingsService == null) {
            ILockSettings service;
            this.mLockSettingsService = service = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        }
        return this.mLockSettingsService;
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedMinimumPasswordLength(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordQuality(int userId) {
        return this.getDevicePolicyManager().getPasswordQuality(null, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordHistoryLength(int userId) {
        return this.getDevicePolicyManager().getPasswordHistoryLength(null, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumLetters(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLetters(null, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumUpperCase(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumUpperCase(null, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumLowerCase(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLowerCase(null, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumNumeric(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumNumeric(null, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumSymbols(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumSymbols(null, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumNonLetter(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumNonLetter(null, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$reportFailedPasswordAttempt(int userId) {
        this.getDevicePolicyManager().reportFailedPasswordAttempt(userId);
        this.getTrustManager().reportUnlockAttempt(false, userId);
        this.requireStrongAuth(16, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$reportSuccessfulPasswordAttempt(int userId) {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt(userId);
        this.getTrustManager().reportUnlockAttempt(true, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getCurrentFailedPasswordAttempts(int userId) {
        return this.getDevicePolicyManager().getCurrentFailedPasswordAttempts(userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getMaximumFailedPasswordsForWipe(int userId) {
        return this.getDevicePolicyManager().getMaximumFailedPasswordsForWipe(null, userId);
    }

    private final byte[] $$robo$$com_android_internal_widget_LockPatternUtils$verifyPattern(List<LockPatternView.Cell> pattern, long challenge, int userId) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyPattern(LockPatternUtils.patternToString(pattern), challenge, userId);
            if (response == null) {
                return null;
            }
            if (response.getResponseCode() == 0) {
                return response.getPayload();
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return null;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$checkPattern(List<LockPatternView.Cell> pattern, int userId) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().checkPattern(LockPatternUtils.patternToString(pattern), userId);
            if (response.getResponseCode() == 0) {
                return true;
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return false;
        }
        catch (RemoteException re) {
            return true;
        }
    }

    private final byte[] $$robo$$com_android_internal_widget_LockPatternUtils$verifyPassword(String password, long challenge, int userId) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyPassword(password, challenge, userId);
            if (response.getResponseCode() == 0) {
                return response.getPayload();
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return null;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private final byte[] $$robo$$com_android_internal_widget_LockPatternUtils$verifyTiedProfileChallenge(String password, boolean isPattern, long challenge, int userId) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyTiedProfileChallenge(password, isPattern, challenge, userId);
            if (response.getResponseCode() == 0) {
                return response.getPayload();
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return null;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$checkPassword(String password, int userId) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().checkPassword(password, userId);
            if (response.getResponseCode() == 0) {
                return true;
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return false;
        }
        catch (RemoteException re) {
            return true;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$checkVoldPassword(int userId) {
        try {
            return this.getLockSettings().checkVoldPassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$checkPasswordHistory(String password, int userId) {
        String passwordHashString = new String(this.passwordToHash(password, userId), StandardCharsets.UTF_8);
        String passwordHistory = this.getString("lockscreen.passwordhistory", userId);
        if (passwordHistory == null) {
            return false;
        }
        int passwordHashLength = passwordHashString.length();
        int passwordHistoryLength = this.getRequestedPasswordHistoryLength(userId);
        if (passwordHistoryLength == 0) {
            return false;
        }
        int neededPasswordHistoryLength = passwordHashLength * passwordHistoryLength + passwordHistoryLength - 1;
        if (passwordHistory.length() > neededPasswordHistoryLength) {
            passwordHistory = passwordHistory.substring(0, neededPasswordHistoryLength);
        }
        return passwordHistory.contains(passwordHashString);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$savedPatternExists(int userId) {
        try {
            return this.getLockSettings().havePattern(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$savedPasswordExists(int userId) {
        try {
            return this.getLockSettings().havePassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isPatternEverChosen(int userId) {
        return this.getBoolean("lockscreen.patterneverchosen", false, userId);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getActivePasswordQuality(int userId) {
        int quality = this.getKeyguardStoredPasswordQuality(userId);
        if (this.isLockPasswordEnabled(quality, userId)) {
            return quality;
        }
        if (this.isLockPatternEnabled(quality, userId)) {
            return quality;
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$resetKeyStore(int userId) {
        try {
            this.getLockSettings().resetKeyStore(userId);
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Couldn't reset keystore " + e);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$clearLock(int userHandle) {
        this.setLong("lockscreen.password_type", 0L, userHandle);
        try {
            this.getLockSettings().setLockPassword(null, null, userHandle);
            this.getLockSettings().setLockPattern(null, null, userHandle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (userHandle == 0) {
            this.updateEncryptionPassword(1, null);
            this.setCredentialRequiredToDecrypt(false);
        }
        this.getDevicePolicyManager().setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
        this.onAfterChangingPassword(userHandle);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setLockScreenDisabled(boolean disable, int userId) {
        this.setBoolean("lockscreen.disabled", disable, userId);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLockScreenDisabled(int userId) {
        return !this.isSecure(userId) && this.getBoolean("lockscreen.disabled", false, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPattern(List<LockPatternView.Cell> pattern, int userId) {
        this.saveLockPattern(pattern, null, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPattern(List<LockPatternView.Cell> pattern, String savedPattern, int userId) {
        try {
            if (pattern == null || pattern.size() < 4) {
                throw new IllegalArgumentException("pattern must not be null and at least 4 dots long.");
            }
            this.getLockSettings().setLockPattern(LockPatternUtils.patternToString(pattern), savedPattern, userId);
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (userId == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                if (!this.shouldEncryptWithCredentials(true)) {
                    this.clearEncryptionPassword();
                } else {
                    String stringPattern = LockPatternUtils.patternToString(pattern);
                    this.updateEncryptionPassword(2, stringPattern);
                }
            }
            this.setBoolean("lockscreen.patterneverchosen", true, userId);
            this.setLong("lockscreen.password_type", 65536L, userId);
            dpm.setActivePasswordState(65536, pattern.size(), 0, 0, 0, 0, 0, 0, userId);
            this.onAfterChangingPassword(userId);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't save lock pattern " + re);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$updateCryptoUserInfo(int userId) {
        if (userId != 0) {
            return;
        }
        String ownerInfo = this.isOwnerInfoEnabled(userId) ? this.getOwnerInfo(userId) : "";
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e("LockPatternUtils", "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            Log.d("LockPatternUtils", "Setting owner info");
            mountService.setField("OwnerInfo", ownerInfo);
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Error changing user info", e);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setOwnerInfo(String info, int userId) {
        this.setString("lock_screen_owner_info", info, userId);
        this.updateCryptoUserInfo(userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setOwnerInfoEnabled(boolean enabled, int userId) {
        this.setBoolean("lock_screen_owner_info_enabled", enabled, userId);
        this.updateCryptoUserInfo(userId);
    }

    private final String $$robo$$com_android_internal_widget_LockPatternUtils$getOwnerInfo(int userId) {
        return this.getString("lock_screen_owner_info", userId);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isOwnerInfoEnabled(int userId) {
        return this.getBoolean("lock_screen_owner_info_enabled", false, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setDeviceOwnerInfo(String info) {
        if (info != null && info.isEmpty()) {
            info = null;
        }
        this.setString("lockscreen.device_owner_info", info, 0);
    }

    private final String $$robo$$com_android_internal_widget_LockPatternUtils$getDeviceOwnerInfo() {
        return this.getString("lockscreen.device_owner_info", 0);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isDeviceOwnerInfoEnabled() {
        return this.getDeviceOwnerInfo() != null;
    }

    private static final int $$robo$$com_android_internal_widget_LockPatternUtils$computePasswordQuality(String password) {
        boolean hasDigit = false;
        boolean hasNonDigit = false;
        int len = password.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(password.charAt(i))) {
                hasDigit = true;
                continue;
            }
            hasNonDigit = true;
        }
        if (hasNonDigit && hasDigit) {
            return 327680;
        }
        if (hasNonDigit) {
            return 262144;
        }
        if (hasDigit) {
            return LockPatternUtils.maxLengthSequence(password) > 3 ? 131072 : 196608;
        }
        return 0;
    }

    private static final int $$robo$$com_android_internal_widget_LockPatternUtils$categoryChar(char c) {
        if ('a' <= c && c <= 'z') {
            return 0;
        }
        if ('A' <= c && c <= 'Z') {
            return 1;
        }
        if ('0' <= c && c <= '9') {
            return 2;
        }
        return 3;
    }

    private static final int $$robo$$com_android_internal_widget_LockPatternUtils$maxDiffCategory(int category) {
        if (category == 0 || category == 1) {
            return 1;
        }
        if (category == 2) {
            return 10;
        }
        return 0;
    }

    private static final int $$robo$$com_android_internal_widget_LockPatternUtils$maxLengthSequence(String string2) {
        if (string2.length() == 0) {
            return 0;
        }
        char previousChar = string2.charAt(0);
        int category = LockPatternUtils.categoryChar(previousChar);
        int diff = 0;
        boolean hasDiff = false;
        int maxLength = 0;
        int startSequence = 0;
        for (int current = 1; current < string2.length(); ++current) {
            char currentChar = string2.charAt(current);
            int categoryCurrent = LockPatternUtils.categoryChar(currentChar);
            int currentDiff = currentChar - previousChar;
            if (categoryCurrent != category || Math.abs(currentDiff) > LockPatternUtils.maxDiffCategory(category)) {
                maxLength = Math.max(maxLength, current - startSequence);
                startSequence = current;
                hasDiff = false;
                category = categoryCurrent;
            } else {
                if (hasDiff && currentDiff != diff) {
                    maxLength = Math.max(maxLength, current - startSequence);
                    startSequence = current - 1;
                }
                diff = currentDiff;
                hasDiff = true;
            }
            previousChar = currentChar;
        }
        maxLength = Math.max(maxLength, string2.length() - startSequence);
        return maxLength;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$updateEncryptionPassword(int type, String password) {
        if (!LockPatternUtils.isDeviceEncryptionEnabled()) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e("LockPatternUtils", "Could not find the mount service to update the encryption password");
            return;
        }
        new AsyncTask<Void, Void, Void>(this, service, type, password){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IBinder val$service;
            /* synthetic */ int val$type;
            /* synthetic */ String val$password;
            /* synthetic */ LockPatternUtils this$0;

            private void $$robo$$com_android_internal_widget_LockPatternUtils_1$__constructor__(LockPatternUtils this$0, IBinder iBinder, int n, String string2) {
            }

            private final Void $$robo$$com_android_internal_widget_LockPatternUtils_1$doInBackground(Void ... dummy) {
                IMountService mountService = IMountService.Stub.asInterface(this.val$service);
                try {
                    mountService.changeEncryptionPassword(this.val$type, this.val$password);
                }
                catch (RemoteException e) {
                    Log.e("LockPatternUtils", "Error changing encryption password", e);
                }
                return null;
            }

            private void __constructor__(LockPatternUtils lockPatternUtils, IBinder iBinder, int n, String string2) {
                this.$$robo$$com_android_internal_widget_LockPatternUtils_1$__constructor__(lockPatternUtils, iBinder, n, string2);
            }
            {
                this.this$0 = lockPatternUtils;
                this.val$service = iBinder;
                this.val$type = n;
                this.val$password = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils_1$__constructor__(com.android.internal.widget.LockPatternUtils android.os.IBinder int java.lang.String ), 0, this, lockPatternUtils, iBinder, n, string2);
            }

            protected Void doInBackground(Void ... voidArray) {
                return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$com_android_internal_widget_LockPatternUtils_1$doInBackground(java.lang.Void[] ), 0, this, voidArray);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }.execute(new Void[0]);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPassword(String password, String savedPassword, int quality, int userHandle) {
        try {
            int passwordHistoryLength;
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (password == null || password.length() < 4) {
                throw new IllegalArgumentException("password must not be null and at least of length 4");
            }
            this.getLockSettings().setLockPassword(password, savedPassword, userHandle);
            this.getLockSettings().setSeparateProfileChallengeEnabled(userHandle, true, null);
            int computedQuality = LockPatternUtils.computePasswordQuality(password);
            if (userHandle == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                if (!this.shouldEncryptWithCredentials(true)) {
                    this.clearEncryptionPassword();
                } else {
                    boolean numeric = computedQuality == 131072;
                    boolean numericComplex = computedQuality == 196608;
                    int type = numeric || numericComplex ? 3 : 0;
                    this.updateEncryptionPassword(type, password);
                }
            }
            this.setLong("lockscreen.password_type", Math.max(quality, computedQuality), userHandle);
            if (computedQuality != 0) {
                int letters = 0;
                int uppercase = 0;
                int lowercase = 0;
                int numbers = 0;
                int symbols = 0;
                int nonletter = 0;
                for (int i = 0; i < password.length(); ++i) {
                    char c = password.charAt(i);
                    if (c >= 'A' && c <= 'Z') {
                        ++letters;
                        ++uppercase;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        ++letters;
                        ++lowercase;
                        continue;
                    }
                    if (c >= '0' && c <= '9') {
                        ++numbers;
                        ++nonletter;
                        continue;
                    }
                    ++symbols;
                    ++nonletter;
                }
                dpm.setActivePasswordState(Math.max(quality, computedQuality), password.length(), letters, uppercase, lowercase, numbers, symbols, nonletter, userHandle);
            } else {
                dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
            }
            String passwordHistory = this.getString("lockscreen.passwordhistory", userHandle);
            if (passwordHistory == null) {
                passwordHistory = "";
            }
            if ((passwordHistoryLength = this.getRequestedPasswordHistoryLength(userHandle)) == 0) {
                passwordHistory = "";
            } else {
                byte[] hash = this.passwordToHash(password, userHandle);
                passwordHistory = new String(hash, StandardCharsets.UTF_8) + "," + passwordHistory;
                passwordHistory = passwordHistory.substring(0, Math.min(hash.length * passwordHistoryLength + passwordHistoryLength - 1, passwordHistory.length()));
            }
            this.setString("lockscreen.passwordhistory", passwordHistory, userHandle);
            this.onAfterChangingPassword(userHandle);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Unable to save lock password " + re);
        }
    }

    private static final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isDeviceEncryptionEnabled() {
        return StorageManager.isEncrypted();
    }

    private static final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isFileEncryptionEnabled() {
        return StorageManager.isFileEncryptedNativeOrEmulated();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$clearEncryptionPassword() {
        this.updateEncryptionPassword(1, null);
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getKeyguardStoredPasswordQuality(int userHandle) {
        return (int)this.getLong("lockscreen.password_type", 0L, userHandle);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setSeparateProfileChallengeEnabled(int userHandle, boolean enabled, String managedUserPassword) {
        UserInfo info = this.getUserManager().getUserInfo(userHandle);
        if (info.isManagedProfile()) {
            try {
                this.getLockSettings().setSeparateProfileChallengeEnabled(userHandle, enabled, managedUserPassword);
                this.onAfterChangingPassword(userHandle);
            }
            catch (RemoteException e) {
                Log.e("LockPatternUtils", "Couldn't update work profile challenge enabled");
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isSeparateProfileChallengeEnabled(int userHandle) {
        UserInfo info = this.getUserManager().getUserInfo(userHandle);
        if (info == null || !info.isManagedProfile()) {
            return false;
        }
        try {
            return this.getLockSettings().getSeparateProfileChallengeEnabled(userHandle);
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Couldn't get separate profile challenge enabled");
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isSeparateProfileChallengeAllowed(int userHandle) {
        UserInfo info = this.getUserManager().getUserInfo(userHandle);
        if (info == null || !info.isManagedProfile()) {
            return false;
        }
        return this.getDevicePolicyManager().isSeparateProfileChallengeAllowed(userHandle);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isSeparateProfileChallengeAllowedToUnify(int userHandle) {
        return this.getDevicePolicyManager().isProfileActivePasswordSufficientForParent(userHandle);
    }

    private static final List<LockPatternView.Cell> $$robo$$com_android_internal_widget_LockPatternUtils$stringToPattern(String string2) {
        if (string2 == null) {
            return null;
        }
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        byte[] bytes = string2.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = (byte)(bytes[i] - 49);
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    private static final String $$robo$$com_android_internal_widget_LockPatternUtils$patternToString(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn() + 49);
        }
        return new String(res);
    }

    private static final String $$robo$$com_android_internal_widget_LockPatternUtils$patternStringToBaseZero(String pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.length();
        byte[] res = new byte[patternSize];
        byte[] bytes = pattern.getBytes();
        for (int i = 0; i < patternSize; ++i) {
            res[i] = (byte)(bytes[i] - 49);
        }
        return new String(res);
    }

    private static final byte[] $$robo$$com_android_internal_widget_LockPatternUtils$patternToHash(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return null;
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(res);
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            return res;
        }
    }

    private final String $$robo$$com_android_internal_widget_LockPatternUtils$getSalt(int userId) {
        long salt = this.getLong("lockscreen.password_salt", 0L, userId);
        if (salt == 0L) {
            try {
                salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                this.setLong("lockscreen.password_salt", salt, userId);
                Log.v("LockPatternUtils", "Initialized lock password salt for user: " + userId);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Couldn't get SecureRandom number", e);
            }
        }
        return Long.toHexString(salt);
    }

    private final byte[] $$robo$$com_android_internal_widget_LockPatternUtils$passwordToHash(String password, int userId) {
        if (password == null) {
            return null;
        }
        try {
            byte[] saltedPassword = (password + this.getSalt(userId)).getBytes();
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            byte[] combined = new byte[sha1.length + md5.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])sha1, (int)0, (byte[])combined, (int)0, (int)sha1.length);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])md5, (int)0, (byte[])combined, (int)sha1.length, (int)md5.length);
            char[] hexEncoded = HexEncoding.encode(combined);
            return new String(hexEncoded).getBytes(StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Missing digest algorithm: ", e);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isSecure(int userId) {
        int mode = this.getKeyguardStoredPasswordQuality(userId);
        return this.isLockPatternEnabled(mode, userId) || this.isLockPasswordEnabled(mode, userId);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLockPasswordEnabled(int userId) {
        return this.isLockPasswordEnabled(this.getKeyguardStoredPasswordQuality(userId), userId);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLockPasswordEnabled(int mode, int userId) {
        boolean passwordEnabled = mode == 262144 || mode == 131072 || mode == 196608 || mode == 327680 || mode == 393216 || mode == 524288;
        return passwordEnabled && this.savedPasswordExists(userId);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLockPatternEnabled(int userId) {
        return this.isLockPatternEnabled(this.getKeyguardStoredPasswordQuality(userId), userId);
    }

    @Deprecated
    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLegacyLockPatternEnabled(int userId) {
        return this.getBoolean("legacy_lock_pattern_enabled", true, userId);
    }

    @Deprecated
    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setLegacyLockPatternEnabled(int userId) {
        this.setBoolean("lock_pattern_autolock", true, userId);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isLockPatternEnabled(int mode, int userId) {
        return mode == 65536 && this.savedPatternExists(userId);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isVisiblePatternEnabled(int userId) {
        return this.getBoolean("lock_pattern_visible_pattern", false, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setVisiblePatternEnabled(boolean enabled, int userId) {
        this.setBoolean("lock_pattern_visible_pattern", enabled, userId);
        if (userId != 0) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e("LockPatternUtils", "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            mountService.setField("PatternVisible", enabled ? "1" : "0");
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Error changing pattern visible state", e);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setVisiblePasswordEnabled(boolean enabled, int userId) {
        if (userId != 0) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e("LockPatternUtils", "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            mountService.setField("PasswordVisible", enabled ? "1" : "0");
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Error changing password visible state", e);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isTactileFeedbackEnabled() {
        return Settings.System.getIntForUser(this.mContentResolver, "haptic_feedback_enabled", 1, -2) != 0;
    }

    private final long $$robo$$com_android_internal_widget_LockPatternUtils$setLockoutAttemptDeadline(int userId, int timeoutMs) {
        long deadline = SystemClock.elapsedRealtime() + (long)timeoutMs;
        this.setLong("lockscreen.lockoutattemptdeadline", deadline, userId);
        this.setLong("lockscreen.lockoutattempttimeoutmss", timeoutMs, userId);
        return deadline;
    }

    private final long $$robo$$com_android_internal_widget_LockPatternUtils$getLockoutAttemptDeadline(int userId) {
        long deadline = this.getLong("lockscreen.lockoutattemptdeadline", 0L, userId);
        long timeoutMs = this.getLong("lockscreen.lockoutattempttimeoutmss", 0L, userId);
        long now = SystemClock.elapsedRealtime();
        if (deadline < now && deadline != 0L) {
            this.setLong("lockscreen.lockoutattemptdeadline", 0L, userId);
            this.setLong("lockscreen.lockoutattempttimeoutmss", 0L, userId);
            return 0L;
        }
        if (deadline > now + timeoutMs) {
            deadline = now + timeoutMs;
            this.setLong("lockscreen.lockoutattemptdeadline", deadline, userId);
        }
        return deadline;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$getBoolean(String secureSettingKey, boolean defaultValue, int userId) {
        try {
            return this.getLockSettings().getBoolean(secureSettingKey, defaultValue, userId);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setBoolean(String secureSettingKey, boolean enabled, int userId) {
        try {
            this.getLockSettings().setBoolean(secureSettingKey, enabled, userId);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't write boolean " + secureSettingKey + re);
        }
    }

    private final long $$robo$$com_android_internal_widget_LockPatternUtils$getLong(String secureSettingKey, long defaultValue, int userHandle) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, userHandle);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setLong(String secureSettingKey, long value, int userHandle) {
        try {
            this.getLockSettings().setLong(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't write long " + secureSettingKey + re);
        }
    }

    private final String $$robo$$com_android_internal_widget_LockPatternUtils$getString(String secureSettingKey, int userHandle) {
        try {
            return this.getLockSettings().getString(secureSettingKey, null, userHandle);
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setString(String secureSettingKey, String value, int userHandle) {
        try {
            this.getLockSettings().setString(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e("LockPatternUtils", "Couldn't write string " + secureSettingKey + re);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setPowerButtonInstantlyLocks(boolean enabled, int userId) {
        this.setBoolean("lockscreen.power_button_instantly_locks", enabled, userId);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$getPowerButtonInstantlyLocks(int userId) {
        return this.getBoolean("lockscreen.power_button_instantly_locks", true, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setEnabledTrustAgents(Collection<ComponentName> activeTrustAgents, int userId) {
        StringBuilder sb = new StringBuilder();
        for (ComponentName cn : activeTrustAgents) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(cn.flattenToShortString());
        }
        this.setString("lockscreen.enabledtrustagents", sb.toString(), userId);
        this.getTrustManager().reportEnabledTrustAgentsChanged(userId);
    }

    private final List<ComponentName> $$robo$$com_android_internal_widget_LockPatternUtils$getEnabledTrustAgents(int userId) {
        String serialized = this.getString("lockscreen.enabledtrustagents", userId);
        if (TextUtils.isEmpty(serialized)) {
            return null;
        }
        String[] split = serialized.split(",");
        ArrayList<ComponentName> activeTrustAgents = new ArrayList<ComponentName>(split.length);
        for (String s : split) {
            if (TextUtils.isEmpty(s)) continue;
            activeTrustAgents.add(ComponentName.unflattenFromString(s));
        }
        return activeTrustAgents;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$requireCredentialEntry(int userId) {
        this.requireStrongAuth(4, userId);
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$requireStrongAuth(int strongAuthReason, int userId) {
        try {
            this.getLockSettings().requireStrongAuth(strongAuthReason, userId);
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Error while requesting strong auth: " + e);
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$onAfterChangingPassword(int userHandle) {
        this.getTrustManager().reportEnabledTrustAgentsChanged(userHandle);
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isCredentialRequiredToDecrypt(boolean defaultValue) {
        int value = Settings.Global.getInt(this.mContentResolver, "require_password_to_decrypt", -1);
        return value == -1 ? defaultValue : value != 0;
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$setCredentialRequiredToDecrypt(boolean required) {
        if (!this.getUserManager().isSystemUser() && !this.getUserManager().isPrimaryUser()) {
            throw new IllegalStateException("Only the system or primary user may call setCredentialRequiredForDecrypt()");
        }
        if (LockPatternUtils.isDeviceEncryptionEnabled()) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "require_password_to_decrypt", required ? 1 : 0);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isDoNotAskCredentialsOnBootSet() {
        return this.mDevicePolicyManager.getDoNotAskCredentialsOnBoot();
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$shouldEncryptWithCredentials(boolean defaultValue) {
        return this.isCredentialRequiredToDecrypt(defaultValue) && !this.isDoNotAskCredentialsOnBootSet();
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$throwIfCalledOnMainThread() {
        if (Looper.getMainLooper().isCurrentThread()) {
            throw new IllegalStateException("should not be called from the main thread.");
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$registerStrongAuthTracker(StrongAuthTracker strongAuthTracker) {
        try {
            this.getLockSettings().registerStrongAuthTracker(strongAuthTracker.mStub);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Could not register StrongAuthTracker");
        }
    }

    private final void $$robo$$com_android_internal_widget_LockPatternUtils$unregisterStrongAuthTracker(StrongAuthTracker strongAuthTracker) {
        try {
            this.getLockSettings().unregisterStrongAuthTracker(strongAuthTracker.mStub);
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Could not unregister StrongAuthTracker", e);
        }
    }

    private final int $$robo$$com_android_internal_widget_LockPatternUtils$getStrongAuthForUser(int userId) {
        try {
            return this.getLockSettings().getStrongAuthForUser(userId);
        }
        catch (RemoteException e) {
            Log.e("LockPatternUtils", "Could not get StrongAuth", e);
            return StrongAuthTracker.getDefaultFlags(this.mContext);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isTrustAllowedForUser(int userId) {
        return this.getStrongAuthForUser(userId) == 0;
    }

    private final boolean $$robo$$com_android_internal_widget_LockPatternUtils$isFingerprintAllowedForUser(int userId) {
        return (this.getStrongAuthForUser(userId) & 0xFFFFFFEB) == 0;
    }

    public boolean isTrustUsuallyManaged(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTrustUsuallyManaged", $$robo$$com_android_internal_widget_LockPatternUtils$isTrustUsuallyManaged(int ), 0, this, n);
    }

    public void setTrustUsuallyManaged(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setTrustUsuallyManaged", $$robo$$com_android_internal_widget_LockPatternUtils$setTrustUsuallyManaged(boolean int ), 0, this, bl, n);
    }

    public void userPresent(int n) {
        InvokeDynamicSupport.bootstrap("userPresent", $$robo$$com_android_internal_widget_LockPatternUtils$userPresent(int ), 0, this, n);
    }

    public DevicePolicyManager getDevicePolicyManager() {
        return InvokeDynamicSupport.bootstrap("getDevicePolicyManager", $$robo$$com_android_internal_widget_LockPatternUtils$getDevicePolicyManager(), 0, this);
    }

    private UserManager getUserManager() {
        return InvokeDynamicSupport.bootstrap("getUserManager", $$robo$$com_android_internal_widget_LockPatternUtils$getUserManager(), 0, this);
    }

    private TrustManager getTrustManager() {
        return InvokeDynamicSupport.bootstrap("getTrustManager", $$robo$$com_android_internal_widget_LockPatternUtils$getTrustManager(), 0, this);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_LockPatternUtils$__constructor__(context);
    }

    public LockPatternUtils(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils$__constructor__(android.content.Context ), 0, this, context);
    }

    private ILockSettings getLockSettings() {
        return InvokeDynamicSupport.bootstrap("getLockSettings", $$robo$$com_android_internal_widget_LockPatternUtils$getLockSettings(), 0, this);
    }

    public int getRequestedMinimumPasswordLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedMinimumPasswordLength", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedMinimumPasswordLength(int ), 0, this, n);
    }

    public int getRequestedPasswordQuality(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordQuality(int ), 0, this, n);
    }

    private int getRequestedPasswordHistoryLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordHistoryLength", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordHistoryLength(int ), 0, this, n);
    }

    public int getRequestedPasswordMinimumLetters(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumLetters", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumLetters(int ), 0, this, n);
    }

    public int getRequestedPasswordMinimumUpperCase(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumUpperCase", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumUpperCase(int ), 0, this, n);
    }

    public int getRequestedPasswordMinimumLowerCase(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumLowerCase", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumLowerCase(int ), 0, this, n);
    }

    public int getRequestedPasswordMinimumNumeric(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumNumeric", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumNumeric(int ), 0, this, n);
    }

    public int getRequestedPasswordMinimumSymbols(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumSymbols", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumSymbols(int ), 0, this, n);
    }

    public int getRequestedPasswordMinimumNonLetter(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedPasswordMinimumNonLetter", $$robo$$com_android_internal_widget_LockPatternUtils$getRequestedPasswordMinimumNonLetter(int ), 0, this, n);
    }

    public void reportFailedPasswordAttempt(int n) {
        InvokeDynamicSupport.bootstrap("reportFailedPasswordAttempt", $$robo$$com_android_internal_widget_LockPatternUtils$reportFailedPasswordAttempt(int ), 0, this, n);
    }

    public void reportSuccessfulPasswordAttempt(int n) {
        InvokeDynamicSupport.bootstrap("reportSuccessfulPasswordAttempt", $$robo$$com_android_internal_widget_LockPatternUtils$reportSuccessfulPasswordAttempt(int ), 0, this, n);
    }

    public int getCurrentFailedPasswordAttempts(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentFailedPasswordAttempts", $$robo$$com_android_internal_widget_LockPatternUtils$getCurrentFailedPasswordAttempts(int ), 0, this, n);
    }

    public int getMaximumFailedPasswordsForWipe(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumFailedPasswordsForWipe", $$robo$$com_android_internal_widget_LockPatternUtils$getMaximumFailedPasswordsForWipe(int ), 0, this, n);
    }

    public byte[] verifyPattern(List<LockPatternView.Cell> list, long l, int n) throws RequestThrottledException {
        return InvokeDynamicSupport.bootstrap("verifyPattern", $$robo$$com_android_internal_widget_LockPatternUtils$verifyPattern(java.util.List<com.android.internal.widget.LockPatternView$Cell> long int ), 0, this, list, l, n);
    }

    public boolean checkPattern(List<LockPatternView.Cell> list, int n) throws RequestThrottledException {
        return (boolean)InvokeDynamicSupport.bootstrap("checkPattern", $$robo$$com_android_internal_widget_LockPatternUtils$checkPattern(java.util.List<com.android.internal.widget.LockPatternView$Cell> int ), 0, this, list, n);
    }

    public byte[] verifyPassword(String string2, long l, int n) throws RequestThrottledException {
        return InvokeDynamicSupport.bootstrap("verifyPassword", $$robo$$com_android_internal_widget_LockPatternUtils$verifyPassword(java.lang.String long int ), 0, this, string2, l, n);
    }

    public byte[] verifyTiedProfileChallenge(String string2, boolean bl, long l, int n) throws RequestThrottledException {
        return InvokeDynamicSupport.bootstrap("verifyTiedProfileChallenge", $$robo$$com_android_internal_widget_LockPatternUtils$verifyTiedProfileChallenge(java.lang.String boolean long int ), 0, this, string2, bl, l, n);
    }

    public boolean checkPassword(String string2, int n) throws RequestThrottledException {
        return (boolean)InvokeDynamicSupport.bootstrap("checkPassword", $$robo$$com_android_internal_widget_LockPatternUtils$checkPassword(java.lang.String int ), 0, this, string2, n);
    }

    public boolean checkVoldPassword(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkVoldPassword", $$robo$$com_android_internal_widget_LockPatternUtils$checkVoldPassword(int ), 0, this, n);
    }

    public boolean checkPasswordHistory(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkPasswordHistory", $$robo$$com_android_internal_widget_LockPatternUtils$checkPasswordHistory(java.lang.String int ), 0, this, string2, n);
    }

    private boolean savedPatternExists(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("savedPatternExists", $$robo$$com_android_internal_widget_LockPatternUtils$savedPatternExists(int ), 0, this, n);
    }

    private boolean savedPasswordExists(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("savedPasswordExists", $$robo$$com_android_internal_widget_LockPatternUtils$savedPasswordExists(int ), 0, this, n);
    }

    public boolean isPatternEverChosen(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPatternEverChosen", $$robo$$com_android_internal_widget_LockPatternUtils$isPatternEverChosen(int ), 0, this, n);
    }

    public int getActivePasswordQuality(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getActivePasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$getActivePasswordQuality(int ), 0, this, n);
    }

    public void resetKeyStore(int n) {
        InvokeDynamicSupport.bootstrap("resetKeyStore", $$robo$$com_android_internal_widget_LockPatternUtils$resetKeyStore(int ), 0, this, n);
    }

    public void clearLock(int n) {
        InvokeDynamicSupport.bootstrap("clearLock", $$robo$$com_android_internal_widget_LockPatternUtils$clearLock(int ), 0, this, n);
    }

    public void setLockScreenDisabled(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setLockScreenDisabled", $$robo$$com_android_internal_widget_LockPatternUtils$setLockScreenDisabled(boolean int ), 0, this, bl, n);
    }

    public boolean isLockScreenDisabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockScreenDisabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLockScreenDisabled(int ), 0, this, n);
    }

    public void saveLockPattern(List<LockPatternView.Cell> list, int n) {
        InvokeDynamicSupport.bootstrap("saveLockPattern", $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPattern(java.util.List<com.android.internal.widget.LockPatternView$Cell> int ), 0, this, list, n);
    }

    public void saveLockPattern(List<LockPatternView.Cell> list, String string2, int n) {
        InvokeDynamicSupport.bootstrap("saveLockPattern", $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPattern(java.util.List<com.android.internal.widget.LockPatternView$Cell> java.lang.String int ), 0, this, list, string2, n);
    }

    private void updateCryptoUserInfo(int n) {
        InvokeDynamicSupport.bootstrap("updateCryptoUserInfo", $$robo$$com_android_internal_widget_LockPatternUtils$updateCryptoUserInfo(int ), 0, this, n);
    }

    public void setOwnerInfo(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setOwnerInfo", $$robo$$com_android_internal_widget_LockPatternUtils$setOwnerInfo(java.lang.String int ), 0, this, string2, n);
    }

    public void setOwnerInfoEnabled(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setOwnerInfoEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setOwnerInfoEnabled(boolean int ), 0, this, bl, n);
    }

    public String getOwnerInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getOwnerInfo", $$robo$$com_android_internal_widget_LockPatternUtils$getOwnerInfo(int ), 0, this, n);
    }

    public boolean isOwnerInfoEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOwnerInfoEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isOwnerInfoEnabled(int ), 0, this, n);
    }

    public void setDeviceOwnerInfo(String string2) {
        InvokeDynamicSupport.bootstrap("setDeviceOwnerInfo", $$robo$$com_android_internal_widget_LockPatternUtils$setDeviceOwnerInfo(java.lang.String ), 0, this, string2);
    }

    public String getDeviceOwnerInfo() {
        return InvokeDynamicSupport.bootstrap("getDeviceOwnerInfo", $$robo$$com_android_internal_widget_LockPatternUtils$getDeviceOwnerInfo(), 0, this);
    }

    public boolean isDeviceOwnerInfoEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceOwnerInfoEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isDeviceOwnerInfoEnabled(), 0, this);
    }

    public static int computePasswordQuality(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("computePasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$computePasswordQuality(java.lang.String ), 0, (String)string2);
    }

    private static int categoryChar(char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("categoryChar", $$robo$$com_android_internal_widget_LockPatternUtils$categoryChar(char ), 0, (char)c);
    }

    private static int maxDiffCategory(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("maxDiffCategory", $$robo$$com_android_internal_widget_LockPatternUtils$maxDiffCategory(int ), 0, (int)n);
    }

    public static int maxLengthSequence(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("maxLengthSequence", $$robo$$com_android_internal_widget_LockPatternUtils$maxLengthSequence(java.lang.String ), 0, (String)string2);
    }

    private void updateEncryptionPassword(int n, String string2) {
        InvokeDynamicSupport.bootstrap("updateEncryptionPassword", $$robo$$com_android_internal_widget_LockPatternUtils$updateEncryptionPassword(int java.lang.String ), 0, this, n, string2);
    }

    public void saveLockPassword(String string2, String string3, int n, int n2) {
        InvokeDynamicSupport.bootstrap("saveLockPassword", $$robo$$com_android_internal_widget_LockPatternUtils$saveLockPassword(java.lang.String java.lang.String int int ), 0, this, string2, string3, n, n2);
    }

    public static boolean isDeviceEncryptionEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDeviceEncryptionEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isDeviceEncryptionEnabled(), 0);
    }

    public static boolean isFileEncryptionEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFileEncryptionEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isFileEncryptionEnabled(), 0);
    }

    public void clearEncryptionPassword() {
        InvokeDynamicSupport.bootstrap("clearEncryptionPassword", $$robo$$com_android_internal_widget_LockPatternUtils$clearEncryptionPassword(), 0, this);
    }

    public int getKeyguardStoredPasswordQuality(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getKeyguardStoredPasswordQuality", $$robo$$com_android_internal_widget_LockPatternUtils$getKeyguardStoredPasswordQuality(int ), 0, this, n);
    }

    public void setSeparateProfileChallengeEnabled(int n, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("setSeparateProfileChallengeEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setSeparateProfileChallengeEnabled(int boolean java.lang.String ), 0, this, n, bl, string2);
    }

    public boolean isSeparateProfileChallengeEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSeparateProfileChallengeEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isSeparateProfileChallengeEnabled(int ), 0, this, n);
    }

    public boolean isSeparateProfileChallengeAllowed(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSeparateProfileChallengeAllowed", $$robo$$com_android_internal_widget_LockPatternUtils$isSeparateProfileChallengeAllowed(int ), 0, this, n);
    }

    public boolean isSeparateProfileChallengeAllowedToUnify(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSeparateProfileChallengeAllowedToUnify", $$robo$$com_android_internal_widget_LockPatternUtils$isSeparateProfileChallengeAllowedToUnify(int ), 0, this, n);
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stringToPattern", $$robo$$com_android_internal_widget_LockPatternUtils$stringToPattern(java.lang.String ), 0, (String)string2);
    }

    public static String patternToString(List<LockPatternView.Cell> list) {
        return InvokeDynamicSupport.bootstrapStatic("patternToString", $$robo$$com_android_internal_widget_LockPatternUtils$patternToString(java.util.List<com.android.internal.widget.LockPatternView$Cell> ), 0, list);
    }

    public static String patternStringToBaseZero(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("patternStringToBaseZero", $$robo$$com_android_internal_widget_LockPatternUtils$patternStringToBaseZero(java.lang.String ), 0, (String)string2);
    }

    public static byte[] patternToHash(List<LockPatternView.Cell> list) {
        return InvokeDynamicSupport.bootstrapStatic("patternToHash", $$robo$$com_android_internal_widget_LockPatternUtils$patternToHash(java.util.List<com.android.internal.widget.LockPatternView$Cell> ), 0, list);
    }

    private String getSalt(int n) {
        return InvokeDynamicSupport.bootstrap("getSalt", $$robo$$com_android_internal_widget_LockPatternUtils$getSalt(int ), 0, this, n);
    }

    public byte[] passwordToHash(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("passwordToHash", $$robo$$com_android_internal_widget_LockPatternUtils$passwordToHash(java.lang.String int ), 0, this, string2, n);
    }

    public boolean isSecure(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$com_android_internal_widget_LockPatternUtils$isSecure(int ), 0, this, n);
    }

    public boolean isLockPasswordEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockPasswordEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLockPasswordEnabled(int ), 0, this, n);
    }

    private boolean isLockPasswordEnabled(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockPasswordEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLockPasswordEnabled(int int ), 0, this, n, n2);
    }

    public boolean isLockPatternEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockPatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLockPatternEnabled(int ), 0, this, n);
    }

    @Deprecated
    public boolean isLegacyLockPatternEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLegacyLockPatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLegacyLockPatternEnabled(int ), 0, this, n);
    }

    @Deprecated
    public void setLegacyLockPatternEnabled(int n) {
        InvokeDynamicSupport.bootstrap("setLegacyLockPatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setLegacyLockPatternEnabled(int ), 0, this, n);
    }

    private boolean isLockPatternEnabled(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLockPatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isLockPatternEnabled(int int ), 0, this, n, n2);
    }

    public boolean isVisiblePatternEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisiblePatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isVisiblePatternEnabled(int ), 0, this, n);
    }

    public void setVisiblePatternEnabled(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setVisiblePatternEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setVisiblePatternEnabled(boolean int ), 0, this, bl, n);
    }

    public void setVisiblePasswordEnabled(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setVisiblePasswordEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$setVisiblePasswordEnabled(boolean int ), 0, this, bl, n);
    }

    public boolean isTactileFeedbackEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTactileFeedbackEnabled", $$robo$$com_android_internal_widget_LockPatternUtils$isTactileFeedbackEnabled(), 0, this);
    }

    public long setLockoutAttemptDeadline(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("setLockoutAttemptDeadline", $$robo$$com_android_internal_widget_LockPatternUtils$setLockoutAttemptDeadline(int int ), 0, this, n, n2);
    }

    public long getLockoutAttemptDeadline(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getLockoutAttemptDeadline", $$robo$$com_android_internal_widget_LockPatternUtils$getLockoutAttemptDeadline(int ), 0, this, n);
    }

    private boolean getBoolean(String string2, boolean bl, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$com_android_internal_widget_LockPatternUtils$getBoolean(java.lang.String boolean int ), 0, this, string2, bl, n);
    }

    private void setBoolean(String string2, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setBoolean", $$robo$$com_android_internal_widget_LockPatternUtils$setBoolean(java.lang.String boolean int ), 0, this, string2, bl, n);
    }

    private long getLong(String string2, long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$com_android_internal_widget_LockPatternUtils$getLong(java.lang.String long int ), 0, this, string2, l, n);
    }

    private void setLong(String string2, long l, int n) {
        InvokeDynamicSupport.bootstrap("setLong", $$robo$$com_android_internal_widget_LockPatternUtils$setLong(java.lang.String long int ), 0, this, string2, l, n);
    }

    private String getString(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$com_android_internal_widget_LockPatternUtils$getString(java.lang.String int ), 0, this, string2, n);
    }

    private void setString(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("setString", $$robo$$com_android_internal_widget_LockPatternUtils$setString(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    public void setPowerButtonInstantlyLocks(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setPowerButtonInstantlyLocks", $$robo$$com_android_internal_widget_LockPatternUtils$setPowerButtonInstantlyLocks(boolean int ), 0, this, bl, n);
    }

    public boolean getPowerButtonInstantlyLocks(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPowerButtonInstantlyLocks", $$robo$$com_android_internal_widget_LockPatternUtils$getPowerButtonInstantlyLocks(int ), 0, this, n);
    }

    public void setEnabledTrustAgents(Collection<ComponentName> collection, int n) {
        InvokeDynamicSupport.bootstrap("setEnabledTrustAgents", $$robo$$com_android_internal_widget_LockPatternUtils$setEnabledTrustAgents(java.util.Collection<android.content.ComponentName> int ), 0, this, collection, n);
    }

    public List<ComponentName> getEnabledTrustAgents(int n) {
        return InvokeDynamicSupport.bootstrap("getEnabledTrustAgents", $$robo$$com_android_internal_widget_LockPatternUtils$getEnabledTrustAgents(int ), 0, this, n);
    }

    public void requireCredentialEntry(int n) {
        InvokeDynamicSupport.bootstrap("requireCredentialEntry", $$robo$$com_android_internal_widget_LockPatternUtils$requireCredentialEntry(int ), 0, this, n);
    }

    public void requireStrongAuth(int n, int n2) {
        InvokeDynamicSupport.bootstrap("requireStrongAuth", $$robo$$com_android_internal_widget_LockPatternUtils$requireStrongAuth(int int ), 0, this, n, n2);
    }

    private void onAfterChangingPassword(int n) {
        InvokeDynamicSupport.bootstrap("onAfterChangingPassword", $$robo$$com_android_internal_widget_LockPatternUtils$onAfterChangingPassword(int ), 0, this, n);
    }

    public boolean isCredentialRequiredToDecrypt(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCredentialRequiredToDecrypt", $$robo$$com_android_internal_widget_LockPatternUtils$isCredentialRequiredToDecrypt(boolean ), 0, this, bl);
    }

    public void setCredentialRequiredToDecrypt(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCredentialRequiredToDecrypt", $$robo$$com_android_internal_widget_LockPatternUtils$setCredentialRequiredToDecrypt(boolean ), 0, this, bl);
    }

    private boolean isDoNotAskCredentialsOnBootSet() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDoNotAskCredentialsOnBootSet", $$robo$$com_android_internal_widget_LockPatternUtils$isDoNotAskCredentialsOnBootSet(), 0, this);
    }

    private boolean shouldEncryptWithCredentials(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldEncryptWithCredentials", $$robo$$com_android_internal_widget_LockPatternUtils$shouldEncryptWithCredentials(boolean ), 0, this, bl);
    }

    private void throwIfCalledOnMainThread() {
        InvokeDynamicSupport.bootstrap("throwIfCalledOnMainThread", $$robo$$com_android_internal_widget_LockPatternUtils$throwIfCalledOnMainThread(), 0, this);
    }

    public void registerStrongAuthTracker(StrongAuthTracker strongAuthTracker) {
        InvokeDynamicSupport.bootstrap("registerStrongAuthTracker", $$robo$$com_android_internal_widget_LockPatternUtils$registerStrongAuthTracker(com.android.internal.widget.LockPatternUtils$StrongAuthTracker ), 0, this, strongAuthTracker);
    }

    public void unregisterStrongAuthTracker(StrongAuthTracker strongAuthTracker) {
        InvokeDynamicSupport.bootstrap("unregisterStrongAuthTracker", $$robo$$com_android_internal_widget_LockPatternUtils$unregisterStrongAuthTracker(com.android.internal.widget.LockPatternUtils$StrongAuthTracker ), 0, this, strongAuthTracker);
    }

    public int getStrongAuthForUser(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStrongAuthForUser", $$robo$$com_android_internal_widget_LockPatternUtils$getStrongAuthForUser(int ), 0, this, n);
    }

    public boolean isTrustAllowedForUser(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTrustAllowedForUser", $$robo$$com_android_internal_widget_LockPatternUtils$isTrustAllowedForUser(int ), 0, this, n);
    }

    public boolean isFingerprintAllowedForUser(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFingerprintAllowedForUser", $$robo$$com_android_internal_widget_LockPatternUtils$isFingerprintAllowedForUser(int ), 0, this, n);
    }

    public /* synthetic */ LockPatternUtils() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LockPatternUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class StrongAuthTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int STRONG_AUTH_NOT_REQUIRED = 0;
        public static int STRONG_AUTH_REQUIRED_AFTER_BOOT = 1;
        public static int STRONG_AUTH_REQUIRED_AFTER_DPM_LOCK_NOW = 2;
        public static int SOME_AUTH_REQUIRED_AFTER_USER_REQUEST = 4;
        public static int STRONG_AUTH_REQUIRED_AFTER_LOCKOUT = 8;
        public static int SOME_AUTH_REQUIRED_AFTER_WRONG_CREDENTIAL = 16;
        private static int ALLOWING_FINGERPRINT = 20;
        private SparseIntArray mStrongAuthRequiredForUser;
        private H mHandler;
        private int mDefaultStrongAuthFlags;
        protected IStrongAuthTracker.Stub mStub;

        private void $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$__constructor__(Context context) {
        }

        private void $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$__constructor__(Context context, Looper looper) {
            this.mStrongAuthRequiredForUser = new SparseIntArray();
            this.mStub = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ StrongAuthTracker this$0;

                private void $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_1$__constructor__(StrongAuthTracker this$0) {
                }

                private final void $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_1$onStrongAuthRequiredChanged(int strongAuthFlags, int userId) {
                    this.this$0.mHandler.obtainMessage(1, strongAuthFlags, userId).sendToTarget();
                }

                private void __constructor__(StrongAuthTracker strongAuthTracker) {
                    this.$$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_1$__constructor__(strongAuthTracker);
                }
                {
                    this.this$0 = strongAuthTracker;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_1$__constructor__(com.android.internal.widget.LockPatternUtils$StrongAuthTracker ), 0, this, strongAuthTracker);
                }

                @Override
                public void onStrongAuthRequiredChanged(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onStrongAuthRequiredChanged", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_1$onStrongAuthRequiredChanged(int int ), 0, this, n, n2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mHandler = new H(this, looper);
            this.mDefaultStrongAuthFlags = StrongAuthTracker.getDefaultFlags(context);
        }

        private static final int $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$getDefaultFlags(Context context) {
            boolean strongAuthRequired = context.getResources().getBoolean(17957035);
            return strongAuthRequired ? 1 : 0;
        }

        private final int $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$getStrongAuthForUser(int userId) {
            return this.mStrongAuthRequiredForUser.get(userId, this.mDefaultStrongAuthFlags);
        }

        private final boolean $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$isTrustAllowedForUser(int userId) {
            return this.getStrongAuthForUser(userId) == 0;
        }

        private final boolean $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$isFingerprintAllowedForUser(int userId) {
            return (this.getStrongAuthForUser(userId) & 0xFFFFFFEB) == 0;
        }

        private final void $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$onStrongAuthRequiredChanged(int userId) {
        }

        private final void $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$handleStrongAuthRequiredChanged(int strongAuthFlags, int userId) {
            int oldValue = this.getStrongAuthForUser(userId);
            if (strongAuthFlags != oldValue) {
                if (strongAuthFlags == this.mDefaultStrongAuthFlags) {
                    this.mStrongAuthRequiredForUser.delete(userId);
                } else {
                    this.mStrongAuthRequiredForUser.put(userId, strongAuthFlags);
                }
                this.onStrongAuthRequiredChanged(userId);
            }
        }

        private void __constructor__(Context context) {
            this.$$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$__constructor__(context);
        }

        public StrongAuthTracker(Context context) {
            this(context, Looper.myLooper());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$__constructor__(android.content.Context ), 0, this, context);
        }

        private void __constructor__(Context context, Looper looper) {
            this.$$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$__constructor__(context, looper);
        }

        public StrongAuthTracker(Context context, Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$__constructor__(android.content.Context android.os.Looper ), 0, this, context, looper);
        }

        public static int getDefaultFlags(Context context) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultFlags", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$getDefaultFlags(android.content.Context ), 0, (Context)context);
        }

        public int getStrongAuthForUser(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getStrongAuthForUser", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$getStrongAuthForUser(int ), 0, this, n);
        }

        public boolean isTrustAllowedForUser(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isTrustAllowedForUser", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$isTrustAllowedForUser(int ), 0, this, n);
        }

        public boolean isFingerprintAllowedForUser(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFingerprintAllowedForUser", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$isFingerprintAllowedForUser(int ), 0, this, n);
        }

        public void onStrongAuthRequiredChanged(int n) {
            InvokeDynamicSupport.bootstrap("onStrongAuthRequiredChanged", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$onStrongAuthRequiredChanged(int ), 0, this, n);
        }

        protected void handleStrongAuthRequiredChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("handleStrongAuthRequiredChanged", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker$handleStrongAuthRequiredChanged(int int ), 0, this, n, n2);
        }

        public /* synthetic */ StrongAuthTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrongAuthTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class H
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            static int MSG_ON_STRONG_AUTH_REQUIRED_CHANGED = 1;
            /* synthetic */ StrongAuthTracker this$0;

            private void $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_H$__constructor__(StrongAuthTracker strongAuthTracker, Looper looper) {
            }

            private final void $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_H$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.handleStrongAuthRequiredChanged(msg.arg1, msg.arg2);
                    }
                }
            }

            private void __constructor__(StrongAuthTracker strongAuthTracker, Looper looper) {
                this.$$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_H$__constructor__(strongAuthTracker, looper);
            }

            public H(StrongAuthTracker strongAuthTracker, Looper looper) {
                this.this$0 = strongAuthTracker;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_H$__constructor__(com.android.internal.widget.LockPatternUtils$StrongAuthTracker android.os.Looper ), 0, this, strongAuthTracker, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_widget_LockPatternUtils_StrongAuthTracker_H$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ H() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (H)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class RequestThrottledException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTimeoutMs;

        private void $$robo$$com_android_internal_widget_LockPatternUtils_RequestThrottledException$__constructor__(int timeoutMs) {
            this.mTimeoutMs = timeoutMs;
        }

        private final int $$robo$$com_android_internal_widget_LockPatternUtils_RequestThrottledException$getTimeoutMs() {
            return this.mTimeoutMs;
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_widget_LockPatternUtils_RequestThrottledException$__constructor__(n);
        }

        public RequestThrottledException(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_LockPatternUtils_RequestThrottledException$__constructor__(int ), 0, this, n);
        }

        public int getTimeoutMs() {
            return (int)InvokeDynamicSupport.bootstrap("getTimeoutMs", $$robo$$com_android_internal_widget_LockPatternUtils_RequestThrottledException$getTimeoutMs(), 0, this);
        }

        public /* synthetic */ RequestThrottledException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestThrottledException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

