/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.MenuPopupWindow;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import com.android.internal.view.menu.MenuAdapter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuPopup;
import com.android.internal.view.menu.MenuPopupHelper;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.SubMenuBuilder;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class StandardMenuPopup
extends MenuPopup
implements PopupWindow.OnDismissListener,
AdapterView.OnItemClickListener,
MenuPresenter,
View.OnKeyListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Context mContext;
    private MenuBuilder mMenu;
    private MenuAdapter mAdapter;
    private boolean mOverflowOnly;
    private int mPopupMaxWidth;
    private int mPopupStyleAttr;
    private int mPopupStyleRes;
    private MenuPopupWindow mPopup;
    private ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;
    private View.OnAttachStateChangeListener mAttachStateChangeListener;
    private PopupWindow.OnDismissListener mOnDismissListener;
    private View mAnchorView;
    private View mShownAnchorView;
    private MenuPresenter.Callback mPresenterCallback;
    private ViewTreeObserver mTreeObserver;
    private boolean mWasDismissed;
    private boolean mHasContentWidth;
    private int mContentWidth;
    private int mDropDownGravity;
    private boolean mShowTitle;

    private void $$robo$$com_android_internal_view_menu_StandardMenuPopup$__constructor__(Context context, MenuBuilder menu2, View anchorView, int popupStyleAttr, int popupStyleRes, boolean overflowOnly) {
        this.mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ StandardMenuPopup this$0;

            private void $$robo$$com_android_internal_view_menu_StandardMenuPopup_1$__constructor__(StandardMenuPopup this$0) {
            }

            private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup_1$onGlobalLayout() {
                if (this.this$0.isShowing() && !this.this$0.mPopup.isModal()) {
                    View anchor = this.this$0.mShownAnchorView;
                    if (anchor == null || !anchor.isShown()) {
                        this.this$0.dismiss();
                    } else {
                        this.this$0.mPopup.show();
                    }
                }
            }

            private void __constructor__(StandardMenuPopup standardMenuPopup) {
                this.$$robo$$com_android_internal_view_menu_StandardMenuPopup_1$__constructor__(standardMenuPopup);
            }
            {
                this.this$0 = standardMenuPopup;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_StandardMenuPopup_1$__constructor__(com.android.internal.view.menu.StandardMenuPopup ), 0, this, standardMenuPopup);
            }

            @Override
            public void onGlobalLayout() {
                InvokeDynamicSupport.bootstrap("onGlobalLayout", $$robo$$com_android_internal_view_menu_StandardMenuPopup_1$onGlobalLayout(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAttachStateChangeListener = new View.OnAttachStateChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ StandardMenuPopup this$0;

            private void $$robo$$com_android_internal_view_menu_StandardMenuPopup_2$__constructor__(StandardMenuPopup this$0) {
            }

            private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup_2$onViewAttachedToWindow(View v) {
            }

            private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup_2$onViewDetachedFromWindow(View v) {
                if (this.this$0.mTreeObserver != null) {
                    if (!this.this$0.mTreeObserver.isAlive()) {
                        this.this$0.mTreeObserver = v.getViewTreeObserver();
                    }
                    this.this$0.mTreeObserver.removeGlobalOnLayoutListener(this.this$0.mGlobalLayoutListener);
                }
                v.removeOnAttachStateChangeListener(this);
            }

            private void __constructor__(StandardMenuPopup standardMenuPopup) {
                this.$$robo$$com_android_internal_view_menu_StandardMenuPopup_2$__constructor__(standardMenuPopup);
            }
            {
                this.this$0 = standardMenuPopup;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_StandardMenuPopup_2$__constructor__(com.android.internal.view.menu.StandardMenuPopup ), 0, this, standardMenuPopup);
            }

            @Override
            public void onViewAttachedToWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$com_android_internal_view_menu_StandardMenuPopup_2$onViewAttachedToWindow(android.view.View ), 0, this, view);
            }

            @Override
            public void onViewDetachedFromWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$com_android_internal_view_menu_StandardMenuPopup_2$onViewDetachedFromWindow(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDropDownGravity = 0;
        this.mContext = Preconditions.checkNotNull(context);
        this.mMenu = menu2;
        this.mOverflowOnly = overflowOnly;
        LayoutInflater inflater = LayoutInflater.from(context);
        this.mAdapter = new MenuAdapter(menu2, inflater, this.mOverflowOnly);
        this.mPopupStyleAttr = popupStyleAttr;
        this.mPopupStyleRes = popupStyleRes;
        Resources res = context.getResources();
        this.mPopupMaxWidth = Math.max(res.getDisplayMetrics().widthPixels / 2, res.getDimensionPixelSize(17104910));
        this.mAnchorView = anchorView;
        this.mPopup = new MenuPopupWindow(this.mContext, null, this.mPopupStyleAttr, this.mPopupStyleRes);
        menu2.addMenuPresenter(this, context);
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$setForceShowIcon(boolean forceShow) {
        this.mAdapter.setForceShowIcon(forceShow);
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$setGravity(int gravity) {
        this.mDropDownGravity = gravity;
    }

    private final boolean $$robo$$com_android_internal_view_menu_StandardMenuPopup$tryShow() {
        if (this.isShowing()) {
            return true;
        }
        if (this.mWasDismissed || this.mAnchorView == null) {
            return false;
        }
        this.mShownAnchorView = this.mAnchorView;
        this.mPopup.setOnDismissListener(this);
        this.mPopup.setOnItemClickListener(this);
        this.mPopup.setAdapter(this.mAdapter);
        this.mPopup.setModal(true);
        View anchor = this.mShownAnchorView;
        boolean addGlobalListener = this.mTreeObserver == null;
        this.mTreeObserver = anchor.getViewTreeObserver();
        if (addGlobalListener) {
            this.mTreeObserver.addOnGlobalLayoutListener(this.mGlobalLayoutListener);
        }
        anchor.addOnAttachStateChangeListener(this.mAttachStateChangeListener);
        this.mPopup.setAnchorView(anchor);
        this.mPopup.setDropDownGravity(this.mDropDownGravity);
        if (!this.mHasContentWidth) {
            this.mContentWidth = StandardMenuPopup.measureIndividualMenuWidth(this.mAdapter, null, this.mContext, this.mPopupMaxWidth);
            this.mHasContentWidth = true;
        }
        this.mPopup.setContentWidth(this.mContentWidth);
        this.mPopup.setInputMethodMode(2);
        this.mPopup.setEpicenterBounds(this.getEpicenterBounds());
        this.mPopup.show();
        ListView listView = this.mPopup.getListView();
        listView.setOnKeyListener(this);
        if (this.mShowTitle && this.mMenu.getHeaderTitle() != null) {
            FrameLayout titleItemView = (FrameLayout)LayoutInflater.from(this.mContext).inflate(17367200, (ViewGroup)listView, false);
            TextView titleView = (TextView)titleItemView.findViewById(16908310);
            if (titleView != null) {
                titleView.setText(this.mMenu.getHeaderTitle());
            }
            titleItemView.setEnabled(false);
            listView.addHeaderView(titleItemView, null, false);
            this.mPopup.show();
        }
        return true;
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$show() {
        if (!this.tryShow()) {
            throw new IllegalStateException("StandardMenuPopup cannot be used without an anchor");
        }
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$dismiss() {
        if (this.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$addMenu(MenuBuilder menu2) {
    }

    private final boolean $$robo$$com_android_internal_view_menu_StandardMenuPopup$isShowing() {
        return !this.mWasDismissed && this.mPopup.isShowing();
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$onDismiss() {
        this.mWasDismissed = true;
        this.mMenu.close();
        if (this.mTreeObserver != null) {
            if (!this.mTreeObserver.isAlive()) {
                this.mTreeObserver = this.mShownAnchorView.getViewTreeObserver();
            }
            this.mTreeObserver.removeGlobalOnLayoutListener(this.mGlobalLayoutListener);
            this.mTreeObserver = null;
        }
        this.mShownAnchorView.removeOnAttachStateChangeListener(this.mAttachStateChangeListener);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$updateMenuView(boolean cleared) {
        this.mHasContentWidth = false;
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$setCallback(MenuPresenter.Callback cb) {
        this.mPresenterCallback = cb;
    }

    private final boolean $$robo$$com_android_internal_view_menu_StandardMenuPopup$onSubMenuSelected(SubMenuBuilder subMenu) {
        if (subMenu.hasVisibleItems()) {
            MenuPopupHelper subPopup = new MenuPopupHelper(this.mContext, subMenu, this.mShownAnchorView, this.mOverflowOnly, this.mPopupStyleAttr, this.mPopupStyleRes);
            subPopup.setPresenterCallback(this.mPresenterCallback);
            subPopup.setForceShowIcon(MenuPopup.shouldPreserveIconSpacing(subMenu));
            subPopup.setOnDismissListener(this.mOnDismissListener);
            this.mOnDismissListener = null;
            this.mMenu.close(false);
            int horizontalOffset = this.mPopup.getHorizontalOffset();
            int verticalOffset = this.mPopup.getVerticalOffset();
            if (subPopup.tryShow(horizontalOffset, verticalOffset)) {
                if (this.mPresenterCallback != null) {
                    this.mPresenterCallback.onOpenSubMenu(subMenu);
                }
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        if (menu2 != this.mMenu) {
            return;
        }
        this.dismiss();
        if (this.mPresenterCallback != null) {
            this.mPresenterCallback.onCloseMenu(menu2, allMenusAreClosing);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_StandardMenuPopup$flagActionItems() {
        return false;
    }

    private final Parcelable $$robo$$com_android_internal_view_menu_StandardMenuPopup$onSaveInstanceState() {
        return null;
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$onRestoreInstanceState(Parcelable state) {
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$setAnchorView(View anchor) {
        this.mAnchorView = anchor;
    }

    private final boolean $$robo$$com_android_internal_view_menu_StandardMenuPopup$onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == 1 && keyCode == 82) {
            this.dismiss();
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    private final ListView $$robo$$com_android_internal_view_menu_StandardMenuPopup$getListView() {
        return this.mPopup.getListView();
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$setHorizontalOffset(int x) {
        this.mPopup.setHorizontalOffset(x);
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$setVerticalOffset(int y) {
        this.mPopup.setVerticalOffset(y);
    }

    private final void $$robo$$com_android_internal_view_menu_StandardMenuPopup$setShowTitle(boolean showTitle) {
        this.mShowTitle = showTitle;
    }

    private void __constructor__(Context context, MenuBuilder menuBuilder, View view, int n, int n2, boolean bl) {
        this.$$robo$$com_android_internal_view_menu_StandardMenuPopup$__constructor__(context, menuBuilder, view, n, n2, bl);
    }

    public StandardMenuPopup(Context context, MenuBuilder menuBuilder, View view, int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_StandardMenuPopup$__constructor__(android.content.Context com.android.internal.view.menu.MenuBuilder android.view.View int int boolean ), 0, this, context, menuBuilder, view, n, n2, bl);
    }

    @Override
    public void setForceShowIcon(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceShowIcon", $$robo$$com_android_internal_view_menu_StandardMenuPopup$setForceShowIcon(boolean ), 0, this, bl);
    }

    @Override
    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$com_android_internal_view_menu_StandardMenuPopup$setGravity(int ), 0, this, n);
    }

    private boolean tryShow() {
        return (boolean)InvokeDynamicSupport.bootstrap("tryShow", $$robo$$com_android_internal_view_menu_StandardMenuPopup$tryShow(), 0, this);
    }

    @Override
    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_view_menu_StandardMenuPopup$show(), 0, this);
    }

    @Override
    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_view_menu_StandardMenuPopup$dismiss(), 0, this);
    }

    @Override
    public void addMenu(MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("addMenu", $$robo$$com_android_internal_view_menu_StandardMenuPopup$addMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
    }

    @Override
    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$com_android_internal_view_menu_StandardMenuPopup$isShowing(), 0, this);
    }

    @Override
    public void onDismiss() {
        InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$com_android_internal_view_menu_StandardMenuPopup$onDismiss(), 0, this);
    }

    @Override
    public void updateMenuView(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMenuView", $$robo$$com_android_internal_view_menu_StandardMenuPopup$updateMenuView(boolean ), 0, this, bl);
    }

    @Override
    public void setCallback(MenuPresenter.Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$com_android_internal_view_menu_StandardMenuPopup$setCallback(com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, callback);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSubMenuSelected", $$robo$$com_android_internal_view_menu_StandardMenuPopup$onSubMenuSelected(com.android.internal.view.menu.SubMenuBuilder ), 0, this, subMenuBuilder);
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$com_android_internal_view_menu_StandardMenuPopup$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
    }

    @Override
    public boolean flagActionItems() {
        return (boolean)InvokeDynamicSupport.bootstrap("flagActionItems", $$robo$$com_android_internal_view_menu_StandardMenuPopup$flagActionItems(), 0, this);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_view_menu_StandardMenuPopup$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_view_menu_StandardMenuPopup$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public void setAnchorView(View view) {
        InvokeDynamicSupport.bootstrap("setAnchorView", $$robo$$com_android_internal_view_menu_StandardMenuPopup$setAnchorView(android.view.View ), 0, this, view);
    }

    @Override
    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKey", $$robo$$com_android_internal_view_menu_StandardMenuPopup$onKey(android.view.View int android.view.KeyEvent ), 0, this, view, n, keyEvent);
    }

    @Override
    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$com_android_internal_view_menu_StandardMenuPopup$setOnDismissListener(android.widget.PopupWindow$OnDismissListener ), 0, this, onDismissListener);
    }

    @Override
    public ListView getListView() {
        return InvokeDynamicSupport.bootstrap("getListView", $$robo$$com_android_internal_view_menu_StandardMenuPopup$getListView(), 0, this);
    }

    @Override
    public void setHorizontalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setHorizontalOffset", $$robo$$com_android_internal_view_menu_StandardMenuPopup$setHorizontalOffset(int ), 0, this, n);
    }

    @Override
    public void setVerticalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalOffset", $$robo$$com_android_internal_view_menu_StandardMenuPopup$setVerticalOffset(int ), 0, this, n);
    }

    @Override
    public void setShowTitle(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowTitle", $$robo$$com_android_internal_view_menu_StandardMenuPopup$setShowTitle(boolean ), 0, this, bl);
    }

    public /* synthetic */ StandardMenuPopup() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StandardMenuPopup)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

