/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Adapter;
import android.widget.FrameLayout;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.MenuItemHoverListener;
import android.widget.MenuPopupWindow;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import com.android.internal.view.menu.MenuAdapter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuPopup;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.SubMenuBuilder;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class CascadingMenuPopup
extends MenuPopup
implements MenuPresenter,
View.OnKeyListener,
PopupWindow.OnDismissListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int HORIZ_POSITION_LEFT = 0;
    private static int HORIZ_POSITION_RIGHT = 1;
    private static int SUBMENU_TIMEOUT_MS = 200;
    private Context mContext;
    private int mMenuMaxWidth;
    private int mPopupStyleAttr;
    private int mPopupStyleRes;
    private boolean mOverflowOnly;
    private Handler mSubMenuHoverHandler;
    private List<MenuBuilder> mPendingMenus;
    private List<CascadingMenuInfo> mShowingMenus;
    private ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;
    private View.OnAttachStateChangeListener mAttachStateChangeListener;
    private MenuItemHoverListener mMenuItemHoverListener;
    private int mRawDropDownGravity;
    private int mDropDownGravity;
    private View mAnchorView;
    private View mShownAnchorView;
    private int mLastPosition;
    private boolean mHasXOffset;
    private boolean mHasYOffset;
    private int mXOffset;
    private int mYOffset;
    private boolean mForceShowIcon;
    private boolean mShowTitle;
    private MenuPresenter.Callback mPresenterCallback;
    private ViewTreeObserver mTreeObserver;
    private PopupWindow.OnDismissListener mOnDismissListener;
    private boolean mShouldCloseImmediately;

    private void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$__constructor__(Context context, View anchor, int popupStyleAttr, int popupStyleRes, boolean overflowOnly) {
        this.mPendingMenus = new LinkedList<MenuBuilder>();
        this.mShowingMenus = new ArrayList<CascadingMenuInfo>();
        this.mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CascadingMenuPopup this$0;

            private void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_1$__constructor__(CascadingMenuPopup this$0) {
            }

            private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_1$onGlobalLayout() {
                if (this.this$0.isShowing() && this.this$0.mShowingMenus.size() > 0 && !((CascadingMenuInfo)((CascadingMenuPopup)this.this$0).mShowingMenus.get((int)0)).window.isModal()) {
                    View anchor = this.this$0.mShownAnchorView;
                    if (anchor == null || !anchor.isShown()) {
                        this.this$0.dismiss();
                    } else {
                        for (CascadingMenuInfo info : this.this$0.mShowingMenus) {
                            info.window.show();
                        }
                    }
                }
            }

            private void __constructor__(CascadingMenuPopup cascadingMenuPopup) {
                this.$$robo$$com_android_internal_view_menu_CascadingMenuPopup_1$__constructor__(cascadingMenuPopup);
            }
            {
                this.this$0 = cascadingMenuPopup;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_1$__constructor__(com.android.internal.view.menu.CascadingMenuPopup ), 0, this, cascadingMenuPopup);
            }

            @Override
            public void onGlobalLayout() {
                InvokeDynamicSupport.bootstrap("onGlobalLayout", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_1$onGlobalLayout(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAttachStateChangeListener = new View.OnAttachStateChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CascadingMenuPopup this$0;

            private void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_2$__constructor__(CascadingMenuPopup this$0) {
            }

            private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_2$onViewAttachedToWindow(View v) {
            }

            private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_2$onViewDetachedFromWindow(View v) {
                if (this.this$0.mTreeObserver != null) {
                    if (!this.this$0.mTreeObserver.isAlive()) {
                        this.this$0.mTreeObserver = v.getViewTreeObserver();
                    }
                    this.this$0.mTreeObserver.removeGlobalOnLayoutListener(this.this$0.mGlobalLayoutListener);
                }
                v.removeOnAttachStateChangeListener(this);
            }

            private void __constructor__(CascadingMenuPopup cascadingMenuPopup) {
                this.$$robo$$com_android_internal_view_menu_CascadingMenuPopup_2$__constructor__(cascadingMenuPopup);
            }
            {
                this.this$0 = cascadingMenuPopup;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_2$__constructor__(com.android.internal.view.menu.CascadingMenuPopup ), 0, this, cascadingMenuPopup);
            }

            @Override
            public void onViewAttachedToWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_2$onViewAttachedToWindow(android.view.View ), 0, this, view);
            }

            @Override
            public void onViewDetachedFromWindow(View view) {
                InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_2$onViewDetachedFromWindow(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mMenuItemHoverListener = new MenuItemHoverListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CascadingMenuPopup this$0;

            private void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3$__constructor__(CascadingMenuPopup this$0) {
            }

            private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3$onItemHoverExit(MenuBuilder menu2, MenuItem item) {
                this.this$0.mSubMenuHoverHandler.removeCallbacksAndMessages(menu2);
            }

            private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3$onItemHoverEnter(MenuBuilder menu2, MenuItem item) {
                this.this$0.mSubMenuHoverHandler.removeCallbacksAndMessages(null);
                int menuIndex = -1;
                int count = this.this$0.mShowingMenus.size();
                for (int i = 0; i < count; ++i) {
                    if (menu2 != ((CascadingMenuInfo)((CascadingMenuPopup)this.this$0).mShowingMenus.get((int)i)).menu) continue;
                    menuIndex = i;
                    break;
                }
                if (menuIndex == -1) {
                    return;
                }
                int nextIndex = menuIndex + 1;
                CascadingMenuInfo nextInfo = nextIndex < this.this$0.mShowingMenus.size() ? (CascadingMenuInfo)this.this$0.mShowingMenus.get(nextIndex) : null;
                Runnable runnable = new Runnable(this, nextInfo, item, menu2){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ CascadingMenuInfo val$nextInfo;
                    /* synthetic */ MenuItem val$item;
                    /* synthetic */ MenuBuilder val$menu;
                    /* synthetic */ 3 this$1;

                    private void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3_1$__constructor__(3 this$1, CascadingMenuInfo cascadingMenuInfo, MenuItem menuItem, MenuBuilder menuBuilder) {
                    }

                    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3_1$run() {
                        if (this.val$nextInfo != null) {
                            this.this$1.this$0.mShouldCloseImmediately = true;
                            this.val$nextInfo.menu.close(false);
                            this.this$1.this$0.mShouldCloseImmediately = false;
                        }
                        if (this.val$item.isEnabled() && this.val$item.hasSubMenu()) {
                            this.val$menu.performItemAction(this.val$item, 0);
                        }
                    }

                    private void __constructor__(3 var1_1, CascadingMenuInfo cascadingMenuInfo, MenuItem menuItem, MenuBuilder menuBuilder) {
                        this.$$robo$$com_android_internal_view_menu_CascadingMenuPopup_3_1$__constructor__(var1_1, cascadingMenuInfo, menuItem, menuBuilder);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$nextInfo = cascadingMenuInfo;
                        this.val$item = menuItem;
                        this.val$menu = menuBuilder;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3_1$__constructor__(com.android.internal.view.menu.CascadingMenuPopup$3 com.android.internal.view.menu.CascadingMenuPopup$CascadingMenuInfo android.view.MenuItem com.android.internal.view.menu.MenuBuilder ), 0, this, var1_1, cascadingMenuInfo, menuItem, menuBuilder);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                long uptimeMillis = SystemClock.uptimeMillis() + 200L;
                this.this$0.mSubMenuHoverHandler.postAtTime(runnable, menu2, uptimeMillis);
            }

            private void __constructor__(CascadingMenuPopup cascadingMenuPopup) {
                this.$$robo$$com_android_internal_view_menu_CascadingMenuPopup_3$__constructor__(cascadingMenuPopup);
            }
            {
                this.this$0 = cascadingMenuPopup;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3$__constructor__(com.android.internal.view.menu.CascadingMenuPopup ), 0, this, cascadingMenuPopup);
            }

            @Override
            public void onItemHoverExit(MenuBuilder menuBuilder, MenuItem menuItem) {
                InvokeDynamicSupport.bootstrap("onItemHoverExit", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3$onItemHoverExit(com.android.internal.view.menu.MenuBuilder android.view.MenuItem ), 0, this, menuBuilder, menuItem);
            }

            @Override
            public void onItemHoverEnter(MenuBuilder menuBuilder, MenuItem menuItem) {
                InvokeDynamicSupport.bootstrap("onItemHoverEnter", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_3$onItemHoverEnter(com.android.internal.view.menu.MenuBuilder android.view.MenuItem ), 0, this, menuBuilder, menuItem);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRawDropDownGravity = 0;
        this.mDropDownGravity = 0;
        this.mContext = Preconditions.checkNotNull(context);
        this.mAnchorView = Preconditions.checkNotNull(anchor);
        this.mPopupStyleAttr = popupStyleAttr;
        this.mPopupStyleRes = popupStyleRes;
        this.mOverflowOnly = overflowOnly;
        this.mForceShowIcon = false;
        this.mLastPosition = this.getInitialMenuPosition();
        Resources res = context.getResources();
        this.mMenuMaxWidth = Math.max(res.getDisplayMetrics().widthPixels / 2, res.getDimensionPixelSize(17104910));
        this.mSubMenuHoverHandler = new Handler();
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setForceShowIcon(boolean forceShow) {
        this.mForceShowIcon = forceShow;
    }

    private final MenuPopupWindow $$robo$$com_android_internal_view_menu_CascadingMenuPopup$createPopupWindow() {
        MenuPopupWindow popupWindow = new MenuPopupWindow(this.mContext, null, this.mPopupStyleAttr, this.mPopupStyleRes);
        popupWindow.setHoverListener(this.mMenuItemHoverListener);
        popupWindow.setOnItemClickListener(this);
        popupWindow.setOnDismissListener(this);
        popupWindow.setAnchorView(this.mAnchorView);
        popupWindow.setDropDownGravity(this.mDropDownGravity);
        popupWindow.setModal(true);
        popupWindow.setInputMethodMode(2);
        return popupWindow;
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$show() {
        if (this.isShowing()) {
            return;
        }
        for (MenuBuilder menu2 : this.mPendingMenus) {
            this.showMenu(menu2);
        }
        this.mPendingMenus.clear();
        this.mShownAnchorView = this.mAnchorView;
        if (this.mShownAnchorView != null) {
            boolean addGlobalListener = this.mTreeObserver == null;
            this.mTreeObserver = this.mShownAnchorView.getViewTreeObserver();
            if (addGlobalListener) {
                this.mTreeObserver.addOnGlobalLayoutListener(this.mGlobalLayoutListener);
            }
            this.mShownAnchorView.addOnAttachStateChangeListener(this.mAttachStateChangeListener);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$dismiss() {
        int length = this.mShowingMenus.size();
        if (length > 0) {
            CascadingMenuInfo[] addedMenus = this.mShowingMenus.toArray(new CascadingMenuInfo[length]);
            for (int i = length - 1; i >= 0; --i) {
                CascadingMenuInfo info = addedMenus[i];
                if (!info.window.isShowing()) continue;
                info.window.dismiss();
            }
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == 1 && keyCode == 82) {
            this.dismiss();
            return true;
        }
        return false;
    }

    private final int $$robo$$com_android_internal_view_menu_CascadingMenuPopup$getInitialMenuPosition() {
        int layoutDirection = this.mAnchorView.getLayoutDirection();
        return layoutDirection == 1 ? 0 : 1;
    }

    private final int $$robo$$com_android_internal_view_menu_CascadingMenuPopup$getNextMenuPosition(int nextMenuWidth) {
        ListView lastListView = this.mShowingMenus.get(this.mShowingMenus.size() - 1).getListView();
        int[] screenLocation = new int[2];
        lastListView.getLocationOnScreen(screenLocation);
        Rect displayFrame = new Rect();
        this.mShownAnchorView.getWindowVisibleDisplayFrame(displayFrame);
        if (this.mLastPosition == 1) {
            int right = screenLocation[0] + lastListView.getWidth() + nextMenuWidth;
            if (right > displayFrame.right) {
                return 0;
            }
            return 1;
        }
        int left = screenLocation[0] - nextMenuWidth;
        if (left < 0) {
            return 1;
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$addMenu(MenuBuilder menu2) {
        menu2.addMenuPresenter(this, this.mContext);
        if (this.isShowing()) {
            this.showMenu(menu2);
        } else {
            this.mPendingMenus.add(menu2);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$showMenu(MenuBuilder menu2) {
        View parentView;
        CascadingMenuInfo parentInfo;
        LayoutInflater inflater = LayoutInflater.from(this.mContext);
        MenuAdapter adapter = new MenuAdapter(menu2, inflater, this.mOverflowOnly);
        if (!this.isShowing() && this.mForceShowIcon) {
            adapter.setForceShowIcon(true);
        } else if (this.isShowing()) {
            adapter.setForceShowIcon(MenuPopup.shouldPreserveIconSpacing(menu2));
        }
        int menuWidth = CascadingMenuPopup.measureIndividualMenuWidth(adapter, null, this.mContext, this.mMenuMaxWidth);
        MenuPopupWindow popupWindow = this.createPopupWindow();
        popupWindow.setAdapter(adapter);
        popupWindow.setWidth(menuWidth);
        popupWindow.setDropDownGravity(this.mDropDownGravity);
        if (this.mShowingMenus.size() > 0) {
            parentInfo = this.mShowingMenus.get(this.mShowingMenus.size() - 1);
            parentView = this.findParentViewForSubmenu(parentInfo, menu2);
        } else {
            parentInfo = null;
            parentView = null;
        }
        if (parentView != null) {
            popupWindow.setTouchModal(false);
            popupWindow.setEnterTransition(null);
            int nextMenuPosition = this.getNextMenuPosition(menuWidth);
            boolean showOnRight = nextMenuPosition == 1;
            this.mLastPosition = nextMenuPosition;
            int[] tempLocation = new int[2];
            parentView.getLocationInWindow(tempLocation);
            int parentOffsetLeft = parentInfo.window.getHorizontalOffset() + tempLocation[0];
            int parentOffsetTop = parentInfo.window.getVerticalOffset() + tempLocation[1];
            int x = (this.mDropDownGravity & 5) == 5 ? (showOnRight ? parentOffsetLeft + menuWidth : parentOffsetLeft - parentView.getWidth()) : (showOnRight ? parentOffsetLeft + parentView.getWidth() : parentOffsetLeft - menuWidth);
            popupWindow.setHorizontalOffset(x);
            int y = parentOffsetTop;
            popupWindow.setVerticalOffset(y);
        } else {
            if (this.mHasXOffset) {
                popupWindow.setHorizontalOffset(this.mXOffset);
            }
            if (this.mHasYOffset) {
                popupWindow.setVerticalOffset(this.mYOffset);
            }
            Rect epicenterBounds = this.getEpicenterBounds();
            popupWindow.setEpicenterBounds(epicenterBounds);
        }
        CascadingMenuInfo menuInfo = new CascadingMenuInfo(popupWindow, menu2, this.mLastPosition);
        this.mShowingMenus.add(menuInfo);
        popupWindow.show();
        if (parentInfo == null && this.mShowTitle && menu2.getHeaderTitle() != null) {
            ListView listView = popupWindow.getListView();
            FrameLayout titleItemView = (FrameLayout)inflater.inflate(17367200, (ViewGroup)listView, false);
            TextView titleView = (TextView)titleItemView.findViewById(16908310);
            titleItemView.setEnabled(false);
            titleView.setText(menu2.getHeaderTitle());
            listView.addHeaderView(titleItemView, null, false);
            popupWindow.show();
        }
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_CascadingMenuPopup$findMenuItemForSubmenu(MenuBuilder parent, MenuBuilder submenu) {
        int count = parent.size();
        for (int i = 0; i < count; ++i) {
            MenuItem item = parent.getItem(i);
            if (!item.hasSubMenu() || submenu != item.getSubMenu()) continue;
            return item;
        }
        return null;
    }

    private final View $$robo$$com_android_internal_view_menu_CascadingMenuPopup$findParentViewForSubmenu(CascadingMenuInfo parentInfo, MenuBuilder submenu) {
        MenuAdapter menuAdapter;
        int headersCount;
        MenuItem owner = this.findMenuItemForSubmenu(parentInfo.menu, submenu);
        if (owner == null) {
            return null;
        }
        ListView listView = parentInfo.getListView();
        Adapter listAdapter = listView.getAdapter();
        if (listAdapter instanceof HeaderViewListAdapter) {
            HeaderViewListAdapter headerAdapter = (HeaderViewListAdapter)listAdapter;
            headersCount = headerAdapter.getHeadersCount();
            menuAdapter = (MenuAdapter)headerAdapter.getWrappedAdapter();
        } else {
            headersCount = 0;
            menuAdapter = (MenuAdapter)listAdapter;
        }
        int ownerPosition = -1;
        int count = menuAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            if (owner != menuAdapter.getItem(i)) continue;
            ownerPosition = i;
            break;
        }
        if (ownerPosition == -1) {
            return null;
        }
        int ownerViewPosition = (ownerPosition += headersCount) - listView.getFirstVisiblePosition();
        if (ownerViewPosition < 0 || ownerViewPosition >= listView.getChildCount()) {
            return null;
        }
        return listView.getChildAt(ownerViewPosition);
    }

    private final boolean $$robo$$com_android_internal_view_menu_CascadingMenuPopup$isShowing() {
        return this.mShowingMenus.size() > 0 && this.mShowingMenus.get((int)0).window.isShowing();
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onDismiss() {
        CascadingMenuInfo dismissedInfo = null;
        int count = this.mShowingMenus.size();
        for (int i = 0; i < count; ++i) {
            CascadingMenuInfo info = this.mShowingMenus.get(i);
            if (info.window.isShowing()) continue;
            dismissedInfo = info;
            break;
        }
        if (dismissedInfo != null) {
            dismissedInfo.menu.close(false);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$updateMenuView(boolean cleared) {
        for (CascadingMenuInfo info : this.mShowingMenus) {
            CascadingMenuPopup.toMenuAdapter((ListAdapter)info.getListView().getAdapter()).notifyDataSetChanged();
        }
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setCallback(MenuPresenter.Callback cb) {
        this.mPresenterCallback = cb;
    }

    private final boolean $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onSubMenuSelected(SubMenuBuilder subMenu) {
        for (CascadingMenuInfo info : this.mShowingMenus) {
            if (subMenu != info.menu) continue;
            info.getListView().requestFocus();
            return true;
        }
        if (subMenu.hasVisibleItems()) {
            this.addMenu(subMenu);
            if (this.mPresenterCallback != null) {
                this.mPresenterCallback.onOpenSubMenu(subMenu);
            }
            return true;
        }
        return false;
    }

    private final int $$robo$$com_android_internal_view_menu_CascadingMenuPopup$findIndexOfAddedMenu(MenuBuilder menu2) {
        int count = this.mShowingMenus.size();
        for (int i = 0; i < count; ++i) {
            CascadingMenuInfo info = this.mShowingMenus.get(i);
            if (menu2 != info.menu) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        int menuIndex = this.findIndexOfAddedMenu(menu2);
        if (menuIndex < 0) {
            return;
        }
        int nextMenuIndex = menuIndex + 1;
        if (nextMenuIndex < this.mShowingMenus.size()) {
            CascadingMenuInfo childInfo = this.mShowingMenus.get(nextMenuIndex);
            childInfo.menu.close(false);
        }
        CascadingMenuInfo info = this.mShowingMenus.remove(menuIndex);
        info.menu.removeMenuPresenter(this);
        if (this.mShouldCloseImmediately) {
            info.window.setExitTransition(null);
            info.window.setAnimationStyle(0);
        }
        info.window.dismiss();
        int count = this.mShowingMenus.size();
        this.mLastPosition = count > 0 ? this.mShowingMenus.get((int)(count - 1)).position : this.getInitialMenuPosition();
        if (count == 0) {
            this.dismiss();
            if (this.mPresenterCallback != null) {
                this.mPresenterCallback.onCloseMenu(menu2, true);
            }
            if (this.mTreeObserver != null) {
                if (this.mTreeObserver.isAlive()) {
                    this.mTreeObserver.removeGlobalOnLayoutListener(this.mGlobalLayoutListener);
                }
                this.mTreeObserver = null;
            }
            this.mShownAnchorView.removeOnAttachStateChangeListener(this.mAttachStateChangeListener);
            this.mOnDismissListener.onDismiss();
        } else if (allMenusAreClosing) {
            CascadingMenuInfo rootInfo = this.mShowingMenus.get(0);
            rootInfo.menu.close(false);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_CascadingMenuPopup$flagActionItems() {
        return false;
    }

    private final Parcelable $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onSaveInstanceState() {
        return null;
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onRestoreInstanceState(Parcelable state) {
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setGravity(int dropDownGravity) {
        if (this.mRawDropDownGravity != dropDownGravity) {
            this.mRawDropDownGravity = dropDownGravity;
            this.mDropDownGravity = Gravity.getAbsoluteGravity(dropDownGravity, this.mAnchorView.getLayoutDirection());
        }
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setAnchorView(View anchor) {
        if (this.mAnchorView != anchor) {
            this.mAnchorView = anchor;
            this.mDropDownGravity = Gravity.getAbsoluteGravity(this.mRawDropDownGravity, this.mAnchorView.getLayoutDirection());
        }
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    private final ListView $$robo$$com_android_internal_view_menu_CascadingMenuPopup$getListView() {
        return this.mShowingMenus.isEmpty() ? null : this.mShowingMenus.get(this.mShowingMenus.size() - 1).getListView();
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setHorizontalOffset(int x) {
        this.mHasXOffset = true;
        this.mXOffset = x;
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setVerticalOffset(int y) {
        this.mHasYOffset = true;
        this.mYOffset = y;
    }

    private final void $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setShowTitle(boolean showTitle) {
        this.mShowTitle = showTitle;
    }

    private void __constructor__(Context context, View view, int n, int n2, boolean bl) {
        this.$$robo$$com_android_internal_view_menu_CascadingMenuPopup$__constructor__(context, view, n, n2, bl);
    }

    public CascadingMenuPopup(Context context, View view, int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$__constructor__(android.content.Context android.view.View int int boolean ), 0, this, context, view, n, n2, bl);
    }

    @Override
    public void setForceShowIcon(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceShowIcon", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setForceShowIcon(boolean ), 0, this, bl);
    }

    private MenuPopupWindow createPopupWindow() {
        return InvokeDynamicSupport.bootstrap("createPopupWindow", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$createPopupWindow(), 0, this);
    }

    @Override
    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$show(), 0, this);
    }

    @Override
    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$dismiss(), 0, this);
    }

    @Override
    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKey", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onKey(android.view.View int android.view.KeyEvent ), 0, this, view, n, keyEvent);
    }

    private int getInitialMenuPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getInitialMenuPosition", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$getInitialMenuPosition(), 0, this);
    }

    private int getNextMenuPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNextMenuPosition", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$getNextMenuPosition(int ), 0, this, n);
    }

    @Override
    public void addMenu(MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("addMenu", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$addMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
    }

    private void showMenu(MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("showMenu", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$showMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
    }

    private MenuItem findMenuItemForSubmenu(MenuBuilder menuBuilder, MenuBuilder menuBuilder2) {
        return InvokeDynamicSupport.bootstrap("findMenuItemForSubmenu", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$findMenuItemForSubmenu(com.android.internal.view.menu.MenuBuilder com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder, menuBuilder2);
    }

    private View findParentViewForSubmenu(CascadingMenuInfo cascadingMenuInfo, MenuBuilder menuBuilder) {
        return InvokeDynamicSupport.bootstrap("findParentViewForSubmenu", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$findParentViewForSubmenu(com.android.internal.view.menu.CascadingMenuPopup$CascadingMenuInfo com.android.internal.view.menu.MenuBuilder ), 0, this, cascadingMenuInfo, menuBuilder);
    }

    @Override
    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$isShowing(), 0, this);
    }

    @Override
    public void onDismiss() {
        InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onDismiss(), 0, this);
    }

    @Override
    public void updateMenuView(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMenuView", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$updateMenuView(boolean ), 0, this, bl);
    }

    @Override
    public void setCallback(MenuPresenter.Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setCallback(com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, callback);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSubMenuSelected", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onSubMenuSelected(com.android.internal.view.menu.SubMenuBuilder ), 0, this, subMenuBuilder);
    }

    private int findIndexOfAddedMenu(MenuBuilder menuBuilder) {
        return (int)InvokeDynamicSupport.bootstrap("findIndexOfAddedMenu", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$findIndexOfAddedMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
    }

    @Override
    public boolean flagActionItems() {
        return (boolean)InvokeDynamicSupport.bootstrap("flagActionItems", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$flagActionItems(), 0, this);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setGravity(int ), 0, this, n);
    }

    @Override
    public void setAnchorView(View view) {
        InvokeDynamicSupport.bootstrap("setAnchorView", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setAnchorView(android.view.View ), 0, this, view);
    }

    @Override
    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setOnDismissListener(android.widget.PopupWindow$OnDismissListener ), 0, this, onDismissListener);
    }

    @Override
    public ListView getListView() {
        return InvokeDynamicSupport.bootstrap("getListView", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$getListView(), 0, this);
    }

    @Override
    public void setHorizontalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setHorizontalOffset", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setHorizontalOffset(int ), 0, this, n);
    }

    @Override
    public void setVerticalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalOffset", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setVerticalOffset(int ), 0, this, n);
    }

    @Override
    public void setShowTitle(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowTitle", $$robo$$com_android_internal_view_menu_CascadingMenuPopup$setShowTitle(boolean ), 0, this, bl);
    }

    public /* synthetic */ CascadingMenuPopup() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CascadingMenuPopup)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CascadingMenuInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public MenuPopupWindow window;
        public MenuBuilder menu;
        public int position;

        private void $$robo$$com_android_internal_view_menu_CascadingMenuPopup_CascadingMenuInfo$__constructor__(MenuPopupWindow window, MenuBuilder menu2, int position) {
            this.window = window;
            this.menu = menu2;
            this.position = position;
        }

        private final ListView $$robo$$com_android_internal_view_menu_CascadingMenuPopup_CascadingMenuInfo$getListView() {
            return this.window.getListView();
        }

        private void __constructor__(MenuPopupWindow menuPopupWindow, MenuBuilder menuBuilder, int n) {
            this.$$robo$$com_android_internal_view_menu_CascadingMenuPopup_CascadingMenuInfo$__constructor__(menuPopupWindow, menuBuilder, n);
        }

        public CascadingMenuInfo(MenuPopupWindow menuPopupWindow, MenuBuilder menuBuilder, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_CascadingMenuInfo$__constructor__(android.widget.MenuPopupWindow com.android.internal.view.menu.MenuBuilder int ), 0, this, menuPopupWindow, menuBuilder, n);
        }

        public ListView getListView() {
            return InvokeDynamicSupport.bootstrap("getListView", $$robo$$com_android_internal_view_menu_CascadingMenuPopup_CascadingMenuInfo$getListView(), 0, this);
        }

        public /* synthetic */ CascadingMenuInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CascadingMenuInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

