/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String STRING_ARRAY_SEPARATOR = ":";

    private void $$robo$$com_android_internal_util_XmlUtils$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$skipCurrentTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
        }
    }

    private static final int $$robo$$com_android_internal_util_XmlUtils$convertValueToList(CharSequence value, String[] options, int defaultValue) {
        if (null != value) {
            for (int i = 0; i < options.length; ++i) {
                if (!value.equals(options[i])) continue;
                return i;
            }
        }
        return defaultValue;
    }

    private static final boolean $$robo$$com_android_internal_util_XmlUtils$convertValueToBoolean(CharSequence value, boolean defaultValue) {
        boolean result = false;
        if (null == value) {
            return defaultValue;
        }
        if (value.equals("1") || value.equals("true") || value.equals("TRUE")) {
            result = true;
        }
        return result;
    }

    private static final int $$robo$$com_android_internal_util_XmlUtils$convertValueToInt(CharSequence charSeq, int defaultValue) {
        if (null == charSeq) {
            return defaultValue;
        }
        String nm = charSeq.toString();
        int sign = 1;
        int index = 0;
        int len = nm.length();
        int base = 10;
        if ('-' == nm.charAt(0)) {
            sign = -1;
            ++index;
        }
        if ('0' == nm.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = nm.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == nm.charAt(index)) {
            ++index;
            base = 16;
        }
        return Integer.parseInt(nm.substring(index), base) * sign;
    }

    private static final int $$robo$$com_android_internal_util_XmlUtils$convertValueToUnsignedInt(String value, int defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        return XmlUtils.parseUnsignedIntAttribute(value);
    }

    private static final int $$robo$$com_android_internal_util_XmlUtils$parseUnsignedIntAttribute(CharSequence charSeq) {
        String value = charSeq.toString();
        int index = 0;
        int len = value.length();
        int base = 10;
        if ('0' == value.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = value.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == value.charAt(index)) {
            ++index;
            base = 16;
        }
        return (int)Long.parseLong(value.substring(index), base);
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeMapXml(Map val, OutputStream out) throws XmlPullParserException, IOException {
        FastXmlSerializer serializer = new FastXmlSerializer();
        serializer.setOutput(out, StandardCharsets.UTF_8.name());
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeMapXml(val, null, serializer);
        serializer.endDocument();
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeListXml(List val, OutputStream out) throws XmlPullParserException, IOException {
        XmlSerializer serializer = Xml.newSerializer();
        serializer.setOutput(out, StandardCharsets.UTF_8.name());
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeListXml(val, null, serializer);
        serializer.endDocument();
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeMapXml(Map val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        XmlUtils.writeMapXml(val, name, out, null);
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeMapXml(Map val, String name, XmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "map");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        XmlUtils.writeMapXml(val, out, callback);
        out.endTag(null, "map");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeMapXml(Map val, XmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        if (val == null) {
            return;
        }
        Set s = val.entrySet();
        for (Map.Entry e : s) {
            XmlUtils.writeValueXml(e.getValue(), (String)e.getKey(), out, callback);
        }
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeListXml(List val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "list");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.size();
        for (int i = 0; i < N; ++i) {
            XmlUtils.writeValueXml(val.get(i), null, out);
        }
        out.endTag(null, "list");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeSetXml(Set val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "set");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        for (Object v : val) {
            XmlUtils.writeValueXml(v, null, out);
        }
        out.endTag(null, "set");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeByteArrayXml(byte[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "byte-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        StringBuilder sb = new StringBuilder(val.length * 2);
        for (int i = 0; i < N; ++i) {
            byte b = val[i];
            int h = b >> 4;
            sb.append(h >= 10 ? 97 + h - 10 : 48 + h);
            h = b & 0xFF;
            sb.append(h >= 10 ? 97 + h - 10 : 48 + h);
        }
        out.text(sb.toString());
        out.endTag(null, "byte-array");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeIntArrayXml(int[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "int-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Integer.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "int-array");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeLongArrayXml(long[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "long-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Long.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "long-array");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeDoubleArrayXml(double[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "double-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Double.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "double-array");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeStringArrayXml(String[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "string-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", val[i]);
            out.endTag(null, "item");
        }
        out.endTag(null, "string-array");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeBooleanArrayXml(boolean[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "boolean-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Boolean.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "boolean-array");
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeValueXml(Object v, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        XmlUtils.writeValueXml(v, name, out, null);
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeValueXml(Object v, String name, XmlSerializer out, WriteMapCallback callback) throws XmlPullParserException, IOException {
        String typeStr;
        if (v == null) {
            out.startTag(null, "null");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.endTag(null, "null");
            return;
        }
        if (v instanceof String) {
            out.startTag(null, "string");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.text(v.toString());
            out.endTag(null, "string");
            return;
        }
        if (v instanceof Integer) {
            typeStr = "int";
        } else if (v instanceof Long) {
            typeStr = "long";
        } else if (v instanceof Float) {
            typeStr = "float";
        } else if (v instanceof Double) {
            typeStr = "double";
        } else if (v instanceof Boolean) {
            typeStr = "boolean";
        } else {
            if (v instanceof byte[]) {
                XmlUtils.writeByteArrayXml((byte[])v, name, out);
                return;
            }
            if (v instanceof int[]) {
                XmlUtils.writeIntArrayXml((int[])v, name, out);
                return;
            }
            if (v instanceof long[]) {
                XmlUtils.writeLongArrayXml((long[])v, name, out);
                return;
            }
            if (v instanceof double[]) {
                XmlUtils.writeDoubleArrayXml((double[])v, name, out);
                return;
            }
            if (v instanceof String[]) {
                XmlUtils.writeStringArrayXml((String[])v, name, out);
                return;
            }
            if (v instanceof boolean[]) {
                XmlUtils.writeBooleanArrayXml((boolean[])v, name, out);
                return;
            }
            if (v instanceof Map) {
                XmlUtils.writeMapXml((Map)v, name, out);
                return;
            }
            if (v instanceof List) {
                XmlUtils.writeListXml((List)v, name, out);
                return;
            }
            if (v instanceof Set) {
                XmlUtils.writeSetXml((Set)v, name, out);
                return;
            }
            if (v instanceof CharSequence) {
                out.startTag(null, "string");
                if (name != null) {
                    out.attribute(null, "name", name);
                }
                out.text(v.toString());
                out.endTag(null, "string");
                return;
            }
            if (callback != null) {
                callback.writeUnknownObject(v, name, out);
                return;
            }
            throw new RuntimeException("writeValueXml: unable to write value " + v);
        }
        out.startTag(null, typeStr);
        if (name != null) {
            out.attribute(null, "name", name);
        }
        out.attribute(null, "value", v.toString());
        out.endTag(null, typeStr);
    }

    private static final HashMap<String, ?> $$robo$$com_android_internal_util_XmlUtils$readMapXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, StandardCharsets.UTF_8.name());
        return (HashMap)XmlUtils.readValueXml(parser, new String[1]);
    }

    private static final ArrayList $$robo$$com_android_internal_util_XmlUtils$readListXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, StandardCharsets.UTF_8.name());
        return (ArrayList)XmlUtils.readValueXml(parser, new String[1]);
    }

    private static final HashSet $$robo$$com_android_internal_util_XmlUtils$readSetXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        return (HashSet)XmlUtils.readValueXml(parser, new String[1]);
    }

    private static final HashMap<String, ?> $$robo$$com_android_internal_util_XmlUtils$readThisMapXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisMapXml(parser, endTag, name, null);
    }

    private static final HashMap<String, ?> $$robo$$com_android_internal_util_XmlUtils$readThisMapXml(XmlPullParser parser, String endTag, String[] name, ReadMapCallback callback) throws XmlPullParserException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, false);
                map.put(name[0], val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return map;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    private static final ArrayMap<String, ?> $$robo$$com_android_internal_util_XmlUtils$readThisArrayMapXml(XmlPullParser parser, String endTag, String[] name, ReadMapCallback callback) throws XmlPullParserException, IOException {
        ArrayMap<String, Object> map = new ArrayMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, true);
                map.put(name[0], val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return map;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    private static final ArrayList $$robo$$com_android_internal_util_XmlUtils$readThisListXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisListXml(parser, endTag, name, null, false);
    }

    private static final ArrayList $$robo$$com_android_internal_util_XmlUtils$readThisListXml(XmlPullParser parser, String endTag, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, arrayMap);
                list.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return list;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    private static final HashSet $$robo$$com_android_internal_util_XmlUtils$readThisSetXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        return XmlUtils.readThisSetXml(parser, endTag, name, null, false);
    }

    private static final HashSet $$robo$$com_android_internal_util_XmlUtils$readThisSetXml(XmlPullParser parser, String endTag, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        HashSet<Object> set = new HashSet<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name, callback, arrayMap);
                set.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return set;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int[] $$robo$$com_android_internal_util_XmlUtils$readThisIntArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in byte-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in byte-array");
        }
        parser.next();
        int[] array2 = new int[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Integer.parseInt(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final long[] $$robo$$com_android_internal_util_XmlUtils$readThisLongArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in long-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in long-array");
        }
        parser.next();
        long[] array2 = new long[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Long.parseLong(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final double[] $$robo$$com_android_internal_util_XmlUtils$readThisDoubleArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in double-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in double-array");
        }
        parser.next();
        double[] array2 = new double[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Double.parseDouble(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String[] $$robo$$com_android_internal_util_XmlUtils$readThisStringArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in string-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in string-array");
        }
        parser.next();
        String[] array2 = new String[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = parser.getAttributeValue(null, "value");
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean[] $$robo$$com_android_internal_util_XmlUtils$readThisBooleanArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in string-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in string-array");
        }
        parser.next();
        boolean[] array2 = new boolean[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Boolean.valueOf(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    private static final Object $$robo$$com_android_internal_util_XmlUtils$readValueXml(XmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                return XmlUtils.readThisValueXml(parser, name, null, false);
            }
            if (eventType == 3) {
                throw new XmlPullParserException("Unexpected end tag at: " + parser.getName());
            }
            if (eventType == 4) {
                throw new XmlPullParserException("Unexpected text: " + parser.getText());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Unexpected end of document");
    }

    private static final Object $$robo$$com_android_internal_util_XmlUtils$readThisValueXml(XmlPullParser parser, String[] name, ReadMapCallback callback, boolean arrayMap) throws XmlPullParserException, IOException {
        String tagName;
        block22: {
            int eventType;
            Object res;
            String valueName = parser.getAttributeValue(null, "name");
            tagName = parser.getName();
            if (tagName.equals("null")) {
                res = null;
            } else {
                if (tagName.equals("string")) {
                    block21: {
                        String value = "";
                        while (true) {
                            int eventType2 = parser.next();
                            if (eventType2 == 1) break block21;
                            if (eventType2 == 3) {
                                if (parser.getName().equals("string")) {
                                    name[0] = valueName;
                                    return value;
                                }
                                throw new XmlPullParserException("Unexpected end tag in <string>: " + parser.getName());
                            }
                            if (eventType2 == 4) {
                                value = value + parser.getText();
                                continue;
                            }
                            if (eventType2 == 2) break;
                        }
                        throw new XmlPullParserException("Unexpected start tag in <string>: " + parser.getName());
                    }
                    throw new XmlPullParserException("Unexpected end of document in <string>");
                }
                res = XmlUtils.readThisPrimitiveValueXml(parser, tagName);
                if (res == null) {
                    if (tagName.equals("int-array")) {
                        res = XmlUtils.readThisIntArrayXml(parser, "int-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("long-array")) {
                        res = XmlUtils.readThisLongArrayXml(parser, "long-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("double-array")) {
                        res = XmlUtils.readThisDoubleArrayXml(parser, "double-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("string-array")) {
                        res = XmlUtils.readThisStringArrayXml(parser, "string-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("boolean-array")) {
                        res = XmlUtils.readThisBooleanArrayXml(parser, "boolean-array", name);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("map")) {
                        parser.next();
                        res = arrayMap ? XmlUtils.readThisArrayMapXml(parser, "map", name, callback) : XmlUtils.readThisMapXml(parser, "map", name, callback);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("list")) {
                        parser.next();
                        res = XmlUtils.readThisListXml(parser, "list", name, callback, arrayMap);
                        name[0] = valueName;
                        return res;
                    }
                    if (tagName.equals("set")) {
                        parser.next();
                        res = XmlUtils.readThisSetXml(parser, "set", name, callback, arrayMap);
                        name[0] = valueName;
                        return res;
                    }
                    if (callback != null) {
                        res = callback.readThisUnknownObjectXml(parser, tagName);
                        name[0] = valueName;
                        return res;
                    }
                    throw new XmlPullParserException("Unknown tag: " + tagName);
                }
            }
            do {
                eventType = parser.next();
                if (eventType == 1) break block22;
                if (eventType == 3) {
                    if (parser.getName().equals(tagName)) {
                        name[0] = valueName;
                        return res;
                    }
                    throw new XmlPullParserException("Unexpected end tag in <" + tagName + ">: " + parser.getName());
                }
                if (eventType == 4) {
                    throw new XmlPullParserException("Unexpected text in <" + tagName + ">: " + parser.getName());
                }
            } while (eventType != 2);
            throw new XmlPullParserException("Unexpected start tag in <" + tagName + ">: " + parser.getName());
        }
        throw new XmlPullParserException("Unexpected end of document in <" + tagName + ">");
    }

    private static final Object $$robo$$com_android_internal_util_XmlUtils$readThisPrimitiveValueXml(XmlPullParser parser, String tagName) throws XmlPullParserException, IOException {
        try {
            if (tagName.equals("int")) {
                return Integer.parseInt(parser.getAttributeValue(null, "value"));
            }
            if (tagName.equals("long")) {
                return Long.valueOf(parser.getAttributeValue(null, "value"));
            }
            if (tagName.equals("float")) {
                return new Float(parser.getAttributeValue(null, "value"));
            }
            if (tagName.equals("double")) {
                return new Double(parser.getAttributeValue(null, "value"));
            }
            if (tagName.equals("boolean")) {
                return Boolean.valueOf(parser.getAttributeValue(null, "value"));
            }
            return null;
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need value attribute in <" + tagName + ">");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in value attribute in <" + tagName + ">");
        }
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$nextElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
    }

    private static final boolean $$robo$$com_android_internal_util_XmlUtils$nextElementWithin(XmlPullParser parser, int outerDepth) throws IOException, XmlPullParserException {
        int type;
        do {
            if ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() != outerDepth)) continue;
            return false;
        } while (type != 2 || parser.getDepth() != outerDepth + 1);
        return true;
    }

    private static final int $$robo$$com_android_internal_util_XmlUtils$readIntAttribute(XmlPullParser in, String name, int defaultValue) {
        String value = in.getAttributeValue(null, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static final int $$robo$$com_android_internal_util_XmlUtils$readIntAttribute(XmlPullParser in, String name) throws IOException {
        String value = in.getAttributeValue(null, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as int");
        }
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeIntAttribute(XmlSerializer out, String name, int value) throws IOException {
        out.attribute(null, name, Integer.toString(value));
    }

    private static final long $$robo$$com_android_internal_util_XmlUtils$readLongAttribute(XmlPullParser in, String name, long defaultValue) {
        String value = in.getAttributeValue(null, name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static final long $$robo$$com_android_internal_util_XmlUtils$readLongAttribute(XmlPullParser in, String name) throws IOException {
        String value = in.getAttributeValue(null, name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as long");
        }
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeLongAttribute(XmlSerializer out, String name, long value) throws IOException {
        out.attribute(null, name, Long.toString(value));
    }

    private static final float $$robo$$com_android_internal_util_XmlUtils$readFloatAttribute(XmlPullParser in, String name) throws IOException {
        String value = in.getAttributeValue(null, name);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("problem parsing " + name + "=" + value + " as long");
        }
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeFloatAttribute(XmlSerializer out, String name, float value) throws IOException {
        out.attribute(null, name, Float.toString(value));
    }

    private static final boolean $$robo$$com_android_internal_util_XmlUtils$readBooleanAttribute(XmlPullParser in, String name) {
        String value = in.getAttributeValue(null, name);
        return Boolean.parseBoolean(value);
    }

    private static final boolean $$robo$$com_android_internal_util_XmlUtils$readBooleanAttribute(XmlPullParser in, String name, boolean defaultValue) {
        String value = in.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeBooleanAttribute(XmlSerializer out, String name, boolean value) throws IOException {
        out.attribute(null, name, Boolean.toString(value));
    }

    private static final Uri $$robo$$com_android_internal_util_XmlUtils$readUriAttribute(XmlPullParser in, String name) {
        String value = in.getAttributeValue(null, name);
        return value != null ? Uri.parse(value) : null;
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeUriAttribute(XmlSerializer out, String name, Uri value) throws IOException {
        if (value != null) {
            out.attribute(null, name, value.toString());
        }
    }

    private static final String $$robo$$com_android_internal_util_XmlUtils$readStringAttribute(XmlPullParser in, String name) {
        return in.getAttributeValue(null, name);
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeStringAttribute(XmlSerializer out, String name, String value) throws IOException {
        if (value != null) {
            out.attribute(null, name, value);
        }
    }

    private static final byte[] $$robo$$com_android_internal_util_XmlUtils$readByteArrayAttribute(XmlPullParser in, String name) {
        String value = in.getAttributeValue(null, name);
        if (value != null) {
            return Base64.decode(value, 0);
        }
        return null;
    }

    private static final void $$robo$$com_android_internal_util_XmlUtils$writeByteArrayAttribute(XmlSerializer out, String name, byte[] value) throws IOException {
        if (value != null) {
            out.attribute(null, name, Base64.encodeToString(value, 0));
        }
    }

    private static final Bitmap $$robo$$com_android_internal_util_XmlUtils$readBitmapAttribute(XmlPullParser in, String name) {
        byte[] value = XmlUtils.readByteArrayAttribute(in, name);
        if (value != null) {
            return BitmapFactory.decodeByteArray(value, 0, value.length);
        }
        return null;
    }

    @Deprecated
    private static final void $$robo$$com_android_internal_util_XmlUtils$writeBitmapAttribute(XmlSerializer out, String name, Bitmap value) throws IOException {
        if (value != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            value.compress(Bitmap.CompressFormat.PNG, 90, os);
            XmlUtils.writeByteArrayAttribute(out, name, os.toByteArray());
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_XmlUtils$__constructor__();
    }

    public XmlUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_XmlUtils$__constructor__(), 0, this);
    }

    public static void skipCurrentTag(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("skipCurrentTag", $$robo$$com_android_internal_util_XmlUtils$skipCurrentTag(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public static int convertValueToList(CharSequence charSequence, String[] stringArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertValueToList", $$robo$$com_android_internal_util_XmlUtils$convertValueToList(java.lang.CharSequence java.lang.String[] int ), 0, (CharSequence)charSequence, (String[])stringArray, (int)n);
    }

    public static boolean convertValueToBoolean(CharSequence charSequence, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("convertValueToBoolean", $$robo$$com_android_internal_util_XmlUtils$convertValueToBoolean(java.lang.CharSequence boolean ), 0, (CharSequence)charSequence, (boolean)bl);
    }

    public static int convertValueToInt(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertValueToInt", $$robo$$com_android_internal_util_XmlUtils$convertValueToInt(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
    }

    public static int convertValueToUnsignedInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertValueToUnsignedInt", $$robo$$com_android_internal_util_XmlUtils$convertValueToUnsignedInt(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static int parseUnsignedIntAttribute(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseUnsignedIntAttribute", $$robo$$com_android_internal_util_XmlUtils$parseUnsignedIntAttribute(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static void writeMapXml(Map map, OutputStream outputStream) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeMapXml", $$robo$$com_android_internal_util_XmlUtils$writeMapXml(java.util.Map java.io.OutputStream ), 0, (Map)map, (OutputStream)outputStream);
    }

    public static void writeListXml(List list, OutputStream outputStream) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeListXml", $$robo$$com_android_internal_util_XmlUtils$writeListXml(java.util.List java.io.OutputStream ), 0, (List)list, (OutputStream)outputStream);
    }

    public static void writeMapXml(Map map, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeMapXml", $$robo$$com_android_internal_util_XmlUtils$writeMapXml(java.util.Map java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (Map)map, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeMapXml(Map map, String string2, XmlSerializer xmlSerializer, WriteMapCallback writeMapCallback) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeMapXml", $$robo$$com_android_internal_util_XmlUtils$writeMapXml(java.util.Map java.lang.String org.xmlpull.v1.XmlSerializer com.android.internal.util.XmlUtils$WriteMapCallback ), 0, (Map)map, (String)string2, (XmlSerializer)xmlSerializer, (WriteMapCallback)writeMapCallback);
    }

    public static void writeMapXml(Map map, XmlSerializer xmlSerializer, WriteMapCallback writeMapCallback) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeMapXml", $$robo$$com_android_internal_util_XmlUtils$writeMapXml(java.util.Map org.xmlpull.v1.XmlSerializer com.android.internal.util.XmlUtils$WriteMapCallback ), 0, (Map)map, (XmlSerializer)xmlSerializer, (WriteMapCallback)writeMapCallback);
    }

    public static void writeListXml(List list, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeListXml", $$robo$$com_android_internal_util_XmlUtils$writeListXml(java.util.List java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (List)list, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeSetXml(Set set, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeSetXml", $$robo$$com_android_internal_util_XmlUtils$writeSetXml(java.util.Set java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (Set)set, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeByteArrayXml(byte[] byArray, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeByteArrayXml", $$robo$$com_android_internal_util_XmlUtils$writeByteArrayXml(byte[] java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (byte[])byArray, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeIntArrayXml(int[] nArray, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeIntArrayXml", $$robo$$com_android_internal_util_XmlUtils$writeIntArrayXml(int[] java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (int[])nArray, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeLongArrayXml(long[] lArray, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeLongArrayXml", $$robo$$com_android_internal_util_XmlUtils$writeLongArrayXml(long[] java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (long[])lArray, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeDoubleArrayXml(double[] dArray, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeDoubleArrayXml", $$robo$$com_android_internal_util_XmlUtils$writeDoubleArrayXml(double[] java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (double[])dArray, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeStringArrayXml(String[] stringArray, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeStringArrayXml", $$robo$$com_android_internal_util_XmlUtils$writeStringArrayXml(java.lang.String[] java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (String[])stringArray, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeBooleanArrayXml(boolean[] blArray, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeBooleanArrayXml", $$robo$$com_android_internal_util_XmlUtils$writeBooleanArrayXml(boolean[] java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (boolean[])blArray, (String)string2, (XmlSerializer)xmlSerializer);
    }

    public static void writeValueXml(Object object, String string2, XmlSerializer xmlSerializer) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeValueXml", $$robo$$com_android_internal_util_XmlUtils$writeValueXml(java.lang.Object java.lang.String org.xmlpull.v1.XmlSerializer ), 0, (Object)object, (String)string2, (XmlSerializer)xmlSerializer);
    }

    private static void writeValueXml(Object object, String string2, XmlSerializer xmlSerializer, WriteMapCallback writeMapCallback) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("writeValueXml", $$robo$$com_android_internal_util_XmlUtils$writeValueXml(java.lang.Object java.lang.String org.xmlpull.v1.XmlSerializer com.android.internal.util.XmlUtils$WriteMapCallback ), 0, (Object)object, (String)string2, (XmlSerializer)xmlSerializer, (WriteMapCallback)writeMapCallback);
    }

    public static HashMap<String, ?> readMapXml(InputStream inputStream) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readMapXml", $$robo$$com_android_internal_util_XmlUtils$readMapXml(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static ArrayList readListXml(InputStream inputStream) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readListXml", $$robo$$com_android_internal_util_XmlUtils$readListXml(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static HashSet readSetXml(InputStream inputStream) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readSetXml", $$robo$$com_android_internal_util_XmlUtils$readSetXml(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static HashMap<String, ?> readThisMapXml(XmlPullParser xmlPullParser, String string2, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisMapXml", $$robo$$com_android_internal_util_XmlUtils$readThisMapXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray);
    }

    public static HashMap<String, ?> readThisMapXml(XmlPullParser xmlPullParser, String string2, String[] stringArray, ReadMapCallback readMapCallback) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisMapXml", $$robo$$com_android_internal_util_XmlUtils$readThisMapXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] com.android.internal.util.XmlUtils$ReadMapCallback ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray, (ReadMapCallback)readMapCallback);
    }

    public static ArrayMap<String, ?> readThisArrayMapXml(XmlPullParser xmlPullParser, String string2, String[] stringArray, ReadMapCallback readMapCallback) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisArrayMapXml", $$robo$$com_android_internal_util_XmlUtils$readThisArrayMapXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] com.android.internal.util.XmlUtils$ReadMapCallback ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray, (ReadMapCallback)readMapCallback);
    }

    public static ArrayList readThisListXml(XmlPullParser xmlPullParser, String string2, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisListXml", $$robo$$com_android_internal_util_XmlUtils$readThisListXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray);
    }

    private static ArrayList readThisListXml(XmlPullParser xmlPullParser, String string2, String[] stringArray, ReadMapCallback readMapCallback, boolean bl) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisListXml", $$robo$$com_android_internal_util_XmlUtils$readThisListXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] com.android.internal.util.XmlUtils$ReadMapCallback boolean ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray, (ReadMapCallback)readMapCallback, (boolean)bl);
    }

    public static HashSet readThisSetXml(XmlPullParser xmlPullParser, String string2, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisSetXml", $$robo$$com_android_internal_util_XmlUtils$readThisSetXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray);
    }

    private static HashSet readThisSetXml(XmlPullParser xmlPullParser, String string2, String[] stringArray, ReadMapCallback readMapCallback, boolean bl) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisSetXml", $$robo$$com_android_internal_util_XmlUtils$readThisSetXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] com.android.internal.util.XmlUtils$ReadMapCallback boolean ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray, (ReadMapCallback)readMapCallback, (boolean)bl);
    }

    public static int[] readThisIntArrayXml(XmlPullParser xmlPullParser, String string2, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisIntArrayXml", $$robo$$com_android_internal_util_XmlUtils$readThisIntArrayXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray);
    }

    public static long[] readThisLongArrayXml(XmlPullParser xmlPullParser, String string2, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisLongArrayXml", $$robo$$com_android_internal_util_XmlUtils$readThisLongArrayXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray);
    }

    public static double[] readThisDoubleArrayXml(XmlPullParser xmlPullParser, String string2, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisDoubleArrayXml", $$robo$$com_android_internal_util_XmlUtils$readThisDoubleArrayXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray);
    }

    public static String[] readThisStringArrayXml(XmlPullParser xmlPullParser, String string2, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisStringArrayXml", $$robo$$com_android_internal_util_XmlUtils$readThisStringArrayXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray);
    }

    public static boolean[] readThisBooleanArrayXml(XmlPullParser xmlPullParser, String string2, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisBooleanArrayXml", $$robo$$com_android_internal_util_XmlUtils$readThisBooleanArrayXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String)string2, (String[])stringArray);
    }

    public static Object readValueXml(XmlPullParser xmlPullParser, String[] stringArray) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readValueXml", $$robo$$com_android_internal_util_XmlUtils$readValueXml(org.xmlpull.v1.XmlPullParser java.lang.String[] ), 0, (XmlPullParser)xmlPullParser, (String[])stringArray);
    }

    private static Object readThisValueXml(XmlPullParser xmlPullParser, String[] stringArray, ReadMapCallback readMapCallback, boolean bl) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisValueXml", $$robo$$com_android_internal_util_XmlUtils$readThisValueXml(org.xmlpull.v1.XmlPullParser java.lang.String[] com.android.internal.util.XmlUtils$ReadMapCallback boolean ), 0, (XmlPullParser)xmlPullParser, (String[])stringArray, (ReadMapCallback)readMapCallback, (boolean)bl);
    }

    private static Object readThisPrimitiveValueXml(XmlPullParser xmlPullParser, String string2) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readThisPrimitiveValueXml", $$robo$$com_android_internal_util_XmlUtils$readThisPrimitiveValueXml(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static void beginDocument(XmlPullParser xmlPullParser, String string2) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("beginDocument", $$robo$$com_android_internal_util_XmlUtils$beginDocument(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static void nextElement(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrapStatic("nextElement", $$robo$$com_android_internal_util_XmlUtils$nextElement(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public static boolean nextElementWithin(XmlPullParser xmlPullParser, int n) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nextElementWithin", $$robo$$com_android_internal_util_XmlUtils$nextElementWithin(org.xmlpull.v1.XmlPullParser int ), 0, (XmlPullParser)xmlPullParser, (int)n);
    }

    public static int readIntAttribute(XmlPullParser xmlPullParser, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("readIntAttribute", $$robo$$com_android_internal_util_XmlUtils$readIntAttribute(org.xmlpull.v1.XmlPullParser java.lang.String int ), 0, (XmlPullParser)xmlPullParser, (String)string2, (int)n);
    }

    public static int readIntAttribute(XmlPullParser xmlPullParser, String string2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("readIntAttribute", $$robo$$com_android_internal_util_XmlUtils$readIntAttribute(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static void writeIntAttribute(XmlSerializer xmlSerializer, String string2, int n) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeIntAttribute", $$robo$$com_android_internal_util_XmlUtils$writeIntAttribute(org.xmlpull.v1.XmlSerializer java.lang.String int ), 0, (XmlSerializer)xmlSerializer, (String)string2, (int)n);
    }

    public static long readLongAttribute(XmlPullParser xmlPullParser, String string2, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("readLongAttribute", $$robo$$com_android_internal_util_XmlUtils$readLongAttribute(org.xmlpull.v1.XmlPullParser java.lang.String long ), 0, (XmlPullParser)xmlPullParser, (String)string2, (long)l);
    }

    public static long readLongAttribute(XmlPullParser xmlPullParser, String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("readLongAttribute", $$robo$$com_android_internal_util_XmlUtils$readLongAttribute(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static void writeLongAttribute(XmlSerializer xmlSerializer, String string2, long l) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeLongAttribute", $$robo$$com_android_internal_util_XmlUtils$writeLongAttribute(org.xmlpull.v1.XmlSerializer java.lang.String long ), 0, (XmlSerializer)xmlSerializer, (String)string2, (long)l);
    }

    public static float readFloatAttribute(XmlPullParser xmlPullParser, String string2) throws IOException {
        return (float)InvokeDynamicSupport.bootstrapStatic("readFloatAttribute", $$robo$$com_android_internal_util_XmlUtils$readFloatAttribute(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static void writeFloatAttribute(XmlSerializer xmlSerializer, String string2, float f) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeFloatAttribute", $$robo$$com_android_internal_util_XmlUtils$writeFloatAttribute(org.xmlpull.v1.XmlSerializer java.lang.String float ), 0, (XmlSerializer)xmlSerializer, (String)string2, (float)f);
    }

    public static boolean readBooleanAttribute(XmlPullParser xmlPullParser, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("readBooleanAttribute", $$robo$$com_android_internal_util_XmlUtils$readBooleanAttribute(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static boolean readBooleanAttribute(XmlPullParser xmlPullParser, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("readBooleanAttribute", $$robo$$com_android_internal_util_XmlUtils$readBooleanAttribute(org.xmlpull.v1.XmlPullParser java.lang.String boolean ), 0, (XmlPullParser)xmlPullParser, (String)string2, (boolean)bl);
    }

    public static void writeBooleanAttribute(XmlSerializer xmlSerializer, String string2, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeBooleanAttribute", $$robo$$com_android_internal_util_XmlUtils$writeBooleanAttribute(org.xmlpull.v1.XmlSerializer java.lang.String boolean ), 0, (XmlSerializer)xmlSerializer, (String)string2, (boolean)bl);
    }

    public static Uri readUriAttribute(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("readUriAttribute", $$robo$$com_android_internal_util_XmlUtils$readUriAttribute(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static void writeUriAttribute(XmlSerializer xmlSerializer, String string2, Uri uri) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeUriAttribute", $$robo$$com_android_internal_util_XmlUtils$writeUriAttribute(org.xmlpull.v1.XmlSerializer java.lang.String android.net.Uri ), 0, (XmlSerializer)xmlSerializer, (String)string2, (Uri)uri);
    }

    public static String readStringAttribute(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("readStringAttribute", $$robo$$com_android_internal_util_XmlUtils$readStringAttribute(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static void writeStringAttribute(XmlSerializer xmlSerializer, String string2, String string3) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeStringAttribute", $$robo$$com_android_internal_util_XmlUtils$writeStringAttribute(org.xmlpull.v1.XmlSerializer java.lang.String java.lang.String ), 0, (XmlSerializer)xmlSerializer, (String)string2, (String)string3);
    }

    public static byte[] readByteArrayAttribute(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("readByteArrayAttribute", $$robo$$com_android_internal_util_XmlUtils$readByteArrayAttribute(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public static void writeByteArrayAttribute(XmlSerializer xmlSerializer, String string2, byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeByteArrayAttribute", $$robo$$com_android_internal_util_XmlUtils$writeByteArrayAttribute(org.xmlpull.v1.XmlSerializer java.lang.String byte[] ), 0, (XmlSerializer)xmlSerializer, (String)string2, (byte[])byArray);
    }

    public static Bitmap readBitmapAttribute(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("readBitmapAttribute", $$robo$$com_android_internal_util_XmlUtils$readBitmapAttribute(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    @Deprecated
    public static void writeBitmapAttribute(XmlSerializer xmlSerializer, String string2, Bitmap bitmap) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeBitmapAttribute", $$robo$$com_android_internal_util_XmlUtils$writeBitmapAttribute(org.xmlpull.v1.XmlSerializer java.lang.String android.graphics.Bitmap ), 0, (XmlSerializer)xmlSerializer, (String)string2, (Bitmap)bitmap);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (XmlUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ReadMapCallback
    extends InstrumentedInterface {
        public Object readThisUnknownObjectXml(XmlPullParser var1, String var2) throws XmlPullParserException, IOException;
    }

    public static interface WriteMapCallback
    extends InstrumentedInterface {
        public void writeUnknownObject(Object var1, String var2, XmlSerializer var3) throws XmlPullParserException, IOException;
    }
}

