/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AdnRecord
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "AdnRecord";
    String mAlphaTag;
    String mNumber;
    String[] mEmails;
    int mExtRecord;
    int mEfid;
    int mRecordNumber;
    static int FOOTER_SIZE_BYTES = 14;
    static int MAX_NUMBER_SIZE_BYTES = 11;
    static int EXT_RECORD_LENGTH_BYTES = 13;
    static int EXT_RECORD_TYPE_ADDITIONAL_DATA = 2;
    static int EXT_RECORD_TYPE_MASK = 3;
    static int MAX_EXT_CALLED_PARTY_LENGTH = 10;
    static int ADN_BCD_NUMBER_LENGTH = 0;
    static int ADN_TON_AND_NPI = 1;
    static int ADN_DIALING_NUMBER_START = 2;
    static int ADN_DIALING_NUMBER_END = 11;
    static int ADN_CAPABILITY_ID = 12;
    static int ADN_EXTENSION_ID = 13;
    public static Parcelable.Creator<AdnRecord> CREATOR;

    private void $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(byte[] record) {
    }

    private void $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(int efid, int recordNumber, byte[] record) {
        this.mAlphaTag = null;
        this.mNumber = null;
        this.mExtRecord = 255;
        this.mEfid = efid;
        this.mRecordNumber = recordNumber;
        this.parseRecord(record);
    }

    private void $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(String alphaTag, String number) {
    }

    private void $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(String alphaTag, String number, String[] emails) {
    }

    private void $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(int efid, int recordNumber, String alphaTag, String number, String[] emails) {
        this.mAlphaTag = null;
        this.mNumber = null;
        this.mExtRecord = 255;
        this.mEfid = efid;
        this.mRecordNumber = recordNumber;
        this.mAlphaTag = alphaTag;
        this.mNumber = number;
        this.mEmails = emails;
    }

    private void $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(int efid, int recordNumber, String alphaTag, String number) {
        this.mAlphaTag = null;
        this.mNumber = null;
        this.mExtRecord = 255;
        this.mEfid = efid;
        this.mRecordNumber = recordNumber;
        this.mAlphaTag = alphaTag;
        this.mNumber = number;
        this.mEmails = null;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_AdnRecord$getAlphaTag() {
        return this.mAlphaTag;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AdnRecord$getEfid() {
        return this.mEfid;
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AdnRecord$getRecId() {
        return this.mRecordNumber;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_AdnRecord$getNumber() {
        return this.mNumber;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecord$setNumber(String number) {
        this.mNumber = number;
    }

    private final String[] $$robo$$com_android_internal_telephony_uicc_AdnRecord$getEmails() {
        return this.mEmails;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecord$setEmails(String[] emails) {
        this.mEmails = emails;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_AdnRecord$toString() {
        return "ADN Record '" + this.mAlphaTag + "' '" + this.mNumber + " " + this.mEmails + "'";
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_AdnRecord$isEmpty() {
        return TextUtils.isEmpty(this.mAlphaTag) && TextUtils.isEmpty(this.mNumber) && this.mEmails == null;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_AdnRecord$hasExtendedRecord() {
        return this.mExtRecord != 0 && this.mExtRecord != 255;
    }

    private static final boolean $$robo$$com_android_internal_telephony_uicc_AdnRecord$stringCompareNullEqualsEmpty(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.equals(s2);
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_AdnRecord$isEqual(AdnRecord adn) {
        return AdnRecord.stringCompareNullEqualsEmpty(this.mAlphaTag, adn.mAlphaTag) && AdnRecord.stringCompareNullEqualsEmpty(this.mNumber, adn.mNumber) && Arrays.equals(this.mEmails, adn.mEmails);
    }

    private final int $$robo$$com_android_internal_telephony_uicc_AdnRecord$describeContents() {
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecord$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mEfid);
        dest.writeInt(this.mRecordNumber);
        dest.writeString(this.mAlphaTag);
        dest.writeString(this.mNumber);
        dest.writeStringArray(this.mEmails);
    }

    private final byte[] $$robo$$com_android_internal_telephony_uicc_AdnRecord$buildAdnString(int recordSize) {
        int footerOffset = recordSize - 14;
        byte[] adnString = new byte[recordSize];
        for (int i = 0; i < recordSize; ++i) {
            adnString[i] = -1;
        }
        if (TextUtils.isEmpty(this.mNumber)) {
            Rlog.w("AdnRecord", "[buildAdnString] Empty dialing number");
            return adnString;
        }
        if (this.mNumber.length() > 20) {
            Rlog.w("AdnRecord", "[buildAdnString] Max length of dialing number is 20");
            return null;
        }
        if (this.mAlphaTag != null && this.mAlphaTag.length() > footerOffset) {
            Rlog.w("AdnRecord", "[buildAdnString] Max length of tag is " + footerOffset);
            return null;
        }
        byte[] bcdNumber = PhoneNumberUtils.numberToCalledPartyBCD(this.mNumber);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])bcdNumber, (int)0, (byte[])adnString, (int)(footerOffset + 1), (int)bcdNumber.length);
        adnString[footerOffset + 0] = (byte)bcdNumber.length;
        adnString[footerOffset + 12] = -1;
        adnString[footerOffset + 13] = -1;
        if (!TextUtils.isEmpty(this.mAlphaTag)) {
            byte[] byteTag = GsmAlphabet.stringToGsm8BitPacked(this.mAlphaTag);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])byteTag, (int)0, (byte[])adnString, (int)0, (int)byteTag.length);
        }
        return adnString;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecord$appendExtRecord(byte[] extRecord) {
        try {
            if (extRecord.length != 13) {
                return;
            }
            if ((extRecord[0] & 3) != 2) {
                return;
            }
            if ((0xFF & extRecord[1]) > 10) {
                return;
            }
            this.mNumber = this.mNumber + PhoneNumberUtils.calledPartyBCDFragmentToString(extRecord, 2, 0xFF & extRecord[1]);
        }
        catch (RuntimeException ex) {
            Rlog.w("AdnRecord", "Error parsing AdnRecord ext record", ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecord$parseRecord(byte[] record) {
        try {
            this.mAlphaTag = IccUtils.adnStringFieldToString(record, 0, record.length - 14);
            int footerOffset = record.length - 14;
            int numberLength = 0xFF & record[footerOffset];
            if (numberLength > 11) {
                this.mNumber = "";
                return;
            }
            this.mNumber = PhoneNumberUtils.calledPartyBCDToString(record, footerOffset + 1, numberLength);
            this.mExtRecord = 0xFF & record[record.length - 1];
            this.mEmails = null;
        }
        catch (RuntimeException ex) {
            Rlog.w("AdnRecord", "Error parsing AdnRecord", ex);
            this.mNumber = "";
            this.mAlphaTag = "";
            this.mEmails = null;
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AdnRecord>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_telephony_uicc_AdnRecord_1$__constructor__() {
            }

            private final AdnRecord $$robo$$com_android_internal_telephony_uicc_AdnRecord_1$createFromParcel(Parcel source) {
                int efid = source.readInt();
                int recordNumber = source.readInt();
                String alphaTag = source.readString();
                String number = source.readString();
                String[] emails = source.readStringArray();
                return new AdnRecord(efid, recordNumber, alphaTag, number, emails);
            }

            private final AdnRecord[] $$robo$$com_android_internal_telephony_uicc_AdnRecord_1$newArray(int size) {
                return new AdnRecord[size];
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_telephony_uicc_AdnRecord_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecord_1$__constructor__(), 0, this);
            }

            @Override
            public AdnRecord createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_telephony_uicc_AdnRecord_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AdnRecord[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_telephony_uicc_AdnRecord_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(byte[] byArray) {
        this.$$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(byArray);
    }

    public AdnRecord(byte[] byArray) {
        this(0, 0, byArray);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(byte[] ), 0, this, byArray);
    }

    private void __constructor__(int n, int n2, byte[] byArray) {
        this.$$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(n, n2, byArray);
    }

    public AdnRecord(int n, int n2, byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(int int byte[] ), 0, this, n, n2, byArray);
    }

    private void __constructor__(String string2, String string3) {
        this.$$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(string2, string3);
    }

    public AdnRecord(String string2, String string3) {
        this(0, 0, string2, string3);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void __constructor__(String string2, String string3, String[] stringArray) {
        this.$$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(string2, string3, stringArray);
    }

    public AdnRecord(String string2, String string3, String[] stringArray) {
        this(0, 0, string2, string3, stringArray);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(java.lang.String java.lang.String java.lang.String[] ), 0, this, string2, string3, stringArray);
    }

    private void __constructor__(int n, int n2, String string2, String string3, String[] stringArray) {
        this.$$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(n, n2, string2, string3, stringArray);
    }

    public AdnRecord(int n, int n2, String string2, String string3, String[] stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(int int java.lang.String java.lang.String java.lang.String[] ), 0, this, n, n2, string2, string3, stringArray);
    }

    private void __constructor__(int n, int n2, String string2, String string3) {
        this.$$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(n, n2, string2, string3);
    }

    public AdnRecord(int n, int n2, String string2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecord$__constructor__(int int java.lang.String java.lang.String ), 0, this, n, n2, string2, string3);
    }

    public String getAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getAlphaTag", $$robo$$com_android_internal_telephony_uicc_AdnRecord$getAlphaTag(), 0, this);
    }

    public int getEfid() {
        return (int)InvokeDynamicSupport.bootstrap("getEfid", $$robo$$com_android_internal_telephony_uicc_AdnRecord$getEfid(), 0, this);
    }

    public int getRecId() {
        return (int)InvokeDynamicSupport.bootstrap("getRecId", $$robo$$com_android_internal_telephony_uicc_AdnRecord$getRecId(), 0, this);
    }

    public String getNumber() {
        return InvokeDynamicSupport.bootstrap("getNumber", $$robo$$com_android_internal_telephony_uicc_AdnRecord$getNumber(), 0, this);
    }

    public void setNumber(String string2) {
        InvokeDynamicSupport.bootstrap("setNumber", $$robo$$com_android_internal_telephony_uicc_AdnRecord$setNumber(java.lang.String ), 0, this, string2);
    }

    public String[] getEmails() {
        return InvokeDynamicSupport.bootstrap("getEmails", $$robo$$com_android_internal_telephony_uicc_AdnRecord$getEmails(), 0, this);
    }

    public void setEmails(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setEmails", $$robo$$com_android_internal_telephony_uicc_AdnRecord$setEmails(java.lang.String[] ), 0, this, stringArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_uicc_AdnRecord$toString(), 0, this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$com_android_internal_telephony_uicc_AdnRecord$isEmpty(), 0, this);
    }

    public boolean hasExtendedRecord() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasExtendedRecord", $$robo$$com_android_internal_telephony_uicc_AdnRecord$hasExtendedRecord(), 0, this);
    }

    private static boolean stringCompareNullEqualsEmpty(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("stringCompareNullEqualsEmpty", $$robo$$com_android_internal_telephony_uicc_AdnRecord$stringCompareNullEqualsEmpty(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public boolean isEqual(AdnRecord adnRecord) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEqual", $$robo$$com_android_internal_telephony_uicc_AdnRecord$isEqual(com.android.internal.telephony.uicc.AdnRecord ), 0, this, adnRecord);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_telephony_uicc_AdnRecord$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_telephony_uicc_AdnRecord$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public byte[] buildAdnString(int n) {
        return InvokeDynamicSupport.bootstrap("buildAdnString", $$robo$$com_android_internal_telephony_uicc_AdnRecord$buildAdnString(int ), 0, this, n);
    }

    public void appendExtRecord(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("appendExtRecord", $$robo$$com_android_internal_telephony_uicc_AdnRecord$appendExtRecord(byte[] ), 0, this, byArray);
    }

    private void parseRecord(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("parseRecord", $$robo$$com_android_internal_telephony_uicc_AdnRecord$parseRecord(byte[] ), 0, this, byArray);
    }

    static {
        RobolectricInternals.classInitializing(AdnRecord.class);
    }

    public /* synthetic */ AdnRecord() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdnRecord)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

