/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.Context;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.text.TextUtils;
import com.android.internal.telephony.uicc.IccRecords;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApnSetting
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "ApnSetting";
    private static boolean DBG = false;
    static String V2_FORMAT_REGEX = "^\\[ApnSettingV2\\]\\s*";
    static String V3_FORMAT_REGEX = "^\\[ApnSettingV3\\]\\s*";
    public String carrier;
    public String apn;
    public String proxy;
    public String port;
    public String mmsc;
    public String mmsProxy;
    public String mmsPort;
    public String user;
    public String password;
    public int authType;
    public String[] types;
    public int id;
    public String numeric;
    public String protocol;
    public String roamingProtocol;
    public int mtu;
    public boolean carrierEnabled;
    private int bearer;
    public int bearerBitmask;
    public int profileId;
    public boolean modemCognitive;
    public int maxConns;
    public int waitTime;
    public int maxConnsTime;
    public String mvnoType;
    public String mvnoMatchData;
    public boolean permanentFailed;
    private static HashMap<Integer, HashSet<String>> sMeteredApnTypes;
    private static HashMap<Integer, HashSet<String>> sMeteredRoamingApnTypes;

    private void $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(int id2, String numeric, String carrier, String apn, String proxy, String port, String mmsc, String mmsProxy, String mmsPort, String user, String password, int authType, String[] types, String protocol, String roamingProtocol, boolean carrierEnabled, int bearer, int bearerBitmask, int profileId, boolean modemCognitive, int maxConns, int waitTime, int maxConnsTime, int mtu, String mvnoType, String mvnoMatchData) {
        this.permanentFailed = false;
        this.id = id2;
        this.numeric = numeric;
        this.carrier = carrier;
        this.apn = apn;
        this.proxy = proxy;
        this.port = port;
        this.mmsc = mmsc;
        this.mmsProxy = mmsProxy;
        this.mmsPort = mmsPort;
        this.user = user;
        this.password = password;
        this.authType = authType;
        this.types = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.types[i] = types[i].toLowerCase(Locale.ROOT);
        }
        this.protocol = protocol;
        this.roamingProtocol = roamingProtocol;
        this.carrierEnabled = carrierEnabled;
        this.bearer = bearer;
        this.bearerBitmask = bearerBitmask | ServiceState.getBitmaskForTech(bearer);
        this.profileId = profileId;
        this.modemCognitive = modemCognitive;
        this.maxConns = maxConns;
        this.waitTime = waitTime;
        this.maxConnsTime = maxConnsTime;
        this.mtu = mtu;
        this.mvnoType = mvnoType;
        this.mvnoMatchData = mvnoMatchData;
    }

    private void $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(ApnSetting apn) {
    }

    private static final ApnSetting $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$fromString(String data) {
        boolean carrierEnabled;
        String roamingProtocol;
        String protocol;
        String[] typeArray;
        int authType;
        int version;
        if (data == null) {
            return null;
        }
        if (data.matches("^\\[ApnSettingV3\\]\\s*.*")) {
            version = 3;
            data = data.replaceFirst("^\\[ApnSettingV3\\]\\s*", "");
        } else if (data.matches("^\\[ApnSettingV2\\]\\s*.*")) {
            version = 2;
            data = data.replaceFirst("^\\[ApnSettingV2\\]\\s*", "");
        } else {
            version = 1;
        }
        String[] a = data.split("\\s*,\\s*");
        if (a.length < 14) {
            return null;
        }
        try {
            authType = Integer.parseInt(a[12]);
        }
        catch (NumberFormatException e) {
            authType = 0;
        }
        int bearerBitmask = 0;
        int profileId = 0;
        boolean modemCognitive = false;
        int maxConns = 0;
        int waitTime = 0;
        int maxConnsTime = 0;
        int mtu = 0;
        String mvnoType = "";
        String mvnoMatchData = "";
        if (version == 1) {
            typeArray = new String[a.length - 13];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)a, (int)13, (Object)typeArray, (int)0, (int)(a.length - 13));
            protocol = "IP";
            roamingProtocol = "IP";
            carrierEnabled = true;
        } else {
            if (a.length < 18) {
                return null;
            }
            typeArray = a[13].split("\\s*\\|\\s*");
            protocol = a[14];
            roamingProtocol = a[15];
            carrierEnabled = Boolean.parseBoolean(a[16]);
            bearerBitmask = ServiceState.getBitmaskFromString(a[17]);
            if (a.length > 22) {
                modemCognitive = Boolean.parseBoolean(a[19]);
                try {
                    profileId = Integer.parseInt(a[18]);
                    maxConns = Integer.parseInt(a[20]);
                    waitTime = Integer.parseInt(a[21]);
                    maxConnsTime = Integer.parseInt(a[22]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (a.length > 23) {
                try {
                    mtu = Integer.parseInt(a[23]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (a.length > 25) {
                mvnoType = a[24];
                mvnoMatchData = a[25];
            }
        }
        return new ApnSetting(-1, a[10] + a[11], a[0], a[1], a[2], a[3], a[7], a[8], a[9], a[4], a[5], authType, typeArray, protocol, roamingProtocol, carrierEnabled, 0, bearerBitmask, profileId, modemCognitive, maxConns, waitTime, maxConnsTime, mtu, mvnoType, mvnoMatchData);
    }

    private static final List<ApnSetting> $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$arrayFromString(String data) {
        String[] apnStrings;
        ArrayList<ApnSetting> retVal = new ArrayList<ApnSetting>();
        if (TextUtils.isEmpty(data)) {
            return retVal;
        }
        for (String apnString : apnStrings = data.split("\\s*;\\s*")) {
            ApnSetting apn = ApnSetting.fromString(apnString);
            if (apn == null) continue;
            retVal.add(apn);
        }
        return retVal;
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ApnSettingV3] ").append(this.carrier).append(", ").append(this.id).append(", ").append(this.numeric).append(", ").append(this.apn).append(", ").append(this.proxy).append(", ").append(this.mmsc).append(", ").append(this.mmsProxy).append(", ").append(this.mmsPort).append(", ").append(this.port).append(", ").append(this.authType).append(", ");
        for (int i = 0; i < this.types.length; ++i) {
            sb.append(this.types[i]);
            if (i >= this.types.length - 1) continue;
            sb.append(" | ");
        }
        sb.append(", ").append(this.protocol);
        sb.append(", ").append(this.roamingProtocol);
        sb.append(", ").append(this.carrierEnabled);
        sb.append(", ").append(this.bearer);
        sb.append(", ").append(this.bearerBitmask);
        sb.append(", ").append(this.profileId);
        sb.append(", ").append(this.modemCognitive);
        sb.append(", ").append(this.maxConns);
        sb.append(", ").append(this.waitTime);
        sb.append(", ").append(this.maxConnsTime);
        sb.append(", ").append(this.mtu);
        sb.append(", ").append(this.mvnoType);
        sb.append(", ").append(this.mvnoMatchData);
        sb.append(", ").append(this.permanentFailed);
        return sb.toString();
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$hasMvnoParams() {
        return !TextUtils.isEmpty(this.mvnoType) && !TextUtils.isEmpty(this.mvnoMatchData);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$canHandleType(String type) {
        if (!this.carrierEnabled) {
            return false;
        }
        for (String t : this.types) {
            if (!t.equalsIgnoreCase(type) && !t.equalsIgnoreCase("*") && (!t.equalsIgnoreCase("default") || !type.equalsIgnoreCase("hipri"))) continue;
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$imsiMatches(String imsiDB, String imsiSIM) {
        int len = imsiDB.length();
        boolean idxCompare = false;
        if (len <= 0) {
            return false;
        }
        if (len > imsiSIM.length()) {
            return false;
        }
        for (int idx = 0; idx < len; ++idx) {
            char c = imsiDB.charAt(idx);
            if (c == 'x' || c == 'X' || c == imsiSIM.charAt(idx)) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$mvnoMatches(IccRecords r, String mvnoType, String mvnoMatchData) {
        if (mvnoType.equalsIgnoreCase("spn")) {
            if (r.getServiceProviderName() != null && r.getServiceProviderName().equalsIgnoreCase(mvnoMatchData)) {
                return true;
            }
        } else if (mvnoType.equalsIgnoreCase("imsi")) {
            String imsiSIM = r.getIMSI();
            if (imsiSIM != null && ApnSetting.imsiMatches(mvnoMatchData, imsiSIM)) {
                return true;
            }
        } else if (mvnoType.equalsIgnoreCase("gid")) {
            String gid1 = r.getGid1();
            int mvno_match_data_length = mvnoMatchData.length();
            if (gid1 != null && gid1.length() >= mvno_match_data_length && gid1.substring(0, mvno_match_data_length).equalsIgnoreCase(mvnoMatchData)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$isMeteredApnType(String type, Context context, int subId, boolean isRoaming) {
        HashMap<Integer, HashSet<String>> meteredApnTypesCache = isRoaming ? sMeteredApnTypes : sMeteredRoamingApnTypes;
        String carrierConfig = isRoaming ? "carrier_metered_roaming_apn_types_strings" : "carrier_metered_apn_types_strings";
        HashMap<Integer, HashSet<String>> hashMap = meteredApnTypesCache;
        synchronized (hashMap) {
            HashSet<String> meteredApnSet = meteredApnTypesCache.get(subId);
            if (meteredApnSet == null) {
                CarrierConfigManager configManager = (CarrierConfigManager)context.getSystemService("carrier_config");
                if (configManager == null) {
                    Rlog.e("ApnSetting", "Carrier config service is not available");
                    return true;
                }
                PersistableBundle b = configManager.getConfigForSubId(subId);
                if (b == null) {
                    Rlog.e("ApnSetting", "Can't get the config. subId = " + subId);
                    return true;
                }
                String[] meteredApnTypes = b.getStringArray(carrierConfig);
                if (meteredApnTypes == null) {
                    Rlog.e("ApnSetting", carrierConfig + " is not available. subId = " + subId);
                    return true;
                }
                meteredApnSet = new HashSet<String>(Arrays.asList(meteredApnTypes));
                meteredApnTypesCache.put(subId, meteredApnSet);
            }
            if (meteredApnSet.contains("*")) {
                return true;
            }
            if (meteredApnSet.contains(type)) {
                return true;
            }
            if (type.equals("*") && meteredApnSet.size() > 0) {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$isMetered(Context context, int subId, boolean isRoaming) {
        for (String type : this.types) {
            if (!ApnSetting.isMeteredApnType(type, context, subId, isRoaming)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$equals(Object o) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return this.carrier.equals(other.carrier) && this.id == other.id && this.numeric.equals(other.numeric) && this.apn.equals(other.apn) && this.proxy.equals(other.proxy) && this.mmsc.equals(other.mmsc) && this.mmsProxy.equals(other.mmsProxy) && this.port.equals(other.port) && this.authType == other.authType && Arrays.deepEquals(this.types, other.types) && this.protocol.equals(other.protocol) && this.roamingProtocol.equals(other.roamingProtocol) && this.carrierEnabled == other.carrierEnabled && this.bearer == other.bearer && this.bearerBitmask == other.bearerBitmask && this.profileId == other.profileId && this.modemCognitive == other.modemCognitive && this.maxConns == other.maxConns && this.waitTime == other.waitTime && this.maxConnsTime == other.maxConnsTime && this.mtu == other.mtu && this.mvnoType.equals(other.mvnoType) && this.mvnoMatchData.equals(other.mvnoMatchData);
    }

    static void __staticInitializer__() {
        sMeteredApnTypes = new HashMap();
        sMeteredRoamingApnTypes = new HashMap();
    }

    private void __constructor__(int n, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, int n2, String[] stringArray, String string12, String string13, boolean bl, int n3, int n4, int n5, boolean bl2, int n6, int n7, int n8, int n9, String string14, String string15) {
        this.$$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(n, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, n2, stringArray, string12, string13, bl, n3, n4, n5, bl2, n6, n7, n8, n9, string14, string15);
    }

    public ApnSetting(int n, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, int n2, String[] stringArray, String string12, String string13, boolean bl, int n3, int n4, int n5, boolean bl2, int n6, int n7, int n8, int n9, String string14, String string15) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(int java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String int java.lang.String[] java.lang.String java.lang.String boolean int int int boolean int int int int java.lang.String java.lang.String ), 0, this, n, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, n2, stringArray, string12, string13, bl, n3, n4, n5, bl2, n6, n7, n8, n9, string14, string15);
    }

    private void __constructor__(ApnSetting apnSetting) {
        this.$$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(apnSetting);
    }

    public ApnSetting(ApnSetting apnSetting) {
        this(apnSetting.id, apnSetting.numeric, apnSetting.carrier, apnSetting.apn, apnSetting.proxy, apnSetting.port, apnSetting.mmsc, apnSetting.mmsProxy, apnSetting.mmsPort, apnSetting.user, apnSetting.password, apnSetting.authType, apnSetting.types, apnSetting.protocol, apnSetting.roamingProtocol, apnSetting.carrierEnabled, apnSetting.bearer, apnSetting.bearerBitmask, apnSetting.profileId, apnSetting.modemCognitive, apnSetting.maxConns, apnSetting.waitTime, apnSetting.maxConnsTime, apnSetting.mtu, apnSetting.mvnoType, apnSetting.mvnoMatchData);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$__constructor__(com.android.internal.telephony.dataconnection.ApnSetting ), 0, this, apnSetting);
    }

    public static ApnSetting fromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fromString", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$fromString(java.lang.String ), 0, (String)string2);
    }

    public static List<ApnSetting> arrayFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("arrayFromString", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$arrayFromString(java.lang.String ), 0, (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$toString(), 0, this);
    }

    public boolean hasMvnoParams() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMvnoParams", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$hasMvnoParams(), 0, this);
    }

    public boolean canHandleType(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("canHandleType", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$canHandleType(java.lang.String ), 0, this, string2);
    }

    private static boolean imsiMatches(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("imsiMatches", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$imsiMatches(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static boolean mvnoMatches(IccRecords iccRecords, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("mvnoMatches", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$mvnoMatches(com.android.internal.telephony.uicc.IccRecords java.lang.String java.lang.String ), 0, (IccRecords)iccRecords, (String)string2, (String)string3);
    }

    public static boolean isMeteredApnType(String string2, Context context, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMeteredApnType", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$isMeteredApnType(java.lang.String android.content.Context int boolean ), 0, (String)string2, (Context)context, (int)n, (boolean)bl);
    }

    public boolean isMetered(Context context, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMetered", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$isMetered(android.content.Context int boolean ), 0, this, context, n, bl);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_dataconnection_ApnSetting$equals(java.lang.Object ), 0, this, object);
    }

    static {
        RobolectricInternals.classInitializing(ApnSetting.class);
    }

    public /* synthetic */ ApnSetting() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApnSetting)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

