/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.google.errorprone.annotations.DoNotMock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class CdmaMmiCode
extends Handler
implements MmiCode,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "CdmaMmiCode";
    static String ACTION_REGISTER = "**";
    static String SC_PIN = "04";
    static String SC_PIN2 = "042";
    static String SC_PUK = "05";
    static String SC_PUK2 = "052";
    static int EVENT_SET_COMPLETE = 1;
    GsmCdmaPhone mPhone;
    Context mContext;
    UiccCardApplication mUiccApplication;
    String mAction;
    String mSc;
    String mSia;
    String mSib;
    String mSic;
    String mPoundString;
    String mDialingNumber;
    String mPwd;
    MmiCode.State mState;
    CharSequence mMessage;
    static Pattern sPatternSuppService;
    static int MATCH_GROUP_POUND_STRING = 1;
    static int MATCH_GROUP_ACTION = 2;
    static int MATCH_GROUP_SERVICE_CODE = 3;
    static int MATCH_GROUP_SIA = 5;
    static int MATCH_GROUP_SIB = 7;
    static int MATCH_GROUP_SIC = 9;
    static int MATCH_GROUP_PWD_CONFIRM = 11;
    static int MATCH_GROUP_DIALING_NUMBER = 12;

    private static final CdmaMmiCode $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$newFromDialString(String dialString, GsmCdmaPhone phone, UiccCardApplication app) {
        CdmaMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new CdmaMmiCode(phone, app);
            ret.mPoundString = CdmaMmiCode.makeEmptyNull(m.group(1));
            ret.mAction = CdmaMmiCode.makeEmptyNull(m.group(2));
            ret.mSc = CdmaMmiCode.makeEmptyNull(m.group(3));
            ret.mSia = CdmaMmiCode.makeEmptyNull(m.group(5));
            ret.mSib = CdmaMmiCode.makeEmptyNull(m.group(7));
            ret.mSic = CdmaMmiCode.makeEmptyNull(m.group(9));
            ret.mPwd = CdmaMmiCode.makeEmptyNull(m.group(11));
            ret.mDialingNumber = CdmaMmiCode.makeEmptyNull(m.group(12));
        }
        return ret;
    }

    private static final String $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    private void $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$__constructor__(GsmCdmaPhone phone, UiccCardApplication app) {
        this.mState = MmiCode.State.PENDING;
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mUiccApplication = app;
    }

    private final MmiCode.State $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$getState() {
        return this.mState;
    }

    private final CharSequence $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$getMessage() {
        return this.mMessage;
    }

    private final Phone $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$getPhone() {
        return this.mPhone;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$cancel() {
        if (this.mState == MmiCode.State.COMPLETE || this.mState == MmiCode.State.FAILED) {
            return;
        }
        this.mState = MmiCode.State.CANCELLED;
        this.mPhone.onMMIDone(this);
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$isCancelable() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$isPinPukCommand() {
        return this.mSc != null && (this.mSc.equals("04") || this.mSc.equals("042") || this.mSc.equals("05") || this.mSc.equals("052"));
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$isRegister() {
        return this.mAction != null && this.mAction.equals("**");
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$isUssdRequest() {
        Rlog.w("CdmaMmiCode", "isUssdRequest is not implemented in CdmaMmiCode");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$processCode() {
        block11: {
            try {
                if (!this.isPinPukCommand()) break block11;
                String oldPinOrPuk = this.mSia;
                String newPinOrPuk = this.mSib;
                int pinLen = newPinOrPuk.length();
                if (this.isRegister()) {
                    if (!newPinOrPuk.equals(this.mSic)) {
                        this.handlePasswordError(17039526);
                        break block11;
                    }
                    if (pinLen < 4 || pinLen > 8) {
                        this.handlePasswordError(17039527);
                        break block11;
                    }
                    if (this.mSc.equals("04") && this.mUiccApplication != null && this.mUiccApplication.getState() == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
                        this.handlePasswordError(17039529);
                        break block11;
                    }
                    if (this.mUiccApplication != null) {
                        Rlog.d("CdmaMmiCode", "process mmi service code using UiccApp sc=" + this.mSc);
                        if (this.mSc.equals("04")) {
                            this.mUiccApplication.changeIccLockPassword(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                            break block11;
                        }
                        if (this.mSc.equals("042")) {
                            this.mUiccApplication.changeIccFdnPassword(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                            break block11;
                        }
                        if (this.mSc.equals("05")) {
                            this.mUiccApplication.supplyPuk(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                            break block11;
                        }
                        if (this.mSc.equals("052")) {
                            this.mUiccApplication.supplyPuk2(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                            break block11;
                        }
                        throw new RuntimeException("Unsupported service code=" + this.mSc);
                    }
                    throw new RuntimeException("No application mUiccApplicaiton is null");
                }
                throw new RuntimeException("Ivalid register/action=" + this.mAction);
            }
            catch (RuntimeException exc) {
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.mContext.getText(17039515);
                this.mPhone.onMMIDone(this);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$handlePasswordError(int res) {
        this.mState = MmiCode.State.FAILED;
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        sb.append(this.mContext.getText(res));
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$handleMessage(Message msg) {
        if (msg.what == 1) {
            AsyncResult ar = (AsyncResult)msg.obj;
            this.onSetComplete(msg, ar);
        } else {
            Rlog.e("CdmaMmiCode", "Unexpected reply");
        }
    }

    private final CharSequence $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$getScString() {
        if (this.mSc != null && this.isPinPukCommand()) {
            return this.mContext.getText(17039542);
        }
        return "";
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$onSetComplete(Message msg, AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException.Error err = ((CommandException)ar.exception).getCommandError();
                if (err == CommandException.Error.PASSWORD_INCORRECT) {
                    if (this.isPinPukCommand()) {
                        if (this.mSc.equals("05") || this.mSc.equals("052")) {
                            sb.append(this.mContext.getText(17039525));
                        } else {
                            sb.append(this.mContext.getText(17039524));
                        }
                        int attemptsRemaining = msg.arg1;
                        if (attemptsRemaining <= 0) {
                            Rlog.d("CdmaMmiCode", "onSetComplete: PUK locked, cancel as lock screen will handle this");
                            this.mState = MmiCode.State.CANCELLED;
                        } else if (attemptsRemaining > 0) {
                            Rlog.d("CdmaMmiCode", "onSetComplete: attemptsRemaining=" + attemptsRemaining);
                            sb.append(this.mContext.getResources().getQuantityString(0x1140000, attemptsRemaining, attemptsRemaining));
                        }
                    } else {
                        sb.append(this.mContext.getText(17039522));
                    }
                } else if (err == CommandException.Error.SIM_PUK2) {
                    sb.append(this.mContext.getText(17039524));
                    sb.append("\n");
                    sb.append(this.mContext.getText(17039530));
                } else if (err == CommandException.Error.REQUEST_NOT_SUPPORTED) {
                    if (this.mSc.equals("04")) {
                        sb.append(this.mContext.getText(17039531));
                    }
                } else {
                    sb.append(this.mContext.getText(17039515));
                }
            } else {
                sb.append(this.mContext.getText(17039515));
            }
        } else if (this.isRegister()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039520));
        } else {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.mContext.getText(17039515));
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    static void __staticInitializer__() {
        sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    }

    public static CdmaMmiCode newFromDialString(String string2, GsmCdmaPhone gsmCdmaPhone, UiccCardApplication uiccCardApplication) {
        return InvokeDynamicSupport.bootstrapStatic("newFromDialString", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$newFromDialString(java.lang.String com.android.internal.telephony.GsmCdmaPhone com.android.internal.telephony.uicc.UiccCardApplication ), 0, (String)string2, (GsmCdmaPhone)gsmCdmaPhone, (UiccCardApplication)uiccCardApplication);
    }

    private static String makeEmptyNull(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeEmptyNull", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$makeEmptyNull(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__(GsmCdmaPhone gsmCdmaPhone, UiccCardApplication uiccCardApplication) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$__constructor__(gsmCdmaPhone, uiccCardApplication);
    }

    CdmaMmiCode(GsmCdmaPhone gsmCdmaPhone, UiccCardApplication uiccCardApplication) {
        super(gsmCdmaPhone.getHandler().getLooper());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$__constructor__(com.android.internal.telephony.GsmCdmaPhone com.android.internal.telephony.uicc.UiccCardApplication ), 0, this, gsmCdmaPhone, uiccCardApplication);
    }

    @Override
    public MmiCode.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$getState(), 0, this);
    }

    @Override
    public CharSequence getMessage() {
        return InvokeDynamicSupport.bootstrap("getMessage", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$getMessage(), 0, this);
    }

    @Override
    public Phone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$getPhone(), 0, this);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$cancel(), 0, this);
    }

    @Override
    public boolean isCancelable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCancelable", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$isCancelable(), 0, this);
    }

    @Override
    public boolean isPinPukCommand() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPinPukCommand", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$isPinPukCommand(), 0, this);
    }

    boolean isRegister() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRegister", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$isRegister(), 0, this);
    }

    @Override
    public boolean isUssdRequest() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUssdRequest", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$isUssdRequest(), 0, this);
    }

    @Override
    public void processCode() {
        InvokeDynamicSupport.bootstrap("processCode", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$processCode(), 0, this);
    }

    private void handlePasswordError(int n) {
        InvokeDynamicSupport.bootstrap("handlePasswordError", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$handlePasswordError(int ), 0, this, n);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$handleMessage(android.os.Message ), 0, this, message);
    }

    private CharSequence getScString() {
        return InvokeDynamicSupport.bootstrap("getScString", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$getScString(), 0, this);
    }

    private void onSetComplete(Message message, AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("onSetComplete", $$robo$$com_android_internal_telephony_cdma_CdmaMmiCode$onSetComplete(android.os.Message android.os.AsyncResult ), 0, this, message, asyncResult);
    }

    static {
        RobolectricInternals.classInitializing(CdmaMmiCode.class);
    }

    public /* synthetic */ CdmaMmiCode() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaMmiCode)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

