/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.BroadcastOptions;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.SubscriptionManager;
import android.util.Log;
import com.android.internal.telephony.BlockChecker;
import com.android.internal.telephony.IWapPushManager;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.WspTypeDecoder;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.PduParser;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.ReadOrigInd;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WapPushOverSms
implements ServiceConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WAP PUSH";
    private static boolean DBG = false;
    private Context mContext;
    private IDeviceIdleController mDeviceIdleController;
    private String mWapPushManagerPackage;
    private volatile IWapPushManager mWapPushManager;
    private static String THREAD_ID_SELECTION = "m_id=? AND m_type=?";
    private static String LOCATION_SELECTION = "m_type=? AND ct_l =?";

    private final void $$robo$$com_android_internal_telephony_WapPushOverSms$onServiceConnected(ComponentName name, IBinder service) {
        this.mWapPushManager = IWapPushManager.Stub.asInterface(service);
    }

    private final void $$robo$$com_android_internal_telephony_WapPushOverSms$onServiceDisconnected(ComponentName name) {
        this.mWapPushManager = null;
    }

    private void $$robo$$com_android_internal_telephony_WapPushOverSms$__constructor__(Context context) {
        this.mContext = context;
        this.mDeviceIdleController = TelephonyComponentFactory.getInstance().getIDeviceIdleController();
        Intent intent = new Intent(IWapPushManager.class.getName());
        ComponentName comp = intent.resolveSystemService(context.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !context.bindService(intent, this, 1)) {
            Rlog.e("WAP PUSH", "bindService() for wappush manager failed");
        } else {
            this.mWapPushManagerPackage = comp.getPackageName();
        }
    }

    private final void $$robo$$com_android_internal_telephony_WapPushOverSms$dispose() {
        if (this.mWapPushManager != null) {
            this.mContext.unbindService(this);
        } else {
            Rlog.e("WAP PUSH", "dispose: not bound to a wappush manager");
        }
    }

    private final DecodedResult $$robo$$com_android_internal_telephony_WapPushOverSms$decodeWapPdu(byte[] pdu, InboundSmsHandler handler) {
        DecodedResult result = new DecodedResult(this);
        try {
            NotificationInd nInd;
            byte[] intentData;
            WspTypeDecoder pduDecoder;
            int index = 0;
            int transactionId = pdu[index++] & 0xFF;
            int pduType = pdu[index++] & 0xFF;
            int phoneId = handler.getPhone().getPhoneId();
            if (pduType != 6 && pduType != 7) {
                index = this.mContext.getResources().getInteger(17694860);
                if (index != -1) {
                    transactionId = pdu[index++] & 0xFF;
                    if ((pduType = pdu[index++] & 0xFF) != 6 && pduType != 7) {
                        result.statusCode = 1;
                        return result;
                    }
                } else {
                    result.statusCode = 1;
                    return result;
                }
            }
            if (!(pduDecoder = TelephonyComponentFactory.getInstance().makeWspTypeDecoder(pdu)).decodeUintvarInteger(index)) {
                result.statusCode = 2;
                return result;
            }
            int headerLength = (int)pduDecoder.getValue32();
            int headerStartIndex = index += pduDecoder.getDecodedDataLength();
            if (!pduDecoder.decodeContentType(index)) {
                result.statusCode = 2;
                return result;
            }
            String mimeType = pduDecoder.getValueString();
            long binaryContentType = pduDecoder.getValue32();
            index += pduDecoder.getDecodedDataLength();
            byte[] header = new byte[headerLength];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])pdu, (int)headerStartIndex, (byte[])header, (int)0, (int)header.length);
            if (mimeType != null && mimeType.equals("application/vnd.wap.coc")) {
                intentData = pdu;
            } else {
                int dataIndex = headerStartIndex + headerLength;
                intentData = new byte[pdu.length - dataIndex];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])pdu, (int)dataIndex, (byte[])intentData, (int)0, (int)intentData.length);
            }
            int[] subIds = SubscriptionManager.getSubId(phoneId);
            int subId = subIds != null && subIds.length > 0 ? subIds[0] : SmsManager.getDefaultSmsSubscriptionId();
            GenericPdu parsedPdu = null;
            try {
                parsedPdu = new PduParser(intentData, WapPushOverSms.shouldParseContentDisposition(subId)).parse();
            }
            catch (Exception e) {
                Rlog.e("WAP PUSH", "Unable to parse PDU: " + e.toString());
            }
            if (parsedPdu != null && parsedPdu.getMessageType() == 130 && (nInd = (NotificationInd)parsedPdu).getFrom() != null && BlockChecker.isBlocked(this.mContext, nInd.getFrom().getString())) {
                result.statusCode = 1;
                return result;
            }
            if (pduDecoder.seekXWapApplicationId(index, index + headerLength - 1)) {
                String contentType;
                index = (int)pduDecoder.getValue32();
                pduDecoder.decodeXWapApplicationId(index);
                String wapAppId = pduDecoder.getValueString();
                if (wapAppId == null) {
                    wapAppId = Integer.toString((int)pduDecoder.getValue32());
                }
                result.wapAppId = wapAppId;
                result.contentType = contentType = mimeType == null ? Long.toString(binaryContentType) : mimeType;
            }
            result.subId = subId;
            result.phoneId = phoneId;
            result.parsedPdu = parsedPdu;
            result.mimeType = mimeType;
            result.transactionId = transactionId;
            result.pduType = pduType;
            result.header = header;
            result.intentData = intentData;
            result.contentTypeParameters = pduDecoder.getContentParameters();
            result.statusCode = -1;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            Rlog.e("WAP PUSH", "ignoring dispatchWapPdu() array index exception: " + aie);
            result.statusCode = 2;
        }
        return result;
    }

    private final int $$robo$$com_android_internal_telephony_WapPushOverSms$dispatchWapPdu(byte[] pdu, BroadcastReceiver receiver, InboundSmsHandler handler) {
        DecodedResult result = this.decodeWapPdu(pdu, handler);
        if (result.statusCode != -1) {
            return result.statusCode;
        }
        if (SmsManager.getDefault().getAutoPersisting()) {
            this.writeInboxMessage(result.subId, result.parsedPdu);
        }
        if (result.wapAppId != null) {
            try {
                boolean processFurther = true;
                IWapPushManager wapPushMan = this.mWapPushManager;
                if (wapPushMan != null) {
                    this.mDeviceIdleController.addPowerSaveTempWhitelistAppForMms(this.mWapPushManagerPackage, 0, "mms-mgr");
                    Intent intent = new Intent();
                    intent.putExtra("transactionId", result.transactionId);
                    intent.putExtra("pduType", result.pduType);
                    intent.putExtra("header", result.header);
                    intent.putExtra("data", result.intentData);
                    intent.putExtra("contentTypeParameters", result.contentTypeParameters);
                    SubscriptionManager.putPhoneIdAndSubIdExtra(intent, result.phoneId);
                    int procRet = wapPushMan.processMessage(result.wapAppId, result.contentType, intent);
                    if ((procRet & 1) > 0 && (procRet & 0x8000) == 0) {
                        processFurther = false;
                    }
                }
                if (!processFurther) {
                    return 1;
                }
            }
            catch (RemoteException processFurther) {
                // empty catch block
            }
        }
        if (result.mimeType == null) {
            return 2;
        }
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
        intent.setType(result.mimeType);
        intent.putExtra("transactionId", result.transactionId);
        intent.putExtra("pduType", result.pduType);
        intent.putExtra("header", result.header);
        intent.putExtra("data", result.intentData);
        intent.putExtra("contentTypeParameters", result.contentTypeParameters);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, result.phoneId);
        ComponentName componentName = SmsApplication.getDefaultMmsApplication(this.mContext, true);
        Bundle options = null;
        if (componentName != null) {
            intent.setComponent(componentName);
            try {
                long duration = this.mDeviceIdleController.addPowerSaveTempWhitelistAppForMms(componentName.getPackageName(), 0, "mms-app");
                BroadcastOptions bopts = BroadcastOptions.makeBasic();
                bopts.setTemporaryAppWhitelistDuration(duration);
                options = bopts.toBundle();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        handler.dispatchIntent(intent, WapPushOverSms.getPermissionForType(result.mimeType), WapPushOverSms.getAppOpsPermissionForIntent(result.mimeType), options, receiver, UserHandle.SYSTEM);
        return -1;
    }

    private final boolean $$robo$$com_android_internal_telephony_WapPushOverSms$isWapPushForMms(byte[] pdu, InboundSmsHandler handler) {
        DecodedResult result = this.decodeWapPdu(pdu, handler);
        return result.statusCode == -1 && "application/vnd.wap.mms-message".equals(result.mimeType);
    }

    private static final boolean $$robo$$com_android_internal_telephony_WapPushOverSms$shouldParseContentDisposition(int subId) {
        return SmsManager.getSmsManagerForSubscriptionId(subId).getCarrierConfigValues().getBoolean("supportMmsContentDisposition", true);
    }

    private final void $$robo$$com_android_internal_telephony_WapPushOverSms$writeInboxMessage(int subId, GenericPdu pdu) {
        if (pdu == null) {
            Rlog.e("WAP PUSH", "Invalid PUSH PDU");
        }
        PduPersister persister = PduPersister.getPduPersister(this.mContext);
        int type = pdu.getMessageType();
        try {
            switch (type) {
                case 134: 
                case 136: {
                    long threadId = WapPushOverSms.getDeliveryOrReadReportThreadId(this.mContext, pdu);
                    if (threadId == -1L) {
                        Rlog.e("WAP PUSH", "Failed to find delivery or read report's thread id");
                        break;
                    }
                    Uri uri = persister.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, true, true, null);
                    if (uri == null) {
                        Rlog.e("WAP PUSH", "Failed to persist delivery or read report");
                        break;
                    }
                    ContentValues values = new ContentValues(1);
                    values.put("thread_id", threadId);
                    if (SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), uri, values, null, null) != 1) {
                        Rlog.e("WAP PUSH", "Failed to update delivery or read report thread id");
                    }
                    break;
                }
                case 130: {
                    byte[] contentLocation;
                    NotificationInd nInd = (NotificationInd)pdu;
                    Bundle configs = SmsManager.getSmsManagerForSubscriptionId(subId).getCarrierConfigValues();
                    if (configs != null && configs.getBoolean("enabledTransID", false) && 61 == (contentLocation = nInd.getContentLocation())[contentLocation.length - 1]) {
                        byte[] transactionId = nInd.getTransactionId();
                        byte[] contentLocationWithId = new byte[contentLocation.length + transactionId.length];
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])contentLocation, (int)0, (byte[])contentLocationWithId, (int)0, (int)contentLocation.length);
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])transactionId, (int)0, (byte[])contentLocationWithId, (int)contentLocation.length, (int)transactionId.length);
                        nInd.setContentLocation(contentLocationWithId);
                    }
                    if (!WapPushOverSms.isDuplicateNotification(this.mContext, nInd)) {
                        Uri uri = persister.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, true, true, null);
                        if (uri == null) {
                            Rlog.e("WAP PUSH", "Failed to save MMS WAP push notification ind");
                        }
                        break;
                    }
                    Rlog.d("WAP PUSH", "Skip storing duplicate MMS WAP push notification ind: " + new String(nInd.getContentLocation()));
                    break;
                }
                default: {
                    Log.e("WAP PUSH", "Received unrecognized WAP Push PDU.");
                }
            }
        }
        catch (MmsException e) {
            Log.e("WAP PUSH", "Failed to save MMS WAP push data: type=" + type, e);
        }
        catch (RuntimeException e) {
            Log.e("WAP PUSH", "Unexpected RuntimeException in persisting MMS WAP push data", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long $$robo$$com_android_internal_telephony_WapPushOverSms$getDeliveryOrReadReportThreadId(Context context, GenericPdu pdu) {
        String messageId;
        if (pdu instanceof DeliveryInd) {
            messageId = new String(((DeliveryInd)pdu).getMessageId());
        } else if (pdu instanceof ReadOrigInd) {
            messageId = new String(((ReadOrigInd)pdu).getMessageId());
        } else {
            Rlog.e("WAP PUSH", "WAP Push data is neither delivery or read report type: " + pdu.getClass().getCanonicalName());
            return -1L;
        }
        try (Cursor cursor = null;){
            cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"thread_id"}, "m_id=? AND m_type=?", new String[]{DatabaseUtils.sqlEscapeString(messageId), Integer.toString(128)}, null);
            if (cursor != null && cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$com_android_internal_telephony_WapPushOverSms$isDuplicateNotification(Context context, NotificationInd nInd) {
        byte[] rawLocation = nInd.getContentLocation();
        if (rawLocation != null) {
            String location = new String(rawLocation);
            String[] selectionArgs = new String[]{location};
            try (Cursor cursor = null;){
                cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"_id"}, "m_type=? AND ct_l =?", new String[]{Integer.toString(130), new String(rawLocation)}, null);
                if (cursor != null && cursor.getCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private static final String $$robo$$com_android_internal_telephony_WapPushOverSms$getPermissionForType(String mimeType) {
        String permission2 = "application/vnd.wap.mms-message".equals(mimeType) ? "android.permission.RECEIVE_MMS" : "android.permission.RECEIVE_WAP_PUSH";
        return permission2;
    }

    private static final int $$robo$$com_android_internal_telephony_WapPushOverSms$getAppOpsPermissionForIntent(String mimeType) {
        int appOp = "application/vnd.wap.mms-message".equals(mimeType) ? 18 : 19;
        return appOp;
    }

    @Override
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_WapPushOverSms$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
    }

    @Override
    public void onServiceDisconnected(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_WapPushOverSms$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_WapPushOverSms$__constructor__(context);
    }

    public WapPushOverSms(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_WapPushOverSms$__constructor__(android.content.Context ), 0, this, context);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_WapPushOverSms$dispose(), 0, this);
    }

    private DecodedResult decodeWapPdu(byte[] byArray, InboundSmsHandler inboundSmsHandler) {
        return InvokeDynamicSupport.bootstrap("decodeWapPdu", $$robo$$com_android_internal_telephony_WapPushOverSms$decodeWapPdu(byte[] com.android.internal.telephony.InboundSmsHandler ), 0, this, byArray, inboundSmsHandler);
    }

    public int dispatchWapPdu(byte[] byArray, BroadcastReceiver broadcastReceiver, InboundSmsHandler inboundSmsHandler) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchWapPdu", $$robo$$com_android_internal_telephony_WapPushOverSms$dispatchWapPdu(byte[] android.content.BroadcastReceiver com.android.internal.telephony.InboundSmsHandler ), 0, this, byArray, broadcastReceiver, inboundSmsHandler);
    }

    public boolean isWapPushForMms(byte[] byArray, InboundSmsHandler inboundSmsHandler) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWapPushForMms", $$robo$$com_android_internal_telephony_WapPushOverSms$isWapPushForMms(byte[] com.android.internal.telephony.InboundSmsHandler ), 0, this, byArray, inboundSmsHandler);
    }

    private static boolean shouldParseContentDisposition(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldParseContentDisposition", $$robo$$com_android_internal_telephony_WapPushOverSms$shouldParseContentDisposition(int ), 0, (int)n);
    }

    private void writeInboxMessage(int n, GenericPdu genericPdu) {
        InvokeDynamicSupport.bootstrap("writeInboxMessage", $$robo$$com_android_internal_telephony_WapPushOverSms$writeInboxMessage(int com.google.android.mms.pdu.GenericPdu ), 0, this, n, genericPdu);
    }

    private static long getDeliveryOrReadReportThreadId(Context context, GenericPdu genericPdu) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDeliveryOrReadReportThreadId", $$robo$$com_android_internal_telephony_WapPushOverSms$getDeliveryOrReadReportThreadId(android.content.Context com.google.android.mms.pdu.GenericPdu ), 0, (Context)context, (GenericPdu)genericPdu);
    }

    private static boolean isDuplicateNotification(Context context, NotificationInd notificationInd) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDuplicateNotification", $$robo$$com_android_internal_telephony_WapPushOverSms$isDuplicateNotification(android.content.Context com.google.android.mms.pdu.NotificationInd ), 0, (Context)context, (NotificationInd)notificationInd);
    }

    public static String getPermissionForType(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getPermissionForType", $$robo$$com_android_internal_telephony_WapPushOverSms$getPermissionForType(java.lang.String ), 0, (String)string2);
    }

    public static int getAppOpsPermissionForIntent(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAppOpsPermissionForIntent", $$robo$$com_android_internal_telephony_WapPushOverSms$getAppOpsPermissionForIntent(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ WapPushOverSms() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WapPushOverSms)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class DecodedResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mimeType;
        String contentType;
        int transactionId;
        int pduType;
        int phoneId;
        int subId;
        byte[] header;
        String wapAppId;
        byte[] intentData;
        HashMap<String, String> contentTypeParameters;
        GenericPdu parsedPdu;
        int statusCode;
        /* synthetic */ WapPushOverSms this$0;

        private void $$robo$$com_android_internal_telephony_WapPushOverSms_DecodedResult$__constructor__(WapPushOverSms wapPushOverSms) {
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_WapPushOverSms_DecodedResult$__constructor__(WapPushOverSms x0, 1 x1) {
        }

        private void __constructor__(WapPushOverSms wapPushOverSms) {
            this.$$robo$$com_android_internal_telephony_WapPushOverSms_DecodedResult$__constructor__(wapPushOverSms);
        }

        private DecodedResult(WapPushOverSms wapPushOverSms) {
            this.this$0 = wapPushOverSms;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_WapPushOverSms_DecodedResult$__constructor__(com.android.internal.telephony.WapPushOverSms ), 0, this, wapPushOverSms);
        }

        private /* synthetic */ void __constructor__(WapPushOverSms wapPushOverSms, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_WapPushOverSms_DecodedResult$__constructor__(wapPushOverSms, var2_2);
        }

        public /* synthetic */ DecodedResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecodedResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

