/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.CellInfo;
import android.telephony.ModemActivityInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.RadioAccessFamily;
import android.telephony.Rlog;
import android.telephony.SignalStrength;
import android.telephony.SmsMessage;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseArray;
import android.view.Display;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.HardwareConfig;
import com.android.internal.telephony.LastCallFailCause;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.TelephonyEventLog;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaInformationRecords;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.dataconnection.DataProfile;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SsData;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class RIL
extends BaseCommands
implements CommandsInterface,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String RILJ_LOG_TAG = "RILJ";
    static String RILJ_ACK_WAKELOCK_NAME = "RILJ_ACK_WL";
    static boolean RILJ_LOGD = true;
    static boolean RILJ_LOGV = false;
    static int RADIO_SCREEN_UNSET = -1;
    static int RADIO_SCREEN_OFF = 0;
    static int RADIO_SCREEN_ON = 1;
    private static int DEFAULT_WAKE_LOCK_TIMEOUT_MS = 60000;
    private static int DEFAULT_ACK_WAKE_LOCK_TIMEOUT_MS = 200;
    private static int DEFAULT_BLOCKING_MESSAGE_RESPONSE_TIMEOUT_MS = 2000;
    public static int INVALID_WAKELOCK = -1;
    public static int FOR_WAKELOCK = 0;
    public static int FOR_ACK_WAKELOCK = 1;
    LocalSocket mSocket;
    HandlerThread mSenderThread;
    RILSender mSender;
    Thread mReceiverThread;
    RILReceiver mReceiver;
    Display mDefaultDisplay;
    int mDefaultDisplayState;
    int mRadioScreenState;
    boolean mIsDevicePlugged;
    PowerManager.WakeLock mWakeLock;
    PowerManager.WakeLock mAckWakeLock;
    int mWakeLockTimeout;
    int mAckWakeLockTimeout;
    int mWakeLockCount;
    volatile int mWlSequenceNum;
    volatile int mAckWlSequenceNum;
    SparseArray<RILRequest> mRequestList;
    Object[] mLastNITZTimeInfo;
    AtomicBoolean mTestingEmergencyCall;
    private Integer mInstanceId;
    private TelephonyEventLog mEventLog;
    static int EVENT_SEND = 1;
    static int EVENT_WAKE_LOCK_TIMEOUT = 2;
    static int EVENT_SEND_ACK = 3;
    static int EVENT_ACK_WAKE_LOCK_TIMEOUT = 4;
    static int EVENT_BLOCKING_RESPONSE_TIMEOUT = 5;
    static int RIL_MAX_COMMAND_BYTES = 8192;
    static int RESPONSE_SOLICITED = 0;
    static int RESPONSE_UNSOLICITED = 1;
    static int RESPONSE_SOLICITED_ACK = 2;
    static int RESPONSE_SOLICITED_ACK_EXP = 3;
    static int RESPONSE_UNSOLICITED_ACK_EXP = 4;
    static String[] SOCKET_NAME_RIL;
    static int SOCKET_OPEN_RETRY_MILLIS = 4000;
    private static int CDMA_BSI_NO_OF_INTS_STRUCT = 3;
    private static int CDMA_BROADCAST_SMS_NO_OF_SERVICE_CATEGORIES = 31;
    private DisplayManager.DisplayListener mDisplayListener;
    private BroadcastReceiver mBatteryStateListener;

    private static final Object $$robo$$com_android_internal_telephony_RIL$getResponseForTimedOutRILRequest(RILRequest rr) {
        if (rr == null) {
            return null;
        }
        ModemActivityInfo timeoutResponse = null;
        switch (rr.mRequest) {
            case 135: {
                timeoutResponse = new ModemActivityInfo(0L, 0, 0, new int[5], 0, 0);
            }
        }
        return timeoutResponse;
    }

    private static final int $$robo$$com_android_internal_telephony_RIL$readRilMessage(InputStream is, byte[] buffer) throws IOException {
        int countRead;
        int offset = 0;
        int remaining = 4;
        do {
            if ((countRead = is.read(buffer, offset, remaining)) < 0) {
                Rlog.e("RILJ", "Hit EOS reading message length");
                return -1;
            }
            offset += countRead;
        } while ((remaining -= countRead) > 0);
        int messageLength = (buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        offset = 0;
        remaining = messageLength;
        do {
            if ((countRead = is.read(buffer, offset, remaining)) < 0) {
                Rlog.e("RILJ", "Hit EOS reading message.  messageLength=" + messageLength + " remaining=" + remaining);
                return -1;
            }
            offset += countRead;
        } while ((remaining -= countRead) > 0);
        return messageLength;
    }

    private void $$robo$$com_android_internal_telephony_RIL$__constructor__(Context context, int preferredNetworkType, int cdmaSubscription) {
    }

    private void $$robo$$com_android_internal_telephony_RIL$__constructor__(Context context, int preferredNetworkType, int cdmaSubscription, Integer instanceId) {
        this.mDefaultDisplayState = 0;
        this.mRadioScreenState = -1;
        this.mIsDevicePlugged = false;
        this.mWlSequenceNum = 0;
        this.mAckWlSequenceNum = 0;
        this.mRequestList = new SparseArray();
        this.mTestingEmergencyCall = new AtomicBoolean(false);
        this.mDisplayListener = new DisplayManager.DisplayListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RIL this$0;

            private void $$robo$$com_android_internal_telephony_RIL_1$__constructor__(RIL this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_RIL_1$onDisplayAdded(int displayId) {
            }

            private final void $$robo$$com_android_internal_telephony_RIL_1$onDisplayRemoved(int displayId) {
            }

            private final void $$robo$$com_android_internal_telephony_RIL_1$onDisplayChanged(int displayId) {
                if (displayId == 0) {
                    int oldState = this.this$0.mDefaultDisplayState;
                    this.this$0.mDefaultDisplayState = this.this$0.mDefaultDisplay.getState();
                    if (this.this$0.mDefaultDisplayState != oldState) {
                        this.this$0.updateScreenState();
                    }
                }
            }

            private void __constructor__(RIL rIL) {
                this.$$robo$$com_android_internal_telephony_RIL_1$__constructor__(rIL);
            }
            {
                this.this$0 = rIL;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL_1$__constructor__(com.android.internal.telephony.RIL ), 0, this, rIL);
            }

            @Override
            public void onDisplayAdded(int n) {
                InvokeDynamicSupport.bootstrap("onDisplayAdded", $$robo$$com_android_internal_telephony_RIL_1$onDisplayAdded(int ), 0, this, n);
            }

            @Override
            public void onDisplayRemoved(int n) {
                InvokeDynamicSupport.bootstrap("onDisplayRemoved", $$robo$$com_android_internal_telephony_RIL_1$onDisplayRemoved(int ), 0, this, n);
            }

            @Override
            public void onDisplayChanged(int n) {
                InvokeDynamicSupport.bootstrap("onDisplayChanged", $$robo$$com_android_internal_telephony_RIL_1$onDisplayChanged(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mBatteryStateListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RIL this$0;

            private void $$robo$$com_android_internal_telephony_RIL_2$__constructor__(RIL this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_RIL_2$onReceive(Context context, Intent intent) {
                boolean oldState = this.this$0.mIsDevicePlugged;
                boolean bl = this.this$0.mIsDevicePlugged = intent.getIntExtra("plugged", 0) != 0;
                if (this.this$0.mIsDevicePlugged != oldState) {
                    this.this$0.updateScreenState();
                }
            }

            private void __constructor__(RIL rIL) {
                this.$$robo$$com_android_internal_telephony_RIL_2$__constructor__(rIL);
            }
            {
                this.this$0 = rIL;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL_2$__constructor__(com.android.internal.telephony.RIL ), 0, this, rIL);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_RIL_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.riljLog("RIL(context, preferredNetworkType=" + preferredNetworkType + " cdmaSubscription=" + cdmaSubscription + ")");
        this.mContext = context;
        this.mCdmaSubscription = cdmaSubscription;
        this.mPreferredNetworkType = preferredNetworkType;
        this.mPhoneType = 0;
        this.mInstanceId = instanceId;
        this.mEventLog = new TelephonyEventLog(this.mInstanceId);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "RILJ");
        this.mWakeLock.setReferenceCounted(false);
        this.mAckWakeLock = pm.newWakeLock(1, "RILJ_ACK_WL");
        this.mAckWakeLock.setReferenceCounted(false);
        this.mWakeLockTimeout = SystemProperties.getInt("ro.ril.wake_lock_timeout", 60000);
        this.mAckWakeLockTimeout = SystemProperties.getInt("ro.ril.wake_lock_timeout", 200);
        this.mWakeLockCount = 0;
        this.mSenderThread = new HandlerThread("RILSender" + this.mInstanceId);
        this.mSenderThread.start();
        Looper looper = this.mSenderThread.getLooper();
        this.mSender = new RILSender(this, looper);
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (!cm.isNetworkSupported(0)) {
            this.riljLog("Not starting RILReceiver: wifi-only");
        } else {
            this.riljLog("Starting RILReceiver" + this.mInstanceId);
            this.mReceiver = new RILReceiver(this);
            this.mReceiverThread = new Thread((Runnable)this.mReceiver, "RILReceiver" + this.mInstanceId);
            this.mReceiverThread.start();
            DisplayManager dm = (DisplayManager)context.getSystemService("display");
            this.mDefaultDisplay = dm.getDisplay(0);
            dm.registerDisplayListener(this.mDisplayListener, null);
            this.mDefaultDisplayState = this.mDefaultDisplay.getState();
            IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = context.registerReceiver(this.mBatteryStateListener, filter);
            if (batteryStatus != null) {
                this.mIsDevicePlugged = batteryStatus.getIntExtra("plugged", 0) != 0;
            }
        }
        TelephonyDevController tdc = TelephonyDevController.getInstance();
        TelephonyDevController.registerRIL(this);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getVoiceRadioTechnology(Message result) {
        RILRequest rr = RILRequest.obtain(108, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getImsRegistrationState(Message result) {
        RILRequest rr = RILRequest.obtain(112, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setOnNITZTime(Handler h, int what, Object obj) {
        super.setOnNITZTime(h, what, obj);
        if (this.mLastNITZTimeInfo != null) {
            this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, this.mLastNITZTimeInfo, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIccCardStatus(Message result) {
        RILRequest rr = RILRequest.obtain(1, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setUiccSubscription(int slotId, int appIndex, int subId, int subStatus, Message result) {
        RILRequest rr = RILRequest.obtain(122, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " slot: " + slotId + " appIndex: " + appIndex + " subId: " + subId + " subStatus: " + subStatus);
        rr.mParcel.writeInt(slotId);
        rr.mParcel.writeInt(appIndex);
        rr.mParcel.writeInt(subId);
        rr.mParcel.writeInt(subStatus);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setDataAllowed(boolean allowed, Message result) {
        RILRequest rr = RILRequest.obtain(123, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " allowed: " + allowed);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(allowed ? 1 : 0);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPin(String pin, Message result) {
        this.supplyIccPinForApp(pin, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPinForApp(String pin, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(2, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(pin);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPuk(String puk, String newPin, Message result) {
        this.supplyIccPukForApp(puk, newPin, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPukForApp(String puk, String newPin, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(3, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(puk);
        rr.mParcel.writeString(newPin);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPin2(String pin, Message result) {
        this.supplyIccPin2ForApp(pin, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPin2ForApp(String pin, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(4, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(pin);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPuk2(String puk2, String newPin2, Message result) {
        this.supplyIccPuk2ForApp(puk2, newPin2, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyIccPuk2ForApp(String puk, String newPin2, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(5, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(puk);
        rr.mParcel.writeString(newPin2);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeIccPin(String oldPin, String newPin, Message result) {
        this.changeIccPinForApp(oldPin, newPin, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeIccPinForApp(String oldPin, String newPin, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(6, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(oldPin);
        rr.mParcel.writeString(newPin);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeIccPin2(String oldPin2, String newPin2, Message result) {
        this.changeIccPin2ForApp(oldPin2, newPin2, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeIccPin2ForApp(String oldPin2, String newPin2, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(7, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(oldPin2);
        rr.mParcel.writeString(newPin2);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$changeBarringPassword(String facility, String oldPwd, String newPwd, Message result) {
        RILRequest rr = RILRequest.obtain(44, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(facility);
        rr.mParcel.writeString(oldPwd);
        rr.mParcel.writeString(newPwd);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$supplyNetworkDepersonalization(String netpin, Message result) {
        RILRequest rr = RILRequest.obtain(8, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(1);
        rr.mParcel.writeString(netpin);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCurrentCalls(Message result) {
        RILRequest rr = RILRequest.obtain(9, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_RIL$getPDPContextList(Message result) {
        this.getDataCallList(result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getDataCallList(Message result) {
        RILRequest rr = RILRequest.obtain(57, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$dial(String address, int clirMode, Message result) {
        this.dial(address, clirMode, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$dial(String address, int clirMode, UUSInfo uusInfo, Message result) {
        RILRequest rr = RILRequest.obtain(10, result);
        rr.mParcel.writeString(address);
        rr.mParcel.writeInt(clirMode);
        if (uusInfo == null) {
            rr.mParcel.writeInt(0);
        } else {
            rr.mParcel.writeInt(1);
            rr.mParcel.writeInt(uusInfo.getType());
            rr.mParcel.writeInt(uusInfo.getDcs());
            rr.mParcel.writeByteArray(uusInfo.getUserData());
        }
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilDial(rr.mSerial, clirMode, uusInfo);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIMSI(Message result) {
        this.getIMSIForApp(null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIMSIForApp(String aid, Message result) {
        RILRequest rr = RILRequest.obtain(11, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeString(aid);
        this.riljLog(rr.serialString() + "> getIMSI: " + RIL.requestToString(rr.mRequest) + " aid: " + aid);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIMEI(Message result) {
        RILRequest rr = RILRequest.obtain(38, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getIMEISV(Message result) {
        RILRequest rr = RILRequest.obtain(39, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$hangupConnection(int gsmIndex, Message result) {
        this.riljLog("hangupConnection: gsmIndex=" + gsmIndex);
        RILRequest rr = RILRequest.obtain(12, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + gsmIndex);
        this.mEventLog.writeRilHangup(rr.mSerial, 12, gsmIndex);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(gsmIndex);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$hangupWaitingOrBackground(Message result) {
        RILRequest rr = RILRequest.obtain(13, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilHangup(rr.mSerial, 13, -1);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$hangupForegroundResumeBackground(Message result) {
        RILRequest rr = RILRequest.obtain(14, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilHangup(rr.mSerial, 14, -1);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$switchWaitingOrHoldingAndActive(Message result) {
        RILRequest rr = RILRequest.obtain(15, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$conference(Message result) {
        RILRequest rr = RILRequest.obtain(16, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setPreferredVoicePrivacy(boolean enable, Message result) {
        RILRequest rr = RILRequest.obtain(82, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(enable ? 1 : 0);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getPreferredVoicePrivacy(Message result) {
        RILRequest rr = RILRequest.obtain(83, result);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$separateConnection(int gsmIndex, Message result) {
        RILRequest rr = RILRequest.obtain(52, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + gsmIndex);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(gsmIndex);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$acceptCall(Message result) {
        RILRequest rr = RILRequest.obtain(40, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilAnswer(rr.mSerial);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$rejectCall(Message result) {
        RILRequest rr = RILRequest.obtain(17, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$explicitCallTransfer(Message result) {
        RILRequest rr = RILRequest.obtain(72, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getLastCallFailCause(Message result) {
        RILRequest rr = RILRequest.obtain(18, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_RIL$getLastPdpFailCause(Message result) {
        this.getLastDataCallFailCause(result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getLastDataCallFailCause(Message result) {
        RILRequest rr = RILRequest.obtain(56, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setMute(boolean enableMute, Message response) {
        RILRequest rr = RILRequest.obtain(53, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + enableMute);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(enableMute ? 1 : 0);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getMute(Message response) {
        RILRequest rr = RILRequest.obtain(54, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getSignalStrength(Message result) {
        RILRequest rr = RILRequest.obtain(19, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getVoiceRegistrationState(Message result) {
        RILRequest rr = RILRequest.obtain(20, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getDataRegistrationState(Message result) {
        RILRequest rr = RILRequest.obtain(21, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getOperator(Message result) {
        RILRequest rr = RILRequest.obtain(22, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getHardwareConfig(Message result) {
        RILRequest rr = RILRequest.obtain(124, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendDtmf(char c, Message result) {
        RILRequest rr = RILRequest.obtain(24, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeString(Character.toString(c));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$startDtmf(char c, Message result) {
        RILRequest rr = RILRequest.obtain(49, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeString(Character.toString(c));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$stopDtmf(Message result) {
        RILRequest rr = RILRequest.obtain(50, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendBurstDtmf(String dtmfString, int on, int off, Message result) {
        RILRequest rr = RILRequest.obtain(85, result);
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(dtmfString);
        rr.mParcel.writeString(Integer.toString(on));
        rr.mParcel.writeString(Integer.toString(off));
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + dtmfString);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$constructGsmSendSmsRilRequest(RILRequest rr, String smscPDU, String pdu) {
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(smscPDU);
        rr.mParcel.writeString(pdu);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendSMS(String smscPDU, String pdu, Message result) {
        RILRequest rr = RILRequest.obtain(25, result);
        this.constructGsmSendSmsRilRequest(rr, smscPDU, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilSendSms(rr.mSerial, rr.mRequest);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendSMSExpectMore(String smscPDU, String pdu, Message result) {
        RILRequest rr = RILRequest.obtain(26, result);
        this.constructGsmSendSmsRilRequest(rr, smscPDU, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilSendSms(rr.mSerial, rr.mRequest);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$constructCdmaSendSmsRilRequest(RILRequest rr, byte[] pdu) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pdu);
        DataInputStream dis = new DataInputStream(bais);
        try {
            int i;
            rr.mParcel.writeInt(dis.readInt());
            rr.mParcel.writeByte((byte)dis.readInt());
            rr.mParcel.writeInt(dis.readInt());
            rr.mParcel.writeInt(dis.read());
            rr.mParcel.writeInt(dis.read());
            rr.mParcel.writeInt(dis.read());
            rr.mParcel.writeInt(dis.read());
            int address_nbr_of_digits = dis.read();
            rr.mParcel.writeByte((byte)address_nbr_of_digits);
            for (i = 0; i < address_nbr_of_digits; ++i) {
                rr.mParcel.writeByte(dis.readByte());
            }
            rr.mParcel.writeInt(dis.read());
            rr.mParcel.writeByte((byte)dis.read());
            int subaddr_nbr_of_digits = dis.read();
            rr.mParcel.writeByte((byte)subaddr_nbr_of_digits);
            for (i = 0; i < subaddr_nbr_of_digits; ++i) {
                rr.mParcel.writeByte(dis.readByte());
            }
            int bearerDataLength = dis.read();
            rr.mParcel.writeInt(bearerDataLength);
            for (i = 0; i < bearerDataLength; ++i) {
                rr.mParcel.writeByte(dis.readByte());
            }
        }
        catch (IOException ex) {
            this.riljLog("sendSmsCdma: conversion from input stream to object failed: " + ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendCdmaSms(byte[] pdu, Message result) {
        RILRequest rr = RILRequest.obtain(87, result);
        this.constructCdmaSendSmsRilRequest(rr, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilSendSms(rr.mSerial, rr.mRequest);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendImsGsmSms(String smscPDU, String pdu, int retry, int messageRef, Message result) {
        RILRequest rr = RILRequest.obtain(113, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeByte((byte)retry);
        rr.mParcel.writeInt(messageRef);
        this.constructGsmSendSmsRilRequest(rr, smscPDU, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilSendSms(rr.mSerial, rr.mRequest);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendImsCdmaSms(byte[] pdu, int retry, int messageRef, Message result) {
        RILRequest rr = RILRequest.obtain(113, result);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeByte((byte)retry);
        rr.mParcel.writeInt(messageRef);
        this.constructCdmaSendSmsRilRequest(rr, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.mEventLog.writeRilSendSms(rr.mSerial, rr.mRequest);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$deleteSmsOnSim(int index, Message response) {
        RILRequest rr = RILRequest.obtain(64, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(index);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$deleteSmsOnRuim(int index, Message response) {
        RILRequest rr = RILRequest.obtain(97, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(index);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$writeSmsToSim(int status, String smsc, String pdu, Message response) {
        status = this.translateStatus(status);
        RILRequest rr = RILRequest.obtain(63, response);
        rr.mParcel.writeInt(status);
        rr.mParcel.writeString(pdu);
        rr.mParcel.writeString(smsc);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$writeSmsToRuim(int status, String pdu, Message response) {
        status = this.translateStatus(status);
        RILRequest rr = RILRequest.obtain(96, response);
        rr.mParcel.writeInt(status);
        rr.mParcel.writeString(pdu);
        this.send(rr);
    }

    private final int $$robo$$com_android_internal_telephony_RIL$translateStatus(int status) {
        switch (status & 7) {
            case 1: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 2;
            }
        }
        return 1;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setupDataCall(int radioTechnology, int profile, String apn, String user, String password, int authType, String protocol, Message result) {
        RILRequest rr = RILRequest.obtain(27, result);
        rr.mParcel.writeInt(7);
        rr.mParcel.writeString(Integer.toString(radioTechnology + 2));
        rr.mParcel.writeString(Integer.toString(profile));
        rr.mParcel.writeString(apn);
        rr.mParcel.writeString(user);
        rr.mParcel.writeString(password);
        rr.mParcel.writeString(Integer.toString(authType));
        rr.mParcel.writeString(protocol);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + radioTechnology + " " + profile + " " + apn + " " + user + " " + password + " " + authType + " " + protocol);
        this.mEventLog.writeRilSetupDataCall(rr.mSerial, radioTechnology, profile, apn, user, password, authType, protocol);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$deactivateDataCall(int cid, int reason, Message result) {
        RILRequest rr = RILRequest.obtain(41, result);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(Integer.toString(cid));
        rr.mParcel.writeString(Integer.toString(reason));
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + cid + " " + reason);
        this.mEventLog.writeRilDeactivateDataCall(rr.mSerial, cid, reason);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setRadioPower(boolean on, Message result) {
        RILRequest rr = RILRequest.obtain(23, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(on ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + (on ? " on" : " off"));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$requestShutdown(Message result) {
        RILRequest rr = RILRequest.obtain(129, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setSuppServiceNotifications(boolean enable, Message result) {
        RILRequest rr = RILRequest.obtain(62, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(enable ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$acknowledgeLastIncomingGsmSms(boolean success, int cause, Message result) {
        RILRequest rr = RILRequest.obtain(37, result);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeInt(success ? 1 : 0);
        rr.mParcel.writeInt(cause);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + success + " " + cause);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$acknowledgeLastIncomingCdmaSms(boolean success, int cause, Message result) {
        RILRequest rr = RILRequest.obtain(88, result);
        rr.mParcel.writeInt(success ? 0 : 1);
        rr.mParcel.writeInt(cause);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + success + " " + cause);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$acknowledgeIncomingGsmSmsWithPdu(boolean success, String ackPdu, Message result) {
        RILRequest rr = RILRequest.obtain(106, result);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(success ? "1" : "0");
        rr.mParcel.writeString(ackPdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ' ' + success + " [" + ackPdu + ']');
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccIO(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, Message result) {
        this.iccIOForApp(command, fileid, path, p1, p2, p3, data, pin2, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccIOForApp(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(28, result);
        rr.mParcel.writeInt(command);
        rr.mParcel.writeInt(fileid);
        rr.mParcel.writeString(path);
        rr.mParcel.writeInt(p1);
        rr.mParcel.writeInt(p2);
        rr.mParcel.writeInt(p3);
        rr.mParcel.writeString(data);
        rr.mParcel.writeString(pin2);
        rr.mParcel.writeString(aid);
        this.riljLog(rr.serialString() + "> iccIO: " + RIL.requestToString(rr.mRequest) + " 0x" + Integer.toHexString(command) + " 0x" + Integer.toHexString(fileid) + "  path: " + path + "," + p1 + "," + p2 + "," + p3 + " aid: " + aid);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCLIR(Message result) {
        RILRequest rr = RILRequest.obtain(31, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCLIR(int clirMode, Message result) {
        RILRequest rr = RILRequest.obtain(32, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(clirMode);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + clirMode);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryCallWaiting(int serviceClass, Message response) {
        RILRequest rr = RILRequest.obtain(35, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(serviceClass);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + serviceClass);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCallWaiting(boolean enable, int serviceClass, Message response) {
        RILRequest rr = RILRequest.obtain(36, response);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeInt(enable ? 1 : 0);
        rr.mParcel.writeInt(serviceClass);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + enable + ", " + serviceClass);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setNetworkSelectionModeAutomatic(Message response) {
        RILRequest rr = RILRequest.obtain(46, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setNetworkSelectionModeManual(String operatorNumeric, Message response) {
        RILRequest rr = RILRequest.obtain(47, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + operatorNumeric);
        rr.mParcel.writeString(operatorNumeric);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getNetworkSelectionMode(Message response) {
        RILRequest rr = RILRequest.obtain(45, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getAvailableNetworks(Message response) {
        RILRequest rr = RILRequest.obtain(48, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCallForward(int action, int cfReason, int serviceClass, String number, int timeSeconds, Message response) {
        RILRequest rr = RILRequest.obtain(34, response);
        rr.mParcel.writeInt(action);
        rr.mParcel.writeInt(cfReason);
        rr.mParcel.writeInt(serviceClass);
        rr.mParcel.writeInt(PhoneNumberUtils.toaFromString(number));
        rr.mParcel.writeString(number);
        rr.mParcel.writeInt(timeSeconds);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + action + " " + cfReason + " " + serviceClass + timeSeconds);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryCallForwardStatus(int cfReason, int serviceClass, String number, Message response) {
        RILRequest rr = RILRequest.obtain(33, response);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeInt(cfReason);
        rr.mParcel.writeInt(serviceClass);
        rr.mParcel.writeInt(PhoneNumberUtils.toaFromString(number));
        rr.mParcel.writeString(number);
        rr.mParcel.writeInt(0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + cfReason + " " + serviceClass);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryCLIP(Message response) {
        RILRequest rr = RILRequest.obtain(55, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getBasebandVersion(Message response) {
        RILRequest rr = RILRequest.obtain(51, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryFacilityLock(String facility, String password, int serviceClass, Message response) {
        this.queryFacilityLockForApp(facility, password, serviceClass, null, response);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryFacilityLockForApp(String facility, String password, int serviceClass, String appId, Message response) {
        RILRequest rr = RILRequest.obtain(42, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " [" + facility + " " + serviceClass + " " + appId + "]");
        rr.mParcel.writeInt(4);
        rr.mParcel.writeString(facility);
        rr.mParcel.writeString(password);
        rr.mParcel.writeString(Integer.toString(serviceClass));
        rr.mParcel.writeString(appId);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setFacilityLock(String facility, boolean lockState, String password, int serviceClass, Message response) {
        this.setFacilityLockForApp(facility, lockState, password, serviceClass, null, response);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setFacilityLockForApp(String facility, boolean lockState, String password, int serviceClass, String appId, Message response) {
        RILRequest rr = RILRequest.obtain(43, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " [" + facility + " " + lockState + " " + serviceClass + " " + appId + "]");
        rr.mParcel.writeInt(5);
        rr.mParcel.writeString(facility);
        String lockString = lockState ? "1" : "0";
        rr.mParcel.writeString(lockString);
        rr.mParcel.writeString(password);
        rr.mParcel.writeString(Integer.toString(serviceClass));
        rr.mParcel.writeString(appId);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendUSSD(String ussdString, Message response) {
        RILRequest rr = RILRequest.obtain(29, response);
        String logUssdString = "*******";
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + logUssdString);
        rr.mParcel.writeString(ussdString);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$cancelPendingUssd(Message response) {
        RILRequest rr = RILRequest.obtain(30, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$resetRadio(Message result) {
        RILRequest rr = RILRequest.obtain(58, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$invokeOemRilRequestRaw(byte[] data, Message response) {
        RILRequest rr = RILRequest.obtain(59, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + "[" + IccUtils.bytesToHexString(data) + "]");
        rr.mParcel.writeByteArray(data);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$invokeOemRilRequestStrings(String[] strings, Message response) {
        RILRequest rr = RILRequest.obtain(60, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeStringArray(strings);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setBandMode(int bandMode, Message response) {
        RILRequest rr = RILRequest.obtain(65, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(bandMode);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + bandMode);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryAvailableBandMode(Message response) {
        RILRequest rr = RILRequest.obtain(66, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendTerminalResponse(String contents, Message response) {
        RILRequest rr = RILRequest.obtain(70, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeString(contents);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendEnvelope(String contents, Message response) {
        RILRequest rr = RILRequest.obtain(69, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeString(contents);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendEnvelopeWithStatus(String contents, Message response) {
        RILRequest rr = RILRequest.obtain(107, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + '[' + contents + ']');
        rr.mParcel.writeString(contents);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$handleCallSetupRequestFromSim(boolean accept, Message response) {
        RILRequest rr = RILRequest.obtain(71, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        int[] param = new int[]{accept ? 1 : 0};
        rr.mParcel.writeIntArray(param);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setPreferredNetworkType(int networkType, Message response) {
        RILRequest rr = RILRequest.obtain(73, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(networkType);
        this.mPreferredNetworkType = networkType;
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + networkType);
        this.mEventLog.writeSetPreferredNetworkType(networkType);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getPreferredNetworkType(Message response) {
        RILRequest rr = RILRequest.obtain(74, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getNeighboringCids(Message response) {
        RILRequest rr = RILRequest.obtain(75, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setLocationUpdates(boolean enable, Message response) {
        RILRequest rr = RILRequest.obtain(76, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(enable ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ": " + enable);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getSmscAddress(Message result) {
        RILRequest rr = RILRequest.obtain(100, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setSmscAddress(String address, Message result) {
        RILRequest rr = RILRequest.obtain(101, result);
        rr.mParcel.writeString(address);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + address);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$reportSmsMemoryStatus(boolean available, Message result) {
        RILRequest rr = RILRequest.obtain(102, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(available ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ": " + available);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$reportStkServiceIsRunning(Message result) {
        RILRequest rr = RILRequest.obtain(103, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getGsmBroadcastConfig(Message response) {
        RILRequest rr = RILRequest.obtain(89, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setGsmBroadcastConfig(SmsBroadcastConfigInfo[] config, Message response) {
        int i;
        RILRequest rr = RILRequest.obtain(90, response);
        int numOfConfig = config.length;
        rr.mParcel.writeInt(numOfConfig);
        for (i = 0; i < numOfConfig; ++i) {
            rr.mParcel.writeInt(config[i].getFromServiceId());
            rr.mParcel.writeInt(config[i].getToServiceId());
            rr.mParcel.writeInt(config[i].getFromCodeScheme());
            rr.mParcel.writeInt(config[i].getToCodeScheme());
            rr.mParcel.writeInt(config[i].isSelected() ? 1 : 0);
        }
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + numOfConfig + " configs : ");
        for (i = 0; i < numOfConfig; ++i) {
            this.riljLog(config[i].toString());
        }
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setGsmBroadcastActivation(boolean activate, Message response) {
        RILRequest rr = RILRequest.obtain(91, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(activate ? 0 : 1);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$updateScreenState() {
        int oldState = this.mRadioScreenState;
        int n = this.mRadioScreenState = this.mDefaultDisplayState == 2 || this.mIsDevicePlugged ? 1 : 0;
        if (this.mRadioScreenState != oldState) {
            this.sendScreenState(this.mRadioScreenState == 1);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendScreenState(boolean on) {
        RILRequest rr = RILRequest.obtain(61, null);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(on ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ": " + on);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$onRadioAvailable() {
        this.updateScreenState();
    }

    private final CommandsInterface.RadioState $$robo$$com_android_internal_telephony_RIL$getRadioStateFromInt(int stateInt) {
        CommandsInterface.RadioState state;
        switch (stateInt) {
            case 0: {
                state = CommandsInterface.RadioState.RADIO_OFF;
                break;
            }
            case 1: {
                state = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
                break;
            }
            case 10: {
                state = CommandsInterface.RadioState.RADIO_ON;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized RIL_RadioState: " + stateInt);
            }
        }
        return state;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$switchToRadioState(CommandsInterface.RadioState newState) {
        this.setRadioState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$acquireWakeLock(RILRequest rr, int wakeLockType) {
        RILRequest rILRequest = rr;
        synchronized (rILRequest) {
            if (rr.mWakeLockType != -1) {
                Rlog.d("RILJ", "Failed to aquire wakelock for " + rr.serialString());
                return;
            }
            switch (wakeLockType) {
                case 0: {
                    PowerManager.WakeLock wakeLock = this.mWakeLock;
                    synchronized (wakeLock) {
                        this.mWakeLock.acquire();
                        ++this.mWakeLockCount;
                        ++this.mWlSequenceNum;
                        Message msg = this.mSender.obtainMessage(2);
                        msg.arg1 = this.mWlSequenceNum;
                        this.mSender.sendMessageDelayed(msg, this.mWakeLockTimeout);
                        break;
                    }
                }
                case 1: {
                    PowerManager.WakeLock wakeLock = this.mAckWakeLock;
                    synchronized (wakeLock) {
                        this.mAckWakeLock.acquire();
                        ++this.mAckWlSequenceNum;
                        Message msg = this.mSender.obtainMessage(4);
                        msg.arg1 = this.mAckWlSequenceNum;
                        this.mSender.sendMessageDelayed(msg, this.mAckWakeLockTimeout);
                        break;
                    }
                }
                default: {
                    Rlog.w("RILJ", "Acquiring Invalid Wakelock type " + wakeLockType);
                    return;
                }
            }
            rr.mWakeLockType = wakeLockType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$decrementWakeLock(RILRequest rr) {
        RILRequest rILRequest = rr;
        synchronized (rILRequest) {
            switch (rr.mWakeLockType) {
                case 0: {
                    PowerManager.WakeLock wakeLock = this.mWakeLock;
                    synchronized (wakeLock) {
                        if (this.mWakeLockCount > 1) {
                            --this.mWakeLockCount;
                        } else {
                            this.mWakeLockCount = 0;
                            this.mWakeLock.release();
                        }
                        break;
                    }
                }
                case 1: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    Rlog.w("RILJ", "Decrementing Invalid Wakelock type " + rr.mWakeLockType);
                }
            }
            rr.mWakeLockType = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_RIL$clearWakeLock(int wakeLockType) {
        if (wakeLockType == 0) {
            PowerManager.WakeLock wakeLock = this.mWakeLock;
            synchronized (wakeLock) {
                if (this.mWakeLockCount == 0 && !this.mWakeLock.isHeld()) {
                    return false;
                }
                Rlog.d("RILJ", "NOTE: mWakeLockCount is " + this.mWakeLockCount + "at time of clearing");
                this.mWakeLockCount = 0;
                this.mWakeLock.release();
                return true;
            }
        }
        PowerManager.WakeLock wakeLock = this.mAckWakeLock;
        synchronized (wakeLock) {
            if (!this.mAckWakeLock.isHeld()) {
                return false;
            }
            this.mAckWakeLock.release();
            return true;
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$send(RILRequest rr) {
        if (this.mSocket == null) {
            rr.onError(1, null);
            rr.release();
            return;
        }
        Message msg = this.mSender.obtainMessage(1, rr);
        this.acquireWakeLock(rr, 0);
        msg.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$processResponse(Parcel p) {
        int type = p.readInt();
        if (type == 1 || type == 4) {
            this.processUnsolicited(p, type);
        } else if (type == 0 || type == 3) {
            RILRequest rr = this.processSolicited(p, type);
            if (rr != null) {
                if (type == 0) {
                    this.decrementWakeLock(rr);
                }
                rr.release();
                return;
            }
        } else if (type == 2) {
            RILRequest rr;
            int serial = p.readInt();
            SparseArray<RILRequest> sparseArray = this.mRequestList;
            synchronized (sparseArray) {
                rr = this.mRequestList.get(serial);
            }
            if (rr == null) {
                Rlog.w("RILJ", "Unexpected solicited ack response! sn: " + serial);
            } else {
                this.decrementWakeLock(rr);
                this.riljLog(rr.serialString() + " Ack < " + RIL.requestToString(rr.mRequest));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$clearRequestList(int error, boolean loggable) {
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            int count = this.mRequestList.size();
            if (loggable) {
                Rlog.d("RILJ", "clearRequestList  mWakeLockCount=" + this.mWakeLockCount + " mRequestList=" + count);
            }
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                if (loggable) {
                    Rlog.d("RILJ", i + ": [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
                }
                rr.onError(error, null);
                this.decrementWakeLock(rr);
                rr.release();
            }
            this.mRequestList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RILRequest $$robo$$com_android_internal_telephony_RIL$findAndRemoveRequestFromList(int serial) {
        RILRequest rr = null;
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr = this.mRequestList.get(serial);
            if (rr != null) {
                this.mRequestList.remove(serial);
            }
        }
        return rr;
    }

    private final RILRequest $$robo$$com_android_internal_telephony_RIL$processSolicited(Parcel p, int type) {
        boolean found = false;
        int serial = p.readInt();
        int error = p.readInt();
        RILRequest rr = this.findAndRemoveRequestFromList(serial);
        if (rr == null) {
            Rlog.w("RILJ", "Unexpected solicited response! sn: " + serial + " error: " + error);
            return null;
        }
        if (this.getRilVersion() >= 13 && type == 3) {
            RILRequest response = RILRequest.obtain(800, null);
            Message msg = this.mSender.obtainMessage(3, response);
            this.acquireWakeLock(rr, 1);
            msg.sendToTarget();
            this.riljLog("Response received for " + rr.serialString() + " " + RIL.requestToString(rr.mRequest) + " Sending ack to ril.cpp");
        }
        Object ret = null;
        if (error == 0 || p.dataAvail() > 0) {
            try {
                switch (rr.mRequest) {
                    case 1: {
                        ret = this.responseIccCardStatus(p);
                        break;
                    }
                    case 2: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 3: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 4: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 5: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 6: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 7: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 8: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 9: {
                        ret = this.responseCallList(p);
                        break;
                    }
                    case 10: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 11: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 12: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 13: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 14: {
                        if (this.mTestingEmergencyCall.getAndSet(false) && this.mEmergencyCallbackModeRegistrant != null) {
                            this.riljLog("testing emergency call, notify ECM Registrants");
                            this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
                        }
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 15: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 16: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 17: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 18: {
                        ret = this.responseFailCause(p);
                        break;
                    }
                    case 19: {
                        ret = this.responseSignalStrength(p);
                        break;
                    }
                    case 20: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 21: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 22: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 23: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 24: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 25: {
                        ret = this.responseSMS(p);
                        break;
                    }
                    case 26: {
                        ret = this.responseSMS(p);
                        break;
                    }
                    case 27: {
                        ret = this.responseSetupDataCall(p);
                        break;
                    }
                    case 28: {
                        ret = this.responseICC_IO(p);
                        break;
                    }
                    case 29: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 30: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 31: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 32: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 33: {
                        ret = this.responseCallForward(p);
                        break;
                    }
                    case 34: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 35: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 36: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 37: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 38: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 39: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 40: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 41: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 42: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 43: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 44: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 45: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 46: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 47: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 48: {
                        ret = this.responseOperatorInfos(p);
                        break;
                    }
                    case 49: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 50: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 51: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 52: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 53: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 54: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 55: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 56: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 57: {
                        ret = this.responseDataCallList(p);
                        break;
                    }
                    case 58: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 59: {
                        ret = this.responseRaw(p);
                        break;
                    }
                    case 60: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 61: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 62: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 63: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 64: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 65: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 66: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 67: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 68: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 69: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 70: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 71: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 72: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 73: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 74: {
                        ret = this.responseGetPreferredNetworkType(p);
                        break;
                    }
                    case 75: {
                        ret = this.responseCellList(p);
                        break;
                    }
                    case 76: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 77: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 78: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 79: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 80: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 81: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 82: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 83: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 84: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 85: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 87: {
                        ret = this.responseSMS(p);
                        break;
                    }
                    case 88: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 89: {
                        ret = this.responseGmsBroadcastConfig(p);
                        break;
                    }
                    case 90: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 91: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 92: {
                        ret = this.responseCdmaBroadcastConfig(p);
                        break;
                    }
                    case 93: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 94: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 86: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 95: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 96: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 97: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 98: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 100: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 101: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 99: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 102: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 103: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 104: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 105: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 106: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 107: {
                        ret = this.responseICC_IO(p);
                        break;
                    }
                    case 108: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 109: {
                        ret = this.responseCellInfoList(p);
                        break;
                    }
                    case 110: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 111: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 128: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 112: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 113: {
                        ret = this.responseSMS(p);
                        break;
                    }
                    case 114: {
                        ret = this.responseICC_IO(p);
                        break;
                    }
                    case 115: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 116: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 117: {
                        ret = this.responseICC_IO(p);
                        break;
                    }
                    case 118: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 119: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 120: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 121: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 122: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 123: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 124: {
                        ret = this.responseHardwareConfig(p);
                        break;
                    }
                    case 125: {
                        ret = this.responseICC_IOBase64(p);
                        break;
                    }
                    case 129: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 130: {
                        ret = this.responseRadioCapability(p);
                        break;
                    }
                    case 131: {
                        ret = this.responseRadioCapability(p);
                        break;
                    }
                    case 132: {
                        ret = this.responseLceStatus(p);
                        break;
                    }
                    case 133: {
                        ret = this.responseLceStatus(p);
                        break;
                    }
                    case 134: {
                        ret = this.responseLceData(p);
                        break;
                    }
                    case 135: {
                        ret = this.responseActivityData(p);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unrecognized solicited response: " + rr.mRequest);
                    }
                }
            }
            catch (Throwable tr) {
                Rlog.w("RILJ", rr.serialString() + "< " + RIL.requestToString(rr.mRequest) + " exception, possible invalid RIL response", tr);
                if (rr.mResult != null) {
                    AsyncResult.forMessage(rr.mResult, null, tr);
                    rr.mResult.sendToTarget();
                }
                return rr;
            }
        }
        if (rr.mRequest == 129) {
            this.riljLog("Response to RIL_REQUEST_SHUTDOWN received. Error is " + error + " Setting Radio State to Unavailable regardless of error.");
            this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
        }
        switch (rr.mRequest) {
            case 3: 
            case 5: {
                if (this.mIccStatusChangedRegistrants == null) break;
                this.riljLog("ON enter sim puk fakeSimStatusChanged: reg count=" + this.mIccStatusChangedRegistrants.size());
                this.mIccStatusChangedRegistrants.notifyRegistrants();
            }
        }
        if (error != 0) {
            switch (rr.mRequest) {
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 43: {
                    if (this.mIccStatusChangedRegistrants == null) break;
                    this.riljLog("ON some errors fakeSimStatusChanged: reg count=" + this.mIccStatusChangedRegistrants.size());
                    this.mIccStatusChangedRegistrants.notifyRegistrants();
                    break;
                }
                case 130: {
                    if (6 != error && 2 != error) break;
                    ret = this.makeStaticRadioCapability();
                    error = 0;
                    break;
                }
                case 135: {
                    ret = new ModemActivityInfo(0L, 0, 0, new int[5], 0, 0);
                    error = 0;
                }
            }
            if (error != 0) {
                rr.onError(error, ret);
            }
        }
        if (error == 0) {
            this.riljLog(rr.serialString() + "< " + RIL.requestToString(rr.mRequest) + " " + RIL.retToString(rr.mRequest, ret));
            if (rr.mResult != null) {
                AsyncResult.forMessage(rr.mResult, ret, null);
                rr.mResult.sendToTarget();
            }
        }
        this.mEventLog.writeOnRilSolicitedResponse(rr.mSerial, error, rr.mRequest, ret);
        return rr;
    }

    private final RadioCapability $$robo$$com_android_internal_telephony_RIL$makeStaticRadioCapability() {
        int raf = 1;
        String rafString = this.mContext.getResources().getString(17039465);
        if (!TextUtils.isEmpty(rafString)) {
            raf = RadioAccessFamily.rafTypeFromString(rafString);
        }
        RadioCapability rc = new RadioCapability(this.mInstanceId, 0, 0, raf, "", 1);
        this.riljLog("Faking RIL_REQUEST_GET_RADIO_CAPABILITY response using " + raf);
        return rc;
    }

    private static final String $$robo$$com_android_internal_telephony_RIL$retToString(int req, Object ret) {
        String s;
        if (ret == null) {
            return "";
        }
        switch (req) {
            case 11: 
            case 38: 
            case 39: 
            case 115: 
            case 117: {
                return "";
            }
        }
        if (ret instanceof int[]) {
            int[] intArray = (int[])ret;
            int length = intArray.length;
            StringBuilder sb = new StringBuilder("{");
            if (length > 0) {
                int i = 0;
                sb.append(intArray[i++]);
                while (i < length) {
                    sb.append(", ").append(intArray[i++]);
                }
            }
            sb.append("}");
            s = sb.toString();
        } else if (ret instanceof String[]) {
            String[] strings = (String[])ret;
            int length = strings.length;
            StringBuilder sb = new StringBuilder("{");
            if (length > 0) {
                int i = 0;
                sb.append(strings[i++]);
                while (i < length) {
                    sb.append(", ").append(strings[i++]);
                }
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 9) {
            ArrayList calls = (ArrayList)ret;
            StringBuilder sb = new StringBuilder("{");
            for (DriverCall dc : calls) {
                sb.append("[").append(dc).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 75) {
            ArrayList cells = (ArrayList)ret;
            StringBuilder sb = new StringBuilder("{");
            for (NeighboringCellInfo cell : cells) {
                sb.append("[").append(cell).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 33) {
            CallForwardInfo[] cinfo = (CallForwardInfo[])ret;
            int length = cinfo.length;
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < length; ++i) {
                sb.append("[").append(cinfo[i]).append("] ");
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 124) {
            ArrayList hwcfgs = (ArrayList)ret;
            StringBuilder sb = new StringBuilder(" ");
            for (HardwareConfig hwcfg : hwcfgs) {
                sb.append("[").append(hwcfg).append("] ");
            }
            s = sb.toString();
        } else {
            s = ret.toString();
        }
        return s;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$processUnsolicited(Parcel p, int type) {
        Object ret;
        int response = p.readInt();
        if (this.getRilVersion() >= 13 && type == 4) {
            RILRequest rr = RILRequest.obtain(800, null);
            Message msg = this.mSender.obtainMessage(3, rr);
            this.acquireWakeLock(rr, 1);
            msg.sendToTarget();
            this.riljLog("Unsol response received for " + RIL.responseToString(response) + " Sending ack to ril.cpp");
        }
        try {
            switch (response) {
                case 1000: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1001: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1002: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1003: {
                    ret = this.responseString(p);
                    break;
                }
                case 1004: {
                    ret = this.responseString(p);
                    break;
                }
                case 1005: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1006: {
                    ret = this.responseStrings(p);
                    break;
                }
                case 1008: {
                    ret = this.responseString(p);
                    break;
                }
                case 1009: {
                    ret = this.responseSignalStrength(p);
                    break;
                }
                case 1010: {
                    ret = this.responseDataCallList(p);
                    break;
                }
                case 1011: {
                    ret = this.responseSuppServiceNotification(p);
                    break;
                }
                case 1012: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1013: {
                    ret = this.responseString(p);
                    break;
                }
                case 1014: {
                    ret = this.responseString(p);
                    break;
                }
                case 1015: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1016: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1017: {
                    ret = this.responseSimRefresh(p);
                    break;
                }
                case 1018: {
                    ret = this.responseCallRing(p);
                    break;
                }
                case 1023: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1019: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1020: {
                    ret = this.responseCdmaSms(p);
                    break;
                }
                case 1021: {
                    ret = this.responseRaw(p);
                    break;
                }
                case 1022: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1024: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1025: {
                    ret = this.responseCdmaCallWaiting(p);
                    break;
                }
                case 1026: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1027: {
                    ret = this.responseCdmaInformationRecord(p);
                    break;
                }
                case 1028: {
                    ret = this.responseRaw(p);
                    break;
                }
                case 1029: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1030: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1031: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1032: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1033: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1034: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1035: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1036: {
                    ret = this.responseCellInfoList(p);
                    break;
                }
                case 1037: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1038: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1039: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1040: {
                    ret = this.responseHardwareConfig(p);
                    break;
                }
                case 1042: {
                    ret = this.responseRadioCapability(p);
                    break;
                }
                case 1043: {
                    ret = this.responseSsData(p);
                    break;
                }
                case 1044: {
                    ret = this.responseString(p);
                    break;
                }
                case 1045: {
                    ret = this.responseLceData(p);
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized unsol response: " + response);
                }
            }
        }
        catch (Throwable tr) {
            Rlog.e("RILJ", "Exception processing unsol response: " + response + "Exception:" + tr.toString());
            return;
        }
        switch (response) {
            case 1000: {
                CommandsInterface.RadioState newState = this.getRadioStateFromInt(p.readInt());
                this.unsljLogMore(response, newState.toString());
                this.switchToRadioState(newState);
                break;
            }
            case 1037: {
                this.unsljLog(response);
                this.mImsNetworkStateChangedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                break;
            }
            case 1001: {
                this.unsljLog(response);
                this.mCallStateRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                break;
            }
            case 1002: {
                this.unsljLog(response);
                this.mVoiceNetworkStateRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                break;
            }
            case 1003: {
                this.unsljLog(response);
                this.mEventLog.writeRilNewSms(response);
                String[] a = new String[2];
                a[1] = (String)ret;
                SmsMessage sms = SmsMessage.newFromCMT(a);
                if (this.mGsmSmsRegistrant == null) break;
                this.mGsmSmsRegistrant.notifyRegistrant(new AsyncResult(null, sms, null));
                break;
            }
            case 1004: {
                this.unsljLogRet(response, ret);
                if (this.mSmsStatusRegistrant == null) break;
                this.mSmsStatusRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1005: {
                this.unsljLogRet(response, ret);
                int[] smsIndex = (int[])ret;
                if (smsIndex.length == 1) {
                    if (this.mSmsOnSimRegistrant == null) break;
                    this.mSmsOnSimRegistrant.notifyRegistrant(new AsyncResult(null, smsIndex, null));
                    break;
                }
                this.riljLog(" NEW_SMS_ON_SIM ERROR with wrong length " + smsIndex.length);
                break;
            }
            case 1006: {
                String[] resp = (String[])ret;
                if (resp.length < 2) {
                    resp = new String[]{((String[])ret)[0], null};
                }
                this.unsljLogMore(response, resp[0]);
                if (this.mUSSDRegistrant == null) break;
                this.mUSSDRegistrant.notifyRegistrant(new AsyncResult(null, resp, null));
                break;
            }
            case 1008: {
                this.unsljLogRet(response, ret);
                long nitzReceiveTime = p.readLong();
                Object[] result = new Object[]{ret, nitzReceiveTime};
                boolean ignoreNitz = SystemProperties.getBoolean("telephony.test.ignore.nitz", false);
                if (ignoreNitz) {
                    this.riljLog("ignoring UNSOL_NITZ_TIME_RECEIVED");
                    break;
                }
                if (this.mNITZTimeRegistrant != null) {
                    this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, result, null));
                }
                this.mLastNITZTimeInfo = result;
                break;
            }
            case 1009: {
                if (this.mSignalStrengthRegistrant == null) break;
                this.mSignalStrengthRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1010: {
                this.unsljLogRet(response, ret);
                this.mDataNetworkStateRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1011: {
                this.unsljLogRet(response, ret);
                if (this.mSsnRegistrant == null) break;
                this.mSsnRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1012: {
                this.unsljLog(response);
                if (this.mCatSessionEndRegistrant == null) break;
                this.mCatSessionEndRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1013: {
                this.unsljLog(response);
                if (this.mCatProCmdRegistrant == null) break;
                this.mCatProCmdRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1014: {
                this.unsljLog(response);
                if (this.mCatEventRegistrant == null) break;
                this.mCatEventRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1015: {
                this.unsljLogRet(response, ret);
                if (this.mCatCallSetUpRegistrant == null) break;
                this.mCatCallSetUpRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1016: {
                this.unsljLog(response);
                if (this.mIccSmsFullRegistrant == null) break;
                this.mIccSmsFullRegistrant.notifyRegistrant();
                break;
            }
            case 1017: {
                this.unsljLogRet(response, ret);
                if (this.mIccRefreshRegistrants == null) break;
                this.mIccRefreshRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1018: {
                this.unsljLogRet(response, ret);
                if (this.mRingRegistrant == null) break;
                this.mRingRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1023: {
                this.unsljLogvRet(response, ret);
                if (this.mRestrictedStateRegistrant == null) break;
                this.mRestrictedStateRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1019: {
                this.unsljLog(response);
                if (this.mIccStatusChangedRegistrants == null) break;
                this.mIccStatusChangedRegistrants.notifyRegistrants();
                break;
            }
            case 1020: {
                this.unsljLog(response);
                this.mEventLog.writeRilNewSms(response);
                SmsMessage sms = (SmsMessage)ret;
                if (this.mCdmaSmsRegistrant == null) break;
                this.mCdmaSmsRegistrant.notifyRegistrant(new AsyncResult(null, sms, null));
                break;
            }
            case 1021: {
                this.unsljLogvRet(response, IccUtils.bytesToHexString((byte[])ret));
                if (this.mGsmBroadcastSmsRegistrant == null) break;
                this.mGsmBroadcastSmsRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1022: {
                this.unsljLog(response);
                if (this.mIccSmsFullRegistrant == null) break;
                this.mIccSmsFullRegistrant.notifyRegistrant();
                break;
            }
            case 1024: {
                this.unsljLog(response);
                if (this.mEmergencyCallbackModeRegistrant == null) break;
                this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
                break;
            }
            case 1025: {
                this.unsljLogRet(response, ret);
                if (this.mCallWaitingInfoRegistrants == null) break;
                this.mCallWaitingInfoRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1026: {
                this.unsljLogRet(response, ret);
                if (this.mOtaProvisionRegistrants == null) break;
                this.mOtaProvisionRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1027: {
                ArrayList listInfoRecs;
                try {
                    listInfoRecs = (ArrayList)ret;
                }
                catch (ClassCastException e) {
                    Rlog.e("RILJ", "Unexpected exception casting to listInfoRecs", e);
                    break;
                }
                for (CdmaInformationRecords rec : listInfoRecs) {
                    this.unsljLogRet(response, rec);
                    this.notifyRegistrantsCdmaInfoRec(rec);
                }
                break;
            }
            case 1028: {
                this.unsljLogvRet(response, IccUtils.bytesToHexString((byte[])ret));
                if (this.mUnsolOemHookRawRegistrant == null) break;
                this.mUnsolOemHookRawRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1029: {
                this.unsljLogvRet(response, ret);
                if (this.mRingbackToneRegistrants == null) break;
                boolean playtone = ((int[])ret)[0] == 1;
                this.mRingbackToneRegistrants.notifyRegistrants(new AsyncResult(null, playtone, null));
                break;
            }
            case 1030: {
                this.unsljLogRet(response, ret);
                if (this.mResendIncallMuteRegistrants == null) break;
                this.mResendIncallMuteRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1035: {
                this.unsljLogRet(response, ret);
                if (this.mVoiceRadioTechChangedRegistrants == null) break;
                this.mVoiceRadioTechChangedRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1031: {
                this.unsljLogRet(response, ret);
                if (this.mCdmaSubscriptionChangedRegistrants == null) break;
                this.mCdmaSubscriptionChangedRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1032: {
                this.unsljLogRet(response, ret);
                if (this.mCdmaPrlChangedRegistrants == null) break;
                this.mCdmaPrlChangedRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1033: {
                this.unsljLogRet(response, ret);
                if (this.mExitEmergencyCallbackModeRegistrants == null) break;
                this.mExitEmergencyCallbackModeRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                break;
            }
            case 1034: {
                this.unsljLogRet(response, ret);
                this.setRadioPower(false, null);
                this.setCdmaSubscriptionSource(this.mCdmaSubscription, null);
                this.setCellInfoListRate(Integer.MAX_VALUE, null);
                this.notifyRegistrantsRilConnectionChanged(((int[])ret)[0]);
                break;
            }
            case 1036: {
                this.unsljLogRet(response, ret);
                if (this.mRilCellInfoListRegistrants == null) break;
                this.mRilCellInfoListRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1038: {
                this.unsljLogRet(response, ret);
                if (this.mSubscriptionStatusRegistrants == null) break;
                this.mSubscriptionStatusRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1039: {
                this.unsljLogRet(response, ret);
                this.mEventLog.writeRilSrvcc(((int[])ret)[0]);
                if (this.mSrvccStateRegistrants == null) break;
                this.mSrvccStateRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1040: {
                this.unsljLogRet(response, ret);
                if (this.mHardwareConfigChangeRegistrants == null) break;
                this.mHardwareConfigChangeRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1042: {
                this.unsljLogRet(response, ret);
                if (this.mPhoneRadioCapabilityChangedRegistrants == null) break;
                this.mPhoneRadioCapabilityChangedRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1043: {
                this.unsljLogRet(response, ret);
                if (this.mSsRegistrant == null) break;
                this.mSsRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1044: {
                this.unsljLogRet(response, ret);
                if (this.mCatCcAlphaRegistrant == null) break;
                this.mCatCcAlphaRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1045: {
                this.unsljLogRet(response, ret);
                if (this.mLceInfoRegistrant == null) break;
                this.mLceInfoRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RIL$notifyRegistrantsRilConnectionChanged(int rilVer) {
        this.mRilVersion = rilVer;
        if (this.mRilConnectedRegistrants != null) {
            this.mRilConnectedRegistrants.notifyRegistrants(new AsyncResult(null, new Integer(rilVer), null));
        }
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseInts(Parcel p) {
        int numInts = p.readInt();
        int[] response = new int[numInts];
        for (int i = 0; i < numInts; ++i) {
            response[i] = p.readInt();
        }
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseFailCause(Parcel p) {
        LastCallFailCause failCause = new LastCallFailCause();
        failCause.causeCode = p.readInt();
        if (p.dataAvail() > 0) {
            failCause.vendorCause = p.readString();
        }
        return failCause;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseVoid(Parcel p) {
        return null;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseCallForward(Parcel p) {
        int numInfos = p.readInt();
        CallForwardInfo[] infos = new CallForwardInfo[numInfos];
        for (int i = 0; i < numInfos; ++i) {
            infos[i] = new CallForwardInfo();
            infos[i].status = p.readInt();
            infos[i].reason = p.readInt();
            infos[i].serviceClass = p.readInt();
            infos[i].toa = p.readInt();
            infos[i].number = p.readString();
            infos[i].timeSeconds = p.readInt();
        }
        return infos;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseSuppServiceNotification(Parcel p) {
        SuppServiceNotification notification = new SuppServiceNotification();
        notification.notificationType = p.readInt();
        notification.code = p.readInt();
        notification.index = p.readInt();
        notification.type = p.readInt();
        notification.number = p.readString();
        return notification;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseCdmaSms(Parcel p) {
        SmsMessage sms = SmsMessage.newFromParcel(p);
        return sms;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseString(Parcel p) {
        String response = p.readString();
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseStrings(Parcel p) {
        String[] response = p.readStringArray();
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseRaw(Parcel p) {
        byte[] response = p.createByteArray();
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseSMS(Parcel p) {
        int messageRef = p.readInt();
        String ackPDU = p.readString();
        int errorCode = p.readInt();
        SmsResponse response = new SmsResponse(messageRef, ackPDU, errorCode);
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseICC_IO(Parcel p) {
        int sw1 = p.readInt();
        int sw2 = p.readInt();
        String s = p.readString();
        return new IccIoResult(sw1, sw2, s);
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseICC_IOBase64(Parcel p) {
        int sw1 = p.readInt();
        int sw2 = p.readInt();
        String s = p.readString();
        return new IccIoResult(sw1, sw2, s != null ? Base64.decode(s, 0) : (byte[])null);
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseIccCardStatus(Parcel p) {
        IccCardStatus cardStatus = new IccCardStatus();
        cardStatus.setCardState(p.readInt());
        cardStatus.setUniversalPinState(p.readInt());
        cardStatus.mGsmUmtsSubscriptionAppIndex = p.readInt();
        cardStatus.mCdmaSubscriptionAppIndex = p.readInt();
        cardStatus.mImsSubscriptionAppIndex = p.readInt();
        int numApplications = p.readInt();
        if (numApplications > 8) {
            numApplications = 8;
        }
        cardStatus.mApplications = new IccCardApplicationStatus[numApplications];
        for (int i = 0; i < numApplications; ++i) {
            IccCardApplicationStatus appStatus = new IccCardApplicationStatus();
            appStatus.app_type = appStatus.AppTypeFromRILInt(p.readInt());
            appStatus.app_state = appStatus.AppStateFromRILInt(p.readInt());
            appStatus.perso_substate = appStatus.PersoSubstateFromRILInt(p.readInt());
            appStatus.aid = p.readString();
            appStatus.app_label = p.readString();
            appStatus.pin1_replaced = p.readInt();
            appStatus.pin1 = appStatus.PinStateFromRILInt(p.readInt());
            appStatus.pin2 = appStatus.PinStateFromRILInt(p.readInt());
            cardStatus.mApplications[i] = appStatus;
        }
        return cardStatus;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseSimRefresh(Parcel p) {
        IccRefreshResponse response = new IccRefreshResponse();
        response.refreshResult = p.readInt();
        response.efId = p.readInt();
        response.aid = p.readString();
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseCallList(Parcel p) {
        int num = p.readInt();
        ArrayList<DriverCall> response = new ArrayList<DriverCall>(num);
        for (int i = 0; i < num; ++i) {
            DriverCall dc = new DriverCall();
            dc.state = DriverCall.stateFromCLCC(p.readInt());
            dc.index = p.readInt();
            dc.TOA = p.readInt();
            dc.isMpty = 0 != p.readInt();
            dc.isMT = 0 != p.readInt();
            dc.als = p.readInt();
            int voiceSettings = p.readInt();
            dc.isVoice = 0 != voiceSettings;
            dc.isVoicePrivacy = 0 != p.readInt();
            dc.number = p.readString();
            int np = p.readInt();
            dc.numberPresentation = DriverCall.presentationFromCLIP(np);
            dc.name = p.readString();
            dc.namePresentation = DriverCall.presentationFromCLIP(p.readInt());
            int uusInfoPresent = p.readInt();
            if (uusInfoPresent == 1) {
                dc.uusInfo = new UUSInfo();
                dc.uusInfo.setType(p.readInt());
                dc.uusInfo.setDcs(p.readInt());
                byte[] userData = p.createByteArray();
                dc.uusInfo.setUserData(userData);
                this.riljLogv(String.format("Incoming UUS : type=%d, dcs=%d, length=%d", dc.uusInfo.getType(), dc.uusInfo.getDcs(), dc.uusInfo.getUserData().length));
                this.riljLogv("Incoming UUS : data (string)=" + new String(dc.uusInfo.getUserData()));
                this.riljLogv("Incoming UUS : data (hex): " + IccUtils.bytesToHexString(dc.uusInfo.getUserData()));
            } else {
                this.riljLogv("Incoming UUS : NOT present!");
            }
            dc.number = PhoneNumberUtils.stringFromStringAndTOA(dc.number, dc.TOA);
            response.add(dc);
            if (dc.isVoicePrivacy) {
                this.mVoicePrivacyOnRegistrants.notifyRegistrants();
                this.riljLog("InCall VoicePrivacy is enabled");
                continue;
            }
            this.mVoicePrivacyOffRegistrants.notifyRegistrants();
            this.riljLog("InCall VoicePrivacy is disabled");
        }
        Collections.sort(response);
        if (num == 0 && this.mTestingEmergencyCall.getAndSet(false) && this.mEmergencyCallbackModeRegistrant != null) {
            this.riljLog("responseCallList: call ended, testing emergency call, notify ECM Registrants");
            this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
        }
        return response;
    }

    private final DataCallResponse $$robo$$com_android_internal_telephony_RIL$getDataCallResponse(Parcel p, int version) {
        DataCallResponse dataCall = new DataCallResponse();
        dataCall.version = version;
        if (version < 5) {
            dataCall.cid = p.readInt();
            dataCall.active = p.readInt();
            dataCall.type = p.readString();
            String addresses = p.readString();
            if (!TextUtils.isEmpty(addresses)) {
                dataCall.addresses = addresses.split(" ");
            }
        } else {
            String pcscf;
            String gateways;
            String dnses;
            dataCall.status = p.readInt();
            dataCall.suggestedRetryTime = p.readInt();
            dataCall.cid = p.readInt();
            dataCall.active = p.readInt();
            dataCall.type = p.readString();
            dataCall.ifname = p.readString();
            if (dataCall.status == DcFailCause.NONE.getErrorCode() && TextUtils.isEmpty(dataCall.ifname)) {
                throw new RuntimeException("getDataCallResponse, no ifname");
            }
            String addresses = p.readString();
            if (!TextUtils.isEmpty(addresses)) {
                dataCall.addresses = addresses.split(" ");
            }
            if (!TextUtils.isEmpty(dnses = p.readString())) {
                dataCall.dnses = dnses.split(" ");
            }
            if (!TextUtils.isEmpty(gateways = p.readString())) {
                dataCall.gateways = gateways.split(" ");
            }
            if (version >= 10 && !TextUtils.isEmpty(pcscf = p.readString())) {
                dataCall.pcscf = pcscf.split(" ");
            }
            if (version >= 11) {
                dataCall.mtu = p.readInt();
            }
        }
        return dataCall;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseDataCallList(Parcel p) {
        int ver = p.readInt();
        int num = p.readInt();
        this.riljLog("responseDataCallList ver=" + ver + " num=" + num);
        ArrayList<DataCallResponse> response = new ArrayList<DataCallResponse>(num);
        for (int i = 0; i < num; ++i) {
            response.add(this.getDataCallResponse(p, ver));
        }
        this.mEventLog.writeRilDataCallList(response);
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseSetupDataCall(Parcel p) {
        DataCallResponse dataCall;
        int ver = p.readInt();
        int num = p.readInt();
        if (ver < 5) {
            dataCall = new DataCallResponse();
            dataCall.version = ver;
            dataCall.cid = Integer.parseInt(p.readString());
            dataCall.ifname = p.readString();
            if (TextUtils.isEmpty(dataCall.ifname)) {
                throw new RuntimeException("RIL_REQUEST_SETUP_DATA_CALL response, no ifname");
            }
            String addresses = p.readString();
            if (!TextUtils.isEmpty(addresses)) {
                dataCall.addresses = addresses.split(" ");
            }
            if (num >= 4) {
                String dnses = p.readString();
                this.riljLog("responseSetupDataCall got dnses=" + dnses);
                if (!TextUtils.isEmpty(dnses)) {
                    dataCall.dnses = dnses.split(" ");
                }
            }
            if (num >= 5) {
                String gateways = p.readString();
                this.riljLog("responseSetupDataCall got gateways=" + gateways);
                if (!TextUtils.isEmpty(gateways)) {
                    dataCall.gateways = gateways.split(" ");
                }
            }
            if (num >= 6) {
                String pcscf = p.readString();
                this.riljLog("responseSetupDataCall got pcscf=" + pcscf);
                if (!TextUtils.isEmpty(pcscf)) {
                    dataCall.pcscf = pcscf.split(" ");
                }
            }
        } else {
            if (num != 1) {
                throw new RuntimeException("RIL_REQUEST_SETUP_DATA_CALL response expecting 1 RIL_Data_Call_response_v5 got " + num);
            }
            dataCall = this.getDataCallResponse(p, ver);
        }
        return dataCall;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseOperatorInfos(Parcel p) {
        String[] strings = (String[])this.responseStrings(p);
        if (strings.length % 4 != 0) {
            throw new RuntimeException("RIL_REQUEST_QUERY_AVAILABLE_NETWORKS: invalid response. Got " + strings.length + " strings, expected multible of 4");
        }
        ArrayList<OperatorInfo> ret = new ArrayList<OperatorInfo>(strings.length / 4);
        for (int i = 0; i < strings.length; i += 4) {
            ret.add(new OperatorInfo(strings[i + 0], strings[i + 1], strings[i + 2], strings[i + 3]));
        }
        return ret;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseCellList(Parcel p) {
        int num = p.readInt();
        ArrayList<NeighboringCellInfo> response = new ArrayList<NeighboringCellInfo>();
        int[] subId = SubscriptionManager.getSubId(this.mInstanceId);
        int radioType = ((TelephonyManager)this.mContext.getSystemService("phone")).getDataNetworkType(subId[0]);
        if (radioType != 0) {
            for (int i = 0; i < num; ++i) {
                int rssi = p.readInt();
                String location = p.readString();
                NeighboringCellInfo cell = new NeighboringCellInfo(rssi, location, radioType);
                response.add(cell);
            }
        }
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseGetPreferredNetworkType(Parcel p) {
        int[] response = (int[])this.responseInts(p);
        if (response.length >= 1) {
            this.mPreferredNetworkType = response[0];
        }
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseGmsBroadcastConfig(Parcel p) {
        int num = p.readInt();
        ArrayList<SmsBroadcastConfigInfo> response = new ArrayList<SmsBroadcastConfigInfo>(num);
        for (int i = 0; i < num; ++i) {
            int fromId = p.readInt();
            int toId = p.readInt();
            int fromScheme = p.readInt();
            int toScheme = p.readInt();
            boolean selected = p.readInt() == 1;
            SmsBroadcastConfigInfo info = new SmsBroadcastConfigInfo(fromId, toId, fromScheme, toScheme, selected);
            response.add(info);
        }
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseCdmaBroadcastConfig(Parcel p) {
        int[] response;
        int numServiceCategories = p.readInt();
        if (numServiceCategories == 0) {
            int numInts = 94;
            response = new int[numInts];
            response[0] = 31;
            for (int i = 1; i < numInts; i += 3) {
                response[i + 0] = i / 3;
                response[i + 1] = 1;
                response[i + 2] = 0;
            }
        } else {
            int numInts = numServiceCategories * 3 + 1;
            response = new int[numInts];
            response[0] = numServiceCategories;
            for (int i = 1; i < numInts; ++i) {
                response[i] = p.readInt();
            }
        }
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseSignalStrength(Parcel p) {
        SignalStrength signalStrength = SignalStrength.makeSignalStrengthFromRilParcel(p);
        return signalStrength;
    }

    private final ArrayList<CdmaInformationRecords> $$robo$$com_android_internal_telephony_RIL$responseCdmaInformationRecord(Parcel p) {
        int numberOfInfoRecs = p.readInt();
        ArrayList<CdmaInformationRecords> response = new ArrayList<CdmaInformationRecords>(numberOfInfoRecs);
        for (int i = 0; i < numberOfInfoRecs; ++i) {
            CdmaInformationRecords InfoRec = new CdmaInformationRecords(p);
            response.add(InfoRec);
        }
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseCdmaCallWaiting(Parcel p) {
        CdmaCallWaitingNotification notification = new CdmaCallWaitingNotification();
        notification.number = p.readString();
        notification.numberPresentation = CdmaCallWaitingNotification.presentationFromCLIP(p.readInt());
        notification.name = p.readString();
        notification.namePresentation = notification.numberPresentation;
        notification.isPresent = p.readInt();
        notification.signalType = p.readInt();
        notification.alertPitch = p.readInt();
        notification.signal = p.readInt();
        notification.numberType = p.readInt();
        notification.numberPlan = p.readInt();
        return notification;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseCallRing(Parcel p) {
        char[] response = new char[]{(char)p.readInt(), (char)p.readInt(), (char)p.readInt(), (char)p.readInt()};
        this.mEventLog.writeRilCallRing(response);
        return response;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$notifyRegistrantsCdmaInfoRec(CdmaInformationRecords infoRec) {
        int response = 1027;
        if (infoRec.record instanceof CdmaInformationRecords.CdmaDisplayInfoRec) {
            if (this.mDisplayInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mDisplayInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaSignalInfoRec) {
            if (this.mSignalInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mSignalInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaNumberInfoRec) {
            if (this.mNumberInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mNumberInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaRedirectingNumberInfoRec) {
            if (this.mRedirNumInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mRedirNumInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaLineControlInfoRec) {
            if (this.mLineControlInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mLineControlInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaT53ClirInfoRec) {
            if (this.mT53ClirInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mT53ClirInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaT53AudioControlInfoRec && this.mT53AudCntrlInfoRegistrants != null) {
            this.unsljLogRet(response, infoRec.record);
            this.mT53AudCntrlInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
        }
    }

    private final ArrayList<CellInfo> $$robo$$com_android_internal_telephony_RIL$responseCellInfoList(Parcel p) {
        int numberOfInfoRecs = p.readInt();
        ArrayList<CellInfo> response = new ArrayList<CellInfo>(numberOfInfoRecs);
        for (int i = 0; i < numberOfInfoRecs; ++i) {
            CellInfo InfoRec = CellInfo.CREATOR.createFromParcel(p);
            response.add(InfoRec);
        }
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseHardwareConfig(Parcel p) {
        int num = p.readInt();
        ArrayList<HardwareConfig> response = new ArrayList<HardwareConfig>(num);
        for (int i = 0; i < num; ++i) {
            HardwareConfig hw;
            int type = p.readInt();
            switch (type) {
                case 0: {
                    hw = new HardwareConfig(type);
                    hw.assignModem(p.readString(), p.readInt(), p.readInt(), p.readInt(), p.readInt(), p.readInt(), p.readInt());
                    break;
                }
                case 1: {
                    hw = new HardwareConfig(type);
                    hw.assignSim(p.readString(), p.readInt(), p.readString());
                    break;
                }
                default: {
                    throw new RuntimeException("RIL_REQUEST_GET_HARDWARE_CONFIG invalid hardward type:" + type);
                }
            }
            response.add(hw);
        }
        return response;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseRadioCapability(Parcel p) {
        int version = p.readInt();
        int session = p.readInt();
        int phase = p.readInt();
        int rat = p.readInt();
        String logicModemUuid = p.readString();
        int status = p.readInt();
        this.riljLog("responseRadioCapability: version= " + version + ", session=" + session + ", phase=" + phase + ", rat=" + rat + ", logicModemUuid=" + logicModemUuid + ", status=" + status);
        RadioCapability rc = new RadioCapability(this.mInstanceId, session, phase, rat, logicModemUuid, status);
        return rc;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseLceData(Parcel p) {
        ArrayList<Integer> capacityResponse = new ArrayList<Integer>();
        int capacityDownKbps = p.readInt();
        byte confidenceLevel = p.readByte();
        byte lceSuspended = p.readByte();
        this.riljLog("LCE capacity information received: capacity=" + capacityDownKbps + " confidence=" + confidenceLevel + " lceSuspended=" + lceSuspended);
        capacityResponse.add(capacityDownKbps);
        capacityResponse.add(Integer.valueOf(confidenceLevel));
        capacityResponse.add(Integer.valueOf(lceSuspended));
        return capacityResponse;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseLceStatus(Parcel p) {
        ArrayList<Integer> statusResponse = new ArrayList<Integer>();
        byte lceStatus = p.readByte();
        int actualInterval = p.readInt();
        this.riljLog("LCE status information received: lceStatus=" + lceStatus + " actualInterval=" + actualInterval);
        statusResponse.add(Integer.valueOf(lceStatus));
        statusResponse.add(actualInterval);
        return statusResponse;
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseActivityData(Parcel p) {
        int sleepModeTimeMs = p.readInt();
        int idleModeTimeMs = p.readInt();
        int[] txModeTimeMs = new int[5];
        for (int i = 0; i < 5; ++i) {
            txModeTimeMs[i] = p.readInt();
        }
        int rxModeTimeMs = p.readInt();
        this.riljLog("Modem activity info received: sleepModeTimeMs=" + sleepModeTimeMs + " idleModeTimeMs=" + idleModeTimeMs + " txModeTimeMs[]=" + Arrays.toString(txModeTimeMs) + " rxModeTimeMs=" + rxModeTimeMs);
        return new ModemActivityInfo(SystemClock.elapsedRealtime(), sleepModeTimeMs, idleModeTimeMs, txModeTimeMs, rxModeTimeMs, 0);
    }

    private static final String $$robo$$com_android_internal_telephony_RIL$requestToString(int request) {
        switch (request) {
            case 1: {
                return "GET_SIM_STATUS";
            }
            case 2: {
                return "ENTER_SIM_PIN";
            }
            case 3: {
                return "ENTER_SIM_PUK";
            }
            case 4: {
                return "ENTER_SIM_PIN2";
            }
            case 5: {
                return "ENTER_SIM_PUK2";
            }
            case 6: {
                return "CHANGE_SIM_PIN";
            }
            case 7: {
                return "CHANGE_SIM_PIN2";
            }
            case 8: {
                return "ENTER_NETWORK_DEPERSONALIZATION";
            }
            case 9: {
                return "GET_CURRENT_CALLS";
            }
            case 10: {
                return "DIAL";
            }
            case 11: {
                return "GET_IMSI";
            }
            case 12: {
                return "HANGUP";
            }
            case 13: {
                return "HANGUP_WAITING_OR_BACKGROUND";
            }
            case 14: {
                return "HANGUP_FOREGROUND_RESUME_BACKGROUND";
            }
            case 15: {
                return "REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
            }
            case 16: {
                return "CONFERENCE";
            }
            case 17: {
                return "UDUB";
            }
            case 18: {
                return "LAST_CALL_FAIL_CAUSE";
            }
            case 19: {
                return "SIGNAL_STRENGTH";
            }
            case 20: {
                return "VOICE_REGISTRATION_STATE";
            }
            case 21: {
                return "DATA_REGISTRATION_STATE";
            }
            case 22: {
                return "OPERATOR";
            }
            case 23: {
                return "RADIO_POWER";
            }
            case 24: {
                return "DTMF";
            }
            case 25: {
                return "SEND_SMS";
            }
            case 26: {
                return "SEND_SMS_EXPECT_MORE";
            }
            case 27: {
                return "SETUP_DATA_CALL";
            }
            case 28: {
                return "SIM_IO";
            }
            case 29: {
                return "SEND_USSD";
            }
            case 30: {
                return "CANCEL_USSD";
            }
            case 31: {
                return "GET_CLIR";
            }
            case 32: {
                return "SET_CLIR";
            }
            case 33: {
                return "QUERY_CALL_FORWARD_STATUS";
            }
            case 34: {
                return "SET_CALL_FORWARD";
            }
            case 35: {
                return "QUERY_CALL_WAITING";
            }
            case 36: {
                return "SET_CALL_WAITING";
            }
            case 37: {
                return "SMS_ACKNOWLEDGE";
            }
            case 38: {
                return "GET_IMEI";
            }
            case 39: {
                return "GET_IMEISV";
            }
            case 40: {
                return "ANSWER";
            }
            case 41: {
                return "DEACTIVATE_DATA_CALL";
            }
            case 42: {
                return "QUERY_FACILITY_LOCK";
            }
            case 43: {
                return "SET_FACILITY_LOCK";
            }
            case 44: {
                return "CHANGE_BARRING_PASSWORD";
            }
            case 45: {
                return "QUERY_NETWORK_SELECTION_MODE";
            }
            case 46: {
                return "SET_NETWORK_SELECTION_AUTOMATIC";
            }
            case 47: {
                return "SET_NETWORK_SELECTION_MANUAL";
            }
            case 48: {
                return "QUERY_AVAILABLE_NETWORKS ";
            }
            case 49: {
                return "DTMF_START";
            }
            case 50: {
                return "DTMF_STOP";
            }
            case 51: {
                return "BASEBAND_VERSION";
            }
            case 52: {
                return "SEPARATE_CONNECTION";
            }
            case 53: {
                return "SET_MUTE";
            }
            case 54: {
                return "GET_MUTE";
            }
            case 55: {
                return "QUERY_CLIP";
            }
            case 56: {
                return "LAST_DATA_CALL_FAIL_CAUSE";
            }
            case 57: {
                return "DATA_CALL_LIST";
            }
            case 58: {
                return "RESET_RADIO";
            }
            case 59: {
                return "OEM_HOOK_RAW";
            }
            case 60: {
                return "OEM_HOOK_STRINGS";
            }
            case 61: {
                return "SCREEN_STATE";
            }
            case 62: {
                return "SET_SUPP_SVC_NOTIFICATION";
            }
            case 63: {
                return "WRITE_SMS_TO_SIM";
            }
            case 64: {
                return "DELETE_SMS_ON_SIM";
            }
            case 65: {
                return "SET_BAND_MODE";
            }
            case 66: {
                return "QUERY_AVAILABLE_BAND_MODE";
            }
            case 67: {
                return "REQUEST_STK_GET_PROFILE";
            }
            case 68: {
                return "REQUEST_STK_SET_PROFILE";
            }
            case 69: {
                return "REQUEST_STK_SEND_ENVELOPE_COMMAND";
            }
            case 70: {
                return "REQUEST_STK_SEND_TERMINAL_RESPONSE";
            }
            case 71: {
                return "REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
            }
            case 72: {
                return "REQUEST_EXPLICIT_CALL_TRANSFER";
            }
            case 73: {
                return "REQUEST_SET_PREFERRED_NETWORK_TYPE";
            }
            case 74: {
                return "REQUEST_GET_PREFERRED_NETWORK_TYPE";
            }
            case 75: {
                return "REQUEST_GET_NEIGHBORING_CELL_IDS";
            }
            case 76: {
                return "REQUEST_SET_LOCATION_UPDATES";
            }
            case 77: {
                return "RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE";
            }
            case 78: {
                return "RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE";
            }
            case 79: {
                return "RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE";
            }
            case 80: {
                return "RIL_REQUEST_SET_TTY_MODE";
            }
            case 81: {
                return "RIL_REQUEST_QUERY_TTY_MODE";
            }
            case 82: {
                return "RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 83: {
                return "RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 84: {
                return "RIL_REQUEST_CDMA_FLASH";
            }
            case 85: {
                return "RIL_REQUEST_CDMA_BURST_DTMF";
            }
            case 87: {
                return "RIL_REQUEST_CDMA_SEND_SMS";
            }
            case 88: {
                return "RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE";
            }
            case 89: {
                return "RIL_REQUEST_GSM_GET_BROADCAST_CONFIG";
            }
            case 90: {
                return "RIL_REQUEST_GSM_SET_BROADCAST_CONFIG";
            }
            case 92: {
                return "RIL_REQUEST_CDMA_GET_BROADCAST_CONFIG";
            }
            case 93: {
                return "RIL_REQUEST_CDMA_SET_BROADCAST_CONFIG";
            }
            case 91: {
                return "RIL_REQUEST_GSM_BROADCAST_ACTIVATION";
            }
            case 86: {
                return "RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY";
            }
            case 94: {
                return "RIL_REQUEST_CDMA_BROADCAST_ACTIVATION";
            }
            case 95: {
                return "RIL_REQUEST_CDMA_SUBSCRIPTION";
            }
            case 96: {
                return "RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM";
            }
            case 97: {
                return "RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM";
            }
            case 98: {
                return "RIL_REQUEST_DEVICE_IDENTITY";
            }
            case 100: {
                return "RIL_REQUEST_GET_SMSC_ADDRESS";
            }
            case 101: {
                return "RIL_REQUEST_SET_SMSC_ADDRESS";
            }
            case 99: {
                return "REQUEST_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 102: {
                return "RIL_REQUEST_REPORT_SMS_MEMORY_STATUS";
            }
            case 103: {
                return "RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING";
            }
            case 104: {
                return "RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE";
            }
            case 105: {
                return "RIL_REQUEST_ISIM_AUTHENTICATION";
            }
            case 106: {
                return "RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU";
            }
            case 107: {
                return "RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS";
            }
            case 108: {
                return "RIL_REQUEST_VOICE_RADIO_TECH";
            }
            case 109: {
                return "RIL_REQUEST_GET_CELL_INFO_LIST";
            }
            case 110: {
                return "RIL_REQUEST_SET_CELL_INFO_LIST_RATE";
            }
            case 111: {
                return "RIL_REQUEST_SET_INITIAL_ATTACH_APN";
            }
            case 128: {
                return "RIL_REQUEST_SET_DATA_PROFILE";
            }
            case 112: {
                return "RIL_REQUEST_IMS_REGISTRATION_STATE";
            }
            case 113: {
                return "RIL_REQUEST_IMS_SEND_SMS";
            }
            case 114: {
                return "RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC";
            }
            case 115: {
                return "RIL_REQUEST_SIM_OPEN_CHANNEL";
            }
            case 116: {
                return "RIL_REQUEST_SIM_CLOSE_CHANNEL";
            }
            case 117: {
                return "RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL";
            }
            case 118: {
                return "RIL_REQUEST_NV_READ_ITEM";
            }
            case 119: {
                return "RIL_REQUEST_NV_WRITE_ITEM";
            }
            case 120: {
                return "RIL_REQUEST_NV_WRITE_CDMA_PRL";
            }
            case 121: {
                return "RIL_REQUEST_NV_RESET_CONFIG";
            }
            case 122: {
                return "RIL_REQUEST_SET_UICC_SUBSCRIPTION";
            }
            case 123: {
                return "RIL_REQUEST_ALLOW_DATA";
            }
            case 124: {
                return "GET_HARDWARE_CONFIG";
            }
            case 125: {
                return "RIL_REQUEST_SIM_AUTHENTICATION";
            }
            case 129: {
                return "RIL_REQUEST_SHUTDOWN";
            }
            case 131: {
                return "RIL_REQUEST_SET_RADIO_CAPABILITY";
            }
            case 130: {
                return "RIL_REQUEST_GET_RADIO_CAPABILITY";
            }
            case 132: {
                return "RIL_REQUEST_START_LCE";
            }
            case 133: {
                return "RIL_REQUEST_STOP_LCE";
            }
            case 134: {
                return "RIL_REQUEST_PULL_LCEDATA";
            }
            case 135: {
                return "RIL_REQUEST_GET_ACTIVITY_INFO";
            }
            case 800: {
                return "RIL_RESPONSE_ACKNOWLEDGEMENT";
            }
        }
        return "<unknown request>";
    }

    private static final String $$robo$$com_android_internal_telephony_RIL$responseToString(int request) {
        switch (request) {
            case 1000: {
                return "UNSOL_RESPONSE_RADIO_STATE_CHANGED";
            }
            case 1001: {
                return "UNSOL_RESPONSE_CALL_STATE_CHANGED";
            }
            case 1002: {
                return "UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED";
            }
            case 1003: {
                return "UNSOL_RESPONSE_NEW_SMS";
            }
            case 1004: {
                return "UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
            }
            case 1005: {
                return "UNSOL_RESPONSE_NEW_SMS_ON_SIM";
            }
            case 1006: {
                return "UNSOL_ON_USSD";
            }
            case 1007: {
                return "UNSOL_ON_USSD_REQUEST";
            }
            case 1008: {
                return "UNSOL_NITZ_TIME_RECEIVED";
            }
            case 1009: {
                return "UNSOL_SIGNAL_STRENGTH";
            }
            case 1010: {
                return "UNSOL_DATA_CALL_LIST_CHANGED";
            }
            case 1011: {
                return "UNSOL_SUPP_SVC_NOTIFICATION";
            }
            case 1012: {
                return "UNSOL_STK_SESSION_END";
            }
            case 1013: {
                return "UNSOL_STK_PROACTIVE_COMMAND";
            }
            case 1014: {
                return "UNSOL_STK_EVENT_NOTIFY";
            }
            case 1015: {
                return "UNSOL_STK_CALL_SETUP";
            }
            case 1016: {
                return "UNSOL_SIM_SMS_STORAGE_FULL";
            }
            case 1017: {
                return "UNSOL_SIM_REFRESH";
            }
            case 1018: {
                return "UNSOL_CALL_RING";
            }
            case 1019: {
                return "UNSOL_RESPONSE_SIM_STATUS_CHANGED";
            }
            case 1020: {
                return "UNSOL_RESPONSE_CDMA_NEW_SMS";
            }
            case 1021: {
                return "UNSOL_RESPONSE_NEW_BROADCAST_SMS";
            }
            case 1022: {
                return "UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
            }
            case 1023: {
                return "UNSOL_RESTRICTED_STATE_CHANGED";
            }
            case 1024: {
                return "UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
            }
            case 1025: {
                return "UNSOL_CDMA_CALL_WAITING";
            }
            case 1026: {
                return "UNSOL_CDMA_OTA_PROVISION_STATUS";
            }
            case 1027: {
                return "UNSOL_CDMA_INFO_REC";
            }
            case 1028: {
                return "UNSOL_OEM_HOOK_RAW";
            }
            case 1029: {
                return "UNSOL_RINGBACK_TONE";
            }
            case 1030: {
                return "UNSOL_RESEND_INCALL_MUTE";
            }
            case 1031: {
                return "CDMA_SUBSCRIPTION_SOURCE_CHANGED";
            }
            case 1032: {
                return "UNSOL_CDMA_PRL_CHANGED";
            }
            case 1033: {
                return "UNSOL_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 1034: {
                return "UNSOL_RIL_CONNECTED";
            }
            case 1035: {
                return "UNSOL_VOICE_RADIO_TECH_CHANGED";
            }
            case 1036: {
                return "UNSOL_CELL_INFO_LIST";
            }
            case 1037: {
                return "UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED";
            }
            case 1038: {
                return "RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED";
            }
            case 1039: {
                return "UNSOL_SRVCC_STATE_NOTIFY";
            }
            case 1040: {
                return "RIL_UNSOL_HARDWARE_CONFIG_CHANGED";
            }
            case 1042: {
                return "RIL_UNSOL_RADIO_CAPABILITY";
            }
            case 1043: {
                return "UNSOL_ON_SS";
            }
            case 1044: {
                return "UNSOL_STK_CC_ALPHA_NOTIFY";
            }
            case 1045: {
                return "UNSOL_LCE_INFO_RECV";
            }
        }
        return "<unknown response>";
    }

    private final void $$robo$$com_android_internal_telephony_RIL$riljLog(String msg) {
        Rlog.d("RILJ", msg + (this.mInstanceId != null ? " [SUB" + this.mInstanceId + "]" : ""));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$riljLogv(String msg) {
        Rlog.v("RILJ", msg + (this.mInstanceId != null ? " [SUB" + this.mInstanceId + "]" : ""));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$unsljLog(int response) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$unsljLogMore(int response, String more) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response) + " " + more);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$unsljLogRet(int response, Object ret) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response) + " " + RIL.retToString(response, ret));
    }

    private final void $$robo$$com_android_internal_telephony_RIL$unsljLogvRet(int response, Object ret) {
        this.riljLogv("[UNSL]< " + RIL.responseToString(response) + " " + RIL.retToString(response, ret));
    }

    private final Object $$robo$$com_android_internal_telephony_RIL$responseSsData(Parcel p) {
        SsData ssData = new SsData();
        ssData.serviceType = ssData.ServiceTypeFromRILInt(p.readInt());
        ssData.requestType = ssData.RequestTypeFromRILInt(p.readInt());
        ssData.teleserviceType = ssData.TeleserviceTypeFromRILInt(p.readInt());
        ssData.serviceClass = p.readInt();
        ssData.result = p.readInt();
        int num = p.readInt();
        if (ssData.serviceType.isTypeCF() && ssData.requestType.isTypeInterrogation()) {
            ssData.cfInfo = new CallForwardInfo[num];
            for (int i = 0; i < num; ++i) {
                ssData.cfInfo[i] = new CallForwardInfo();
                ssData.cfInfo[i].status = p.readInt();
                ssData.cfInfo[i].reason = p.readInt();
                ssData.cfInfo[i].serviceClass = p.readInt();
                ssData.cfInfo[i].toa = p.readInt();
                ssData.cfInfo[i].number = p.readString();
                ssData.cfInfo[i].timeSeconds = p.readInt();
                this.riljLog("[SS Data] CF Info " + i + " : " + ssData.cfInfo[i]);
            }
        } else {
            ssData.ssInfo = new int[num];
            for (int i = 0; i < num; ++i) {
                ssData.ssInfo[i] = p.readInt();
                this.riljLog("[SS Data] SS Info " + i + " : " + ssData.ssInfo[i]);
            }
        }
        return ssData;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getDeviceIdentity(Message response) {
        RILRequest rr = RILRequest.obtain(98, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCDMASubscription(Message response) {
        RILRequest rr = RILRequest.obtain(95, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setPhoneType(int phoneType) {
        this.riljLog("setPhoneType=" + phoneType + " old value=" + this.mPhoneType);
        this.mPhoneType = phoneType;
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryCdmaRoamingPreference(Message response) {
        RILRequest rr = RILRequest.obtain(79, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        RILRequest rr = RILRequest.obtain(78, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(cdmaRoamingType);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + cdmaRoamingType);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCdmaSubscriptionSource(int cdmaSubscription, Message response) {
        RILRequest rr = RILRequest.obtain(77, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(cdmaSubscription);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + cdmaSubscription);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCdmaSubscriptionSource(Message response) {
        RILRequest rr = RILRequest.obtain(104, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$queryTTYMode(Message response) {
        RILRequest rr = RILRequest.obtain(81, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setTTYMode(int ttyMode, Message response) {
        RILRequest rr = RILRequest.obtain(80, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(ttyMode);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + ttyMode);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$sendCDMAFeatureCode(String FeatureCode, Message response) {
        RILRequest rr = RILRequest.obtain(84, response);
        rr.mParcel.writeString(FeatureCode);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + FeatureCode);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCdmaBroadcastConfig(Message response) {
        RILRequest rr = RILRequest.obtain(92, response);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs, Message response) {
        int i;
        RILRequest rr = RILRequest.obtain(93, response);
        ArrayList<CdmaSmsBroadcastConfigInfo> processedConfigs = new ArrayList<CdmaSmsBroadcastConfigInfo>();
        for (CdmaSmsBroadcastConfigInfo config : configs) {
            for (int i2 = config.getFromServiceCategory(); i2 <= config.getToServiceCategory(); ++i2) {
                processedConfigs.add(new CdmaSmsBroadcastConfigInfo(i2, i2, config.getLanguage(), config.isSelected()));
            }
        }
        CdmaSmsBroadcastConfigInfo[] rilConfigs = processedConfigs.toArray(configs);
        rr.mParcel.writeInt(rilConfigs.length);
        for (i = 0; i < rilConfigs.length; ++i) {
            rr.mParcel.writeInt(rilConfigs[i].getFromServiceCategory());
            rr.mParcel.writeInt(rilConfigs[i].getLanguage());
            rr.mParcel.writeInt(rilConfigs[i].isSelected() ? 1 : 0);
        }
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + rilConfigs.length + " configs : ");
        for (i = 0; i < rilConfigs.length; ++i) {
            this.riljLog(rilConfigs[i].toString());
        }
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCdmaBroadcastActivation(boolean activate, Message response) {
        RILRequest rr = RILRequest.obtain(94, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(activate ? 0 : 1);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$exitEmergencyCallbackMode(Message response) {
        RILRequest rr = RILRequest.obtain(99, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$requestIsimAuthentication(String nonce, Message response) {
        RILRequest rr = RILRequest.obtain(105, response);
        rr.mParcel.writeString(nonce);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$requestIccSimAuthentication(int authContext, String data, String aid, Message response) {
        RILRequest rr = RILRequest.obtain(125, response);
        rr.mParcel.writeInt(authContext);
        rr.mParcel.writeString(data);
        rr.mParcel.writeString(aid);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getCellInfoList(Message result) {
        RILRequest rr = RILRequest.obtain(109, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setCellInfoListRate(int rateInMillis, Message response) {
        this.riljLog("setCellInfoListRate: " + rateInMillis);
        RILRequest rr = RILRequest.obtain(110, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(rateInMillis);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setInitialAttachApn(String apn, String protocol, int authType, String username, String password, Message result) {
        RILRequest rr = RILRequest.obtain(111, result);
        this.riljLog("Set RIL_REQUEST_SET_INITIAL_ATTACH_APN");
        rr.mParcel.writeString(apn);
        rr.mParcel.writeString(protocol);
        rr.mParcel.writeInt(authType);
        rr.mParcel.writeString(username);
        rr.mParcel.writeString(password);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ", apn:" + apn + ", protocol:" + protocol + ", authType:" + authType + ", username:" + username + ", password:" + password);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setDataProfile(DataProfile[] dps, Message result) {
        this.riljLog("Set RIL_REQUEST_SET_DATA_PROFILE");
        RILRequest rr = RILRequest.obtain(128, null);
        DataProfile.toParcel(rr.mParcel, dps);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + dps + " Data Profiles : ");
        for (int i = 0; i < dps.length; ++i) {
            this.riljLog(dps[i].toString());
        }
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$testingEmergencyCall() {
        this.riljLog("testingEmergencyCall");
        this.mTestingEmergencyCall.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RIL$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("RIL: " + this);
        pw.println(" mSocket=" + this.mSocket);
        pw.println(" mSenderThread=" + this.mSenderThread);
        pw.println(" mSender=" + this.mSender);
        pw.println(" mReceiverThread=" + this.mReceiverThread);
        pw.println(" mReceiver=" + this.mReceiver);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mWakeLockTimeout=" + this.mWakeLockTimeout);
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            PowerManager.WakeLock wakeLock = this.mWakeLock;
            synchronized (wakeLock) {
                pw.println(" mWakeLockCount=" + this.mWakeLockCount);
            }
            int count = this.mRequestList.size();
            pw.println(" mRequestList count=" + count);
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                pw.println("  [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
            }
        }
        pw.println(" mLastNITZTimeInfo=" + Arrays.toString(this.mLastNITZTimeInfo));
        pw.println(" mTestingEmergencyCall=" + this.mTestingEmergencyCall.get());
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccOpenLogicalChannel(String AID, Message response) {
        RILRequest rr = RILRequest.obtain(115, response);
        rr.mParcel.writeString(AID);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccCloseLogicalChannel(int channel, Message response) {
        RILRequest rr = RILRequest.obtain(116, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(channel);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        if (channel <= 0) {
            throw new RuntimeException("Invalid channel in iccTransmitApduLogicalChannel: " + channel);
        }
        this.iccTransmitApduHelper(117, channel, cla, instruction, p1, p2, p3, data, response);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        this.iccTransmitApduHelper(114, 0, cla, instruction, p1, p2, p3, data, response);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$iccTransmitApduHelper(int rilCommand, int channel, int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        RILRequest rr = RILRequest.obtain(rilCommand, response);
        rr.mParcel.writeInt(channel);
        rr.mParcel.writeInt(cla);
        rr.mParcel.writeInt(instruction);
        rr.mParcel.writeInt(p1);
        rr.mParcel.writeInt(p2);
        rr.mParcel.writeInt(p3);
        rr.mParcel.writeString(data);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$nvReadItem(int itemID, Message response) {
        RILRequest rr = RILRequest.obtain(118, response);
        rr.mParcel.writeInt(itemID);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ' ' + itemID);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$nvWriteItem(int itemID, String itemValue, Message response) {
        RILRequest rr = RILRequest.obtain(119, response);
        rr.mParcel.writeInt(itemID);
        rr.mParcel.writeString(itemValue);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ' ' + itemID + ": " + itemValue);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        RILRequest rr = RILRequest.obtain(120, response);
        rr.mParcel.writeByteArray(preferredRoamingList);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " (" + preferredRoamingList.length + " bytes)");
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$nvResetConfig(int resetType, Message response) {
        RILRequest rr = RILRequest.obtain(121, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(resetType);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ' ' + resetType);
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$setRadioCapability(RadioCapability rc, Message response) {
        RILRequest rr = RILRequest.obtain(131, response);
        rr.mParcel.writeInt(rc.getVersion());
        rr.mParcel.writeInt(rc.getSession());
        rr.mParcel.writeInt(rc.getPhase());
        rr.mParcel.writeInt(rc.getRadioAccessFamily());
        rr.mParcel.writeString(rc.getLogicalModemUuid());
        rr.mParcel.writeInt(rc.getStatus());
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + rc.toString());
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getRadioCapability(Message response) {
        RILRequest rr = RILRequest.obtain(130, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$startLceService(int reportIntervalMs, boolean pullMode, Message response) {
        RILRequest rr = RILRequest.obtain(132, response);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeInt(reportIntervalMs);
        rr.mParcel.writeInt(pullMode ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$stopLceService(Message response) {
        RILRequest rr = RILRequest.obtain(133, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$pullLceData(Message response) {
        RILRequest rr = RILRequest.obtain(134, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private final void $$robo$$com_android_internal_telephony_RIL$getModemActivityInfo(Message response) {
        RILRequest rr = RILRequest.obtain(135, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
        Message msg = this.mSender.obtainMessage(5);
        msg.obj = null;
        msg.arg1 = rr.mSerial;
        this.mSender.sendMessageDelayed(msg, 2000L);
    }

    static void __staticInitializer__() {
        SOCKET_NAME_RIL = new String[]{"rild", "rild2", "rild3"};
    }

    private static Object getResponseForTimedOutRILRequest(RILRequest rILRequest) {
        return InvokeDynamicSupport.bootstrapStatic("getResponseForTimedOutRILRequest", $$robo$$com_android_internal_telephony_RIL$getResponseForTimedOutRILRequest(com.android.internal.telephony.RILRequest ), 0, (RILRequest)rILRequest);
    }

    private static int readRilMessage(InputStream inputStream, byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("readRilMessage", $$robo$$com_android_internal_telephony_RIL$readRilMessage(java.io.InputStream byte[] ), 0, (InputStream)inputStream, (byte[])byArray);
    }

    private void __constructor__(Context context, int n, int n2) {
        this.$$robo$$com_android_internal_telephony_RIL$__constructor__(context, n, n2);
    }

    public RIL(Context context, int n, int n2) {
        this(context, n, n2, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL$__constructor__(android.content.Context int int ), 0, this, context, n, n2);
    }

    private void __constructor__(Context context, int n, int n2, Integer n3) {
        this.$$robo$$com_android_internal_telephony_RIL$__constructor__(context, n, n2, n3);
    }

    public RIL(Context context, int n, int n2, Integer n3) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL$__constructor__(android.content.Context int int java.lang.Integer ), 0, this, context, n, n2, n3);
    }

    @Override
    public void getVoiceRadioTechnology(Message message) {
        InvokeDynamicSupport.bootstrap("getVoiceRadioTechnology", $$robo$$com_android_internal_telephony_RIL$getVoiceRadioTechnology(android.os.Message ), 0, this, message);
    }

    @Override
    public void getImsRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getImsRegistrationState", $$robo$$com_android_internal_telephony_RIL$getImsRegistrationState(android.os.Message ), 0, this, message);
    }

    @Override
    public void setOnNITZTime(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnNITZTime", $$robo$$com_android_internal_telephony_RIL$setOnNITZTime(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void getIccCardStatus(Message message) {
        InvokeDynamicSupport.bootstrap("getIccCardStatus", $$robo$$com_android_internal_telephony_RIL$getIccCardStatus(android.os.Message ), 0, this, message);
    }

    @Override
    public void setUiccSubscription(int n, int n2, int n3, int n4, Message message) {
        InvokeDynamicSupport.bootstrap("setUiccSubscription", $$robo$$com_android_internal_telephony_RIL$setUiccSubscription(int int int int android.os.Message ), 0, this, n, n2, n3, n4, message);
    }

    @Override
    public void setDataAllowed(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setDataAllowed", $$robo$$com_android_internal_telephony_RIL$setDataAllowed(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void supplyIccPin(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin", $$robo$$com_android_internal_telephony_RIL$supplyIccPin(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void supplyIccPinForApp(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPinForApp", $$robo$$com_android_internal_telephony_RIL$supplyIccPinForApp(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyIccPuk(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk", $$robo$$com_android_internal_telephony_RIL$supplyIccPuk(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyIccPukForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPukForApp", $$robo$$com_android_internal_telephony_RIL$supplyIccPukForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void supplyIccPin2(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin2", $$robo$$com_android_internal_telephony_RIL$supplyIccPin2(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void supplyIccPin2ForApp(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin2ForApp", $$robo$$com_android_internal_telephony_RIL$supplyIccPin2ForApp(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyIccPuk2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk2", $$robo$$com_android_internal_telephony_RIL$supplyIccPuk2(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyIccPuk2ForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk2ForApp", $$robo$$com_android_internal_telephony_RIL$supplyIccPuk2ForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void changeIccPin(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin", $$robo$$com_android_internal_telephony_RIL$changeIccPin(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void changeIccPinForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPinForApp", $$robo$$com_android_internal_telephony_RIL$changeIccPinForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void changeIccPin2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin2", $$robo$$com_android_internal_telephony_RIL$changeIccPin2(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void changeIccPin2ForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin2ForApp", $$robo$$com_android_internal_telephony_RIL$changeIccPin2ForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void changeBarringPassword(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeBarringPassword", $$robo$$com_android_internal_telephony_RIL$changeBarringPassword(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyNetworkDepersonalization", $$robo$$com_android_internal_telephony_RIL$supplyNetworkDepersonalization(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void getCurrentCalls(Message message) {
        InvokeDynamicSupport.bootstrap("getCurrentCalls", $$robo$$com_android_internal_telephony_RIL$getCurrentCalls(android.os.Message ), 0, this, message);
    }

    @Override
    @Deprecated
    public void getPDPContextList(Message message) {
        InvokeDynamicSupport.bootstrap("getPDPContextList", $$robo$$com_android_internal_telephony_RIL$getPDPContextList(android.os.Message ), 0, this, message);
    }

    @Override
    public void getDataCallList(Message message) {
        InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_RIL$getDataCallList(android.os.Message ), 0, this, message);
    }

    @Override
    public void dial(String string2, int n, Message message) {
        InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_RIL$dial(java.lang.String int android.os.Message ), 0, this, string2, n, message);
    }

    @Override
    public void dial(String string2, int n, UUSInfo uUSInfo, Message message) {
        InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_RIL$dial(java.lang.String int com.android.internal.telephony.UUSInfo android.os.Message ), 0, this, string2, n, uUSInfo, message);
    }

    @Override
    public void getIMSI(Message message) {
        InvokeDynamicSupport.bootstrap("getIMSI", $$robo$$com_android_internal_telephony_RIL$getIMSI(android.os.Message ), 0, this, message);
    }

    @Override
    public void getIMSIForApp(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("getIMSIForApp", $$robo$$com_android_internal_telephony_RIL$getIMSIForApp(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void getIMEI(Message message) {
        InvokeDynamicSupport.bootstrap("getIMEI", $$robo$$com_android_internal_telephony_RIL$getIMEI(android.os.Message ), 0, this, message);
    }

    @Override
    public void getIMEISV(Message message) {
        InvokeDynamicSupport.bootstrap("getIMEISV", $$robo$$com_android_internal_telephony_RIL$getIMEISV(android.os.Message ), 0, this, message);
    }

    @Override
    public void hangupConnection(int n, Message message) {
        InvokeDynamicSupport.bootstrap("hangupConnection", $$robo$$com_android_internal_telephony_RIL$hangupConnection(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void hangupWaitingOrBackground(Message message) {
        InvokeDynamicSupport.bootstrap("hangupWaitingOrBackground", $$robo$$com_android_internal_telephony_RIL$hangupWaitingOrBackground(android.os.Message ), 0, this, message);
    }

    @Override
    public void hangupForegroundResumeBackground(Message message) {
        InvokeDynamicSupport.bootstrap("hangupForegroundResumeBackground", $$robo$$com_android_internal_telephony_RIL$hangupForegroundResumeBackground(android.os.Message ), 0, this, message);
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message message) {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_RIL$switchWaitingOrHoldingAndActive(android.os.Message ), 0, this, message);
    }

    @Override
    public void conference(Message message) {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_RIL$conference(android.os.Message ), 0, this, message);
    }

    @Override
    public void setPreferredVoicePrivacy(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredVoicePrivacy", $$robo$$com_android_internal_telephony_RIL$setPreferredVoicePrivacy(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getPreferredVoicePrivacy(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredVoicePrivacy", $$robo$$com_android_internal_telephony_RIL$getPreferredVoicePrivacy(android.os.Message ), 0, this, message);
    }

    @Override
    public void separateConnection(int n, Message message) {
        InvokeDynamicSupport.bootstrap("separateConnection", $$robo$$com_android_internal_telephony_RIL$separateConnection(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void acceptCall(Message message) {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_RIL$acceptCall(android.os.Message ), 0, this, message);
    }

    @Override
    public void rejectCall(Message message) {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_RIL$rejectCall(android.os.Message ), 0, this, message);
    }

    @Override
    public void explicitCallTransfer(Message message) {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_RIL$explicitCallTransfer(android.os.Message ), 0, this, message);
    }

    @Override
    public void getLastCallFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastCallFailCause", $$robo$$com_android_internal_telephony_RIL$getLastCallFailCause(android.os.Message ), 0, this, message);
    }

    @Override
    @Deprecated
    public void getLastPdpFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastPdpFailCause", $$robo$$com_android_internal_telephony_RIL$getLastPdpFailCause(android.os.Message ), 0, this, message);
    }

    @Override
    public void getLastDataCallFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastDataCallFailCause", $$robo$$com_android_internal_telephony_RIL$getLastDataCallFailCause(android.os.Message ), 0, this, message);
    }

    @Override
    public void setMute(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_RIL$setMute(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getMute(Message message) {
        InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_RIL$getMute(android.os.Message ), 0, this, message);
    }

    @Override
    public void getSignalStrength(Message message) {
        InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$com_android_internal_telephony_RIL$getSignalStrength(android.os.Message ), 0, this, message);
    }

    @Override
    public void getVoiceRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getVoiceRegistrationState", $$robo$$com_android_internal_telephony_RIL$getVoiceRegistrationState(android.os.Message ), 0, this, message);
    }

    @Override
    public void getDataRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getDataRegistrationState", $$robo$$com_android_internal_telephony_RIL$getDataRegistrationState(android.os.Message ), 0, this, message);
    }

    @Override
    public void getOperator(Message message) {
        InvokeDynamicSupport.bootstrap("getOperator", $$robo$$com_android_internal_telephony_RIL$getOperator(android.os.Message ), 0, this, message);
    }

    @Override
    public void getHardwareConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getHardwareConfig", $$robo$$com_android_internal_telephony_RIL$getHardwareConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void sendDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_RIL$sendDtmf(char android.os.Message ), 0, this, c, message);
    }

    @Override
    public void startDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_RIL$startDtmf(char android.os.Message ), 0, this, c, message);
    }

    @Override
    public void stopDtmf(Message message) {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_RIL$stopDtmf(android.os.Message ), 0, this, message);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_RIL$sendBurstDtmf(java.lang.String int int android.os.Message ), 0, this, string2, n, n2, message);
    }

    private void constructGsmSendSmsRilRequest(RILRequest rILRequest, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("constructGsmSendSmsRilRequest", $$robo$$com_android_internal_telephony_RIL$constructGsmSendSmsRilRequest(com.android.internal.telephony.RILRequest java.lang.String java.lang.String ), 0, this, rILRequest, string2, string3);
    }

    @Override
    public void sendSMS(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("sendSMS", $$robo$$com_android_internal_telephony_RIL$sendSMS(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void sendSMSExpectMore(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("sendSMSExpectMore", $$robo$$com_android_internal_telephony_RIL$sendSMSExpectMore(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    private void constructCdmaSendSmsRilRequest(RILRequest rILRequest, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("constructCdmaSendSmsRilRequest", $$robo$$com_android_internal_telephony_RIL$constructCdmaSendSmsRilRequest(com.android.internal.telephony.RILRequest byte[] ), 0, this, rILRequest, byArray);
    }

    @Override
    public void sendCdmaSms(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("sendCdmaSms", $$robo$$com_android_internal_telephony_RIL$sendCdmaSms(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void sendImsGsmSms(String string2, String string3, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendImsGsmSms", $$robo$$com_android_internal_telephony_RIL$sendImsGsmSms(java.lang.String java.lang.String int int android.os.Message ), 0, this, string2, string3, n, n2, message);
    }

    @Override
    public void sendImsCdmaSms(byte[] byArray, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendImsCdmaSms", $$robo$$com_android_internal_telephony_RIL$sendImsCdmaSms(byte[] int int android.os.Message ), 0, this, byArray, n, n2, message);
    }

    @Override
    public void deleteSmsOnSim(int n, Message message) {
        InvokeDynamicSupport.bootstrap("deleteSmsOnSim", $$robo$$com_android_internal_telephony_RIL$deleteSmsOnSim(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void deleteSmsOnRuim(int n, Message message) {
        InvokeDynamicSupport.bootstrap("deleteSmsOnRuim", $$robo$$com_android_internal_telephony_RIL$deleteSmsOnRuim(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void writeSmsToSim(int n, String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("writeSmsToSim", $$robo$$com_android_internal_telephony_RIL$writeSmsToSim(int java.lang.String java.lang.String android.os.Message ), 0, this, n, string2, string3, message);
    }

    @Override
    public void writeSmsToRuim(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("writeSmsToRuim", $$robo$$com_android_internal_telephony_RIL$writeSmsToRuim(int java.lang.String android.os.Message ), 0, this, n, string2, message);
    }

    private int translateStatus(int n) {
        return (int)InvokeDynamicSupport.bootstrap("translateStatus", $$robo$$com_android_internal_telephony_RIL$translateStatus(int ), 0, this, n);
    }

    @Override
    public void setupDataCall(int n, int n2, String string2, String string3, String string4, int n3, String string5, Message message) {
        InvokeDynamicSupport.bootstrap("setupDataCall", $$robo$$com_android_internal_telephony_RIL$setupDataCall(int int java.lang.String java.lang.String java.lang.String int java.lang.String android.os.Message ), 0, this, n, n2, string2, string3, string4, n3, string5, message);
    }

    @Override
    public void deactivateDataCall(int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("deactivateDataCall", $$robo$$com_android_internal_telephony_RIL$deactivateDataCall(int int android.os.Message ), 0, this, n, n2, message);
    }

    @Override
    public void setRadioPower(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$com_android_internal_telephony_RIL$setRadioPower(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void requestShutdown(Message message) {
        InvokeDynamicSupport.bootstrap("requestShutdown", $$robo$$com_android_internal_telephony_RIL$requestShutdown(android.os.Message ), 0, this, message);
    }

    @Override
    public void setSuppServiceNotifications(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setSuppServiceNotifications", $$robo$$com_android_internal_telephony_RIL$setSuppServiceNotifications(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void acknowledgeLastIncomingGsmSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingGsmSms", $$robo$$com_android_internal_telephony_RIL$acknowledgeLastIncomingGsmSms(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingCdmaSms", $$robo$$com_android_internal_telephony_RIL$acknowledgeLastIncomingCdmaSms(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    @Override
    public void acknowledgeIncomingGsmSmsWithPdu(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeIncomingGsmSmsWithPdu", $$robo$$com_android_internal_telephony_RIL$acknowledgeIncomingGsmSmsWithPdu(boolean java.lang.String android.os.Message ), 0, this, bl, string2, message);
    }

    @Override
    public void iccIO(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("iccIO", $$robo$$com_android_internal_telephony_RIL$iccIO(int int java.lang.String int int int java.lang.String java.lang.String android.os.Message ), 0, this, n, n2, string2, n3, n4, n5, string3, string4, message);
    }

    @Override
    public void iccIOForApp(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, String string5, Message message) {
        InvokeDynamicSupport.bootstrap("iccIOForApp", $$robo$$com_android_internal_telephony_RIL$iccIOForApp(int int java.lang.String int int int java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, n, n2, string2, n3, n4, n5, string3, string4, string5, message);
    }

    @Override
    public void getCLIR(Message message) {
        InvokeDynamicSupport.bootstrap("getCLIR", $$robo$$com_android_internal_telephony_RIL$getCLIR(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCLIR(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCLIR", $$robo$$com_android_internal_telephony_RIL$setCLIR(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryCallWaiting(int n, Message message) {
        InvokeDynamicSupport.bootstrap("queryCallWaiting", $$robo$$com_android_internal_telephony_RIL$queryCallWaiting(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCallWaiting(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_RIL$setCallWaiting(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeAutomatic", $$robo$$com_android_internal_telephony_RIL$setNetworkSelectionModeAutomatic(android.os.Message ), 0, this, message);
    }

    @Override
    public void setNetworkSelectionModeManual(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeManual", $$robo$$com_android_internal_telephony_RIL$setNetworkSelectionModeManual(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void getNetworkSelectionMode(Message message) {
        InvokeDynamicSupport.bootstrap("getNetworkSelectionMode", $$robo$$com_android_internal_telephony_RIL$getNetworkSelectionMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworks", $$robo$$com_android_internal_telephony_RIL$getAvailableNetworks(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCallForward(int n, int n2, int n3, String string2, int n4, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForward", $$robo$$com_android_internal_telephony_RIL$setCallForward(int int int java.lang.String int android.os.Message ), 0, this, n, n2, n3, string2, n4, message);
    }

    @Override
    public void queryCallForwardStatus(int n, int n2, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("queryCallForwardStatus", $$robo$$com_android_internal_telephony_RIL$queryCallForwardStatus(int int java.lang.String android.os.Message ), 0, this, n, n2, string2, message);
    }

    @Override
    public void queryCLIP(Message message) {
        InvokeDynamicSupport.bootstrap("queryCLIP", $$robo$$com_android_internal_telephony_RIL$queryCLIP(android.os.Message ), 0, this, message);
    }

    @Override
    public void getBasebandVersion(Message message) {
        InvokeDynamicSupport.bootstrap("getBasebandVersion", $$robo$$com_android_internal_telephony_RIL$getBasebandVersion(android.os.Message ), 0, this, message);
    }

    @Override
    public void queryFacilityLock(String string2, String string3, int n, Message message) {
        InvokeDynamicSupport.bootstrap("queryFacilityLock", $$robo$$com_android_internal_telephony_RIL$queryFacilityLock(java.lang.String java.lang.String int android.os.Message ), 0, this, string2, string3, n, message);
    }

    @Override
    public void queryFacilityLockForApp(String string2, String string3, int n, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("queryFacilityLockForApp", $$robo$$com_android_internal_telephony_RIL$queryFacilityLockForApp(java.lang.String java.lang.String int java.lang.String android.os.Message ), 0, this, string2, string3, n, string4, message);
    }

    @Override
    public void setFacilityLock(String string2, boolean bl, String string3, int n, Message message) {
        InvokeDynamicSupport.bootstrap("setFacilityLock", $$robo$$com_android_internal_telephony_RIL$setFacilityLock(java.lang.String boolean java.lang.String int android.os.Message ), 0, this, string2, bl, string3, n, message);
    }

    @Override
    public void setFacilityLockForApp(String string2, boolean bl, String string3, int n, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("setFacilityLockForApp", $$robo$$com_android_internal_telephony_RIL$setFacilityLockForApp(java.lang.String boolean java.lang.String int java.lang.String android.os.Message ), 0, this, string2, bl, string3, n, string4, message);
    }

    @Override
    public void sendUSSD(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendUSSD", $$robo$$com_android_internal_telephony_RIL$sendUSSD(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void cancelPendingUssd(Message message) {
        InvokeDynamicSupport.bootstrap("cancelPendingUssd", $$robo$$com_android_internal_telephony_RIL$cancelPendingUssd(android.os.Message ), 0, this, message);
    }

    @Override
    public void resetRadio(Message message) {
        InvokeDynamicSupport.bootstrap("resetRadio", $$robo$$com_android_internal_telephony_RIL$resetRadio(android.os.Message ), 0, this, message);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestRaw", $$robo$$com_android_internal_telephony_RIL$invokeOemRilRequestRaw(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestStrings", $$robo$$com_android_internal_telephony_RIL$invokeOemRilRequestStrings(java.lang.String[] android.os.Message ), 0, this, stringArray, message);
    }

    @Override
    public void setBandMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setBandMode", $$robo$$com_android_internal_telephony_RIL$setBandMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryAvailableBandMode", $$robo$$com_android_internal_telephony_RIL$queryAvailableBandMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void sendTerminalResponse(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendTerminalResponse", $$robo$$com_android_internal_telephony_RIL$sendTerminalResponse(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void sendEnvelope(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendEnvelope", $$robo$$com_android_internal_telephony_RIL$sendEnvelope(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void sendEnvelopeWithStatus(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatus", $$robo$$com_android_internal_telephony_RIL$sendEnvelopeWithStatus(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void handleCallSetupRequestFromSim(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("handleCallSetupRequestFromSim", $$robo$$com_android_internal_telephony_RIL$handleCallSetupRequestFromSim(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredNetworkType", $$robo$$com_android_internal_telephony_RIL$setPreferredNetworkType(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredNetworkType", $$robo$$com_android_internal_telephony_RIL$getPreferredNetworkType(android.os.Message ), 0, this, message);
    }

    @Override
    public void getNeighboringCids(Message message) {
        InvokeDynamicSupport.bootstrap("getNeighboringCids", $$robo$$com_android_internal_telephony_RIL$getNeighboringCids(android.os.Message ), 0, this, message);
    }

    @Override
    public void setLocationUpdates(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setLocationUpdates", $$robo$$com_android_internal_telephony_RIL$setLocationUpdates(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getSmscAddress(Message message) {
        InvokeDynamicSupport.bootstrap("getSmscAddress", $$robo$$com_android_internal_telephony_RIL$getSmscAddress(android.os.Message ), 0, this, message);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setSmscAddress", $$robo$$com_android_internal_telephony_RIL$setSmscAddress(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void reportSmsMemoryStatus(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("reportSmsMemoryStatus", $$robo$$com_android_internal_telephony_RIL$reportSmsMemoryStatus(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void reportStkServiceIsRunning(Message message) {
        InvokeDynamicSupport.bootstrap("reportStkServiceIsRunning", $$robo$$com_android_internal_telephony_RIL$reportStkServiceIsRunning(android.os.Message ), 0, this, message);
    }

    @Override
    public void getGsmBroadcastConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getGsmBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$getGsmBroadcastConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] smsBroadcastConfigInfoArray, Message message) {
        InvokeDynamicSupport.bootstrap("setGsmBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$setGsmBroadcastConfig(com.android.internal.telephony.gsm.SmsBroadcastConfigInfo[] android.os.Message ), 0, this, smsBroadcastConfigInfoArray, message);
    }

    @Override
    public void setGsmBroadcastActivation(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setGsmBroadcastActivation", $$robo$$com_android_internal_telephony_RIL$setGsmBroadcastActivation(boolean android.os.Message ), 0, this, bl, message);
    }

    private void updateScreenState() {
        InvokeDynamicSupport.bootstrap("updateScreenState", $$robo$$com_android_internal_telephony_RIL$updateScreenState(), 0, this);
    }

    private void sendScreenState(boolean bl) {
        InvokeDynamicSupport.bootstrap("sendScreenState", $$robo$$com_android_internal_telephony_RIL$sendScreenState(boolean ), 0, this, bl);
    }

    @Override
    protected void onRadioAvailable() {
        InvokeDynamicSupport.bootstrap("onRadioAvailable", $$robo$$com_android_internal_telephony_RIL$onRadioAvailable(), 0, this);
    }

    private CommandsInterface.RadioState getRadioStateFromInt(int n) {
        return InvokeDynamicSupport.bootstrap("getRadioStateFromInt", $$robo$$com_android_internal_telephony_RIL$getRadioStateFromInt(int ), 0, this, n);
    }

    private void switchToRadioState(CommandsInterface.RadioState radioState) {
        InvokeDynamicSupport.bootstrap("switchToRadioState", $$robo$$com_android_internal_telephony_RIL$switchToRadioState(com.android.internal.telephony.CommandsInterface$RadioState ), 0, this, radioState);
    }

    private void acquireWakeLock(RILRequest rILRequest, int n) {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$com_android_internal_telephony_RIL$acquireWakeLock(com.android.internal.telephony.RILRequest int ), 0, this, rILRequest, n);
    }

    private void decrementWakeLock(RILRequest rILRequest) {
        InvokeDynamicSupport.bootstrap("decrementWakeLock", $$robo$$com_android_internal_telephony_RIL$decrementWakeLock(com.android.internal.telephony.RILRequest ), 0, this, rILRequest);
    }

    private boolean clearWakeLock(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearWakeLock", $$robo$$com_android_internal_telephony_RIL$clearWakeLock(int ), 0, this, n);
    }

    private void send(RILRequest rILRequest) {
        InvokeDynamicSupport.bootstrap("send", $$robo$$com_android_internal_telephony_RIL$send(com.android.internal.telephony.RILRequest ), 0, this, rILRequest);
    }

    private void processResponse(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("processResponse", $$robo$$com_android_internal_telephony_RIL$processResponse(android.os.Parcel ), 0, this, parcel);
    }

    private void clearRequestList(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("clearRequestList", $$robo$$com_android_internal_telephony_RIL$clearRequestList(int boolean ), 0, this, n, bl);
    }

    private RILRequest findAndRemoveRequestFromList(int n) {
        return InvokeDynamicSupport.bootstrap("findAndRemoveRequestFromList", $$robo$$com_android_internal_telephony_RIL$findAndRemoveRequestFromList(int ), 0, this, n);
    }

    private RILRequest processSolicited(Parcel parcel, int n) {
        return InvokeDynamicSupport.bootstrap("processSolicited", $$robo$$com_android_internal_telephony_RIL$processSolicited(android.os.Parcel int ), 0, this, parcel, n);
    }

    private RadioCapability makeStaticRadioCapability() {
        return InvokeDynamicSupport.bootstrap("makeStaticRadioCapability", $$robo$$com_android_internal_telephony_RIL$makeStaticRadioCapability(), 0, this);
    }

    static String retToString(int n, Object object) {
        return InvokeDynamicSupport.bootstrapStatic("retToString", $$robo$$com_android_internal_telephony_RIL$retToString(int java.lang.Object ), 0, (int)n, (Object)object);
    }

    private void processUnsolicited(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("processUnsolicited", $$robo$$com_android_internal_telephony_RIL$processUnsolicited(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void notifyRegistrantsRilConnectionChanged(int n) {
        InvokeDynamicSupport.bootstrap("notifyRegistrantsRilConnectionChanged", $$robo$$com_android_internal_telephony_RIL$notifyRegistrantsRilConnectionChanged(int ), 0, this, n);
    }

    private Object responseInts(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseInts", $$robo$$com_android_internal_telephony_RIL$responseInts(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseFailCause(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseFailCause", $$robo$$com_android_internal_telephony_RIL$responseFailCause(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseVoid(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseVoid", $$robo$$com_android_internal_telephony_RIL$responseVoid(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseCallForward(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCallForward", $$robo$$com_android_internal_telephony_RIL$responseCallForward(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseSuppServiceNotification(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseSuppServiceNotification", $$robo$$com_android_internal_telephony_RIL$responseSuppServiceNotification(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseCdmaSms(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCdmaSms", $$robo$$com_android_internal_telephony_RIL$responseCdmaSms(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseString(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseString", $$robo$$com_android_internal_telephony_RIL$responseString(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseStrings(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseStrings", $$robo$$com_android_internal_telephony_RIL$responseStrings(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseRaw(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseRaw", $$robo$$com_android_internal_telephony_RIL$responseRaw(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseSMS(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseSMS", $$robo$$com_android_internal_telephony_RIL$responseSMS(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseICC_IO(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseICC_IO", $$robo$$com_android_internal_telephony_RIL$responseICC_IO(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseICC_IOBase64(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseICC_IOBase64", $$robo$$com_android_internal_telephony_RIL$responseICC_IOBase64(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseIccCardStatus(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseIccCardStatus", $$robo$$com_android_internal_telephony_RIL$responseIccCardStatus(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseSimRefresh(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseSimRefresh", $$robo$$com_android_internal_telephony_RIL$responseSimRefresh(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseCallList(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCallList", $$robo$$com_android_internal_telephony_RIL$responseCallList(android.os.Parcel ), 0, this, parcel);
    }

    private DataCallResponse getDataCallResponse(Parcel parcel, int n) {
        return InvokeDynamicSupport.bootstrap("getDataCallResponse", $$robo$$com_android_internal_telephony_RIL$getDataCallResponse(android.os.Parcel int ), 0, this, parcel, n);
    }

    private Object responseDataCallList(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseDataCallList", $$robo$$com_android_internal_telephony_RIL$responseDataCallList(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseSetupDataCall(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseSetupDataCall", $$robo$$com_android_internal_telephony_RIL$responseSetupDataCall(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseOperatorInfos(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseOperatorInfos", $$robo$$com_android_internal_telephony_RIL$responseOperatorInfos(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseCellList(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCellList", $$robo$$com_android_internal_telephony_RIL$responseCellList(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseGetPreferredNetworkType(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseGetPreferredNetworkType", $$robo$$com_android_internal_telephony_RIL$responseGetPreferredNetworkType(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseGmsBroadcastConfig(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseGmsBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$responseGmsBroadcastConfig(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseCdmaBroadcastConfig(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$responseCdmaBroadcastConfig(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseSignalStrength(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseSignalStrength", $$robo$$com_android_internal_telephony_RIL$responseSignalStrength(android.os.Parcel ), 0, this, parcel);
    }

    private ArrayList<CdmaInformationRecords> responseCdmaInformationRecord(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCdmaInformationRecord", $$robo$$com_android_internal_telephony_RIL$responseCdmaInformationRecord(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseCdmaCallWaiting(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCdmaCallWaiting", $$robo$$com_android_internal_telephony_RIL$responseCdmaCallWaiting(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseCallRing(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCallRing", $$robo$$com_android_internal_telephony_RIL$responseCallRing(android.os.Parcel ), 0, this, parcel);
    }

    private void notifyRegistrantsCdmaInfoRec(CdmaInformationRecords cdmaInformationRecords) {
        InvokeDynamicSupport.bootstrap("notifyRegistrantsCdmaInfoRec", $$robo$$com_android_internal_telephony_RIL$notifyRegistrantsCdmaInfoRec(com.android.internal.telephony.cdma.CdmaInformationRecords ), 0, this, cdmaInformationRecords);
    }

    private ArrayList<CellInfo> responseCellInfoList(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseCellInfoList", $$robo$$com_android_internal_telephony_RIL$responseCellInfoList(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseHardwareConfig(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseHardwareConfig", $$robo$$com_android_internal_telephony_RIL$responseHardwareConfig(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseRadioCapability(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseRadioCapability", $$robo$$com_android_internal_telephony_RIL$responseRadioCapability(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseLceData(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseLceData", $$robo$$com_android_internal_telephony_RIL$responseLceData(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseLceStatus(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseLceStatus", $$robo$$com_android_internal_telephony_RIL$responseLceStatus(android.os.Parcel ), 0, this, parcel);
    }

    private Object responseActivityData(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseActivityData", $$robo$$com_android_internal_telephony_RIL$responseActivityData(android.os.Parcel ), 0, this, parcel);
    }

    static String requestToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("requestToString", $$robo$$com_android_internal_telephony_RIL$requestToString(int ), 0, (int)n);
    }

    static String responseToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("responseToString", $$robo$$com_android_internal_telephony_RIL$responseToString(int ), 0, (int)n);
    }

    private void riljLog(String string2) {
        InvokeDynamicSupport.bootstrap("riljLog", $$robo$$com_android_internal_telephony_RIL$riljLog(java.lang.String ), 0, this, string2);
    }

    private void riljLogv(String string2) {
        InvokeDynamicSupport.bootstrap("riljLogv", $$robo$$com_android_internal_telephony_RIL$riljLogv(java.lang.String ), 0, this, string2);
    }

    private void unsljLog(int n) {
        InvokeDynamicSupport.bootstrap("unsljLog", $$robo$$com_android_internal_telephony_RIL$unsljLog(int ), 0, this, n);
    }

    private void unsljLogMore(int n, String string2) {
        InvokeDynamicSupport.bootstrap("unsljLogMore", $$robo$$com_android_internal_telephony_RIL$unsljLogMore(int java.lang.String ), 0, this, n, string2);
    }

    private void unsljLogRet(int n, Object object) {
        InvokeDynamicSupport.bootstrap("unsljLogRet", $$robo$$com_android_internal_telephony_RIL$unsljLogRet(int java.lang.Object ), 0, this, n, object);
    }

    private void unsljLogvRet(int n, Object object) {
        InvokeDynamicSupport.bootstrap("unsljLogvRet", $$robo$$com_android_internal_telephony_RIL$unsljLogvRet(int java.lang.Object ), 0, this, n, object);
    }

    private Object responseSsData(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("responseSsData", $$robo$$com_android_internal_telephony_RIL$responseSsData(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void getDeviceIdentity(Message message) {
        InvokeDynamicSupport.bootstrap("getDeviceIdentity", $$robo$$com_android_internal_telephony_RIL$getDeviceIdentity(android.os.Message ), 0, this, message);
    }

    @Override
    public void getCDMASubscription(Message message) {
        InvokeDynamicSupport.bootstrap("getCDMASubscription", $$robo$$com_android_internal_telephony_RIL$getCDMASubscription(android.os.Message ), 0, this, message);
    }

    @Override
    public void setPhoneType(int n) {
        InvokeDynamicSupport.bootstrap("setPhoneType", $$robo$$com_android_internal_telephony_RIL$setPhoneType(int ), 0, this, n);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        InvokeDynamicSupport.bootstrap("queryCdmaRoamingPreference", $$robo$$com_android_internal_telephony_RIL$queryCdmaRoamingPreference(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaRoamingPreference", $$robo$$com_android_internal_telephony_RIL$setCdmaRoamingPreference(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCdmaSubscriptionSource(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_RIL$setCdmaSubscriptionSource(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getCdmaSubscriptionSource(Message message) {
        InvokeDynamicSupport.bootstrap("getCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_RIL$getCdmaSubscriptionSource(android.os.Message ), 0, this, message);
    }

    @Override
    public void queryTTYMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryTTYMode", $$robo$$com_android_internal_telephony_RIL$queryTTYMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setTTYMode", $$robo$$com_android_internal_telephony_RIL$setTTYMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void sendCDMAFeatureCode(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendCDMAFeatureCode", $$robo$$com_android_internal_telephony_RIL$sendCDMAFeatureCode(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void getCdmaBroadcastConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$getCdmaBroadcastConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] cdmaSmsBroadcastConfigInfoArray, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_RIL$setCdmaBroadcastConfig(com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo[] android.os.Message ), 0, this, cdmaSmsBroadcastConfigInfoArray, message);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaBroadcastActivation", $$robo$$com_android_internal_telephony_RIL$setCdmaBroadcastActivation(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void exitEmergencyCallbackMode(Message message) {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_RIL$exitEmergencyCallbackMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void requestIsimAuthentication(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("requestIsimAuthentication", $$robo$$com_android_internal_telephony_RIL$requestIsimAuthentication(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void requestIccSimAuthentication(int n, String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("requestIccSimAuthentication", $$robo$$com_android_internal_telephony_RIL$requestIccSimAuthentication(int java.lang.String java.lang.String android.os.Message ), 0, this, n, string2, string3, message);
    }

    @Override
    public void getCellInfoList(Message message) {
        InvokeDynamicSupport.bootstrap("getCellInfoList", $$robo$$com_android_internal_telephony_RIL$getCellInfoList(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCellInfoListRate(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$com_android_internal_telephony_RIL$setCellInfoListRate(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setInitialAttachApn(String string2, String string3, int n, String string4, String string5, Message message) {
        InvokeDynamicSupport.bootstrap("setInitialAttachApn", $$robo$$com_android_internal_telephony_RIL$setInitialAttachApn(java.lang.String java.lang.String int java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, n, string4, string5, message);
    }

    @Override
    public void setDataProfile(DataProfile[] dataProfileArray, Message message) {
        InvokeDynamicSupport.bootstrap("setDataProfile", $$robo$$com_android_internal_telephony_RIL$setDataProfile(com.android.internal.telephony.dataconnection.DataProfile[] android.os.Message ), 0, this, dataProfileArray, message);
    }

    @Override
    public void testingEmergencyCall() {
        InvokeDynamicSupport.bootstrap("testingEmergencyCall", $$robo$$com_android_internal_telephony_RIL$testingEmergencyCall(), 0, this);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_RIL$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public void iccOpenLogicalChannel(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$com_android_internal_telephony_RIL$iccOpenLogicalChannel(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void iccCloseLogicalChannel(int n, Message message) {
        InvokeDynamicSupport.bootstrap("iccCloseLogicalChannel", $$robo$$com_android_internal_telephony_RIL$iccCloseLogicalChannel(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannel", $$robo$$com_android_internal_telephony_RIL$iccTransmitApduLogicalChannel(int int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, n6, string2, message);
    }

    @Override
    public void iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannel", $$robo$$com_android_internal_telephony_RIL$iccTransmitApduBasicChannel(int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, string2, message);
    }

    private void iccTransmitApduHelper(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduHelper", $$robo$$com_android_internal_telephony_RIL$iccTransmitApduHelper(int int int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, n6, n7, string2, message);
    }

    @Override
    public void nvReadItem(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvReadItem", $$robo$$com_android_internal_telephony_RIL$nvReadItem(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void nvWriteItem(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteItem", $$robo$$com_android_internal_telephony_RIL$nvWriteItem(int java.lang.String android.os.Message ), 0, this, n, string2, message);
    }

    @Override
    public void nvWriteCdmaPrl(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteCdmaPrl", $$robo$$com_android_internal_telephony_RIL$nvWriteCdmaPrl(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void nvResetConfig(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvResetConfig", $$robo$$com_android_internal_telephony_RIL$nvResetConfig(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setRadioCapability(RadioCapability radioCapability, Message message) {
        InvokeDynamicSupport.bootstrap("setRadioCapability", $$robo$$com_android_internal_telephony_RIL$setRadioCapability(com.android.internal.telephony.RadioCapability android.os.Message ), 0, this, radioCapability, message);
    }

    @Override
    public void getRadioCapability(Message message) {
        InvokeDynamicSupport.bootstrap("getRadioCapability", $$robo$$com_android_internal_telephony_RIL$getRadioCapability(android.os.Message ), 0, this, message);
    }

    @Override
    public void startLceService(int n, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("startLceService", $$robo$$com_android_internal_telephony_RIL$startLceService(int boolean android.os.Message ), 0, this, n, bl, message);
    }

    @Override
    public void stopLceService(Message message) {
        InvokeDynamicSupport.bootstrap("stopLceService", $$robo$$com_android_internal_telephony_RIL$stopLceService(android.os.Message ), 0, this, message);
    }

    @Override
    public void pullLceData(Message message) {
        InvokeDynamicSupport.bootstrap("pullLceData", $$robo$$com_android_internal_telephony_RIL$pullLceData(android.os.Message ), 0, this, message);
    }

    @Override
    public void getModemActivityInfo(Message message) {
        InvokeDynamicSupport.bootstrap("getModemActivityInfo", $$robo$$com_android_internal_telephony_RIL$getModemActivityInfo(android.os.Message ), 0, this, message);
    }

    static {
        RobolectricInternals.classInitializing(RIL.class);
    }

    public /* synthetic */ RIL() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RIL)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class RILReceiver
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        byte[] buffer;
        /* synthetic */ RIL this$0;

        private void $$robo$$com_android_internal_telephony_RIL_RILReceiver$__constructor__(RIL this$0) {
            this.buffer = new byte[8192];
        }

        private final void $$robo$$com_android_internal_telephony_RIL_RILReceiver$run() {
            int retryCount = 0;
            String rilSocket = "rild";
            try {
                while (true) {
                    LocalSocket s = null;
                    rilSocket = this.this$0.mInstanceId == null || this.this$0.mInstanceId == 0 ? SOCKET_NAME_RIL[0] : SOCKET_NAME_RIL[this.this$0.mInstanceId];
                    try {
                        s = new LocalSocket();
                        LocalSocketAddress l = new LocalSocketAddress(rilSocket, LocalSocketAddress.Namespace.RESERVED);
                        s.connect(l);
                    }
                    catch (IOException ex) {
                        try {
                            if (s != null) {
                                s.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (retryCount == 8) {
                            Rlog.e("RILJ", "Couldn't find '" + rilSocket + "' socket after " + retryCount + " times, continuing to retry silently");
                        } else if (retryCount >= 0 && retryCount < 8) {
                            Rlog.i("RILJ", "Couldn't find '" + rilSocket + "' socket; retrying after timeout");
                        }
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++retryCount;
                        continue;
                    }
                    retryCount = 0;
                    this.this$0.mSocket = s;
                    Rlog.i("RILJ", "(" + this.this$0.mInstanceId + ") Connected to '" + rilSocket + "' socket");
                    int length = 0;
                    try {
                        InputStream is = this.this$0.mSocket.getInputStream();
                        while ((length = RIL.readRilMessage(is, this.buffer)) >= 0) {
                            Parcel p = Parcel.obtain();
                            p.unmarshall(this.buffer, 0, length);
                            p.setDataPosition(0);
                            this.this$0.processResponse(p);
                            p.recycle();
                        }
                    }
                    catch (IOException ex) {
                        Rlog.i("RILJ", "'" + rilSocket + "' socket closed", ex);
                    }
                    catch (Throwable tr) {
                        Rlog.e("RILJ", "Uncaught exception read length=" + length + "Exception:" + tr.toString());
                    }
                    Rlog.i("RILJ", "(" + this.this$0.mInstanceId + ") Disconnected from '" + rilSocket + "' socket");
                    this.this$0.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
                    try {
                        this.this$0.mSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.this$0.mSocket = null;
                    RILRequest.resetSerial();
                    this.this$0.clearRequestList(1, false);
                }
            }
            catch (Throwable tr) {
                Rlog.e("RILJ", "Uncaught exception", tr);
                this.this$0.notifyRegistrantsRilConnectionChanged(-1);
                return;
            }
        }

        private void __constructor__(RIL rIL) {
            this.$$robo$$com_android_internal_telephony_RIL_RILReceiver$__constructor__(rIL);
        }

        RILReceiver(RIL rIL) {
            this.this$0 = rIL;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL_RILReceiver$__constructor__(com.android.internal.telephony.RIL ), 0, this, rIL);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_RIL_RILReceiver$run(), 0, this);
        }

        public /* synthetic */ RILReceiver() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RILReceiver)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class RILSender
    extends Handler
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        byte[] dataLength;
        /* synthetic */ RIL this$0;

        private void $$robo$$com_android_internal_telephony_RIL_RILSender$__constructor__(RIL this$0, Looper looper) {
            this.dataLength = new byte[4];
        }

        private final void $$robo$$com_android_internal_telephony_RIL_RILSender$run() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_RIL_RILSender$handleMessage(Message msg) {
            RILRequest rr = (RILRequest)msg.obj;
            RILRequest req = null;
            switch (msg.what) {
                case 1: 
                case 3: {
                    try {
                        LocalSocket s = this.this$0.mSocket;
                        if (s == null) {
                            rr.onError(1, null);
                            this.this$0.decrementWakeLock(rr);
                            rr.release();
                            return;
                        }
                        if (msg.what != 3) {
                            SparseArray<RILRequest> sparseArray = this.this$0.mRequestList;
                            synchronized (sparseArray) {
                                this.this$0.mRequestList.append(rr.mSerial, rr);
                            }
                        }
                        byte[] data = rr.mParcel.marshall();
                        rr.mParcel.recycle();
                        rr.mParcel = null;
                        if (data.length > 8192) {
                            throw new RuntimeException("Parcel larger than max bytes allowed! " + data.length);
                        }
                        this.dataLength[1] = 0;
                        this.dataLength[0] = 0;
                        this.dataLength[2] = (byte)(data.length >> 8 & 0xFF);
                        this.dataLength[3] = (byte)(data.length & 0xFF);
                        s.getOutputStream().write(this.dataLength);
                        s.getOutputStream().write(data);
                        if (msg.what == 3) {
                            rr.release();
                            return;
                        }
                        break;
                    }
                    catch (IOException ex) {
                        Rlog.e("RILJ", "IOException", ex);
                        req = this.this$0.findAndRemoveRequestFromList(rr.mSerial);
                        if (req == null) break;
                        rr.onError(1, null);
                        this.this$0.decrementWakeLock(rr);
                        rr.release();
                        return;
                    }
                    catch (RuntimeException exc) {
                        Rlog.e("RILJ", "Uncaught exception ", exc);
                        req = this.this$0.findAndRemoveRequestFromList(rr.mSerial);
                        if (req == null) break;
                        rr.onError(2, null);
                        this.this$0.decrementWakeLock(rr);
                        rr.release();
                        return;
                    }
                }
                case 2: {
                    SparseArray<RILRequest> exc = this.this$0.mRequestList;
                    synchronized (exc) {
                        if (msg.arg1 == this.this$0.mWlSequenceNum && this.this$0.clearWakeLock(0)) {
                            int count = this.this$0.mRequestList.size();
                            Rlog.d("RILJ", "WAKE_LOCK_TIMEOUT  mRequestList=" + count);
                            for (int i = 0; i < count; ++i) {
                                rr = this.this$0.mRequestList.valueAt(i);
                                Rlog.d("RILJ", i + ": [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    if (msg.arg1 != this.this$0.mAckWlSequenceNum || !this.this$0.clearWakeLock(1)) break;
                    Rlog.d("RILJ", "ACK_WAKE_LOCK_TIMEOUT");
                    break;
                }
                case 5: {
                    int serial = msg.arg1;
                    rr = this.this$0.findAndRemoveRequestFromList(serial);
                    if (rr == null) break;
                    if (rr.mResult != null) {
                        Object timeoutResponse = RIL.getResponseForTimedOutRILRequest(rr);
                        AsyncResult.forMessage(rr.mResult, timeoutResponse, null);
                        rr.mResult.sendToTarget();
                        this.this$0.mEventLog.writeOnRilTimeoutResponse(rr.mSerial, rr.mRequest);
                    }
                    this.this$0.decrementWakeLock(rr);
                    rr.release();
                }
            }
        }

        private void __constructor__(RIL rIL, Looper looper) {
            this.$$robo$$com_android_internal_telephony_RIL_RILSender$__constructor__(rIL, looper);
        }

        public RILSender(RIL rIL, Looper looper) {
            this.this$0 = rIL;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RIL_RILSender$__constructor__(com.android.internal.telephony.RIL android.os.Looper ), 0, this, rIL, looper);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_RIL_RILSender$run(), 0, this);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_RIL_RILSender$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ RILSender() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RILSender)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

