/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.GsmCdmaCall;
import com.android.internal.telephony.GsmCdmaCallTracker;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.UiccCardApplication;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GsmCdmaConnection
extends Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "GsmCdmaConnection";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    GsmCdmaCallTracker mOwner;
    GsmCdmaCall mParent;
    boolean mDisconnected;
    int mIndex;
    long mDisconnectTime;
    UUSInfo mUusInfo;
    int mPreciseCause;
    String mVendorCause;
    Connection mOrigConnection;
    Handler mHandler;
    private PowerManager.WakeLock mPartialWakeLock;
    private int mDtmfToneDelay;
    static int EVENT_DTMF_DONE = 1;
    static int EVENT_PAUSE_DONE = 2;
    static int EVENT_NEXT_POST_DIAL = 3;
    static int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static int EVENT_DTMF_DELAY_DONE = 5;
    static int PAUSE_DELAY_MILLIS_GSM = 3000;
    static int PAUSE_DELAY_MILLIS_CDMA = 2000;
    static int WAKE_LOCK_TIMEOUT_MILLIS = 60000;

    private void $$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(GsmCdmaPhone phone, DriverCall dc, GsmCdmaCallTracker ct, int index) {
        this.mPreciseCause = 0;
        this.mDtmfToneDelay = 0;
        this.createWakeLock(phone.getContext());
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mAddress = dc.number;
        this.mIsIncoming = dc.isMT;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mCnapName = dc.name;
        this.mCnapNamePresentation = dc.namePresentation;
        this.mNumberPresentation = dc.numberPresentation;
        this.mUusInfo = dc.uusInfo;
        this.mIndex = index;
        this.mParent = this.parentFromDCState(dc.state);
        this.mParent.attach(this, dc);
        this.fetchDtmfToneDelay(phone);
    }

    private void $$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(GsmCdmaPhone phone, String dialString, GsmCdmaCallTracker ct, GsmCdmaCall parent) {
        this.mPreciseCause = 0;
        this.mDtmfToneDelay = 0;
        this.createWakeLock(phone.getContext());
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        if (this.isPhoneTypeGsm()) {
            this.mDialString = dialString;
        } else {
            Rlog.d("GsmCdmaConnection", "[GsmCdmaConn] GsmCdmaConnection: dialString=" + this.maskDialString(dialString));
            dialString = GsmCdmaConnection.formatDialString(dialString);
            Rlog.d("GsmCdmaConnection", "[GsmCdmaConn] GsmCdmaConnection:formated dialString=" + this.maskDialString(dialString));
        }
        this.mAddress = PhoneNumberUtils.extractNetworkPortionAlt(dialString);
        this.mPostDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.mIndex = -1;
        this.mIsIncoming = false;
        this.mCnapName = null;
        this.mCnapNamePresentation = 1;
        this.mNumberPresentation = 1;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (parent != null) {
            this.mParent = parent;
            if (this.isPhoneTypeGsm()) {
                parent.attachFake(this, Call.State.DIALING);
            } else if (parent.mState == Call.State.ACTIVE) {
                parent.attachFake(this, Call.State.ACTIVE);
            } else {
                parent.attachFake(this, Call.State.DIALING);
            }
        }
        this.fetchDtmfToneDelay(phone);
    }

    private void $$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(Context context, CdmaCallWaitingNotification cw, GsmCdmaCallTracker ct, GsmCdmaCall parent) {
        this.mPreciseCause = 0;
        this.mDtmfToneDelay = 0;
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this, this.mOwner.getLooper());
        this.mAddress = cw.number;
        this.mNumberPresentation = cw.numberPresentation;
        this.mCnapName = cw.name;
        this.mCnapNamePresentation = cw.namePresentation;
        this.mIndex = -1;
        this.mIsIncoming = true;
        this.mCreateTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mConnectTime = 0L;
        this.mParent = parent;
        parent.attachFake(this, Call.State.WAITING);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$dispose() {
        this.clearPostDialListeners();
        this.releaseAllWakeLocks();
    }

    private static final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static final String $$robo$$com_android_internal_telephony_GsmCdmaConnection$formatDialString(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int length = phoneNumber.length();
        StringBuilder ret = new StringBuilder();
        for (int currIndex = 0; currIndex < length; ++currIndex) {
            char c = phoneNumber.charAt(currIndex);
            if (GsmCdmaConnection.isPause(c) || GsmCdmaConnection.isWait(c)) {
                if (currIndex >= length - 1) continue;
                int nextIndex = GsmCdmaConnection.findNextPCharOrNonPOrNonWCharIndex(phoneNumber, currIndex);
                if (nextIndex < length) {
                    char pC = GsmCdmaConnection.findPOrWCharToAppend(phoneNumber, currIndex, nextIndex);
                    ret.append(pC);
                    if (nextIndex <= currIndex + 1) continue;
                    currIndex = nextIndex - 1;
                    continue;
                }
                if (nextIndex != length) continue;
                currIndex = length - 1;
                continue;
            }
            ret.append(c);
        }
        return PhoneNumberUtils.cdmaCheckAndProcessPlusCode(ret.toString());
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$compareTo(DriverCall c) {
        if (!this.mIsIncoming && !c.isMT) {
            return true;
        }
        if (this.isPhoneTypeGsm() && this.mOrigConnection != null) {
            return true;
        }
        String cAddress = PhoneNumberUtils.stringFromStringAndTOA(c.number, c.TOA);
        return this.mIsIncoming == c.isMT && GsmCdmaConnection.equalsHandlesNulls(this.mAddress, cAddress);
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaConnection$getOrigDialString() {
        return this.mDialString;
    }

    private final GsmCdmaCall $$robo$$com_android_internal_telephony_GsmCdmaConnection$getCall() {
        return this.mParent;
    }

    private final long $$robo$$com_android_internal_telephony_GsmCdmaConnection$getDisconnectTime() {
        return this.mDisconnectTime;
    }

    private final long $$robo$$com_android_internal_telephony_GsmCdmaConnection$getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.mHoldingStartTime;
    }

    private final Call.State $$robo$$com_android_internal_telephony_GsmCdmaConnection$getState() {
        if (this.mDisconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$hangup() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.hangup(this);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$separate() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.separate(this);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$proceedAfterWaitChar() {
        if (this.mPostDialState != Connection.PostDialState.WAIT) {
            Rlog.w("GsmCdmaConnection", "GsmCdmaConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$proceedAfterWildChar(String str) {
        if (this.mPostDialState != Connection.PostDialState.WILD) {
            Rlog.w("GsmCdmaConnection", "GsmCdmaConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder buf = new StringBuilder(str);
        buf.append(this.mPostDialString.substring(this.mNextPostDialChar));
        this.mPostDialString = buf.toString();
        this.mNextPostDialChar = 0;
        this.log("proceedAfterWildChar: new postDialString is " + this.mPostDialString);
        this.processNextPostDialChar();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$onHangupLocal() {
        this.mCause = 3;
        this.mPreciseCause = 0;
        this.mVendorCause = null;
    }

    private final int $$robo$$com_android_internal_telephony_GsmCdmaConnection$disconnectCauseFromCode(int causeCode) {
        IccCardApplicationStatus.AppState uiccAppState;
        switch (causeCode) {
            case 17: {
                return 4;
            }
            case 34: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 58: {
                return 5;
            }
            case 68: {
                return 15;
            }
            case 240: {
                return 20;
            }
            case 241: {
                return 21;
            }
            case 1: {
                return 25;
            }
            case 244: {
                return 46;
            }
            case 245: {
                return 47;
            }
            case 246: {
                return 48;
            }
            case 1000: {
                return 26;
            }
            case 1001: {
                return 27;
            }
            case 1002: {
                return 28;
            }
            case 1003: {
                return 29;
            }
            case 1004: {
                return 30;
            }
            case 1005: {
                return 31;
            }
            case 1006: {
                return 32;
            }
            case 1007: {
                return 33;
            }
            case 1008: {
                return 34;
            }
            case 1009: {
                return 35;
            }
        }
        GsmCdmaPhone phone = this.mOwner.getPhone();
        int serviceState = phone.getServiceState().getState();
        UiccCardApplication cardApp = phone.getUiccCardApplication();
        IccCardApplicationStatus.AppState appState = uiccAppState = cardApp != null ? cardApp.getState() : IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
        if (serviceState == 3) {
            return 17;
        }
        if (serviceState == 1 || serviceState == 2) {
            return 18;
        }
        if (this.isPhoneTypeGsm()) {
            if (uiccAppState != IccCardApplicationStatus.AppState.APPSTATE_READY) {
                return 19;
            }
            if (causeCode == 65535) {
                if (phone.mSST.mRestrictedState.isCsRestricted()) {
                    return 22;
                }
                if (phone.mSST.mRestrictedState.isCsEmergencyRestricted()) {
                    return 24;
                }
                if (phone.mSST.mRestrictedState.isCsNormalRestricted()) {
                    return 23;
                }
                return 36;
            }
            if (causeCode == 16) {
                return 2;
            }
            return 36;
        }
        if (phone.mCdmaSubscriptionSource == 0 && uiccAppState != IccCardApplicationStatus.AppState.APPSTATE_READY) {
            return 19;
        }
        if (causeCode == 16) {
            return 2;
        }
        return 36;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$onRemoteDisconnect(int causeCode, String vendorCause) {
        this.mPreciseCause = causeCode;
        this.mVendorCause = vendorCause;
        this.onDisconnect(this.disconnectCauseFromCode(causeCode));
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$onDisconnect(int cause) {
        boolean changed = false;
        this.mCause = cause;
        if (!this.mDisconnected) {
            this.doDisconnect();
            Rlog.d("GsmCdmaConnection", "onDisconnect: cause=" + cause);
            this.mOwner.getPhone().notifyDisconnect(this);
            if (this.mParent != null) {
                changed = this.mParent.connectionDisconnected(this);
            }
            this.mOrigConnection = null;
        }
        this.clearPostDialListeners();
        this.releaseWakeLock();
        return changed;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$onLocalDisconnect() {
        if (!this.mDisconnected) {
            this.doDisconnect();
            if (this.mParent != null) {
                this.mParent.detach(this);
            }
        }
        this.releaseWakeLock();
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$update(DriverCall dc) {
        boolean changed = false;
        boolean wasConnectingInOrOut = this.isConnectingInOrOut();
        boolean wasHolding = this.getState() == Call.State.HOLDING;
        GsmCdmaCall newParent = this.parentFromDCState(dc.state);
        this.log("parent= " + this.mParent + ", newParent= " + newParent);
        if (this.isPhoneTypeGsm() && this.mOrigConnection != null) {
            this.log("update: mOrigConnection is not null");
        } else {
            this.log(" mNumberConverted " + this.mNumberConverted);
            if (!(GsmCdmaConnection.equalsHandlesNulls(this.mAddress, dc.number) || this.mNumberConverted && GsmCdmaConnection.equalsHandlesNulls(this.mConvertedNumber, dc.number))) {
                this.log("update: phone # changed!");
                this.mAddress = dc.number;
                changed = true;
            }
        }
        if (TextUtils.isEmpty(dc.name)) {
            if (!TextUtils.isEmpty(this.mCnapName)) {
                changed = true;
                this.mCnapName = "";
            }
        } else if (!dc.name.equals(this.mCnapName)) {
            changed = true;
            this.mCnapName = dc.name;
        }
        this.log("--dssds----" + this.mCnapName);
        this.mCnapNamePresentation = dc.namePresentation;
        this.mNumberPresentation = dc.numberPresentation;
        if (newParent != this.mParent) {
            if (this.mParent != null) {
                this.mParent.detach(this);
            }
            newParent.attach(this, dc);
            this.mParent = newParent;
            changed = true;
        } else {
            boolean parentStateChange = this.mParent.update(this, dc);
            changed = changed || parentStateChange;
        }
        this.log("update: parent=" + this.mParent + ", hasNewParent=" + (newParent != this.mParent) + ", wasConnectingInOrOut=" + wasConnectingInOrOut + ", wasHolding=" + wasHolding + ", isConnectingInOrOut=" + this.isConnectingInOrOut() + ", changed=" + changed);
        if (wasConnectingInOrOut && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (changed && !wasHolding && this.getState() == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        return changed;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$fakeHoldBeforeDial() {
        if (this.mParent != null) {
            this.mParent.detach(this);
        }
        this.mParent = this.mOwner.mBackgroundCall;
        this.mParent.attachFake(this, Call.State.HOLDING);
        this.onStartedHolding();
    }

    private final int $$robo$$com_android_internal_telephony_GsmCdmaConnection$getGsmCdmaIndex() throws CallStateException {
        if (this.mIndex >= 0) {
            return this.mIndex + 1;
        }
        throw new CallStateException("GsmCdma index not yet assigned");
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$onConnectedInOrOut() {
        this.mConnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mConnectTimeReal = SystemClock.elapsedRealtime();
        this.mDuration = 0L;
        this.log("onConnectedInOrOut: connectTime=" + this.mConnectTime);
        if (!this.mIsIncoming) {
            this.processNextPostDialChar();
        } else {
            this.releaseWakeLock();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$doDisconnect() {
        this.mIndex = -1;
        this.mDisconnectTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mDuration = SystemClock.elapsedRealtime() - this.mConnectTimeReal;
        this.mDisconnected = true;
        this.clearPostDialListeners();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$onStartedHolding() {
        this.mHoldingStartTime = SystemClock.elapsedRealtime();
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.mOwner.mCi.sendDtmf(c, this.mHandler.obtainMessage(1));
        } else if (GsmCdmaConnection.isPause(c)) {
            if (!this.isPhoneTypeGsm()) {
                this.setPostDialState(Connection.PostDialState.PAUSE);
            }
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), this.isPhoneTypeGsm() ? 3000L : 2000L);
        } else if (GsmCdmaConnection.isWait(c)) {
            this.setPostDialState(Connection.PostDialState.WAIT);
        } else if (GsmCdmaConnection.isWild(c)) {
            this.setPostDialState(Connection.PostDialState.WILD);
        } else {
            return false;
        }
        return true;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaConnection$getRemainingPostDialString() {
        String subStr = super.getRemainingPostDialString();
        if (!this.isPhoneTypeGsm() && !TextUtils.isEmpty(subStr)) {
            int wIndex = subStr.indexOf(59);
            int pIndex = subStr.indexOf(44);
            if (wIndex > 0 && (wIndex < pIndex || pIndex <= 0)) {
                subStr = subStr.substring(0, wIndex);
            } else if (pIndex > 0) {
                subStr = subStr.substring(0, pIndex);
            }
        }
        return subStr;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$updateParent(GsmCdmaCall oldParent, GsmCdmaCall newParent) {
        if (newParent != oldParent) {
            if (oldParent != null) {
                oldParent.detach(this);
            }
            newParent.attachFake(this, Call.State.ACTIVE);
            this.mParent = newParent;
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            Rlog.e("GsmCdmaConnection", "[GsmCdmaConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.clearPostDialListeners();
        this.releaseWakeLock();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$processNextPostDialChar() {
        Message notifyMessage;
        char c = '\u0000';
        if (this.mPostDialState == Connection.PostDialState.CANCELLED) {
            this.releaseWakeLock();
            return;
        }
        if (this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            this.setPostDialState(Connection.PostDialState.COMPLETE);
            this.releaseWakeLock();
            c = '\u0000';
        } else {
            this.setPostDialState(Connection.PostDialState.STARTED);
            c = this.mPostDialString.charAt(this.mNextPostDialChar++);
            boolean isValid = this.processPostDialChar(c);
            if (!isValid) {
                this.mHandler.obtainMessage(3).sendToTarget();
                Rlog.e("GsmCdmaConnection", "processNextPostDialChar: c=" + c + " isn't valid!");
                return;
            }
        }
        this.notifyPostDialListenersNextChar(c);
        Registrant postDialHandler = this.mOwner.getPhone().getPostDialHandler();
        if (postDialHandler != null && (notifyMessage = postDialHandler.messageForRegistrant()) != null) {
            Connection.PostDialState state = this.mPostDialState;
            AsyncResult ar = AsyncResult.forMessage(notifyMessage);
            ar.result = this;
            ar.userObj = state;
            notifyMessage.arg1 = c;
            notifyMessage.sendToTarget();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$isConnectingInOrOut() {
        return this.mParent == null || this.mParent == this.mOwner.mRingingCall || this.mParent.mState == Call.State.DIALING || this.mParent.mState == Call.State.ALERTING;
    }

    private final GsmCdmaCall $$robo$$com_android_internal_telephony_GsmCdmaConnection$parentFromDCState(DriverCall.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$DriverCall$State[state.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return this.mOwner.mForegroundCall;
            }
            case 4: {
                return this.mOwner.mBackgroundCall;
            }
            case 5: 
            case 6: {
                return this.mOwner.mRingingCall;
            }
        }
        throw new RuntimeException("illegal call state: " + (Object)((Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$setPostDialState(Connection.PostDialState s) {
        if (s == Connection.PostDialState.STARTED || s == Connection.PostDialState.PAUSE) {
            PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
            synchronized (wakeLock) {
                if (this.mPartialWakeLock.isHeld()) {
                    this.mHandler.removeMessages(4);
                } else {
                    this.acquireWakeLock();
                }
                Message msg = this.mHandler.obtainMessage(4);
                this.mHandler.sendMessageDelayed(msg, 60000L);
            }
        } else {
            this.mHandler.removeMessages(4);
            this.releaseWakeLock();
        }
        this.mPostDialState = s;
        this.notifyPostDialListeners();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$createWakeLock(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mPartialWakeLock = pm.newWakeLock(1, "GsmCdmaConnection");
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$releaseAllWakeLocks() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            while (this.mPartialWakeLock.isHeld()) {
                this.mPartialWakeLock.release();
            }
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$isPause(char c) {
        return c == ',';
    }

    private static final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$isWait(char c) {
        return c == ';';
    }

    private static final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$isWild(char c) {
        return c == 'N';
    }

    private static final int $$robo$$com_android_internal_telephony_GsmCdmaConnection$findNextPCharOrNonPOrNonWCharIndex(String phoneNumber, int currIndex) {
        int index;
        boolean wMatched = GsmCdmaConnection.isWait(phoneNumber.charAt(currIndex));
        int length = phoneNumber.length();
        for (index = currIndex + 1; index < length; ++index) {
            char cNext = phoneNumber.charAt(index);
            if (GsmCdmaConnection.isWait(cNext)) {
                wMatched = true;
            }
            if (!GsmCdmaConnection.isWait(cNext) && !GsmCdmaConnection.isPause(cNext)) break;
        }
        if (index < length && index > currIndex + 1 && !wMatched && GsmCdmaConnection.isPause(phoneNumber.charAt(currIndex))) {
            return currIndex + 1;
        }
        return index;
    }

    private static final char $$robo$$com_android_internal_telephony_GsmCdmaConnection$findPOrWCharToAppend(String phoneNumber, int currPwIndex, int nextNonPwCharIndex) {
        char ret;
        char c = phoneNumber.charAt(currPwIndex);
        char c2 = ret = GsmCdmaConnection.isPause(c) ? (char)',' : ';';
        if (nextNonPwCharIndex > currPwIndex + 1) {
            ret = ';';
        }
        return ret;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaConnection$maskDialString(String dialString) {
        return "<MASKED>";
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$fetchDtmfToneDelay(GsmCdmaPhone phone) {
        CarrierConfigManager configMgr = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        PersistableBundle b = configMgr.getConfigForSubId(phone.getSubId());
        if (b != null) {
            this.mDtmfToneDelay = b.getInt(phone.getDtmfToneDelayKey());
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$isPhoneTypeGsm() {
        return this.mOwner.getPhone().getPhoneType() == 1;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$log(String msg) {
        Rlog.d("GsmCdmaConnection", "[GsmCdmaConn] " + msg);
    }

    private final int $$robo$$com_android_internal_telephony_GsmCdmaConnection$getNumberPresentation() {
        return this.mNumberPresentation;
    }

    private final UUSInfo $$robo$$com_android_internal_telephony_GsmCdmaConnection$getUUSInfo() {
        return this.mUusInfo;
    }

    private final int $$robo$$com_android_internal_telephony_GsmCdmaConnection$getPreciseDisconnectCause() {
        return this.mPreciseCause;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaConnection$getVendorDisconnectCause() {
        return this.mVendorCause;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection$migrateFrom(Connection c) {
        if (c == null) {
            return;
        }
        super.migrateFrom(c);
        this.mUusInfo = c.getUUSInfo();
        this.setUserData(c.getUserData());
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaConnection$getOrigConnection() {
        return this.mOrigConnection;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaConnection$isMultiparty() {
        if (this.mOrigConnection != null) {
            return this.mOrigConnection.isMultiparty();
        }
        return false;
    }

    private void __constructor__(GsmCdmaPhone gsmCdmaPhone, DriverCall driverCall, GsmCdmaCallTracker gsmCdmaCallTracker, int n) {
        this.$$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(gsmCdmaPhone, driverCall, gsmCdmaCallTracker, n);
    }

    public GsmCdmaConnection(GsmCdmaPhone gsmCdmaPhone, DriverCall driverCall, GsmCdmaCallTracker gsmCdmaCallTracker, int n) {
        super(gsmCdmaPhone.getPhoneType());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(com.android.internal.telephony.GsmCdmaPhone com.android.internal.telephony.DriverCall com.android.internal.telephony.GsmCdmaCallTracker int ), 0, this, gsmCdmaPhone, driverCall, gsmCdmaCallTracker, n);
    }

    private void __constructor__(GsmCdmaPhone gsmCdmaPhone, String string2, GsmCdmaCallTracker gsmCdmaCallTracker, GsmCdmaCall gsmCdmaCall) {
        this.$$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(gsmCdmaPhone, string2, gsmCdmaCallTracker, gsmCdmaCall);
    }

    public GsmCdmaConnection(GsmCdmaPhone gsmCdmaPhone, String string2, GsmCdmaCallTracker gsmCdmaCallTracker, GsmCdmaCall gsmCdmaCall) {
        super(gsmCdmaPhone.getPhoneType());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(com.android.internal.telephony.GsmCdmaPhone java.lang.String com.android.internal.telephony.GsmCdmaCallTracker com.android.internal.telephony.GsmCdmaCall ), 0, this, gsmCdmaPhone, string2, gsmCdmaCallTracker, gsmCdmaCall);
    }

    private void __constructor__(Context context, CdmaCallWaitingNotification cdmaCallWaitingNotification, GsmCdmaCallTracker gsmCdmaCallTracker, GsmCdmaCall gsmCdmaCall) {
        this.$$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(context, cdmaCallWaitingNotification, gsmCdmaCallTracker, gsmCdmaCall);
    }

    public GsmCdmaConnection(Context context, CdmaCallWaitingNotification cdmaCallWaitingNotification, GsmCdmaCallTracker gsmCdmaCallTracker, GsmCdmaCall gsmCdmaCall) {
        super(gsmCdmaCall.getPhone().getPhoneType());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaConnection$__constructor__(android.content.Context com.android.internal.telephony.cdma.CdmaCallWaitingNotification com.android.internal.telephony.GsmCdmaCallTracker com.android.internal.telephony.GsmCdmaCall ), 0, this, context, cdmaCallWaitingNotification, gsmCdmaCallTracker, gsmCdmaCall);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_GsmCdmaConnection$dispose(), 0, this);
    }

    static boolean equalsHandlesNulls(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equalsHandlesNulls", $$robo$$com_android_internal_telephony_GsmCdmaConnection$equalsHandlesNulls(java.lang.Object java.lang.Object ), 0, (Object)object, (Object)object2);
    }

    public static String formatDialString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("formatDialString", $$robo$$com_android_internal_telephony_GsmCdmaConnection$formatDialString(java.lang.String ), 0, (String)string2);
    }

    boolean compareTo(DriverCall driverCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$com_android_internal_telephony_GsmCdmaConnection$compareTo(com.android.internal.telephony.DriverCall ), 0, this, driverCall);
    }

    @Override
    public String getOrigDialString() {
        return InvokeDynamicSupport.bootstrap("getOrigDialString", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getOrigDialString(), 0, this);
    }

    @Override
    public GsmCdmaCall getCall() {
        return InvokeDynamicSupport.bootstrap("getCall", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getCall(), 0, this);
    }

    @Override
    public long getDisconnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDisconnectTime", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getDisconnectTime(), 0, this);
    }

    @Override
    public long getHoldDurationMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldDurationMillis", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getHoldDurationMillis(), 0, this);
    }

    @Override
    public Call.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getState(), 0, this);
    }

    @Override
    public void hangup() throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_GsmCdmaConnection$hangup(), 0, this);
    }

    @Override
    public void separate() throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_GsmCdmaConnection$separate(), 0, this);
    }

    @Override
    public void proceedAfterWaitChar() {
        InvokeDynamicSupport.bootstrap("proceedAfterWaitChar", $$robo$$com_android_internal_telephony_GsmCdmaConnection$proceedAfterWaitChar(), 0, this);
    }

    @Override
    public void proceedAfterWildChar(String string2) {
        InvokeDynamicSupport.bootstrap("proceedAfterWildChar", $$robo$$com_android_internal_telephony_GsmCdmaConnection$proceedAfterWildChar(java.lang.String ), 0, this, string2);
    }

    @Override
    public void cancelPostDial() {
        InvokeDynamicSupport.bootstrap("cancelPostDial", $$robo$$com_android_internal_telephony_GsmCdmaConnection$cancelPostDial(), 0, this);
    }

    void onHangupLocal() {
        InvokeDynamicSupport.bootstrap("onHangupLocal", $$robo$$com_android_internal_telephony_GsmCdmaConnection$onHangupLocal(), 0, this);
    }

    int disconnectCauseFromCode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("disconnectCauseFromCode", $$robo$$com_android_internal_telephony_GsmCdmaConnection$disconnectCauseFromCode(int ), 0, this, n);
    }

    void onRemoteDisconnect(int n, String string2) {
        InvokeDynamicSupport.bootstrap("onRemoteDisconnect", $$robo$$com_android_internal_telephony_GsmCdmaConnection$onRemoteDisconnect(int java.lang.String ), 0, this, n, string2);
    }

    @Override
    public boolean onDisconnect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$com_android_internal_telephony_GsmCdmaConnection$onDisconnect(int ), 0, this, n);
    }

    void onLocalDisconnect() {
        InvokeDynamicSupport.bootstrap("onLocalDisconnect", $$robo$$com_android_internal_telephony_GsmCdmaConnection$onLocalDisconnect(), 0, this);
    }

    public boolean update(DriverCall driverCall) {
        return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_GsmCdmaConnection$update(com.android.internal.telephony.DriverCall ), 0, this, driverCall);
    }

    void fakeHoldBeforeDial() {
        InvokeDynamicSupport.bootstrap("fakeHoldBeforeDial", $$robo$$com_android_internal_telephony_GsmCdmaConnection$fakeHoldBeforeDial(), 0, this);
    }

    int getGsmCdmaIndex() throws CallStateException {
        return (int)InvokeDynamicSupport.bootstrap("getGsmCdmaIndex", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getGsmCdmaIndex(), 0, this);
    }

    void onConnectedInOrOut() {
        InvokeDynamicSupport.bootstrap("onConnectedInOrOut", $$robo$$com_android_internal_telephony_GsmCdmaConnection$onConnectedInOrOut(), 0, this);
    }

    private void doDisconnect() {
        InvokeDynamicSupport.bootstrap("doDisconnect", $$robo$$com_android_internal_telephony_GsmCdmaConnection$doDisconnect(), 0, this);
    }

    void onStartedHolding() {
        InvokeDynamicSupport.bootstrap("onStartedHolding", $$robo$$com_android_internal_telephony_GsmCdmaConnection$onStartedHolding(), 0, this);
    }

    private boolean processPostDialChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("processPostDialChar", $$robo$$com_android_internal_telephony_GsmCdmaConnection$processPostDialChar(char ), 0, this, c);
    }

    @Override
    public String getRemainingPostDialString() {
        return InvokeDynamicSupport.bootstrap("getRemainingPostDialString", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getRemainingPostDialString(), 0, this);
    }

    public void updateParent(GsmCdmaCall gsmCdmaCall, GsmCdmaCall gsmCdmaCall2) {
        InvokeDynamicSupport.bootstrap("updateParent", $$robo$$com_android_internal_telephony_GsmCdmaConnection$updateParent(com.android.internal.telephony.GsmCdmaCall com.android.internal.telephony.GsmCdmaCall ), 0, this, gsmCdmaCall, gsmCdmaCall2);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_GsmCdmaConnection$finalize(), 0, this);
    }

    private void processNextPostDialChar() {
        InvokeDynamicSupport.bootstrap("processNextPostDialChar", $$robo$$com_android_internal_telephony_GsmCdmaConnection$processNextPostDialChar(), 0, this);
    }

    private boolean isConnectingInOrOut() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectingInOrOut", $$robo$$com_android_internal_telephony_GsmCdmaConnection$isConnectingInOrOut(), 0, this);
    }

    private GsmCdmaCall parentFromDCState(DriverCall.State state) {
        return InvokeDynamicSupport.bootstrap("parentFromDCState", $$robo$$com_android_internal_telephony_GsmCdmaConnection$parentFromDCState(com.android.internal.telephony.DriverCall$State ), 0, this, state);
    }

    private void setPostDialState(Connection.PostDialState postDialState) {
        InvokeDynamicSupport.bootstrap("setPostDialState", $$robo$$com_android_internal_telephony_GsmCdmaConnection$setPostDialState(com.android.internal.telephony.Connection$PostDialState ), 0, this, postDialState);
    }

    private void createWakeLock(Context context) {
        InvokeDynamicSupport.bootstrap("createWakeLock", $$robo$$com_android_internal_telephony_GsmCdmaConnection$createWakeLock(android.content.Context ), 0, this, context);
    }

    private void acquireWakeLock() {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$com_android_internal_telephony_GsmCdmaConnection$acquireWakeLock(), 0, this);
    }

    private void releaseWakeLock() {
        InvokeDynamicSupport.bootstrap("releaseWakeLock", $$robo$$com_android_internal_telephony_GsmCdmaConnection$releaseWakeLock(), 0, this);
    }

    private void releaseAllWakeLocks() {
        InvokeDynamicSupport.bootstrap("releaseAllWakeLocks", $$robo$$com_android_internal_telephony_GsmCdmaConnection$releaseAllWakeLocks(), 0, this);
    }

    private static boolean isPause(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPause", $$robo$$com_android_internal_telephony_GsmCdmaConnection$isPause(char ), 0, (char)c);
    }

    private static boolean isWait(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWait", $$robo$$com_android_internal_telephony_GsmCdmaConnection$isWait(char ), 0, (char)c);
    }

    private static boolean isWild(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWild", $$robo$$com_android_internal_telephony_GsmCdmaConnection$isWild(char ), 0, (char)c);
    }

    private static int findNextPCharOrNonPOrNonWCharIndex(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findNextPCharOrNonPOrNonWCharIndex", $$robo$$com_android_internal_telephony_GsmCdmaConnection$findNextPCharOrNonPOrNonWCharIndex(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static char findPOrWCharToAppend(String string2, int n, int n2) {
        return (char)InvokeDynamicSupport.bootstrapStatic("findPOrWCharToAppend", $$robo$$com_android_internal_telephony_GsmCdmaConnection$findPOrWCharToAppend(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    private String maskDialString(String string2) {
        return InvokeDynamicSupport.bootstrap("maskDialString", $$robo$$com_android_internal_telephony_GsmCdmaConnection$maskDialString(java.lang.String ), 0, this, string2);
    }

    private void fetchDtmfToneDelay(GsmCdmaPhone gsmCdmaPhone) {
        InvokeDynamicSupport.bootstrap("fetchDtmfToneDelay", $$robo$$com_android_internal_telephony_GsmCdmaConnection$fetchDtmfToneDelay(com.android.internal.telephony.GsmCdmaPhone ), 0, this, gsmCdmaPhone);
    }

    private boolean isPhoneTypeGsm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneTypeGsm", $$robo$$com_android_internal_telephony_GsmCdmaConnection$isPhoneTypeGsm(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_GsmCdmaConnection$log(java.lang.String ), 0, this, string2);
    }

    @Override
    public int getNumberPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberPresentation", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getNumberPresentation(), 0, this);
    }

    @Override
    public UUSInfo getUUSInfo() {
        return InvokeDynamicSupport.bootstrap("getUUSInfo", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getUUSInfo(), 0, this);
    }

    @Override
    public int getPreciseDisconnectCause() {
        return (int)InvokeDynamicSupport.bootstrap("getPreciseDisconnectCause", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getPreciseDisconnectCause(), 0, this);
    }

    @Override
    public String getVendorDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getVendorDisconnectCause", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getVendorDisconnectCause(), 0, this);
    }

    @Override
    public void migrateFrom(Connection connection) {
        InvokeDynamicSupport.bootstrap("migrateFrom", $$robo$$com_android_internal_telephony_GsmCdmaConnection$migrateFrom(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    @Override
    public Connection getOrigConnection() {
        return InvokeDynamicSupport.bootstrap("getOrigConnection", $$robo$$com_android_internal_telephony_GsmCdmaConnection$getOrigConnection(), 0, this);
    }

    @Override
    public boolean isMultiparty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiparty", $$robo$$com_android_internal_telephony_GsmCdmaConnection$isMultiparty(), 0, this);
    }

    public /* synthetic */ GsmCdmaConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmCdmaConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ GsmCdmaConnection this$0;

        private void $$robo$$com_android_internal_telephony_GsmCdmaConnection_MyHandler$__constructor__(GsmCdmaConnection this$0, Looper l) {
        }

        private final void $$robo$$com_android_internal_telephony_GsmCdmaConnection_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 2: 
                case 3: 
                case 5: {
                    this.this$0.processNextPostDialChar();
                    break;
                }
                case 4: {
                    this.this$0.releaseWakeLock();
                    break;
                }
                case 1: {
                    this.this$0.mHandler.sendMessageDelayed(this.this$0.mHandler.obtainMessage(5), this.this$0.mDtmfToneDelay);
                }
            }
        }

        private void __constructor__(GsmCdmaConnection gsmCdmaConnection, Looper looper) {
            this.$$robo$$com_android_internal_telephony_GsmCdmaConnection_MyHandler$__constructor__(gsmCdmaConnection, looper);
        }

        MyHandler(GsmCdmaConnection gsmCdmaConnection, Looper looper) {
            this.this$0 = gsmCdmaConnection;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaConnection_MyHandler$__constructor__(com.android.internal.telephony.GsmCdmaConnection android.os.Looper ), 0, this, gsmCdmaConnection, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_GsmCdmaConnection_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

