/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.res.Resources;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class CarrierAppUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CarrierAppUtils";
    private static boolean DEBUG = false;

    private void $$robo$$com_android_internal_telephony_CarrierAppUtils$__constructor__() {
    }

    private static final synchronized void $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, TelephonyManager telephonyManager, int userId) {
        String[] systemCarrierAppsDisabledUntilUsed = Resources.getSystem().getStringArray(17236024);
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(callingPackage, packageManager, telephonyManager, userId, systemCarrierAppsDisabledUntilUsed);
    }

    private static final synchronized void $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, int userId) {
        String[] systemCarrierAppsDisabledUntilUsed = Resources.getSystem().getStringArray(17236024);
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(callingPackage, packageManager, null, userId, systemCarrierAppsDisabledUntilUsed);
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, TelephonyManager telephonyManager, int userId, String[] systemCarrierAppsDisabledUntilUsed) {
        List<ApplicationInfo> candidates = CarrierAppUtils.getDefaultCarrierAppCandidatesHelper(packageManager, userId, systemCarrierAppsDisabledUntilUsed);
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        ArrayList<String> enabledCarrierPackages = new ArrayList<String>();
        try {
            for (ApplicationInfo ai : candidates) {
                boolean hasPrivileges;
                String packageName = ai.packageName;
                boolean bl = hasPrivileges = telephonyManager != null && telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
                if (!ai.isUpdatedSystemApp()) {
                    if (hasPrivileges && (ai.enabledSetting == 0 || ai.enabledSetting == 4)) {
                        Slog.i("CarrierAppUtils", "Update state(" + packageName + "): ENABLED for user " + userId);
                        packageManager.setApplicationEnabledSetting(packageName, 1, 1, userId, callingPackage);
                    } else if (!hasPrivileges && ai.enabledSetting == 0) {
                        Slog.i("CarrierAppUtils", "Update state(" + packageName + "): DISABLED_UNTIL_USED for user " + userId);
                        packageManager.setApplicationEnabledSetting(packageName, 4, 0, userId, callingPackage);
                    }
                }
                if (!hasPrivileges) continue;
                enabledCarrierPackages.add(ai.packageName);
            }
            if (!enabledCarrierPackages.isEmpty()) {
                String[] packageNames = new String[enabledCarrierPackages.size()];
                enabledCarrierPackages.toArray(packageNames);
                packageManager.grantDefaultPermissionsToEnabledCarrierApps(packageNames, userId);
            }
        }
        catch (RemoteException e) {
            Slog.w("CarrierAppUtils", "Could not reach PackageManager", e);
        }
    }

    private static final List<ApplicationInfo> $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierApps(IPackageManager packageManager, TelephonyManager telephonyManager, int userId) {
        List<ApplicationInfo> candidates = CarrierAppUtils.getDefaultCarrierAppCandidates(packageManager, userId);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (int i = candidates.size() - 1; i >= 0; --i) {
            boolean hasPrivileges;
            ApplicationInfo ai = candidates.get(i);
            String packageName = ai.packageName;
            boolean bl = hasPrivileges = telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
            if (hasPrivileges) continue;
            candidates.remove(i);
        }
        return candidates;
    }

    private static final List<ApplicationInfo> $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAppCandidates(IPackageManager packageManager, int userId) {
        String[] systemCarrierAppsDisabledUntilUsed = Resources.getSystem().getStringArray(17236024);
        return CarrierAppUtils.getDefaultCarrierAppCandidatesHelper(packageManager, userId, systemCarrierAppsDisabledUntilUsed);
    }

    private static final List<ApplicationInfo> $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAppCandidatesHelper(IPackageManager packageManager, int userId, String[] systemCarrierAppsDisabledUntilUsed) {
        if (systemCarrierAppsDisabledUntilUsed == null || systemCarrierAppsDisabledUntilUsed.length == 0) {
            return null;
        }
        ArrayList<ApplicationInfo> apps = null;
        try {
            apps = new ArrayList<ApplicationInfo>(systemCarrierAppsDisabledUntilUsed.length);
            for (String packageName : systemCarrierAppsDisabledUntilUsed) {
                ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 32768, userId);
                if (ai == null || !ai.isSystemApp()) continue;
                apps.add(ai);
            }
        }
        catch (RemoteException e) {
            Slog.w("CarrierAppUtils", "Could not reach PackageManager", e);
        }
        return apps;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_CarrierAppUtils$__constructor__();
    }

    private CarrierAppUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierAppUtils$__constructor__(), 0, this);
    }

    public static synchronized void disableCarrierAppsUntilPrivileged(String string2, IPackageManager iPackageManager, TelephonyManager telephonyManager, int n) {
        InvokeDynamicSupport.bootstrapStatic("disableCarrierAppsUntilPrivileged", $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(java.lang.String android.content.pm.IPackageManager android.telephony.TelephonyManager int ), 0, (String)string2, (IPackageManager)iPackageManager, (TelephonyManager)telephonyManager, (int)n);
    }

    public static synchronized void disableCarrierAppsUntilPrivileged(String string2, IPackageManager iPackageManager, int n) {
        InvokeDynamicSupport.bootstrapStatic("disableCarrierAppsUntilPrivileged", $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(java.lang.String android.content.pm.IPackageManager int ), 0, (String)string2, (IPackageManager)iPackageManager, (int)n);
    }

    public static void disableCarrierAppsUntilPrivileged(String string2, IPackageManager iPackageManager, TelephonyManager telephonyManager, int n, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("disableCarrierAppsUntilPrivileged", $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(java.lang.String android.content.pm.IPackageManager android.telephony.TelephonyManager int java.lang.String[] ), 0, (String)string2, (IPackageManager)iPackageManager, (TelephonyManager)telephonyManager, (int)n, (String[])stringArray);
    }

    public static List<ApplicationInfo> getDefaultCarrierApps(IPackageManager iPackageManager, TelephonyManager telephonyManager, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultCarrierApps", $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierApps(android.content.pm.IPackageManager android.telephony.TelephonyManager int ), 0, (IPackageManager)iPackageManager, (TelephonyManager)telephonyManager, (int)n);
    }

    public static List<ApplicationInfo> getDefaultCarrierAppCandidates(IPackageManager iPackageManager, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultCarrierAppCandidates", $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAppCandidates(android.content.pm.IPackageManager int ), 0, (IPackageManager)iPackageManager, (int)n);
    }

    private static List<ApplicationInfo> getDefaultCarrierAppCandidatesHelper(IPackageManager iPackageManager, int n, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultCarrierAppCandidatesHelper", $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAppCandidatesHelper(android.content.pm.IPackageManager int java.lang.String[] ), 0, (IPackageManager)iPackageManager, (int)n, (String[])stringArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierAppUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

