/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiPowerEstimator
extends PowerCalculator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "WifiPowerEstimator";
    private double mWifiPowerPerPacket;
    private double mWifiPowerOn;
    private double mWifiPowerScan;
    private double mWifiPowerBatchScan;
    private long mTotalAppWifiRunningTimeMs;

    private void $$robo$$com_android_internal_os_WifiPowerEstimator$__constructor__(PowerProfile profile) {
        this.mTotalAppWifiRunningTimeMs = 0L;
        this.mWifiPowerPerPacket = WifiPowerEstimator.getWifiPowerPerPacket(profile);
        this.mWifiPowerOn = profile.getAveragePower("wifi.on");
        this.mWifiPowerScan = profile.getAveragePower("wifi.scan");
        this.mWifiPowerBatchScan = profile.getAveragePower("wifi.batchedscan");
    }

    private static final double $$robo$$com_android_internal_os_WifiPowerEstimator$getWifiPowerPerPacket(PowerProfile profile) {
        long WIFI_BPS = 1000000L;
        double WIFI_POWER = profile.getAveragePower("wifi.active") / 3600.0;
        return WIFI_POWER / 61.03515625 / 3600.0;
    }

    private final void $$robo$$com_android_internal_os_WifiPowerEstimator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        app.wifiRxPackets = u.getNetworkActivityPackets(2, statsType);
        app.wifiTxPackets = u.getNetworkActivityPackets(3, statsType);
        app.wifiRxBytes = u.getNetworkActivityBytes(2, statsType);
        app.wifiTxBytes = u.getNetworkActivityBytes(3, statsType);
        double wifiPacketPower = (double)(app.wifiRxPackets + app.wifiTxPackets) * this.mWifiPowerPerPacket;
        app.wifiRunningTimeMs = u.getWifiRunningTime(rawRealtimeUs, statsType) / 1000L;
        this.mTotalAppWifiRunningTimeMs += app.wifiRunningTimeMs;
        double wifiLockPower = (double)app.wifiRunningTimeMs * this.mWifiPowerOn / 3600000.0;
        long wifiScanTimeMs = u.getWifiScanTime(rawRealtimeUs, statsType) / 1000L;
        double wifiScanPower = (double)wifiScanTimeMs * this.mWifiPowerScan / 3600000.0;
        double wifiBatchScanPower = 0.0;
        for (int bin = 0; bin < 5; ++bin) {
            long batchScanTimeMs = u.getWifiBatchedScanTime(bin, rawRealtimeUs, statsType) / 1000L;
            double batchScanPower = (double)batchScanTimeMs * this.mWifiPowerBatchScan / 3600000.0;
            wifiBatchScanPower += batchScanPower;
        }
        app.wifiPowerMah = wifiPacketPower + wifiLockPower + wifiScanPower + wifiBatchScanPower;
    }

    private final void $$robo$$com_android_internal_os_WifiPowerEstimator$calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long totalRunningTimeMs = stats.getGlobalWifiRunningTime(rawRealtimeUs, statsType) / 1000L;
        double powerDrain = (double)(totalRunningTimeMs - this.mTotalAppWifiRunningTimeMs) * this.mWifiPowerOn / 3600000.0;
        app.wifiRunningTimeMs = totalRunningTimeMs;
        app.wifiPowerMah = Math.max(0.0, powerDrain);
    }

    private final void $$robo$$com_android_internal_os_WifiPowerEstimator$reset() {
        this.mTotalAppWifiRunningTimeMs = 0L;
    }

    private void __constructor__(PowerProfile powerProfile) {
        this.$$robo$$com_android_internal_os_WifiPowerEstimator$__constructor__(powerProfile);
    }

    public WifiPowerEstimator(PowerProfile powerProfile) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_WifiPowerEstimator$__constructor__(com.android.internal.os.PowerProfile ), 0, this, powerProfile);
    }

    private static double getWifiPowerPerPacket(PowerProfile powerProfile) {
        return (double)InvokeDynamicSupport.bootstrapStatic("getWifiPowerPerPacket", $$robo$$com_android_internal_os_WifiPowerEstimator$getWifiPowerPerPacket(com.android.internal.os.PowerProfile ), 0, (PowerProfile)powerProfile);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_WifiPowerEstimator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), 0, this, batterySipper, uid, l, l2, n);
    }

    @Override
    public void calculateRemaining(BatterySipper batterySipper, BatteryStats batteryStats, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateRemaining", $$robo$$com_android_internal_os_WifiPowerEstimator$calculateRemaining(com.android.internal.os.BatterySipper android.os.BatteryStats long long int ), 0, this, batterySipper, batteryStats, l, l2, n);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_WifiPowerEstimator$reset(), 0, this);
    }

    public /* synthetic */ WifiPowerEstimator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiPowerEstimator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

