/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiPowerCalculator
extends PowerCalculator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "WifiPowerCalculator";
    private double mIdleCurrentMa;
    private double mTxCurrentMa;
    private double mRxCurrentMa;
    private double mTotalAppPowerDrain;
    private long mTotalAppRunningTime;

    private void $$robo$$com_android_internal_os_WifiPowerCalculator$__constructor__(PowerProfile profile) {
        this.mTotalAppPowerDrain = 0.0;
        this.mTotalAppRunningTime = 0L;
        this.mIdleCurrentMa = profile.getAveragePower("wifi.controller.idle");
        this.mTxCurrentMa = profile.getAveragePower("wifi.controller.tx");
        this.mRxCurrentMa = profile.getAveragePower("wifi.controller.rx");
    }

    private final void $$robo$$com_android_internal_os_WifiPowerCalculator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.ControllerActivityCounter counter = u.getWifiControllerActivity();
        if (counter == null) {
            return;
        }
        long idleTime = counter.getIdleTimeCounter().getCountLocked(statsType);
        long txTime = counter.getTxTimeCounters()[0].getCountLocked(statsType);
        long rxTime = counter.getRxTimeCounter().getCountLocked(statsType);
        app.wifiRunningTimeMs = idleTime + rxTime + txTime;
        this.mTotalAppRunningTime += app.wifiRunningTimeMs;
        app.wifiPowerMah = ((double)idleTime * this.mIdleCurrentMa + (double)txTime * this.mTxCurrentMa + (double)rxTime * this.mRxCurrentMa) / 3600000.0;
        this.mTotalAppPowerDrain += app.wifiPowerMah;
        app.wifiRxPackets = u.getNetworkActivityPackets(2, statsType);
        app.wifiTxPackets = u.getNetworkActivityPackets(3, statsType);
        app.wifiRxBytes = u.getNetworkActivityBytes(2, statsType);
        app.wifiTxBytes = u.getNetworkActivityBytes(3, statsType);
    }

    private final void $$robo$$com_android_internal_os_WifiPowerCalculator$calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.ControllerActivityCounter counter = stats.getWifiControllerActivity();
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(statsType);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(statsType);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(statsType);
        app.wifiRunningTimeMs = Math.max(0L, idleTimeMs + rxTimeMs + txTimeMs - this.mTotalAppRunningTime);
        double powerDrainMah = (double)counter.getPowerCounter().getCountLocked(statsType) / 3600000.0;
        if (powerDrainMah == 0.0) {
            powerDrainMah = ((double)idleTimeMs * this.mIdleCurrentMa + (double)txTimeMs * this.mTxCurrentMa + (double)rxTimeMs * this.mRxCurrentMa) / 3600000.0;
        }
        app.wifiPowerMah = Math.max(0.0, powerDrainMah - this.mTotalAppPowerDrain);
    }

    private final void $$robo$$com_android_internal_os_WifiPowerCalculator$reset() {
        this.mTotalAppPowerDrain = 0.0;
        this.mTotalAppRunningTime = 0L;
    }

    private void __constructor__(PowerProfile powerProfile) {
        this.$$robo$$com_android_internal_os_WifiPowerCalculator$__constructor__(powerProfile);
    }

    public WifiPowerCalculator(PowerProfile powerProfile) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_WifiPowerCalculator$__constructor__(com.android.internal.os.PowerProfile ), 0, this, powerProfile);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_WifiPowerCalculator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), 0, this, batterySipper, uid, l, l2, n);
    }

    @Override
    public void calculateRemaining(BatterySipper batterySipper, BatteryStats batteryStats, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateRemaining", $$robo$$com_android_internal_os_WifiPowerCalculator$calculateRemaining(com.android.internal.os.BatterySipper android.os.BatteryStats long long int ), 0, this, batterySipper, batteryStats, l, l2, n);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_WifiPowerCalculator$reset(), 0, this);
    }

    public /* synthetic */ WifiPowerCalculator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiPowerCalculator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

