/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TransferPipe
implements Runnable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "TransferPipe";
    static boolean DEBUG = false;
    static long DEFAULT_TIMEOUT = 5000L;
    Thread mThread;
    ParcelFileDescriptor[] mFds;
    FileDescriptor mOutFd;
    long mEndTime;
    String mFailure;
    boolean mComplete;
    String mBufferPrefix;

    private void $$robo$$com_android_internal_os_TransferPipe$__constructor__() throws IOException {
        this.mThread = new Thread((Runnable)this, "TransferPipe");
        this.mFds = ParcelFileDescriptor.createPipe();
    }

    private final ParcelFileDescriptor $$robo$$com_android_internal_os_TransferPipe$getReadFd() {
        return this.mFds[0];
    }

    private final ParcelFileDescriptor $$robo$$com_android_internal_os_TransferPipe$getWriteFd() {
        return this.mFds[1];
    }

    private final void $$robo$$com_android_internal_os_TransferPipe$setBufferPrefix(String prefix) {
        this.mBufferPrefix = prefix;
    }

    private static final void $$robo$$com_android_internal_os_TransferPipe$go(Caller caller, IInterface iface, FileDescriptor out, String prefix, String[] args) throws IOException, RemoteException {
        TransferPipe.go(caller, iface, out, prefix, args, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_os_TransferPipe$go(Caller caller, IInterface iface, FileDescriptor out, String prefix, String[] args, long timeout) throws IOException, RemoteException {
        if (iface.asBinder() instanceof Binder) {
            try {
                caller.go(iface, out, prefix, args);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        TransferPipe tp = new TransferPipe();
        try {
            caller.go(iface, tp.getWriteFd().getFileDescriptor(), prefix, args);
            tp.go(out, timeout);
        }
        finally {
            tp.kill();
        }
    }

    private static final void $$robo$$com_android_internal_os_TransferPipe$goDump(IBinder binder, FileDescriptor out, String[] args) throws IOException, RemoteException {
        TransferPipe.goDump(binder, out, args, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_os_TransferPipe$goDump(IBinder binder, FileDescriptor out, String[] args, long timeout) throws IOException, RemoteException {
        if (binder instanceof Binder) {
            try {
                binder.dump(out, args);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        TransferPipe tp = new TransferPipe();
        try {
            binder.dumpAsync(tp.getWriteFd().getFileDescriptor(), args);
            tp.go(out, timeout);
        }
        finally {
            tp.kill();
        }
    }

    private final void $$robo$$com_android_internal_os_TransferPipe$go(FileDescriptor out) throws IOException {
        this.go(out, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_TransferPipe$go(FileDescriptor out, long timeout) throws IOException {
        try {
            TransferPipe transferPipe = this;
            synchronized (transferPipe) {
                this.mOutFd = out;
                this.mEndTime = SystemClock.uptimeMillis() + timeout;
                this.closeFd(1);
                this.mThread.start();
                while (this.mFailure == null && !this.mComplete) {
                    long waitTime = this.mEndTime - SystemClock.uptimeMillis();
                    if (waitTime <= 0L) {
                        this.mThread.interrupt();
                        throw new IOException("Timeout");
                    }
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.mFailure != null) {
                    throw new IOException(this.mFailure);
                }
            }
        }
        finally {
            this.kill();
        }
    }

    private final void $$robo$$com_android_internal_os_TransferPipe$closeFd(int num) {
        if (this.mFds[num] != null) {
            try {
                this.mFds[num].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mFds[num] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_TransferPipe$kill() {
        TransferPipe transferPipe = this;
        synchronized (transferPipe) {
            this.closeFd(0);
            this.closeFd(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void $$robo$$com_android_internal_os_TransferPipe$run() {
        FileOutputStream fos;
        FileInputStream fis;
        byte[] buffer = new byte[1024];
        TransferPipe transferPipe = this;
        synchronized (transferPipe) {
            ParcelFileDescriptor readFd = this.getReadFd();
            if (readFd == null) {
                Slog.w("TransferPipe", "Pipe has been closed...");
                return;
            }
            fis = new FileInputStream(readFd.getFileDescriptor());
            fos = new FileOutputStream(this.mOutFd);
        }
        byte[] bufferPrefix = null;
        boolean needPrefix = true;
        if (this.mBufferPrefix != null) {
            bufferPrefix = this.mBufferPrefix.getBytes();
        }
        try {
            int size;
            while ((size = fis.read(buffer)) > 0) {
                if (bufferPrefix == null) {
                    fos.write(buffer, 0, size);
                    continue;
                }
                int start = 0;
                for (int i = 0; i < size; ++i) {
                    if (buffer[i] == 10) continue;
                    if (i > start) {
                        fos.write(buffer, start, i - start);
                    }
                    start = i;
                    if (needPrefix) {
                        fos.write(bufferPrefix);
                        needPrefix = false;
                    }
                    while (++i < size && buffer[i] != 10) {
                    }
                    if (i >= size) continue;
                    needPrefix = true;
                }
                if (size <= start) continue;
                fos.write(buffer, start, size - start);
            }
            if (!this.mThread.isInterrupted()) {
                // empty if block
            }
        }
        catch (IOException e) {
            TransferPipe transferPipe2 = this;
            synchronized (transferPipe2) {
                this.mFailure = e.toString();
                this.notifyAll();
                return;
            }
        }
        TransferPipe transferPipe3 = this;
        synchronized (transferPipe3) {
            this.mComplete = true;
            this.notifyAll();
            return;
        }
    }

    private void __constructor__() throws IOException {
        this.$$robo$$com_android_internal_os_TransferPipe$__constructor__();
    }

    public TransferPipe() throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_TransferPipe$__constructor__(), 0, this);
    }

    ParcelFileDescriptor getReadFd() {
        return InvokeDynamicSupport.bootstrap("getReadFd", $$robo$$com_android_internal_os_TransferPipe$getReadFd(), 0, this);
    }

    public ParcelFileDescriptor getWriteFd() {
        return InvokeDynamicSupport.bootstrap("getWriteFd", $$robo$$com_android_internal_os_TransferPipe$getWriteFd(), 0, this);
    }

    public void setBufferPrefix(String string2) {
        InvokeDynamicSupport.bootstrap("setBufferPrefix", $$robo$$com_android_internal_os_TransferPipe$setBufferPrefix(java.lang.String ), 0, this, string2);
    }

    static void go(Caller caller, IInterface iInterface, FileDescriptor fileDescriptor, String string2, String[] stringArray) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("go", $$robo$$com_android_internal_os_TransferPipe$go(com.android.internal.os.TransferPipe$Caller android.os.IInterface java.io.FileDescriptor java.lang.String java.lang.String[] ), 0, (Caller)caller, (IInterface)iInterface, (FileDescriptor)fileDescriptor, (String)string2, (String[])stringArray);
    }

    static void go(Caller caller, IInterface iInterface, FileDescriptor fileDescriptor, String string2, String[] stringArray, long l) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("go", $$robo$$com_android_internal_os_TransferPipe$go(com.android.internal.os.TransferPipe$Caller android.os.IInterface java.io.FileDescriptor java.lang.String java.lang.String[] long ), 0, (Caller)caller, (IInterface)iInterface, (FileDescriptor)fileDescriptor, (String)string2, (String[])stringArray, (long)l);
    }

    static void goDump(IBinder iBinder, FileDescriptor fileDescriptor, String[] stringArray) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("goDump", $$robo$$com_android_internal_os_TransferPipe$goDump(android.os.IBinder java.io.FileDescriptor java.lang.String[] ), 0, (IBinder)iBinder, (FileDescriptor)fileDescriptor, (String[])stringArray);
    }

    static void goDump(IBinder iBinder, FileDescriptor fileDescriptor, String[] stringArray, long l) throws IOException, RemoteException {
        InvokeDynamicSupport.bootstrapStatic("goDump", $$robo$$com_android_internal_os_TransferPipe$goDump(android.os.IBinder java.io.FileDescriptor java.lang.String[] long ), 0, (IBinder)iBinder, (FileDescriptor)fileDescriptor, (String[])stringArray, (long)l);
    }

    public void go(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("go", $$robo$$com_android_internal_os_TransferPipe$go(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    public void go(FileDescriptor fileDescriptor, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("go", $$robo$$com_android_internal_os_TransferPipe$go(java.io.FileDescriptor long ), 0, this, fileDescriptor, l);
    }

    void closeFd(int n) {
        InvokeDynamicSupport.bootstrap("closeFd", $$robo$$com_android_internal_os_TransferPipe$closeFd(int ), 0, this, n);
    }

    public void kill() {
        InvokeDynamicSupport.bootstrap("kill", $$robo$$com_android_internal_os_TransferPipe$kill(), 0, this);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_TransferPipe$run(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransferPipe)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface Caller
    extends InstrumentedInterface {
        public void go(IInterface var1, FileDescriptor var2, String var3, String[] var4) throws RemoteException;
    }
}

