/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Process;
import android.util.Slog;
import com.android.internal.os.KernelWakelockStats;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KernelWakelockReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "KernelWakelockReader";
    private static int sKernelWakelockUpdateVersion;
    private static String sWakelockFile = "/proc/wakelocks";
    private static String sWakeupSourceFile = "/d/wakeup_sources";
    private static int[] PROC_WAKELOCKS_FORMAT;
    private static int[] WAKEUP_SOURCES_FORMAT;
    private String[] mProcWakelocksName;
    private long[] mProcWakelocksData;

    private void $$robo$$com_android_internal_os_KernelWakelockReader$__constructor__() {
        this.mProcWakelocksName = new String[3];
        this.mProcWakelocksData = new long[3];
    }

    private final KernelWakelockStats $$robo$$com_android_internal_os_KernelWakelockReader$readKernelWakelockStats(KernelWakelockStats staleStats) {
        int len;
        boolean wakeup_sources;
        byte[] buffer = new byte[32768];
        try {
            FileInputStream is;
            try {
                is = new FileInputStream("/proc/wakelocks");
                wakeup_sources = false;
            }
            catch (FileNotFoundException e) {
                try {
                    is = new FileInputStream("/d/wakeup_sources");
                    wakeup_sources = true;
                }
                catch (FileNotFoundException e2) {
                    Slog.wtf("KernelWakelockReader", "neither /proc/wakelocks nor /d/wakeup_sources exists");
                    return null;
                }
            }
            len = is.read(buffer);
            is.close();
        }
        catch (IOException e) {
            Slog.wtf("KernelWakelockReader", "failed to read kernel wakelocks", e);
            return null;
        }
        if (len > 0) {
            if (len >= buffer.length) {
                Slog.wtf("KernelWakelockReader", "Kernel wake locks exceeded buffer size " + buffer.length);
            }
            for (int i = 0; i < len; ++i) {
                if (buffer[i] != 0) continue;
                len = i;
                break;
            }
        }
        return this.parseProcWakelocks(buffer, len, wakeup_sources, staleStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KernelWakelockStats $$robo$$com_android_internal_os_KernelWakelockReader$parseProcWakelocks(byte[] wlBuffer, int len, boolean wakeup_sources, KernelWakelockStats staleStats) {
        int endIndex;
        int i;
        for (i = 0; i < len && wlBuffer[i] != 10 && wlBuffer[i] != 0; ++i) {
        }
        int startIndex = endIndex = i + 1;
        KernelWakelockReader kernelWakelockReader = this;
        synchronized (kernelWakelockReader) {
            ++sKernelWakelockUpdateVersion;
            while (endIndex < len) {
                for (endIndex = startIndex; endIndex < len && wlBuffer[endIndex] != 10 && wlBuffer[endIndex] != 0; ++endIndex) {
                }
                if (endIndex > len - 1) break;
                String[] nameStringArray = this.mProcWakelocksName;
                long[] wlData = this.mProcWakelocksData;
                for (int j = startIndex; j < endIndex; ++j) {
                    if ((wlBuffer[j] & 0x80) == 0) continue;
                    wlBuffer[j] = 63;
                }
                boolean parsed = Process.parseProcLine(wlBuffer, startIndex, endIndex, wakeup_sources ? WAKEUP_SOURCES_FORMAT : PROC_WAKELOCKS_FORMAT, nameStringArray, wlData, null);
                String name = nameStringArray[0];
                int count = (int)wlData[1];
                long totalTime = wakeup_sources ? wlData[2] * 1000L : (wlData[2] + 500L) / 1000L;
                if (parsed && name.length() > 0) {
                    if (!staleStats.containsKey(name)) {
                        staleStats.put(name, new KernelWakelockStats.Entry(count, totalTime, sKernelWakelockUpdateVersion));
                    } else {
                        KernelWakelockStats.Entry kwlStats = (KernelWakelockStats.Entry)staleStats.get(name);
                        if (kwlStats.mVersion == sKernelWakelockUpdateVersion) {
                            kwlStats.mCount += count;
                            kwlStats.mTotalTime += totalTime;
                        } else {
                            kwlStats.mCount = count;
                            kwlStats.mTotalTime = totalTime;
                            kwlStats.mVersion = sKernelWakelockUpdateVersion;
                        }
                    }
                } else if (!parsed) {
                    try {
                        Slog.wtf("KernelWakelockReader", "Failed to parse proc line: " + new String(wlBuffer, startIndex, endIndex - startIndex));
                    }
                    catch (Exception e) {
                        Slog.wtf("KernelWakelockReader", "Failed to parse proc line!");
                    }
                }
                startIndex = endIndex + 1;
            }
            Iterator itr = staleStats.values().iterator();
            while (itr.hasNext()) {
                if (((KernelWakelockStats.Entry)itr.next()).mVersion == sKernelWakelockUpdateVersion) continue;
                itr.remove();
            }
            staleStats.kernelWakelockVersion = sKernelWakelockUpdateVersion;
            return staleStats;
        }
    }

    static void __staticInitializer__() {
        sKernelWakelockUpdateVersion = 0;
        PROC_WAKELOCKS_FORMAT = new int[]{5129, 8201, 9, 9, 9, 8201};
        WAKEUP_SOURCES_FORMAT = new int[]{4105, 8457, 265, 265, 265, 265, 8457};
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_KernelWakelockReader$__constructor__();
    }

    public KernelWakelockReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelWakelockReader$__constructor__(), 0, this);
    }

    public KernelWakelockStats readKernelWakelockStats(KernelWakelockStats kernelWakelockStats) {
        return InvokeDynamicSupport.bootstrap("readKernelWakelockStats", $$robo$$com_android_internal_os_KernelWakelockReader$readKernelWakelockStats(com.android.internal.os.KernelWakelockStats ), 0, this, kernelWakelockStats);
    }

    public KernelWakelockStats parseProcWakelocks(byte[] byArray, int n, boolean bl, KernelWakelockStats kernelWakelockStats) {
        return InvokeDynamicSupport.bootstrap("parseProcWakelocks", $$robo$$com_android_internal_os_KernelWakelockReader$parseProcWakelocks(byte[] int boolean com.android.internal.os.KernelWakelockStats ), 0, this, byArray, n, bl, kernelWakelockStats);
    }

    static {
        RobolectricInternals.classInitializing(KernelWakelockReader.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelWakelockReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

