/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import libcore.io.IoUtils;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InstallerConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "InstallerConnection";
    private static boolean LOCAL_DEBUG = false;
    private InputStream mIn;
    private OutputStream mOut;
    private LocalSocket mSocket;
    private volatile Object mWarnIfHeld;
    private byte[] buf;

    private void $$robo$$com_android_internal_os_InstallerConnection$__constructor__() {
        this.buf = new byte[1024];
    }

    private final void $$robo$$com_android_internal_os_InstallerConnection$setWarnIfHeld(Object warnIfHeld) {
        Preconditions.checkState(this.mWarnIfHeld == null);
        this.mWarnIfHeld = Preconditions.checkNotNull(warnIfHeld);
    }

    private final synchronized String $$robo$$com_android_internal_os_InstallerConnection$transact(String cmd) {
        int replyLength;
        if (this.mWarnIfHeld != null && Thread.holdsLock(this.mWarnIfHeld)) {
            Slog.wtf("InstallerConnection", "Calling thread " + Thread.currentThread().getName() + " is holding 0x" + Integer.toHexString(System.identityHashCode(this.mWarnIfHeld)), new Throwable());
        }
        if (!this.connect()) {
            Slog.e("InstallerConnection", "connection failed");
            return "-1";
        }
        if (!this.writeCommand(cmd)) {
            Slog.e("InstallerConnection", "write command failed? reconnect!");
            if (!this.connect() || !this.writeCommand(cmd)) {
                return "-1";
            }
        }
        if ((replyLength = this.readReply()) > 0) {
            String s = new String(this.buf, 0, replyLength);
            return s;
        }
        return "-1";
    }

    private final String[] $$robo$$com_android_internal_os_InstallerConnection$execute(String cmd, Object ... args) throws InstallerException {
        StringBuilder builder = new StringBuilder(cmd);
        for (Object arg : args) {
            String escaped = arg == null ? "" : String.valueOf(arg);
            if (escaped.indexOf(0) != -1 || escaped.indexOf(32) != -1 || "!".equals(escaped)) {
                throw new InstallerException("Invalid argument while executing " + cmd + " " + Arrays.toString(args));
            }
            if (TextUtils.isEmpty(escaped)) {
                escaped = "!";
            }
            builder.append(' ').append(escaped);
        }
        String[] resRaw = this.transact(builder.toString()).split(" ");
        int res = -1;
        try {
            res = Integer.parseInt(resRaw[0]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (res != 0) {
            throw new InstallerException("Failed to execute " + cmd + " " + Arrays.toString(args) + ": " + res);
        }
        return resRaw;
    }

    private final void $$robo$$com_android_internal_os_InstallerConnection$dexopt(String apkPath, int uid, String instructionSet, int dexoptNeeded, int dexFlags, String compilerFilter, String volumeUuid, String sharedLibraries) throws InstallerException {
        this.dexopt(apkPath, uid, "*", instructionSet, dexoptNeeded, null, dexFlags, compilerFilter, volumeUuid, sharedLibraries);
    }

    private final void $$robo$$com_android_internal_os_InstallerConnection$dexopt(String apkPath, int uid, String pkgName, String instructionSet, int dexoptNeeded, String outputPath, int dexFlags, String compilerFilter, String volumeUuid, String sharedLibraries) throws InstallerException {
        this.execute("dexopt", apkPath, uid, pkgName, instructionSet, dexoptNeeded, outputPath, dexFlags, compilerFilter, volumeUuid, sharedLibraries);
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$safeParseBooleanResult(String[] res) throws InstallerException {
        if (res == null || res.length != 2) {
            throw new InstallerException("Invalid size result: " + Arrays.toString(res));
        }
        if (!res[1].equals("true") && !res[1].equals("false")) {
            throw new InstallerException("Invalid boolean result: " + Arrays.toString(res));
        }
        return Boolean.parseBoolean(res[1]);
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$mergeProfiles(int uid, String pkgName) throws InstallerException {
        String[] res = this.execute("merge_profiles", uid, pkgName);
        return this.safeParseBooleanResult(res);
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$dumpProfiles(String gid, String packageName, String codePaths) throws InstallerException {
        String[] res = this.execute("dump_profiles", gid, packageName, codePaths);
        return this.safeParseBooleanResult(res);
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$connect() {
        if (this.mSocket != null) {
            return true;
        }
        Slog.i("InstallerConnection", "connecting...");
        try {
            this.mSocket = new LocalSocket();
            LocalSocketAddress address = new LocalSocketAddress("installd", LocalSocketAddress.Namespace.RESERVED);
            this.mSocket.connect(address);
            this.mIn = this.mSocket.getInputStream();
            this.mOut = this.mSocket.getOutputStream();
        }
        catch (IOException ex) {
            this.disconnect();
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_os_InstallerConnection$disconnect() {
        Slog.i("InstallerConnection", "disconnecting...");
        IoUtils.closeQuietly(this.mSocket);
        IoUtils.closeQuietly(this.mIn);
        IoUtils.closeQuietly(this.mOut);
        this.mSocket = null;
        this.mIn = null;
        this.mOut = null;
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$readFully(byte[] buffer, int len) {
        try {
            Streams.readFully(this.mIn, buffer, 0, len);
        }
        catch (IOException ioe) {
            Slog.e("InstallerConnection", "read exception");
            this.disconnect();
            return false;
        }
        return true;
    }

    private final int $$robo$$com_android_internal_os_InstallerConnection$readReply() {
        if (!this.readFully(this.buf, 2)) {
            return -1;
        }
        int len = this.buf[0] & 0xFF | (this.buf[1] & 0xFF) << 8;
        if (len < 1 || len > this.buf.length) {
            Slog.e("InstallerConnection", "invalid reply length (" + len + ")");
            this.disconnect();
            return -1;
        }
        if (!this.readFully(this.buf, len)) {
            return -1;
        }
        return len;
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$writeCommand(String cmdString) {
        byte[] cmd = cmdString.getBytes();
        int len = cmd.length;
        if (len < 1 || len > this.buf.length) {
            return false;
        }
        this.buf[0] = (byte)(len & 0xFF);
        this.buf[1] = (byte)(len >> 8 & 0xFF);
        try {
            this.mOut.write(this.buf, 0, 2);
            this.mOut.write(cmd, 0, len);
        }
        catch (IOException ex) {
            Slog.e("InstallerConnection", "write error");
            this.disconnect();
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_os_InstallerConnection$waitForConnection() {
        while (true) {
            try {
                this.execute("ping", new Object[0]);
                return;
            }
            catch (InstallerException installerException) {
                Slog.w("InstallerConnection", "installd not ready");
                SystemClock.sleep(1000L);
                continue;
            }
            break;
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_InstallerConnection$__constructor__();
    }

    public InstallerConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_InstallerConnection$__constructor__(), 0, this);
    }

    public void setWarnIfHeld(Object object) {
        InvokeDynamicSupport.bootstrap("setWarnIfHeld", $$robo$$com_android_internal_os_InstallerConnection$setWarnIfHeld(java.lang.Object ), 0, this, object);
    }

    public synchronized String transact(String string2) {
        return InvokeDynamicSupport.bootstrap("transact", $$robo$$com_android_internal_os_InstallerConnection$transact(java.lang.String ), 0, this, string2);
    }

    public String[] execute(String string2, Object ... objectArray) throws InstallerException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$com_android_internal_os_InstallerConnection$execute(java.lang.String java.lang.Object[] ), 0, this, string2, objectArray);
    }

    public void dexopt(String string2, int n, String string3, int n2, int n3, String string4, String string5, String string6) throws InstallerException {
        InvokeDynamicSupport.bootstrap("dexopt", $$robo$$com_android_internal_os_InstallerConnection$dexopt(java.lang.String int java.lang.String int int java.lang.String java.lang.String java.lang.String ), 0, this, string2, n, string3, n2, n3, string4, string5, string6);
    }

    public void dexopt(String string2, int n, String string3, String string4, int n2, String string5, int n3, String string6, String string7, String string8) throws InstallerException {
        InvokeDynamicSupport.bootstrap("dexopt", $$robo$$com_android_internal_os_InstallerConnection$dexopt(java.lang.String int java.lang.String java.lang.String int java.lang.String int java.lang.String java.lang.String java.lang.String ), 0, this, string2, n, string3, string4, n2, string5, n3, string6, string7, string8);
    }

    private boolean safeParseBooleanResult(String[] stringArray) throws InstallerException {
        return (boolean)InvokeDynamicSupport.bootstrap("safeParseBooleanResult", $$robo$$com_android_internal_os_InstallerConnection$safeParseBooleanResult(java.lang.String[] ), 0, this, stringArray);
    }

    public boolean mergeProfiles(int n, String string2) throws InstallerException {
        return (boolean)InvokeDynamicSupport.bootstrap("mergeProfiles", $$robo$$com_android_internal_os_InstallerConnection$mergeProfiles(int java.lang.String ), 0, this, n, string2);
    }

    public boolean dumpProfiles(String string2, String string3, String string4) throws InstallerException {
        return (boolean)InvokeDynamicSupport.bootstrap("dumpProfiles", $$robo$$com_android_internal_os_InstallerConnection$dumpProfiles(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    private boolean connect() {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$com_android_internal_os_InstallerConnection$connect(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$com_android_internal_os_InstallerConnection$disconnect(), 0, this);
    }

    private boolean readFully(byte[] byArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("readFully", $$robo$$com_android_internal_os_InstallerConnection$readFully(byte[] int ), 0, this, byArray, n);
    }

    private int readReply() {
        return (int)InvokeDynamicSupport.bootstrap("readReply", $$robo$$com_android_internal_os_InstallerConnection$readReply(), 0, this);
    }

    private boolean writeCommand(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("writeCommand", $$robo$$com_android_internal_os_InstallerConnection$writeCommand(java.lang.String ), 0, this, string2);
    }

    public void waitForConnection() {
        InvokeDynamicSupport.bootstrap("waitForConnection", $$robo$$com_android_internal_os_InstallerConnection$waitForConnection(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstallerConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class InstallerException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_os_InstallerConnection_InstallerException$__constructor__(String detailMessage) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$com_android_internal_os_InstallerConnection_InstallerException$__constructor__(string2);
        }

        public InstallerException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_InstallerConnection_InstallerException$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ InstallerException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstallerException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

