/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.UidTraffic;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkStats;
import android.net.wifi.WifiActivityEnergyInfo;
import android.net.wifi.WifiManager;
import android.os.BatteryStats;
import android.os.Build;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.telephony.ModemActivityInfo;
import android.telephony.SignalStrength;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LogWriter;
import android.util.MutableInt;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.os.AtomicFile;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsHelper;
import com.android.internal.os.KernelCpuSpeedReader;
import com.android.internal.os.KernelUidCpuTimeReader;
import com.android.internal.os.KernelWakelockReader;
import com.android.internal.os.KernelWakelockStats;
import com.android.internal.os.PowerProfile;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class BatteryStatsImpl
extends BatteryStats
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BatteryStatsImpl";
    private static boolean DEBUG = false;
    public static boolean DEBUG_ENERGY = false;
    private static boolean DEBUG_ENERGY_CPU = false;
    private static boolean DEBUG_HISTORY = false;
    private static boolean USE_OLD_HISTORY = false;
    private static int MAGIC = -1166707595;
    private static int VERSION = 147;
    private static int MAX_HISTORY_ITEMS = 2000;
    private static int MAX_MAX_HISTORY_ITEMS = 3000;
    private static int MAX_WAKELOCKS_PER_UID = 100;
    private static int NUM_WIFI_TX_LEVELS = 1;
    private static int NUM_BT_TX_LEVELS = 1;
    protected Clocks mClocks;
    private JournaledFile mFile;
    public AtomicFile mCheckinFile;
    public AtomicFile mDailyFile;
    static int MSG_UPDATE_WAKELOCKS = 1;
    static int MSG_REPORT_POWER_CHANGE = 2;
    static int MSG_REPORT_CHARGING = 3;
    static long DELAY_UPDATE_WAKELOCKS = 5000L;
    private KernelWakelockReader mKernelWakelockReader;
    private KernelWakelockStats mTmpWakelockStats;
    private KernelUidCpuTimeReader mKernelUidCpuTimeReader;
    private KernelCpuSpeedReader[] mKernelCpuSpeedReaders;
    private PlatformIdleStateCallback mPlatformIdleStateCallback;
    public MyHandler mHandler;
    private ExternalStatsSync mExternalSync;
    private BatteryCallback mCallback;
    SparseIntArray mIsolatedUids;
    SparseArray<Uid> mUidStats;
    ArrayList<StopwatchTimer> mPartialTimers;
    ArrayList<StopwatchTimer> mFullTimers;
    ArrayList<StopwatchTimer> mWindowTimers;
    ArrayList<StopwatchTimer> mDrawTimers;
    SparseArray<ArrayList<StopwatchTimer>> mSensorTimers;
    ArrayList<StopwatchTimer> mWifiRunningTimers;
    ArrayList<StopwatchTimer> mFullWifiLockTimers;
    ArrayList<StopwatchTimer> mWifiMulticastTimers;
    ArrayList<StopwatchTimer> mWifiScanTimers;
    SparseArray<ArrayList<StopwatchTimer>> mWifiBatchedScanTimers;
    ArrayList<StopwatchTimer> mAudioTurnedOnTimers;
    ArrayList<StopwatchTimer> mVideoTurnedOnTimers;
    ArrayList<StopwatchTimer> mFlashlightTurnedOnTimers;
    ArrayList<StopwatchTimer> mCameraTurnedOnTimers;
    ArrayList<StopwatchTimer> mBluetoothScanOnTimers;
    ArrayList<StopwatchTimer> mLastPartialTimers;
    protected TimeBase mOnBatteryTimeBase;
    TimeBase mOnBatteryScreenOffTimeBase;
    boolean mDistributeWakelockCpu;
    boolean mShuttingDown;
    BatteryStats.HistoryEventTracker mActiveEvents;
    long mHistoryBaseTime;
    boolean mHaveBatteryLevel;
    boolean mRecordingHistory;
    int mNumHistoryItems;
    static int MAX_HISTORY_BUFFER = 262144;
    static int MAX_MAX_HISTORY_BUFFER = 327680;
    Parcel mHistoryBuffer;
    BatteryStats.HistoryItem mHistoryLastWritten;
    BatteryStats.HistoryItem mHistoryLastLastWritten;
    BatteryStats.HistoryItem mHistoryReadTmp;
    BatteryStats.HistoryItem mHistoryAddTmp;
    HashMap<BatteryStats.HistoryTag, Integer> mHistoryTagPool;
    String[] mReadHistoryStrings;
    int[] mReadHistoryUids;
    int mReadHistoryChars;
    int mNextHistoryTagIdx;
    int mNumHistoryTagChars;
    int mHistoryBufferLastPos;
    boolean mHistoryOverflow;
    int mActiveHistoryStates;
    int mActiveHistoryStates2;
    long mLastHistoryElapsedRealtime;
    long mTrackRunningHistoryElapsedRealtime;
    long mTrackRunningHistoryUptime;
    BatteryStats.HistoryItem mHistoryCur;
    BatteryStats.HistoryItem mHistory;
    BatteryStats.HistoryItem mHistoryEnd;
    BatteryStats.HistoryItem mHistoryLastEnd;
    BatteryStats.HistoryItem mHistoryCache;
    BatteryStats.HistoryStepDetails mLastHistoryStepDetails;
    byte mLastHistoryStepLevel;
    BatteryStats.HistoryStepDetails mCurHistoryStepDetails;
    BatteryStats.HistoryStepDetails mReadHistoryStepDetails;
    BatteryStats.HistoryStepDetails mTmpHistoryStepDetails;
    long mLastStepCpuUserTime;
    long mCurStepCpuUserTime;
    long mLastStepCpuSystemTime;
    long mCurStepCpuSystemTime;
    long mLastStepStatUserTime;
    long mLastStepStatSystemTime;
    long mLastStepStatIOWaitTime;
    long mLastStepStatIrqTime;
    long mLastStepStatSoftIrqTime;
    long mLastStepStatIdleTime;
    long mCurStepStatUserTime;
    long mCurStepStatSystemTime;
    long mCurStepStatIOWaitTime;
    long mCurStepStatIrqTime;
    long mCurStepStatSoftIrqTime;
    long mCurStepStatIdleTime;
    private BatteryStats.HistoryItem mHistoryIterator;
    private boolean mReadOverflow;
    private boolean mIteratingHistory;
    int mStartCount;
    long mStartClockTime;
    String mStartPlatformVersion;
    String mEndPlatformVersion;
    long mUptime;
    long mUptimeStart;
    long mRealtime;
    long mRealtimeStart;
    int mWakeLockNesting;
    boolean mWakeLockImportant;
    public boolean mRecordAllHistory;
    boolean mNoAutoReset;
    int mScreenState;
    StopwatchTimer mScreenOnTimer;
    int mScreenBrightnessBin;
    StopwatchTimer[] mScreenBrightnessTimer;
    boolean mInteractive;
    StopwatchTimer mInteractiveTimer;
    boolean mPowerSaveModeEnabled;
    StopwatchTimer mPowerSaveModeEnabledTimer;
    boolean mDeviceIdling;
    StopwatchTimer mDeviceIdlingTimer;
    boolean mDeviceLightIdling;
    StopwatchTimer mDeviceLightIdlingTimer;
    int mDeviceIdleMode;
    long mLastIdleTimeStart;
    long mLongestLightIdleTime;
    long mLongestFullIdleTime;
    StopwatchTimer mDeviceIdleModeLightTimer;
    StopwatchTimer mDeviceIdleModeFullTimer;
    boolean mPhoneOn;
    StopwatchTimer mPhoneOnTimer;
    int mAudioOnNesting;
    StopwatchTimer mAudioOnTimer;
    int mVideoOnNesting;
    StopwatchTimer mVideoOnTimer;
    int mFlashlightOnNesting;
    StopwatchTimer mFlashlightOnTimer;
    int mCameraOnNesting;
    StopwatchTimer mCameraOnTimer;
    int mPhoneSignalStrengthBin;
    int mPhoneSignalStrengthBinRaw;
    StopwatchTimer[] mPhoneSignalStrengthsTimer;
    StopwatchTimer mPhoneSignalScanningTimer;
    int mPhoneDataConnectionType;
    StopwatchTimer[] mPhoneDataConnectionsTimer;
    LongSamplingCounter[] mNetworkByteActivityCounters;
    LongSamplingCounter[] mNetworkPacketActivityCounters;
    ControllerActivityCounterImpl mWifiActivity;
    ControllerActivityCounterImpl mBluetoothActivity;
    ControllerActivityCounterImpl mModemActivity;
    boolean mHasWifiReporting;
    boolean mHasBluetoothReporting;
    boolean mHasModemReporting;
    boolean mWifiOn;
    StopwatchTimer mWifiOnTimer;
    boolean mGlobalWifiRunning;
    StopwatchTimer mGlobalWifiRunningTimer;
    int mWifiState;
    StopwatchTimer[] mWifiStateTimer;
    int mWifiSupplState;
    StopwatchTimer[] mWifiSupplStateTimer;
    int mWifiSignalStrengthBin;
    StopwatchTimer[] mWifiSignalStrengthsTimer;
    int mBluetoothScanNesting;
    StopwatchTimer mBluetoothScanTimer;
    int mMobileRadioPowerState;
    long mMobileRadioActiveStartTime;
    StopwatchTimer mMobileRadioActiveTimer;
    StopwatchTimer mMobileRadioActivePerAppTimer;
    LongSamplingCounter mMobileRadioActiveAdjustedTime;
    LongSamplingCounter mMobileRadioActiveUnknownTime;
    LongSamplingCounter mMobileRadioActiveUnknownCount;
    int mWifiRadioPowerState;
    boolean mOnBattery;
    boolean mOnBatteryInternal;
    boolean mCharging;
    int mLastChargingStateLevel;
    int mDischargeStartLevel;
    int mDischargeUnplugLevel;
    int mDischargePlugLevel;
    int mDischargeCurrentLevel;
    int mCurrentBatteryLevel;
    int mLowDischargeAmountSinceCharge;
    int mHighDischargeAmountSinceCharge;
    int mDischargeScreenOnUnplugLevel;
    int mDischargeScreenOffUnplugLevel;
    int mDischargeAmountScreenOn;
    int mDischargeAmountScreenOnSinceCharge;
    int mDischargeAmountScreenOff;
    int mDischargeAmountScreenOffSinceCharge;
    private LongSamplingCounter mDischargeScreenOffCounter;
    private LongSamplingCounter mDischargeCounter;
    static int MAX_LEVEL_STEPS = 200;
    int mInitStepMode;
    int mCurStepMode;
    int mModStepMode;
    int mLastDischargeStepLevel;
    int mMinDischargeStepLevel;
    BatteryStats.LevelStepTracker mDischargeStepTracker;
    BatteryStats.LevelStepTracker mDailyDischargeStepTracker;
    ArrayList<BatteryStats.PackageChange> mDailyPackageChanges;
    int mLastChargeStepLevel;
    int mMaxChargeStepLevel;
    BatteryStats.LevelStepTracker mChargeStepTracker;
    BatteryStats.LevelStepTracker mDailyChargeStepTracker;
    static int MAX_DAILY_ITEMS = 10;
    long mDailyStartTime;
    long mNextMinDailyDeadline;
    long mNextMaxDailyDeadline;
    ArrayList<BatteryStats.DailyItem> mDailyItems;
    long mLastWriteTime;
    private int mPhoneServiceState;
    private int mPhoneServiceStateRaw;
    private int mPhoneSimStateRaw;
    private int mNumConnectivityChange;
    private int mLoadedNumConnectivityChange;
    private int mUnpluggedNumConnectivityChange;
    private int mEstimatedBatteryCapacity;
    private NetworkStats.Entry mTmpNetworkStatsEntry;
    private PowerProfile mPowerProfile;
    private HashMap<String, SamplingTimer> mKernelWakelockStats;
    String mLastWakeupReason;
    long mLastWakeupUptimeMs;
    private HashMap<String, SamplingTimer> mWakeupReasonStats;
    static int DELTA_TIME_MASK = 524287;
    static int DELTA_TIME_LONG = 524287;
    static int DELTA_TIME_INT = 524286;
    static int DELTA_TIME_ABS = 524285;
    static int DELTA_BATTERY_LEVEL_FLAG = 524288;
    static int DELTA_STATE_FLAG = 0x100000;
    static int DELTA_STATE2_FLAG = 0x200000;
    static int DELTA_WAKELOCK_FLAG = 0x400000;
    static int DELTA_EVENT_FLAG = 0x800000;
    static int DELTA_BATTERY_CHARGE_FLAG = 0x1000000;
    static int DELTA_STATE_MASK = -33554432;
    static int STATE_BATTERY_MASK = -16777216;
    static int STATE_BATTERY_STATUS_MASK = 7;
    static int STATE_BATTERY_STATUS_SHIFT = 29;
    static int STATE_BATTERY_HEALTH_MASK = 7;
    static int STATE_BATTERY_HEALTH_SHIFT = 26;
    static int STATE_BATTERY_PLUG_MASK = 3;
    static int STATE_BATTERY_PLUG_SHIFT = 24;
    static int BATTERY_DELTA_LEVEL_FLAG = 1;
    int mChangedStates;
    int mChangedStates2;
    private String mInitialAcquireWakeName;
    private int mInitialAcquireWakeUid;
    int mSensorNesting;
    int mGpsNesting;
    int mWifiFullLockNesting;
    int mWifiScanNesting;
    int mWifiMulticastNesting;
    private String[] mMobileIfaces;
    private String[] mWifiIfaces;
    private NetworkStatsFactory mNetworkStatsFactory;
    private static int NETWORK_STATS_LAST = 0;
    private static int NETWORK_STATS_NEXT = 1;
    private static int NETWORK_STATS_DELTA = 2;
    private NetworkStats[] mMobileNetworkStats;
    private NetworkStats[] mWifiNetworkStats;
    long mTempTotalCpuUserTimeUs;
    long mTempTotalCpuSystemTimeUs;
    public static int BATTERY_PLUGGED_NONE = 0;
    Parcel mPendingWrite;
    ReentrantLock mWriteLock;
    public static Parcelable.Creator<BatteryStatsImpl> CREATOR;

    private final Map<String, ? extends Timer> $$robo$$com_android_internal_os_BatteryStatsImpl$getKernelWakelockStats() {
        return this.mKernelWakelockStats;
    }

    private final Map<String, ? extends Timer> $$robo$$com_android_internal_os_BatteryStatsImpl$getWakeupReasonStats() {
        return this.mWakeupReasonStats;
    }

    private final BatteryStats.LongCounter $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeScreenOffCoulombCounter() {
        return this.mDischargeScreenOffCounter;
    }

    private final BatteryStats.LongCounter $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeCoulombCounter() {
        return this.mDischargeCounter;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getEstimatedBatteryCapacity() {
        return this.mEstimatedBatteryCapacity;
    }

    private void $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__() {
    }

    private void $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(Clocks clocks) {
        this.mKernelWakelockReader = new KernelWakelockReader();
        this.mTmpWakelockStats = new KernelWakelockStats();
        this.mKernelUidCpuTimeReader = new KernelUidCpuTimeReader();
        this.mIsolatedUids = new SparseIntArray();
        this.mUidStats = new SparseArray();
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mDrawTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mWifiScanTimers = new ArrayList();
        this.mWifiBatchedScanTimers = new SparseArray();
        this.mAudioTurnedOnTimers = new ArrayList();
        this.mVideoTurnedOnTimers = new ArrayList();
        this.mFlashlightTurnedOnTimers = new ArrayList();
        this.mCameraTurnedOnTimers = new ArrayList();
        this.mBluetoothScanOnTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mOnBatteryTimeBase = new TimeBase();
        this.mOnBatteryScreenOffTimeBase = new TimeBase();
        this.mActiveEvents = new BatteryStats.HistoryEventTracker();
        this.mHaveBatteryLevel = false;
        this.mRecordingHistory = false;
        this.mHistoryBuffer = Parcel.obtain();
        this.mHistoryLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryLastLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryReadTmp = new BatteryStats.HistoryItem();
        this.mHistoryAddTmp = new BatteryStats.HistoryItem();
        this.mHistoryTagPool = new HashMap();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        this.mHistoryOverflow = false;
        this.mActiveHistoryStates = -1;
        this.mActiveHistoryStates2 = -1;
        this.mLastHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryUptime = 0L;
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mLastHistoryStepDetails = null;
        this.mLastHistoryStepLevel = 0;
        this.mCurHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mTmpHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mScreenState = 0;
        this.mScreenBrightnessBin = -1;
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthBin = -1;
        this.mPhoneSignalStrengthBinRaw = -1;
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionType = -1;
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[17];
        this.mNetworkByteActivityCounters = new LongSamplingCounter[6];
        this.mNetworkPacketActivityCounters = new LongSamplingCounter[6];
        this.mHasWifiReporting = false;
        this.mHasBluetoothReporting = false;
        this.mHasModemReporting = false;
        this.mWifiState = -1;
        this.mWifiStateTimer = new StopwatchTimer[8];
        this.mWifiSupplState = -1;
        this.mWifiSupplStateTimer = new StopwatchTimer[13];
        this.mWifiSignalStrengthBin = -1;
        this.mWifiSignalStrengthsTimer = new StopwatchTimer[5];
        this.mMobileRadioPowerState = 1;
        this.mWifiRadioPowerState = 1;
        this.mCharging = true;
        this.mInitStepMode = 0;
        this.mCurStepMode = 0;
        this.mModStepMode = 0;
        this.mDischargeStepTracker = new BatteryStats.LevelStepTracker(200);
        this.mDailyDischargeStepTracker = new BatteryStats.LevelStepTracker(400);
        this.mChargeStepTracker = new BatteryStats.LevelStepTracker(200);
        this.mDailyChargeStepTracker = new BatteryStats.LevelStepTracker(400);
        this.mDailyStartTime = 0L;
        this.mNextMinDailyDeadline = 0L;
        this.mNextMaxDailyDeadline = 0L;
        this.mDailyItems = new ArrayList();
        this.mLastWriteTime = 0L;
        this.mPhoneServiceState = -1;
        this.mPhoneServiceStateRaw = -1;
        this.mPhoneSimStateRaw = -1;
        this.mEstimatedBatteryCapacity = -1;
        this.mTmpNetworkStatsEntry = new NetworkStats.Entry();
        this.mKernelWakelockStats = new HashMap();
        this.mLastWakeupReason = null;
        this.mLastWakeupUptimeMs = 0L;
        this.mWakeupReasonStats = new HashMap();
        this.mChangedStates = 0;
        this.mChangedStates2 = 0;
        this.mInitialAcquireWakeUid = -1;
        this.mWifiFullLockNesting = 0;
        this.mWifiScanNesting = 0;
        this.mWifiMulticastNesting = 0;
        this.mMobileIfaces = EmptyArray.STRING;
        this.mWifiIfaces = EmptyArray.STRING;
        this.mNetworkStatsFactory = new NetworkStatsFactory();
        this.mPendingWrite = null;
        this.mWriteLock = new ReentrantLock();
        this.init(clocks);
        this.mFile = null;
        this.mCheckinFile = null;
        this.mDailyFile = null;
        this.mHandler = null;
        this.mExternalSync = null;
        this.mPlatformIdleStateCallback = null;
        this.clearHistoryLocked();
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$init(Clocks clocks) {
        this.mClocks = clocks;
        this.mMobileNetworkStats = new NetworkStats[]{new NetworkStats(this.mClocks.elapsedRealtime(), 50), new NetworkStats(this.mClocks.elapsedRealtime(), 50), new NetworkStats(this.mClocks.elapsedRealtime(), 50)};
        this.mWifiNetworkStats = new NetworkStats[]{new NetworkStats(this.mClocks.elapsedRealtime(), 50), new NetworkStats(this.mClocks.elapsedRealtime(), 50), new NetworkStats(this.mClocks.elapsedRealtime(), 50)};
    }

    private final SamplingTimer $$robo$$com_android_internal_os_BatteryStatsImpl$getWakeupReasonTimerLocked(String name) {
        SamplingTimer timer = this.mWakeupReasonStats.get(name);
        if (timer == null) {
            timer = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase);
            this.mWakeupReasonStats.put(name, timer);
        }
        return timer;
    }

    private final SamplingTimer $$robo$$com_android_internal_os_BatteryStatsImpl$getKernelWakelockTimerLocked(String name) {
        SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
        if (kwlt == null) {
            kwlt = new SamplingTimer(this.mClocks, this.mOnBatteryScreenOffTimeBase);
            this.mKernelWakelockStats.put(name, kwlt);
        }
        return kwlt;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$writeHistoryTag(BatteryStats.HistoryTag tag) {
        int idx;
        Integer idxObj = this.mHistoryTagPool.get(tag);
        if (idxObj != null) {
            idx = idxObj;
        } else {
            idx = this.mNextHistoryTagIdx++;
            BatteryStats.HistoryTag key = new BatteryStats.HistoryTag();
            key.setTo(tag);
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(key, idx);
            this.mNumHistoryTagChars += key.string.length() + 1;
        }
        return idx;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readHistoryTag(int index, BatteryStats.HistoryTag tag) {
        tag.string = this.mReadHistoryStrings[index];
        tag.uid = this.mReadHistoryUids[index];
        tag.poolIdx = index;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeHistoryDelta(Parcel dest, BatteryStats.HistoryItem cur, BatteryStats.HistoryItem last) {
        boolean batteryChargeChanged;
        boolean state2IntChanged;
        int stateInt;
        boolean stateIntChanged;
        boolean batteryLevelIntChanged;
        if (last == null || cur.cmd != 0) {
            dest.writeInt(524285);
            cur.writeToParcel(dest, 0);
            return;
        }
        long deltaTime = cur.time - last.time;
        int lastBatteryLevelInt = this.buildBatteryLevelInt(last);
        int lastStateInt = this.buildStateInt(last);
        int deltaTimeToken = deltaTime < 0L || deltaTime > Integer.MAX_VALUE ? 524287 : (deltaTime >= 524285L ? 524286 : (int)deltaTime);
        int firstToken = deltaTimeToken | cur.states & 0xFE000000;
        int includeStepDetails = this.mLastHistoryStepLevel > cur.batteryLevel ? 1 : 0;
        boolean computeStepDetails = includeStepDetails != 0 || this.mLastHistoryStepDetails == null;
        int batteryLevelInt = this.buildBatteryLevelInt(cur) | includeStepDetails;
        boolean bl = batteryLevelIntChanged = batteryLevelInt != lastBatteryLevelInt;
        if (batteryLevelIntChanged) {
            firstToken |= 0x80000;
        }
        boolean bl2 = stateIntChanged = (stateInt = this.buildStateInt(cur)) != lastStateInt;
        if (stateIntChanged) {
            firstToken |= 0x100000;
        }
        boolean bl3 = state2IntChanged = cur.states2 != last.states2;
        if (state2IntChanged) {
            firstToken |= 0x200000;
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            firstToken |= 0x400000;
        }
        if (cur.eventCode != 0) {
            firstToken |= 0x800000;
        }
        boolean bl4 = batteryChargeChanged = cur.batteryChargeUAh != last.batteryChargeUAh;
        if (batteryChargeChanged) {
            firstToken |= 0x1000000;
        }
        dest.writeInt(firstToken);
        if (deltaTimeToken >= 524286) {
            if (deltaTimeToken == 524286) {
                dest.writeInt((int)deltaTime);
            } else {
                dest.writeLong(deltaTime);
            }
        }
        if (batteryLevelIntChanged) {
            dest.writeInt(batteryLevelInt);
        }
        if (stateIntChanged) {
            dest.writeInt(stateInt);
        }
        if (state2IntChanged) {
            dest.writeInt(cur.states2);
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            int wakeLockIndex = cur.wakelockTag != null ? this.writeHistoryTag(cur.wakelockTag) : 65535;
            int wakeReasonIndex = cur.wakeReasonTag != null ? this.writeHistoryTag(cur.wakeReasonTag) : 65535;
            dest.writeInt(wakeReasonIndex << 16 | wakeLockIndex);
        }
        if (cur.eventCode != 0) {
            int index = this.writeHistoryTag(cur.eventTag);
            int codeAndIndex = cur.eventCode & 0xFFFF | index << 16;
            dest.writeInt(codeAndIndex);
        }
        if (computeStepDetails) {
            if (this.mPlatformIdleStateCallback != null) {
                this.mCurHistoryStepDetails.statPlatformIdleState = this.mPlatformIdleStateCallback.getPlatformLowPowerStats();
            }
            this.computeHistoryStepDetails(this.mCurHistoryStepDetails, this.mLastHistoryStepDetails);
            if (includeStepDetails != 0) {
                this.mCurHistoryStepDetails.writeToParcel(dest);
            }
            cur.stepDetails = this.mCurHistoryStepDetails;
            this.mLastHistoryStepDetails = this.mCurHistoryStepDetails;
        } else {
            cur.stepDetails = null;
        }
        if (this.mLastHistoryStepLevel < cur.batteryLevel) {
            this.mLastHistoryStepDetails = null;
        }
        this.mLastHistoryStepLevel = cur.batteryLevel;
        if (batteryChargeChanged) {
            dest.writeInt(cur.batteryChargeUAh);
        }
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$buildBatteryLevelInt(BatteryStats.HistoryItem h) {
        return h.batteryLevel << 25 & 0xFE000000 | h.batteryTemperature << 15 & 0x1FF8000 | h.batteryVoltage << 1 & 0x7FFE;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readBatteryLevelInt(int batteryLevelInt, BatteryStats.HistoryItem out) {
        out.batteryLevel = (byte)((batteryLevelInt & 0xFE000000) >>> 25);
        out.batteryTemperature = (short)((batteryLevelInt & 0x1FF8000) >>> 15);
        out.batteryVoltage = (char)((batteryLevelInt & 0x7FFE) >>> 1);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$buildStateInt(BatteryStats.HistoryItem h) {
        int plugType = 0;
        if ((h.batteryPlugType & 1) != 0) {
            plugType = 1;
        } else if ((h.batteryPlugType & 2) != 0) {
            plugType = 2;
        } else if ((h.batteryPlugType & 4) != 0) {
            plugType = 3;
        }
        return (h.batteryStatus & 7) << 29 | (h.batteryHealth & 7) << 26 | (plugType & 3) << 24 | h.states & 0xFFFFFF;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$computeHistoryStepDetails(BatteryStats.HistoryStepDetails out, BatteryStats.HistoryStepDetails last) {
        BatteryStats.HistoryStepDetails tmp = last != null ? this.mTmpHistoryStepDetails : out;
        this.requestImmediateCpuUpdate();
        if (last == null) {
            int NU = this.mUidStats.size();
            for (int i = 0; i < NU; ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.mLastStepUserTime = uid.mCurStepUserTime;
                uid.mLastStepSystemTime = uid.mCurStepSystemTime;
            }
            this.mLastStepCpuUserTime = this.mCurStepCpuUserTime;
            this.mLastStepCpuSystemTime = this.mCurStepCpuSystemTime;
            this.mLastStepStatUserTime = this.mCurStepStatUserTime;
            this.mLastStepStatSystemTime = this.mCurStepStatSystemTime;
            this.mLastStepStatIOWaitTime = this.mCurStepStatIOWaitTime;
            this.mLastStepStatIrqTime = this.mCurStepStatIrqTime;
            this.mLastStepStatSoftIrqTime = this.mCurStepStatSoftIrqTime;
            this.mLastStepStatIdleTime = this.mCurStepStatIdleTime;
            tmp.clear();
            return;
        }
        out.userTime = (int)(this.mCurStepCpuUserTime - this.mLastStepCpuUserTime);
        out.systemTime = (int)(this.mCurStepCpuSystemTime - this.mLastStepCpuSystemTime);
        out.statUserTime = (int)(this.mCurStepStatUserTime - this.mLastStepStatUserTime);
        out.statSystemTime = (int)(this.mCurStepStatSystemTime - this.mLastStepStatSystemTime);
        out.statIOWaitTime = (int)(this.mCurStepStatIOWaitTime - this.mLastStepStatIOWaitTime);
        out.statIrqTime = (int)(this.mCurStepStatIrqTime - this.mLastStepStatIrqTime);
        out.statSoftIrqTime = (int)(this.mCurStepStatSoftIrqTime - this.mLastStepStatSoftIrqTime);
        out.statIdlTime = (int)(this.mCurStepStatIdleTime - this.mLastStepStatIdleTime);
        out.appCpuUid3 = -1;
        out.appCpuUid2 = -1;
        out.appCpuUid1 = -1;
        out.appCpuUTime3 = 0;
        out.appCpuUTime2 = 0;
        out.appCpuUTime1 = 0;
        out.appCpuSTime3 = 0;
        out.appCpuSTime2 = 0;
        out.appCpuSTime1 = 0;
        int NU = this.mUidStats.size();
        for (int i = 0; i < NU; ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            int totalUTime = (int)(uid.mCurStepUserTime - uid.mLastStepUserTime);
            int totalSTime = (int)(uid.mCurStepSystemTime - uid.mLastStepSystemTime);
            int totalTime = totalUTime + totalSTime;
            uid.mLastStepUserTime = uid.mCurStepUserTime;
            uid.mLastStepSystemTime = uid.mCurStepSystemTime;
            if (totalTime <= out.appCpuUTime3 + out.appCpuSTime3) continue;
            if (totalTime <= out.appCpuUTime2 + out.appCpuSTime2) {
                out.appCpuUid3 = uid.mUid;
                out.appCpuUTime3 = totalUTime;
                out.appCpuSTime3 = totalSTime;
                continue;
            }
            out.appCpuUid3 = out.appCpuUid2;
            out.appCpuUTime3 = out.appCpuUTime2;
            out.appCpuSTime3 = out.appCpuSTime2;
            if (totalTime <= out.appCpuUTime1 + out.appCpuSTime1) {
                out.appCpuUid2 = uid.mUid;
                out.appCpuUTime2 = totalUTime;
                out.appCpuSTime2 = totalSTime;
                continue;
            }
            out.appCpuUid2 = out.appCpuUid1;
            out.appCpuUTime2 = out.appCpuUTime1;
            out.appCpuSTime2 = out.appCpuSTime1;
            out.appCpuUid1 = uid.mUid;
            out.appCpuUTime1 = totalUTime;
            out.appCpuSTime1 = totalSTime;
        }
        this.mLastStepCpuUserTime = this.mCurStepCpuUserTime;
        this.mLastStepCpuSystemTime = this.mCurStepCpuSystemTime;
        this.mLastStepStatUserTime = this.mCurStepStatUserTime;
        this.mLastStepStatSystemTime = this.mCurStepStatSystemTime;
        this.mLastStepStatIOWaitTime = this.mCurStepStatIOWaitTime;
        this.mLastStepStatIrqTime = this.mCurStepStatIrqTime;
        this.mLastStepStatSoftIrqTime = this.mCurStepStatSoftIrqTime;
        this.mLastStepStatIdleTime = this.mCurStepStatIdleTime;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readHistoryDelta(Parcel src, BatteryStats.HistoryItem cur) {
        int batteryLevelInt;
        int firstToken = src.readInt();
        int deltaTimeToken = firstToken & 0x7FFFF;
        cur.cmd = 0;
        cur.numReadInts = 1;
        if (deltaTimeToken < 524285) {
            cur.time += (long)deltaTimeToken;
        } else {
            if (deltaTimeToken == 524285) {
                cur.time = src.readLong();
                cur.numReadInts += 2;
                cur.readFromParcel(src);
                return;
            }
            if (deltaTimeToken == 524286) {
                int delta = src.readInt();
                cur.time += (long)delta;
                ++cur.numReadInts;
            } else {
                long delta = src.readLong();
                cur.time += delta;
                cur.numReadInts += 2;
            }
        }
        if ((firstToken & 0x80000) != 0) {
            batteryLevelInt = src.readInt();
            this.readBatteryLevelInt(batteryLevelInt, cur);
            ++cur.numReadInts;
        } else {
            batteryLevelInt = 0;
        }
        if ((firstToken & 0x100000) != 0) {
            int stateInt = src.readInt();
            cur.states = firstToken & 0xFE000000 | stateInt & 0xFFFFFF;
            cur.batteryStatus = (byte)(stateInt >> 29 & 7);
            cur.batteryHealth = (byte)(stateInt >> 26 & 7);
            cur.batteryPlugType = (byte)(stateInt >> 24 & 3);
            switch (cur.batteryPlugType) {
                case 1: {
                    cur.batteryPlugType = 1;
                    break;
                }
                case 2: {
                    cur.batteryPlugType = (byte)2;
                    break;
                }
                case 3: {
                    cur.batteryPlugType = (byte)4;
                }
            }
            ++cur.numReadInts;
        } else {
            cur.states = firstToken & 0xFE000000 | cur.states & 0xFFFFFF;
        }
        if ((firstToken & 0x200000) != 0) {
            cur.states2 = src.readInt();
        }
        if ((firstToken & 0x400000) != 0) {
            int indexes = src.readInt();
            int wakeLockIndex = indexes & 0xFFFF;
            int wakeReasonIndex = indexes >> 16 & 0xFFFF;
            if (wakeLockIndex != 65535) {
                cur.wakelockTag = cur.localWakelockTag;
                this.readHistoryTag(wakeLockIndex, cur.wakelockTag);
            } else {
                cur.wakelockTag = null;
            }
            if (wakeReasonIndex != 65535) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                this.readHistoryTag(wakeReasonIndex, cur.wakeReasonTag);
            } else {
                cur.wakeReasonTag = null;
            }
            ++cur.numReadInts;
        } else {
            cur.wakelockTag = null;
            cur.wakeReasonTag = null;
        }
        if ((firstToken & 0x800000) != 0) {
            cur.eventTag = cur.localEventTag;
            int codeAndIndex = src.readInt();
            cur.eventCode = codeAndIndex & 0xFFFF;
            int index = codeAndIndex >> 16 & 0xFFFF;
            this.readHistoryTag(index, cur.eventTag);
            ++cur.numReadInts;
        } else {
            cur.eventCode = 0;
        }
        if ((batteryLevelInt & 1) != 0) {
            cur.stepDetails = this.mReadHistoryStepDetails;
            cur.stepDetails.readFromParcel(src);
        } else {
            cur.stepDetails = null;
        }
        if ((firstToken & 0x1000000) != 0) {
            cur.batteryChargeUAh = src.readInt();
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$commitCurrentHistoryBatchLocked() {
        this.mHistoryLastWritten.cmd = (byte)-1;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryBufferLocked(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur) {
        int dataSize;
        if (!this.mHaveBatteryLevel || !this.mRecordingHistory) {
            return;
        }
        long timeDiff = this.mHistoryBaseTime + elapsedRealtimeMs - this.mHistoryLastWritten.time;
        int diffStates = this.mHistoryLastWritten.states ^ cur.states & this.mActiveHistoryStates;
        int diffStates2 = this.mHistoryLastWritten.states2 ^ cur.states2 & this.mActiveHistoryStates2;
        int lastDiffStates = this.mHistoryLastWritten.states ^ this.mHistoryLastLastWritten.states;
        int lastDiffStates2 = this.mHistoryLastWritten.states2 ^ this.mHistoryLastLastWritten.states2;
        if (!(this.mHistoryBufferLastPos < 0 || this.mHistoryLastWritten.cmd != 0 || timeDiff >= 1000L || (diffStates & lastDiffStates) != 0 || (diffStates2 & lastDiffStates2) != 0 || this.mHistoryLastWritten.wakelockTag != null && cur.wakelockTag != null || this.mHistoryLastWritten.wakeReasonTag != null && cur.wakeReasonTag != null || this.mHistoryLastWritten.stepDetails != null || this.mHistoryLastWritten.eventCode != 0 && cur.eventCode != 0 || this.mHistoryLastWritten.batteryLevel != cur.batteryLevel || this.mHistoryLastWritten.batteryStatus != cur.batteryStatus || this.mHistoryLastWritten.batteryHealth != cur.batteryHealth || this.mHistoryLastWritten.batteryPlugType != cur.batteryPlugType || this.mHistoryLastWritten.batteryTemperature != cur.batteryTemperature || this.mHistoryLastWritten.batteryVoltage != cur.batteryVoltage)) {
            this.mHistoryBuffer.setDataSize(this.mHistoryBufferLastPos);
            this.mHistoryBuffer.setDataPosition(this.mHistoryBufferLastPos);
            this.mHistoryBufferLastPos = -1;
            elapsedRealtimeMs = this.mHistoryLastWritten.time - this.mHistoryBaseTime;
            if (this.mHistoryLastWritten.wakelockTag != null) {
                cur.wakelockTag = cur.localWakelockTag;
                cur.wakelockTag.setTo(this.mHistoryLastWritten.wakelockTag);
            }
            if (this.mHistoryLastWritten.wakeReasonTag != null) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                cur.wakeReasonTag.setTo(this.mHistoryLastWritten.wakeReasonTag);
            }
            if (this.mHistoryLastWritten.eventCode != 0) {
                cur.eventCode = this.mHistoryLastWritten.eventCode;
                cur.eventTag = cur.localEventTag;
                cur.eventTag.setTo(this.mHistoryLastWritten.eventTag);
            }
            this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
        }
        if ((dataSize = this.mHistoryBuffer.dataSize()) >= 262144) {
            int curStates2;
            if (!this.mHistoryOverflow) {
                this.mHistoryOverflow = true;
                this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)0, cur);
                this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)6, cur);
                return;
            }
            boolean writeAnyway = false;
            int curStates = cur.states & 0xFFE70000 & this.mActiveHistoryStates;
            if (this.mHistoryLastWritten.states != curStates) {
                int old = this.mActiveHistoryStates;
                this.mActiveHistoryStates &= curStates | 0x18FFFF;
                writeAnyway |= old != this.mActiveHistoryStates;
            }
            if (this.mHistoryLastWritten.states2 != (curStates2 = cur.states2 & 0x683F0000 & this.mActiveHistoryStates2)) {
                int old = this.mActiveHistoryStates2;
                this.mActiveHistoryStates2 &= curStates2 | 0x97C0FFFF;
                writeAnyway |= old != this.mActiveHistoryStates2;
            }
            if (!(writeAnyway || this.mHistoryLastWritten.batteryLevel != cur.batteryLevel || dataSize < 327680 && ((this.mHistoryLastWritten.states ^ cur.states) & 0x180000) != 0 && ((this.mHistoryLastWritten.states2 ^ cur.states2) & 0x97C00000) != 0)) {
                return;
            }
            this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)0, cur);
            return;
        }
        if (dataSize == 0) {
            cur.currentTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)7, cur);
        }
        this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)0, cur);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryBufferLocked(long elapsedRealtimeMs, long uptimeMs, byte cmd, BatteryStats.HistoryItem cur) {
        if (this.mIteratingHistory) {
            throw new IllegalStateException("Can't do this while iterating history!");
        }
        this.mHistoryBufferLastPos = this.mHistoryBuffer.dataPosition();
        this.mHistoryLastLastWritten.setTo(this.mHistoryLastWritten);
        this.mHistoryLastWritten.setTo(this.mHistoryBaseTime + elapsedRealtimeMs, cmd, cur);
        this.mHistoryLastWritten.states &= this.mActiveHistoryStates;
        this.mHistoryLastWritten.states2 &= this.mActiveHistoryStates2;
        this.writeHistoryDelta(this.mHistoryBuffer, this.mHistoryLastWritten, this.mHistoryLastLastWritten);
        this.mLastHistoryElapsedRealtime = elapsedRealtimeMs;
        cur.wakelockTag = null;
        cur.wakeReasonTag = null;
        cur.eventCode = 0;
        cur.eventTag = null;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryRecordLocked(long elapsedRealtimeMs, long uptimeMs) {
        long diffElapsed;
        long diffUptime;
        if (this.mTrackRunningHistoryElapsedRealtime != 0L && (diffUptime = uptimeMs - this.mTrackRunningHistoryUptime) < (diffElapsed = elapsedRealtimeMs - this.mTrackRunningHistoryElapsedRealtime) - 20L) {
            long wakeElapsedTime = elapsedRealtimeMs - (diffElapsed - diffUptime);
            this.mHistoryAddTmp.setTo(this.mHistoryLastWritten);
            this.mHistoryAddTmp.wakelockTag = null;
            this.mHistoryAddTmp.wakeReasonTag = null;
            this.mHistoryAddTmp.eventCode = 0;
            this.mHistoryAddTmp.states &= Integer.MAX_VALUE;
            this.addHistoryRecordInnerLocked(wakeElapsedTime, uptimeMs, this.mHistoryAddTmp);
        }
        this.mHistoryCur.states |= Integer.MIN_VALUE;
        this.mTrackRunningHistoryElapsedRealtime = elapsedRealtimeMs;
        this.mTrackRunningHistoryUptime = uptimeMs;
        this.addHistoryRecordInnerLocked(elapsedRealtimeMs, uptimeMs, this.mHistoryCur);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryRecordInnerLocked(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur) {
        this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, cur);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryEventLocked(long elapsedRealtimeMs, long uptimeMs, int code, String name, int uid) {
        this.mHistoryCur.eventCode = code;
        this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
        this.mHistoryCur.eventTag.string = name;
        this.mHistoryCur.eventTag.uid = uid;
        this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryRecordLocked(long elapsedRealtimeMs, long uptimeMs, byte cmd, BatteryStats.HistoryItem cur) {
        BatteryStats.HistoryItem rec = this.mHistoryCache;
        if (rec != null) {
            this.mHistoryCache = rec.next;
        } else {
            rec = new BatteryStats.HistoryItem();
        }
        rec.setTo(this.mHistoryBaseTime + elapsedRealtimeMs, cmd, cur);
        this.addHistoryRecordLocked(rec);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryRecordLocked(BatteryStats.HistoryItem rec) {
        ++this.mNumHistoryItems;
        rec.next = null;
        this.mHistoryLastEnd = this.mHistoryEnd;
        if (this.mHistoryEnd != null) {
            this.mHistoryEnd.next = rec;
            this.mHistoryEnd = rec;
        } else {
            this.mHistory = this.mHistoryEnd = rec;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$clearHistoryLocked() {
        this.mHistoryBaseTime = 0L;
        this.mLastHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryUptime = 0L;
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(131072);
        this.mHistoryLastLastWritten.clear();
        this.mHistoryLastWritten.clear();
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        this.mHistoryOverflow = false;
        this.mActiveHistoryStates = -1;
        this.mActiveHistoryStates2 = -1;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateTimeBasesLocked(boolean unplugged, boolean screenOff, long uptime, long realtime) {
        boolean unpluggedScreenOff;
        this.mOnBatteryTimeBase.setRunning(unplugged, uptime, realtime);
        boolean bl = unpluggedScreenOff = unplugged && screenOff;
        if (unpluggedScreenOff != this.mOnBatteryScreenOffTimeBase.isRunning()) {
            this.updateKernelWakelocksLocked();
            this.updateCpuTimeLocked();
            this.mOnBatteryScreenOffTimeBase.setRunning(unpluggedScreenOff, uptime, realtime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addIsolatedUidLocked(int isolatedUid, int appUid) {
        this.mIsolatedUids.put(isolatedUid, appUid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$scheduleRemoveIsolatedUidLocked(int isolatedUid, int appUid) {
        int curUid = this.mIsolatedUids.get(isolatedUid, -1);
        if (curUid == appUid && this.mExternalSync != null) {
            this.mExternalSync.scheduleCpuSyncDueToRemovedUid(isolatedUid);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$removeIsolatedUidLocked(int isolatedUid) {
        this.mIsolatedUids.delete(isolatedUid);
        this.mKernelUidCpuTimeReader.removeUid(isolatedUid);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$mapUid(int uid) {
        int isolated = this.mIsolatedUids.get(uid, -1);
        return isolated > 0 ? isolated : uid;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteEventLocked(int code, String name, int uid) {
        if (!this.mActiveEvents.updateState(code, name, uid = this.mapUid(uid), 0)) {
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, code, name, uid);
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$ensureStartClockTime(long currentTime) {
        long ABOUT_ONE_YEAR = 31536000000L;
        if (currentTime > 31536000000L && this.mStartClockTime < currentTime - 31536000000L) {
            this.mStartClockTime = currentTime - (this.mClocks.elapsedRealtime() - this.mRealtimeStart / 1000L);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteCurrentTimeChangedLocked() {
        CallSite currentTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.recordCurrentTimeChangeLocked((long)currentTime, elapsedRealtime, uptime);
        this.ensureStartClockTime((long)currentTime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incStartsLocked();
        }
        if (!this.mActiveEvents.updateState(32769, name, uid, 0)) {
            return;
        }
        if (!this.mRecordAllHistory) {
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32769, name, uid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessCrashLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incNumCrashesLocked();
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessAnrLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incNumAnrsLocked();
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteUidProcessStateLocked(int uid, int state) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).updateUidProcessStateLocked(state);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessFinishLocked(String name, int uid) {
        if (!this.mActiveEvents.updateState(16385, name, uid = this.mapUid(uid), 0)) {
            return;
        }
        if (!this.mRecordAllHistory) {
            return;
        }
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16385, name, uid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteSyncStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.getUidStatsLocked(uid).noteStartSyncLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(32772, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32772, name, uid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteSyncFinishLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.getUidStatsLocked(uid).noteStopSyncLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(16388, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16388, name, uid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteJobStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.getUidStatsLocked(uid).noteStartJobLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(32774, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32774, name, uid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteJobFinishLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.getUidStatsLocked(uid).noteStopJobLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(16390, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16390, name, uid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteAlarmStartLocked(String name, int uid) {
        if (!this.mRecordAllHistory) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (!this.mActiveEvents.updateState(32781, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32781, name, uid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteAlarmFinishLocked(String name, int uid) {
        if (!this.mRecordAllHistory) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (!this.mActiveEvents.updateState(16397, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16397, name, uid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$requestWakelockCpuUpdate() {
        if (!this.mHandler.hasMessages(1)) {
            Message m = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(m, 5000L);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$requestImmediateCpuUpdate() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessage(1);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$setRecordAllHistoryLocked(boolean enabled) {
        block6: {
            block5: {
                this.mRecordAllHistory = enabled;
                if (enabled) break block5;
                this.mActiveEvents.removeEvents(5);
                this.mActiveEvents.removeEvents(13);
                HashMap<String, SparseIntArray> active = this.mActiveEvents.getStateForEvent(1);
                if (active == null) break block6;
                long mSecRealtime = this.mClocks.elapsedRealtime();
                long mSecUptime = this.mClocks.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                    SparseIntArray uids = ent.getValue();
                    for (int j = 0; j < uids.size(); ++j) {
                        this.addHistoryEventLocked(mSecRealtime, mSecUptime, 16385, ent.getKey(), uids.keyAt(j));
                    }
                }
                break block6;
            }
            HashMap<String, SparseIntArray> active = this.mActiveEvents.getStateForEvent(1);
            if (active != null) {
                long mSecRealtime = this.mClocks.elapsedRealtime();
                long mSecUptime = this.mClocks.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                    SparseIntArray uids = ent.getValue();
                    for (int j = 0; j < uids.size(); ++j) {
                        this.addHistoryEventLocked(mSecRealtime, mSecUptime, 32769, ent.getKey(), uids.keyAt(j));
                    }
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$setNoAutoReset(boolean enabled) {
        this.mNoAutoReset = enabled;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteStartWakeLocked(int uid, int pid, String name, String historyName, int type, boolean unimportantForLogging, long elapsedRealtime, long uptime) {
        uid = this.mapUid(uid);
        if (type == 0) {
            this.aggregateLastWakeupUptimeLocked(uptime);
            if (historyName == null) {
                historyName = name;
            }
            if (this.mRecordAllHistory && this.mActiveEvents.updateState(32773, historyName, uid, 0)) {
                this.addHistoryEventLocked(elapsedRealtime, uptime, 32773, historyName, uid);
            }
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states |= 0x40000000;
                this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                this.mHistoryCur.wakelockTag.string = this.mInitialAcquireWakeName = historyName;
                this.mHistoryCur.wakelockTag.uid = this.mInitialAcquireWakeUid = uid;
                this.mWakeLockImportant = !unimportantForLogging;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            } else if (!this.mWakeLockImportant && !unimportantForLogging && this.mHistoryLastWritten.cmd == 0) {
                if (this.mHistoryLastWritten.wakelockTag != null) {
                    this.mHistoryLastWritten.wakelockTag = null;
                    this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                    this.mHistoryCur.wakelockTag.string = this.mInitialAcquireWakeName = historyName;
                    this.mHistoryCur.wakelockTag.uid = this.mInitialAcquireWakeUid = uid;
                    this.addHistoryRecordLocked(elapsedRealtime, uptime);
                }
                this.mWakeLockImportant = true;
            }
            ++this.mWakeLockNesting;
        }
        if (uid >= 0) {
            if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
                this.requestWakelockCpuUpdate();
            }
            this.getUidStatsLocked(uid).noteStartWakeLocked(pid, name, type, elapsedRealtime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteStopWakeLocked(int uid, int pid, String name, String historyName, int type, long elapsedRealtime, long uptime) {
        uid = this.mapUid(uid);
        if (type == 0) {
            --this.mWakeLockNesting;
            if (this.mRecordAllHistory) {
                if (historyName == null) {
                    historyName = name;
                }
                if (this.mActiveEvents.updateState(16389, historyName, uid, 0)) {
                    this.addHistoryEventLocked(elapsedRealtime, uptime, 16389, historyName, uid);
                }
            }
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states &= 0xBFFFFFFF;
                this.mInitialAcquireWakeName = null;
                this.mInitialAcquireWakeUid = -1;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            }
        }
        if (uid >= 0) {
            if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
                this.requestWakelockCpuUpdate();
            }
            this.getUidStatsLocked(uid).noteStopWakeLocked(pid, name, type, elapsedRealtime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteStartWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStartWakeLocked(ws.get(i), pid, name, historyName, type, unimportantForLogging, elapsedRealtime, uptime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteChangeWakelockFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        int NN = newWs.size();
        for (int i = 0; i < NN; ++i) {
            this.noteStartWakeLocked(newWs.get(i), newPid, newName, newHistoryName, newType, newUnimportantForLogging, elapsedRealtime, uptime);
        }
        int NO = ws.size();
        for (int i = 0; i < NO; ++i) {
            this.noteStopWakeLocked(ws.get(i), pid, name, historyName, type, elapsedRealtime, uptime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteStopWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStopWakeLocked(ws.get(i), pid, name, historyName, type, elapsedRealtime, uptime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$aggregateLastWakeupUptimeLocked(long uptimeMs) {
        if (this.mLastWakeupReason != null) {
            long deltaUptime = uptimeMs - this.mLastWakeupUptimeMs;
            SamplingTimer timer = this.getWakeupReasonTimerLocked(this.mLastWakeupReason);
            timer.add(deltaUptime * 1000L, 1);
            this.mLastWakeupReason = null;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWakeupReasonLocked(String reason) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.aggregateLastWakeupUptimeLocked(uptime);
        this.mHistoryCur.wakeReasonTag = this.mHistoryCur.localWakeReasonTag;
        this.mHistoryCur.wakeReasonTag.string = reason;
        this.mHistoryCur.wakeReasonTag.uid = 0;
        this.mLastWakeupReason = reason;
        this.mLastWakeupUptimeMs = uptime;
        this.addHistoryRecordLocked(elapsedRealtime, uptime);
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$startAddingCpuLocked() {
        this.mHandler.removeMessages(1);
        return this.mOnBatteryInternal;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$finishAddingCpuLocked(int totalUTime, int totalSTime, int statUserTime, int statSystemTime, int statIOWaitTime, int statIrqTime, int statSoftIrqTime, int statIdleTime) {
        this.mCurStepCpuUserTime += (long)totalUTime;
        this.mCurStepCpuSystemTime += (long)totalSTime;
        this.mCurStepStatUserTime += (long)statUserTime;
        this.mCurStepStatSystemTime += (long)statSystemTime;
        this.mCurStepStatIOWaitTime += (long)statIOWaitTime;
        this.mCurStepStatIrqTime += (long)statIrqTime;
        this.mCurStepStatSoftIrqTime += (long)statSoftIrqTime;
        this.mCurStepStatIdleTime += (long)statIdleTime;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessDiedLocked(int uid, int pid) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.mPids.remove(pid);
        }
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getProcessWakeTime(int uid, int pid, long realtime) {
        BatteryStats.Uid.Pid p;
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null && (p = u.mPids.get(pid)) != null) {
            return p.mWakeSumMs + (p.mWakeNesting > 0 ? realtime - p.mWakeStartMs : 0L);
        }
        return 0L;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$reportExcessiveWakeLocked(int uid, String proc, long overTime, long usedTime) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.reportExcessiveWakeLocked(proc, overTime, usedTime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$reportExcessiveCpuLocked(int uid, String proc, long overTime, long usedTime) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.reportExcessiveCpuLocked(proc, overTime, usedTime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteStartSensorLocked(int uid, int sensor) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states |= 0x800000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mSensorNesting;
        this.getUidStatsLocked(uid).noteStartSensor(sensor, elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteStopSensorLocked(int uid, int sensor) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mSensorNesting;
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states &= 0xFF7FFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteStopSensor(sensor, elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteStartGpsLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states |= 0x20000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mGpsNesting;
        this.getUidStatsLocked(uid).noteStartGps(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteStopGpsLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mGpsNesting;
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteStopGps(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteScreenStateLocked(int state) {
        if (this.mScreenState != state) {
            this.recordDailyStatsIfNeededLocked(true);
            int oldState = this.mScreenState;
            this.mScreenState = state;
            if (state != 0) {
                int stepState = state - 1;
                if (stepState < 4) {
                    this.mModStepMode |= this.mCurStepMode & 3 ^ stepState;
                    this.mCurStepMode = this.mCurStepMode & 0xFFFFFFFC | stepState;
                } else {
                    Slog.wtf("BatteryStatsImpl", "Unexpected screen state: " + state);
                }
            }
            if (state == 2) {
                long elapsedRealtime = this.mClocks.elapsedRealtime();
                long uptime = this.mClocks.uptimeMillis();
                this.mHistoryCur.states |= 0x100000;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
                this.mScreenOnTimer.startRunningLocked(elapsedRealtime);
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].startRunningLocked(elapsedRealtime);
                }
                this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), false, this.mClocks.uptimeMillis() * 1000L, elapsedRealtime * 1000L);
                this.noteStartWakeLocked(-1, -1, "screen", null, 0, false, elapsedRealtime, uptime);
                if (this.mOnBatteryInternal) {
                    this.updateDischargeScreenLevelsLocked(false, true);
                }
            } else if (oldState == 2) {
                long elapsedRealtime = this.mClocks.elapsedRealtime();
                long uptime = this.mClocks.uptimeMillis();
                this.mHistoryCur.states &= 0xFFEFFFFF;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
                this.mScreenOnTimer.stopRunningLocked(elapsedRealtime);
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(elapsedRealtime);
                }
                this.noteStopWakeLocked(-1, -1, "screen", "screen", 0, elapsedRealtime, uptime);
                this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), true, this.mClocks.uptimeMillis() * 1000L, elapsedRealtime * 1000L);
                if (this.mOnBatteryInternal) {
                    this.updateDischargeScreenLevelsLocked(true, false);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteScreenBrightnessLocked(int brightness) {
        int bin = brightness / 51;
        if (bin < 0) {
            bin = 0;
        } else if (bin >= 5) {
            bin = 4;
        }
        if (this.mScreenBrightnessBin != bin) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFF8 | bin << 0;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            if (this.mScreenState == 2) {
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(elapsedRealtime);
                }
                this.mScreenBrightnessTimer[bin].startRunningLocked(elapsedRealtime);
            }
            this.mScreenBrightnessBin = bin;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteUserActivityLocked(int uid, int event) {
        if (this.mOnBatteryInternal) {
            uid = this.mapUid(uid);
            this.getUidStatsLocked(uid).noteUserActivityLocked(event);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWakeUpLocked(String reason, int reasonUid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 18, reason, reasonUid);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteInteractiveLocked(boolean interactive) {
        if (this.mInteractive != interactive) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            this.mInteractive = interactive;
            if (interactive) {
                this.mInteractiveTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mInteractiveTimer.stopRunningLocked(elapsedRealtime);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteConnectivityChangedLocked(int type, String extra) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 9, extra, type);
        ++this.mNumConnectivityChange;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteMobileRadioPowerState(int powerState, long timestampNs, int uid) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mMobileRadioPowerState != powerState) {
            long realElapsedRealtimeMs;
            boolean active;
            boolean bl = active = powerState == 2 || powerState == 3;
            if (active) {
                this.mMobileRadioActiveStartTime = realElapsedRealtimeMs = timestampNs / 1000000L;
                this.mHistoryCur.states |= 0x2000000;
            } else {
                realElapsedRealtimeMs = timestampNs / 1000000L;
                long lastUpdateTimeMs = this.mMobileRadioActiveStartTime;
                if (realElapsedRealtimeMs < lastUpdateTimeMs) {
                    Slog.wtf("BatteryStatsImpl", "Data connection inactive timestamp " + realElapsedRealtimeMs + " is before start time " + lastUpdateTimeMs);
                    realElapsedRealtimeMs = elapsedRealtime;
                } else if (realElapsedRealtimeMs < elapsedRealtime) {
                    this.mMobileRadioActiveAdjustedTime.addCountLocked(elapsedRealtime - realElapsedRealtimeMs);
                }
                this.mHistoryCur.states &= 0xFDFFFFFF;
            }
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mMobileRadioPowerState = powerState;
            if (active) {
                this.mMobileRadioActiveTimer.startRunningLocked(elapsedRealtime);
                this.mMobileRadioActivePerAppTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mMobileRadioActiveTimer.stopRunningLocked(realElapsedRealtimeMs);
                this.updateMobileRadioStateLocked(realElapsedRealtimeMs, null);
                this.mMobileRadioActivePerAppTimer.stopRunningLocked(realElapsedRealtimeMs);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$notePowerSaveMode(boolean enabled) {
        if (this.mPowerSaveModeEnabled != enabled) {
            int stepState = enabled ? 4 : 0;
            this.mModStepMode |= this.mCurStepMode & 4 ^ stepState;
            this.mCurStepMode = this.mCurStepMode & 0xFFFFFFFB | stepState;
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mPowerSaveModeEnabled = enabled;
            if (enabled) {
                this.mHistoryCur.states2 |= Integer.MIN_VALUE;
                this.mPowerSaveModeEnabledTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mHistoryCur.states2 &= Integer.MAX_VALUE;
                this.mPowerSaveModeEnabledTimer.stopRunningLocked(elapsedRealtime);
            }
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteDeviceIdleModeLocked(int mode, String activeReason, int activeUid) {
        boolean nowLightIdling;
        boolean nowIdling;
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        boolean bl = nowIdling = mode == 2;
        if (this.mDeviceIdling && !nowIdling && activeReason == null) {
            nowIdling = true;
        }
        boolean bl2 = nowLightIdling = mode == 1;
        if (this.mDeviceLightIdling && !nowLightIdling && !nowIdling && activeReason == null) {
            nowLightIdling = true;
        }
        if (activeReason != null && (this.mDeviceIdling || this.mDeviceLightIdling)) {
            this.addHistoryEventLocked(elapsedRealtime, uptime, 10, activeReason, activeUid);
        }
        if (this.mDeviceIdling != nowIdling) {
            this.mDeviceIdling = nowIdling;
            int stepState = nowIdling ? 8 : 0;
            this.mModStepMode |= this.mCurStepMode & 8 ^ stepState;
            this.mCurStepMode = this.mCurStepMode & 0xFFFFFFF7 | stepState;
            if (nowIdling) {
                this.mDeviceIdlingTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mDeviceIdlingTimer.stopRunningLocked(elapsedRealtime);
            }
        }
        if (this.mDeviceLightIdling != nowLightIdling) {
            this.mDeviceLightIdling = nowLightIdling;
            if (nowLightIdling) {
                this.mDeviceLightIdlingTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mDeviceLightIdlingTimer.stopRunningLocked(elapsedRealtime);
            }
        }
        if (this.mDeviceIdleMode != mode) {
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xF9FFFFFF | mode << 25;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            long lastDuration = elapsedRealtime - this.mLastIdleTimeStart;
            this.mLastIdleTimeStart = elapsedRealtime;
            if (this.mDeviceIdleMode == 1) {
                if (lastDuration > this.mLongestLightIdleTime) {
                    this.mLongestLightIdleTime = lastDuration;
                }
                this.mDeviceIdleModeLightTimer.stopRunningLocked(elapsedRealtime);
            } else if (this.mDeviceIdleMode == 2) {
                if (lastDuration > this.mLongestFullIdleTime) {
                    this.mLongestFullIdleTime = lastDuration;
                }
                this.mDeviceIdleModeFullTimer.stopRunningLocked(elapsedRealtime);
            }
            if (mode == 1) {
                this.mDeviceIdleModeLightTimer.startRunningLocked(elapsedRealtime);
            } else if (mode == 2) {
                this.mDeviceIdleModeFullTimer.startRunningLocked(elapsedRealtime);
            }
            this.mDeviceIdleMode = mode;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$notePackageInstalledLocked(String pkgName, int versionCode) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 11, pkgName, versionCode);
        BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
        pc.mPackageName = pkgName;
        pc.mUpdate = true;
        pc.mVersionCode = versionCode;
        this.addPackageChange(pc);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$notePackageUninstalledLocked(String pkgName) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 12, pkgName, 0);
        BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
        pc.mPackageName = pkgName;
        pc.mUpdate = true;
        this.addPackageChange(pc);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$addPackageChange(BatteryStats.PackageChange pc) {
        if (this.mDailyPackageChanges == null) {
            this.mDailyPackageChanges = new ArrayList();
        }
        this.mDailyPackageChanges.add(pc);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneOnLocked() {
        if (!this.mPhoneOn) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 |= 0x800000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mPhoneOn = true;
            this.mPhoneOnTimer.startRunningLocked(elapsedRealtime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneOffLocked() {
        if (this.mPhoneOn) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 &= 0xFF7FFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mPhoneOn = false;
            this.mPhoneOnTimer.stopRunningLocked(elapsedRealtime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$stopAllPhoneSignalStrengthTimersLocked(int except) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        for (int i = 0; i < 5; ++i) {
            if (i == except) continue;
            while (this.mPhoneSignalStrengthsTimer[i].isRunningLocked()) {
                this.mPhoneSignalStrengthsTimer[i].stopRunningLocked(elapsedRealtime);
            }
        }
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$fixPhoneServiceState(int state, int signalBin) {
        if (this.mPhoneSimStateRaw == 1 && state == 1 && signalBin > 0) {
            state = 0;
        }
        return state;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateAllPhoneStateLocked(int state, int simState, int strengthBin) {
        boolean scanning = false;
        boolean newHistory = false;
        this.mPhoneServiceStateRaw = state;
        this.mPhoneSimStateRaw = simState;
        this.mPhoneSignalStrengthBinRaw = strengthBin;
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (simState == 1 && state == 1 && strengthBin > 0) {
            state = 0;
        }
        if (state == 3) {
            strengthBin = -1;
        } else if (state != 0 && state == 1) {
            scanning = true;
            strengthBin = 0;
            if (!this.mPhoneSignalScanningTimer.isRunningLocked()) {
                this.mHistoryCur.states |= 0x200000;
                newHistory = true;
                this.mPhoneSignalScanningTimer.startRunningLocked(elapsedRealtime);
            }
        }
        if (!scanning && this.mPhoneSignalScanningTimer.isRunningLocked()) {
            this.mHistoryCur.states &= 0xFFDFFFFF;
            newHistory = true;
            this.mPhoneSignalScanningTimer.stopRunningLocked(elapsedRealtime);
        }
        if (this.mPhoneServiceState != state) {
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFE3F | state << 6;
            newHistory = true;
            this.mPhoneServiceState = state;
        }
        if (this.mPhoneSignalStrengthBin != strengthBin) {
            if (this.mPhoneSignalStrengthBin >= 0) {
                this.mPhoneSignalStrengthsTimer[this.mPhoneSignalStrengthBin].stopRunningLocked(elapsedRealtime);
            }
            if (strengthBin >= 0) {
                if (!this.mPhoneSignalStrengthsTimer[strengthBin].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[strengthBin].startRunningLocked(elapsedRealtime);
                }
                this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFC7 | strengthBin << 3;
                newHistory = true;
            } else {
                this.stopAllPhoneSignalStrengthTimersLocked(-1);
            }
            this.mPhoneSignalStrengthBin = strengthBin;
        }
        if (newHistory) {
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneStateLocked(int state, int simState) {
        this.updateAllPhoneStateLocked(state, simState, this.mPhoneSignalStrengthBinRaw);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        int bin = signalStrength.getLevel();
        this.updateAllPhoneStateLocked(this.mPhoneServiceStateRaw, this.mPhoneSimStateRaw, bin);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneDataConnectionStateLocked(int dataType, boolean hasData) {
        int bin = 0;
        if (hasData) {
            switch (dataType) {
                case 2: {
                    bin = 2;
                    break;
                }
                case 1: {
                    bin = 1;
                    break;
                }
                case 3: {
                    bin = 3;
                    break;
                }
                case 4: {
                    bin = 4;
                    break;
                }
                case 5: {
                    bin = 5;
                    break;
                }
                case 6: {
                    bin = 6;
                    break;
                }
                case 7: {
                    bin = 7;
                    break;
                }
                case 8: {
                    bin = 8;
                    break;
                }
                case 9: {
                    bin = 9;
                    break;
                }
                case 10: {
                    bin = 10;
                    break;
                }
                case 11: {
                    bin = 11;
                    break;
                }
                case 12: {
                    bin = 12;
                    break;
                }
                case 13: {
                    bin = 13;
                    break;
                }
                case 14: {
                    bin = 14;
                    break;
                }
                case 15: {
                    bin = 15;
                    break;
                }
                default: {
                    bin = 16;
                }
            }
        }
        if (this.mPhoneDataConnectionType != bin) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFC1FF | bin << 9;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            if (this.mPhoneDataConnectionType >= 0) {
                this.mPhoneDataConnectionsTimer[this.mPhoneDataConnectionType].stopRunningLocked(elapsedRealtime);
            }
            this.mPhoneDataConnectionType = bin;
            this.mPhoneDataConnectionsTimer[bin].startRunningLocked(elapsedRealtime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiOnLocked() {
        if (!this.mWifiOn) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 |= 0x10000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiOn = true;
            this.mWifiOnTimer.startRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalStatsLocked("wifi-off", 2);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiOffLocked() {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiOn) {
            this.mHistoryCur.states2 &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiOn = false;
            this.mWifiOnTimer.stopRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalStatsLocked("wifi-on", 2);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteAudioOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mAudioOnNesting == 0) {
            this.mHistoryCur.states |= 0x400000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.startRunningLocked(elapsedRealtime);
        }
        ++this.mAudioOnNesting;
        this.getUidStatsLocked(uid).noteAudioTurnedOnLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteAudioOffLocked(int uid) {
        if (this.mAudioOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (--this.mAudioOnNesting == 0) {
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteAudioTurnedOffLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteVideoOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mVideoOnNesting == 0) {
            this.mHistoryCur.states2 |= 0x40000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.startRunningLocked(elapsedRealtime);
        }
        ++this.mVideoOnNesting;
        this.getUidStatsLocked(uid).noteVideoTurnedOnLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteVideoOffLocked(int uid) {
        if (this.mVideoOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (--this.mVideoOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xBFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteVideoTurnedOffLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetAudioLocked() {
        if (this.mAudioOnNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mAudioOnNesting = 0;
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetAudioLocked(elapsedRealtime);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetVideoLocked() {
        if (this.mVideoOnNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mAudioOnNesting = 0;
            this.mHistoryCur.states2 &= 0xBFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetVideoLocked(elapsedRealtime);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteActivityResumedLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteActivityResumedLocked(this.mClocks.elapsedRealtime());
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteActivityPausedLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteActivityPausedLocked(this.mClocks.elapsedRealtime());
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteVibratorOnLocked(int uid, long durationMillis) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteVibratorOnLocked(durationMillis);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteVibratorOffLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteVibratorOffLocked();
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteFlashlightOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mFlashlightOnNesting++ == 0) {
            this.mHistoryCur.states2 |= 0x8000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.startRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteFlashlightTurnedOnLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteFlashlightOffLocked(int uid) {
        if (this.mFlashlightOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (--this.mFlashlightOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteFlashlightTurnedOffLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteCameraOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mCameraOnNesting++ == 0) {
            this.mHistoryCur.states2 |= 0x200000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.startRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteCameraTurnedOnLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteCameraOffLocked(int uid) {
        if (this.mCameraOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (--this.mCameraOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xFFDFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteCameraTurnedOffLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetCameraLocked() {
        if (this.mCameraOnNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mCameraOnNesting = 0;
            this.mHistoryCur.states2 &= 0xFFDFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetCameraLocked(elapsedRealtime);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetFlashlightLocked() {
        if (this.mFlashlightOnNesting > 0) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mFlashlightOnNesting = 0;
            this.mHistoryCur.states2 &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetFlashlightLocked(elapsedRealtime);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteBluetoothScanStartedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mBluetoothScanNesting == 0) {
            this.mHistoryCur.states2 |= 0x100000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mBluetoothScanTimer.startRunningLocked(elapsedRealtime);
        }
        ++this.mBluetoothScanNesting;
        this.getUidStatsLocked(uid).noteBluetoothScanStartedLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteBluetoothScanStartedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteBluetoothScanStartedLocked(ws.get(i));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteBluetoothScanStoppedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        --this.mBluetoothScanNesting;
        if (this.mBluetoothScanNesting == 0) {
            this.mHistoryCur.states2 &= 0xFFEFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mBluetoothScanTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteBluetoothScanStoppedLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteBluetoothScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteBluetoothScanStoppedLocked(ws.get(i));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetBluetoothScanLocked() {
        if (this.mBluetoothScanNesting > 0) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mBluetoothScanNesting = 0;
            this.mHistoryCur.states2 &= 0xFFEFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mBluetoothScanTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetBluetoothScanLocked(elapsedRealtime);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiRadioPowerState(int powerState, long timestampNs) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiRadioPowerState != powerState) {
            boolean active;
            boolean bl = active = powerState == 2 || powerState == 3;
            this.mHistoryCur.states = active ? (this.mHistoryCur.states |= 0x4000000) : (this.mHistoryCur.states &= 0xFBFFFFFF);
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiRadioPowerState = powerState;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiRunningLocked(WorkSource ws) {
        if (!this.mGlobalWifiRunning) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 |= 0x20000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mGlobalWifiRunning = true;
            this.mGlobalWifiRunningTimer.startRunningLocked(elapsedRealtime);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                int uid = this.mapUid(ws.get(i));
                this.getUidStatsLocked(uid).noteWifiRunningLocked(elapsedRealtime);
            }
            this.scheduleSyncExternalStatsLocked("wifi-running", 2);
        } else {
            Log.w("BatteryStatsImpl", "noteWifiRunningLocked -- called while WIFI running");
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiRunningChangedLocked(WorkSource oldWs, WorkSource newWs) {
        if (this.mGlobalWifiRunning) {
            int uid;
            int i;
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            int N = oldWs.size();
            for (i = 0; i < N; ++i) {
                uid = this.mapUid(oldWs.get(i));
                this.getUidStatsLocked(uid).noteWifiStoppedLocked(elapsedRealtime);
            }
            N = newWs.size();
            for (i = 0; i < N; ++i) {
                uid = this.mapUid(newWs.get(i));
                this.getUidStatsLocked(uid).noteWifiRunningLocked(elapsedRealtime);
            }
        } else {
            Log.w("BatteryStatsImpl", "noteWifiRunningChangedLocked -- called while WIFI not running");
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiStoppedLocked(WorkSource ws) {
        if (this.mGlobalWifiRunning) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.mHistoryCur.states2 &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mGlobalWifiRunning = false;
            this.mGlobalWifiRunningTimer.stopRunningLocked(elapsedRealtime);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                int uid = this.mapUid(ws.get(i));
                this.getUidStatsLocked(uid).noteWifiStoppedLocked(elapsedRealtime);
            }
            this.scheduleSyncExternalStatsLocked("wifi-stopped", 2);
        } else {
            Log.w("BatteryStatsImpl", "noteWifiStoppedLocked -- called while WIFI not running");
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiStateLocked(int wifiState, String accessPoint) {
        if (this.mWifiState != wifiState) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            if (this.mWifiState >= 0) {
                this.mWifiStateTimer[this.mWifiState].stopRunningLocked(elapsedRealtime);
            }
            this.mWifiState = wifiState;
            this.mWifiStateTimer[wifiState].startRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalStatsLocked("wifi-state", 2);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiSupplicantStateChangedLocked(int supplState, boolean failedAuth) {
        if (this.mWifiSupplState != supplState) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            if (this.mWifiSupplState >= 0) {
                this.mWifiSupplStateTimer[this.mWifiSupplState].stopRunningLocked(elapsedRealtime);
            }
            this.mWifiSupplState = supplState;
            this.mWifiSupplStateTimer[supplState].startRunningLocked(elapsedRealtime);
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFFF0 | supplState << 0;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$stopAllWifiSignalStrengthTimersLocked(int except) {
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        for (int i = 0; i < 5; ++i) {
            if (i == except) continue;
            while (this.mWifiSignalStrengthsTimer[i].isRunningLocked()) {
                this.mWifiSignalStrengthsTimer[i].stopRunningLocked(elapsedRealtime);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiRssiChangedLocked(int newRssi) {
        int strengthBin = WifiManager.calculateSignalLevel(newRssi, 5);
        if (this.mWifiSignalStrengthBin != strengthBin) {
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            if (this.mWifiSignalStrengthBin >= 0) {
                this.mWifiSignalStrengthsTimer[this.mWifiSignalStrengthBin].stopRunningLocked(elapsedRealtime);
            }
            if (strengthBin >= 0) {
                if (!this.mWifiSignalStrengthsTimer[strengthBin].isRunningLocked()) {
                    this.mWifiSignalStrengthsTimer[strengthBin].startRunningLocked(elapsedRealtime);
                }
                this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFF8F | strengthBin << 4;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            } else {
                this.stopAllWifiSignalStrengthTimersLocked(-1);
            }
            this.mWifiSignalStrengthBin = strengthBin;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteFullWifiLockAcquiredLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states |= 0x10000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mWifiFullLockNesting;
        this.getUidStatsLocked(uid).noteFullWifiLockAcquiredLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteFullWifiLockReleasedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mWifiFullLockNesting;
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteFullWifiLockReleasedLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiScanStartedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states |= 0x8000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mWifiScanNesting;
        this.getUidStatsLocked(uid).noteWifiScanStartedLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiScanStoppedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mWifiScanNesting;
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteWifiScanStoppedLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiBatchedScanStartedLocked(int uid, int csph) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        this.getUidStatsLocked(uid).noteWifiBatchedScanStartedLocked(csph, elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiBatchedScanStoppedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        this.getUidStatsLocked(uid).noteWifiBatchedScanStoppedLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiMulticastEnabledLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states |= 0x10000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mWifiMulticastNesting;
        this.getUidStatsLocked(uid).noteWifiMulticastEnabledLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiMulticastDisabledLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        long uptime = this.mClocks.uptimeMillis();
        --this.mWifiMulticastNesting;
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states &= 0xFFFEFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteWifiMulticastDisabledLocked(elapsedRealtime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteFullWifiLockAcquiredFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteFullWifiLockAcquiredLocked(ws.get(i));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteFullWifiLockReleasedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteFullWifiLockReleasedLocked(ws.get(i));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiScanStartedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiScanStartedLocked(ws.get(i));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiScanStoppedLocked(ws.get(i));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiBatchedScanStartedFromSourceLocked(WorkSource ws, int csph) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStartedLocked(ws.get(i), csph);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiBatchedScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStoppedLocked(ws.get(i));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiMulticastEnabledFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiMulticastEnabledLocked(ws.get(i));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiMulticastDisabledFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiMulticastDisabledLocked(ws.get(i));
        }
    }

    private static final String[] $$robo$$com_android_internal_os_BatteryStatsImpl$includeInStringArray(String[] array2, String str) {
        if (ArrayUtils.indexOf(array2, str) >= 0) {
            return array2;
        }
        String[] newArray = new String[array2.length + 1];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)array2, (int)0, (Object)newArray, (int)0, (int)array2.length);
        newArray[array2.length] = str;
        return newArray;
    }

    private static final String[] $$robo$$com_android_internal_os_BatteryStatsImpl$excludeFromStringArray(String[] array2, String str) {
        int index = ArrayUtils.indexOf(array2, str);
        if (index >= 0) {
            String[] newArray = new String[array2.length - 1];
            if (index > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)array2, (int)0, (Object)newArray, (int)0, (int)index);
            }
            if (index < array2.length - 1) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)array2, (int)(index + 1), (Object)newArray, (int)index, (int)(array2.length - index - 1));
            }
            return newArray;
        }
        return array2;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteNetworkInterfaceTypeLocked(String iface, int networkType) {
        if (TextUtils.isEmpty(iface)) {
            return;
        }
        this.mMobileIfaces = ConnectivityManager.isNetworkTypeMobile(networkType) ? BatteryStatsImpl.includeInStringArray(this.mMobileIfaces, iface) : BatteryStatsImpl.excludeFromStringArray(this.mMobileIfaces, iface);
        this.mWifiIfaces = ConnectivityManager.isNetworkTypeWifi(networkType) ? BatteryStatsImpl.includeInStringArray(this.mWifiIfaces, iface) : BatteryStatsImpl.excludeFromStringArray(this.mWifiIfaces, iface);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$noteNetworkStatsEnabledLocked() {
        this.updateMobileRadioStateLocked(this.mClocks.elapsedRealtime(), null);
        this.updateWifiStateLocked(null);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getScreenOnTime(long elapsedRealtimeUs, int which) {
        return this.mScreenOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getScreenOnCount(int which) {
        return this.mScreenOnTimer.getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getScreenBrightnessTime(int brightnessBin, long elapsedRealtimeUs, int which) {
        return this.mScreenBrightnessTimer[brightnessBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getInteractiveTime(long elapsedRealtimeUs, int which) {
        return this.mInteractiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getPowerSaveModeEnabledTime(long elapsedRealtimeUs, int which) {
        return this.mPowerSaveModeEnabledTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getPowerSaveModeEnabledCount(int which) {
        return this.mPowerSaveModeEnabledTimer.getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getDeviceIdleModeTime(int mode, long elapsedRealtimeUs, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceIdleModeLightTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
            case 2: {
                return this.mDeviceIdleModeFullTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
        }
        return 0L;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDeviceIdleModeCount(int mode, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceIdleModeLightTimer.getCountLocked(which);
            }
            case 2: {
                return this.mDeviceIdleModeFullTimer.getCountLocked(which);
            }
        }
        return 0;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getLongestDeviceIdleModeTime(int mode) {
        switch (mode) {
            case 1: {
                return this.mLongestLightIdleTime;
            }
            case 2: {
                return this.mLongestFullIdleTime;
            }
        }
        return 0L;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getDeviceIdlingTime(int mode, long elapsedRealtimeUs, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceLightIdlingTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
            case 2: {
                return this.mDeviceIdlingTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
            }
        }
        return 0L;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDeviceIdlingCount(int mode, int which) {
        switch (mode) {
            case 1: {
                return this.mDeviceLightIdlingTimer.getCountLocked(which);
            }
            case 2: {
                return this.mDeviceIdlingTimer.getCountLocked(which);
            }
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getNumConnectivityChange(int which) {
        int val = this.mNumConnectivityChange;
        if (which == 1) {
            val -= this.mLoadedNumConnectivityChange;
        } else if (which == 2) {
            val -= this.mUnpluggedNumConnectivityChange;
        }
        return val;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneOnTime(long elapsedRealtimeUs, int which) {
        return this.mPhoneOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneOnCount(int which) {
        return this.mPhoneOnTimer.getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneSignalStrengthTime(int strengthBin, long elapsedRealtimeUs, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneSignalScanningTime(long elapsedRealtimeUs, int which) {
        return this.mPhoneSignalScanningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneSignalStrengthCount(int strengthBin, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneDataConnectionTime(int dataType, long elapsedRealtimeUs, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneDataConnectionCount(int dataType, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveTime(long elapsedRealtimeUs, int which) {
        return this.mMobileRadioActiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveCount(int which) {
        return this.mMobileRadioActiveTimer.getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveAdjustedTime(int which) {
        return this.mMobileRadioActiveAdjustedTime.getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveUnknownTime(int which) {
        return this.mMobileRadioActiveUnknownTime.getCountLocked(which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveUnknownCount(int which) {
        return (int)this.mMobileRadioActiveUnknownCount.getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiOnTime(long elapsedRealtimeUs, int which) {
        return this.mWifiOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getGlobalWifiRunningTime(long elapsedRealtimeUs, int which) {
        return this.mGlobalWifiRunningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiStateTime(int wifiState, long elapsedRealtimeUs, int which) {
        return this.mWifiStateTimer[wifiState].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiStateCount(int wifiState, int which) {
        return this.mWifiStateTimer[wifiState].getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiSupplStateTime(int state, long elapsedRealtimeUs, int which) {
        return this.mWifiSupplStateTimer[state].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiSupplStateCount(int state, int which) {
        return this.mWifiSupplStateTimer[state].getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiSignalStrengthTime(int strengthBin, long elapsedRealtimeUs, int which) {
        return this.mWifiSignalStrengthsTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiSignalStrengthCount(int strengthBin, int which) {
        return this.mWifiSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    private final BatteryStats.ControllerActivityCounter $$robo$$com_android_internal_os_BatteryStatsImpl$getBluetoothControllerActivity() {
        return this.mBluetoothActivity;
    }

    private final BatteryStats.ControllerActivityCounter $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiControllerActivity() {
        return this.mWifiActivity;
    }

    private final BatteryStats.ControllerActivityCounter $$robo$$com_android_internal_os_BatteryStatsImpl$getModemControllerActivity() {
        return this.mModemActivity;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$hasBluetoothActivityReporting() {
        return this.mHasBluetoothReporting;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$hasWifiActivityReporting() {
        return this.mHasWifiReporting;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$hasModemActivityReporting() {
        return this.mHasModemReporting;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getFlashlightOnTime(long elapsedRealtimeUs, int which) {
        return this.mFlashlightOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getFlashlightOnCount(int which) {
        return this.mFlashlightOnTimer.getCountLocked(which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getCameraOnTime(long elapsedRealtimeUs, int which) {
        return this.mCameraOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getBluetoothScanTime(long elapsedRealtimeUs, int which) {
        return this.mBluetoothScanTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getNetworkActivityBytes(int type, int which) {
        if (type >= 0 && type < this.mNetworkByteActivityCounters.length) {
            return this.mNetworkByteActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getNetworkActivityPackets(int type, int which) {
        if (type >= 0 && type < this.mNetworkPacketActivityCounters.length) {
            return this.mNetworkPacketActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getStartClockTime() {
        CallSite currentTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.ensureStartClockTime((long)currentTime)) {
            this.recordCurrentTimeChangeLocked((long)currentTime, this.mClocks.elapsedRealtime(), this.mClocks.uptimeMillis());
        }
        return this.mStartClockTime;
    }

    private final String $$robo$$com_android_internal_os_BatteryStatsImpl$getStartPlatformVersion() {
        return this.mStartPlatformVersion;
    }

    private final String $$robo$$com_android_internal_os_BatteryStatsImpl$getEndPlatformVersion() {
        return this.mEndPlatformVersion;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getParcelVersion() {
        return 147;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$getIsOnBattery() {
        return this.mOnBattery;
    }

    private final SparseArray<? extends BatteryStats.Uid> $$robo$$com_android_internal_os_BatteryStatsImpl$getUidStats() {
        return this.mUidStats;
    }

    private void $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(File systemDir, Handler handler, ExternalStatsSync externalSync) {
    }

    private void $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(File systemDir, Handler handler, ExternalStatsSync externalSync, PlatformIdleStateCallback cb) {
    }

    private void $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(Clocks clocks, File systemDir, Handler handler, ExternalStatsSync externalSync, PlatformIdleStateCallback cb) {
        int i;
        this.mKernelWakelockReader = new KernelWakelockReader();
        this.mTmpWakelockStats = new KernelWakelockStats();
        this.mKernelUidCpuTimeReader = new KernelUidCpuTimeReader();
        this.mIsolatedUids = new SparseIntArray();
        this.mUidStats = new SparseArray();
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mDrawTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mWifiScanTimers = new ArrayList();
        this.mWifiBatchedScanTimers = new SparseArray();
        this.mAudioTurnedOnTimers = new ArrayList();
        this.mVideoTurnedOnTimers = new ArrayList();
        this.mFlashlightTurnedOnTimers = new ArrayList();
        this.mCameraTurnedOnTimers = new ArrayList();
        this.mBluetoothScanOnTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mOnBatteryTimeBase = new TimeBase();
        this.mOnBatteryScreenOffTimeBase = new TimeBase();
        this.mActiveEvents = new BatteryStats.HistoryEventTracker();
        this.mHaveBatteryLevel = false;
        this.mRecordingHistory = false;
        this.mHistoryBuffer = Parcel.obtain();
        this.mHistoryLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryLastLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryReadTmp = new BatteryStats.HistoryItem();
        this.mHistoryAddTmp = new BatteryStats.HistoryItem();
        this.mHistoryTagPool = new HashMap();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        this.mHistoryOverflow = false;
        this.mActiveHistoryStates = -1;
        this.mActiveHistoryStates2 = -1;
        this.mLastHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryUptime = 0L;
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mLastHistoryStepDetails = null;
        this.mLastHistoryStepLevel = 0;
        this.mCurHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mTmpHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mScreenState = 0;
        this.mScreenBrightnessBin = -1;
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthBin = -1;
        this.mPhoneSignalStrengthBinRaw = -1;
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionType = -1;
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[17];
        this.mNetworkByteActivityCounters = new LongSamplingCounter[6];
        this.mNetworkPacketActivityCounters = new LongSamplingCounter[6];
        this.mHasWifiReporting = false;
        this.mHasBluetoothReporting = false;
        this.mHasModemReporting = false;
        this.mWifiState = -1;
        this.mWifiStateTimer = new StopwatchTimer[8];
        this.mWifiSupplState = -1;
        this.mWifiSupplStateTimer = new StopwatchTimer[13];
        this.mWifiSignalStrengthBin = -1;
        this.mWifiSignalStrengthsTimer = new StopwatchTimer[5];
        this.mMobileRadioPowerState = 1;
        this.mWifiRadioPowerState = 1;
        this.mCharging = true;
        this.mInitStepMode = 0;
        this.mCurStepMode = 0;
        this.mModStepMode = 0;
        this.mDischargeStepTracker = new BatteryStats.LevelStepTracker(200);
        this.mDailyDischargeStepTracker = new BatteryStats.LevelStepTracker(400);
        this.mChargeStepTracker = new BatteryStats.LevelStepTracker(200);
        this.mDailyChargeStepTracker = new BatteryStats.LevelStepTracker(400);
        this.mDailyStartTime = 0L;
        this.mNextMinDailyDeadline = 0L;
        this.mNextMaxDailyDeadline = 0L;
        this.mDailyItems = new ArrayList();
        this.mLastWriteTime = 0L;
        this.mPhoneServiceState = -1;
        this.mPhoneServiceStateRaw = -1;
        this.mPhoneSimStateRaw = -1;
        this.mEstimatedBatteryCapacity = -1;
        this.mTmpNetworkStatsEntry = new NetworkStats.Entry();
        this.mKernelWakelockStats = new HashMap();
        this.mLastWakeupReason = null;
        this.mLastWakeupUptimeMs = 0L;
        this.mWakeupReasonStats = new HashMap();
        this.mChangedStates = 0;
        this.mChangedStates2 = 0;
        this.mInitialAcquireWakeUid = -1;
        this.mWifiFullLockNesting = 0;
        this.mWifiScanNesting = 0;
        this.mWifiMulticastNesting = 0;
        this.mMobileIfaces = EmptyArray.STRING;
        this.mWifiIfaces = EmptyArray.STRING;
        this.mNetworkStatsFactory = new NetworkStatsFactory();
        this.mPendingWrite = null;
        this.mWriteLock = new ReentrantLock();
        this.init(clocks);
        this.mFile = systemDir != null ? new JournaledFile(new File(systemDir, "batterystats.bin"), new File(systemDir, "batterystats.bin.tmp")) : null;
        this.mCheckinFile = new AtomicFile(new File(systemDir, "batterystats-checkin.bin"));
        this.mDailyFile = new AtomicFile(new File(systemDir, "batterystats-daily.xml"));
        this.mExternalSync = externalSync;
        this.mHandler = new MyHandler(this, handler.getLooper());
        ++this.mStartCount;
        this.mScreenOnTimer = new StopwatchTimer(this.mClocks, null, -1, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(this.mClocks, null, -100 - i, null, this.mOnBatteryTimeBase);
        }
        this.mInteractiveTimer = new StopwatchTimer(this.mClocks, null, -10, null, this.mOnBatteryTimeBase);
        this.mPowerSaveModeEnabledTimer = new StopwatchTimer(this.mClocks, null, -2, null, this.mOnBatteryTimeBase);
        this.mDeviceIdleModeLightTimer = new StopwatchTimer(this.mClocks, null, -11, null, this.mOnBatteryTimeBase);
        this.mDeviceIdleModeFullTimer = new StopwatchTimer(this.mClocks, null, -14, null, this.mOnBatteryTimeBase);
        this.mDeviceLightIdlingTimer = new StopwatchTimer(this.mClocks, null, -15, null, this.mOnBatteryTimeBase);
        this.mDeviceIdlingTimer = new StopwatchTimer(this.mClocks, null, -12, null, this.mOnBatteryTimeBase);
        this.mPhoneOnTimer = new StopwatchTimer(this.mClocks, null, -3, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(this.mClocks, null, -200 - i, null, this.mOnBatteryTimeBase);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(this.mClocks, null, -199, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(this.mClocks, null, -300 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 6; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
        }
        this.mWifiActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 1);
        this.mBluetoothActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 1);
        this.mModemActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 5);
        this.mMobileRadioActiveTimer = new StopwatchTimer(this.mClocks, null, -400, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(this.mClocks, null, -401, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mWifiOnTimer = new StopwatchTimer(this.mClocks, null, -4, null, this.mOnBatteryTimeBase);
        this.mGlobalWifiRunningTimer = new StopwatchTimer(this.mClocks, null, -5, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(this.mClocks, null, -600 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(this.mClocks, null, -700 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(this.mClocks, null, -800 - i, null, this.mOnBatteryTimeBase);
        }
        this.mAudioOnTimer = new StopwatchTimer(this.mClocks, null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnTimer = new StopwatchTimer(this.mClocks, null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOnTimer = new StopwatchTimer(this.mClocks, null, -9, null, this.mOnBatteryTimeBase);
        this.mCameraOnTimer = new StopwatchTimer(this.mClocks, null, -13, null, this.mOnBatteryTimeBase);
        this.mBluetoothScanTimer = new StopwatchTimer(this.mClocks, null, -14, null, this.mOnBatteryTimeBase);
        this.mDischargeScreenOffCounter = new LongSamplingCounter(this.mOnBatteryScreenOffTimeBase);
        this.mDischargeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mOnBatteryInternal = false;
        this.mOnBattery = false;
        long uptime = this.mClocks.uptimeMillis() * 1000L;
        long realtime = this.mClocks.elapsedRealtime() * 1000L;
        this.initTimes(uptime, realtime);
        this.mStartPlatformVersion = this.mEndPlatformVersion = Build.ID;
        this.mDischargeStartLevel = 0;
        this.mDischargeUnplugLevel = 0;
        this.mDischargePlugLevel = -1;
        this.mDischargeCurrentLevel = 0;
        this.mCurrentBatteryLevel = 0;
        this.initDischarge();
        this.clearHistoryLocked();
        this.updateDailyDeadlineLocked();
        this.mPlatformIdleStateCallback = cb;
    }

    private void $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(Parcel p) {
    }

    private void $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(Clocks clocks, Parcel p) {
        this.mKernelWakelockReader = new KernelWakelockReader();
        this.mTmpWakelockStats = new KernelWakelockStats();
        this.mKernelUidCpuTimeReader = new KernelUidCpuTimeReader();
        this.mIsolatedUids = new SparseIntArray();
        this.mUidStats = new SparseArray();
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mDrawTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mWifiScanTimers = new ArrayList();
        this.mWifiBatchedScanTimers = new SparseArray();
        this.mAudioTurnedOnTimers = new ArrayList();
        this.mVideoTurnedOnTimers = new ArrayList();
        this.mFlashlightTurnedOnTimers = new ArrayList();
        this.mCameraTurnedOnTimers = new ArrayList();
        this.mBluetoothScanOnTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mOnBatteryTimeBase = new TimeBase();
        this.mOnBatteryScreenOffTimeBase = new TimeBase();
        this.mActiveEvents = new BatteryStats.HistoryEventTracker();
        this.mHaveBatteryLevel = false;
        this.mRecordingHistory = false;
        this.mHistoryBuffer = Parcel.obtain();
        this.mHistoryLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryLastLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryReadTmp = new BatteryStats.HistoryItem();
        this.mHistoryAddTmp = new BatteryStats.HistoryItem();
        this.mHistoryTagPool = new HashMap();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        this.mHistoryOverflow = false;
        this.mActiveHistoryStates = -1;
        this.mActiveHistoryStates2 = -1;
        this.mLastHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryUptime = 0L;
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mLastHistoryStepDetails = null;
        this.mLastHistoryStepLevel = 0;
        this.mCurHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mTmpHistoryStepDetails = new BatteryStats.HistoryStepDetails();
        this.mScreenState = 0;
        this.mScreenBrightnessBin = -1;
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthBin = -1;
        this.mPhoneSignalStrengthBinRaw = -1;
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionType = -1;
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[17];
        this.mNetworkByteActivityCounters = new LongSamplingCounter[6];
        this.mNetworkPacketActivityCounters = new LongSamplingCounter[6];
        this.mHasWifiReporting = false;
        this.mHasBluetoothReporting = false;
        this.mHasModemReporting = false;
        this.mWifiState = -1;
        this.mWifiStateTimer = new StopwatchTimer[8];
        this.mWifiSupplState = -1;
        this.mWifiSupplStateTimer = new StopwatchTimer[13];
        this.mWifiSignalStrengthBin = -1;
        this.mWifiSignalStrengthsTimer = new StopwatchTimer[5];
        this.mMobileRadioPowerState = 1;
        this.mWifiRadioPowerState = 1;
        this.mCharging = true;
        this.mInitStepMode = 0;
        this.mCurStepMode = 0;
        this.mModStepMode = 0;
        this.mDischargeStepTracker = new BatteryStats.LevelStepTracker(200);
        this.mDailyDischargeStepTracker = new BatteryStats.LevelStepTracker(400);
        this.mChargeStepTracker = new BatteryStats.LevelStepTracker(200);
        this.mDailyChargeStepTracker = new BatteryStats.LevelStepTracker(400);
        this.mDailyStartTime = 0L;
        this.mNextMinDailyDeadline = 0L;
        this.mNextMaxDailyDeadline = 0L;
        this.mDailyItems = new ArrayList();
        this.mLastWriteTime = 0L;
        this.mPhoneServiceState = -1;
        this.mPhoneServiceStateRaw = -1;
        this.mPhoneSimStateRaw = -1;
        this.mEstimatedBatteryCapacity = -1;
        this.mTmpNetworkStatsEntry = new NetworkStats.Entry();
        this.mKernelWakelockStats = new HashMap();
        this.mLastWakeupReason = null;
        this.mLastWakeupUptimeMs = 0L;
        this.mWakeupReasonStats = new HashMap();
        this.mChangedStates = 0;
        this.mChangedStates2 = 0;
        this.mInitialAcquireWakeUid = -1;
        this.mWifiFullLockNesting = 0;
        this.mWifiScanNesting = 0;
        this.mWifiMulticastNesting = 0;
        this.mMobileIfaces = EmptyArray.STRING;
        this.mWifiIfaces = EmptyArray.STRING;
        this.mNetworkStatsFactory = new NetworkStatsFactory();
        this.mPendingWrite = null;
        this.mWriteLock = new ReentrantLock();
        this.init(clocks);
        this.mFile = null;
        this.mCheckinFile = null;
        this.mDailyFile = null;
        this.mHandler = null;
        this.mExternalSync = null;
        this.clearHistoryLocked();
        this.readFromParcel(p);
        this.mPlatformIdleStateCallback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$setPowerProfile(PowerProfile profile) {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            this.mPowerProfile = profile;
            int numClusters = this.mPowerProfile.getNumCpuClusters();
            this.mKernelCpuSpeedReaders = new KernelCpuSpeedReader[numClusters];
            int firstCpuOfCluster = 0;
            for (int i = 0; i < numClusters; ++i) {
                int numSpeedSteps = this.mPowerProfile.getNumSpeedStepsInCpuCluster(i);
                this.mKernelCpuSpeedReaders[i] = new KernelCpuSpeedReader(firstCpuOfCluster, numSpeedSteps);
                firstCpuOfCluster += this.mPowerProfile.getNumCoresInCpuCluster(i);
            }
            if (this.mEstimatedBatteryCapacity == -1) {
                this.mEstimatedBatteryCapacity = (int)this.mPowerProfile.getBatteryCapacity();
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$setCallback(BatteryCallback cb) {
        this.mCallback = cb;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$setRadioScanningTimeout(long timeout) {
        if (this.mPhoneSignalScanningTimer != null) {
            this.mPhoneSignalScanningTimer.setTimeout(timeout);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateDailyDeadlineLocked() {
        CallSite callSite = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mDailyStartTime = (long)callSite;
        CallSite currentTime = callSite;
        Calendar calDeadline = Calendar.getInstance();
        calDeadline.setTimeInMillis((long)currentTime);
        calDeadline.set(6, calDeadline.get(6) + 1);
        calDeadline.set(14, 0);
        calDeadline.set(13, 0);
        calDeadline.set(12, 0);
        calDeadline.set(11, 1);
        this.mNextMinDailyDeadline = calDeadline.getTimeInMillis();
        calDeadline.set(11, 3);
        this.mNextMaxDailyDeadline = calDeadline.getTimeInMillis();
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$recordDailyStatsIfNeededLocked(boolean settled) {
        CallSite currentTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (currentTime >= this.mNextMaxDailyDeadline) {
            this.recordDailyStatsLocked();
        } else if (settled && currentTime >= this.mNextMinDailyDeadline) {
            this.recordDailyStatsLocked();
        } else if (currentTime < this.mDailyStartTime - 86400000L) {
            this.recordDailyStatsLocked();
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$recordDailyStatsLocked() {
        BatteryStats.DailyItem item = new BatteryStats.DailyItem();
        item.mStartTime = this.mDailyStartTime;
        item.mEndTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        boolean hasData = false;
        if (this.mDailyDischargeStepTracker.mNumStepDurations > 0) {
            hasData = true;
            item.mDischargeSteps = new BatteryStats.LevelStepTracker(this.mDailyDischargeStepTracker.mNumStepDurations, this.mDailyDischargeStepTracker.mStepDurations);
        }
        if (this.mDailyChargeStepTracker.mNumStepDurations > 0) {
            hasData = true;
            item.mChargeSteps = new BatteryStats.LevelStepTracker(this.mDailyChargeStepTracker.mNumStepDurations, this.mDailyChargeStepTracker.mStepDurations);
        }
        if (this.mDailyPackageChanges != null) {
            hasData = true;
            item.mPackageChanges = this.mDailyPackageChanges;
            this.mDailyPackageChanges = null;
        }
        this.mDailyDischargeStepTracker.init();
        this.mDailyChargeStepTracker.init();
        this.updateDailyDeadlineLocked();
        if (hasData) {
            this.mDailyItems.add(item);
            while (this.mDailyItems.size() > 10) {
                this.mDailyItems.remove(0);
            }
            ByteArrayOutputStream memStream = new ByteArrayOutputStream();
            try {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(memStream, StandardCharsets.UTF_8.name());
                this.writeDailyItemsLocked(out);
                BackgroundThread.getHandler().post(new Runnable(this, memStream){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ByteArrayOutputStream val$memStream;
                    /* synthetic */ BatteryStatsImpl this$0;

                    private void $$robo$$com_android_internal_os_BatteryStatsImpl_1$__constructor__(BatteryStatsImpl this$0, ByteArrayOutputStream byteArrayOutputStream) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private final void $$robo$$com_android_internal_os_BatteryStatsImpl_1$run() {
                        AtomicFile atomicFile = this.this$0.mCheckinFile;
                        synchronized (atomicFile) {
                            FileOutputStream stream = null;
                            try {
                                stream = this.this$0.mDailyFile.startWrite();
                                this.val$memStream.writeTo(stream);
                                stream.flush();
                                FileUtils.sync(stream);
                                stream.close();
                                this.this$0.mDailyFile.finishWrite(stream);
                            }
                            catch (IOException e) {
                                Slog.w("BatteryStats", "Error writing battery daily items", e);
                                this.this$0.mDailyFile.failWrite(stream);
                            }
                        }
                    }

                    private void __constructor__(BatteryStatsImpl batteryStatsImpl, ByteArrayOutputStream byteArrayOutputStream) {
                        this.$$robo$$com_android_internal_os_BatteryStatsImpl_1$__constructor__(batteryStatsImpl, byteArrayOutputStream);
                    }
                    {
                        this.this$0 = batteryStatsImpl;
                        this.val$memStream = byteArrayOutputStream;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_1$__constructor__(com.android.internal.os.BatteryStatsImpl java.io.ByteArrayOutputStream ), 0, this, batteryStatsImpl, byteArrayOutputStream);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_BatteryStatsImpl_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeDailyItemsLocked(XmlSerializer out) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        out.startDocument(null, true);
        out.startTag(null, "daily-items");
        for (int i = 0; i < this.mDailyItems.size(); ++i) {
            BatteryStats.DailyItem dit = this.mDailyItems.get(i);
            out.startTag(null, "item");
            out.attribute(null, "start", Long.toString(dit.mStartTime));
            out.attribute(null, "end", Long.toString(dit.mEndTime));
            this.writeDailyLevelSteps(out, "dis", dit.mDischargeSteps, sb);
            this.writeDailyLevelSteps(out, "chg", dit.mChargeSteps, sb);
            if (dit.mPackageChanges != null) {
                for (int j = 0; j < dit.mPackageChanges.size(); ++j) {
                    BatteryStats.PackageChange pc = dit.mPackageChanges.get(j);
                    if (pc.mUpdate) {
                        out.startTag(null, "upd");
                        out.attribute(null, "pkg", pc.mPackageName);
                        out.attribute(null, "ver", Integer.toString(pc.mVersionCode));
                        out.endTag(null, "upd");
                        continue;
                    }
                    out.startTag(null, "rem");
                    out.attribute(null, "pkg", pc.mPackageName);
                    out.endTag(null, "rem");
                }
            }
            out.endTag(null, "item");
        }
        out.endTag(null, "daily-items");
        out.endDocument();
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeDailyLevelSteps(XmlSerializer out, String tag, BatteryStats.LevelStepTracker steps, StringBuilder tmpBuilder) throws IOException {
        if (steps != null) {
            out.startTag(null, tag);
            out.attribute(null, "n", Integer.toString(steps.mNumStepDurations));
            for (int i = 0; i < steps.mNumStepDurations; ++i) {
                out.startTag(null, "s");
                tmpBuilder.setLength(0);
                steps.encodeEntryAt(i, tmpBuilder);
                out.attribute(null, "v", tmpBuilder.toString());
                out.endTag(null, "s");
            }
            out.endTag(null, tag);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readDailyStatsLocked() {
        FileInputStream stream;
        Slog.d("BatteryStatsImpl", "Reading daily items from " + this.mDailyFile.getBaseFile());
        this.mDailyItems.clear();
        try {
            stream = this.mDailyFile.openRead();
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            this.readDailyItemsLocked(parser);
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readDailyItemsLocked(XmlPullParser parser) {
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("item")) {
                    this.readDailyItemTagLocked(parser);
                    continue;
                }
                Slog.w("BatteryStatsImpl", "Unknown element under <daily-items>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (IllegalStateException e) {
            Slog.w("BatteryStatsImpl", "Failed parsing daily " + e);
        }
        catch (NullPointerException e) {
            Slog.w("BatteryStatsImpl", "Failed parsing daily " + e);
        }
        catch (NumberFormatException e) {
            Slog.w("BatteryStatsImpl", "Failed parsing daily " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w("BatteryStatsImpl", "Failed parsing daily " + e);
        }
        catch (IOException e) {
            Slog.w("BatteryStatsImpl", "Failed parsing daily " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w("BatteryStatsImpl", "Failed parsing daily " + e);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readDailyItemTagLocked(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        BatteryStats.DailyItem dit = new BatteryStats.DailyItem();
        String attr2 = parser.getAttributeValue(null, "start");
        if (attr2 != null) {
            dit.mStartTime = Long.parseLong(attr2);
        }
        if ((attr2 = parser.getAttributeValue(null, "end")) != null) {
            dit.mEndTime = Long.parseLong(attr2);
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            BatteryStats.PackageChange pc;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("dis")) {
                this.readDailyItemTagDetailsLocked(parser, dit, false, "dis");
                continue;
            }
            if (tagName.equals("chg")) {
                this.readDailyItemTagDetailsLocked(parser, dit, true, "chg");
                continue;
            }
            if (tagName.equals("upd")) {
                if (dit.mPackageChanges == null) {
                    dit.mPackageChanges = new ArrayList();
                }
                pc = new BatteryStats.PackageChange();
                pc.mUpdate = true;
                pc.mPackageName = parser.getAttributeValue(null, "pkg");
                String verStr = parser.getAttributeValue(null, "ver");
                pc.mVersionCode = verStr != null ? Integer.parseInt(verStr) : 0;
                dit.mPackageChanges.add(pc);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("rem")) {
                if (dit.mPackageChanges == null) {
                    dit.mPackageChanges = new ArrayList();
                }
                pc = new BatteryStats.PackageChange();
                pc.mUpdate = false;
                pc.mPackageName = parser.getAttributeValue(null, "pkg");
                dit.mPackageChanges.add(pc);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w("BatteryStatsImpl", "Unknown element under <item>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        this.mDailyItems.add(dit);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readDailyItemTagDetailsLocked(XmlPullParser parser, BatteryStats.DailyItem dit, boolean isCharge, String tag) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        String numAttr = parser.getAttributeValue(null, "n");
        if (numAttr == null) {
            Slog.w("BatteryStatsImpl", "Missing 'n' attribute at " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
            return;
        }
        int num = Integer.parseInt(numAttr);
        BatteryStats.LevelStepTracker steps = new BatteryStats.LevelStepTracker(num);
        if (isCharge) {
            dit.mChargeSteps = steps;
        } else {
            dit.mDischargeSteps = steps;
        }
        int i = 0;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("s".equals(tagName)) {
                String valueAttr;
                if (i >= num || (valueAttr = parser.getAttributeValue(null, "v")) == null) continue;
                steps.decodeEntryAt(i, valueAttr);
                ++i;
                continue;
            }
            Slog.w("BatteryStatsImpl", "Unknown element under <" + tag + ">: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        steps.mNumStepDurations = i;
    }

    private final BatteryStats.DailyItem $$robo$$com_android_internal_os_BatteryStatsImpl$getDailyItemLocked(int daysAgo) {
        int index = this.mDailyItems.size() - 1 - daysAgo;
        return index >= 0 ? this.mDailyItems.get(index) : null;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getCurrentDailyStartTime() {
        return this.mDailyStartTime;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getNextMinDailyDeadline() {
        return this.mNextMinDailyDeadline;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getNextMaxDailyDeadline() {
        return this.mNextMaxDailyDeadline;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$startIteratingOldHistoryLocked() {
        this.mHistoryIterator = this.mHistory;
        if (this.mHistoryIterator == null) {
            return false;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryReadTmp.clear();
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        return true;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$getNextOldHistoryLocked(BatteryStats.HistoryItem out) {
        BatteryStats.HistoryItem cur;
        boolean end;
        boolean bl = end = this.mHistoryBuffer.dataPosition() >= this.mHistoryBuffer.dataSize();
        if (!end) {
            this.readHistoryDelta(this.mHistoryBuffer, this.mHistoryReadTmp);
            this.mReadOverflow |= this.mHistoryReadTmp.cmd == 6;
        }
        if ((cur = this.mHistoryIterator) == null) {
            if (!this.mReadOverflow && !end) {
                Slog.w("BatteryStatsImpl", "Old history ends before new history!");
            }
            return false;
        }
        out.setTo(cur);
        this.mHistoryIterator = cur.next;
        if (!this.mReadOverflow) {
            if (end) {
                Slog.w("BatteryStatsImpl", "New history ends before old history!");
            } else if (!out.same(this.mHistoryReadTmp)) {
                FastPrintWriter pw = new FastPrintWriter(new LogWriter(5, "BatteryStatsImpl"));
                pw.println("Histories differ!");
                pw.println("Old history:");
                new BatteryStats.HistoryPrinter().printNextItem(pw, out, 0L, false, true);
                pw.println("New history:");
                new BatteryStats.HistoryPrinter().printNextItem(pw, this.mHistoryReadTmp, 0L, false, true);
                ((PrintWriter)pw).flush();
            }
        }
        return true;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$finishIteratingOldHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        this.mHistoryIterator = null;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryTotalSize() {
        return 262144;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryUsedSize() {
        return this.mHistoryBuffer.dataSize();
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$startIteratingHistoryLocked() {
        if (this.mHistoryBuffer.dataSize() <= 0) {
            return false;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        this.mReadHistoryStrings = new String[this.mHistoryTagPool.size()];
        this.mReadHistoryUids = new int[this.mHistoryTagPool.size()];
        this.mReadHistoryChars = 0;
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            int idx = ent.getValue();
            this.mReadHistoryStrings[idx] = tag.string;
            this.mReadHistoryUids[idx] = tag.uid;
            this.mReadHistoryChars += tag.string.length() + 1;
        }
        return true;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryStringPoolSize() {
        return this.mReadHistoryStrings.length;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryStringPoolBytes() {
        return this.mReadHistoryStrings.length * 12 + this.mReadHistoryChars * 2;
    }

    private final String $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryTagPoolString(int index) {
        return this.mReadHistoryStrings[index];
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryTagPoolUid(int index) {
        return this.mReadHistoryUids[index];
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$getNextHistoryLocked(BatteryStats.HistoryItem out) {
        boolean end;
        int pos = this.mHistoryBuffer.dataPosition();
        if (pos == 0) {
            out.clear();
        }
        boolean bl = end = pos >= this.mHistoryBuffer.dataSize();
        if (end) {
            return false;
        }
        long lastRealtime = out.time;
        long lastWalltime = out.currentTime;
        this.readHistoryDelta(this.mHistoryBuffer, out);
        if (out.cmd != 5 && out.cmd != 7 && lastWalltime != 0L) {
            out.currentTime = lastWalltime + (out.time - lastRealtime);
        }
        return true;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$finishIteratingHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        this.mReadHistoryStrings = null;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryBaseTime() {
        return this.mHistoryBaseTime;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getStartCount() {
        return this.mStartCount;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$isOnBattery() {
        return this.mOnBattery;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$isCharging() {
        return this.mCharging;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$isScreenOn() {
        return this.mScreenState == 2;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$initTimes(long uptime, long realtime) {
        this.mStartClockTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mOnBatteryTimeBase.init(uptime, realtime);
        this.mOnBatteryScreenOffTimeBase.init(uptime, realtime);
        this.mRealtime = 0L;
        this.mUptime = 0L;
        this.mRealtimeStart = realtime;
        this.mUptimeStart = uptime;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$initDischarge() {
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
        this.mDischargeAmountScreenOn = 0;
        this.mDischargeAmountScreenOnSinceCharge = 0;
        this.mDischargeAmountScreenOff = 0;
        this.mDischargeAmountScreenOffSinceCharge = 0;
        this.mDischargeStepTracker.init();
        this.mChargeStepTracker.init();
        this.mDischargeScreenOffCounter.reset(false);
        this.mDischargeCounter.reset(false);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$resetAllStatsCmdLocked() {
        this.resetAllStatsLocked();
        long mSecUptime = this.mClocks.uptimeMillis();
        long uptime = mSecUptime * 1000L;
        long mSecRealtime = this.mClocks.elapsedRealtime();
        long realtime = mSecRealtime * 1000L;
        this.mDischargeStartLevel = this.mHistoryCur.batteryLevel;
        this.pullPendingStateUpdatesLocked();
        this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
        byte by = this.mHistoryCur.batteryLevel;
        this.mCurrentBatteryLevel = by;
        this.mDischargePlugLevel = by;
        this.mDischargeUnplugLevel = by;
        this.mDischargeCurrentLevel = by;
        this.mOnBatteryTimeBase.reset(uptime, realtime);
        this.mOnBatteryScreenOffTimeBase.reset(uptime, realtime);
        if ((this.mHistoryCur.states & 0x80000) == 0) {
            if (this.mScreenState == 2) {
                this.mDischargeScreenOnUnplugLevel = this.mHistoryCur.batteryLevel;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = this.mHistoryCur.batteryLevel;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenOff = 0;
        }
        this.initActiveHistoryEventsLocked(mSecRealtime, mSecUptime);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$resetAllStatsLocked() {
        int i;
        long uptimeMillis = this.mClocks.uptimeMillis();
        long elapsedRealtimeMillis = this.mClocks.elapsedRealtime();
        this.mStartCount = 0;
        this.initTimes(uptimeMillis * 1000L, elapsedRealtimeMillis * 1000L);
        this.mScreenOnTimer.reset(false);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].reset(false);
        }
        this.mEstimatedBatteryCapacity = this.mPowerProfile != null ? (int)this.mPowerProfile.getBatteryCapacity() : -1;
        this.mInteractiveTimer.reset(false);
        this.mPowerSaveModeEnabledTimer.reset(false);
        this.mLastIdleTimeStart = elapsedRealtimeMillis;
        this.mLongestLightIdleTime = 0L;
        this.mLongestFullIdleTime = 0L;
        this.mDeviceIdleModeLightTimer.reset(false);
        this.mDeviceIdleModeFullTimer.reset(false);
        this.mDeviceLightIdlingTimer.reset(false);
        this.mDeviceIdlingTimer.reset(false);
        this.mPhoneOnTimer.reset(false);
        this.mAudioOnTimer.reset(false);
        this.mVideoOnTimer.reset(false);
        this.mFlashlightOnTimer.reset(false);
        this.mCameraOnTimer.reset(false);
        this.mBluetoothScanTimer.reset(false);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].reset(false);
        }
        this.mPhoneSignalScanningTimer.reset(false);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].reset(false);
        }
        for (i = 0; i < 6; ++i) {
            this.mNetworkByteActivityCounters[i].reset(false);
            this.mNetworkPacketActivityCounters[i].reset(false);
        }
        this.mMobileRadioActiveTimer.reset(false);
        this.mMobileRadioActivePerAppTimer.reset(false);
        this.mMobileRadioActiveAdjustedTime.reset(false);
        this.mMobileRadioActiveUnknownTime.reset(false);
        this.mMobileRadioActiveUnknownCount.reset(false);
        this.mWifiOnTimer.reset(false);
        this.mGlobalWifiRunningTimer.reset(false);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].reset(false);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].reset(false);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].reset(false);
        }
        this.mWifiActivity.reset(false);
        this.mBluetoothActivity.reset(false);
        this.mModemActivity.reset(false);
        this.mUnpluggedNumConnectivityChange = 0;
        this.mLoadedNumConnectivityChange = 0;
        this.mNumConnectivityChange = 0;
        for (i = 0; i < this.mUidStats.size(); ++i) {
            if (!this.mUidStats.valueAt(i).reset()) continue;
            this.mUidStats.remove(this.mUidStats.keyAt(i));
            --i;
        }
        if (this.mKernelWakelockStats.size() > 0) {
            for (SamplingTimer timer : this.mKernelWakelockStats.values()) {
                this.mOnBatteryScreenOffTimeBase.remove(timer);
            }
            this.mKernelWakelockStats.clear();
        }
        if (this.mWakeupReasonStats.size() > 0) {
            for (SamplingTimer timer : this.mWakeupReasonStats.values()) {
                this.mOnBatteryTimeBase.remove(timer);
            }
            this.mWakeupReasonStats.clear();
        }
        this.mLastHistoryStepDetails = null;
        this.mLastStepCpuSystemTime = 0L;
        this.mLastStepCpuUserTime = 0L;
        this.mCurStepCpuSystemTime = 0L;
        this.mCurStepCpuUserTime = 0L;
        this.mCurStepCpuUserTime = 0L;
        this.mLastStepCpuUserTime = 0L;
        this.mCurStepCpuSystemTime = 0L;
        this.mLastStepCpuSystemTime = 0L;
        this.mCurStepStatUserTime = 0L;
        this.mLastStepStatUserTime = 0L;
        this.mCurStepStatSystemTime = 0L;
        this.mLastStepStatSystemTime = 0L;
        this.mCurStepStatIOWaitTime = 0L;
        this.mLastStepStatIOWaitTime = 0L;
        this.mCurStepStatIrqTime = 0L;
        this.mLastStepStatIrqTime = 0L;
        this.mCurStepStatSoftIrqTime = 0L;
        this.mLastStepStatSoftIrqTime = 0L;
        this.mCurStepStatIdleTime = 0L;
        this.mLastStepStatIdleTime = 0L;
        this.initDischarge();
        this.clearHistoryLocked();
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$initActiveHistoryEventsLocked(long elapsedRealtimeMs, long uptimeMs) {
        for (int i = 0; i < 19; ++i) {
            HashMap<String, SparseIntArray> active;
            if (!this.mRecordAllHistory && i == 1 || (active = this.mActiveEvents.getStateForEvent(i)) == null) continue;
            for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                SparseIntArray uids = ent.getValue();
                for (int j = 0; j < uids.size(); ++j) {
                    this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, i, ent.getKey(), uids.keyAt(j));
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateDischargeScreenLevelsLocked(boolean oldScreenOn, boolean newScreenOn) {
        if (oldScreenOn) {
            int diff = this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            if (diff > 0) {
                this.mDischargeAmountScreenOn += diff;
                this.mDischargeAmountScreenOnSinceCharge += diff;
            }
        } else {
            int diff = this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            if (diff > 0) {
                this.mDischargeAmountScreenOff += diff;
                this.mDischargeAmountScreenOffSinceCharge += diff;
            }
        }
        if (newScreenOn) {
            this.mDischargeScreenOnUnplugLevel = this.mDischargeCurrentLevel;
            this.mDischargeScreenOffUnplugLevel = 0;
        } else {
            this.mDischargeScreenOnUnplugLevel = 0;
            this.mDischargeScreenOffUnplugLevel = this.mDischargeCurrentLevel;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$pullPendingStateUpdatesLocked() {
        if (this.mOnBatteryInternal) {
            boolean screenOn = this.mScreenState == 2;
            this.updateDischargeScreenLevelsLocked(screenOn, screenOn);
        }
    }

    private final NetworkStats $$robo$$com_android_internal_os_BatteryStatsImpl$getNetworkStatsDeltaLocked(String[] ifaces, NetworkStats[] networkStatsBuffer) throws IOException {
        if (!SystemProperties.getBoolean("net.qtaguid_enabled", false)) {
            return null;
        }
        NetworkStats stats = this.mNetworkStatsFactory.readNetworkStatsDetail(-1, ifaces, 0, networkStatsBuffer[1]);
        networkStatsBuffer[2] = NetworkStats.subtract(stats, networkStatsBuffer[0], null, null, networkStatsBuffer[2]);
        networkStatsBuffer[1] = networkStatsBuffer[0];
        networkStatsBuffer[0] = stats;
        return networkStatsBuffer[2];
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateWifiStateLocked(WifiActivityEnergyInfo info) {
        long elapsedRealtimeMs = this.mClocks.elapsedRealtime();
        NetworkStats delta = null;
        try {
            if (!ArrayUtils.isEmpty(this.mWifiIfaces)) {
                delta = this.getNetworkStatsDeltaLocked(this.mWifiIfaces, this.mWifiNetworkStats);
            }
        }
        catch (IOException e) {
            Slog.wtf("BatteryStatsImpl", "Failed to get wifi network stats", e);
            return;
        }
        if (!this.mOnBatteryInternal) {
            return;
        }
        SparseLongArray rxPackets = new SparseLongArray();
        SparseLongArray txPackets = new SparseLongArray();
        long totalTxPackets = 0L;
        long totalRxPackets = 0L;
        if (delta != null) {
            int size = delta.size();
            for (int i = 0; i < size; ++i) {
                NetworkStats.Entry entry = delta.getValues(i, this.mTmpNetworkStatsEntry);
                if (entry.rxBytes == 0L && entry.txBytes == 0L) continue;
                Uid u = this.getUidStatsLocked(this.mapUid(entry.uid));
                if (entry.rxBytes != 0L) {
                    u.noteNetworkActivityLocked(2, entry.rxBytes, entry.rxPackets);
                    this.mNetworkByteActivityCounters[2].addCountLocked(entry.rxBytes);
                    this.mNetworkPacketActivityCounters[2].addCountLocked(entry.rxPackets);
                    rxPackets.put(u.getUid(), entry.rxPackets);
                    totalRxPackets += entry.rxPackets;
                }
                if (entry.txBytes == 0L) continue;
                u.noteNetworkActivityLocked(3, entry.txBytes, entry.txPackets);
                this.mNetworkByteActivityCounters[3].addCountLocked(entry.txBytes);
                this.mNetworkPacketActivityCounters[3].addCountLocked(entry.txPackets);
                txPackets.put(u.getUid(), entry.txPackets);
                totalTxPackets += entry.txPackets;
            }
        }
        if (info != null) {
            Uid uid;
            int i;
            this.mHasWifiReporting = true;
            long txTimeMs = info.getControllerTxTimeMillis();
            long rxTimeMs = info.getControllerRxTimeMillis();
            long idleTimeMs = info.getControllerIdleTimeMillis();
            long totalTimeMs = txTimeMs + rxTimeMs + idleTimeMs;
            long leftOverRxTimeMs = rxTimeMs;
            long leftOverTxTimeMs = txTimeMs;
            long totalWifiLockTimeMs = 0L;
            long totalScanTimeMs = 0L;
            int uidStatsSize = this.mUidStats.size();
            for (i = 0; i < uidStatsSize; ++i) {
                uid = this.mUidStats.valueAt(i);
                totalScanTimeMs += uid.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                totalWifiLockTimeMs += uid.mFullWifiLockTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
            }
            for (i = 0; i < uidStatsSize; ++i) {
                long wifiLockTimeSinceMarkMs;
                uid = this.mUidStats.valueAt(i);
                long scanTimeSinceMarkMs = uid.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                if (scanTimeSinceMarkMs > 0L) {
                    uid.mWifiScanTimer.setMark(elapsedRealtimeMs);
                    long scanRxTimeSinceMarkMs = scanTimeSinceMarkMs;
                    long scanTxTimeSinceMarkMs = scanTimeSinceMarkMs;
                    if (totalScanTimeMs > rxTimeMs) {
                        scanRxTimeSinceMarkMs = rxTimeMs * scanRxTimeSinceMarkMs / totalScanTimeMs;
                    }
                    if (totalScanTimeMs > txTimeMs) {
                        scanTxTimeSinceMarkMs = txTimeMs * scanTxTimeSinceMarkMs / totalScanTimeMs;
                    }
                    ControllerActivityCounterImpl activityCounter = uid.getOrCreateWifiControllerActivityLocked();
                    ((LongSamplingCounter)activityCounter.getRxTimeCounter()).addCountLocked(scanRxTimeSinceMarkMs);
                    activityCounter.getTxTimeCounters()[0].addCountLocked(scanTxTimeSinceMarkMs);
                    leftOverRxTimeMs -= scanRxTimeSinceMarkMs;
                    leftOverTxTimeMs -= scanTxTimeSinceMarkMs;
                }
                if ((wifiLockTimeSinceMarkMs = uid.mFullWifiLockTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L) <= 0L) continue;
                uid.mFullWifiLockTimer.setMark(elapsedRealtimeMs);
                long myIdleTimeMs = wifiLockTimeSinceMarkMs * idleTimeMs / totalWifiLockTimeMs;
                ((LongSamplingCounter)uid.getOrCreateWifiControllerActivityLocked().getIdleTimeCounter()).addCountLocked(myIdleTimeMs);
            }
            for (i = 0; i < txPackets.size(); ++i) {
                uid = this.getUidStatsLocked(txPackets.keyAt(i));
                long myTxTimeMs = txPackets.valueAt(i) * leftOverTxTimeMs / totalTxPackets;
                uid.getOrCreateWifiControllerActivityLocked().getTxTimeCounters()[0].addCountLocked(myTxTimeMs);
            }
            for (i = 0; i < rxPackets.size(); ++i) {
                uid = this.getUidStatsLocked(rxPackets.keyAt(i));
                long myRxTimeMs = rxPackets.valueAt(i) * leftOverRxTimeMs / totalRxPackets;
                ((LongSamplingCounter)uid.getOrCreateWifiControllerActivityLocked().getRxTimeCounter()).addCountLocked(myRxTimeMs);
            }
            ((LongSamplingCounter)this.mWifiActivity.getRxTimeCounter()).addCountLocked(info.getControllerRxTimeMillis());
            this.mWifiActivity.getTxTimeCounters()[0].addCountLocked(info.getControllerTxTimeMillis());
            ((LongSamplingCounter)this.mWifiActivity.getIdleTimeCounter()).addCountLocked(info.getControllerIdleTimeMillis());
            double opVolt = this.mPowerProfile.getAveragePower("wifi.controller.voltage") / 1000.0;
            if (opVolt != 0.0) {
                ((LongSamplingCounter)this.mWifiActivity.getPowerCounter()).addCountLocked((long)((double)info.getControllerEnergyUsed() / opVolt));
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateMobileRadioStateLocked(long elapsedRealtimeMs, ModemActivityInfo activityInfo) {
        NetworkStats delta = null;
        try {
            if (!ArrayUtils.isEmpty(this.mMobileIfaces)) {
                delta = this.getNetworkStatsDeltaLocked(this.mMobileIfaces, this.mMobileNetworkStats);
            }
        }
        catch (IOException e) {
            Slog.wtf("BatteryStatsImpl", "Failed to get mobile network stats", e);
            return;
        }
        if (!this.mOnBatteryInternal) {
            return;
        }
        long radioTime = this.mMobileRadioActivePerAppTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L);
        this.mMobileRadioActivePerAppTimer.setMark(elapsedRealtimeMs);
        long totalRxPackets = 0L;
        long totalTxPackets = 0L;
        if (delta != null) {
            int size = delta.size();
            for (int i = 0; i < size; ++i) {
                NetworkStats.Entry entry = delta.getValues(i, this.mTmpNetworkStatsEntry);
                if (entry.rxPackets == 0L && entry.txPackets == 0L) continue;
                totalRxPackets += entry.rxPackets;
                totalTxPackets += entry.txPackets;
                Uid u = this.getUidStatsLocked(this.mapUid(entry.uid));
                u.noteNetworkActivityLocked(0, entry.rxBytes, entry.rxPackets);
                u.noteNetworkActivityLocked(1, entry.txBytes, entry.txPackets);
                this.mNetworkByteActivityCounters[0].addCountLocked(entry.rxBytes);
                this.mNetworkByteActivityCounters[1].addCountLocked(entry.txBytes);
                this.mNetworkPacketActivityCounters[0].addCountLocked(entry.rxPackets);
                this.mNetworkPacketActivityCounters[1].addCountLocked(entry.txPackets);
            }
            long totalPackets = totalRxPackets + totalTxPackets;
            if (totalPackets > 0L) {
                for (int i = 0; i < size; ++i) {
                    NetworkStats.Entry entry = delta.getValues(i, this.mTmpNetworkStatsEntry);
                    if (entry.rxPackets == 0L && entry.txPackets == 0L) continue;
                    Uid u = this.getUidStatsLocked(this.mapUid(entry.uid));
                    long appPackets = entry.rxPackets + entry.txPackets;
                    long appRadioTime = radioTime * appPackets / totalPackets;
                    u.noteMobileRadioActiveTimeLocked(appRadioTime);
                    radioTime -= appRadioTime;
                    totalPackets -= appPackets;
                    if (activityInfo == null) continue;
                    ControllerActivityCounterImpl activityCounter = u.getOrCreateModemControllerActivityLocked();
                    if (totalRxPackets > 0L && entry.rxPackets > 0L) {
                        long rxMs = entry.rxPackets * (long)activityInfo.getRxTimeMillis() / totalRxPackets;
                        ((LongSamplingCounter)activityCounter.getRxTimeCounter()).addCountLocked(rxMs);
                    }
                    if (totalTxPackets <= 0L || entry.txPackets <= 0L) continue;
                    for (int lvl = 0; lvl < 5; ++lvl) {
                        long txMs = entry.txPackets * (long)activityInfo.getTxTimeMillis()[lvl];
                        activityCounter.getTxTimeCounters()[lvl].addCountLocked(txMs /= totalTxPackets);
                    }
                }
            }
            if (radioTime > 0L) {
                this.mMobileRadioActiveUnknownTime.addCountLocked(radioTime);
                this.mMobileRadioActiveUnknownCount.addCountLocked(1L);
            }
        }
        if (activityInfo != null) {
            this.mHasModemReporting = true;
            ((LongSamplingCounter)this.mModemActivity.getIdleTimeCounter()).addCountLocked(activityInfo.getIdleTimeMillis());
            ((LongSamplingCounter)this.mModemActivity.getRxTimeCounter()).addCountLocked(activityInfo.getRxTimeMillis());
            for (int lvl = 0; lvl < 5; ++lvl) {
                this.mModemActivity.getTxTimeCounters()[lvl].addCountLocked(activityInfo.getTxTimeMillis()[lvl]);
            }
            double opVolt = this.mPowerProfile.getAveragePower("modem.controller.voltage") / 1000.0;
            if (opVolt != 0.0) {
                ((LongSamplingCounter)this.mModemActivity.getPowerCounter()).addCountLocked((long)((double)activityInfo.getEnergyUsed() / opVolt));
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateBluetoothStateLocked(BluetoothActivityEnergyInfo info) {
        Uid u;
        UidTraffic traffic;
        int i;
        if (info == null || !this.mOnBatteryInternal) {
            return;
        }
        this.mHasBluetoothReporting = true;
        long elapsedRealtimeMs = SystemClock.elapsedRealtime();
        long rxTimeMs = info.getControllerRxTimeMillis();
        long txTimeMs = info.getControllerTxTimeMillis();
        long totalScanTimeMs = 0L;
        int uidCount = this.mUidStats.size();
        for (int i2 = 0; i2 < uidCount; ++i2) {
            Uid u2 = this.mUidStats.valueAt(i2);
            if (u2.mBluetoothScanTimer == null) continue;
            totalScanTimeMs += u2.mBluetoothScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
        }
        boolean normalizeScanRxTime = totalScanTimeMs > rxTimeMs;
        boolean normalizeScanTxTime = totalScanTimeMs > txTimeMs;
        long leftOverRxTimeMs = rxTimeMs;
        long leftOverTxTimeMs = txTimeMs;
        for (int i3 = 0; i3 < uidCount; ++i3) {
            long scanTimeSinceMarkMs;
            Uid u3 = this.mUidStats.valueAt(i3);
            if (u3.mBluetoothScanTimer == null || (scanTimeSinceMarkMs = u3.mBluetoothScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L) <= 0L) continue;
            u3.mBluetoothScanTimer.setMark(elapsedRealtimeMs);
            long scanTimeRxSinceMarkMs = scanTimeSinceMarkMs;
            long scanTimeTxSinceMarkMs = scanTimeSinceMarkMs;
            if (normalizeScanRxTime) {
                scanTimeRxSinceMarkMs = rxTimeMs * scanTimeRxSinceMarkMs / totalScanTimeMs;
            }
            if (normalizeScanTxTime) {
                scanTimeTxSinceMarkMs = txTimeMs * scanTimeTxSinceMarkMs / totalScanTimeMs;
            }
            ControllerActivityCounterImpl counter = u3.getOrCreateBluetoothControllerActivityLocked();
            ((LongSamplingCounter)counter.getRxTimeCounter()).addCountLocked(scanTimeRxSinceMarkMs);
            counter.getTxTimeCounters()[0].addCountLocked(scanTimeTxSinceMarkMs);
            leftOverRxTimeMs -= scanTimeRxSinceMarkMs;
            leftOverTxTimeMs -= scanTimeTxSinceMarkMs;
        }
        long totalTxBytes = 0L;
        long totalRxBytes = 0L;
        UidTraffic[] uidTraffic = info.getUidTraffic();
        int numUids = uidTraffic != null ? uidTraffic.length : 0;
        for (i = 0; i < numUids; ++i) {
            traffic = uidTraffic[i];
            this.mNetworkByteActivityCounters[4].addCountLocked(traffic.getRxBytes());
            this.mNetworkByteActivityCounters[5].addCountLocked(traffic.getTxBytes());
            u = this.getUidStatsLocked(this.mapUid(traffic.getUid()));
            u.noteNetworkActivityLocked(4, traffic.getRxBytes(), 0L);
            u.noteNetworkActivityLocked(5, traffic.getTxBytes(), 0L);
            totalTxBytes += traffic.getTxBytes();
            totalRxBytes += traffic.getRxBytes();
        }
        if (!(totalTxBytes == 0L && totalRxBytes == 0L || leftOverRxTimeMs == 0L && leftOverTxTimeMs == 0L)) {
            for (i = 0; i < numUids; ++i) {
                traffic = uidTraffic[i];
                u = this.getUidStatsLocked(this.mapUid(traffic.getUid()));
                ControllerActivityCounterImpl counter = u.getOrCreateBluetoothControllerActivityLocked();
                if (totalRxBytes > 0L && traffic.getRxBytes() > 0L) {
                    long timeRxMs = leftOverRxTimeMs * traffic.getRxBytes() / totalRxBytes;
                    ((LongSamplingCounter)counter.getRxTimeCounter()).addCountLocked(timeRxMs);
                    leftOverRxTimeMs -= timeRxMs;
                }
                if (totalTxBytes <= 0L || traffic.getTxBytes() <= 0L) continue;
                long timeTxMs = leftOverTxTimeMs * traffic.getTxBytes() / totalTxBytes;
                counter.getTxTimeCounters()[0].addCountLocked(timeTxMs);
                leftOverTxTimeMs -= timeTxMs;
            }
        }
        ((LongSamplingCounter)this.mBluetoothActivity.getRxTimeCounter()).addCountLocked(info.getControllerRxTimeMillis());
        this.mBluetoothActivity.getTxTimeCounters()[0].addCountLocked(info.getControllerTxTimeMillis());
        ((LongSamplingCounter)this.mBluetoothActivity.getIdleTimeCounter()).addCountLocked(info.getControllerIdleTimeMillis());
        double opVolt = this.mPowerProfile.getAveragePower("bluetooth.controller.voltage") / 1000.0;
        if (opVolt != 0.0) {
            ((LongSamplingCounter)this.mBluetoothActivity.getPowerCounter()).addCountLocked((long)((double)info.getControllerEnergyUsed() / opVolt));
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateKernelWakelocksLocked() {
        KernelWakelockStats wakelockStats = this.mKernelWakelockReader.readKernelWakelockStats(this.mTmpWakelockStats);
        if (wakelockStats == null) {
            Slog.w("BatteryStatsImpl", "Couldn't get kernel wake lock stats");
            return;
        }
        for (Map.Entry ent : wakelockStats.entrySet()) {
            String name = (String)ent.getKey();
            KernelWakelockStats.Entry kws = (KernelWakelockStats.Entry)ent.getValue();
            SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
            if (kwlt == null) {
                kwlt = new SamplingTimer(this.mClocks, this.mOnBatteryScreenOffTimeBase);
                this.mKernelWakelockStats.put(name, kwlt);
            }
            kwlt.update(kws.mTotalTime, kws.mCount);
            kwlt.setUpdateVersion(kws.mVersion);
        }
        int numWakelocksSetStale = 0;
        for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
            SamplingTimer st = ent.getValue();
            if (st.getUpdateVersion() == wakelockStats.kernelWakelockVersion) continue;
            st.endSample();
            ++numWakelocksSetStale;
        }
        if (wakelockStats.isEmpty()) {
            Slog.wtf("BatteryStatsImpl", "All kernel wakelocks had time of zero");
        }
        if (numWakelocksSetStale == this.mKernelWakelockStats.size()) {
            Slog.wtf("BatteryStatsImpl", "All kernel wakelocks were set stale. new version=" + wakelockStats.kernelWakelockVersion);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$updateCpuTimeLocked() {
        int i;
        if (this.mPowerProfile == null) {
            return;
        }
        int wakelockWeight = 50;
        long[][] clusterSpeeds = new long[this.mKernelCpuSpeedReaders.length][];
        for (int cluster = 0; cluster < this.mKernelCpuSpeedReaders.length; ++cluster) {
            clusterSpeeds[cluster] = this.mKernelCpuSpeedReaders[cluster].readDelta();
        }
        int numWakelocks = 0;
        int numPartialTimers = this.mPartialTimers.size();
        if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
            for (int i2 = 0; i2 < numPartialTimers; ++i2) {
                StopwatchTimer timer = this.mPartialTimers.get(i2);
                if (!timer.mInList || timer.mUid == null || timer.mUid.mUid == 1000) continue;
                ++numWakelocks;
            }
        }
        int numWakelocksF = numWakelocks;
        this.mTempTotalCpuUserTimeUs = 0L;
        this.mTempTotalCpuSystemTimeUs = 0L;
        long startTimeMs = this.mClocks.elapsedRealtime();
        this.mKernelUidCpuTimeReader.readDelta(!this.mOnBatteryInternal ? null : new KernelUidCpuTimeReader.Callback(this, numWakelocksF, clusterSpeeds){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$numWakelocksF;
            /* synthetic */ long[][] val$clusterSpeeds;
            /* synthetic */ BatteryStatsImpl this$0;

            private void $$robo$$com_android_internal_os_BatteryStatsImpl_2$__constructor__(BatteryStatsImpl this$0, int n, long[][] lArray) {
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_2$onUidCpuTime(int uid, long userTimeUs, long systemTimeUs, long powerMaUs) {
                Uid u = this.this$0.getUidStatsLocked(this.this$0.mapUid(uid));
                this.this$0.mTempTotalCpuUserTimeUs += userTimeUs;
                this.this$0.mTempTotalCpuSystemTimeUs += systemTimeUs;
                StringBuilder sb = null;
                if (this.val$numWakelocksF > 0) {
                    userTimeUs = userTimeUs * 50L / 100L;
                    systemTimeUs = systemTimeUs * 50L / 100L;
                }
                if (sb != null) {
                    sb.append("  adding to uid=").append(u.mUid).append(": u=");
                    TimeUtils.formatDuration(userTimeUs / 1000L, sb);
                    sb.append(" s=");
                    TimeUtils.formatDuration(systemTimeUs / 1000L, sb);
                    sb.append(" p=").append(powerMaUs / 1000L).append("mAms");
                    Slog.d("BatteryStatsImpl", sb.toString());
                }
                u.mUserCpuTime.addCountLocked(userTimeUs);
                u.mSystemCpuTime.addCountLocked(systemTimeUs);
                u.mCpuPower.addCountLocked(powerMaUs);
                int numClusters = this.this$0.mPowerProfile.getNumCpuClusters();
                if (u.mCpuClusterSpeed == null || u.mCpuClusterSpeed.length != numClusters) {
                    u.mCpuClusterSpeed = new LongSamplingCounter[numClusters][];
                }
                for (int cluster = 0; cluster < this.val$clusterSpeeds.length; ++cluster) {
                    int speedsInCluster = this.this$0.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster);
                    if (u.mCpuClusterSpeed[cluster] == null || speedsInCluster != u.mCpuClusterSpeed[cluster].length) {
                        u.mCpuClusterSpeed[cluster] = new LongSamplingCounter[speedsInCluster];
                    }
                    LongSamplingCounter[] cpuSpeeds = u.mCpuClusterSpeed[cluster];
                    for (int speed = 0; speed < this.val$clusterSpeeds[cluster].length; ++speed) {
                        if (cpuSpeeds[speed] == null) {
                            cpuSpeeds[speed] = new LongSamplingCounter(this.this$0.mOnBatteryTimeBase);
                        }
                        cpuSpeeds[speed].addCountLocked(this.val$clusterSpeeds[cluster][speed]);
                    }
                }
            }

            private void __constructor__(BatteryStatsImpl batteryStatsImpl, int n, long[][] lArray) {
                this.$$robo$$com_android_internal_os_BatteryStatsImpl_2$__constructor__(batteryStatsImpl, n, lArray);
            }
            {
                this.this$0 = batteryStatsImpl;
                this.val$numWakelocksF = n;
                this.val$clusterSpeeds = lArray;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_2$__constructor__(com.android.internal.os.BatteryStatsImpl int long[][] ), 0, this, batteryStatsImpl, n, lArray);
            }

            @Override
            public void onUidCpuTime(int n, long l, long l2, long l3) {
                InvokeDynamicSupport.bootstrap("onUidCpuTime", $$robo$$com_android_internal_os_BatteryStatsImpl_2$onUidCpuTime(int long long long ), 0, this, n, l, l2, l3);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        if (this.mOnBatteryInternal && numWakelocks > 0) {
            this.mTempTotalCpuUserTimeUs = this.mTempTotalCpuUserTimeUs * 50L / 100L;
            this.mTempTotalCpuSystemTimeUs = this.mTempTotalCpuSystemTimeUs * 50L / 100L;
            for (i = 0; i < numPartialTimers; ++i) {
                StopwatchTimer timer = this.mPartialTimers.get(i);
                if (!timer.mInList || timer.mUid == null || timer.mUid.mUid == 1000) continue;
                int userTimeUs = (int)(this.mTempTotalCpuUserTimeUs / (long)numWakelocks);
                int systemTimeUs = (int)(this.mTempTotalCpuSystemTimeUs / (long)numWakelocks);
                timer.mUid.mUserCpuTime.addCountLocked(userTimeUs);
                timer.mUid.mSystemCpuTime.addCountLocked(systemTimeUs);
                Uid.Proc proc = timer.mUid.getProcessStatsLocked("*wakelock*");
                proc.addCpuTimeLocked(userTimeUs / 1000, systemTimeUs / 1000);
                this.mTempTotalCpuUserTimeUs -= (long)userTimeUs;
                this.mTempTotalCpuSystemTimeUs -= (long)systemTimeUs;
                --numWakelocks;
            }
            if (this.mTempTotalCpuUserTimeUs > 0L || this.mTempTotalCpuSystemTimeUs > 0L) {
                Uid u = this.getUidStatsLocked(1000);
                u.mUserCpuTime.addCountLocked(this.mTempTotalCpuUserTimeUs);
                u.mSystemCpuTime.addCountLocked(this.mTempTotalCpuSystemTimeUs);
                Uid.Proc proc = u.getProcessStatsLocked("*lost*");
                proc.addCpuTimeLocked((int)this.mTempTotalCpuUserTimeUs / 1000, (int)this.mTempTotalCpuSystemTimeUs / 1000);
            }
        }
        if (ArrayUtils.referenceEquals(this.mPartialTimers, this.mLastPartialTimers)) {
            for (i = 0; i < numPartialTimers; ++i) {
                this.mPartialTimers.get((int)i).mInList = true;
            }
        } else {
            int i3;
            int numLastPartialTimers = this.mLastPartialTimers.size();
            for (i3 = 0; i3 < numLastPartialTimers; ++i3) {
                this.mLastPartialTimers.get((int)i3).mInList = false;
            }
            this.mLastPartialTimers.clear();
            for (i3 = 0; i3 < numPartialTimers; ++i3) {
                StopwatchTimer timer = this.mPartialTimers.get(i3);
                timer.mInList = true;
                this.mLastPartialTimers.add(timer);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl$setChargingLocked(boolean charging) {
        if (this.mCharging != charging) {
            this.mCharging = charging;
            this.mHistoryCur.states2 = charging ? (this.mHistoryCur.states2 |= 0x1000000) : (this.mHistoryCur.states2 &= 0xFEFFFFFF);
            this.mHandler.sendEmptyMessage(3);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$setOnBatteryLocked(long mSecRealtime, long mSecUptime, boolean onBattery, int oldStatus, int level, int chargeUAh) {
        boolean screenOn;
        boolean doWrite = false;
        Message m = this.mHandler.obtainMessage(2);
        m.arg1 = onBattery ? 1 : 0;
        this.mHandler.sendMessage(m);
        long uptime = mSecUptime * 1000L;
        long realtime = mSecRealtime * 1000L;
        boolean bl = screenOn = this.mScreenState == 2;
        if (onBattery) {
            boolean reset = false;
            if (!this.mNoAutoReset && (oldStatus == 5 || level >= 90 || this.mDischargeCurrentLevel < 20 && level >= 80 || this.getHighDischargeAmountSinceCharge() >= 200 && this.mHistoryBuffer.dataSize() >= 262144)) {
                Slog.i("BatteryStatsImpl", "Resetting battery stats: level=" + level + " status=" + oldStatus + " dischargeLevel=" + this.mDischargeCurrentLevel + " lowAmount=" + this.getLowDischargeAmountSinceCharge() + " highAmount=" + this.getHighDischargeAmountSinceCharge());
                if (this.getLowDischargeAmountSinceCharge() >= 20) {
                    Parcel parcel = Parcel.obtain();
                    this.writeSummaryToParcel(parcel, true);
                    BackgroundThread.getHandler().post(new Runnable(this, parcel){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ Parcel val$parcel;
                        /* synthetic */ BatteryStatsImpl this$0;

                        private void $$robo$$com_android_internal_os_BatteryStatsImpl_3$__constructor__(BatteryStatsImpl this$0, Parcel parcel) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_3$run() {
                            AtomicFile atomicFile = this.this$0.mCheckinFile;
                            synchronized (atomicFile) {
                                FileOutputStream stream = null;
                                try {
                                    stream = this.this$0.mCheckinFile.startWrite();
                                    stream.write(this.val$parcel.marshall());
                                    stream.flush();
                                    FileUtils.sync(stream);
                                    stream.close();
                                    this.this$0.mCheckinFile.finishWrite(stream);
                                }
                                catch (IOException e) {
                                    Slog.w("BatteryStats", "Error writing checkin battery statistics", e);
                                    this.this$0.mCheckinFile.failWrite(stream);
                                }
                                finally {
                                    this.val$parcel.recycle();
                                }
                            }
                        }

                        private void __constructor__(BatteryStatsImpl batteryStatsImpl, Parcel parcel) {
                            this.$$robo$$com_android_internal_os_BatteryStatsImpl_3$__constructor__(batteryStatsImpl, parcel);
                        }
                        {
                            this.this$0 = batteryStatsImpl;
                            this.val$parcel = parcel;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_3$__constructor__(com.android.internal.os.BatteryStatsImpl android.os.Parcel ), 0, this, batteryStatsImpl, parcel);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_BatteryStatsImpl_3$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
                doWrite = true;
                this.resetAllStatsLocked();
                if (chargeUAh > 0) {
                    this.mEstimatedBatteryCapacity = (int)((double)level / 100.0 * (double)(chargeUAh / 1000));
                }
                this.mDischargeStartLevel = level;
                reset = true;
                this.mDischargeStepTracker.init();
            }
            if (this.mCharging) {
                this.setChargingLocked(false);
            }
            this.mLastChargingStateLevel = level;
            this.mOnBatteryInternal = true;
            this.mOnBattery = true;
            this.mLastDischargeStepLevel = level;
            this.mMinDischargeStepLevel = level;
            this.mDischargeStepTracker.clearTime();
            this.mDailyDischargeStepTracker.clearTime();
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states &= 0xFFF7FFFF;
            if (reset) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(mSecRealtime, mSecUptime, reset);
            }
            this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
            this.mDischargeCurrentLevel = this.mDischargeUnplugLevel = level;
            if (screenOn) {
                this.mDischargeScreenOnUnplugLevel = level;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = level;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenOff = 0;
            this.updateTimeBasesLocked(true, !screenOn, uptime, realtime);
        } else {
            this.mLastChargingStateLevel = level;
            this.mOnBatteryInternal = false;
            this.mOnBattery = false;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states |= 0x80000;
            this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
            this.mDischargeCurrentLevel = this.mDischargePlugLevel = level;
            if (level < this.mDischargeUnplugLevel) {
                this.mLowDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level - 1;
                this.mHighDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level;
            }
            this.updateDischargeScreenLevelsLocked(screenOn, screenOn);
            this.updateTimeBasesLocked(false, !screenOn, uptime, realtime);
            this.mChargeStepTracker.init();
            this.mLastChargeStepLevel = level;
            this.mMaxChargeStepLevel = level;
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
        }
        if ((doWrite || this.mLastWriteTime + 60000L < mSecRealtime) && this.mFile != null) {
            this.writeAsyncLocked();
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$startRecordingHistory(long elapsedRealtimeMs, long uptimeMs, boolean reset) {
        this.mRecordingHistory = true;
        this.mHistoryCur.currentTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, reset ? (byte)7 : 5, this.mHistoryCur);
        this.mHistoryCur.currentTime = 0L;
        if (reset) {
            this.initActiveHistoryEventsLocked(elapsedRealtimeMs, uptimeMs);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$recordCurrentTimeChangeLocked(long currentTime, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = currentTime;
            this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)5, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$recordShutdownLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)8, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$scheduleSyncExternalStatsLocked(String reason, int updateFlags) {
        if (this.mExternalSync != null) {
            this.mExternalSync.scheduleSync(reason, updateFlags);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$setBatteryStateLocked(int status, int health, int plugType, int level, int temp, int volt, int chargeUAh) {
        boolean onBattery = plugType == 0;
        long uptime = this.mClocks.uptimeMillis();
        long elapsedRealtime = this.mClocks.elapsedRealtime();
        if (!this.mHaveBatteryLevel) {
            this.mHaveBatteryLevel = true;
            if (onBattery == this.mOnBattery) {
                this.mHistoryCur.states = onBattery ? (this.mHistoryCur.states &= 0xFFF7FFFF) : (this.mHistoryCur.states |= 0x80000);
            }
            this.mHistoryCur.states2 |= 0x1000000;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryChargeUAh = chargeUAh;
            this.mLastChargeStepLevel = this.mLastDischargeStepLevel = level;
            this.mMinDischargeStepLevel = this.mLastDischargeStepLevel;
            this.mMaxChargeStepLevel = this.mLastDischargeStepLevel;
            this.mLastChargingStateLevel = level;
        } else if (this.mCurrentBatteryLevel != level || this.mOnBattery != onBattery) {
            this.recordDailyStatsIfNeededLocked(level >= 100 && onBattery);
        }
        byte oldStatus = this.mHistoryCur.batteryStatus;
        if (onBattery) {
            this.mDischargeCurrentLevel = level;
            if (!this.mRecordingHistory) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(elapsedRealtime, uptime, true);
            }
        } else if (level < 96 && !this.mRecordingHistory) {
            this.mRecordingHistory = true;
            this.startRecordingHistory(elapsedRealtime, uptime, true);
        }
        this.mCurrentBatteryLevel = level;
        if (this.mDischargePlugLevel < 0) {
            this.mDischargePlugLevel = level;
        }
        if (onBattery != this.mOnBattery) {
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryHealth = (byte)health;
            this.mHistoryCur.batteryPlugType = (byte)plugType;
            this.mHistoryCur.batteryTemperature = (short)temp;
            this.mHistoryCur.batteryVoltage = (char)volt;
            if (chargeUAh < this.mHistoryCur.batteryChargeUAh) {
                long chargeDiff = this.mHistoryCur.batteryChargeUAh - chargeUAh;
                this.mDischargeCounter.addCountLocked(chargeDiff);
                this.mDischargeScreenOffCounter.addCountLocked(chargeDiff);
            }
            this.mHistoryCur.batteryChargeUAh = chargeUAh;
            this.setOnBatteryLocked(elapsedRealtime, uptime, onBattery, oldStatus, level, chargeUAh);
        } else {
            boolean changed = false;
            if (this.mHistoryCur.batteryLevel != level) {
                this.mHistoryCur.batteryLevel = (byte)level;
                changed = true;
                this.scheduleSyncExternalStatsLocked("battery-level", 15);
            }
            if (this.mHistoryCur.batteryStatus != status) {
                this.mHistoryCur.batteryStatus = (byte)status;
                changed = true;
            }
            if (this.mHistoryCur.batteryHealth != health) {
                this.mHistoryCur.batteryHealth = (byte)health;
                changed = true;
            }
            if (this.mHistoryCur.batteryPlugType != plugType) {
                this.mHistoryCur.batteryPlugType = (byte)plugType;
                changed = true;
            }
            if (temp >= this.mHistoryCur.batteryTemperature + 10 || temp <= this.mHistoryCur.batteryTemperature - 10) {
                this.mHistoryCur.batteryTemperature = (short)temp;
                changed = true;
            }
            if (volt > this.mHistoryCur.batteryVoltage + 20 || volt < this.mHistoryCur.batteryVoltage - 20) {
                this.mHistoryCur.batteryVoltage = (char)volt;
                changed = true;
            }
            if (chargeUAh >= this.mHistoryCur.batteryChargeUAh + 10 || chargeUAh <= this.mHistoryCur.batteryChargeUAh - 10) {
                if (chargeUAh < this.mHistoryCur.batteryChargeUAh) {
                    long chargeDiff = this.mHistoryCur.batteryChargeUAh - chargeUAh;
                    this.mDischargeCounter.addCountLocked(chargeDiff);
                    this.mDischargeScreenOffCounter.addCountLocked(chargeDiff);
                }
                this.mHistoryCur.batteryChargeUAh = chargeUAh;
                changed = true;
            }
            long modeBits = (long)this.mInitStepMode << 48 | (long)this.mModStepMode << 56 | (long)(level & 0xFF) << 40;
            if (onBattery) {
                changed |= this.setChargingLocked(false);
                if (this.mLastDischargeStepLevel != level && this.mMinDischargeStepLevel > level) {
                    this.mDischargeStepTracker.addLevelSteps(this.mLastDischargeStepLevel - level, modeBits, elapsedRealtime);
                    this.mDailyDischargeStepTracker.addLevelSteps(this.mLastDischargeStepLevel - level, modeBits, elapsedRealtime);
                    this.mLastDischargeStepLevel = level;
                    this.mMinDischargeStepLevel = level;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
            } else {
                if (level >= 90) {
                    changed |= this.setChargingLocked(true);
                    this.mLastChargeStepLevel = level;
                }
                if (!this.mCharging) {
                    if (this.mLastChargeStepLevel < level) {
                        changed |= this.setChargingLocked(true);
                        this.mLastChargeStepLevel = level;
                    }
                } else if (this.mLastChargeStepLevel > level) {
                    changed |= this.setChargingLocked(false);
                    this.mLastChargeStepLevel = level;
                }
                if (this.mLastChargeStepLevel != level && this.mMaxChargeStepLevel < level) {
                    this.mChargeStepTracker.addLevelSteps(level - this.mLastChargeStepLevel, modeBits, elapsedRealtime);
                    this.mDailyChargeStepTracker.addLevelSteps(level - this.mLastChargeStepLevel, modeBits, elapsedRealtime);
                    this.mLastChargeStepLevel = level;
                    this.mMaxChargeStepLevel = level;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
            }
            if (changed) {
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            }
        }
        if (!onBattery && status == 5) {
            this.mRecordingHistory = false;
        }
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getAwakeTimeBattery() {
        return this.computeBatteryUptime(this.getBatteryUptimeLocked(), 1);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getAwakeTimePlugged() {
        return this.mClocks.uptimeMillis() * 1000L - this.getAwakeTimeBattery();
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeUptime(long curTime, int which) {
        switch (which) {
            case 0: {
                return this.mUptime + (curTime - this.mUptimeStart);
            }
            case 1: {
                return curTime - this.mUptimeStart;
            }
            case 2: {
                return curTime - this.mOnBatteryTimeBase.getUptimeStart();
            }
        }
        return 0L;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeRealtime(long curTime, int which) {
        switch (which) {
            case 0: {
                return this.mRealtime + (curTime - this.mRealtimeStart);
            }
            case 1: {
                return curTime - this.mRealtimeStart;
            }
            case 2: {
                return curTime - this.mOnBatteryTimeBase.getRealtimeStart();
            }
        }
        return 0L;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryUptime(long curTime, int which) {
        return this.mOnBatteryTimeBase.computeUptime(curTime, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryRealtime(long curTime, int which) {
        return this.mOnBatteryTimeBase.computeRealtime(curTime, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryScreenOffUptime(long curTime, int which) {
        return this.mOnBatteryScreenOffTimeBase.computeUptime(curTime, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryScreenOffRealtime(long curTime, int which) {
        return this.mOnBatteryScreenOffTimeBase.computeRealtime(curTime, which);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeTimePerLevel(long[] steps, int numSteps) {
        if (numSteps <= 0) {
            return -1L;
        }
        long total = 0L;
        for (int i = 0; i < numSteps; ++i) {
            total += steps[i] & 0xFFFFFFFFFFL;
        }
        return total / (long)numSteps;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryTimeRemaining(long curTime) {
        if (!this.mOnBattery) {
            return -1L;
        }
        if (this.mDischargeStepTracker.mNumStepDurations < 1) {
            return -1L;
        }
        long msPerLevel = this.mDischargeStepTracker.computeTimePerLevel();
        if (msPerLevel <= 0L) {
            return -1L;
        }
        return msPerLevel * (long)this.mCurrentBatteryLevel * 1000L;
    }

    private final BatteryStats.LevelStepTracker $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeLevelStepTracker() {
        return this.mDischargeStepTracker;
    }

    private final BatteryStats.LevelStepTracker $$robo$$com_android_internal_os_BatteryStatsImpl$getDailyDischargeLevelStepTracker() {
        return this.mDailyDischargeStepTracker;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$computeChargeTimeRemaining(long curTime) {
        if (this.mOnBattery) {
            return -1L;
        }
        if (this.mChargeStepTracker.mNumStepDurations < 1) {
            return -1L;
        }
        long msPerLevel = this.mChargeStepTracker.computeTimePerLevel();
        if (msPerLevel <= 0L) {
            return -1L;
        }
        return msPerLevel * (long)(100 - this.mCurrentBatteryLevel) * 1000L;
    }

    private final BatteryStats.LevelStepTracker $$robo$$com_android_internal_os_BatteryStatsImpl$getChargeLevelStepTracker() {
        return this.mChargeStepTracker;
    }

    private final BatteryStats.LevelStepTracker $$robo$$com_android_internal_os_BatteryStatsImpl$getDailyChargeLevelStepTracker() {
        return this.mDailyChargeStepTracker;
    }

    private final ArrayList<BatteryStats.PackageChange> $$robo$$com_android_internal_os_BatteryStatsImpl$getDailyPackageChanges() {
        return this.mDailyPackageChanges;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getBatteryUptimeLocked() {
        return this.mOnBatteryTimeBase.getUptime(this.mClocks.uptimeMillis() * 1000L);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getBatteryUptime(long curTime) {
        return this.mOnBatteryTimeBase.getUptime(curTime);
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsImpl$getBatteryRealtime(long curTime) {
        return this.mOnBatteryTimeBase.getRealtime(curTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeStartLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeStartLevelLocked();
        }
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeStartLevelLocked() {
        return this.mDischargeUnplugLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeCurrentLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeCurrentLevelLocked();
        }
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeCurrentLevelLocked() {
        return this.mDischargeCurrentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getLowDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mLowDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel - 1;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getHighDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mHighDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmount(int which) {
        int dischargeAmount;
        int n = dischargeAmount = which == 0 ? this.getHighDischargeAmountSinceCharge() : this.getDischargeStartLevel() - this.getDischargeCurrentLevel();
        if (dischargeAmount < 0) {
            dischargeAmount = 0;
        }
        return dischargeAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmountScreenOn() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOn;
            if (this.mOnBattery && this.mScreenState == 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmountScreenOnSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOnSinceCharge;
            if (this.mOnBattery && this.mScreenState == 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmountScreenOff() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOff;
            if (this.mOnBattery && this.mScreenState != 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmountScreenOffSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOffSinceCharge;
            if (this.mOnBattery && this.mScreenState != 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    private final Uid $$robo$$com_android_internal_os_BatteryStatsImpl$getUidStatsLocked(int uid) {
        Uid u = this.mUidStats.get(uid);
        if (u == null) {
            u = new Uid(this, uid);
            this.mUidStats.put(uid, u);
        }
        return u;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$removeUidStatsLocked(int uid) {
        this.mKernelUidCpuTimeReader.removeUid(uid);
        this.mUidStats.remove(uid);
    }

    private final Uid.Proc $$robo$$com_android_internal_os_BatteryStatsImpl$getProcessStatsLocked(int uid, String name) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getProcessStatsLocked(name);
    }

    private final Uid.Pkg $$robo$$com_android_internal_os_BatteryStatsImpl$getPackageStatsLocked(int uid, String pkg) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getPackageStatsLocked(pkg);
    }

    private final Uid.Pkg.Serv $$robo$$com_android_internal_os_BatteryStatsImpl$getServiceStatsLocked(int uid, String pkg, String name) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getServiceStatsLocked(pkg, name);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$shutdownLocked() {
        this.recordShutdownLocked(this.mClocks.elapsedRealtime(), this.mClocks.uptimeMillis());
        this.writeSyncLocked();
        this.mShuttingDown = true;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeAsyncLocked() {
        this.writeLocked(false);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeSyncLocked() {
        this.writeLocked(true);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeLocked(boolean sync) {
        if (this.mFile == null) {
            Slog.w("BatteryStats", "writeLocked: no file associated with this instance");
            return;
        }
        if (this.mShuttingDown) {
            return;
        }
        Parcel out = Parcel.obtain();
        this.writeSummaryToParcel(out, true);
        this.mLastWriteTime = this.mClocks.elapsedRealtime();
        if (this.mPendingWrite != null) {
            this.mPendingWrite.recycle();
        }
        this.mPendingWrite = out;
        if (sync) {
            this.commitPendingDataToDisk();
        } else {
            BackgroundThread.getHandler().post(new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ BatteryStatsImpl this$0;

                private void $$robo$$com_android_internal_os_BatteryStatsImpl_4$__constructor__(BatteryStatsImpl this$0) {
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_4$run() {
                    this.this$0.commitPendingDataToDisk();
                }

                private void __constructor__(BatteryStatsImpl batteryStatsImpl) {
                    this.$$robo$$com_android_internal_os_BatteryStatsImpl_4$__constructor__(batteryStatsImpl);
                }
                {
                    this.this$0 = batteryStatsImpl;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_4$__constructor__(com.android.internal.os.BatteryStatsImpl ), 0, this, batteryStatsImpl);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_BatteryStatsImpl_4$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$commitPendingDataToDisk() {
        Parcel next;
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            next = this.mPendingWrite;
            this.mPendingWrite = null;
            if (next == null) {
                return;
            }
            this.mWriteLock.lock();
        }
        try {
            FileOutputStream stream = new FileOutputStream(this.mFile.chooseForWrite());
            stream.write(next.marshall());
            stream.flush();
            FileUtils.sync(stream);
            stream.close();
            this.mFile.commit();
        }
        catch (IOException e) {
            Slog.w("BatteryStats", "Error writing battery statistics", e);
            this.mFile.rollback();
        }
        finally {
            next.recycle();
            this.mWriteLock.unlock();
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readLocked() {
        if (this.mDailyFile != null) {
            this.readDailyStatsLocked();
        }
        if (this.mFile == null) {
            Slog.w("BatteryStats", "readLocked: no file associated with this instance");
            return;
        }
        this.mUidStats.clear();
        try {
            File file = this.mFile.chooseForRead();
            if (!file.exists()) {
                return;
            }
            FileInputStream stream = new FileInputStream(file);
            byte[] raw2 = BatteryStatsHelper.readFully(stream);
            Parcel in = Parcel.obtain();
            in.unmarshall(raw2, 0, raw2.length);
            in.setDataPosition(0);
            stream.close();
            this.readSummaryFromParcel(in);
        }
        catch (Exception e) {
            Slog.e("BatteryStats", "Error reading battery statistics", e);
            this.resetAllStatsLocked();
        }
        this.mEndPlatformVersion = Build.ID;
        if (this.mHistoryBuffer.dataPosition() > 0) {
            this.mRecordingHistory = true;
            long elapsedRealtime = this.mClocks.elapsedRealtime();
            long uptime = this.mClocks.uptimeMillis();
            this.addHistoryBufferLocked(elapsedRealtime, uptime, (byte)4, this.mHistoryCur);
            this.startRecordingHistory(elapsedRealtime, uptime, false);
        }
        this.recordDailyStatsIfNeededLocked(false);
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsImpl$describeContents() {
        return 0;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readHistory(Parcel in, boolean andOldHistory) throws ParcelFormatException {
        long historyBaseTime = in.readLong();
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        int numTags = in.readInt();
        for (int i = 0; i < numTags; ++i) {
            int idx = in.readInt();
            String str = in.readString();
            if (str == null) {
                throw new ParcelFormatException("null history tag string");
            }
            int uid = in.readInt();
            BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
            tag.string = str;
            tag.uid = uid;
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(tag, idx);
            if (idx >= this.mNextHistoryTagIdx) {
                this.mNextHistoryTagIdx = idx + 1;
            }
            this.mNumHistoryTagChars += tag.string.length() + 1;
        }
        int bufSize = in.readInt();
        int curPos = in.dataPosition();
        if (bufSize >= 983040) {
            throw new ParcelFormatException("File corrupt: history data buffer too large " + bufSize);
        }
        if ((bufSize & 0xFFFFFFFC) != bufSize) {
            throw new ParcelFormatException("File corrupt: history data buffer not aligned " + bufSize);
        }
        this.mHistoryBuffer.appendFrom(in, curPos, bufSize);
        in.setDataPosition(curPos + bufSize);
        if (andOldHistory) {
            this.readOldHistory(in);
        }
        this.mHistoryBaseTime = historyBaseTime;
        if (this.mHistoryBaseTime > 0L) {
            long oldnow = this.mClocks.elapsedRealtime();
            this.mHistoryBaseTime = this.mHistoryBaseTime - oldnow + 1L;
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readOldHistory(Parcel in) {
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeHistory(Parcel out, boolean inclData, boolean andOldHistory) {
        out.writeLong(this.mHistoryBaseTime + this.mLastHistoryElapsedRealtime);
        if (!inclData) {
            out.writeInt(0);
            out.writeInt(0);
            return;
        }
        out.writeInt(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            out.writeInt(ent.getValue());
            out.writeString(tag.string);
            out.writeInt(tag.uid);
        }
        out.writeInt(this.mHistoryBuffer.dataSize());
        out.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
        if (andOldHistory) {
            this.writeOldHistory(out);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeOldHistory(Parcel out) {
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readSummaryFromParcel(Parcel in) throws ParcelFormatException {
        int i;
        int NPKG;
        int version = in.readInt();
        if (version != 147) {
            Slog.w("BatteryStats", "readFromParcel: version got " + version + ", expected " + 147 + "; erasing old stats");
            return;
        }
        this.readHistory(in, true);
        this.mStartCount = in.readInt();
        this.mUptime = in.readLong();
        this.mRealtime = in.readLong();
        this.mStartClockTime = in.readLong();
        this.mStartPlatformVersion = in.readString();
        this.mEndPlatformVersion = in.readString();
        this.mOnBatteryTimeBase.readSummaryFromParcel(in);
        this.mOnBatteryScreenOffTimeBase.readSummaryFromParcel(in);
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargePlugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mCurrentBatteryLevel = in.readInt();
        this.mEstimatedBatteryCapacity = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mDischargeStepTracker.readFromParcel(in);
        this.mChargeStepTracker.readFromParcel(in);
        this.mDailyDischargeStepTracker.readFromParcel(in);
        this.mDailyChargeStepTracker.readFromParcel(in);
        this.mDischargeCounter.readSummaryFromParcelLocked(in);
        this.mDischargeScreenOffCounter.readSummaryFromParcelLocked(in);
        if (NPKG > 0) {
            this.mDailyPackageChanges = new ArrayList(NPKG);
            for (NPKG = in.readInt(); NPKG > 0; --NPKG) {
                BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
                pc.mPackageName = in.readString();
                pc.mUpdate = in.readInt() != 0;
                pc.mVersionCode = in.readInt();
                this.mDailyPackageChanges.add(pc);
            }
        } else {
            this.mDailyPackageChanges = null;
        }
        this.mDailyStartTime = in.readLong();
        this.mNextMinDailyDeadline = in.readLong();
        this.mNextMaxDailyDeadline = in.readLong();
        ++this.mStartCount;
        this.mScreenState = 0;
        this.mScreenOnTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mInteractive = false;
        this.mInteractiveTimer.readSummaryFromParcelLocked(in);
        this.mPhoneOn = false;
        this.mPowerSaveModeEnabledTimer.readSummaryFromParcelLocked(in);
        this.mLongestLightIdleTime = in.readLong();
        this.mLongestFullIdleTime = in.readLong();
        this.mDeviceIdleModeLightTimer.readSummaryFromParcelLocked(in);
        this.mDeviceIdleModeFullTimer.readSummaryFromParcelLocked(in);
        this.mDeviceLightIdlingTimer.readSummaryFromParcelLocked(in);
        this.mDeviceIdlingTimer.readSummaryFromParcelLocked(in);
        this.mPhoneOnTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mPhoneSignalScanningTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 6; ++i) {
            this.mNetworkByteActivityCounters[i].readSummaryFromParcelLocked(in);
            this.mNetworkPacketActivityCounters[i].readSummaryFromParcelLocked(in);
        }
        this.mMobileRadioPowerState = 1;
        this.mMobileRadioActiveTimer.readSummaryFromParcelLocked(in);
        this.mMobileRadioActivePerAppTimer.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveAdjustedTime.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveUnknownTime.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveUnknownCount.readSummaryFromParcelLocked(in);
        this.mWifiRadioPowerState = 1;
        this.mWifiOn = false;
        this.mWifiOnTimer.readSummaryFromParcelLocked(in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mWifiActivity.readSummaryFromParcel(in);
        this.mBluetoothActivity.readSummaryFromParcel(in);
        this.mModemActivity.readSummaryFromParcel(in);
        this.mHasWifiReporting = in.readInt() != 0;
        this.mHasBluetoothReporting = in.readInt() != 0;
        this.mHasModemReporting = in.readInt() != 0;
        this.mNumConnectivityChange = this.mLoadedNumConnectivityChange = in.readInt();
        this.mFlashlightOnNesting = 0;
        this.mFlashlightOnTimer.readSummaryFromParcelLocked(in);
        this.mCameraOnNesting = 0;
        this.mCameraOnTimer.readSummaryFromParcelLocked(in);
        this.mBluetoothScanNesting = 0;
        this.mBluetoothScanTimer.readSummaryFromParcelLocked(in);
        int NKW = in.readInt();
        if (NKW > 10000) {
            throw new ParcelFormatException("File corrupt: too many kernel wake locks " + NKW);
        }
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String kwltName = in.readString();
            this.getKernelWakelockTimerLocked(kwltName).readSummaryFromParcelLocked(in);
        }
        int NWR = in.readInt();
        if (NWR > 10000) {
            throw new ParcelFormatException("File corrupt: too many wakeup reasons " + NWR);
        }
        for (int iwr = 0; iwr < NWR; ++iwr) {
            if (in.readInt() == 0) continue;
            String reasonName = in.readString();
            this.getWakeupReasonTimerLocked(reasonName).readSummaryFromParcelLocked(in);
        }
        int NU = in.readInt();
        if (NU > 10000) {
            throw new ParcelFormatException("File corrupt: too many uids " + NU);
        }
        for (int iu = 0; iu < NU; ++iu) {
            ShadowedObject p;
            int ip;
            int NW;
            int i2;
            int uid = in.readInt();
            Uid u = new Uid(this, uid);
            this.mUidStats.put(uid, u);
            u.mWifiRunning = false;
            if (in.readInt() != 0) {
                u.mWifiRunningTimer.readSummaryFromParcelLocked(in);
            }
            u.mFullWifiLockOut = false;
            if (in.readInt() != 0) {
                u.mFullWifiLockTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiScanStarted = false;
            if (in.readInt() != 0) {
                u.mWifiScanTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiBatchedScanBinStarted = -1;
            for (i2 = 0; i2 < 5; ++i2) {
                if (in.readInt() == 0) continue;
                u.makeWifiBatchedScanBin(i2, null);
                u.mWifiBatchedScanTimer[i2].readSummaryFromParcelLocked(in);
            }
            u.mWifiMulticastEnabled = false;
            if (in.readInt() != 0) {
                u.mWifiMulticastTimer.readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createAudioTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVideoTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createFlashlightTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createCameraTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createForegroundActivityTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createBluetoothScanTimerLocked().readSummaryFromParcelLocked(in);
            }
            u.mProcessState = -1;
            for (i2 = 0; i2 < 6; ++i2) {
                if (in.readInt() == 0) continue;
                u.makeProcessState(i2, null);
                u.mProcessStateTimer[i2].readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVibratorOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                if (u.mUserActivityCounters == null) {
                    u.initUserActivityLocked();
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    u.mUserActivityCounters[i2].readSummaryFromParcelLocked(in);
                }
            }
            if (in.readInt() != 0) {
                if (u.mNetworkByteActivityCounters == null) {
                    u.initNetworkActivityLocked();
                }
                for (i2 = 0; i2 < 6; ++i2) {
                    u.mNetworkByteActivityCounters[i2].readSummaryFromParcelLocked(in);
                    u.mNetworkPacketActivityCounters[i2].readSummaryFromParcelLocked(in);
                }
                u.mMobileRadioActiveTime.readSummaryFromParcelLocked(in);
                u.mMobileRadioActiveCount.readSummaryFromParcelLocked(in);
            }
            u.mUserCpuTime.readSummaryFromParcelLocked(in);
            u.mSystemCpuTime.readSummaryFromParcelLocked(in);
            u.mCpuPower.readSummaryFromParcelLocked(in);
            if (in.readInt() != 0) {
                int numClusters = in.readInt();
                if (this.mPowerProfile != null && this.mPowerProfile.getNumCpuClusters() != numClusters) {
                    throw new ParcelFormatException("Incompatible cpu cluster arrangement");
                }
                u.mCpuClusterSpeed = new LongSamplingCounter[numClusters][];
                for (int cluster = 0; cluster < numClusters; ++cluster) {
                    if (in.readInt() != 0) {
                        int NSB = in.readInt();
                        if (this.mPowerProfile != null && this.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster) != NSB) {
                            throw new ParcelFormatException("File corrupt: too many speed bins " + NSB);
                        }
                        u.mCpuClusterSpeed[cluster] = new LongSamplingCounter[NSB];
                        for (int speed = 0; speed < NSB; ++speed) {
                            if (in.readInt() == 0) continue;
                            u.mCpuClusterSpeed[cluster][speed] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                            u.mCpuClusterSpeed[cluster][speed].readSummaryFromParcelLocked(in);
                        }
                        continue;
                    }
                    u.mCpuClusterSpeed[cluster] = null;
                }
            } else {
                u.mCpuClusterSpeed = null;
            }
            if ((NW = in.readInt()) > 100) {
                throw new ParcelFormatException("File corrupt: too many wake locks " + NW);
            }
            for (int iw = 0; iw < NW; ++iw) {
                String wlName = in.readString();
                u.readWakeSummaryFromParcelLocked(wlName, in);
            }
            int NS = in.readInt();
            if (NS > 100) {
                throw new ParcelFormatException("File corrupt: too many syncs " + NS);
            }
            for (int is = 0; is < NS; ++is) {
                String name = in.readString();
                u.readSyncSummaryFromParcelLocked(name, in);
            }
            int NJ = in.readInt();
            if (NJ > 100) {
                throw new ParcelFormatException("File corrupt: too many job timers " + NJ);
            }
            for (int ij = 0; ij < NJ; ++ij) {
                String name = in.readString();
                u.readJobSummaryFromParcelLocked(name, in);
            }
            int NP = in.readInt();
            if (NP > 1000) {
                throw new ParcelFormatException("File corrupt: too many sensors " + NP);
            }
            for (int is = 0; is < NP; ++is) {
                int seNumber = in.readInt();
                if (in.readInt() == 0) continue;
                u.getSensorTimerLocked(seNumber, true).readSummaryFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 1000) {
                throw new ParcelFormatException("File corrupt: too many processes " + NP);
            }
            for (ip = 0; ip < NP; ++ip) {
                String procName = in.readString();
                p = u.getProcessStatsLocked(procName);
                p.mUserTime = p.mLoadedUserTime = in.readLong();
                p.mSystemTime = p.mLoadedSystemTime = in.readLong();
                p.mForegroundTime = p.mLoadedForegroundTime = in.readLong();
                p.mStarts = p.mLoadedStarts = in.readInt();
                p.mNumCrashes = p.mLoadedNumCrashes = in.readInt();
                p.mNumAnrs = p.mLoadedNumAnrs = in.readInt();
                p.readExcessivePowerFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 10000) {
                throw new ParcelFormatException("File corrupt: too many packages " + NP);
            }
            for (ip = 0; ip < NP; ++ip) {
                String pkgName = in.readString();
                p = u.getPackageStatsLocked(pkgName);
                int NWA = in.readInt();
                if (NWA > 1000) {
                    throw new ParcelFormatException("File corrupt: too many wakeup alarms " + NWA);
                }
                p.mWakeupAlarms.clear();
                for (int iwa = 0; iwa < NWA; ++iwa) {
                    String tag = in.readString();
                    Counter c = new Counter(this.mOnBatteryTimeBase);
                    c.readSummaryFromParcelLocked(in);
                    p.mWakeupAlarms.put(tag, c);
                }
                NS = in.readInt();
                if (NS > 1000) {
                    throw new ParcelFormatException("File corrupt: too many services " + NS);
                }
                for (int is = 0; is < NS; ++is) {
                    String servName = in.readString();
                    Uid.Pkg.Serv s = u.getServiceStatsLocked(pkgName, servName);
                    s.mStartTime = s.mLoadedStartTime = in.readLong();
                    s.mStarts = s.mLoadedStarts = in.readInt();
                    s.mLaunches = s.mLoadedLaunches = in.readInt();
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeSummaryToParcel(Parcel out, boolean inclHistory) {
        int i;
        this.pullPendingStateUpdatesLocked();
        long startClockTime = this.getStartClockTime();
        long NOW_SYS = this.mClocks.uptimeMillis() * 1000L;
        long NOWREAL_SYS = this.mClocks.elapsedRealtime() * 1000L;
        out.writeInt(147);
        this.writeHistory(out, inclHistory, true);
        out.writeInt(this.mStartCount);
        out.writeLong(this.computeUptime(NOW_SYS, 0));
        out.writeLong(this.computeRealtime(NOWREAL_SYS, 0));
        out.writeLong(startClockTime);
        out.writeString(this.mStartPlatformVersion);
        out.writeString(this.mEndPlatformVersion);
        this.mOnBatteryTimeBase.writeSummaryToParcel(out, NOW_SYS, NOWREAL_SYS);
        this.mOnBatteryScreenOffTimeBase.writeSummaryToParcel(out, NOW_SYS, NOWREAL_SYS);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargePlugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mCurrentBatteryLevel);
        out.writeInt(this.mEstimatedBatteryCapacity);
        out.writeInt(this.getLowDischargeAmountSinceCharge());
        out.writeInt(this.getHighDischargeAmountSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOnSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOffSinceCharge());
        this.mDischargeStepTracker.writeToParcel(out);
        this.mChargeStepTracker.writeToParcel(out);
        this.mDailyDischargeStepTracker.writeToParcel(out);
        this.mDailyChargeStepTracker.writeToParcel(out);
        this.mDischargeCounter.writeSummaryFromParcelLocked(out);
        this.mDischargeScreenOffCounter.writeSummaryFromParcelLocked(out);
        if (this.mDailyPackageChanges != null) {
            int NPKG = this.mDailyPackageChanges.size();
            out.writeInt(NPKG);
            for (int i2 = 0; i2 < NPKG; ++i2) {
                BatteryStats.PackageChange pc = this.mDailyPackageChanges.get(i2);
                out.writeString(pc.mPackageName);
                out.writeInt(pc.mUpdate ? 1 : 0);
                out.writeInt(pc.mVersionCode);
            }
        } else {
            out.writeInt(0);
        }
        out.writeLong(this.mDailyStartTime);
        out.writeLong(this.mNextMinDailyDeadline);
        out.writeLong(this.mNextMaxDailyDeadline);
        this.mScreenOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mInteractiveTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mPowerSaveModeEnabledTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        out.writeLong(this.mLongestLightIdleTime);
        out.writeLong(this.mLongestFullIdleTime);
        this.mDeviceIdleModeLightTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mDeviceIdleModeFullTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mDeviceLightIdlingTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mDeviceIdlingTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mPhoneOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mPhoneSignalScanningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 6; ++i) {
            this.mNetworkByteActivityCounters[i].writeSummaryFromParcelLocked(out);
            this.mNetworkPacketActivityCounters[i].writeSummaryFromParcelLocked(out);
        }
        this.mMobileRadioActiveTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mMobileRadioActivePerAppTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mMobileRadioActiveAdjustedTime.writeSummaryFromParcelLocked(out);
        this.mMobileRadioActiveUnknownTime.writeSummaryFromParcelLocked(out);
        this.mMobileRadioActiveUnknownCount.writeSummaryFromParcelLocked(out);
        this.mWifiOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mGlobalWifiRunningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mWifiActivity.writeSummaryToParcel(out);
        this.mBluetoothActivity.writeSummaryToParcel(out);
        this.mModemActivity.writeSummaryToParcel(out);
        out.writeInt(this.mHasWifiReporting ? 1 : 0);
        out.writeInt(this.mHasBluetoothReporting ? 1 : 0);
        out.writeInt(this.mHasModemReporting ? 1 : 0);
        out.writeInt(this.mNumConnectivityChange);
        this.mFlashlightOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mCameraOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mBluetoothScanTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        out.writeInt(this.mKernelWakelockStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
            Timer kwlt = ent.getValue();
            if (kwlt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                kwlt.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mWakeupReasonStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mWakeupReasonStats.entrySet()) {
            SamplingTimer timer = ent.getValue();
            if (timer != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                timer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        int NU = this.mUidStats.size();
        out.writeInt(NU);
        for (int iu = 0; iu < NU; ++iu) {
            int i3;
            out.writeInt(this.mUidStats.keyAt(iu));
            Uid u = this.mUidStats.valueAt(iu);
            if (u.mWifiRunningTimer != null) {
                out.writeInt(1);
                u.mWifiRunningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mFullWifiLockTimer != null) {
                out.writeInt(1);
                u.mFullWifiLockTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mWifiScanTimer != null) {
                out.writeInt(1);
                u.mWifiScanTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            for (i3 = 0; i3 < 5; ++i3) {
                if (u.mWifiBatchedScanTimer[i3] != null) {
                    out.writeInt(1);
                    u.mWifiBatchedScanTimer[i3].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mWifiMulticastTimer != null) {
                out.writeInt(1);
                u.mWifiMulticastTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                u.mAudioTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                u.mVideoTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mFlashlightTurnedOnTimer != null) {
                out.writeInt(1);
                u.mFlashlightTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mCameraTurnedOnTimer != null) {
                out.writeInt(1);
                u.mCameraTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mForegroundActivityTimer != null) {
                out.writeInt(1);
                u.mForegroundActivityTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mBluetoothScanTimer != null) {
                out.writeInt(1);
                u.mBluetoothScanTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            for (i3 = 0; i3 < 6; ++i3) {
                if (u.mProcessStateTimer[i3] != null) {
                    out.writeInt(1);
                    u.mProcessStateTimer[i3].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mVibratorOnTimer != null) {
                out.writeInt(1);
                u.mVibratorOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mUserActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i3 = 0; i3 < 4; ++i3) {
                    u.mUserActivityCounters[i3].writeSummaryFromParcelLocked(out);
                }
            }
            if (u.mNetworkByteActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i3 = 0; i3 < 6; ++i3) {
                    u.mNetworkByteActivityCounters[i3].writeSummaryFromParcelLocked(out);
                    u.mNetworkPacketActivityCounters[i3].writeSummaryFromParcelLocked(out);
                }
                u.mMobileRadioActiveTime.writeSummaryFromParcelLocked(out);
                u.mMobileRadioActiveCount.writeSummaryFromParcelLocked(out);
            }
            u.mUserCpuTime.writeSummaryFromParcelLocked(out);
            u.mSystemCpuTime.writeSummaryFromParcelLocked(out);
            u.mCpuPower.writeSummaryFromParcelLocked(out);
            if (u.mCpuClusterSpeed != null) {
                out.writeInt(1);
                out.writeInt(u.mCpuClusterSpeed.length);
                for (LongSamplingCounter[] cpuSpeeds : u.mCpuClusterSpeed) {
                    if (cpuSpeeds != null) {
                        out.writeInt(1);
                        out.writeInt(cpuSpeeds.length);
                        for (LongSamplingCounter c : cpuSpeeds) {
                            if (c != null) {
                                out.writeInt(1);
                                c.writeSummaryFromParcelLocked(out);
                                continue;
                            }
                            out.writeInt(0);
                        }
                        continue;
                    }
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
            }
            ArrayMap<String, Uid.Wakelock> wakeStats = u.mWakelockStats.getMap();
            int NW = wakeStats.size();
            out.writeInt(NW);
            for (int iw = 0; iw < NW; ++iw) {
                out.writeString(wakeStats.keyAt(iw));
                Uid.Wakelock wl = wakeStats.valueAt(iw);
                if (wl.mTimerFull != null) {
                    out.writeInt(1);
                    wl.mTimerFull.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerPartial != null) {
                    out.writeInt(1);
                    wl.mTimerPartial.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerWindow != null) {
                    out.writeInt(1);
                    wl.mTimerWindow.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerDraw != null) {
                    out.writeInt(1);
                    wl.mTimerDraw.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            ArrayMap<String, StopwatchTimer> syncStats = u.mSyncStats.getMap();
            int NS = syncStats.size();
            out.writeInt(NS);
            for (int is = 0; is < NS; ++is) {
                out.writeString(syncStats.keyAt(is));
                syncStats.valueAt(is).writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            }
            ArrayMap<String, StopwatchTimer> jobStats = u.mJobStats.getMap();
            int NJ = jobStats.size();
            out.writeInt(NJ);
            for (int ij = 0; ij < NJ; ++ij) {
                out.writeString(jobStats.keyAt(ij));
                jobStats.valueAt(ij).writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            }
            int NSE = u.mSensorStats.size();
            out.writeInt(NSE);
            for (int ise = 0; ise < NSE; ++ise) {
                out.writeInt(u.mSensorStats.keyAt(ise));
                Uid.Sensor se = u.mSensorStats.valueAt(ise);
                if (se.mTimer != null) {
                    out.writeInt(1);
                    se.mTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            int NP = u.mProcessStats.size();
            out.writeInt(NP);
            for (int ip = 0; ip < NP; ++ip) {
                out.writeString(u.mProcessStats.keyAt(ip));
                Uid.Proc ps = u.mProcessStats.valueAt(ip);
                out.writeLong(ps.mUserTime);
                out.writeLong(ps.mSystemTime);
                out.writeLong(ps.mForegroundTime);
                out.writeInt(ps.mStarts);
                out.writeInt(ps.mNumCrashes);
                out.writeInt(ps.mNumAnrs);
                ps.writeExcessivePowerToParcelLocked(out);
            }
            NP = u.mPackageStats.size();
            out.writeInt(NP);
            if (NP <= 0) continue;
            for (Map.Entry<String, Uid.Pkg> ent : u.mPackageStats.entrySet()) {
                out.writeString(ent.getKey());
                Uid.Pkg ps = ent.getValue();
                int NWA = ps.mWakeupAlarms.size();
                out.writeInt(NWA);
                for (int iwa = 0; iwa < NWA; ++iwa) {
                    out.writeString(ps.mWakeupAlarms.keyAt(iwa));
                    ps.mWakeupAlarms.valueAt(iwa).writeSummaryFromParcelLocked(out);
                }
                NS = ps.mServiceStats.size();
                out.writeInt(NS);
                for (int is = 0; is < NS; ++is) {
                    out.writeString(ps.mServiceStats.keyAt(is));
                    Uid.Pkg.Serv ss = ps.mServiceStats.valueAt(is);
                    long time = ss.getStartTimeToNowLocked(this.mOnBatteryTimeBase.getUptime(NOW_SYS));
                    out.writeLong(time);
                    out.writeInt(ss.mStarts);
                    out.writeInt(ss.mLaunches);
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readFromParcel(Parcel in) {
        this.readFromParcelLocked(in);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$readFromParcelLocked(Parcel in) {
        int i;
        int magic = in.readInt();
        if (magic != -1166707595) {
            throw new ParcelFormatException("Bad magic number: #" + Integer.toHexString(magic));
        }
        this.readHistory(in, false);
        this.mStartCount = in.readInt();
        this.mStartClockTime = in.readLong();
        this.mStartPlatformVersion = in.readString();
        this.mEndPlatformVersion = in.readString();
        this.mUptime = in.readLong();
        this.mUptimeStart = in.readLong();
        this.mRealtime = in.readLong();
        this.mRealtimeStart = in.readLong();
        this.mOnBattery = in.readInt() != 0;
        this.mEstimatedBatteryCapacity = in.readInt();
        this.mOnBatteryInternal = false;
        this.mOnBatteryTimeBase.readFromParcel(in);
        this.mOnBatteryScreenOffTimeBase.readFromParcel(in);
        this.mScreenState = 0;
        this.mScreenOnTimer = new StopwatchTimer(this.mClocks, null, -1, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(this.mClocks, null, -100 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mInteractive = false;
        this.mInteractiveTimer = new StopwatchTimer(this.mClocks, null, -10, null, this.mOnBatteryTimeBase, in);
        this.mPhoneOn = false;
        this.mPowerSaveModeEnabledTimer = new StopwatchTimer(this.mClocks, null, -2, null, this.mOnBatteryTimeBase, in);
        this.mLongestLightIdleTime = in.readLong();
        this.mLongestFullIdleTime = in.readLong();
        this.mDeviceIdleModeLightTimer = new StopwatchTimer(this.mClocks, null, -14, null, this.mOnBatteryTimeBase, in);
        this.mDeviceIdleModeFullTimer = new StopwatchTimer(this.mClocks, null, -11, null, this.mOnBatteryTimeBase, in);
        this.mDeviceLightIdlingTimer = new StopwatchTimer(this.mClocks, null, -15, null, this.mOnBatteryTimeBase, in);
        this.mDeviceIdlingTimer = new StopwatchTimer(this.mClocks, null, -12, null, this.mOnBatteryTimeBase, in);
        this.mPhoneOnTimer = new StopwatchTimer(this.mClocks, null, -3, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(this.mClocks, null, -200 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(this.mClocks, null, -199, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(this.mClocks, null, -300 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 6; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        }
        this.mMobileRadioPowerState = 1;
        this.mMobileRadioActiveTimer = new StopwatchTimer(this.mClocks, null, -400, null, this.mOnBatteryTimeBase, in);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(this.mClocks, null, -401, null, this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mWifiRadioPowerState = 1;
        this.mWifiOn = false;
        this.mWifiOnTimer = new StopwatchTimer(this.mClocks, null, -4, null, this.mOnBatteryTimeBase, in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer = new StopwatchTimer(this.mClocks, null, -5, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(this.mClocks, null, -600 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(this.mClocks, null, -700 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(this.mClocks, null, -800 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mWifiActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 1, in);
        this.mBluetoothActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 1, in);
        this.mModemActivity = new ControllerActivityCounterImpl(this.mOnBatteryTimeBase, 5, in);
        this.mHasWifiReporting = in.readInt() != 0;
        this.mHasBluetoothReporting = in.readInt() != 0;
        this.mHasModemReporting = in.readInt() != 0;
        this.mNumConnectivityChange = in.readInt();
        this.mLoadedNumConnectivityChange = in.readInt();
        this.mUnpluggedNumConnectivityChange = in.readInt();
        this.mAudioOnNesting = 0;
        this.mAudioOnTimer = new StopwatchTimer(this.mClocks, null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnNesting = 0;
        this.mVideoOnTimer = new StopwatchTimer(this.mClocks, null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOnNesting = 0;
        this.mFlashlightOnTimer = new StopwatchTimer(this.mClocks, null, -9, null, this.mOnBatteryTimeBase, in);
        this.mCameraOnNesting = 0;
        this.mCameraOnTimer = new StopwatchTimer(this.mClocks, null, -13, null, this.mOnBatteryTimeBase, in);
        this.mBluetoothScanNesting = 0;
        this.mBluetoothScanTimer = new StopwatchTimer(this.mClocks, null, -14, null, this.mOnBatteryTimeBase, in);
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargePlugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mCurrentBatteryLevel = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOn = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOff = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mDischargeStepTracker.readFromParcel(in);
        this.mChargeStepTracker.readFromParcel(in);
        this.mDischargeCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mDischargeScreenOffCounter = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mLastWriteTime = in.readLong();
        this.mKernelWakelockStats.clear();
        int NKW = in.readInt();
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String wakelockName = in.readString();
            SamplingTimer kwlt = new SamplingTimer(this.mClocks, this.mOnBatteryScreenOffTimeBase, in);
            this.mKernelWakelockStats.put(wakelockName, kwlt);
        }
        this.mWakeupReasonStats.clear();
        int NWR = in.readInt();
        for (int iwr = 0; iwr < NWR; ++iwr) {
            if (in.readInt() == 0) continue;
            String reasonName = in.readString();
            SamplingTimer timer = new SamplingTimer(this.mClocks, this.mOnBatteryTimeBase, in);
            this.mWakeupReasonStats.put(reasonName, timer);
        }
        this.mPartialTimers.clear();
        this.mFullTimers.clear();
        this.mWindowTimers.clear();
        this.mWifiRunningTimers.clear();
        this.mFullWifiLockTimers.clear();
        this.mWifiScanTimers.clear();
        this.mWifiBatchedScanTimers.clear();
        this.mWifiMulticastTimers.clear();
        this.mAudioTurnedOnTimers.clear();
        this.mVideoTurnedOnTimers.clear();
        this.mFlashlightTurnedOnTimers.clear();
        this.mCameraTurnedOnTimers.clear();
        int numUids = in.readInt();
        this.mUidStats.clear();
        for (int i2 = 0; i2 < numUids; ++i2) {
            int uid = in.readInt();
            Uid u = new Uid(this, uid);
            u.readFromParcelLocked(this.mOnBatteryTimeBase, this.mOnBatteryScreenOffTimeBase, in);
            this.mUidStats.append(uid, u);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeToParcel(Parcel out, int flags) {
        this.writeToParcelLocked(out, true, flags);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeToParcelWithoutUids(Parcel out, int flags) {
        this.writeToParcelLocked(out, false, flags);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$writeToParcelLocked(Parcel out, boolean inclUids, int flags) {
        int i;
        this.pullPendingStateUpdatesLocked();
        long startClockTime = this.getStartClockTime();
        long uSecUptime = this.mClocks.uptimeMillis() * 1000L;
        long uSecRealtime = this.mClocks.elapsedRealtime() * 1000L;
        long batteryRealtime = this.mOnBatteryTimeBase.getRealtime(uSecRealtime);
        long batteryScreenOffRealtime = this.mOnBatteryScreenOffTimeBase.getRealtime(uSecRealtime);
        out.writeInt(-1166707595);
        this.writeHistory(out, true, false);
        out.writeInt(this.mStartCount);
        out.writeLong(startClockTime);
        out.writeString(this.mStartPlatformVersion);
        out.writeString(this.mEndPlatformVersion);
        out.writeLong(this.mUptime);
        out.writeLong(this.mUptimeStart);
        out.writeLong(this.mRealtime);
        out.writeLong(this.mRealtimeStart);
        out.writeInt(this.mOnBattery ? 1 : 0);
        out.writeInt(this.mEstimatedBatteryCapacity);
        this.mOnBatteryTimeBase.writeToParcel(out, uSecUptime, uSecRealtime);
        this.mOnBatteryScreenOffTimeBase.writeToParcel(out, uSecUptime, uSecRealtime);
        this.mScreenOnTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mInteractiveTimer.writeToParcel(out, uSecRealtime);
        this.mPowerSaveModeEnabledTimer.writeToParcel(out, uSecRealtime);
        out.writeLong(this.mLongestLightIdleTime);
        out.writeLong(this.mLongestFullIdleTime);
        this.mDeviceIdleModeLightTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceIdleModeFullTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceLightIdlingTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceIdlingTimer.writeToParcel(out, uSecRealtime);
        this.mPhoneOnTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mPhoneSignalScanningTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 6; ++i) {
            this.mNetworkByteActivityCounters[i].writeToParcel(out);
            this.mNetworkPacketActivityCounters[i].writeToParcel(out);
        }
        this.mMobileRadioActiveTimer.writeToParcel(out, uSecRealtime);
        this.mMobileRadioActivePerAppTimer.writeToParcel(out, uSecRealtime);
        this.mMobileRadioActiveAdjustedTime.writeToParcel(out);
        this.mMobileRadioActiveUnknownTime.writeToParcel(out);
        this.mMobileRadioActiveUnknownCount.writeToParcel(out);
        this.mWifiOnTimer.writeToParcel(out, uSecRealtime);
        this.mGlobalWifiRunningTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mWifiActivity.writeToParcel(out, 0);
        this.mBluetoothActivity.writeToParcel(out, 0);
        this.mModemActivity.writeToParcel(out, 0);
        out.writeInt(this.mHasWifiReporting ? 1 : 0);
        out.writeInt(this.mHasBluetoothReporting ? 1 : 0);
        out.writeInt(this.mHasModemReporting ? 1 : 0);
        out.writeInt(this.mNumConnectivityChange);
        out.writeInt(this.mLoadedNumConnectivityChange);
        out.writeInt(this.mUnpluggedNumConnectivityChange);
        this.mFlashlightOnTimer.writeToParcel(out, uSecRealtime);
        this.mCameraOnTimer.writeToParcel(out, uSecRealtime);
        this.mBluetoothScanTimer.writeToParcel(out, uSecRealtime);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargePlugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mCurrentBatteryLevel);
        out.writeInt(this.mLowDischargeAmountSinceCharge);
        out.writeInt(this.mHighDischargeAmountSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOn);
        out.writeInt(this.mDischargeAmountScreenOnSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOff);
        out.writeInt(this.mDischargeAmountScreenOffSinceCharge);
        this.mDischargeStepTracker.writeToParcel(out);
        this.mChargeStepTracker.writeToParcel(out);
        this.mDischargeCounter.writeToParcel(out);
        this.mDischargeScreenOffCounter.writeToParcel(out);
        out.writeLong(this.mLastWriteTime);
        if (inclUids) {
            out.writeInt(this.mKernelWakelockStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer kwlt = ent.getValue();
                if (kwlt != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    kwlt.writeToParcel(out, uSecRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            out.writeInt(this.mWakeupReasonStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mWakeupReasonStats.entrySet()) {
                SamplingTimer timer = ent.getValue();
                if (timer != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    timer.writeToParcel(out, uSecRealtime);
                    continue;
                }
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
        }
        if (inclUids) {
            int size = this.mUidStats.size();
            out.writeInt(size);
            for (int i2 = 0; i2 < size; ++i2) {
                out.writeInt(this.mUidStats.keyAt(i2));
                Uid uid = this.mUidStats.valueAt(i2);
                uid.writeToParcelLocked(out, uSecRealtime);
            }
        } else {
            out.writeInt(0);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$prepareForDumpLocked() {
        this.pullPendingStateUpdatesLocked();
        this.getStartClockTime();
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsImpl$dumpLocked(Context context, PrintWriter pw, int flags, int reqUid, long histStart) {
        super.dumpLocked(context, pw, flags, reqUid, histStart);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<BatteryStatsImpl>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_os_BatteryStatsImpl_5$__constructor__() {
            }

            private final BatteryStatsImpl $$robo$$com_android_internal_os_BatteryStatsImpl_5$createFromParcel(Parcel in) {
                return new BatteryStatsImpl(in);
            }

            private final BatteryStatsImpl[] $$robo$$com_android_internal_os_BatteryStatsImpl_5$newArray(int size) {
                return new BatteryStatsImpl[size];
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_os_BatteryStatsImpl_5$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_5$__constructor__(), 0, this);
            }

            @Override
            public BatteryStatsImpl createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_5$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public BatteryStatsImpl[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_os_BatteryStatsImpl_5$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public Map<String, ? extends Timer> getKernelWakelockStats() {
        return InvokeDynamicSupport.bootstrap("getKernelWakelockStats", $$robo$$com_android_internal_os_BatteryStatsImpl$getKernelWakelockStats(), 0, this);
    }

    public Map<String, ? extends Timer> getWakeupReasonStats() {
        return InvokeDynamicSupport.bootstrap("getWakeupReasonStats", $$robo$$com_android_internal_os_BatteryStatsImpl$getWakeupReasonStats(), 0, this);
    }

    @Override
    public BatteryStats.LongCounter getDischargeScreenOffCoulombCounter() {
        return InvokeDynamicSupport.bootstrap("getDischargeScreenOffCoulombCounter", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeScreenOffCoulombCounter(), 0, this);
    }

    @Override
    public BatteryStats.LongCounter getDischargeCoulombCounter() {
        return InvokeDynamicSupport.bootstrap("getDischargeCoulombCounter", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeCoulombCounter(), 0, this);
    }

    @Override
    public int getEstimatedBatteryCapacity() {
        return (int)InvokeDynamicSupport.bootstrap("getEstimatedBatteryCapacity", $$robo$$com_android_internal_os_BatteryStatsImpl$getEstimatedBatteryCapacity(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__();
    }

    public BatteryStatsImpl() {
        this(new SystemClocks());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(), 0, this);
    }

    private void __constructor__(Clocks clocks) {
        this.$$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(clocks);
    }

    public BatteryStatsImpl(Clocks clocks) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks ), 0, this, clocks);
    }

    private void init(Clocks clocks) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_os_BatteryStatsImpl$init(com.android.internal.os.BatteryStatsImpl$Clocks ), 0, this, clocks);
    }

    public SamplingTimer getWakeupReasonTimerLocked(String string2) {
        return InvokeDynamicSupport.bootstrap("getWakeupReasonTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getWakeupReasonTimerLocked(java.lang.String ), 0, this, string2);
    }

    public SamplingTimer getKernelWakelockTimerLocked(String string2) {
        return InvokeDynamicSupport.bootstrap("getKernelWakelockTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getKernelWakelockTimerLocked(java.lang.String ), 0, this, string2);
    }

    private int writeHistoryTag(BatteryStats.HistoryTag historyTag) {
        return (int)InvokeDynamicSupport.bootstrap("writeHistoryTag", $$robo$$com_android_internal_os_BatteryStatsImpl$writeHistoryTag(android.os.BatteryStats$HistoryTag ), 0, this, historyTag);
    }

    private void readHistoryTag(int n, BatteryStats.HistoryTag historyTag) {
        InvokeDynamicSupport.bootstrap("readHistoryTag", $$robo$$com_android_internal_os_BatteryStatsImpl$readHistoryTag(int android.os.BatteryStats$HistoryTag ), 0, this, n, historyTag);
    }

    public void writeHistoryDelta(Parcel parcel, BatteryStats.HistoryItem historyItem, BatteryStats.HistoryItem historyItem2) {
        InvokeDynamicSupport.bootstrap("writeHistoryDelta", $$robo$$com_android_internal_os_BatteryStatsImpl$writeHistoryDelta(android.os.Parcel android.os.BatteryStats$HistoryItem android.os.BatteryStats$HistoryItem ), 0, this, parcel, historyItem, historyItem2);
    }

    private int buildBatteryLevelInt(BatteryStats.HistoryItem historyItem) {
        return (int)InvokeDynamicSupport.bootstrap("buildBatteryLevelInt", $$robo$$com_android_internal_os_BatteryStatsImpl$buildBatteryLevelInt(android.os.BatteryStats$HistoryItem ), 0, this, historyItem);
    }

    private void readBatteryLevelInt(int n, BatteryStats.HistoryItem historyItem) {
        InvokeDynamicSupport.bootstrap("readBatteryLevelInt", $$robo$$com_android_internal_os_BatteryStatsImpl$readBatteryLevelInt(int android.os.BatteryStats$HistoryItem ), 0, this, n, historyItem);
    }

    private int buildStateInt(BatteryStats.HistoryItem historyItem) {
        return (int)InvokeDynamicSupport.bootstrap("buildStateInt", $$robo$$com_android_internal_os_BatteryStatsImpl$buildStateInt(android.os.BatteryStats$HistoryItem ), 0, this, historyItem);
    }

    private void computeHistoryStepDetails(BatteryStats.HistoryStepDetails historyStepDetails, BatteryStats.HistoryStepDetails historyStepDetails2) {
        InvokeDynamicSupport.bootstrap("computeHistoryStepDetails", $$robo$$com_android_internal_os_BatteryStatsImpl$computeHistoryStepDetails(android.os.BatteryStats$HistoryStepDetails android.os.BatteryStats$HistoryStepDetails ), 0, this, historyStepDetails, historyStepDetails2);
    }

    public void readHistoryDelta(Parcel parcel, BatteryStats.HistoryItem historyItem) {
        InvokeDynamicSupport.bootstrap("readHistoryDelta", $$robo$$com_android_internal_os_BatteryStatsImpl$readHistoryDelta(android.os.Parcel android.os.BatteryStats$HistoryItem ), 0, this, parcel, historyItem);
    }

    @Override
    public void commitCurrentHistoryBatchLocked() {
        InvokeDynamicSupport.bootstrap("commitCurrentHistoryBatchLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$commitCurrentHistoryBatchLocked(), 0, this);
    }

    void addHistoryBufferLocked(long l, long l2, BatteryStats.HistoryItem historyItem) {
        InvokeDynamicSupport.bootstrap("addHistoryBufferLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryBufferLocked(long long android.os.BatteryStats$HistoryItem ), 0, this, l, l2, historyItem);
    }

    private void addHistoryBufferLocked(long l, long l2, byte by, BatteryStats.HistoryItem historyItem) {
        InvokeDynamicSupport.bootstrap("addHistoryBufferLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryBufferLocked(long long byte android.os.BatteryStats$HistoryItem ), 0, this, l, l2, by, historyItem);
    }

    void addHistoryRecordLocked(long l, long l2) {
        InvokeDynamicSupport.bootstrap("addHistoryRecordLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryRecordLocked(long long ), 0, this, l, l2);
    }

    void addHistoryRecordInnerLocked(long l, long l2, BatteryStats.HistoryItem historyItem) {
        InvokeDynamicSupport.bootstrap("addHistoryRecordInnerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryRecordInnerLocked(long long android.os.BatteryStats$HistoryItem ), 0, this, l, l2, historyItem);
    }

    public void addHistoryEventLocked(long l, long l2, int n, String string2, int n2) {
        InvokeDynamicSupport.bootstrap("addHistoryEventLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryEventLocked(long long int java.lang.String int ), 0, this, l, l2, n, string2, n2);
    }

    void addHistoryRecordLocked(long l, long l2, byte by, BatteryStats.HistoryItem historyItem) {
        InvokeDynamicSupport.bootstrap("addHistoryRecordLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryRecordLocked(long long byte android.os.BatteryStats$HistoryItem ), 0, this, l, l2, by, historyItem);
    }

    void addHistoryRecordLocked(BatteryStats.HistoryItem historyItem) {
        InvokeDynamicSupport.bootstrap("addHistoryRecordLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$addHistoryRecordLocked(android.os.BatteryStats$HistoryItem ), 0, this, historyItem);
    }

    void clearHistoryLocked() {
        InvokeDynamicSupport.bootstrap("clearHistoryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$clearHistoryLocked(), 0, this);
    }

    public void updateTimeBasesLocked(boolean bl, boolean bl2, long l, long l2) {
        InvokeDynamicSupport.bootstrap("updateTimeBasesLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateTimeBasesLocked(boolean boolean long long ), 0, this, bl, bl2, l, l2);
    }

    public void addIsolatedUidLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("addIsolatedUidLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$addIsolatedUidLocked(int int ), 0, this, n, n2);
    }

    public void scheduleRemoveIsolatedUidLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("scheduleRemoveIsolatedUidLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$scheduleRemoveIsolatedUidLocked(int int ), 0, this, n, n2);
    }

    public void removeIsolatedUidLocked(int n) {
        InvokeDynamicSupport.bootstrap("removeIsolatedUidLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$removeIsolatedUidLocked(int ), 0, this, n);
    }

    public int mapUid(int n) {
        return (int)InvokeDynamicSupport.bootstrap("mapUid", $$robo$$com_android_internal_os_BatteryStatsImpl$mapUid(int ), 0, this, n);
    }

    public void noteEventLocked(int n, String string2, int n2) {
        InvokeDynamicSupport.bootstrap("noteEventLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteEventLocked(int java.lang.String int ), 0, this, n, string2, n2);
    }

    boolean ensureStartClockTime(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("ensureStartClockTime", $$robo$$com_android_internal_os_BatteryStatsImpl$ensureStartClockTime(long ), 0, this, l);
    }

    public void noteCurrentTimeChangedLocked() {
        InvokeDynamicSupport.bootstrap("noteCurrentTimeChangedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteCurrentTimeChangedLocked(), 0, this);
    }

    public void noteProcessStartLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteProcessStartLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessStartLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteProcessCrashLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteProcessCrashLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessCrashLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteProcessAnrLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteProcessAnrLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessAnrLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteUidProcessStateLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("noteUidProcessStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteUidProcessStateLocked(int int ), 0, this, n, n2);
    }

    public void noteProcessFinishLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteProcessFinishLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessFinishLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteSyncStartLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteSyncStartLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteSyncStartLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteSyncFinishLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteSyncFinishLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteSyncFinishLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteJobStartLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteJobStartLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteJobStartLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteJobFinishLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteJobFinishLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteJobFinishLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteAlarmStartLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteAlarmStartLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteAlarmStartLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteAlarmFinishLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteAlarmFinishLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteAlarmFinishLocked(java.lang.String int ), 0, this, string2, n);
    }

    private void requestWakelockCpuUpdate() {
        InvokeDynamicSupport.bootstrap("requestWakelockCpuUpdate", $$robo$$com_android_internal_os_BatteryStatsImpl$requestWakelockCpuUpdate(), 0, this);
    }

    private void requestImmediateCpuUpdate() {
        InvokeDynamicSupport.bootstrap("requestImmediateCpuUpdate", $$robo$$com_android_internal_os_BatteryStatsImpl$requestImmediateCpuUpdate(), 0, this);
    }

    public void setRecordAllHistoryLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRecordAllHistoryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$setRecordAllHistoryLocked(boolean ), 0, this, bl);
    }

    public void setNoAutoReset(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNoAutoReset", $$robo$$com_android_internal_os_BatteryStatsImpl$setNoAutoReset(boolean ), 0, this, bl);
    }

    public void noteStartWakeLocked(int n, int n2, String string2, String string3, int n3, boolean bl, long l, long l2) {
        InvokeDynamicSupport.bootstrap("noteStartWakeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteStartWakeLocked(int int java.lang.String java.lang.String int boolean long long ), 0, this, n, n2, string2, string3, n3, bl, l, l2);
    }

    public void noteStopWakeLocked(int n, int n2, String string2, String string3, int n3, long l, long l2) {
        InvokeDynamicSupport.bootstrap("noteStopWakeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteStopWakeLocked(int int java.lang.String java.lang.String int long long ), 0, this, n, n2, string2, string3, n3, l, l2);
    }

    public void noteStartWakeFromSourceLocked(WorkSource workSource, int n, String string2, String string3, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("noteStartWakeFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteStartWakeFromSourceLocked(android.os.WorkSource int java.lang.String java.lang.String int boolean ), 0, this, workSource, n, string2, string3, n2, bl);
    }

    public void noteChangeWakelockFromSourceLocked(WorkSource workSource, int n, String string2, String string3, int n2, WorkSource workSource2, int n3, String string4, String string5, int n4, boolean bl) {
        InvokeDynamicSupport.bootstrap("noteChangeWakelockFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteChangeWakelockFromSourceLocked(android.os.WorkSource int java.lang.String java.lang.String int android.os.WorkSource int java.lang.String java.lang.String int boolean ), 0, this, workSource, n, string2, string3, n2, workSource2, n3, string4, string5, n4, bl);
    }

    public void noteStopWakeFromSourceLocked(WorkSource workSource, int n, String string2, String string3, int n2) {
        InvokeDynamicSupport.bootstrap("noteStopWakeFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteStopWakeFromSourceLocked(android.os.WorkSource int java.lang.String java.lang.String int ), 0, this, workSource, n, string2, string3, n2);
    }

    void aggregateLastWakeupUptimeLocked(long l) {
        InvokeDynamicSupport.bootstrap("aggregateLastWakeupUptimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$aggregateLastWakeupUptimeLocked(long ), 0, this, l);
    }

    public void noteWakeupReasonLocked(String string2) {
        InvokeDynamicSupport.bootstrap("noteWakeupReasonLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWakeupReasonLocked(java.lang.String ), 0, this, string2);
    }

    public boolean startAddingCpuLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("startAddingCpuLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$startAddingCpuLocked(), 0, this);
    }

    public void finishAddingCpuLocked(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        InvokeDynamicSupport.bootstrap("finishAddingCpuLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$finishAddingCpuLocked(int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void noteProcessDiedLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("noteProcessDiedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteProcessDiedLocked(int int ), 0, this, n, n2);
    }

    public long getProcessWakeTime(int n, int n2, long l) {
        return (long)InvokeDynamicSupport.bootstrap("getProcessWakeTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getProcessWakeTime(int int long ), 0, this, n, n2, l);
    }

    public void reportExcessiveWakeLocked(int n, String string2, long l, long l2) {
        InvokeDynamicSupport.bootstrap("reportExcessiveWakeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$reportExcessiveWakeLocked(int java.lang.String long long ), 0, this, n, string2, l, l2);
    }

    public void reportExcessiveCpuLocked(int n, String string2, long l, long l2) {
        InvokeDynamicSupport.bootstrap("reportExcessiveCpuLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$reportExcessiveCpuLocked(int java.lang.String long long ), 0, this, n, string2, l, l2);
    }

    public void noteStartSensorLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("noteStartSensorLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteStartSensorLocked(int int ), 0, this, n, n2);
    }

    public void noteStopSensorLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("noteStopSensorLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteStopSensorLocked(int int ), 0, this, n, n2);
    }

    public void noteStartGpsLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteStartGpsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteStartGpsLocked(int ), 0, this, n);
    }

    public void noteStopGpsLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteStopGpsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteStopGpsLocked(int ), 0, this, n);
    }

    public void noteScreenStateLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteScreenStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteScreenStateLocked(int ), 0, this, n);
    }

    public void noteScreenBrightnessLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteScreenBrightnessLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteScreenBrightnessLocked(int ), 0, this, n);
    }

    public void noteUserActivityLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("noteUserActivityLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteUserActivityLocked(int int ), 0, this, n, n2);
    }

    public void noteWakeUpLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteWakeUpLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWakeUpLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteInteractiveLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("noteInteractiveLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteInteractiveLocked(boolean ), 0, this, bl);
    }

    public void noteConnectivityChangedLocked(int n, String string2) {
        InvokeDynamicSupport.bootstrap("noteConnectivityChangedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteConnectivityChangedLocked(int java.lang.String ), 0, this, n, string2);
    }

    public void noteMobileRadioPowerState(int n, long l, int n2) {
        InvokeDynamicSupport.bootstrap("noteMobileRadioPowerState", $$robo$$com_android_internal_os_BatteryStatsImpl$noteMobileRadioPowerState(int long int ), 0, this, n, l, n2);
    }

    public void notePowerSaveMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("notePowerSaveMode", $$robo$$com_android_internal_os_BatteryStatsImpl$notePowerSaveMode(boolean ), 0, this, bl);
    }

    public void noteDeviceIdleModeLocked(int n, String string2, int n2) {
        InvokeDynamicSupport.bootstrap("noteDeviceIdleModeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteDeviceIdleModeLocked(int java.lang.String int ), 0, this, n, string2, n2);
    }

    public void notePackageInstalledLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("notePackageInstalledLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$notePackageInstalledLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void notePackageUninstalledLocked(String string2) {
        InvokeDynamicSupport.bootstrap("notePackageUninstalledLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$notePackageUninstalledLocked(java.lang.String ), 0, this, string2);
    }

    private void addPackageChange(BatteryStats.PackageChange packageChange) {
        InvokeDynamicSupport.bootstrap("addPackageChange", $$robo$$com_android_internal_os_BatteryStatsImpl$addPackageChange(android.os.BatteryStats$PackageChange ), 0, this, packageChange);
    }

    public void notePhoneOnLocked() {
        InvokeDynamicSupport.bootstrap("notePhoneOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneOnLocked(), 0, this);
    }

    public void notePhoneOffLocked() {
        InvokeDynamicSupport.bootstrap("notePhoneOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneOffLocked(), 0, this);
    }

    void stopAllPhoneSignalStrengthTimersLocked(int n) {
        InvokeDynamicSupport.bootstrap("stopAllPhoneSignalStrengthTimersLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$stopAllPhoneSignalStrengthTimersLocked(int ), 0, this, n);
    }

    private int fixPhoneServiceState(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("fixPhoneServiceState", $$robo$$com_android_internal_os_BatteryStatsImpl$fixPhoneServiceState(int int ), 0, this, n, n2);
    }

    private void updateAllPhoneStateLocked(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("updateAllPhoneStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateAllPhoneStateLocked(int int int ), 0, this, n, n2, n3);
    }

    public void notePhoneStateLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("notePhoneStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneStateLocked(int int ), 0, this, n, n2);
    }

    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        InvokeDynamicSupport.bootstrap("notePhoneSignalStrengthLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneSignalStrengthLocked(android.telephony.SignalStrength ), 0, this, signalStrength);
    }

    public void notePhoneDataConnectionStateLocked(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("notePhoneDataConnectionStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$notePhoneDataConnectionStateLocked(int boolean ), 0, this, n, bl);
    }

    public void noteWifiOnLocked() {
        InvokeDynamicSupport.bootstrap("noteWifiOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiOnLocked(), 0, this);
    }

    public void noteWifiOffLocked() {
        InvokeDynamicSupport.bootstrap("noteWifiOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiOffLocked(), 0, this);
    }

    public void noteAudioOnLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteAudioOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteAudioOnLocked(int ), 0, this, n);
    }

    public void noteAudioOffLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteAudioOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteAudioOffLocked(int ), 0, this, n);
    }

    public void noteVideoOnLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteVideoOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteVideoOnLocked(int ), 0, this, n);
    }

    public void noteVideoOffLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteVideoOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteVideoOffLocked(int ), 0, this, n);
    }

    public void noteResetAudioLocked() {
        InvokeDynamicSupport.bootstrap("noteResetAudioLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetAudioLocked(), 0, this);
    }

    public void noteResetVideoLocked() {
        InvokeDynamicSupport.bootstrap("noteResetVideoLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetVideoLocked(), 0, this);
    }

    public void noteActivityResumedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteActivityResumedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteActivityResumedLocked(int ), 0, this, n);
    }

    public void noteActivityPausedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteActivityPausedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteActivityPausedLocked(int ), 0, this, n);
    }

    public void noteVibratorOnLocked(int n, long l) {
        InvokeDynamicSupport.bootstrap("noteVibratorOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteVibratorOnLocked(int long ), 0, this, n, l);
    }

    public void noteVibratorOffLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteVibratorOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteVibratorOffLocked(int ), 0, this, n);
    }

    public void noteFlashlightOnLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteFlashlightOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteFlashlightOnLocked(int ), 0, this, n);
    }

    public void noteFlashlightOffLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteFlashlightOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteFlashlightOffLocked(int ), 0, this, n);
    }

    public void noteCameraOnLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteCameraOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteCameraOnLocked(int ), 0, this, n);
    }

    public void noteCameraOffLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteCameraOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteCameraOffLocked(int ), 0, this, n);
    }

    public void noteResetCameraLocked() {
        InvokeDynamicSupport.bootstrap("noteResetCameraLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetCameraLocked(), 0, this);
    }

    public void noteResetFlashlightLocked() {
        InvokeDynamicSupport.bootstrap("noteResetFlashlightLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetFlashlightLocked(), 0, this);
    }

    private void noteBluetoothScanStartedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteBluetoothScanStartedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteBluetoothScanStartedLocked(int ), 0, this, n);
    }

    public void noteBluetoothScanStartedFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteBluetoothScanStartedFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteBluetoothScanStartedFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    private void noteBluetoothScanStoppedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteBluetoothScanStoppedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteBluetoothScanStoppedLocked(int ), 0, this, n);
    }

    public void noteBluetoothScanStoppedFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteBluetoothScanStoppedFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteBluetoothScanStoppedFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteResetBluetoothScanLocked() {
        InvokeDynamicSupport.bootstrap("noteResetBluetoothScanLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteResetBluetoothScanLocked(), 0, this);
    }

    public void noteWifiRadioPowerState(int n, long l) {
        InvokeDynamicSupport.bootstrap("noteWifiRadioPowerState", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiRadioPowerState(int long ), 0, this, n, l);
    }

    public void noteWifiRunningLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteWifiRunningLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiRunningLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteWifiRunningChangedLocked(WorkSource workSource, WorkSource workSource2) {
        InvokeDynamicSupport.bootstrap("noteWifiRunningChangedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiRunningChangedLocked(android.os.WorkSource android.os.WorkSource ), 0, this, workSource, workSource2);
    }

    public void noteWifiStoppedLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteWifiStoppedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiStoppedLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteWifiStateLocked(int n, String string2) {
        InvokeDynamicSupport.bootstrap("noteWifiStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiStateLocked(int java.lang.String ), 0, this, n, string2);
    }

    public void noteWifiSupplicantStateChangedLocked(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("noteWifiSupplicantStateChangedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiSupplicantStateChangedLocked(int boolean ), 0, this, n, bl);
    }

    void stopAllWifiSignalStrengthTimersLocked(int n) {
        InvokeDynamicSupport.bootstrap("stopAllWifiSignalStrengthTimersLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$stopAllWifiSignalStrengthTimersLocked(int ), 0, this, n);
    }

    public void noteWifiRssiChangedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteWifiRssiChangedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiRssiChangedLocked(int ), 0, this, n);
    }

    public void noteFullWifiLockAcquiredLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteFullWifiLockAcquiredLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteFullWifiLockAcquiredLocked(int ), 0, this, n);
    }

    public void noteFullWifiLockReleasedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteFullWifiLockReleasedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteFullWifiLockReleasedLocked(int ), 0, this, n);
    }

    public void noteWifiScanStartedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteWifiScanStartedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiScanStartedLocked(int ), 0, this, n);
    }

    public void noteWifiScanStoppedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteWifiScanStoppedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiScanStoppedLocked(int ), 0, this, n);
    }

    public void noteWifiBatchedScanStartedLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("noteWifiBatchedScanStartedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiBatchedScanStartedLocked(int int ), 0, this, n, n2);
    }

    public void noteWifiBatchedScanStoppedLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteWifiBatchedScanStoppedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiBatchedScanStoppedLocked(int ), 0, this, n);
    }

    public void noteWifiMulticastEnabledLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteWifiMulticastEnabledLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiMulticastEnabledLocked(int ), 0, this, n);
    }

    public void noteWifiMulticastDisabledLocked(int n) {
        InvokeDynamicSupport.bootstrap("noteWifiMulticastDisabledLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiMulticastDisabledLocked(int ), 0, this, n);
    }

    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteFullWifiLockAcquiredFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteFullWifiLockAcquiredFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteFullWifiLockReleasedFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteFullWifiLockReleasedFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteWifiScanStartedFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteWifiScanStartedFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiScanStartedFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteWifiScanStoppedFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteWifiScanStoppedFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiScanStoppedFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteWifiBatchedScanStartedFromSourceLocked(WorkSource workSource, int n) {
        InvokeDynamicSupport.bootstrap("noteWifiBatchedScanStartedFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiBatchedScanStartedFromSourceLocked(android.os.WorkSource int ), 0, this, workSource, n);
    }

    public void noteWifiBatchedScanStoppedFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteWifiBatchedScanStoppedFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiBatchedScanStoppedFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteWifiMulticastEnabledFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteWifiMulticastEnabledFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiMulticastEnabledFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    public void noteWifiMulticastDisabledFromSourceLocked(WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("noteWifiMulticastDisabledFromSourceLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteWifiMulticastDisabledFromSourceLocked(android.os.WorkSource ), 0, this, workSource);
    }

    private static String[] includeInStringArray(String[] stringArray, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("includeInStringArray", $$robo$$com_android_internal_os_BatteryStatsImpl$includeInStringArray(java.lang.String[] java.lang.String ), 0, (String[])stringArray, (String)string2);
    }

    private static String[] excludeFromStringArray(String[] stringArray, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("excludeFromStringArray", $$robo$$com_android_internal_os_BatteryStatsImpl$excludeFromStringArray(java.lang.String[] java.lang.String ), 0, (String[])stringArray, (String)string2);
    }

    public void noteNetworkInterfaceTypeLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("noteNetworkInterfaceTypeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteNetworkInterfaceTypeLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void noteNetworkStatsEnabledLocked() {
        InvokeDynamicSupport.bootstrap("noteNetworkStatsEnabledLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$noteNetworkStatsEnabledLocked(), 0, this);
    }

    @Override
    public long getScreenOnTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getScreenOnTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getScreenOnTime(long int ), 0, this, l, n);
    }

    @Override
    public int getScreenOnCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getScreenOnCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getScreenOnCount(int ), 0, this, n);
    }

    @Override
    public long getScreenBrightnessTime(int n, long l, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getScreenBrightnessTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getScreenBrightnessTime(int long int ), 0, this, n, l, n2);
    }

    @Override
    public long getInteractiveTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getInteractiveTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getInteractiveTime(long int ), 0, this, l, n);
    }

    @Override
    public long getPowerSaveModeEnabledTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPowerSaveModeEnabledTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getPowerSaveModeEnabledTime(long int ), 0, this, l, n);
    }

    @Override
    public int getPowerSaveModeEnabledCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPowerSaveModeEnabledCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getPowerSaveModeEnabledCount(int ), 0, this, n);
    }

    @Override
    public long getDeviceIdleModeTime(int n, long l, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getDeviceIdleModeTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getDeviceIdleModeTime(int long int ), 0, this, n, l, n2);
    }

    @Override
    public int getDeviceIdleModeCount(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceIdleModeCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getDeviceIdleModeCount(int int ), 0, this, n, n2);
    }

    @Override
    public long getLongestDeviceIdleModeTime(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getLongestDeviceIdleModeTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getLongestDeviceIdleModeTime(int ), 0, this, n);
    }

    @Override
    public long getDeviceIdlingTime(int n, long l, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getDeviceIdlingTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getDeviceIdlingTime(int long int ), 0, this, n, l, n2);
    }

    @Override
    public int getDeviceIdlingCount(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceIdlingCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getDeviceIdlingCount(int int ), 0, this, n, n2);
    }

    @Override
    public int getNumConnectivityChange(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNumConnectivityChange", $$robo$$com_android_internal_os_BatteryStatsImpl$getNumConnectivityChange(int ), 0, this, n);
    }

    @Override
    public long getPhoneOnTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPhoneOnTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneOnTime(long int ), 0, this, l, n);
    }

    @Override
    public int getPhoneOnCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneOnCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneOnCount(int ), 0, this, n);
    }

    @Override
    public long getPhoneSignalStrengthTime(int n, long l, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getPhoneSignalStrengthTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneSignalStrengthTime(int long int ), 0, this, n, l, n2);
    }

    @Override
    public long getPhoneSignalScanningTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPhoneSignalScanningTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneSignalScanningTime(long int ), 0, this, l, n);
    }

    @Override
    public int getPhoneSignalStrengthCount(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneSignalStrengthCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneSignalStrengthCount(int int ), 0, this, n, n2);
    }

    @Override
    public long getPhoneDataConnectionTime(int n, long l, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getPhoneDataConnectionTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneDataConnectionTime(int long int ), 0, this, n, l, n2);
    }

    @Override
    public int getPhoneDataConnectionCount(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneDataConnectionCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getPhoneDataConnectionCount(int int ), 0, this, n, n2);
    }

    @Override
    public long getMobileRadioActiveTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getMobileRadioActiveTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveTime(long int ), 0, this, l, n);
    }

    @Override
    public int getMobileRadioActiveCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMobileRadioActiveCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveCount(int ), 0, this, n);
    }

    @Override
    public long getMobileRadioActiveAdjustedTime(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getMobileRadioActiveAdjustedTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveAdjustedTime(int ), 0, this, n);
    }

    @Override
    public long getMobileRadioActiveUnknownTime(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getMobileRadioActiveUnknownTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveUnknownTime(int ), 0, this, n);
    }

    @Override
    public int getMobileRadioActiveUnknownCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMobileRadioActiveUnknownCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getMobileRadioActiveUnknownCount(int ), 0, this, n);
    }

    @Override
    public long getWifiOnTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getWifiOnTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiOnTime(long int ), 0, this, l, n);
    }

    @Override
    public long getGlobalWifiRunningTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getGlobalWifiRunningTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getGlobalWifiRunningTime(long int ), 0, this, l, n);
    }

    @Override
    public long getWifiStateTime(int n, long l, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getWifiStateTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiStateTime(int long int ), 0, this, n, l, n2);
    }

    @Override
    public int getWifiStateCount(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getWifiStateCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiStateCount(int int ), 0, this, n, n2);
    }

    @Override
    public long getWifiSupplStateTime(int n, long l, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getWifiSupplStateTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiSupplStateTime(int long int ), 0, this, n, l, n2);
    }

    @Override
    public int getWifiSupplStateCount(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getWifiSupplStateCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiSupplStateCount(int int ), 0, this, n, n2);
    }

    @Override
    public long getWifiSignalStrengthTime(int n, long l, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getWifiSignalStrengthTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiSignalStrengthTime(int long int ), 0, this, n, l, n2);
    }

    @Override
    public int getWifiSignalStrengthCount(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getWifiSignalStrengthCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiSignalStrengthCount(int int ), 0, this, n, n2);
    }

    @Override
    public BatteryStats.ControllerActivityCounter getBluetoothControllerActivity() {
        return InvokeDynamicSupport.bootstrap("getBluetoothControllerActivity", $$robo$$com_android_internal_os_BatteryStatsImpl$getBluetoothControllerActivity(), 0, this);
    }

    @Override
    public BatteryStats.ControllerActivityCounter getWifiControllerActivity() {
        return InvokeDynamicSupport.bootstrap("getWifiControllerActivity", $$robo$$com_android_internal_os_BatteryStatsImpl$getWifiControllerActivity(), 0, this);
    }

    @Override
    public BatteryStats.ControllerActivityCounter getModemControllerActivity() {
        return InvokeDynamicSupport.bootstrap("getModemControllerActivity", $$robo$$com_android_internal_os_BatteryStatsImpl$getModemControllerActivity(), 0, this);
    }

    @Override
    public boolean hasBluetoothActivityReporting() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBluetoothActivityReporting", $$robo$$com_android_internal_os_BatteryStatsImpl$hasBluetoothActivityReporting(), 0, this);
    }

    @Override
    public boolean hasWifiActivityReporting() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasWifiActivityReporting", $$robo$$com_android_internal_os_BatteryStatsImpl$hasWifiActivityReporting(), 0, this);
    }

    @Override
    public boolean hasModemActivityReporting() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasModemActivityReporting", $$robo$$com_android_internal_os_BatteryStatsImpl$hasModemActivityReporting(), 0, this);
    }

    @Override
    public long getFlashlightOnTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getFlashlightOnTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getFlashlightOnTime(long int ), 0, this, l, n);
    }

    @Override
    public long getFlashlightOnCount(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getFlashlightOnCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getFlashlightOnCount(int ), 0, this, n);
    }

    @Override
    public long getCameraOnTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getCameraOnTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getCameraOnTime(long int ), 0, this, l, n);
    }

    @Override
    public long getBluetoothScanTime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("getBluetoothScanTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getBluetoothScanTime(long int ), 0, this, l, n);
    }

    @Override
    public long getNetworkActivityBytes(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getNetworkActivityBytes", $$robo$$com_android_internal_os_BatteryStatsImpl$getNetworkActivityBytes(int int ), 0, this, n, n2);
    }

    @Override
    public long getNetworkActivityPackets(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getNetworkActivityPackets", $$robo$$com_android_internal_os_BatteryStatsImpl$getNetworkActivityPackets(int int ), 0, this, n, n2);
    }

    @Override
    public long getStartClockTime() {
        return (long)InvokeDynamicSupport.bootstrap("getStartClockTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getStartClockTime(), 0, this);
    }

    @Override
    public String getStartPlatformVersion() {
        return InvokeDynamicSupport.bootstrap("getStartPlatformVersion", $$robo$$com_android_internal_os_BatteryStatsImpl$getStartPlatformVersion(), 0, this);
    }

    @Override
    public String getEndPlatformVersion() {
        return InvokeDynamicSupport.bootstrap("getEndPlatformVersion", $$robo$$com_android_internal_os_BatteryStatsImpl$getEndPlatformVersion(), 0, this);
    }

    @Override
    public int getParcelVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getParcelVersion", $$robo$$com_android_internal_os_BatteryStatsImpl$getParcelVersion(), 0, this);
    }

    @Override
    public boolean getIsOnBattery() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIsOnBattery", $$robo$$com_android_internal_os_BatteryStatsImpl$getIsOnBattery(), 0, this);
    }

    @Override
    public SparseArray<? extends BatteryStats.Uid> getUidStats() {
        return InvokeDynamicSupport.bootstrap("getUidStats", $$robo$$com_android_internal_os_BatteryStatsImpl$getUidStats(), 0, this);
    }

    private void __constructor__(File file, Handler handler, ExternalStatsSync externalStatsSync) {
        this.$$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(file, handler, externalStatsSync);
    }

    public BatteryStatsImpl(File file, Handler handler, ExternalStatsSync externalStatsSync) {
        this(new SystemClocks(), file, handler, externalStatsSync, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(java.io.File android.os.Handler com.android.internal.os.BatteryStatsImpl$ExternalStatsSync ), 0, this, file, handler, externalStatsSync);
    }

    private void __constructor__(File file, Handler handler, ExternalStatsSync externalStatsSync, PlatformIdleStateCallback platformIdleStateCallback) {
        this.$$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(file, handler, externalStatsSync, platformIdleStateCallback);
    }

    public BatteryStatsImpl(File file, Handler handler, ExternalStatsSync externalStatsSync, PlatformIdleStateCallback platformIdleStateCallback) {
        this(new SystemClocks(), file, handler, externalStatsSync, platformIdleStateCallback);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(java.io.File android.os.Handler com.android.internal.os.BatteryStatsImpl$ExternalStatsSync com.android.internal.os.BatteryStatsImpl$PlatformIdleStateCallback ), 0, this, file, handler, externalStatsSync, platformIdleStateCallback);
    }

    private void __constructor__(Clocks clocks, File file, Handler handler, ExternalStatsSync externalStatsSync, PlatformIdleStateCallback platformIdleStateCallback) {
        this.$$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(clocks, file, handler, externalStatsSync, platformIdleStateCallback);
    }

    public BatteryStatsImpl(Clocks clocks, File file, Handler handler, ExternalStatsSync externalStatsSync, PlatformIdleStateCallback platformIdleStateCallback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks java.io.File android.os.Handler com.android.internal.os.BatteryStatsImpl$ExternalStatsSync com.android.internal.os.BatteryStatsImpl$PlatformIdleStateCallback ), 0, this, clocks, file, handler, externalStatsSync, platformIdleStateCallback);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(parcel);
    }

    public BatteryStatsImpl(Parcel parcel) {
        this(new SystemClocks(), parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__(Clocks clocks, Parcel parcel) {
        this.$$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(clocks, parcel);
    }

    public BatteryStatsImpl(Clocks clocks, Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks android.os.Parcel ), 0, this, clocks, parcel);
    }

    public void setPowerProfile(PowerProfile powerProfile) {
        InvokeDynamicSupport.bootstrap("setPowerProfile", $$robo$$com_android_internal_os_BatteryStatsImpl$setPowerProfile(com.android.internal.os.PowerProfile ), 0, this, powerProfile);
    }

    public void setCallback(BatteryCallback batteryCallback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$com_android_internal_os_BatteryStatsImpl$setCallback(com.android.internal.os.BatteryStatsImpl$BatteryCallback ), 0, this, batteryCallback);
    }

    public void setRadioScanningTimeout(long l) {
        InvokeDynamicSupport.bootstrap("setRadioScanningTimeout", $$robo$$com_android_internal_os_BatteryStatsImpl$setRadioScanningTimeout(long ), 0, this, l);
    }

    public void updateDailyDeadlineLocked() {
        InvokeDynamicSupport.bootstrap("updateDailyDeadlineLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateDailyDeadlineLocked(), 0, this);
    }

    public void recordDailyStatsIfNeededLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("recordDailyStatsIfNeededLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$recordDailyStatsIfNeededLocked(boolean ), 0, this, bl);
    }

    public void recordDailyStatsLocked() {
        InvokeDynamicSupport.bootstrap("recordDailyStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$recordDailyStatsLocked(), 0, this);
    }

    private void writeDailyItemsLocked(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("writeDailyItemsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$writeDailyItemsLocked(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    private void writeDailyLevelSteps(XmlSerializer xmlSerializer, String string2, BatteryStats.LevelStepTracker levelStepTracker, StringBuilder stringBuilder) throws IOException {
        InvokeDynamicSupport.bootstrap("writeDailyLevelSteps", $$robo$$com_android_internal_os_BatteryStatsImpl$writeDailyLevelSteps(org.xmlpull.v1.XmlSerializer java.lang.String android.os.BatteryStats$LevelStepTracker java.lang.StringBuilder ), 0, this, xmlSerializer, string2, levelStepTracker, stringBuilder);
    }

    public void readDailyStatsLocked() {
        InvokeDynamicSupport.bootstrap("readDailyStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$readDailyStatsLocked(), 0, this);
    }

    private void readDailyItemsLocked(XmlPullParser xmlPullParser) {
        InvokeDynamicSupport.bootstrap("readDailyItemsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$readDailyItemsLocked(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
    }

    void readDailyItemTagLocked(XmlPullParser xmlPullParser) throws NumberFormatException, XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("readDailyItemTagLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$readDailyItemTagLocked(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
    }

    void readDailyItemTagDetailsLocked(XmlPullParser xmlPullParser, BatteryStats.DailyItem dailyItem, boolean bl, String string2) throws NumberFormatException, XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("readDailyItemTagDetailsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$readDailyItemTagDetailsLocked(org.xmlpull.v1.XmlPullParser android.os.BatteryStats$DailyItem boolean java.lang.String ), 0, this, xmlPullParser, dailyItem, bl, string2);
    }

    @Override
    public BatteryStats.DailyItem getDailyItemLocked(int n) {
        return InvokeDynamicSupport.bootstrap("getDailyItemLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getDailyItemLocked(int ), 0, this, n);
    }

    @Override
    public long getCurrentDailyStartTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCurrentDailyStartTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getCurrentDailyStartTime(), 0, this);
    }

    @Override
    public long getNextMinDailyDeadline() {
        return (long)InvokeDynamicSupport.bootstrap("getNextMinDailyDeadline", $$robo$$com_android_internal_os_BatteryStatsImpl$getNextMinDailyDeadline(), 0, this);
    }

    @Override
    public long getNextMaxDailyDeadline() {
        return (long)InvokeDynamicSupport.bootstrap("getNextMaxDailyDeadline", $$robo$$com_android_internal_os_BatteryStatsImpl$getNextMaxDailyDeadline(), 0, this);
    }

    @Override
    public boolean startIteratingOldHistoryLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("startIteratingOldHistoryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$startIteratingOldHistoryLocked(), 0, this);
    }

    @Override
    public boolean getNextOldHistoryLocked(BatteryStats.HistoryItem historyItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("getNextOldHistoryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getNextOldHistoryLocked(android.os.BatteryStats$HistoryItem ), 0, this, historyItem);
    }

    @Override
    public void finishIteratingOldHistoryLocked() {
        InvokeDynamicSupport.bootstrap("finishIteratingOldHistoryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$finishIteratingOldHistoryLocked(), 0, this);
    }

    @Override
    public int getHistoryTotalSize() {
        return (int)InvokeDynamicSupport.bootstrap("getHistoryTotalSize", $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryTotalSize(), 0, this);
    }

    @Override
    public int getHistoryUsedSize() {
        return (int)InvokeDynamicSupport.bootstrap("getHistoryUsedSize", $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryUsedSize(), 0, this);
    }

    @Override
    public boolean startIteratingHistoryLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("startIteratingHistoryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$startIteratingHistoryLocked(), 0, this);
    }

    @Override
    public int getHistoryStringPoolSize() {
        return (int)InvokeDynamicSupport.bootstrap("getHistoryStringPoolSize", $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryStringPoolSize(), 0, this);
    }

    @Override
    public int getHistoryStringPoolBytes() {
        return (int)InvokeDynamicSupport.bootstrap("getHistoryStringPoolBytes", $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryStringPoolBytes(), 0, this);
    }

    @Override
    public String getHistoryTagPoolString(int n) {
        return InvokeDynamicSupport.bootstrap("getHistoryTagPoolString", $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryTagPoolString(int ), 0, this, n);
    }

    @Override
    public int getHistoryTagPoolUid(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getHistoryTagPoolUid", $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryTagPoolUid(int ), 0, this, n);
    }

    @Override
    public boolean getNextHistoryLocked(BatteryStats.HistoryItem historyItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("getNextHistoryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getNextHistoryLocked(android.os.BatteryStats$HistoryItem ), 0, this, historyItem);
    }

    @Override
    public void finishIteratingHistoryLocked() {
        InvokeDynamicSupport.bootstrap("finishIteratingHistoryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$finishIteratingHistoryLocked(), 0, this);
    }

    @Override
    public long getHistoryBaseTime() {
        return (long)InvokeDynamicSupport.bootstrap("getHistoryBaseTime", $$robo$$com_android_internal_os_BatteryStatsImpl$getHistoryBaseTime(), 0, this);
    }

    @Override
    public int getStartCount() {
        return (int)InvokeDynamicSupport.bootstrap("getStartCount", $$robo$$com_android_internal_os_BatteryStatsImpl$getStartCount(), 0, this);
    }

    public boolean isOnBattery() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnBattery", $$robo$$com_android_internal_os_BatteryStatsImpl$isOnBattery(), 0, this);
    }

    public boolean isCharging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCharging", $$robo$$com_android_internal_os_BatteryStatsImpl$isCharging(), 0, this);
    }

    public boolean isScreenOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScreenOn", $$robo$$com_android_internal_os_BatteryStatsImpl$isScreenOn(), 0, this);
    }

    void initTimes(long l, long l2) {
        InvokeDynamicSupport.bootstrap("initTimes", $$robo$$com_android_internal_os_BatteryStatsImpl$initTimes(long long ), 0, this, l, l2);
    }

    void initDischarge() {
        InvokeDynamicSupport.bootstrap("initDischarge", $$robo$$com_android_internal_os_BatteryStatsImpl$initDischarge(), 0, this);
    }

    public void resetAllStatsCmdLocked() {
        InvokeDynamicSupport.bootstrap("resetAllStatsCmdLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$resetAllStatsCmdLocked(), 0, this);
    }

    private void resetAllStatsLocked() {
        InvokeDynamicSupport.bootstrap("resetAllStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$resetAllStatsLocked(), 0, this);
    }

    private void initActiveHistoryEventsLocked(long l, long l2) {
        InvokeDynamicSupport.bootstrap("initActiveHistoryEventsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$initActiveHistoryEventsLocked(long long ), 0, this, l, l2);
    }

    void updateDischargeScreenLevelsLocked(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("updateDischargeScreenLevelsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateDischargeScreenLevelsLocked(boolean boolean ), 0, this, bl, bl2);
    }

    public void pullPendingStateUpdatesLocked() {
        InvokeDynamicSupport.bootstrap("pullPendingStateUpdatesLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$pullPendingStateUpdatesLocked(), 0, this);
    }

    private NetworkStats getNetworkStatsDeltaLocked(String[] stringArray, NetworkStats[] networkStatsArray) throws IOException {
        return InvokeDynamicSupport.bootstrap("getNetworkStatsDeltaLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getNetworkStatsDeltaLocked(java.lang.String[] android.net.NetworkStats[] ), 0, this, stringArray, networkStatsArray);
    }

    public void updateWifiStateLocked(WifiActivityEnergyInfo wifiActivityEnergyInfo) {
        InvokeDynamicSupport.bootstrap("updateWifiStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateWifiStateLocked(android.net.wifi.WifiActivityEnergyInfo ), 0, this, wifiActivityEnergyInfo);
    }

    public void updateMobileRadioStateLocked(long l, ModemActivityInfo modemActivityInfo) {
        InvokeDynamicSupport.bootstrap("updateMobileRadioStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateMobileRadioStateLocked(long android.telephony.ModemActivityInfo ), 0, this, l, modemActivityInfo);
    }

    public void updateBluetoothStateLocked(BluetoothActivityEnergyInfo bluetoothActivityEnergyInfo) {
        InvokeDynamicSupport.bootstrap("updateBluetoothStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateBluetoothStateLocked(android.bluetooth.BluetoothActivityEnergyInfo ), 0, this, bluetoothActivityEnergyInfo);
    }

    public void updateKernelWakelocksLocked() {
        InvokeDynamicSupport.bootstrap("updateKernelWakelocksLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateKernelWakelocksLocked(), 0, this);
    }

    public void updateCpuTimeLocked() {
        InvokeDynamicSupport.bootstrap("updateCpuTimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$updateCpuTimeLocked(), 0, this);
    }

    boolean setChargingLocked(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setChargingLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$setChargingLocked(boolean ), 0, this, bl);
    }

    void setOnBatteryLocked(long l, long l2, boolean bl, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setOnBatteryLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$setOnBatteryLocked(long long boolean int int int ), 0, this, l, l2, bl, n, n2, n3);
    }

    private void startRecordingHistory(long l, long l2, boolean bl) {
        InvokeDynamicSupport.bootstrap("startRecordingHistory", $$robo$$com_android_internal_os_BatteryStatsImpl$startRecordingHistory(long long boolean ), 0, this, l, l2, bl);
    }

    private void recordCurrentTimeChangeLocked(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrap("recordCurrentTimeChangeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$recordCurrentTimeChangeLocked(long long long ), 0, this, l, l2, l3);
    }

    private void recordShutdownLocked(long l, long l2) {
        InvokeDynamicSupport.bootstrap("recordShutdownLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$recordShutdownLocked(long long ), 0, this, l, l2);
    }

    private void scheduleSyncExternalStatsLocked(String string2, int n) {
        InvokeDynamicSupport.bootstrap("scheduleSyncExternalStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$scheduleSyncExternalStatsLocked(java.lang.String int ), 0, this, string2, n);
    }

    public void setBatteryStateLocked(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        InvokeDynamicSupport.bootstrap("setBatteryStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$setBatteryStateLocked(int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7);
    }

    public long getAwakeTimeBattery() {
        return (long)InvokeDynamicSupport.bootstrap("getAwakeTimeBattery", $$robo$$com_android_internal_os_BatteryStatsImpl$getAwakeTimeBattery(), 0, this);
    }

    public long getAwakeTimePlugged() {
        return (long)InvokeDynamicSupport.bootstrap("getAwakeTimePlugged", $$robo$$com_android_internal_os_BatteryStatsImpl$getAwakeTimePlugged(), 0, this);
    }

    @Override
    public long computeUptime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("computeUptime", $$robo$$com_android_internal_os_BatteryStatsImpl$computeUptime(long int ), 0, this, l, n);
    }

    @Override
    public long computeRealtime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("computeRealtime", $$robo$$com_android_internal_os_BatteryStatsImpl$computeRealtime(long int ), 0, this, l, n);
    }

    @Override
    public long computeBatteryUptime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("computeBatteryUptime", $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryUptime(long int ), 0, this, l, n);
    }

    @Override
    public long computeBatteryRealtime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("computeBatteryRealtime", $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryRealtime(long int ), 0, this, l, n);
    }

    @Override
    public long computeBatteryScreenOffUptime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("computeBatteryScreenOffUptime", $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryScreenOffUptime(long int ), 0, this, l, n);
    }

    @Override
    public long computeBatteryScreenOffRealtime(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrap("computeBatteryScreenOffRealtime", $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryScreenOffRealtime(long int ), 0, this, l, n);
    }

    private long computeTimePerLevel(long[] lArray, int n) {
        return (long)InvokeDynamicSupport.bootstrap("computeTimePerLevel", $$robo$$com_android_internal_os_BatteryStatsImpl$computeTimePerLevel(long[] int ), 0, this, lArray, n);
    }

    @Override
    public long computeBatteryTimeRemaining(long l) {
        return (long)InvokeDynamicSupport.bootstrap("computeBatteryTimeRemaining", $$robo$$com_android_internal_os_BatteryStatsImpl$computeBatteryTimeRemaining(long ), 0, this, l);
    }

    @Override
    public BatteryStats.LevelStepTracker getDischargeLevelStepTracker() {
        return InvokeDynamicSupport.bootstrap("getDischargeLevelStepTracker", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeLevelStepTracker(), 0, this);
    }

    @Override
    public BatteryStats.LevelStepTracker getDailyDischargeLevelStepTracker() {
        return InvokeDynamicSupport.bootstrap("getDailyDischargeLevelStepTracker", $$robo$$com_android_internal_os_BatteryStatsImpl$getDailyDischargeLevelStepTracker(), 0, this);
    }

    @Override
    public long computeChargeTimeRemaining(long l) {
        return (long)InvokeDynamicSupport.bootstrap("computeChargeTimeRemaining", $$robo$$com_android_internal_os_BatteryStatsImpl$computeChargeTimeRemaining(long ), 0, this, l);
    }

    @Override
    public BatteryStats.LevelStepTracker getChargeLevelStepTracker() {
        return InvokeDynamicSupport.bootstrap("getChargeLevelStepTracker", $$robo$$com_android_internal_os_BatteryStatsImpl$getChargeLevelStepTracker(), 0, this);
    }

    @Override
    public BatteryStats.LevelStepTracker getDailyChargeLevelStepTracker() {
        return InvokeDynamicSupport.bootstrap("getDailyChargeLevelStepTracker", $$robo$$com_android_internal_os_BatteryStatsImpl$getDailyChargeLevelStepTracker(), 0, this);
    }

    @Override
    public ArrayList<BatteryStats.PackageChange> getDailyPackageChanges() {
        return InvokeDynamicSupport.bootstrap("getDailyPackageChanges", $$robo$$com_android_internal_os_BatteryStatsImpl$getDailyPackageChanges(), 0, this);
    }

    protected long getBatteryUptimeLocked() {
        return (long)InvokeDynamicSupport.bootstrap("getBatteryUptimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getBatteryUptimeLocked(), 0, this);
    }

    @Override
    public long getBatteryUptime(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getBatteryUptime", $$robo$$com_android_internal_os_BatteryStatsImpl$getBatteryUptime(long ), 0, this, l);
    }

    @Override
    public long getBatteryRealtime(long l) {
        return (long)InvokeDynamicSupport.bootstrap("getBatteryRealtime", $$robo$$com_android_internal_os_BatteryStatsImpl$getBatteryRealtime(long ), 0, this, l);
    }

    @Override
    public int getDischargeStartLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeStartLevel", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeStartLevel(), 0, this);
    }

    public int getDischargeStartLevelLocked() {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeStartLevelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeStartLevelLocked(), 0, this);
    }

    @Override
    public int getDischargeCurrentLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeCurrentLevel", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeCurrentLevel(), 0, this);
    }

    public int getDischargeCurrentLevelLocked() {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeCurrentLevelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeCurrentLevelLocked(), 0, this);
    }

    @Override
    public int getLowDischargeAmountSinceCharge() {
        return (int)InvokeDynamicSupport.bootstrap("getLowDischargeAmountSinceCharge", $$robo$$com_android_internal_os_BatteryStatsImpl$getLowDischargeAmountSinceCharge(), 0, this);
    }

    @Override
    public int getHighDischargeAmountSinceCharge() {
        return (int)InvokeDynamicSupport.bootstrap("getHighDischargeAmountSinceCharge", $$robo$$com_android_internal_os_BatteryStatsImpl$getHighDischargeAmountSinceCharge(), 0, this);
    }

    @Override
    public int getDischargeAmount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeAmount", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmount(int ), 0, this, n);
    }

    @Override
    public int getDischargeAmountScreenOn() {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeAmountScreenOn", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmountScreenOn(), 0, this);
    }

    @Override
    public int getDischargeAmountScreenOnSinceCharge() {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeAmountScreenOnSinceCharge", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmountScreenOnSinceCharge(), 0, this);
    }

    @Override
    public int getDischargeAmountScreenOff() {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeAmountScreenOff", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmountScreenOff(), 0, this);
    }

    @Override
    public int getDischargeAmountScreenOffSinceCharge() {
        return (int)InvokeDynamicSupport.bootstrap("getDischargeAmountScreenOffSinceCharge", $$robo$$com_android_internal_os_BatteryStatsImpl$getDischargeAmountScreenOffSinceCharge(), 0, this);
    }

    public Uid getUidStatsLocked(int n) {
        return InvokeDynamicSupport.bootstrap("getUidStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getUidStatsLocked(int ), 0, this, n);
    }

    public void removeUidStatsLocked(int n) {
        InvokeDynamicSupport.bootstrap("removeUidStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$removeUidStatsLocked(int ), 0, this, n);
    }

    public Uid.Proc getProcessStatsLocked(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getProcessStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getProcessStatsLocked(int java.lang.String ), 0, this, n, string2);
    }

    public Uid.Pkg getPackageStatsLocked(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getPackageStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getPackageStatsLocked(int java.lang.String ), 0, this, n, string2);
    }

    public Uid.Pkg.Serv getServiceStatsLocked(int n, String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getServiceStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$getServiceStatsLocked(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    public void shutdownLocked() {
        InvokeDynamicSupport.bootstrap("shutdownLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$shutdownLocked(), 0, this);
    }

    public void writeAsyncLocked() {
        InvokeDynamicSupport.bootstrap("writeAsyncLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$writeAsyncLocked(), 0, this);
    }

    public void writeSyncLocked() {
        InvokeDynamicSupport.bootstrap("writeSyncLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$writeSyncLocked(), 0, this);
    }

    void writeLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("writeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$writeLocked(boolean ), 0, this, bl);
    }

    public void commitPendingDataToDisk() {
        InvokeDynamicSupport.bootstrap("commitPendingDataToDisk", $$robo$$com_android_internal_os_BatteryStatsImpl$commitPendingDataToDisk(), 0, this);
    }

    public void readLocked() {
        InvokeDynamicSupport.bootstrap("readLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$readLocked(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_os_BatteryStatsImpl$describeContents(), 0, this);
    }

    void readHistory(Parcel parcel, boolean bl) throws ParcelFormatException {
        InvokeDynamicSupport.bootstrap("readHistory", $$robo$$com_android_internal_os_BatteryStatsImpl$readHistory(android.os.Parcel boolean ), 0, this, parcel, bl);
    }

    void readOldHistory(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readOldHistory", $$robo$$com_android_internal_os_BatteryStatsImpl$readOldHistory(android.os.Parcel ), 0, this, parcel);
    }

    void writeHistory(Parcel parcel, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("writeHistory", $$robo$$com_android_internal_os_BatteryStatsImpl$writeHistory(android.os.Parcel boolean boolean ), 0, this, parcel, bl, bl2);
    }

    void writeOldHistory(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("writeOldHistory", $$robo$$com_android_internal_os_BatteryStatsImpl$writeOldHistory(android.os.Parcel ), 0, this, parcel);
    }

    public void readSummaryFromParcel(Parcel parcel) throws ParcelFormatException {
        InvokeDynamicSupport.bootstrap("readSummaryFromParcel", $$robo$$com_android_internal_os_BatteryStatsImpl$readSummaryFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public void writeSummaryToParcel(Parcel parcel, boolean bl) {
        InvokeDynamicSupport.bootstrap("writeSummaryToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl$writeSummaryToParcel(android.os.Parcel boolean ), 0, this, parcel, bl);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_os_BatteryStatsImpl$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    void readFromParcelLocked(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$readFromParcelLocked(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public void writeToParcelWithoutUids(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcelWithoutUids", $$robo$$com_android_internal_os_BatteryStatsImpl$writeToParcelWithoutUids(android.os.Parcel int ), 0, this, parcel, n);
    }

    void writeToParcelLocked(Parcel parcel, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$writeToParcelLocked(android.os.Parcel boolean int ), 0, this, parcel, bl, n);
    }

    @Override
    public void prepareForDumpLocked() {
        InvokeDynamicSupport.bootstrap("prepareForDumpLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$prepareForDumpLocked(), 0, this);
    }

    @Override
    public void dumpLocked(Context context, PrintWriter printWriter, int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("dumpLocked", $$robo$$com_android_internal_os_BatteryStatsImpl$dumpLocked(android.content.Context java.io.PrintWriter int int long ), 0, this, context, printWriter, n, n2, l);
    }

    static {
        RobolectricInternals.classInitializing(BatteryStatsImpl.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BatteryStatsImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Uid
    extends BatteryStats.Uid
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected BatteryStatsImpl mBsi;
        int mUid;
        boolean mWifiRunning;
        StopwatchTimer mWifiRunningTimer;
        boolean mFullWifiLockOut;
        StopwatchTimer mFullWifiLockTimer;
        boolean mWifiScanStarted;
        StopwatchTimer mWifiScanTimer;
        static int NO_BATCHED_SCAN_STARTED = -1;
        int mWifiBatchedScanBinStarted;
        StopwatchTimer[] mWifiBatchedScanTimer;
        boolean mWifiMulticastEnabled;
        StopwatchTimer mWifiMulticastTimer;
        StopwatchTimer mAudioTurnedOnTimer;
        StopwatchTimer mVideoTurnedOnTimer;
        StopwatchTimer mFlashlightTurnedOnTimer;
        StopwatchTimer mCameraTurnedOnTimer;
        StopwatchTimer mForegroundActivityTimer;
        StopwatchTimer mBluetoothScanTimer;
        int mProcessState;
        StopwatchTimer[] mProcessStateTimer;
        BatchTimer mVibratorOnTimer;
        Counter[] mUserActivityCounters;
        LongSamplingCounter[] mNetworkByteActivityCounters;
        LongSamplingCounter[] mNetworkPacketActivityCounters;
        LongSamplingCounter mMobileRadioActiveTime;
        LongSamplingCounter mMobileRadioActiveCount;
        private ControllerActivityCounterImpl mWifiControllerActivity;
        private ControllerActivityCounterImpl mBluetoothControllerActivity;
        private ControllerActivityCounterImpl mModemControllerActivity;
        long mLastStepUserTime;
        long mLastStepSystemTime;
        long mCurStepUserTime;
        long mCurStepSystemTime;
        LongSamplingCounter mUserCpuTime;
        LongSamplingCounter mSystemCpuTime;
        LongSamplingCounter mCpuPower;
        LongSamplingCounter[][] mCpuClusterSpeed;
        OverflowArrayMap<Wakelock> mWakelockStats;
        OverflowArrayMap<StopwatchTimer> mSyncStats;
        OverflowArrayMap<StopwatchTimer> mJobStats;
        SparseArray<Sensor> mSensorStats;
        ArrayMap<String, Proc> mProcessStats;
        ArrayMap<String, Pkg> mPackageStats;
        SparseArray<BatteryStats.Uid.Pid> mPids;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$__constructor__(BatteryStatsImpl bsi, int uid) {
            this.mWifiBatchedScanBinStarted = -1;
            this.mProcessState = -1;
            this.mSensorStats = new SparseArray();
            this.mProcessStats = new ArrayMap();
            this.mPackageStats = new ArrayMap();
            this.mPids = new SparseArray();
            this.mBsi = bsi;
            this.mUid = uid;
            this.mUserCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mSystemCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mCpuPower = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mWakelockStats = new OverflowArrayMap<Wakelock>(this, this.mBsi){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Uid this$0;

                private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_1$__constructor__(Uid this$0, BatteryStatsImpl x0) {
                }

                private final Wakelock $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_1$instantiateObject() {
                    return new Wakelock(this.this$0.mBsi, this.this$0);
                }

                private void __constructor__(Uid uid, BatteryStatsImpl batteryStatsImpl) {
                    this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid_1$__constructor__(uid, batteryStatsImpl);
                }
                {
                    this.this$0 = uid;
                    super(batteryStatsImpl);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_1$__constructor__(com.android.internal.os.BatteryStatsImpl$Uid com.android.internal.os.BatteryStatsImpl ), 0, this, uid, batteryStatsImpl);
                }

                @Override
                public Wakelock instantiateObject() {
                    return InvokeDynamicSupport.bootstrap("instantiateObject", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_1$instantiateObject(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mSyncStats = new OverflowArrayMap<StopwatchTimer>(this, this.mBsi){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Uid this$0;

                private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_2$__constructor__(Uid this$0, BatteryStatsImpl x0) {
                }

                private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_2$instantiateObject() {
                    return new StopwatchTimer(this.this$0.mBsi.mClocks, this.this$0, 13, null, this.this$0.mBsi.mOnBatteryTimeBase);
                }

                private void __constructor__(Uid uid, BatteryStatsImpl batteryStatsImpl) {
                    this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid_2$__constructor__(uid, batteryStatsImpl);
                }
                {
                    this.this$0 = uid;
                    super(batteryStatsImpl);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_2$__constructor__(com.android.internal.os.BatteryStatsImpl$Uid com.android.internal.os.BatteryStatsImpl ), 0, this, uid, batteryStatsImpl);
                }

                @Override
                public StopwatchTimer instantiateObject() {
                    return InvokeDynamicSupport.bootstrap("instantiateObject", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_2$instantiateObject(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mJobStats = new OverflowArrayMap<StopwatchTimer>(this, this.mBsi){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Uid this$0;

                private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_3$__constructor__(Uid this$0, BatteryStatsImpl x0) {
                }

                private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_3$instantiateObject() {
                    return new StopwatchTimer(this.this$0.mBsi.mClocks, this.this$0, 14, null, this.this$0.mBsi.mOnBatteryTimeBase);
                }

                private void __constructor__(Uid uid, BatteryStatsImpl batteryStatsImpl) {
                    this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid_3$__constructor__(uid, batteryStatsImpl);
                }
                {
                    this.this$0 = uid;
                    super(batteryStatsImpl);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_3$__constructor__(com.android.internal.os.BatteryStatsImpl$Uid com.android.internal.os.BatteryStatsImpl ), 0, this, uid, batteryStatsImpl);
                }

                @Override
                public StopwatchTimer instantiateObject() {
                    return InvokeDynamicSupport.bootstrap("instantiateObject", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_3$instantiateObject(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mWifiRunningTimer = new StopwatchTimer(this.mBsi.mClocks, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase);
            this.mFullWifiLockTimer = new StopwatchTimer(this.mBsi.mClocks, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase);
            this.mWifiScanTimer = new StopwatchTimer(this.mBsi.mClocks, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase);
            this.mWifiBatchedScanTimer = new StopwatchTimer[5];
            this.mWifiMulticastTimer = new StopwatchTimer(this.mBsi.mClocks, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase);
            this.mProcessStateTimer = new StopwatchTimer[6];
        }

        private final ArrayMap<String, ? extends BatteryStats.Uid.Wakelock> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWakelockStats() {
            return this.mWakelockStats.getMap();
        }

        private final ArrayMap<String, ? extends BatteryStats.Timer> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getSyncStats() {
            return this.mSyncStats.getMap();
        }

        private final ArrayMap<String, ? extends BatteryStats.Timer> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getJobStats() {
            return this.mJobStats.getMap();
        }

        private final SparseArray<? extends BatteryStats.Uid.Sensor> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getSensorStats() {
            return this.mSensorStats;
        }

        private final ArrayMap<String, ? extends BatteryStats.Uid.Proc> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getProcessStats() {
            return this.mProcessStats;
        }

        private final ArrayMap<String, ? extends BatteryStats.Uid.Pkg> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getPackageStats() {
            return this.mPackageStats;
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getUid() {
            return this.mUid;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiRunningLocked(long elapsedRealtimeMs) {
            if (!this.mWifiRunning) {
                this.mWifiRunning = true;
                if (this.mWifiRunningTimer == null) {
                    this.mWifiRunningTimer = new StopwatchTimer(this.mBsi.mClocks, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mWifiRunningTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiRunning) {
                this.mWifiRunning = false;
                this.mWifiRunningTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteFullWifiLockAcquiredLocked(long elapsedRealtimeMs) {
            if (!this.mFullWifiLockOut) {
                this.mFullWifiLockOut = true;
                if (this.mFullWifiLockTimer == null) {
                    this.mFullWifiLockTimer = new StopwatchTimer(this.mBsi.mClocks, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mFullWifiLockTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteFullWifiLockReleasedLocked(long elapsedRealtimeMs) {
            if (this.mFullWifiLockOut) {
                this.mFullWifiLockOut = false;
                this.mFullWifiLockTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiScanStartedLocked(long elapsedRealtimeMs) {
            if (!this.mWifiScanStarted) {
                this.mWifiScanStarted = true;
                if (this.mWifiScanTimer == null) {
                    this.mWifiScanTimer = new StopwatchTimer(this.mBsi.mClocks, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mWifiScanTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiScanStarted) {
                this.mWifiScanStarted = false;
                this.mWifiScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiBatchedScanStartedLocked(int csph, long elapsedRealtimeMs) {
            int bin;
            for (bin = 0; csph > 8 && bin < 4; csph >>= 3, ++bin) {
            }
            if (this.mWifiBatchedScanBinStarted == bin) {
                return;
            }
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(elapsedRealtimeMs);
            }
            this.mWifiBatchedScanBinStarted = bin;
            if (this.mWifiBatchedScanTimer[bin] == null) {
                this.makeWifiBatchedScanBin(bin, null);
            }
            this.mWifiBatchedScanTimer[bin].startRunningLocked(elapsedRealtimeMs);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiBatchedScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(elapsedRealtimeMs);
                this.mWifiBatchedScanBinStarted = -1;
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiMulticastEnabledLocked(long elapsedRealtimeMs) {
            if (!this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = true;
                if (this.mWifiMulticastTimer == null) {
                    this.mWifiMulticastTimer = new StopwatchTimer(this.mBsi.mClocks, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase);
                }
                this.mWifiMulticastTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiMulticastDisabledLocked(long elapsedRealtimeMs) {
            if (this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = false;
                this.mWifiMulticastTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final BatteryStats.ControllerActivityCounter $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiControllerActivity() {
            return this.mWifiControllerActivity;
        }

        private final BatteryStats.ControllerActivityCounter $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getBluetoothControllerActivity() {
            return this.mBluetoothControllerActivity;
        }

        private final BatteryStats.ControllerActivityCounter $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getModemControllerActivity() {
            return this.mModemControllerActivity;
        }

        private final ControllerActivityCounterImpl $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getOrCreateWifiControllerActivityLocked() {
            if (this.mWifiControllerActivity == null) {
                this.mWifiControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 1);
            }
            return this.mWifiControllerActivity;
        }

        private final ControllerActivityCounterImpl $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getOrCreateBluetoothControllerActivityLocked() {
            if (this.mBluetoothControllerActivity == null) {
                this.mBluetoothControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 1);
            }
            return this.mBluetoothControllerActivity;
        }

        private final ControllerActivityCounterImpl $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getOrCreateModemControllerActivityLocked() {
            if (this.mModemControllerActivity == null) {
                this.mModemControllerActivity = new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 5);
            }
            return this.mModemControllerActivity;
        }

        private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createAudioTurnedOnTimerLocked() {
            if (this.mAudioTurnedOnTimer == null) {
                this.mAudioTurnedOnTimer = new StopwatchTimer(this.mBsi.mClocks, this, 15, this.mBsi.mAudioTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mAudioTurnedOnTimer;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteAudioTurnedOnLocked(long elapsedRealtimeMs) {
            this.createAudioTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteAudioTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetAudioLocked(long elapsedRealtimeMs) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createVideoTurnedOnTimerLocked() {
            if (this.mVideoTurnedOnTimer == null) {
                this.mVideoTurnedOnTimer = new StopwatchTimer(this.mBsi.mClocks, this, 8, this.mBsi.mVideoTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mVideoTurnedOnTimer;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteVideoTurnedOnLocked(long elapsedRealtimeMs) {
            this.createVideoTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteVideoTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetVideoLocked(long elapsedRealtimeMs) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createFlashlightTurnedOnTimerLocked() {
            if (this.mFlashlightTurnedOnTimer == null) {
                this.mFlashlightTurnedOnTimer = new StopwatchTimer(this.mBsi.mClocks, this, 16, this.mBsi.mFlashlightTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mFlashlightTurnedOnTimer;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteFlashlightTurnedOnLocked(long elapsedRealtimeMs) {
            this.createFlashlightTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteFlashlightTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mFlashlightTurnedOnTimer != null) {
                this.mFlashlightTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetFlashlightLocked(long elapsedRealtimeMs) {
            if (this.mFlashlightTurnedOnTimer != null) {
                this.mFlashlightTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createCameraTurnedOnTimerLocked() {
            if (this.mCameraTurnedOnTimer == null) {
                this.mCameraTurnedOnTimer = new StopwatchTimer(this.mBsi.mClocks, this, 17, this.mBsi.mCameraTurnedOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mCameraTurnedOnTimer;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteCameraTurnedOnLocked(long elapsedRealtimeMs) {
            this.createCameraTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteCameraTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mCameraTurnedOnTimer != null) {
                this.mCameraTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetCameraLocked(long elapsedRealtimeMs) {
            if (this.mCameraTurnedOnTimer != null) {
                this.mCameraTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createForegroundActivityTimerLocked() {
            if (this.mForegroundActivityTimer == null) {
                this.mForegroundActivityTimer = new StopwatchTimer(this.mBsi.mClocks, this, 10, null, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mForegroundActivityTimer;
        }

        private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createBluetoothScanTimerLocked() {
            if (this.mBluetoothScanTimer == null) {
                this.mBluetoothScanTimer = new StopwatchTimer(this.mBsi.mClocks, this, 19, this.mBsi.mBluetoothScanOnTimers, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mBluetoothScanTimer;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteBluetoothScanStartedLocked(long elapsedRealtimeMs) {
            this.createBluetoothScanTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteBluetoothScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mBluetoothScanTimer != null) {
                this.mBluetoothScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetBluetoothScanLocked(long elapsedRealtimeMs) {
            if (this.mBluetoothScanTimer != null) {
                this.mBluetoothScanTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteActivityResumedLocked(long elapsedRealtimeMs) {
            this.createForegroundActivityTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteActivityPausedLocked(long elapsedRealtimeMs) {
            if (this.mForegroundActivityTimer != null) {
                this.mForegroundActivityTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final BatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createVibratorOnTimerLocked() {
            if (this.mVibratorOnTimer == null) {
                this.mVibratorOnTimer = new BatchTimer(this.mBsi.mClocks, this, 9, this.mBsi.mOnBatteryTimeBase);
            }
            return this.mVibratorOnTimer;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteVibratorOnLocked(long durationMillis) {
            this.createVibratorOnTimerLocked().addDuration(this.mBsi, durationMillis);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteVibratorOffLocked() {
            if (this.mVibratorOnTimer != null) {
                this.mVibratorOnTimer.abortLastDuration(this.mBsi);
            }
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiRunningTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiRunningTimer == null) {
                return 0L;
            }
            return this.mWifiRunningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getFullWifiLockTime(long elapsedRealtimeUs, int which) {
            if (this.mFullWifiLockTimer == null) {
                return 0L;
            }
            return this.mFullWifiLockTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiScanTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiScanTimer == null) {
                return 0L;
            }
            return this.mWifiScanTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiScanCount(int which) {
            if (this.mWifiScanTimer == null) {
                return 0;
            }
            return this.mWifiScanTimer.getCountLocked(which);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiBatchedScanTime(int csphBin, long elapsedRealtimeUs, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0L;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0L;
            }
            return this.mWifiBatchedScanTimer[csphBin].getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiBatchedScanCount(int csphBin, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0;
            }
            return this.mWifiBatchedScanTimer[csphBin].getCountLocked(which);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiMulticastTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiMulticastTimer == null) {
                return 0L;
            }
            return this.mWifiMulticastTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getAudioTurnedOnTimer() {
            return this.mAudioTurnedOnTimer;
        }

        private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getVideoTurnedOnTimer() {
            return this.mVideoTurnedOnTimer;
        }

        private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getFlashlightTurnedOnTimer() {
            return this.mFlashlightTurnedOnTimer;
        }

        private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getCameraTurnedOnTimer() {
            return this.mCameraTurnedOnTimer;
        }

        private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getForegroundActivityTimer() {
            return this.mForegroundActivityTimer;
        }

        private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getBluetoothScanTimer() {
            return this.mBluetoothScanTimer;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$makeProcessState(int i, Parcel in) {
            if (i < 0 || i >= 6) {
                return;
            }
            this.mProcessStateTimer[i] = in == null ? new StopwatchTimer(this.mBsi.mClocks, this, 12, null, this.mBsi.mOnBatteryTimeBase) : new StopwatchTimer(this.mBsi.mClocks, this, 12, null, this.mBsi.mOnBatteryTimeBase, in);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getProcessStateTime(int state, long elapsedRealtimeUs, int which) {
            if (state < 0 || state >= 6) {
                return 0L;
            }
            if (this.mProcessStateTimer[state] == null) {
                return 0L;
            }
            return this.mProcessStateTimer[state].getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getProcessStateTimer(int state) {
            if (state < 0 || state >= 6) {
                return null;
            }
            return this.mProcessStateTimer[state];
        }

        private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getVibratorOnTimer() {
            return this.mVibratorOnTimer;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteUserActivityLocked(int type) {
            if (this.mUserActivityCounters == null) {
                this.initUserActivityLocked();
            }
            if (type >= 0 && type < 4) {
                this.mUserActivityCounters[type].stepAtomic();
            } else {
                Slog.w("BatteryStatsImpl", "Unknown user activity type " + type + " was specified.", new Throwable());
            }
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$hasUserActivity() {
            return this.mUserActivityCounters != null;
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getUserActivityCount(int type, int which) {
            if (this.mUserActivityCounters == null) {
                return 0;
            }
            return this.mUserActivityCounters[type].getCountLocked(which);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$makeWifiBatchedScanBin(int i, Parcel in) {
            if (i < 0 || i >= 5) {
                return;
            }
            ArrayList<StopwatchTimer> collected = this.mBsi.mWifiBatchedScanTimers.get(i);
            if (collected == null) {
                collected = new ArrayList();
                this.mBsi.mWifiBatchedScanTimers.put(i, collected);
            }
            this.mWifiBatchedScanTimer[i] = in == null ? new StopwatchTimer(this.mBsi.mClocks, this, 11, collected, this.mBsi.mOnBatteryTimeBase) : new StopwatchTimer(this.mBsi.mClocks, this, 11, collected, this.mBsi.mOnBatteryTimeBase, in);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$initUserActivityLocked() {
            this.mUserActivityCounters = new Counter[4];
            for (int i = 0; i < 4; ++i) {
                this.mUserActivityCounters[i] = new Counter(this.mBsi.mOnBatteryTimeBase);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteNetworkActivityLocked(int type, long deltaBytes, long deltaPackets) {
            if (this.mNetworkByteActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            if (type >= 0 && type < 6) {
                this.mNetworkByteActivityCounters[type].addCountLocked(deltaBytes);
                this.mNetworkPacketActivityCounters[type].addCountLocked(deltaPackets);
            } else {
                Slog.w("BatteryStatsImpl", "Unknown network activity type " + type + " was specified.", new Throwable());
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteMobileRadioActiveTimeLocked(long batteryUptime) {
            if (this.mNetworkByteActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            this.mMobileRadioActiveTime.addCountLocked(batteryUptime);
            this.mMobileRadioActiveCount.addCountLocked(1L);
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$hasNetworkActivity() {
            return this.mNetworkByteActivityCounters != null;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getNetworkActivityBytes(int type, int which) {
            if (this.mNetworkByteActivityCounters != null && type >= 0 && type < this.mNetworkByteActivityCounters.length) {
                return this.mNetworkByteActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getNetworkActivityPackets(int type, int which) {
            if (this.mNetworkPacketActivityCounters != null && type >= 0 && type < this.mNetworkPacketActivityCounters.length) {
                return this.mNetworkPacketActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getMobileRadioActiveTime(int which) {
            return this.mMobileRadioActiveTime != null ? this.mMobileRadioActiveTime.getCountLocked(which) : 0L;
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getMobileRadioActiveCount(int which) {
            return this.mMobileRadioActiveCount != null ? (int)this.mMobileRadioActiveCount.getCountLocked(which) : 0;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getUserCpuTimeUs(int which) {
            return this.mUserCpuTime.getCountLocked(which);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getSystemCpuTimeUs(int which) {
            return this.mSystemCpuTime.getCountLocked(which);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getCpuPowerMaUs(int which) {
            return this.mCpuPower.getCountLocked(which);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getTimeAtCpuSpeed(int cluster, int step, int which) {
            LongSamplingCounter c;
            LongSamplingCounter[] cpuSpeeds;
            if (this.mCpuClusterSpeed != null && cluster >= 0 && cluster < this.mCpuClusterSpeed.length && (cpuSpeeds = this.mCpuClusterSpeed[cluster]) != null && step >= 0 && step < cpuSpeeds.length && (c = cpuSpeeds[step]) != null) {
                return c.getCountLocked(which);
            }
            return 0L;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$initNetworkActivityLocked() {
            this.mNetworkByteActivityCounters = new LongSamplingCounter[6];
            this.mNetworkPacketActivityCounters = new LongSamplingCounter[6];
            for (int i = 0; i < 6; ++i) {
                this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
                this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            }
            this.mMobileRadioActiveTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
            this.mMobileRadioActiveCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase);
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$reset() {
            int i;
            boolean active = false;
            if (this.mWifiRunningTimer != null) {
                active |= !this.mWifiRunningTimer.reset(false);
                active |= this.mWifiRunning;
            }
            if (this.mFullWifiLockTimer != null) {
                active |= !this.mFullWifiLockTimer.reset(false);
                active |= this.mFullWifiLockOut;
            }
            if (this.mWifiScanTimer != null) {
                active |= !this.mWifiScanTimer.reset(false);
                active |= this.mWifiScanStarted;
            }
            if (this.mWifiBatchedScanTimer != null) {
                for (i = 0; i < 5; ++i) {
                    if (this.mWifiBatchedScanTimer[i] == null) continue;
                    active |= !this.mWifiBatchedScanTimer[i].reset(false);
                }
                active |= this.mWifiBatchedScanBinStarted != -1;
            }
            if (this.mWifiMulticastTimer != null) {
                active |= !this.mWifiMulticastTimer.reset(false);
                active |= this.mWifiMulticastEnabled;
            }
            if (this.mAudioTurnedOnTimer != null) {
                active |= !this.mAudioTurnedOnTimer.reset(false);
            }
            if (this.mVideoTurnedOnTimer != null) {
                active |= !this.mVideoTurnedOnTimer.reset(false);
            }
            if (this.mFlashlightTurnedOnTimer != null) {
                active |= !this.mFlashlightTurnedOnTimer.reset(false);
            }
            if (this.mCameraTurnedOnTimer != null) {
                active |= !this.mCameraTurnedOnTimer.reset(false);
            }
            if (this.mForegroundActivityTimer != null) {
                active |= !this.mForegroundActivityTimer.reset(false);
            }
            if (this.mBluetoothScanTimer != null) {
                active |= !this.mBluetoothScanTimer.reset(false);
            }
            if (this.mProcessStateTimer != null) {
                for (i = 0; i < 6; ++i) {
                    if (this.mProcessStateTimer[i] == null) continue;
                    active |= !this.mProcessStateTimer[i].reset(false);
                }
                active |= this.mProcessState != -1;
            }
            if (this.mVibratorOnTimer != null) {
                if (this.mVibratorOnTimer.reset(false)) {
                    this.mVibratorOnTimer.detach();
                    this.mVibratorOnTimer = null;
                } else {
                    active = true;
                }
            }
            if (this.mUserActivityCounters != null) {
                for (i = 0; i < 4; ++i) {
                    this.mUserActivityCounters[i].reset(false);
                }
            }
            if (this.mNetworkByteActivityCounters != null) {
                for (i = 0; i < 6; ++i) {
                    this.mNetworkByteActivityCounters[i].reset(false);
                    this.mNetworkPacketActivityCounters[i].reset(false);
                }
                this.mMobileRadioActiveTime.reset(false);
                this.mMobileRadioActiveCount.reset(false);
            }
            if (this.mWifiControllerActivity != null) {
                this.mWifiControllerActivity.reset(false);
            }
            if (this.mBluetoothControllerActivity != null) {
                this.mBluetoothControllerActivity.reset(false);
            }
            if (this.mModemControllerActivity != null) {
                this.mModemControllerActivity.reset(false);
            }
            this.mUserCpuTime.reset(false);
            this.mSystemCpuTime.reset(false);
            this.mCpuPower.reset(false);
            if (this.mCpuClusterSpeed != null) {
                for (LongSamplingCounter[] speeds : this.mCpuClusterSpeed) {
                    if (speeds == null) continue;
                    for (LongSamplingCounter speed : speeds) {
                        if (speed == null) continue;
                        speed.reset(false);
                    }
                }
            }
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            for (int iw = wakeStats.size() - 1; iw >= 0; --iw) {
                Wakelock wl = wakeStats.valueAt(iw);
                if (wl.reset()) {
                    wakeStats.removeAt(iw);
                    continue;
                }
                active = true;
            }
            this.mWakelockStats.cleanup();
            ArrayMap<String, StopwatchTimer> syncStats = this.mSyncStats.getMap();
            for (int is = syncStats.size() - 1; is >= 0; --is) {
                StopwatchTimer timer = syncStats.valueAt(is);
                if (timer.reset(false)) {
                    syncStats.removeAt(is);
                    timer.detach();
                    continue;
                }
                active = true;
            }
            this.mSyncStats.cleanup();
            ArrayMap<String, StopwatchTimer> jobStats = this.mJobStats.getMap();
            for (int ij = jobStats.size() - 1; ij >= 0; --ij) {
                StopwatchTimer timer = jobStats.valueAt(ij);
                if (timer.reset(false)) {
                    jobStats.removeAt(ij);
                    timer.detach();
                    continue;
                }
                active = true;
            }
            this.mJobStats.cleanup();
            for (int ise = this.mSensorStats.size() - 1; ise >= 0; --ise) {
                Sensor s = this.mSensorStats.valueAt(ise);
                if (s.reset()) {
                    this.mSensorStats.removeAt(ise);
                    continue;
                }
                active = true;
            }
            for (int ip = this.mProcessStats.size() - 1; ip >= 0; --ip) {
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.detach();
            }
            this.mProcessStats.clear();
            if (this.mPids.size() > 0) {
                for (int i2 = this.mPids.size() - 1; i2 >= 0; --i2) {
                    BatteryStats.Uid.Pid pid = this.mPids.valueAt(i2);
                    if (pid.mWakeNesting > 0) {
                        active = true;
                        continue;
                    }
                    this.mPids.removeAt(i2);
                }
            }
            if (this.mPackageStats.size() > 0) {
                for (Map.Entry<String, Pkg> pkgEntry : this.mPackageStats.entrySet()) {
                    Pkg p = pkgEntry.getValue();
                    p.detach();
                    if (p.mServiceStats.size() <= 0) continue;
                    for (Map.Entry<String, Pkg.Serv> servEntry : p.mServiceStats.entrySet()) {
                        servEntry.getValue().detach();
                    }
                }
                this.mPackageStats.clear();
            }
            this.mLastStepSystemTime = 0L;
            this.mLastStepUserTime = 0L;
            this.mCurStepSystemTime = 0L;
            this.mCurStepUserTime = 0L;
            if (!active) {
                int i3;
                if (this.mWifiRunningTimer != null) {
                    this.mWifiRunningTimer.detach();
                }
                if (this.mFullWifiLockTimer != null) {
                    this.mFullWifiLockTimer.detach();
                }
                if (this.mWifiScanTimer != null) {
                    this.mWifiScanTimer.detach();
                }
                for (i3 = 0; i3 < 5; ++i3) {
                    if (this.mWifiBatchedScanTimer[i3] == null) continue;
                    this.mWifiBatchedScanTimer[i3].detach();
                }
                if (this.mWifiMulticastTimer != null) {
                    this.mWifiMulticastTimer.detach();
                }
                if (this.mAudioTurnedOnTimer != null) {
                    this.mAudioTurnedOnTimer.detach();
                    this.mAudioTurnedOnTimer = null;
                }
                if (this.mVideoTurnedOnTimer != null) {
                    this.mVideoTurnedOnTimer.detach();
                    this.mVideoTurnedOnTimer = null;
                }
                if (this.mFlashlightTurnedOnTimer != null) {
                    this.mFlashlightTurnedOnTimer.detach();
                    this.mFlashlightTurnedOnTimer = null;
                }
                if (this.mCameraTurnedOnTimer != null) {
                    this.mCameraTurnedOnTimer.detach();
                    this.mCameraTurnedOnTimer = null;
                }
                if (this.mForegroundActivityTimer != null) {
                    this.mForegroundActivityTimer.detach();
                    this.mForegroundActivityTimer = null;
                }
                if (this.mBluetoothScanTimer != null) {
                    this.mBluetoothScanTimer.detach();
                    this.mBluetoothScanTimer = null;
                }
                if (this.mUserActivityCounters != null) {
                    for (i3 = 0; i3 < 4; ++i3) {
                        this.mUserActivityCounters[i3].detach();
                    }
                }
                if (this.mNetworkByteActivityCounters != null) {
                    for (i3 = 0; i3 < 6; ++i3) {
                        this.mNetworkByteActivityCounters[i3].detach();
                        this.mNetworkPacketActivityCounters[i3].detach();
                    }
                }
                if (this.mWifiControllerActivity != null) {
                    this.mWifiControllerActivity.detach();
                }
                if (this.mBluetoothControllerActivity != null) {
                    this.mBluetoothControllerActivity.detach();
                }
                if (this.mModemControllerActivity != null) {
                    this.mModemControllerActivity.detach();
                }
                this.mPids.clear();
                this.mUserCpuTime.detach();
                this.mSystemCpuTime.detach();
                this.mCpuPower.detach();
                if (this.mCpuClusterSpeed != null) {
                    for (LongSamplingCounter[] cpuSpeeds : this.mCpuClusterSpeed) {
                        if (cpuSpeeds == null) continue;
                        for (LongSamplingCounter c : cpuSpeeds) {
                            if (c == null) continue;
                            c.detach();
                        }
                    }
                }
            }
            return !active;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
            int i;
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            int NW = wakeStats.size();
            out.writeInt(NW);
            for (int iw = 0; iw < NW; ++iw) {
                out.writeString(wakeStats.keyAt(iw));
                Wakelock wakelock = wakeStats.valueAt(iw);
                wakelock.writeToParcelLocked(out, elapsedRealtimeUs);
            }
            ArrayMap<String, StopwatchTimer> syncStats = this.mSyncStats.getMap();
            int NS = syncStats.size();
            out.writeInt(NS);
            for (int is = 0; is < NS; ++is) {
                out.writeString(syncStats.keyAt(is));
                StopwatchTimer timer = syncStats.valueAt(is);
                Timer.writeTimerToParcel(out, timer, elapsedRealtimeUs);
            }
            ArrayMap<String, StopwatchTimer> jobStats = this.mJobStats.getMap();
            int NJ = jobStats.size();
            out.writeInt(NJ);
            for (int ij = 0; ij < NJ; ++ij) {
                out.writeString(jobStats.keyAt(ij));
                StopwatchTimer timer = jobStats.valueAt(ij);
                Timer.writeTimerToParcel(out, timer, elapsedRealtimeUs);
            }
            int NSE = this.mSensorStats.size();
            out.writeInt(NSE);
            for (int ise = 0; ise < NSE; ++ise) {
                out.writeInt(this.mSensorStats.keyAt(ise));
                Sensor sensor = this.mSensorStats.valueAt(ise);
                sensor.writeToParcelLocked(out, elapsedRealtimeUs);
            }
            int NP = this.mProcessStats.size();
            out.writeInt(NP);
            for (int ip = 0; ip < NP; ++ip) {
                out.writeString(this.mProcessStats.keyAt(ip));
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.writeToParcelLocked(out);
            }
            out.writeInt(this.mPackageStats.size());
            for (Map.Entry<String, Pkg> pkgEntry : this.mPackageStats.entrySet()) {
                out.writeString(pkgEntry.getKey());
                Pkg pkg = pkgEntry.getValue();
                pkg.writeToParcelLocked(out);
            }
            if (this.mWifiRunningTimer != null) {
                out.writeInt(1);
                this.mWifiRunningTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mFullWifiLockTimer != null) {
                out.writeInt(1);
                this.mFullWifiLockTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiScanTimer != null) {
                out.writeInt(1);
                this.mWifiScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 5; ++i) {
                if (this.mWifiBatchedScanTimer[i] != null) {
                    out.writeInt(1);
                    this.mWifiBatchedScanTimer[i].writeToParcel(out, elapsedRealtimeUs);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mWifiMulticastTimer != null) {
                out.writeInt(1);
                this.mWifiMulticastTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                this.mAudioTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                this.mVideoTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mFlashlightTurnedOnTimer != null) {
                out.writeInt(1);
                this.mFlashlightTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mCameraTurnedOnTimer != null) {
                out.writeInt(1);
                this.mCameraTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mForegroundActivityTimer != null) {
                out.writeInt(1);
                this.mForegroundActivityTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothScanTimer != null) {
                out.writeInt(1);
                this.mBluetoothScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 6; ++i) {
                if (this.mProcessStateTimer[i] != null) {
                    out.writeInt(1);
                    this.mProcessStateTimer[i].writeToParcel(out, elapsedRealtimeUs);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mVibratorOnTimer != null) {
                out.writeInt(1);
                this.mVibratorOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mUserActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < 4; ++i) {
                    this.mUserActivityCounters[i].writeToParcel(out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.mNetworkByteActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < 6; ++i) {
                    this.mNetworkByteActivityCounters[i].writeToParcel(out);
                    this.mNetworkPacketActivityCounters[i].writeToParcel(out);
                }
                this.mMobileRadioActiveTime.writeToParcel(out);
                this.mMobileRadioActiveCount.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiControllerActivity != null) {
                out.writeInt(1);
                this.mWifiControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            if (this.mBluetoothControllerActivity != null) {
                out.writeInt(1);
                this.mBluetoothControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            if (this.mModemControllerActivity != null) {
                out.writeInt(1);
                this.mModemControllerActivity.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            this.mUserCpuTime.writeToParcel(out);
            this.mSystemCpuTime.writeToParcel(out);
            this.mCpuPower.writeToParcel(out);
            if (this.mCpuClusterSpeed != null) {
                out.writeInt(1);
                out.writeInt(this.mCpuClusterSpeed.length);
                for (LongSamplingCounter[] cpuSpeeds : this.mCpuClusterSpeed) {
                    if (cpuSpeeds != null) {
                        out.writeInt(1);
                        out.writeInt(cpuSpeeds.length);
                        for (LongSamplingCounter c : cpuSpeeds) {
                            if (c != null) {
                                out.writeInt(1);
                                c.writeToParcel(out);
                                continue;
                            }
                            out.writeInt(0);
                        }
                        continue;
                    }
                    out.writeInt(0);
                }
            } else {
                out.writeInt(0);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$readFromParcelLocked(TimeBase timeBase, TimeBase screenOffTimeBase, Parcel in) {
            int i;
            int numWakelocks = in.readInt();
            this.mWakelockStats.clear();
            for (int j = 0; j < numWakelocks; ++j) {
                String wakelockName = in.readString();
                Wakelock wakelock = new Wakelock(this.mBsi, this);
                wakelock.readFromParcelLocked(timeBase, screenOffTimeBase, in);
                this.mWakelockStats.add(wakelockName, wakelock);
            }
            int numSyncs = in.readInt();
            this.mSyncStats.clear();
            for (int j = 0; j < numSyncs; ++j) {
                String syncName = in.readString();
                if (in.readInt() == 0) continue;
                this.mSyncStats.add(syncName, new StopwatchTimer(this.mBsi.mClocks, this, 13, null, timeBase, in));
            }
            int numJobs = in.readInt();
            this.mJobStats.clear();
            for (int j = 0; j < numJobs; ++j) {
                String jobName = in.readString();
                if (in.readInt() == 0) continue;
                this.mJobStats.add(jobName, new StopwatchTimer(this.mBsi.mClocks, this, 14, null, timeBase, in));
            }
            int numSensors = in.readInt();
            this.mSensorStats.clear();
            for (int k = 0; k < numSensors; ++k) {
                int sensorNumber = in.readInt();
                Sensor sensor = new Sensor(this.mBsi, this, sensorNumber);
                sensor.readFromParcelLocked(this.mBsi.mOnBatteryTimeBase, in);
                this.mSensorStats.put(sensorNumber, sensor);
            }
            int numProcs = in.readInt();
            this.mProcessStats.clear();
            for (int k = 0; k < numProcs; ++k) {
                String processName = in.readString();
                Proc proc = new Proc(this.mBsi, processName);
                proc.readFromParcelLocked(in);
                this.mProcessStats.put(processName, proc);
            }
            int numPkgs = in.readInt();
            this.mPackageStats.clear();
            for (int l = 0; l < numPkgs; ++l) {
                String packageName = in.readString();
                Pkg pkg = new Pkg(this.mBsi);
                pkg.readFromParcelLocked(in);
                this.mPackageStats.put(packageName, pkg);
            }
            this.mWifiRunning = false;
            this.mWifiRunningTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 4, this.mBsi.mWifiRunningTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mFullWifiLockOut = false;
            this.mFullWifiLockTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 5, this.mBsi.mFullWifiLockTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mWifiScanStarted = false;
            this.mWifiScanTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 6, this.mBsi.mWifiScanTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mWifiBatchedScanBinStarted = -1;
            for (i = 0; i < 5; ++i) {
                if (in.readInt() != 0) {
                    this.makeWifiBatchedScanBin(i, in);
                    continue;
                }
                this.mWifiBatchedScanTimer[i] = null;
            }
            this.mWifiMulticastEnabled = false;
            this.mWifiMulticastTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 7, this.mBsi.mWifiMulticastTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mAudioTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 15, this.mBsi.mAudioTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mVideoTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 8, this.mBsi.mVideoTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mFlashlightTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 16, this.mBsi.mFlashlightTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mCameraTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 17, this.mBsi.mCameraTurnedOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mForegroundActivityTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 10, null, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mBluetoothScanTimer = in.readInt() != 0 ? new StopwatchTimer(this.mBsi.mClocks, this, 19, this.mBsi.mBluetoothScanOnTimers, this.mBsi.mOnBatteryTimeBase, in) : null;
            this.mProcessState = -1;
            for (i = 0; i < 6; ++i) {
                if (in.readInt() != 0) {
                    this.makeProcessState(i, in);
                    continue;
                }
                this.mProcessStateTimer[i] = null;
            }
            this.mVibratorOnTimer = in.readInt() != 0 ? new BatchTimer(this.mBsi.mClocks, this, 9, this.mBsi.mOnBatteryTimeBase, in) : null;
            if (in.readInt() != 0) {
                this.mUserActivityCounters = new Counter[4];
                for (i = 0; i < 4; ++i) {
                    this.mUserActivityCounters[i] = new Counter(this.mBsi.mOnBatteryTimeBase, in);
                }
            } else {
                this.mUserActivityCounters = null;
            }
            if (in.readInt() != 0) {
                this.mNetworkByteActivityCounters = new LongSamplingCounter[6];
                this.mNetworkPacketActivityCounters = new LongSamplingCounter[6];
                for (i = 0; i < 6; ++i) {
                    this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                    this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                }
                this.mMobileRadioActiveTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                this.mMobileRadioActiveCount = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            } else {
                this.mNetworkByteActivityCounters = null;
                this.mNetworkPacketActivityCounters = null;
            }
            this.mWifiControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 1, in) : null;
            this.mBluetoothControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 1, in) : null;
            this.mModemControllerActivity = in.readInt() != 0 ? new ControllerActivityCounterImpl(this.mBsi.mOnBatteryTimeBase, 5, in) : null;
            this.mUserCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            this.mSystemCpuTime = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            this.mCpuPower = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
            if (in.readInt() != 0) {
                int numCpuClusters = in.readInt();
                if (this.mBsi.mPowerProfile != null && this.mBsi.mPowerProfile.getNumCpuClusters() != numCpuClusters) {
                    throw new ParcelFormatException("Incompatible number of cpu clusters");
                }
                this.mCpuClusterSpeed = new LongSamplingCounter[numCpuClusters][];
                for (int cluster = 0; cluster < numCpuClusters; ++cluster) {
                    if (in.readInt() != 0) {
                        int numSpeeds = in.readInt();
                        if (this.mBsi.mPowerProfile != null && this.mBsi.mPowerProfile.getNumSpeedStepsInCpuCluster(cluster) != numSpeeds) {
                            throw new ParcelFormatException("Incompatible number of cpu speeds");
                        }
                        LongSamplingCounter[] cpuSpeeds = new LongSamplingCounter[numSpeeds];
                        this.mCpuClusterSpeed[cluster] = cpuSpeeds;
                        for (int speed = 0; speed < numSpeeds; ++speed) {
                            if (in.readInt() == 0) continue;
                            cpuSpeeds[speed] = new LongSamplingCounter(this.mBsi.mOnBatteryTimeBase, in);
                        }
                        continue;
                    }
                    this.mCpuClusterSpeed[cluster] = null;
                }
            } else {
                this.mCpuClusterSpeed = null;
            }
        }

        private final Proc $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getProcessStatsLocked(String name) {
            Proc ps = this.mProcessStats.get(name);
            if (ps == null) {
                ps = new Proc(this.mBsi, name);
                this.mProcessStats.put(name, ps);
            }
            return ps;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$updateUidProcessStateLocked(int procState) {
            int uidRunningState = procState == -1 ? -1 : (procState == 2 ? 0 : (procState <= 4 ? 1 : (procState <= 5 ? 2 : (procState <= 6 ? 3 : (procState <= 11 ? 4 : 5)))));
            if (this.mProcessState == uidRunningState) {
                return;
            }
            long elapsedRealtime = this.mBsi.mClocks.elapsedRealtime();
            if (this.mProcessState != -1) {
                this.mProcessStateTimer[this.mProcessState].stopRunningLocked(elapsedRealtime);
            }
            this.mProcessState = uidRunningState;
            if (uidRunningState != -1) {
                if (this.mProcessStateTimer[uidRunningState] == null) {
                    this.makeProcessState(uidRunningState, null);
                }
                this.mProcessStateTimer[uidRunningState].startRunningLocked(elapsedRealtime);
            }
        }

        private final SparseArray<? extends BatteryStats.Uid.Pid> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getPidStats() {
            return this.mPids;
        }

        private final BatteryStats.Uid.Pid $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getPidStatsLocked(int pid) {
            BatteryStats.Uid.Pid p = this.mPids.get(pid);
            if (p == null) {
                p = new BatteryStats.Uid.Pid(this);
                this.mPids.put(pid, p);
            }
            return p;
        }

        private final Pkg $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getPackageStatsLocked(String name) {
            Pkg ps = this.mPackageStats.get(name);
            if (ps == null) {
                ps = new Pkg(this.mBsi);
                this.mPackageStats.put(name, ps);
            }
            return ps;
        }

        private final Pkg.Serv $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getServiceStatsLocked(String pkg, String serv) {
            Pkg ps = this.getPackageStatsLocked(pkg);
            Pkg.Serv ss = ps.mServiceStats.get(serv);
            if (ss == null) {
                ss = ps.newServiceStatsLocked();
                ps.mServiceStats.put(serv, ss);
            }
            return ss;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$readSyncSummaryFromParcelLocked(String name, Parcel in) {
            StopwatchTimer timer = this.mSyncStats.instantiateObject();
            timer.readSummaryFromParcelLocked(in);
            this.mSyncStats.add(name, timer);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$readJobSummaryFromParcelLocked(String name, Parcel in) {
            StopwatchTimer timer = this.mJobStats.instantiateObject();
            timer.readSummaryFromParcelLocked(in);
            this.mJobStats.add(name, timer);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$readWakeSummaryFromParcelLocked(String wlName, Parcel in) {
            Wakelock wl = new Wakelock(this.mBsi, this);
            this.mWakelockStats.add(wlName, wl);
            if (in.readInt() != 0) {
                wl.getStopwatchTimer(1).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                wl.getStopwatchTimer(0).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                wl.getStopwatchTimer(2).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                wl.getStopwatchTimer(18).readSummaryFromParcelLocked(in);
            }
        }

        private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getSensorTimerLocked(int sensor, boolean create) {
            StopwatchTimer t;
            Sensor se = this.mSensorStats.get(sensor);
            if (se == null) {
                if (!create) {
                    return null;
                }
                se = new Sensor(this.mBsi, this, sensor);
                this.mSensorStats.put(sensor, se);
            }
            if ((t = se.mTimer) != null) {
                return t;
            }
            ArrayList<StopwatchTimer> timers = this.mBsi.mSensorTimers.get(sensor);
            if (timers == null) {
                timers = new ArrayList();
                this.mBsi.mSensorTimers.put(sensor, timers);
            }
            se.mTimer = t = new StopwatchTimer(this.mBsi.mClocks, this, 3, timers, this.mBsi.mOnBatteryTimeBase);
            return t;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartSyncLocked(String name, long elapsedRealtimeMs) {
            StopwatchTimer t = this.mSyncStats.startObject(name);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopSyncLocked(String name, long elapsedRealtimeMs) {
            StopwatchTimer t = this.mSyncStats.stopObject(name);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartJobLocked(String name, long elapsedRealtimeMs) {
            StopwatchTimer t = this.mJobStats.startObject(name);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopJobLocked(String name, long elapsedRealtimeMs) {
            StopwatchTimer t = this.mJobStats.stopObject(name);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartWakeLocked(int pid, String name, int type, long elapsedRealtimeMs) {
            Wakelock wl = this.mWakelockStats.startObject(name);
            if (wl != null) {
                wl.getStopwatchTimer(type).startRunningLocked(elapsedRealtimeMs);
            }
            if (pid >= 0 && type == 0) {
                BatteryStats.Uid.Pid p = this.getPidStatsLocked(pid);
                if (p.mWakeNesting++ == 0) {
                    p.mWakeStartMs = elapsedRealtimeMs;
                }
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopWakeLocked(int pid, String name, int type, long elapsedRealtimeMs) {
            BatteryStats.Uid.Pid p;
            Wakelock wl = this.mWakelockStats.stopObject(name);
            if (wl != null) {
                wl.getStopwatchTimer(type).stopRunningLocked(elapsedRealtimeMs);
            }
            if (pid >= 0 && type == 0 && (p = this.mPids.get(pid)) != null && p.mWakeNesting > 0 && p.mWakeNesting-- == 1) {
                p.mWakeSumMs += elapsedRealtimeMs - p.mWakeStartMs;
                p.mWakeStartMs = 0L;
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$reportExcessiveWakeLocked(String proc, long overTime, long usedTime) {
            Proc p = this.getProcessStatsLocked(proc);
            if (p != null) {
                p.addExcessiveWake(overTime, usedTime);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$reportExcessiveCpuLocked(String proc, long overTime, long usedTime) {
            Proc p = this.getProcessStatsLocked(proc);
            if (p != null) {
                p.addExcessiveCpu(overTime, usedTime);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartSensor(int sensor, long elapsedRealtimeMs) {
            StopwatchTimer t = this.getSensorTimerLocked(sensor, true);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopSensor(int sensor, long elapsedRealtimeMs) {
            StopwatchTimer t = this.getSensorTimerLocked(sensor, false);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartGps(long elapsedRealtimeMs) {
            StopwatchTimer t = this.getSensorTimerLocked(-10000, true);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopGps(long elapsedRealtimeMs) {
            StopwatchTimer t = this.getSensorTimerLocked(-10000, false);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private final BatteryStatsImpl $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getBatteryStats() {
            return this.mBsi;
        }

        private void __constructor__(BatteryStatsImpl batteryStatsImpl, int n) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid$__constructor__(batteryStatsImpl, n);
        }

        public Uid(BatteryStatsImpl batteryStatsImpl, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$__constructor__(com.android.internal.os.BatteryStatsImpl int ), 0, this, batteryStatsImpl, n);
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Uid.Wakelock> getWakelockStats() {
            return InvokeDynamicSupport.bootstrap("getWakelockStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWakelockStats(), 0, this);
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Timer> getSyncStats() {
            return InvokeDynamicSupport.bootstrap("getSyncStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getSyncStats(), 0, this);
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Timer> getJobStats() {
            return InvokeDynamicSupport.bootstrap("getJobStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getJobStats(), 0, this);
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Sensor> getSensorStats() {
            return InvokeDynamicSupport.bootstrap("getSensorStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getSensorStats(), 0, this);
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Uid.Proc> getProcessStats() {
            return InvokeDynamicSupport.bootstrap("getProcessStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getProcessStats(), 0, this);
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Uid.Pkg> getPackageStats() {
            return InvokeDynamicSupport.bootstrap("getPackageStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getPackageStats(), 0, this);
        }

        @Override
        public int getUid() {
            return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getUid(), 0, this);
        }

        @Override
        public void noteWifiRunningLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteWifiRunningLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiRunningLocked(long ), 0, this, l);
        }

        @Override
        public void noteWifiStoppedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteWifiStoppedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiStoppedLocked(long ), 0, this, l);
        }

        @Override
        public void noteFullWifiLockAcquiredLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteFullWifiLockAcquiredLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteFullWifiLockAcquiredLocked(long ), 0, this, l);
        }

        @Override
        public void noteFullWifiLockReleasedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteFullWifiLockReleasedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteFullWifiLockReleasedLocked(long ), 0, this, l);
        }

        @Override
        public void noteWifiScanStartedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteWifiScanStartedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiScanStartedLocked(long ), 0, this, l);
        }

        @Override
        public void noteWifiScanStoppedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteWifiScanStoppedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiScanStoppedLocked(long ), 0, this, l);
        }

        @Override
        public void noteWifiBatchedScanStartedLocked(int n, long l) {
            InvokeDynamicSupport.bootstrap("noteWifiBatchedScanStartedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiBatchedScanStartedLocked(int long ), 0, this, n, l);
        }

        @Override
        public void noteWifiBatchedScanStoppedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteWifiBatchedScanStoppedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiBatchedScanStoppedLocked(long ), 0, this, l);
        }

        @Override
        public void noteWifiMulticastEnabledLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteWifiMulticastEnabledLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiMulticastEnabledLocked(long ), 0, this, l);
        }

        @Override
        public void noteWifiMulticastDisabledLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteWifiMulticastDisabledLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteWifiMulticastDisabledLocked(long ), 0, this, l);
        }

        @Override
        public BatteryStats.ControllerActivityCounter getWifiControllerActivity() {
            return InvokeDynamicSupport.bootstrap("getWifiControllerActivity", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiControllerActivity(), 0, this);
        }

        @Override
        public BatteryStats.ControllerActivityCounter getBluetoothControllerActivity() {
            return InvokeDynamicSupport.bootstrap("getBluetoothControllerActivity", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getBluetoothControllerActivity(), 0, this);
        }

        @Override
        public BatteryStats.ControllerActivityCounter getModemControllerActivity() {
            return InvokeDynamicSupport.bootstrap("getModemControllerActivity", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getModemControllerActivity(), 0, this);
        }

        public ControllerActivityCounterImpl getOrCreateWifiControllerActivityLocked() {
            return InvokeDynamicSupport.bootstrap("getOrCreateWifiControllerActivityLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getOrCreateWifiControllerActivityLocked(), 0, this);
        }

        public ControllerActivityCounterImpl getOrCreateBluetoothControllerActivityLocked() {
            return InvokeDynamicSupport.bootstrap("getOrCreateBluetoothControllerActivityLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getOrCreateBluetoothControllerActivityLocked(), 0, this);
        }

        public ControllerActivityCounterImpl getOrCreateModemControllerActivityLocked() {
            return InvokeDynamicSupport.bootstrap("getOrCreateModemControllerActivityLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getOrCreateModemControllerActivityLocked(), 0, this);
        }

        public StopwatchTimer createAudioTurnedOnTimerLocked() {
            return InvokeDynamicSupport.bootstrap("createAudioTurnedOnTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createAudioTurnedOnTimerLocked(), 0, this);
        }

        public void noteAudioTurnedOnLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteAudioTurnedOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteAudioTurnedOnLocked(long ), 0, this, l);
        }

        public void noteAudioTurnedOffLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteAudioTurnedOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteAudioTurnedOffLocked(long ), 0, this, l);
        }

        public void noteResetAudioLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteResetAudioLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetAudioLocked(long ), 0, this, l);
        }

        public StopwatchTimer createVideoTurnedOnTimerLocked() {
            return InvokeDynamicSupport.bootstrap("createVideoTurnedOnTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createVideoTurnedOnTimerLocked(), 0, this);
        }

        public void noteVideoTurnedOnLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteVideoTurnedOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteVideoTurnedOnLocked(long ), 0, this, l);
        }

        public void noteVideoTurnedOffLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteVideoTurnedOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteVideoTurnedOffLocked(long ), 0, this, l);
        }

        public void noteResetVideoLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteResetVideoLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetVideoLocked(long ), 0, this, l);
        }

        public StopwatchTimer createFlashlightTurnedOnTimerLocked() {
            return InvokeDynamicSupport.bootstrap("createFlashlightTurnedOnTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createFlashlightTurnedOnTimerLocked(), 0, this);
        }

        public void noteFlashlightTurnedOnLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteFlashlightTurnedOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteFlashlightTurnedOnLocked(long ), 0, this, l);
        }

        public void noteFlashlightTurnedOffLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteFlashlightTurnedOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteFlashlightTurnedOffLocked(long ), 0, this, l);
        }

        public void noteResetFlashlightLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteResetFlashlightLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetFlashlightLocked(long ), 0, this, l);
        }

        public StopwatchTimer createCameraTurnedOnTimerLocked() {
            return InvokeDynamicSupport.bootstrap("createCameraTurnedOnTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createCameraTurnedOnTimerLocked(), 0, this);
        }

        public void noteCameraTurnedOnLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteCameraTurnedOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteCameraTurnedOnLocked(long ), 0, this, l);
        }

        public void noteCameraTurnedOffLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteCameraTurnedOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteCameraTurnedOffLocked(long ), 0, this, l);
        }

        public void noteResetCameraLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteResetCameraLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetCameraLocked(long ), 0, this, l);
        }

        public StopwatchTimer createForegroundActivityTimerLocked() {
            return InvokeDynamicSupport.bootstrap("createForegroundActivityTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createForegroundActivityTimerLocked(), 0, this);
        }

        public StopwatchTimer createBluetoothScanTimerLocked() {
            return InvokeDynamicSupport.bootstrap("createBluetoothScanTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createBluetoothScanTimerLocked(), 0, this);
        }

        public void noteBluetoothScanStartedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteBluetoothScanStartedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteBluetoothScanStartedLocked(long ), 0, this, l);
        }

        public void noteBluetoothScanStoppedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteBluetoothScanStoppedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteBluetoothScanStoppedLocked(long ), 0, this, l);
        }

        public void noteResetBluetoothScanLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteResetBluetoothScanLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteResetBluetoothScanLocked(long ), 0, this, l);
        }

        @Override
        public void noteActivityResumedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteActivityResumedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteActivityResumedLocked(long ), 0, this, l);
        }

        @Override
        public void noteActivityPausedLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteActivityPausedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteActivityPausedLocked(long ), 0, this, l);
        }

        public BatchTimer createVibratorOnTimerLocked() {
            return InvokeDynamicSupport.bootstrap("createVibratorOnTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$createVibratorOnTimerLocked(), 0, this);
        }

        public void noteVibratorOnLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteVibratorOnLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteVibratorOnLocked(long ), 0, this, l);
        }

        public void noteVibratorOffLocked() {
            InvokeDynamicSupport.bootstrap("noteVibratorOffLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteVibratorOffLocked(), 0, this);
        }

        @Override
        public long getWifiRunningTime(long l, int n) {
            return (long)InvokeDynamicSupport.bootstrap("getWifiRunningTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiRunningTime(long int ), 0, this, l, n);
        }

        @Override
        public long getFullWifiLockTime(long l, int n) {
            return (long)InvokeDynamicSupport.bootstrap("getFullWifiLockTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getFullWifiLockTime(long int ), 0, this, l, n);
        }

        @Override
        public long getWifiScanTime(long l, int n) {
            return (long)InvokeDynamicSupport.bootstrap("getWifiScanTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiScanTime(long int ), 0, this, l, n);
        }

        @Override
        public int getWifiScanCount(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getWifiScanCount", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiScanCount(int ), 0, this, n);
        }

        @Override
        public long getWifiBatchedScanTime(int n, long l, int n2) {
            return (long)InvokeDynamicSupport.bootstrap("getWifiBatchedScanTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiBatchedScanTime(int long int ), 0, this, n, l, n2);
        }

        @Override
        public int getWifiBatchedScanCount(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("getWifiBatchedScanCount", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiBatchedScanCount(int int ), 0, this, n, n2);
        }

        @Override
        public long getWifiMulticastTime(long l, int n) {
            return (long)InvokeDynamicSupport.bootstrap("getWifiMulticastTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getWifiMulticastTime(long int ), 0, this, l, n);
        }

        @Override
        public Timer getAudioTurnedOnTimer() {
            return InvokeDynamicSupport.bootstrap("getAudioTurnedOnTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getAudioTurnedOnTimer(), 0, this);
        }

        @Override
        public Timer getVideoTurnedOnTimer() {
            return InvokeDynamicSupport.bootstrap("getVideoTurnedOnTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getVideoTurnedOnTimer(), 0, this);
        }

        @Override
        public Timer getFlashlightTurnedOnTimer() {
            return InvokeDynamicSupport.bootstrap("getFlashlightTurnedOnTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getFlashlightTurnedOnTimer(), 0, this);
        }

        @Override
        public Timer getCameraTurnedOnTimer() {
            return InvokeDynamicSupport.bootstrap("getCameraTurnedOnTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getCameraTurnedOnTimer(), 0, this);
        }

        @Override
        public Timer getForegroundActivityTimer() {
            return InvokeDynamicSupport.bootstrap("getForegroundActivityTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getForegroundActivityTimer(), 0, this);
        }

        @Override
        public Timer getBluetoothScanTimer() {
            return InvokeDynamicSupport.bootstrap("getBluetoothScanTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getBluetoothScanTimer(), 0, this);
        }

        void makeProcessState(int n, Parcel parcel) {
            InvokeDynamicSupport.bootstrap("makeProcessState", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$makeProcessState(int android.os.Parcel ), 0, this, n, parcel);
        }

        @Override
        public long getProcessStateTime(int n, long l, int n2) {
            return (long)InvokeDynamicSupport.bootstrap("getProcessStateTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getProcessStateTime(int long int ), 0, this, n, l, n2);
        }

        @Override
        public Timer getProcessStateTimer(int n) {
            return InvokeDynamicSupport.bootstrap("getProcessStateTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getProcessStateTimer(int ), 0, this, n);
        }

        @Override
        public Timer getVibratorOnTimer() {
            return InvokeDynamicSupport.bootstrap("getVibratorOnTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getVibratorOnTimer(), 0, this);
        }

        @Override
        public void noteUserActivityLocked(int n) {
            InvokeDynamicSupport.bootstrap("noteUserActivityLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteUserActivityLocked(int ), 0, this, n);
        }

        @Override
        public boolean hasUserActivity() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasUserActivity", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$hasUserActivity(), 0, this);
        }

        @Override
        public int getUserActivityCount(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("getUserActivityCount", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getUserActivityCount(int int ), 0, this, n, n2);
        }

        void makeWifiBatchedScanBin(int n, Parcel parcel) {
            InvokeDynamicSupport.bootstrap("makeWifiBatchedScanBin", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$makeWifiBatchedScanBin(int android.os.Parcel ), 0, this, n, parcel);
        }

        void initUserActivityLocked() {
            InvokeDynamicSupport.bootstrap("initUserActivityLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$initUserActivityLocked(), 0, this);
        }

        void noteNetworkActivityLocked(int n, long l, long l2) {
            InvokeDynamicSupport.bootstrap("noteNetworkActivityLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteNetworkActivityLocked(int long long ), 0, this, n, l, l2);
        }

        void noteMobileRadioActiveTimeLocked(long l) {
            InvokeDynamicSupport.bootstrap("noteMobileRadioActiveTimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteMobileRadioActiveTimeLocked(long ), 0, this, l);
        }

        @Override
        public boolean hasNetworkActivity() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNetworkActivity", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$hasNetworkActivity(), 0, this);
        }

        @Override
        public long getNetworkActivityBytes(int n, int n2) {
            return (long)InvokeDynamicSupport.bootstrap("getNetworkActivityBytes", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getNetworkActivityBytes(int int ), 0, this, n, n2);
        }

        @Override
        public long getNetworkActivityPackets(int n, int n2) {
            return (long)InvokeDynamicSupport.bootstrap("getNetworkActivityPackets", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getNetworkActivityPackets(int int ), 0, this, n, n2);
        }

        @Override
        public long getMobileRadioActiveTime(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getMobileRadioActiveTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getMobileRadioActiveTime(int ), 0, this, n);
        }

        @Override
        public int getMobileRadioActiveCount(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getMobileRadioActiveCount", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getMobileRadioActiveCount(int ), 0, this, n);
        }

        @Override
        public long getUserCpuTimeUs(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getUserCpuTimeUs", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getUserCpuTimeUs(int ), 0, this, n);
        }

        @Override
        public long getSystemCpuTimeUs(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getSystemCpuTimeUs", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getSystemCpuTimeUs(int ), 0, this, n);
        }

        @Override
        public long getCpuPowerMaUs(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getCpuPowerMaUs", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getCpuPowerMaUs(int ), 0, this, n);
        }

        @Override
        public long getTimeAtCpuSpeed(int n, int n2, int n3) {
            return (long)InvokeDynamicSupport.bootstrap("getTimeAtCpuSpeed", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getTimeAtCpuSpeed(int int int ), 0, this, n, n2, n3);
        }

        void initNetworkActivityLocked() {
            InvokeDynamicSupport.bootstrap("initNetworkActivityLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$initNetworkActivityLocked(), 0, this);
        }

        boolean reset() {
            return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$reset(), 0, this);
        }

        void writeToParcelLocked(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeToParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$writeToParcelLocked(android.os.Parcel long ), 0, this, parcel, l);
        }

        void readFromParcelLocked(TimeBase timeBase, TimeBase timeBase2, Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$readFromParcelLocked(com.android.internal.os.BatteryStatsImpl$TimeBase com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, timeBase, timeBase2, parcel);
        }

        public Proc getProcessStatsLocked(String string2) {
            return InvokeDynamicSupport.bootstrap("getProcessStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getProcessStatsLocked(java.lang.String ), 0, this, string2);
        }

        public void updateUidProcessStateLocked(int n) {
            InvokeDynamicSupport.bootstrap("updateUidProcessStateLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$updateUidProcessStateLocked(int ), 0, this, n);
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Pid> getPidStats() {
            return InvokeDynamicSupport.bootstrap("getPidStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getPidStats(), 0, this);
        }

        public BatteryStats.Uid.Pid getPidStatsLocked(int n) {
            return InvokeDynamicSupport.bootstrap("getPidStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getPidStatsLocked(int ), 0, this, n);
        }

        public Pkg getPackageStatsLocked(String string2) {
            return InvokeDynamicSupport.bootstrap("getPackageStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getPackageStatsLocked(java.lang.String ), 0, this, string2);
        }

        public Pkg.Serv getServiceStatsLocked(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getServiceStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getServiceStatsLocked(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public void readSyncSummaryFromParcelLocked(String string2, Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readSyncSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$readSyncSummaryFromParcelLocked(java.lang.String android.os.Parcel ), 0, this, string2, parcel);
        }

        public void readJobSummaryFromParcelLocked(String string2, Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readJobSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$readJobSummaryFromParcelLocked(java.lang.String android.os.Parcel ), 0, this, string2, parcel);
        }

        public void readWakeSummaryFromParcelLocked(String string2, Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readWakeSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$readWakeSummaryFromParcelLocked(java.lang.String android.os.Parcel ), 0, this, string2, parcel);
        }

        public StopwatchTimer getSensorTimerLocked(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("getSensorTimerLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getSensorTimerLocked(int boolean ), 0, this, n, bl);
        }

        public void noteStartSyncLocked(String string2, long l) {
            InvokeDynamicSupport.bootstrap("noteStartSyncLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartSyncLocked(java.lang.String long ), 0, this, string2, l);
        }

        public void noteStopSyncLocked(String string2, long l) {
            InvokeDynamicSupport.bootstrap("noteStopSyncLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopSyncLocked(java.lang.String long ), 0, this, string2, l);
        }

        public void noteStartJobLocked(String string2, long l) {
            InvokeDynamicSupport.bootstrap("noteStartJobLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartJobLocked(java.lang.String long ), 0, this, string2, l);
        }

        public void noteStopJobLocked(String string2, long l) {
            InvokeDynamicSupport.bootstrap("noteStopJobLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopJobLocked(java.lang.String long ), 0, this, string2, l);
        }

        public void noteStartWakeLocked(int n, String string2, int n2, long l) {
            InvokeDynamicSupport.bootstrap("noteStartWakeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartWakeLocked(int java.lang.String int long ), 0, this, n, string2, n2, l);
        }

        public void noteStopWakeLocked(int n, String string2, int n2, long l) {
            InvokeDynamicSupport.bootstrap("noteStopWakeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopWakeLocked(int java.lang.String int long ), 0, this, n, string2, n2, l);
        }

        public void reportExcessiveWakeLocked(String string2, long l, long l2) {
            InvokeDynamicSupport.bootstrap("reportExcessiveWakeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$reportExcessiveWakeLocked(java.lang.String long long ), 0, this, string2, l, l2);
        }

        public void reportExcessiveCpuLocked(String string2, long l, long l2) {
            InvokeDynamicSupport.bootstrap("reportExcessiveCpuLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$reportExcessiveCpuLocked(java.lang.String long long ), 0, this, string2, l, l2);
        }

        public void noteStartSensor(int n, long l) {
            InvokeDynamicSupport.bootstrap("noteStartSensor", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartSensor(int long ), 0, this, n, l);
        }

        public void noteStopSensor(int n, long l) {
            InvokeDynamicSupport.bootstrap("noteStopSensor", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopSensor(int long ), 0, this, n, l);
        }

        public void noteStartGps(long l) {
            InvokeDynamicSupport.bootstrap("noteStartGps", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStartGps(long ), 0, this, l);
        }

        public void noteStopGps(long l) {
            InvokeDynamicSupport.bootstrap("noteStopGps", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$noteStopGps(long ), 0, this, l);
        }

        public BatteryStatsImpl getBatteryStats() {
            return InvokeDynamicSupport.bootstrap("getBatteryStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid$getBatteryStats(), 0, this);
        }

        public /* synthetic */ Uid() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Uid)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Pkg
        extends BatteryStats.Uid.Pkg
        implements TimeBaseObs,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            protected BatteryStatsImpl mBsi;
            ArrayMap<String, Counter> mWakeupAlarms;
            ArrayMap<String, Serv> mServiceStats;

            private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$__constructor__(BatteryStatsImpl bsi) {
                this.mWakeupAlarms = new ArrayMap();
                this.mServiceStats = new ArrayMap();
                this.mBsi = bsi;
                this.mBsi.mOnBatteryScreenOffTimeBase.add(this);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$detach() {
                this.mBsi.mOnBatteryScreenOffTimeBase.remove(this);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$readFromParcelLocked(Parcel in) {
                int numWA = in.readInt();
                this.mWakeupAlarms.clear();
                for (int i = 0; i < numWA; ++i) {
                    String tag = in.readString();
                    this.mWakeupAlarms.put(tag, new Counter(this.mBsi.mOnBatteryTimeBase, in));
                }
                int numServs = in.readInt();
                this.mServiceStats.clear();
                for (int m = 0; m < numServs; ++m) {
                    String serviceName = in.readString();
                    Serv serv = new Serv(this.mBsi);
                    this.mServiceStats.put(serviceName, serv);
                    serv.readFromParcelLocked(in);
                }
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$writeToParcelLocked(Parcel out) {
                int numWA = this.mWakeupAlarms.size();
                out.writeInt(numWA);
                for (int i = 0; i < numWA; ++i) {
                    out.writeString(this.mWakeupAlarms.keyAt(i));
                    this.mWakeupAlarms.valueAt(i).writeToParcel(out);
                }
                int NS = this.mServiceStats.size();
                out.writeInt(NS);
                for (int i = 0; i < NS; ++i) {
                    out.writeString(this.mServiceStats.keyAt(i));
                    Serv serv = this.mServiceStats.valueAt(i);
                    serv.writeToParcelLocked(out);
                }
            }

            private final ArrayMap<String, ? extends BatteryStats.Counter> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$getWakeupAlarmStats() {
                return this.mWakeupAlarms;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$noteWakeupAlarmLocked(String tag) {
                Counter c = this.mWakeupAlarms.get(tag);
                if (c == null) {
                    c = new Counter(this.mBsi.mOnBatteryTimeBase);
                    this.mWakeupAlarms.put(tag, c);
                }
                c.stepAtomic();
            }

            private final ArrayMap<String, ? extends BatteryStats.Uid.Pkg.Serv> $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$getServiceStats() {
                return this.mServiceStats;
            }

            private final Serv $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$newServiceStatsLocked() {
                return new Serv(this.mBsi);
            }

            private void __constructor__(BatteryStatsImpl batteryStatsImpl) {
                this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$__constructor__(batteryStatsImpl);
            }

            public Pkg(BatteryStatsImpl batteryStatsImpl) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$__constructor__(com.android.internal.os.BatteryStatsImpl ), 0, this, batteryStatsImpl);
            }

            @Override
            public void onTimeStarted(long l, long l2, long l3) {
                InvokeDynamicSupport.bootstrap("onTimeStarted", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$onTimeStarted(long long long ), 0, this, l, l2, l3);
            }

            @Override
            public void onTimeStopped(long l, long l2, long l3) {
                InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$onTimeStopped(long long long ), 0, this, l, l2, l3);
            }

            void detach() {
                InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$detach(), 0, this);
            }

            void readFromParcelLocked(Parcel parcel) {
                InvokeDynamicSupport.bootstrap("readFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$readFromParcelLocked(android.os.Parcel ), 0, this, parcel);
            }

            void writeToParcelLocked(Parcel parcel) {
                InvokeDynamicSupport.bootstrap("writeToParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$writeToParcelLocked(android.os.Parcel ), 0, this, parcel);
            }

            @Override
            public ArrayMap<String, ? extends BatteryStats.Counter> getWakeupAlarmStats() {
                return InvokeDynamicSupport.bootstrap("getWakeupAlarmStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$getWakeupAlarmStats(), 0, this);
            }

            public void noteWakeupAlarmLocked(String string2) {
                InvokeDynamicSupport.bootstrap("noteWakeupAlarmLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$noteWakeupAlarmLocked(java.lang.String ), 0, this, string2);
            }

            @Override
            public ArrayMap<String, ? extends BatteryStats.Uid.Pkg.Serv> getServiceStats() {
                return InvokeDynamicSupport.bootstrap("getServiceStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$getServiceStats(), 0, this);
            }

            Serv newServiceStatsLocked() {
                return InvokeDynamicSupport.bootstrap("newServiceStatsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg$newServiceStatsLocked(), 0, this);
            }

            public /* synthetic */ Pkg() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Pkg)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }

            public static class Serv
            extends BatteryStats.Uid.Pkg.Serv
            implements TimeBaseObs,
            ShadowedObject {
                public transient /* synthetic */ Object __robo_data__;
                protected BatteryStatsImpl mBsi;
                protected Pkg mPkg;
                protected long mStartTime;
                protected long mRunningSince;
                protected boolean mRunning;
                protected int mStarts;
                protected long mLaunchedTime;
                protected long mLaunchedSince;
                protected boolean mLaunched;
                protected int mLaunches;
                protected long mLoadedStartTime;
                protected int mLoadedStarts;
                protected int mLoadedLaunches;
                protected long mLastStartTime;
                protected int mLastStarts;
                protected int mLastLaunches;
                protected long mUnpluggedStartTime;
                protected int mUnpluggedStarts;
                protected int mUnpluggedLaunches;

                private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$__constructor__(BatteryStatsImpl bsi) {
                    this.mBsi = bsi;
                    this.mBsi.mOnBatteryTimeBase.add(this);
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
                    this.mUnpluggedStartTime = this.getStartTimeToNowLocked(baseUptime);
                    this.mUnpluggedStarts = this.mStarts;
                    this.mUnpluggedLaunches = this.mLaunches;
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$detach() {
                    this.mBsi.mOnBatteryTimeBase.remove(this);
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$readFromParcelLocked(Parcel in) {
                    this.mStartTime = in.readLong();
                    this.mRunningSince = in.readLong();
                    this.mRunning = in.readInt() != 0;
                    this.mStarts = in.readInt();
                    this.mLaunchedTime = in.readLong();
                    this.mLaunchedSince = in.readLong();
                    this.mLaunched = in.readInt() != 0;
                    this.mLaunches = in.readInt();
                    this.mLoadedStartTime = in.readLong();
                    this.mLoadedStarts = in.readInt();
                    this.mLoadedLaunches = in.readInt();
                    this.mLastStartTime = 0L;
                    this.mLastStarts = 0;
                    this.mLastLaunches = 0;
                    this.mUnpluggedStartTime = in.readLong();
                    this.mUnpluggedStarts = in.readInt();
                    this.mUnpluggedLaunches = in.readInt();
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$writeToParcelLocked(Parcel out) {
                    out.writeLong(this.mStartTime);
                    out.writeLong(this.mRunningSince);
                    out.writeInt(this.mRunning ? 1 : 0);
                    out.writeInt(this.mStarts);
                    out.writeLong(this.mLaunchedTime);
                    out.writeLong(this.mLaunchedSince);
                    out.writeInt(this.mLaunched ? 1 : 0);
                    out.writeInt(this.mLaunches);
                    out.writeLong(this.mLoadedStartTime);
                    out.writeInt(this.mLoadedStarts);
                    out.writeInt(this.mLoadedLaunches);
                    out.writeLong(this.mUnpluggedStartTime);
                    out.writeInt(this.mUnpluggedStarts);
                    out.writeInt(this.mUnpluggedLaunches);
                }

                private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getLaunchTimeToNowLocked(long batteryUptime) {
                    if (!this.mLaunched) {
                        return this.mLaunchedTime;
                    }
                    return this.mLaunchedTime + batteryUptime - this.mLaunchedSince;
                }

                private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getStartTimeToNowLocked(long batteryUptime) {
                    if (!this.mRunning) {
                        return this.mStartTime;
                    }
                    return this.mStartTime + batteryUptime - this.mRunningSince;
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$startLaunchedLocked() {
                    if (!this.mLaunched) {
                        ++this.mLaunches;
                        this.mLaunchedSince = this.mBsi.getBatteryUptimeLocked();
                        this.mLaunched = true;
                    }
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$stopLaunchedLocked() {
                    if (this.mLaunched) {
                        long time = this.mBsi.getBatteryUptimeLocked() - this.mLaunchedSince;
                        if (time > 0L) {
                            this.mLaunchedTime += time;
                        } else {
                            --this.mLaunches;
                        }
                        this.mLaunched = false;
                    }
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$startRunningLocked() {
                    if (!this.mRunning) {
                        ++this.mStarts;
                        this.mRunningSince = this.mBsi.getBatteryUptimeLocked();
                        this.mRunning = true;
                    }
                }

                private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$stopRunningLocked() {
                    if (this.mRunning) {
                        long time = this.mBsi.getBatteryUptimeLocked() - this.mRunningSince;
                        if (time > 0L) {
                            this.mStartTime += time;
                        } else {
                            --this.mStarts;
                        }
                        this.mRunning = false;
                    }
                }

                private final BatteryStatsImpl $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getBatteryStats() {
                    return this.mBsi;
                }

                private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getLaunches(int which) {
                    int val = this.mLaunches;
                    if (which == 1) {
                        val -= this.mLoadedLaunches;
                    } else if (which == 2) {
                        val -= this.mUnpluggedLaunches;
                    }
                    return val;
                }

                private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getStartTime(long now, int which) {
                    long val = this.getStartTimeToNowLocked(now);
                    if (which == 1) {
                        val -= this.mLoadedStartTime;
                    } else if (which == 2) {
                        val -= this.mUnpluggedStartTime;
                    }
                    return val;
                }

                private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getStarts(int which) {
                    int val = this.mStarts;
                    if (which == 1) {
                        val -= this.mLoadedStarts;
                    } else if (which == 2) {
                        val -= this.mUnpluggedStarts;
                    }
                    return val;
                }

                private void __constructor__(BatteryStatsImpl batteryStatsImpl) {
                    this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$__constructor__(batteryStatsImpl);
                }

                public Serv(BatteryStatsImpl batteryStatsImpl) {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$__constructor__(com.android.internal.os.BatteryStatsImpl ), 0, this, batteryStatsImpl);
                }

                @Override
                public void onTimeStarted(long l, long l2, long l3) {
                    InvokeDynamicSupport.bootstrap("onTimeStarted", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$onTimeStarted(long long long ), 0, this, l, l2, l3);
                }

                @Override
                public void onTimeStopped(long l, long l2, long l3) {
                    InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$onTimeStopped(long long long ), 0, this, l, l2, l3);
                }

                public void detach() {
                    InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$detach(), 0, this);
                }

                public void readFromParcelLocked(Parcel parcel) {
                    InvokeDynamicSupport.bootstrap("readFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$readFromParcelLocked(android.os.Parcel ), 0, this, parcel);
                }

                public void writeToParcelLocked(Parcel parcel) {
                    InvokeDynamicSupport.bootstrap("writeToParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$writeToParcelLocked(android.os.Parcel ), 0, this, parcel);
                }

                public long getLaunchTimeToNowLocked(long l) {
                    return (long)InvokeDynamicSupport.bootstrap("getLaunchTimeToNowLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getLaunchTimeToNowLocked(long ), 0, this, l);
                }

                public long getStartTimeToNowLocked(long l) {
                    return (long)InvokeDynamicSupport.bootstrap("getStartTimeToNowLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getStartTimeToNowLocked(long ), 0, this, l);
                }

                public void startLaunchedLocked() {
                    InvokeDynamicSupport.bootstrap("startLaunchedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$startLaunchedLocked(), 0, this);
                }

                public void stopLaunchedLocked() {
                    InvokeDynamicSupport.bootstrap("stopLaunchedLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$stopLaunchedLocked(), 0, this);
                }

                public void startRunningLocked() {
                    InvokeDynamicSupport.bootstrap("startRunningLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$startRunningLocked(), 0, this);
                }

                public void stopRunningLocked() {
                    InvokeDynamicSupport.bootstrap("stopRunningLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$stopRunningLocked(), 0, this);
                }

                public BatteryStatsImpl getBatteryStats() {
                    return InvokeDynamicSupport.bootstrap("getBatteryStats", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getBatteryStats(), 0, this);
                }

                @Override
                public int getLaunches(int n) {
                    return (int)InvokeDynamicSupport.bootstrap("getLaunches", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getLaunches(int ), 0, this, n);
                }

                @Override
                public long getStartTime(long l, int n) {
                    return (long)InvokeDynamicSupport.bootstrap("getStartTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getStartTime(long int ), 0, this, l, n);
                }

                @Override
                public int getStarts(int n) {
                    return (int)InvokeDynamicSupport.bootstrap("getStarts", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Pkg_Serv$getStarts(int ), 0, this, n);
                }

                public /* synthetic */ Serv() {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Serv)this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }
        }

        public static class Proc
        extends BatteryStats.Uid.Proc
        implements TimeBaseObs,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            protected BatteryStatsImpl mBsi;
            String mName;
            boolean mActive;
            long mUserTime;
            long mSystemTime;
            long mForegroundTime;
            int mStarts;
            int mNumCrashes;
            int mNumAnrs;
            long mLoadedUserTime;
            long mLoadedSystemTime;
            long mLoadedForegroundTime;
            int mLoadedStarts;
            int mLoadedNumCrashes;
            int mLoadedNumAnrs;
            long mUnpluggedUserTime;
            long mUnpluggedSystemTime;
            long mUnpluggedForegroundTime;
            int mUnpluggedStarts;
            int mUnpluggedNumCrashes;
            int mUnpluggedNumAnrs;
            ArrayList<BatteryStats.Uid.Proc.ExcessivePower> mExcessivePower;

            private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$__constructor__(BatteryStatsImpl bsi, String name) {
                this.mActive = true;
                this.mBsi = bsi;
                this.mName = name;
                this.mBsi.mOnBatteryTimeBase.add(this);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
                this.mUnpluggedUserTime = this.mUserTime;
                this.mUnpluggedSystemTime = this.mSystemTime;
                this.mUnpluggedForegroundTime = this.mForegroundTime;
                this.mUnpluggedStarts = this.mStarts;
                this.mUnpluggedNumCrashes = this.mNumCrashes;
                this.mUnpluggedNumAnrs = this.mNumAnrs;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$detach() {
                this.mActive = false;
                this.mBsi.mOnBatteryTimeBase.remove(this);
            }

            private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$countExcessivePowers() {
                return this.mExcessivePower != null ? this.mExcessivePower.size() : 0;
            }

            private final BatteryStats.Uid.Proc.ExcessivePower $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getExcessivePower(int i) {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.get(i);
                }
                return null;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$addExcessiveWake(long overTime, long usedTime) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                ew.type = 1;
                ew.overTime = overTime;
                ew.usedTime = usedTime;
                this.mExcessivePower.add(ew);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$addExcessiveCpu(long overTime, long usedTime) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                ew.type = 2;
                ew.overTime = overTime;
                ew.usedTime = usedTime;
                this.mExcessivePower.add(ew);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$writeExcessivePowerToParcelLocked(Parcel out) {
                if (this.mExcessivePower == null) {
                    out.writeInt(0);
                    return;
                }
                int N = this.mExcessivePower.size();
                out.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = this.mExcessivePower.get(i);
                    out.writeInt(ew.type);
                    out.writeLong(ew.overTime);
                    out.writeLong(ew.usedTime);
                }
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$readExcessivePowerFromParcelLocked(Parcel in) {
                int N = in.readInt();
                if (N == 0) {
                    this.mExcessivePower = null;
                    return;
                }
                if (N > 10000) {
                    throw new ParcelFormatException("File corrupt: too many excessive power entries " + N);
                }
                this.mExcessivePower = new ArrayList();
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                    ew.type = in.readInt();
                    ew.overTime = in.readLong();
                    ew.usedTime = in.readLong();
                    this.mExcessivePower.add(ew);
                }
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$writeToParcelLocked(Parcel out) {
                out.writeLong(this.mUserTime);
                out.writeLong(this.mSystemTime);
                out.writeLong(this.mForegroundTime);
                out.writeInt(this.mStarts);
                out.writeInt(this.mNumCrashes);
                out.writeInt(this.mNumAnrs);
                out.writeLong(this.mLoadedUserTime);
                out.writeLong(this.mLoadedSystemTime);
                out.writeLong(this.mLoadedForegroundTime);
                out.writeInt(this.mLoadedStarts);
                out.writeInt(this.mLoadedNumCrashes);
                out.writeInt(this.mLoadedNumAnrs);
                out.writeLong(this.mUnpluggedUserTime);
                out.writeLong(this.mUnpluggedSystemTime);
                out.writeLong(this.mUnpluggedForegroundTime);
                out.writeInt(this.mUnpluggedStarts);
                out.writeInt(this.mUnpluggedNumCrashes);
                out.writeInt(this.mUnpluggedNumAnrs);
                this.writeExcessivePowerToParcelLocked(out);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$readFromParcelLocked(Parcel in) {
                this.mUserTime = in.readLong();
                this.mSystemTime = in.readLong();
                this.mForegroundTime = in.readLong();
                this.mStarts = in.readInt();
                this.mNumCrashes = in.readInt();
                this.mNumAnrs = in.readInt();
                this.mLoadedUserTime = in.readLong();
                this.mLoadedSystemTime = in.readLong();
                this.mLoadedForegroundTime = in.readLong();
                this.mLoadedStarts = in.readInt();
                this.mLoadedNumCrashes = in.readInt();
                this.mLoadedNumAnrs = in.readInt();
                this.mUnpluggedUserTime = in.readLong();
                this.mUnpluggedSystemTime = in.readLong();
                this.mUnpluggedForegroundTime = in.readLong();
                this.mUnpluggedStarts = in.readInt();
                this.mUnpluggedNumCrashes = in.readInt();
                this.mUnpluggedNumAnrs = in.readInt();
                this.readExcessivePowerFromParcelLocked(in);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$addCpuTimeLocked(int utime, int stime) {
                this.mUserTime += (long)utime;
                this.mSystemTime += (long)stime;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$addForegroundTimeLocked(long ttime) {
                this.mForegroundTime += ttime;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$incStartsLocked() {
                ++this.mStarts;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$incNumCrashesLocked() {
                ++this.mNumCrashes;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$incNumAnrsLocked() {
                ++this.mNumAnrs;
            }

            private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$isActive() {
                return this.mActive;
            }

            private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getUserTime(int which) {
                long val = this.mUserTime;
                if (which == 1) {
                    val -= this.mLoadedUserTime;
                } else if (which == 2) {
                    val -= this.mUnpluggedUserTime;
                }
                return val;
            }

            private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getSystemTime(int which) {
                long val = this.mSystemTime;
                if (which == 1) {
                    val -= this.mLoadedSystemTime;
                } else if (which == 2) {
                    val -= this.mUnpluggedSystemTime;
                }
                return val;
            }

            private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getForegroundTime(int which) {
                long val = this.mForegroundTime;
                if (which == 1) {
                    val -= this.mLoadedForegroundTime;
                } else if (which == 2) {
                    val -= this.mUnpluggedForegroundTime;
                }
                return val;
            }

            private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getStarts(int which) {
                int val = this.mStarts;
                if (which == 1) {
                    val -= this.mLoadedStarts;
                } else if (which == 2) {
                    val -= this.mUnpluggedStarts;
                }
                return val;
            }

            private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getNumCrashes(int which) {
                int val = this.mNumCrashes;
                if (which == 1) {
                    val -= this.mLoadedNumCrashes;
                } else if (which == 2) {
                    val -= this.mUnpluggedNumCrashes;
                }
                return val;
            }

            private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getNumAnrs(int which) {
                int val = this.mNumAnrs;
                if (which == 1) {
                    val -= this.mLoadedNumAnrs;
                } else if (which == 2) {
                    val -= this.mUnpluggedNumAnrs;
                }
                return val;
            }

            private void __constructor__(BatteryStatsImpl batteryStatsImpl, String string2) {
                this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$__constructor__(batteryStatsImpl, string2);
            }

            public Proc(BatteryStatsImpl batteryStatsImpl, String string2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$__constructor__(com.android.internal.os.BatteryStatsImpl java.lang.String ), 0, this, batteryStatsImpl, string2);
            }

            @Override
            public void onTimeStarted(long l, long l2, long l3) {
                InvokeDynamicSupport.bootstrap("onTimeStarted", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$onTimeStarted(long long long ), 0, this, l, l2, l3);
            }

            @Override
            public void onTimeStopped(long l, long l2, long l3) {
                InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$onTimeStopped(long long long ), 0, this, l, l2, l3);
            }

            void detach() {
                InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$detach(), 0, this);
            }

            @Override
            public int countExcessivePowers() {
                return (int)InvokeDynamicSupport.bootstrap("countExcessivePowers", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$countExcessivePowers(), 0, this);
            }

            @Override
            public BatteryStats.Uid.Proc.ExcessivePower getExcessivePower(int n) {
                return InvokeDynamicSupport.bootstrap("getExcessivePower", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getExcessivePower(int ), 0, this, n);
            }

            public void addExcessiveWake(long l, long l2) {
                InvokeDynamicSupport.bootstrap("addExcessiveWake", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$addExcessiveWake(long long ), 0, this, l, l2);
            }

            public void addExcessiveCpu(long l, long l2) {
                InvokeDynamicSupport.bootstrap("addExcessiveCpu", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$addExcessiveCpu(long long ), 0, this, l, l2);
            }

            void writeExcessivePowerToParcelLocked(Parcel parcel) {
                InvokeDynamicSupport.bootstrap("writeExcessivePowerToParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$writeExcessivePowerToParcelLocked(android.os.Parcel ), 0, this, parcel);
            }

            void readExcessivePowerFromParcelLocked(Parcel parcel) {
                InvokeDynamicSupport.bootstrap("readExcessivePowerFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$readExcessivePowerFromParcelLocked(android.os.Parcel ), 0, this, parcel);
            }

            void writeToParcelLocked(Parcel parcel) {
                InvokeDynamicSupport.bootstrap("writeToParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$writeToParcelLocked(android.os.Parcel ), 0, this, parcel);
            }

            void readFromParcelLocked(Parcel parcel) {
                InvokeDynamicSupport.bootstrap("readFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$readFromParcelLocked(android.os.Parcel ), 0, this, parcel);
            }

            public void addCpuTimeLocked(int n, int n2) {
                InvokeDynamicSupport.bootstrap("addCpuTimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$addCpuTimeLocked(int int ), 0, this, n, n2);
            }

            public void addForegroundTimeLocked(long l) {
                InvokeDynamicSupport.bootstrap("addForegroundTimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$addForegroundTimeLocked(long ), 0, this, l);
            }

            public void incStartsLocked() {
                InvokeDynamicSupport.bootstrap("incStartsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$incStartsLocked(), 0, this);
            }

            public void incNumCrashesLocked() {
                InvokeDynamicSupport.bootstrap("incNumCrashesLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$incNumCrashesLocked(), 0, this);
            }

            public void incNumAnrsLocked() {
                InvokeDynamicSupport.bootstrap("incNumAnrsLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$incNumAnrsLocked(), 0, this);
            }

            @Override
            public boolean isActive() {
                return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$isActive(), 0, this);
            }

            @Override
            public long getUserTime(int n) {
                return (long)InvokeDynamicSupport.bootstrap("getUserTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getUserTime(int ), 0, this, n);
            }

            @Override
            public long getSystemTime(int n) {
                return (long)InvokeDynamicSupport.bootstrap("getSystemTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getSystemTime(int ), 0, this, n);
            }

            @Override
            public long getForegroundTime(int n) {
                return (long)InvokeDynamicSupport.bootstrap("getForegroundTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getForegroundTime(int ), 0, this, n);
            }

            @Override
            public int getStarts(int n) {
                return (int)InvokeDynamicSupport.bootstrap("getStarts", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getStarts(int ), 0, this, n);
            }

            @Override
            public int getNumCrashes(int n) {
                return (int)InvokeDynamicSupport.bootstrap("getNumCrashes", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getNumCrashes(int ), 0, this, n);
            }

            @Override
            public int getNumAnrs(int n) {
                return (int)InvokeDynamicSupport.bootstrap("getNumAnrs", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Proc$getNumAnrs(int ), 0, this, n);
            }

            public /* synthetic */ Proc() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proc)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class Sensor
        extends BatteryStats.Uid.Sensor
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            protected BatteryStatsImpl mBsi;
            protected Uid mUid;
            int mHandle;
            StopwatchTimer mTimer;

            private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$__constructor__(BatteryStatsImpl bsi, Uid uid, int handle) {
                this.mBsi = bsi;
                this.mUid = uid;
                this.mHandle = handle;
            }

            private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$readTimerFromParcel(TimeBase timeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                ArrayList<StopwatchTimer> pool = this.mBsi.mSensorTimers.get(this.mHandle);
                if (pool == null) {
                    pool = new ArrayList();
                    this.mBsi.mSensorTimers.put(this.mHandle, pool);
                }
                return new StopwatchTimer(this.mBsi.mClocks, this.mUid, 0, pool, timeBase, in);
            }

            private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$reset() {
                if (this.mTimer.reset(true)) {
                    this.mTimer = null;
                    return true;
                }
                return false;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$readFromParcelLocked(TimeBase timeBase, Parcel in) {
                this.mTimer = this.readTimerFromParcel(timeBase, in);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
                Timer.writeTimerToParcel(out, this.mTimer, elapsedRealtimeUs);
            }

            private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$getSensorTime() {
                return this.mTimer;
            }

            private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$getHandle() {
                return this.mHandle;
            }

            private void __constructor__(BatteryStatsImpl batteryStatsImpl, Uid uid, int n) {
                this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$__constructor__(batteryStatsImpl, uid, n);
            }

            public Sensor(BatteryStatsImpl batteryStatsImpl, Uid uid, int n) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$__constructor__(com.android.internal.os.BatteryStatsImpl com.android.internal.os.BatteryStatsImpl$Uid int ), 0, this, batteryStatsImpl, uid, n);
            }

            private StopwatchTimer readTimerFromParcel(TimeBase timeBase, Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("readTimerFromParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$readTimerFromParcel(com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, timeBase, parcel);
            }

            boolean reset() {
                return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$reset(), 0, this);
            }

            void readFromParcelLocked(TimeBase timeBase, Parcel parcel) {
                InvokeDynamicSupport.bootstrap("readFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$readFromParcelLocked(com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, timeBase, parcel);
            }

            void writeToParcelLocked(Parcel parcel, long l) {
                InvokeDynamicSupport.bootstrap("writeToParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$writeToParcelLocked(android.os.Parcel long ), 0, this, parcel, l);
            }

            @Override
            public Timer getSensorTime() {
                return InvokeDynamicSupport.bootstrap("getSensorTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$getSensorTime(), 0, this);
            }

            @Override
            public int getHandle() {
                return (int)InvokeDynamicSupport.bootstrap("getHandle", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Sensor$getHandle(), 0, this);
            }

            public /* synthetic */ Sensor() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Sensor)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class Wakelock
        extends BatteryStats.Uid.Wakelock
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            protected BatteryStatsImpl mBsi;
            protected Uid mUid;
            StopwatchTimer mTimerPartial;
            StopwatchTimer mTimerFull;
            StopwatchTimer mTimerWindow;
            StopwatchTimer mTimerDraw;

            private void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$__constructor__(BatteryStatsImpl bsi, Uid uid) {
                this.mBsi = bsi;
                this.mUid = uid;
            }

            private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$readTimerFromParcel(int type, ArrayList<StopwatchTimer> pool, TimeBase timeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                return new StopwatchTimer(this.mBsi.mClocks, this.mUid, type, pool, timeBase, in);
            }

            private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$reset() {
                boolean wlactive = false;
                if (this.mTimerFull != null) {
                    wlactive |= !this.mTimerFull.reset(false);
                }
                if (this.mTimerPartial != null) {
                    wlactive |= !this.mTimerPartial.reset(false);
                }
                if (this.mTimerWindow != null) {
                    wlactive |= !this.mTimerWindow.reset(false);
                }
                if (this.mTimerDraw != null) {
                    wlactive |= !this.mTimerDraw.reset(false);
                }
                if (!wlactive) {
                    if (this.mTimerFull != null) {
                        this.mTimerFull.detach();
                        this.mTimerFull = null;
                    }
                    if (this.mTimerPartial != null) {
                        this.mTimerPartial.detach();
                        this.mTimerPartial = null;
                    }
                    if (this.mTimerWindow != null) {
                        this.mTimerWindow.detach();
                        this.mTimerWindow = null;
                    }
                    if (this.mTimerDraw != null) {
                        this.mTimerDraw.detach();
                        this.mTimerDraw = null;
                    }
                }
                return !wlactive;
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$readFromParcelLocked(TimeBase timeBase, TimeBase screenOffTimeBase, Parcel in) {
                this.mTimerPartial = this.readTimerFromParcel(0, this.mBsi.mPartialTimers, screenOffTimeBase, in);
                this.mTimerFull = this.readTimerFromParcel(1, this.mBsi.mFullTimers, timeBase, in);
                this.mTimerWindow = this.readTimerFromParcel(2, this.mBsi.mWindowTimers, timeBase, in);
                this.mTimerDraw = this.readTimerFromParcel(18, this.mBsi.mDrawTimers, timeBase, in);
            }

            private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
                Timer.writeTimerToParcel(out, this.mTimerPartial, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerFull, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerWindow, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerDraw, elapsedRealtimeUs);
            }

            private final Timer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$getWakeTime(int type) {
                switch (type) {
                    case 1: {
                        return this.mTimerFull;
                    }
                    case 0: {
                        return this.mTimerPartial;
                    }
                    case 2: {
                        return this.mTimerWindow;
                    }
                    case 18: {
                        return this.mTimerDraw;
                    }
                }
                throw new IllegalArgumentException("type = " + type);
            }

            private final StopwatchTimer $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$getStopwatchTimer(int type) {
                switch (type) {
                    case 0: {
                        StopwatchTimer t = this.mTimerPartial;
                        if (t == null) {
                            this.mTimerPartial = t = new StopwatchTimer(this.mBsi.mClocks, this.mUid, 0, this.mBsi.mPartialTimers, this.mBsi.mOnBatteryScreenOffTimeBase);
                        }
                        return t;
                    }
                    case 1: {
                        StopwatchTimer t = this.mTimerFull;
                        if (t == null) {
                            this.mTimerFull = t = new StopwatchTimer(this.mBsi.mClocks, this.mUid, 1, this.mBsi.mFullTimers, this.mBsi.mOnBatteryTimeBase);
                        }
                        return t;
                    }
                    case 2: {
                        StopwatchTimer t = this.mTimerWindow;
                        if (t == null) {
                            this.mTimerWindow = t = new StopwatchTimer(this.mBsi.mClocks, this.mUid, 2, this.mBsi.mWindowTimers, this.mBsi.mOnBatteryTimeBase);
                        }
                        return t;
                    }
                    case 18: {
                        StopwatchTimer t = this.mTimerDraw;
                        if (t == null) {
                            this.mTimerDraw = t = new StopwatchTimer(this.mBsi.mClocks, this.mUid, 18, this.mBsi.mDrawTimers, this.mBsi.mOnBatteryTimeBase);
                        }
                        return t;
                    }
                }
                throw new IllegalArgumentException("type=" + type);
            }

            private void __constructor__(BatteryStatsImpl batteryStatsImpl, Uid uid) {
                this.$$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$__constructor__(batteryStatsImpl, uid);
            }

            public Wakelock(BatteryStatsImpl batteryStatsImpl, Uid uid) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$__constructor__(com.android.internal.os.BatteryStatsImpl com.android.internal.os.BatteryStatsImpl$Uid ), 0, this, batteryStatsImpl, uid);
            }

            private StopwatchTimer readTimerFromParcel(int n, ArrayList<StopwatchTimer> arrayList, TimeBase timeBase, Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("readTimerFromParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$readTimerFromParcel(int java.util.ArrayList<com.android.internal.os.BatteryStatsImpl$StopwatchTimer> com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, n, arrayList, timeBase, parcel);
            }

            boolean reset() {
                return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$reset(), 0, this);
            }

            void readFromParcelLocked(TimeBase timeBase, TimeBase timeBase2, Parcel parcel) {
                InvokeDynamicSupport.bootstrap("readFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$readFromParcelLocked(com.android.internal.os.BatteryStatsImpl$TimeBase com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, timeBase, timeBase2, parcel);
            }

            void writeToParcelLocked(Parcel parcel, long l) {
                InvokeDynamicSupport.bootstrap("writeToParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$writeToParcelLocked(android.os.Parcel long ), 0, this, parcel, l);
            }

            @Override
            public Timer getWakeTime(int n) {
                return InvokeDynamicSupport.bootstrap("getWakeTime", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$getWakeTime(int ), 0, this, n);
            }

            public StopwatchTimer getStopwatchTimer(int n) {
                return InvokeDynamicSupport.bootstrap("getStopwatchTimer", $$robo$$com_android_internal_os_BatteryStatsImpl_Uid_Wakelock$getStopwatchTimer(int ), 0, this, n);
            }

            public /* synthetic */ Wakelock() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Wakelock)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class ControllerActivityCounterImpl
    extends BatteryStats.ControllerActivityCounter
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private LongSamplingCounter mIdleTimeMillis;
        private LongSamplingCounter mRxTimeMillis;
        private LongSamplingCounter[] mTxTimeMillis;
        private LongSamplingCounter mPowerDrainMaMs;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$__constructor__(TimeBase timeBase, int numTxStates) {
            this.mIdleTimeMillis = new LongSamplingCounter(timeBase);
            this.mRxTimeMillis = new LongSamplingCounter(timeBase);
            this.mTxTimeMillis = new LongSamplingCounter[numTxStates];
            for (int i = 0; i < numTxStates; ++i) {
                this.mTxTimeMillis[i] = new LongSamplingCounter(timeBase);
            }
            this.mPowerDrainMaMs = new LongSamplingCounter(timeBase);
        }

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$__constructor__(TimeBase timeBase, int numTxStates, Parcel in) {
            this.mIdleTimeMillis = new LongSamplingCounter(timeBase, in);
            this.mRxTimeMillis = new LongSamplingCounter(timeBase, in);
            int recordedTxStates = in.readInt();
            if (recordedTxStates != numTxStates) {
                throw new ParcelFormatException("inconsistent tx state lengths");
            }
            this.mTxTimeMillis = new LongSamplingCounter[numTxStates];
            for (int i = 0; i < numTxStates; ++i) {
                this.mTxTimeMillis[i] = new LongSamplingCounter(timeBase, in);
            }
            this.mPowerDrainMaMs = new LongSamplingCounter(timeBase, in);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$readSummaryFromParcel(Parcel in) {
            this.mIdleTimeMillis.readSummaryFromParcelLocked(in);
            this.mRxTimeMillis.readSummaryFromParcelLocked(in);
            int recordedTxStates = in.readInt();
            if (recordedTxStates != this.mTxTimeMillis.length) {
                throw new ParcelFormatException("inconsistent tx state lengths");
            }
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.readSummaryFromParcelLocked(in);
            }
            this.mPowerDrainMaMs.readSummaryFromParcelLocked(in);
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$describeContents() {
            return 0;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$writeSummaryToParcel(Parcel dest) {
            this.mIdleTimeMillis.writeSummaryFromParcelLocked(dest);
            this.mRxTimeMillis.writeSummaryFromParcelLocked(dest);
            dest.writeInt(this.mTxTimeMillis.length);
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.writeSummaryFromParcelLocked(dest);
            }
            this.mPowerDrainMaMs.writeSummaryFromParcelLocked(dest);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$writeToParcel(Parcel dest, int flags) {
            this.mIdleTimeMillis.writeToParcel(dest);
            this.mRxTimeMillis.writeToParcel(dest);
            dest.writeInt(this.mTxTimeMillis.length);
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.writeToParcel(dest);
            }
            this.mPowerDrainMaMs.writeToParcel(dest);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$reset(boolean detachIfReset) {
            this.mIdleTimeMillis.reset(detachIfReset);
            this.mRxTimeMillis.reset(detachIfReset);
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.reset(detachIfReset);
            }
            this.mPowerDrainMaMs.reset(detachIfReset);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$detach() {
            this.mIdleTimeMillis.detach();
            this.mRxTimeMillis.detach();
            for (LongSamplingCounter counter : this.mTxTimeMillis) {
                counter.detach();
            }
            this.mPowerDrainMaMs.detach();
        }

        private final LongSamplingCounter $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$getIdleTimeCounter() {
            return this.mIdleTimeMillis;
        }

        private final LongSamplingCounter $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$getRxTimeCounter() {
            return this.mRxTimeMillis;
        }

        private final LongSamplingCounter[] $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$getTxTimeCounters() {
            return this.mTxTimeMillis;
        }

        private final LongSamplingCounter $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$getPowerCounter() {
            return this.mPowerDrainMaMs;
        }

        private void __constructor__(TimeBase timeBase, int n) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$__constructor__(timeBase, n);
        }

        public ControllerActivityCounterImpl(TimeBase timeBase, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$__constructor__(com.android.internal.os.BatteryStatsImpl$TimeBase int ), 0, this, timeBase, n);
        }

        private void __constructor__(TimeBase timeBase, int n, Parcel parcel) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$__constructor__(timeBase, n, parcel);
        }

        public ControllerActivityCounterImpl(TimeBase timeBase, int n, Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$__constructor__(com.android.internal.os.BatteryStatsImpl$TimeBase int android.os.Parcel ), 0, this, timeBase, n, parcel);
        }

        public void readSummaryFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readSummaryFromParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$readSummaryFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$describeContents(), 0, this);
        }

        public void writeSummaryToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeSummaryToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$writeSummaryToParcel(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void reset(boolean bl) {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$reset(boolean ), 0, this, bl);
        }

        public void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$detach(), 0, this);
        }

        @Override
        public LongSamplingCounter getIdleTimeCounter() {
            return InvokeDynamicSupport.bootstrap("getIdleTimeCounter", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$getIdleTimeCounter(), 0, this);
        }

        @Override
        public LongSamplingCounter getRxTimeCounter() {
            return InvokeDynamicSupport.bootstrap("getRxTimeCounter", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$getRxTimeCounter(), 0, this);
        }

        public LongSamplingCounter[] getTxTimeCounters() {
            return InvokeDynamicSupport.bootstrap("getTxTimeCounters", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$getTxTimeCounters(), 0, this);
        }

        @Override
        public LongSamplingCounter getPowerCounter() {
            return InvokeDynamicSupport.bootstrap("getPowerCounter", $$robo$$com_android_internal_os_BatteryStatsImpl_ControllerActivityCounterImpl$getPowerCounter(), 0, this);
        }

        public /* synthetic */ ControllerActivityCounterImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ControllerActivityCounterImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public abstract class OverflowArrayMap<T> {
        public transient /* synthetic */ Object __robo_data__;
        private static String OVERFLOW_NAME = "*overflow*";
        ArrayMap<String, T> mMap;
        T mCurOverflow;
        ArrayMap<String, MutableInt> mActiveOverflow;
        /* synthetic */ BatteryStatsImpl this$0;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$__constructor__(BatteryStatsImpl this$0) {
            this.mMap = new ArrayMap();
        }

        private final ArrayMap<String, T> $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$getMap() {
            return this.mMap;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$clear() {
            this.mMap.clear();
            this.mCurOverflow = null;
            this.mActiveOverflow = null;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$add(String name, T obj) {
            if (name == null) {
                name = "";
            }
            this.mMap.put(name, obj);
            if ("*overflow*".equals(name)) {
                this.mCurOverflow = obj;
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$cleanup() {
            if (this.mActiveOverflow != null && this.mActiveOverflow.size() == 0) {
                this.mActiveOverflow = null;
            }
            if (this.mActiveOverflow == null) {
                if (this.mMap.containsKey("*overflow*")) {
                    Slog.wtf("BatteryStatsImpl", "Cleaning up with no active overflow, but have overflow entry " + this.mMap.get("*overflow*"));
                    this.mMap.remove("*overflow*");
                }
                this.mCurOverflow = null;
            } else if (this.mCurOverflow == null || !this.mMap.containsKey("*overflow*")) {
                Slog.wtf("BatteryStatsImpl", "Cleaning up with active overflow, but no overflow entry: cur=" + this.mCurOverflow + " map=" + this.mMap.get("*overflow*"));
            }
        }

        private final T $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$startObject(String name) {
            MutableInt over;
            T obj;
            if (name == null) {
                name = "";
            }
            if ((obj = this.mMap.get(name)) != null) {
                return obj;
            }
            if (this.mActiveOverflow != null && (over = this.mActiveOverflow.get(name)) != null) {
                obj = this.mCurOverflow;
                if (obj == null) {
                    Slog.wtf("BatteryStatsImpl", "Have active overflow " + name + " but null overflow");
                    this.mCurOverflow = this.instantiateObject();
                    obj = this.mCurOverflow;
                    this.mMap.put("*overflow*", obj);
                }
                ++over.value;
                return obj;
            }
            int N = this.mMap.size();
            if (N >= 100) {
                obj = this.mCurOverflow;
                if (obj == null) {
                    this.mCurOverflow = this.instantiateObject();
                    obj = this.mCurOverflow;
                    this.mMap.put("*overflow*", obj);
                }
                if (this.mActiveOverflow == null) {
                    this.mActiveOverflow = new ArrayMap();
                }
                this.mActiveOverflow.put(name, new MutableInt(1));
                return obj;
            }
            obj = this.instantiateObject();
            this.mMap.put(name, obj);
            return obj;
        }

        private final T $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$stopObject(String name) {
            MutableInt over;
            T obj;
            if (name == null) {
                name = "";
            }
            if ((obj = this.mMap.get(name)) != null) {
                return obj;
            }
            if (this.mActiveOverflow != null && (over = this.mActiveOverflow.get(name)) != null && (obj = this.mCurOverflow) != null) {
                --over.value;
                if (over.value <= 0) {
                    this.mActiveOverflow.remove(name);
                }
                return obj;
            }
            Slog.wtf("BatteryStatsImpl", "Unable to find object for " + name + " mapsize=" + this.mMap.size() + " activeoverflow=" + this.mActiveOverflow + " curoverflow=" + this.mCurOverflow);
            return null;
        }

        public abstract T instantiateObject();

        private void __constructor__(BatteryStatsImpl batteryStatsImpl) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$__constructor__(batteryStatsImpl);
        }

        public OverflowArrayMap(BatteryStatsImpl batteryStatsImpl) {
            this.this$0 = batteryStatsImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$__constructor__(com.android.internal.os.BatteryStatsImpl ), 0, this, batteryStatsImpl);
        }

        public ArrayMap<String, T> getMap() {
            return InvokeDynamicSupport.bootstrap("getMap", $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$getMap(), 0, this);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$clear(), 0, this);
        }

        public void add(String string2, T t) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$add(java.lang.String T ), 0, this, string2, t);
        }

        public void cleanup() {
            InvokeDynamicSupport.bootstrap("cleanup", $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$cleanup(), 0, this);
        }

        public T startObject(String string2) {
            return (T)InvokeDynamicSupport.bootstrap("startObject", $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$startObject(java.lang.String ), 0, this, string2);
        }

        public T stopObject(String string2) {
            return (T)InvokeDynamicSupport.bootstrap("stopObject", $$robo$$com_android_internal_os_BatteryStatsImpl_OverflowArrayMap$stopObject(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ OverflowArrayMap() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverflowArrayMap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StopwatchTimer
    extends Timer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Uid mUid;
        ArrayList<StopwatchTimer> mTimerPool;
        int mNesting;
        long mUpdateTime;
        long mAcquireTime;
        long mTimeout;
        boolean mInList;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$__constructor__(Clocks clocks, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, Parcel in) {
            this.mUid = uid;
            this.mTimerPool = timerPool;
            this.mUpdateTime = in.readLong();
        }

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$__constructor__(Clocks clocks, Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase) {
            this.mUid = uid;
            this.mTimerPool = timerPool;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$setTimeout(long timeout) {
            this.mTimeout = timeout;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.mUpdateTime);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            if (this.mNesting > 0) {
                super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
                this.mUpdateTime = baseRealtime;
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mNesting=" + this.mNesting + " mUpdateTime=" + this.mUpdateTime + " mAcquireTime=" + this.mAcquireTime);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$startRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting++ == 0) {
                long batteryRealtime;
                this.mUpdateTime = batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, null);
                    this.mTimerPool.add(this);
                }
                ++this.mCount;
                this.mAcquireTime = this.mTotalTime;
            }
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$isRunningLocked() {
            return this.mNesting > 0;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$stopRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting == 0) {
                return;
            }
            if (--this.mNesting == 0) {
                long batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, null);
                    this.mTimerPool.remove(this);
                } else {
                    this.mNesting = 1;
                    this.mTotalTime = this.computeRunTimeLocked(batteryRealtime);
                    this.mNesting = 0;
                }
                if (this.mTotalTime == this.mAcquireTime) {
                    --this.mCount;
                }
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$stopAllRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting > 0) {
                this.mNesting = 1;
                this.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private static final long $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$refreshTimersLocked(long batteryRealtime, ArrayList<StopwatchTimer> pool, StopwatchTimer self) {
            long selfTime = 0L;
            int N = pool.size();
            for (int i = N - 1; i >= 0; --i) {
                StopwatchTimer t = pool.get(i);
                long heldTime = batteryRealtime - t.mUpdateTime;
                if (heldTime > 0L) {
                    long myTime = heldTime / (long)N;
                    if (t == self) {
                        selfTime = myTime;
                    }
                    t.mTotalTime += myTime;
                }
                t.mUpdateTime = batteryRealtime;
            }
            return selfTime;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$computeRunTimeLocked(long curBatteryRealtime) {
            if (this.mTimeout > 0L && curBatteryRealtime > this.mUpdateTime + this.mTimeout) {
                curBatteryRealtime = this.mUpdateTime + this.mTimeout;
            }
            return this.mTotalTime + (this.mNesting > 0 ? (curBatteryRealtime - this.mUpdateTime) / (long)(this.mTimerPool != null ? this.mTimerPool.size() : 1) : 0L);
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$computeCurrentCountLocked() {
            return this.mCount;
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$reset(boolean detachIfReset) {
            boolean canDetach = this.mNesting <= 0;
            super.reset(canDetach && detachIfReset);
            if (this.mNesting > 0) {
                this.mUpdateTime = this.mTimeBase.getRealtime(this.mClocks.elapsedRealtime() * 1000L);
            }
            this.mAcquireTime = this.mTotalTime;
            return canDetach;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$detach() {
            super.detach();
            if (this.mTimerPool != null) {
                this.mTimerPool.remove(this);
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mNesting = 0;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$setMark(long elapsedRealtimeMs) {
            long batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
            if (this.mNesting > 0) {
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, this);
                } else {
                    this.mTotalTime += batteryRealtime - this.mUpdateTime;
                    this.mUpdateTime = batteryRealtime;
                }
            }
            this.mTimeBeforeMark = this.mTotalTime;
        }

        private void __constructor__(Clocks clocks, Uid uid, int n, ArrayList<StopwatchTimer> arrayList, TimeBase timeBase, Parcel parcel) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$__constructor__(clocks, uid, n, arrayList, timeBase, parcel);
        }

        public StopwatchTimer(Clocks clocks, Uid uid, int n, ArrayList<StopwatchTimer> arrayList, TimeBase timeBase, Parcel parcel) {
            super(clocks, n, timeBase, parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks com.android.internal.os.BatteryStatsImpl$Uid int java.util.ArrayList<com.android.internal.os.BatteryStatsImpl$StopwatchTimer> com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, clocks, uid, n, arrayList, timeBase, parcel);
        }

        private void __constructor__(Clocks clocks, Uid uid, int n, ArrayList<StopwatchTimer> arrayList, TimeBase timeBase) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$__constructor__(clocks, uid, n, arrayList, timeBase);
        }

        public StopwatchTimer(Clocks clocks, Uid uid, int n, ArrayList<StopwatchTimer> arrayList, TimeBase timeBase) {
            super(clocks, n, timeBase);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks com.android.internal.os.BatteryStatsImpl$Uid int java.util.ArrayList<com.android.internal.os.BatteryStatsImpl$StopwatchTimer> com.android.internal.os.BatteryStatsImpl$TimeBase ), 0, this, clocks, uid, n, arrayList, timeBase);
        }

        public void setTimeout(long l) {
            InvokeDynamicSupport.bootstrap("setTimeout", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$setTimeout(long ), 0, this, l);
        }

        @Override
        public void writeToParcel(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$writeToParcel(android.os.Parcel long ), 0, this, parcel, l);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$onTimeStopped(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public void logState(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("logState", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$logState(android.util.Printer java.lang.String ), 0, this, printer, string2);
        }

        public void startRunningLocked(long l) {
            InvokeDynamicSupport.bootstrap("startRunningLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$startRunningLocked(long ), 0, this, l);
        }

        public boolean isRunningLocked() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunningLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$isRunningLocked(), 0, this);
        }

        public void stopRunningLocked(long l) {
            InvokeDynamicSupport.bootstrap("stopRunningLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$stopRunningLocked(long ), 0, this, l);
        }

        public void stopAllRunningLocked(long l) {
            InvokeDynamicSupport.bootstrap("stopAllRunningLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$stopAllRunningLocked(long ), 0, this, l);
        }

        private static long refreshTimersLocked(long l, ArrayList<StopwatchTimer> arrayList, StopwatchTimer stopwatchTimer) {
            return (long)InvokeDynamicSupport.bootstrapStatic("refreshTimersLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$refreshTimersLocked(long java.util.ArrayList<com.android.internal.os.BatteryStatsImpl$StopwatchTimer> com.android.internal.os.BatteryStatsImpl$StopwatchTimer ), 0, (long)l, arrayList, (StopwatchTimer)stopwatchTimer);
        }

        @Override
        protected long computeRunTimeLocked(long l) {
            return (long)InvokeDynamicSupport.bootstrap("computeRunTimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$computeRunTimeLocked(long ), 0, this, l);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return (int)InvokeDynamicSupport.bootstrap("computeCurrentCountLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$computeCurrentCountLocked(), 0, this);
        }

        @Override
        public boolean reset(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$reset(boolean ), 0, this, bl);
        }

        @Override
        public void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$detach(), 0, this);
        }

        @Override
        public void readSummaryFromParcelLocked(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$readSummaryFromParcelLocked(android.os.Parcel ), 0, this, parcel);
        }

        public void setMark(long l) {
            InvokeDynamicSupport.bootstrap("setMark", $$robo$$com_android_internal_os_BatteryStatsImpl_StopwatchTimer$setMark(long ), 0, this, l);
        }

        public /* synthetic */ StopwatchTimer() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StopwatchTimer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BatchTimer
    extends Timer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Uid mUid;
        long mLastAddedTime;
        long mLastAddedDuration;
        boolean mInDischarge;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$__constructor__(Clocks clocks, Uid uid, int type, TimeBase timeBase, Parcel in) {
            this.mUid = uid;
            this.mLastAddedTime = in.readLong();
            this.mLastAddedDuration = in.readLong();
            this.mInDischarge = timeBase.isRunning();
        }

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$__constructor__(Clocks clocks, Uid uid, int type, TimeBase timeBase) {
            this.mUid = uid;
            this.mInDischarge = timeBase.isRunning();
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.mLastAddedTime);
            out.writeLong(this.mLastAddedDuration);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.recomputeLastDuration(this.mClocks.elapsedRealtime() * 1000L, false);
            this.mInDischarge = false;
            super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.recomputeLastDuration(elapsedRealtime, false);
            this.mInDischarge = true;
            if (this.mLastAddedTime == elapsedRealtime) {
                this.mTotalTime += this.mLastAddedDuration;
            }
            super.onTimeStarted(elapsedRealtime, baseUptime, baseRealtime);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mLastAddedTime=" + this.mLastAddedTime + " mLastAddedDuration=" + this.mLastAddedDuration);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$computeOverage(long curTime) {
            if (this.mLastAddedTime > 0L) {
                return this.mLastTime + this.mLastAddedDuration - curTime;
            }
            return 0L;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$recomputeLastDuration(long curTime, boolean abort) {
            long overage = this.computeOverage(curTime);
            if (overage > 0L) {
                if (this.mInDischarge) {
                    this.mTotalTime -= overage;
                }
                if (abort) {
                    this.mLastAddedTime = 0L;
                } else {
                    this.mLastAddedTime = curTime;
                    this.mLastAddedDuration -= overage;
                }
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$addDuration(BatteryStatsImpl stats, long durationMillis) {
            long now = this.mClocks.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
            this.mLastAddedTime = now;
            this.mLastAddedDuration = durationMillis * 1000L;
            if (this.mInDischarge) {
                this.mTotalTime += this.mLastAddedDuration;
                ++this.mCount;
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$abortLastDuration(BatteryStatsImpl stats) {
            long now = this.mClocks.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$computeCurrentCountLocked() {
            return this.mCount;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$computeRunTimeLocked(long curBatteryRealtime) {
            long overage = this.computeOverage(this.mClocks.elapsedRealtime() * 1000L);
            if (overage > 0L) {
                this.mTotalTime = overage;
                return this.mTotalTime;
            }
            return this.mTotalTime;
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$reset(boolean detachIfReset) {
            long now = this.mClocks.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
            boolean stillActive = this.mLastAddedTime == now;
            super.reset(!stillActive && detachIfReset);
            return !stillActive;
        }

        private void __constructor__(Clocks clocks, Uid uid, int n, TimeBase timeBase, Parcel parcel) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$__constructor__(clocks, uid, n, timeBase, parcel);
        }

        BatchTimer(Clocks clocks, Uid uid, int n, TimeBase timeBase, Parcel parcel) {
            super(clocks, n, timeBase, parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks com.android.internal.os.BatteryStatsImpl$Uid int com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, clocks, uid, n, timeBase, parcel);
        }

        private void __constructor__(Clocks clocks, Uid uid, int n, TimeBase timeBase) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$__constructor__(clocks, uid, n, timeBase);
        }

        BatchTimer(Clocks clocks, Uid uid, int n, TimeBase timeBase) {
            super(clocks, n, timeBase);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks com.android.internal.os.BatteryStatsImpl$Uid int com.android.internal.os.BatteryStatsImpl$TimeBase ), 0, this, clocks, uid, n, timeBase);
        }

        @Override
        public void writeToParcel(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$writeToParcel(android.os.Parcel long ), 0, this, parcel, l);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$onTimeStopped(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStarted", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$onTimeStarted(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public void logState(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("logState", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$logState(android.util.Printer java.lang.String ), 0, this, printer, string2);
        }

        private long computeOverage(long l) {
            return (long)InvokeDynamicSupport.bootstrap("computeOverage", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$computeOverage(long ), 0, this, l);
        }

        private void recomputeLastDuration(long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("recomputeLastDuration", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$recomputeLastDuration(long boolean ), 0, this, l, bl);
        }

        public void addDuration(BatteryStatsImpl batteryStatsImpl, long l) {
            InvokeDynamicSupport.bootstrap("addDuration", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$addDuration(com.android.internal.os.BatteryStatsImpl long ), 0, this, batteryStatsImpl, l);
        }

        public void abortLastDuration(BatteryStatsImpl batteryStatsImpl) {
            InvokeDynamicSupport.bootstrap("abortLastDuration", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$abortLastDuration(com.android.internal.os.BatteryStatsImpl ), 0, this, batteryStatsImpl);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return (int)InvokeDynamicSupport.bootstrap("computeCurrentCountLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$computeCurrentCountLocked(), 0, this);
        }

        @Override
        protected long computeRunTimeLocked(long l) {
            return (long)InvokeDynamicSupport.bootstrap("computeRunTimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$computeRunTimeLocked(long ), 0, this, l);
        }

        @Override
        public boolean reset(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_BatchTimer$reset(boolean ), 0, this, bl);
        }

        public /* synthetic */ BatchTimer() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BatchTimer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SamplingTimer
    extends Timer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mCurrentReportedCount;
        int mUnpluggedReportedCount;
        long mCurrentReportedTotalTime;
        long mUnpluggedReportedTotalTime;
        boolean mTimeBaseRunning;
        boolean mTrackingReportedValues;
        int mUpdateVersion;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$__constructor__(Clocks clocks, TimeBase timeBase, Parcel in) {
            this.mCurrentReportedCount = in.readInt();
            this.mUnpluggedReportedCount = in.readInt();
            this.mCurrentReportedTotalTime = in.readLong();
            this.mUnpluggedReportedTotalTime = in.readLong();
            this.mTrackingReportedValues = in.readInt() == 1;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$__constructor__(Clocks clocks, TimeBase timeBase) {
            this.mTrackingReportedValues = false;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$endSample() {
            this.mTotalTime = this.computeRunTimeLocked(0L);
            this.mCount = this.computeCurrentCountLocked();
            this.mCurrentReportedTotalTime = 0L;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mCurrentReportedCount = 0;
            this.mUnpluggedReportedCount = 0;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$setUpdateVersion(int version) {
            this.mUpdateVersion = version;
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$getUpdateVersion() {
            return this.mUpdateVersion;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$update(long totalTime, int count) {
            if (this.mTimeBaseRunning && !this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTime = totalTime;
                this.mUnpluggedReportedCount = count;
            }
            this.mTrackingReportedValues = true;
            if (totalTime < this.mCurrentReportedTotalTime || count < this.mCurrentReportedCount) {
                this.endSample();
            }
            this.mCurrentReportedTotalTime = totalTime;
            this.mCurrentReportedCount = count;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$add(long deltaTime, int deltaCount) {
            this.update(this.mCurrentReportedTotalTime + deltaTime, this.mCurrentReportedCount + deltaCount);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            super.onTimeStarted(elapsedRealtime, baseUptime, baseRealtime);
            if (this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime;
                this.mUnpluggedReportedCount = this.mCurrentReportedCount;
            }
            this.mTimeBaseRunning = true;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
            this.mTimeBaseRunning = false;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mCurrentReportedCount=" + this.mCurrentReportedCount + " mUnpluggedReportedCount=" + this.mUnpluggedReportedCount + " mCurrentReportedTotalTime=" + this.mCurrentReportedTotalTime + " mUnpluggedReportedTotalTime=" + this.mUnpluggedReportedTotalTime);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$computeRunTimeLocked(long curBatteryRealtime) {
            return this.mTotalTime + (this.mTimeBaseRunning && this.mTrackingReportedValues ? this.mCurrentReportedTotalTime - this.mUnpluggedReportedTotalTime : 0L);
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$computeCurrentCountLocked() {
            return this.mCount + (this.mTimeBaseRunning && this.mTrackingReportedValues ? this.mCurrentReportedCount - this.mUnpluggedReportedCount : 0);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeInt(this.mCurrentReportedCount);
            out.writeInt(this.mUnpluggedReportedCount);
            out.writeLong(this.mCurrentReportedTotalTime);
            out.writeLong(this.mUnpluggedReportedTotalTime);
            out.writeInt(this.mTrackingReportedValues ? 1 : 0);
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$reset(boolean detachIfReset) {
            super.reset(detachIfReset);
            this.mTrackingReportedValues = false;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mUnpluggedReportedCount = 0;
            return true;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$writeSummaryFromParcelLocked(Parcel out, long batteryRealtime) {
            super.writeSummaryFromParcelLocked(out, batteryRealtime);
            out.writeLong(this.mCurrentReportedTotalTime);
            out.writeInt(this.mCurrentReportedCount);
            out.writeInt(this.mTrackingReportedValues ? 1 : 0);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime = in.readLong();
            this.mUnpluggedReportedCount = this.mCurrentReportedCount = in.readInt();
            this.mTrackingReportedValues = in.readInt() == 1;
        }

        private void __constructor__(Clocks clocks, TimeBase timeBase, Parcel parcel) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$__constructor__(clocks, timeBase, parcel);
        }

        public SamplingTimer(Clocks clocks, TimeBase timeBase, Parcel parcel) {
            super(clocks, 0, timeBase, parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, clocks, timeBase, parcel);
        }

        private void __constructor__(Clocks clocks, TimeBase timeBase) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$__constructor__(clocks, timeBase);
        }

        public SamplingTimer(Clocks clocks, TimeBase timeBase) {
            super(clocks, 0, timeBase);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks com.android.internal.os.BatteryStatsImpl$TimeBase ), 0, this, clocks, timeBase);
        }

        public void endSample() {
            InvokeDynamicSupport.bootstrap("endSample", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$endSample(), 0, this);
        }

        public void setUpdateVersion(int n) {
            InvokeDynamicSupport.bootstrap("setUpdateVersion", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$setUpdateVersion(int ), 0, this, n);
        }

        public int getUpdateVersion() {
            return (int)InvokeDynamicSupport.bootstrap("getUpdateVersion", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$getUpdateVersion(), 0, this);
        }

        public void update(long l, int n) {
            InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$update(long int ), 0, this, l, n);
        }

        public void add(long l, int n) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$add(long int ), 0, this, l, n);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStarted", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$onTimeStarted(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$onTimeStopped(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public void logState(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("logState", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$logState(android.util.Printer java.lang.String ), 0, this, printer, string2);
        }

        @Override
        protected long computeRunTimeLocked(long l) {
            return (long)InvokeDynamicSupport.bootstrap("computeRunTimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$computeRunTimeLocked(long ), 0, this, l);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return (int)InvokeDynamicSupport.bootstrap("computeCurrentCountLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$computeCurrentCountLocked(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$writeToParcel(android.os.Parcel long ), 0, this, parcel, l);
        }

        @Override
        public boolean reset(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$reset(boolean ), 0, this, bl);
        }

        @Override
        public void writeSummaryFromParcelLocked(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$writeSummaryFromParcelLocked(android.os.Parcel long ), 0, this, parcel, l);
        }

        @Override
        public void readSummaryFromParcelLocked(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_SamplingTimer$readSummaryFromParcelLocked(android.os.Parcel ), 0, this, parcel);
        }

        public /* synthetic */ SamplingTimer() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SamplingTimer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Timer
    extends BatteryStats.Timer
    implements TimeBaseObs,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected Clocks mClocks;
        protected int mType;
        protected TimeBase mTimeBase;
        protected int mCount;
        protected int mLoadedCount;
        protected int mLastCount;
        protected int mUnpluggedCount;
        protected long mTotalTime;
        protected long mLoadedTime;
        protected long mLastTime;
        protected long mUnpluggedTime;
        protected long mTimeBeforeMark;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$__constructor__(Clocks clocks, int type, TimeBase timeBase, Parcel in) {
            this.mClocks = clocks;
            this.mType = type;
            this.mTimeBase = timeBase;
            this.mCount = in.readInt();
            this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = in.readInt();
            this.mTotalTime = in.readLong();
            this.mLoadedTime = in.readLong();
            this.mLastTime = 0L;
            this.mUnpluggedTime = in.readLong();
            this.mTimeBeforeMark = in.readLong();
            timeBase.add(this);
        }

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$__constructor__(Clocks clocks, int type, TimeBase timeBase) {
            this.mClocks = clocks;
            this.mType = type;
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        protected abstract long computeRunTimeLocked(long var1);

        protected abstract int computeCurrentCountLocked();

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$reset(boolean detachIfReset) {
            this.mTimeBeforeMark = 0L;
            this.mLastTime = 0L;
            this.mLoadedTime = 0L;
            this.mTotalTime = 0L;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            this.mCount = 0;
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$detach() {
            this.mTimeBase.remove(this);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$writeToParcel(Parcel out, long elapsedRealtimeUs) {
            out.writeInt(this.computeCurrentCountLocked());
            out.writeInt(this.mLoadedCount);
            out.writeInt(this.mUnpluggedCount);
            out.writeLong(this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs)));
            out.writeLong(this.mLoadedTime);
            out.writeLong(this.mUnpluggedTime);
            out.writeLong(this.mTimeBeforeMark);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$onTimeStarted(long elapsedRealtime, long timeBaseUptime, long baseRealtime) {
            this.mUnpluggedTime = this.computeRunTimeLocked(baseRealtime);
            this.mUnpluggedCount = this.computeCurrentCountLocked();
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mTotalTime = this.computeRunTimeLocked(baseRealtime);
            this.mCount = this.computeCurrentCountLocked();
        }

        private static final void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$writeTimerToParcel(Parcel out, Timer timer, long elapsedRealtimeUs) {
            if (timer == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            timer.writeToParcel(out, elapsedRealtimeUs);
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$getTotalTimeLocked(long elapsedRealtimeUs, int which) {
            long val = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
            if (which == 2) {
                val -= this.mUnpluggedTime;
            } else if (which != 0) {
                val -= this.mLoadedTime;
            }
            return val;
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$getCountLocked(int which) {
            int val = this.computeCurrentCountLocked();
            if (which == 2) {
                val -= this.mUnpluggedCount;
            } else if (which != 0) {
                val -= this.mLoadedCount;
            }
            return val;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$getTimeSinceMarkLocked(long elapsedRealtimeUs) {
            long val = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
            return val - this.mTimeBeforeMark;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount);
            pw.println(prefix + "mTotalTime=" + this.mTotalTime + " mLoadedTime=" + this.mLoadedTime);
            pw.println(prefix + "mLastTime=" + this.mLastTime + " mUnpluggedTime=" + this.mUnpluggedTime);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$writeSummaryFromParcelLocked(Parcel out, long elapsedRealtimeUs) {
            long runTime = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
            out.writeLong(runTime);
            out.writeInt(this.computeCurrentCountLocked());
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$readSummaryFromParcelLocked(Parcel in) {
            this.mTotalTime = this.mLoadedTime = in.readLong();
            this.mLastTime = 0L;
            this.mUnpluggedTime = this.mTotalTime;
            this.mCount = this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = this.mCount;
            this.mTimeBeforeMark = this.mTotalTime;
        }

        private void __constructor__(Clocks clocks, int n, TimeBase timeBase, Parcel parcel) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_Timer$__constructor__(clocks, n, timeBase, parcel);
        }

        public Timer(Clocks clocks, int n, TimeBase timeBase, Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks int com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, clocks, n, timeBase, parcel);
        }

        private void __constructor__(Clocks clocks, int n, TimeBase timeBase) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_Timer$__constructor__(clocks, n, timeBase);
        }

        public Timer(Clocks clocks, int n, TimeBase timeBase) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$__constructor__(com.android.internal.os.BatteryStatsImpl$Clocks int com.android.internal.os.BatteryStatsImpl$TimeBase ), 0, this, clocks, n, timeBase);
        }

        public boolean reset(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$reset(boolean ), 0, this, bl);
        }

        public void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$detach(), 0, this);
        }

        public void writeToParcel(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$writeToParcel(android.os.Parcel long ), 0, this, parcel, l);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStarted", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$onTimeStarted(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$onTimeStopped(long long long ), 0, this, l, l2, l3);
        }

        public static void writeTimerToParcel(Parcel parcel, Timer timer, long l) {
            InvokeDynamicSupport.bootstrapStatic("writeTimerToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$writeTimerToParcel(android.os.Parcel com.android.internal.os.BatteryStatsImpl$Timer long ), 0, (Parcel)parcel, (Timer)timer, (long)l);
        }

        @Override
        public long getTotalTimeLocked(long l, int n) {
            return (long)InvokeDynamicSupport.bootstrap("getTotalTimeLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$getTotalTimeLocked(long int ), 0, this, l, n);
        }

        @Override
        public int getCountLocked(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getCountLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$getCountLocked(int ), 0, this, n);
        }

        @Override
        public long getTimeSinceMarkLocked(long l) {
            return (long)InvokeDynamicSupport.bootstrap("getTimeSinceMarkLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$getTimeSinceMarkLocked(long ), 0, this, l);
        }

        @Override
        public void logState(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("logState", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$logState(android.util.Printer java.lang.String ), 0, this, printer, string2);
        }

        public void writeSummaryFromParcelLocked(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$writeSummaryFromParcelLocked(android.os.Parcel long ), 0, this, parcel, l);
        }

        public void readSummaryFromParcelLocked(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Timer$readSummaryFromParcelLocked(android.os.Parcel ), 0, this, parcel);
        }

        public /* synthetic */ Timer() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Timer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LongSamplingCounter
    extends BatteryStats.LongCounter
    implements TimeBaseObs,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        TimeBase mTimeBase;
        long mCount;
        long mLoadedCount;
        long mUnpluggedCount;
        long mPluggedCount;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$__constructor__(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mCount = this.mPluggedCount = in.readLong();
            this.mLoadedCount = in.readLong();
            this.mUnpluggedCount = in.readLong();
            timeBase.add(this);
        }

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$__constructor__(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$writeToParcel(Parcel out) {
            out.writeLong(this.mCount);
            out.writeLong(this.mLoadedCount);
            out.writeLong(this.mUnpluggedCount);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount = this.mPluggedCount;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mPluggedCount = this.mCount;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$getCountLocked(int which) {
            long val;
            long l = val = this.mTimeBase.isRunning() ? this.mCount : this.mPluggedCount;
            if (which == 2) {
                val -= this.mUnpluggedCount;
            } else if (which != 0) {
                val -= this.mLoadedCount;
            }
            return val;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount + " mLoadedCount=" + this.mLoadedCount + " mUnpluggedCount=" + this.mUnpluggedCount + " mPluggedCount=" + this.mPluggedCount);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$addCountLocked(long count) {
            this.mCount += count;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$reset(boolean detachIfReset) {
            this.mCount = 0L;
            this.mUnpluggedCount = 0L;
            this.mPluggedCount = 0L;
            this.mLoadedCount = 0L;
            if (detachIfReset) {
                this.detach();
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$detach() {
            this.mTimeBase.remove(this);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$writeSummaryFromParcelLocked(Parcel out) {
            out.writeLong(this.mCount);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$readSummaryFromParcelLocked(Parcel in) {
            this.mCount = this.mLoadedCount = in.readLong();
            this.mUnpluggedCount = this.mPluggedCount = this.mLoadedCount;
        }

        private void __constructor__(TimeBase timeBase, Parcel parcel) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$__constructor__(timeBase, parcel);
        }

        LongSamplingCounter(TimeBase timeBase, Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$__constructor__(com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, timeBase, parcel);
        }

        private void __constructor__(TimeBase timeBase) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$__constructor__(timeBase);
        }

        LongSamplingCounter(TimeBase timeBase) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$__constructor__(com.android.internal.os.BatteryStatsImpl$TimeBase ), 0, this, timeBase);
        }

        public void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$writeToParcel(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStarted", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$onTimeStarted(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$onTimeStopped(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public long getCountLocked(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getCountLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$getCountLocked(int ), 0, this, n);
        }

        @Override
        public void logState(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("logState", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$logState(android.util.Printer java.lang.String ), 0, this, printer, string2);
        }

        void addCountLocked(long l) {
            InvokeDynamicSupport.bootstrap("addCountLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$addCountLocked(long ), 0, this, l);
        }

        void reset(boolean bl) {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$reset(boolean ), 0, this, bl);
        }

        void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$detach(), 0, this);
        }

        void writeSummaryFromParcelLocked(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$writeSummaryFromParcelLocked(android.os.Parcel ), 0, this, parcel);
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_LongSamplingCounter$readSummaryFromParcelLocked(android.os.Parcel ), 0, this, parcel);
        }

        public /* synthetic */ LongSamplingCounter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LongSamplingCounter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Counter
    extends BatteryStats.Counter
    implements TimeBaseObs,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AtomicInteger mCount;
        TimeBase mTimeBase;
        int mLoadedCount;
        int mLastCount;
        int mUnpluggedCount;
        int mPluggedCount;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$__constructor__(TimeBase timeBase, Parcel in) {
            this.mCount = new AtomicInteger();
            this.mTimeBase = timeBase;
            this.mPluggedCount = in.readInt();
            this.mCount.set(this.mPluggedCount);
            this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = in.readInt();
            timeBase.add(this);
        }

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$__constructor__(TimeBase timeBase) {
            this.mCount = new AtomicInteger();
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$writeToParcel(Parcel out) {
            out.writeInt(this.mCount.get());
            out.writeInt(this.mLoadedCount);
            out.writeInt(this.mUnpluggedCount);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount.set(this.mPluggedCount);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mPluggedCount = this.mCount.get();
        }

        private static final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$writeCounterToParcel(Parcel out, Counter counter) {
            if (counter == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            counter.writeToParcel(out);
        }

        private final int $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$getCountLocked(int which) {
            int val = this.mCount.get();
            if (which == 2) {
                val -= this.mUnpluggedCount;
            } else if (which != 0) {
                val -= this.mLoadedCount;
            }
            return val;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount.get() + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount + " mPluggedCount=" + this.mPluggedCount);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$stepAtomic() {
            this.mCount.incrementAndGet();
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$reset(boolean detachIfReset) {
            this.mCount.set(0);
            this.mUnpluggedCount = 0;
            this.mPluggedCount = 0;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            if (detachIfReset) {
                this.detach();
            }
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$detach() {
            this.mTimeBase.remove(this);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$writeSummaryFromParcelLocked(Parcel out) {
            int count = this.mCount.get();
            out.writeInt(count);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$readSummaryFromParcelLocked(Parcel in) {
            this.mLoadedCount = in.readInt();
            this.mCount.set(this.mLoadedCount);
            this.mLastCount = 0;
            this.mUnpluggedCount = this.mPluggedCount = this.mLoadedCount;
        }

        private void __constructor__(TimeBase timeBase, Parcel parcel) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_Counter$__constructor__(timeBase, parcel);
        }

        Counter(TimeBase timeBase, Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$__constructor__(com.android.internal.os.BatteryStatsImpl$TimeBase android.os.Parcel ), 0, this, timeBase, parcel);
        }

        private void __constructor__(TimeBase timeBase) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_Counter$__constructor__(timeBase);
        }

        Counter(TimeBase timeBase) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$__constructor__(com.android.internal.os.BatteryStatsImpl$TimeBase ), 0, this, timeBase);
        }

        public void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$writeToParcel(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStarted", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$onTimeStarted(long long long ), 0, this, l, l2, l3);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("onTimeStopped", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$onTimeStopped(long long long ), 0, this, l, l2, l3);
        }

        public static void writeCounterToParcel(Parcel parcel, Counter counter) {
            InvokeDynamicSupport.bootstrapStatic("writeCounterToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$writeCounterToParcel(android.os.Parcel com.android.internal.os.BatteryStatsImpl$Counter ), 0, (Parcel)parcel, (Counter)counter);
        }

        @Override
        public int getCountLocked(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getCountLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$getCountLocked(int ), 0, this, n);
        }

        @Override
        public void logState(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("logState", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$logState(android.util.Printer java.lang.String ), 0, this, printer, string2);
        }

        void stepAtomic() {
            InvokeDynamicSupport.bootstrap("stepAtomic", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$stepAtomic(), 0, this);
        }

        void reset(boolean bl) {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$reset(boolean ), 0, this, bl);
        }

        void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$detach(), 0, this);
        }

        void writeSummaryFromParcelLocked(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$writeSummaryFromParcelLocked(android.os.Parcel ), 0, this, parcel);
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readSummaryFromParcelLocked", $$robo$$com_android_internal_os_BatteryStatsImpl_Counter$readSummaryFromParcelLocked(android.os.Parcel ), 0, this, parcel);
        }

        public /* synthetic */ Counter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Counter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TimeBase
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected ArrayList<TimeBaseObs> mObservers;
        protected long mUptime;
        protected long mRealtime;
        protected boolean mRunning;
        protected long mPastUptime;
        protected long mUptimeStart;
        protected long mPastRealtime;
        protected long mRealtimeStart;
        protected long mUnpluggedUptime;
        protected long mUnpluggedRealtime;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$__constructor__() {
            this.mObservers = new ArrayList();
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$dump(PrintWriter pw, String prefix) {
            StringBuilder sb = new StringBuilder(128);
            pw.print(prefix);
            pw.print("mRunning=");
            pw.println(this.mRunning);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mUptime=");
            BatteryStats.formatTimeMs(sb, this.mUptime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mRealtime=");
            BatteryStats.formatTimeMs(sb, this.mRealtime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPastUptime=");
            BatteryStats.formatTimeMs(sb, this.mPastUptime / 1000L);
            sb.append("mUptimeStart=");
            BatteryStats.formatTimeMs(sb, this.mUptimeStart / 1000L);
            sb.append("mUnpluggedUptime=");
            BatteryStats.formatTimeMs(sb, this.mUnpluggedUptime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPastRealtime=");
            BatteryStats.formatTimeMs(sb, this.mPastRealtime / 1000L);
            sb.append("mRealtimeStart=");
            BatteryStats.formatTimeMs(sb, this.mRealtimeStart / 1000L);
            sb.append("mUnpluggedRealtime=");
            BatteryStats.formatTimeMs(sb, this.mUnpluggedRealtime / 1000L);
            pw.println(sb.toString());
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$add(TimeBaseObs observer) {
            this.mObservers.add(observer);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$remove(TimeBaseObs observer) {
            if (!this.mObservers.remove(observer)) {
                Slog.wtf("BatteryStatsImpl", "Removed unknown observer: " + observer);
            }
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$hasObserver(TimeBaseObs observer) {
            return this.mObservers.contains(observer);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$init(long uptime, long realtime) {
            this.mRealtime = 0L;
            this.mUptime = 0L;
            this.mPastUptime = 0L;
            this.mPastRealtime = 0L;
            this.mUptimeStart = uptime;
            this.mRealtimeStart = realtime;
            this.mUnpluggedUptime = this.getUptime(this.mUptimeStart);
            this.mUnpluggedRealtime = this.getRealtime(this.mRealtimeStart);
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$reset(long uptime, long realtime) {
            if (!this.mRunning) {
                this.mPastUptime = 0L;
                this.mPastRealtime = 0L;
            } else {
                this.mUptimeStart = uptime;
                this.mRealtimeStart = realtime;
                this.mUnpluggedUptime = this.getUptime(uptime);
                this.mUnpluggedRealtime = this.getRealtime(realtime);
            }
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$computeUptime(long curTime, int which) {
            switch (which) {
                case 0: {
                    return this.mUptime + this.getUptime(curTime);
                }
                case 1: {
                    return this.getUptime(curTime);
                }
                case 2: {
                    return this.getUptime(curTime) - this.mUnpluggedUptime;
                }
            }
            return 0L;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$computeRealtime(long curTime, int which) {
            switch (which) {
                case 0: {
                    return this.mRealtime + this.getRealtime(curTime);
                }
                case 1: {
                    return this.getRealtime(curTime);
                }
                case 2: {
                    return this.getRealtime(curTime) - this.mUnpluggedRealtime;
                }
            }
            return 0L;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$getUptime(long curTime) {
            long time = this.mPastUptime;
            if (this.mRunning) {
                time += curTime - this.mUptimeStart;
            }
            return time;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$getRealtime(long curTime) {
            long time = this.mPastRealtime;
            if (this.mRunning) {
                time += curTime - this.mRealtimeStart;
            }
            return time;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$getUptimeStart() {
            return this.mUptimeStart;
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$getRealtimeStart() {
            return this.mRealtimeStart;
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$isRunning() {
            return this.mRunning;
        }

        private final boolean $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$setRunning(boolean running, long uptime, long realtime) {
            if (this.mRunning != running) {
                this.mRunning = running;
                if (running) {
                    this.mUptimeStart = uptime;
                    this.mRealtimeStart = realtime;
                    long batteryUptime = this.mUnpluggedUptime = this.getUptime(uptime);
                    long batteryRealtime = this.mUnpluggedRealtime = this.getRealtime(realtime);
                    for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                        this.mObservers.get(i).onTimeStarted(realtime, batteryUptime, batteryRealtime);
                    }
                } else {
                    this.mPastUptime += uptime - this.mUptimeStart;
                    this.mPastRealtime += realtime - this.mRealtimeStart;
                    long batteryUptime = this.getUptime(uptime);
                    long batteryRealtime = this.getRealtime(realtime);
                    for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                        this.mObservers.get(i).onTimeStopped(realtime, batteryUptime, batteryRealtime);
                    }
                }
                return true;
            }
            return false;
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$readSummaryFromParcel(Parcel in) {
            this.mUptime = in.readLong();
            this.mRealtime = in.readLong();
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$writeSummaryToParcel(Parcel out, long uptime, long realtime) {
            out.writeLong(this.computeUptime(uptime, 0));
            out.writeLong(this.computeRealtime(realtime, 0));
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$readFromParcel(Parcel in) {
            this.mRunning = false;
            this.mUptime = in.readLong();
            this.mPastUptime = in.readLong();
            this.mUptimeStart = in.readLong();
            this.mRealtime = in.readLong();
            this.mPastRealtime = in.readLong();
            this.mRealtimeStart = in.readLong();
            this.mUnpluggedUptime = in.readLong();
            this.mUnpluggedRealtime = in.readLong();
        }

        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$writeToParcel(Parcel out, long uptime, long realtime) {
            long runningUptime = this.getUptime(uptime);
            long runningRealtime = this.getRealtime(realtime);
            out.writeLong(this.mUptime);
            out.writeLong(runningUptime);
            out.writeLong(this.mUptimeStart);
            out.writeLong(this.mRealtime);
            out.writeLong(runningRealtime);
            out.writeLong(this.mRealtimeStart);
            out.writeLong(this.mUnpluggedUptime);
            out.writeLong(this.mUnpluggedRealtime);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$__constructor__();
        }

        public TimeBase() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$__constructor__(), 0, this);
        }

        public void dump(PrintWriter printWriter, String string2) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$dump(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
        }

        public void add(TimeBaseObs timeBaseObs) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$add(com.android.internal.os.BatteryStatsImpl$TimeBaseObs ), 0, this, timeBaseObs);
        }

        public void remove(TimeBaseObs timeBaseObs) {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$remove(com.android.internal.os.BatteryStatsImpl$TimeBaseObs ), 0, this, timeBaseObs);
        }

        public boolean hasObserver(TimeBaseObs timeBaseObs) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasObserver", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$hasObserver(com.android.internal.os.BatteryStatsImpl$TimeBaseObs ), 0, this, timeBaseObs);
        }

        public void init(long l, long l2) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$init(long long ), 0, this, l, l2);
        }

        public void reset(long l, long l2) {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$reset(long long ), 0, this, l, l2);
        }

        public long computeUptime(long l, int n) {
            return (long)InvokeDynamicSupport.bootstrap("computeUptime", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$computeUptime(long int ), 0, this, l, n);
        }

        public long computeRealtime(long l, int n) {
            return (long)InvokeDynamicSupport.bootstrap("computeRealtime", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$computeRealtime(long int ), 0, this, l, n);
        }

        public long getUptime(long l) {
            return (long)InvokeDynamicSupport.bootstrap("getUptime", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$getUptime(long ), 0, this, l);
        }

        public long getRealtime(long l) {
            return (long)InvokeDynamicSupport.bootstrap("getRealtime", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$getRealtime(long ), 0, this, l);
        }

        public long getUptimeStart() {
            return (long)InvokeDynamicSupport.bootstrap("getUptimeStart", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$getUptimeStart(), 0, this);
        }

        public long getRealtimeStart() {
            return (long)InvokeDynamicSupport.bootstrap("getRealtimeStart", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$getRealtimeStart(), 0, this);
        }

        public boolean isRunning() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$isRunning(), 0, this);
        }

        public boolean setRunning(boolean bl, long l, long l2) {
            return (boolean)InvokeDynamicSupport.bootstrap("setRunning", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$setRunning(boolean long long ), 0, this, bl, l, l2);
        }

        public void readSummaryFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readSummaryFromParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$readSummaryFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        public void writeSummaryToParcel(Parcel parcel, long l, long l2) {
            InvokeDynamicSupport.bootstrap("writeSummaryToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$writeSummaryToParcel(android.os.Parcel long long ), 0, this, parcel, l, l2);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        public void writeToParcel(Parcel parcel, long l, long l2) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_os_BatteryStatsImpl_TimeBase$writeToParcel(android.os.Parcel long long ), 0, this, parcel, l, l2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeBase)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface TimeBaseObs
    extends InstrumentedInterface {
        public void onTimeStarted(long var1, long var3, long var5);

        public void onTimeStopped(long var1, long var3, long var5);
    }

    public static interface ExternalStatsSync
    extends InstrumentedInterface {
        public static final int UPDATE_CPU = 1;
        public static final int UPDATE_WIFI = 2;
        public static final int UPDATE_RADIO = 4;
        public static final int UPDATE_BT = 8;
        public static final int UPDATE_ALL = 15;

        public void scheduleSync(String var1, int var2);

        public void scheduleCpuSyncDueToRemovedUid(int var1);
    }

    public static class SystemClocks
    implements Clocks,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_SystemClocks$__constructor__() {
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_SystemClocks$elapsedRealtime() {
            return SystemClock.elapsedRealtime();
        }

        private final long $$robo$$com_android_internal_os_BatteryStatsImpl_SystemClocks$uptimeMillis() {
            return SystemClock.uptimeMillis();
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_SystemClocks$__constructor__();
        }

        public SystemClocks() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_SystemClocks$__constructor__(), 0, this);
        }

        @Override
        public long elapsedRealtime() {
            return (long)InvokeDynamicSupport.bootstrap("elapsedRealtime", $$robo$$com_android_internal_os_BatteryStatsImpl_SystemClocks$elapsedRealtime(), 0, this);
        }

        @Override
        public long uptimeMillis() {
            return (long)InvokeDynamicSupport.bootstrap("uptimeMillis", $$robo$$com_android_internal_os_BatteryStatsImpl_SystemClocks$uptimeMillis(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemClocks)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Clocks
    extends InstrumentedInterface {
        public long elapsedRealtime();

        public long uptimeMillis();
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public final class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ BatteryStatsImpl this$0;

        private void $$robo$$com_android_internal_os_BatteryStatsImpl_MyHandler$__constructor__(BatteryStatsImpl this$0, Looper looper) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_os_BatteryStatsImpl_MyHandler$handleMessage(Message msg) {
            BatteryCallback cb = this.this$0.mCallback;
            switch (msg.what) {
                case 1: {
                    BatteryStatsImpl batteryStatsImpl = this.this$0;
                    synchronized (batteryStatsImpl) {
                        this.this$0.updateCpuTimeLocked();
                    }
                    if (cb == null) break;
                    cb.batteryNeedsCpuUpdate();
                    break;
                }
                case 2: {
                    if (cb == null) break;
                    cb.batteryPowerChanged(msg.arg1 != 0);
                    break;
                }
                case 3: {
                    String action;
                    if (cb == null) break;
                    BatteryStatsImpl batteryStatsImpl = this.this$0;
                    synchronized (batteryStatsImpl) {
                        action = this.this$0.mCharging ? "android.os.action.CHARGING" : "android.os.action.DISCHARGING";
                    }
                    Intent intent = new Intent(action);
                    intent.addFlags(0x4000000);
                    cb.batterySendBroadcast(intent);
                }
            }
        }

        private void __constructor__(BatteryStatsImpl batteryStatsImpl, Looper looper) {
            this.$$robo$$com_android_internal_os_BatteryStatsImpl_MyHandler$__constructor__(batteryStatsImpl, looper);
        }

        public MyHandler(BatteryStatsImpl batteryStatsImpl, Looper looper) {
            this.this$0 = batteryStatsImpl;
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsImpl_MyHandler$__constructor__(com.android.internal.os.BatteryStatsImpl android.os.Looper ), 0, this, batteryStatsImpl, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_os_BatteryStatsImpl_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface PlatformIdleStateCallback
    extends InstrumentedInterface {
        public String getPlatformLowPowerStats();
    }

    public static interface BatteryCallback
    extends InstrumentedInterface {
        public void batteryNeedsCpuUpdate();

        public void batteryPowerChanged(boolean var1);

        public void batterySendBroadcast(Intent var1);
    }
}

