/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.icu.util.ULocale;
import android.os.LocaleList;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class LocaleUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$com_android_internal_inputmethod_LocaleUtils$__constructor__() {
    }

    private static final byte $$robo$$com_android_internal_inputmethod_LocaleUtils$calculateMatchingSubScore(ULocale supported, ULocale desired) {
        if (supported.equals(desired)) {
            return 3;
        }
        String supportedScript = supported.getScript();
        if (supportedScript.isEmpty() || !supportedScript.equals(desired.getScript())) {
            return 1;
        }
        String supportedCountry = supported.getCountry();
        if (supportedCountry.isEmpty() || !supportedCountry.equals(desired.getCountry())) {
            return 2;
        }
        return 3;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_LocaleUtils$calculateMatchingScore(ULocale supported, LocaleList desired, byte[] out) {
        if (desired.isEmpty()) {
            return false;
        }
        boolean allZeros = true;
        int N = desired.size();
        for (int i = 0; i < N; ++i) {
            Locale locale = desired.get(i);
            if (!locale.getLanguage().equals(supported.getLanguage())) {
                out[i] = 0;
                continue;
            }
            out[i] = LocaleUtils.calculateMatchingSubScore(supported, ULocale.addLikelySubtags(ULocale.forLocale(locale)));
            if (!allZeros || out[i] == 0) continue;
            allZeros = false;
        }
        return !allZeros;
    }

    private static final <T> void $$robo$$com_android_internal_inputmethod_LocaleUtils$filterByLanguage(List<T> sources, LocaleExtractor<T> extractor, LocaleList preferredLanguages, ArrayList<T> dest) {
        HashMap<String, ScoreEntry> scoreboard = new HashMap<String, ScoreEntry>();
        byte[] score = new byte[preferredLanguages.size()];
        int sourceSize = sources.size();
        for (int i = 0; i < sourceSize; ++i) {
            Locale locale = extractor.get(sources.get(i));
            if (locale == null || !LocaleUtils.calculateMatchingScore(ULocale.addLikelySubtags(ULocale.forLocale(locale)), preferredLanguages, score)) continue;
            String lang = locale.getLanguage();
            ScoreEntry bestScore = (ScoreEntry)scoreboard.get(lang);
            if (bestScore == null) {
                scoreboard.put(lang, new ScoreEntry(score, i));
                continue;
            }
            bestScore.updateIfBetter(score, i);
        }
        Object[] result = scoreboard.values().toArray(new ScoreEntry[scoreboard.size()]);
        Arrays.sort(result);
        for (Object entry : result) {
            dest.add(sources.get(((ScoreEntry)entry).mIndex));
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_inputmethod_LocaleUtils$__constructor__();
    }

    public LocaleUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_LocaleUtils$__constructor__(), 0, this);
    }

    private static byte calculateMatchingSubScore(ULocale uLocale, ULocale uLocale2) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("calculateMatchingSubScore", $$robo$$com_android_internal_inputmethod_LocaleUtils$calculateMatchingSubScore(android.icu.util.ULocale android.icu.util.ULocale ), 0, (ULocale)uLocale, (ULocale)uLocale2);
    }

    private static boolean calculateMatchingScore(ULocale uLocale, LocaleList localeList, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("calculateMatchingScore", $$robo$$com_android_internal_inputmethod_LocaleUtils$calculateMatchingScore(android.icu.util.ULocale android.os.LocaleList byte[] ), 0, (ULocale)uLocale, (LocaleList)localeList, (byte[])byArray);
    }

    public static <T> void filterByLanguage(List<T> list, LocaleExtractor<T> localeExtractor, LocaleList localeList, ArrayList<T> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("filterByLanguage", $$robo$$com_android_internal_inputmethod_LocaleUtils$filterByLanguage(java.util.List<T> com.android.internal.inputmethod.LocaleUtils$LocaleExtractor<T> android.os.LocaleList java.util.ArrayList<T> ), 0, list, localeExtractor, (LocaleList)localeList, arrayList);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ScoreEntry
    implements Comparable<ScoreEntry> {
        public transient /* synthetic */ Object __robo_data__;
        public int mIndex;
        public byte[] mScore;

        private void $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$__constructor__(byte[] score, int index) {
            this.mIndex = -1;
            this.mScore = new byte[score.length];
            this.set(score, index);
        }

        private final void $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$set(byte[] score, int index) {
            for (int i = 0; i < this.mScore.length; ++i) {
                this.mScore[i] = score[i];
            }
            this.mIndex = index;
        }

        private final void $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$updateIfBetter(byte[] score, int index) {
            if (ScoreEntry.compare(this.mScore, score) == -1) {
                this.set(score, index);
            }
        }

        private static final int $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$compare(byte[] left, byte[] right) {
            for (int i = 0; i < left.length; ++i) {
                if (left[i] > right[i]) {
                    return 1;
                }
                if (left[i] >= right[i]) continue;
                return -1;
            }
            return 0;
        }

        private final int $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$compareTo(ScoreEntry other) {
            return -1 * ScoreEntry.compare(this.mScore, other.mScore);
        }

        private void __constructor__(byte[] byArray, int n) {
            this.$$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$__constructor__(byArray, n);
        }

        ScoreEntry(byte[] byArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$__constructor__(byte[] int ), 0, this, byArray, n);
        }

        private void set(byte[] byArray, int n) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$set(byte[] int ), 0, this, byArray, n);
        }

        public void updateIfBetter(byte[] byArray, int n) {
            InvokeDynamicSupport.bootstrap("updateIfBetter", $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$updateIfBetter(byte[] int ), 0, this, byArray, n);
        }

        private static int compare(byte[] byArray, byte[] byArray2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$compare(byte[] byte[] ), 0, (byte[])byArray, (byte[])byArray2);
        }

        @Override
        public int compareTo(ScoreEntry scoreEntry) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$com_android_internal_inputmethod_LocaleUtils_ScoreEntry$compareTo(com.android.internal.inputmethod.LocaleUtils$ScoreEntry ), 0, this, scoreEntry);
        }

        public /* synthetic */ ScoreEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScoreEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface LocaleExtractor<T> {
        public Locale get(T var1);
    }
}

