/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http;

import android.text.format.Time;
import com.google.errorprone.annotations.DoNotMock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class HttpDateTime
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String HTTP_DATE_RFC_REGEXP = "([0-9]{1,2})[- ]([A-Za-z]{3,9})[- ]([0-9]{2,4})[ ]([0-9]{1,2}:[0-9][0-9]:[0-9][0-9])";
    private static String HTTP_DATE_ANSIC_REGEXP = "[ ]([A-Za-z]{3,9})[ ]+([0-9]{1,2})[ ]([0-9]{1,2}:[0-9][0-9]:[0-9][0-9])[ ]([0-9]{2,4})";
    private static Pattern HTTP_DATE_RFC_PATTERN;
    private static Pattern HTTP_DATE_ANSIC_PATTERN;

    private void $$robo$$com_android_internal_http_HttpDateTime$__constructor__() {
    }

    private static final long $$robo$$com_android_internal_http_HttpDateTime$parse(String timeString) throws IllegalArgumentException {
        TimeOfDay timeOfDay;
        int date = 1;
        int month = 0;
        int year = 1970;
        Matcher rfcMatcher = HTTP_DATE_RFC_PATTERN.matcher(timeString);
        if (rfcMatcher.find()) {
            date = HttpDateTime.getDate(rfcMatcher.group(1));
            month = HttpDateTime.getMonth(rfcMatcher.group(2));
            year = HttpDateTime.getYear(rfcMatcher.group(3));
            timeOfDay = HttpDateTime.getTime(rfcMatcher.group(4));
        } else {
            Matcher ansicMatcher = HTTP_DATE_ANSIC_PATTERN.matcher(timeString);
            if (ansicMatcher.find()) {
                month = HttpDateTime.getMonth(ansicMatcher.group(1));
                date = HttpDateTime.getDate(ansicMatcher.group(2));
                timeOfDay = HttpDateTime.getTime(ansicMatcher.group(3));
                year = HttpDateTime.getYear(ansicMatcher.group(4));
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (year >= 2038) {
            year = 2038;
            month = 0;
            date = 1;
        }
        Time time = new Time("UTC");
        time.set(timeOfDay.second, timeOfDay.minute, timeOfDay.hour, date, month, year);
        return time.toMillis(false);
    }

    private static final int $$robo$$com_android_internal_http_HttpDateTime$getDate(String dateString) {
        if (dateString.length() == 2) {
            return (dateString.charAt(0) - 48) * 10 + (dateString.charAt(1) - 48);
        }
        return dateString.charAt(0) - 48;
    }

    private static final int $$robo$$com_android_internal_http_HttpDateTime$getMonth(String monthString) {
        int hash = Character.toLowerCase(monthString.charAt(0)) + Character.toLowerCase(monthString.charAt(1)) + Character.toLowerCase(monthString.charAt(2)) - 291;
        switch (hash) {
            case 22: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 29: {
                return 2;
            }
            case 32: {
                return 3;
            }
            case 36: {
                return 4;
            }
            case 42: {
                return 5;
            }
            case 40: {
                return 6;
            }
            case 26: {
                return 7;
            }
            case 37: {
                return 8;
            }
            case 35: {
                return 9;
            }
            case 48: {
                return 10;
            }
            case 9: {
                return 11;
            }
        }
        throw new IllegalArgumentException();
    }

    private static final int $$robo$$com_android_internal_http_HttpDateTime$getYear(String yearString) {
        if (yearString.length() == 2) {
            int year = (yearString.charAt(0) - 48) * 10 + (yearString.charAt(1) - 48);
            if (year >= 70) {
                return year + 1900;
            }
            return year + 2000;
        }
        if (yearString.length() == 3) {
            int year = (yearString.charAt(0) - 48) * 100 + (yearString.charAt(1) - 48) * 10 + (yearString.charAt(2) - 48);
            return year + 1900;
        }
        if (yearString.length() == 4) {
            return (yearString.charAt(0) - 48) * 1000 + (yearString.charAt(1) - 48) * 100 + (yearString.charAt(2) - 48) * 10 + (yearString.charAt(3) - 48);
        }
        return 1970;
    }

    private static final TimeOfDay $$robo$$com_android_internal_http_HttpDateTime$getTime(String timeString) {
        int i = 0;
        int hour = timeString.charAt(i++) - 48;
        if (timeString.charAt(i) != ':') {
            hour = hour * 10 + (timeString.charAt(i++) - 48);
        }
        int n = ++i;
        int n2 = ++i;
        ++i;
        int minute = (timeString.charAt(n) - 48) * 10 + (timeString.charAt(n2) - 48);
        int n3 = ++i;
        int n4 = ++i;
        ++i;
        int second = (timeString.charAt(n3) - 48) * 10 + (timeString.charAt(n4) - 48);
        return new TimeOfDay(hour, minute, second);
    }

    static void __staticInitializer__() {
        HTTP_DATE_RFC_PATTERN = Pattern.compile("([0-9]{1,2})[- ]([A-Za-z]{3,9})[- ]([0-9]{2,4})[ ]([0-9]{1,2}:[0-9][0-9]:[0-9][0-9])");
        HTTP_DATE_ANSIC_PATTERN = Pattern.compile("[ ]([A-Za-z]{3,9})[ ]+([0-9]{1,2})[ ]([0-9]{1,2}:[0-9][0-9]:[0-9][0-9])[ ]([0-9]{2,4})");
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_http_HttpDateTime$__constructor__();
    }

    public HttpDateTime() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_http_HttpDateTime$__constructor__(), 0, this);
    }

    public static long parse(String string2) throws IllegalArgumentException {
        return (long)InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$com_android_internal_http_HttpDateTime$parse(java.lang.String ), 0, (String)string2);
    }

    private static int getDate(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDate", $$robo$$com_android_internal_http_HttpDateTime$getDate(java.lang.String ), 0, (String)string2);
    }

    private static int getMonth(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMonth", $$robo$$com_android_internal_http_HttpDateTime$getMonth(java.lang.String ), 0, (String)string2);
    }

    private static int getYear(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getYear", $$robo$$com_android_internal_http_HttpDateTime$getYear(java.lang.String ), 0, (String)string2);
    }

    private static TimeOfDay getTime(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getTime", $$robo$$com_android_internal_http_HttpDateTime$getTime(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(HttpDateTime.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HttpDateTime)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class TimeOfDay
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int hour;
        int minute;
        int second;

        private void $$robo$$com_android_internal_http_HttpDateTime_TimeOfDay$__constructor__(int h, int m, int s) {
            this.hour = h;
            this.minute = m;
            this.second = s;
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$com_android_internal_http_HttpDateTime_TimeOfDay$__constructor__(n, n2, n3);
        }

        TimeOfDay(int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_http_HttpDateTime_TimeOfDay$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        public /* synthetic */ TimeOfDay() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeOfDay)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

