/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import com.android.internal.app.ResolverActivity;
import java.text.Collator;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResolverComparator
implements Comparator<ResolverActivity.ResolvedComponentInfo> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ResolverComparator";
    private static boolean DEBUG = false;
    private static long USAGE_STATS_PERIOD = 604800000L;
    private static long RECENCY_TIME_PERIOD = 43200000L;
    private static float RECENCY_MULTIPLIER = 2.0f;
    private Collator mCollator;
    private boolean mHttp;
    private PackageManager mPm;
    private UsageStatsManager mUsm;
    private Map<String, UsageStats> mStats;
    private long mCurrentTime;
    private long mSinceTime;
    private LinkedHashMap<ComponentName, ScoredTarget> mScoredTargets;
    private String mReferrerPackage;

    private void $$robo$$com_android_internal_app_ResolverComparator$__constructor__(Context context, Intent intent, String referrerPackage) {
        this.mScoredTargets = new LinkedHashMap();
        this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        String scheme = intent.getScheme();
        this.mHttp = "http".equals(scheme) || "https".equals(scheme);
        this.mReferrerPackage = referrerPackage;
        this.mPm = context.getPackageManager();
        this.mUsm = (UsageStatsManager)context.getSystemService("usagestats");
        this.mCurrentTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mSinceTime = this.mCurrentTime - 604800000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats(this.mSinceTime, this.mCurrentTime);
    }

    private final void $$robo$$com_android_internal_app_ResolverComparator$compute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.mScoredTargets.clear();
        long recentSinceTime = this.mCurrentTime - 43200000L;
        long mostRecentlyUsedTime = recentSinceTime + 1L;
        long mostTimeSpent = 1L;
        int mostLaunched = 1;
        for (ResolverActivity.ResolvedComponentInfo resolvedComponentInfo : targets) {
            long timeSpent;
            ScoredTarget scoredTarget = new ScoredTarget(resolvedComponentInfo.getResolveInfoAt((int)0).activityInfo);
            this.mScoredTargets.put(resolvedComponentInfo.name, scoredTarget);
            UsageStats pkStats = this.mStats.get(resolvedComponentInfo.name.getPackageName());
            if (pkStats == null) continue;
            if (!resolvedComponentInfo.name.getPackageName().equals(this.mReferrerPackage) && !ResolverComparator.isPersistentProcess(resolvedComponentInfo)) {
                long lastTimeUsed;
                scoredTarget.lastTimeUsed = lastTimeUsed = pkStats.getLastTimeUsed();
                if (lastTimeUsed > mostRecentlyUsedTime) {
                    mostRecentlyUsedTime = lastTimeUsed;
                }
            }
            scoredTarget.timeSpent = timeSpent = pkStats.getTotalTimeInForeground();
            if (timeSpent > mostTimeSpent) {
                mostTimeSpent = timeSpent;
            }
            int launched = pkStats.mLaunchCount;
            scoredTarget.launchCount = launched;
            if (launched <= mostLaunched) continue;
            mostLaunched = launched;
        }
        for (ScoredTarget scoredTarget : this.mScoredTargets.values()) {
            float recency = (float)Math.max(scoredTarget.lastTimeUsed - recentSinceTime, 0L) / (float)(mostRecentlyUsedTime - recentSinceTime);
            float recencyScore = recency * recency * 2.0f;
            float usageTimeScore = (float)scoredTarget.timeSpent / (float)mostTimeSpent;
            float launchCountScore = (float)scoredTarget.launchCount / (float)mostLaunched;
            scoredTarget.score = recencyScore + usageTimeScore + launchCountScore;
        }
    }

    private static final boolean $$robo$$com_android_internal_app_ResolverComparator$isPersistentProcess(ResolverActivity.ResolvedComponentInfo rci) {
        if (rci != null && rci.getCount() > 0) {
            return (rci.getResolveInfoAt((int)0).activityInfo.applicationInfo.flags & 8) != 0;
        }
        return false;
    }

    private final int $$robo$$com_android_internal_app_ResolverComparator$compare(ResolverActivity.ResolvedComponentInfo lhsp, ResolverActivity.ResolvedComponentInfo rhsp) {
        CharSequence sb;
        CharSequence sa;
        boolean rhsSpecific;
        boolean lhsSpecific;
        ResolveInfo lhs = lhsp.getResolveInfoAt(0);
        ResolveInfo rhs = rhsp.getResolveInfoAt(0);
        if (lhs.targetUserId != -2) {
            return 1;
        }
        if (this.mHttp && (lhsSpecific = ResolverActivity.isSpecificUriMatch(lhs.match)) != (rhsSpecific = ResolverActivity.isSpecificUriMatch(rhs.match))) {
            return lhsSpecific ? -1 : 1;
        }
        boolean lPinned = lhsp.isPinned();
        boolean rPinned = rhsp.isPinned();
        if (lPinned && !rPinned) {
            return -1;
        }
        if (!lPinned && rPinned) {
            return 1;
        }
        if (!lPinned && !rPinned && this.mStats != null) {
            ScoredTarget lhsTarget = this.mScoredTargets.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
            ScoredTarget rhsTarget = this.mScoredTargets.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
            float diff = rhsTarget.score - lhsTarget.score;
            if (diff != 0.0f) {
                return diff > 0.0f ? 1 : -1;
            }
        }
        if ((sa = lhs.loadLabel(this.mPm)) == null) {
            sa = lhs.activityInfo.name;
        }
        if ((sb = rhs.loadLabel(this.mPm)) == null) {
            sb = rhs.activityInfo.name;
        }
        return this.mCollator.compare(sa.toString().trim(), sb.toString().trim());
    }

    private final float $$robo$$com_android_internal_app_ResolverComparator$getScore(ComponentName name) {
        ScoredTarget target = this.mScoredTargets.get(name);
        if (target != null) {
            return target.score;
        }
        return 0.0f;
    }

    private void __constructor__(Context context, Intent intent, String string2) {
        this.$$robo$$com_android_internal_app_ResolverComparator$__constructor__(context, intent, string2);
    }

    public ResolverComparator(Context context, Intent intent, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverComparator$__constructor__(android.content.Context android.content.Intent java.lang.String ), 0, this, context, intent, string2);
    }

    public void compute(List<ResolverActivity.ResolvedComponentInfo> list) {
        InvokeDynamicSupport.bootstrap("compute", $$robo$$com_android_internal_app_ResolverComparator$compute(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> ), 0, this, list);
    }

    static boolean isPersistentProcess(ResolverActivity.ResolvedComponentInfo resolvedComponentInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPersistentProcess", $$robo$$com_android_internal_app_ResolverComparator$isPersistentProcess(com.android.internal.app.ResolverActivity$ResolvedComponentInfo ), 0, (ResolverActivity.ResolvedComponentInfo)resolvedComponentInfo);
    }

    @Override
    public int compare(ResolverActivity.ResolvedComponentInfo resolvedComponentInfo, ResolverActivity.ResolvedComponentInfo resolvedComponentInfo2) {
        return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_app_ResolverComparator$compare(com.android.internal.app.ResolverActivity$ResolvedComponentInfo com.android.internal.app.ResolverActivity$ResolvedComponentInfo ), 0, this, resolvedComponentInfo, resolvedComponentInfo2);
    }

    public float getScore(ComponentName componentName) {
        return (float)InvokeDynamicSupport.bootstrap("getScore", $$robo$$com_android_internal_app_ResolverComparator$getScore(android.content.ComponentName ), 0, this, componentName);
    }

    public /* synthetic */ ResolverComparator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolverComparator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ScoredTarget
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ComponentInfo componentInfo;
        public float score;
        public long lastTimeUsed;
        public long timeSpent;
        public long launchCount;

        private void $$robo$$com_android_internal_app_ResolverComparator_ScoredTarget$__constructor__(ComponentInfo ci) {
            this.componentInfo = ci;
        }

        private final String $$robo$$com_android_internal_app_ResolverComparator_ScoredTarget$toString() {
            return "ScoredTarget{" + this.componentInfo + " score: " + this.score + " lastTimeUsed: " + this.lastTimeUsed + " timeSpent: " + this.timeSpent + " launchCount: " + this.launchCount + "}";
        }

        private void __constructor__(ComponentInfo componentInfo) {
            this.$$robo$$com_android_internal_app_ResolverComparator_ScoredTarget$__constructor__(componentInfo);
        }

        public ScoredTarget(ComponentInfo componentInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverComparator_ScoredTarget$__constructor__(android.content.pm.ComponentInfo ), 0, this, componentInfo);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_app_ResolverComparator_ScoredTarget$toString(), 0, this);
        }

        public /* synthetic */ ScoredTarget() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScoredTarget)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

