/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import android.widget.Toast;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ResolverActivity;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IntentForwarderActivity
extends Activity
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG;
    public static String FORWARD_INTENT_TO_PARENT;
    public static String FORWARD_INTENT_TO_MANAGED_PROFILE;

    private void $$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__() {
    }

    private final void $$robo$$com_android_internal_app_IntentForwarderActivity$onCreate(Bundle savedInstanceState) {
        int targetUserId;
        int userMessageId;
        super.onCreate(savedInstanceState);
        Intent intentReceived = this.getIntent();
        String className = intentReceived.getComponent().getClassName();
        if (className.equals(FORWARD_INTENT_TO_PARENT)) {
            userMessageId = 17040480;
            targetUserId = this.getProfileParent();
        } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            userMessageId = 17040481;
            targetUserId = this.getManagedProfile();
        } else {
            Slog.wtf(TAG, IntentForwarderActivity.class.getName() + " cannot be called directly");
            userMessageId = -1;
            targetUserId = -10000;
        }
        if (targetUserId == -10000) {
            this.finish();
            return;
        }
        Intent newIntent = new Intent(intentReceived);
        newIntent.setComponent(null);
        newIntent.setPackage(null);
        newIntent.addFlags(0x3000000);
        int callingUserId = this.getUserId();
        if (this.canForward(newIntent, targetUserId)) {
            if ("android.intent.action.CHOOSER".equals(newIntent.getAction())) {
                Intent innerIntent = (Intent)newIntent.getParcelableExtra("android.intent.extra.INTENT");
                innerIntent.prepareToLeaveUser(callingUserId);
            } else {
                newIntent.prepareToLeaveUser(callingUserId);
            }
            ResolveInfo ri = this.getPackageManager().resolveActivityAsUser(newIntent, 65536, targetUserId);
            boolean shouldShowDisclosure = ri == null || ri.activityInfo == null || !"android".equals(ri.activityInfo.packageName) || !ResolverActivity.class.getName().equals(ri.activityInfo.name) && !ChooserActivity.class.getName().equals(ri.activityInfo.name);
            try {
                this.startActivityAsCaller(newIntent, null, false, targetUserId);
            }
            catch (RuntimeException e) {
                int launchedFromUid = -1;
                String launchedFromPackage = "?";
                try {
                    launchedFromUid = ActivityManagerNative.getDefault().getLaunchedFromUid(this.getActivityToken());
                    launchedFromPackage = ActivityManagerNative.getDefault().getLaunchedFromPackage(this.getActivityToken());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                Slog.wtf(TAG, "Unable to launch as UID " + launchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
            }
            if (shouldShowDisclosure) {
                Toast.makeText((Context)this, this.getString(userMessageId), 1).show();
            }
        } else {
            Slog.wtf(TAG, "the intent: " + newIntent + " cannot be forwarded from user " + callingUserId + " to user " + targetUserId);
        }
        this.finish();
    }

    private final boolean $$robo$$com_android_internal_app_IntentForwarderActivity$canForward(Intent intent, int targetUserId) {
        IPackageManager ipm = AppGlobals.getPackageManager();
        if ("android.intent.action.CHOOSER".equals(intent.getAction())) {
            if (intent.hasExtra("android.intent.extra.INITIAL_INTENTS")) {
                Slog.wtf(TAG, "An chooser intent with extra initial intents cannot be forwarded to a different user");
                return false;
            }
            if (intent.hasExtra("android.intent.extra.REPLACEMENT_EXTRAS")) {
                Slog.wtf(TAG, "A chooser intent with replacement extras cannot be forwarded to a different user");
                return false;
            }
            if ((intent = (Intent)intent.getParcelableExtra("android.intent.extra.INTENT")) == null) {
                Slog.wtf(TAG, "Cannot forward a chooser intent with no extra android.intent.extra.INTENT");
                return false;
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (intent.getSelector() != null) {
            intent = intent.getSelector();
        }
        try {
            return ipm.canForwardTo(intent, resolvedType, this.getUserId(), targetUserId);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "PackageManagerService is dead?");
            return false;
        }
    }

    private final int $$robo$$com_android_internal_app_IntentForwarderActivity$getManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        List<UserInfo> relatedUsers = userManager.getProfiles(UserHandle.myUserId());
        for (UserInfo userInfo : relatedUsers) {
            if (!userInfo.isManagedProfile()) continue;
            return userInfo.id;
        }
        Slog.wtf(TAG, FORWARD_INTENT_TO_MANAGED_PROFILE + " has been called, but there is no managed profile");
        return -10000;
    }

    private final int $$robo$$com_android_internal_app_IntentForwarderActivity$getProfileParent() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        UserInfo parent = userManager.getProfileParent(UserHandle.myUserId());
        if (parent == null) {
            Slog.wtf(TAG, FORWARD_INTENT_TO_PARENT + " has been called, but there is no parent");
            return -10000;
        }
        return parent.id;
    }

    static void __staticInitializer__() {
        TAG = "IntentForwarderActivity";
        FORWARD_INTENT_TO_PARENT = "com.android.internal.app.ForwardIntentToParent";
        FORWARD_INTENT_TO_MANAGED_PROFILE = "com.android.internal.app.ForwardIntentToManagedProfile";
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__();
    }

    public IntentForwarderActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__(), 0, this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_IntentForwarderActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    boolean canForward(Intent intent, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("canForward", $$robo$$com_android_internal_app_IntentForwarderActivity$canForward(android.content.Intent int ), 0, this, intent, n);
    }

    private int getManagedProfile() {
        return (int)InvokeDynamicSupport.bootstrap("getManagedProfile", $$robo$$com_android_internal_app_IntentForwarderActivity$getManagedProfile(), 0, this);
    }

    private int getProfileParent() {
        return (int)InvokeDynamicSupport.bootstrap("getProfileParent", $$robo$$com_android_internal_app_IntentForwarderActivity$getProfileParent(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(IntentForwarderActivity.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentForwarderActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

