/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.os.UserManager;
import android.util.Log;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConfirmUserCreationActivity
extends AlertActivity
implements DialogInterface.OnClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CreateUser";
    private String mUserName;
    private String mAccountName;
    private String mAccountType;
    private PersistableBundle mAccountOptions;
    private boolean mCanProceed;
    private UserManager mUserManager;

    private void $$robo$$com_android_internal_app_ConfirmUserCreationActivity$__constructor__() {
    }

    private final void $$robo$$com_android_internal_app_ConfirmUserCreationActivity$onCreate(Bundle icicle) {
        super.onCreate(icicle);
        Intent intent = this.getIntent();
        this.mUserName = intent.getStringExtra("android.os.extra.USER_NAME");
        this.mAccountName = intent.getStringExtra("android.os.extra.USER_ACCOUNT_NAME");
        this.mAccountType = intent.getStringExtra("android.os.extra.USER_ACCOUNT_TYPE");
        this.mAccountOptions = (PersistableBundle)intent.getParcelableExtra("android.os.extra.USER_ACCOUNT_OPTIONS");
        this.mUserManager = this.getSystemService(UserManager.class);
        String message = this.checkUserCreationRequirements();
        if (message == null) {
            this.finish();
            return;
        }
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mMessage = message;
        ap.mPositiveButtonText = this.getString(17039370);
        ap.mPositiveButtonListener = this;
        if (this.mCanProceed) {
            ap.mNegativeButtonText = this.getString(0x1040000);
            ap.mNegativeButtonListener = this;
        }
        this.setupAlert();
    }

    private final String $$robo$$com_android_internal_app_ConfirmUserCreationActivity$checkUserCreationRequirements() {
        ApplicationInfo appInfo;
        String callingPackage = this.getCallingPackage();
        if (callingPackage == null) {
            throw new SecurityException("User Creation intent must be launched with startActivityForResult");
        }
        try {
            appInfo = this.getPackageManager().getApplicationInfo(callingPackage, 0);
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            throw new SecurityException("Cannot find the calling package");
        }
        boolean cantCreateUser = this.mUserManager.hasUserRestriction("no_add_user") || !this.mUserManager.isAdminUser();
        boolean cantCreateAnyMoreUsers = !this.mUserManager.canAddMoreUsers();
        Account account = new Account(this.mAccountName, this.mAccountType);
        boolean accountExists = this.mAccountName != null && this.mAccountType != null && AccountManager.get(this).someUserHasAccount(account) | this.mUserManager.someUserHasSeedAccount(this.mAccountName, this.mAccountType);
        this.mCanProceed = true;
        String appName = appInfo.loadLabel(this.getPackageManager()).toString();
        if (cantCreateUser) {
            this.setResult(1);
            return null;
        }
        if (cantCreateAnyMoreUsers) {
            this.setResult(2);
            return null;
        }
        String message = accountExists ? this.getString(17040849, appName, this.mAccountName) : this.getString(17040850, appName, this.mAccountName);
        return message;
    }

    private final void $$robo$$com_android_internal_app_ConfirmUserCreationActivity$onClick(DialogInterface dialog, int which) {
        this.setResult(0);
        if (which == -1 && this.mCanProceed) {
            Log.i("CreateUser", "Ok, creating user");
            UserInfo user = this.mUserManager.createUser(this.mUserName, 0);
            if (user == null) {
                Log.e("CreateUser", "Couldn't create user");
                this.finish();
                return;
            }
            this.mUserManager.setSeedAccountData(user.id, this.mAccountName, this.mAccountType, this.mAccountOptions);
            this.setResult(-1);
        }
        this.finish();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_ConfirmUserCreationActivity$__constructor__();
    }

    public ConfirmUserCreationActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ConfirmUserCreationActivity$__constructor__(), 0, this);
    }

    @Override
    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_ConfirmUserCreationActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    private String checkUserCreationRequirements() {
        return InvokeDynamicSupport.bootstrap("checkUserCreationRequirements", $$robo$$com_android_internal_app_ConfirmUserCreationActivity$checkUserCreationRequirements(), 0, this);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_ConfirmUserCreationActivity$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfirmUserCreationActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

