/*
 * Decompiled with CFR 0.152.
 */
package com.android.framework.protobuf.nano;

import com.android.framework.protobuf.nano.InvalidProtocolBufferNanoException;
import com.android.framework.protobuf.nano.MessageNano;
import com.android.framework.protobuf.nano.WireFormatNano;
import java.io.IOException;

public final class CodedInputByteBufferNano {
    private final byte[] buffer;
    private int bufferStart;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private int lastTag;
    private int currentLimit = Integer.MAX_VALUE;
    private int recursionDepth;
    private int recursionLimit = 64;
    private int sizeLimit = 0x4000000;
    private static final int DEFAULT_RECURSION_LIMIT = 64;
    private static final int DEFAULT_SIZE_LIMIT = 0x4000000;

    public static CodedInputByteBufferNano newInstance(byte[] buf) {
        return CodedInputByteBufferNano.newInstance(buf, 0, buf.length);
    }

    public static CodedInputByteBufferNano newInstance(byte[] buf, int off, int len) {
        return new CodedInputByteBufferNano(buf, off, len);
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (this.lastTag == 0) {
            throw InvalidProtocolBufferNanoException.invalidTag();
        }
        return this.lastTag;
    }

    public void checkLastTagWas(int value) throws InvalidProtocolBufferNanoException {
        if (this.lastTag != value) {
            throw InvalidProtocolBufferNanoException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormatNano.getTagWireType(tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormatNano.makeTag(WireFormatNano.getTagFieldNumber(tag), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw InvalidProtocolBufferNanoException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        return this.readRawVarint32() != 0;
    }

    public String readString() throws IOException {
        int size = this.readRawVarint32();
        if (size < 0) {
            throw InvalidProtocolBufferNanoException.negativeSize();
        }
        if (size > this.bufferSize - this.bufferPos) {
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        String result = new String(this.buffer, this.bufferPos, size, "UTF-8");
        this.bufferPos += size;
        return result;
    }

    public void readGroup(MessageNano msg, int fieldNumber) throws IOException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferNanoException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        msg.mergeFrom(this);
        this.checkLastTagWas(WireFormatNano.makeTag(fieldNumber, 4));
        --this.recursionDepth;
    }

    public void readMessage(MessageNano msg) throws IOException {
        int length = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferNanoException.recursionLimitExceeded();
        }
        int oldLimit = this.pushLimit(length);
        ++this.recursionDepth;
        msg.mergeFrom(this);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(oldLimit);
    }

    public byte[] readBytes() throws IOException {
        int size = this.readRawVarint32();
        if (size < 0) {
            throw InvalidProtocolBufferNanoException.negativeSize();
        }
        if (size == 0) {
            return WireFormatNano.EMPTY_BYTES;
        }
        if (size > this.bufferSize - this.bufferPos) {
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        byte[] result = new byte[size];
        System.arraycopy(this.buffer, this.bufferPos, result, 0, size);
        this.bufferPos += size;
        return result;
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() throws IOException {
        return CodedInputByteBufferNano.decodeZigZag32(this.readRawVarint32());
    }

    public long readSInt64() throws IOException {
        return CodedInputByteBufferNano.decodeZigZag64(this.readRawVarint64());
    }

    public int readRawVarint32() throws IOException {
        byte tmp = this.readRawByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = this.readRawByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = this.readRawByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = this.readRawByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.readRawByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.readRawByte() < 0) continue;
                            return result;
                        }
                        throw InvalidProtocolBufferNanoException.malformedVarint();
                    }
                }
            }
        }
        return result;
    }

    public long readRawVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw InvalidProtocolBufferNanoException.malformedVarint();
    }

    public int readRawLittleEndian32() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        byte b5 = this.readRawByte();
        byte b6 = this.readRawByte();
        byte b7 = this.readRawByte();
        byte b8 = this.readRawByte();
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private CodedInputByteBufferNano(byte[] buffer, int off, int len) {
        this.buffer = buffer;
        this.bufferStart = off;
        this.bufferSize = off + len;
        this.bufferPos = off;
    }

    public int setRecursionLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + limit);
        }
        int oldLimit = this.recursionLimit;
        this.recursionLimit = limit;
        return oldLimit;
    }

    public int setSizeLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Size limit cannot be negative: " + limit);
        }
        int oldLimit = this.sizeLimit;
        this.sizeLimit = limit;
        return oldLimit;
    }

    public void resetSizeCounter() {
    }

    public int pushLimit(int byteLimit) throws InvalidProtocolBufferNanoException {
        if (byteLimit < 0) {
            throw InvalidProtocolBufferNanoException.negativeSize();
        }
        int oldLimit = this.currentLimit;
        if ((byteLimit += this.bufferPos) > oldLimit) {
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        this.currentLimit = byteLimit;
        this.recomputeBufferSizeAfterLimit();
        return oldLimit;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int bufferEnd = this.bufferSize;
        if (bufferEnd > this.currentLimit) {
            this.bufferSizeAfterLimit = bufferEnd - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    public void popLimit(int oldLimit) {
        this.currentLimit = oldLimit;
        this.recomputeBufferSizeAfterLimit();
    }

    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int currentAbsolutePosition = this.bufferPos;
        return this.currentLimit - currentAbsolutePosition;
    }

    public boolean isAtEnd() {
        return this.bufferPos == this.bufferSize;
    }

    public int getPosition() {
        return this.bufferPos - this.bufferStart;
    }

    public int getAbsolutePosition() {
        return this.bufferPos;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] getData(int offset, int length) {
        if (length == 0) {
            return WireFormatNano.EMPTY_BYTES;
        }
        byte[] copy = new byte[length];
        int start = this.bufferStart + offset;
        System.arraycopy(this.buffer, start, copy, 0, length);
        return copy;
    }

    public void rewindToPosition(int position) {
        if (position > this.bufferPos - this.bufferStart) {
            throw new IllegalArgumentException("Position " + position + " is beyond current " + (this.bufferPos - this.bufferStart));
        }
        if (position < 0) {
            throw new IllegalArgumentException("Bad position " + position);
        }
        this.bufferPos = this.bufferStart + position;
    }

    public byte readRawByte() throws IOException {
        if (this.bufferPos == this.bufferSize) {
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        return this.buffer[this.bufferPos++];
    }

    public byte[] readRawBytes(int size) throws IOException {
        if (size < 0) {
            throw InvalidProtocolBufferNanoException.negativeSize();
        }
        if (this.bufferPos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.bufferPos);
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        if (size <= this.bufferSize - this.bufferPos) {
            byte[] bytes = new byte[size];
            System.arraycopy(this.buffer, this.bufferPos, bytes, 0, size);
            this.bufferPos += size;
            return bytes;
        }
        throw InvalidProtocolBufferNanoException.truncatedMessage();
    }

    public void skipRawBytes(int size) throws IOException {
        if (size < 0) {
            throw InvalidProtocolBufferNanoException.negativeSize();
        }
        if (this.bufferPos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.bufferPos);
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        if (size <= this.bufferSize - this.bufferPos) {
            this.bufferPos += size;
        } else {
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
    }
}

