/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.UndoManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ParcelableParcel;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.BoringLayout;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.AllCapsTransformationMethod;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.BaseKeyListener;
import android.text.method.DateKeyListener;
import android.text.method.DateTimeKeyListener;
import android.text.method.DialerKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.LinkMovementMethod;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TextKeyListener;
import android.text.method.TimeKeyListener;
import android.text.method.TransformationMethod;
import android.text.method.TransformationMethod2;
import android.text.method.WordIterator;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ParagraphStyle;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionSpan;
import android.text.style.URLSpan;
import android.text.style.UpdateAppearance;
import android.text.util.Linkify;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.AccessibilityIterators;
import android.view.ActionMode;
import android.view.Choreographer;
import android.view.ContextMenu;
import android.view.DragEvent;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.ViewStructure;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.SpellCheckerSubtype;
import android.view.textservice.TextServicesManager;
import android.widget.AccessibilityIterators;
import android.widget.Editor;
import android.widget.RemoteViews;
import android.widget.Scroller;
import android.widget.SpellChecker;
import android.widget.Toast;
import com.android.internal.R;
import com.android.internal.util.FastMath;
import com.android.internal.widget.EditableInputConnection;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@RemoteViews.RemoteView
public class TextView
extends View
implements ViewTreeObserver.OnPreDrawListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "TextView";
    static boolean DEBUG_EXTRACT = false;
    private static int SANS = 1;
    private static int SERIF = 2;
    private static int MONOSPACE = 3;
    private static int SIGNED = 2;
    private static int DECIMAL = 4;
    private static int MARQUEE_FADE_NORMAL = 0;
    private static int MARQUEE_FADE_SWITCH_SHOW_ELLIPSIS = 1;
    private static int MARQUEE_FADE_SWITCH_SHOW_FADE = 2;
    private static int LINES = 1;
    private static int EMS = 1;
    private static int PIXELS = 2;
    private static RectF TEMP_RECTF;
    static int VERY_WIDE = 0x100000;
    private static int ANIMATED_SCROLL_GAP = 250;
    private static InputFilter[] NO_FILTERS;
    private static Spanned EMPTY_SPANNED;
    private static int CHANGE_WATCHER_PRIORITY = 100;
    private static int[] MULTILINE_STATE_SET;
    private static int ACCESSIBILITY_ACTION_SHARE = 0x10000000;
    static int ACCESSIBILITY_ACTION_PROCESS_TEXT_START_ID = 0x10000100;
    static int PROCESS_TEXT_REQUEST_CODE = 100;
    private static int KEY_EVENT_NOT_HANDLED = 0;
    private static int KEY_EVENT_HANDLED = -1;
    private static int KEY_DOWN_HANDLED_BY_KEY_LISTENER = 1;
    private static int KEY_DOWN_HANDLED_BY_MOVEMENT_METHOD = 2;
    static long sLastCutCopyOrTextChangedTime;
    private ColorStateList mTextColor;
    private ColorStateList mHintTextColor;
    private ColorStateList mLinkTextColor;
    @ViewDebug.ExportedProperty(category="text")
    private int mCurTextColor;
    private int mCurHintTextColor;
    private boolean mFreezesText;
    private Editable.Factory mEditableFactory;
    private Spannable.Factory mSpannableFactory;
    private float mShadowRadius;
    private float mShadowDx;
    private float mShadowDy;
    private int mShadowColor;
    private boolean mPreDrawRegistered;
    private boolean mPreDrawListenerDetached;
    private boolean mPreventDefaultMovement;
    private TextUtils.TruncateAt mEllipsize;
    Drawables mDrawables;
    private CharWrapper mCharWrapper;
    private Marquee mMarquee;
    private boolean mRestartMarquee;
    private int mMarqueeRepeatLimit;
    private int mLastLayoutDirection;
    private int mMarqueeFadeMode;
    private Layout mSavedMarqueeModeLayout;
    @ViewDebug.ExportedProperty(category="text")
    private CharSequence mText;
    private CharSequence mTransformed;
    private BufferType mBufferType;
    private CharSequence mHint;
    private Layout mHintLayout;
    private MovementMethod mMovement;
    private TransformationMethod mTransformation;
    private boolean mAllowTransformationLengthChange;
    private ChangeWatcher mChangeWatcher;
    private ArrayList<TextWatcher> mListeners;
    private TextPaint mTextPaint;
    private boolean mUserSetTextScaleX;
    private Layout mLayout;
    private boolean mLocalesChanged;
    @ViewDebug.ExportedProperty(category="text")
    private int mGravity;
    private boolean mHorizontallyScrolling;
    private int mAutoLinkMask;
    private boolean mLinksClickable;
    private float mSpacingMult;
    private float mSpacingAdd;
    private int mBreakStrategy;
    private int mHyphenationFrequency;
    private int mMaximum;
    private int mMaxMode;
    private int mMinimum;
    private int mMinMode;
    private int mOldMaximum;
    private int mOldMaxMode;
    private int mMaxWidth;
    private int mMaxWidthMode;
    private int mMinWidth;
    private int mMinWidthMode;
    private boolean mSingleLine;
    private int mDesiredHeightAtMeasure;
    private boolean mIncludePad;
    private int mDeferScroll;
    private Rect mTempRect;
    private long mLastScroll;
    private Scroller mScroller;
    private BoringLayout.Metrics mBoring;
    private BoringLayout.Metrics mHintBoring;
    private BoringLayout mSavedLayout;
    private BoringLayout mSavedHintLayout;
    private TextDirectionHeuristic mTextDir;
    private InputFilter[] mFilters;
    private volatile Locale mCurrentSpellCheckerLocaleCache;
    int mHighlightColor;
    private Path mHighlightPath;
    private Paint mHighlightPaint;
    private boolean mHighlightPathBogus;
    int mCursorDrawableRes;
    int mTextSelectHandleLeftRes;
    int mTextSelectHandleRightRes;
    int mTextSelectHandleRes;
    int mTextEditSuggestionItemLayout;
    int mTextEditSuggestionContainerLayout;
    int mTextEditSuggestionHighlightStyle;
    private Editor mEditor;
    private static int DEVICE_PROVISIONED_UNKNOWN = 0;
    private static int DEVICE_PROVISIONED_NO = 1;
    private static int DEVICE_PROVISIONED_YES = 2;
    private int mDeviceProvisionedState;
    private static BoringLayout.Metrics UNKNOWN_BORING;
    static int ID_SELECT_ALL = 16908319;
    static int ID_UNDO = 16908338;
    static int ID_REDO = 16908339;
    static int ID_CUT = 0x1020020;
    static int ID_COPY = 0x1020021;
    static int ID_PASTE = 0x1020022;
    static int ID_SHARE = 16908341;
    static int ID_PASTE_AS_PLAIN_TEXT = 16908337;
    static int ID_REPLACE = 16908340;

    private static final void $$robo$$android_widget_TextView$preloadFontCache() {
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.measureText("H");
    }

    private void $$robo$$android_widget_TextView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_TextView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_TextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_TextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        boolean numberPasswordInputType;
        this.mEditableFactory = Editable.Factory.getInstance();
        this.mSpannableFactory = Spannable.Factory.getInstance();
        this.mMarqueeRepeatLimit = 3;
        this.mLastLayoutDirection = -1;
        this.mMarqueeFadeMode = 0;
        this.mBufferType = BufferType.NORMAL;
        this.mLocalesChanged = false;
        this.mGravity = 0x800033;
        this.mLinksClickable = true;
        this.mSpacingMult = 1.0f;
        this.mSpacingAdd = 0.0f;
        this.mMaximum = Integer.MAX_VALUE;
        this.mMaxMode = 1;
        this.mMinimum = 0;
        this.mMinMode = 1;
        this.mOldMaximum = this.mMaximum;
        this.mOldMaxMode = this.mMaxMode;
        this.mMaxWidth = Integer.MAX_VALUE;
        this.mMaxWidthMode = 2;
        this.mMinWidth = 0;
        this.mMinWidthMode = 2;
        this.mDesiredHeightAtMeasure = -1;
        this.mIncludePad = true;
        this.mDeferScroll = -1;
        this.mFilters = NO_FILTERS;
        this.mHighlightColor = 1714664933;
        this.mHighlightPathBogus = true;
        this.mDeviceProvisionedState = 0;
        this.mText = "";
        Resources res = this.getResources();
        CompatibilityInfo compat = res.getCompatibilityInfo();
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setCompatibilityScaling(compat.applicationScale);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setCompatibilityScaling(compat.applicationScale);
        this.mMovement = this.getDefaultMovementMethod();
        this.mTransformation = null;
        int textColorHighlight = 0;
        ColorStateList textColor = null;
        ColorStateList textColorHint = null;
        ColorStateList textColorLink = null;
        int textSize = 15;
        String fontFamily = null;
        boolean fontFamilyExplicit = false;
        int typefaceIndex = -1;
        int styleIndex = -1;
        boolean allCaps = false;
        int shadowcolor = 0;
        float dx = 0.0f;
        float dy = 0.0f;
        float r = 0.0f;
        boolean elegant = false;
        float letterSpacing = 0.0f;
        String fontFeatureSettings = null;
        this.mBreakStrategy = 0;
        this.mHyphenationFrequency = 0;
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.TextViewAppearance, defStyleAttr, defStyleRes);
        TypedArray appearance = null;
        int ap = a.getResourceId(0, -1);
        a.recycle();
        if (ap != -1) {
            appearance = theme.obtainStyledAttributes(ap, R.styleable.TextAppearance);
        }
        if (appearance != null) {
            int n = appearance.getIndexCount();
            block132: for (int i = 0; i < n; ++i) {
                int attr2 = appearance.getIndex(i);
                switch (attr2) {
                    case 4: {
                        textColorHighlight = appearance.getColor(attr2, textColorHighlight);
                        continue block132;
                    }
                    case 3: {
                        textColor = appearance.getColorStateList(attr2);
                        continue block132;
                    }
                    case 5: {
                        textColorHint = appearance.getColorStateList(attr2);
                        continue block132;
                    }
                    case 6: {
                        textColorLink = appearance.getColorStateList(attr2);
                        continue block132;
                    }
                    case 0: {
                        textSize = appearance.getDimensionPixelSize(attr2, textSize);
                        continue block132;
                    }
                    case 1: {
                        typefaceIndex = appearance.getInt(attr2, -1);
                        continue block132;
                    }
                    case 12: {
                        fontFamily = appearance.getString(attr2);
                        continue block132;
                    }
                    case 2: {
                        styleIndex = appearance.getInt(attr2, -1);
                        continue block132;
                    }
                    case 11: {
                        allCaps = appearance.getBoolean(attr2, false);
                        continue block132;
                    }
                    case 7: {
                        shadowcolor = appearance.getInt(attr2, 0);
                        continue block132;
                    }
                    case 8: {
                        dx = appearance.getFloat(attr2, 0.0f);
                        continue block132;
                    }
                    case 9: {
                        dy = appearance.getFloat(attr2, 0.0f);
                        continue block132;
                    }
                    case 10: {
                        r = appearance.getFloat(attr2, 0.0f);
                        continue block132;
                    }
                    case 13: {
                        elegant = appearance.getBoolean(attr2, false);
                        continue block132;
                    }
                    case 14: {
                        letterSpacing = appearance.getFloat(attr2, 0.0f);
                        continue block132;
                    }
                    case 15: {
                        fontFeatureSettings = appearance.getString(attr2);
                    }
                }
            }
            appearance.recycle();
        }
        boolean editable = this.getDefaultEditable();
        CharSequence inputMethod = null;
        int numeric = 0;
        CharSequence digits = null;
        boolean phone = false;
        boolean autotext = false;
        int autocap = -1;
        int buffertype = 0;
        boolean selectallonfocus = false;
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        Drawable drawableStart = null;
        Drawable drawableEnd = null;
        ColorStateList drawableTint = null;
        PorterDuff.Mode drawableTintMode = null;
        int drawablePadding = 0;
        int ellipsize = -1;
        boolean singleLine = false;
        int maxlength = -1;
        CharSequence text = "";
        CharSequence hint = null;
        boolean password = false;
        int inputType = 0;
        a = theme.obtainStyledAttributes(attrs, R.styleable.TextView, defStyleAttr, defStyleRes);
        int n = a.getIndexCount();
        block133: for (int i = 0; i < n; ++i) {
            int attr3 = a.getIndex(i);
            switch (attr3) {
                case 46: {
                    editable = a.getBoolean(attr3, editable);
                    continue block133;
                }
                case 43: {
                    inputMethod = a.getText(attr3);
                    continue block133;
                }
                case 40: {
                    numeric = a.getInt(attr3, numeric);
                    continue block133;
                }
                case 41: {
                    digits = a.getText(attr3);
                    continue block133;
                }
                case 42: {
                    phone = a.getBoolean(attr3, phone);
                    continue block133;
                }
                case 45: {
                    autotext = a.getBoolean(attr3, autotext);
                    continue block133;
                }
                case 44: {
                    autocap = a.getInt(attr3, autocap);
                    continue block133;
                }
                case 17: {
                    buffertype = a.getInt(attr3, buffertype);
                    continue block133;
                }
                case 33: {
                    selectallonfocus = a.getBoolean(attr3, selectallonfocus);
                    continue block133;
                }
                case 11: {
                    this.mAutoLinkMask = a.getInt(attr3, 0);
                    continue block133;
                }
                case 12: {
                    this.mLinksClickable = a.getBoolean(attr3, true);
                    continue block133;
                }
                case 50: {
                    drawableLeft = a.getDrawable(attr3);
                    continue block133;
                }
                case 48: {
                    drawableTop = a.getDrawable(attr3);
                    continue block133;
                }
                case 51: {
                    drawableRight = a.getDrawable(attr3);
                    continue block133;
                }
                case 49: {
                    drawableBottom = a.getDrawable(attr3);
                    continue block133;
                }
                case 73: {
                    drawableStart = a.getDrawable(attr3);
                    continue block133;
                }
                case 74: {
                    drawableEnd = a.getDrawable(attr3);
                    continue block133;
                }
                case 79: {
                    drawableTint = a.getColorStateList(attr3);
                    continue block133;
                }
                case 80: {
                    drawableTintMode = Drawable.parseTintMode(a.getInt(attr3, -1), drawableTintMode);
                    continue block133;
                }
                case 52: {
                    drawablePadding = a.getDimensionPixelSize(attr3, drawablePadding);
                    continue block133;
                }
                case 22: {
                    this.setMaxLines(a.getInt(attr3, -1));
                    continue block133;
                }
                case 14: {
                    this.setMaxHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block133;
                }
                case 23: {
                    this.setLines(a.getInt(attr3, -1));
                    continue block133;
                }
                case 24: {
                    this.setHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block133;
                }
                case 25: {
                    this.setMinLines(a.getInt(attr3, -1));
                    continue block133;
                }
                case 16: {
                    this.setMinHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block133;
                }
                case 26: {
                    this.setMaxEms(a.getInt(attr3, -1));
                    continue block133;
                }
                case 13: {
                    this.setMaxWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block133;
                }
                case 27: {
                    this.setEms(a.getInt(attr3, -1));
                    continue block133;
                }
                case 28: {
                    this.setWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block133;
                }
                case 29: {
                    this.setMinEms(a.getInt(attr3, -1));
                    continue block133;
                }
                case 15: {
                    this.setMinWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block133;
                }
                case 10: {
                    this.setGravity(a.getInt(attr3, -1));
                    continue block133;
                }
                case 19: {
                    hint = a.getText(attr3);
                    continue block133;
                }
                case 18: {
                    text = a.getText(attr3);
                    continue block133;
                }
                case 30: {
                    if (!a.getBoolean(attr3, false)) continue block133;
                    this.setHorizontallyScrolling(true);
                    continue block133;
                }
                case 32: {
                    singleLine = a.getBoolean(attr3, singleLine);
                    continue block133;
                }
                case 9: {
                    ellipsize = a.getInt(attr3, ellipsize);
                    continue block133;
                }
                case 55: {
                    this.setMarqueeRepeatLimit(a.getInt(attr3, this.mMarqueeRepeatLimit));
                    continue block133;
                }
                case 34: {
                    if (a.getBoolean(attr3, true)) continue block133;
                    this.setIncludeFontPadding(false);
                    continue block133;
                }
                case 21: {
                    if (a.getBoolean(attr3, true)) continue block133;
                    this.setCursorVisible(false);
                    continue block133;
                }
                case 35: {
                    maxlength = a.getInt(attr3, -1);
                    continue block133;
                }
                case 20: {
                    this.setTextScaleX(a.getFloat(attr3, 1.0f));
                    continue block133;
                }
                case 47: {
                    this.mFreezesText = a.getBoolean(attr3, false);
                    continue block133;
                }
                case 36: {
                    shadowcolor = a.getInt(attr3, 0);
                    continue block133;
                }
                case 37: {
                    dx = a.getFloat(attr3, 0.0f);
                    continue block133;
                }
                case 38: {
                    dy = a.getFloat(attr3, 0.0f);
                    continue block133;
                }
                case 39: {
                    r = a.getFloat(attr3, 0.0f);
                    continue block133;
                }
                case 0: {
                    this.setEnabled(a.getBoolean(attr3, this.isEnabled()));
                    continue block133;
                }
                case 6: {
                    textColorHighlight = a.getColor(attr3, textColorHighlight);
                    continue block133;
                }
                case 5: {
                    textColor = a.getColorStateList(attr3);
                    continue block133;
                }
                case 7: {
                    textColorHint = a.getColorStateList(attr3);
                    continue block133;
                }
                case 8: {
                    textColorLink = a.getColorStateList(attr3);
                    continue block133;
                }
                case 2: {
                    textSize = a.getDimensionPixelSize(attr3, textSize);
                    continue block133;
                }
                case 3: {
                    typefaceIndex = a.getInt(attr3, typefaceIndex);
                    continue block133;
                }
                case 4: {
                    styleIndex = a.getInt(attr3, styleIndex);
                    continue block133;
                }
                case 75: {
                    fontFamily = a.getString(attr3);
                    fontFamilyExplicit = true;
                    continue block133;
                }
                case 31: {
                    password = a.getBoolean(attr3, password);
                    continue block133;
                }
                case 53: {
                    this.mSpacingAdd = a.getDimensionPixelSize(attr3, (int)this.mSpacingAdd);
                    continue block133;
                }
                case 54: {
                    this.mSpacingMult = a.getFloat(attr3, this.mSpacingMult);
                    continue block133;
                }
                case 56: {
                    inputType = a.getInt(attr3, 0);
                    continue block133;
                }
                case 83: {
                    this.createEditorIfNeeded();
                    this.mEditor.mAllowUndo = a.getBoolean(attr3, true);
                    continue block133;
                }
                case 59: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeOptions = a.getInt(attr3, this.mEditor.mInputContentType.imeOptions);
                    continue block133;
                }
                case 60: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeActionLabel = a.getText(attr3);
                    continue block133;
                }
                case 61: {
                    this.createEditorIfNeeded();
                    this.mEditor.createInputContentTypeIfNeeded();
                    this.mEditor.mInputContentType.imeActionId = a.getInt(attr3, this.mEditor.mInputContentType.imeActionId);
                    continue block133;
                }
                case 57: {
                    this.setPrivateImeOptions(a.getString(attr3));
                    continue block133;
                }
                case 58: {
                    try {
                        this.setInputExtras(a.getResourceId(attr3, 0));
                    }
                    catch (XmlPullParserException e) {
                        Log.w("TextView", "Failure reading input extras", e);
                    }
                    catch (IOException e) {
                        Log.w("TextView", "Failure reading input extras", e);
                    }
                    continue block133;
                }
                case 70: {
                    this.mCursorDrawableRes = a.getResourceId(attr3, 0);
                    continue block133;
                }
                case 62: {
                    this.mTextSelectHandleLeftRes = a.getResourceId(attr3, 0);
                    continue block133;
                }
                case 63: {
                    this.mTextSelectHandleRightRes = a.getResourceId(attr3, 0);
                    continue block133;
                }
                case 64: {
                    this.mTextSelectHandleRes = a.getResourceId(attr3, 0);
                    continue block133;
                }
                case 71: {
                    this.mTextEditSuggestionItemLayout = a.getResourceId(attr3, 0);
                    continue block133;
                }
                case 84: {
                    this.mTextEditSuggestionContainerLayout = a.getResourceId(attr3, 0);
                    continue block133;
                }
                case 85: {
                    this.mTextEditSuggestionHighlightStyle = a.getResourceId(attr3, 0);
                    continue block133;
                }
                case 67: {
                    this.setTextIsSelectable(a.getBoolean(attr3, false));
                    continue block133;
                }
                case 72: {
                    allCaps = a.getBoolean(attr3, false);
                    continue block133;
                }
                case 76: {
                    elegant = a.getBoolean(attr3, false);
                    continue block133;
                }
                case 77: {
                    letterSpacing = a.getFloat(attr3, 0.0f);
                    continue block133;
                }
                case 78: {
                    fontFeatureSettings = a.getString(attr3);
                    continue block133;
                }
                case 81: {
                    this.mBreakStrategy = a.getInt(attr3, 0);
                    continue block133;
                }
                case 82: {
                    this.mHyphenationFrequency = a.getInt(attr3, 0);
                }
            }
        }
        a.recycle();
        BufferType bufferType = BufferType.EDITABLE;
        int variation = inputType & 0xFFF;
        boolean passwordInputType = variation == 129;
        boolean webPasswordInputType = variation == 225;
        boolean bl = numberPasswordInputType = variation == 18;
        if (inputMethod != null) {
            Class<?> c;
            try {
                c = Class.forName(inputMethod.toString());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.createEditorIfNeeded();
                this.mEditor.mKeyListener = (KeyListener)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.mEditor.mInputType = inputType != 0 ? inputType : this.mEditor.mKeyListener.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mEditor.mInputType = 1;
            }
        } else if (digits != null) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DigitsKeyListener.getInstance(digits.toString());
            this.mEditor.mInputType = inputType != 0 ? inputType : 1;
        } else if (inputType != 0) {
            this.setInputType(inputType, true);
            singleLine = !TextView.isMultilineInputType(inputType);
        } else if (phone) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DialerKeyListener.getInstance();
            inputType = 3;
            this.mEditor.mInputType = 3;
        } else if (numeric != 0) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = DigitsKeyListener.getInstance((numeric & 2) != 0, (numeric & 4) != 0);
            inputType = 2;
            if ((numeric & 2) != 0) {
                inputType |= 0x1000;
            }
            if ((numeric & 4) != 0) {
                inputType |= 0x2000;
            }
            this.mEditor.mInputType = inputType;
        } else if (autotext || autocap != -1) {
            TextKeyListener.Capitalize cap;
            inputType = 1;
            switch (autocap) {
                case 1: {
                    cap = TextKeyListener.Capitalize.SENTENCES;
                    inputType |= 0x4000;
                    break;
                }
                case 2: {
                    cap = TextKeyListener.Capitalize.WORDS;
                    inputType |= 0x2000;
                    break;
                }
                case 3: {
                    cap = TextKeyListener.Capitalize.CHARACTERS;
                    inputType |= 0x1000;
                    break;
                }
                default: {
                    cap = TextKeyListener.Capitalize.NONE;
                }
            }
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = TextKeyListener.getInstance(autotext, cap);
            this.mEditor.mInputType = inputType;
        } else if (this.isTextSelectable()) {
            if (this.mEditor != null) {
                this.mEditor.mKeyListener = null;
                this.mEditor.mInputType = 0;
            }
            bufferType = BufferType.SPANNABLE;
            this.setMovementMethod(ArrowKeyMovementMethod.getInstance());
        } else if (editable) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = TextKeyListener.getInstance();
            this.mEditor.mInputType = 1;
        } else {
            if (this.mEditor != null) {
                this.mEditor.mKeyListener = null;
            }
            switch (buffertype) {
                case 0: {
                    bufferType = BufferType.NORMAL;
                    break;
                }
                case 1: {
                    bufferType = BufferType.SPANNABLE;
                    break;
                }
                case 2: {
                    bufferType = BufferType.EDITABLE;
                }
            }
        }
        if (this.mEditor != null) {
            this.mEditor.adjustInputType(password, passwordInputType, webPasswordInputType, numberPasswordInputType);
        }
        if (selectallonfocus) {
            this.createEditorIfNeeded();
            this.mEditor.mSelectAllOnFocus = true;
            if (bufferType == BufferType.NORMAL) {
                bufferType = BufferType.SPANNABLE;
            }
        }
        if (drawableTint != null || drawableTintMode != null) {
            if (this.mDrawables == null) {
                this.mDrawables = new Drawables(context);
            }
            if (drawableTint != null) {
                this.mDrawables.mTintList = drawableTint;
                this.mDrawables.mHasTint = true;
            }
            if (drawableTintMode != null) {
                this.mDrawables.mTintMode = drawableTintMode;
                this.mDrawables.mHasTintMode = true;
            }
        }
        this.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        this.setRelativeDrawablesIfNeeded(drawableStart, drawableEnd);
        this.setCompoundDrawablePadding(drawablePadding);
        this.setInputTypeSingleLine(singleLine);
        this.applySingleLine(singleLine, singleLine, singleLine);
        if (singleLine && this.getKeyListener() == null && ellipsize < 0) {
            ellipsize = 3;
        }
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                if (ViewConfiguration.get(context).isFadingMarqueeEnabled()) {
                    this.setHorizontalFadingEdgeEnabled(true);
                    this.mMarqueeFadeMode = 0;
                } else {
                    this.setHorizontalFadingEdgeEnabled(false);
                    this.mMarqueeFadeMode = 1;
                }
                this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
        this.setTextColor(textColor != null ? textColor : ColorStateList.valueOf(-16777216));
        this.setHintTextColor(textColorHint);
        this.setLinkTextColor(textColorLink);
        if (textColorHighlight != 0) {
            this.setHighlightColor(textColorHighlight);
        }
        this.setRawTextSize(textSize);
        this.setElegantTextHeight(elegant);
        this.setLetterSpacing(letterSpacing);
        this.setFontFeatureSettings(fontFeatureSettings);
        if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        }
        if (password || passwordInputType || webPasswordInputType || numberPasswordInputType) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            typefaceIndex = 3;
        } else if (this.mEditor != null && (this.mEditor.mInputType & 0xFFF) == 129) {
            typefaceIndex = 3;
        }
        if (typefaceIndex != -1 && !fontFamilyExplicit) {
            fontFamily = null;
        }
        this.setTypefaceFromAttrs(fontFamily, typefaceIndex, styleIndex);
        if (shadowcolor != 0) {
            this.setShadowLayer(r, dx, dy, shadowcolor);
        }
        if (maxlength >= 0) {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxlength)});
        } else {
            this.setFilters(NO_FILTERS);
        }
        this.setText(text, bufferType);
        if (hint != null) {
            this.setHint(hint);
        }
        a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyleAttr, defStyleRes);
        boolean focusable = this.mMovement != null || this.getKeyListener() != null;
        boolean clickable = focusable || this.isClickable();
        boolean longClickable = focusable || this.isLongClickable();
        n = a.getIndexCount();
        block134: for (int i = 0; i < n; ++i) {
            int attr4 = a.getIndex(i);
            switch (attr4) {
                case 19: {
                    focusable = a.getBoolean(attr4, focusable);
                    continue block134;
                }
                case 30: {
                    clickable = a.getBoolean(attr4, clickable);
                    continue block134;
                }
                case 31: {
                    longClickable = a.getBoolean(attr4, longClickable);
                }
            }
        }
        a.recycle();
        this.setFocusable(focusable);
        this.setClickable(clickable);
        this.setLongClickable(longClickable);
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    private final int[] $$robo$$android_widget_TextView$parseDimensionArray(TypedArray dimens) {
        if (dimens == null) {
            return null;
        }
        int[] result = new int[dimens.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = dimens.getDimensionPixelSize(i, 0);
        }
        return result;
    }

    private final void $$robo$$android_widget_TextView$onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 100) {
            if (resultCode == -1 && data != null) {
                CharSequence result = data.getCharSequenceExtra("android.intent.extra.PROCESS_TEXT");
                if (result != null) {
                    if (this.isTextEditable()) {
                        this.replaceSelectionWithText(result);
                        if (this.mEditor != null) {
                            this.mEditor.refreshTextActionMode();
                        }
                    } else if (result.length() > 0) {
                        Toast.makeText(this.getContext(), String.valueOf(result), 1).show();
                    }
                }
            } else if (this.mText instanceof Spannable) {
                Selection.setSelection((Spannable)this.mText, this.getSelectionEnd());
            }
        }
    }

    private final void $$robo$$android_widget_TextView$setTypefaceFromAttrs(String familyName, int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        if (familyName != null && (tf = Typeface.create(familyName, styleIndex)) != null) {
            this.setTypeface(tf);
            return;
        }
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setTypeface(tf, styleIndex);
    }

    private final void $$robo$$android_widget_TextView$setRelativeDrawablesIfNeeded(Drawable start, Drawable end) {
        boolean hasRelativeDrawables;
        boolean bl = hasRelativeDrawables = start != null || end != null;
        if (hasRelativeDrawables) {
            Drawables dr = this.mDrawables;
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = true;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (start != null) {
                start.setBounds(0, 0, start.getIntrinsicWidth(), start.getIntrinsicHeight());
                start.setState(state);
                start.copyBounds(compoundRect);
                start.setCallback(this);
                dr.mDrawableStart = start;
                dr.mDrawableSizeStart = compoundRect.width();
                dr.mDrawableHeightStart = compoundRect.height();
            } else {
                dr.mDrawableHeightStart = 0;
                dr.mDrawableSizeStart = 0;
            }
            if (end != null) {
                end.setBounds(0, 0, end.getIntrinsicWidth(), end.getIntrinsicHeight());
                end.setState(state);
                end.copyBounds(compoundRect);
                end.setCallback(this);
                dr.mDrawableEnd = end;
                dr.mDrawableSizeEnd = compoundRect.width();
                dr.mDrawableHeightEnd = compoundRect.height();
            } else {
                dr.mDrawableHeightEnd = 0;
                dr.mDrawableSizeEnd = 0;
            }
            this.resetResolvedDrawables();
            this.resolveDrawables();
            this.applyCompoundDrawableTint();
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setEnabled(boolean enabled) {
        InputMethodManager imm;
        if (enabled == this.isEnabled()) {
            return;
        }
        if (!enabled && (imm = InputMethodManager.peekInstance()) != null && imm.isActive(this)) {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        super.setEnabled(enabled);
        if (enabled && (imm = InputMethodManager.peekInstance()) != null) {
            imm.restartInput(this);
        }
        if (this.mEditor != null) {
            this.mEditor.invalidateTextDisplayList();
            this.mEditor.prepareCursorControllers();
            this.mEditor.makeBlink();
        }
    }

    private final void $$robo$$android_widget_TextView$setTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    private final boolean $$robo$$android_widget_TextView$getDefaultEditable() {
        return false;
    }

    private final MovementMethod $$robo$$android_widget_TextView$getDefaultMovementMethod() {
        return null;
    }

    @ViewDebug.CapturedViewProperty
    private final CharSequence $$robo$$android_widget_TextView$getText() {
        return this.mText;
    }

    private final int $$robo$$android_widget_TextView$length() {
        return this.mText.length();
    }

    private final Editable $$robo$$android_widget_TextView$getEditableText() {
        return this.mText instanceof Editable ? (Editable)this.mText : null;
    }

    private final int $$robo$$android_widget_TextView$getLineHeight() {
        return FastMath.round((float)this.mTextPaint.getFontMetricsInt(null) * this.mSpacingMult + this.mSpacingAdd);
    }

    private final Layout $$robo$$android_widget_TextView$getLayout() {
        return this.mLayout;
    }

    private final Layout $$robo$$android_widget_TextView$getHintLayout() {
        return this.mHintLayout;
    }

    private final UndoManager $$robo$$android_widget_TextView$getUndoManager() {
        throw new UnsupportedOperationException("not implemented");
    }

    private final Editor $$robo$$android_widget_TextView$getEditorForTesting() {
        return this.mEditor;
    }

    private final void $$robo$$android_widget_TextView$setUndoManager(UndoManager undoManager, String tag) {
        throw new UnsupportedOperationException("not implemented");
    }

    private final KeyListener $$robo$$android_widget_TextView$getKeyListener() {
        return this.mEditor == null ? null : this.mEditor.mKeyListener;
    }

    private final void $$robo$$android_widget_TextView$setKeyListener(KeyListener input) {
        this.setKeyListenerOnly(input);
        this.fixFocusableAndClickableSettings();
        if (input != null) {
            this.createEditorIfNeeded();
            try {
                this.mEditor.mInputType = this.mEditor.mKeyListener.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mEditor.mInputType = 1;
            }
            this.setInputTypeSingleLine(this.mSingleLine);
        } else if (this.mEditor != null) {
            this.mEditor.mInputType = 0;
        }
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null) {
            imm.restartInput(this);
        }
    }

    private final void $$robo$$android_widget_TextView$setKeyListenerOnly(KeyListener input) {
        if (this.mEditor == null && input == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mKeyListener != input) {
            this.mEditor.mKeyListener = input;
            if (input != null && !(this.mText instanceof Editable)) {
                this.setText(this.mText);
            }
            this.setFilters((Editable)this.mText, this.mFilters);
        }
    }

    private final MovementMethod $$robo$$android_widget_TextView$getMovementMethod() {
        return this.mMovement;
    }

    private final void $$robo$$android_widget_TextView$setMovementMethod(MovementMethod movement) {
        if (this.mMovement != movement) {
            this.mMovement = movement;
            if (movement != null && !(this.mText instanceof Spannable)) {
                this.setText(this.mText);
            }
            this.fixFocusableAndClickableSettings();
            if (this.mEditor != null) {
                this.mEditor.prepareCursorControllers();
            }
        }
    }

    private final void $$robo$$android_widget_TextView$fixFocusableAndClickableSettings() {
        if (this.mMovement != null || this.mEditor != null && this.mEditor.mKeyListener != null) {
            this.setFocusable(true);
            this.setClickable(true);
            this.setLongClickable(true);
        } else {
            this.setFocusable(false);
            this.setClickable(false);
            this.setLongClickable(false);
        }
    }

    private final TransformationMethod $$robo$$android_widget_TextView$getTransformationMethod() {
        return this.mTransformation;
    }

    private final void $$robo$$android_widget_TextView$setTransformationMethod(TransformationMethod method) {
        if (method == this.mTransformation) {
            return;
        }
        if (this.mTransformation != null && this.mText instanceof Spannable) {
            ((Spannable)this.mText).removeSpan(this.mTransformation);
        }
        this.mTransformation = method;
        if (method instanceof TransformationMethod2) {
            TransformationMethod2 method2 = (TransformationMethod2)method;
            this.mAllowTransformationLengthChange = !this.isTextSelectable() && !(this.mText instanceof Editable);
            method2.setLengthChangesAllowed(this.mAllowTransformationLengthChange);
        } else {
            this.mAllowTransformationLengthChange = false;
        }
        this.setText(this.mText);
        if (this.hasPasswordTransformationMethod()) {
            this.notifyViewAccessibilityStateChangedIfNeeded(0);
        }
        this.mTextDir = this.getTextDirectionHeuristic();
    }

    private final int $$robo$$android_widget_TextView$getCompoundPaddingTop() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mShowing[1] == null) {
            return this.mPaddingTop;
        }
        return this.mPaddingTop + dr.mDrawablePadding + dr.mDrawableSizeTop;
    }

    private final int $$robo$$android_widget_TextView$getCompoundPaddingBottom() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mShowing[3] == null) {
            return this.mPaddingBottom;
        }
        return this.mPaddingBottom + dr.mDrawablePadding + dr.mDrawableSizeBottom;
    }

    private final int $$robo$$android_widget_TextView$getCompoundPaddingLeft() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mShowing[0] == null) {
            return this.mPaddingLeft;
        }
        return this.mPaddingLeft + dr.mDrawablePadding + dr.mDrawableSizeLeft;
    }

    private final int $$robo$$android_widget_TextView$getCompoundPaddingRight() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mShowing[2] == null) {
            return this.mPaddingRight;
        }
        return this.mPaddingRight + dr.mDrawablePadding + dr.mDrawableSizeRight;
    }

    private final int $$robo$$android_widget_TextView$getCompoundPaddingStart() {
        this.resolveDrawables();
        switch (this.getLayoutDirection()) {
            default: {
                return this.getCompoundPaddingLeft();
            }
            case 1: 
        }
        return this.getCompoundPaddingRight();
    }

    private final int $$robo$$android_widget_TextView$getCompoundPaddingEnd() {
        this.resolveDrawables();
        switch (this.getLayoutDirection()) {
            default: {
                return this.getCompoundPaddingRight();
            }
            case 1: 
        }
        return this.getCompoundPaddingLeft();
    }

    private final int $$robo$$android_widget_TextView$getExtendedPaddingTop() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingTop();
        }
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingTop();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return top;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return top;
        }
        if (gravity == 80) {
            return top + viewht - layoutht;
        }
        return top + (viewht - layoutht) / 2;
    }

    private final int $$robo$$android_widget_TextView$getExtendedPaddingBottom() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingBottom();
        }
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingBottom();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return bottom;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return bottom + viewht - layoutht;
        }
        if (gravity == 80) {
            return bottom;
        }
        return bottom + (viewht - layoutht) / 2;
    }

    private final int $$robo$$android_widget_TextView$getTotalPaddingLeft() {
        return this.getCompoundPaddingLeft();
    }

    private final int $$robo$$android_widget_TextView$getTotalPaddingRight() {
        return this.getCompoundPaddingRight();
    }

    private final int $$robo$$android_widget_TextView$getTotalPaddingStart() {
        return this.getCompoundPaddingStart();
    }

    private final int $$robo$$android_widget_TextView$getTotalPaddingEnd() {
        return this.getCompoundPaddingEnd();
    }

    private final int $$robo$$android_widget_TextView$getTotalPaddingTop() {
        return this.getExtendedPaddingTop() + this.getVerticalOffset(true);
    }

    private final int $$robo$$android_widget_TextView$getTotalPaddingBottom() {
        return this.getExtendedPaddingBottom() + this.getBottomVerticalOffset(true);
    }

    private final void $$robo$$android_widget_TextView$setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            if (dr.mDrawableStart != null) {
                dr.mDrawableStart.setCallback(null);
            }
            dr.mDrawableStart = null;
            if (dr.mDrawableEnd != null) {
                dr.mDrawableEnd.setCallback(null);
            }
            dr.mDrawableEnd = null;
            dr.mDrawableHeightStart = 0;
            dr.mDrawableSizeStart = 0;
            dr.mDrawableHeightEnd = 0;
            dr.mDrawableSizeEnd = 0;
        }
        boolean bl = drawables = left != null || top != null || right != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (!dr.hasMetadata()) {
                    this.mDrawables = null;
                } else {
                    for (int i = dr.mShowing.length - 1; i >= 0; --i) {
                        if (dr.mShowing[i] != null) {
                            dr.mShowing[i].setCallback(null);
                        }
                        dr.mShowing[i] = null;
                    }
                    dr.mDrawableHeightLeft = 0;
                    dr.mDrawableSizeLeft = 0;
                    dr.mDrawableHeightRight = 0;
                    dr.mDrawableSizeRight = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = false;
            if (dr.mShowing[0] != left && dr.mShowing[0] != null) {
                dr.mShowing[0].setCallback(null);
            }
            dr.mShowing[0] = left;
            if (dr.mShowing[1] != top && dr.mShowing[1] != null) {
                dr.mShowing[1].setCallback(null);
            }
            dr.mShowing[1] = top;
            if (dr.mShowing[2] != right && dr.mShowing[2] != null) {
                dr.mShowing[2].setCallback(null);
            }
            dr.mShowing[2] = right;
            if (dr.mShowing[3] != bottom && dr.mShowing[3] != null) {
                dr.mShowing[3].setCallback(null);
            }
            dr.mShowing[3] = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (left != null) {
                left.setState(state);
                left.copyBounds(compoundRect);
                left.setCallback(this);
                dr.mDrawableSizeLeft = compoundRect.width();
                dr.mDrawableHeightLeft = compoundRect.height();
            } else {
                dr.mDrawableHeightLeft = 0;
                dr.mDrawableSizeLeft = 0;
            }
            if (right != null) {
                right.setState(state);
                right.copyBounds(compoundRect);
                right.setCallback(this);
                dr.mDrawableSizeRight = compoundRect.width();
                dr.mDrawableHeightRight = compoundRect.height();
            } else {
                dr.mDrawableHeightRight = 0;
                dr.mDrawableSizeRight = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        if (dr != null) {
            dr.mDrawableLeftInitial = left;
            dr.mDrawableRightInitial = right;
        }
        this.resetResolvedDrawables();
        this.resolveDrawables();
        this.applyCompoundDrawableTint();
        this.invalidate();
        this.requestLayout();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        Context context = this.getContext();
        this.setCompoundDrawablesWithIntrinsicBounds(left != 0 ? context.getDrawable(left) : null, top != 0 ? context.getDrawable(top) : null, right != 0 ? context.getDrawable(right) : null, bottom != 0 ? context.getDrawable(bottom) : null);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        if (left != null) {
            left.setBounds(0, 0, left.getIntrinsicWidth(), left.getIntrinsicHeight());
        }
        if (right != null) {
            right.setBounds(0, 0, right.getIntrinsicWidth(), right.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawables(left, top, right, bottom);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setCompoundDrawablesRelative(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            if (dr.mShowing[0] != null) {
                dr.mShowing[0].setCallback(null);
            }
            dr.mDrawableLeftInitial = null;
            dr.mShowing[0] = null;
            if (dr.mShowing[2] != null) {
                dr.mShowing[2].setCallback(null);
            }
            dr.mDrawableRightInitial = null;
            dr.mShowing[2] = null;
            dr.mDrawableHeightLeft = 0;
            dr.mDrawableSizeLeft = 0;
            dr.mDrawableHeightRight = 0;
            dr.mDrawableSizeRight = 0;
        }
        boolean bl = drawables = start != null || top != null || end != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (!dr.hasMetadata()) {
                    this.mDrawables = null;
                } else {
                    if (dr.mDrawableStart != null) {
                        dr.mDrawableStart.setCallback(null);
                    }
                    dr.mDrawableStart = null;
                    if (dr.mShowing[1] != null) {
                        dr.mShowing[1].setCallback(null);
                    }
                    dr.mShowing[1] = null;
                    if (dr.mDrawableEnd != null) {
                        dr.mDrawableEnd.setCallback(null);
                    }
                    dr.mDrawableEnd = null;
                    if (dr.mShowing[3] != null) {
                        dr.mShowing[3].setCallback(null);
                    }
                    dr.mShowing[3] = null;
                    dr.mDrawableHeightStart = 0;
                    dr.mDrawableSizeStart = 0;
                    dr.mDrawableHeightEnd = 0;
                    dr.mDrawableSizeEnd = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            this.mDrawables.mOverride = true;
            if (dr.mDrawableStart != start && dr.mDrawableStart != null) {
                dr.mDrawableStart.setCallback(null);
            }
            dr.mDrawableStart = start;
            if (dr.mShowing[1] != top && dr.mShowing[1] != null) {
                dr.mShowing[1].setCallback(null);
            }
            dr.mShowing[1] = top;
            if (dr.mDrawableEnd != end && dr.mDrawableEnd != null) {
                dr.mDrawableEnd.setCallback(null);
            }
            dr.mDrawableEnd = end;
            if (dr.mShowing[3] != bottom && dr.mShowing[3] != null) {
                dr.mShowing[3].setCallback(null);
            }
            dr.mShowing[3] = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (start != null) {
                start.setState(state);
                start.copyBounds(compoundRect);
                start.setCallback(this);
                dr.mDrawableSizeStart = compoundRect.width();
                dr.mDrawableHeightStart = compoundRect.height();
            } else {
                dr.mDrawableHeightStart = 0;
                dr.mDrawableSizeStart = 0;
            }
            if (end != null) {
                end.setState(state);
                end.copyBounds(compoundRect);
                end.setCallback(this);
                dr.mDrawableSizeEnd = compoundRect.width();
                dr.mDrawableHeightEnd = compoundRect.height();
            } else {
                dr.mDrawableHeightEnd = 0;
                dr.mDrawableSizeEnd = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        this.resetResolvedDrawables();
        this.resolveDrawables();
        this.invalidate();
        this.requestLayout();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setCompoundDrawablesRelativeWithIntrinsicBounds(int start, int top, int end, int bottom) {
        Context context = this.getContext();
        this.setCompoundDrawablesRelativeWithIntrinsicBounds(start != 0 ? context.getDrawable(start) : null, top != 0 ? context.getDrawable(top) : null, end != 0 ? context.getDrawable(end) : null, bottom != 0 ? context.getDrawable(bottom) : null);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        if (start != null) {
            start.setBounds(0, 0, start.getIntrinsicWidth(), start.getIntrinsicHeight());
        }
        if (end != null) {
            end.setBounds(0, 0, end.getIntrinsicWidth(), end.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawablesRelative(start, top, end, bottom);
    }

    private final Drawable[] $$robo$$android_widget_TextView$getCompoundDrawables() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return (Drawable[])dr.mShowing.clone();
        }
        return new Drawable[]{null, null, null, null};
    }

    private final Drawable[] $$robo$$android_widget_TextView$getCompoundDrawablesRelative() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return new Drawable[]{dr.mDrawableStart, dr.mShowing[1], dr.mDrawableEnd, dr.mShowing[3]};
        }
        return new Drawable[]{null, null, null, null};
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setCompoundDrawablePadding(int pad) {
        Drawables dr = this.mDrawables;
        if (pad == 0) {
            if (dr != null) {
                dr.mDrawablePadding = pad;
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables(this.getContext());
            }
            dr.mDrawablePadding = pad;
        }
        this.invalidate();
        this.requestLayout();
    }

    private final int $$robo$$android_widget_TextView$getCompoundDrawablePadding() {
        Drawables dr = this.mDrawables;
        return dr != null ? dr.mDrawablePadding : 0;
    }

    private final void $$robo$$android_widget_TextView$setCompoundDrawableTintList(ColorStateList tint) {
        if (this.mDrawables == null) {
            this.mDrawables = new Drawables(this.getContext());
        }
        this.mDrawables.mTintList = tint;
        this.mDrawables.mHasTint = true;
        this.applyCompoundDrawableTint();
    }

    private final ColorStateList $$robo$$android_widget_TextView$getCompoundDrawableTintList() {
        return this.mDrawables != null ? this.mDrawables.mTintList : null;
    }

    private final void $$robo$$android_widget_TextView$setCompoundDrawableTintMode(PorterDuff.Mode tintMode) {
        if (this.mDrawables == null) {
            this.mDrawables = new Drawables(this.getContext());
        }
        this.mDrawables.mTintMode = tintMode;
        this.mDrawables.mHasTintMode = true;
        this.applyCompoundDrawableTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_TextView$getCompoundDrawableTintMode() {
        return this.mDrawables != null ? this.mDrawables.mTintMode : null;
    }

    private final void $$robo$$android_widget_TextView$applyCompoundDrawableTint() {
        if (this.mDrawables == null) {
            return;
        }
        if (this.mDrawables.mHasTint || this.mDrawables.mHasTintMode) {
            ColorStateList tintList = this.mDrawables.mTintList;
            PorterDuff.Mode tintMode = this.mDrawables.mTintMode;
            boolean hasTint = this.mDrawables.mHasTint;
            boolean hasTintMode = this.mDrawables.mHasTintMode;
            int[] state = this.getDrawableState();
            for (Drawable dr : this.mDrawables.mShowing) {
                if (dr == null || dr == this.mDrawables.mDrawableError) continue;
                dr.mutate();
                if (hasTint) {
                    dr.setTintList(tintList);
                }
                if (hasTintMode) {
                    dr.setTintMode(tintMode);
                }
                if (!dr.isStateful()) continue;
                dr.setState(state);
            }
        }
    }

    private final void $$robo$$android_widget_TextView$setPadding(int left, int top, int right, int bottom) {
        if (left != this.mPaddingLeft || right != this.mPaddingRight || top != this.mPaddingTop || bottom != this.mPaddingBottom) {
            this.nullLayouts();
        }
        super.setPadding(left, top, right, bottom);
        this.invalidate();
    }

    private final void $$robo$$android_widget_TextView$setPaddingRelative(int start, int top, int end, int bottom) {
        if (start != this.getPaddingStart() || end != this.getPaddingEnd() || top != this.mPaddingTop || bottom != this.mPaddingBottom) {
            this.nullLayouts();
        }
        super.setPaddingRelative(start, top, end, bottom);
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getAutoLinkMask() {
        return this.mAutoLinkMask;
    }

    private final void $$robo$$android_widget_TextView$setTextAppearance(int resId) {
        this.setTextAppearance(this.mContext, resId);
    }

    @Deprecated
    private final void $$robo$$android_widget_TextView$setTextAppearance(Context context, int resId) {
        ColorStateList textColorLink;
        ColorStateList textColorHint;
        int textSize;
        ColorStateList textColor;
        TypedArray ta = context.obtainStyledAttributes(resId, R.styleable.TextAppearance);
        int textColorHighlight = ta.getColor(4, 0);
        if (textColorHighlight != 0) {
            this.setHighlightColor(textColorHighlight);
        }
        if ((textColor = ta.getColorStateList(3)) != null) {
            this.setTextColor(textColor);
        }
        if ((textSize = ta.getDimensionPixelSize(0, 0)) != 0) {
            this.setRawTextSize(textSize);
        }
        if ((textColorHint = ta.getColorStateList(5)) != null) {
            this.setHintTextColor(textColorHint);
        }
        if ((textColorLink = ta.getColorStateList(6)) != null) {
            this.setLinkTextColor(textColorLink);
        }
        String fontFamily = ta.getString(12);
        int typefaceIndex = ta.getInt(1, -1);
        int styleIndex = ta.getInt(2, -1);
        this.setTypefaceFromAttrs(fontFamily, typefaceIndex, styleIndex);
        int shadowColor = ta.getInt(7, 0);
        if (shadowColor != 0) {
            float dx = ta.getFloat(8, 0.0f);
            float dy = ta.getFloat(9, 0.0f);
            float r = ta.getFloat(10, 0.0f);
            this.setShadowLayer(r, dx, dy, shadowColor);
        }
        if (ta.getBoolean(11, false)) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        }
        if (ta.hasValue(13)) {
            this.setElegantTextHeight(ta.getBoolean(13, false));
        }
        if (ta.hasValue(14)) {
            this.setLetterSpacing(ta.getFloat(14, 0.0f));
        }
        if (ta.hasValue(15)) {
            this.setFontFeatureSettings(ta.getString(15));
        }
        ta.recycle();
    }

    private final Locale $$robo$$android_widget_TextView$getTextLocale() {
        return this.mTextPaint.getTextLocale();
    }

    private final LocaleList $$robo$$android_widget_TextView$getTextLocales() {
        return this.mTextPaint.getTextLocales();
    }

    private final void $$robo$$android_widget_TextView$setTextLocale(Locale locale) {
        this.mLocalesChanged = true;
        this.mTextPaint.setTextLocale(locale);
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_TextView$setTextLocales(LocaleList locales) {
        this.mLocalesChanged = true;
        this.mTextPaint.setTextLocales(locales);
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_TextView$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (!this.mLocalesChanged) {
            this.mTextPaint.setTextLocales(LocaleList.getDefault());
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="text")
    private final float $$robo$$android_widget_TextView$getTextSize() {
        return this.mTextPaint.getTextSize();
    }

    @ViewDebug.ExportedProperty(category="text")
    private final float $$robo$$android_widget_TextView$getScaledTextSize() {
        return this.mTextPaint.getTextSize() / this.mTextPaint.density;
    }

    @ViewDebug.ExportedProperty(category="text", mapping={@ViewDebug.IntToString(from=0, to="NORMAL"), @ViewDebug.IntToString(from=1, to="BOLD"), @ViewDebug.IntToString(from=2, to="ITALIC"), @ViewDebug.IntToString(from=3, to="BOLD_ITALIC")})
    private final int $$robo$$android_widget_TextView$getTypefaceStyle() {
        Typeface typeface = this.mTextPaint.getTypeface();
        return typeface != null ? typeface.getStyle() : 0;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setTextSize(float size) {
        this.setTextSize(2, size);
    }

    private final void $$robo$$android_widget_TextView$setTextSize(int unit, float size) {
        Context c = this.getContext();
        Resources r = c == null ? Resources.getSystem() : c.getResources();
        this.setRawTextSize(TypedValue.applyDimension(unit, size, r.getDisplayMetrics()));
    }

    private final void $$robo$$android_widget_TextView$setRawTextSize(float size) {
        if (size != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final float $$robo$$android_widget_TextView$getTextScaleX() {
        return this.mTextPaint.getTextScaleX();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setTextScaleX(float size) {
        if (size != this.mTextPaint.getTextScaleX()) {
            this.mUserSetTextScaleX = true;
            this.mTextPaint.setTextScaleX(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final void $$robo$$android_widget_TextView$setTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final Typeface $$robo$$android_widget_TextView$getTypeface() {
        return this.mTextPaint.getTypeface();
    }

    private final void $$robo$$android_widget_TextView$setElegantTextHeight(boolean elegant) {
        if (elegant != this.mTextPaint.isElegantTextHeight()) {
            this.mTextPaint.setElegantTextHeight(elegant);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final float $$robo$$android_widget_TextView$getLetterSpacing() {
        return this.mTextPaint.getLetterSpacing();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setLetterSpacing(float letterSpacing) {
        if (letterSpacing != this.mTextPaint.getLetterSpacing()) {
            this.mTextPaint.setLetterSpacing(letterSpacing);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final String $$robo$$android_widget_TextView$getFontFeatureSettings() {
        return this.mTextPaint.getFontFeatureSettings();
    }

    private final void $$robo$$android_widget_TextView$setBreakStrategy(int breakStrategy) {
        this.mBreakStrategy = breakStrategy;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    private final int $$robo$$android_widget_TextView$getBreakStrategy() {
        return this.mBreakStrategy;
    }

    private final void $$robo$$android_widget_TextView$setHyphenationFrequency(int hyphenationFrequency) {
        this.mHyphenationFrequency = hyphenationFrequency;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    private final int $$robo$$android_widget_TextView$getHyphenationFrequency() {
        return this.mHyphenationFrequency;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setFontFeatureSettings(String fontFeatureSettings) {
        if (fontFeatureSettings != this.mTextPaint.getFontFeatureSettings()) {
            this.mTextPaint.setFontFeatureSettings(fontFeatureSettings);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setTextColor(int color2) {
        this.mTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    private final void $$robo$$android_widget_TextView$setTextColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mTextColor = colors;
        this.updateTextColors();
    }

    private final ColorStateList $$robo$$android_widget_TextView$getTextColors() {
        return this.mTextColor;
    }

    private final int $$robo$$android_widget_TextView$getCurrentTextColor() {
        return this.mCurTextColor;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setHighlightColor(int color2) {
        if (this.mHighlightColor != color2) {
            this.mHighlightColor = color2;
            this.invalidate();
        }
    }

    private final int $$robo$$android_widget_TextView$getHighlightColor() {
        return this.mHighlightColor;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setShowSoftInputOnFocus(boolean show) {
        this.createEditorIfNeeded();
        this.mEditor.mShowSoftInputOnFocus = show;
    }

    private final boolean $$robo$$android_widget_TextView$getShowSoftInputOnFocus() {
        return this.mEditor == null || this.mEditor.mShowSoftInputOnFocus;
    }

    private final void $$robo$$android_widget_TextView$setShadowLayer(float radius, float dx, float dy, int color2) {
        this.mTextPaint.setShadowLayer(radius, dx, dy, color2);
        this.mShadowRadius = radius;
        this.mShadowDx = dx;
        this.mShadowDy = dy;
        this.mShadowColor = color2;
        if (this.mEditor != null) {
            this.mEditor.invalidateTextDisplayList();
            this.mEditor.invalidateHandlesAndActionMode();
        }
        this.invalidate();
    }

    private final float $$robo$$android_widget_TextView$getShadowRadius() {
        return this.mShadowRadius;
    }

    private final float $$robo$$android_widget_TextView$getShadowDx() {
        return this.mShadowDx;
    }

    private final float $$robo$$android_widget_TextView$getShadowDy() {
        return this.mShadowDy;
    }

    private final int $$robo$$android_widget_TextView$getShadowColor() {
        return this.mShadowColor;
    }

    private final TextPaint $$robo$$android_widget_TextView$getPaint() {
        return this.mTextPaint;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setAutoLinkMask(int mask) {
        this.mAutoLinkMask = mask;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setLinksClickable(boolean whether) {
        this.mLinksClickable = whether;
    }

    private final boolean $$robo$$android_widget_TextView$getLinksClickable() {
        return this.mLinksClickable;
    }

    private final URLSpan[] $$robo$$android_widget_TextView$getUrls() {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpans(0, this.mText.length(), URLSpan.class);
        }
        return new URLSpan[0];
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setHintTextColor(int color2) {
        this.mHintTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    private final void $$robo$$android_widget_TextView$setHintTextColor(ColorStateList colors) {
        this.mHintTextColor = colors;
        this.updateTextColors();
    }

    private final ColorStateList $$robo$$android_widget_TextView$getHintTextColors() {
        return this.mHintTextColor;
    }

    private final int $$robo$$android_widget_TextView$getCurrentHintTextColor() {
        return this.mHintTextColor != null ? this.mCurHintTextColor : this.mCurTextColor;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setLinkTextColor(int color2) {
        this.mLinkTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    private final void $$robo$$android_widget_TextView$setLinkTextColor(ColorStateList colors) {
        this.mLinkTextColor = colors;
        this.updateTextColors();
    }

    private final ColorStateList $$robo$$android_widget_TextView$getLinkTextColors() {
        return this.mLinkTextColor;
    }

    private final void $$robo$$android_widget_TextView$setGravity(int gravity) {
        if ((gravity & 0x800007) == 0) {
            gravity |= 0x800003;
        }
        if ((gravity & 0x70) == 0) {
            gravity |= 0x30;
        }
        boolean newLayout = false;
        if ((gravity & 0x800007) != (this.mGravity & 0x800007)) {
            newLayout = true;
        }
        if (gravity != this.mGravity) {
            this.invalidate();
        }
        this.mGravity = gravity;
        if (this.mLayout != null && newLayout) {
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), true);
        }
    }

    private final int $$robo$$android_widget_TextView$getGravity() {
        return this.mGravity;
    }

    private final int $$robo$$android_widget_TextView$getPaintFlags() {
        return this.mTextPaint.getFlags();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setPaintFlags(int flags) {
        if (this.mTextPaint.getFlags() != flags) {
            this.mTextPaint.setFlags(flags);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final void $$robo$$android_widget_TextView$setHorizontallyScrolling(boolean whether) {
        if (this.mHorizontallyScrolling != whether) {
            this.mHorizontallyScrolling = whether;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final boolean $$robo$$android_widget_TextView$getHorizontallyScrolling() {
        return this.mHorizontallyScrolling;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setMinLines(int minlines) {
        this.mMinimum = minlines;
        this.mMinMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getMinLines() {
        return this.mMinMode == 1 ? this.mMinimum : -1;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setMinHeight(int minHeight) {
        this.mMinimum = minHeight;
        this.mMinMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getMinHeight() {
        return this.mMinMode == 2 ? this.mMinimum : -1;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setMaxLines(int maxlines) {
        this.mMaximum = maxlines;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getMaxLines() {
        return this.mMaxMode == 1 ? this.mMaximum : -1;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setMaxHeight(int maxHeight) {
        this.mMaximum = maxHeight;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getMaxHeight() {
        return this.mMaxMode == 2 ? this.mMaximum : -1;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setLines(int lines) {
        this.mMaximum = this.mMinimum = lines;
        this.mMinMode = 1;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setHeight(int pixels) {
        this.mMaximum = this.mMinimum = pixels;
        this.mMinMode = 2;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setMinEms(int minems) {
        this.mMinWidth = minems;
        this.mMinWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getMinEms() {
        return this.mMinWidthMode == 1 ? this.mMinWidth : -1;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setMinWidth(int minpixels) {
        this.mMinWidth = minpixels;
        this.mMinWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getMinWidth() {
        return this.mMinWidthMode == 2 ? this.mMinWidth : -1;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setMaxEms(int maxems) {
        this.mMaxWidth = maxems;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getMaxEms() {
        return this.mMaxWidthMode == 1 ? this.mMaxWidth : -1;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setMaxWidth(int maxpixels) {
        this.mMaxWidth = maxpixels;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_TextView$getMaxWidth() {
        return this.mMaxWidthMode == 2 ? this.mMaxWidth : -1;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setEms(int ems) {
        this.mMaxWidth = this.mMinWidth = ems;
        this.mMinWidthMode = 1;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setWidth(int pixels) {
        this.mMaxWidth = this.mMinWidth = pixels;
        this.mMinWidthMode = 2;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_TextView$setLineSpacing(float add, float mult) {
        if (this.mSpacingAdd != add || this.mSpacingMult != mult) {
            this.mSpacingAdd = add;
            this.mSpacingMult = mult;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final float $$robo$$android_widget_TextView$getLineSpacingMultiplier() {
        return this.mSpacingMult;
    }

    private final float $$robo$$android_widget_TextView$getLineSpacingExtra() {
        return this.mSpacingAdd;
    }

    private final void $$robo$$android_widget_TextView$append(CharSequence text) {
        this.append(text, 0, text.length());
    }

    private final void $$robo$$android_widget_TextView$append(CharSequence text, int start, int end) {
        boolean linksWereAdded;
        if (!(this.mText instanceof Editable)) {
            this.setText(this.mText, BufferType.EDITABLE);
        }
        ((Editable)this.mText).append(text, start, end);
        if (this.mAutoLinkMask != 0 && (linksWereAdded = Linkify.addLinks((Spannable)this.mText, this.mAutoLinkMask)) && this.mLinksClickable && !this.textCanBeSelected()) {
            this.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    private final void $$robo$$android_widget_TextView$updateTextColors() {
        boolean inval = false;
        int color2 = this.mTextColor.getColorForState(this.getDrawableState(), 0);
        if (color2 != this.mCurTextColor) {
            this.mCurTextColor = color2;
            inval = true;
        }
        if (this.mLinkTextColor != null && (color2 = this.mLinkTextColor.getColorForState(this.getDrawableState(), 0)) != this.mTextPaint.linkColor) {
            this.mTextPaint.linkColor = color2;
            inval = true;
        }
        if (this.mHintTextColor != null && (color2 = this.mHintTextColor.getColorForState(this.getDrawableState(), 0)) != this.mCurHintTextColor) {
            this.mCurHintTextColor = color2;
            if (this.mText.length() == 0) {
                inval = true;
            }
        }
        if (inval) {
            if (this.mEditor != null) {
                this.mEditor.invalidateTextDisplayList();
            }
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_TextView$drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mTextColor != null && this.mTextColor.isStateful() || this.mHintTextColor != null && this.mHintTextColor.isStateful() || this.mLinkTextColor != null && this.mLinkTextColor.isStateful()) {
            this.updateTextColors();
        }
        if (this.mDrawables != null) {
            int[] state = this.getDrawableState();
            for (Drawable dr : this.mDrawables.mShowing) {
                if (dr == null || !dr.isStateful() || !dr.setState(state)) continue;
                this.invalidateDrawable(dr);
            }
        }
    }

    private final void $$robo$$android_widget_TextView$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mDrawables != null) {
            for (Drawable dr : this.mDrawables.mShowing) {
                if (dr == null) continue;
                dr.setHotspot(x, y);
            }
        }
    }

    private final Parcelable $$robo$$android_widget_TextView$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        boolean freezesText = this.getFreezesText();
        boolean hasSelection = false;
        int start = -1;
        int end = -1;
        if (this.mText != null) {
            start = this.getSelectionStart();
            end = this.getSelectionEnd();
            if (start >= 0 || end >= 0) {
                hasSelection = true;
            }
        }
        if (freezesText || hasSelection) {
            SavedState ss = new SavedState(superState);
            if (freezesText) {
                if (this.mText instanceof Spanned) {
                    SpannableStringBuilder sp = new SpannableStringBuilder(this.mText);
                    if (this.mEditor != null) {
                        this.removeMisspelledSpans(sp);
                        sp.removeSpan(this.mEditor.mSuggestionRangeSpan);
                    }
                    ss.text = sp;
                } else {
                    ss.text = this.mText.toString();
                }
            }
            if (hasSelection) {
                ss.selStart = start;
                ss.selEnd = end;
            }
            if (this.isFocused() && start >= 0 && end >= 0) {
                ss.frozenWithFocus = true;
            }
            ss.error = this.getError();
            if (this.mEditor != null) {
                ss.editorState = this.mEditor.saveInstanceState();
            }
            return ss;
        }
        return superState;
    }

    private final void $$robo$$android_widget_TextView$removeMisspelledSpans(Spannable spannable) {
        SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            int flags = suggestionSpans[i].getFlags();
            if ((flags & 1) == 0 || (flags & 2) == 0) continue;
            spannable.removeSpan(suggestionSpans[i]);
        }
    }

    private final void $$robo$$android_widget_TextView$onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.text != null) {
            this.setText(ss.text);
        }
        if (ss.selStart >= 0 && ss.selEnd >= 0 && this.mText instanceof Spannable) {
            int len = this.mText.length();
            if (ss.selStart > len || ss.selEnd > len) {
                String restored = "";
                if (ss.text != null) {
                    restored = "(restored) ";
                }
                Log.e("TextView", "Saved cursor position " + ss.selStart + "/" + ss.selEnd + " out of range for " + restored + "text " + this.mText);
            } else {
                Selection.setSelection((Spannable)this.mText, ss.selStart, ss.selEnd);
                if (ss.frozenWithFocus) {
                    this.createEditorIfNeeded();
                    this.mEditor.mFrozenWithFocus = true;
                }
            }
        }
        if (ss.error != null) {
            CharSequence error = ss.error;
            this.post(new Runnable(this, error){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ CharSequence val$error;
                /* synthetic */ TextView this$0;

                private void $$robo$$android_widget_TextView_1$__constructor__(TextView this$0, CharSequence charSequence) {
                }

                private final void $$robo$$android_widget_TextView_1$run() {
                    if (this.this$0.mEditor == null || !((TextView)this.this$0).mEditor.mErrorWasChanged) {
                        this.this$0.setError(this.val$error);
                    }
                }

                private void __constructor__(TextView textView, CharSequence charSequence) {
                    this.$$robo$$android_widget_TextView_1$__constructor__(textView, charSequence);
                }
                {
                    this.this$0 = textView;
                    this.val$error = charSequence;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_1$__constructor__(android.widget.TextView java.lang.CharSequence ), 0, this, textView, charSequence);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_TextView_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        if (ss.editorState != null) {
            this.createEditorIfNeeded();
            this.mEditor.restoreInstanceState(ss.editorState);
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setFreezesText(boolean freezesText) {
        this.mFreezesText = freezesText;
    }

    private final boolean $$robo$$android_widget_TextView$getFreezesText() {
        return this.mFreezesText;
    }

    private final void $$robo$$android_widget_TextView$setEditableFactory(Editable.Factory factory) {
        this.mEditableFactory = factory;
        this.setText(this.mText);
    }

    private final void $$robo$$android_widget_TextView$setSpannableFactory(Spannable.Factory factory) {
        this.mSpannableFactory = factory;
        this.setText(this.mText);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setText(CharSequence text) {
        this.setText(text, this.mBufferType);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setTextKeepState(CharSequence text) {
        this.setTextKeepState(text, this.mBufferType);
    }

    private final void $$robo$$android_widget_TextView$setText(CharSequence text, BufferType type) {
        this.setText(text, type, true, 0);
        if (this.mCharWrapper != null) {
            CharWrapper.access$102(this.mCharWrapper, null);
        }
    }

    private final void $$robo$$android_widget_TextView$setText(CharSequence text, BufferType type, boolean notifyBefore, int oldlen) {
        Spannable s2;
        if (text == null) {
            text = "";
        }
        if (!this.isSuggestionsEnabled()) {
            text = this.removeSuggestionSpans(text);
        }
        if (!this.mUserSetTextScaleX) {
            this.mTextPaint.setTextScaleX(1.0f);
        }
        if (text instanceof Spanned && ((Spanned)text).getSpanStart((Object)TextUtils.TruncateAt.MARQUEE) >= 0) {
            if (ViewConfiguration.get(this.mContext).isFadingMarqueeEnabled()) {
                this.setHorizontalFadingEdgeEnabled(true);
                this.mMarqueeFadeMode = 0;
            } else {
                this.setHorizontalFadingEdgeEnabled(false);
                this.mMarqueeFadeMode = 1;
            }
            this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        }
        int n = this.mFilters.length;
        for (int i = 0; i < n; ++i) {
            CharSequence out = this.mFilters[i].filter(text, 0, text.length(), EMPTY_SPANNED, 0, 0);
            if (out == null) continue;
            text = out;
        }
        if (notifyBefore) {
            if (this.mText != null) {
                oldlen = this.mText.length();
                this.sendBeforeTextChanged(this.mText, 0, oldlen, text.length());
            } else {
                this.sendBeforeTextChanged("", 0, 0, text.length());
            }
        }
        boolean needEditableForNotification = false;
        if (this.mListeners != null && this.mListeners.size() != 0) {
            needEditableForNotification = true;
        }
        if (type == BufferType.EDITABLE || this.getKeyListener() != null || needEditableForNotification) {
            this.createEditorIfNeeded();
            this.mEditor.forgetUndoRedo();
            Editable t = this.mEditableFactory.newEditable(text);
            text = t;
            this.setFilters(t, this.mFilters);
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.restartInput(this);
            }
        } else if (type == BufferType.SPANNABLE || this.mMovement != null) {
            text = this.mSpannableFactory.newSpannable(text);
        } else if (!(text instanceof CharWrapper)) {
            text = TextUtils.stringOrSpannedString(text);
        }
        if (this.mAutoLinkMask != 0 && Linkify.addLinks(s2 = type == BufferType.EDITABLE || text instanceof Spannable ? (Spannable)text : this.mSpannableFactory.newSpannable(text), this.mAutoLinkMask)) {
            text = s2;
            type = type == BufferType.EDITABLE ? BufferType.EDITABLE : BufferType.SPANNABLE;
            this.mText = text;
            if (this.mLinksClickable && !this.textCanBeSelected()) {
                this.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
        this.mBufferType = type;
        this.mText = text;
        this.mTransformed = this.mTransformation == null ? text : this.mTransformation.getTransformation(text, this);
        int textLength = text.length();
        if (text instanceof Spannable && !this.mAllowTransformationLengthChange) {
            Spannable sp = (Spannable)text;
            ChangeWatcher[] watchers = sp.getSpans(0, sp.length(), ChangeWatcher.class);
            int count = watchers.length;
            for (int i = 0; i < count; ++i) {
                sp.removeSpan(watchers[i]);
            }
            if (this.mChangeWatcher == null) {
                this.mChangeWatcher = new ChangeWatcher(this);
            }
            sp.setSpan(this.mChangeWatcher, 0, textLength, 6553618);
            if (this.mEditor != null) {
                this.mEditor.addSpanWatchers(sp);
            }
            if (this.mTransformation != null) {
                sp.setSpan(this.mTransformation, 0, textLength, 18);
            }
            if (this.mMovement != null) {
                this.mMovement.initialize(this, (Spannable)text);
                if (this.mEditor != null) {
                    this.mEditor.mSelectionMoved = false;
                }
            }
        }
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        this.sendOnTextChanged(text, 0, oldlen, textLength);
        this.onTextChanged(text, 0, oldlen, textLength);
        this.notifyViewAccessibilityStateChangedIfNeeded(2);
        if (needEditableForNotification) {
            this.sendAfterTextChanged((Editable)text);
        }
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
    }

    private final void $$robo$$android_widget_TextView$setText(char[] text, int start, int len) {
        int oldlen = 0;
        if (start < 0 || len < 0 || start + len > text.length) {
            throw new IndexOutOfBoundsException(start + ", " + len);
        }
        if (this.mText != null) {
            oldlen = this.mText.length();
            this.sendBeforeTextChanged(this.mText, 0, oldlen, len);
        } else {
            this.sendBeforeTextChanged("", 0, 0, len);
        }
        if (this.mCharWrapper == null) {
            this.mCharWrapper = new CharWrapper(text, start, len);
        } else {
            this.mCharWrapper.set(text, start, len);
        }
        this.setText(this.mCharWrapper, this.mBufferType, false, oldlen);
    }

    private final void $$robo$$android_widget_TextView$setTextKeepState(CharSequence text, BufferType type) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        int len = text.length();
        this.setText(text, type);
        if ((start >= 0 || end >= 0) && this.mText instanceof Spannable) {
            Selection.setSelection((Spannable)this.mText, Math.max(0, Math.min(start, len)), Math.max(0, Math.min(end, len)));
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setText(int resid) {
        this.setText(this.getContext().getResources().getText(resid));
    }

    private final void $$robo$$android_widget_TextView$setText(int resid, BufferType type) {
        this.setText(this.getContext().getResources().getText(resid), type);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setHint(CharSequence hint) {
        this.mHint = TextUtils.stringOrSpannedString(hint);
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        if (this.mText.length() == 0) {
            this.invalidate();
        }
        if (this.mEditor != null && this.mText.length() == 0 && this.mHint != null) {
            this.mEditor.invalidateTextDisplayList();
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setHint(int resid) {
        this.setHint(this.getContext().getResources().getText(resid));
    }

    @ViewDebug.CapturedViewProperty
    private final CharSequence $$robo$$android_widget_TextView$getHint() {
        return this.mHint;
    }

    private final boolean $$robo$$android_widget_TextView$isSingleLine() {
        return this.mSingleLine;
    }

    private static final boolean $$robo$$android_widget_TextView$isMultilineInputType(int type) {
        return (type & 0x2000F) == 131073;
    }

    private final CharSequence $$robo$$android_widget_TextView$removeSuggestionSpans(CharSequence text) {
        if (text instanceof Spanned) {
            Spannable spannable;
            if (text instanceof Spannable) {
                spannable = (Spannable)text;
            } else {
                spannable = new SpannableString(text);
                text = spannable;
            }
            SuggestionSpan[] spans = spannable.getSpans(0, text.length(), SuggestionSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                spannable.removeSpan(spans[i]);
            }
        }
        return text;
    }

    private final void $$robo$$android_widget_TextView$setInputType(int type) {
        InputMethodManager imm;
        boolean singleLine;
        boolean wasPassword = TextView.isPasswordInputType(this.getInputType());
        boolean wasVisiblePassword = TextView.isVisiblePasswordInputType(this.getInputType());
        this.setInputType(type, false);
        boolean isPassword = TextView.isPasswordInputType(type);
        boolean isVisiblePassword = TextView.isVisiblePasswordInputType(type);
        boolean forceUpdate = false;
        if (isPassword) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            this.setTypefaceFromAttrs(null, 3, 0);
        } else if (isVisiblePassword) {
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
            this.setTypefaceFromAttrs(null, 3, 0);
        } else if (wasPassword || wasVisiblePassword) {
            this.setTypefaceFromAttrs(null, -1, -1);
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
        }
        boolean bl = singleLine = !TextView.isMultilineInputType(type);
        if (this.mSingleLine != singleLine || forceUpdate) {
            this.applySingleLine(singleLine, !isPassword, true);
        }
        if (!this.isSuggestionsEnabled()) {
            this.mText = this.removeSuggestionSpans(this.mText);
        }
        if ((imm = InputMethodManager.peekInstance()) != null) {
            imm.restartInput(this);
        }
    }

    private final boolean $$robo$$android_widget_TextView$hasPasswordTransformationMethod() {
        return this.mTransformation instanceof PasswordTransformationMethod;
    }

    private static final boolean $$robo$$android_widget_TextView$isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    private static final boolean $$robo$$android_widget_TextView$isVisiblePasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 145;
    }

    private final void $$robo$$android_widget_TextView$setRawInputType(int type) {
        if (type == 0 && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        this.mEditor.mInputType = type;
    }

    private final void $$robo$$android_widget_TextView$setInputType(int type, boolean direct) {
        BaseKeyListener input;
        int cls = type & 0xF;
        if (cls == 1) {
            boolean autotext;
            boolean bl = autotext = (type & 0x8000) != 0;
            TextKeyListener.Capitalize cap = (type & 0x1000) != 0 ? TextKeyListener.Capitalize.CHARACTERS : ((type & 0x2000) != 0 ? TextKeyListener.Capitalize.WORDS : ((type & 0x4000) != 0 ? TextKeyListener.Capitalize.SENTENCES : TextKeyListener.Capitalize.NONE));
            input = TextKeyListener.getInstance(autotext, cap);
        } else if (cls == 2) {
            input = DigitsKeyListener.getInstance((type & 0x1000) != 0, (type & 0x2000) != 0);
        } else if (cls == 4) {
            switch (type & 0xFF0) {
                case 16: {
                    input = DateKeyListener.getInstance();
                    break;
                }
                case 32: {
                    input = TimeKeyListener.getInstance();
                    break;
                }
                default: {
                    input = DateTimeKeyListener.getInstance();
                    break;
                }
            }
        } else {
            input = cls == 3 ? DialerKeyListener.getInstance() : TextKeyListener.getInstance();
        }
        this.setRawInputType(type);
        if (direct) {
            this.createEditorIfNeeded();
            this.mEditor.mKeyListener = input;
        } else {
            this.setKeyListenerOnly(input);
        }
    }

    private final int $$robo$$android_widget_TextView$getInputType() {
        return this.mEditor == null ? 0 : this.mEditor.mInputType;
    }

    private final void $$robo$$android_widget_TextView$setImeOptions(int imeOptions) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.imeOptions = imeOptions;
    }

    private final int $$robo$$android_widget_TextView$getImeOptions() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeOptions : 0;
    }

    private final void $$robo$$android_widget_TextView$setImeActionLabel(CharSequence label, int actionId) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.imeActionLabel = label;
        this.mEditor.mInputContentType.imeActionId = actionId;
    }

    private final CharSequence $$robo$$android_widget_TextView$getImeActionLabel() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeActionLabel : null;
    }

    private final int $$robo$$android_widget_TextView$getImeActionId() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.imeActionId : 0;
    }

    private final void $$robo$$android_widget_TextView$setOnEditorActionListener(OnEditorActionListener l) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.onEditorActionListener = l;
    }

    private final void $$robo$$android_widget_TextView$onEditorAction(int actionCode) {
        ViewRootImpl viewRootImpl;
        Editor.InputContentType ict;
        Editor.InputContentType inputContentType = ict = this.mEditor == null ? null : this.mEditor.mInputContentType;
        if (ict != null) {
            if (ict.onEditorActionListener != null && ict.onEditorActionListener.onEditorAction(this, actionCode, null)) {
                return;
            }
            if (actionCode == 5) {
                View v = this.focusSearch(2);
                if (v != null && !v.requestFocus(2)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 7) {
                View v = this.focusSearch(1);
                if (v != null && !v.requestFocus(1)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 6) {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm != null && imm.isActive(this)) {
                    imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                }
                return;
            }
        }
        if ((viewRootImpl = this.getViewRootImpl()) != null) {
            long eventTime = SystemClock.uptimeMillis();
            viewRootImpl.dispatchKeyFromIme(new KeyEvent(eventTime, eventTime, 0, 66, 0, 0, -1, 0, 22));
            viewRootImpl.dispatchKeyFromIme(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, 66, 0, 0, -1, 0, 22));
        }
    }

    private final void $$robo$$android_widget_TextView$setPrivateImeOptions(String type) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.privateImeOptions = type;
    }

    private final String $$robo$$android_widget_TextView$getPrivateImeOptions() {
        return this.mEditor != null && this.mEditor.mInputContentType != null ? this.mEditor.mInputContentType.privateImeOptions : null;
    }

    private final void $$robo$$android_widget_TextView$setInputExtras(int xmlResId) throws XmlPullParserException, IOException {
        this.createEditorIfNeeded();
        XmlResourceParser parser = this.getResources().getXml(xmlResId);
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.extras = new Bundle();
        this.getResources().parseBundleExtras(parser, this.mEditor.mInputContentType.extras);
    }

    private final Bundle $$robo$$android_widget_TextView$getInputExtras(boolean create) {
        if (this.mEditor == null && !create) {
            return null;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mInputContentType == null) {
            if (!create) {
                return null;
            }
            this.mEditor.createInputContentTypeIfNeeded();
        }
        if (this.mEditor.mInputContentType.extras == null) {
            if (!create) {
                return null;
            }
            this.mEditor.mInputContentType.extras = new Bundle();
        }
        return this.mEditor.mInputContentType.extras;
    }

    private final void $$robo$$android_widget_TextView$setImeHintLocales(LocaleList hintLocales) {
        this.createEditorIfNeeded();
        this.mEditor.createInputContentTypeIfNeeded();
        this.mEditor.mInputContentType.imeHintLocales = hintLocales;
    }

    private final LocaleList $$robo$$android_widget_TextView$getImeHintLocales() {
        if (this.mEditor == null) {
            return null;
        }
        if (this.mEditor.mInputContentType == null) {
            return null;
        }
        return this.mEditor.mInputContentType.imeHintLocales;
    }

    private final CharSequence $$robo$$android_widget_TextView$getError() {
        return this.mEditor == null ? null : this.mEditor.mError;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setError(CharSequence error) {
        if (error == null) {
            this.setError(null, null);
        } else {
            Drawable dr = this.getContext().getDrawable(17302598);
            dr.setBounds(0, 0, dr.getIntrinsicWidth(), dr.getIntrinsicHeight());
            this.setError(error, dr);
        }
    }

    private final void $$robo$$android_widget_TextView$setError(CharSequence error, Drawable icon) {
        this.createEditorIfNeeded();
        this.mEditor.setError(error, icon);
        this.notifyViewAccessibilityStateChangedIfNeeded(0);
    }

    private final boolean $$robo$$android_widget_TextView$setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.mEditor != null) {
            this.mEditor.setFrame();
        }
        this.restartMarqueeIfNeeded();
        return result;
    }

    private final void $$robo$$android_widget_TextView$restartMarqueeIfNeeded() {
        if (this.mRestartMarquee && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            this.mRestartMarquee = false;
            this.startMarquee();
        }
    }

    private final void $$robo$$android_widget_TextView$setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = filters;
        if (this.mText instanceof Editable) {
            this.setFilters((Editable)this.mText, filters);
        }
    }

    private final void $$robo$$android_widget_TextView$setFilters(Editable e, InputFilter[] filters) {
        if (this.mEditor != null) {
            boolean undoFilter = this.mEditor.mUndoInputFilter != null;
            boolean keyFilter = this.mEditor.mKeyListener instanceof InputFilter;
            int num = 0;
            if (undoFilter) {
                ++num;
            }
            if (keyFilter) {
                ++num;
            }
            if (num > 0) {
                InputFilter[] nf = new InputFilter[filters.length + num];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)filters, (int)0, (Object)nf, (int)0, (int)filters.length);
                num = 0;
                if (undoFilter) {
                    nf[filters.length] = this.mEditor.mUndoInputFilter;
                    ++num;
                }
                if (keyFilter) {
                    nf[filters.length + num] = (InputFilter)((Object)this.mEditor.mKeyListener);
                }
                e.setFilters(nf);
                return;
            }
        }
        e.setFilters(filters);
    }

    private final InputFilter[] $$robo$$android_widget_TextView$getFilters() {
        return this.mFilters;
    }

    private final int $$robo$$android_widget_TextView$getBoxHeight(Layout l) {
        Insets opticalInsets = TextView.isLayoutModeOptical(this.mParent) ? this.getOpticalInsets() : Insets.NONE;
        int padding = l == this.mHintLayout ? this.getCompoundPaddingTop() + this.getCompoundPaddingBottom() : this.getExtendedPaddingTop() + this.getExtendedPaddingBottom();
        return this.getMeasuredHeight() - padding + opticalInsets.top + opticalInsets.bottom;
    }

    private final int $$robo$$android_widget_TextView$getVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 48) {
            int boxht = this.getBoxHeight(l);
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 80 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    private final int $$robo$$android_widget_TextView$getBottomVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 80) {
            int boxht = this.getBoxHeight(l);
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 48 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_TextView$invalidateCursorPath() {
        if (this.mHighlightPathBogus) {
            this.invalidateCursor();
        } else {
            int horizontalPadding = this.getCompoundPaddingLeft();
            int verticalPadding = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
            if (this.mEditor.mCursorCount == 0) {
                RectF rectF = TEMP_RECTF;
                synchronized (rectF) {
                    float thick = (float)Math.ceil(this.mTextPaint.getStrokeWidth());
                    if (thick < 1.0f) {
                        thick = 1.0f;
                    }
                    this.mHighlightPath.computeBounds(TEMP_RECTF, false);
                    this.invalidate((int)Math.floor((float)horizontalPadding + TextView.TEMP_RECTF.left - (thick /= 2.0f)), (int)Math.floor((float)verticalPadding + TextView.TEMP_RECTF.top - thick), (int)Math.ceil((float)horizontalPadding + TextView.TEMP_RECTF.right + thick), (int)Math.ceil((float)verticalPadding + TextView.TEMP_RECTF.bottom + thick));
                }
            } else {
                for (int i = 0; i < this.mEditor.mCursorCount; ++i) {
                    Rect bounds = this.mEditor.mCursorDrawable[i].getBounds();
                    this.invalidate(bounds.left + horizontalPadding, bounds.top + verticalPadding, bounds.right + horizontalPadding, bounds.bottom + verticalPadding);
                }
            }
        }
    }

    private final void $$robo$$android_widget_TextView$invalidateCursor() {
        int where = this.getSelectionEnd();
        this.invalidateCursor(where, where, where);
    }

    private final void $$robo$$android_widget_TextView$invalidateCursor(int a, int b, int c) {
        if (a >= 0 || b >= 0 || c >= 0) {
            int start = Math.min(Math.min(a, b), c);
            int end = Math.max(Math.max(a, b), c);
            this.invalidateRegion(start, end, true);
        }
    }

    private final void $$robo$$android_widget_TextView$invalidateRegion(int start, int end, boolean invalidateCursor) {
        if (this.mLayout == null) {
            this.invalidate();
        } else {
            int right;
            int left;
            int lineStart = this.mLayout.getLineForOffset(start);
            int top = this.mLayout.getLineTop(lineStart);
            if (lineStart > 0) {
                top -= this.mLayout.getLineDescent(lineStart - 1);
            }
            int lineEnd = start == end ? lineStart : this.mLayout.getLineForOffset(end);
            int bottom = this.mLayout.getLineBottom(lineEnd);
            if (invalidateCursor && this.mEditor != null) {
                for (int i = 0; i < this.mEditor.mCursorCount; ++i) {
                    Rect bounds = this.mEditor.mCursorDrawable[i].getBounds();
                    top = Math.min(top, bounds.top);
                    bottom = Math.max(bottom, bounds.bottom);
                }
            }
            int compoundPaddingLeft = this.getCompoundPaddingLeft();
            int verticalPadding = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
            if (lineStart == lineEnd && !invalidateCursor) {
                left = (int)this.mLayout.getPrimaryHorizontal(start);
                right = (int)((double)this.mLayout.getPrimaryHorizontal(end) + 1.0);
                left += compoundPaddingLeft;
                right += compoundPaddingLeft;
            } else {
                left = compoundPaddingLeft;
                right = this.getWidth() - this.getCompoundPaddingRight();
            }
            this.invalidate(this.mScrollX + left, verticalPadding + top, this.mScrollX + right, verticalPadding + bottom);
        }
    }

    private final void $$robo$$android_widget_TextView$registerForPreDraw() {
        if (!this.mPreDrawRegistered) {
            this.getViewTreeObserver().addOnPreDrawListener(this);
            this.mPreDrawRegistered = true;
        }
    }

    private final void $$robo$$android_widget_TextView$unregisterForPreDraw() {
        this.getViewTreeObserver().removeOnPreDrawListener(this);
        this.mPreDrawRegistered = false;
        this.mPreDrawListenerDetached = false;
    }

    private final boolean $$robo$$android_widget_TextView$onPreDraw() {
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        if (this.mMovement != null) {
            int curs = this.getSelectionEnd();
            if (this.mEditor != null && this.mEditor.mSelectionModifierCursorController != null && this.mEditor.mSelectionModifierCursorController.isSelectionStartDragged()) {
                curs = this.getSelectionStart();
            }
            if (curs < 0 && (this.mGravity & 0x70) == 80) {
                curs = this.mText.length();
            }
            if (curs >= 0) {
                this.bringPointIntoView(curs);
            }
        } else {
            this.bringTextIntoView();
        }
        if (this.mEditor != null && this.mEditor.mCreatedWithASelection) {
            this.mEditor.refreshTextActionMode();
            this.mEditor.mCreatedWithASelection = false;
        }
        this.unregisterForPreDraw();
        return true;
    }

    private final void $$robo$$android_widget_TextView$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mEditor != null) {
            this.mEditor.onAttachedToWindow();
        }
        if (this.mPreDrawListenerDetached) {
            this.getViewTreeObserver().addOnPreDrawListener(this);
            this.mPreDrawListenerDetached = false;
        }
    }

    private final void $$robo$$android_widget_TextView$onDetachedFromWindowInternal() {
        if (this.mPreDrawRegistered) {
            this.getViewTreeObserver().removeOnPreDrawListener(this);
            this.mPreDrawListenerDetached = true;
        }
        this.resetResolvedDrawables();
        if (this.mEditor != null) {
            this.mEditor.onDetachedFromWindow();
        }
        super.onDetachedFromWindowInternal();
    }

    private final void $$robo$$android_widget_TextView$onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        if (this.mEditor != null) {
            this.mEditor.onScreenStateChanged(screenState);
        }
    }

    private final boolean $$robo$$android_widget_TextView$isPaddingOffsetRequired() {
        return this.mShadowRadius != 0.0f || this.mDrawables != null;
    }

    private final int $$robo$$android_widget_TextView$getLeftPaddingOffset() {
        return this.getCompoundPaddingLeft() - this.mPaddingLeft + (int)Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
    }

    private final int $$robo$$android_widget_TextView$getTopPaddingOffset() {
        return (int)Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
    }

    private final int $$robo$$android_widget_TextView$getBottomPaddingOffset() {
        return (int)Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
    }

    private final int $$robo$$android_widget_TextView$getRightPaddingOffset() {
        return -(this.getCompoundPaddingRight() - this.mPaddingRight) + (int)Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
    }

    private final boolean $$robo$$android_widget_TextView$verifyDrawable(Drawable who) {
        boolean verified = super.verifyDrawable(who);
        if (!verified && this.mDrawables != null) {
            for (Drawable dr : this.mDrawables.mShowing) {
                if (who != dr) continue;
                return true;
            }
        }
        return verified;
    }

    private final void $$robo$$android_widget_TextView$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDrawables != null) {
            for (Drawable dr : this.mDrawables.mShowing) {
                if (dr == null) continue;
                dr.jumpToCurrentState();
            }
        }
    }

    private final void $$robo$$android_widget_TextView$invalidateDrawable(Drawable drawable2) {
        boolean handled = false;
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            Drawables drawables = this.mDrawables;
            if (drawables != null) {
                if (drawable2 == drawables.mShowing[0]) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mPaddingLeft;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightLeft) / 2;
                    handled = true;
                } else if (drawable2 == drawables.mShowing[2]) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mRight - this.mLeft - this.mPaddingRight - drawables.mDrawableSizeRight;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightRight) / 2;
                    handled = true;
                } else if (drawable2 == drawables.mShowing[1]) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthTop) / 2;
                    scrollY += this.mPaddingTop;
                    handled = true;
                } else if (drawable2 == drawables.mShowing[3]) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthBottom) / 2;
                    scrollY += this.mBottom - this.mTop - this.mPaddingBottom - drawables.mDrawableSizeBottom;
                    handled = true;
                }
            }
            if (handled) {
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            }
        }
        if (!handled) {
            super.invalidateDrawable(drawable2);
        }
    }

    private final boolean $$robo$$android_widget_TextView$hasOverlappingRendering() {
        return this.getBackground() != null && this.getBackground().getCurrent() != null || this.mText instanceof Spannable || this.hasSelection() || this.isHorizontalFadingEdgeEnabled();
    }

    private final boolean $$robo$$android_widget_TextView$isTextSelectable() {
        return this.mEditor == null ? false : this.mEditor.mTextIsSelectable;
    }

    private final void $$robo$$android_widget_TextView$setTextIsSelectable(boolean selectable) {
        if (!selectable && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mTextIsSelectable == selectable) {
            return;
        }
        this.mEditor.mTextIsSelectable = selectable;
        this.setFocusableInTouchMode(selectable);
        this.setFocusable(selectable);
        this.setClickable(selectable);
        this.setLongClickable(selectable);
        this.setMovementMethod(selectable ? ArrowKeyMovementMethod.getInstance() : null);
        this.setText(this.mText, selectable ? BufferType.SPANNABLE : BufferType.NORMAL);
        this.mEditor.prepareCursorControllers();
    }

    private final int[] $$robo$$android_widget_TextView$onCreateDrawableState(int extraSpace) {
        int[] drawableState;
        if (this.mSingleLine) {
            drawableState = super.onCreateDrawableState(extraSpace);
        } else {
            drawableState = super.onCreateDrawableState(extraSpace + 1);
            TextView.mergeDrawableStates(drawableState, MULTILINE_STATE_SET);
        }
        if (this.isTextSelectable()) {
            int length = drawableState.length;
            for (int i = 0; i < length; ++i) {
                if (drawableState[i] != 16842919) continue;
                int[] nonPressedState = new int[length - 1];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])drawableState, (int)0, (int[])nonPressedState, (int)0, (int)i);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])drawableState, (int)(i + 1), (int[])nonPressedState, (int)i, (int)(length - i - 1));
                return nonPressedState;
            }
        }
        return drawableState;
    }

    private final Path $$robo$$android_widget_TextView$getUpdatedHighlightPath() {
        Path highlight = null;
        Paint highlightPaint = this.mHighlightPaint;
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        if (this.mMovement != null && (this.isFocused() || this.isPressed()) && selStart >= 0) {
            if (selStart == selEnd) {
                if (this.mEditor != null && this.mEditor.isCursorVisible() && (SystemClock.uptimeMillis() - this.mEditor.mShowCursor) % 1000L < 500L) {
                    if (this.mHighlightPathBogus) {
                        if (this.mHighlightPath == null) {
                            this.mHighlightPath = new Path();
                        }
                        this.mHighlightPath.reset();
                        this.mLayout.getCursorPath(selStart, this.mHighlightPath, this.mText);
                        this.mEditor.updateCursorsPositions();
                        this.mHighlightPathBogus = false;
                    }
                    highlightPaint.setColor(this.mCurTextColor);
                    highlightPaint.setStyle(Paint.Style.STROKE);
                    highlight = this.mHighlightPath;
                }
            } else {
                if (this.mHighlightPathBogus) {
                    if (this.mHighlightPath == null) {
                        this.mHighlightPath = new Path();
                    }
                    this.mHighlightPath.reset();
                    this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                    this.mHighlightPathBogus = false;
                }
                highlightPaint.setColor(this.mHighlightColor);
                highlightPaint.setStyle(Paint.Style.FILL);
                highlight = this.mHighlightPath;
            }
        }
        return highlight;
    }

    private final int $$robo$$android_widget_TextView$getHorizontalOffsetForDrawables() {
        return 0;
    }

    private final void $$robo$$android_widget_TextView$onDraw(Canvas canvas) {
        float dx;
        this.restartMarqueeIfNeeded();
        super.onDraw(canvas);
        int compoundPaddingLeft = this.getCompoundPaddingLeft();
        int compoundPaddingTop = this.getCompoundPaddingTop();
        int compoundPaddingRight = this.getCompoundPaddingRight();
        int compoundPaddingBottom = this.getCompoundPaddingBottom();
        int scrollX = this.mScrollX;
        int scrollY = this.mScrollY;
        int right = this.mRight;
        int left = this.mLeft;
        int bottom = this.mBottom;
        int top = this.mTop;
        boolean isLayoutRtl = this.isLayoutRtl();
        int offset = this.getHorizontalOffsetForDrawables();
        int leftOffset = isLayoutRtl ? 0 : offset;
        int rightOffset = isLayoutRtl ? offset : 0;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            int vspace = bottom - top - compoundPaddingBottom - compoundPaddingTop;
            int hspace = right - left - compoundPaddingRight - compoundPaddingLeft;
            if (dr.mShowing[0] != null) {
                canvas.save();
                canvas.translate(scrollX + this.mPaddingLeft + leftOffset, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightLeft) / 2);
                dr.mShowing[0].draw(canvas);
                canvas.restore();
            }
            if (dr.mShowing[2] != null) {
                canvas.save();
                canvas.translate(scrollX + right - left - this.mPaddingRight - dr.mDrawableSizeRight - rightOffset, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightRight) / 2);
                dr.mShowing[2].draw(canvas);
                canvas.restore();
            }
            if (dr.mShowing[1] != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthTop) / 2, scrollY + this.mPaddingTop);
                dr.mShowing[1].draw(canvas);
                canvas.restore();
            }
            if (dr.mShowing[3] != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthBottom) / 2, scrollY + bottom - top - this.mPaddingBottom - dr.mDrawableSizeBottom);
                dr.mShowing[3].draw(canvas);
                canvas.restore();
            }
        }
        int color2 = this.mCurTextColor;
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        Layout layout2 = this.mLayout;
        if (this.mHint != null && this.mText.length() == 0) {
            if (this.mHintTextColor != null) {
                color2 = this.mCurHintTextColor;
            }
            layout2 = this.mHintLayout;
        }
        this.mTextPaint.setColor(color2);
        this.mTextPaint.drawableState = this.getDrawableState();
        canvas.save();
        int extendedPaddingTop = this.getExtendedPaddingTop();
        int extendedPaddingBottom = this.getExtendedPaddingBottom();
        int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
        int maxScrollY = this.mLayout.getHeight() - vspace;
        float clipLeft = compoundPaddingLeft + scrollX;
        float clipTop = scrollY == 0 ? 0.0f : (float)(extendedPaddingTop + scrollY);
        float clipRight = right - left - this.getCompoundPaddingRight() + scrollX;
        float clipBottom = bottom - top + scrollY - (scrollY == maxScrollY ? 0 : extendedPaddingBottom);
        if (this.mShadowRadius != 0.0f) {
            clipLeft += Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
            clipRight += Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
            clipTop += Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
            clipBottom += Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
        }
        canvas.clipRect(clipLeft, clipTop, clipRight, clipBottom);
        int voffsetText = 0;
        int voffsetCursor = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffsetText = this.getVerticalOffset(false);
            voffsetCursor = this.getVerticalOffset(true);
        }
        canvas.translate(compoundPaddingLeft, extendedPaddingTop + voffsetText);
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
        if (this.isMarqueeFadeEnabled()) {
            if (!this.mSingleLine && this.getLineCount() == 1 && this.canMarquee() && (absoluteGravity & 7) != 3) {
                int width = this.mRight - this.mLeft;
                int padding = this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
                dx = this.mLayout.getLineRight(0) - (float)(width - padding);
                canvas.translate((float)layout2.getParagraphDirection(0) * dx, 0.0f);
            }
            if (this.mMarquee != null && this.mMarquee.isRunning()) {
                float dx2 = -this.mMarquee.getScroll();
                canvas.translate((float)layout2.getParagraphDirection(0) * dx2, 0.0f);
            }
        }
        int cursorOffsetVertical = voffsetCursor - voffsetText;
        Path highlight = this.getUpdatedHighlightPath();
        if (this.mEditor != null) {
            this.mEditor.onDraw(canvas, layout2, highlight, this.mHighlightPaint, cursorOffsetVertical);
        } else {
            layout2.draw(canvas, highlight, this.mHighlightPaint, cursorOffsetVertical);
        }
        if (this.mMarquee != null && this.mMarquee.shouldDrawGhost()) {
            dx = this.mMarquee.getGhostOffset();
            canvas.translate((float)layout2.getParagraphDirection(0) * dx, 0.0f);
            layout2.draw(canvas, highlight, this.mHighlightPaint, cursorOffsetVertical);
        }
        canvas.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_TextView$getFocusedRect(Rect r) {
        if (this.mLayout == null) {
            super.getFocusedRect(r);
            return;
        }
        int selEnd = this.getSelectionEnd();
        if (selEnd < 0) {
            super.getFocusedRect(r);
            return;
        }
        int selStart = this.getSelectionStart();
        if (selStart < 0 || selStart >= selEnd) {
            int line = this.mLayout.getLineForOffset(selEnd);
            r.top = this.mLayout.getLineTop(line);
            r.bottom = this.mLayout.getLineBottom(line);
            r.left = (int)this.mLayout.getPrimaryHorizontal(selEnd) - 2;
            r.right = r.left + 4;
        } else {
            int lineStart = this.mLayout.getLineForOffset(selStart);
            int lineEnd = this.mLayout.getLineForOffset(selEnd);
            r.top = this.mLayout.getLineTop(lineStart);
            r.bottom = this.mLayout.getLineBottom(lineEnd);
            if (lineStart == lineEnd) {
                r.left = (int)this.mLayout.getPrimaryHorizontal(selStart);
                r.right = (int)this.mLayout.getPrimaryHorizontal(selEnd);
            } else {
                if (this.mHighlightPathBogus) {
                    if (this.mHighlightPath == null) {
                        this.mHighlightPath = new Path();
                    }
                    this.mHighlightPath.reset();
                    this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                    this.mHighlightPathBogus = false;
                }
                RectF rectF = TEMP_RECTF;
                synchronized (rectF) {
                    this.mHighlightPath.computeBounds(TEMP_RECTF, true);
                    r.left = (int)TextView.TEMP_RECTF.left - 1;
                    r.right = (int)TextView.TEMP_RECTF.right + 1;
                }
            }
        }
        int paddingLeft = this.getCompoundPaddingLeft();
        int paddingTop = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            paddingTop += this.getVerticalOffset(false);
        }
        r.offset(paddingLeft, paddingTop);
        int paddingBottom = this.getExtendedPaddingBottom();
        r.bottom += paddingBottom;
    }

    private final int $$robo$$android_widget_TextView$getLineCount() {
        return this.mLayout != null ? this.mLayout.getLineCount() : 0;
    }

    private final int $$robo$$android_widget_TextView$getLineBounds(int line, Rect bounds) {
        if (this.mLayout == null) {
            if (bounds != null) {
                bounds.set(0, 0, 0, 0);
            }
            return 0;
        }
        int baseline = this.mLayout.getLineBounds(line, bounds);
        int voffset = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            voffset += this.getVerticalOffset(true);
        }
        if (bounds != null) {
            bounds.offset(this.getCompoundPaddingLeft(), voffset);
        }
        return baseline + voffset;
    }

    private final int $$robo$$android_widget_TextView$getBaseline() {
        if (this.mLayout == null) {
            return super.getBaseline();
        }
        return this.getBaselineOffset() + this.mLayout.getLineBaseline(0);
    }

    private final int $$robo$$android_widget_TextView$getBaselineOffset() {
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        if (TextView.isLayoutModeOptical(this.mParent)) {
            voffset -= this.getOpticalInsets().top;
        }
        return this.getExtendedPaddingTop() + voffset;
    }

    private final int $$robo$$android_widget_TextView$getFadeTop(boolean offsetRequired) {
        if (this.mLayout == null) {
            return 0;
        }
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        if (offsetRequired) {
            voffset += this.getTopPaddingOffset();
        }
        return this.getExtendedPaddingTop() + voffset;
    }

    private final int $$robo$$android_widget_TextView$getFadeHeight(boolean offsetRequired) {
        return this.mLayout != null ? this.mLayout.getHeight() : 0;
    }

    private final PointerIcon $$robo$$android_widget_TextView$onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        float y;
        float x;
        int offset;
        ClickableSpan[] clickables;
        if (this.mText instanceof Spannable && this.mLinksClickable && (clickables = ((Spannable)this.mText).getSpans(offset = this.getOffsetForPosition(x = event.getX(pointerIndex), y = event.getY(pointerIndex)), offset, ClickableSpan.class)).length > 0) {
            return PointerIcon.getSystemIcon(this.mContext, 1002);
        }
        if (this.isTextSelectable() || this.isTextEditable()) {
            return PointerIcon.getSystemIcon(this.mContext, 1008);
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    private final boolean $$robo$$android_widget_TextView$onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.handleBackInTextActionModeIfNeeded(event)) {
            return true;
        }
        return super.onKeyPreIme(keyCode, event);
    }

    private final boolean $$robo$$android_widget_TextView$handleBackInTextActionModeIfNeeded(KeyEvent event) {
        if (this.mEditor == null || this.mEditor.mTextActionMode == null) {
            return false;
        }
        if (event.getAction() == 0 && event.getRepeatCount() == 0) {
            KeyEvent.DispatcherState state = this.getKeyDispatcherState();
            if (state != null) {
                state.startTracking(event, this);
            }
            return true;
        }
        if (event.getAction() == 1) {
            KeyEvent.DispatcherState state = this.getKeyDispatcherState();
            if (state != null) {
                state.handleUpEvent(event);
            }
            if (event.isTracking() && !event.isCanceled()) {
                this.stopTextActionMode();
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_TextView$onKeyDown(int keyCode, KeyEvent event) {
        int which = this.doKeyDown(keyCode, event, null);
        if (which == 0) {
            return super.onKeyDown(keyCode, event);
        }
        return true;
    }

    private final boolean $$robo$$android_widget_TextView$onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        KeyEvent down = KeyEvent.changeAction(event, 0);
        int which = this.doKeyDown(keyCode, down, event);
        if (which == 0) {
            return super.onKeyMultiple(keyCode, repeatCount, event);
        }
        if (which == -1) {
            return true;
        }
        --repeatCount;
        KeyEvent up = KeyEvent.changeAction(event, 1);
        if (which == 1) {
            this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mEditor.mKeyListener.onKeyDown(this, (Editable)this.mText, keyCode, down);
                this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, up);
            }
            this.hideErrorIfUnchanged();
        } else if (which == 2) {
            this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mMovement.onKeyDown(this, (Spannable)this.mText, keyCode, down);
                this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, up);
            }
        }
        return true;
    }

    private final boolean $$robo$$android_widget_TextView$shouldAdvanceFocusOnEnter() {
        int variation;
        if (this.getKeyListener() == null) {
            return false;
        }
        if (this.mSingleLine) {
            return true;
        }
        return this.mEditor != null && (this.mEditor.mInputType & 0xF) == 1 && ((variation = this.mEditor.mInputType & 0xFF0) == 32 || variation == 48);
    }

    private final boolean $$robo$$android_widget_TextView$shouldAdvanceFocusOnTab() {
        int variation;
        return this.getKeyListener() == null || this.mSingleLine || this.mEditor == null || (this.mEditor.mInputType & 0xF) != 1 || (variation = this.mEditor.mInputType & 0xFF0) != 262144 && variation != 131072;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_widget_TextView$doKeyDown(int keyCode, KeyEvent event, KeyEvent otherEvent) {
        boolean handled;
        boolean doDown;
        if (!this.isEnabled()) {
            return 0;
        }
        if (event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(keyCode)) {
            this.mPreventDefaultMovement = false;
        }
        switch (keyCode) {
            case 66: {
                if (!event.hasNoModifiers()) break;
                if (this.mEditor != null && this.mEditor.mInputContentType != null && this.mEditor.mInputContentType.onEditorActionListener != null && this.mEditor.mInputContentType.onEditorActionListener.onEditorAction(this, 0, event)) {
                    this.mEditor.mInputContentType.enterDown = true;
                    return -1;
                }
                if ((event.getFlags() & 0x10) == 0 && !this.shouldAdvanceFocusOnEnter()) break;
                if (this.hasOnClickListeners()) {
                    return 0;
                }
                return -1;
            }
            case 23: {
                if (!event.hasNoModifiers() || !this.shouldAdvanceFocusOnEnter()) break;
                return 0;
            }
            case 61: {
                if (!event.hasNoModifiers() && !event.hasModifiers(1) || !this.shouldAdvanceFocusOnTab()) break;
                return 0;
            }
            case 4: {
                if (this.mEditor == null || this.mEditor.mTextActionMode == null) break;
                this.stopTextActionMode();
                return -1;
            }
            case 277: {
                if (!event.hasNoModifiers() || !this.canCut() || !this.onTextContextMenuItem(0x1020020)) break;
                return -1;
            }
            case 278: {
                if (!event.hasNoModifiers() || !this.canCopy() || !this.onTextContextMenuItem(0x1020021)) break;
                return -1;
            }
            case 279: {
                if (!event.hasNoModifiers() || !this.canPaste() || !this.onTextContextMenuItem(0x1020022)) break;
                return -1;
            }
        }
        if (this.mEditor != null && this.mEditor.mKeyListener != null) {
            doDown = true;
            if (otherEvent != null) {
                try {
                    this.beginBatchEdit();
                    handled = this.mEditor.mKeyListener.onKeyOther(this, (Editable)this.mText, otherEvent);
                    this.hideErrorIfUnchanged();
                    doDown = false;
                    if (handled) {
                        int n = -1;
                        return n;
                    }
                }
                catch (AbstractMethodError handled2) {
                }
                finally {
                    this.endBatchEdit();
                }
            }
            if (doDown) {
                this.beginBatchEdit();
                handled = this.mEditor.mKeyListener.onKeyDown(this, (Editable)this.mText, keyCode, event);
                this.endBatchEdit();
                this.hideErrorIfUnchanged();
                if (handled) {
                    return 1;
                }
            }
        }
        if (this.mMovement != null && this.mLayout != null) {
            doDown = true;
            if (otherEvent != null) {
                try {
                    handled = this.mMovement.onKeyOther(this, (Spannable)this.mText, otherEvent);
                    doDown = false;
                    if (handled) {
                        return -1;
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            if (doDown && this.mMovement.onKeyDown(this, (Spannable)this.mText, keyCode, event)) {
                if (event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(keyCode)) {
                    this.mPreventDefaultMovement = true;
                }
                return 2;
            }
        }
        return this.mPreventDefaultMovement && !KeyEvent.isModifierKey(keyCode) ? -1 : 0;
    }

    private final void $$robo$$android_widget_TextView$resetErrorChangedFlag() {
        if (this.mEditor != null) {
            this.mEditor.mErrorWasChanged = false;
        }
    }

    private final void $$robo$$android_widget_TextView$hideErrorIfUnchanged() {
        if (this.mEditor != null && this.mEditor.mError != null && !this.mEditor.mErrorWasChanged) {
            this.setError(null, null);
        }
    }

    private final boolean $$robo$$android_widget_TextView$onKeyUp(int keyCode, KeyEvent event) {
        if (!this.isEnabled()) {
            return super.onKeyUp(keyCode, event);
        }
        if (!KeyEvent.isModifierKey(keyCode)) {
            this.mPreventDefaultMovement = false;
        }
        switch (keyCode) {
            case 23: {
                if (event.hasNoModifiers() && !this.hasOnClickListeners() && this.mMovement != null && this.mText instanceof Editable && this.mLayout != null && this.onCheckIsTextEditor()) {
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    this.viewClicked(imm);
                    if (imm != null && this.getShowSoftInputOnFocus()) {
                        imm.showSoftInput(this, 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
            case 66: {
                if (!event.hasNoModifiers()) break;
                if (this.mEditor != null && this.mEditor.mInputContentType != null && this.mEditor.mInputContentType.onEditorActionListener != null && this.mEditor.mInputContentType.enterDown) {
                    this.mEditor.mInputContentType.enterDown = false;
                    if (this.mEditor.mInputContentType.onEditorActionListener.onEditorAction(this, 0, event)) {
                        return true;
                    }
                }
                if (((event.getFlags() & 0x10) != 0 || this.shouldAdvanceFocusOnEnter()) && !this.hasOnClickListeners()) {
                    InputMethodManager imm;
                    View v = this.focusSearch(130);
                    if (v != null) {
                        if (!v.requestFocus(130)) {
                            throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                        }
                        super.onKeyUp(keyCode, event);
                        return true;
                    }
                    if ((event.getFlags() & 0x10) != 0 && (imm = InputMethodManager.peekInstance()) != null && imm.isActive(this)) {
                        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
        }
        if (this.mEditor != null && this.mEditor.mKeyListener != null && this.mEditor.mKeyListener.onKeyUp(this, (Editable)this.mText, keyCode, event)) {
            return true;
        }
        if (this.mMovement != null && this.mLayout != null && this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private final boolean $$robo$$android_widget_TextView$onCheckIsTextEditor() {
        return this.mEditor != null && this.mEditor.mInputType != 0;
    }

    private final InputConnection $$robo$$android_widget_TextView$onCreateInputConnection(EditorInfo outAttrs) {
        if (this.onCheckIsTextEditor() && this.isEnabled()) {
            this.mEditor.createInputMethodStateIfNeeded();
            outAttrs.inputType = this.getInputType();
            if (this.mEditor.mInputContentType != null) {
                outAttrs.imeOptions = this.mEditor.mInputContentType.imeOptions;
                outAttrs.privateImeOptions = this.mEditor.mInputContentType.privateImeOptions;
                outAttrs.actionLabel = this.mEditor.mInputContentType.imeActionLabel;
                outAttrs.actionId = this.mEditor.mInputContentType.imeActionId;
                outAttrs.extras = this.mEditor.mInputContentType.extras;
                outAttrs.hintLocales = this.mEditor.mInputContentType.imeHintLocales;
            } else {
                outAttrs.imeOptions = 0;
                outAttrs.hintLocales = null;
            }
            if (this.focusSearch(130) != null) {
                outAttrs.imeOptions |= 0x8000000;
            }
            if (this.focusSearch(33) != null) {
                outAttrs.imeOptions |= 0x4000000;
            }
            if ((outAttrs.imeOptions & 0xFF) == 0) {
                outAttrs.imeOptions = (outAttrs.imeOptions & 0x8000000) != 0 ? (outAttrs.imeOptions |= 5) : (outAttrs.imeOptions |= 6);
                if (!this.shouldAdvanceFocusOnEnter()) {
                    outAttrs.imeOptions |= 0x40000000;
                }
            }
            if (TextView.isMultilineInputType(outAttrs.inputType)) {
                outAttrs.imeOptions |= 0x40000000;
            }
            outAttrs.hintText = this.mHint;
            if (this.mText instanceof Editable) {
                EditableInputConnection ic = new EditableInputConnection(this);
                outAttrs.initialSelStart = this.getSelectionStart();
                outAttrs.initialSelEnd = this.getSelectionEnd();
                outAttrs.initialCapsMode = ic.getCursorCapsMode(this.getInputType());
                return ic;
            }
        }
        return null;
    }

    private final boolean $$robo$$android_widget_TextView$extractText(ExtractedTextRequest request, ExtractedText outText) {
        this.createEditorIfNeeded();
        return this.mEditor.extractText(request, outText);
    }

    private static final void $$robo$$android_widget_TextView$removeParcelableSpans(Spannable spannable, int start, int end) {
        ParcelableSpan[] spans = spannable.getSpans(start, end, ParcelableSpan.class);
        int i = spans.length;
        while (i > 0) {
            spannable.removeSpan(spans[--i]);
        }
    }

    private final void $$robo$$android_widget_TextView$setExtractedText(ExtractedText text) {
        Editable content = this.getEditableText();
        if (text.text != null) {
            if (content == null) {
                this.setText(text.text, BufferType.EDITABLE);
            } else {
                int start = 0;
                int end = content.length();
                if (text.partialStartOffset >= 0) {
                    start = text.partialStartOffset;
                    int N = content.length();
                    if (start > N) {
                        start = N;
                    }
                    if ((end = text.partialEndOffset) > N) {
                        end = N;
                    }
                }
                TextView.removeParcelableSpans(content, start, end);
                if (TextUtils.equals(content.subSequence(start, end), text.text)) {
                    if (text.text instanceof Spanned) {
                        TextUtils.copySpansFrom((Spanned)text.text, 0, end - start, Object.class, content, start);
                    }
                } else {
                    content.replace(start, end, text.text);
                }
            }
        }
        Spannable sp = (Spannable)this.getText();
        int N = sp.length();
        int start = text.selectionStart;
        if (start < 0) {
            start = 0;
        } else if (start > N) {
            start = N;
        }
        int end = text.selectionEnd;
        if (end < 0) {
            end = 0;
        } else if (end > N) {
            end = N;
        }
        Selection.setSelection(sp, start, end);
        if ((text.flags & 2) != 0) {
            MetaKeyKeyListener.startSelecting(this, sp);
        } else {
            MetaKeyKeyListener.stopSelecting(this, sp);
        }
    }

    private final void $$robo$$android_widget_TextView$setExtracting(ExtractedTextRequest req) {
        if (this.mEditor.mInputMethodState != null) {
            this.mEditor.mInputMethodState.mExtractedTextRequest = req;
        }
        this.mEditor.hideCursorAndSpanControllers();
        this.stopTextActionMode();
        if (this.mEditor.mSelectionModifierCursorController != null) {
            this.mEditor.mSelectionModifierCursorController.resetTouchOffsets();
        }
    }

    private final void $$robo$$android_widget_TextView$onCommitCompletion(CompletionInfo text) {
    }

    private final void $$robo$$android_widget_TextView$onCommitCorrection(CorrectionInfo info) {
        if (this.mEditor != null) {
            this.mEditor.onCommitCorrection(info);
        }
    }

    private final void $$robo$$android_widget_TextView$beginBatchEdit() {
        if (this.mEditor != null) {
            this.mEditor.beginBatchEdit();
        }
    }

    private final void $$robo$$android_widget_TextView$endBatchEdit() {
        if (this.mEditor != null) {
            this.mEditor.endBatchEdit();
        }
    }

    private final void $$robo$$android_widget_TextView$onBeginBatchEdit() {
    }

    private final void $$robo$$android_widget_TextView$onEndBatchEdit() {
    }

    private final boolean $$robo$$android_widget_TextView$onPrivateIMECommand(String action, Bundle data) {
        return false;
    }

    private final void $$robo$$android_widget_TextView$nullLayouts() {
        if (this.mLayout instanceof BoringLayout && this.mSavedLayout == null) {
            this.mSavedLayout = (BoringLayout)this.mLayout;
        }
        if (this.mHintLayout instanceof BoringLayout && this.mSavedHintLayout == null) {
            this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
        }
        this.mHintLayout = null;
        this.mLayout = null;
        this.mSavedMarqueeModeLayout = null;
        this.mHintBoring = null;
        this.mBoring = null;
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
    }

    private final void $$robo$$android_widget_TextView$assumeLayout() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (width < 1) {
            width = 0;
        }
        int physicalWidth = width;
        if (this.mHorizontallyScrolling) {
            width = 0x100000;
        }
        this.makeNewLayout(width, physicalWidth, UNKNOWN_BORING, UNKNOWN_BORING, physicalWidth, false);
    }

    private final Layout.Alignment $$robo$$android_widget_TextView$getLayoutAlignment() {
        Layout.Alignment alignment;
        block0 : switch (this.getTextAlignment()) {
            case 1: {
                switch (this.mGravity & 0x800007) {
                    case 0x800003: {
                        alignment = Layout.Alignment.ALIGN_NORMAL;
                        break block0;
                    }
                    case 0x800005: {
                        alignment = Layout.Alignment.ALIGN_OPPOSITE;
                        break block0;
                    }
                    case 3: {
                        alignment = Layout.Alignment.ALIGN_LEFT;
                        break block0;
                    }
                    case 5: {
                        alignment = Layout.Alignment.ALIGN_RIGHT;
                        break block0;
                    }
                    case 1: {
                        alignment = Layout.Alignment.ALIGN_CENTER;
                        break block0;
                    }
                }
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 2: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 3: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 4: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 5: {
                alignment = this.getLayoutDirection() == 1 ? Layout.Alignment.ALIGN_RIGHT : Layout.Alignment.ALIGN_LEFT;
                break;
            }
            case 6: {
                alignment = this.getLayoutDirection() == 1 ? Layout.Alignment.ALIGN_LEFT : Layout.Alignment.ALIGN_RIGHT;
                break;
            }
            default: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        return alignment;
    }

    private final void $$robo$$android_widget_TextView$makeNewLayout(int wantWidth, int hintWidth, BoringLayout.Metrics boring, BoringLayout.Metrics hintBoring, int ellipsisWidth, boolean bringIntoView) {
        this.stopMarquee();
        this.mOldMaximum = this.mMaximum;
        this.mOldMaxMode = this.mMaxMode;
        this.mHighlightPathBogus = true;
        if (wantWidth < 0) {
            wantWidth = 0;
        }
        if (hintWidth < 0) {
            hintWidth = 0;
        }
        Layout.Alignment alignment = this.getLayoutAlignment();
        boolean testDirChange = this.mSingleLine && this.mLayout != null && (alignment == Layout.Alignment.ALIGN_NORMAL || alignment == Layout.Alignment.ALIGN_OPPOSITE);
        int oldDir = 0;
        if (testDirChange) {
            oldDir = this.mLayout.getParagraphDirection(0);
        }
        boolean shouldEllipsize = this.mEllipsize != null && this.getKeyListener() == null;
        boolean switchEllipsize = this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 0;
        TextUtils.TruncateAt effectiveEllipsize = this.mEllipsize;
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode == 1) {
            effectiveEllipsize = TextUtils.TruncateAt.END_SMALL;
        }
        if (this.mTextDir == null) {
            this.mTextDir = this.getTextDirectionHeuristic();
        }
        this.mLayout = this.makeSingleLayout(wantWidth, boring, ellipsisWidth, alignment, shouldEllipsize, effectiveEllipsize, effectiveEllipsize == this.mEllipsize);
        if (switchEllipsize) {
            TextUtils.TruncateAt oppositeEllipsize = effectiveEllipsize == TextUtils.TruncateAt.MARQUEE ? TextUtils.TruncateAt.END : TextUtils.TruncateAt.MARQUEE;
            this.mSavedMarqueeModeLayout = this.makeSingleLayout(wantWidth, boring, ellipsisWidth, alignment, shouldEllipsize, oppositeEllipsize, effectiveEllipsize != this.mEllipsize);
        }
        shouldEllipsize = this.mEllipsize != null;
        this.mHintLayout = null;
        if (this.mHint != null) {
            if (shouldEllipsize) {
                hintWidth = wantWidth;
            }
            if (hintBoring == UNKNOWN_BORING && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mTextDir, this.mHintBoring)) != null) {
                this.mHintBoring = hintBoring;
            }
            if (hintBoring != null) {
                if (!(hintBoring.width > hintWidth || shouldEllipsize && hintBoring.width > ellipsisWidth)) {
                    this.mHintLayout = this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad);
                    this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
                } else if (shouldEllipsize && hintBoring.width <= hintWidth) {
                    this.mHintLayout = this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth);
                }
            }
            if (this.mHintLayout == null) {
                StaticLayout.Builder builder = StaticLayout.Builder.obtain(this.mHint, 0, this.mHint.length(), this.mTextPaint, hintWidth).setAlignment(alignment).setTextDirection(this.mTextDir).setLineSpacing(this.mSpacingAdd, this.mSpacingMult).setIncludePad(this.mIncludePad).setBreakStrategy(this.mBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency);
                if (shouldEllipsize) {
                    builder.setEllipsize(this.mEllipsize).setEllipsizedWidth(ellipsisWidth).setMaxLines(this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE);
                }
                this.mHintLayout = builder.build();
            }
        }
        if (bringIntoView || testDirChange && oldDir != this.mLayout.getParagraphDirection(0)) {
            this.registerForPreDraw();
        }
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && !this.compressText(ellipsisWidth)) {
            int height = this.mLayoutParams.height;
            if (height != -2 && height != -1) {
                this.startMarquee();
            } else {
                this.mRestartMarquee = true;
            }
        }
        if (this.mEditor != null) {
            this.mEditor.prepareCursorControllers();
        }
    }

    private final Layout $$robo$$android_widget_TextView$makeSingleLayout(int wantWidth, BoringLayout.Metrics boring, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, boolean useSaved) {
        Layout result = null;
        if (this.mText instanceof Spannable) {
            result = new DynamicLayout(this.mText, this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mTextDir, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mBreakStrategy, this.mHyphenationFrequency, this.getKeyListener() == null ? effectiveEllipsize : null, ellipsisWidth);
        } else {
            if (boring == UNKNOWN_BORING && (boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mTextDir, this.mBoring)) != null) {
                this.mBoring = boring;
            }
            if (boring != null) {
                if (boring.width <= wantWidth && (effectiveEllipsize == null || boring.width <= ellipsisWidth)) {
                    result = useSaved && this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad) : BoringLayout.make(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad);
                    if (useSaved) {
                        this.mSavedLayout = result;
                    }
                } else if (shouldEllipsize && boring.width <= wantWidth) {
                    result = useSaved && this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, effectiveEllipsize, ellipsisWidth) : BoringLayout.make(this.mTransformed, this.mTextPaint, wantWidth, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, effectiveEllipsize, ellipsisWidth);
                }
            }
        }
        if (result == null) {
            StaticLayout.Builder builder = StaticLayout.Builder.obtain(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, wantWidth).setAlignment(alignment).setTextDirection(this.mTextDir).setLineSpacing(this.mSpacingAdd, this.mSpacingMult).setIncludePad(this.mIncludePad).setBreakStrategy(this.mBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency);
            if (shouldEllipsize) {
                builder.setEllipsize(effectiveEllipsize).setEllipsizedWidth(ellipsisWidth).setMaxLines(this.mMaxMode == 1 ? this.mMaximum : Integer.MAX_VALUE);
            }
            result = builder.build();
        }
        return result;
    }

    private final boolean $$robo$$android_widget_TextView$compressText(float width) {
        float textWidth;
        float overflow;
        if (this.isHardwareAccelerated()) {
            return false;
        }
        if (width > 0.0f && this.mLayout != null && this.getLineCount() == 1 && !this.mUserSetTextScaleX && this.mTextPaint.getTextScaleX() == 1.0f && (overflow = ((textWidth = this.mLayout.getLineWidth(0)) + 1.0f - width) / width) > 0.0f && overflow <= 0.07f) {
            this.mTextPaint.setTextScaleX(1.0f - overflow - 0.005f);
            this.post(new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TextView this$0;

                private void $$robo$$android_widget_TextView_2$__constructor__(TextView this$0) {
                }

                private final void $$robo$$android_widget_TextView_2$run() {
                    this.this$0.requestLayout();
                }

                private void __constructor__(TextView textView) {
                    this.$$robo$$android_widget_TextView_2$__constructor__(textView);
                }
                {
                    this.this$0 = textView;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_2$__constructor__(android.widget.TextView ), 0, this, textView);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_TextView_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            return true;
        }
        return false;
    }

    private static final int $$robo$$android_widget_TextView$desired(Layout layout2) {
        int i;
        int n = layout2.getLineCount();
        CharSequence text = layout2.getText();
        float max = 0.0f;
        for (i = 0; i < n - 1; ++i) {
            if (text.charAt(layout2.getLineEnd(i) - 1) == '\n') continue;
            return -1;
        }
        for (i = 0; i < n; ++i) {
            max = Math.max(max, layout2.getLineWidth(i));
        }
        return (int)Math.ceil(max);
    }

    private final void $$robo$$android_widget_TextView$setIncludeFontPadding(boolean includepad) {
        if (this.mIncludePad != includepad) {
            this.mIncludePad = includepad;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final boolean $$robo$$android_widget_TextView$getIncludeFontPadding() {
        return this.mIncludePad;
    }

    private final void $$robo$$android_widget_TextView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int hintWidth;
        int want;
        int width;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        BoringLayout.Metrics boring = UNKNOWN_BORING;
        BoringLayout.Metrics hintBoring = UNKNOWN_BORING;
        if (this.mTextDir == null) {
            this.mTextDir = this.getTextDirectionHeuristic();
        }
        int des = -1;
        boolean fromexisting = false;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            if (this.mLayout != null && this.mEllipsize == null) {
                des = TextView.desired(this.mLayout);
            }
            if (des < 0) {
                boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mTextDir, this.mBoring);
                if (boring != null) {
                    this.mBoring = boring;
                }
            } else {
                fromexisting = true;
            }
            if (boring == null || boring == UNKNOWN_BORING) {
                if (des < 0) {
                    des = (int)Math.ceil(Layout.getDesiredWidth(this.mTransformed, this.mTextPaint));
                }
                width = des;
            } else {
                width = boring.width;
            }
            Drawables dr = this.mDrawables;
            if (dr != null) {
                width = Math.max(width, dr.mDrawableWidthTop);
                width = Math.max(width, dr.mDrawableWidthBottom);
            }
            if (this.mHint != null) {
                int hintWidth2;
                int hintDes = -1;
                if (this.mHintLayout != null && this.mEllipsize == null) {
                    hintDes = TextView.desired(this.mHintLayout);
                }
                if (hintDes < 0 && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mTextDir, this.mHintBoring)) != null) {
                    this.mHintBoring = hintBoring;
                }
                if (hintBoring == null || hintBoring == UNKNOWN_BORING) {
                    if (hintDes < 0) {
                        hintDes = (int)Math.ceil(Layout.getDesiredWidth(this.mHint, this.mTextPaint));
                    }
                    hintWidth2 = hintDes;
                } else {
                    hintWidth2 = hintBoring.width;
                }
                if (hintWidth2 > width) {
                    width = hintWidth2;
                }
            }
            width += this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
            width = this.mMaxWidthMode == 1 ? Math.min(width, this.mMaxWidth * this.getLineHeight()) : Math.min(width, this.mMaxWidth);
            width = this.mMinWidthMode == 1 ? Math.max(width, this.mMinWidth * this.getLineHeight()) : Math.max(width, this.mMinWidth);
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        int unpaddedWidth = want = width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (this.mHorizontallyScrolling) {
            want = 0x100000;
        }
        int hintWant = want;
        int n = hintWidth = this.mHintLayout == null ? hintWant : this.mHintLayout.getWidth();
        if (this.mLayout == null) {
            this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
        } else {
            boolean maximumChanged;
            boolean layoutChanged = this.mLayout.getWidth() != want || hintWidth != hintWant || this.mLayout.getEllipsizedWidth() != width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            boolean widthChanged = this.mHint == null && this.mEllipsize == null && want > this.mLayout.getWidth() && (this.mLayout instanceof BoringLayout || fromexisting && des >= 0 && des <= want);
            boolean bl = maximumChanged = this.mMaxMode != this.mOldMaxMode || this.mMaximum != this.mOldMaximum;
            if (layoutChanged || maximumChanged) {
                if (!maximumChanged && widthChanged) {
                    this.mLayout.increaseWidthTo(want);
                } else {
                    this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
                }
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
            this.mDesiredHeightAtMeasure = -1;
        } else {
            int desired;
            height = desired = this.getDesiredHeight();
            this.mDesiredHeightAtMeasure = desired;
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(desired, heightSize);
            }
        }
        int unpaddedHeight = height - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
        if (this.mMaxMode == 1 && this.mLayout.getLineCount() > this.mMaximum) {
            unpaddedHeight = Math.min(unpaddedHeight, this.mLayout.getLineTop(this.mMaximum));
        }
        if (this.mMovement != null || this.mLayout.getWidth() > unpaddedWidth || this.mLayout.getHeight() > unpaddedHeight) {
            this.registerForPreDraw();
        } else {
            this.scrollTo(0, 0);
        }
        this.setMeasuredDimension(width, height);
    }

    private final int $$robo$$android_widget_TextView$getDesiredHeight() {
        return Math.max(this.getDesiredHeight(this.mLayout, true), this.getDesiredHeight(this.mHintLayout, this.mEllipsize != null));
    }

    private final int $$robo$$android_widget_TextView$getDesiredHeight(Layout layout2, boolean cap) {
        if (layout2 == null) {
            return 0;
        }
        int linecount = layout2.getLineCount();
        int pad = this.getCompoundPaddingTop() + this.getCompoundPaddingBottom();
        int desired = layout2.getLineTop(linecount);
        Drawables dr = this.mDrawables;
        if (dr != null) {
            desired = Math.max(desired, dr.mDrawableHeightLeft);
            desired = Math.max(desired, dr.mDrawableHeightRight);
        }
        desired += pad;
        if (this.mMaxMode == 1) {
            if (cap && linecount > this.mMaximum) {
                desired = layout2.getLineTop(this.mMaximum);
                if (dr != null) {
                    desired = Math.max(desired, dr.mDrawableHeightLeft);
                    desired = Math.max(desired, dr.mDrawableHeightRight);
                }
                desired += pad;
                linecount = this.mMaximum;
            }
        } else {
            desired = Math.min(desired, this.mMaximum);
        }
        if (this.mMinMode == 1) {
            if (linecount < this.mMinimum) {
                desired += this.getLineHeight() * (this.mMinimum - linecount);
            }
        } else {
            desired = Math.max(desired, this.mMinimum);
        }
        desired = Math.max(desired, this.getSuggestedMinimumHeight());
        return desired;
    }

    private final void $$robo$$android_widget_TextView$checkForResize() {
        boolean sizeChanged = false;
        if (this.mLayout != null) {
            int desiredHeight;
            if (this.mLayoutParams.width == -2) {
                sizeChanged = true;
                this.invalidate();
            }
            if (this.mLayoutParams.height == -2) {
                int desiredHeight2 = this.getDesiredHeight();
                if (desiredHeight2 != this.getHeight()) {
                    sizeChanged = true;
                }
            } else if (this.mLayoutParams.height == -1 && this.mDesiredHeightAtMeasure >= 0 && (desiredHeight = this.getDesiredHeight()) != this.mDesiredHeightAtMeasure) {
                sizeChanged = true;
            }
        }
        if (sizeChanged) {
            this.requestLayout();
        }
    }

    private final void $$robo$$android_widget_TextView$checkForRelayout() {
        if ((this.mLayoutParams.width != -2 || this.mMaxWidthMode == this.mMinWidthMode && this.mMaxWidth == this.mMinWidth) && (this.mHint == null || this.mHintLayout != null) && this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight() > 0) {
            int oldht = this.mLayout.getHeight();
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
            if (this.mEllipsize != TextUtils.TruncateAt.MARQUEE) {
                if (this.mLayoutParams.height != -2 && this.mLayoutParams.height != -1) {
                    this.invalidate();
                    return;
                }
                if (this.mLayout.getHeight() == oldht && (this.mHintLayout == null || this.mHintLayout.getHeight() == oldht)) {
                    this.invalidate();
                    return;
                }
            }
            this.requestLayout();
            this.invalidate();
        } else {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_TextView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mDeferScroll >= 0) {
            int curs = this.mDeferScroll;
            this.mDeferScroll = -1;
            this.bringPointIntoView(Math.min(curs, this.mText.length()));
        }
    }

    private final boolean $$robo$$android_widget_TextView$isShowingHint() {
        return TextUtils.isEmpty(this.mText) && !TextUtils.isEmpty(this.mHint);
    }

    private final boolean $$robo$$android_widget_TextView$bringTextIntoView() {
        int scrollx;
        Layout layout2 = this.isShowingHint() ? this.mHintLayout : this.mLayout;
        int line = 0;
        if ((this.mGravity & 0x70) == 80) {
            line = layout2.getLineCount() - 1;
        }
        Layout.Alignment a = layout2.getParagraphAlignment(line);
        int dir = layout2.getParagraphDirection(line);
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        int ht = layout2.getHeight();
        if (a == Layout.Alignment.ALIGN_NORMAL) {
            a = dir == 1 ? Layout.Alignment.ALIGN_LEFT : Layout.Alignment.ALIGN_RIGHT;
        } else if (a == Layout.Alignment.ALIGN_OPPOSITE) {
            Layout.Alignment alignment = a = dir == 1 ? Layout.Alignment.ALIGN_RIGHT : Layout.Alignment.ALIGN_LEFT;
        }
        if (a == Layout.Alignment.ALIGN_CENTER) {
            int left = (int)Math.floor(layout2.getLineLeft(line));
            int right = (int)Math.ceil(layout2.getLineRight(line));
            scrollx = right - left < hspace ? (right + left) / 2 - hspace / 2 : (dir < 0 ? right - hspace : left);
        } else if (a == Layout.Alignment.ALIGN_RIGHT) {
            int right = (int)Math.ceil(layout2.getLineRight(line));
            scrollx = right - hspace;
        } else {
            scrollx = (int)Math.floor(layout2.getLineLeft(line));
        }
        int scrolly = ht < vspace ? 0 : ((this.mGravity & 0x70) == 80 ? ht - vspace : 0);
        if (scrollx != this.mScrollX || scrolly != this.mScrollY) {
            this.scrollTo(scrollx, scrolly);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_TextView$bringPointIntoView(int offset) {
        int hslack;
        int vslack;
        int grav;
        Layout layout2;
        if (this.isLayoutRequested()) {
            this.mDeferScroll = offset;
            return false;
        }
        boolean changed = false;
        Layout layout3 = layout2 = this.isShowingHint() ? this.mHintLayout : this.mLayout;
        if (layout2 == null) {
            return changed;
        }
        int line = layout2.getLineForOffset(offset);
        switch (4.$SwitchMap$android$text$Layout$Alignment[layout2.getParagraphAlignment(line).ordinal()]) {
            case 1: {
                grav = 1;
                break;
            }
            case 2: {
                grav = -1;
                break;
            }
            case 3: {
                grav = layout2.getParagraphDirection(line);
                break;
            }
            case 4: {
                grav = -layout2.getParagraphDirection(line);
                break;
            }
            default: {
                grav = 0;
            }
        }
        boolean clamped = grav > 0;
        int x = (int)layout2.getPrimaryHorizontal(offset, clamped);
        int top = layout2.getLineTop(line);
        int bottom = layout2.getLineTop(line + 1);
        int left = (int)Math.floor(layout2.getLineLeft(line));
        int right = (int)Math.ceil(layout2.getLineRight(line));
        int ht = layout2.getHeight();
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        if (!this.mHorizontallyScrolling && right - left > hspace && right > x) {
            right = Math.max(x, left + hspace);
        }
        if ((vslack = (hslack = (bottom - top) / 2)) > vspace / 4) {
            vslack = vspace / 4;
        }
        if (hslack > hspace / 4) {
            hslack = hspace / 4;
        }
        int hs = this.mScrollX;
        int vs = this.mScrollY;
        if (top - vs < vslack) {
            vs = top - vslack;
        }
        if (bottom - vs > vspace - vslack) {
            vs = bottom - (vspace - vslack);
        }
        if (ht - vs < vspace) {
            vs = ht - vspace;
        }
        if (0 - vs > 0) {
            vs = 0;
        }
        if (grav != 0) {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (grav < 0) {
            if (left - hs > 0) {
                hs = left;
            }
            if (right - hs < hspace) {
                hs = right - hspace;
            }
        } else if (grav > 0) {
            if (right - hs < hspace) {
                hs = right - hspace;
            }
            if (left - hs > 0) {
                hs = left;
            }
        } else if (right - left <= hspace) {
            hs = left - (hspace - (right - left)) / 2;
        } else if (x > right - hslack) {
            hs = right - hspace;
        } else if (x < left + hslack) {
            hs = left;
        } else if (left > hs) {
            hs = left;
        } else if (right < hs + hspace) {
            hs = right - hspace;
        } else {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (hs != this.mScrollX || vs != this.mScrollY) {
            if (this.mScroller == null) {
                this.scrollTo(hs, vs);
            } else {
                long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
                int dx = hs - this.mScrollX;
                int dy = vs - this.mScrollY;
                if (duration > 250L) {
                    this.mScroller.startScroll(this.mScrollX, this.mScrollY, dx, dy);
                    this.awakenScrollBars(this.mScroller.getDuration());
                    this.invalidate();
                } else {
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    this.scrollBy(dx, dy);
                }
                this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
            }
            changed = true;
        }
        if (this.isFocused()) {
            if (this.mTempRect == null) {
                this.mTempRect = new Rect();
            }
            this.mTempRect.set(x - 2, top, x + 2, bottom);
            this.getInterestingRect(this.mTempRect, line);
            this.mTempRect.offset(this.mScrollX, this.mScrollY);
            if (this.requestRectangleOnScreen(this.mTempRect)) {
                changed = true;
            }
        }
        return changed;
    }

    private final boolean $$robo$$android_widget_TextView$moveCursorToVisibleOffset() {
        int vs;
        int vspace;
        int end;
        if (!(this.mText instanceof Spannable)) {
            return false;
        }
        int start = this.getSelectionStart();
        if (start != (end = this.getSelectionEnd())) {
            return false;
        }
        int line = this.mLayout.getLineForOffset(start);
        int top = this.mLayout.getLineTop(line);
        int bottom = this.mLayout.getLineTop(line + 1);
        int vslack = (bottom - top) / 2;
        if (vslack > (vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom()) / 4) {
            vslack = vspace / 4;
        }
        if (top < (vs = this.mScrollY) + vslack) {
            line = this.mLayout.getLineForVertical(vs + vslack + (bottom - top));
        } else if (bottom > vspace + vs - vslack) {
            line = this.mLayout.getLineForVertical(vspace + vs - vslack - (bottom - top));
        }
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int hs = this.mScrollX;
        int leftChar = this.mLayout.getOffsetForHorizontal(line, hs);
        int rightChar = this.mLayout.getOffsetForHorizontal(line, hspace + hs);
        int lowChar = leftChar < rightChar ? leftChar : rightChar;
        int highChar = leftChar > rightChar ? leftChar : rightChar;
        int newStart = start;
        if (newStart < lowChar) {
            newStart = lowChar;
        } else if (newStart > highChar) {
            newStart = highChar;
        }
        if (newStart != start) {
            Selection.setSelection((Spannable)this.mText, newStart);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_TextView$computeScroll() {
        if (this.mScroller != null && this.mScroller.computeScrollOffset()) {
            this.mScrollX = this.mScroller.getCurrX();
            this.mScrollY = this.mScroller.getCurrY();
            this.invalidateParentCaches();
            this.postInvalidate();
        }
    }

    private final void $$robo$$android_widget_TextView$getInterestingRect(Rect r, int line) {
        this.convertFromViewportToContentCoordinates(r);
        if (line == 0) {
            r.top -= this.getExtendedPaddingTop();
        }
        if (line == this.mLayout.getLineCount() - 1) {
            r.bottom += this.getExtendedPaddingBottom();
        }
    }

    private final void $$robo$$android_widget_TextView$convertFromViewportToContentCoordinates(Rect r) {
        int horizontalOffset = this.viewportToContentHorizontalOffset();
        r.left += horizontalOffset;
        r.right += horizontalOffset;
        int verticalOffset = this.viewportToContentVerticalOffset();
        r.top += verticalOffset;
        r.bottom += verticalOffset;
    }

    private final int $$robo$$android_widget_TextView$viewportToContentHorizontalOffset() {
        return this.getCompoundPaddingLeft() - this.mScrollX;
    }

    private final int $$robo$$android_widget_TextView$viewportToContentVerticalOffset() {
        int offset = this.getExtendedPaddingTop() - this.mScrollY;
        if ((this.mGravity & 0x70) != 48) {
            offset += this.getVerticalOffset(false);
        }
        return offset;
    }

    private final void $$robo$$android_widget_TextView$debug(int depth) {
        super.debug(depth);
        String output = TextView.debugIndent(depth);
        output = output + "frame={" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "} scroll={" + this.mScrollX + ", " + this.mScrollY + "} ";
        if (this.mText != null) {
            output = output + "mText=\"" + this.mText + "\" ";
            if (this.mLayout != null) {
                output = output + "mLayout width=" + this.mLayout.getWidth() + " height=" + this.mLayout.getHeight();
            }
        } else {
            output = output + "mText=NULL";
        }
        Log.d("View", output);
    }

    @ViewDebug.ExportedProperty(category="text")
    private final int $$robo$$android_widget_TextView$getSelectionStart() {
        return Selection.getSelectionStart(this.getText());
    }

    @ViewDebug.ExportedProperty(category="text")
    private final int $$robo$$android_widget_TextView$getSelectionEnd() {
        return Selection.getSelectionEnd(this.getText());
    }

    private final boolean $$robo$$android_widget_TextView$hasSelection() {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        return selectionStart >= 0 && selectionStart != selectionEnd;
    }

    private final String $$robo$$android_widget_TextView$getSelectedText() {
        int end;
        if (!this.hasSelection()) {
            return null;
        }
        int start = this.getSelectionStart();
        return String.valueOf(start > (end = this.getSelectionEnd()) ? this.mText.subSequence(end, start) : this.mText.subSequence(start, end));
    }

    private final void $$robo$$android_widget_TextView$setSingleLine() {
        this.setSingleLine(true);
    }

    private final void $$robo$$android_widget_TextView$setAllCaps(boolean allCaps) {
        if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        } else {
            this.setTransformationMethod(null);
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setSingleLine(boolean singleLine) {
        this.setInputTypeSingleLine(singleLine);
        this.applySingleLine(singleLine, true, true);
    }

    private final void $$robo$$android_widget_TextView$setInputTypeSingleLine(boolean singleLine) {
        if (this.mEditor != null && (this.mEditor.mInputType & 0xF) == 1) {
            this.mEditor.mInputType = singleLine ? (this.mEditor.mInputType &= 0xFFFDFFFF) : (this.mEditor.mInputType |= 0x20000);
        }
    }

    private final void $$robo$$android_widget_TextView$applySingleLine(boolean singleLine, boolean applyTransformation, boolean changeMaxLines) {
        this.mSingleLine = singleLine;
        if (singleLine) {
            this.setLines(1);
            this.setHorizontallyScrolling(true);
            if (applyTransformation) {
                this.setTransformationMethod(SingleLineTransformationMethod.getInstance());
            }
        } else {
            if (changeMaxLines) {
                this.setMaxLines(Integer.MAX_VALUE);
            }
            this.setHorizontallyScrolling(false);
            if (applyTransformation) {
                this.setTransformationMethod(null);
            }
        }
    }

    private final void $$robo$$android_widget_TextView$setEllipsize(TextUtils.TruncateAt where) {
        if (this.mEllipsize != where) {
            this.mEllipsize = where;
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    private final void $$robo$$android_widget_TextView$setMarqueeRepeatLimit(int marqueeLimit) {
        this.mMarqueeRepeatLimit = marqueeLimit;
    }

    private final int $$robo$$android_widget_TextView$getMarqueeRepeatLimit() {
        return this.mMarqueeRepeatLimit;
    }

    @ViewDebug.ExportedProperty
    private final TextUtils.TruncateAt $$robo$$android_widget_TextView$getEllipsize() {
        return this.mEllipsize;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.createEditorIfNeeded();
        this.mEditor.mSelectAllOnFocus = selectAllOnFocus;
        if (selectAllOnFocus && !(this.mText instanceof Spannable)) {
            this.setText(this.mText, BufferType.SPANNABLE);
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_TextView$setCursorVisible(boolean visible) {
        if (visible && this.mEditor == null) {
            return;
        }
        this.createEditorIfNeeded();
        if (this.mEditor.mCursorVisible != visible) {
            this.mEditor.mCursorVisible = visible;
            this.invalidate();
            this.mEditor.makeBlink();
            this.mEditor.prepareCursorControllers();
        }
    }

    private final boolean $$robo$$android_widget_TextView$isCursorVisible() {
        return this.mEditor == null ? true : this.mEditor.mCursorVisible;
    }

    private final boolean $$robo$$android_widget_TextView$canMarquee() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        return width > 0 && (this.mLayout.getLineWidth(0) > (float)width || this.mMarqueeFadeMode != 0 && this.mSavedMarqueeModeLayout != null && this.mSavedMarqueeModeLayout.getLineWidth(0) > (float)width);
    }

    private final void $$robo$$android_widget_TextView$startMarquee() {
        if (this.getKeyListener() != null) {
            return;
        }
        if (this.compressText(this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight())) {
            return;
        }
        if ((this.mMarquee == null || this.mMarquee.isStopped()) && (this.isFocused() || this.isSelected()) && this.getLineCount() == 1 && this.canMarquee()) {
            if (this.mMarqueeFadeMode == 1) {
                this.mMarqueeFadeMode = 2;
                Layout tmp = this.mLayout;
                this.mLayout = this.mSavedMarqueeModeLayout;
                this.mSavedMarqueeModeLayout = tmp;
                this.setHorizontalFadingEdgeEnabled(true);
                this.requestLayout();
                this.invalidate();
            }
            if (this.mMarquee == null) {
                this.mMarquee = new Marquee(this);
            }
            this.mMarquee.start(this.mMarqueeRepeatLimit);
        }
    }

    private final void $$robo$$android_widget_TextView$stopMarquee() {
        if (this.mMarquee != null && !this.mMarquee.isStopped()) {
            this.mMarquee.stop();
        }
        if (this.mMarqueeFadeMode == 2) {
            this.mMarqueeFadeMode = 1;
            Layout tmp = this.mSavedMarqueeModeLayout;
            this.mSavedMarqueeModeLayout = this.mLayout;
            this.mLayout = tmp;
            this.setHorizontalFadingEdgeEnabled(false);
            this.requestLayout();
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_TextView$startStopMarquee(boolean start) {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (start) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    private final void $$robo$$android_widget_TextView$onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
    }

    private final void $$robo$$android_widget_TextView$onSelectionChanged(int selStart, int selEnd) {
        this.sendAccessibilityEvent(8192);
    }

    private final void $$robo$$android_widget_TextView$addTextChangedListener(TextWatcher watcher) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(watcher);
    }

    private final void $$robo$$android_widget_TextView$removeTextChangedListener(TextWatcher watcher) {
        int i;
        if (this.mListeners != null && (i = this.mListeners.indexOf(watcher)) >= 0) {
            this.mListeners.remove(i);
        }
    }

    private final void $$robo$$android_widget_TextView$sendBeforeTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).beforeTextChanged(text, start, before, after);
            }
        }
        this.removeIntersectingNonAdjacentSpans(start, start + before, SpellCheckSpan.class);
        this.removeIntersectingNonAdjacentSpans(start, start + before, SuggestionSpan.class);
    }

    private final <T> void $$robo$$android_widget_TextView$removeIntersectingNonAdjacentSpans(int start, int end, Class<T> type) {
        if (!(this.mText instanceof Editable)) {
            return;
        }
        Editable text = (Editable)this.mText;
        Object[] spans = text.getSpans(start, end, type);
        int length = spans.length;
        for (int i = 0; i < length; ++i) {
            int spanStart = text.getSpanStart(spans[i]);
            int spanEnd = text.getSpanEnd(spans[i]);
            if (spanEnd == start || spanStart == end) break;
            text.removeSpan(spans[i]);
        }
    }

    private final void $$robo$$android_widget_TextView$removeAdjacentSuggestionSpans(int pos) {
        if (!(this.mText instanceof Editable)) {
            return;
        }
        Editable text = (Editable)this.mText;
        SuggestionSpan[] spans = (SuggestionSpan[])text.getSpans(pos, pos, SuggestionSpan.class);
        int length = spans.length;
        for (int i = 0; i < length; ++i) {
            int spanStart = text.getSpanStart(spans[i]);
            int spanEnd = text.getSpanEnd(spans[i]);
            if (spanEnd != pos && spanStart != pos || !SpellChecker.haveWordBoundariesChanged(text, pos, pos, spanStart, spanEnd)) continue;
            text.removeSpan(spans[i]);
        }
    }

    private final void $$robo$$android_widget_TextView$sendOnTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).onTextChanged(text, start, before, after);
            }
        }
        if (this.mEditor != null) {
            this.mEditor.sendOnTextChanged(start, after);
        }
    }

    private final void $$robo$$android_widget_TextView$sendAfterTextChanged(Editable text) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).afterTextChanged(text);
            }
        }
        this.hideErrorIfUnchanged();
    }

    private final void $$robo$$android_widget_TextView$updateAfterEdit() {
        this.invalidate();
        int curs = this.getSelectionStart();
        if (curs >= 0 || (this.mGravity & 0x70) == 80) {
            this.registerForPreDraw();
        }
        this.checkForResize();
        if (curs >= 0) {
            this.mHighlightPathBogus = true;
            if (this.mEditor != null) {
                this.mEditor.makeBlink();
            }
            this.bringPointIntoView(curs);
        }
    }

    private final void $$robo$$android_widget_TextView$handleTextChanged(CharSequence buffer, int start, int before, int after) {
        Editor.InputMethodState ims;
        sLastCutCopyOrTextChangedTime = 0L;
        Editor.InputMethodState inputMethodState = ims = this.mEditor == null ? null : this.mEditor.mInputMethodState;
        if (ims == null || ims.mBatchEditNesting == 0) {
            this.updateAfterEdit();
        }
        if (ims != null) {
            ims.mContentChanged = true;
            if (ims.mChangedStart < 0) {
                ims.mChangedStart = start;
                ims.mChangedEnd = start + before;
            } else {
                ims.mChangedStart = Math.min(ims.mChangedStart, start);
                ims.mChangedEnd = Math.max(ims.mChangedEnd, start + before - ims.mChangedDelta);
            }
            ims.mChangedDelta += after - before;
        }
        this.resetErrorChangedFlag();
        this.sendOnTextChanged(buffer, start, before, after);
        this.onTextChanged(buffer, start, before, after);
    }

    private final void $$robo$$android_widget_TextView$spanChange(Spanned buf, Object what, int oldStart, int newStart, int oldEnd, int newEnd) {
        Editor.InputMethodState ims;
        boolean selChanged = false;
        int newSelStart = -1;
        int newSelEnd = -1;
        Editor.InputMethodState inputMethodState = ims = this.mEditor == null ? null : this.mEditor.mInputMethodState;
        if (what == Selection.SELECTION_END) {
            selChanged = true;
            newSelEnd = newStart;
            if (oldStart >= 0 || newStart >= 0) {
                this.invalidateCursor(Selection.getSelectionStart(buf), oldStart, newStart);
                this.checkForResize();
                this.registerForPreDraw();
                if (this.mEditor != null) {
                    this.mEditor.makeBlink();
                }
            }
        }
        if (what == Selection.SELECTION_START) {
            selChanged = true;
            newSelStart = newStart;
            if (oldStart >= 0 || newStart >= 0) {
                int end = Selection.getSelectionEnd(buf);
                this.invalidateCursor(end, oldStart, newStart);
            }
        }
        if (selChanged) {
            this.mHighlightPathBogus = true;
            if (this.mEditor != null && !this.isFocused()) {
                this.mEditor.mSelectionMoved = true;
            }
            if ((buf.getSpanFlags(what) & 0x200) == 0) {
                if (newSelStart < 0) {
                    newSelStart = Selection.getSelectionStart(buf);
                }
                if (newSelEnd < 0) {
                    newSelEnd = Selection.getSelectionEnd(buf);
                }
                if (this.mEditor != null) {
                    this.mEditor.refreshTextActionMode();
                    if (!this.hasSelection() && this.mEditor.mTextActionMode == null && this.hasTransientState()) {
                        this.setHasTransientState(false);
                    }
                }
                this.onSelectionChanged(newSelStart, newSelEnd);
            }
        }
        if (what instanceof UpdateAppearance || what instanceof ParagraphStyle || what instanceof CharacterStyle) {
            if (ims == null || ims.mBatchEditNesting == 0) {
                this.invalidate();
                this.mHighlightPathBogus = true;
                this.checkForResize();
            } else {
                ims.mContentChanged = true;
            }
            if (this.mEditor != null) {
                if (oldStart >= 0) {
                    this.mEditor.invalidateTextDisplayList(this.mLayout, oldStart, oldEnd);
                }
                if (newStart >= 0) {
                    this.mEditor.invalidateTextDisplayList(this.mLayout, newStart, newEnd);
                }
                this.mEditor.invalidateHandlesAndActionMode();
            }
        }
        if (MetaKeyKeyListener.isMetaTracker(buf, what)) {
            this.mHighlightPathBogus = true;
            if (ims != null && MetaKeyKeyListener.isSelectingMetaTracker(buf, what)) {
                ims.mSelectionModeChanged = true;
            }
            if (Selection.getSelectionStart(buf) >= 0) {
                if (ims == null || ims.mBatchEditNesting == 0) {
                    this.invalidateCursor();
                } else {
                    ims.mCursorChanged = true;
                }
            }
        }
        if (what instanceof ParcelableSpan && ims != null && ims.mExtractedTextRequest != null) {
            if (ims.mBatchEditNesting != 0) {
                if (oldStart >= 0) {
                    if (ims.mChangedStart > oldStart) {
                        ims.mChangedStart = oldStart;
                    }
                    if (ims.mChangedStart > oldEnd) {
                        ims.mChangedStart = oldEnd;
                    }
                }
                if (newStart >= 0) {
                    if (ims.mChangedStart > newStart) {
                        ims.mChangedStart = newStart;
                    }
                    if (ims.mChangedStart > newEnd) {
                        ims.mChangedStart = newEnd;
                    }
                }
            } else {
                ims.mContentChanged = true;
            }
        }
        if (this.mEditor != null && this.mEditor.mSpellChecker != null && newStart < 0 && what instanceof SpellCheckSpan) {
            this.mEditor.mSpellChecker.onSpellCheckSpanRemoved((SpellCheckSpan)what);
        }
    }

    private final void $$robo$$android_widget_TextView$onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (this.isTemporarilyDetached()) {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
            return;
        }
        if (this.mEditor != null) {
            this.mEditor.onFocusChanged(focused, direction);
        }
        if (focused && this.mText instanceof Spannable) {
            Spannable sp = (Spannable)this.mText;
            MetaKeyKeyListener.resetMetaState(sp);
        }
        this.startStopMarquee(focused);
        if (this.mTransformation != null) {
            this.mTransformation.onFocusChanged(this, this.mText, focused, direction, previouslyFocusedRect);
        }
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    private final void $$robo$$android_widget_TextView$onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mEditor != null) {
            this.mEditor.onWindowFocusChanged(hasWindowFocus);
        }
        this.startStopMarquee(hasWindowFocus);
    }

    private final void $$robo$$android_widget_TextView$onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mEditor != null && visibility != 0) {
            this.mEditor.hideCursorAndSpanControllers();
            this.stopTextActionMode();
        }
    }

    private final void $$robo$$android_widget_TextView$clearComposingText() {
        if (this.mText instanceof Spannable) {
            BaseInputConnection.removeComposingSpans((Spannable)this.mText);
        }
    }

    private final void $$robo$$android_widget_TextView$setSelected(boolean selected) {
        boolean wasSelected = this.isSelected();
        super.setSelected(selected);
        if (selected != wasSelected && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (selected) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    private final boolean $$robo$$android_widget_TextView$onTouchEvent(MotionEvent event) {
        boolean touchIsFinished;
        int action = event.getActionMasked();
        if (this.mEditor != null) {
            this.mEditor.onTouchEvent(event);
            if (this.mEditor.mSelectionModifierCursorController != null && this.mEditor.mSelectionModifierCursorController.isDragAcceleratorActive()) {
                return true;
            }
        }
        boolean superResult = super.onTouchEvent(event);
        if (this.mEditor != null && this.mEditor.mDiscardNextActionUp && action == 1) {
            this.mEditor.mDiscardNextActionUp = false;
            if (this.mEditor.mIsInsertionActionModeStartPending) {
                this.mEditor.startInsertionActionMode();
                this.mEditor.mIsInsertionActionModeStartPending = false;
            }
            return superResult;
        }
        boolean bl = touchIsFinished = action == 1 && (this.mEditor == null || !this.mEditor.mIgnoreActionUpEvent) && this.isFocused();
        if ((this.mMovement != null || this.onCheckIsTextEditor()) && this.isEnabled() && this.mText instanceof Spannable && this.mLayout != null) {
            ClickableSpan[] links;
            boolean handled = false;
            if (this.mMovement != null) {
                handled |= this.mMovement.onTouchEvent(this, (Spannable)this.mText, event);
            }
            boolean textIsSelectable = this.isTextSelectable();
            if (touchIsFinished && this.mLinksClickable && this.mAutoLinkMask != 0 && textIsSelectable && (links = ((Spannable)this.mText).getSpans(this.getSelectionStart(), this.getSelectionEnd(), ClickableSpan.class)).length > 0) {
                links[0].onClick(this);
                handled = true;
            }
            if (touchIsFinished && (this.isTextEditable() || textIsSelectable)) {
                InputMethodManager imm = InputMethodManager.peekInstance();
                this.viewClicked(imm);
                if (!textIsSelectable && this.mEditor.mShowSoftInputOnFocus) {
                    handled |= imm != null && imm.showSoftInput(this, 0);
                }
                this.mEditor.onTouchUpEvent(event);
                handled = true;
            }
            if (handled) {
                return true;
            }
        }
        return superResult;
    }

    private final boolean $$robo$$android_widget_TextView$onGenericMotionEvent(MotionEvent event) {
        if (this.mMovement != null && this.mText instanceof Spannable && this.mLayout != null) {
            try {
                if (this.mMovement.onGenericMotionEvent(this, (Spannable)this.mText, event)) {
                    return true;
                }
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return super.onGenericMotionEvent(event);
    }

    private final void $$robo$$android_widget_TextView$onCreateContextMenu(ContextMenu menu2) {
        if (this.mEditor != null) {
            this.mEditor.onCreateContextMenu(menu2);
        }
    }

    private final boolean $$robo$$android_widget_TextView$showContextMenu() {
        if (this.mEditor != null) {
            this.mEditor.setContextMenuAnchor(Float.NaN, Float.NaN);
        }
        return super.showContextMenu();
    }

    private final boolean $$robo$$android_widget_TextView$showContextMenu(float x, float y) {
        if (this.mEditor != null) {
            this.mEditor.setContextMenuAnchor(x, y);
        }
        return super.showContextMenu(x, y);
    }

    private final boolean $$robo$$android_widget_TextView$isTextEditable() {
        return this.mText instanceof Editable && this.onCheckIsTextEditor() && this.isEnabled();
    }

    private final boolean $$robo$$android_widget_TextView$didTouchFocusSelect() {
        return this.mEditor != null && this.mEditor.mTouchFocusSelected;
    }

    private final void $$robo$$android_widget_TextView$cancelLongPress() {
        super.cancelLongPress();
        if (this.mEditor != null) {
            this.mEditor.mIgnoreActionUpEvent = true;
        }
    }

    private final boolean $$robo$$android_widget_TextView$onTrackballEvent(MotionEvent event) {
        if (this.mMovement != null && this.mText instanceof Spannable && this.mLayout != null && this.mMovement.onTrackballEvent(this, (Spannable)this.mText, event)) {
            return true;
        }
        return super.onTrackballEvent(event);
    }

    private final void $$robo$$android_widget_TextView$setScroller(Scroller s) {
        this.mScroller = s;
    }

    private final float $$robo$$android_widget_TextView$getLeftFadingEdgeStrength() {
        if (this.isMarqueeFadeEnabled() && this.mMarquee != null && !this.mMarquee.isStopped()) {
            Marquee marquee = this.mMarquee;
            if (marquee.shouldDrawLeftFade()) {
                return this.getHorizontalFadingEdgeStrength(marquee.getScroll(), 0.0f);
            }
            return 0.0f;
        }
        if (this.getLineCount() == 1) {
            float lineLeft = this.getLayout().getLineLeft(0);
            if (lineLeft > (float)this.mScrollX) {
                return 0.0f;
            }
            return this.getHorizontalFadingEdgeStrength(this.mScrollX, lineLeft);
        }
        return super.getLeftFadingEdgeStrength();
    }

    private final float $$robo$$android_widget_TextView$getRightFadingEdgeStrength() {
        if (this.isMarqueeFadeEnabled() && this.mMarquee != null && !this.mMarquee.isStopped()) {
            Marquee marquee = this.mMarquee;
            return this.getHorizontalFadingEdgeStrength(marquee.getMaxFadeScroll(), marquee.getScroll());
        }
        if (this.getLineCount() == 1) {
            float rightEdge = this.mScrollX + (this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight());
            float lineRight = this.getLayout().getLineRight(0);
            if (lineRight < rightEdge) {
                return 0.0f;
            }
            return this.getHorizontalFadingEdgeStrength(rightEdge, lineRight);
        }
        return super.getRightFadingEdgeStrength();
    }

    private final float $$robo$$android_widget_TextView$getHorizontalFadingEdgeStrength(float position1, float position2) {
        int horizontalFadingEdgeLength = this.getHorizontalFadingEdgeLength();
        if (horizontalFadingEdgeLength == 0) {
            return 0.0f;
        }
        float diff = Math.abs(position1 - position2);
        if (diff > (float)horizontalFadingEdgeLength) {
            return 1.0f;
        }
        return diff / (float)horizontalFadingEdgeLength;
    }

    private final boolean $$robo$$android_widget_TextView$isMarqueeFadeEnabled() {
        return this.mEllipsize == TextUtils.TruncateAt.MARQUEE && this.mMarqueeFadeMode != 1;
    }

    private final int $$robo$$android_widget_TextView$computeHorizontalScrollRange() {
        if (this.mLayout != null) {
            return this.mSingleLine && (this.mGravity & 7) == 3 ? (int)this.mLayout.getLineWidth(0) : this.mLayout.getWidth();
        }
        return super.computeHorizontalScrollRange();
    }

    private final int $$robo$$android_widget_TextView$computeVerticalScrollRange() {
        if (this.mLayout != null) {
            return this.mLayout.getHeight();
        }
        return super.computeVerticalScrollRange();
    }

    private final int $$robo$$android_widget_TextView$computeVerticalScrollExtent() {
        return this.getHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
    }

    private final void $$robo$$android_widget_TextView$findViewsWithText(ArrayList<View> outViews, CharSequence searched, int flags) {
        super.findViewsWithText(outViews, searched, flags);
        if (!(outViews.contains(this) || (flags & 1) == 0 || TextUtils.isEmpty(searched) || TextUtils.isEmpty(this.mText))) {
            String searchedLowerCase = searched.toString().toLowerCase();
            String textLowerCase = this.mText.toString().toLowerCase();
            if (textLowerCase.contains(searchedLowerCase)) {
                outViews.add(this);
            }
        }
    }

    private static final ColorStateList $$robo$$android_widget_TextView$getTextColors(Context context, TypedArray attrs) {
        int ap;
        if (attrs == null) {
            throw new NullPointerException();
        }
        TypedArray a = context.obtainStyledAttributes(R.styleable.TextView);
        ColorStateList colors = a.getColorStateList(5);
        if (colors == null && (ap = a.getResourceId(1, 0)) != 0) {
            TypedArray appearance = context.obtainStyledAttributes(ap, R.styleable.TextAppearance);
            colors = appearance.getColorStateList(3);
            appearance.recycle();
        }
        a.recycle();
        return colors;
    }

    private static final int $$robo$$android_widget_TextView$getTextColor(Context context, TypedArray attrs, int def) {
        ColorStateList colors = TextView.getTextColors(context, attrs);
        if (colors == null) {
            return def;
        }
        return colors.getDefaultColor();
    }

    private final boolean $$robo$$android_widget_TextView$onKeyShortcut(int keyCode, KeyEvent event) {
        if (event.hasModifiers(4096)) {
            switch (keyCode) {
                case 29: {
                    if (!this.canSelectText()) break;
                    return this.onTextContextMenuItem(16908319);
                }
                case 54: {
                    if (!this.canUndo()) break;
                    return this.onTextContextMenuItem(16908338);
                }
                case 52: {
                    if (!this.canCut()) break;
                    return this.onTextContextMenuItem(0x1020020);
                }
                case 31: {
                    if (!this.canCopy()) break;
                    return this.onTextContextMenuItem(0x1020021);
                }
                case 50: {
                    if (!this.canPaste()) break;
                    return this.onTextContextMenuItem(0x1020022);
                }
            }
        } else if (event.hasModifiers(4097)) {
            switch (keyCode) {
                case 54: {
                    if (!this.canRedo()) break;
                    return this.onTextContextMenuItem(16908339);
                }
                case 50: {
                    if (!this.canPaste()) break;
                    return this.onTextContextMenuItem(16908337);
                }
            }
        }
        return super.onKeyShortcut(keyCode, event);
    }

    private final boolean $$robo$$android_widget_TextView$canSelectText() {
        return this.mText.length() != 0 && this.mEditor != null && this.mEditor.hasSelectionController();
    }

    private final boolean $$robo$$android_widget_TextView$textCanBeSelected() {
        if (this.mMovement == null || !this.mMovement.canSelectArbitrarily()) {
            return false;
        }
        return this.isTextEditable() || this.isTextSelectable() && this.mText instanceof Spannable && this.isEnabled();
    }

    private final Locale $$robo$$android_widget_TextView$getTextServicesLocale(boolean allowNullLocale) {
        this.updateTextServicesLocaleAsync();
        return this.mCurrentSpellCheckerLocaleCache == null && !allowNullLocale ? Locale.getDefault() : this.mCurrentSpellCheckerLocaleCache;
    }

    private final Locale $$robo$$android_widget_TextView$getTextServicesLocale() {
        return this.getTextServicesLocale(false);
    }

    private final boolean $$robo$$android_widget_TextView$isInExtractedMode() {
        return false;
    }

    private final Locale $$robo$$android_widget_TextView$getSpellCheckerLocale() {
        return this.getTextServicesLocale(true);
    }

    private final void $$robo$$android_widget_TextView$updateTextServicesLocaleAsync() {
        AsyncTask.execute(new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextView this$0;

            private void $$robo$$android_widget_TextView_3$__constructor__(TextView this$0) {
            }

            private final void $$robo$$android_widget_TextView_3$run() {
                this.this$0.updateTextServicesLocaleLocked();
            }

            private void __constructor__(TextView textView) {
                this.$$robo$$android_widget_TextView_3$__constructor__(textView);
            }
            {
                this.this$0 = textView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_3$__constructor__(android.widget.TextView ), 0, this, textView);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_TextView_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_widget_TextView$updateTextServicesLocaleLocked() {
        TextServicesManager textServicesManager = (TextServicesManager)this.mContext.getSystemService("textservices");
        SpellCheckerSubtype subtype = textServicesManager.getCurrentSpellCheckerSubtype(true);
        Locale locale = subtype != null ? subtype.getLocaleObject() : null;
        this.mCurrentSpellCheckerLocaleCache = locale;
    }

    private final void $$robo$$android_widget_TextView$onLocaleChanged() {
        this.mEditor.onLocaleChanged();
    }

    private final WordIterator $$robo$$android_widget_TextView$getWordIterator() {
        if (this.mEditor != null) {
            return this.mEditor.getWordIterator();
        }
        return null;
    }

    private final void $$robo$$android_widget_TextView$onPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        super.onPopulateAccessibilityEventInternal(event);
        CharSequence text = this.getTextForAccessibility();
        if (!TextUtils.isEmpty(text)) {
            event.getText().add(text);
        }
    }

    private final boolean $$robo$$android_widget_TextView$shouldSpeakPasswordsForAccessibility() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "speak_password", 0, -3) == 1;
    }

    private final CharSequence $$robo$$android_widget_TextView$getAccessibilityClassName() {
        return TextView.class.getName();
    }

    private final void $$robo$$android_widget_TextView$onProvideStructure(ViewStructure structure) {
        boolean isPassword;
        super.onProvideStructure(structure);
        boolean bl = isPassword = this.hasPasswordTransformationMethod() || TextView.isPasswordInputType(this.getInputType());
        if (!isPassword) {
            int paintFlags;
            Layout layout2;
            int lineCount;
            if (this.mLayout == null) {
                this.assumeLayout();
            }
            if ((lineCount = (layout2 = this.mLayout).getLineCount()) <= 1) {
                structure.setText(this.getText(), this.getSelectionStart(), this.getSelectionEnd());
            } else {
                int selEnd;
                int expandedBottomLine;
                int bottomLine;
                int topLine;
                int[] tmpCords = new int[2];
                this.getLocationInWindow(tmpCords);
                int topWindowLocation = tmpCords[1];
                View root = this;
                ViewParent viewParent = this.getParent();
                while (viewParent instanceof View) {
                    root = (View)((Object)viewParent);
                    viewParent = root.getParent();
                }
                int windowHeight = root.getHeight();
                if (topWindowLocation >= 0) {
                    topLine = this.getLineAtCoordinateUnclamped(0.0f);
                    bottomLine = this.getLineAtCoordinateUnclamped(windowHeight - 1);
                } else {
                    topLine = this.getLineAtCoordinateUnclamped(-topWindowLocation);
                    bottomLine = this.getLineAtCoordinateUnclamped(windowHeight - 1 - topWindowLocation);
                }
                int expandedTopLine = topLine - (bottomLine - topLine) / 2;
                if (expandedTopLine < 0) {
                    expandedTopLine = 0;
                }
                if ((expandedBottomLine = bottomLine + (bottomLine - topLine) / 2) >= lineCount) {
                    expandedBottomLine = lineCount - 1;
                }
                int expandedTopChar = layout2.getLineStart(expandedTopLine);
                int expandedBottomChar = layout2.getLineEnd(expandedBottomLine);
                int selStart = this.getSelectionStart();
                if (selStart < (selEnd = this.getSelectionEnd())) {
                    if (selStart < expandedTopChar) {
                        expandedTopChar = selStart;
                    }
                    if (selEnd > expandedBottomChar) {
                        expandedBottomChar = selEnd;
                    }
                }
                CharSequence text = this.getText();
                if (expandedTopChar > 0 || expandedBottomChar < text.length()) {
                    text = text.subSequence(expandedTopChar, expandedBottomChar);
                }
                structure.setText(text, selStart - expandedTopChar, selEnd - expandedTopChar);
                int[] lineOffsets = new int[bottomLine - topLine + 1];
                int[] lineBaselines = new int[bottomLine - topLine + 1];
                int baselineOffset = this.getBaselineOffset();
                for (int i = topLine; i <= bottomLine; ++i) {
                    lineOffsets[i - topLine] = layout2.getLineStart(i);
                    lineBaselines[i - topLine] = layout2.getLineBaseline(i) + baselineOffset;
                }
                structure.setTextLines(lineOffsets, lineBaselines);
            }
            int style2 = 0;
            int typefaceStyle = this.getTypefaceStyle();
            if ((typefaceStyle & 1) != 0) {
                style2 |= 1;
            }
            if ((typefaceStyle & 2) != 0) {
                style2 |= 2;
            }
            if (((paintFlags = this.mTextPaint.getFlags()) & 0x20) != 0) {
                style2 |= 1;
            }
            if ((paintFlags & 8) != 0) {
                style2 |= 4;
            }
            if ((paintFlags & 0x10) != 0) {
                style2 |= 8;
            }
            structure.setTextStyle(this.getTextSize(), this.getCurrentTextColor(), 1, style2);
        }
        structure.setHint(this.getHint());
    }

    private final void $$robo$$android_widget_TextView$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        boolean isPassword = this.hasPasswordTransformationMethod();
        event.setPassword(isPassword);
        if (event.getEventType() == 8192) {
            event.setFromIndex(Selection.getSelectionStart(this.mText));
            event.setToIndex(Selection.getSelectionEnd(this.mText));
            event.setItemCount(this.mText.length());
        }
    }

    private final void $$robo$$android_widget_TextView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        boolean isPassword = this.hasPasswordTransformationMethod();
        info.setPassword(isPassword);
        info.setText(this.getTextForAccessibility());
        if (this.mBufferType == BufferType.EDITABLE) {
            info.setEditable(true);
            if (this.isEnabled()) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SET_TEXT);
            }
        }
        if (this.mEditor != null) {
            info.setInputType(this.mEditor.mInputType);
            if (this.mEditor.mError != null) {
                info.setContentInvalid(true);
                info.setError(this.mEditor.mError);
            }
        }
        if (!TextUtils.isEmpty(this.mText)) {
            info.addAction(256);
            info.addAction(512);
            info.setMovementGranularities(31);
            info.addAction(131072);
        }
        if (this.isFocused()) {
            if (this.canCopy()) {
                info.addAction(16384);
            }
            if (this.canPaste()) {
                info.addAction(32768);
            }
            if (this.canCut()) {
                info.addAction(65536);
            }
            if (this.canShare()) {
                info.addAction(new AccessibilityNodeInfo.AccessibilityAction(0x10000000, this.getResources().getString(17040515)));
            }
            if (this.canProcessText()) {
                this.mEditor.mProcessTextIntentActionsHandler.onInitializeAccessibilityNodeInfo(info);
            }
        }
        for (InputFilter filter : this.mFilters) {
            if (!(filter instanceof InputFilter.LengthFilter)) continue;
            info.setMaxTextLength(((InputFilter.LengthFilter)filter).getMax());
        }
        if (!this.isSingleLine()) {
            info.setMultiLine(true);
        }
    }

    private final boolean $$robo$$android_widget_TextView$performAccessibilityActionInternal(int action, Bundle arguments) {
        if (this.mEditor != null && this.mEditor.mProcessTextIntentActionsHandler.performAccessibilityAction(action)) {
            return true;
        }
        switch (action) {
            case 16: {
                return this.performAccessibilityActionClick(arguments);
            }
            case 16384: {
                return this.isFocused() && this.canCopy() && this.onTextContextMenuItem(0x1020021);
            }
            case 32768: {
                return this.isFocused() && this.canPaste() && this.onTextContextMenuItem(0x1020022);
            }
            case 65536: {
                return this.isFocused() && this.canCut() && this.onTextContextMenuItem(0x1020020);
            }
            case 131072: {
                int end;
                this.ensureIterableTextForAccessibilitySelectable();
                CharSequence text = this.getIterableTextForAccessibility();
                if (text == null) {
                    return false;
                }
                int start = arguments != null ? arguments.getInt("ACTION_ARGUMENT_SELECTION_START_INT", -1) : -1;
                int n = end = arguments != null ? arguments.getInt("ACTION_ARGUMENT_SELECTION_END_INT", -1) : -1;
                if (this.getSelectionStart() != start || this.getSelectionEnd() != end) {
                    if (start == end && end == -1) {
                        Selection.removeSelection((Spannable)text);
                        return true;
                    }
                    if (start >= 0 && start <= end && end <= text.length()) {
                        Selection.setSelection((Spannable)text, start, end);
                        if (this.mEditor != null) {
                            this.mEditor.startSelectionActionMode();
                        }
                        return true;
                    }
                }
                return false;
            }
            case 256: 
            case 512: {
                this.ensureIterableTextForAccessibilitySelectable();
                return super.performAccessibilityActionInternal(action, arguments);
            }
            case 0x10000000: {
                return this.isFocused() && this.canShare() && this.onTextContextMenuItem(16908341);
            }
            case 0x200000: {
                int updatedTextLength;
                if (!this.isEnabled() || this.mBufferType != BufferType.EDITABLE) {
                    return false;
                }
                CharSequence text = arguments != null ? arguments.getCharSequence("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE") : null;
                this.setText(text);
                if (this.mText != null && (updatedTextLength = this.mText.length()) > 0) {
                    Selection.setSelection((Spannable)this.mText, updatedTextLength);
                }
                return true;
            }
        }
        return super.performAccessibilityActionInternal(action, arguments);
    }

    private final boolean $$robo$$android_widget_TextView$performAccessibilityActionClick(Bundle arguments) {
        boolean handled = false;
        if (!this.isEnabled()) {
            return false;
        }
        if (this.isClickable() || this.isLongClickable()) {
            if (this.isFocusable() && !this.isFocused()) {
                this.requestFocus();
            }
            this.performClick();
            handled = true;
        }
        if ((this.mMovement != null || this.onCheckIsTextEditor()) && this.hasSpannableText() && this.mLayout != null && (this.isTextEditable() || this.isTextSelectable()) && this.isFocused()) {
            InputMethodManager imm = InputMethodManager.peekInstance();
            this.viewClicked(imm);
            if (!this.isTextSelectable() && this.mEditor.mShowSoftInputOnFocus && imm != null) {
                handled |= imm.showSoftInput(this, 0);
            }
        }
        return handled;
    }

    private final boolean $$robo$$android_widget_TextView$hasSpannableText() {
        return this.mText != null && this.mText instanceof Spannable;
    }

    private final void $$robo$$android_widget_TextView$sendAccessibilityEventInternal(int eventType) {
        if (eventType == 32768 && this.mEditor != null) {
            this.mEditor.mProcessTextIntentActionsHandler.initializeAccessibilityActions();
        }
        if (eventType == 4096) {
            return;
        }
        super.sendAccessibilityEventInternal(eventType);
    }

    private final CharSequence $$robo$$android_widget_TextView$getTextForAccessibility() {
        if (TextUtils.isEmpty(this.mText)) {
            return this.mHint;
        }
        if (this.hasPasswordTransformationMethod() && this.shouldSpeakPasswordsForAccessibility()) {
            return this.mText;
        }
        return this.mTransformed;
    }

    private final void $$robo$$android_widget_TextView$sendAccessibilityEventTypeViewTextChanged(CharSequence beforeText, int fromIndex, int removedCount, int addedCount) {
        AccessibilityEvent event = AccessibilityEvent.obtain(16);
        event.setFromIndex(fromIndex);
        event.setRemovedCount(removedCount);
        event.setAddedCount(addedCount);
        event.setBeforeText(beforeText);
        this.sendAccessibilityEventUnchecked(event);
    }

    private final boolean $$robo$$android_widget_TextView$isInputMethodTarget() {
        InputMethodManager imm = InputMethodManager.peekInstance();
        return imm != null && imm.isActive(this);
    }

    private final boolean $$robo$$android_widget_TextView$onTextContextMenuItem(int id2) {
        int min = 0;
        int max = this.mText.length();
        if (this.isFocused()) {
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            min = Math.max(0, Math.min(selStart, selEnd));
            max = Math.max(0, Math.max(selStart, selEnd));
        }
        switch (id2) {
            case 16908319: {
                this.selectAllText();
                return true;
            }
            case 16908338: {
                if (this.mEditor != null) {
                    this.mEditor.undo();
                }
                return true;
            }
            case 16908339: {
                if (this.mEditor != null) {
                    this.mEditor.redo();
                }
                return true;
            }
            case 0x1020022: {
                this.paste(min, max, true);
                return true;
            }
            case 16908337: {
                this.paste(min, max, false);
                return true;
            }
            case 0x1020020: {
                this.setPrimaryClip(ClipData.newPlainText(null, this.getTransformedText(min, max)));
                this.deleteText_internal(min, max);
                return true;
            }
            case 0x1020021: {
                this.setPrimaryClip(ClipData.newPlainText(null, this.getTransformedText(min, max)));
                this.stopTextActionMode();
                return true;
            }
            case 16908340: {
                if (this.mEditor != null) {
                    this.mEditor.replace();
                }
                return true;
            }
            case 16908341: {
                this.shareSelectedText();
                return true;
            }
        }
        return false;
    }

    private final CharSequence $$robo$$android_widget_TextView$getTransformedText(int start, int end) {
        return this.removeSuggestionSpans(this.mTransformed.subSequence(start, end));
    }

    private final boolean $$robo$$android_widget_TextView$performLongClick() {
        boolean handled = false;
        if (this.mEditor != null) {
            this.mEditor.mIsBeingLongClicked = true;
        }
        if (super.performLongClick()) {
            handled = true;
        }
        if (this.mEditor != null) {
            handled |= this.mEditor.performLongClick(handled);
            this.mEditor.mIsBeingLongClicked = false;
        }
        if (handled) {
            this.performHapticFeedback(0);
            if (this.mEditor != null) {
                this.mEditor.mDiscardNextActionUp = true;
            }
        }
        return handled;
    }

    private final void $$robo$$android_widget_TextView$onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        if (this.mEditor != null) {
            this.mEditor.onScrollChanged();
        }
    }

    private final boolean $$robo$$android_widget_TextView$isSuggestionsEnabled() {
        if (this.mEditor == null) {
            return false;
        }
        if ((this.mEditor.mInputType & 0xF) != 1) {
            return false;
        }
        if ((this.mEditor.mInputType & 0x80000) > 0) {
            return false;
        }
        int variation = this.mEditor.mInputType & 0xFF0;
        return variation == 0 || variation == 48 || variation == 80 || variation == 64 || variation == 160;
    }

    private final void $$robo$$android_widget_TextView$setCustomSelectionActionModeCallback(ActionMode.Callback actionModeCallback) {
        this.createEditorIfNeeded();
        this.mEditor.mCustomSelectionActionModeCallback = actionModeCallback;
    }

    private final ActionMode.Callback $$robo$$android_widget_TextView$getCustomSelectionActionModeCallback() {
        return this.mEditor == null ? null : this.mEditor.mCustomSelectionActionModeCallback;
    }

    private final void $$robo$$android_widget_TextView$setCustomInsertionActionModeCallback(ActionMode.Callback actionModeCallback) {
        this.createEditorIfNeeded();
        this.mEditor.mCustomInsertionActionModeCallback = actionModeCallback;
    }

    private final ActionMode.Callback $$robo$$android_widget_TextView$getCustomInsertionActionModeCallback() {
        return this.mEditor == null ? null : this.mEditor.mCustomInsertionActionModeCallback;
    }

    private final void $$robo$$android_widget_TextView$stopTextActionMode() {
        if (this.mEditor != null) {
            this.mEditor.stopTextActionMode();
        }
    }

    private final boolean $$robo$$android_widget_TextView$canUndo() {
        return this.mEditor != null && this.mEditor.canUndo();
    }

    private final boolean $$robo$$android_widget_TextView$canRedo() {
        return this.mEditor != null && this.mEditor.canRedo();
    }

    private final boolean $$robo$$android_widget_TextView$canCut() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection() && this.mText instanceof Editable && this.mEditor != null && this.mEditor.mKeyListener != null;
    }

    private final boolean $$robo$$android_widget_TextView$canCopy() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection() && this.mEditor != null;
    }

    private final boolean $$robo$$android_widget_TextView$canShare() {
        if (!this.getContext().canStartActivityForResult() || !this.isDeviceProvisioned()) {
            return false;
        }
        return this.canCopy();
    }

    private final boolean $$robo$$android_widget_TextView$isDeviceProvisioned() {
        if (this.mDeviceProvisionedState == 0) {
            this.mDeviceProvisionedState = Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0 ? 2 : 1;
        }
        return this.mDeviceProvisionedState == 2;
    }

    private final boolean $$robo$$android_widget_TextView$canPaste() {
        return this.mText instanceof Editable && this.mEditor != null && this.mEditor.mKeyListener != null && this.getSelectionStart() >= 0 && this.getSelectionEnd() >= 0 && ((ClipboardManager)this.getContext().getSystemService("clipboard")).hasPrimaryClip();
    }

    private final boolean $$robo$$android_widget_TextView$canProcessText() {
        if (this.getId() == -1) {
            return false;
        }
        return this.canShare();
    }

    private final boolean $$robo$$android_widget_TextView$canSelectAllText() {
        return this.canSelectText() && !this.hasPasswordTransformationMethod() && (this.getSelectionStart() != 0 || this.getSelectionEnd() != this.mText.length());
    }

    private final boolean $$robo$$android_widget_TextView$selectAllText() {
        int length = this.mText.length();
        Selection.setSelection((Spannable)this.mText, 0, length);
        return length > 0;
    }

    private final void $$robo$$android_widget_TextView$replaceSelectionWithText(CharSequence text) {
        ((Editable)this.mText).replace(this.getSelectionStart(), this.getSelectionEnd(), text);
    }

    private final void $$robo$$android_widget_TextView$paste(int min, int max, boolean withFormatting) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null) {
            boolean didFirst = false;
            for (int i = 0; i < clip.getItemCount(); ++i) {
                CharSequence paste;
                if (withFormatting) {
                    paste = clip.getItemAt(i).coerceToStyledText(this.getContext());
                } else {
                    CharSequence text = clip.getItemAt(i).coerceToText(this.getContext());
                    CharSequence charSequence = paste = text instanceof Spanned ? text.toString() : text;
                }
                if (paste == null) continue;
                if (!didFirst) {
                    Selection.setSelection((Spannable)this.mText, max);
                    ((Editable)this.mText).replace(min, max, paste);
                    didFirst = true;
                    continue;
                }
                ((Editable)this.mText).insert(this.getSelectionEnd(), "\n");
                ((Editable)this.mText).insert(this.getSelectionEnd(), paste);
            }
            sLastCutCopyOrTextChangedTime = 0L;
        }
    }

    private final void $$robo$$android_widget_TextView$shareSelectedText() {
        String selectedText = this.getSelectedText();
        if (selectedText != null && !selectedText.isEmpty()) {
            Intent sharingIntent = new Intent("android.intent.action.SEND");
            sharingIntent.setType("text/plain");
            sharingIntent.removeExtra("android.intent.extra.TEXT");
            sharingIntent.putExtra("android.intent.extra.TEXT", selectedText);
            this.getContext().startActivity(Intent.createChooser(sharingIntent, null));
            Selection.setSelection((Spannable)this.mText, this.getSelectionEnd());
        }
    }

    private final void $$robo$$android_widget_TextView$setPrimaryClip(ClipData clip) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        clipboard.setPrimaryClip(clip);
        sLastCutCopyOrTextChangedTime = SystemClock.uptimeMillis();
    }

    private final int $$robo$$android_widget_TextView$getOffsetForPosition(float x, float y) {
        if (this.getLayout() == null) {
            return -1;
        }
        int line = this.getLineAtCoordinate(y);
        int offset = this.getOffsetAtCoordinate(line, x);
        return offset;
    }

    private final float $$robo$$android_widget_TextView$convertToLocalHorizontalCoordinate(float x) {
        x -= (float)this.getTotalPaddingLeft();
        x = Math.max(0.0f, x);
        x = Math.min((float)(this.getWidth() - this.getTotalPaddingRight() - 1), x);
        return x += (float)this.getScrollX();
    }

    private final int $$robo$$android_widget_TextView$getLineAtCoordinate(float y) {
        y -= (float)this.getTotalPaddingTop();
        y = Math.max(0.0f, y);
        y = Math.min((float)(this.getHeight() - this.getTotalPaddingBottom() - 1), y);
        return this.getLayout().getLineForVertical((int)(y += (float)this.getScrollY()));
    }

    private final int $$robo$$android_widget_TextView$getLineAtCoordinateUnclamped(float y) {
        y -= (float)this.getTotalPaddingTop();
        return this.getLayout().getLineForVertical((int)(y += (float)this.getScrollY()));
    }

    private final int $$robo$$android_widget_TextView$getOffsetAtCoordinate(int line, float x) {
        x = this.convertToLocalHorizontalCoordinate(x);
        return this.getLayout().getOffsetForHorizontal(line, x);
    }

    private final boolean $$robo$$android_widget_TextView$onDragEvent(DragEvent event) {
        switch (event.getAction()) {
            case 1: {
                return this.mEditor != null && this.mEditor.hasInsertionController();
            }
            case 5: {
                this.requestFocus();
                return true;
            }
            case 2: {
                int offset = this.getOffsetForPosition(event.getX(), event.getY());
                Selection.setSelection((Spannable)this.mText, offset);
                return true;
            }
            case 3: {
                if (this.mEditor != null) {
                    this.mEditor.onDrop(event);
                }
                return true;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_widget_TextView$isInBatchEditMode() {
        if (this.mEditor == null) {
            return false;
        }
        Editor.InputMethodState ims = this.mEditor.mInputMethodState;
        if (ims != null) {
            return ims.mBatchEditNesting > 0;
        }
        return this.mEditor.mInBatchEditControllers;
    }

    private final void $$robo$$android_widget_TextView$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        TextDirectionHeuristic newTextDir = this.getTextDirectionHeuristic();
        if (this.mTextDir != newTextDir) {
            this.mTextDir = newTextDir;
            if (this.mLayout != null) {
                this.checkForRelayout();
            }
        }
    }

    private final TextDirectionHeuristic $$robo$$android_widget_TextView$getTextDirectionHeuristic() {
        if (this.hasPasswordTransformationMethod()) {
            return TextDirectionHeuristics.LTR;
        }
        boolean defaultIsRtl = this.getLayoutDirection() == 1;
        switch (this.getTextDirection()) {
            default: {
                return defaultIsRtl ? TextDirectionHeuristics.FIRSTSTRONG_RTL : TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }
            case 2: {
                return TextDirectionHeuristics.ANYRTL_LTR;
            }
            case 3: {
                return TextDirectionHeuristics.LTR;
            }
            case 4: {
                return TextDirectionHeuristics.RTL;
            }
            case 5: {
                return TextDirectionHeuristics.LOCALE;
            }
            case 6: {
                return TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }
            case 7: 
        }
        return TextDirectionHeuristics.FIRSTSTRONG_RTL;
    }

    private final void $$robo$$android_widget_TextView$onResolveDrawables(int layoutDirection) {
        if (this.mLastLayoutDirection == layoutDirection) {
            return;
        }
        this.mLastLayoutDirection = layoutDirection;
        if (this.mDrawables != null && this.mDrawables.resolveWithLayoutDirection(layoutDirection)) {
            this.prepareDrawableForDisplay(this.mDrawables.mShowing[0]);
            this.prepareDrawableForDisplay(this.mDrawables.mShowing[2]);
            this.applyCompoundDrawableTint();
        }
    }

    private final void $$robo$$android_widget_TextView$prepareDrawableForDisplay(Drawable dr) {
        if (dr == null) {
            return;
        }
        dr.setLayoutDirection(this.getLayoutDirection());
        if (dr.isStateful()) {
            dr.setState(this.getDrawableState());
            dr.jumpToCurrentState();
        }
    }

    private final void $$robo$$android_widget_TextView$resetResolvedDrawables() {
        super.resetResolvedDrawables();
        this.mLastLayoutDirection = -1;
    }

    private final void $$robo$$android_widget_TextView$viewClicked(InputMethodManager imm) {
        if (imm != null) {
            imm.viewClicked(this);
        }
    }

    private final void $$robo$$android_widget_TextView$deleteText_internal(int start, int end) {
        ((Editable)this.mText).delete(start, end);
    }

    private final void $$robo$$android_widget_TextView$replaceText_internal(int start, int end, CharSequence text) {
        ((Editable)this.mText).replace(start, end, text);
    }

    private final void $$robo$$android_widget_TextView$setSpan_internal(Object span, int start, int end, int flags) {
        ((Editable)this.mText).setSpan(span, start, end, flags);
    }

    private final void $$robo$$android_widget_TextView$setCursorPosition_internal(int start, int end) {
        Selection.setSelection((Editable)this.mText, start, end);
    }

    private final void $$robo$$android_widget_TextView$createEditorIfNeeded() {
        if (this.mEditor == null) {
            this.mEditor = new Editor(this);
        }
    }

    private final CharSequence $$robo$$android_widget_TextView$getIterableTextForAccessibility() {
        return this.mText;
    }

    private final void $$robo$$android_widget_TextView$ensureIterableTextForAccessibilitySelectable() {
        if (!(this.mText instanceof Spannable)) {
            this.setText(this.mText, BufferType.SPANNABLE);
        }
    }

    private final AccessibilityIterators.TextSegmentIterator $$robo$$android_widget_TextView$getIteratorForGranularity(int granularity) {
        switch (granularity) {
            case 4: {
                Spannable text = (Spannable)this.getIterableTextForAccessibility();
                if (TextUtils.isEmpty(text) || this.getLayout() == null) break;
                AccessibilityIterators.LineTextSegmentIterator iterator = AccessibilityIterators.LineTextSegmentIterator.getInstance();
                iterator.initialize(text, this.getLayout());
                return iterator;
            }
            case 16: {
                Spannable text = (Spannable)this.getIterableTextForAccessibility();
                if (TextUtils.isEmpty(text) || this.getLayout() == null) break;
                AccessibilityIterators.PageTextSegmentIterator iterator = AccessibilityIterators.PageTextSegmentIterator.getInstance();
                iterator.initialize(this);
                return iterator;
            }
        }
        return super.getIteratorForGranularity(granularity);
    }

    private final int $$robo$$android_widget_TextView$getAccessibilitySelectionStart() {
        return this.getSelectionStart();
    }

    private final boolean $$robo$$android_widget_TextView$isAccessibilitySelectionExtendable() {
        return true;
    }

    private final int $$robo$$android_widget_TextView$getAccessibilitySelectionEnd() {
        return this.getSelectionEnd();
    }

    private final void $$robo$$android_widget_TextView$setAccessibilitySelection(int start, int end) {
        if (this.getAccessibilitySelectionStart() == start && this.getAccessibilitySelectionEnd() == end) {
            return;
        }
        CharSequence text = this.getIterableTextForAccessibility();
        if (Math.min(start, end) >= 0 && Math.max(start, end) <= text.length()) {
            Selection.setSelection((Spannable)text, start, end);
        } else {
            Selection.removeSelection((Spannable)text);
        }
        if (this.mEditor != null) {
            this.mEditor.hideCursorAndSpanControllers();
            this.mEditor.stopTextActionMode();
        }
    }

    private final void $$robo$$android_widget_TextView$encodeProperties(ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        TextUtils.TruncateAt ellipsize = this.getEllipsize();
        stream.addProperty("text:ellipsize", ellipsize == null ? null : ellipsize.name());
        stream.addProperty("text:textSize", this.getTextSize());
        stream.addProperty("text:scaledTextSize", this.getScaledTextSize());
        stream.addProperty("text:typefaceStyle", this.getTypefaceStyle());
        stream.addProperty("text:selectionStart", this.getSelectionStart());
        stream.addProperty("text:selectionEnd", this.getSelectionEnd());
        stream.addProperty("text:curTextColor", this.mCurTextColor);
        stream.addProperty("text:text", this.mText == null ? null : this.mText.toString());
        stream.addProperty("text:gravity", this.mGravity);
    }

    static void __staticInitializer__() {
        TEMP_RECTF = new RectF();
        NO_FILTERS = new InputFilter[0];
        EMPTY_SPANNED = new SpannedString("");
        MULTILINE_STATE_SET = new int[]{16843597};
        UNKNOWN_BORING = new BoringLayout.Metrics();
    }

    public static void preloadFontCache() {
        InvokeDynamicSupport.bootstrapStatic("preloadFontCache", $$robo$$android_widget_TextView$preloadFontCache(), 0);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TextView$__constructor__(context);
    }

    public TextView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TextView$__constructor__(context, attributeSet);
    }

    public TextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_TextView$__constructor__(context, attributeSet, n);
    }

    public TextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TextView$__constructor__(context, attributeSet, n, n2);
    }

    public TextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private int[] parseDimensionArray(TypedArray typedArray) {
        return InvokeDynamicSupport.bootstrap("parseDimensionArray", $$robo$$android_widget_TextView$parseDimensionArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
        InvokeDynamicSupport.bootstrap("onActivityResult", $$robo$$android_widget_TextView$onActivityResult(int int android.content.Intent ), 0, this, n, n2, intent);
    }

    private void setTypefaceFromAttrs(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setTypefaceFromAttrs", $$robo$$android_widget_TextView$setTypefaceFromAttrs(java.lang.String int int ), 0, this, string2, n, n2);
    }

    private void setRelativeDrawablesIfNeeded(Drawable drawable2, Drawable drawable3) {
        InvokeDynamicSupport.bootstrap("setRelativeDrawablesIfNeeded", $$robo$$android_widget_TextView$setRelativeDrawablesIfNeeded(android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, drawable2, drawable3);
    }

    @Override
    @RemotableViewMethod
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_TextView$setEnabled(boolean ), 0, this, bl);
    }

    public void setTypeface(Typeface typeface, int n) {
        InvokeDynamicSupport.bootstrap("setTypeface", $$robo$$android_widget_TextView$setTypeface(android.graphics.Typeface int ), 0, this, typeface, n);
    }

    protected boolean getDefaultEditable() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDefaultEditable", $$robo$$android_widget_TextView$getDefaultEditable(), 0, this);
    }

    protected MovementMethod getDefaultMovementMethod() {
        return InvokeDynamicSupport.bootstrap("getDefaultMovementMethod", $$robo$$android_widget_TextView$getDefaultMovementMethod(), 0, this);
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_widget_TextView$getText(), 0, this);
    }

    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_widget_TextView$length(), 0, this);
    }

    public Editable getEditableText() {
        return InvokeDynamicSupport.bootstrap("getEditableText", $$robo$$android_widget_TextView$getEditableText(), 0, this);
    }

    public int getLineHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getLineHeight", $$robo$$android_widget_TextView$getLineHeight(), 0, this);
    }

    public Layout getLayout() {
        return InvokeDynamicSupport.bootstrap("getLayout", $$robo$$android_widget_TextView$getLayout(), 0, this);
    }

    Layout getHintLayout() {
        return InvokeDynamicSupport.bootstrap("getHintLayout", $$robo$$android_widget_TextView$getHintLayout(), 0, this);
    }

    public UndoManager getUndoManager() {
        return InvokeDynamicSupport.bootstrap("getUndoManager", $$robo$$android_widget_TextView$getUndoManager(), 0, this);
    }

    public Editor getEditorForTesting() {
        return InvokeDynamicSupport.bootstrap("getEditorForTesting", $$robo$$android_widget_TextView$getEditorForTesting(), 0, this);
    }

    public void setUndoManager(UndoManager undoManager, String string2) {
        InvokeDynamicSupport.bootstrap("setUndoManager", $$robo$$android_widget_TextView$setUndoManager(android.content.UndoManager java.lang.String ), 0, this, undoManager, string2);
    }

    public KeyListener getKeyListener() {
        return InvokeDynamicSupport.bootstrap("getKeyListener", $$robo$$android_widget_TextView$getKeyListener(), 0, this);
    }

    public void setKeyListener(KeyListener keyListener) {
        InvokeDynamicSupport.bootstrap("setKeyListener", $$robo$$android_widget_TextView$setKeyListener(android.text.method.KeyListener ), 0, this, keyListener);
    }

    private void setKeyListenerOnly(KeyListener keyListener) {
        InvokeDynamicSupport.bootstrap("setKeyListenerOnly", $$robo$$android_widget_TextView$setKeyListenerOnly(android.text.method.KeyListener ), 0, this, keyListener);
    }

    public MovementMethod getMovementMethod() {
        return InvokeDynamicSupport.bootstrap("getMovementMethod", $$robo$$android_widget_TextView$getMovementMethod(), 0, this);
    }

    public void setMovementMethod(MovementMethod movementMethod) {
        InvokeDynamicSupport.bootstrap("setMovementMethod", $$robo$$android_widget_TextView$setMovementMethod(android.text.method.MovementMethod ), 0, this, movementMethod);
    }

    private void fixFocusableAndClickableSettings() {
        InvokeDynamicSupport.bootstrap("fixFocusableAndClickableSettings", $$robo$$android_widget_TextView$fixFocusableAndClickableSettings(), 0, this);
    }

    public TransformationMethod getTransformationMethod() {
        return InvokeDynamicSupport.bootstrap("getTransformationMethod", $$robo$$android_widget_TextView$getTransformationMethod(), 0, this);
    }

    public void setTransformationMethod(TransformationMethod transformationMethod) {
        InvokeDynamicSupport.bootstrap("setTransformationMethod", $$robo$$android_widget_TextView$setTransformationMethod(android.text.method.TransformationMethod ), 0, this, transformationMethod);
    }

    public int getCompoundPaddingTop() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingTop", $$robo$$android_widget_TextView$getCompoundPaddingTop(), 0, this);
    }

    public int getCompoundPaddingBottom() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingBottom", $$robo$$android_widget_TextView$getCompoundPaddingBottom(), 0, this);
    }

    public int getCompoundPaddingLeft() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingLeft", $$robo$$android_widget_TextView$getCompoundPaddingLeft(), 0, this);
    }

    public int getCompoundPaddingRight() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingRight", $$robo$$android_widget_TextView$getCompoundPaddingRight(), 0, this);
    }

    public int getCompoundPaddingStart() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingStart", $$robo$$android_widget_TextView$getCompoundPaddingStart(), 0, this);
    }

    public int getCompoundPaddingEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundPaddingEnd", $$robo$$android_widget_TextView$getCompoundPaddingEnd(), 0, this);
    }

    public int getExtendedPaddingTop() {
        return (int)InvokeDynamicSupport.bootstrap("getExtendedPaddingTop", $$robo$$android_widget_TextView$getExtendedPaddingTop(), 0, this);
    }

    public int getExtendedPaddingBottom() {
        return (int)InvokeDynamicSupport.bootstrap("getExtendedPaddingBottom", $$robo$$android_widget_TextView$getExtendedPaddingBottom(), 0, this);
    }

    public int getTotalPaddingLeft() {
        return (int)InvokeDynamicSupport.bootstrap("getTotalPaddingLeft", $$robo$$android_widget_TextView$getTotalPaddingLeft(), 0, this);
    }

    public int getTotalPaddingRight() {
        return (int)InvokeDynamicSupport.bootstrap("getTotalPaddingRight", $$robo$$android_widget_TextView$getTotalPaddingRight(), 0, this);
    }

    public int getTotalPaddingStart() {
        return (int)InvokeDynamicSupport.bootstrap("getTotalPaddingStart", $$robo$$android_widget_TextView$getTotalPaddingStart(), 0, this);
    }

    public int getTotalPaddingEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getTotalPaddingEnd", $$robo$$android_widget_TextView$getTotalPaddingEnd(), 0, this);
    }

    public int getTotalPaddingTop() {
        return (int)InvokeDynamicSupport.bootstrap("getTotalPaddingTop", $$robo$$android_widget_TextView$getTotalPaddingTop(), 0, this);
    }

    public int getTotalPaddingBottom() {
        return (int)InvokeDynamicSupport.bootstrap("getTotalPaddingBottom", $$robo$$android_widget_TextView$getTotalPaddingBottom(), 0, this);
    }

    public void setCompoundDrawables(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawables", $$robo$$android_widget_TextView$setCompoundDrawables(android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, drawable2, drawable3, drawable4, drawable5);
    }

    @RemotableViewMethod
    public void setCompoundDrawablesWithIntrinsicBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawablesWithIntrinsicBounds", $$robo$$android_widget_TextView$setCompoundDrawablesWithIntrinsicBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @RemotableViewMethod
    public void setCompoundDrawablesWithIntrinsicBounds(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawablesWithIntrinsicBounds", $$robo$$android_widget_TextView$setCompoundDrawablesWithIntrinsicBounds(android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, drawable2, drawable3, drawable4, drawable5);
    }

    @RemotableViewMethod
    public void setCompoundDrawablesRelative(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawablesRelative", $$robo$$android_widget_TextView$setCompoundDrawablesRelative(android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, drawable2, drawable3, drawable4, drawable5);
    }

    @RemotableViewMethod
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawablesRelativeWithIntrinsicBounds", $$robo$$android_widget_TextView$setCompoundDrawablesRelativeWithIntrinsicBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @RemotableViewMethod
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawablesRelativeWithIntrinsicBounds", $$robo$$android_widget_TextView$setCompoundDrawablesRelativeWithIntrinsicBounds(android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, drawable2, drawable3, drawable4, drawable5);
    }

    public Drawable[] getCompoundDrawables() {
        return InvokeDynamicSupport.bootstrap("getCompoundDrawables", $$robo$$android_widget_TextView$getCompoundDrawables(), 0, this);
    }

    public Drawable[] getCompoundDrawablesRelative() {
        return InvokeDynamicSupport.bootstrap("getCompoundDrawablesRelative", $$robo$$android_widget_TextView$getCompoundDrawablesRelative(), 0, this);
    }

    @RemotableViewMethod
    public void setCompoundDrawablePadding(int n) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawablePadding", $$robo$$android_widget_TextView$setCompoundDrawablePadding(int ), 0, this, n);
    }

    public int getCompoundDrawablePadding() {
        return (int)InvokeDynamicSupport.bootstrap("getCompoundDrawablePadding", $$robo$$android_widget_TextView$getCompoundDrawablePadding(), 0, this);
    }

    public void setCompoundDrawableTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawableTintList", $$robo$$android_widget_TextView$setCompoundDrawableTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getCompoundDrawableTintList() {
        return InvokeDynamicSupport.bootstrap("getCompoundDrawableTintList", $$robo$$android_widget_TextView$getCompoundDrawableTintList(), 0, this);
    }

    public void setCompoundDrawableTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setCompoundDrawableTintMode", $$robo$$android_widget_TextView$setCompoundDrawableTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getCompoundDrawableTintMode() {
        return InvokeDynamicSupport.bootstrap("getCompoundDrawableTintMode", $$robo$$android_widget_TextView$getCompoundDrawableTintMode(), 0, this);
    }

    private void applyCompoundDrawableTint() {
        InvokeDynamicSupport.bootstrap("applyCompoundDrawableTint", $$robo$$android_widget_TextView$applyCompoundDrawableTint(), 0, this);
    }

    @Override
    public void setPadding(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setPadding", $$robo$$android_widget_TextView$setPadding(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void setPaddingRelative(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setPaddingRelative", $$robo$$android_widget_TextView$setPaddingRelative(int int int int ), 0, this, n, n2, n3, n4);
    }

    public int getAutoLinkMask() {
        return (int)InvokeDynamicSupport.bootstrap("getAutoLinkMask", $$robo$$android_widget_TextView$getAutoLinkMask(), 0, this);
    }

    public void setTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setTextAppearance", $$robo$$android_widget_TextView$setTextAppearance(int ), 0, this, n);
    }

    @Deprecated
    public void setTextAppearance(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setTextAppearance", $$robo$$android_widget_TextView$setTextAppearance(android.content.Context int ), 0, this, context, n);
    }

    public Locale getTextLocale() {
        return InvokeDynamicSupport.bootstrap("getTextLocale", $$robo$$android_widget_TextView$getTextLocale(), 0, this);
    }

    public LocaleList getTextLocales() {
        return InvokeDynamicSupport.bootstrap("getTextLocales", $$robo$$android_widget_TextView$getTextLocales(), 0, this);
    }

    public void setTextLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setTextLocale", $$robo$$android_widget_TextView$setTextLocale(java.util.Locale ), 0, this, locale);
    }

    public void setTextLocales(LocaleList localeList) {
        InvokeDynamicSupport.bootstrap("setTextLocales", $$robo$$android_widget_TextView$setTextLocales(android.os.LocaleList ), 0, this, localeList);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_TextView$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @ViewDebug.ExportedProperty(category="text")
    public float getTextSize() {
        return (float)InvokeDynamicSupport.bootstrap("getTextSize", $$robo$$android_widget_TextView$getTextSize(), 0, this);
    }

    @ViewDebug.ExportedProperty(category="text")
    public float getScaledTextSize() {
        return (float)InvokeDynamicSupport.bootstrap("getScaledTextSize", $$robo$$android_widget_TextView$getScaledTextSize(), 0, this);
    }

    @ViewDebug.ExportedProperty(category="text", mapping={@ViewDebug.IntToString(from=0, to="NORMAL"), @ViewDebug.IntToString(from=1, to="BOLD"), @ViewDebug.IntToString(from=2, to="ITALIC"), @ViewDebug.IntToString(from=3, to="BOLD_ITALIC")})
    public int getTypefaceStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getTypefaceStyle", $$robo$$android_widget_TextView$getTypefaceStyle(), 0, this);
    }

    @RemotableViewMethod
    public void setTextSize(float f) {
        InvokeDynamicSupport.bootstrap("setTextSize", $$robo$$android_widget_TextView$setTextSize(float ), 0, this, f);
    }

    public void setTextSize(int n, float f) {
        InvokeDynamicSupport.bootstrap("setTextSize", $$robo$$android_widget_TextView$setTextSize(int float ), 0, this, n, f);
    }

    private void setRawTextSize(float f) {
        InvokeDynamicSupport.bootstrap("setRawTextSize", $$robo$$android_widget_TextView$setRawTextSize(float ), 0, this, f);
    }

    public float getTextScaleX() {
        return (float)InvokeDynamicSupport.bootstrap("getTextScaleX", $$robo$$android_widget_TextView$getTextScaleX(), 0, this);
    }

    @RemotableViewMethod
    public void setTextScaleX(float f) {
        InvokeDynamicSupport.bootstrap("setTextScaleX", $$robo$$android_widget_TextView$setTextScaleX(float ), 0, this, f);
    }

    public void setTypeface(Typeface typeface) {
        InvokeDynamicSupport.bootstrap("setTypeface", $$robo$$android_widget_TextView$setTypeface(android.graphics.Typeface ), 0, this, typeface);
    }

    public Typeface getTypeface() {
        return InvokeDynamicSupport.bootstrap("getTypeface", $$robo$$android_widget_TextView$getTypeface(), 0, this);
    }

    public void setElegantTextHeight(boolean bl) {
        InvokeDynamicSupport.bootstrap("setElegantTextHeight", $$robo$$android_widget_TextView$setElegantTextHeight(boolean ), 0, this, bl);
    }

    public float getLetterSpacing() {
        return (float)InvokeDynamicSupport.bootstrap("getLetterSpacing", $$robo$$android_widget_TextView$getLetterSpacing(), 0, this);
    }

    @RemotableViewMethod
    public void setLetterSpacing(float f) {
        InvokeDynamicSupport.bootstrap("setLetterSpacing", $$robo$$android_widget_TextView$setLetterSpacing(float ), 0, this, f);
    }

    public String getFontFeatureSettings() {
        return InvokeDynamicSupport.bootstrap("getFontFeatureSettings", $$robo$$android_widget_TextView$getFontFeatureSettings(), 0, this);
    }

    public void setBreakStrategy(int n) {
        InvokeDynamicSupport.bootstrap("setBreakStrategy", $$robo$$android_widget_TextView$setBreakStrategy(int ), 0, this, n);
    }

    public int getBreakStrategy() {
        return (int)InvokeDynamicSupport.bootstrap("getBreakStrategy", $$robo$$android_widget_TextView$getBreakStrategy(), 0, this);
    }

    public void setHyphenationFrequency(int n) {
        InvokeDynamicSupport.bootstrap("setHyphenationFrequency", $$robo$$android_widget_TextView$setHyphenationFrequency(int ), 0, this, n);
    }

    public int getHyphenationFrequency() {
        return (int)InvokeDynamicSupport.bootstrap("getHyphenationFrequency", $$robo$$android_widget_TextView$getHyphenationFrequency(), 0, this);
    }

    @RemotableViewMethod
    public void setFontFeatureSettings(String string2) {
        InvokeDynamicSupport.bootstrap("setFontFeatureSettings", $$robo$$android_widget_TextView$setFontFeatureSettings(java.lang.String ), 0, this, string2);
    }

    @RemotableViewMethod
    public void setTextColor(int n) {
        InvokeDynamicSupport.bootstrap("setTextColor", $$robo$$android_widget_TextView$setTextColor(int ), 0, this, n);
    }

    public void setTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTextColor", $$robo$$android_widget_TextView$setTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getTextColors() {
        return InvokeDynamicSupport.bootstrap("getTextColors", $$robo$$android_widget_TextView$getTextColors(), 0, this);
    }

    public int getCurrentTextColor() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentTextColor", $$robo$$android_widget_TextView$getCurrentTextColor(), 0, this);
    }

    @RemotableViewMethod
    public void setHighlightColor(int n) {
        InvokeDynamicSupport.bootstrap("setHighlightColor", $$robo$$android_widget_TextView$setHighlightColor(int ), 0, this, n);
    }

    public int getHighlightColor() {
        return (int)InvokeDynamicSupport.bootstrap("getHighlightColor", $$robo$$android_widget_TextView$getHighlightColor(), 0, this);
    }

    @RemotableViewMethod
    public void setShowSoftInputOnFocus(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowSoftInputOnFocus", $$robo$$android_widget_TextView$setShowSoftInputOnFocus(boolean ), 0, this, bl);
    }

    public boolean getShowSoftInputOnFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("getShowSoftInputOnFocus", $$robo$$android_widget_TextView$getShowSoftInputOnFocus(), 0, this);
    }

    public void setShadowLayer(float f, float f2, float f3, int n) {
        InvokeDynamicSupport.bootstrap("setShadowLayer", $$robo$$android_widget_TextView$setShadowLayer(float float float int ), 0, this, f, f2, f3, n);
    }

    public float getShadowRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getShadowRadius", $$robo$$android_widget_TextView$getShadowRadius(), 0, this);
    }

    public float getShadowDx() {
        return (float)InvokeDynamicSupport.bootstrap("getShadowDx", $$robo$$android_widget_TextView$getShadowDx(), 0, this);
    }

    public float getShadowDy() {
        return (float)InvokeDynamicSupport.bootstrap("getShadowDy", $$robo$$android_widget_TextView$getShadowDy(), 0, this);
    }

    public int getShadowColor() {
        return (int)InvokeDynamicSupport.bootstrap("getShadowColor", $$robo$$android_widget_TextView$getShadowColor(), 0, this);
    }

    public TextPaint getPaint() {
        return InvokeDynamicSupport.bootstrap("getPaint", $$robo$$android_widget_TextView$getPaint(), 0, this);
    }

    @RemotableViewMethod
    public void setAutoLinkMask(int n) {
        InvokeDynamicSupport.bootstrap("setAutoLinkMask", $$robo$$android_widget_TextView$setAutoLinkMask(int ), 0, this, n);
    }

    @RemotableViewMethod
    public void setLinksClickable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLinksClickable", $$robo$$android_widget_TextView$setLinksClickable(boolean ), 0, this, bl);
    }

    public boolean getLinksClickable() {
        return (boolean)InvokeDynamicSupport.bootstrap("getLinksClickable", $$robo$$android_widget_TextView$getLinksClickable(), 0, this);
    }

    public URLSpan[] getUrls() {
        return InvokeDynamicSupport.bootstrap("getUrls", $$robo$$android_widget_TextView$getUrls(), 0, this);
    }

    @RemotableViewMethod
    public void setHintTextColor(int n) {
        InvokeDynamicSupport.bootstrap("setHintTextColor", $$robo$$android_widget_TextView$setHintTextColor(int ), 0, this, n);
    }

    public void setHintTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setHintTextColor", $$robo$$android_widget_TextView$setHintTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getHintTextColors() {
        return InvokeDynamicSupport.bootstrap("getHintTextColors", $$robo$$android_widget_TextView$getHintTextColors(), 0, this);
    }

    public int getCurrentHintTextColor() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentHintTextColor", $$robo$$android_widget_TextView$getCurrentHintTextColor(), 0, this);
    }

    @RemotableViewMethod
    public void setLinkTextColor(int n) {
        InvokeDynamicSupport.bootstrap("setLinkTextColor", $$robo$$android_widget_TextView$setLinkTextColor(int ), 0, this, n);
    }

    public void setLinkTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setLinkTextColor", $$robo$$android_widget_TextView$setLinkTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getLinkTextColors() {
        return InvokeDynamicSupport.bootstrap("getLinkTextColors", $$robo$$android_widget_TextView$getLinkTextColors(), 0, this);
    }

    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_widget_TextView$setGravity(int ), 0, this, n);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_widget_TextView$getGravity(), 0, this);
    }

    public int getPaintFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getPaintFlags", $$robo$$android_widget_TextView$getPaintFlags(), 0, this);
    }

    @RemotableViewMethod
    public void setPaintFlags(int n) {
        InvokeDynamicSupport.bootstrap("setPaintFlags", $$robo$$android_widget_TextView$setPaintFlags(int ), 0, this, n);
    }

    public void setHorizontallyScrolling(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHorizontallyScrolling", $$robo$$android_widget_TextView$setHorizontallyScrolling(boolean ), 0, this, bl);
    }

    public boolean getHorizontallyScrolling() {
        return (boolean)InvokeDynamicSupport.bootstrap("getHorizontallyScrolling", $$robo$$android_widget_TextView$getHorizontallyScrolling(), 0, this);
    }

    @RemotableViewMethod
    public void setMinLines(int n) {
        InvokeDynamicSupport.bootstrap("setMinLines", $$robo$$android_widget_TextView$setMinLines(int ), 0, this, n);
    }

    public int getMinLines() {
        return (int)InvokeDynamicSupport.bootstrap("getMinLines", $$robo$$android_widget_TextView$getMinLines(), 0, this);
    }

    @RemotableViewMethod
    public void setMinHeight(int n) {
        InvokeDynamicSupport.bootstrap("setMinHeight", $$robo$$android_widget_TextView$setMinHeight(int ), 0, this, n);
    }

    public int getMinHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMinHeight", $$robo$$android_widget_TextView$getMinHeight(), 0, this);
    }

    @RemotableViewMethod
    public void setMaxLines(int n) {
        InvokeDynamicSupport.bootstrap("setMaxLines", $$robo$$android_widget_TextView$setMaxLines(int ), 0, this, n);
    }

    public int getMaxLines() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxLines", $$robo$$android_widget_TextView$getMaxLines(), 0, this);
    }

    @RemotableViewMethod
    public void setMaxHeight(int n) {
        InvokeDynamicSupport.bootstrap("setMaxHeight", $$robo$$android_widget_TextView$setMaxHeight(int ), 0, this, n);
    }

    public int getMaxHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxHeight", $$robo$$android_widget_TextView$getMaxHeight(), 0, this);
    }

    @RemotableViewMethod
    public void setLines(int n) {
        InvokeDynamicSupport.bootstrap("setLines", $$robo$$android_widget_TextView$setLines(int ), 0, this, n);
    }

    @RemotableViewMethod
    public void setHeight(int n) {
        InvokeDynamicSupport.bootstrap("setHeight", $$robo$$android_widget_TextView$setHeight(int ), 0, this, n);
    }

    @RemotableViewMethod
    public void setMinEms(int n) {
        InvokeDynamicSupport.bootstrap("setMinEms", $$robo$$android_widget_TextView$setMinEms(int ), 0, this, n);
    }

    public int getMinEms() {
        return (int)InvokeDynamicSupport.bootstrap("getMinEms", $$robo$$android_widget_TextView$getMinEms(), 0, this);
    }

    @RemotableViewMethod
    public void setMinWidth(int n) {
        InvokeDynamicSupport.bootstrap("setMinWidth", $$robo$$android_widget_TextView$setMinWidth(int ), 0, this, n);
    }

    public int getMinWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMinWidth", $$robo$$android_widget_TextView$getMinWidth(), 0, this);
    }

    @RemotableViewMethod
    public void setMaxEms(int n) {
        InvokeDynamicSupport.bootstrap("setMaxEms", $$robo$$android_widget_TextView$setMaxEms(int ), 0, this, n);
    }

    public int getMaxEms() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxEms", $$robo$$android_widget_TextView$getMaxEms(), 0, this);
    }

    @RemotableViewMethod
    public void setMaxWidth(int n) {
        InvokeDynamicSupport.bootstrap("setMaxWidth", $$robo$$android_widget_TextView$setMaxWidth(int ), 0, this, n);
    }

    public int getMaxWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxWidth", $$robo$$android_widget_TextView$getMaxWidth(), 0, this);
    }

    @RemotableViewMethod
    public void setEms(int n) {
        InvokeDynamicSupport.bootstrap("setEms", $$robo$$android_widget_TextView$setEms(int ), 0, this, n);
    }

    @RemotableViewMethod
    public void setWidth(int n) {
        InvokeDynamicSupport.bootstrap("setWidth", $$robo$$android_widget_TextView$setWidth(int ), 0, this, n);
    }

    public void setLineSpacing(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setLineSpacing", $$robo$$android_widget_TextView$setLineSpacing(float float ), 0, this, f, f2);
    }

    public float getLineSpacingMultiplier() {
        return (float)InvokeDynamicSupport.bootstrap("getLineSpacingMultiplier", $$robo$$android_widget_TextView$getLineSpacingMultiplier(), 0, this);
    }

    public float getLineSpacingExtra() {
        return (float)InvokeDynamicSupport.bootstrap("getLineSpacingExtra", $$robo$$android_widget_TextView$getLineSpacingExtra(), 0, this);
    }

    public void append(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_widget_TextView$append(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void append(CharSequence charSequence, int n, int n2) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_widget_TextView$append(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    private void updateTextColors() {
        InvokeDynamicSupport.bootstrap("updateTextColors", $$robo$$android_widget_TextView$updateTextColors(), 0, this);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_TextView$drawableStateChanged(), 0, this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_TextView$drawableHotspotChanged(float float ), 0, this, f, f2);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_TextView$onSaveInstanceState(), 0, this);
    }

    void removeMisspelledSpans(Spannable spannable) {
        InvokeDynamicSupport.bootstrap("removeMisspelledSpans", $$robo$$android_widget_TextView$removeMisspelledSpans(android.text.Spannable ), 0, this, spannable);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_TextView$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @RemotableViewMethod
    public void setFreezesText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFreezesText", $$robo$$android_widget_TextView$setFreezesText(boolean ), 0, this, bl);
    }

    public boolean getFreezesText() {
        return (boolean)InvokeDynamicSupport.bootstrap("getFreezesText", $$robo$$android_widget_TextView$getFreezesText(), 0, this);
    }

    public void setEditableFactory(Editable.Factory factory) {
        InvokeDynamicSupport.bootstrap("setEditableFactory", $$robo$$android_widget_TextView$setEditableFactory(android.text.Editable$Factory ), 0, this, factory);
    }

    public void setSpannableFactory(Spannable.Factory factory) {
        InvokeDynamicSupport.bootstrap("setSpannableFactory", $$robo$$android_widget_TextView$setSpannableFactory(android.text.Spannable$Factory ), 0, this, factory);
    }

    @RemotableViewMethod
    public void setText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_TextView$setText(java.lang.CharSequence ), 0, this, charSequence);
    }

    @RemotableViewMethod
    public void setTextKeepState(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTextKeepState", $$robo$$android_widget_TextView$setTextKeepState(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setText(CharSequence charSequence, BufferType bufferType) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_TextView$setText(java.lang.CharSequence android.widget.TextView$BufferType ), 0, this, charSequence, bufferType);
    }

    private void setText(CharSequence charSequence, BufferType bufferType, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_TextView$setText(java.lang.CharSequence android.widget.TextView$BufferType boolean int ), 0, this, charSequence, bufferType, bl, n);
    }

    public void setText(char[] cArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_TextView$setText(char[] int int ), 0, this, cArray, n, n2);
    }

    public void setTextKeepState(CharSequence charSequence, BufferType bufferType) {
        InvokeDynamicSupport.bootstrap("setTextKeepState", $$robo$$android_widget_TextView$setTextKeepState(java.lang.CharSequence android.widget.TextView$BufferType ), 0, this, charSequence, bufferType);
    }

    @RemotableViewMethod
    public void setText(int n) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_TextView$setText(int ), 0, this, n);
    }

    public void setText(int n, BufferType bufferType) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_TextView$setText(int android.widget.TextView$BufferType ), 0, this, n, bufferType);
    }

    @RemotableViewMethod
    public void setHint(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setHint", $$robo$$android_widget_TextView$setHint(java.lang.CharSequence ), 0, this, charSequence);
    }

    @RemotableViewMethod
    public void setHint(int n) {
        InvokeDynamicSupport.bootstrap("setHint", $$robo$$android_widget_TextView$setHint(int ), 0, this, n);
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getHint() {
        return InvokeDynamicSupport.bootstrap("getHint", $$robo$$android_widget_TextView$getHint(), 0, this);
    }

    boolean isSingleLine() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSingleLine", $$robo$$android_widget_TextView$isSingleLine(), 0, this);
    }

    private static boolean isMultilineInputType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMultilineInputType", $$robo$$android_widget_TextView$isMultilineInputType(int ), 0, (int)n);
    }

    CharSequence removeSuggestionSpans(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("removeSuggestionSpans", $$robo$$android_widget_TextView$removeSuggestionSpans(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setInputType(int n) {
        InvokeDynamicSupport.bootstrap("setInputType", $$robo$$android_widget_TextView$setInputType(int ), 0, this, n);
    }

    boolean hasPasswordTransformationMethod() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPasswordTransformationMethod", $$robo$$android_widget_TextView$hasPasswordTransformationMethod(), 0, this);
    }

    private static boolean isPasswordInputType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPasswordInputType", $$robo$$android_widget_TextView$isPasswordInputType(int ), 0, (int)n);
    }

    private static boolean isVisiblePasswordInputType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVisiblePasswordInputType", $$robo$$android_widget_TextView$isVisiblePasswordInputType(int ), 0, (int)n);
    }

    public void setRawInputType(int n) {
        InvokeDynamicSupport.bootstrap("setRawInputType", $$robo$$android_widget_TextView$setRawInputType(int ), 0, this, n);
    }

    private void setInputType(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setInputType", $$robo$$android_widget_TextView$setInputType(int boolean ), 0, this, n, bl);
    }

    public int getInputType() {
        return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_widget_TextView$getInputType(), 0, this);
    }

    public void setImeOptions(int n) {
        InvokeDynamicSupport.bootstrap("setImeOptions", $$robo$$android_widget_TextView$setImeOptions(int ), 0, this, n);
    }

    public int getImeOptions() {
        return (int)InvokeDynamicSupport.bootstrap("getImeOptions", $$robo$$android_widget_TextView$getImeOptions(), 0, this);
    }

    public void setImeActionLabel(CharSequence charSequence, int n) {
        InvokeDynamicSupport.bootstrap("setImeActionLabel", $$robo$$android_widget_TextView$setImeActionLabel(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    public CharSequence getImeActionLabel() {
        return InvokeDynamicSupport.bootstrap("getImeActionLabel", $$robo$$android_widget_TextView$getImeActionLabel(), 0, this);
    }

    public int getImeActionId() {
        return (int)InvokeDynamicSupport.bootstrap("getImeActionId", $$robo$$android_widget_TextView$getImeActionId(), 0, this);
    }

    public void setOnEditorActionListener(OnEditorActionListener onEditorActionListener) {
        InvokeDynamicSupport.bootstrap("setOnEditorActionListener", $$robo$$android_widget_TextView$setOnEditorActionListener(android.widget.TextView$OnEditorActionListener ), 0, this, onEditorActionListener);
    }

    public void onEditorAction(int n) {
        InvokeDynamicSupport.bootstrap("onEditorAction", $$robo$$android_widget_TextView$onEditorAction(int ), 0, this, n);
    }

    public void setPrivateImeOptions(String string2) {
        InvokeDynamicSupport.bootstrap("setPrivateImeOptions", $$robo$$android_widget_TextView$setPrivateImeOptions(java.lang.String ), 0, this, string2);
    }

    public String getPrivateImeOptions() {
        return InvokeDynamicSupport.bootstrap("getPrivateImeOptions", $$robo$$android_widget_TextView$getPrivateImeOptions(), 0, this);
    }

    public void setInputExtras(int n) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("setInputExtras", $$robo$$android_widget_TextView$setInputExtras(int ), 0, this, n);
    }

    public Bundle getInputExtras(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getInputExtras", $$robo$$android_widget_TextView$getInputExtras(boolean ), 0, this, bl);
    }

    public void setImeHintLocales(LocaleList localeList) {
        InvokeDynamicSupport.bootstrap("setImeHintLocales", $$robo$$android_widget_TextView$setImeHintLocales(android.os.LocaleList ), 0, this, localeList);
    }

    public LocaleList getImeHintLocales() {
        return InvokeDynamicSupport.bootstrap("getImeHintLocales", $$robo$$android_widget_TextView$getImeHintLocales(), 0, this);
    }

    public CharSequence getError() {
        return InvokeDynamicSupport.bootstrap("getError", $$robo$$android_widget_TextView$getError(), 0, this);
    }

    @RemotableViewMethod
    public void setError(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setError", $$robo$$android_widget_TextView$setError(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setError(CharSequence charSequence, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setError", $$robo$$android_widget_TextView$setError(java.lang.CharSequence android.graphics.drawable.Drawable ), 0, this, charSequence, drawable2);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_widget_TextView$setFrame(int int int int ), 0, this, n, n2, n3, n4);
    }

    private void restartMarqueeIfNeeded() {
        InvokeDynamicSupport.bootstrap("restartMarqueeIfNeeded", $$robo$$android_widget_TextView$restartMarqueeIfNeeded(), 0, this);
    }

    public void setFilters(InputFilter[] inputFilterArray) {
        InvokeDynamicSupport.bootstrap("setFilters", $$robo$$android_widget_TextView$setFilters(android.text.InputFilter[] ), 0, this, inputFilterArray);
    }

    private void setFilters(Editable editable, InputFilter[] inputFilterArray) {
        InvokeDynamicSupport.bootstrap("setFilters", $$robo$$android_widget_TextView$setFilters(android.text.Editable android.text.InputFilter[] ), 0, this, editable, inputFilterArray);
    }

    public InputFilter[] getFilters() {
        return InvokeDynamicSupport.bootstrap("getFilters", $$robo$$android_widget_TextView$getFilters(), 0, this);
    }

    private int getBoxHeight(Layout layout2) {
        return (int)InvokeDynamicSupport.bootstrap("getBoxHeight", $$robo$$android_widget_TextView$getBoxHeight(android.text.Layout ), 0, this, layout2);
    }

    int getVerticalOffset(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getVerticalOffset", $$robo$$android_widget_TextView$getVerticalOffset(boolean ), 0, this, bl);
    }

    private int getBottomVerticalOffset(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getBottomVerticalOffset", $$robo$$android_widget_TextView$getBottomVerticalOffset(boolean ), 0, this, bl);
    }

    void invalidateCursorPath() {
        InvokeDynamicSupport.bootstrap("invalidateCursorPath", $$robo$$android_widget_TextView$invalidateCursorPath(), 0, this);
    }

    void invalidateCursor() {
        InvokeDynamicSupport.bootstrap("invalidateCursor", $$robo$$android_widget_TextView$invalidateCursor(), 0, this);
    }

    private void invalidateCursor(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("invalidateCursor", $$robo$$android_widget_TextView$invalidateCursor(int int int ), 0, this, n, n2, n3);
    }

    void invalidateRegion(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("invalidateRegion", $$robo$$android_widget_TextView$invalidateRegion(int int boolean ), 0, this, n, n2, bl);
    }

    private void registerForPreDraw() {
        InvokeDynamicSupport.bootstrap("registerForPreDraw", $$robo$$android_widget_TextView$registerForPreDraw(), 0, this);
    }

    private void unregisterForPreDraw() {
        InvokeDynamicSupport.bootstrap("unregisterForPreDraw", $$robo$$android_widget_TextView$unregisterForPreDraw(), 0, this);
    }

    @Override
    public boolean onPreDraw() {
        return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_widget_TextView$onPreDraw(), 0, this);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_TextView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindowInternal() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindowInternal", $$robo$$android_widget_TextView$onDetachedFromWindowInternal(), 0, this);
    }

    @Override
    public void onScreenStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("onScreenStateChanged", $$robo$$android_widget_TextView$onScreenStateChanged(int ), 0, this, n);
    }

    @Override
    protected boolean isPaddingOffsetRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPaddingOffsetRequired", $$robo$$android_widget_TextView$isPaddingOffsetRequired(), 0, this);
    }

    @Override
    protected int getLeftPaddingOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getLeftPaddingOffset", $$robo$$android_widget_TextView$getLeftPaddingOffset(), 0, this);
    }

    @Override
    protected int getTopPaddingOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getTopPaddingOffset", $$robo$$android_widget_TextView$getTopPaddingOffset(), 0, this);
    }

    @Override
    protected int getBottomPaddingOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getBottomPaddingOffset", $$robo$$android_widget_TextView$getBottomPaddingOffset(), 0, this);
    }

    @Override
    protected int getRightPaddingOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getRightPaddingOffset", $$robo$$android_widget_TextView$getRightPaddingOffset(), 0, this);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_TextView$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_TextView$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_widget_TextView$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public boolean hasOverlappingRendering() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasOverlappingRendering", $$robo$$android_widget_TextView$hasOverlappingRendering(), 0, this);
    }

    public boolean isTextSelectable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTextSelectable", $$robo$$android_widget_TextView$isTextSelectable(), 0, this);
    }

    public void setTextIsSelectable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTextIsSelectable", $$robo$$android_widget_TextView$setTextIsSelectable(boolean ), 0, this, bl);
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_widget_TextView$onCreateDrawableState(int ), 0, this, n);
    }

    private Path getUpdatedHighlightPath() {
        return InvokeDynamicSupport.bootstrap("getUpdatedHighlightPath", $$robo$$android_widget_TextView$getUpdatedHighlightPath(), 0, this);
    }

    public int getHorizontalOffsetForDrawables() {
        return (int)InvokeDynamicSupport.bootstrap("getHorizontalOffsetForDrawables", $$robo$$android_widget_TextView$getHorizontalOffsetForDrawables(), 0, this);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_TextView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public void getFocusedRect(Rect rect) {
        InvokeDynamicSupport.bootstrap("getFocusedRect", $$robo$$android_widget_TextView$getFocusedRect(android.graphics.Rect ), 0, this, rect);
    }

    public int getLineCount() {
        return (int)InvokeDynamicSupport.bootstrap("getLineCount", $$robo$$android_widget_TextView$getLineCount(), 0, this);
    }

    public int getLineBounds(int n, Rect rect) {
        return (int)InvokeDynamicSupport.bootstrap("getLineBounds", $$robo$$android_widget_TextView$getLineBounds(int android.graphics.Rect ), 0, this, n, rect);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_TextView$getBaseline(), 0, this);
    }

    int getBaselineOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getBaselineOffset", $$robo$$android_widget_TextView$getBaselineOffset(), 0, this);
    }

    @Override
    protected int getFadeTop(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getFadeTop", $$robo$$android_widget_TextView$getFadeTop(boolean ), 0, this, bl);
    }

    @Override
    protected int getFadeHeight(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getFadeHeight", $$robo$$android_widget_TextView$getFadeHeight(boolean ), 0, this, bl);
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int n) {
        return InvokeDynamicSupport.bootstrap("onResolvePointerIcon", $$robo$$android_widget_TextView$onResolvePointerIcon(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    @Override
    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyPreIme", $$robo$$android_widget_TextView$onKeyPreIme(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    public boolean handleBackInTextActionModeIfNeeded(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleBackInTextActionModeIfNeeded", $$robo$$android_widget_TextView$handleBackInTextActionModeIfNeeded(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_TextView$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$android_widget_TextView$onKeyMultiple(int int android.view.KeyEvent ), 0, this, n, n2, keyEvent);
    }

    private boolean shouldAdvanceFocusOnEnter() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAdvanceFocusOnEnter", $$robo$$android_widget_TextView$shouldAdvanceFocusOnEnter(), 0, this);
    }

    private boolean shouldAdvanceFocusOnTab() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAdvanceFocusOnTab", $$robo$$android_widget_TextView$shouldAdvanceFocusOnTab(), 0, this);
    }

    private int doKeyDown(int n, KeyEvent keyEvent, KeyEvent keyEvent2) {
        return (int)InvokeDynamicSupport.bootstrap("doKeyDown", $$robo$$android_widget_TextView$doKeyDown(int android.view.KeyEvent android.view.KeyEvent ), 0, this, n, keyEvent, keyEvent2);
    }

    public void resetErrorChangedFlag() {
        InvokeDynamicSupport.bootstrap("resetErrorChangedFlag", $$robo$$android_widget_TextView$resetErrorChangedFlag(), 0, this);
    }

    public void hideErrorIfUnchanged() {
        InvokeDynamicSupport.bootstrap("hideErrorIfUnchanged", $$robo$$android_widget_TextView$hideErrorIfUnchanged(), 0, this);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_widget_TextView$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean onCheckIsTextEditor() {
        return (boolean)InvokeDynamicSupport.bootstrap("onCheckIsTextEditor", $$robo$$android_widget_TextView$onCheckIsTextEditor(), 0, this);
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        return InvokeDynamicSupport.bootstrap("onCreateInputConnection", $$robo$$android_widget_TextView$onCreateInputConnection(android.view.inputmethod.EditorInfo ), 0, this, editorInfo);
    }

    public boolean extractText(ExtractedTextRequest extractedTextRequest, ExtractedText extractedText) {
        return (boolean)InvokeDynamicSupport.bootstrap("extractText", $$robo$$android_widget_TextView$extractText(android.view.inputmethod.ExtractedTextRequest android.view.inputmethod.ExtractedText ), 0, this, extractedTextRequest, extractedText);
    }

    static void removeParcelableSpans(Spannable spannable, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("removeParcelableSpans", $$robo$$android_widget_TextView$removeParcelableSpans(android.text.Spannable int int ), 0, (Spannable)spannable, (int)n, (int)n2);
    }

    public void setExtractedText(ExtractedText extractedText) {
        InvokeDynamicSupport.bootstrap("setExtractedText", $$robo$$android_widget_TextView$setExtractedText(android.view.inputmethod.ExtractedText ), 0, this, extractedText);
    }

    public void setExtracting(ExtractedTextRequest extractedTextRequest) {
        InvokeDynamicSupport.bootstrap("setExtracting", $$robo$$android_widget_TextView$setExtracting(android.view.inputmethod.ExtractedTextRequest ), 0, this, extractedTextRequest);
    }

    public void onCommitCompletion(CompletionInfo completionInfo) {
        InvokeDynamicSupport.bootstrap("onCommitCompletion", $$robo$$android_widget_TextView$onCommitCompletion(android.view.inputmethod.CompletionInfo ), 0, this, completionInfo);
    }

    public void onCommitCorrection(CorrectionInfo correctionInfo) {
        InvokeDynamicSupport.bootstrap("onCommitCorrection", $$robo$$android_widget_TextView$onCommitCorrection(android.view.inputmethod.CorrectionInfo ), 0, this, correctionInfo);
    }

    public void beginBatchEdit() {
        InvokeDynamicSupport.bootstrap("beginBatchEdit", $$robo$$android_widget_TextView$beginBatchEdit(), 0, this);
    }

    public void endBatchEdit() {
        InvokeDynamicSupport.bootstrap("endBatchEdit", $$robo$$android_widget_TextView$endBatchEdit(), 0, this);
    }

    public void onBeginBatchEdit() {
        InvokeDynamicSupport.bootstrap("onBeginBatchEdit", $$robo$$android_widget_TextView$onBeginBatchEdit(), 0, this);
    }

    public void onEndBatchEdit() {
        InvokeDynamicSupport.bootstrap("onEndBatchEdit", $$robo$$android_widget_TextView$onEndBatchEdit(), 0, this);
    }

    public boolean onPrivateIMECommand(String string2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("onPrivateIMECommand", $$robo$$android_widget_TextView$onPrivateIMECommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private void nullLayouts() {
        InvokeDynamicSupport.bootstrap("nullLayouts", $$robo$$android_widget_TextView$nullLayouts(), 0, this);
    }

    private void assumeLayout() {
        InvokeDynamicSupport.bootstrap("assumeLayout", $$robo$$android_widget_TextView$assumeLayout(), 0, this);
    }

    private Layout.Alignment getLayoutAlignment() {
        return InvokeDynamicSupport.bootstrap("getLayoutAlignment", $$robo$$android_widget_TextView$getLayoutAlignment(), 0, this);
    }

    protected void makeNewLayout(int n, int n2, BoringLayout.Metrics metrics, BoringLayout.Metrics metrics2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("makeNewLayout", $$robo$$android_widget_TextView$makeNewLayout(int int android.text.BoringLayout$Metrics android.text.BoringLayout$Metrics int boolean ), 0, this, n, n2, metrics, metrics2, n3, bl);
    }

    protected Layout makeSingleLayout(int n, BoringLayout.Metrics metrics, int n2, Layout.Alignment alignment, boolean bl, TextUtils.TruncateAt truncateAt, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("makeSingleLayout", $$robo$$android_widget_TextView$makeSingleLayout(int android.text.BoringLayout$Metrics int android.text.Layout$Alignment boolean android.text.TextUtils$TruncateAt boolean ), 0, this, n, metrics, n2, alignment, bl, truncateAt, bl2);
    }

    private boolean compressText(float f) {
        return (boolean)InvokeDynamicSupport.bootstrap("compressText", $$robo$$android_widget_TextView$compressText(float ), 0, this, f);
    }

    private static int desired(Layout layout2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("desired", $$robo$$android_widget_TextView$desired(android.text.Layout ), 0, (Layout)layout2);
    }

    public void setIncludeFontPadding(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIncludeFontPadding", $$robo$$android_widget_TextView$setIncludeFontPadding(boolean ), 0, this, bl);
    }

    public boolean getIncludeFontPadding() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIncludeFontPadding", $$robo$$android_widget_TextView$getIncludeFontPadding(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_TextView$onMeasure(int int ), 0, this, n, n2);
    }

    private int getDesiredHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getDesiredHeight", $$robo$$android_widget_TextView$getDesiredHeight(), 0, this);
    }

    private int getDesiredHeight(Layout layout2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getDesiredHeight", $$robo$$android_widget_TextView$getDesiredHeight(android.text.Layout boolean ), 0, this, layout2, bl);
    }

    private void checkForResize() {
        InvokeDynamicSupport.bootstrap("checkForResize", $$robo$$android_widget_TextView$checkForResize(), 0, this);
    }

    private void checkForRelayout() {
        InvokeDynamicSupport.bootstrap("checkForRelayout", $$robo$$android_widget_TextView$checkForRelayout(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_TextView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    private boolean isShowingHint() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowingHint", $$robo$$android_widget_TextView$isShowingHint(), 0, this);
    }

    private boolean bringTextIntoView() {
        return (boolean)InvokeDynamicSupport.bootstrap("bringTextIntoView", $$robo$$android_widget_TextView$bringTextIntoView(), 0, this);
    }

    public boolean bringPointIntoView(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("bringPointIntoView", $$robo$$android_widget_TextView$bringPointIntoView(int ), 0, this, n);
    }

    public boolean moveCursorToVisibleOffset() {
        return (boolean)InvokeDynamicSupport.bootstrap("moveCursorToVisibleOffset", $$robo$$android_widget_TextView$moveCursorToVisibleOffset(), 0, this);
    }

    @Override
    public void computeScroll() {
        InvokeDynamicSupport.bootstrap("computeScroll", $$robo$$android_widget_TextView$computeScroll(), 0, this);
    }

    private void getInterestingRect(Rect rect, int n) {
        InvokeDynamicSupport.bootstrap("getInterestingRect", $$robo$$android_widget_TextView$getInterestingRect(android.graphics.Rect int ), 0, this, rect, n);
    }

    private void convertFromViewportToContentCoordinates(Rect rect) {
        InvokeDynamicSupport.bootstrap("convertFromViewportToContentCoordinates", $$robo$$android_widget_TextView$convertFromViewportToContentCoordinates(android.graphics.Rect ), 0, this, rect);
    }

    int viewportToContentHorizontalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("viewportToContentHorizontalOffset", $$robo$$android_widget_TextView$viewportToContentHorizontalOffset(), 0, this);
    }

    int viewportToContentVerticalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("viewportToContentVerticalOffset", $$robo$$android_widget_TextView$viewportToContentVerticalOffset(), 0, this);
    }

    @Override
    public void debug(int n) {
        InvokeDynamicSupport.bootstrap("debug", $$robo$$android_widget_TextView$debug(int ), 0, this, n);
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionStart() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionStart", $$robo$$android_widget_TextView$getSelectionStart(), 0, this);
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionEnd", $$robo$$android_widget_TextView$getSelectionEnd(), 0, this);
    }

    public boolean hasSelection() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSelection", $$robo$$android_widget_TextView$hasSelection(), 0, this);
    }

    String getSelectedText() {
        return InvokeDynamicSupport.bootstrap("getSelectedText", $$robo$$android_widget_TextView$getSelectedText(), 0, this);
    }

    public void setSingleLine() {
        InvokeDynamicSupport.bootstrap("setSingleLine", $$robo$$android_widget_TextView$setSingleLine(), 0, this);
    }

    public void setAllCaps(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllCaps", $$robo$$android_widget_TextView$setAllCaps(boolean ), 0, this, bl);
    }

    @RemotableViewMethod
    public void setSingleLine(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSingleLine", $$robo$$android_widget_TextView$setSingleLine(boolean ), 0, this, bl);
    }

    private void setInputTypeSingleLine(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInputTypeSingleLine", $$robo$$android_widget_TextView$setInputTypeSingleLine(boolean ), 0, this, bl);
    }

    private void applySingleLine(boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("applySingleLine", $$robo$$android_widget_TextView$applySingleLine(boolean boolean boolean ), 0, this, bl, bl2, bl3);
    }

    public void setEllipsize(TextUtils.TruncateAt truncateAt) {
        InvokeDynamicSupport.bootstrap("setEllipsize", $$robo$$android_widget_TextView$setEllipsize(android.text.TextUtils$TruncateAt ), 0, this, truncateAt);
    }

    public void setMarqueeRepeatLimit(int n) {
        InvokeDynamicSupport.bootstrap("setMarqueeRepeatLimit", $$robo$$android_widget_TextView$setMarqueeRepeatLimit(int ), 0, this, n);
    }

    public int getMarqueeRepeatLimit() {
        return (int)InvokeDynamicSupport.bootstrap("getMarqueeRepeatLimit", $$robo$$android_widget_TextView$getMarqueeRepeatLimit(), 0, this);
    }

    @ViewDebug.ExportedProperty
    public TextUtils.TruncateAt getEllipsize() {
        return InvokeDynamicSupport.bootstrap("getEllipsize", $$robo$$android_widget_TextView$getEllipsize(), 0, this);
    }

    @RemotableViewMethod
    public void setSelectAllOnFocus(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSelectAllOnFocus", $$robo$$android_widget_TextView$setSelectAllOnFocus(boolean ), 0, this, bl);
    }

    @RemotableViewMethod
    public void setCursorVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCursorVisible", $$robo$$android_widget_TextView$setCursorVisible(boolean ), 0, this, bl);
    }

    public boolean isCursorVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCursorVisible", $$robo$$android_widget_TextView$isCursorVisible(), 0, this);
    }

    private boolean canMarquee() {
        return (boolean)InvokeDynamicSupport.bootstrap("canMarquee", $$robo$$android_widget_TextView$canMarquee(), 0, this);
    }

    private void startMarquee() {
        InvokeDynamicSupport.bootstrap("startMarquee", $$robo$$android_widget_TextView$startMarquee(), 0, this);
    }

    private void stopMarquee() {
        InvokeDynamicSupport.bootstrap("stopMarquee", $$robo$$android_widget_TextView$stopMarquee(), 0, this);
    }

    private void startStopMarquee(boolean bl) {
        InvokeDynamicSupport.bootstrap("startStopMarquee", $$robo$$android_widget_TextView$startStopMarquee(boolean ), 0, this, bl);
    }

    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_widget_TextView$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    protected void onSelectionChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onSelectionChanged", $$robo$$android_widget_TextView$onSelectionChanged(int int ), 0, this, n, n2);
    }

    public void addTextChangedListener(TextWatcher textWatcher) {
        InvokeDynamicSupport.bootstrap("addTextChangedListener", $$robo$$android_widget_TextView$addTextChangedListener(android.text.TextWatcher ), 0, this, textWatcher);
    }

    public void removeTextChangedListener(TextWatcher textWatcher) {
        InvokeDynamicSupport.bootstrap("removeTextChangedListener", $$robo$$android_widget_TextView$removeTextChangedListener(android.text.TextWatcher ), 0, this, textWatcher);
    }

    private void sendBeforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendBeforeTextChanged", $$robo$$android_widget_TextView$sendBeforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    private <T> void removeIntersectingNonAdjacentSpans(int n, int n2, Class<T> clazz) {
        InvokeDynamicSupport.bootstrap("removeIntersectingNonAdjacentSpans", $$robo$$android_widget_TextView$removeIntersectingNonAdjacentSpans(int int java.lang.Class<T> ), 0, this, n, n2, clazz);
    }

    void removeAdjacentSuggestionSpans(int n) {
        InvokeDynamicSupport.bootstrap("removeAdjacentSuggestionSpans", $$robo$$android_widget_TextView$removeAdjacentSuggestionSpans(int ), 0, this, n);
    }

    void sendOnTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendOnTextChanged", $$robo$$android_widget_TextView$sendOnTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    void sendAfterTextChanged(Editable editable) {
        InvokeDynamicSupport.bootstrap("sendAfterTextChanged", $$robo$$android_widget_TextView$sendAfterTextChanged(android.text.Editable ), 0, this, editable);
    }

    void updateAfterEdit() {
        InvokeDynamicSupport.bootstrap("updateAfterEdit", $$robo$$android_widget_TextView$updateAfterEdit(), 0, this);
    }

    void handleTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("handleTextChanged", $$robo$$android_widget_TextView$handleTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    void spanChange(Spanned spanned, Object object, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("spanChange", $$robo$$android_widget_TextView$spanChange(android.text.Spanned java.lang.Object int int int int ), 0, this, spanned, object, n, n2, n3, n4);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$android_widget_TextView$onFocusChanged(boolean int android.graphics.Rect ), 0, this, bl, n, rect);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$android_widget_TextView$onWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$android_widget_TextView$onVisibilityChanged(android.view.View int ), 0, this, view, n);
    }

    public void clearComposingText() {
        InvokeDynamicSupport.bootstrap("clearComposingText", $$robo$$android_widget_TextView$clearComposingText(), 0, this);
    }

    @Override
    public void setSelected(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSelected", $$robo$$android_widget_TextView$setSelected(boolean ), 0, this, bl);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_TextView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_widget_TextView$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    protected void onCreateContextMenu(ContextMenu contextMenu) {
        InvokeDynamicSupport.bootstrap("onCreateContextMenu", $$robo$$android_widget_TextView$onCreateContextMenu(android.view.ContextMenu ), 0, this, contextMenu);
    }

    @Override
    public boolean showContextMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenu", $$robo$$android_widget_TextView$showContextMenu(), 0, this);
    }

    @Override
    public boolean showContextMenu(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenu", $$robo$$android_widget_TextView$showContextMenu(float float ), 0, this, f, f2);
    }

    boolean isTextEditable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTextEditable", $$robo$$android_widget_TextView$isTextEditable(), 0, this);
    }

    public boolean didTouchFocusSelect() {
        return (boolean)InvokeDynamicSupport.bootstrap("didTouchFocusSelect", $$robo$$android_widget_TextView$didTouchFocusSelect(), 0, this);
    }

    @Override
    public void cancelLongPress() {
        InvokeDynamicSupport.bootstrap("cancelLongPress", $$robo$$android_widget_TextView$cancelLongPress(), 0, this);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$android_widget_TextView$onTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public void setScroller(Scroller scroller) {
        InvokeDynamicSupport.bootstrap("setScroller", $$robo$$android_widget_TextView$setScroller(android.widget.Scroller ), 0, this, scroller);
    }

    @Override
    protected float getLeftFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getLeftFadingEdgeStrength", $$robo$$android_widget_TextView$getLeftFadingEdgeStrength(), 0, this);
    }

    @Override
    protected float getRightFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getRightFadingEdgeStrength", $$robo$$android_widget_TextView$getRightFadingEdgeStrength(), 0, this);
    }

    private float getHorizontalFadingEdgeStrength(float f, float f2) {
        return (float)InvokeDynamicSupport.bootstrap("getHorizontalFadingEdgeStrength", $$robo$$android_widget_TextView$getHorizontalFadingEdgeStrength(float float ), 0, this, f, f2);
    }

    private boolean isMarqueeFadeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMarqueeFadeEnabled", $$robo$$android_widget_TextView$isMarqueeFadeEnabled(), 0, this);
    }

    @Override
    protected int computeHorizontalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollRange", $$robo$$android_widget_TextView$computeHorizontalScrollRange(), 0, this);
    }

    @Override
    protected int computeVerticalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollRange", $$robo$$android_widget_TextView$computeVerticalScrollRange(), 0, this);
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return (int)InvokeDynamicSupport.bootstrap("computeVerticalScrollExtent", $$robo$$android_widget_TextView$computeVerticalScrollExtent(), 0, this);
    }

    @Override
    public void findViewsWithText(ArrayList<View> arrayList, CharSequence charSequence, int n) {
        InvokeDynamicSupport.bootstrap("findViewsWithText", $$robo$$android_widget_TextView$findViewsWithText(java.util.ArrayList<android.view.View> java.lang.CharSequence int ), 0, this, arrayList, charSequence, n);
    }

    public static ColorStateList getTextColors(Context context, TypedArray typedArray) {
        return InvokeDynamicSupport.bootstrapStatic("getTextColors", $$robo$$android_widget_TextView$getTextColors(android.content.Context android.content.res.TypedArray ), 0, (Context)context, (TypedArray)typedArray);
    }

    public static int getTextColor(Context context, TypedArray typedArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTextColor", $$robo$$android_widget_TextView$getTextColor(android.content.Context android.content.res.TypedArray int ), 0, (Context)context, (TypedArray)typedArray, (int)n);
    }

    @Override
    public boolean onKeyShortcut(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyShortcut", $$robo$$android_widget_TextView$onKeyShortcut(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    boolean canSelectText() {
        return (boolean)InvokeDynamicSupport.bootstrap("canSelectText", $$robo$$android_widget_TextView$canSelectText(), 0, this);
    }

    boolean textCanBeSelected() {
        return (boolean)InvokeDynamicSupport.bootstrap("textCanBeSelected", $$robo$$android_widget_TextView$textCanBeSelected(), 0, this);
    }

    private Locale getTextServicesLocale(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getTextServicesLocale", $$robo$$android_widget_TextView$getTextServicesLocale(boolean ), 0, this, bl);
    }

    public Locale getTextServicesLocale() {
        return InvokeDynamicSupport.bootstrap("getTextServicesLocale", $$robo$$android_widget_TextView$getTextServicesLocale(), 0, this);
    }

    public boolean isInExtractedMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInExtractedMode", $$robo$$android_widget_TextView$isInExtractedMode(), 0, this);
    }

    public Locale getSpellCheckerLocale() {
        return InvokeDynamicSupport.bootstrap("getSpellCheckerLocale", $$robo$$android_widget_TextView$getSpellCheckerLocale(), 0, this);
    }

    private void updateTextServicesLocaleAsync() {
        InvokeDynamicSupport.bootstrap("updateTextServicesLocaleAsync", $$robo$$android_widget_TextView$updateTextServicesLocaleAsync(), 0, this);
    }

    private void updateTextServicesLocaleLocked() {
        InvokeDynamicSupport.bootstrap("updateTextServicesLocaleLocked", $$robo$$android_widget_TextView$updateTextServicesLocaleLocked(), 0, this);
    }

    void onLocaleChanged() {
        InvokeDynamicSupport.bootstrap("onLocaleChanged", $$robo$$android_widget_TextView$onLocaleChanged(), 0, this);
    }

    public WordIterator getWordIterator() {
        return InvokeDynamicSupport.bootstrap("getWordIterator", $$robo$$android_widget_TextView$getWordIterator(), 0, this);
    }

    @Override
    public void onPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEventInternal", $$robo$$android_widget_TextView$onPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    private boolean shouldSpeakPasswordsForAccessibility() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldSpeakPasswordsForAccessibility", $$robo$$android_widget_TextView$shouldSpeakPasswordsForAccessibility(), 0, this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_TextView$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onProvideStructure(ViewStructure viewStructure) {
        InvokeDynamicSupport.bootstrap("onProvideStructure", $$robo$$android_widget_TextView$onProvideStructure(android.view.ViewStructure ), 0, this, viewStructure);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_TextView$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_TextView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$android_widget_TextView$performAccessibilityActionInternal(int android.os.Bundle ), 0, this, n, bundle);
    }

    private boolean performAccessibilityActionClick(Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionClick", $$robo$$android_widget_TextView$performAccessibilityActionClick(android.os.Bundle ), 0, this, bundle);
    }

    private boolean hasSpannableText() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSpannableText", $$robo$$android_widget_TextView$hasSpannableText(), 0, this);
    }

    @Override
    public void sendAccessibilityEventInternal(int n) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEventInternal", $$robo$$android_widget_TextView$sendAccessibilityEventInternal(int ), 0, this, n);
    }

    private CharSequence getTextForAccessibility() {
        return InvokeDynamicSupport.bootstrap("getTextForAccessibility", $$robo$$android_widget_TextView$getTextForAccessibility(), 0, this);
    }

    void sendAccessibilityEventTypeViewTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEventTypeViewTextChanged", $$robo$$android_widget_TextView$sendAccessibilityEventTypeViewTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    public boolean isInputMethodTarget() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputMethodTarget", $$robo$$android_widget_TextView$isInputMethodTarget(), 0, this);
    }

    public boolean onTextContextMenuItem(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTextContextMenuItem", $$robo$$android_widget_TextView$onTextContextMenuItem(int ), 0, this, n);
    }

    CharSequence getTransformedText(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getTransformedText", $$robo$$android_widget_TextView$getTransformedText(int int ), 0, this, n, n2);
    }

    @Override
    public boolean performLongClick() {
        return (boolean)InvokeDynamicSupport.bootstrap("performLongClick", $$robo$$android_widget_TextView$performLongClick(), 0, this);
    }

    @Override
    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onScrollChanged", $$robo$$android_widget_TextView$onScrollChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    public boolean isSuggestionsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSuggestionsEnabled", $$robo$$android_widget_TextView$isSuggestionsEnabled(), 0, this);
    }

    public void setCustomSelectionActionModeCallback(ActionMode.Callback callback) {
        InvokeDynamicSupport.bootstrap("setCustomSelectionActionModeCallback", $$robo$$android_widget_TextView$setCustomSelectionActionModeCallback(android.view.ActionMode$Callback ), 0, this, callback);
    }

    public ActionMode.Callback getCustomSelectionActionModeCallback() {
        return InvokeDynamicSupport.bootstrap("getCustomSelectionActionModeCallback", $$robo$$android_widget_TextView$getCustomSelectionActionModeCallback(), 0, this);
    }

    public void setCustomInsertionActionModeCallback(ActionMode.Callback callback) {
        InvokeDynamicSupport.bootstrap("setCustomInsertionActionModeCallback", $$robo$$android_widget_TextView$setCustomInsertionActionModeCallback(android.view.ActionMode$Callback ), 0, this, callback);
    }

    public ActionMode.Callback getCustomInsertionActionModeCallback() {
        return InvokeDynamicSupport.bootstrap("getCustomInsertionActionModeCallback", $$robo$$android_widget_TextView$getCustomInsertionActionModeCallback(), 0, this);
    }

    protected void stopTextActionMode() {
        InvokeDynamicSupport.bootstrap("stopTextActionMode", $$robo$$android_widget_TextView$stopTextActionMode(), 0, this);
    }

    boolean canUndo() {
        return (boolean)InvokeDynamicSupport.bootstrap("canUndo", $$robo$$android_widget_TextView$canUndo(), 0, this);
    }

    boolean canRedo() {
        return (boolean)InvokeDynamicSupport.bootstrap("canRedo", $$robo$$android_widget_TextView$canRedo(), 0, this);
    }

    boolean canCut() {
        return (boolean)InvokeDynamicSupport.bootstrap("canCut", $$robo$$android_widget_TextView$canCut(), 0, this);
    }

    boolean canCopy() {
        return (boolean)InvokeDynamicSupport.bootstrap("canCopy", $$robo$$android_widget_TextView$canCopy(), 0, this);
    }

    boolean canShare() {
        return (boolean)InvokeDynamicSupport.bootstrap("canShare", $$robo$$android_widget_TextView$canShare(), 0, this);
    }

    boolean isDeviceProvisioned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceProvisioned", $$robo$$android_widget_TextView$isDeviceProvisioned(), 0, this);
    }

    boolean canPaste() {
        return (boolean)InvokeDynamicSupport.bootstrap("canPaste", $$robo$$android_widget_TextView$canPaste(), 0, this);
    }

    boolean canProcessText() {
        return (boolean)InvokeDynamicSupport.bootstrap("canProcessText", $$robo$$android_widget_TextView$canProcessText(), 0, this);
    }

    boolean canSelectAllText() {
        return (boolean)InvokeDynamicSupport.bootstrap("canSelectAllText", $$robo$$android_widget_TextView$canSelectAllText(), 0, this);
    }

    boolean selectAllText() {
        return (boolean)InvokeDynamicSupport.bootstrap("selectAllText", $$robo$$android_widget_TextView$selectAllText(), 0, this);
    }

    void replaceSelectionWithText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("replaceSelectionWithText", $$robo$$android_widget_TextView$replaceSelectionWithText(java.lang.CharSequence ), 0, this, charSequence);
    }

    private void paste(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("paste", $$robo$$android_widget_TextView$paste(int int boolean ), 0, this, n, n2, bl);
    }

    private void shareSelectedText() {
        InvokeDynamicSupport.bootstrap("shareSelectedText", $$robo$$android_widget_TextView$shareSelectedText(), 0, this);
    }

    private void setPrimaryClip(ClipData clipData) {
        InvokeDynamicSupport.bootstrap("setPrimaryClip", $$robo$$android_widget_TextView$setPrimaryClip(android.content.ClipData ), 0, this, clipData);
    }

    public int getOffsetForPosition(float f, float f2) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetForPosition", $$robo$$android_widget_TextView$getOffsetForPosition(float float ), 0, this, f, f2);
    }

    float convertToLocalHorizontalCoordinate(float f) {
        return (float)InvokeDynamicSupport.bootstrap("convertToLocalHorizontalCoordinate", $$robo$$android_widget_TextView$convertToLocalHorizontalCoordinate(float ), 0, this, f);
    }

    int getLineAtCoordinate(float f) {
        return (int)InvokeDynamicSupport.bootstrap("getLineAtCoordinate", $$robo$$android_widget_TextView$getLineAtCoordinate(float ), 0, this, f);
    }

    int getLineAtCoordinateUnclamped(float f) {
        return (int)InvokeDynamicSupport.bootstrap("getLineAtCoordinateUnclamped", $$robo$$android_widget_TextView$getLineAtCoordinateUnclamped(float ), 0, this, f);
    }

    int getOffsetAtCoordinate(int n, float f) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetAtCoordinate", $$robo$$android_widget_TextView$getOffsetAtCoordinate(int float ), 0, this, n, f);
    }

    @Override
    public boolean onDragEvent(DragEvent dragEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onDragEvent", $$robo$$android_widget_TextView$onDragEvent(android.view.DragEvent ), 0, this, dragEvent);
    }

    boolean isInBatchEditMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInBatchEditMode", $$robo$$android_widget_TextView$isInBatchEditMode(), 0, this);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_TextView$onRtlPropertiesChanged(int ), 0, this, n);
    }

    protected TextDirectionHeuristic getTextDirectionHeuristic() {
        return InvokeDynamicSupport.bootstrap("getTextDirectionHeuristic", $$robo$$android_widget_TextView$getTextDirectionHeuristic(), 0, this);
    }

    @Override
    public void onResolveDrawables(int n) {
        InvokeDynamicSupport.bootstrap("onResolveDrawables", $$robo$$android_widget_TextView$onResolveDrawables(int ), 0, this, n);
    }

    private void prepareDrawableForDisplay(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("prepareDrawableForDisplay", $$robo$$android_widget_TextView$prepareDrawableForDisplay(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    protected void resetResolvedDrawables() {
        InvokeDynamicSupport.bootstrap("resetResolvedDrawables", $$robo$$android_widget_TextView$resetResolvedDrawables(), 0, this);
    }

    protected void viewClicked(InputMethodManager inputMethodManager) {
        InvokeDynamicSupport.bootstrap("viewClicked", $$robo$$android_widget_TextView$viewClicked(android.view.inputmethod.InputMethodManager ), 0, this, inputMethodManager);
    }

    protected void deleteText_internal(int n, int n2) {
        InvokeDynamicSupport.bootstrap("deleteText_internal", $$robo$$android_widget_TextView$deleteText_internal(int int ), 0, this, n, n2);
    }

    protected void replaceText_internal(int n, int n2, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("replaceText_internal", $$robo$$android_widget_TextView$replaceText_internal(int int java.lang.CharSequence ), 0, this, n, n2, charSequence);
    }

    protected void setSpan_internal(Object object, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setSpan_internal", $$robo$$android_widget_TextView$setSpan_internal(java.lang.Object int int int ), 0, this, object, n, n2, n3);
    }

    protected void setCursorPosition_internal(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setCursorPosition_internal", $$robo$$android_widget_TextView$setCursorPosition_internal(int int ), 0, this, n, n2);
    }

    private void createEditorIfNeeded() {
        InvokeDynamicSupport.bootstrap("createEditorIfNeeded", $$robo$$android_widget_TextView$createEditorIfNeeded(), 0, this);
    }

    @Override
    public CharSequence getIterableTextForAccessibility() {
        return InvokeDynamicSupport.bootstrap("getIterableTextForAccessibility", $$robo$$android_widget_TextView$getIterableTextForAccessibility(), 0, this);
    }

    private void ensureIterableTextForAccessibilitySelectable() {
        InvokeDynamicSupport.bootstrap("ensureIterableTextForAccessibilitySelectable", $$robo$$android_widget_TextView$ensureIterableTextForAccessibilitySelectable(), 0, this);
    }

    @Override
    public AccessibilityIterators.TextSegmentIterator getIteratorForGranularity(int n) {
        return InvokeDynamicSupport.bootstrap("getIteratorForGranularity", $$robo$$android_widget_TextView$getIteratorForGranularity(int ), 0, this, n);
    }

    @Override
    public int getAccessibilitySelectionStart() {
        return (int)InvokeDynamicSupport.bootstrap("getAccessibilitySelectionStart", $$robo$$android_widget_TextView$getAccessibilitySelectionStart(), 0, this);
    }

    @Override
    public boolean isAccessibilitySelectionExtendable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilitySelectionExtendable", $$robo$$android_widget_TextView$isAccessibilitySelectionExtendable(), 0, this);
    }

    @Override
    public int getAccessibilitySelectionEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getAccessibilitySelectionEnd", $$robo$$android_widget_TextView$getAccessibilitySelectionEnd(), 0, this);
    }

    @Override
    public void setAccessibilitySelection(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setAccessibilitySelection", $$robo$$android_widget_TextView$setAccessibilitySelection(int int ), 0, this, n, n2);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_TextView$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
    }

    static {
        RobolectricInternals.classInitializing(TextView.class);
    }

    public /* synthetic */ TextView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ChangeWatcher
    implements TextWatcher,
    SpanWatcher,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mBeforeText;
        /* synthetic */ TextView this$0;

        private void $$robo$$android_widget_TextView_ChangeWatcher$__constructor__(TextView textView) {
        }

        private final void $$robo$$android_widget_TextView_ChangeWatcher$beforeTextChanged(CharSequence buffer, int start, int before, int after) {
            if (AccessibilityManager.getInstance(this.this$0.mContext).isEnabled() && (!TextView.isPasswordInputType(this.this$0.getInputType()) && !this.this$0.hasPasswordTransformationMethod() || this.this$0.shouldSpeakPasswordsForAccessibility())) {
                this.mBeforeText = buffer.toString();
            }
            this.this$0.sendBeforeTextChanged(buffer, start, before, after);
        }

        private final void $$robo$$android_widget_TextView_ChangeWatcher$onTextChanged(CharSequence buffer, int start, int before, int after) {
            this.this$0.handleTextChanged(buffer, start, before, after);
            if (AccessibilityManager.getInstance(this.this$0.mContext).isEnabled() && (this.this$0.isFocused() || this.this$0.isSelected() && this.this$0.isShown())) {
                this.this$0.sendAccessibilityEventTypeViewTextChanged(this.mBeforeText, start, before, after);
                this.mBeforeText = null;
            }
        }

        private final void $$robo$$android_widget_TextView_ChangeWatcher$afterTextChanged(Editable buffer) {
            this.this$0.sendAfterTextChanged(buffer);
            if (MetaKeyKeyListener.getMetaState((CharSequence)buffer, 2048) != 0) {
                MetaKeyKeyListener.stopSelecting(this.this$0, buffer);
            }
        }

        private final void $$robo$$android_widget_TextView_ChangeWatcher$onSpanChanged(Spannable buf, Object what, int s, int e, int st, int en) {
            this.this$0.spanChange(buf, what, s, st, e, en);
        }

        private final void $$robo$$android_widget_TextView_ChangeWatcher$onSpanAdded(Spannable buf, Object what, int s, int e) {
            this.this$0.spanChange(buf, what, -1, s, -1, e);
        }

        private final void $$robo$$android_widget_TextView_ChangeWatcher$onSpanRemoved(Spannable buf, Object what, int s, int e) {
            this.this$0.spanChange(buf, what, s, -1, e, -1);
        }

        private /* synthetic */ void $$robo$$android_widget_TextView_ChangeWatcher$__constructor__(TextView x0, 1 x1) {
        }

        private void __constructor__(TextView textView) {
            this.$$robo$$android_widget_TextView_ChangeWatcher$__constructor__(textView);
        }

        private ChangeWatcher(TextView textView) {
            this.this$0 = textView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_ChangeWatcher$__constructor__(android.widget.TextView ), 0, this, textView);
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$android_widget_TextView_ChangeWatcher$beforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_widget_TextView_ChangeWatcher$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
        }

        @Override
        public void afterTextChanged(Editable editable) {
            InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$android_widget_TextView_ChangeWatcher$afterTextChanged(android.text.Editable ), 0, this, editable);
        }

        @Override
        public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onSpanChanged", $$robo$$android_widget_TextView_ChangeWatcher$onSpanChanged(android.text.Spannable java.lang.Object int int int int ), 0, this, spannable, object, n, n2, n3, n4);
        }

        @Override
        public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSpanAdded", $$robo$$android_widget_TextView_ChangeWatcher$onSpanAdded(android.text.Spannable java.lang.Object int int ), 0, this, spannable, object, n, n2);
        }

        @Override
        public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSpanRemoved", $$robo$$android_widget_TextView_ChangeWatcher$onSpanRemoved(android.text.Spannable java.lang.Object int int ), 0, this, spannable, object, n, n2);
        }

        private /* synthetic */ void __constructor__(TextView textView, 1 var2_2) {
            this.$$robo$$android_widget_TextView_ChangeWatcher$__constructor__(textView, var2_2);
        }

        public /* synthetic */ ChangeWatcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChangeWatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Marquee
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static float MARQUEE_DELTA_MAX = 0.07f;
        private static int MARQUEE_DELAY = 1200;
        private static int MARQUEE_DP_PER_SECOND = 30;
        private static byte MARQUEE_STOPPED = 0;
        private static byte MARQUEE_STARTING = 1;
        private static byte MARQUEE_RUNNING = 2;
        private WeakReference<TextView> mView;
        private Choreographer mChoreographer;
        private byte mStatus;
        private float mPixelsPerSecond;
        private float mMaxScroll;
        private float mMaxFadeScroll;
        private float mGhostStart;
        private float mGhostOffset;
        private float mFadeStop;
        private int mRepeatLimit;
        private float mScroll;
        private long mLastAnimationMs;
        private Choreographer.FrameCallback mTickCallback;
        private Choreographer.FrameCallback mStartCallback;
        private Choreographer.FrameCallback mRestartCallback;

        private void $$robo$$android_widget_TextView_Marquee$__constructor__(TextView v) {
            this.mStatus = 0;
            this.mTickCallback = new Choreographer.FrameCallback(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Marquee this$0;

                private void $$robo$$android_widget_TextView_Marquee_1$__constructor__(Marquee this$0) {
                }

                private final void $$robo$$android_widget_TextView_Marquee_1$doFrame(long frameTimeNanos) {
                    this.this$0.tick();
                }

                private void __constructor__(Marquee marquee) {
                    this.$$robo$$android_widget_TextView_Marquee_1$__constructor__(marquee);
                }
                {
                    this.this$0 = marquee;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_Marquee_1$__constructor__(android.widget.TextView$Marquee ), 0, this, marquee);
                }

                @Override
                public void doFrame(long l) {
                    InvokeDynamicSupport.bootstrap("doFrame", $$robo$$android_widget_TextView_Marquee_1$doFrame(long ), 0, this, l);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mStartCallback = new Choreographer.FrameCallback(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Marquee this$0;

                private void $$robo$$android_widget_TextView_Marquee_2$__constructor__(Marquee this$0) {
                }

                private final void $$robo$$android_widget_TextView_Marquee_2$doFrame(long frameTimeNanos) {
                    this.this$0.mStatus = (byte)2;
                    this.this$0.mLastAnimationMs = this.this$0.mChoreographer.getFrameTime();
                    this.this$0.tick();
                }

                private void __constructor__(Marquee marquee) {
                    this.$$robo$$android_widget_TextView_Marquee_2$__constructor__(marquee);
                }
                {
                    this.this$0 = marquee;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_Marquee_2$__constructor__(android.widget.TextView$Marquee ), 0, this, marquee);
                }

                @Override
                public void doFrame(long l) {
                    InvokeDynamicSupport.bootstrap("doFrame", $$robo$$android_widget_TextView_Marquee_2$doFrame(long ), 0, this, l);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mRestartCallback = new Choreographer.FrameCallback(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Marquee this$0;

                private void $$robo$$android_widget_TextView_Marquee_3$__constructor__(Marquee this$0) {
                }

                private final void $$robo$$android_widget_TextView_Marquee_3$doFrame(long frameTimeNanos) {
                    if (this.this$0.mStatus == 2) {
                        if (this.this$0.mRepeatLimit >= 0) {
                            this.this$0.mRepeatLimit--;
                        }
                        this.this$0.start(this.this$0.mRepeatLimit);
                    }
                }

                private void __constructor__(Marquee marquee) {
                    this.$$robo$$android_widget_TextView_Marquee_3$__constructor__(marquee);
                }
                {
                    this.this$0 = marquee;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_Marquee_3$__constructor__(android.widget.TextView$Marquee ), 0, this, marquee);
                }

                @Override
                public void doFrame(long l) {
                    InvokeDynamicSupport.bootstrap("doFrame", $$robo$$android_widget_TextView_Marquee_3$doFrame(long ), 0, this, l);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            float density = v.getContext().getResources().getDisplayMetrics().density;
            this.mPixelsPerSecond = 30.0f * density;
            this.mView = new WeakReference<TextView>(v);
            this.mChoreographer = Choreographer.getInstance();
        }

        private final void $$robo$$android_widget_TextView_Marquee$tick() {
            if (this.mStatus != 2) {
                return;
            }
            this.mChoreographer.removeFrameCallback(this.mTickCallback);
            TextView textView = (TextView)this.mView.get();
            if (textView != null && (textView.isFocused() || textView.isSelected())) {
                long currentMs = this.mChoreographer.getFrameTime();
                long deltaMs = currentMs - this.mLastAnimationMs;
                this.mLastAnimationMs = currentMs;
                float deltaPx = (float)deltaMs / 1000.0f * this.mPixelsPerSecond;
                this.mScroll += deltaPx;
                if (this.mScroll > this.mMaxScroll) {
                    this.mScroll = this.mMaxScroll;
                    this.mChoreographer.postFrameCallbackDelayed(this.mRestartCallback, 1200L);
                } else {
                    this.mChoreographer.postFrameCallback(this.mTickCallback);
                }
                textView.invalidate();
            }
        }

        private final void $$robo$$android_widget_TextView_Marquee$stop() {
            this.mStatus = 0;
            this.mChoreographer.removeFrameCallback(this.mStartCallback);
            this.mChoreographer.removeFrameCallback(this.mRestartCallback);
            this.mChoreographer.removeFrameCallback(this.mTickCallback);
            this.resetScroll();
        }

        private final void $$robo$$android_widget_TextView_Marquee$resetScroll() {
            this.mScroll = 0.0f;
            TextView textView = (TextView)this.mView.get();
            if (textView != null) {
                textView.invalidate();
            }
        }

        private final void $$robo$$android_widget_TextView_Marquee$start(int repeatLimit) {
            if (repeatLimit == 0) {
                this.stop();
                return;
            }
            this.mRepeatLimit = repeatLimit;
            TextView textView = (TextView)this.mView.get();
            if (textView != null && textView.mLayout != null) {
                this.mStatus = 1;
                this.mScroll = 0.0f;
                int textWidth = textView.getWidth() - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight();
                float lineWidth = textView.mLayout.getLineWidth(0);
                float gap = (float)textWidth / 3.0f;
                this.mGhostStart = lineWidth - (float)textWidth + gap;
                this.mMaxScroll = this.mGhostStart + (float)textWidth;
                this.mGhostOffset = lineWidth + gap;
                this.mFadeStop = lineWidth + (float)textWidth / 6.0f;
                this.mMaxFadeScroll = this.mGhostStart + lineWidth + lineWidth;
                textView.invalidate();
                this.mChoreographer.postFrameCallback(this.mStartCallback);
            }
        }

        private final float $$robo$$android_widget_TextView_Marquee$getGhostOffset() {
            return this.mGhostOffset;
        }

        private final float $$robo$$android_widget_TextView_Marquee$getScroll() {
            return this.mScroll;
        }

        private final float $$robo$$android_widget_TextView_Marquee$getMaxFadeScroll() {
            return this.mMaxFadeScroll;
        }

        private final boolean $$robo$$android_widget_TextView_Marquee$shouldDrawLeftFade() {
            return this.mScroll <= this.mFadeStop;
        }

        private final boolean $$robo$$android_widget_TextView_Marquee$shouldDrawGhost() {
            return this.mStatus == 2 && this.mScroll > this.mGhostStart;
        }

        private final boolean $$robo$$android_widget_TextView_Marquee$isRunning() {
            return this.mStatus == 2;
        }

        private final boolean $$robo$$android_widget_TextView_Marquee$isStopped() {
            return this.mStatus == 0;
        }

        private void __constructor__(TextView textView) {
            this.$$robo$$android_widget_TextView_Marquee$__constructor__(textView);
        }

        Marquee(TextView textView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_Marquee$__constructor__(android.widget.TextView ), 0, this, textView);
        }

        void tick() {
            InvokeDynamicSupport.bootstrap("tick", $$robo$$android_widget_TextView_Marquee$tick(), 0, this);
        }

        void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_widget_TextView_Marquee$stop(), 0, this);
        }

        private void resetScroll() {
            InvokeDynamicSupport.bootstrap("resetScroll", $$robo$$android_widget_TextView_Marquee$resetScroll(), 0, this);
        }

        void start(int n) {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_widget_TextView_Marquee$start(int ), 0, this, n);
        }

        float getGhostOffset() {
            return (float)InvokeDynamicSupport.bootstrap("getGhostOffset", $$robo$$android_widget_TextView_Marquee$getGhostOffset(), 0, this);
        }

        float getScroll() {
            return (float)InvokeDynamicSupport.bootstrap("getScroll", $$robo$$android_widget_TextView_Marquee$getScroll(), 0, this);
        }

        float getMaxFadeScroll() {
            return (float)InvokeDynamicSupport.bootstrap("getMaxFadeScroll", $$robo$$android_widget_TextView_Marquee$getMaxFadeScroll(), 0, this);
        }

        boolean shouldDrawLeftFade() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldDrawLeftFade", $$robo$$android_widget_TextView_Marquee$shouldDrawLeftFade(), 0, this);
        }

        boolean shouldDrawGhost() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldDrawGhost", $$robo$$android_widget_TextView_Marquee$shouldDrawGhost(), 0, this);
        }

        boolean isRunning() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_widget_TextView_Marquee$isRunning(), 0, this);
        }

        boolean isStopped() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStopped", $$robo$$android_widget_TextView_Marquee$isStopped(), 0, this);
        }

        public /* synthetic */ Marquee() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Marquee)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CharWrapper
    implements CharSequence,
    GetChars,
    GraphicsOperations,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private char[] mChars;
        private int mStart;
        private int mLength;

        private void $$robo$$android_widget_TextView_CharWrapper$__constructor__(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        private final void $$robo$$android_widget_TextView_CharWrapper$set(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        private final int $$robo$$android_widget_TextView_CharWrapper$length() {
            return this.mLength;
        }

        private final char $$robo$$android_widget_TextView_CharWrapper$charAt(int off) {
            return this.mChars[off + this.mStart];
        }

        private final String $$robo$$android_widget_TextView_CharWrapper$toString() {
            return new String(this.mChars, this.mStart, this.mLength);
        }

        private final CharSequence $$robo$$android_widget_TextView_CharWrapper$subSequence(int start, int end) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            return new String(this.mChars, start + this.mStart, end - start);
        }

        private final void $$robo$$android_widget_TextView_CharWrapper$getChars(int start, int end, char[] buf, int off) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mChars, (int)(start + this.mStart), (char[])buf, (int)off, (int)(end - start));
        }

        private final void $$robo$$android_widget_TextView_CharWrapper$drawText(Canvas c, int start, int end, float x, float y, Paint p) {
            c.drawText(this.mChars, start + this.mStart, end - start, x, y, p);
        }

        private final void $$robo$$android_widget_TextView_CharWrapper$drawTextRun(Canvas c, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint p) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            c.drawTextRun(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, x, y, isRtl, p);
        }

        private final float $$robo$$android_widget_TextView_CharWrapper$measureText(int start, int end, Paint p) {
            return p.measureText(this.mChars, start + this.mStart, end - start);
        }

        private final int $$robo$$android_widget_TextView_CharWrapper$getTextWidths(int start, int end, float[] widths, Paint p) {
            return p.getTextWidths(this.mChars, start + this.mStart, end - start, widths);
        }

        private final float $$robo$$android_widget_TextView_CharWrapper$getTextRunAdvances(int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex, Paint p) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            return p.getTextRunAdvances(this.mChars, start + this.mStart, count, contextStart + this.mStart, contextCount, isRtl, advances, advancesIndex);
        }

        private final int $$robo$$android_widget_TextView_CharWrapper$getTextRunCursor(int contextStart, int contextEnd, int dir, int offset, int cursorOpt, Paint p) {
            int contextCount = contextEnd - contextStart;
            return p.getTextRunCursor(this.mChars, contextStart + this.mStart, contextCount, dir, offset + this.mStart, cursorOpt);
        }

        static /* synthetic */ char[] access$102(CharWrapper x0, char[] x1) {
            x0.mChars = x1;
            return x1;
        }

        private void __constructor__(char[] cArray, int n, int n2) {
            this.$$robo$$android_widget_TextView_CharWrapper$__constructor__(cArray, n, n2);
        }

        public CharWrapper(char[] cArray, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_CharWrapper$__constructor__(char[] int int ), 0, this, cArray, n, n2);
        }

        void set(char[] cArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_widget_TextView_CharWrapper$set(char[] int int ), 0, this, cArray, n, n2);
        }

        @Override
        public int length() {
            return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_widget_TextView_CharWrapper$length(), 0, this);
        }

        @Override
        public char charAt(int n) {
            return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_widget_TextView_CharWrapper$charAt(int ), 0, this, n);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_TextView_CharWrapper$toString(), 0, this);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_widget_TextView_CharWrapper$subSequence(int int ), 0, this, n, n2);
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            InvokeDynamicSupport.bootstrap("getChars", $$robo$$android_widget_TextView_CharWrapper$getChars(int int char[] int ), 0, this, n, n2, cArray, n3);
        }

        @Override
        public void drawText(Canvas canvas, int n, int n2, float f, float f2, Paint paint) {
            InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_widget_TextView_CharWrapper$drawText(android.graphics.Canvas int int float float android.graphics.Paint ), 0, this, canvas, n, n2, f, f2, paint);
        }

        @Override
        public void drawTextRun(Canvas canvas, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
            InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_widget_TextView_CharWrapper$drawTextRun(android.graphics.Canvas int int int int float float boolean android.graphics.Paint ), 0, this, canvas, n, n2, n3, n4, f, f2, bl, paint);
        }

        @Override
        public float measureText(int n, int n2, Paint paint) {
            return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_widget_TextView_CharWrapper$measureText(int int android.graphics.Paint ), 0, this, n, n2, paint);
        }

        @Override
        public int getTextWidths(int n, int n2, float[] fArray, Paint paint) {
            return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_widget_TextView_CharWrapper$getTextWidths(int int float[] android.graphics.Paint ), 0, this, n, n2, fArray, paint);
        }

        @Override
        public float getTextRunAdvances(int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5, Paint paint) {
            return (float)InvokeDynamicSupport.bootstrap("getTextRunAdvances", $$robo$$android_widget_TextView_CharWrapper$getTextRunAdvances(int int int int boolean float[] int android.graphics.Paint ), 0, this, n, n2, n3, n4, bl, fArray, n5, paint);
        }

        @Override
        public int getTextRunCursor(int n, int n2, int n3, int n4, int n5, Paint paint) {
            return (int)InvokeDynamicSupport.bootstrap("getTextRunCursor", $$robo$$android_widget_TextView_CharWrapper$getTextRunCursor(int int int int int android.graphics.Paint ), 0, this, n, n2, n3, n4, n5, paint);
        }

        public /* synthetic */ CharWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int selStart;
        int selEnd;
        CharSequence text;
        boolean frozenWithFocus;
        CharSequence error;
        ParcelableParcel editorState;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_TextView_SavedState$__constructor__(Parcelable superState) {
            this.selStart = -1;
            this.selEnd = -1;
        }

        private final void $$robo$$android_widget_TextView_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.selStart);
            out.writeInt(this.selEnd);
            out.writeInt(this.frozenWithFocus ? 1 : 0);
            TextUtils.writeToParcel(this.text, out, flags);
            if (this.error == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                TextUtils.writeToParcel(this.error, out, flags);
            }
            if (this.editorState == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                this.editorState.writeToParcel(out, flags);
            }
        }

        private final String $$robo$$android_widget_TextView_SavedState$toString() {
            String str = "TextView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " start=" + this.selStart + " end=" + this.selEnd;
            if (this.text != null) {
                str = str + " text=" + this.text;
            }
            return str + "}";
        }

        private void $$robo$$android_widget_TextView_SavedState$__constructor__(Parcel in) {
            this.selStart = -1;
            this.selEnd = -1;
            this.selStart = in.readInt();
            this.selEnd = in.readInt();
            this.frozenWithFocus = in.readInt() != 0;
            this.text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() != 0) {
                this.error = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
            if (in.readInt() != 0) {
                this.editorState = (ParcelableParcel)ParcelableParcel.CREATOR.createFromParcel(in);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_TextView_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_TextView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_TextView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_TextView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_TextView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_TextView_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_TextView_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_TextView_SavedState$__constructor__(parcelable);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_SavedState$__constructor__(android.os.Parcelable ), 0, this, parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_TextView_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_TextView_SavedState$toString(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_TextView_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_TextView_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class BufferType
    extends Enum<BufferType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ BufferType NORMAL;
        public static /* enum */ BufferType SPANNABLE;
        public static /* enum */ BufferType EDITABLE;
        private static /* synthetic */ BufferType[] $VALUES;

        private static final BufferType[] $$robo$$android_widget_TextView_BufferType$values() {
            return (BufferType[])$VALUES.clone();
        }

        private static final BufferType $$robo$$android_widget_TextView_BufferType$valueOf(String name) {
            return Enum.valueOf(BufferType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_widget_TextView_BufferType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NORMAL = new BufferType();
            SPANNABLE = new BufferType();
            EDITABLE = new BufferType();
            $VALUES = new BufferType[]{NORMAL, SPANNABLE, EDITABLE};
        }

        public static BufferType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_widget_TextView_BufferType$values(), 0);
        }

        public static BufferType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_widget_TextView_BufferType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_widget_TextView_BufferType$__constructor__(string2, n);
        }

        private BufferType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_BufferType$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(BufferType.class);
        }

        public /* synthetic */ BufferType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BufferType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnEditorActionListener
    extends InstrumentedInterface {
        public boolean onEditorAction(TextView var1, int var2, KeyEvent var3);
    }

    public static class Drawables
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int LEFT = 0;
        static int TOP = 1;
        static int RIGHT = 2;
        static int BOTTOM = 3;
        static int DRAWABLE_NONE = -1;
        static int DRAWABLE_RIGHT = 0;
        static int DRAWABLE_LEFT = 1;
        Rect mCompoundRect;
        Drawable[] mShowing;
        ColorStateList mTintList;
        PorterDuff.Mode mTintMode;
        boolean mHasTint;
        boolean mHasTintMode;
        Drawable mDrawableStart;
        Drawable mDrawableEnd;
        Drawable mDrawableError;
        Drawable mDrawableTemp;
        Drawable mDrawableLeftInitial;
        Drawable mDrawableRightInitial;
        boolean mIsRtlCompatibilityMode;
        boolean mOverride;
        int mDrawableSizeTop;
        int mDrawableSizeBottom;
        int mDrawableSizeLeft;
        int mDrawableSizeRight;
        int mDrawableSizeStart;
        int mDrawableSizeEnd;
        int mDrawableSizeError;
        int mDrawableSizeTemp;
        int mDrawableWidthTop;
        int mDrawableWidthBottom;
        int mDrawableHeightLeft;
        int mDrawableHeightRight;
        int mDrawableHeightStart;
        int mDrawableHeightEnd;
        int mDrawableHeightError;
        int mDrawableHeightTemp;
        int mDrawablePadding;
        int mDrawableSaved;

        private void $$robo$$android_widget_TextView_Drawables$__constructor__(Context context) {
            this.mCompoundRect = new Rect();
            this.mShowing = new Drawable[4];
            this.mDrawableSaved = -1;
            int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
            this.mIsRtlCompatibilityMode = targetSdkVersion < 17 || !context.getApplicationInfo().hasRtlSupport();
            this.mOverride = false;
        }

        private final boolean $$robo$$android_widget_TextView_Drawables$hasMetadata() {
            return this.mDrawablePadding != 0 || this.mHasTintMode || this.mHasTint;
        }

        private final boolean $$robo$$android_widget_TextView_Drawables$resolveWithLayoutDirection(int layoutDirection) {
            Drawable previousLeft = this.mShowing[0];
            Drawable previousRight = this.mShowing[2];
            this.mShowing[0] = this.mDrawableLeftInitial;
            this.mShowing[2] = this.mDrawableRightInitial;
            if (this.mIsRtlCompatibilityMode) {
                if (this.mDrawableStart != null && this.mShowing[0] == null) {
                    this.mShowing[0] = this.mDrawableStart;
                    this.mDrawableSizeLeft = this.mDrawableSizeStart;
                    this.mDrawableHeightLeft = this.mDrawableHeightStart;
                }
                if (this.mDrawableEnd != null && this.mShowing[2] == null) {
                    this.mShowing[2] = this.mDrawableEnd;
                    this.mDrawableSizeRight = this.mDrawableSizeEnd;
                    this.mDrawableHeightRight = this.mDrawableHeightEnd;
                }
            } else {
                switch (layoutDirection) {
                    case 1: {
                        if (!this.mOverride) break;
                        this.mShowing[2] = this.mDrawableStart;
                        this.mDrawableSizeRight = this.mDrawableSizeStart;
                        this.mDrawableHeightRight = this.mDrawableHeightStart;
                        this.mShowing[0] = this.mDrawableEnd;
                        this.mDrawableSizeLeft = this.mDrawableSizeEnd;
                        this.mDrawableHeightLeft = this.mDrawableHeightEnd;
                        break;
                    }
                    default: {
                        if (!this.mOverride) break;
                        this.mShowing[0] = this.mDrawableStart;
                        this.mDrawableSizeLeft = this.mDrawableSizeStart;
                        this.mDrawableHeightLeft = this.mDrawableHeightStart;
                        this.mShowing[2] = this.mDrawableEnd;
                        this.mDrawableSizeRight = this.mDrawableSizeEnd;
                        this.mDrawableHeightRight = this.mDrawableHeightEnd;
                    }
                }
            }
            this.applyErrorDrawableIfNeeded(layoutDirection);
            return this.mShowing[0] != previousLeft || this.mShowing[2] != previousRight;
        }

        private final void $$robo$$android_widget_TextView_Drawables$setErrorDrawable(Drawable dr, TextView tv) {
            if (this.mDrawableError != dr && this.mDrawableError != null) {
                this.mDrawableError.setCallback(null);
            }
            this.mDrawableError = dr;
            if (this.mDrawableError != null) {
                Rect compoundRect = this.mCompoundRect;
                int[] state = tv.getDrawableState();
                this.mDrawableError.setState(state);
                this.mDrawableError.copyBounds(compoundRect);
                this.mDrawableError.setCallback(tv);
                this.mDrawableSizeError = compoundRect.width();
                this.mDrawableHeightError = compoundRect.height();
            } else {
                this.mDrawableHeightError = 0;
                this.mDrawableSizeError = 0;
            }
        }

        private final void $$robo$$android_widget_TextView_Drawables$applyErrorDrawableIfNeeded(int layoutDirection) {
            switch (this.mDrawableSaved) {
                case 1: {
                    this.mShowing[0] = this.mDrawableTemp;
                    this.mDrawableSizeLeft = this.mDrawableSizeTemp;
                    this.mDrawableHeightLeft = this.mDrawableHeightTemp;
                    break;
                }
                case 0: {
                    this.mShowing[2] = this.mDrawableTemp;
                    this.mDrawableSizeRight = this.mDrawableSizeTemp;
                    this.mDrawableHeightRight = this.mDrawableHeightTemp;
                    break;
                }
            }
            if (this.mDrawableError != null) {
                switch (layoutDirection) {
                    case 1: {
                        this.mDrawableSaved = 1;
                        this.mDrawableTemp = this.mShowing[0];
                        this.mDrawableSizeTemp = this.mDrawableSizeLeft;
                        this.mDrawableHeightTemp = this.mDrawableHeightLeft;
                        this.mShowing[0] = this.mDrawableError;
                        this.mDrawableSizeLeft = this.mDrawableSizeError;
                        this.mDrawableHeightLeft = this.mDrawableHeightError;
                        break;
                    }
                    default: {
                        this.mDrawableSaved = 0;
                        this.mDrawableTemp = this.mShowing[2];
                        this.mDrawableSizeTemp = this.mDrawableSizeRight;
                        this.mDrawableHeightTemp = this.mDrawableHeightRight;
                        this.mShowing[2] = this.mDrawableError;
                        this.mDrawableSizeRight = this.mDrawableSizeError;
                        this.mDrawableHeightRight = this.mDrawableHeightError;
                    }
                }
            }
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_widget_TextView_Drawables$__constructor__(context);
        }

        public Drawables(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextView_Drawables$__constructor__(android.content.Context ), 0, this, context);
        }

        public boolean hasMetadata() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasMetadata", $$robo$$android_widget_TextView_Drawables$hasMetadata(), 0, this);
        }

        public boolean resolveWithLayoutDirection(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("resolveWithLayoutDirection", $$robo$$android_widget_TextView_Drawables$resolveWithLayoutDirection(int ), 0, this, n);
        }

        public void setErrorDrawable(Drawable drawable2, TextView textView) {
            InvokeDynamicSupport.bootstrap("setErrorDrawable", $$robo$$android_widget_TextView_Drawables$setErrorDrawable(android.graphics.drawable.Drawable android.widget.TextView ), 0, this, drawable2, textView);
        }

        private void applyErrorDrawableIfNeeded(int n) {
            InvokeDynamicSupport.bootstrap("applyErrorDrawableIfNeeded", $$robo$$android_widget_TextView_Drawables$applyErrorDrawableIfNeeded(int ), 0, this, n);
        }

        public /* synthetic */ Drawables() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Drawables)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

