/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.Log;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class OverScroller
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mMode;
    private SplineOverScroller mScrollerX;
    private SplineOverScroller mScrollerY;
    private Interpolator mInterpolator;
    private boolean mFlywheel;
    private static int DEFAULT_DURATION = 250;
    private static int SCROLL_MODE = 0;
    private static int FLING_MODE = 1;

    private void $$robo$$android_widget_OverScroller$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_OverScroller$__constructor__(Context context, Interpolator interpolator2) {
    }

    private void $$robo$$android_widget_OverScroller$__constructor__(Context context, Interpolator interpolator2, boolean flywheel) {
        this.mInterpolator = interpolator2 == null ? new Scroller.ViscousFluidInterpolator() : interpolator2;
        this.mFlywheel = flywheel;
        this.mScrollerX = new SplineOverScroller(context);
        this.mScrollerY = new SplineOverScroller(context);
    }

    private void $$robo$$android_widget_OverScroller$__constructor__(Context context, Interpolator interpolator2, float bounceCoefficientX, float bounceCoefficientY) {
    }

    private void $$robo$$android_widget_OverScroller$__constructor__(Context context, Interpolator interpolator2, float bounceCoefficientX, float bounceCoefficientY, boolean flywheel) {
    }

    private final void $$robo$$android_widget_OverScroller$setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2 == null ? new Scroller.ViscousFluidInterpolator() : interpolator2;
    }

    private final void $$robo$$android_widget_OverScroller$setFriction(float friction) {
        this.mScrollerX.setFriction(friction);
        this.mScrollerY.setFriction(friction);
    }

    private final boolean $$robo$$android_widget_OverScroller$isFinished() {
        return this.mScrollerX.mFinished && this.mScrollerY.mFinished;
    }

    private final void $$robo$$android_widget_OverScroller$forceFinished(boolean finished) {
        this.mScrollerX.mFinished = (this.mScrollerY.mFinished = finished);
    }

    private final int $$robo$$android_widget_OverScroller$getCurrX() {
        return this.mScrollerX.mCurrentPosition;
    }

    private final int $$robo$$android_widget_OverScroller$getCurrY() {
        return this.mScrollerY.mCurrentPosition;
    }

    private final float $$robo$$android_widget_OverScroller$getCurrVelocity() {
        return (float)Math.hypot(this.mScrollerX.mCurrVelocity, this.mScrollerY.mCurrVelocity);
    }

    private final int $$robo$$android_widget_OverScroller$getStartX() {
        return this.mScrollerX.mStart;
    }

    private final int $$robo$$android_widget_OverScroller$getStartY() {
        return this.mScrollerY.mStart;
    }

    private final int $$robo$$android_widget_OverScroller$getFinalX() {
        return this.mScrollerX.mFinal;
    }

    private final int $$robo$$android_widget_OverScroller$getFinalY() {
        return this.mScrollerY.mFinal;
    }

    @Deprecated
    private final int $$robo$$android_widget_OverScroller$getDuration() {
        return Math.max(this.mScrollerX.mDuration, this.mScrollerY.mDuration);
    }

    @Deprecated
    private final void $$robo$$android_widget_OverScroller$extendDuration(int extend) {
        this.mScrollerX.extendDuration(extend);
        this.mScrollerY.extendDuration(extend);
    }

    @Deprecated
    private final void $$robo$$android_widget_OverScroller$setFinalX(int newX) {
        this.mScrollerX.setFinalPosition(newX);
    }

    @Deprecated
    private final void $$robo$$android_widget_OverScroller$setFinalY(int newY) {
        this.mScrollerY.setFinalPosition(newY);
    }

    private final boolean $$robo$$android_widget_OverScroller$computeScrollOffset() {
        if (this.isFinished()) {
            return false;
        }
        switch (this.mMode) {
            case 0: {
                long time = AnimationUtils.currentAnimationTimeMillis();
                long elapsedTime = time - this.mScrollerX.mStartTime;
                int duration = this.mScrollerX.mDuration;
                if (elapsedTime < (long)duration) {
                    float q = this.mInterpolator.getInterpolation((float)elapsedTime / (float)duration);
                    this.mScrollerX.updateScroll(q);
                    this.mScrollerY.updateScroll(q);
                    break;
                }
                this.abortAnimation();
                break;
            }
            case 1: {
                if (!(this.mScrollerX.mFinished || this.mScrollerX.update() || this.mScrollerX.continueWhenFinished())) {
                    this.mScrollerX.finish();
                }
                if (this.mScrollerY.mFinished || this.mScrollerY.update() || this.mScrollerY.continueWhenFinished()) break;
                this.mScrollerY.finish();
            }
        }
        return true;
    }

    private final void $$robo$$android_widget_OverScroller$startScroll(int startX, int startY, int dx, int dy) {
        this.startScroll(startX, startY, dx, dy, 250);
    }

    private final void $$robo$$android_widget_OverScroller$startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.mMode = 0;
        this.mScrollerX.startScroll(startX, dx, duration);
        this.mScrollerY.startScroll(startY, dy, duration);
    }

    private final boolean $$robo$$android_widget_OverScroller$springBack(int startX, int startY, int minX, int maxX, int minY, int maxY) {
        this.mMode = 1;
        boolean spingbackX = this.mScrollerX.springback(startX, minX, maxX);
        boolean spingbackY = this.mScrollerY.springback(startY, minY, maxY);
        return spingbackX || spingbackY;
    }

    private final void $$robo$$android_widget_OverScroller$fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        this.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
    }

    private final void $$robo$$android_widget_OverScroller$fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY, int overX, int overY) {
        if (this.mFlywheel && !this.isFinished()) {
            float oldVelocityX = this.mScrollerX.mCurrVelocity;
            float oldVelocityY = this.mScrollerY.mCurrVelocity;
            if (Math.signum(velocityX) == Math.signum(oldVelocityX) && Math.signum(velocityY) == Math.signum(oldVelocityY)) {
                velocityX = (int)((float)velocityX + oldVelocityX);
                velocityY = (int)((float)velocityY + oldVelocityY);
            }
        }
        this.mMode = 1;
        this.mScrollerX.fling(startX, velocityX, minX, maxX, overX);
        this.mScrollerY.fling(startY, velocityY, minY, maxY, overY);
    }

    private final void $$robo$$android_widget_OverScroller$notifyHorizontalEdgeReached(int startX, int finalX, int overX) {
        this.mScrollerX.notifyEdgeReached(startX, finalX, overX);
    }

    private final void $$robo$$android_widget_OverScroller$notifyVerticalEdgeReached(int startY, int finalY, int overY) {
        this.mScrollerY.notifyEdgeReached(startY, finalY, overY);
    }

    private final boolean $$robo$$android_widget_OverScroller$isOverScrolled() {
        return !this.mScrollerX.mFinished && this.mScrollerX.mState != 0 || !this.mScrollerY.mFinished && this.mScrollerY.mState != 0;
    }

    private final void $$robo$$android_widget_OverScroller$abortAnimation() {
        this.mScrollerX.finish();
        this.mScrollerY.finish();
    }

    private final int $$robo$$android_widget_OverScroller$timePassed() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        long startTime = Math.min(this.mScrollerX.mStartTime, this.mScrollerY.mStartTime);
        return (int)(time - startTime);
    }

    private final boolean $$robo$$android_widget_OverScroller$isScrollingInDirection(float xvel, float yvel) {
        int dx = this.mScrollerX.mFinal - this.mScrollerX.mStart;
        int dy = this.mScrollerY.mFinal - this.mScrollerY.mStart;
        return !this.isFinished() && Math.signum(xvel) == Math.signum(dx) && Math.signum(yvel) == Math.signum(dy);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_OverScroller$__constructor__(context);
    }

    public OverScroller(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_OverScroller$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, Interpolator interpolator2) {
        this.$$robo$$android_widget_OverScroller$__constructor__(context, interpolator2);
    }

    public OverScroller(Context context, Interpolator interpolator2) {
        this(context, interpolator2, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_OverScroller$__constructor__(android.content.Context android.view.animation.Interpolator ), 0, this, context, interpolator2);
    }

    private void __constructor__(Context context, Interpolator interpolator2, boolean bl) {
        this.$$robo$$android_widget_OverScroller$__constructor__(context, interpolator2, bl);
    }

    public OverScroller(Context context, Interpolator interpolator2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_OverScroller$__constructor__(android.content.Context android.view.animation.Interpolator boolean ), 0, this, context, interpolator2, bl);
    }

    private void __constructor__(Context context, Interpolator interpolator2, float f, float f2) {
        this.$$robo$$android_widget_OverScroller$__constructor__(context, interpolator2, f, f2);
    }

    public OverScroller(Context context, Interpolator interpolator2, float f, float f2) {
        this(context, interpolator2, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_OverScroller$__constructor__(android.content.Context android.view.animation.Interpolator float float ), 0, this, context, interpolator2, f, f2);
    }

    private void __constructor__(Context context, Interpolator interpolator2, float f, float f2, boolean bl) {
        this.$$robo$$android_widget_OverScroller$__constructor__(context, interpolator2, f, f2, bl);
    }

    public OverScroller(Context context, Interpolator interpolator2, float f, float f2, boolean bl) {
        this(context, interpolator2, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_OverScroller$__constructor__(android.content.Context android.view.animation.Interpolator float float boolean ), 0, this, context, interpolator2, f, f2, bl);
    }

    void setInterpolator(Interpolator interpolator2) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_widget_OverScroller$setInterpolator(android.view.animation.Interpolator ), 0, this, interpolator2);
    }

    public void setFriction(float f) {
        InvokeDynamicSupport.bootstrap("setFriction", $$robo$$android_widget_OverScroller$setFriction(float ), 0, this, f);
    }

    public boolean isFinished() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFinished", $$robo$$android_widget_OverScroller$isFinished(), 0, this);
    }

    public void forceFinished(boolean bl) {
        InvokeDynamicSupport.bootstrap("forceFinished", $$robo$$android_widget_OverScroller$forceFinished(boolean ), 0, this, bl);
    }

    public int getCurrX() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrX", $$robo$$android_widget_OverScroller$getCurrX(), 0, this);
    }

    public int getCurrY() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrY", $$robo$$android_widget_OverScroller$getCurrY(), 0, this);
    }

    public float getCurrVelocity() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrVelocity", $$robo$$android_widget_OverScroller$getCurrVelocity(), 0, this);
    }

    public int getStartX() {
        return (int)InvokeDynamicSupport.bootstrap("getStartX", $$robo$$android_widget_OverScroller$getStartX(), 0, this);
    }

    public int getStartY() {
        return (int)InvokeDynamicSupport.bootstrap("getStartY", $$robo$$android_widget_OverScroller$getStartY(), 0, this);
    }

    public int getFinalX() {
        return (int)InvokeDynamicSupport.bootstrap("getFinalX", $$robo$$android_widget_OverScroller$getFinalX(), 0, this);
    }

    public int getFinalY() {
        return (int)InvokeDynamicSupport.bootstrap("getFinalY", $$robo$$android_widget_OverScroller$getFinalY(), 0, this);
    }

    @Deprecated
    public int getDuration() {
        return (int)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_widget_OverScroller$getDuration(), 0, this);
    }

    @Deprecated
    public void extendDuration(int n) {
        InvokeDynamicSupport.bootstrap("extendDuration", $$robo$$android_widget_OverScroller$extendDuration(int ), 0, this, n);
    }

    @Deprecated
    public void setFinalX(int n) {
        InvokeDynamicSupport.bootstrap("setFinalX", $$robo$$android_widget_OverScroller$setFinalX(int ), 0, this, n);
    }

    @Deprecated
    public void setFinalY(int n) {
        InvokeDynamicSupport.bootstrap("setFinalY", $$robo$$android_widget_OverScroller$setFinalY(int ), 0, this, n);
    }

    public boolean computeScrollOffset() {
        return (boolean)InvokeDynamicSupport.bootstrap("computeScrollOffset", $$robo$$android_widget_OverScroller$computeScrollOffset(), 0, this);
    }

    public void startScroll(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("startScroll", $$robo$$android_widget_OverScroller$startScroll(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void startScroll(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("startScroll", $$robo$$android_widget_OverScroller$startScroll(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public boolean springBack(int n, int n2, int n3, int n4, int n5, int n6) {
        return (boolean)InvokeDynamicSupport.bootstrap("springBack", $$robo$$android_widget_OverScroller$springBack(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        InvokeDynamicSupport.bootstrap("fling", $$robo$$android_widget_OverScroller$fling(int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        InvokeDynamicSupport.bootstrap("fling", $$robo$$android_widget_OverScroller$fling(int int int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public void notifyHorizontalEdgeReached(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("notifyHorizontalEdgeReached", $$robo$$android_widget_OverScroller$notifyHorizontalEdgeReached(int int int ), 0, this, n, n2, n3);
    }

    public void notifyVerticalEdgeReached(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("notifyVerticalEdgeReached", $$robo$$android_widget_OverScroller$notifyVerticalEdgeReached(int int int ), 0, this, n, n2, n3);
    }

    public boolean isOverScrolled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverScrolled", $$robo$$android_widget_OverScroller$isOverScrolled(), 0, this);
    }

    public void abortAnimation() {
        InvokeDynamicSupport.bootstrap("abortAnimation", $$robo$$android_widget_OverScroller$abortAnimation(), 0, this);
    }

    public int timePassed() {
        return (int)InvokeDynamicSupport.bootstrap("timePassed", $$robo$$android_widget_OverScroller$timePassed(), 0, this);
    }

    public boolean isScrollingInDirection(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isScrollingInDirection", $$robo$$android_widget_OverScroller$isScrollingInDirection(float float ), 0, this, f, f2);
    }

    public /* synthetic */ OverScroller() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverScroller)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SplineOverScroller
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mStart;
        private int mCurrentPosition;
        private int mFinal;
        private int mVelocity;
        private float mCurrVelocity;
        private float mDeceleration;
        private long mStartTime;
        private int mDuration;
        private int mSplineDuration;
        private int mSplineDistance;
        private boolean mFinished;
        private int mOver;
        private float mFlingFriction;
        private int mState;
        private static float GRAVITY = 2000.0f;
        private float mPhysicalCoeff;
        private static float DECELERATION_RATE;
        private static float INFLEXION = 0.35f;
        private static float START_TENSION = 0.5f;
        private static float END_TENSION = 1.0f;
        private static float P1 = 0.175f;
        private static float P2 = 0.35000002f;
        private static int NB_SAMPLES = 100;
        private static float[] SPLINE_POSITION;
        private static float[] SPLINE_TIME;
        private static int SPLINE = 0;
        private static int CUBIC = 1;
        private static int BALLISTIC = 2;

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$setFriction(float friction) {
            this.mFlingFriction = friction;
        }

        private void $$robo$$android_widget_OverScroller_SplineOverScroller$__constructor__(Context context) {
            this.mFlingFriction = ViewConfiguration.getScrollFriction();
            this.mState = 0;
            this.mFinished = true;
            float ppi = context.getResources().getDisplayMetrics().density * 160.0f;
            this.mPhysicalCoeff = 386.0878f * ppi * 0.84f;
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$updateScroll(float q) {
            this.mCurrentPosition = this.mStart + Math.round(q * (float)(this.mFinal - this.mStart));
        }

        private static final float $$robo$$android_widget_OverScroller_SplineOverScroller$getDeceleration(int velocity) {
            return velocity > 0 ? -2000.0f : 2000.0f;
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$adjustDuration(int start, int oldFinal, int newFinal) {
            int newDistance = newFinal - start;
            int oldDistance = oldFinal - start;
            float x = Math.abs((float)newDistance / (float)oldDistance);
            int index = (int)(100.0f * x);
            if (index < 100) {
                float x_inf = (float)index / 100.0f;
                float x_sup = (float)(index + 1) / 100.0f;
                float t_inf = SPLINE_TIME[index];
                float t_sup = SPLINE_TIME[index + 1];
                float timeCoef = t_inf + (x - x_inf) / (x_sup - x_inf) * (t_sup - t_inf);
                this.mDuration = (int)((float)this.mDuration * timeCoef);
            }
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$startScroll(int start, int distance, int duration) {
            this.mFinished = false;
            this.mCurrentPosition = this.mStart = start;
            this.mFinal = start + distance;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = duration;
            this.mDeceleration = 0.0f;
            this.mVelocity = 0;
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$finish() {
            this.mCurrentPosition = this.mFinal;
            this.mFinished = true;
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$setFinalPosition(int position) {
            this.mFinal = position;
            this.mFinished = false;
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$extendDuration(int extend) {
            long time = AnimationUtils.currentAnimationTimeMillis();
            int elapsedTime = (int)(time - this.mStartTime);
            this.mDuration = elapsedTime + extend;
            this.mFinished = false;
        }

        private final boolean $$robo$$android_widget_OverScroller_SplineOverScroller$springback(int start, int min, int max) {
            this.mFinished = true;
            this.mStart = this.mFinal = start;
            this.mCurrentPosition = this.mFinal;
            this.mVelocity = 0;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = 0;
            if (start < min) {
                this.startSpringback(start, min, 0);
            } else if (start > max) {
                this.startSpringback(start, max, 0);
            }
            return !this.mFinished;
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$startSpringback(int start, int end, int velocity) {
            this.mFinished = false;
            this.mState = 1;
            this.mCurrentPosition = this.mStart = start;
            this.mFinal = end;
            int delta = start - end;
            this.mDeceleration = SplineOverScroller.getDeceleration(delta);
            this.mVelocity = -delta;
            this.mOver = Math.abs(delta);
            this.mDuration = (int)(1000.0 * Math.sqrt(-2.0 * (double)delta / (double)this.mDeceleration));
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$fling(int start, int velocity, int min, int max, int over) {
            this.mOver = over;
            this.mFinished = false;
            this.mVelocity = velocity;
            this.mCurrVelocity = this.mVelocity;
            this.mSplineDuration = 0;
            this.mDuration = 0;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mCurrentPosition = this.mStart = start;
            if (start > max || start < min) {
                this.startAfterEdge(start, min, max, velocity);
                return;
            }
            this.mState = 0;
            double totalDistance = 0.0;
            if (velocity != 0) {
                this.mDuration = this.mSplineDuration = this.getSplineFlingDuration(velocity);
                totalDistance = this.getSplineFlingDistance(velocity);
            }
            this.mSplineDistance = (int)(totalDistance * (double)Math.signum(velocity));
            this.mFinal = start + this.mSplineDistance;
            if (this.mFinal < min) {
                this.adjustDuration(this.mStart, this.mFinal, min);
                this.mFinal = min;
            }
            if (this.mFinal > max) {
                this.adjustDuration(this.mStart, this.mFinal, max);
                this.mFinal = max;
            }
        }

        private final double $$robo$$android_widget_OverScroller_SplineOverScroller$getSplineDeceleration(int velocity) {
            return Math.log(0.35f * (float)Math.abs(velocity) / (this.mFlingFriction * this.mPhysicalCoeff));
        }

        private final double $$robo$$android_widget_OverScroller_SplineOverScroller$getSplineFlingDistance(int velocity) {
            double l = this.getSplineDeceleration(velocity);
            double decelMinusOne = (double)DECELERATION_RATE - 1.0;
            return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp((double)DECELERATION_RATE / decelMinusOne * l);
        }

        private final int $$robo$$android_widget_OverScroller_SplineOverScroller$getSplineFlingDuration(int velocity) {
            double l = this.getSplineDeceleration(velocity);
            double decelMinusOne = (double)DECELERATION_RATE - 1.0;
            return (int)(1000.0 * Math.exp(l / decelMinusOne));
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$fitOnBounceCurve(int start, int end, int velocity) {
            float durationToApex = (float)(-velocity) / this.mDeceleration;
            float velocitySquared = (float)velocity * (float)velocity;
            float distanceToApex = velocitySquared / 2.0f / Math.abs(this.mDeceleration);
            float distanceToEdge = Math.abs(end - start);
            float totalDuration = (float)Math.sqrt(2.0 * (double)(distanceToApex + distanceToEdge) / (double)Math.abs(this.mDeceleration));
            this.mStartTime -= (long)((int)(1000.0f * (totalDuration - durationToApex)));
            this.mCurrentPosition = this.mStart = end;
            this.mVelocity = (int)(-this.mDeceleration * totalDuration);
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$startBounceAfterEdge(int start, int end, int velocity) {
            this.mDeceleration = SplineOverScroller.getDeceleration(velocity == 0 ? start - end : velocity);
            this.fitOnBounceCurve(start, end, velocity);
            this.onEdgeReached();
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$startAfterEdge(int start, int min, int max, int velocity) {
            boolean keepIncreasing;
            if (start > min && start < max) {
                Log.e("OverScroller", "startAfterEdge called from a valid position");
                this.mFinished = true;
                return;
            }
            boolean positive = start > max;
            int edge = positive ? max : min;
            int overDistance = start - edge;
            boolean bl = keepIncreasing = overDistance * velocity >= 0;
            if (keepIncreasing) {
                this.startBounceAfterEdge(start, edge, velocity);
            } else {
                double totalDistance = this.getSplineFlingDistance(velocity);
                if (totalDistance > (double)Math.abs(overDistance)) {
                    this.fling(start, velocity, positive ? min : start, positive ? start : max, this.mOver);
                } else {
                    this.startSpringback(start, edge, velocity);
                }
            }
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$notifyEdgeReached(int start, int end, int over) {
            if (this.mState == 0) {
                this.mOver = over;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.startAfterEdge(start, end, end, (int)this.mCurrVelocity);
            }
        }

        private final void $$robo$$android_widget_OverScroller_SplineOverScroller$onEdgeReached() {
            float velocitySquared = (float)this.mVelocity * (float)this.mVelocity;
            float distance = velocitySquared / (2.0f * Math.abs(this.mDeceleration));
            float sign = Math.signum(this.mVelocity);
            if (distance > (float)this.mOver) {
                this.mDeceleration = -sign * velocitySquared / (2.0f * (float)this.mOver);
                distance = this.mOver;
            }
            this.mOver = (int)distance;
            this.mState = 2;
            this.mFinal = this.mStart + (int)(this.mVelocity > 0 ? distance : -distance);
            this.mDuration = -((int)(1000.0f * (float)this.mVelocity / this.mDeceleration));
        }

        private final boolean $$robo$$android_widget_OverScroller_SplineOverScroller$continueWhenFinished() {
            switch (this.mState) {
                case 0: {
                    if (this.mDuration < this.mSplineDuration) {
                        this.mCurrentPosition = this.mStart = this.mFinal;
                        this.mVelocity = (int)this.mCurrVelocity;
                        this.mDeceleration = SplineOverScroller.getDeceleration(this.mVelocity);
                        this.mStartTime += (long)this.mDuration;
                        this.onEdgeReached();
                        break;
                    }
                    return false;
                }
                case 2: {
                    this.mStartTime += (long)this.mDuration;
                    this.startSpringback(this.mFinal, this.mStart, 0);
                    break;
                }
                case 1: {
                    return false;
                }
            }
            this.update();
            return true;
        }

        private final boolean $$robo$$android_widget_OverScroller_SplineOverScroller$update() {
            long time = AnimationUtils.currentAnimationTimeMillis();
            long currentTime = time - this.mStartTime;
            if (currentTime == 0L) {
                return this.mDuration > 0;
            }
            if (currentTime > (long)this.mDuration) {
                return false;
            }
            double distance = 0.0;
            switch (this.mState) {
                case 0: {
                    float t = (float)currentTime / (float)this.mSplineDuration;
                    int index = (int)(100.0f * t);
                    float distanceCoef = 1.0f;
                    float velocityCoef = 0.0f;
                    if (index < 100) {
                        float t_inf = (float)index / 100.0f;
                        float t_sup = (float)(index + 1) / 100.0f;
                        float d_inf = SPLINE_POSITION[index];
                        float d_sup = SPLINE_POSITION[index + 1];
                        velocityCoef = (d_sup - d_inf) / (t_sup - t_inf);
                        distanceCoef = d_inf + (t - t_inf) * velocityCoef;
                    }
                    distance = distanceCoef * (float)this.mSplineDistance;
                    this.mCurrVelocity = velocityCoef * (float)this.mSplineDistance / (float)this.mSplineDuration * 1000.0f;
                    break;
                }
                case 2: {
                    float t = (float)currentTime / 1000.0f;
                    this.mCurrVelocity = (float)this.mVelocity + this.mDeceleration * t;
                    distance = (float)this.mVelocity * t + this.mDeceleration * t * t / 2.0f;
                    break;
                }
                case 1: {
                    float t = (float)currentTime / (float)this.mDuration;
                    float t2 = t * t;
                    float sign = Math.signum(this.mVelocity);
                    distance = sign * (float)this.mOver * (3.0f * t2 - 2.0f * t * t2);
                    this.mCurrVelocity = sign * (float)this.mOver * 6.0f * (-t + t2);
                    break;
                }
            }
            this.mCurrentPosition = this.mStart + (int)Math.round(distance);
            return true;
        }

        static void __staticInitializer__() {
            DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
            SPLINE_POSITION = new float[101];
            SPLINE_TIME = new float[101];
            float x_min = 0.0f;
            float y_min = 0.0f;
            for (int i = 0; i < 100; ++i) {
                float y;
                float dy;
                float x;
                float coef;
                float tx;
                float alpha = (float)i / 100.0f;
                float x_max = 1.0f;
                while (!((double)Math.abs((tx = (coef = 3.0f * (x = x_min + (x_max - x_min) / 2.0f) * (1.0f - x)) * ((1.0f - x) * 0.175f + x * 0.35000002f) + x * x * x) - alpha) < 1.0E-5)) {
                    if (tx > alpha) {
                        x_max = x;
                        continue;
                    }
                    x_min = x;
                }
                SplineOverScroller.SPLINE_POSITION[i] = coef * ((1.0f - x) * 0.5f + x) + x * x * x;
                float y_max = 1.0f;
                while (!((double)Math.abs((dy = (coef = 3.0f * (y = y_min + (y_max - y_min) / 2.0f) * (1.0f - y)) * ((1.0f - y) * 0.5f + y) + y * y * y) - alpha) < 1.0E-5)) {
                    if (dy > alpha) {
                        y_max = y;
                        continue;
                    }
                    y_min = y;
                }
                SplineOverScroller.SPLINE_TIME[i] = coef * ((1.0f - y) * 0.175f + y * 0.35000002f) + y * y * y;
            }
            SplineOverScroller.SPLINE_TIME[100] = 1.0f;
            SplineOverScroller.SPLINE_POSITION[100] = 1.0f;
        }

        void setFriction(float f) {
            InvokeDynamicSupport.bootstrap("setFriction", $$robo$$android_widget_OverScroller_SplineOverScroller$setFriction(float ), 0, this, f);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_widget_OverScroller_SplineOverScroller$__constructor__(context);
        }

        SplineOverScroller(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_OverScroller_SplineOverScroller$__constructor__(android.content.Context ), 0, this, context);
        }

        void updateScroll(float f) {
            InvokeDynamicSupport.bootstrap("updateScroll", $$robo$$android_widget_OverScroller_SplineOverScroller$updateScroll(float ), 0, this, f);
        }

        private static float getDeceleration(int n) {
            return (float)InvokeDynamicSupport.bootstrapStatic("getDeceleration", $$robo$$android_widget_OverScroller_SplineOverScroller$getDeceleration(int ), 0, (int)n);
        }

        private void adjustDuration(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("adjustDuration", $$robo$$android_widget_OverScroller_SplineOverScroller$adjustDuration(int int int ), 0, this, n, n2, n3);
        }

        void startScroll(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("startScroll", $$robo$$android_widget_OverScroller_SplineOverScroller$startScroll(int int int ), 0, this, n, n2, n3);
        }

        void finish() {
            InvokeDynamicSupport.bootstrap("finish", $$robo$$android_widget_OverScroller_SplineOverScroller$finish(), 0, this);
        }

        void setFinalPosition(int n) {
            InvokeDynamicSupport.bootstrap("setFinalPosition", $$robo$$android_widget_OverScroller_SplineOverScroller$setFinalPosition(int ), 0, this, n);
        }

        void extendDuration(int n) {
            InvokeDynamicSupport.bootstrap("extendDuration", $$robo$$android_widget_OverScroller_SplineOverScroller$extendDuration(int ), 0, this, n);
        }

        boolean springback(int n, int n2, int n3) {
            return (boolean)InvokeDynamicSupport.bootstrap("springback", $$robo$$android_widget_OverScroller_SplineOverScroller$springback(int int int ), 0, this, n, n2, n3);
        }

        private void startSpringback(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("startSpringback", $$robo$$android_widget_OverScroller_SplineOverScroller$startSpringback(int int int ), 0, this, n, n2, n3);
        }

        void fling(int n, int n2, int n3, int n4, int n5) {
            InvokeDynamicSupport.bootstrap("fling", $$robo$$android_widget_OverScroller_SplineOverScroller$fling(int int int int int ), 0, this, n, n2, n3, n4, n5);
        }

        private double getSplineDeceleration(int n) {
            return (double)InvokeDynamicSupport.bootstrap("getSplineDeceleration", $$robo$$android_widget_OverScroller_SplineOverScroller$getSplineDeceleration(int ), 0, this, n);
        }

        private double getSplineFlingDistance(int n) {
            return (double)InvokeDynamicSupport.bootstrap("getSplineFlingDistance", $$robo$$android_widget_OverScroller_SplineOverScroller$getSplineFlingDistance(int ), 0, this, n);
        }

        private int getSplineFlingDuration(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getSplineFlingDuration", $$robo$$android_widget_OverScroller_SplineOverScroller$getSplineFlingDuration(int ), 0, this, n);
        }

        private void fitOnBounceCurve(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("fitOnBounceCurve", $$robo$$android_widget_OverScroller_SplineOverScroller$fitOnBounceCurve(int int int ), 0, this, n, n2, n3);
        }

        private void startBounceAfterEdge(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("startBounceAfterEdge", $$robo$$android_widget_OverScroller_SplineOverScroller$startBounceAfterEdge(int int int ), 0, this, n, n2, n3);
        }

        private void startAfterEdge(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("startAfterEdge", $$robo$$android_widget_OverScroller_SplineOverScroller$startAfterEdge(int int int int ), 0, this, n, n2, n3, n4);
        }

        void notifyEdgeReached(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("notifyEdgeReached", $$robo$$android_widget_OverScroller_SplineOverScroller$notifyEdgeReached(int int int ), 0, this, n, n2, n3);
        }

        private void onEdgeReached() {
            InvokeDynamicSupport.bootstrap("onEdgeReached", $$robo$$android_widget_OverScroller_SplineOverScroller$onEdgeReached(), 0, this);
        }

        boolean continueWhenFinished() {
            return (boolean)InvokeDynamicSupport.bootstrap("continueWhenFinished", $$robo$$android_widget_OverScroller_SplineOverScroller$continueWhenFinished(), 0, this);
        }

        boolean update() {
            return (boolean)InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_OverScroller_SplineOverScroller$update(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(SplineOverScroller.class);
        }

        public /* synthetic */ SplineOverScroller() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplineOverScroller)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

