/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.DropDownListView;
import com.android.internal.view.menu.ShowableListMenu;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ForwardingListener
implements View.OnTouchListener,
View.OnAttachStateChangeListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private float mScaledTouchSlop;
    private int mTapTimeout;
    private int mLongPressTimeout;
    private View mSrc;
    private Runnable mDisallowIntercept;
    private Runnable mTriggerLongPress;
    private boolean mForwarding;
    private int mActivePointerId;

    private void $$robo$$android_widget_ForwardingListener$__constructor__(View src) {
        this.mSrc = src;
        this.mScaledTouchSlop = ViewConfiguration.get(src.getContext()).getScaledTouchSlop();
        this.mTapTimeout = ViewConfiguration.getTapTimeout();
        this.mLongPressTimeout = (this.mTapTimeout + ViewConfiguration.getLongPressTimeout()) / 2;
        src.addOnAttachStateChangeListener(this);
    }

    public abstract ShowableListMenu getPopup();

    private final boolean $$robo$$android_widget_ForwardingListener$onTouch(View v, MotionEvent event) {
        boolean forwarding;
        boolean wasForwarding = this.mForwarding;
        if (wasForwarding) {
            forwarding = this.onTouchForwarded(event) || !this.onForwardingStopped();
        } else {
            boolean bl = forwarding = this.onTouchObserved(event) && this.onForwardingStarted();
            if (forwarding) {
                long now = SystemClock.uptimeMillis();
                MotionEvent e = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                this.mSrc.onTouchEvent(e);
                e.recycle();
            }
        }
        this.mForwarding = forwarding;
        return forwarding || wasForwarding;
    }

    private final void $$robo$$android_widget_ForwardingListener$onViewAttachedToWindow(View v) {
    }

    private final void $$robo$$android_widget_ForwardingListener$onViewDetachedFromWindow(View v) {
        this.mForwarding = false;
        this.mActivePointerId = -1;
        if (this.mDisallowIntercept != null) {
            this.mSrc.removeCallbacks(this.mDisallowIntercept);
        }
    }

    private final boolean $$robo$$android_widget_ForwardingListener$onForwardingStarted() {
        ShowableListMenu popup = this.getPopup();
        if (popup != null && !popup.isShowing()) {
            popup.show();
        }
        return true;
    }

    private final boolean $$robo$$android_widget_ForwardingListener$onForwardingStopped() {
        ShowableListMenu popup = this.getPopup();
        if (popup != null && popup.isShowing()) {
            popup.dismiss();
        }
        return true;
    }

    private final boolean $$robo$$android_widget_ForwardingListener$onTouchObserved(MotionEvent srcEvent) {
        View src = this.mSrc;
        if (!src.isEnabled()) {
            return false;
        }
        int actionMasked = srcEvent.getActionMasked();
        switch (actionMasked) {
            case 0: {
                this.mActivePointerId = srcEvent.getPointerId(0);
                if (this.mDisallowIntercept == null) {
                    this.mDisallowIntercept = new DisallowIntercept(this);
                }
                src.postDelayed(this.mDisallowIntercept, this.mTapTimeout);
                if (this.mTriggerLongPress == null) {
                    this.mTriggerLongPress = new TriggerLongPress(this);
                }
                src.postDelayed(this.mTriggerLongPress, this.mLongPressTimeout);
                break;
            }
            case 2: {
                float y;
                float x;
                int activePointerIndex = srcEvent.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex < 0 || src.pointInView(x = srcEvent.getX(activePointerIndex), y = srcEvent.getY(activePointerIndex), this.mScaledTouchSlop)) break;
                this.clearCallbacks();
                src.getParent().requestDisallowInterceptTouchEvent(true);
                return true;
            }
            case 1: 
            case 3: {
                this.clearCallbacks();
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_ForwardingListener$clearCallbacks() {
        if (this.mTriggerLongPress != null) {
            this.mSrc.removeCallbacks(this.mTriggerLongPress);
        }
        if (this.mDisallowIntercept != null) {
            this.mSrc.removeCallbacks(this.mDisallowIntercept);
        }
    }

    private final void $$robo$$android_widget_ForwardingListener$onLongPress() {
        this.clearCallbacks();
        View src = this.mSrc;
        if (!src.isEnabled() || src.isLongClickable()) {
            return;
        }
        if (!this.onForwardingStarted()) {
            return;
        }
        src.getParent().requestDisallowInterceptTouchEvent(true);
        long now = SystemClock.uptimeMillis();
        MotionEvent e = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
        src.onTouchEvent(e);
        e.recycle();
        this.mForwarding = true;
    }

    private final boolean $$robo$$android_widget_ForwardingListener$onTouchForwarded(MotionEvent srcEvent) {
        View src = this.mSrc;
        ShowableListMenu popup = this.getPopup();
        if (popup == null || !popup.isShowing()) {
            return false;
        }
        DropDownListView dst = (DropDownListView)popup.getListView();
        if (dst == null || !dst.isShown()) {
            return false;
        }
        MotionEvent dstEvent = MotionEvent.obtainNoHistory(srcEvent);
        src.toGlobalMotionEvent(dstEvent);
        dst.toLocalMotionEvent(dstEvent);
        boolean handled = dst.onForwardedEvent(dstEvent, this.mActivePointerId);
        dstEvent.recycle();
        int action = srcEvent.getActionMasked();
        boolean keepForwarding = action != 1 && action != 3;
        return handled && keepForwarding;
    }

    private void __constructor__(View view) {
        this.$$robo$$android_widget_ForwardingListener$__constructor__(view);
    }

    public ForwardingListener(View view) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ForwardingListener$__constructor__(android.view.View ), 0, this, view);
    }

    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$android_widget_ForwardingListener$onTouch(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
    }

    @Override
    public void onViewAttachedToWindow(View view) {
        InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$android_widget_ForwardingListener$onViewAttachedToWindow(android.view.View ), 0, this, view);
    }

    @Override
    public void onViewDetachedFromWindow(View view) {
        InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_widget_ForwardingListener$onViewDetachedFromWindow(android.view.View ), 0, this, view);
    }

    protected boolean onForwardingStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStarted", $$robo$$android_widget_ForwardingListener$onForwardingStarted(), 0, this);
    }

    protected boolean onForwardingStopped() {
        return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStopped", $$robo$$android_widget_ForwardingListener$onForwardingStopped(), 0, this);
    }

    private boolean onTouchObserved(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchObserved", $$robo$$android_widget_ForwardingListener$onTouchObserved(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void clearCallbacks() {
        InvokeDynamicSupport.bootstrap("clearCallbacks", $$robo$$android_widget_ForwardingListener$clearCallbacks(), 0, this);
    }

    private void onLongPress() {
        InvokeDynamicSupport.bootstrap("onLongPress", $$robo$$android_widget_ForwardingListener$onLongPress(), 0, this);
    }

    private boolean onTouchForwarded(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchForwarded", $$robo$$android_widget_ForwardingListener$onTouchForwarded(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public /* synthetic */ ForwardingListener() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ForwardingListener)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class TriggerLongPress
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ForwardingListener this$0;

        private void $$robo$$android_widget_ForwardingListener_TriggerLongPress$__constructor__(ForwardingListener forwardingListener) {
        }

        private final void $$robo$$android_widget_ForwardingListener_TriggerLongPress$run() {
            this.this$0.onLongPress();
        }

        private /* synthetic */ void $$robo$$android_widget_ForwardingListener_TriggerLongPress$__constructor__(ForwardingListener x0, 1 x1) {
        }

        private void __constructor__(ForwardingListener forwardingListener) {
            this.$$robo$$android_widget_ForwardingListener_TriggerLongPress$__constructor__(forwardingListener);
        }

        private TriggerLongPress(ForwardingListener forwardingListener) {
            this.this$0 = forwardingListener;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ForwardingListener_TriggerLongPress$__constructor__(android.widget.ForwardingListener ), 0, this, forwardingListener);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ForwardingListener_TriggerLongPress$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(ForwardingListener forwardingListener, 1 var2_2) {
            this.$$robo$$android_widget_ForwardingListener_TriggerLongPress$__constructor__(forwardingListener, var2_2);
        }

        public /* synthetic */ TriggerLongPress() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TriggerLongPress)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DisallowIntercept
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ForwardingListener this$0;

        private void $$robo$$android_widget_ForwardingListener_DisallowIntercept$__constructor__(ForwardingListener forwardingListener) {
        }

        private final void $$robo$$android_widget_ForwardingListener_DisallowIntercept$run() {
            ViewParent parent = this.this$0.mSrc.getParent();
            parent.requestDisallowInterceptTouchEvent(true);
        }

        private /* synthetic */ void $$robo$$android_widget_ForwardingListener_DisallowIntercept$__constructor__(ForwardingListener x0, 1 x1) {
        }

        private void __constructor__(ForwardingListener forwardingListener) {
            this.$$robo$$android_widget_ForwardingListener_DisallowIntercept$__constructor__(forwardingListener);
        }

        private DisallowIntercept(ForwardingListener forwardingListener) {
            this.this$0 = forwardingListener;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ForwardingListener_DisallowIntercept$__constructor__(android.widget.ForwardingListener ), 0, this, forwardingListener);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ForwardingListener_DisallowIntercept$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(ForwardingListener forwardingListener, 1 var2_2) {
            this.$$robo$$android_widget_ForwardingListener_DisallowIntercept$__constructor__(forwardingListener, var2_2);
        }

        public /* synthetic */ DisallowIntercept() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisallowIntercept)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

