/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.Cursor;
import android.database.DataSetObserver;
import android.util.SparseIntArray;
import android.widget.SectionIndexer;
import java.text.Collator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlphabetIndexer
extends DataSetObserver
implements SectionIndexer,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected Cursor mDataCursor;
    protected int mColumnIndex;
    protected CharSequence mAlphabet;
    private int mAlphabetLength;
    private SparseIntArray mAlphaMap;
    private Collator mCollator;
    private String[] mAlphabetArray;

    private void $$robo$$android_widget_AlphabetIndexer$__constructor__(Cursor cursor, int sortedColumnIndex, CharSequence alphabet) {
        this.mDataCursor = cursor;
        this.mColumnIndex = sortedColumnIndex;
        this.mAlphabet = alphabet;
        this.mAlphabetLength = alphabet.length();
        this.mAlphabetArray = new String[this.mAlphabetLength];
        for (int i = 0; i < this.mAlphabetLength; ++i) {
            this.mAlphabetArray[i] = Character.toString(this.mAlphabet.charAt(i));
        }
        this.mAlphaMap = new SparseIntArray(this.mAlphabetLength);
        if (cursor != null) {
            cursor.registerDataSetObserver(this);
        }
        this.mCollator = Collator.getInstance();
        this.mCollator.setStrength(0);
    }

    private final Object[] $$robo$$android_widget_AlphabetIndexer$getSections() {
        return this.mAlphabetArray;
    }

    private final void $$robo$$android_widget_AlphabetIndexer$setCursor(Cursor cursor) {
        if (this.mDataCursor != null) {
            this.mDataCursor.unregisterDataSetObserver(this);
        }
        this.mDataCursor = cursor;
        if (cursor != null) {
            this.mDataCursor.registerDataSetObserver(this);
        }
        this.mAlphaMap.clear();
    }

    private final int $$robo$$android_widget_AlphabetIndexer$compare(String word, String letter) {
        String firstLetter = word.length() == 0 ? " " : word.substring(0, 1);
        return this.mCollator.compare(firstLetter, letter);
    }

    private final int $$robo$$android_widget_AlphabetIndexer$getPositionForSection(int sectionIndex) {
        char prevLetter;
        int prevLetterPos;
        SparseIntArray alphaMap = this.mAlphaMap;
        Cursor cursor = this.mDataCursor;
        if (cursor == null || this.mAlphabet == null) {
            return 0;
        }
        if (sectionIndex <= 0) {
            return 0;
        }
        if (sectionIndex >= this.mAlphabetLength) {
            sectionIndex = this.mAlphabetLength - 1;
        }
        int savedCursorPos = cursor.getPosition();
        int count = cursor.getCount();
        int start = 0;
        int end = count;
        char letter = this.mAlphabet.charAt(sectionIndex);
        String targetLetter = Character.toString(letter);
        char key = letter;
        int pos = alphaMap.get(key, Integer.MIN_VALUE);
        if (Integer.MIN_VALUE != pos) {
            if (pos < 0) {
                end = pos = -pos;
            } else {
                return pos;
            }
        }
        if (sectionIndex > 0 && (prevLetterPos = alphaMap.get(prevLetter = this.mAlphabet.charAt(sectionIndex - 1), Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            start = Math.abs(prevLetterPos);
        }
        pos = (end + start) / 2;
        while (pos < end) {
            cursor.moveToPosition(pos);
            String curName = cursor.getString(this.mColumnIndex);
            if (curName == null) {
                if (pos == 0) break;
                --pos;
                continue;
            }
            int diff = this.compare(curName, targetLetter);
            if (diff != 0) {
                if (diff < 0) {
                    start = pos + 1;
                    if (start >= count) {
                        pos = count;
                        break;
                    }
                } else {
                    end = pos;
                }
            } else {
                if (start == pos) break;
                end = pos;
            }
            pos = (start + end) / 2;
        }
        alphaMap.put(key, pos);
        cursor.moveToPosition(savedCursorPos);
        return pos;
    }

    private final int $$robo$$android_widget_AlphabetIndexer$getSectionForPosition(int position) {
        int savedCursorPos = this.mDataCursor.getPosition();
        this.mDataCursor.moveToPosition(position);
        String curName = this.mDataCursor.getString(this.mColumnIndex);
        this.mDataCursor.moveToPosition(savedCursorPos);
        for (int i = 0; i < this.mAlphabetLength; ++i) {
            char letter = this.mAlphabet.charAt(i);
            String targetLetter = Character.toString(letter);
            if (this.compare(curName, targetLetter) != 0) continue;
            return i;
        }
        return 0;
    }

    private final void $$robo$$android_widget_AlphabetIndexer$onChanged() {
        super.onChanged();
        this.mAlphaMap.clear();
    }

    private final void $$robo$$android_widget_AlphabetIndexer$onInvalidated() {
        super.onInvalidated();
        this.mAlphaMap.clear();
    }

    private void __constructor__(Cursor cursor, int n, CharSequence charSequence) {
        this.$$robo$$android_widget_AlphabetIndexer$__constructor__(cursor, n, charSequence);
    }

    public AlphabetIndexer(Cursor cursor, int n, CharSequence charSequence) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AlphabetIndexer$__constructor__(android.database.Cursor int java.lang.CharSequence ), 0, this, cursor, n, charSequence);
    }

    @Override
    public Object[] getSections() {
        return InvokeDynamicSupport.bootstrap("getSections", $$robo$$android_widget_AlphabetIndexer$getSections(), 0, this);
    }

    public void setCursor(Cursor cursor) {
        InvokeDynamicSupport.bootstrap("setCursor", $$robo$$android_widget_AlphabetIndexer$setCursor(android.database.Cursor ), 0, this, cursor);
    }

    protected int compare(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_widget_AlphabetIndexer$compare(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public int getPositionForSection(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPositionForSection", $$robo$$android_widget_AlphabetIndexer$getPositionForSection(int ), 0, this, n);
    }

    @Override
    public int getSectionForPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSectionForPosition", $$robo$$android_widget_AlphabetIndexer$getSectionForPosition(int ), 0, this, n);
    }

    @Override
    public void onChanged() {
        InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_AlphabetIndexer$onChanged(), 0, this);
    }

    @Override
    public void onInvalidated() {
        InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$android_widget_AlphabetIndexer$onInvalidated(), 0, this);
    }

    public /* synthetic */ AlphabetIndexer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlphabetIndexer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

