/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.graphics.Rect;
import android.text.Layout;
import android.text.Spannable;
import android.view.AccessibilityIterators;
import android.widget.TextView;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AccessibilityIterators
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_widget_AccessibilityIterators$__constructor__() {
    }

    private void __constructor__() {
        this.$$robo$$android_widget_AccessibilityIterators$__constructor__();
    }

    AccessibilityIterators() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AccessibilityIterators$__constructor__(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityIterators)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PageTextSegmentIterator
    extends LineTextSegmentIterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static PageTextSegmentIterator sPageInstance;
        private TextView mView;
        private Rect mTempRect;

        private void $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$__constructor__() {
            this.mTempRect = new Rect();
        }

        private static final PageTextSegmentIterator $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$getInstance() {
            if (sPageInstance == null) {
                sPageInstance = new PageTextSegmentIterator();
            }
            return sPageInstance;
        }

        private final void $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$initialize(TextView view) {
            super.initialize((Spannable)view.getIterableTextForAccessibility(), view.getLayout());
            this.mView = view;
        }

        private final int[] $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$following(int offset) {
            int lastLineTop;
            int pageHeight;
            int textLength = this.mText.length();
            if (textLength <= 0) {
                return null;
            }
            if (offset >= this.mText.length()) {
                return null;
            }
            if (!this.mView.getGlobalVisibleRect(this.mTempRect)) {
                return null;
            }
            int start = Math.max(0, offset);
            int currentLine = this.mLayout.getLineForOffset(start);
            int currentLineTop = this.mLayout.getLineTop(currentLine);
            int nextPageStartY = currentLineTop + (pageHeight = this.mTempRect.height() - this.mView.getTotalPaddingTop() - this.mView.getTotalPaddingBottom());
            int currentPageEndLine = nextPageStartY < (lastLineTop = this.mLayout.getLineTop(this.mLayout.getLineCount() - 1)) ? this.mLayout.getLineForVertical(nextPageStartY) - 1 : this.mLayout.getLineCount() - 1;
            int end = this.getLineEdgeIndex(currentPageEndLine, 1) + 1;
            return this.getRange(start, end);
        }

        private final int[] $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$preceding(int offset) {
            int currentPageStartLine;
            int pageHeight;
            int textLength = this.mText.length();
            if (textLength <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            if (!this.mView.getGlobalVisibleRect(this.mTempRect)) {
                return null;
            }
            int end = Math.min(this.mText.length(), offset);
            int currentLine = this.mLayout.getLineForOffset(end);
            int currentLineTop = this.mLayout.getLineTop(currentLine);
            int previousPageEndY = currentLineTop - (pageHeight = this.mTempRect.height() - this.mView.getTotalPaddingTop() - this.mView.getTotalPaddingBottom());
            int n = currentPageStartLine = previousPageEndY > 0 ? this.mLayout.getLineForVertical(previousPageEndY) : 0;
            if (end == this.mText.length() && currentPageStartLine < currentLine) {
                ++currentPageStartLine;
            }
            int start = this.getLineEdgeIndex(currentPageStartLine, -1);
            return this.getRange(start, end);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$__constructor__();
        }

        PageTextSegmentIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$__constructor__(), 0, this);
        }

        public static PageTextSegmentIterator getInstance() {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$getInstance(), 0);
        }

        public void initialize(TextView textView) {
            InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$initialize(android.widget.TextView ), 0, this, textView);
        }

        @Override
        public int[] following(int n) {
            return InvokeDynamicSupport.bootstrap("following", $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$following(int ), 0, this, n);
        }

        @Override
        public int[] preceding(int n) {
            return InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_widget_AccessibilityIterators_PageTextSegmentIterator$preceding(int ), 0, this, n);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PageTextSegmentIterator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LineTextSegmentIterator
    extends AccessibilityIterators.AbstractTextSegmentIterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static LineTextSegmentIterator sLineInstance;
        protected static int DIRECTION_START = -1;
        protected static int DIRECTION_END = 1;
        protected Layout mLayout;

        private void $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$__constructor__() {
        }

        private static final LineTextSegmentIterator $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$getInstance() {
            if (sLineInstance == null) {
                sLineInstance = new LineTextSegmentIterator();
            }
            return sLineInstance;
        }

        private final void $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$initialize(Spannable text, Layout layout2) {
            this.mText = text.toString();
            this.mLayout = layout2;
        }

        private final int[] $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$following(int offset) {
            int currentLine;
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset >= this.mText.length()) {
                return null;
            }
            int nextLine = offset < 0 ? this.mLayout.getLineForOffset(0) : (this.getLineEdgeIndex(currentLine = this.mLayout.getLineForOffset(offset), -1) == offset ? currentLine : currentLine + 1);
            if (nextLine >= this.mLayout.getLineCount()) {
                return null;
            }
            int start = this.getLineEdgeIndex(nextLine, -1);
            int end = this.getLineEdgeIndex(nextLine, 1) + 1;
            return this.getRange(start, end);
        }

        private final int[] $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$preceding(int offset) {
            int currentLine;
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            int previousLine = offset > this.mText.length() ? this.mLayout.getLineForOffset(this.mText.length()) : (this.getLineEdgeIndex(currentLine = this.mLayout.getLineForOffset(offset), 1) + 1 == offset ? currentLine : currentLine - 1);
            if (previousLine < 0) {
                return null;
            }
            int start = this.getLineEdgeIndex(previousLine, -1);
            int end = this.getLineEdgeIndex(previousLine, 1) + 1;
            return this.getRange(start, end);
        }

        private final int $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$getLineEdgeIndex(int lineNumber, int direction) {
            int paragraphDirection = this.mLayout.getParagraphDirection(lineNumber);
            if (direction * paragraphDirection < 0) {
                return this.mLayout.getLineStart(lineNumber);
            }
            return this.mLayout.getLineEnd(lineNumber) - 1;
        }

        private void __constructor__() {
            this.$$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$__constructor__();
        }

        LineTextSegmentIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$__constructor__(), 0, this);
        }

        public static LineTextSegmentIterator getInstance() {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$getInstance(), 0);
        }

        public void initialize(Spannable spannable, Layout layout2) {
            InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$initialize(android.text.Spannable android.text.Layout ), 0, this, spannable, layout2);
        }

        @Override
        public int[] following(int n) {
            return InvokeDynamicSupport.bootstrap("following", $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$following(int ), 0, this, n);
        }

        @Override
        public int[] preceding(int n) {
            return InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$preceding(int ), 0, this, n);
        }

        protected int getLineEdgeIndex(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("getLineEdgeIndex", $$robo$$android_widget_AccessibilityIterators_LineTextSegmentIterator$getLineEdgeIndex(int int ), 0, this, n, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LineTextSegmentIterator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

