/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.Trace;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.ArraySet;
import android.util.Log;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewDelegate;
import android.webkit.WebViewFactoryProvider;
import android.webkit.WebViewProviderResponse;
import com.android.server.LocalServices;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class WebViewFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String CHROMIUM_WEBVIEW_FACTORY = "com.android.webview.chromium.WebViewChromiumFactoryProvider";
    private static String NULL_WEBVIEW_FACTORY = "com.android.webview.nullwebview.NullWebViewFactoryProvider";
    private static String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    public static String CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY = "persist.sys.webview.vmsize";
    private static long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static String LOGTAG = "WebViewFactory";
    private static boolean DEBUG = false;
    private static WebViewFactoryProvider sProviderInstance;
    private static Object sProviderLock;
    private static boolean sAddressSpaceReserved;
    private static PackageInfo sPackageInfo;
    public static int LIBLOAD_SUCCESS = 0;
    public static int LIBLOAD_WRONG_PACKAGE_NAME = 1;
    public static int LIBLOAD_ADDRESS_SPACE_NOT_RESERVED = 2;
    public static int LIBLOAD_FAILED_WAITING_FOR_RELRO = 3;
    public static int LIBLOAD_FAILED_LISTING_WEBVIEW_PACKAGES = 4;
    public static int LIBLOAD_FAILED_TO_OPEN_RELRO_FILE = 5;
    public static int LIBLOAD_FAILED_TO_LOAD_LIBRARY = 6;
    public static int LIBLOAD_FAILED_JNI_CALL = 7;
    public static int LIBLOAD_FAILED_WAITING_FOR_WEBVIEW_REASON_UNKNOWN = 8;
    public static int LIBLOAD_FAILED_TO_FIND_NAMESPACE = 10;
    private static String WEBVIEW_UPDATE_SERVICE_NAME;

    private void $$robo$$android_webkit_WebViewFactory$__constructor__() {
    }

    private static final String $$robo$$android_webkit_WebViewFactory$getWebViewPreparationErrorReason(int error) {
        switch (error) {
            case 3: {
                return "Time out waiting for Relro files being created";
            }
            case 4: {
                return "No WebView installed";
            }
            case 8: {
                return "Crashed for unknown reason";
            }
        }
        return "Unknown";
    }

    private static final String $$robo$$android_webkit_WebViewFactory$getWebViewLibrary(ApplicationInfo ai) {
        if (ai.metaData != null) {
            return ai.metaData.getString("com.android.webview.WebViewLibrary");
        }
        return null;
    }

    private static final PackageInfo $$robo$$android_webkit_WebViewFactory$getLoadedPackageInfo() {
        return sPackageInfo;
    }

    private static final int $$robo$$android_webkit_WebViewFactory$loadWebViewNativeLibraryFromPackage(String packageName, ClassLoader clazzLoader) {
        PackageInfo packageInfo;
        WebViewProviderResponse response = null;
        try {
            response = WebViewFactory.getUpdateService().waitForAndGetProvider();
        }
        catch (RemoteException e) {
            Log.e("WebViewFactory", "error waiting for relro creation", e);
            return 8;
        }
        if (response.status != 0 && response.status != 3) {
            return response.status;
        }
        if (!response.packageInfo.packageName.equals(packageName)) {
            return 1;
        }
        PackageManager packageManager = AppGlobals.getInitialApplication().getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0x10000080);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("WebViewFactory", "Couldn't find package " + packageName);
            return 1;
        }
        sPackageInfo = packageInfo;
        int loadNativeRet = WebViewFactory.loadNativeLibrary(clazzLoader);
        if (loadNativeRet == 0) {
            return response.status;
        }
        return loadNativeRet;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static final WebViewFactoryProvider $$robo$$android_webkit_WebViewFactory$getProvider() {
        Object object = sProviderLock;
        synchronized (object) {
            if (sProviderInstance != null) {
                return sProviderInstance;
            }
            int uid = Process.myUid();
            if (uid == 0 || uid == 1000) {
                throw new UnsupportedOperationException("For security reasons, WebView is not allowed in privileged processes");
            }
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            Trace.traceBegin(16L, "WebViewFactory.getProvider()");
            try {
                WebViewFactoryProvider webViewFactoryProvider;
                Class<WebViewFactoryProvider> providerClass = WebViewFactory.getProviderClass();
                Trace.traceBegin(16L, "providerClass.newInstance()");
                try {
                    webViewFactoryProvider = sProviderInstance = providerClass.getConstructor(WebViewDelegate.class).newInstance(new WebViewDelegate());
                }
                catch (Exception e) {
                    Log.e("WebViewFactory", "error instantiating provider", e);
                    throw new AndroidRuntimeException(e);
                }
                finally {
                    Trace.traceEnd(16L);
                }
                return webViewFactoryProvider;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Trace.traceEnd(16L);
                StrictMode.setThreadPolicy(oldPolicy);
            }
        }
    }

    private static final boolean $$robo$$android_webkit_WebViewFactory$signaturesEquals(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        ArraySet<Signature> set1 = new ArraySet<Signature>();
        for (Signature signature : s1) {
            set1.add(signature);
        }
        ArraySet<Signature> set2 = new ArraySet<Signature>();
        for (Signature signature : s2) {
            set2.add(signature);
        }
        return set1.equals(set2);
    }

    private static final void $$robo$$android_webkit_WebViewFactory$verifyPackageInfo(PackageInfo chosen, PackageInfo toUse) {
        if (!chosen.packageName.equals(toUse.packageName)) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, packageName mismatch, expected: " + chosen.packageName + " actual: " + toUse.packageName);
        }
        if (chosen.versionCode > toUse.versionCode) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, version code is lower than expected: " + chosen.versionCode + " actual: " + toUse.versionCode);
        }
        if (WebViewFactory.getWebViewLibrary(toUse.applicationInfo) == null) {
            throw new MissingWebViewPackageException("Tried to load an invalid WebView provider: " + toUse.packageName);
        }
        if (!WebViewFactory.signaturesEquals(chosen.signatures, toUse.signatures)) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, signature mismatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Context $$robo$$android_webkit_WebViewFactory$getWebViewContextAndSetProvider() {
        Context context;
        Application initialApplication = AppGlobals.getInitialApplication();
        WebViewProviderResponse response = null;
        Trace.traceBegin(16L, "WebViewUpdateService.waitForAndGetProvider()");
        try {
            response = WebViewFactory.getUpdateService().waitForAndGetProvider();
        }
        finally {
            Trace.traceEnd(16L);
        }
        if (response.status != 0 && response.status != 3) {
            throw new MissingWebViewPackageException("Failed to load WebView provider: " + WebViewFactory.getWebViewPreparationErrorReason(response.status));
        }
        Trace.traceBegin(16L, "ActivityManager.addPackageDependency()");
        try {
            ActivityManagerNative.getDefault().addPackageDependency(response.packageInfo.packageName);
        }
        finally {
            Trace.traceEnd(16L);
        }
        PackageInfo newPackageInfo = null;
        Trace.traceBegin(16L, "PackageManager.getPackageInfo()");
        try {
            newPackageInfo = initialApplication.getPackageManager().getPackageInfo(response.packageInfo.packageName, 268444864);
        }
        finally {
            Trace.traceEnd(16L);
        }
        WebViewFactory.verifyPackageInfo(response.packageInfo, newPackageInfo);
        Trace.traceBegin(16L, "initialApplication.createApplicationContext");
        try {
            Context webViewContext = initialApplication.createApplicationContext(newPackageInfo.applicationInfo, 3);
            sPackageInfo = newPackageInfo;
            context = webViewContext;
        }
        catch (Throwable throwable) {
            try {
                Trace.traceEnd(16L);
                throw throwable;
            }
            catch (PackageManager.NameNotFoundException | RemoteException e) {
                throw new MissingWebViewPackageException("Failed to load WebView provider: " + e);
            }
        }
        Trace.traceEnd(16L);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static final Class<WebViewFactoryProvider> $$robo$$android_webkit_WebViewFactory$getProviderClass() {
        Context webViewContext = null;
        Application initialApplication = AppGlobals.getInitialApplication();
        try {
            Trace.traceBegin(16L, "WebViewFactory.getWebViewContextAndSetProvider()");
            try {
                webViewContext = WebViewFactory.getWebViewContextAndSetProvider();
            }
            finally {
                Trace.traceEnd(16L);
            }
            Log.i("WebViewFactory", "Loading " + WebViewFactory.sPackageInfo.packageName + " version " + WebViewFactory.sPackageInfo.versionName + " (code " + WebViewFactory.sPackageInfo.versionCode + ")");
            Trace.traceBegin(16L, "WebViewFactory.getChromiumProviderClass()");
            try {
                Class<WebViewFactoryProvider> clazz;
                initialApplication.getAssets().addAssetPathAsSharedLibrary(webViewContext.getApplicationInfo().sourceDir);
                ClassLoader clazzLoader = webViewContext.getClassLoader();
                Trace.traceBegin(16L, "WebViewFactory.loadNativeLibrary()");
                WebViewFactory.loadNativeLibrary(clazzLoader);
                Trace.traceEnd(16L);
                Trace.traceBegin(16L, "Class.forName()");
                try {
                    clazz = Class.forName("com.android.webview.chromium.WebViewChromiumFactoryProvider", true, clazzLoader);
                }
                catch (Throwable throwable) {
                    try {
                        Trace.traceEnd(16L);
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        Log.e("WebViewFactory", "error loading provider", e);
                        throw new AndroidRuntimeException(e);
                    }
                }
                Trace.traceEnd(16L);
                return clazz;
            }
            finally {
                Trace.traceEnd(16L);
            }
        }
        catch (MissingWebViewPackageException e) {
            try {
                return Class.forName("com.android.webview.nullwebview.NullWebViewFactoryProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.e("WebViewFactory", "Chromium WebView package does not exist", e);
                throw new AndroidRuntimeException(e);
            }
        }
    }

    private static final void $$robo$$android_webkit_WebViewFactory$prepareWebViewInZygote() {
        try {
            InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"webviewchromium_loader");
            long addressSpaceToReserve = SystemProperties.getLong("persist.sys.webview.vmsize", 0x6400000L);
            sAddressSpaceReserved = WebViewFactory.nativeReserveAddressSpace(addressSpaceToReserve);
            if (!sAddressSpaceReserved) {
                Log.e("WebViewFactory", "reserving " + addressSpaceToReserve + " bytes of address space failed");
            }
        }
        catch (Throwable t) {
            Log.e("WebViewFactory", "error preparing native loader", t);
        }
    }

    private static final int $$robo$$android_webkit_WebViewFactory$prepareWebViewInSystemServer(String[] nativeLibraryPaths) {
        int numRelros = 0;
        if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(false, nativeLibraryPaths);
            ++numRelros;
        }
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(true, nativeLibraryPaths);
            ++numRelros;
        }
        return numRelros;
    }

    private static final int $$robo$$android_webkit_WebViewFactory$onWebViewProviderChanged(PackageInfo packageInfo) {
        String[] nativeLibs;
        block22: {
            nativeLibs = null;
            try {
                nativeLibs = WebViewFactory.getWebViewNativeLibraryPaths(packageInfo);
                if (nativeLibs == null) break block22;
                long newVmSize = 0L;
                for (String path : nativeLibs) {
                    String[] split;
                    if (path == null || TextUtils.isEmpty(path)) continue;
                    File f = new File(path);
                    if (f.exists()) {
                        newVmSize = Math.max(newVmSize, f.length());
                        continue;
                    }
                    if (path.contains("!/") && (split = TextUtils.split(path, "!/")).length == 2) {
                        try (ZipFile z = new ZipFile(split[0]);){
                            ZipEntry e = z.getEntry(split[1]);
                            if (e != null && e.getMethod() == 0) {
                                newVmSize = Math.max(newVmSize, e.getSize());
                                continue;
                            }
                        }
                        catch (IOException e) {
                            Log.e("WebViewFactory", "error reading APK file " + split[0] + ", ", e);
                        }
                    }
                    Log.e("WebViewFactory", "error sizing load for " + path);
                }
                newVmSize = Math.max(2L * newVmSize, 0x6400000L);
                Log.d("WebViewFactory", "Setting new address space to " + newVmSize);
                SystemProperties.set("persist.sys.webview.vmsize", Long.toString(newVmSize));
            }
            catch (Throwable t) {
                Log.e("WebViewFactory", "error preparing webview native library", t);
            }
        }
        return WebViewFactory.prepareWebViewInSystemServer(nativeLibs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String $$robo$$android_webkit_WebViewFactory$getLoadFromApkPath(String apkPath, String[] abiList, String nativeLibFileName) {
        try (ZipFile z = new ZipFile(apkPath);){
            String[] stringArray = abiList;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String abi = stringArray[n2];
                String entry = "lib/" + abi + "/" + nativeLibFileName;
                ZipEntry e = z.getEntry(entry);
                if (e != null && e.getMethod() == 0) {
                    String string2 = apkPath + "!/" + entry;
                    return string2;
                }
                ++n2;
            }
            return "";
        }
        catch (IOException e) {
            throw new MissingWebViewPackageException(e);
        }
    }

    private static final String[] $$robo$$android_webkit_WebViewFactory$getWebViewNativeLibraryPaths(PackageInfo packageInfo) {
        File f;
        String path32;
        String path64;
        ApplicationInfo ai = packageInfo.applicationInfo;
        String NATIVE_LIB_FILE_NAME = WebViewFactory.getWebViewLibrary(ai);
        boolean primaryArchIs64bit = VMRuntime.is64BitAbi(ai.primaryCpuAbi);
        if (!TextUtils.isEmpty(ai.secondaryCpuAbi)) {
            if (primaryArchIs64bit) {
                path64 = ai.nativeLibraryDir;
                path32 = ai.secondaryNativeLibraryDir;
            } else {
                path64 = ai.secondaryNativeLibraryDir;
                path32 = ai.nativeLibraryDir;
            }
        } else if (primaryArchIs64bit) {
            path64 = ai.nativeLibraryDir;
            path32 = "";
        } else {
            path32 = ai.nativeLibraryDir;
            path64 = "";
        }
        if (!TextUtils.isEmpty(path32) && !(f = new File(path32 = path32 + "/" + NATIVE_LIB_FILE_NAME)).exists()) {
            path32 = WebViewFactory.getLoadFromApkPath(ai.sourceDir, Build.SUPPORTED_32_BIT_ABIS, NATIVE_LIB_FILE_NAME);
        }
        if (!TextUtils.isEmpty(path64) && !(f = new File(path64 = path64 + "/" + NATIVE_LIB_FILE_NAME)).exists()) {
            path64 = WebViewFactory.getLoadFromApkPath(ai.sourceDir, Build.SUPPORTED_64_BIT_ABIS, NATIVE_LIB_FILE_NAME);
        }
        return new String[]{path32, path64};
    }

    private static final void $$robo$$android_webkit_WebViewFactory$createRelroFile(boolean is64Bit, String[] nativeLibraryPaths) {
        String abi = is64Bit ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable crashHandler = new Runnable(abi){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$abi;

            private void $$robo$$android_webkit_WebViewFactory_1$__constructor__(String string2) {
            }

            private final void $$robo$$android_webkit_WebViewFactory_1$run() {
                try {
                    Log.e("WebViewFactory", "relro file creator for " + this.val$abi + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e("WebViewFactory", "Cannot reach WebViewUpdateService. " + e.getMessage());
                }
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_webkit_WebViewFactory_1$__constructor__(string2);
            }
            {
                this.val$abi = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory_1$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_webkit_WebViewFactory_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            if (nativeLibraryPaths == null || nativeLibraryPaths[0] == null || nativeLibraryPaths[1] == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            int pid = LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), nativeLibraryPaths, "WebViewLoader-" + abi, abi, 1037, crashHandler);
            if (pid <= 0) {
                throw new Exception("Failed to start the relro file creator process");
            }
        }
        catch (Throwable t) {
            Log.e("WebViewFactory", "error starting relro file creator for abi " + abi, t);
            crashHandler.run();
        }
    }

    private static final int $$robo$$android_webkit_WebViewFactory$loadNativeLibrary(ClassLoader clazzLoader) {
        if (!sAddressSpaceReserved) {
            Log.e("WebViewFactory", "can't load with relro file; address space not reserved");
            return 2;
        }
        String[] args = WebViewFactory.getWebViewNativeLibraryPaths(sPackageInfo);
        int result = WebViewFactory.nativeLoadWithRelroFile(args[0], args[1], "/data/misc/shared_relro/libwebviewchromium32.relro", "/data/misc/shared_relro/libwebviewchromium64.relro", clazzLoader);
        if (result != 0) {
            Log.w("WebViewFactory", "failed to load with relro file, proceeding without");
        }
        return result;
    }

    private static final IWebViewUpdateService $$robo$$android_webkit_WebViewFactory$getUpdateService() {
        return IWebViewUpdateService.Stub.asInterface(ServiceManager.getService(WEBVIEW_UPDATE_SERVICE_NAME));
    }

    private static final boolean $$robo$$android_webkit_WebViewFactory$nativeReserveAddressSpace(long l) {
        return false;
    }

    private static final boolean $$robo$$android_webkit_WebViewFactory$nativeCreateRelroFile(String string2, String string3, String string4, String string5) {
        return false;
    }

    private static final int $$robo$$android_webkit_WebViewFactory$nativeLoadWithRelroFile(String string2, String string3, String string4, String string5, ClassLoader classLoader) {
        return 0;
    }

    static void __staticInitializer__() {
        sProviderLock = new Object();
        sAddressSpaceReserved = false;
        WEBVIEW_UPDATE_SERVICE_NAME = "webviewupdate";
    }

    private void __constructor__() {
        this.$$robo$$android_webkit_WebViewFactory$__constructor__();
    }

    public WebViewFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory$__constructor__(), 0, this);
    }

    private static String getWebViewPreparationErrorReason(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewPreparationErrorReason", $$robo$$android_webkit_WebViewFactory$getWebViewPreparationErrorReason(int ), 0, (int)n);
    }

    public static String getWebViewLibrary(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewLibrary", $$robo$$android_webkit_WebViewFactory$getWebViewLibrary(android.content.pm.ApplicationInfo ), 0, (ApplicationInfo)applicationInfo);
    }

    public static PackageInfo getLoadedPackageInfo() {
        return InvokeDynamicSupport.bootstrapStatic("getLoadedPackageInfo", $$robo$$android_webkit_WebViewFactory$getLoadedPackageInfo(), 0);
    }

    public static int loadWebViewNativeLibraryFromPackage(String string2, ClassLoader classLoader) {
        return (int)InvokeDynamicSupport.bootstrapStatic("loadWebViewNativeLibraryFromPackage", $$robo$$android_webkit_WebViewFactory$loadWebViewNativeLibraryFromPackage(java.lang.String java.lang.ClassLoader ), 0, (String)string2, (ClassLoader)classLoader);
    }

    static WebViewFactoryProvider getProvider() {
        return InvokeDynamicSupport.bootstrapStatic("getProvider", $$robo$$android_webkit_WebViewFactory$getProvider(), 0);
    }

    private static boolean signaturesEquals(Signature[] signatureArray, Signature[] signatureArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("signaturesEquals", $$robo$$android_webkit_WebViewFactory$signaturesEquals(android.content.pm.Signature[] android.content.pm.Signature[] ), 0, (Signature[])signatureArray, (Signature[])signatureArray2);
    }

    private static void verifyPackageInfo(PackageInfo packageInfo, PackageInfo packageInfo2) {
        InvokeDynamicSupport.bootstrapStatic("verifyPackageInfo", $$robo$$android_webkit_WebViewFactory$verifyPackageInfo(android.content.pm.PackageInfo android.content.pm.PackageInfo ), 0, (PackageInfo)packageInfo, (PackageInfo)packageInfo2);
    }

    private static Context getWebViewContextAndSetProvider() {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewContextAndSetProvider", $$robo$$android_webkit_WebViewFactory$getWebViewContextAndSetProvider(), 0);
    }

    private static Class<WebViewFactoryProvider> getProviderClass() {
        return InvokeDynamicSupport.bootstrapStatic("getProviderClass", $$robo$$android_webkit_WebViewFactory$getProviderClass(), 0);
    }

    public static void prepareWebViewInZygote() {
        InvokeDynamicSupport.bootstrapStatic("prepareWebViewInZygote", $$robo$$android_webkit_WebViewFactory$prepareWebViewInZygote(), 0);
    }

    private static int prepareWebViewInSystemServer(String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("prepareWebViewInSystemServer", $$robo$$android_webkit_WebViewFactory$prepareWebViewInSystemServer(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static int onWebViewProviderChanged(PackageInfo packageInfo) {
        return (int)InvokeDynamicSupport.bootstrapStatic("onWebViewProviderChanged", $$robo$$android_webkit_WebViewFactory$onWebViewProviderChanged(android.content.pm.PackageInfo ), 0, (PackageInfo)packageInfo);
    }

    private static String getLoadFromApkPath(String string2, String[] stringArray, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getLoadFromApkPath", $$robo$$android_webkit_WebViewFactory$getLoadFromApkPath(java.lang.String java.lang.String[] java.lang.String ), 0, (String)string2, (String[])stringArray, (String)string3);
    }

    private static String[] getWebViewNativeLibraryPaths(PackageInfo packageInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewNativeLibraryPaths", $$robo$$android_webkit_WebViewFactory$getWebViewNativeLibraryPaths(android.content.pm.PackageInfo ), 0, (PackageInfo)packageInfo);
    }

    private static void createRelroFile(boolean bl, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("createRelroFile", $$robo$$android_webkit_WebViewFactory$createRelroFile(boolean java.lang.String[] ), 0, (boolean)bl, (String[])stringArray);
    }

    private static int loadNativeLibrary(ClassLoader classLoader) {
        return (int)InvokeDynamicSupport.bootstrapStatic("loadNativeLibrary", $$robo$$android_webkit_WebViewFactory$loadNativeLibrary(java.lang.ClassLoader ), 0, (ClassLoader)classLoader);
    }

    public static IWebViewUpdateService getUpdateService() {
        return InvokeDynamicSupport.bootstrapStatic("getUpdateService", $$robo$$android_webkit_WebViewFactory$getUpdateService(), 0);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeReserveAddressSpace$nativeBinding(long var0);

    private static boolean nativeReserveAddressSpace(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeReserveAddressSpace", $$robo$$android_webkit_WebViewFactory$nativeReserveAddressSpace(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeCreateRelroFile$nativeBinding(String var0, String var1, String var2, String var3);

    private static boolean nativeCreateRelroFile(String string2, String string3, String string4, String string5) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeCreateRelroFile", $$robo$$android_webkit_WebViewFactory$nativeCreateRelroFile(java.lang.String java.lang.String java.lang.String java.lang.String ), 1, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    private static final native /* synthetic */ int $$robo$$nativeLoadWithRelroFile$nativeBinding(String var0, String var1, String var2, String var3, ClassLoader var4);

    private static int nativeLoadWithRelroFile(String string2, String string3, String string4, String string5, ClassLoader classLoader) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeLoadWithRelroFile", $$robo$$android_webkit_WebViewFactory$nativeLoadWithRelroFile(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.ClassLoader ), 1, (String)string2, (String)string3, (String)string4, (String)string5, (ClassLoader)classLoader);
    }

    static {
        RobolectricInternals.classInitializing(WebViewFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebViewFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class RelroFileCreator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_webkit_WebViewFactory_RelroFileCreator$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void $$robo$$android_webkit_WebViewFactory_RelroFileCreator$main(String[] args) {
            boolean result = false;
            boolean is64Bit = VMRuntime.getRuntime().is64Bit();
            try {
                if (args.length != 2 || args[0] == null || args[1] == null) {
                    Log.e("WebViewFactory", "Invalid RelroFileCreator args: " + Arrays.toString(args));
                    return;
                }
                Log.v("WebViewFactory", "RelroFileCreator (64bit = " + is64Bit + "),  32-bit lib: " + args[0] + ", 64-bit lib: " + args[1]);
                if (!sAddressSpaceReserved) {
                    Log.e("WebViewFactory", "can't create relro file; address space not reserved");
                    return;
                }
                result = WebViewFactory.nativeCreateRelroFile(args[0], args[1], "/data/misc/shared_relro/libwebviewchromium32.relro", "/data/misc/shared_relro/libwebviewchromium64.relro");
                if (result) {
                    // empty if block
                }
            }
            finally {
                try {
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e("WebViewFactory", "error notifying update service", e);
                }
                if (!result) {
                    Log.e("WebViewFactory", "failed to create relro file");
                }
                System.exit(0);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_webkit_WebViewFactory_RelroFileCreator$__constructor__();
        }

        private RelroFileCreator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory_RelroFileCreator$__constructor__(), 0, this);
        }

        public static void main(String[] stringArray) {
            InvokeDynamicSupport.bootstrapStatic("main", $$robo$$android_webkit_WebViewFactory_RelroFileCreator$main(java.lang.String[] ), 0, (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelroFileCreator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MissingWebViewPackageException
    extends AndroidRuntimeException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(String message) {
        }

        private void $$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(Exception e) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(string2);
        }

        public MissingWebViewPackageException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(Exception exception) {
            this.$$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(exception);
        }

        public MissingWebViewPackageException(Exception exception) {
            super(exception);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory_MissingWebViewPackageException$__constructor__(java.lang.Exception ), 0, this, exception);
        }

        public /* synthetic */ MissingWebViewPackageException() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MissingWebViewPackageException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

