/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.Handler;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;
import dalvik.system.CloseGuard;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Animation
implements Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int INFINITE = -1;
    public static int RESTART = 1;
    public static int REVERSE = 2;
    public static int START_ON_FIRST_FRAME = -1;
    public static int ABSOLUTE = 0;
    public static int RELATIVE_TO_SELF = 1;
    public static int RELATIVE_TO_PARENT = 2;
    public static int ZORDER_NORMAL = 0;
    public static int ZORDER_TOP = 1;
    public static int ZORDER_BOTTOM = -1;
    boolean mEnded;
    boolean mStarted;
    boolean mCycleFlip;
    boolean mInitialized;
    boolean mFillBefore;
    boolean mFillAfter;
    boolean mFillEnabled;
    long mStartTime;
    long mStartOffset;
    long mDuration;
    int mRepeatCount;
    int mRepeated;
    int mRepeatMode;
    Interpolator mInterpolator;
    AnimationListener mListener;
    private int mZAdjustment;
    private int mBackgroundColor;
    private float mScaleFactor;
    private boolean mDetachWallpaper;
    private boolean mMore;
    private boolean mOneMoreTime;
    RectF mPreviousRegion;
    RectF mRegion;
    Transformation mTransformation;
    Transformation mPreviousTransformation;
    private CloseGuard guard;
    private Handler mListenerHandler;
    private Runnable mOnStart;
    private Runnable mOnRepeat;
    private Runnable mOnEnd;

    private void $$robo$$android_view_animation_Animation$__constructor__() {
        this.mEnded = false;
        this.mStarted = false;
        this.mCycleFlip = false;
        this.mInitialized = false;
        this.mFillBefore = true;
        this.mFillAfter = false;
        this.mFillEnabled = false;
        this.mStartTime = -1L;
        this.mRepeatCount = 0;
        this.mRepeated = 0;
        this.mRepeatMode = 1;
        this.mScaleFactor = 1.0f;
        this.mDetachWallpaper = false;
        this.mMore = true;
        this.mOneMoreTime = true;
        this.mPreviousRegion = new RectF();
        this.mRegion = new RectF();
        this.mTransformation = new Transformation();
        this.mPreviousTransformation = new Transformation();
        this.guard = CloseGuard.get();
        this.ensureInterpolator();
    }

    private void $$robo$$android_view_animation_Animation$__constructor__(Context context, AttributeSet attrs) {
        this.mEnded = false;
        this.mStarted = false;
        this.mCycleFlip = false;
        this.mInitialized = false;
        this.mFillBefore = true;
        this.mFillAfter = false;
        this.mFillEnabled = false;
        this.mStartTime = -1L;
        this.mRepeatCount = 0;
        this.mRepeated = 0;
        this.mRepeatMode = 1;
        this.mScaleFactor = 1.0f;
        this.mDetachWallpaper = false;
        this.mMore = true;
        this.mOneMoreTime = true;
        this.mPreviousRegion = new RectF();
        this.mRegion = new RectF();
        this.mTransformation = new Transformation();
        this.mPreviousTransformation = new Transformation();
        this.guard = CloseGuard.get();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Animation);
        this.setDuration(a.getInt(2, 0));
        this.setStartOffset(a.getInt(5, 0));
        this.setFillEnabled(a.getBoolean(9, this.mFillEnabled));
        this.setFillBefore(a.getBoolean(3, this.mFillBefore));
        this.setFillAfter(a.getBoolean(4, this.mFillAfter));
        this.setRepeatCount(a.getInt(6, this.mRepeatCount));
        this.setRepeatMode(a.getInt(7, 1));
        this.setZAdjustment(a.getInt(8, 0));
        this.setBackgroundColor(a.getInt(0, 0));
        this.setDetachWallpaper(a.getBoolean(10, false));
        int resID = a.getResourceId(1, 0);
        a.recycle();
        if (resID > 0) {
            this.setInterpolator(context, resID);
        }
        this.ensureInterpolator();
    }

    private final Animation $$robo$$android_view_animation_Animation$clone() throws CloneNotSupportedException {
        Animation animation = (Animation)super.clone();
        animation.mPreviousRegion = new RectF();
        animation.mRegion = new RectF();
        animation.mTransformation = new Transformation();
        animation.mPreviousTransformation = new Transformation();
        return animation;
    }

    private final void $$robo$$android_view_animation_Animation$reset() {
        this.mPreviousRegion.setEmpty();
        this.mPreviousTransformation.clear();
        this.mInitialized = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
        this.mOneMoreTime = true;
        this.mListenerHandler = null;
    }

    private final void $$robo$$android_view_animation_Animation$cancel() {
        if (this.mStarted && !this.mEnded) {
            this.fireAnimationEnd();
            this.mEnded = true;
            this.guard.close();
        }
        this.mStartTime = Long.MIN_VALUE;
        this.mOneMoreTime = false;
        this.mMore = false;
    }

    private final void $$robo$$android_view_animation_Animation$detach() {
        if (this.mStarted && !this.mEnded) {
            this.mEnded = true;
            this.guard.close();
            this.fireAnimationEnd();
        }
    }

    private final boolean $$robo$$android_view_animation_Animation$isInitialized() {
        return this.mInitialized;
    }

    private final void $$robo$$android_view_animation_Animation$initialize(int width, int height, int parentWidth, int parentHeight) {
        this.reset();
        this.mInitialized = true;
    }

    private final void $$robo$$android_view_animation_Animation$setListenerHandler(Handler handler) {
        if (this.mListenerHandler == null) {
            this.mOnStart = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Animation this$0;

                private void $$robo$$android_view_animation_Animation_1$__constructor__(Animation this$0) {
                }

                private final void $$robo$$android_view_animation_Animation_1$run() {
                    if (this.this$0.mListener != null) {
                        this.this$0.mListener.onAnimationStart(this.this$0);
                    }
                }

                private void __constructor__(Animation animation) {
                    this.$$robo$$android_view_animation_Animation_1$__constructor__(animation);
                }
                {
                    this.this$0 = animation;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_Animation_1$__constructor__(android.view.animation.Animation ), 0, this, animation);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_animation_Animation_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mOnRepeat = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Animation this$0;

                private void $$robo$$android_view_animation_Animation_2$__constructor__(Animation this$0) {
                }

                private final void $$robo$$android_view_animation_Animation_2$run() {
                    if (this.this$0.mListener != null) {
                        this.this$0.mListener.onAnimationRepeat(this.this$0);
                    }
                }

                private void __constructor__(Animation animation) {
                    this.$$robo$$android_view_animation_Animation_2$__constructor__(animation);
                }
                {
                    this.this$0 = animation;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_Animation_2$__constructor__(android.view.animation.Animation ), 0, this, animation);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_animation_Animation_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mOnEnd = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Animation this$0;

                private void $$robo$$android_view_animation_Animation_3$__constructor__(Animation this$0) {
                }

                private final void $$robo$$android_view_animation_Animation_3$run() {
                    if (this.this$0.mListener != null) {
                        this.this$0.mListener.onAnimationEnd(this.this$0);
                    }
                }

                private void __constructor__(Animation animation) {
                    this.$$robo$$android_view_animation_Animation_3$__constructor__(animation);
                }
                {
                    this.this$0 = animation;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_Animation_3$__constructor__(android.view.animation.Animation ), 0, this, animation);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_animation_Animation_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        this.mListenerHandler = handler;
    }

    private final void $$robo$$android_view_animation_Animation$setInterpolator(Context context, int resID) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, resID));
    }

    private final void $$robo$$android_view_animation_Animation$setInterpolator(Interpolator i) {
        this.mInterpolator = i;
    }

    private final void $$robo$$android_view_animation_Animation$setStartOffset(long startOffset) {
        this.mStartOffset = startOffset;
    }

    private final void $$robo$$android_view_animation_Animation$setDuration(long durationMillis) {
        if (durationMillis < 0L) {
            throw new IllegalArgumentException("Animation duration cannot be negative");
        }
        this.mDuration = durationMillis;
    }

    private final void $$robo$$android_view_animation_Animation$restrictDuration(long durationMillis) {
        if (this.mStartOffset > durationMillis) {
            this.mStartOffset = durationMillis;
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        long dur = this.mDuration + this.mStartOffset;
        if (dur > durationMillis) {
            this.mDuration = durationMillis - this.mStartOffset;
            dur = durationMillis;
        }
        if (this.mDuration <= 0L) {
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        if (this.mRepeatCount < 0 || (long)this.mRepeatCount > durationMillis || dur * (long)this.mRepeatCount > durationMillis) {
            this.mRepeatCount = (int)(durationMillis / dur) - 1;
            if (this.mRepeatCount < 0) {
                this.mRepeatCount = 0;
            }
        }
    }

    private final void $$robo$$android_view_animation_Animation$scaleCurrentDuration(float scale) {
        this.mDuration = (long)((float)this.mDuration * scale);
        this.mStartOffset = (long)((float)this.mStartOffset * scale);
    }

    private final void $$robo$$android_view_animation_Animation$setStartTime(long startTimeMillis) {
        this.mStartTime = startTimeMillis;
        this.mEnded = false;
        this.mStarted = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
    }

    private final void $$robo$$android_view_animation_Animation$start() {
        this.setStartTime(-1L);
    }

    private final void $$robo$$android_view_animation_Animation$startNow() {
        this.setStartTime(AnimationUtils.currentAnimationTimeMillis());
    }

    private final void $$robo$$android_view_animation_Animation$setRepeatMode(int repeatMode) {
        this.mRepeatMode = repeatMode;
    }

    private final void $$robo$$android_view_animation_Animation$setRepeatCount(int repeatCount) {
        if (repeatCount < 0) {
            repeatCount = -1;
        }
        this.mRepeatCount = repeatCount;
    }

    private final boolean $$robo$$android_view_animation_Animation$isFillEnabled() {
        return this.mFillEnabled;
    }

    private final void $$robo$$android_view_animation_Animation$setFillEnabled(boolean fillEnabled) {
        this.mFillEnabled = fillEnabled;
    }

    private final void $$robo$$android_view_animation_Animation$setFillBefore(boolean fillBefore) {
        this.mFillBefore = fillBefore;
    }

    private final void $$robo$$android_view_animation_Animation$setFillAfter(boolean fillAfter) {
        this.mFillAfter = fillAfter;
    }

    private final void $$robo$$android_view_animation_Animation$setZAdjustment(int zAdjustment) {
        this.mZAdjustment = zAdjustment;
    }

    private final void $$robo$$android_view_animation_Animation$setBackgroundColor(int bg) {
        this.mBackgroundColor = bg;
    }

    private final float $$robo$$android_view_animation_Animation$getScaleFactor() {
        return this.mScaleFactor;
    }

    private final void $$robo$$android_view_animation_Animation$setDetachWallpaper(boolean detachWallpaper) {
        this.mDetachWallpaper = detachWallpaper;
    }

    private final Interpolator $$robo$$android_view_animation_Animation$getInterpolator() {
        return this.mInterpolator;
    }

    private final long $$robo$$android_view_animation_Animation$getStartTime() {
        return this.mStartTime;
    }

    private final long $$robo$$android_view_animation_Animation$getDuration() {
        return this.mDuration;
    }

    private final long $$robo$$android_view_animation_Animation$getStartOffset() {
        return this.mStartOffset;
    }

    private final int $$robo$$android_view_animation_Animation$getRepeatMode() {
        return this.mRepeatMode;
    }

    private final int $$robo$$android_view_animation_Animation$getRepeatCount() {
        return this.mRepeatCount;
    }

    private final boolean $$robo$$android_view_animation_Animation$getFillBefore() {
        return this.mFillBefore;
    }

    private final boolean $$robo$$android_view_animation_Animation$getFillAfter() {
        return this.mFillAfter;
    }

    private final int $$robo$$android_view_animation_Animation$getZAdjustment() {
        return this.mZAdjustment;
    }

    private final int $$robo$$android_view_animation_Animation$getBackgroundColor() {
        return this.mBackgroundColor;
    }

    private final boolean $$robo$$android_view_animation_Animation$getDetachWallpaper() {
        return this.mDetachWallpaper;
    }

    private final boolean $$robo$$android_view_animation_Animation$willChangeTransformationMatrix() {
        return true;
    }

    private final boolean $$robo$$android_view_animation_Animation$willChangeBounds() {
        return true;
    }

    private final void $$robo$$android_view_animation_Animation$setAnimationListener(AnimationListener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_view_animation_Animation$ensureInterpolator() {
        if (this.mInterpolator == null) {
            this.mInterpolator = new AccelerateDecelerateInterpolator();
        }
    }

    private final long $$robo$$android_view_animation_Animation$computeDurationHint() {
        return (this.getStartOffset() + this.getDuration()) * (long)(this.getRepeatCount() + 1);
    }

    private final boolean $$robo$$android_view_animation_Animation$getTransformation(long currentTime, Transformation outTransformation) {
        if (this.mStartTime == -1L) {
            this.mStartTime = currentTime;
        }
        long startOffset = this.getStartOffset();
        long duration = this.mDuration;
        float normalizedTime = duration != 0L ? (float)(currentTime - (this.mStartTime + startOffset)) / (float)duration : (currentTime < this.mStartTime ? 0.0f : 1.0f);
        boolean expired = normalizedTime >= 1.0f || this.isCanceled();
        boolean bl = this.mMore = !expired;
        if (!this.mFillEnabled) {
            normalizedTime = Math.max(Math.min(normalizedTime, 1.0f), 0.0f);
        }
        if ((normalizedTime >= 0.0f || this.mFillBefore) && (normalizedTime <= 1.0f || this.mFillAfter)) {
            if (!this.mStarted) {
                this.fireAnimationStart();
                this.mStarted = true;
                if (NoImagePreloadHolder.USE_CLOSEGUARD) {
                    this.guard.open("cancel or detach or getTransformation");
                }
            }
            if (this.mFillEnabled) {
                normalizedTime = Math.max(Math.min(normalizedTime, 1.0f), 0.0f);
            }
            if (this.mCycleFlip) {
                normalizedTime = 1.0f - normalizedTime;
            }
            float interpolatedTime = this.mInterpolator.getInterpolation(normalizedTime);
            this.applyTransformation(interpolatedTime, outTransformation);
        }
        if (expired) {
            if (this.mRepeatCount == this.mRepeated || this.isCanceled()) {
                if (!this.mEnded) {
                    this.mEnded = true;
                    this.guard.close();
                    this.fireAnimationEnd();
                }
            } else {
                if (this.mRepeatCount > 0) {
                    ++this.mRepeated;
                }
                if (this.mRepeatMode == 2) {
                    this.mCycleFlip = !this.mCycleFlip;
                }
                this.mStartTime = -1L;
                this.mMore = true;
                this.fireAnimationRepeat();
            }
        }
        if (!this.mMore && this.mOneMoreTime) {
            this.mOneMoreTime = false;
            return true;
        }
        return this.mMore;
    }

    private final boolean $$robo$$android_view_animation_Animation$isCanceled() {
        return this.mStartTime == Long.MIN_VALUE;
    }

    private final void $$robo$$android_view_animation_Animation$fireAnimationStart() {
        if (this.mListener != null) {
            if (this.mListenerHandler == null) {
                this.mListener.onAnimationStart(this);
            } else {
                this.mListenerHandler.postAtFrontOfQueue(this.mOnStart);
            }
        }
    }

    private final void $$robo$$android_view_animation_Animation$fireAnimationRepeat() {
        if (this.mListener != null) {
            if (this.mListenerHandler == null) {
                this.mListener.onAnimationRepeat(this);
            } else {
                this.mListenerHandler.postAtFrontOfQueue(this.mOnRepeat);
            }
        }
    }

    private final void $$robo$$android_view_animation_Animation$fireAnimationEnd() {
        if (this.mListener != null) {
            if (this.mListenerHandler == null) {
                this.mListener.onAnimationEnd(this);
            } else {
                this.mListenerHandler.postAtFrontOfQueue(this.mOnEnd);
            }
        }
    }

    private final boolean $$robo$$android_view_animation_Animation$getTransformation(long currentTime, Transformation outTransformation, float scale) {
        this.mScaleFactor = scale;
        return this.getTransformation(currentTime, outTransformation);
    }

    private final boolean $$robo$$android_view_animation_Animation$hasStarted() {
        return this.mStarted;
    }

    private final boolean $$robo$$android_view_animation_Animation$hasEnded() {
        return this.mEnded;
    }

    private final void $$robo$$android_view_animation_Animation$applyTransformation(float interpolatedTime, Transformation t) {
    }

    private final float $$robo$$android_view_animation_Animation$resolveSize(int type, float value, int size, int parentSize) {
        switch (type) {
            case 0: {
                return value;
            }
            case 1: {
                return (float)size * value;
            }
            case 2: {
                return (float)parentSize * value;
            }
        }
        return value;
    }

    private final void $$robo$$android_view_animation_Animation$getInvalidateRegion(int left, int top, int right, int bottom, RectF invalidate, Transformation transformation) {
        RectF tempRegion = this.mRegion;
        RectF previousRegion = this.mPreviousRegion;
        invalidate.set(left, top, right, bottom);
        transformation.getMatrix().mapRect(invalidate);
        invalidate.inset(-1.0f, -1.0f);
        tempRegion.set(invalidate);
        invalidate.union(previousRegion);
        previousRegion.set(tempRegion);
        Transformation tempTransformation = this.mTransformation;
        Transformation previousTransformation = this.mPreviousTransformation;
        tempTransformation.set(transformation);
        transformation.set(previousTransformation);
        previousTransformation.set(tempTransformation);
    }

    private final void $$robo$$android_view_animation_Animation$initializeInvalidateRegion(int left, int top, int right, int bottom) {
        RectF region = this.mPreviousRegion;
        region.set(left, top, right, bottom);
        region.inset(-1.0f, -1.0f);
        if (this.mFillBefore) {
            Transformation previousTransformation = this.mPreviousTransformation;
            this.applyTransformation(this.mInterpolator.getInterpolation(0.0f), previousTransformation);
        }
    }

    private final void $$robo$$android_view_animation_Animation$finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
        }
        finally {
            super.finalize();
        }
    }

    private final boolean $$robo$$android_view_animation_Animation$hasAlpha() {
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_view_animation_Animation$__constructor__();
    }

    public Animation() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_Animation$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_animation_Animation$__constructor__(context, attributeSet);
    }

    public Animation(Context context, AttributeSet attributeSet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_Animation$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    protected Animation clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_view_animation_Animation$clone(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_view_animation_Animation$reset(), 0, this);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_view_animation_Animation$cancel(), 0, this);
    }

    public void detach() {
        InvokeDynamicSupport.bootstrap("detach", $$robo$$android_view_animation_Animation$detach(), 0, this);
    }

    public boolean isInitialized() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInitialized", $$robo$$android_view_animation_Animation$isInitialized(), 0, this);
    }

    public void initialize(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_view_animation_Animation$initialize(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setListenerHandler(Handler handler) {
        InvokeDynamicSupport.bootstrap("setListenerHandler", $$robo$$android_view_animation_Animation$setListenerHandler(android.os.Handler ), 0, this, handler);
    }

    public void setInterpolator(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_view_animation_Animation$setInterpolator(android.content.Context int ), 0, this, context, n);
    }

    public void setInterpolator(Interpolator interpolator2) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_view_animation_Animation$setInterpolator(android.view.animation.Interpolator ), 0, this, interpolator2);
    }

    public void setStartOffset(long l) {
        InvokeDynamicSupport.bootstrap("setStartOffset", $$robo$$android_view_animation_Animation$setStartOffset(long ), 0, this, l);
    }

    public void setDuration(long l) {
        InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_view_animation_Animation$setDuration(long ), 0, this, l);
    }

    public void restrictDuration(long l) {
        InvokeDynamicSupport.bootstrap("restrictDuration", $$robo$$android_view_animation_Animation$restrictDuration(long ), 0, this, l);
    }

    public void scaleCurrentDuration(float f) {
        InvokeDynamicSupport.bootstrap("scaleCurrentDuration", $$robo$$android_view_animation_Animation$scaleCurrentDuration(float ), 0, this, f);
    }

    public void setStartTime(long l) {
        InvokeDynamicSupport.bootstrap("setStartTime", $$robo$$android_view_animation_Animation$setStartTime(long ), 0, this, l);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_view_animation_Animation$start(), 0, this);
    }

    public void startNow() {
        InvokeDynamicSupport.bootstrap("startNow", $$robo$$android_view_animation_Animation$startNow(), 0, this);
    }

    public void setRepeatMode(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatMode", $$robo$$android_view_animation_Animation$setRepeatMode(int ), 0, this, n);
    }

    public void setRepeatCount(int n) {
        InvokeDynamicSupport.bootstrap("setRepeatCount", $$robo$$android_view_animation_Animation$setRepeatCount(int ), 0, this, n);
    }

    public boolean isFillEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFillEnabled", $$robo$$android_view_animation_Animation$isFillEnabled(), 0, this);
    }

    public void setFillEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFillEnabled", $$robo$$android_view_animation_Animation$setFillEnabled(boolean ), 0, this, bl);
    }

    public void setFillBefore(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFillBefore", $$robo$$android_view_animation_Animation$setFillBefore(boolean ), 0, this, bl);
    }

    public void setFillAfter(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFillAfter", $$robo$$android_view_animation_Animation$setFillAfter(boolean ), 0, this, bl);
    }

    public void setZAdjustment(int n) {
        InvokeDynamicSupport.bootstrap("setZAdjustment", $$robo$$android_view_animation_Animation$setZAdjustment(int ), 0, this, n);
    }

    public void setBackgroundColor(int n) {
        InvokeDynamicSupport.bootstrap("setBackgroundColor", $$robo$$android_view_animation_Animation$setBackgroundColor(int ), 0, this, n);
    }

    protected float getScaleFactor() {
        return (float)InvokeDynamicSupport.bootstrap("getScaleFactor", $$robo$$android_view_animation_Animation$getScaleFactor(), 0, this);
    }

    public void setDetachWallpaper(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDetachWallpaper", $$robo$$android_view_animation_Animation$setDetachWallpaper(boolean ), 0, this, bl);
    }

    public Interpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_view_animation_Animation$getInterpolator(), 0, this);
    }

    public long getStartTime() {
        return (long)InvokeDynamicSupport.bootstrap("getStartTime", $$robo$$android_view_animation_Animation$getStartTime(), 0, this);
    }

    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_view_animation_Animation$getDuration(), 0, this);
    }

    public long getStartOffset() {
        return (long)InvokeDynamicSupport.bootstrap("getStartOffset", $$robo$$android_view_animation_Animation$getStartOffset(), 0, this);
    }

    public int getRepeatMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRepeatMode", $$robo$$android_view_animation_Animation$getRepeatMode(), 0, this);
    }

    public int getRepeatCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRepeatCount", $$robo$$android_view_animation_Animation$getRepeatCount(), 0, this);
    }

    public boolean getFillBefore() {
        return (boolean)InvokeDynamicSupport.bootstrap("getFillBefore", $$robo$$android_view_animation_Animation$getFillBefore(), 0, this);
    }

    public boolean getFillAfter() {
        return (boolean)InvokeDynamicSupport.bootstrap("getFillAfter", $$robo$$android_view_animation_Animation$getFillAfter(), 0, this);
    }

    public int getZAdjustment() {
        return (int)InvokeDynamicSupport.bootstrap("getZAdjustment", $$robo$$android_view_animation_Animation$getZAdjustment(), 0, this);
    }

    public int getBackgroundColor() {
        return (int)InvokeDynamicSupport.bootstrap("getBackgroundColor", $$robo$$android_view_animation_Animation$getBackgroundColor(), 0, this);
    }

    public boolean getDetachWallpaper() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDetachWallpaper", $$robo$$android_view_animation_Animation$getDetachWallpaper(), 0, this);
    }

    public boolean willChangeTransformationMatrix() {
        return (boolean)InvokeDynamicSupport.bootstrap("willChangeTransformationMatrix", $$robo$$android_view_animation_Animation$willChangeTransformationMatrix(), 0, this);
    }

    public boolean willChangeBounds() {
        return (boolean)InvokeDynamicSupport.bootstrap("willChangeBounds", $$robo$$android_view_animation_Animation$willChangeBounds(), 0, this);
    }

    public void setAnimationListener(AnimationListener animationListener) {
        InvokeDynamicSupport.bootstrap("setAnimationListener", $$robo$$android_view_animation_Animation$setAnimationListener(android.view.animation.Animation$AnimationListener ), 0, this, animationListener);
    }

    protected void ensureInterpolator() {
        InvokeDynamicSupport.bootstrap("ensureInterpolator", $$robo$$android_view_animation_Animation$ensureInterpolator(), 0, this);
    }

    public long computeDurationHint() {
        return (long)InvokeDynamicSupport.bootstrap("computeDurationHint", $$robo$$android_view_animation_Animation$computeDurationHint(), 0, this);
    }

    public boolean getTransformation(long l, Transformation transformation) {
        return (boolean)InvokeDynamicSupport.bootstrap("getTransformation", $$robo$$android_view_animation_Animation$getTransformation(long android.view.animation.Transformation ), 0, this, l, transformation);
    }

    private boolean isCanceled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCanceled", $$robo$$android_view_animation_Animation$isCanceled(), 0, this);
    }

    private void fireAnimationStart() {
        InvokeDynamicSupport.bootstrap("fireAnimationStart", $$robo$$android_view_animation_Animation$fireAnimationStart(), 0, this);
    }

    private void fireAnimationRepeat() {
        InvokeDynamicSupport.bootstrap("fireAnimationRepeat", $$robo$$android_view_animation_Animation$fireAnimationRepeat(), 0, this);
    }

    private void fireAnimationEnd() {
        InvokeDynamicSupport.bootstrap("fireAnimationEnd", $$robo$$android_view_animation_Animation$fireAnimationEnd(), 0, this);
    }

    public boolean getTransformation(long l, Transformation transformation, float f) {
        return (boolean)InvokeDynamicSupport.bootstrap("getTransformation", $$robo$$android_view_animation_Animation$getTransformation(long android.view.animation.Transformation float ), 0, this, l, transformation, f);
    }

    public boolean hasStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStarted", $$robo$$android_view_animation_Animation$hasStarted(), 0, this);
    }

    public boolean hasEnded() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasEnded", $$robo$$android_view_animation_Animation$hasEnded(), 0, this);
    }

    protected void applyTransformation(float f, Transformation transformation) {
        InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$android_view_animation_Animation$applyTransformation(float android.view.animation.Transformation ), 0, this, f, transformation);
    }

    protected float resolveSize(int n, float f, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("resolveSize", $$robo$$android_view_animation_Animation$resolveSize(int float int int ), 0, this, n, f, n2, n3);
    }

    public void getInvalidateRegion(int n, int n2, int n3, int n4, RectF rectF, Transformation transformation) {
        InvokeDynamicSupport.bootstrap("getInvalidateRegion", $$robo$$android_view_animation_Animation$getInvalidateRegion(int int int int android.graphics.RectF android.view.animation.Transformation ), 0, this, n, n2, n3, n4, rectF, transformation);
    }

    public void initializeInvalidateRegion(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("initializeInvalidateRegion", $$robo$$android_view_animation_Animation$initializeInvalidateRegion(int int int int ), 0, this, n, n2, n3, n4);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_animation_Animation$finalize(), 0, this);
    }

    public boolean hasAlpha() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAlpha", $$robo$$android_view_animation_Animation$hasAlpha(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Animation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface AnimationListener
    extends InstrumentedInterface {
        public void onAnimationStart(Animation var1);

        public void onAnimationEnd(Animation var1);

        public void onAnimationRepeat(Animation var1);
    }

    protected static class Description
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int type;
        public float value;

        private void $$robo$$android_view_animation_Animation_Description$__constructor__() {
        }

        private static final Description $$robo$$android_view_animation_Animation_Description$parseValue(TypedValue value) {
            Description d = new Description();
            if (value == null) {
                d.type = 0;
                d.value = 0.0f;
            } else {
                if (value.type == 6) {
                    d.type = (value.data & 0xF) == 1 ? 2 : 1;
                    d.value = TypedValue.complexToFloat(value.data);
                    return d;
                }
                if (value.type == 4) {
                    d.type = 0;
                    d.value = value.getFloat();
                    return d;
                }
                if (value.type >= 16 && value.type <= 31) {
                    d.type = 0;
                    d.value = value.data;
                    return d;
                }
            }
            d.type = 0;
            d.value = 0.0f;
            return d;
        }

        private void __constructor__() {
            this.$$robo$$android_view_animation_Animation_Description$__constructor__();
        }

        protected Description() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_Animation_Description$__constructor__(), 0, this);
        }

        static Description parseValue(TypedValue typedValue) {
            return InvokeDynamicSupport.bootstrapStatic("parseValue", $$robo$$android_view_animation_Animation_Description$parseValue(android.util.TypedValue ), 0, (TypedValue)typedValue);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Description)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class NoImagePreloadHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static boolean USE_CLOSEGUARD;

        private void $$robo$$android_view_animation_Animation_NoImagePreloadHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            USE_CLOSEGUARD = SystemProperties.getBoolean("log.closeguard.Animation", false);
        }

        private void __constructor__() {
            this.$$robo$$android_view_animation_Animation_NoImagePreloadHolder$__constructor__();
        }

        private NoImagePreloadHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_Animation_NoImagePreloadHolder$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(NoImagePreloadHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoImagePreloadHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

