/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.AppGlobals;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.Display;
import android.view.IWindowManager;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ViewConfiguration
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int SCROLL_BAR_SIZE = 10;
    private static int SCROLL_BAR_FADE_DURATION = 250;
    private static int SCROLL_BAR_DEFAULT_DELAY = 300;
    private static int FADING_EDGE_LENGTH = 12;
    private static int PRESSED_STATE_DURATION = 64;
    private static int DEFAULT_LONG_PRESS_TIMEOUT = 500;
    private static int KEY_REPEAT_DELAY = 50;
    private static int GLOBAL_ACTIONS_KEY_TIMEOUT = 500;
    private static int TAP_TIMEOUT = 100;
    private static int JUMP_TAP_TIMEOUT = 500;
    private static int DOUBLE_TAP_TIMEOUT = 300;
    private static int DOUBLE_TAP_MIN_TIME = 40;
    private static int HOVER_TAP_TIMEOUT = 150;
    private static int HOVER_TAP_SLOP = 20;
    private static int ZOOM_CONTROLS_TIMEOUT = 3000;
    private static int EDGE_SLOP = 12;
    private static int TOUCH_SLOP = 8;
    private static int DOUBLE_TAP_TOUCH_SLOP = 8;
    private static int PAGING_TOUCH_SLOP = 16;
    private static int DOUBLE_TAP_SLOP = 100;
    private static int WINDOW_TOUCH_SLOP = 16;
    private static int MINIMUM_FLING_VELOCITY = 50;
    private static int MAXIMUM_FLING_VELOCITY = 8000;
    private static long SEND_RECURRING_ACCESSIBILITY_EVENTS_INTERVAL_MILLIS = 100L;
    @Deprecated
    private static int MAXIMUM_DRAWING_CACHE_SIZE = 0x177000;
    private static float SCROLL_FRICTION = 0.015f;
    private static int OVERSCROLL_DISTANCE = 0;
    private static int OVERFLING_DISTANCE = 6;
    private static long ACTION_MODE_HIDE_DURATION_DEFAULT = 2000L;
    private static int HAS_PERMANENT_MENU_KEY_AUTODETECT = 0;
    private static int HAS_PERMANENT_MENU_KEY_TRUE = 1;
    private static int HAS_PERMANENT_MENU_KEY_FALSE = 2;
    private int mEdgeSlop;
    private int mFadingEdgeLength;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private int mScrollbarSize;
    private int mTouchSlop;
    private int mDoubleTapTouchSlop;
    private int mPagingTouchSlop;
    private int mDoubleTapSlop;
    private int mWindowTouchSlop;
    private int mMaximumDrawingCacheSize;
    private int mOverscrollDistance;
    private int mOverflingDistance;
    private boolean mFadingMarqueeEnabled;
    private long mGlobalActionsKeyTimeout;
    private boolean sHasPermanentMenuKey;
    private boolean sHasPermanentMenuKeySet;
    static SparseArray<ViewConfiguration> sConfigurations;

    @Deprecated
    private void $$robo$$android_view_ViewConfiguration$__constructor__() {
        this.mEdgeSlop = 12;
        this.mFadingEdgeLength = 12;
        this.mMinimumFlingVelocity = 50;
        this.mMaximumFlingVelocity = 8000;
        this.mScrollbarSize = 10;
        this.mTouchSlop = 8;
        this.mDoubleTapTouchSlop = 8;
        this.mPagingTouchSlop = 16;
        this.mDoubleTapSlop = 100;
        this.mWindowTouchSlop = 16;
        this.mMaximumDrawingCacheSize = 0x177000;
        this.mOverscrollDistance = 0;
        this.mOverflingDistance = 6;
        this.mFadingMarqueeEnabled = true;
        this.mGlobalActionsKeyTimeout = 500L;
    }

    private void $$robo$$android_view_ViewConfiguration$__constructor__(Context context) {
        Resources res = context.getResources();
        DisplayMetrics metrics = res.getDisplayMetrics();
        Configuration config = res.getConfiguration();
        float density = metrics.density;
        float sizeAndDensity = config.isLayoutSizeAtLeast(4) ? density * 1.5f : density;
        this.mEdgeSlop = (int)(sizeAndDensity * 12.0f + 0.5f);
        this.mFadingEdgeLength = (int)(sizeAndDensity * 12.0f + 0.5f);
        this.mScrollbarSize = (int)(density * 10.0f + 0.5f);
        this.mDoubleTapSlop = (int)(sizeAndDensity * 100.0f + 0.5f);
        this.mWindowTouchSlop = (int)(sizeAndDensity * 16.0f + 0.5f);
        WindowManager win = (WindowManager)context.getSystemService("window");
        Display display = win.getDefaultDisplay();
        Point size = new Point();
        display.getRealSize(size);
        this.mMaximumDrawingCacheSize = 4 * size.x * size.y;
        this.mOverscrollDistance = (int)(sizeAndDensity * 0.0f + 0.5f);
        this.mOverflingDistance = (int)(sizeAndDensity * 6.0f + 0.5f);
        if (!this.sHasPermanentMenuKeySet) {
            int configVal = res.getInteger(17694861);
            switch (configVal) {
                default: {
                    IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
                    try {
                        this.sHasPermanentMenuKey = !wm.hasNavigationBar();
                        this.sHasPermanentMenuKeySet = true;
                    }
                    catch (RemoteException ex) {
                        this.sHasPermanentMenuKey = false;
                    }
                    break;
                }
                case 1: {
                    this.sHasPermanentMenuKey = true;
                    this.sHasPermanentMenuKeySet = true;
                    break;
                }
                case 2: {
                    this.sHasPermanentMenuKey = false;
                    this.sHasPermanentMenuKeySet = true;
                }
            }
        }
        this.mFadingMarqueeEnabled = res.getBoolean(0x1120010);
        this.mTouchSlop = res.getDimensionPixelSize(17104911);
        this.mPagingTouchSlop = this.mTouchSlop * 2;
        this.mDoubleTapTouchSlop = this.mTouchSlop;
        this.mMinimumFlingVelocity = res.getDimensionPixelSize(0x1050010);
        this.mMaximumFlingVelocity = res.getDimensionPixelSize(0x1050011);
        this.mGlobalActionsKeyTimeout = res.getInteger(17694853);
    }

    private static final ViewConfiguration $$robo$$android_view_ViewConfiguration$get(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int density = (int)(100.0f * metrics.density);
        ViewConfiguration configuration = sConfigurations.get(density);
        if (configuration == null) {
            configuration = new ViewConfiguration(context);
            sConfigurations.put(density, configuration);
        }
        return configuration;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getScrollBarSize() {
        return 10;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledScrollBarSize() {
        return this.mScrollbarSize;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getScrollBarFadeDuration() {
        return 250;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getScrollDefaultDelay() {
        return 300;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getFadingEdgeLength() {
        return 12;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledFadingEdgeLength() {
        return this.mFadingEdgeLength;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getPressedStateDuration() {
        return 64;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getLongPressTimeout() {
        return AppGlobals.getIntCoreSetting("long_press_timeout", 500);
    }

    private static final int $$robo$$android_view_ViewConfiguration$getKeyRepeatTimeout() {
        return ViewConfiguration.getLongPressTimeout();
    }

    private static final int $$robo$$android_view_ViewConfiguration$getKeyRepeatDelay() {
        return 50;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getTapTimeout() {
        return 100;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getJumpTapTimeout() {
        return 500;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getDoubleTapTimeout() {
        return 300;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getDoubleTapMinTime() {
        return 40;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getHoverTapTimeout() {
        return 150;
    }

    private static final int $$robo$$android_view_ViewConfiguration$getHoverTapSlop() {
        return 20;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getEdgeSlop() {
        return 12;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledEdgeSlop() {
        return this.mEdgeSlop;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getTouchSlop() {
        return 8;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledTouchSlop() {
        return this.mTouchSlop;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledDoubleTapTouchSlop() {
        return this.mDoubleTapTouchSlop;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledPagingTouchSlop() {
        return this.mPagingTouchSlop;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getDoubleTapSlop() {
        return 100;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledDoubleTapSlop() {
        return this.mDoubleTapSlop;
    }

    private static final long $$robo$$android_view_ViewConfiguration$getSendRecurringAccessibilityEventsInterval() {
        return 100L;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getWindowTouchSlop() {
        return 16;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledWindowTouchSlop() {
        return this.mWindowTouchSlop;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getMinimumFlingVelocity() {
        return 50;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledMinimumFlingVelocity() {
        return this.mMinimumFlingVelocity;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getMaximumFlingVelocity() {
        return 8000;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledMaximumFlingVelocity() {
        return this.mMaximumFlingVelocity;
    }

    @Deprecated
    private static final int $$robo$$android_view_ViewConfiguration$getMaximumDrawingCacheSize() {
        return 0x177000;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledMaximumDrawingCacheSize() {
        return this.mMaximumDrawingCacheSize;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledOverscrollDistance() {
        return this.mOverscrollDistance;
    }

    private final int $$robo$$android_view_ViewConfiguration$getScaledOverflingDistance() {
        return this.mOverflingDistance;
    }

    private static final long $$robo$$android_view_ViewConfiguration$getZoomControlsTimeout() {
        return 3000L;
    }

    @Deprecated
    private static final long $$robo$$android_view_ViewConfiguration$getGlobalActionKeyTimeout() {
        return 500L;
    }

    private final long $$robo$$android_view_ViewConfiguration$getDeviceGlobalActionKeyTimeout() {
        return this.mGlobalActionsKeyTimeout;
    }

    private static final float $$robo$$android_view_ViewConfiguration$getScrollFriction() {
        return 0.015f;
    }

    private static final long $$robo$$android_view_ViewConfiguration$getDefaultActionModeHideDuration() {
        return 2000L;
    }

    private final boolean $$robo$$android_view_ViewConfiguration$hasPermanentMenuKey() {
        return this.sHasPermanentMenuKey;
    }

    private final boolean $$robo$$android_view_ViewConfiguration$isFadingMarqueeEnabled() {
        return this.mFadingMarqueeEnabled;
    }

    static void __staticInitializer__() {
        sConfigurations = new SparseArray(2);
    }

    private void __constructor__() {
        this.$$robo$$android_view_ViewConfiguration$__constructor__();
    }

    public ViewConfiguration() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewConfiguration$__constructor__(), 0, this);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_ViewConfiguration$__constructor__(context);
    }

    private ViewConfiguration(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ViewConfiguration$__constructor__(android.content.Context ), 0, this, context);
    }

    public static ViewConfiguration get(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_view_ViewConfiguration$get(android.content.Context ), 0, (Context)context);
    }

    @Deprecated
    public static int getScrollBarSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getScrollBarSize", $$robo$$android_view_ViewConfiguration$getScrollBarSize(), 0);
    }

    public int getScaledScrollBarSize() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledScrollBarSize", $$robo$$android_view_ViewConfiguration$getScaledScrollBarSize(), 0, this);
    }

    public static int getScrollBarFadeDuration() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getScrollBarFadeDuration", $$robo$$android_view_ViewConfiguration$getScrollBarFadeDuration(), 0);
    }

    public static int getScrollDefaultDelay() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getScrollDefaultDelay", $$robo$$android_view_ViewConfiguration$getScrollDefaultDelay(), 0);
    }

    @Deprecated
    public static int getFadingEdgeLength() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getFadingEdgeLength", $$robo$$android_view_ViewConfiguration$getFadingEdgeLength(), 0);
    }

    public int getScaledFadingEdgeLength() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledFadingEdgeLength", $$robo$$android_view_ViewConfiguration$getScaledFadingEdgeLength(), 0, this);
    }

    public static int getPressedStateDuration() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPressedStateDuration", $$robo$$android_view_ViewConfiguration$getPressedStateDuration(), 0);
    }

    public static int getLongPressTimeout() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLongPressTimeout", $$robo$$android_view_ViewConfiguration$getLongPressTimeout(), 0);
    }

    public static int getKeyRepeatTimeout() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getKeyRepeatTimeout", $$robo$$android_view_ViewConfiguration$getKeyRepeatTimeout(), 0);
    }

    public static int getKeyRepeatDelay() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getKeyRepeatDelay", $$robo$$android_view_ViewConfiguration$getKeyRepeatDelay(), 0);
    }

    public static int getTapTimeout() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTapTimeout", $$robo$$android_view_ViewConfiguration$getTapTimeout(), 0);
    }

    public static int getJumpTapTimeout() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getJumpTapTimeout", $$robo$$android_view_ViewConfiguration$getJumpTapTimeout(), 0);
    }

    public static int getDoubleTapTimeout() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDoubleTapTimeout", $$robo$$android_view_ViewConfiguration$getDoubleTapTimeout(), 0);
    }

    public static int getDoubleTapMinTime() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDoubleTapMinTime", $$robo$$android_view_ViewConfiguration$getDoubleTapMinTime(), 0);
    }

    public static int getHoverTapTimeout() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getHoverTapTimeout", $$robo$$android_view_ViewConfiguration$getHoverTapTimeout(), 0);
    }

    public static int getHoverTapSlop() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getHoverTapSlop", $$robo$$android_view_ViewConfiguration$getHoverTapSlop(), 0);
    }

    @Deprecated
    public static int getEdgeSlop() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getEdgeSlop", $$robo$$android_view_ViewConfiguration$getEdgeSlop(), 0);
    }

    public int getScaledEdgeSlop() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledEdgeSlop", $$robo$$android_view_ViewConfiguration$getScaledEdgeSlop(), 0, this);
    }

    @Deprecated
    public static int getTouchSlop() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTouchSlop", $$robo$$android_view_ViewConfiguration$getTouchSlop(), 0);
    }

    public int getScaledTouchSlop() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledTouchSlop", $$robo$$android_view_ViewConfiguration$getScaledTouchSlop(), 0, this);
    }

    public int getScaledDoubleTapTouchSlop() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledDoubleTapTouchSlop", $$robo$$android_view_ViewConfiguration$getScaledDoubleTapTouchSlop(), 0, this);
    }

    public int getScaledPagingTouchSlop() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledPagingTouchSlop", $$robo$$android_view_ViewConfiguration$getScaledPagingTouchSlop(), 0, this);
    }

    @Deprecated
    public static int getDoubleTapSlop() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDoubleTapSlop", $$robo$$android_view_ViewConfiguration$getDoubleTapSlop(), 0);
    }

    public int getScaledDoubleTapSlop() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledDoubleTapSlop", $$robo$$android_view_ViewConfiguration$getScaledDoubleTapSlop(), 0, this);
    }

    public static long getSendRecurringAccessibilityEventsInterval() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getSendRecurringAccessibilityEventsInterval", $$robo$$android_view_ViewConfiguration$getSendRecurringAccessibilityEventsInterval(), 0);
    }

    @Deprecated
    public static int getWindowTouchSlop() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getWindowTouchSlop", $$robo$$android_view_ViewConfiguration$getWindowTouchSlop(), 0);
    }

    public int getScaledWindowTouchSlop() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledWindowTouchSlop", $$robo$$android_view_ViewConfiguration$getScaledWindowTouchSlop(), 0, this);
    }

    @Deprecated
    public static int getMinimumFlingVelocity() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMinimumFlingVelocity", $$robo$$android_view_ViewConfiguration$getMinimumFlingVelocity(), 0);
    }

    public int getScaledMinimumFlingVelocity() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledMinimumFlingVelocity", $$robo$$android_view_ViewConfiguration$getScaledMinimumFlingVelocity(), 0, this);
    }

    @Deprecated
    public static int getMaximumFlingVelocity() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaximumFlingVelocity", $$robo$$android_view_ViewConfiguration$getMaximumFlingVelocity(), 0);
    }

    public int getScaledMaximumFlingVelocity() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledMaximumFlingVelocity", $$robo$$android_view_ViewConfiguration$getScaledMaximumFlingVelocity(), 0, this);
    }

    @Deprecated
    public static int getMaximumDrawingCacheSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaximumDrawingCacheSize", $$robo$$android_view_ViewConfiguration$getMaximumDrawingCacheSize(), 0);
    }

    public int getScaledMaximumDrawingCacheSize() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledMaximumDrawingCacheSize", $$robo$$android_view_ViewConfiguration$getScaledMaximumDrawingCacheSize(), 0, this);
    }

    public int getScaledOverscrollDistance() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledOverscrollDistance", $$robo$$android_view_ViewConfiguration$getScaledOverscrollDistance(), 0, this);
    }

    public int getScaledOverflingDistance() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledOverflingDistance", $$robo$$android_view_ViewConfiguration$getScaledOverflingDistance(), 0, this);
    }

    public static long getZoomControlsTimeout() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getZoomControlsTimeout", $$robo$$android_view_ViewConfiguration$getZoomControlsTimeout(), 0);
    }

    @Deprecated
    public static long getGlobalActionKeyTimeout() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getGlobalActionKeyTimeout", $$robo$$android_view_ViewConfiguration$getGlobalActionKeyTimeout(), 0);
    }

    public long getDeviceGlobalActionKeyTimeout() {
        return (long)InvokeDynamicSupport.bootstrap("getDeviceGlobalActionKeyTimeout", $$robo$$android_view_ViewConfiguration$getDeviceGlobalActionKeyTimeout(), 0, this);
    }

    public static float getScrollFriction() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getScrollFriction", $$robo$$android_view_ViewConfiguration$getScrollFriction(), 0);
    }

    public static long getDefaultActionModeHideDuration() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDefaultActionModeHideDuration", $$robo$$android_view_ViewConfiguration$getDefaultActionModeHideDuration(), 0);
    }

    public boolean hasPermanentMenuKey() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPermanentMenuKey", $$robo$$android_view_ViewConfiguration$hasPermanentMenuKey(), 0, this);
    }

    public boolean isFadingMarqueeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFadingMarqueeEnabled", $$robo$$android_view_ViewConfiguration$isFadingMarqueeEnabled(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ViewConfiguration.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

