/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.util.SparseIntArray;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.View;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.internal.view.animation.FallbackLUTInterpolator;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RenderNodeAnimator
extends Animator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int TRANSLATION_X = 0;
    public static int TRANSLATION_Y = 1;
    public static int TRANSLATION_Z = 2;
    public static int SCALE_X = 3;
    public static int SCALE_Y = 4;
    public static int ROTATION = 5;
    public static int ROTATION_X = 6;
    public static int ROTATION_Y = 7;
    public static int X = 8;
    public static int Y = 9;
    public static int Z = 10;
    public static int ALPHA = 11;
    public static int LAST_VALUE = 11;
    public static int PAINT_STROKE_WIDTH = 0;
    public static int PAINT_ALPHA = 1;
    private static SparseIntArray sViewPropertyAnimatorMap;
    private VirtualRefBasePtr mNativePtr;
    private RenderNode mTarget;
    private View mViewTarget;
    private int mRenderProperty;
    private float mFinalValue;
    private TimeInterpolator mInterpolator;
    private static int STATE_PREPARE = 0;
    private static int STATE_DELAYED = 1;
    private static int STATE_RUNNING = 2;
    private static int STATE_FINISHED = 3;
    private int mState;
    private long mUnscaledDuration;
    private long mUnscaledStartDelay;
    private boolean mUiThreadHandlesDelay;
    private long mStartDelay;
    private long mStartTime;
    private static ThreadLocal<DelayedAnimationHelper> sAnimationHelper;

    private static final int $$robo$$android_view_RenderNodeAnimator$mapViewPropertyToRenderProperty(int viewProperty) {
        return sViewPropertyAnimatorMap.get(viewProperty);
    }

    private void $$robo$$android_view_RenderNodeAnimator$__constructor__(int property, float finalValue) {
        this.mRenderProperty = -1;
        this.mState = 0;
        this.mUnscaledDuration = 300L;
        this.mUnscaledStartDelay = 0L;
        this.mStartDelay = 0L;
        this.mRenderProperty = property;
        this.mFinalValue = finalValue;
        this.mUiThreadHandlesDelay = true;
        this.init(RenderNodeAnimator.nCreateAnimator(property, finalValue));
    }

    private void $$robo$$android_view_RenderNodeAnimator$__constructor__(CanvasProperty<Float> property, float finalValue) {
        this.mRenderProperty = -1;
        this.mState = 0;
        this.mUnscaledDuration = 300L;
        this.mUnscaledStartDelay = 0L;
        this.mStartDelay = 0L;
        this.init(RenderNodeAnimator.nCreateCanvasPropertyFloatAnimator(property.getNativeContainer(), finalValue));
        this.mUiThreadHandlesDelay = false;
    }

    private void $$robo$$android_view_RenderNodeAnimator$__constructor__(CanvasProperty<Paint> property, int paintField, float finalValue) {
        this.mRenderProperty = -1;
        this.mState = 0;
        this.mUnscaledDuration = 300L;
        this.mUnscaledStartDelay = 0L;
        this.mStartDelay = 0L;
        this.init(RenderNodeAnimator.nCreateCanvasPropertyPaintAnimator(property.getNativeContainer(), paintField, finalValue));
        this.mUiThreadHandlesDelay = false;
    }

    private void $$robo$$android_view_RenderNodeAnimator$__constructor__(int x, int y, float startRadius, float endRadius) {
        this.mRenderProperty = -1;
        this.mState = 0;
        this.mUnscaledDuration = 300L;
        this.mUnscaledStartDelay = 0L;
        this.mStartDelay = 0L;
        this.init(RenderNodeAnimator.nCreateRevealAnimator(x, y, startRadius, endRadius));
        this.mUiThreadHandlesDelay = true;
    }

    private final void $$robo$$android_view_RenderNodeAnimator$init(long ptr) {
        this.mNativePtr = new VirtualRefBasePtr(ptr);
    }

    private final void $$robo$$android_view_RenderNodeAnimator$checkMutable() {
        if (this.mState != 0) {
            throw new IllegalStateException("Animator has already started, cannot change it now!");
        }
        if (this.mNativePtr == null) {
            throw new IllegalStateException("Animator's target has been destroyed (trying to modify an animation after activity destroy?)");
        }
    }

    private static final boolean $$robo$$android_view_RenderNodeAnimator$isNativeInterpolator(TimeInterpolator interpolator2) {
        return interpolator2.getClass().isAnnotationPresent(HasNativeInterpolator.class);
    }

    private final void $$robo$$android_view_RenderNodeAnimator$applyInterpolator() {
        long ni;
        if (this.mInterpolator == null) {
            return;
        }
        if (RenderNodeAnimator.isNativeInterpolator(this.mInterpolator)) {
            ni = ((NativeInterpolatorFactory)((Object)this.mInterpolator)).createNativeInterpolator();
        } else {
            long duration = RenderNodeAnimator.nGetDuration(this.mNativePtr.get());
            ni = FallbackLUTInterpolator.createNativeInterpolator(this.mInterpolator, duration);
        }
        RenderNodeAnimator.nSetInterpolator(this.mNativePtr.get(), ni);
    }

    private final void $$robo$$android_view_RenderNodeAnimator$start() {
        if (this.mTarget == null) {
            throw new IllegalStateException("Missing target!");
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Already started!");
        }
        this.mState = 1;
        this.applyInterpolator();
        if (this.mNativePtr == null) {
            this.cancel();
        } else if (this.mStartDelay <= 0L || !this.mUiThreadHandlesDelay) {
            RenderNodeAnimator.nSetStartDelay(this.mNativePtr.get(), this.mStartDelay);
            this.doStart();
        } else {
            RenderNodeAnimator.getHelper().addDelayedAnimation(this);
        }
    }

    private final void $$robo$$android_view_RenderNodeAnimator$doStart() {
        if (this.mRenderProperty == 11) {
            this.mViewTarget.mTransformationInfo.mAlpha = this.mFinalValue;
        }
        this.moveToRunningState();
        if (this.mViewTarget != null) {
            this.mViewTarget.invalidateViewProperty(true, false);
        }
    }

    private final void $$robo$$android_view_RenderNodeAnimator$moveToRunningState() {
        this.mState = 2;
        if (this.mNativePtr != null) {
            RenderNodeAnimator.nStart(this.mNativePtr.get());
        }
        this.notifyStartListeners();
    }

    private final void $$robo$$android_view_RenderNodeAnimator$notifyStartListeners() {
        ArrayList<Animator.AnimatorListener> listeners = this.cloneListeners();
        int numListeners = listeners == null ? 0 : listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            listeners.get(i).onAnimationStart(this);
        }
    }

    private final void $$robo$$android_view_RenderNodeAnimator$cancel() {
        if (this.mState != 0 && this.mState != 3) {
            ArrayList<Animator.AnimatorListener> listeners;
            if (this.mState == 1) {
                RenderNodeAnimator.getHelper().removeDelayedAnimation(this);
                this.moveToRunningState();
            }
            int numListeners = (listeners = this.cloneListeners()) == null ? 0 : listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                listeners.get(i).onAnimationCancel(this);
            }
            this.end();
        }
    }

    private final void $$robo$$android_view_RenderNodeAnimator$end() {
        if (this.mState != 3) {
            if (this.mState < 2) {
                RenderNodeAnimator.getHelper().removeDelayedAnimation(this);
                this.doStart();
            }
            if (this.mNativePtr != null) {
                RenderNodeAnimator.nEnd(this.mNativePtr.get());
                if (this.mViewTarget != null) {
                    this.mViewTarget.invalidateViewProperty(true, false);
                }
            } else {
                this.onFinished();
            }
        }
    }

    private final void $$robo$$android_view_RenderNodeAnimator$pause() {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$android_view_RenderNodeAnimator$resume() {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$android_view_RenderNodeAnimator$setTarget(View view) {
        this.mViewTarget = view;
        this.setTarget(this.mViewTarget.mRenderNode);
    }

    private final void $$robo$$android_view_RenderNodeAnimator$setTarget(Canvas canvas) {
        if (!(canvas instanceof DisplayListCanvas)) {
            throw new IllegalArgumentException("Not a GLES20RecordingCanvas");
        }
        DisplayListCanvas recordingCanvas = (DisplayListCanvas)canvas;
        this.setTarget(recordingCanvas.mNode);
    }

    private final void $$robo$$android_view_RenderNodeAnimator$setTarget(RenderNode node) {
        this.checkMutable();
        if (this.mTarget != null) {
            throw new IllegalStateException("Target already set!");
        }
        RenderNodeAnimator.nSetListener(this.mNativePtr.get(), this);
        this.mTarget = node;
        this.mTarget.addAnimator(this);
    }

    private final void $$robo$$android_view_RenderNodeAnimator$setStartValue(float startValue) {
        this.checkMutable();
        RenderNodeAnimator.nSetStartValue(this.mNativePtr.get(), startValue);
    }

    private final void $$robo$$android_view_RenderNodeAnimator$setStartDelay(long startDelay) {
        this.checkMutable();
        if (startDelay < 0L) {
            throw new IllegalArgumentException("startDelay must be positive; " + startDelay);
        }
        this.mUnscaledStartDelay = startDelay;
        this.mStartDelay = (long)(ValueAnimator.getDurationScale() * (float)startDelay);
    }

    private final long $$robo$$android_view_RenderNodeAnimator$getStartDelay() {
        return this.mUnscaledStartDelay;
    }

    private final RenderNodeAnimator $$robo$$android_view_RenderNodeAnimator$setDuration(long duration) {
        this.checkMutable();
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be positive; " + duration);
        }
        this.mUnscaledDuration = duration;
        RenderNodeAnimator.nSetDuration(this.mNativePtr.get(), (long)((float)duration * ValueAnimator.getDurationScale()));
        return this;
    }

    private final long $$robo$$android_view_RenderNodeAnimator$getDuration() {
        return this.mUnscaledDuration;
    }

    private final long $$robo$$android_view_RenderNodeAnimator$getTotalDuration() {
        return this.mUnscaledDuration + this.mUnscaledStartDelay;
    }

    private final boolean $$robo$$android_view_RenderNodeAnimator$isRunning() {
        return this.mState == 1 || this.mState == 2;
    }

    private final boolean $$robo$$android_view_RenderNodeAnimator$isStarted() {
        return this.mState != 0;
    }

    private final void $$robo$$android_view_RenderNodeAnimator$setInterpolator(TimeInterpolator interpolator2) {
        this.checkMutable();
        this.mInterpolator = interpolator2;
    }

    private final TimeInterpolator $$robo$$android_view_RenderNodeAnimator$getInterpolator() {
        return this.mInterpolator;
    }

    private final void $$robo$$android_view_RenderNodeAnimator$onFinished() {
        if (this.mState == 0) {
            this.releaseNativePtr();
            return;
        }
        if (this.mState == 1) {
            RenderNodeAnimator.getHelper().removeDelayedAnimation(this);
            this.notifyStartListeners();
        }
        this.mState = 3;
        ArrayList<Animator.AnimatorListener> listeners = this.cloneListeners();
        int numListeners = listeners == null ? 0 : listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            listeners.get(i).onAnimationEnd(this);
        }
        this.releaseNativePtr();
    }

    private final void $$robo$$android_view_RenderNodeAnimator$releaseNativePtr() {
        if (this.mNativePtr != null) {
            this.mNativePtr.release();
            this.mNativePtr = null;
        }
    }

    private final ArrayList<Animator.AnimatorListener> $$robo$$android_view_RenderNodeAnimator$cloneListeners() {
        ArrayList listeners = this.getListeners();
        if (listeners != null) {
            listeners = (ArrayList)listeners.clone();
        }
        return listeners;
    }

    private final long $$robo$$android_view_RenderNodeAnimator$getNativeAnimator() {
        return this.mNativePtr.get();
    }

    private final boolean $$robo$$android_view_RenderNodeAnimator$processDelayed(long frameTimeMs) {
        if (this.mStartTime == 0L) {
            this.mStartTime = frameTimeMs;
        } else if (frameTimeMs - this.mStartTime >= this.mStartDelay) {
            this.doStart();
            return true;
        }
        return false;
    }

    private static final DelayedAnimationHelper $$robo$$android_view_RenderNodeAnimator$getHelper() {
        DelayedAnimationHelper helper = sAnimationHelper.get();
        if (helper == null) {
            helper = new DelayedAnimationHelper();
            sAnimationHelper.set(helper);
        }
        return helper;
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$callOnFinished(RenderNodeAnimator animator2) {
        animator2.onFinished();
    }

    private final Animator $$robo$$android_view_RenderNodeAnimator$clone() {
        throw new IllegalStateException("Cannot clone this animator");
    }

    private final void $$robo$$android_view_RenderNodeAnimator$setAllowRunningAsynchronously(boolean mayRunAsync) {
        this.checkMutable();
        RenderNodeAnimator.nSetAllowRunningAsync(this.mNativePtr.get(), mayRunAsync);
    }

    private static final long $$robo$$android_view_RenderNodeAnimator$nCreateAnimator(int n, float f) {
        return 0L;
    }

    private static final long $$robo$$android_view_RenderNodeAnimator$nCreateCanvasPropertyFloatAnimator(long l, float f) {
        return 0L;
    }

    private static final long $$robo$$android_view_RenderNodeAnimator$nCreateCanvasPropertyPaintAnimator(long l, int n, float f) {
        return 0L;
    }

    private static final long $$robo$$android_view_RenderNodeAnimator$nCreateRevealAnimator(int n, int n2, float f, float f2) {
        return 0L;
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$nSetStartValue(long l, float f) {
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$nSetDuration(long l, long l2) {
    }

    private static final long $$robo$$android_view_RenderNodeAnimator$nGetDuration(long l) {
        return 0L;
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$nSetStartDelay(long l, long l2) {
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$nSetInterpolator(long l, long l2) {
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$nSetAllowRunningAsync(long l, boolean bl) {
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$nSetListener(long l, RenderNodeAnimator renderNodeAnimator) {
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$nStart(long l) {
    }

    private static final void $$robo$$android_view_RenderNodeAnimator$nEnd(long l) {
    }

    static void __staticInitializer__() {
        sViewPropertyAnimatorMap = new ShadowedObject(15){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_RenderNodeAnimator_1$__constructor__(int initialCapacity) {
                this.put(1, 0);
                this.put(2, 1);
                this.put(4, 2);
                this.put(8, 3);
                this.put(16, 4);
                this.put(32, 5);
                this.put(64, 6);
                this.put(128, 7);
                this.put(256, 8);
                this.put(512, 9);
                this.put(1024, 10);
                this.put(2048, 11);
            }

            private void __constructor__(int n) {
                this.$$robo$$android_view_RenderNodeAnimator_1$__constructor__(n);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_RenderNodeAnimator_1$__constructor__(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sAnimationHelper = new ThreadLocal();
    }

    public static int mapViewPropertyToRenderProperty(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("mapViewPropertyToRenderProperty", $$robo$$android_view_RenderNodeAnimator$mapViewPropertyToRenderProperty(int ), 0, (int)n);
    }

    private void __constructor__(int n, float f) {
        this.$$robo$$android_view_RenderNodeAnimator$__constructor__(n, f);
    }

    public RenderNodeAnimator(int n, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_RenderNodeAnimator$__constructor__(int float ), 0, this, n, f);
    }

    private void __constructor__(CanvasProperty<Float> canvasProperty, float f) {
        this.$$robo$$android_view_RenderNodeAnimator$__constructor__(canvasProperty, f);
    }

    public RenderNodeAnimator(CanvasProperty<Float> canvasProperty, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_RenderNodeAnimator$__constructor__(android.graphics.CanvasProperty<java.lang.Float> float ), 0, this, canvasProperty, f);
    }

    private void __constructor__(CanvasProperty<Paint> canvasProperty, int n, float f) {
        this.$$robo$$android_view_RenderNodeAnimator$__constructor__(canvasProperty, n, f);
    }

    public RenderNodeAnimator(CanvasProperty<Paint> canvasProperty, int n, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_RenderNodeAnimator$__constructor__(android.graphics.CanvasProperty<android.graphics.Paint> int float ), 0, this, canvasProperty, n, f);
    }

    private void __constructor__(int n, int n2, float f, float f2) {
        this.$$robo$$android_view_RenderNodeAnimator$__constructor__(n, n2, f, f2);
    }

    public RenderNodeAnimator(int n, int n2, float f, float f2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_RenderNodeAnimator$__constructor__(int int float float ), 0, this, n, n2, f, f2);
    }

    private void init(long l) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_RenderNodeAnimator$init(long ), 0, this, l);
    }

    private void checkMutable() {
        InvokeDynamicSupport.bootstrap("checkMutable", $$robo$$android_view_RenderNodeAnimator$checkMutable(), 0, this);
    }

    static boolean isNativeInterpolator(TimeInterpolator timeInterpolator) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNativeInterpolator", $$robo$$android_view_RenderNodeAnimator$isNativeInterpolator(android.animation.TimeInterpolator ), 0, (TimeInterpolator)timeInterpolator);
    }

    private void applyInterpolator() {
        InvokeDynamicSupport.bootstrap("applyInterpolator", $$robo$$android_view_RenderNodeAnimator$applyInterpolator(), 0, this);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_view_RenderNodeAnimator$start(), 0, this);
    }

    private void doStart() {
        InvokeDynamicSupport.bootstrap("doStart", $$robo$$android_view_RenderNodeAnimator$doStart(), 0, this);
    }

    private void moveToRunningState() {
        InvokeDynamicSupport.bootstrap("moveToRunningState", $$robo$$android_view_RenderNodeAnimator$moveToRunningState(), 0, this);
    }

    private void notifyStartListeners() {
        InvokeDynamicSupport.bootstrap("notifyStartListeners", $$robo$$android_view_RenderNodeAnimator$notifyStartListeners(), 0, this);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_view_RenderNodeAnimator$cancel(), 0, this);
    }

    @Override
    public void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_view_RenderNodeAnimator$end(), 0, this);
    }

    @Override
    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_view_RenderNodeAnimator$pause(), 0, this);
    }

    @Override
    public void resume() {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_view_RenderNodeAnimator$resume(), 0, this);
    }

    public void setTarget(View view) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_view_RenderNodeAnimator$setTarget(android.view.View ), 0, this, view);
    }

    public void setTarget(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_view_RenderNodeAnimator$setTarget(android.graphics.Canvas ), 0, this, canvas);
    }

    private void setTarget(RenderNode renderNode) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_view_RenderNodeAnimator$setTarget(android.view.RenderNode ), 0, this, renderNode);
    }

    public void setStartValue(float f) {
        InvokeDynamicSupport.bootstrap("setStartValue", $$robo$$android_view_RenderNodeAnimator$setStartValue(float ), 0, this, f);
    }

    @Override
    public void setStartDelay(long l) {
        InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_view_RenderNodeAnimator$setStartDelay(long ), 0, this, l);
    }

    @Override
    public long getStartDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_view_RenderNodeAnimator$getStartDelay(), 0, this);
    }

    @Override
    public RenderNodeAnimator setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_view_RenderNodeAnimator$setDuration(long ), 0, this, l);
    }

    @Override
    public long getDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_view_RenderNodeAnimator$getDuration(), 0, this);
    }

    @Override
    public long getTotalDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalDuration", $$robo$$android_view_RenderNodeAnimator$getTotalDuration(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_view_RenderNodeAnimator$isRunning(), 0, this);
    }

    @Override
    public boolean isStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_view_RenderNodeAnimator$isStarted(), 0, this);
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_view_RenderNodeAnimator$setInterpolator(android.animation.TimeInterpolator ), 0, this, timeInterpolator);
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_view_RenderNodeAnimator$getInterpolator(), 0, this);
    }

    protected void onFinished() {
        InvokeDynamicSupport.bootstrap("onFinished", $$robo$$android_view_RenderNodeAnimator$onFinished(), 0, this);
    }

    private void releaseNativePtr() {
        InvokeDynamicSupport.bootstrap("releaseNativePtr", $$robo$$android_view_RenderNodeAnimator$releaseNativePtr(), 0, this);
    }

    private ArrayList<Animator.AnimatorListener> cloneListeners() {
        return InvokeDynamicSupport.bootstrap("cloneListeners", $$robo$$android_view_RenderNodeAnimator$cloneListeners(), 0, this);
    }

    long getNativeAnimator() {
        return (long)InvokeDynamicSupport.bootstrap("getNativeAnimator", $$robo$$android_view_RenderNodeAnimator$getNativeAnimator(), 0, this);
    }

    private boolean processDelayed(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("processDelayed", $$robo$$android_view_RenderNodeAnimator$processDelayed(long ), 0, this, l);
    }

    private static DelayedAnimationHelper getHelper() {
        return InvokeDynamicSupport.bootstrapStatic("getHelper", $$robo$$android_view_RenderNodeAnimator$getHelper(), 0);
    }

    private static void callOnFinished(RenderNodeAnimator renderNodeAnimator) {
        InvokeDynamicSupport.bootstrapStatic("callOnFinished", $$robo$$android_view_RenderNodeAnimator$callOnFinished(android.view.RenderNodeAnimator ), 0, (RenderNodeAnimator)renderNodeAnimator);
    }

    @Override
    public Animator clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_view_RenderNodeAnimator$clone(), 0, this);
    }

    @Override
    public void setAllowRunningAsynchronously(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowRunningAsynchronously", $$robo$$android_view_RenderNodeAnimator$setAllowRunningAsynchronously(boolean ), 0, this, bl);
    }

    private static final native /* synthetic */ long $$robo$$nCreateAnimator$nativeBinding(int var0, float var1);

    private static long nCreateAnimator(int n, float f) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateAnimator", $$robo$$android_view_RenderNodeAnimator$nCreateAnimator(int float ), 1, (int)n, (float)f);
    }

    private static final native /* synthetic */ long $$robo$$nCreateCanvasPropertyFloatAnimator$nativeBinding(long var0, float var2);

    private static long nCreateCanvasPropertyFloatAnimator(long l, float f) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateCanvasPropertyFloatAnimator", $$robo$$android_view_RenderNodeAnimator$nCreateCanvasPropertyFloatAnimator(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ long $$robo$$nCreateCanvasPropertyPaintAnimator$nativeBinding(long var0, int var2, float var3);

    private static long nCreateCanvasPropertyPaintAnimator(long l, int n, float f) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateCanvasPropertyPaintAnimator", $$robo$$android_view_RenderNodeAnimator$nCreateCanvasPropertyPaintAnimator(long int float ), 1, (long)l, (int)n, (float)f);
    }

    private static final native /* synthetic */ long $$robo$$nCreateRevealAnimator$nativeBinding(int var0, int var1, float var2, float var3);

    private static long nCreateRevealAnimator(int n, int n2, float f, float f2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateRevealAnimator", $$robo$$android_view_RenderNodeAnimator$nCreateRevealAnimator(int int float float ), 1, (int)n, (int)n2, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$nSetStartValue$nativeBinding(long var0, float var2);

    private static void nSetStartValue(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nSetStartValue", $$robo$$android_view_RenderNodeAnimator$nSetStartValue(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ void $$robo$$nSetDuration$nativeBinding(long var0, long var2);

    private static void nSetDuration(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetDuration", $$robo$$android_view_RenderNodeAnimator$nSetDuration(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$nGetDuration$nativeBinding(long var0);

    private static long nGetDuration(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetDuration", $$robo$$android_view_RenderNodeAnimator$nGetDuration(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetStartDelay$nativeBinding(long var0, long var2);

    private static void nSetStartDelay(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetStartDelay", $$robo$$android_view_RenderNodeAnimator$nSetStartDelay(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nSetInterpolator$nativeBinding(long var0, long var2);

    private static void nSetInterpolator(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetInterpolator", $$robo$$android_view_RenderNodeAnimator$nSetInterpolator(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nSetAllowRunningAsync$nativeBinding(long var0, boolean var2);

    private static void nSetAllowRunningAsync(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetAllowRunningAsync", $$robo$$android_view_RenderNodeAnimator$nSetAllowRunningAsync(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nSetListener$nativeBinding(long var0, RenderNodeAnimator var2);

    private static void nSetListener(long l, RenderNodeAnimator renderNodeAnimator) {
        InvokeDynamicSupport.bootstrapStatic("nSetListener", $$robo$$android_view_RenderNodeAnimator$nSetListener(long android.view.RenderNodeAnimator ), 1, (long)l, (RenderNodeAnimator)renderNodeAnimator);
    }

    private static final native /* synthetic */ void $$robo$$nStart$nativeBinding(long var0);

    private static void nStart(long l) {
        InvokeDynamicSupport.bootstrapStatic("nStart", $$robo$$android_view_RenderNodeAnimator$nStart(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nEnd$nativeBinding(long var0);

    private static void nEnd(long l) {
        InvokeDynamicSupport.bootstrapStatic("nEnd", $$robo$$android_view_RenderNodeAnimator$nEnd(long ), 1, (long)l);
    }

    static {
        RobolectricInternals.classInitializing(RenderNodeAnimator.class);
    }

    public /* synthetic */ RenderNodeAnimator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RenderNodeAnimator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DelayedAnimationHelper
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<RenderNodeAnimator> mDelayedAnims;
        private Choreographer mChoreographer;
        private boolean mCallbackScheduled;

        private void $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$__constructor__() {
            this.mDelayedAnims = new ArrayList();
            this.mChoreographer = Choreographer.getInstance();
        }

        private final void $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$addDelayedAnimation(RenderNodeAnimator animator2) {
            this.mDelayedAnims.add(animator2);
            this.scheduleCallback();
        }

        private final void $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$removeDelayedAnimation(RenderNodeAnimator animator2) {
            this.mDelayedAnims.remove(animator2);
        }

        private final void $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$scheduleCallback() {
            if (!this.mCallbackScheduled) {
                this.mCallbackScheduled = true;
                this.mChoreographer.postCallback(1, this, null);
            }
        }

        private final void $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$run() {
            long frameTimeMs = this.mChoreographer.getFrameTime();
            this.mCallbackScheduled = false;
            int end = 0;
            for (int i = 0; i < this.mDelayedAnims.size(); ++i) {
                RenderNodeAnimator animator2 = this.mDelayedAnims.get(i);
                if (animator2.processDelayed(frameTimeMs)) continue;
                if (end != i) {
                    this.mDelayedAnims.set(end, animator2);
                }
                ++end;
            }
            while (this.mDelayedAnims.size() > end) {
                this.mDelayedAnims.remove(this.mDelayedAnims.size() - 1);
            }
            if (this.mDelayedAnims.size() > 0) {
                this.scheduleCallback();
            }
        }

        private void __constructor__() {
            this.$$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$__constructor__();
        }

        public DelayedAnimationHelper() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$__constructor__(), 0, this);
        }

        public void addDelayedAnimation(RenderNodeAnimator renderNodeAnimator) {
            InvokeDynamicSupport.bootstrap("addDelayedAnimation", $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$addDelayedAnimation(android.view.RenderNodeAnimator ), 0, this, renderNodeAnimator);
        }

        public void removeDelayedAnimation(RenderNodeAnimator renderNodeAnimator) {
            InvokeDynamicSupport.bootstrap("removeDelayedAnimation", $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$removeDelayedAnimation(android.view.RenderNodeAnimator ), 0, this, renderNodeAnimator);
        }

        private void scheduleCallback() {
            InvokeDynamicSupport.bootstrap("scheduleCallback", $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$scheduleCallback(), 0, this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_RenderNodeAnimator_DelayedAnimationHelper$run(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DelayedAnimationHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

