/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.InputEvent;
import android.view.KeyEvent;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MotionEvent
extends InputEvent
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long NS_PER_MS = 1000000L;
    private static String LABEL_PREFIX = "AXIS_";
    public static int INVALID_POINTER_ID = -1;
    public static int ACTION_MASK = 255;
    public static int ACTION_DOWN = 0;
    public static int ACTION_UP = 1;
    public static int ACTION_MOVE = 2;
    public static int ACTION_CANCEL = 3;
    public static int ACTION_OUTSIDE = 4;
    public static int ACTION_POINTER_DOWN = 5;
    public static int ACTION_POINTER_UP = 6;
    public static int ACTION_HOVER_MOVE = 7;
    public static int ACTION_SCROLL = 8;
    public static int ACTION_HOVER_ENTER = 9;
    public static int ACTION_HOVER_EXIT = 10;
    public static int ACTION_BUTTON_PRESS = 11;
    public static int ACTION_BUTTON_RELEASE = 12;
    public static int ACTION_POINTER_INDEX_MASK = 65280;
    public static int ACTION_POINTER_INDEX_SHIFT = 8;
    @Deprecated
    public static int ACTION_POINTER_1_DOWN = 5;
    @Deprecated
    public static int ACTION_POINTER_2_DOWN = 261;
    @Deprecated
    public static int ACTION_POINTER_3_DOWN = 517;
    @Deprecated
    public static int ACTION_POINTER_1_UP = 6;
    @Deprecated
    public static int ACTION_POINTER_2_UP = 262;
    @Deprecated
    public static int ACTION_POINTER_3_UP = 518;
    @Deprecated
    public static int ACTION_POINTER_ID_MASK = 65280;
    @Deprecated
    public static int ACTION_POINTER_ID_SHIFT = 8;
    public static int FLAG_WINDOW_IS_OBSCURED = 1;
    public static int FLAG_WINDOW_IS_PARTIALLY_OBSCURED = 2;
    public static int FLAG_TAINTED = Integer.MIN_VALUE;
    public static int FLAG_TARGET_ACCESSIBILITY_FOCUS = 0x40000000;
    public static int EDGE_TOP = 1;
    public static int EDGE_BOTTOM = 2;
    public static int EDGE_LEFT = 4;
    public static int EDGE_RIGHT = 8;
    public static int AXIS_X = 0;
    public static int AXIS_Y = 1;
    public static int AXIS_PRESSURE = 2;
    public static int AXIS_SIZE = 3;
    public static int AXIS_TOUCH_MAJOR = 4;
    public static int AXIS_TOUCH_MINOR = 5;
    public static int AXIS_TOOL_MAJOR = 6;
    public static int AXIS_TOOL_MINOR = 7;
    public static int AXIS_ORIENTATION = 8;
    public static int AXIS_VSCROLL = 9;
    public static int AXIS_HSCROLL = 10;
    public static int AXIS_Z = 11;
    public static int AXIS_RX = 12;
    public static int AXIS_RY = 13;
    public static int AXIS_RZ = 14;
    public static int AXIS_HAT_X = 15;
    public static int AXIS_HAT_Y = 16;
    public static int AXIS_LTRIGGER = 17;
    public static int AXIS_RTRIGGER = 18;
    public static int AXIS_THROTTLE = 19;
    public static int AXIS_RUDDER = 20;
    public static int AXIS_WHEEL = 21;
    public static int AXIS_GAS = 22;
    public static int AXIS_BRAKE = 23;
    public static int AXIS_DISTANCE = 24;
    public static int AXIS_TILT = 25;
    public static int AXIS_SCROLL = 26;
    public static int AXIS_RELATIVE_X = 27;
    public static int AXIS_RELATIVE_Y = 28;
    public static int AXIS_GENERIC_1 = 32;
    public static int AXIS_GENERIC_2 = 33;
    public static int AXIS_GENERIC_3 = 34;
    public static int AXIS_GENERIC_4 = 35;
    public static int AXIS_GENERIC_5 = 36;
    public static int AXIS_GENERIC_6 = 37;
    public static int AXIS_GENERIC_7 = 38;
    public static int AXIS_GENERIC_8 = 39;
    public static int AXIS_GENERIC_9 = 40;
    public static int AXIS_GENERIC_10 = 41;
    public static int AXIS_GENERIC_11 = 42;
    public static int AXIS_GENERIC_12 = 43;
    public static int AXIS_GENERIC_13 = 44;
    public static int AXIS_GENERIC_14 = 45;
    public static int AXIS_GENERIC_15 = 46;
    public static int AXIS_GENERIC_16 = 47;
    private static SparseArray<String> AXIS_SYMBOLIC_NAMES;
    public static int BUTTON_PRIMARY = 1;
    public static int BUTTON_SECONDARY = 2;
    public static int BUTTON_TERTIARY = 4;
    public static int BUTTON_BACK = 8;
    public static int BUTTON_FORWARD = 16;
    public static int BUTTON_STYLUS_PRIMARY = 32;
    public static int BUTTON_STYLUS_SECONDARY = 64;
    private static String[] BUTTON_SYMBOLIC_NAMES;
    public static int TOOL_TYPE_UNKNOWN = 0;
    public static int TOOL_TYPE_FINGER = 1;
    public static int TOOL_TYPE_STYLUS = 2;
    public static int TOOL_TYPE_MOUSE = 3;
    public static int TOOL_TYPE_ERASER = 4;
    private static SparseArray<String> TOOL_TYPE_SYMBOLIC_NAMES;
    private static int HISTORY_CURRENT = Integer.MIN_VALUE;
    private static int MAX_RECYCLED = 10;
    private static Object gRecyclerLock;
    private static int gRecyclerUsed;
    private static MotionEvent gRecyclerTop;
    private static Object gSharedTempLock;
    private static PointerCoords[] gSharedTempPointerCoords;
    private static PointerProperties[] gSharedTempPointerProperties;
    private static int[] gSharedTempPointerIndexMap;
    private long mNativePtr;
    private MotionEvent mNext;
    public static Parcelable.Creator<MotionEvent> CREATOR;

    private static final void $$robo$$android_view_MotionEvent$ensureSharedTempPointerCapacity(int desiredCapacity) {
        if (gSharedTempPointerCoords == null || gSharedTempPointerCoords.length < desiredCapacity) {
            int capacity;
            int n = capacity = gSharedTempPointerCoords != null ? gSharedTempPointerCoords.length : 8;
            while (capacity < desiredCapacity) {
                capacity *= 2;
            }
            gSharedTempPointerCoords = PointerCoords.createArray(capacity);
            gSharedTempPointerProperties = PointerProperties.createArray(capacity);
            gSharedTempPointerIndexMap = new int[capacity];
        }
    }

    private static final long $$robo$$android_view_MotionEvent$nativeInitialize(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, float f3, float f4, long l2, long l3, int n8, PointerProperties[] pointerPropertiesArray, PointerCoords[] pointerCoordsArray) {
        return 0L;
    }

    private static final long $$robo$$android_view_MotionEvent$nativeCopy(long l, long l2, boolean bl) {
        return 0L;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeDispose(long l) {
    }

    private static final void $$robo$$android_view_MotionEvent$nativeAddBatch(long l, long l2, PointerCoords[] pointerCoordsArray, int n) {
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetDeviceId(long l) {
        return 0;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetSource(long l) {
        return 0;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeSetSource(long l, int n) {
        return 0;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetAction(long l) {
        return 0;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeSetAction(long l, int n) {
    }

    private static final boolean $$robo$$android_view_MotionEvent$nativeIsTouchEvent(long l) {
        return false;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetFlags(long l) {
        return 0;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeSetFlags(long l, int n) {
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetEdgeFlags(long l) {
        return 0;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeSetEdgeFlags(long l, int n) {
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetMetaState(long l) {
        return 0;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetButtonState(long l) {
        return 0;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeSetButtonState(long l, int n) {
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetActionButton(long l) {
        return 0;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeSetActionButton(long l, int n) {
    }

    private static final void $$robo$$android_view_MotionEvent$nativeOffsetLocation(long l, float f, float f2) {
    }

    private static final float $$robo$$android_view_MotionEvent$nativeGetXOffset(long l) {
        return 0.0f;
    }

    private static final float $$robo$$android_view_MotionEvent$nativeGetYOffset(long l) {
        return 0.0f;
    }

    private static final float $$robo$$android_view_MotionEvent$nativeGetXPrecision(long l) {
        return 0.0f;
    }

    private static final float $$robo$$android_view_MotionEvent$nativeGetYPrecision(long l) {
        return 0.0f;
    }

    private static final long $$robo$$android_view_MotionEvent$nativeGetDownTimeNanos(long l) {
        return 0L;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeSetDownTimeNanos(long l, long l2) {
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetPointerCount(long l) {
        return 0;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetPointerId(long l, int n) {
        return 0;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetToolType(long l, int n) {
        return 0;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeFindPointerIndex(long l, int n) {
        return 0;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeGetHistorySize(long l) {
        return 0;
    }

    private static final long $$robo$$android_view_MotionEvent$nativeGetEventTimeNanos(long l, int n) {
        return 0L;
    }

    private static final float $$robo$$android_view_MotionEvent$nativeGetRawAxisValue(long l, int n, int n2, int n3) {
        return 0.0f;
    }

    private static final float $$robo$$android_view_MotionEvent$nativeGetAxisValue(long l, int n, int n2, int n3) {
        return 0.0f;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeGetPointerCoords(long l, int n, int n2, PointerCoords pointerCoords) {
    }

    private static final void $$robo$$android_view_MotionEvent$nativeGetPointerProperties(long l, int n, PointerProperties pointerProperties) {
    }

    private static final void $$robo$$android_view_MotionEvent$nativeScale(long l, float f) {
    }

    private static final void $$robo$$android_view_MotionEvent$nativeTransform(long l, Matrix matrix) {
    }

    private static final long $$robo$$android_view_MotionEvent$nativeReadFromParcel(long l, Parcel parcel) {
        return 0L;
    }

    private static final void $$robo$$android_view_MotionEvent$nativeWriteToParcel(long l, Parcel parcel) {
    }

    private static final String $$robo$$android_view_MotionEvent$nativeAxisToString(int n) {
        return null;
    }

    private static final int $$robo$$android_view_MotionEvent$nativeAxisFromString(String string2) {
        return 0;
    }

    private void $$robo$$android_view_MotionEvent$__constructor__() {
    }

    private final void $$robo$$android_view_MotionEvent$finalize() throws Throwable {
        try {
            if (this.mNativePtr != 0L) {
                MotionEvent.nativeDispose(this.mNativePtr);
                this.mNativePtr = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MotionEvent $$robo$$android_view_MotionEvent$obtain() {
        MotionEvent ev;
        Object object = gRecyclerLock;
        synchronized (object) {
            ev = gRecyclerTop;
            if (ev == null) {
                return new MotionEvent();
            }
            gRecyclerTop = ev.mNext;
            --gRecyclerUsed;
        }
        ev.mNext = null;
        ev.prepareForReuse();
        return ev;
    }

    private static final MotionEvent $$robo$$android_view_MotionEvent$obtain(long downTime, long eventTime, int action, int pointerCount, PointerProperties[] pointerProperties, PointerCoords[] pointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, deviceId, source, action, flags, edgeFlags, metaState, buttonState, 0.0f, 0.0f, xPrecision, yPrecision, downTime * 1000000L, eventTime * 1000000L, pointerCount, pointerProperties, pointerCoords);
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static final MotionEvent $$robo$$android_view_MotionEvent$obtain(long downTime, long eventTime, int action, int pointerCount, int[] pointerIds, PointerCoords[] pointerCoords, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) {
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(pointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            for (int i = 0; i < pointerCount; ++i) {
                pp[i].clear();
                pp[i].id = pointerIds[i];
            }
            return MotionEvent.obtain(downTime, eventTime, action, pointerCount, pp, pointerCoords, metaState, 0, xPrecision, yPrecision, deviceId, edgeFlags, source, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MotionEvent $$robo$$android_view_MotionEvent$obtain(long downTime, long eventTime, int action, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerProperties[] pp = gSharedTempPointerProperties;
            pp[0].clear();
            pp[0].id = 0;
            PointerCoords[] pc = gSharedTempPointerCoords;
            pc[0].clear();
            pc[0].x = x;
            pc[0].y = y;
            pc[0].pressure = pressure;
            pc[0].size = size;
            ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, deviceId, 0, action, 0, edgeFlags, metaState, 0, 0.0f, 0.0f, xPrecision, yPrecision, downTime * 1000000L, eventTime * 1000000L, 1, pp, pc);
            return ev;
        }
    }

    @Deprecated
    private static final MotionEvent $$robo$$android_view_MotionEvent$obtain(long downTime, long eventTime, int action, int pointerCount, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        return MotionEvent.obtain(downTime, eventTime, action, x, y, pressure, size, metaState, xPrecision, yPrecision, deviceId, edgeFlags);
    }

    private static final MotionEvent $$robo$$android_view_MotionEvent$obtain(long downTime, long eventTime, int action, float x, float y, int metaState) {
        return MotionEvent.obtain(downTime, eventTime, action, x, y, 1.0f, 1.0f, metaState, 1.0f, 1.0f, 0, 0);
    }

    private static final MotionEvent $$robo$$android_view_MotionEvent$obtain(MotionEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeCopy(ev.mNativePtr, other.mNativePtr, true);
        return ev;
    }

    private static final MotionEvent $$robo$$android_view_MotionEvent$obtainNoHistory(MotionEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeCopy(ev.mNativePtr, other.mNativePtr, false);
        return ev;
    }

    private final MotionEvent $$robo$$android_view_MotionEvent$copy() {
        return MotionEvent.obtain(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_MotionEvent$recycle() {
        super.recycle();
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                ++gRecyclerUsed;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
        }
    }

    private final void $$robo$$android_view_MotionEvent$scale(float scale) {
        if (scale != 1.0f) {
            MotionEvent.nativeScale(this.mNativePtr, scale);
        }
    }

    private final int $$robo$$android_view_MotionEvent$getDeviceId() {
        return MotionEvent.nativeGetDeviceId(this.mNativePtr);
    }

    private final int $$robo$$android_view_MotionEvent$getSource() {
        return MotionEvent.nativeGetSource(this.mNativePtr);
    }

    private final void $$robo$$android_view_MotionEvent$setSource(int source) {
        MotionEvent.nativeSetSource(this.mNativePtr, source);
    }

    private final int $$robo$$android_view_MotionEvent$getAction() {
        return MotionEvent.nativeGetAction(this.mNativePtr);
    }

    private final int $$robo$$android_view_MotionEvent$getActionMasked() {
        return MotionEvent.nativeGetAction(this.mNativePtr) & 0xFF;
    }

    private final int $$robo$$android_view_MotionEvent$getActionIndex() {
        return (MotionEvent.nativeGetAction(this.mNativePtr) & 0xFF00) >> 8;
    }

    private final boolean $$robo$$android_view_MotionEvent$isTouchEvent() {
        return MotionEvent.nativeIsTouchEvent(this.mNativePtr);
    }

    private final int $$robo$$android_view_MotionEvent$getFlags() {
        return MotionEvent.nativeGetFlags(this.mNativePtr);
    }

    private final boolean $$robo$$android_view_MotionEvent$isTainted() {
        int flags = this.getFlags();
        return (flags & Integer.MIN_VALUE) != 0;
    }

    private final void $$robo$$android_view_MotionEvent$setTainted(boolean tainted) {
        int flags = this.getFlags();
        MotionEvent.nativeSetFlags(this.mNativePtr, tainted ? flags | Integer.MIN_VALUE : flags & Integer.MAX_VALUE);
    }

    private final boolean $$robo$$android_view_MotionEvent$isTargetAccessibilityFocus() {
        int flags = this.getFlags();
        return (flags & 0x40000000) != 0;
    }

    private final void $$robo$$android_view_MotionEvent$setTargetAccessibilityFocus(boolean targetsFocus) {
        int flags = this.getFlags();
        MotionEvent.nativeSetFlags(this.mNativePtr, targetsFocus ? flags | 0x40000000 : flags & 0xBFFFFFFF);
    }

    private final long $$robo$$android_view_MotionEvent$getDownTime() {
        return MotionEvent.nativeGetDownTimeNanos(this.mNativePtr) / 1000000L;
    }

    private final void $$robo$$android_view_MotionEvent$setDownTime(long downTime) {
        MotionEvent.nativeSetDownTimeNanos(this.mNativePtr, downTime * 1000000L);
    }

    private final long $$robo$$android_view_MotionEvent$getEventTime() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE) / 1000000L;
    }

    private final long $$robo$$android_view_MotionEvent$getEventTimeNano() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getX() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getY() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getPressure() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getSize() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getTouchMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getTouchMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getToolMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getToolMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getOrientation() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getAxisValue(int axis) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, 0, Integer.MIN_VALUE);
    }

    private final int $$robo$$android_view_MotionEvent$getPointerCount() {
        return MotionEvent.nativeGetPointerCount(this.mNativePtr);
    }

    private final int $$robo$$android_view_MotionEvent$getPointerId(int pointerIndex) {
        return MotionEvent.nativeGetPointerId(this.mNativePtr, pointerIndex);
    }

    private final int $$robo$$android_view_MotionEvent$getToolType(int pointerIndex) {
        return MotionEvent.nativeGetToolType(this.mNativePtr, pointerIndex);
    }

    private final int $$robo$$android_view_MotionEvent$findPointerIndex(int pointerId) {
        return MotionEvent.nativeFindPointerIndex(this.mNativePtr, pointerId);
    }

    private final float $$robo$$android_view_MotionEvent$getX(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getY(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getPressure(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getSize(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getTouchMajor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getTouchMinor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getToolMajor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getToolMinor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getOrientation(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, pointerIndex, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getAxisValue(int axis, int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, pointerIndex, Integer.MIN_VALUE);
    }

    private final void $$robo$$android_view_MotionEvent$getPointerCoords(int pointerIndex, PointerCoords outPointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, pointerIndex, Integer.MIN_VALUE, outPointerCoords);
    }

    private final void $$robo$$android_view_MotionEvent$getPointerProperties(int pointerIndex, PointerProperties outPointerProperties) {
        MotionEvent.nativeGetPointerProperties(this.mNativePtr, pointerIndex, outPointerProperties);
    }

    private final int $$robo$$android_view_MotionEvent$getMetaState() {
        return MotionEvent.nativeGetMetaState(this.mNativePtr);
    }

    private final int $$robo$$android_view_MotionEvent$getButtonState() {
        return MotionEvent.nativeGetButtonState(this.mNativePtr);
    }

    private final void $$robo$$android_view_MotionEvent$setButtonState(int buttonState) {
        MotionEvent.nativeSetButtonState(this.mNativePtr, buttonState);
    }

    private final int $$robo$$android_view_MotionEvent$getActionButton() {
        return MotionEvent.nativeGetActionButton(this.mNativePtr);
    }

    private final void $$robo$$android_view_MotionEvent$setActionButton(int button) {
        MotionEvent.nativeSetActionButton(this.mNativePtr, button);
    }

    private final float $$robo$$android_view_MotionEvent$getRawX() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getRawY() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    private final float $$robo$$android_view_MotionEvent$getXPrecision() {
        return MotionEvent.nativeGetXPrecision(this.mNativePtr);
    }

    private final float $$robo$$android_view_MotionEvent$getYPrecision() {
        return MotionEvent.nativeGetYPrecision(this.mNativePtr);
    }

    private final int $$robo$$android_view_MotionEvent$getHistorySize() {
        return MotionEvent.nativeGetHistorySize(this.mNativePtr);
    }

    private final long $$robo$$android_view_MotionEvent$getHistoricalEventTime(int pos) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, pos) / 1000000L;
    }

    private final long $$robo$$android_view_MotionEvent$getHistoricalEventTimeNano(int pos) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalX(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalY(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalPressure(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalSize(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalTouchMajor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalTouchMinor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalToolMajor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalToolMinor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalOrientation(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalAxisValue(int axis, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, 0, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalX(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalY(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalPressure(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalSize(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalTouchMajor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalTouchMinor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalToolMajor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalToolMinor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalOrientation(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, pointerIndex, pos);
    }

    private final float $$robo$$android_view_MotionEvent$getHistoricalAxisValue(int axis, int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, pointerIndex, pos);
    }

    private final void $$robo$$android_view_MotionEvent$getHistoricalPointerCoords(int pointerIndex, int pos, PointerCoords outPointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, pointerIndex, pos, outPointerCoords);
    }

    private final int $$robo$$android_view_MotionEvent$getEdgeFlags() {
        return MotionEvent.nativeGetEdgeFlags(this.mNativePtr);
    }

    private final void $$robo$$android_view_MotionEvent$setEdgeFlags(int flags) {
        MotionEvent.nativeSetEdgeFlags(this.mNativePtr, flags);
    }

    private final void $$robo$$android_view_MotionEvent$setAction(int action) {
        MotionEvent.nativeSetAction(this.mNativePtr, action);
    }

    private final void $$robo$$android_view_MotionEvent$offsetLocation(float deltaX, float deltaY) {
        if (deltaX != 0.0f || deltaY != 0.0f) {
            MotionEvent.nativeOffsetLocation(this.mNativePtr, deltaX, deltaY);
        }
    }

    private final void $$robo$$android_view_MotionEvent$setLocation(float x, float y) {
        float oldX = this.getX();
        float oldY = this.getY();
        this.offsetLocation(x - oldX, y - oldY);
    }

    private final void $$robo$$android_view_MotionEvent$transform(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("matrix must not be null");
        }
        MotionEvent.nativeTransform(this.mNativePtr, matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_MotionEvent$addBatch(long eventTime, float x, float y, float pressure, float size, int metaState) {
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(1);
            PointerCoords[] pc = gSharedTempPointerCoords;
            pc[0].clear();
            pc[0].x = x;
            pc[0].y = y;
            pc[0].pressure = pressure;
            pc[0].size = size;
            MotionEvent.nativeAddBatch(this.mNativePtr, eventTime * 1000000L, pc, metaState);
        }
    }

    private final void $$robo$$android_view_MotionEvent$addBatch(long eventTime, PointerCoords[] pointerCoords, int metaState) {
        MotionEvent.nativeAddBatch(this.mNativePtr, eventTime * 1000000L, pointerCoords, metaState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_MotionEvent$addBatch(MotionEvent event) {
        int action = MotionEvent.nativeGetAction(this.mNativePtr);
        if (action != 2 && action != 7) {
            return false;
        }
        if (action != MotionEvent.nativeGetAction(event.mNativePtr)) {
            return false;
        }
        if (MotionEvent.nativeGetDeviceId(this.mNativePtr) != MotionEvent.nativeGetDeviceId(event.mNativePtr) || MotionEvent.nativeGetSource(this.mNativePtr) != MotionEvent.nativeGetSource(event.mNativePtr) || MotionEvent.nativeGetFlags(this.mNativePtr) != MotionEvent.nativeGetFlags(event.mNativePtr)) {
            return false;
        }
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        if (pointerCount != MotionEvent.nativeGetPointerCount(event.mNativePtr)) {
            return false;
        }
        Object object = gSharedTempLock;
        synchronized (object) {
            MotionEvent.ensureSharedTempPointerCapacity(Math.max(pointerCount, 2));
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            for (int i = 0; i < pointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[0]);
                MotionEvent.nativeGetPointerProperties(event.mNativePtr, i, pp[1]);
                if (pp[0].equals(pp[1])) continue;
                return false;
            }
            int metaState = MotionEvent.nativeGetMetaState(event.mNativePtr);
            int historySize = MotionEvent.nativeGetHistorySize(event.mNativePtr);
            for (int h = 0; h <= historySize; ++h) {
                int historyPos = h == historySize ? Integer.MIN_VALUE : h;
                for (int i = 0; i < pointerCount; ++i) {
                    MotionEvent.nativeGetPointerCoords(event.mNativePtr, i, historyPos, pc[i]);
                }
                long eventTimeNanos = MotionEvent.nativeGetEventTimeNanos(event.mNativePtr, historyPos);
                MotionEvent.nativeAddBatch(this.mNativePtr, eventTimeNanos, pc, metaState);
            }
        }
        return true;
    }

    private final boolean $$robo$$android_view_MotionEvent$isWithinBoundsNoHistory(float left, float top, float right, float bottom) {
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        for (int i = 0; i < pointerCount; ++i) {
            float x = MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, i, Integer.MIN_VALUE);
            float y = MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, i, Integer.MIN_VALUE);
            if (!(x < left || x > right || y < top) && !(y > bottom)) continue;
            return false;
        }
        return true;
    }

    private static final float $$robo$$android_view_MotionEvent$clamp(float value, float low, float high) {
        if (value < low) {
            return low;
        }
        if (value > high) {
            return high;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MotionEvent $$robo$$android_view_MotionEvent$clampNoHistory(float left, float top, float right, float bottom) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
            MotionEvent.ensureSharedTempPointerCapacity(pointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            for (int i = 0; i < pointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[i]);
                MotionEvent.nativeGetPointerCoords(this.mNativePtr, i, Integer.MIN_VALUE, pc[i]);
                pc[i].x = MotionEvent.clamp(pc[i].x, left, right);
                pc[i].y = MotionEvent.clamp(pc[i].y, top, bottom);
            }
            ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, MotionEvent.nativeGetDeviceId(this.mNativePtr), MotionEvent.nativeGetSource(this.mNativePtr), MotionEvent.nativeGetAction(this.mNativePtr), MotionEvent.nativeGetFlags(this.mNativePtr), MotionEvent.nativeGetEdgeFlags(this.mNativePtr), MotionEvent.nativeGetMetaState(this.mNativePtr), MotionEvent.nativeGetButtonState(this.mNativePtr), MotionEvent.nativeGetXOffset(this.mNativePtr), MotionEvent.nativeGetYOffset(this.mNativePtr), MotionEvent.nativeGetXPrecision(this.mNativePtr), MotionEvent.nativeGetYPrecision(this.mNativePtr), MotionEvent.nativeGetDownTimeNanos(this.mNativePtr), MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE), pointerCount, pp, pc);
            return ev;
        }
    }

    private final int $$robo$$android_view_MotionEvent$getPointerIdBits() {
        int idBits = 0;
        int pointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
        for (int i = 0; i < pointerCount; ++i) {
            idBits |= 1 << MotionEvent.nativeGetPointerId(this.mNativePtr, i);
        }
        return idBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MotionEvent $$robo$$android_view_MotionEvent$split(int idBits) {
        MotionEvent ev = MotionEvent.obtain();
        Object object = gSharedTempLock;
        synchronized (object) {
            int oldPointerCount = MotionEvent.nativeGetPointerCount(this.mNativePtr);
            MotionEvent.ensureSharedTempPointerCapacity(oldPointerCount);
            PointerProperties[] pp = gSharedTempPointerProperties;
            PointerCoords[] pc = gSharedTempPointerCoords;
            int[] map = gSharedTempPointerIndexMap;
            int oldAction = MotionEvent.nativeGetAction(this.mNativePtr);
            int oldActionMasked = oldAction & 0xFF;
            int oldActionPointerIndex = (oldAction & 0xFF00) >> 8;
            int newActionPointerIndex = -1;
            int newPointerCount = 0;
            int newIdBits = 0;
            for (int i = 0; i < oldPointerCount; ++i) {
                MotionEvent.nativeGetPointerProperties(this.mNativePtr, i, pp[newPointerCount]);
                int idBit = 1 << pp[newPointerCount].id;
                if ((idBit & idBits) == 0) continue;
                if (i == oldActionPointerIndex) {
                    newActionPointerIndex = newPointerCount;
                }
                map[newPointerCount] = i;
                ++newPointerCount;
                newIdBits |= idBit;
            }
            if (newPointerCount == 0) {
                throw new IllegalArgumentException("idBits did not match any ids in the event");
            }
            int newAction = oldActionMasked == 5 || oldActionMasked == 6 ? (newActionPointerIndex < 0 ? 2 : (newPointerCount == 1 ? (oldActionMasked == 5 ? 0 : 1) : oldActionMasked | newActionPointerIndex << 8)) : oldAction;
            int historySize = MotionEvent.nativeGetHistorySize(this.mNativePtr);
            for (int h = 0; h <= historySize; ++h) {
                int historyPos = h == historySize ? Integer.MIN_VALUE : h;
                for (int i = 0; i < newPointerCount; ++i) {
                    MotionEvent.nativeGetPointerCoords(this.mNativePtr, map[i], historyPos, pc[i]);
                }
                long eventTimeNanos = MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, historyPos);
                if (h == 0) {
                    ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, MotionEvent.nativeGetDeviceId(this.mNativePtr), MotionEvent.nativeGetSource(this.mNativePtr), newAction, MotionEvent.nativeGetFlags(this.mNativePtr), MotionEvent.nativeGetEdgeFlags(this.mNativePtr), MotionEvent.nativeGetMetaState(this.mNativePtr), MotionEvent.nativeGetButtonState(this.mNativePtr), MotionEvent.nativeGetXOffset(this.mNativePtr), MotionEvent.nativeGetYOffset(this.mNativePtr), MotionEvent.nativeGetXPrecision(this.mNativePtr), MotionEvent.nativeGetYPrecision(this.mNativePtr), MotionEvent.nativeGetDownTimeNanos(this.mNativePtr), eventTimeNanos, newPointerCount, pp, pc);
                    continue;
                }
                MotionEvent.nativeAddBatch(ev.mNativePtr, eventTimeNanos, pc, 0);
            }
            return ev;
        }
    }

    private final String $$robo$$android_view_MotionEvent$toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("MotionEvent { action=").append(MotionEvent.actionToString(this.getAction()));
        msg.append(", actionButton=").append(MotionEvent.buttonStateToString(this.getActionButton()));
        int pointerCount = this.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            msg.append(", id[").append(i).append("]=").append(this.getPointerId(i));
            msg.append(", x[").append(i).append("]=").append(this.getX(i));
            msg.append(", y[").append(i).append("]=").append(this.getY(i));
            msg.append(", toolType[").append(i).append("]=").append(MotionEvent.toolTypeToString(this.getToolType(i)));
        }
        msg.append(", buttonState=").append(MotionEvent.buttonStateToString(this.getButtonState()));
        msg.append(", metaState=").append(KeyEvent.metaStateToString(this.getMetaState()));
        msg.append(", flags=0x").append(Integer.toHexString(this.getFlags()));
        msg.append(", edgeFlags=0x").append(Integer.toHexString(this.getEdgeFlags()));
        msg.append(", pointerCount=").append(pointerCount);
        msg.append(", historySize=").append(this.getHistorySize());
        msg.append(", eventTime=").append(this.getEventTime());
        msg.append(", downTime=").append(this.getDownTime());
        msg.append(", deviceId=").append(this.getDeviceId());
        msg.append(", source=0x").append(Integer.toHexString(this.getSource()));
        msg.append(" }");
        return msg.toString();
    }

    private static final String $$robo$$android_view_MotionEvent$actionToString(int action) {
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
            case 9: {
                return "ACTION_HOVER_ENTER";
            }
            case 10: {
                return "ACTION_HOVER_EXIT";
            }
            case 11: {
                return "ACTION_BUTTON_PRESS";
            }
            case 12: {
                return "ACTION_BUTTON_RELEASE";
            }
        }
        int index = (action & 0xFF00) >> 8;
        switch (action & 0xFF) {
            case 5: {
                return "ACTION_POINTER_DOWN(" + index + ")";
            }
            case 6: {
                return "ACTION_POINTER_UP(" + index + ")";
            }
        }
        return Integer.toString(action);
    }

    private static final String $$robo$$android_view_MotionEvent$axisToString(int axis) {
        String symbolicName = MotionEvent.nativeAxisToString(axis);
        return symbolicName != null ? "AXIS_" + symbolicName : Integer.toString(axis);
    }

    private static final int $$robo$$android_view_MotionEvent$axisFromString(String symbolicName) {
        int axis;
        if (symbolicName.startsWith("AXIS_") && (axis = MotionEvent.nativeAxisFromString(symbolicName = symbolicName.substring("AXIS_".length()))) >= 0) {
            return axis;
        }
        try {
            return Integer.parseInt(symbolicName, 10);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static final String $$robo$$android_view_MotionEvent$buttonStateToString(int buttonState) {
        if (buttonState == 0) {
            return "0";
        }
        StringBuilder result = null;
        int i = 0;
        while (buttonState != 0) {
            boolean isSet = (buttonState & 1) != 0;
            buttonState >>>= 1;
            if (isSet) {
                String name = BUTTON_SYMBOLIC_NAMES[i];
                if (result == null) {
                    if (buttonState == 0) {
                        return name;
                    }
                    result = new StringBuilder(name);
                } else {
                    result.append('|');
                    result.append(name);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static final String $$robo$$android_view_MotionEvent$toolTypeToString(int toolType) {
        String symbolicName = TOOL_TYPE_SYMBOLIC_NAMES.get(toolType);
        return symbolicName != null ? symbolicName : Integer.toString(toolType);
    }

    private final boolean $$robo$$android_view_MotionEvent$isButtonPressed(int button) {
        if (button == 0) {
            return false;
        }
        return (this.getButtonState() & button) == button;
    }

    private static final MotionEvent $$robo$$android_view_MotionEvent$createFromParcelBody(Parcel in) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeReadFromParcel(ev.mNativePtr, in);
        return ev;
    }

    private final void $$robo$$android_view_MotionEvent$cancel() {
        this.setAction(3);
    }

    private final void $$robo$$android_view_MotionEvent$writeToParcel(Parcel out, int flags) {
        out.writeInt(1);
        MotionEvent.nativeWriteToParcel(this.mNativePtr, out);
    }

    static void __staticInitializer__() {
        SparseArray<String> names = AXIS_SYMBOLIC_NAMES = new SparseArray();
        names.append(0, "AXIS_X");
        names.append(1, "AXIS_Y");
        names.append(2, "AXIS_PRESSURE");
        names.append(3, "AXIS_SIZE");
        names.append(4, "AXIS_TOUCH_MAJOR");
        names.append(5, "AXIS_TOUCH_MINOR");
        names.append(6, "AXIS_TOOL_MAJOR");
        names.append(7, "AXIS_TOOL_MINOR");
        names.append(8, "AXIS_ORIENTATION");
        names.append(9, "AXIS_VSCROLL");
        names.append(10, "AXIS_HSCROLL");
        names.append(11, "AXIS_Z");
        names.append(12, "AXIS_RX");
        names.append(13, "AXIS_RY");
        names.append(14, "AXIS_RZ");
        names.append(15, "AXIS_HAT_X");
        names.append(16, "AXIS_HAT_Y");
        names.append(17, "AXIS_LTRIGGER");
        names.append(18, "AXIS_RTRIGGER");
        names.append(19, "AXIS_THROTTLE");
        names.append(20, "AXIS_RUDDER");
        names.append(21, "AXIS_WHEEL");
        names.append(22, "AXIS_GAS");
        names.append(23, "AXIS_BRAKE");
        names.append(24, "AXIS_DISTANCE");
        names.append(25, "AXIS_TILT");
        names.append(26, "AXIS_SCROLL");
        names.append(27, "AXIS_REALTIVE_X");
        names.append(28, "AXIS_REALTIVE_Y");
        names.append(32, "AXIS_GENERIC_1");
        names.append(33, "AXIS_GENERIC_2");
        names.append(34, "AXIS_GENERIC_3");
        names.append(35, "AXIS_GENERIC_4");
        names.append(36, "AXIS_GENERIC_5");
        names.append(37, "AXIS_GENERIC_6");
        names.append(38, "AXIS_GENERIC_7");
        names.append(39, "AXIS_GENERIC_8");
        names.append(40, "AXIS_GENERIC_9");
        names.append(41, "AXIS_GENERIC_10");
        names.append(42, "AXIS_GENERIC_11");
        names.append(43, "AXIS_GENERIC_12");
        names.append(44, "AXIS_GENERIC_13");
        names.append(45, "AXIS_GENERIC_14");
        names.append(46, "AXIS_GENERIC_15");
        names.append(47, "AXIS_GENERIC_16");
        BUTTON_SYMBOLIC_NAMES = new String[]{"BUTTON_PRIMARY", "BUTTON_SECONDARY", "BUTTON_TERTIARY", "BUTTON_BACK", "BUTTON_FORWARD", "BUTTON_STYLUS_PRIMARY", "BUTTON_STYLUS_SECONDARY", "0x00000080", "0x00000100", "0x00000200", "0x00000400", "0x00000800", "0x00001000", "0x00002000", "0x00004000", "0x00008000", "0x00010000", "0x00020000", "0x00040000", "0x00080000", "0x00100000", "0x00200000", "0x00400000", "0x00800000", "0x01000000", "0x02000000", "0x04000000", "0x08000000", "0x10000000", "0x20000000", "0x40000000", "0x80000000"};
        TOOL_TYPE_SYMBOLIC_NAMES = new SparseArray();
        names = TOOL_TYPE_SYMBOLIC_NAMES;
        names.append(0, "TOOL_TYPE_UNKNOWN");
        names.append(1, "TOOL_TYPE_FINGER");
        names.append(2, "TOOL_TYPE_STYLUS");
        names.append(3, "TOOL_TYPE_MOUSE");
        names.append(4, "TOOL_TYPE_ERASER");
        gRecyclerLock = new Object();
        gSharedTempLock = new Object();
        CREATOR = new Parcelable.Creator<MotionEvent>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_MotionEvent_1$__constructor__() {
            }

            private final MotionEvent $$robo$$android_view_MotionEvent_1$createFromParcel(Parcel in) {
                in.readInt();
                return MotionEvent.createFromParcelBody(in);
            }

            private final MotionEvent[] $$robo$$android_view_MotionEvent_1$newArray(int size) {
                return new MotionEvent[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_MotionEvent_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MotionEvent_1$__constructor__(), 0, this);
            }

            @Override
            public MotionEvent createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_MotionEvent_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public MotionEvent[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_MotionEvent_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private static void ensureSharedTempPointerCapacity(int n) {
        InvokeDynamicSupport.bootstrapStatic("ensureSharedTempPointerCapacity", $$robo$$android_view_MotionEvent$ensureSharedTempPointerCapacity(int ), 0, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nativeInitialize$nativeBinding(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9, float var10, float var11, float var12, long var13, long var15, int var17, PointerProperties[] var18, PointerCoords[] var19);

    private static long nativeInitialize(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, float f3, float f4, long l2, long l3, int n8, PointerProperties[] pointerPropertiesArray, PointerCoords[] pointerCoordsArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeInitialize", $$robo$$android_view_MotionEvent$nativeInitialize(long int int int int int int int float float float float long long int android.view.MotionEvent$PointerProperties[] android.view.MotionEvent$PointerCoords[] ), 1, (long)l, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (float)f, (float)f2, (float)f3, (float)f4, (long)l2, (long)l3, (int)n8, (PointerProperties[])pointerPropertiesArray, (PointerCoords[])pointerCoordsArray);
    }

    private static final native /* synthetic */ long $$robo$$nativeCopy$nativeBinding(long var0, long var2, boolean var4);

    private static long nativeCopy(long l, long l2, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCopy", $$robo$$android_view_MotionEvent$nativeCopy(long long boolean ), 1, (long)l, (long)l2, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nativeDispose$nativeBinding(long var0);

    private static void nativeDispose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDispose", $$robo$$android_view_MotionEvent$nativeDispose(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeAddBatch$nativeBinding(long var0, long var2, PointerCoords[] var4, int var5);

    private static void nativeAddBatch(long l, long l2, PointerCoords[] pointerCoordsArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeAddBatch", $$robo$$android_view_MotionEvent$nativeAddBatch(long long android.view.MotionEvent$PointerCoords[] int ), 1, (long)l, (long)l2, (PointerCoords[])pointerCoordsArray, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetDeviceId$nativeBinding(long var0);

    private static int nativeGetDeviceId(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetDeviceId", $$robo$$android_view_MotionEvent$nativeGetDeviceId(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetSource$nativeBinding(long var0);

    private static int nativeGetSource(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetSource", $$robo$$android_view_MotionEvent$nativeGetSource(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetSource$nativeBinding(long var0, int var2);

    private static int nativeSetSource(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetSource", $$robo$$android_view_MotionEvent$nativeSetSource(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetAction$nativeBinding(long var0);

    private static int nativeGetAction(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetAction", $$robo$$android_view_MotionEvent$nativeGetAction(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetAction$nativeBinding(long var0, int var2);

    private static void nativeSetAction(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetAction", $$robo$$android_view_MotionEvent$nativeSetAction(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsTouchEvent$nativeBinding(long var0);

    private static boolean nativeIsTouchEvent(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsTouchEvent", $$robo$$android_view_MotionEvent$nativeIsTouchEvent(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetFlags$nativeBinding(long var0);

    private static int nativeGetFlags(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetFlags", $$robo$$android_view_MotionEvent$nativeGetFlags(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetFlags$nativeBinding(long var0, int var2);

    private static void nativeSetFlags(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetFlags", $$robo$$android_view_MotionEvent$nativeSetFlags(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetEdgeFlags$nativeBinding(long var0);

    private static int nativeGetEdgeFlags(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetEdgeFlags", $$robo$$android_view_MotionEvent$nativeGetEdgeFlags(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetEdgeFlags$nativeBinding(long var0, int var2);

    private static void nativeSetEdgeFlags(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetEdgeFlags", $$robo$$android_view_MotionEvent$nativeSetEdgeFlags(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetMetaState$nativeBinding(long var0);

    private static int nativeGetMetaState(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetMetaState", $$robo$$android_view_MotionEvent$nativeGetMetaState(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetButtonState$nativeBinding(long var0);

    private static int nativeGetButtonState(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetButtonState", $$robo$$android_view_MotionEvent$nativeGetButtonState(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetButtonState$nativeBinding(long var0, int var2);

    private static void nativeSetButtonState(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetButtonState", $$robo$$android_view_MotionEvent$nativeSetButtonState(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetActionButton$nativeBinding(long var0);

    private static int nativeGetActionButton(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetActionButton", $$robo$$android_view_MotionEvent$nativeGetActionButton(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetActionButton$nativeBinding(long var0, int var2);

    private static void nativeSetActionButton(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetActionButton", $$robo$$android_view_MotionEvent$nativeSetActionButton(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeOffsetLocation$nativeBinding(long var0, float var2, float var3);

    private static void nativeOffsetLocation(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nativeOffsetLocation", $$robo$$android_view_MotionEvent$nativeOffsetLocation(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ float $$robo$$nativeGetXOffset$nativeBinding(long var0);

    private static float nativeGetXOffset(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nativeGetXOffset", $$robo$$android_view_MotionEvent$nativeGetXOffset(long ), 1, (long)l);
    }

    private static final native /* synthetic */ float $$robo$$nativeGetYOffset$nativeBinding(long var0);

    private static float nativeGetYOffset(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nativeGetYOffset", $$robo$$android_view_MotionEvent$nativeGetYOffset(long ), 1, (long)l);
    }

    private static final native /* synthetic */ float $$robo$$nativeGetXPrecision$nativeBinding(long var0);

    private static float nativeGetXPrecision(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nativeGetXPrecision", $$robo$$android_view_MotionEvent$nativeGetXPrecision(long ), 1, (long)l);
    }

    private static final native /* synthetic */ float $$robo$$nativeGetYPrecision$nativeBinding(long var0);

    private static float nativeGetYPrecision(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nativeGetYPrecision", $$robo$$android_view_MotionEvent$nativeGetYPrecision(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nativeGetDownTimeNanos$nativeBinding(long var0);

    private static long nativeGetDownTimeNanos(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetDownTimeNanos", $$robo$$android_view_MotionEvent$nativeGetDownTimeNanos(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetDownTimeNanos$nativeBinding(long var0, long var2);

    private static void nativeSetDownTimeNanos(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetDownTimeNanos", $$robo$$android_view_MotionEvent$nativeSetDownTimeNanos(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetPointerCount$nativeBinding(long var0);

    private static int nativeGetPointerCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetPointerCount", $$robo$$android_view_MotionEvent$nativeGetPointerCount(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetPointerId$nativeBinding(long var0, int var2);

    private static int nativeGetPointerId(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetPointerId", $$robo$$android_view_MotionEvent$nativeGetPointerId(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetToolType$nativeBinding(long var0, int var2);

    private static int nativeGetToolType(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetToolType", $$robo$$android_view_MotionEvent$nativeGetToolType(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeFindPointerIndex$nativeBinding(long var0, int var2);

    private static int nativeFindPointerIndex(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeFindPointerIndex", $$robo$$android_view_MotionEvent$nativeFindPointerIndex(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetHistorySize$nativeBinding(long var0);

    private static int nativeGetHistorySize(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetHistorySize", $$robo$$android_view_MotionEvent$nativeGetHistorySize(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nativeGetEventTimeNanos$nativeBinding(long var0, int var2);

    private static long nativeGetEventTimeNanos(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetEventTimeNanos", $$robo$$android_view_MotionEvent$nativeGetEventTimeNanos(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ float $$robo$$nativeGetRawAxisValue$nativeBinding(long var0, int var2, int var3, int var4);

    private static float nativeGetRawAxisValue(long l, int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nativeGetRawAxisValue", $$robo$$android_view_MotionEvent$nativeGetRawAxisValue(long int int int ), 1, (long)l, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ float $$robo$$nativeGetAxisValue$nativeBinding(long var0, int var2, int var3, int var4);

    private static float nativeGetAxisValue(long l, int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("nativeGetAxisValue", $$robo$$android_view_MotionEvent$nativeGetAxisValue(long int int int ), 1, (long)l, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ void $$robo$$nativeGetPointerCoords$nativeBinding(long var0, int var2, int var3, PointerCoords var4);

    private static void nativeGetPointerCoords(long l, int n, int n2, PointerCoords pointerCoords) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetPointerCoords", $$robo$$android_view_MotionEvent$nativeGetPointerCoords(long int int android.view.MotionEvent$PointerCoords ), 1, (long)l, (int)n, (int)n2, (PointerCoords)pointerCoords);
    }

    private static final native /* synthetic */ void $$robo$$nativeGetPointerProperties$nativeBinding(long var0, int var2, PointerProperties var3);

    private static void nativeGetPointerProperties(long l, int n, PointerProperties pointerProperties) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetPointerProperties", $$robo$$android_view_MotionEvent$nativeGetPointerProperties(long int android.view.MotionEvent$PointerProperties ), 1, (long)l, (int)n, (PointerProperties)pointerProperties);
    }

    private static final native /* synthetic */ void $$robo$$nativeScale$nativeBinding(long var0, float var2);

    private static void nativeScale(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nativeScale", $$robo$$android_view_MotionEvent$nativeScale(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ void $$robo$$nativeTransform$nativeBinding(long var0, Matrix var2);

    private static void nativeTransform(long l, Matrix matrix) {
        InvokeDynamicSupport.bootstrapStatic("nativeTransform", $$robo$$android_view_MotionEvent$nativeTransform(long android.graphics.Matrix ), 1, (long)l, (Matrix)matrix);
    }

    private static final native /* synthetic */ long $$robo$$nativeReadFromParcel$nativeBinding(long var0, Parcel var2);

    private static long nativeReadFromParcel(long l, Parcel parcel) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeReadFromParcel", $$robo$$android_view_MotionEvent$nativeReadFromParcel(long android.os.Parcel ), 1, (long)l, (Parcel)parcel);
    }

    private static final native /* synthetic */ void $$robo$$nativeWriteToParcel$nativeBinding(long var0, Parcel var2);

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteToParcel", $$robo$$android_view_MotionEvent$nativeWriteToParcel(long android.os.Parcel ), 1, (long)l, (Parcel)parcel);
    }

    private static final native /* synthetic */ String $$robo$$nativeAxisToString$nativeBinding(int var0);

    private static String nativeAxisToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeAxisToString", $$robo$$android_view_MotionEvent$nativeAxisToString(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeAxisFromString$nativeBinding(String var0);

    private static int nativeAxisFromString(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeAxisFromString", $$robo$$android_view_MotionEvent$nativeAxisFromString(java.lang.String ), 1, (String)string2);
    }

    private void __constructor__() {
        this.$$robo$$android_view_MotionEvent$__constructor__();
    }

    private MotionEvent() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MotionEvent$__constructor__(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_MotionEvent$finalize(), 0, this);
    }

    private static MotionEvent obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_MotionEvent$obtain(), 0);
    }

    public static MotionEvent obtain(long l, long l2, int n, int n2, PointerProperties[] pointerPropertiesArray, PointerCoords[] pointerCoordsArray, int n3, int n4, float f, float f2, int n5, int n6, int n7, int n8) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_MotionEvent$obtain(long long int int android.view.MotionEvent$PointerProperties[] android.view.MotionEvent$PointerCoords[] int int float float int int int int ), 0, (long)l, (long)l2, (int)n, (int)n2, (PointerProperties[])pointerPropertiesArray, (PointerCoords[])pointerCoordsArray, (int)n3, (int)n4, (float)f, (float)f2, (int)n5, (int)n6, (int)n7, (int)n8);
    }

    @Deprecated
    public static MotionEvent obtain(long l, long l2, int n, int n2, int[] nArray, PointerCoords[] pointerCoordsArray, int n3, float f, float f2, int n4, int n5, int n6, int n7) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_MotionEvent$obtain(long long int int int[] android.view.MotionEvent$PointerCoords[] int float float int int int int ), 0, (long)l, (long)l2, (int)n, (int)n2, (int[])nArray, (PointerCoords[])pointerCoordsArray, (int)n3, (float)f, (float)f2, (int)n4, (int)n5, (int)n6, (int)n7);
    }

    public static MotionEvent obtain(long l, long l2, int n, float f, float f2, float f3, float f4, int n2, float f5, float f6, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_MotionEvent$obtain(long long int float float float float int float float int int ), 0, (long)l, (long)l2, (int)n, (float)f, (float)f2, (float)f3, (float)f4, (int)n2, (float)f5, (float)f6, (int)n3, (int)n4);
    }

    @Deprecated
    public static MotionEvent obtain(long l, long l2, int n, int n2, float f, float f2, float f3, float f4, int n3, float f5, float f6, int n4, int n5) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_MotionEvent$obtain(long long int int float float float float int float float int int ), 0, (long)l, (long)l2, (int)n, (int)n2, (float)f, (float)f2, (float)f3, (float)f4, (int)n3, (float)f5, (float)f6, (int)n4, (int)n5);
    }

    public static MotionEvent obtain(long l, long l2, int n, float f, float f2, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_MotionEvent$obtain(long long int float float int ), 0, (long)l, (long)l2, (int)n, (float)f, (float)f2, (int)n2);
    }

    public static MotionEvent obtain(MotionEvent motionEvent) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_MotionEvent$obtain(android.view.MotionEvent ), 0, (MotionEvent)motionEvent);
    }

    public static MotionEvent obtainNoHistory(MotionEvent motionEvent) {
        return InvokeDynamicSupport.bootstrapStatic("obtainNoHistory", $$robo$$android_view_MotionEvent$obtainNoHistory(android.view.MotionEvent ), 0, (MotionEvent)motionEvent);
    }

    @Override
    public MotionEvent copy() {
        return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_view_MotionEvent$copy(), 0, this);
    }

    @Override
    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_MotionEvent$recycle(), 0, this);
    }

    public void scale(float f) {
        InvokeDynamicSupport.bootstrap("scale", $$robo$$android_view_MotionEvent$scale(float ), 0, this, f);
    }

    @Override
    public int getDeviceId() {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$android_view_MotionEvent$getDeviceId(), 0, this);
    }

    @Override
    public int getSource() {
        return (int)InvokeDynamicSupport.bootstrap("getSource", $$robo$$android_view_MotionEvent$getSource(), 0, this);
    }

    @Override
    public void setSource(int n) {
        InvokeDynamicSupport.bootstrap("setSource", $$robo$$android_view_MotionEvent$setSource(int ), 0, this, n);
    }

    public int getAction() {
        return (int)InvokeDynamicSupport.bootstrap("getAction", $$robo$$android_view_MotionEvent$getAction(), 0, this);
    }

    public int getActionMasked() {
        return (int)InvokeDynamicSupport.bootstrap("getActionMasked", $$robo$$android_view_MotionEvent$getActionMasked(), 0, this);
    }

    public int getActionIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getActionIndex", $$robo$$android_view_MotionEvent$getActionIndex(), 0, this);
    }

    public boolean isTouchEvent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTouchEvent", $$robo$$android_view_MotionEvent$isTouchEvent(), 0, this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_view_MotionEvent$getFlags(), 0, this);
    }

    @Override
    public boolean isTainted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTainted", $$robo$$android_view_MotionEvent$isTainted(), 0, this);
    }

    @Override
    public void setTainted(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTainted", $$robo$$android_view_MotionEvent$setTainted(boolean ), 0, this, bl);
    }

    public boolean isTargetAccessibilityFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTargetAccessibilityFocus", $$robo$$android_view_MotionEvent$isTargetAccessibilityFocus(), 0, this);
    }

    public void setTargetAccessibilityFocus(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTargetAccessibilityFocus", $$robo$$android_view_MotionEvent$setTargetAccessibilityFocus(boolean ), 0, this, bl);
    }

    public long getDownTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDownTime", $$robo$$android_view_MotionEvent$getDownTime(), 0, this);
    }

    public void setDownTime(long l) {
        InvokeDynamicSupport.bootstrap("setDownTime", $$robo$$android_view_MotionEvent$setDownTime(long ), 0, this, l);
    }

    @Override
    public long getEventTime() {
        return (long)InvokeDynamicSupport.bootstrap("getEventTime", $$robo$$android_view_MotionEvent$getEventTime(), 0, this);
    }

    @Override
    public long getEventTimeNano() {
        return (long)InvokeDynamicSupport.bootstrap("getEventTimeNano", $$robo$$android_view_MotionEvent$getEventTimeNano(), 0, this);
    }

    public float getX() {
        return (float)InvokeDynamicSupport.bootstrap("getX", $$robo$$android_view_MotionEvent$getX(), 0, this);
    }

    public float getY() {
        return (float)InvokeDynamicSupport.bootstrap("getY", $$robo$$android_view_MotionEvent$getY(), 0, this);
    }

    public float getPressure() {
        return (float)InvokeDynamicSupport.bootstrap("getPressure", $$robo$$android_view_MotionEvent$getPressure(), 0, this);
    }

    public float getSize() {
        return (float)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_view_MotionEvent$getSize(), 0, this);
    }

    public float getTouchMajor() {
        return (float)InvokeDynamicSupport.bootstrap("getTouchMajor", $$robo$$android_view_MotionEvent$getTouchMajor(), 0, this);
    }

    public float getTouchMinor() {
        return (float)InvokeDynamicSupport.bootstrap("getTouchMinor", $$robo$$android_view_MotionEvent$getTouchMinor(), 0, this);
    }

    public float getToolMajor() {
        return (float)InvokeDynamicSupport.bootstrap("getToolMajor", $$robo$$android_view_MotionEvent$getToolMajor(), 0, this);
    }

    public float getToolMinor() {
        return (float)InvokeDynamicSupport.bootstrap("getToolMinor", $$robo$$android_view_MotionEvent$getToolMinor(), 0, this);
    }

    public float getOrientation() {
        return (float)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_view_MotionEvent$getOrientation(), 0, this);
    }

    public float getAxisValue(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getAxisValue", $$robo$$android_view_MotionEvent$getAxisValue(int ), 0, this, n);
    }

    public int getPointerCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPointerCount", $$robo$$android_view_MotionEvent$getPointerCount(), 0, this);
    }

    public int getPointerId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPointerId", $$robo$$android_view_MotionEvent$getPointerId(int ), 0, this, n);
    }

    public int getToolType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getToolType", $$robo$$android_view_MotionEvent$getToolType(int ), 0, this, n);
    }

    public int findPointerIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findPointerIndex", $$robo$$android_view_MotionEvent$findPointerIndex(int ), 0, this, n);
    }

    public float getX(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getX", $$robo$$android_view_MotionEvent$getX(int ), 0, this, n);
    }

    public float getY(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getY", $$robo$$android_view_MotionEvent$getY(int ), 0, this, n);
    }

    public float getPressure(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getPressure", $$robo$$android_view_MotionEvent$getPressure(int ), 0, this, n);
    }

    public float getSize(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_view_MotionEvent$getSize(int ), 0, this, n);
    }

    public float getTouchMajor(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getTouchMajor", $$robo$$android_view_MotionEvent$getTouchMajor(int ), 0, this, n);
    }

    public float getTouchMinor(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getTouchMinor", $$robo$$android_view_MotionEvent$getTouchMinor(int ), 0, this, n);
    }

    public float getToolMajor(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getToolMajor", $$robo$$android_view_MotionEvent$getToolMajor(int ), 0, this, n);
    }

    public float getToolMinor(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getToolMinor", $$robo$$android_view_MotionEvent$getToolMinor(int ), 0, this, n);
    }

    public float getOrientation(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_view_MotionEvent$getOrientation(int ), 0, this, n);
    }

    public float getAxisValue(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getAxisValue", $$robo$$android_view_MotionEvent$getAxisValue(int int ), 0, this, n, n2);
    }

    public void getPointerCoords(int n, PointerCoords pointerCoords) {
        InvokeDynamicSupport.bootstrap("getPointerCoords", $$robo$$android_view_MotionEvent$getPointerCoords(int android.view.MotionEvent$PointerCoords ), 0, this, n, pointerCoords);
    }

    public void getPointerProperties(int n, PointerProperties pointerProperties) {
        InvokeDynamicSupport.bootstrap("getPointerProperties", $$robo$$android_view_MotionEvent$getPointerProperties(int android.view.MotionEvent$PointerProperties ), 0, this, n, pointerProperties);
    }

    public int getMetaState() {
        return (int)InvokeDynamicSupport.bootstrap("getMetaState", $$robo$$android_view_MotionEvent$getMetaState(), 0, this);
    }

    public int getButtonState() {
        return (int)InvokeDynamicSupport.bootstrap("getButtonState", $$robo$$android_view_MotionEvent$getButtonState(), 0, this);
    }

    public void setButtonState(int n) {
        InvokeDynamicSupport.bootstrap("setButtonState", $$robo$$android_view_MotionEvent$setButtonState(int ), 0, this, n);
    }

    public int getActionButton() {
        return (int)InvokeDynamicSupport.bootstrap("getActionButton", $$robo$$android_view_MotionEvent$getActionButton(), 0, this);
    }

    public void setActionButton(int n) {
        InvokeDynamicSupport.bootstrap("setActionButton", $$robo$$android_view_MotionEvent$setActionButton(int ), 0, this, n);
    }

    public float getRawX() {
        return (float)InvokeDynamicSupport.bootstrap("getRawX", $$robo$$android_view_MotionEvent$getRawX(), 0, this);
    }

    public float getRawY() {
        return (float)InvokeDynamicSupport.bootstrap("getRawY", $$robo$$android_view_MotionEvent$getRawY(), 0, this);
    }

    public float getXPrecision() {
        return (float)InvokeDynamicSupport.bootstrap("getXPrecision", $$robo$$android_view_MotionEvent$getXPrecision(), 0, this);
    }

    public float getYPrecision() {
        return (float)InvokeDynamicSupport.bootstrap("getYPrecision", $$robo$$android_view_MotionEvent$getYPrecision(), 0, this);
    }

    public int getHistorySize() {
        return (int)InvokeDynamicSupport.bootstrap("getHistorySize", $$robo$$android_view_MotionEvent$getHistorySize(), 0, this);
    }

    public long getHistoricalEventTime(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getHistoricalEventTime", $$robo$$android_view_MotionEvent$getHistoricalEventTime(int ), 0, this, n);
    }

    public long getHistoricalEventTimeNano(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getHistoricalEventTimeNano", $$robo$$android_view_MotionEvent$getHistoricalEventTimeNano(int ), 0, this, n);
    }

    public float getHistoricalX(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalX", $$robo$$android_view_MotionEvent$getHistoricalX(int ), 0, this, n);
    }

    public float getHistoricalY(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalY", $$robo$$android_view_MotionEvent$getHistoricalY(int ), 0, this, n);
    }

    public float getHistoricalPressure(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalPressure", $$robo$$android_view_MotionEvent$getHistoricalPressure(int ), 0, this, n);
    }

    public float getHistoricalSize(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalSize", $$robo$$android_view_MotionEvent$getHistoricalSize(int ), 0, this, n);
    }

    public float getHistoricalTouchMajor(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalTouchMajor", $$robo$$android_view_MotionEvent$getHistoricalTouchMajor(int ), 0, this, n);
    }

    public float getHistoricalTouchMinor(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalTouchMinor", $$robo$$android_view_MotionEvent$getHistoricalTouchMinor(int ), 0, this, n);
    }

    public float getHistoricalToolMajor(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalToolMajor", $$robo$$android_view_MotionEvent$getHistoricalToolMajor(int ), 0, this, n);
    }

    public float getHistoricalToolMinor(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalToolMinor", $$robo$$android_view_MotionEvent$getHistoricalToolMinor(int ), 0, this, n);
    }

    public float getHistoricalOrientation(int n) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalOrientation", $$robo$$android_view_MotionEvent$getHistoricalOrientation(int ), 0, this, n);
    }

    public float getHistoricalAxisValue(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalAxisValue", $$robo$$android_view_MotionEvent$getHistoricalAxisValue(int int ), 0, this, n, n2);
    }

    public float getHistoricalX(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalX", $$robo$$android_view_MotionEvent$getHistoricalX(int int ), 0, this, n, n2);
    }

    public float getHistoricalY(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalY", $$robo$$android_view_MotionEvent$getHistoricalY(int int ), 0, this, n, n2);
    }

    public float getHistoricalPressure(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalPressure", $$robo$$android_view_MotionEvent$getHistoricalPressure(int int ), 0, this, n, n2);
    }

    public float getHistoricalSize(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalSize", $$robo$$android_view_MotionEvent$getHistoricalSize(int int ), 0, this, n, n2);
    }

    public float getHistoricalTouchMajor(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalTouchMajor", $$robo$$android_view_MotionEvent$getHistoricalTouchMajor(int int ), 0, this, n, n2);
    }

    public float getHistoricalTouchMinor(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalTouchMinor", $$robo$$android_view_MotionEvent$getHistoricalTouchMinor(int int ), 0, this, n, n2);
    }

    public float getHistoricalToolMajor(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalToolMajor", $$robo$$android_view_MotionEvent$getHistoricalToolMajor(int int ), 0, this, n, n2);
    }

    public float getHistoricalToolMinor(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalToolMinor", $$robo$$android_view_MotionEvent$getHistoricalToolMinor(int int ), 0, this, n, n2);
    }

    public float getHistoricalOrientation(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalOrientation", $$robo$$android_view_MotionEvent$getHistoricalOrientation(int int ), 0, this, n, n2);
    }

    public float getHistoricalAxisValue(int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("getHistoricalAxisValue", $$robo$$android_view_MotionEvent$getHistoricalAxisValue(int int int ), 0, this, n, n2, n3);
    }

    public void getHistoricalPointerCoords(int n, int n2, PointerCoords pointerCoords) {
        InvokeDynamicSupport.bootstrap("getHistoricalPointerCoords", $$robo$$android_view_MotionEvent$getHistoricalPointerCoords(int int android.view.MotionEvent$PointerCoords ), 0, this, n, n2, pointerCoords);
    }

    public int getEdgeFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getEdgeFlags", $$robo$$android_view_MotionEvent$getEdgeFlags(), 0, this);
    }

    public void setEdgeFlags(int n) {
        InvokeDynamicSupport.bootstrap("setEdgeFlags", $$robo$$android_view_MotionEvent$setEdgeFlags(int ), 0, this, n);
    }

    public void setAction(int n) {
        InvokeDynamicSupport.bootstrap("setAction", $$robo$$android_view_MotionEvent$setAction(int ), 0, this, n);
    }

    public void offsetLocation(float f, float f2) {
        InvokeDynamicSupport.bootstrap("offsetLocation", $$robo$$android_view_MotionEvent$offsetLocation(float float ), 0, this, f, f2);
    }

    public void setLocation(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setLocation", $$robo$$android_view_MotionEvent$setLocation(float float ), 0, this, f, f2);
    }

    public void transform(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("transform", $$robo$$android_view_MotionEvent$transform(android.graphics.Matrix ), 0, this, matrix);
    }

    public void addBatch(long l, float f, float f2, float f3, float f4, int n) {
        InvokeDynamicSupport.bootstrap("addBatch", $$robo$$android_view_MotionEvent$addBatch(long float float float float int ), 0, this, l, f, f2, f3, f4, n);
    }

    public void addBatch(long l, PointerCoords[] pointerCoordsArray, int n) {
        InvokeDynamicSupport.bootstrap("addBatch", $$robo$$android_view_MotionEvent$addBatch(long android.view.MotionEvent$PointerCoords[] int ), 0, this, l, pointerCoordsArray, n);
    }

    public boolean addBatch(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("addBatch", $$robo$$android_view_MotionEvent$addBatch(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public boolean isWithinBoundsNoHistory(float f, float f2, float f3, float f4) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWithinBoundsNoHistory", $$robo$$android_view_MotionEvent$isWithinBoundsNoHistory(float float float float ), 0, this, f, f2, f3, f4);
    }

    private static float clamp(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("clamp", $$robo$$android_view_MotionEvent$clamp(float float float ), 0, (float)f, (float)f2, (float)f3);
    }

    public MotionEvent clampNoHistory(float f, float f2, float f3, float f4) {
        return InvokeDynamicSupport.bootstrap("clampNoHistory", $$robo$$android_view_MotionEvent$clampNoHistory(float float float float ), 0, this, f, f2, f3, f4);
    }

    public int getPointerIdBits() {
        return (int)InvokeDynamicSupport.bootstrap("getPointerIdBits", $$robo$$android_view_MotionEvent$getPointerIdBits(), 0, this);
    }

    public MotionEvent split(int n) {
        return InvokeDynamicSupport.bootstrap("split", $$robo$$android_view_MotionEvent$split(int ), 0, this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_MotionEvent$toString(), 0, this);
    }

    public static String actionToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("actionToString", $$robo$$android_view_MotionEvent$actionToString(int ), 0, (int)n);
    }

    public static String axisToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("axisToString", $$robo$$android_view_MotionEvent$axisToString(int ), 0, (int)n);
    }

    public static int axisFromString(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("axisFromString", $$robo$$android_view_MotionEvent$axisFromString(java.lang.String ), 0, (String)string2);
    }

    public static String buttonStateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("buttonStateToString", $$robo$$android_view_MotionEvent$buttonStateToString(int ), 0, (int)n);
    }

    public static String toolTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toolTypeToString", $$robo$$android_view_MotionEvent$toolTypeToString(int ), 0, (int)n);
    }

    public boolean isButtonPressed(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isButtonPressed", $$robo$$android_view_MotionEvent$isButtonPressed(int ), 0, this, n);
    }

    public static MotionEvent createFromParcelBody(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("createFromParcelBody", $$robo$$android_view_MotionEvent$createFromParcelBody(android.os.Parcel ), 0, (Parcel)parcel);
    }

    @Override
    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_view_MotionEvent$cancel(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_MotionEvent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(MotionEvent.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MotionEvent)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PointerProperties
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int id;
        public int toolType;

        private void $$robo$$android_view_MotionEvent_PointerProperties$__constructor__() {
            this.clear();
        }

        private void $$robo$$android_view_MotionEvent_PointerProperties$__constructor__(PointerProperties other) {
            this.copyFrom(other);
        }

        private static final PointerProperties[] $$robo$$android_view_MotionEvent_PointerProperties$createArray(int size) {
            PointerProperties[] array2 = new PointerProperties[size];
            for (int i = 0; i < size; ++i) {
                array2[i] = new PointerProperties();
            }
            return array2;
        }

        private final void $$robo$$android_view_MotionEvent_PointerProperties$clear() {
            this.id = -1;
            this.toolType = 0;
        }

        private final void $$robo$$android_view_MotionEvent_PointerProperties$copyFrom(PointerProperties other) {
            this.id = other.id;
            this.toolType = other.toolType;
        }

        private final boolean $$robo$$android_view_MotionEvent_PointerProperties$equals(Object other) {
            if (other instanceof PointerProperties) {
                return this.equals((PointerProperties)other);
            }
            return false;
        }

        private final boolean $$robo$$android_view_MotionEvent_PointerProperties$equals(PointerProperties other) {
            return other != null && this.id == other.id && this.toolType == other.toolType;
        }

        private final int $$robo$$android_view_MotionEvent_PointerProperties$hashCode() {
            return this.id | this.toolType << 8;
        }

        private void __constructor__() {
            this.$$robo$$android_view_MotionEvent_PointerProperties$__constructor__();
        }

        public PointerProperties() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MotionEvent_PointerProperties$__constructor__(), 0, this);
        }

        private void __constructor__(PointerProperties pointerProperties) {
            this.$$robo$$android_view_MotionEvent_PointerProperties$__constructor__(pointerProperties);
        }

        public PointerProperties(PointerProperties pointerProperties) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MotionEvent_PointerProperties$__constructor__(android.view.MotionEvent$PointerProperties ), 0, this, pointerProperties);
        }

        public static PointerProperties[] createArray(int n) {
            return InvokeDynamicSupport.bootstrapStatic("createArray", $$robo$$android_view_MotionEvent_PointerProperties$createArray(int ), 0, (int)n);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_MotionEvent_PointerProperties$clear(), 0, this);
        }

        public void copyFrom(PointerProperties pointerProperties) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_view_MotionEvent_PointerProperties$copyFrom(android.view.MotionEvent$PointerProperties ), 0, this, pointerProperties);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_MotionEvent_PointerProperties$equals(java.lang.Object ), 0, this, object);
        }

        private boolean equals(PointerProperties pointerProperties) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_MotionEvent_PointerProperties$equals(android.view.MotionEvent$PointerProperties ), 0, this, pointerProperties);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_MotionEvent_PointerProperties$hashCode(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointerProperties)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PointerCoords
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int INITIAL_PACKED_AXIS_VALUES = 8;
        private long mPackedAxisBits;
        private float[] mPackedAxisValues;
        public float x;
        public float y;
        public float pressure;
        public float size;
        public float touchMajor;
        public float touchMinor;
        public float toolMajor;
        public float toolMinor;
        public float orientation;

        private void $$robo$$android_view_MotionEvent_PointerCoords$__constructor__() {
        }

        private void $$robo$$android_view_MotionEvent_PointerCoords$__constructor__(PointerCoords other) {
            this.copyFrom(other);
        }

        private static final PointerCoords[] $$robo$$android_view_MotionEvent_PointerCoords$createArray(int size) {
            PointerCoords[] array2 = new PointerCoords[size];
            for (int i = 0; i < size; ++i) {
                array2[i] = new PointerCoords();
            }
            return array2;
        }

        private final void $$robo$$android_view_MotionEvent_PointerCoords$clear() {
            this.mPackedAxisBits = 0L;
            this.x = 0.0f;
            this.y = 0.0f;
            this.pressure = 0.0f;
            this.size = 0.0f;
            this.touchMajor = 0.0f;
            this.touchMinor = 0.0f;
            this.toolMajor = 0.0f;
            this.toolMinor = 0.0f;
            this.orientation = 0.0f;
        }

        private final void $$robo$$android_view_MotionEvent_PointerCoords$copyFrom(PointerCoords other) {
            long bits;
            this.mPackedAxisBits = bits = other.mPackedAxisBits;
            if (bits != 0L) {
                float[] otherValues = other.mPackedAxisValues;
                int count = Long.bitCount(bits);
                float[] values = this.mPackedAxisValues;
                if (values == null || count > values.length) {
                    this.mPackedAxisValues = values = new float[otherValues.length];
                }
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])otherValues, (int)0, (float[])values, (int)0, (int)count);
            }
            this.x = other.x;
            this.y = other.y;
            this.pressure = other.pressure;
            this.size = other.size;
            this.touchMajor = other.touchMajor;
            this.touchMinor = other.touchMinor;
            this.toolMajor = other.toolMajor;
            this.toolMinor = other.toolMinor;
            this.orientation = other.orientation;
        }

        private final float $$robo$$android_view_MotionEvent_PointerCoords$getAxisValue(int axis) {
            switch (axis) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
                case 2: {
                    return this.pressure;
                }
                case 3: {
                    return this.size;
                }
                case 4: {
                    return this.touchMajor;
                }
                case 5: {
                    return this.touchMinor;
                }
                case 6: {
                    return this.toolMajor;
                }
                case 7: {
                    return this.toolMinor;
                }
                case 8: {
                    return this.orientation;
                }
            }
            if (axis < 0 || axis > 63) {
                throw new IllegalArgumentException("Axis out of range.");
            }
            long bits = this.mPackedAxisBits;
            long axisBit = Long.MIN_VALUE >>> axis;
            if ((bits & axisBit) == 0L) {
                return 0.0f;
            }
            int index = Long.bitCount(bits & (-1L >>> axis ^ 0xFFFFFFFFFFFFFFFFL));
            return this.mPackedAxisValues[index];
        }

        private final void $$robo$$android_view_MotionEvent_PointerCoords$setAxisValue(int axis, float value) {
            switch (axis) {
                case 0: {
                    this.x = value;
                    break;
                }
                case 1: {
                    this.y = value;
                    break;
                }
                case 2: {
                    this.pressure = value;
                    break;
                }
                case 3: {
                    this.size = value;
                    break;
                }
                case 4: {
                    this.touchMajor = value;
                    break;
                }
                case 5: {
                    this.touchMinor = value;
                    break;
                }
                case 6: {
                    this.toolMajor = value;
                    break;
                }
                case 7: {
                    this.toolMinor = value;
                    break;
                }
                case 8: {
                    this.orientation = value;
                    break;
                }
                default: {
                    if (axis < 0 || axis > 63) {
                        throw new IllegalArgumentException("Axis out of range.");
                    }
                    long bits = this.mPackedAxisBits;
                    long axisBit = Long.MIN_VALUE >>> axis;
                    int index = Long.bitCount(bits & (-1L >>> axis ^ 0xFFFFFFFFFFFFFFFFL));
                    float[] values = this.mPackedAxisValues;
                    if ((bits & axisBit) == 0L) {
                        if (values == null) {
                            this.mPackedAxisValues = values = new float[8];
                        } else {
                            int count = Long.bitCount(bits);
                            if (count < values.length) {
                                if (index != count) {
                                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])values, (int)index, (float[])values, (int)(index + 1), (int)(count - index));
                                }
                            } else {
                                float[] newValues = new float[count * 2];
                                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])values, (int)0, (float[])newValues, (int)0, (int)index);
                                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])values, (int)index, (float[])newValues, (int)(index + 1), (int)(count - index));
                                this.mPackedAxisValues = values = newValues;
                            }
                        }
                        this.mPackedAxisBits = bits | axisBit;
                    }
                    values[index] = value;
                }
            }
        }

        private void __constructor__() {
            this.$$robo$$android_view_MotionEvent_PointerCoords$__constructor__();
        }

        public PointerCoords() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MotionEvent_PointerCoords$__constructor__(), 0, this);
        }

        private void __constructor__(PointerCoords pointerCoords) {
            this.$$robo$$android_view_MotionEvent_PointerCoords$__constructor__(pointerCoords);
        }

        public PointerCoords(PointerCoords pointerCoords) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_MotionEvent_PointerCoords$__constructor__(android.view.MotionEvent$PointerCoords ), 0, this, pointerCoords);
        }

        public static PointerCoords[] createArray(int n) {
            return InvokeDynamicSupport.bootstrapStatic("createArray", $$robo$$android_view_MotionEvent_PointerCoords$createArray(int ), 0, (int)n);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_MotionEvent_PointerCoords$clear(), 0, this);
        }

        public void copyFrom(PointerCoords pointerCoords) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_view_MotionEvent_PointerCoords$copyFrom(android.view.MotionEvent$PointerCoords ), 0, this, pointerCoords);
        }

        public float getAxisValue(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getAxisValue", $$robo$$android_view_MotionEvent_PointerCoords$getAxisValue(int ), 0, this, n);
        }

        public void setAxisValue(int n, float f) {
            InvokeDynamicSupport.bootstrap("setAxisValue", $$robo$$android_view_MotionEvent_PointerCoords$setAxisValue(int float ), 0, this, n, f);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointerCoords)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

