/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewOverlay;
import android.view.ViewParent;
import android.widget.FrameLayout;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GhostView
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private View mView;
    private int mReferences;
    private boolean mBeingMoved;

    private void $$robo$$android_view_GhostView$__constructor__(View view) {
        this.mView = view;
        this.mView.mGhostView = this;
        ViewGroup parent = (ViewGroup)this.mView.getParent();
        this.mView.setTransitionVisibility(4);
        parent.invalidate();
    }

    private final void $$robo$$android_view_GhostView$onDraw(Canvas canvas) {
        if (canvas instanceof DisplayListCanvas) {
            DisplayListCanvas dlCanvas = (DisplayListCanvas)canvas;
            this.mView.mRecreateDisplayList = true;
            RenderNode renderNode = this.mView.updateDisplayListIfDirty();
            if (renderNode.isValid()) {
                dlCanvas.insertReorderBarrier();
                dlCanvas.drawRenderNode(renderNode);
                dlCanvas.insertInorderBarrier();
            }
        }
    }

    private final void $$robo$$android_view_GhostView$setMatrix(Matrix matrix) {
        this.mRenderNode.setAnimationMatrix(matrix);
    }

    private final void $$robo$$android_view_GhostView$setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mView.mGhostView == this) {
            int inverseVisibility = visibility == 0 ? 4 : 0;
            this.mView.setTransitionVisibility(inverseVisibility);
        }
    }

    private final void $$robo$$android_view_GhostView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mBeingMoved) {
            this.mView.setTransitionVisibility(0);
            this.mView.mGhostView = null;
            ViewGroup parent = (ViewGroup)this.mView.getParent();
            if (parent != null) {
                parent.invalidate();
            }
        }
    }

    private static final void $$robo$$android_view_GhostView$calculateMatrix(View view, ViewGroup host, Matrix matrix) {
        ViewGroup parent = (ViewGroup)view.getParent();
        matrix.reset();
        parent.transformMatrixToGlobal(matrix);
        matrix.preTranslate(-parent.getScrollX(), -parent.getScrollY());
        host.transformMatrixToLocal(matrix);
    }

    private static final GhostView $$robo$$android_view_GhostView$addGhost(View view, ViewGroup viewGroup, Matrix matrix) {
        View oldParent;
        ViewGroup oldGrandParent;
        if (!(view.getParent() instanceof ViewGroup)) {
            throw new IllegalArgumentException("Ghosted views must be parented by a ViewGroup");
        }
        ViewOverlay overlay = viewGroup.getOverlay();
        ViewOverlay.OverlayViewGroup overlayViewGroup = ((ViewGroupOverlay)overlay).mOverlayViewGroup;
        GhostView ghostView = view.mGhostView;
        int previousRefCount = 0;
        if (ghostView != null && (oldGrandParent = (ViewGroup)(oldParent = (View)((Object)ghostView.getParent())).getParent()) != overlayViewGroup) {
            previousRefCount = ghostView.mReferences;
            oldGrandParent.removeView(oldParent);
            ghostView = null;
        }
        if (ghostView == null) {
            if (matrix == null) {
                matrix = new Matrix();
                GhostView.calculateMatrix(view, viewGroup, matrix);
            }
            ghostView = new GhostView(view);
            ghostView.setMatrix(matrix);
            FrameLayout parent = new FrameLayout(view.getContext());
            parent.setClipChildren(false);
            GhostView.copySize(viewGroup, parent);
            GhostView.copySize(viewGroup, ghostView);
            parent.addView(ghostView);
            ArrayList<View> tempViews = new ArrayList<View>();
            int firstGhost = GhostView.moveGhostViewsToTop(((ViewGroupOverlay)overlay).mOverlayViewGroup, tempViews);
            GhostView.insertIntoOverlay(((ViewGroupOverlay)overlay).mOverlayViewGroup, parent, ghostView, tempViews, firstGhost);
            ghostView.mReferences = previousRefCount;
        } else if (matrix != null) {
            ghostView.setMatrix(matrix);
        }
        ++ghostView.mReferences;
        return ghostView;
    }

    private static final GhostView $$robo$$android_view_GhostView$addGhost(View view, ViewGroup viewGroup) {
        return GhostView.addGhost(view, viewGroup, null);
    }

    private static final void $$robo$$android_view_GhostView$removeGhost(View view) {
        GhostView ghostView = view.mGhostView;
        if (ghostView != null) {
            --ghostView.mReferences;
            if (ghostView.mReferences == 0) {
                ViewGroup parent = (ViewGroup)ghostView.getParent();
                ViewGroup grandParent = (ViewGroup)parent.getParent();
                grandParent.removeView(parent);
            }
        }
    }

    private static final GhostView $$robo$$android_view_GhostView$getGhost(View view) {
        return view.mGhostView;
    }

    private static final void $$robo$$android_view_GhostView$copySize(View from, View to) {
        to.setLeft(0);
        to.setTop(0);
        to.setRight(from.getWidth());
        to.setBottom(from.getHeight());
    }

    private static final int $$robo$$android_view_GhostView$moveGhostViewsToTop(ViewGroup viewGroup, ArrayList<View> tempViews) {
        int firstGhost;
        int numChildren = viewGroup.getChildCount();
        if (numChildren == 0) {
            return -1;
        }
        if (GhostView.isGhostWrapper(viewGroup.getChildAt(numChildren - 1))) {
            int firstGhost2 = numChildren - 1;
            int i = numChildren - 2;
            while (i >= 0 && GhostView.isGhostWrapper(viewGroup.getChildAt(i))) {
                firstGhost2 = i--;
            }
            return firstGhost2;
        }
        for (int i = numChildren - 2; i >= 0; --i) {
            View child = viewGroup.getChildAt(i);
            if (!GhostView.isGhostWrapper(child)) continue;
            tempViews.add(child);
            GhostView ghostView = (GhostView)((ViewGroup)child).getChildAt(0);
            ghostView.mBeingMoved = true;
            viewGroup.removeViewAt(i);
            ghostView.mBeingMoved = false;
        }
        if (tempViews.isEmpty()) {
            firstGhost = -1;
        } else {
            firstGhost = viewGroup.getChildCount();
            for (int i = tempViews.size() - 1; i >= 0; --i) {
                viewGroup.addView(tempViews.get(i));
            }
            tempViews.clear();
        }
        return firstGhost;
    }

    private static final void $$robo$$android_view_GhostView$insertIntoOverlay(ViewGroup viewGroup, ViewGroup wrapper, GhostView ghostView, ArrayList<View> tempParents, int firstGhost) {
        if (firstGhost == -1) {
            viewGroup.addView(wrapper);
        } else {
            ArrayList<View> viewParents = new ArrayList<View>();
            GhostView.getParents(ghostView.mView, viewParents);
            int index = GhostView.getInsertIndex(viewGroup, viewParents, tempParents, firstGhost);
            if (index < 0 || index >= viewGroup.getChildCount()) {
                viewGroup.addView(wrapper);
            } else {
                viewGroup.addView((View)wrapper, index);
            }
        }
    }

    private static final int $$robo$$android_view_GhostView$getInsertIndex(ViewGroup overlayViewGroup, ArrayList<View> viewParents, ArrayList<View> tempParents, int firstGhost) {
        int low = firstGhost;
        int high = overlayViewGroup.getChildCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            ViewGroup wrapper = (ViewGroup)overlayViewGroup.getChildAt(mid);
            GhostView midView = (GhostView)wrapper.getChildAt(0);
            GhostView.getParents(midView.mView, tempParents);
            if (GhostView.isOnTop(viewParents, tempParents)) {
                low = mid + 1;
            } else {
                high = mid - 1;
            }
            tempParents.clear();
        }
        return low;
    }

    private static final boolean $$robo$$android_view_GhostView$isGhostWrapper(View view) {
        FrameLayout frameLayout;
        if (view instanceof FrameLayout && (frameLayout = (FrameLayout)view).getChildCount() == 1) {
            View child = frameLayout.getChildAt(0);
            return child instanceof GhostView;
        }
        return false;
    }

    private static final boolean $$robo$$android_view_GhostView$isOnTop(ArrayList<View> viewParents, ArrayList<View> comparedWith) {
        if (viewParents.isEmpty() || comparedWith.isEmpty() || viewParents.get(0) != comparedWith.get(0)) {
            return true;
        }
        int depth = Math.min(viewParents.size(), comparedWith.size());
        for (int i = 1; i < depth; ++i) {
            View comparedWithParent;
            View viewParent = viewParents.get(i);
            if (viewParent == (comparedWithParent = comparedWith.get(i))) continue;
            return GhostView.isOnTop(viewParent, comparedWithParent);
        }
        boolean isComparedWithTheParent = comparedWith.size() == depth;
        return isComparedWithTheParent;
    }

    private static final void $$robo$$android_view_GhostView$getParents(View view, ArrayList<View> parents) {
        ViewParent parent = view.getParent();
        if (parent != null && parent instanceof ViewGroup) {
            GhostView.getParents((View)((Object)parent), parents);
        }
        parents.add(view);
    }

    private static final boolean $$robo$$android_view_GhostView$isOnTop(View view, View comparedWith) {
        ViewGroup parent = (ViewGroup)view.getParent();
        int childrenCount = parent.getChildCount();
        ArrayList<View> preorderedList = parent.buildOrderedChildList();
        boolean customOrder = preorderedList == null && parent.isChildrenDrawingOrderEnabled();
        boolean isOnTop = true;
        for (int i = 0; i < childrenCount; ++i) {
            View child;
            int childIndex = customOrder ? parent.getChildDrawingOrder(childrenCount, i) : i;
            View view2 = child = preorderedList == null ? parent.getChildAt(childIndex) : preorderedList.get(childIndex);
            if (child == view) {
                isOnTop = false;
                break;
            }
            if (child != comparedWith) continue;
            isOnTop = true;
            break;
        }
        if (preorderedList != null) {
            preorderedList.clear();
        }
        return isOnTop;
    }

    private void __constructor__(View view) {
        this.$$robo$$android_view_GhostView$__constructor__(view);
    }

    private GhostView(View view) {
        super(view.getContext());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_GhostView$__constructor__(android.view.View ), 0, this, view);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_view_GhostView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setMatrix(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("setMatrix", $$robo$$android_view_GhostView$setMatrix(android.graphics.Matrix ), 0, this, matrix);
    }

    @Override
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_view_GhostView$setVisibility(int ), 0, this, n);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_view_GhostView$onDetachedFromWindow(), 0, this);
    }

    public static void calculateMatrix(View view, ViewGroup viewGroup, Matrix matrix) {
        InvokeDynamicSupport.bootstrapStatic("calculateMatrix", $$robo$$android_view_GhostView$calculateMatrix(android.view.View android.view.ViewGroup android.graphics.Matrix ), 0, (View)view, (ViewGroup)viewGroup, (Matrix)matrix);
    }

    public static GhostView addGhost(View view, ViewGroup viewGroup, Matrix matrix) {
        return InvokeDynamicSupport.bootstrapStatic("addGhost", $$robo$$android_view_GhostView$addGhost(android.view.View android.view.ViewGroup android.graphics.Matrix ), 0, (View)view, (ViewGroup)viewGroup, (Matrix)matrix);
    }

    public static GhostView addGhost(View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrapStatic("addGhost", $$robo$$android_view_GhostView$addGhost(android.view.View android.view.ViewGroup ), 0, (View)view, (ViewGroup)viewGroup);
    }

    public static void removeGhost(View view) {
        InvokeDynamicSupport.bootstrapStatic("removeGhost", $$robo$$android_view_GhostView$removeGhost(android.view.View ), 0, (View)view);
    }

    public static GhostView getGhost(View view) {
        return InvokeDynamicSupport.bootstrapStatic("getGhost", $$robo$$android_view_GhostView$getGhost(android.view.View ), 0, (View)view);
    }

    private static void copySize(View view, View view2) {
        InvokeDynamicSupport.bootstrapStatic("copySize", $$robo$$android_view_GhostView$copySize(android.view.View android.view.View ), 0, (View)view, (View)view2);
    }

    private static int moveGhostViewsToTop(ViewGroup viewGroup, ArrayList<View> arrayList) {
        return (int)InvokeDynamicSupport.bootstrapStatic("moveGhostViewsToTop", $$robo$$android_view_GhostView$moveGhostViewsToTop(android.view.ViewGroup java.util.ArrayList<android.view.View> ), 0, (ViewGroup)viewGroup, arrayList);
    }

    private static void insertIntoOverlay(ViewGroup viewGroup, ViewGroup viewGroup2, GhostView ghostView, ArrayList<View> arrayList, int n) {
        InvokeDynamicSupport.bootstrapStatic("insertIntoOverlay", $$robo$$android_view_GhostView$insertIntoOverlay(android.view.ViewGroup android.view.ViewGroup android.view.GhostView java.util.ArrayList<android.view.View> int ), 0, (ViewGroup)viewGroup, (ViewGroup)viewGroup2, (GhostView)ghostView, arrayList, (int)n);
    }

    private static int getInsertIndex(ViewGroup viewGroup, ArrayList<View> arrayList, ArrayList<View> arrayList2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getInsertIndex", $$robo$$android_view_GhostView$getInsertIndex(android.view.ViewGroup java.util.ArrayList<android.view.View> java.util.ArrayList<android.view.View> int ), 0, (ViewGroup)viewGroup, arrayList, arrayList2, (int)n);
    }

    private static boolean isGhostWrapper(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGhostWrapper", $$robo$$android_view_GhostView$isGhostWrapper(android.view.View ), 0, (View)view);
    }

    private static boolean isOnTop(ArrayList<View> arrayList, ArrayList<View> arrayList2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOnTop", $$robo$$android_view_GhostView$isOnTop(java.util.ArrayList<android.view.View> java.util.ArrayList<android.view.View> ), 0, arrayList, arrayList2);
    }

    private static void getParents(View view, ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("getParents", $$robo$$android_view_GhostView$getParents(android.view.View java.util.ArrayList<android.view.View> ), 0, (View)view, arrayList);
    }

    private static boolean isOnTop(View view, View view2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOnTop", $$robo$$android_view_GhostView$isOnTop(android.view.View android.view.View ), 0, (View)view, (View)view2);
    }

    public /* synthetic */ GhostView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GhostView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

