/*
 * Decompiled with CFR 0.152.
 */
package android.util.jar;

import android.util.jar.StrictJarManifest;
import android.util.jar.StrictJarVerifier;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import libcore.io.IoUtils;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class StrictJarFile
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private long nativeHandle;
    private RandomAccessFile raf;
    private StrictJarManifest manifest;
    private StrictJarVerifier verifier;
    private boolean isSigned;
    private CloseGuard guard;
    private boolean closed;

    private void $$robo$$android_util_jar_StrictJarFile$__constructor__(String fileName) throws IOException, SecurityException {
    }

    private void $$robo$$android_util_jar_StrictJarFile$__constructor__(String fileName, boolean verify, boolean signatureSchemeRollbackProtectionsEnforced) throws IOException, SecurityException {
        this.guard = CloseGuard.get();
        this.nativeHandle = StrictJarFile.nativeOpenJarFile(fileName);
        this.raf = new RandomAccessFile(fileName, "r");
        try {
            if (verify) {
                HashMap<String, byte[]> metaEntries = this.getMetaEntries();
                this.manifest = new StrictJarManifest(metaEntries.get("META-INF/MANIFEST.MF"), true);
                this.verifier = new StrictJarVerifier(fileName, this.manifest, metaEntries, signatureSchemeRollbackProtectionsEnforced);
                Set<String> files = this.manifest.getEntries().keySet();
                for (String file : files) {
                    if (this.findEntry(file) != null) continue;
                    throw new SecurityException(fileName + ": File " + file + " in manifest does not exist");
                }
                this.isSigned = this.verifier.readCertificates() && this.verifier.isSignedJar();
            } else {
                this.isSigned = false;
                this.manifest = null;
                this.verifier = null;
            }
        }
        catch (IOException | SecurityException e) {
            StrictJarFile.nativeClose(this.nativeHandle);
            IoUtils.closeQuietly(this.raf);
            throw e;
        }
        this.guard.open("close");
    }

    private final StrictJarManifest $$robo$$android_util_jar_StrictJarFile$getManifest() {
        return this.manifest;
    }

    private final Iterator<ZipEntry> $$robo$$android_util_jar_StrictJarFile$iterator() throws IOException {
        return new EntryIterator(this.nativeHandle, "");
    }

    private final ZipEntry $$robo$$android_util_jar_StrictJarFile$findEntry(String name) {
        return StrictJarFile.nativeFindEntry(this.nativeHandle, name);
    }

    private final Certificate[][] $$robo$$android_util_jar_StrictJarFile$getCertificateChains(ZipEntry ze) {
        if (this.isSigned) {
            return this.verifier.getCertificateChains(ze.getName());
        }
        return null;
    }

    @Deprecated
    private final Certificate[] $$robo$$android_util_jar_StrictJarFile$getCertificates(ZipEntry ze) {
        if (this.isSigned) {
            Certificate[][] certChains = this.verifier.getCertificateChains(ze.getName());
            int count = 0;
            for (Certificate[] chain : certChains) {
                count += chain.length;
            }
            Certificate[] certs = new Certificate[count];
            int i = 0;
            for (Certificate[] chain : certChains) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)chain, (int)0, (Object)certs, (int)i, (int)chain.length);
                i += chain.length;
            }
            return certs;
        }
        return null;
    }

    private final InputStream $$robo$$android_util_jar_StrictJarFile$getInputStream(ZipEntry ze) {
        InputStream is = this.getZipInputStream(ze);
        if (this.isSigned) {
            StrictJarVerifier.VerifierEntry entry = this.verifier.initEntry(ze.getName());
            if (entry == null) {
                return is;
            }
            return new JarFileInputStream(is, ze.getSize(), entry);
        }
        return is;
    }

    private final void $$robo$$android_util_jar_StrictJarFile$close() throws IOException {
        if (!this.closed) {
            this.guard.close();
            StrictJarFile.nativeClose(this.nativeHandle);
            IoUtils.closeQuietly(this.raf);
            this.closed = true;
        }
    }

    private final InputStream $$robo$$android_util_jar_StrictJarFile$getZipInputStream(ZipEntry ze) {
        if (ze.getMethod() == 0) {
            return new RAFStream(this.raf, ze.getDataOffset(), ze.getDataOffset() + ze.getSize());
        }
        RAFStream wrapped = new RAFStream(this.raf, ze.getDataOffset(), ze.getDataOffset() + ze.getCompressedSize());
        int bufSize = Math.max(1024, (int)Math.min(ze.getSize(), 65535L));
        return new ZipInflaterInputStream(wrapped, new Inflater(true), bufSize, ze);
    }

    private final HashMap<String, byte[]> $$robo$$android_util_jar_StrictJarFile$getMetaEntries() throws IOException {
        HashMap<String, byte[]> metaEntries = new HashMap<String, byte[]>();
        EntryIterator entryIterator = new EntryIterator(this.nativeHandle, "META-INF/");
        while (entryIterator.hasNext()) {
            ZipEntry entry = (ZipEntry)entryIterator.next();
            metaEntries.put(entry.getName(), Streams.readFully(this.getInputStream(entry)));
        }
        return metaEntries;
    }

    private static final long $$robo$$android_util_jar_StrictJarFile$nativeOpenJarFile(String string2) throws IOException {
        return 0L;
    }

    private static final long $$robo$$android_util_jar_StrictJarFile$nativeStartIteration(long l, String string2) {
        return 0L;
    }

    private static final ZipEntry $$robo$$android_util_jar_StrictJarFile$nativeNextEntry(long l) {
        return null;
    }

    private static final ZipEntry $$robo$$android_util_jar_StrictJarFile$nativeFindEntry(long l, String string2) {
        return null;
    }

    private static final void $$robo$$android_util_jar_StrictJarFile$nativeClose(long l) {
    }

    private void __constructor__(String string2) throws IOException, SecurityException {
        this.$$robo$$android_util_jar_StrictJarFile$__constructor__(string2);
    }

    public StrictJarFile(String string2) throws IOException, SecurityException {
        this(string2, true, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarFile$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(String string2, boolean bl, boolean bl2) throws IOException, SecurityException {
        this.$$robo$$android_util_jar_StrictJarFile$__constructor__(string2, bl, bl2);
    }

    public StrictJarFile(String string2, boolean bl, boolean bl2) throws IOException, SecurityException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarFile$__constructor__(java.lang.String boolean boolean ), 0, this, string2, bl, bl2);
    }

    public StrictJarManifest getManifest() {
        return InvokeDynamicSupport.bootstrap("getManifest", $$robo$$android_util_jar_StrictJarFile$getManifest(), 0, this);
    }

    public Iterator<ZipEntry> iterator() throws IOException {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_util_jar_StrictJarFile$iterator(), 0, this);
    }

    public ZipEntry findEntry(String string2) {
        return InvokeDynamicSupport.bootstrap("findEntry", $$robo$$android_util_jar_StrictJarFile$findEntry(java.lang.String ), 0, this, string2);
    }

    public Certificate[][] getCertificateChains(ZipEntry zipEntry) {
        return InvokeDynamicSupport.bootstrap("getCertificateChains", $$robo$$android_util_jar_StrictJarFile$getCertificateChains(java.util.zip.ZipEntry ), 0, this, zipEntry);
    }

    @Deprecated
    public Certificate[] getCertificates(ZipEntry zipEntry) {
        return InvokeDynamicSupport.bootstrap("getCertificates", $$robo$$android_util_jar_StrictJarFile$getCertificates(java.util.zip.ZipEntry ), 0, this, zipEntry);
    }

    public InputStream getInputStream(ZipEntry zipEntry) {
        return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$android_util_jar_StrictJarFile$getInputStream(java.util.zip.ZipEntry ), 0, this, zipEntry);
    }

    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_util_jar_StrictJarFile$close(), 0, this);
    }

    private InputStream getZipInputStream(ZipEntry zipEntry) {
        return InvokeDynamicSupport.bootstrap("getZipInputStream", $$robo$$android_util_jar_StrictJarFile$getZipInputStream(java.util.zip.ZipEntry ), 0, this, zipEntry);
    }

    private HashMap<String, byte[]> getMetaEntries() throws IOException {
        return InvokeDynamicSupport.bootstrap("getMetaEntries", $$robo$$android_util_jar_StrictJarFile$getMetaEntries(), 0, this);
    }

    private static final native /* synthetic */ long $$robo$$nativeOpenJarFile$nativeBinding(String var0) throws IOException;

    private static long nativeOpenJarFile(String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpenJarFile", $$robo$$android_util_jar_StrictJarFile$nativeOpenJarFile(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ long $$robo$$nativeStartIteration$nativeBinding(long var0, String var2);

    private static long nativeStartIteration(long l, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeStartIteration", $$robo$$android_util_jar_StrictJarFile$nativeStartIteration(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ ZipEntry $$robo$$nativeNextEntry$nativeBinding(long var0);

    private static ZipEntry nativeNextEntry(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeNextEntry", $$robo$$android_util_jar_StrictJarFile$nativeNextEntry(long ), 1, (long)l);
    }

    private static final native /* synthetic */ ZipEntry $$robo$$nativeFindEntry$nativeBinding(long var0, String var2);

    private static ZipEntry nativeFindEntry(long l, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("nativeFindEntry", $$robo$$android_util_jar_StrictJarFile$nativeFindEntry(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$nativeClose$nativeBinding(long var0);

    private static void nativeClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClose", $$robo$$android_util_jar_StrictJarFile$nativeClose(long ), 1, (long)l);
    }

    public /* synthetic */ StrictJarFile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictJarFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class RAFStream
    extends InputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private RandomAccessFile sharedRaf;
        private long endOffset;
        private long offset;

        private void $$robo$$android_util_jar_StrictJarFile_RAFStream$__constructor__(RandomAccessFile raf, long initialOffset, long endOffset) {
            this.sharedRaf = raf;
            this.offset = initialOffset;
            this.endOffset = endOffset;
        }

        private void $$robo$$android_util_jar_StrictJarFile_RAFStream$__constructor__(RandomAccessFile raf, long initialOffset) throws IOException {
        }

        private final int $$robo$$android_util_jar_StrictJarFile_RAFStream$available() throws IOException {
            return this.offset < this.endOffset ? 1 : 0;
        }

        private final int $$robo$$android_util_jar_StrictJarFile_RAFStream$read() throws IOException {
            return Streams.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_util_jar_StrictJarFile_RAFStream$read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            RandomAccessFile randomAccessFile = this.sharedRaf;
            synchronized (randomAccessFile) {
                long length = this.endOffset - this.offset;
                if ((long)byteCount > length) {
                    byteCount = (int)length;
                }
                this.sharedRaf.seek(this.offset);
                int count = this.sharedRaf.read(buffer, byteOffset, byteCount);
                if (count > 0) {
                    this.offset += (long)count;
                    return count;
                }
                return -1;
            }
        }

        private final long $$robo$$android_util_jar_StrictJarFile_RAFStream$skip(long byteCount) throws IOException {
            if (byteCount > this.endOffset - this.offset) {
                byteCount = this.endOffset - this.offset;
            }
            this.offset += byteCount;
            return byteCount;
        }

        private void __constructor__(RandomAccessFile randomAccessFile, long l, long l2) {
            this.$$robo$$android_util_jar_StrictJarFile_RAFStream$__constructor__(randomAccessFile, l, l2);
        }

        public RAFStream(RandomAccessFile randomAccessFile, long l, long l2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarFile_RAFStream$__constructor__(java.io.RandomAccessFile long long ), 0, this, randomAccessFile, l, l2);
        }

        private void __constructor__(RandomAccessFile randomAccessFile, long l) throws IOException {
            this.$$robo$$android_util_jar_StrictJarFile_RAFStream$__constructor__(randomAccessFile, l);
        }

        public RAFStream(RandomAccessFile randomAccessFile, long l) throws IOException {
            this(randomAccessFile, l, randomAccessFile.length());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarFile_RAFStream$__constructor__(java.io.RandomAccessFile long ), 0, this, randomAccessFile, l);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_util_jar_StrictJarFile_RAFStream$available(), 0, this);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_util_jar_StrictJarFile_RAFStream$read(), 0, this);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_util_jar_StrictJarFile_RAFStream$read(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$android_util_jar_StrictJarFile_RAFStream$skip(long ), 0, this, l);
        }

        public /* synthetic */ RAFStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RAFStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ZipInflaterInputStream
    extends InflaterInputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ZipEntry entry;
        private long bytesRead;

        private void $$robo$$android_util_jar_StrictJarFile_ZipInflaterInputStream$__constructor__(InputStream is, Inflater inf, int bsize, ZipEntry entry) {
            this.bytesRead = 0L;
            this.entry = entry;
        }

        private final int $$robo$$android_util_jar_StrictJarFile_ZipInflaterInputStream$read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int i;
            try {
                i = super.read(buffer, byteOffset, byteCount);
            }
            catch (IOException e) {
                throw new IOException("Error reading data for " + this.entry.getName() + " near offset " + this.bytesRead, e);
            }
            if (i == -1) {
                if (this.entry.getSize() != this.bytesRead) {
                    throw new IOException("Size mismatch on inflated file: " + this.bytesRead + " vs " + this.entry.getSize());
                }
            } else {
                this.bytesRead += (long)i;
            }
            return i;
        }

        private final int $$robo$$android_util_jar_StrictJarFile_ZipInflaterInputStream$available() throws IOException {
            if (this.closed) {
                return 0;
            }
            return super.available() == 0 ? 0 : (int)(this.entry.getSize() - this.bytesRead);
        }

        private void __constructor__(InputStream inputStream, Inflater inflater, int n, ZipEntry zipEntry) {
            this.$$robo$$android_util_jar_StrictJarFile_ZipInflaterInputStream$__constructor__(inputStream, inflater, n, zipEntry);
        }

        public ZipInflaterInputStream(InputStream inputStream, Inflater inflater, int n, ZipEntry zipEntry) {
            super(inputStream, inflater, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarFile_ZipInflaterInputStream$__constructor__(java.io.InputStream java.util.zip.Inflater int java.util.zip.ZipEntry ), 0, this, inputStream, inflater, n, zipEntry);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_util_jar_StrictJarFile_ZipInflaterInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_util_jar_StrictJarFile_ZipInflaterInputStream$available(), 0, this);
        }

        public /* synthetic */ ZipInflaterInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZipInflaterInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class JarFileInputStream
    extends FilterInputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private StrictJarVerifier.VerifierEntry entry;
        private long count;
        private boolean done;

        private void $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$__constructor__(InputStream is, long size, StrictJarVerifier.VerifierEntry e) {
            this.done = false;
            this.entry = e;
            this.count = size;
        }

        private final int $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$read() throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read();
                if (r != -1) {
                    this.entry.write(r);
                    --this.count;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                    this.entry.verify();
                }
                return r;
            }
            this.done = true;
            this.entry.verify();
            return -1;
        }

        private final int $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read(buffer, byteOffset, byteCount);
                if (r != -1) {
                    int size = r;
                    if (this.count < (long)size) {
                        size = (int)this.count;
                    }
                    this.entry.write(buffer, byteOffset, size);
                    this.count -= (long)size;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                    this.entry.verify();
                }
                return r;
            }
            this.done = true;
            this.entry.verify();
            return -1;
        }

        private final int $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$available() throws IOException {
            if (this.done) {
                return 0;
            }
            return super.available();
        }

        private final long $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$skip(long byteCount) throws IOException {
            return Streams.skipByReading(this, byteCount);
        }

        private void __constructor__(InputStream inputStream, long l, StrictJarVerifier.VerifierEntry verifierEntry) {
            this.$$robo$$android_util_jar_StrictJarFile_JarFileInputStream$__constructor__(inputStream, l, verifierEntry);
        }

        JarFileInputStream(InputStream inputStream, long l, StrictJarVerifier.VerifierEntry verifierEntry) {
            super(inputStream);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$__constructor__(java.io.InputStream long android.util.jar.StrictJarVerifier$VerifierEntry ), 0, this, inputStream, l, verifierEntry);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$read(), 0, this);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$available(), 0, this);
        }

        @Override
        public long skip(long l) throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$android_util_jar_StrictJarFile_JarFileInputStream$skip(long ), 0, this, l);
        }

        public /* synthetic */ JarFileInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JarFileInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EntryIterator
    implements Iterator<ZipEntry> {
        public transient /* synthetic */ Object __robo_data__;
        private long iterationHandle;
        private ZipEntry nextEntry;

        private void $$robo$$android_util_jar_StrictJarFile_EntryIterator$__constructor__(long nativeHandle, String prefix) throws IOException {
            this.iterationHandle = StrictJarFile.nativeStartIteration(nativeHandle, prefix);
        }

        private final ZipEntry $$robo$$android_util_jar_StrictJarFile_EntryIterator$next() {
            if (this.nextEntry != null) {
                ZipEntry ze = this.nextEntry;
                this.nextEntry = null;
                return ze;
            }
            return StrictJarFile.nativeNextEntry(this.iterationHandle);
        }

        private final boolean $$robo$$android_util_jar_StrictJarFile_EntryIterator$hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            ZipEntry ze = StrictJarFile.nativeNextEntry(this.iterationHandle);
            if (ze == null) {
                return false;
            }
            this.nextEntry = ze;
            return true;
        }

        private final void $$robo$$android_util_jar_StrictJarFile_EntryIterator$remove() {
            throw new UnsupportedOperationException();
        }

        private void __constructor__(long l, String string2) throws IOException {
            this.$$robo$$android_util_jar_StrictJarFile_EntryIterator$__constructor__(l, string2);
        }

        EntryIterator(long l, String string2) throws IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarFile_EntryIterator$__constructor__(long java.lang.String ), 0, this, l, string2);
        }

        @Override
        public ZipEntry next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_util_jar_StrictJarFile_EntryIterator$next(), 0, this);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_util_jar_StrictJarFile_EntryIterator$hasNext(), 0, this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_jar_StrictJarFile_EntryIterator$remove(), 0, this);
        }

        public /* synthetic */ EntryIterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntryIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

