/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.ArrayMap;
import android.util.Pair;
import android.util.apk.ZipUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import libcore.io.Libcore;
import libcore.io.Os;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApkSignatureSchemeV2Verifier
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String SF_ATTRIBUTE_ANDROID_APK_SIGNED_NAME = "X-Android-APK-Signed";
    public static int SF_ATTRIBUTE_ANDROID_APK_SIGNED_ID = 2;
    private static int CHUNK_SIZE_BYTES = 0x100000;
    private static int SIGNATURE_RSA_PSS_WITH_SHA256 = 257;
    private static int SIGNATURE_RSA_PSS_WITH_SHA512 = 258;
    private static int SIGNATURE_RSA_PKCS1_V1_5_WITH_SHA256 = 259;
    private static int SIGNATURE_RSA_PKCS1_V1_5_WITH_SHA512 = 260;
    private static int SIGNATURE_ECDSA_WITH_SHA256 = 513;
    private static int SIGNATURE_ECDSA_WITH_SHA512 = 514;
    private static int SIGNATURE_DSA_WITH_SHA256 = 769;
    private static int CONTENT_DIGEST_CHUNKED_SHA256 = 1;
    private static int CONTENT_DIGEST_CHUNKED_SHA512 = 2;
    private static long APK_SIG_BLOCK_MAGIC_HI = 3617552046287187010L;
    private static long APK_SIG_BLOCK_MAGIC_LO = 2334950737559900225L;
    private static int APK_SIG_BLOCK_MIN_SIZE = 32;
    private static int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;

    private void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$__constructor__() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$hasSignature(String apkFile) throws IOException {
        try (RandomAccessFile apk = new RandomAccessFile(apkFile, "r");){
            ApkSignatureSchemeV2Verifier.findSignature(apk);
            boolean bl = true;
            return bl;
        }
        catch (SignatureNotFoundException e) {
            return false;
        }
    }

    private static final X509Certificate[][] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verify(String apkFile) throws SignatureNotFoundException, SecurityException, IOException {
        try (RandomAccessFile apk = new RandomAccessFile(apkFile, "r");){
            X509Certificate[][] x509CertificateArray = ApkSignatureSchemeV2Verifier.verify(apk);
            return x509CertificateArray;
        }
    }

    private static final X509Certificate[][] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verify(RandomAccessFile apk) throws SignatureNotFoundException, SecurityException, IOException {
        SignatureInfo signatureInfo = ApkSignatureSchemeV2Verifier.findSignature(apk);
        return ApkSignatureSchemeV2Verifier.verify(apk.getFD(), signatureInfo);
    }

    private static final SignatureInfo $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$findSignature(RandomAccessFile apk) throws IOException, SignatureNotFoundException {
        Pair<ByteBuffer, Long> eocdAndOffsetInFile = ApkSignatureSchemeV2Verifier.getEocd(apk);
        ByteBuffer eocd = (ByteBuffer)eocdAndOffsetInFile.first;
        long eocdOffset = (Long)eocdAndOffsetInFile.second;
        if (ZipUtils.isZip64EndOfCentralDirectoryLocatorPresent(apk, eocdOffset)) {
            throw new SignatureNotFoundException("ZIP64 APK not supported");
        }
        long centralDirOffset = ApkSignatureSchemeV2Verifier.getCentralDirOffset(eocd, eocdOffset);
        Pair<ByteBuffer, Long> apkSigningBlockAndOffsetInFile = ApkSignatureSchemeV2Verifier.findApkSigningBlock(apk, centralDirOffset);
        ByteBuffer apkSigningBlock = (ByteBuffer)apkSigningBlockAndOffsetInFile.first;
        long apkSigningBlockOffset = (Long)apkSigningBlockAndOffsetInFile.second;
        ByteBuffer apkSignatureSchemeV2Block = ApkSignatureSchemeV2Verifier.findApkSignatureSchemeV2Block(apkSigningBlock);
        return new SignatureInfo(apkSignatureSchemeV2Block, apkSigningBlockOffset, centralDirOffset, eocdOffset, eocd);
    }

    private static final X509Certificate[][] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verify(FileDescriptor apkFileDescriptor, SignatureInfo signatureInfo) throws SecurityException {
        ByteBuffer signers;
        CertificateFactory certFactory;
        int signerCount = 0;
        ArrayMap<Integer, byte[]> contentDigests = new ArrayMap<Integer, byte[]>();
        ArrayList<X509Certificate[]> signerCerts = new ArrayList<X509Certificate[]>();
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        try {
            signers = ApkSignatureSchemeV2Verifier.getLengthPrefixedSlice(signatureInfo.signatureBlock);
        }
        catch (IOException e) {
            throw new SecurityException("Failed to read list of signers", e);
        }
        while (signers.hasRemaining()) {
            ++signerCount;
            try {
                ByteBuffer signer = ApkSignatureSchemeV2Verifier.getLengthPrefixedSlice(signers);
                X509Certificate[] certs = ApkSignatureSchemeV2Verifier.verifySigner(signer, contentDigests, certFactory);
                signerCerts.add(certs);
            }
            catch (IOException | SecurityException | BufferUnderflowException e) {
                throw new SecurityException("Failed to parse/verify signer #" + signerCount + " block", e);
            }
        }
        if (signerCount < 1) {
            throw new SecurityException("No signers found");
        }
        if (contentDigests.isEmpty()) {
            throw new SecurityException("No content digests found");
        }
        ApkSignatureSchemeV2Verifier.verifyIntegrity(contentDigests, apkFileDescriptor, signatureInfo.apkSigningBlockOffset, signatureInfo.centralDirOffset, signatureInfo.eocdOffset, signatureInfo.eocd);
        return (X509Certificate[][])signerCerts.toArray((T[])new X509Certificate[signerCerts.size()][]);
    }

    private static final X509Certificate[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verifySigner(ByteBuffer signerBlock, Map<Integer, byte[]> contentDigests, CertificateFactory certFactory) throws SecurityException, IOException {
        boolean sigVerified;
        ByteBuffer signedData = ApkSignatureSchemeV2Verifier.getLengthPrefixedSlice(signerBlock);
        ByteBuffer signatures = ApkSignatureSchemeV2Verifier.getLengthPrefixedSlice(signerBlock);
        byte[] publicKeyBytes = ApkSignatureSchemeV2Verifier.readLengthPrefixedByteArray(signerBlock);
        int signatureCount = 0;
        int bestSigAlgorithm = -1;
        byte[] bestSigAlgorithmSignatureBytes = null;
        ArrayList<Integer> signaturesSigAlgorithms = new ArrayList<Integer>();
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSignatureSchemeV2Verifier.getLengthPrefixedSlice(signatures);
                if (signature.remaining() < 8) {
                    throw new SecurityException("Signature record too short");
                }
                int sigAlgorithm = signature.getInt();
                signaturesSigAlgorithms.add(sigAlgorithm);
                if (!ApkSignatureSchemeV2Verifier.isSupportedSignatureAlgorithm(sigAlgorithm) || bestSigAlgorithm != -1 && ApkSignatureSchemeV2Verifier.compareSignatureAlgorithm(sigAlgorithm, bestSigAlgorithm) <= 0) continue;
                bestSigAlgorithm = sigAlgorithm;
                bestSigAlgorithmSignatureBytes = ApkSignatureSchemeV2Verifier.readLengthPrefixedByteArray(signature);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new SecurityException("Failed to parse signature record #" + signatureCount, e);
            }
        }
        if (bestSigAlgorithm == -1) {
            if (signatureCount == 0) {
                throw new SecurityException("No signatures found");
            }
            throw new SecurityException("No supported signatures found");
        }
        String keyAlgorithm = ApkSignatureSchemeV2Verifier.getSignatureAlgorithmJcaKeyAlgorithm(bestSigAlgorithm);
        Pair<String, ? extends AlgorithmParameterSpec> signatureAlgorithmParams = ApkSignatureSchemeV2Verifier.getSignatureAlgorithmJcaSignatureAlgorithm(bestSigAlgorithm);
        String jcaSignatureAlgorithm = (String)signatureAlgorithmParams.first;
        AlgorithmParameterSpec jcaSignatureAlgorithmParams = (AlgorithmParameterSpec)signatureAlgorithmParams.second;
        try {
            PublicKey publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
            sig.initVerify(publicKey);
            if (jcaSignatureAlgorithmParams != null) {
                sig.setParameter(jcaSignatureAlgorithmParams);
            }
            sig.update(signedData);
            sigVerified = sig.verify(bestSigAlgorithmSignatureBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new SecurityException("Failed to verify " + jcaSignatureAlgorithm + " signature", e);
        }
        if (!sigVerified) {
            throw new SecurityException(jcaSignatureAlgorithm + " signature did not verify");
        }
        byte[] contentDigest = null;
        signedData.clear();
        ByteBuffer digests = ApkSignatureSchemeV2Verifier.getLengthPrefixedSlice(signedData);
        ArrayList<Integer> digestsSigAlgorithms = new ArrayList<Integer>();
        int digestCount = 0;
        while (digests.hasRemaining()) {
            ++digestCount;
            try {
                ByteBuffer digest = ApkSignatureSchemeV2Verifier.getLengthPrefixedSlice(digests);
                if (digest.remaining() < 8) {
                    throw new IOException("Record too short");
                }
                int sigAlgorithm = digest.getInt();
                digestsSigAlgorithms.add(sigAlgorithm);
                if (sigAlgorithm != bestSigAlgorithm) continue;
                contentDigest = ApkSignatureSchemeV2Verifier.readLengthPrefixedByteArray(digest);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new IOException("Failed to parse digest record #" + digestCount, e);
            }
        }
        if (!signaturesSigAlgorithms.equals(digestsSigAlgorithms)) {
            throw new SecurityException("Signature algorithms don't match between digests and signatures records");
        }
        int digestAlgorithm = ApkSignatureSchemeV2Verifier.getSignatureAlgorithmContentDigestAlgorithm(bestSigAlgorithm);
        byte[] previousSignerDigest = contentDigests.put(digestAlgorithm, contentDigest);
        if (previousSignerDigest != null && !MessageDigest.isEqual(previousSignerDigest, contentDigest)) {
            throw new SecurityException(ApkSignatureSchemeV2Verifier.getContentDigestAlgorithmJcaDigestAlgorithm(digestAlgorithm) + " contents digest does not match the digest specified by a preceding signer");
        }
        ByteBuffer certificates = ApkSignatureSchemeV2Verifier.getLengthPrefixedSlice(signedData);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        int certificateCount = 0;
        while (certificates.hasRemaining()) {
            X509Certificate certificate;
            ++certificateCount;
            byte[] encodedCert = ApkSignatureSchemeV2Verifier.readLengthPrefixedByteArray(certificates);
            try {
                certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
            }
            catch (CertificateException e) {
                throw new SecurityException("Failed to decode certificate #" + certificateCount, e);
            }
            certificate = new VerbatimX509Certificate(certificate, encodedCert);
            certs.add(certificate);
        }
        if (certs.isEmpty()) {
            throw new SecurityException("No certificates listed");
        }
        X509Certificate mainCertificate = (X509Certificate)certs.get(0);
        byte[] certificatePublicKeyBytes = mainCertificate.getPublicKey().getEncoded();
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            throw new SecurityException("Public key mismatch between certificate and signature record");
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    private static final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verifyIntegrity(Map<Integer, byte[]> expectedDigests, FileDescriptor apkFileDescriptor, long apkSigningBlockOffset, long centralDirOffset, long eocdOffset, ByteBuffer eocdBuf) throws SecurityException {
        byte[][] actualDigests;
        if (expectedDigests.isEmpty()) {
            throw new SecurityException("No digests provided");
        }
        MemoryMappedFileDataSource beforeApkSigningBlock = new MemoryMappedFileDataSource(apkFileDescriptor, 0L, apkSigningBlockOffset);
        MemoryMappedFileDataSource centralDir = new MemoryMappedFileDataSource(apkFileDescriptor, centralDirOffset, eocdOffset - centralDirOffset);
        eocdBuf = eocdBuf.duplicate();
        eocdBuf.order(ByteOrder.LITTLE_ENDIAN);
        ZipUtils.setZipEocdCentralDirectoryOffset(eocdBuf, apkSigningBlockOffset);
        ByteBufferDataSource eocd = new ByteBufferDataSource(eocdBuf);
        int[] digestAlgorithms = new int[expectedDigests.size()];
        int digestAlgorithmCount = 0;
        Iterator<Integer> iterator = expectedDigests.keySet().iterator();
        while (iterator.hasNext()) {
            int digestAlgorithm;
            digestAlgorithms[digestAlgorithmCount] = digestAlgorithm = iterator.next().intValue();
            ++digestAlgorithmCount;
        }
        try {
            actualDigests = ApkSignatureSchemeV2Verifier.computeContentDigests(digestAlgorithms, new DataSource[]{beforeApkSigningBlock, centralDir, eocd});
        }
        catch (DigestException e) {
            throw new SecurityException("Failed to compute digest(s) of contents", e);
        }
        for (int i = 0; i < digestAlgorithms.length; ++i) {
            byte[] actualDigest;
            int digestAlgorithm = digestAlgorithms[i];
            byte[] expectedDigest = expectedDigests.get(digestAlgorithm);
            if (MessageDigest.isEqual(expectedDigest, actualDigest = actualDigests[i])) continue;
            throw new SecurityException(ApkSignatureSchemeV2Verifier.getContentDigestAlgorithmJcaDigestAlgorithm(digestAlgorithm) + " digest of contents did not verify");
        }
    }

    private static final byte[][] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$computeContentDigests(int[] digestAlgorithms, DataSource[] contents) throws DigestException {
        long totalChunkCountLong = 0L;
        for (DataSource input : contents) {
            totalChunkCountLong += ApkSignatureSchemeV2Verifier.getChunkCount(input.size());
        }
        if (totalChunkCountLong >= 0x1FFFFFL) {
            throw new DigestException("Too many chunks: " + totalChunkCountLong);
        }
        int totalChunkCount = (int)totalChunkCountLong;
        byte[][] digestsOfChunks = new byte[digestAlgorithms.length][];
        for (int i = 0; i < digestAlgorithms.length; ++i) {
            int digestAlgorithm = digestAlgorithms[i];
            int digestOutputSizeBytes = ApkSignatureSchemeV2Verifier.getContentDigestAlgorithmOutputSizeBytes(digestAlgorithm);
            byte[] concatenationOfChunkCountAndChunkDigests = new byte[5 + totalChunkCount * digestOutputSizeBytes];
            concatenationOfChunkCountAndChunkDigests[0] = 90;
            ApkSignatureSchemeV2Verifier.setUnsignedInt32LittleEndian(totalChunkCount, concatenationOfChunkCountAndChunkDigests, 1);
            digestsOfChunks[i] = concatenationOfChunkCountAndChunkDigests;
        }
        byte[] chunkContentPrefix = new byte[5];
        chunkContentPrefix[0] = -91;
        int chunkIndex = 0;
        MessageDigest[] mds = new MessageDigest[digestAlgorithms.length];
        for (int i = 0; i < digestAlgorithms.length; ++i) {
            String string2 = ApkSignatureSchemeV2Verifier.getContentDigestAlgorithmJcaDigestAlgorithm(digestAlgorithms[i]);
            try {
                mds[i] = MessageDigest.getInstance(string2);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(string2 + " digest not supported", e);
            }
        }
        int dataSourceIndex = 0;
        for (DataSource dataSource : contents) {
            long inputOffset = 0L;
            long inputRemaining = dataSource.size();
            while (inputRemaining > 0L) {
                int i;
                int chunkSize = (int)Math.min(inputRemaining, 0x100000L);
                ApkSignatureSchemeV2Verifier.setUnsignedInt32LittleEndian(chunkSize, chunkContentPrefix, 1);
                for (i = 0; i < mds.length; ++i) {
                    mds[i].update(chunkContentPrefix);
                }
                try {
                    dataSource.feedIntoMessageDigests(mds, inputOffset, chunkSize);
                }
                catch (IOException e) {
                    throw new DigestException("Failed to digest chunk #" + chunkIndex + " of section #" + dataSourceIndex, e);
                }
                for (i = 0; i < digestAlgorithms.length; ++i) {
                    MessageDigest md = mds[i];
                    byte[] concatenationOfChunkCountAndChunkDigests = digestsOfChunks[i];
                    int digestAlgorithm = digestAlgorithms[i];
                    int expectedDigestSizeBytes = ApkSignatureSchemeV2Verifier.getContentDigestAlgorithmOutputSizeBytes(digestAlgorithm);
                    int actualDigestSizeBytes = md.digest(concatenationOfChunkCountAndChunkDigests, 5 + chunkIndex * expectedDigestSizeBytes, expectedDigestSizeBytes);
                    if (actualDigestSizeBytes == expectedDigestSizeBytes) continue;
                    throw new RuntimeException("Unexpected output size of " + md.getAlgorithm() + " digest: " + actualDigestSizeBytes);
                }
                inputOffset += (long)chunkSize;
                inputRemaining -= (long)chunkSize;
                ++chunkIndex;
            }
            ++dataSourceIndex;
        }
        byte[][] byArrayArray = new byte[digestAlgorithms.length][];
        for (int i = 0; i < digestAlgorithms.length; ++i) {
            MessageDigest md;
            int digestAlgorithm = digestAlgorithms[i];
            byte[] byArray = digestsOfChunks[i];
            String jcaAlgorithmName = ApkSignatureSchemeV2Verifier.getContentDigestAlgorithmJcaDigestAlgorithm(digestAlgorithm);
            try {
                md = MessageDigest.getInstance(jcaAlgorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(jcaAlgorithmName + " digest not supported", e);
            }
            byte[] output = md.digest(byArray);
            byArrayArray[i] = output;
        }
        return byArrayArray;
    }

    private static final Pair<ByteBuffer, Long> $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getEocd(RandomAccessFile apk) throws IOException, SignatureNotFoundException {
        Pair<ByteBuffer, Long> eocdAndOffsetInFile = ZipUtils.findZipEndOfCentralDirectoryRecord(apk);
        if (eocdAndOffsetInFile == null) {
            throw new SignatureNotFoundException("Not an APK file: ZIP End of Central Directory record not found");
        }
        return eocdAndOffsetInFile;
    }

    private static final long $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getCentralDirOffset(ByteBuffer eocd, long eocdOffset) throws SignatureNotFoundException {
        long centralDirOffset = ZipUtils.getZipEocdCentralDirectoryOffset(eocd);
        if (centralDirOffset >= eocdOffset) {
            throw new SignatureNotFoundException("ZIP Central Directory offset out of range: " + centralDirOffset + ". ZIP End of Central Directory offset: " + eocdOffset);
        }
        long centralDirSize = ZipUtils.getZipEocdCentralDirectorySizeBytes(eocd);
        if (centralDirOffset + centralDirSize != eocdOffset) {
            throw new SignatureNotFoundException("ZIP Central Directory is not immediately followed by End of Central Directory");
        }
        return centralDirOffset;
    }

    private static final long $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getChunkCount(long inputSizeBytes) {
        return (inputSizeBytes + 0x100000L - 1L) / 0x100000L;
    }

    private static final boolean $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$isSupportedSignatureAlgorithm(int sigAlgorithm) {
        switch (sigAlgorithm) {
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 513: 
            case 514: 
            case 769: {
                return true;
            }
        }
        return false;
    }

    private static final int $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$compareSignatureAlgorithm(int sigAlgorithm1, int sigAlgorithm2) {
        int digestAlgorithm1 = ApkSignatureSchemeV2Verifier.getSignatureAlgorithmContentDigestAlgorithm(sigAlgorithm1);
        int digestAlgorithm2 = ApkSignatureSchemeV2Verifier.getSignatureAlgorithmContentDigestAlgorithm(sigAlgorithm2);
        return ApkSignatureSchemeV2Verifier.compareContentDigestAlgorithm(digestAlgorithm1, digestAlgorithm2);
    }

    private static final int $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$compareContentDigestAlgorithm(int digestAlgorithm1, int digestAlgorithm2) {
        switch (digestAlgorithm1) {
            case 1: {
                switch (digestAlgorithm2) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown digestAlgorithm2: " + digestAlgorithm2);
            }
            case 2: {
                switch (digestAlgorithm2) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("Unknown digestAlgorithm2: " + digestAlgorithm2);
            }
        }
        throw new IllegalArgumentException("Unknown digestAlgorithm1: " + digestAlgorithm1);
    }

    private static final int $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getSignatureAlgorithmContentDigestAlgorithm(int sigAlgorithm) {
        switch (sigAlgorithm) {
            case 257: 
            case 259: 
            case 513: 
            case 769: {
                return 1;
            }
            case 258: 
            case 260: 
            case 514: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown signature algorithm: 0x" + Long.toHexString(sigAlgorithm & 0xFFFFFFFF));
    }

    private static final String $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getContentDigestAlgorithmJcaDigestAlgorithm(int digestAlgorithm) {
        switch (digestAlgorithm) {
            case 1: {
                return "SHA-256";
            }
            case 2: {
                return "SHA-512";
            }
        }
        throw new IllegalArgumentException("Unknown content digest algorthm: " + digestAlgorithm);
    }

    private static final int $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getContentDigestAlgorithmOutputSizeBytes(int digestAlgorithm) {
        switch (digestAlgorithm) {
            case 1: {
                return 32;
            }
            case 2: {
                return 64;
            }
        }
        throw new IllegalArgumentException("Unknown content digest algorthm: " + digestAlgorithm);
    }

    private static final String $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getSignatureAlgorithmJcaKeyAlgorithm(int sigAlgorithm) {
        switch (sigAlgorithm) {
            case 257: 
            case 258: 
            case 259: 
            case 260: {
                return "RSA";
            }
            case 513: 
            case 514: {
                return "EC";
            }
            case 769: {
                return "DSA";
            }
        }
        throw new IllegalArgumentException("Unknown signature algorithm: 0x" + Long.toHexString(sigAlgorithm & 0xFFFFFFFF));
    }

    private static final Pair<String, ? extends AlgorithmParameterSpec> $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getSignatureAlgorithmJcaSignatureAlgorithm(int sigAlgorithm) {
        switch (sigAlgorithm) {
            case 257: {
                return Pair.create("SHA256withRSA/PSS", new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
            }
            case 258: {
                return Pair.create("SHA512withRSA/PSS", new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1));
            }
            case 259: {
                return Pair.create("SHA256withRSA", null);
            }
            case 260: {
                return Pair.create("SHA512withRSA", null);
            }
            case 513: {
                return Pair.create("SHA256withECDSA", null);
            }
            case 514: {
                return Pair.create("SHA512withECDSA", null);
            }
            case 769: {
                return Pair.create("SHA256withDSA", null);
            }
        }
        throw new IllegalArgumentException("Unknown signature algorithm: 0x" + Long.toHexString(sigAlgorithm & 0xFFFFFFFF));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ByteBuffer $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$sliceFromTo(ByteBuffer source, int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start: " + end + " < " + start);
        }
        int capacity = source.capacity();
        if (end > source.capacity()) {
            throw new IllegalArgumentException("end > capacity: " + end + " > " + capacity);
        }
        int originalLimit = source.limit();
        int originalPosition = source.position();
        try {
            source.position(0);
            source.limit(end);
            source.position(start);
            ByteBuffer result = source.slice();
            result.order(source.order());
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.position(0);
            source.limit(originalLimit);
            source.position(originalPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ByteBuffer $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getByteBuffer(ByteBuffer source, int size) throws BufferUnderflowException {
        if (size < 0) {
            throw new IllegalArgumentException("size: " + size);
        }
        int originalLimit = source.limit();
        int position = source.position();
        int limit = position + size;
        if (limit < position || limit > originalLimit) {
            throw new BufferUnderflowException();
        }
        source.limit(limit);
        try {
            ByteBuffer result = source.slice();
            result.order(source.order());
            source.position(limit);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        finally {
            source.limit(originalLimit);
        }
    }

    private static final ByteBuffer $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getLengthPrefixedSlice(ByteBuffer source) throws IOException {
        if (source.remaining() < 4) {
            throw new IOException("Remaining buffer too short to contain length of length-prefixed field. Remaining: " + source.remaining());
        }
        int len = source.getInt();
        if (len < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (len > source.remaining()) {
            throw new IOException("Length-prefixed field longer than remaining buffer. Field length: " + len + ", remaining: " + source.remaining());
        }
        return ApkSignatureSchemeV2Verifier.getByteBuffer(source, len);
    }

    private static final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$readLengthPrefixedByteArray(ByteBuffer buf) throws IOException {
        int len = buf.getInt();
        if (len < 0) {
            throw new IOException("Negative length");
        }
        if (len > buf.remaining()) {
            throw new IOException("Underflow while reading length-prefixed value. Length: " + len + ", available: " + buf.remaining());
        }
        byte[] result = new byte[len];
        buf.get(result);
        return result;
    }

    private static final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$setUnsignedInt32LittleEndian(int value, byte[] result, int offset) {
        result[offset] = (byte)(value & 0xFF);
        result[offset + 1] = (byte)(value >>> 8 & 0xFF);
        result[offset + 2] = (byte)(value >>> 16 & 0xFF);
        result[offset + 3] = (byte)(value >>> 24 & 0xFF);
    }

    private static final Pair<ByteBuffer, Long> $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$findApkSigningBlock(RandomAccessFile apk, long centralDirOffset) throws IOException, SignatureNotFoundException {
        if (centralDirOffset < 32L) {
            throw new SignatureNotFoundException("APK too small for APK Signing Block. ZIP Central Directory offset: " + centralDirOffset);
        }
        ByteBuffer footer = ByteBuffer.allocate(24);
        footer.order(ByteOrder.LITTLE_ENDIAN);
        apk.seek(centralDirOffset - (long)footer.capacity());
        apk.readFully(footer.array(), footer.arrayOffset(), footer.capacity());
        if (footer.getLong(8) != 2334950737559900225L || footer.getLong(16) != 3617552046287187010L) {
            throw new SignatureNotFoundException("No APK Signing Block before ZIP Central Directory");
        }
        long apkSigBlockSizeInFooter = footer.getLong(0);
        if (apkSigBlockSizeInFooter < (long)footer.capacity() || apkSigBlockSizeInFooter > 0x7FFFFFF7L) {
            throw new SignatureNotFoundException("APK Signing Block size out of range: " + apkSigBlockSizeInFooter);
        }
        int totalSize = (int)(apkSigBlockSizeInFooter + 8L);
        long apkSigBlockOffset = centralDirOffset - (long)totalSize;
        if (apkSigBlockOffset < 0L) {
            throw new SignatureNotFoundException("APK Signing Block offset out of range: " + apkSigBlockOffset);
        }
        ByteBuffer apkSigBlock = ByteBuffer.allocate(totalSize);
        apkSigBlock.order(ByteOrder.LITTLE_ENDIAN);
        apk.seek(apkSigBlockOffset);
        apk.readFully(apkSigBlock.array(), apkSigBlock.arrayOffset(), apkSigBlock.capacity());
        long apkSigBlockSizeInHeader = apkSigBlock.getLong(0);
        if (apkSigBlockSizeInHeader != apkSigBlockSizeInFooter) {
            throw new SignatureNotFoundException("APK Signing Block sizes in header and footer do not match: " + apkSigBlockSizeInHeader + " vs " + apkSigBlockSizeInFooter);
        }
        return Pair.create(apkSigBlock, apkSigBlockOffset);
    }

    private static final ByteBuffer $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$findApkSignatureSchemeV2Block(ByteBuffer apkSigningBlock) throws SignatureNotFoundException {
        ApkSignatureSchemeV2Verifier.checkByteOrderLittleEndian(apkSigningBlock);
        ByteBuffer pairs = ApkSignatureSchemeV2Verifier.sliceFromTo(apkSigningBlock, 8, apkSigningBlock.capacity() - 24);
        int entryCount = 0;
        while (pairs.hasRemaining()) {
            ++entryCount;
            if (pairs.remaining() < 8) {
                throw new SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + entryCount);
            }
            long lenLong = pairs.getLong();
            if (lenLong < 4L || lenLong > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + lenLong);
            }
            int len = (int)lenLong;
            int nextEntryPos = pairs.position() + len;
            if (len > pairs.remaining()) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + entryCount + " size out of range: " + len + ", available: " + pairs.remaining());
            }
            int id2 = pairs.getInt();
            if (id2 == 1896449818) {
                return ApkSignatureSchemeV2Verifier.getByteBuffer(pairs, len - 4);
            }
            pairs.position(nextEntryPos);
        }
        throw new SignatureNotFoundException("No APK Signature Scheme v2 block in APK Signing Block");
    }

    private static final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$checkByteOrderLittleEndian(ByteBuffer buffer) {
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    private void __constructor__() {
        this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$__constructor__();
    }

    public ApkSignatureSchemeV2Verifier() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$__constructor__(), 0, this);
    }

    public static boolean hasSignature(String string2) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSignature", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$hasSignature(java.lang.String ), 0, (String)string2);
    }

    public static X509Certificate[][] verify(String string2) throws SignatureNotFoundException, SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("verify", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verify(java.lang.String ), 0, (String)string2);
    }

    private static X509Certificate[][] verify(RandomAccessFile randomAccessFile) throws SignatureNotFoundException, SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("verify", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verify(java.io.RandomAccessFile ), 0, (RandomAccessFile)randomAccessFile);
    }

    private static SignatureInfo findSignature(RandomAccessFile randomAccessFile) throws IOException, SignatureNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("findSignature", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$findSignature(java.io.RandomAccessFile ), 0, (RandomAccessFile)randomAccessFile);
    }

    private static X509Certificate[][] verify(FileDescriptor fileDescriptor, SignatureInfo signatureInfo) throws SecurityException {
        return InvokeDynamicSupport.bootstrapStatic("verify", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verify(java.io.FileDescriptor android.util.apk.ApkSignatureSchemeV2Verifier$SignatureInfo ), 0, (FileDescriptor)fileDescriptor, (SignatureInfo)signatureInfo);
    }

    private static X509Certificate[] verifySigner(ByteBuffer byteBuffer, Map<Integer, byte[]> map, CertificateFactory certificateFactory) throws SecurityException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("verifySigner", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verifySigner(java.nio.ByteBuffer java.util.Map<java.lang.Integer, byte[]> java.security.cert.CertificateFactory ), 0, (ByteBuffer)byteBuffer, map, (CertificateFactory)certificateFactory);
    }

    private static void verifyIntegrity(Map<Integer, byte[]> map, FileDescriptor fileDescriptor, long l, long l2, long l3, ByteBuffer byteBuffer) throws SecurityException {
        InvokeDynamicSupport.bootstrapStatic("verifyIntegrity", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$verifyIntegrity(java.util.Map<java.lang.Integer, byte[]> java.io.FileDescriptor long long long java.nio.ByteBuffer ), 0, map, (FileDescriptor)fileDescriptor, (long)l, (long)l2, (long)l3, (ByteBuffer)byteBuffer);
    }

    private static byte[][] computeContentDigests(int[] nArray, DataSource[] dataSourceArray) throws DigestException {
        return InvokeDynamicSupport.bootstrapStatic("computeContentDigests", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$computeContentDigests(int[] android.util.apk.ApkSignatureSchemeV2Verifier$DataSource[] ), 0, (int[])nArray, (DataSource[])dataSourceArray);
    }

    private static Pair<ByteBuffer, Long> getEocd(RandomAccessFile randomAccessFile) throws IOException, SignatureNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getEocd", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getEocd(java.io.RandomAccessFile ), 0, (RandomAccessFile)randomAccessFile);
    }

    private static long getCentralDirOffset(ByteBuffer byteBuffer, long l) throws SignatureNotFoundException {
        return (long)InvokeDynamicSupport.bootstrapStatic("getCentralDirOffset", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getCentralDirOffset(java.nio.ByteBuffer long ), 0, (ByteBuffer)byteBuffer, (long)l);
    }

    private static long getChunkCount(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getChunkCount", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getChunkCount(long ), 0, (long)l);
    }

    private static boolean isSupportedSignatureAlgorithm(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSupportedSignatureAlgorithm", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$isSupportedSignatureAlgorithm(int ), 0, (int)n);
    }

    private static int compareSignatureAlgorithm(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareSignatureAlgorithm", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$compareSignatureAlgorithm(int int ), 0, (int)n, (int)n2);
    }

    private static int compareContentDigestAlgorithm(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareContentDigestAlgorithm", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$compareContentDigestAlgorithm(int int ), 0, (int)n, (int)n2);
    }

    private static int getSignatureAlgorithmContentDigestAlgorithm(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSignatureAlgorithmContentDigestAlgorithm", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getSignatureAlgorithmContentDigestAlgorithm(int ), 0, (int)n);
    }

    private static String getContentDigestAlgorithmJcaDigestAlgorithm(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getContentDigestAlgorithmJcaDigestAlgorithm", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getContentDigestAlgorithmJcaDigestAlgorithm(int ), 0, (int)n);
    }

    private static int getContentDigestAlgorithmOutputSizeBytes(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getContentDigestAlgorithmOutputSizeBytes", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getContentDigestAlgorithmOutputSizeBytes(int ), 0, (int)n);
    }

    private static String getSignatureAlgorithmJcaKeyAlgorithm(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSignatureAlgorithmJcaKeyAlgorithm", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getSignatureAlgorithmJcaKeyAlgorithm(int ), 0, (int)n);
    }

    private static Pair<String, ? extends AlgorithmParameterSpec> getSignatureAlgorithmJcaSignatureAlgorithm(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSignatureAlgorithmJcaSignatureAlgorithm", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getSignatureAlgorithmJcaSignatureAlgorithm(int ), 0, (int)n);
    }

    private static ByteBuffer sliceFromTo(ByteBuffer byteBuffer, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("sliceFromTo", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$sliceFromTo(java.nio.ByteBuffer int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2);
    }

    private static ByteBuffer getByteBuffer(ByteBuffer byteBuffer, int n) throws BufferUnderflowException {
        return InvokeDynamicSupport.bootstrapStatic("getByteBuffer", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getByteBuffer(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    private static ByteBuffer getLengthPrefixedSlice(ByteBuffer byteBuffer) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getLengthPrefixedSlice", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$getLengthPrefixedSlice(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    private static byte[] readLengthPrefixedByteArray(ByteBuffer byteBuffer) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readLengthPrefixedByteArray", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$readLengthPrefixedByteArray(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    private static void setUnsignedInt32LittleEndian(int n, byte[] byArray, int n2) {
        InvokeDynamicSupport.bootstrapStatic("setUnsignedInt32LittleEndian", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$setUnsignedInt32LittleEndian(int byte[] int ), 0, (int)n, (byte[])byArray, (int)n2);
    }

    private static Pair<ByteBuffer, Long> findApkSigningBlock(RandomAccessFile randomAccessFile, long l) throws IOException, SignatureNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("findApkSigningBlock", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$findApkSigningBlock(java.io.RandomAccessFile long ), 0, (RandomAccessFile)randomAccessFile, (long)l);
    }

    private static ByteBuffer findApkSignatureSchemeV2Block(ByteBuffer byteBuffer) throws SignatureNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("findApkSignatureSchemeV2Block", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$findApkSignatureSchemeV2Block(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    private static void checkByteOrderLittleEndian(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrapStatic("checkByteOrderLittleEndian", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier$checkByteOrderLittleEndian(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkSignatureSchemeV2Verifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class WrappedX509Certificate
    extends X509Certificate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private X509Certificate wrapped;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$__constructor__(X509Certificate wrapped) {
            this.wrapped = wrapped;
        }

        private final Set<String> $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getCriticalExtensionOIDs() {
            return this.wrapped.getCriticalExtensionOIDs();
        }

        private final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getExtensionValue(String oid) {
            return this.wrapped.getExtensionValue(oid);
        }

        private final Set<String> $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getNonCriticalExtensionOIDs() {
            return this.wrapped.getNonCriticalExtensionOIDs();
        }

        private final boolean $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$hasUnsupportedCriticalExtension() {
            return this.wrapped.hasUnsupportedCriticalExtension();
        }

        private final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            this.wrapped.checkValidity();
        }

        private final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            this.wrapped.checkValidity(date);
        }

        private final int $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getVersion() {
            return this.wrapped.getVersion();
        }

        private final BigInteger $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSerialNumber() {
            return this.wrapped.getSerialNumber();
        }

        private final Principal $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getIssuerDN() {
            return this.wrapped.getIssuerDN();
        }

        private final Principal $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSubjectDN() {
            return this.wrapped.getSubjectDN();
        }

        private final Date $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getNotBefore() {
            return this.wrapped.getNotBefore();
        }

        private final Date $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getNotAfter() {
            return this.wrapped.getNotAfter();
        }

        private final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getTBSCertificate() throws CertificateEncodingException {
            return this.wrapped.getTBSCertificate();
        }

        private final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSignature() {
            return this.wrapped.getSignature();
        }

        private final String $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSigAlgName() {
            return this.wrapped.getSigAlgName();
        }

        private final String $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSigAlgOID() {
            return this.wrapped.getSigAlgOID();
        }

        private final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSigAlgParams() {
            return this.wrapped.getSigAlgParams();
        }

        private final boolean[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getIssuerUniqueID() {
            return this.wrapped.getIssuerUniqueID();
        }

        private final boolean[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSubjectUniqueID() {
            return this.wrapped.getSubjectUniqueID();
        }

        private final boolean[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getKeyUsage() {
            return this.wrapped.getKeyUsage();
        }

        private final int $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getBasicConstraints() {
            return this.wrapped.getBasicConstraints();
        }

        private final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getEncoded() throws CertificateEncodingException {
            return this.wrapped.getEncoded();
        }

        private final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            this.wrapped.verify(key);
        }

        private final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            this.wrapped.verify(key, sigProvider);
        }

        private final String $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$toString() {
            return this.wrapped.toString();
        }

        private final PublicKey $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getPublicKey() {
            return this.wrapped.getPublicKey();
        }

        private void __constructor__(X509Certificate x509Certificate) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$__constructor__(x509Certificate);
        }

        public WrappedX509Certificate(X509Certificate x509Certificate) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$__constructor__(java.security.cert.X509Certificate ), 0, this, x509Certificate);
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return InvokeDynamicSupport.bootstrap("getCriticalExtensionOIDs", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getCriticalExtensionOIDs(), 0, this);
        }

        @Override
        public byte[] getExtensionValue(String string2) {
            return InvokeDynamicSupport.bootstrap("getExtensionValue", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getExtensionValue(java.lang.String ), 0, this, string2);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return InvokeDynamicSupport.bootstrap("getNonCriticalExtensionOIDs", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getNonCriticalExtensionOIDs(), 0, this);
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasUnsupportedCriticalExtension", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$hasUnsupportedCriticalExtension(), 0, this);
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            InvokeDynamicSupport.bootstrap("checkValidity", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$checkValidity(), 0, this);
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            InvokeDynamicSupport.bootstrap("checkValidity", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$checkValidity(java.util.Date ), 0, this, date);
        }

        @Override
        public int getVersion() {
            return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getVersion(), 0, this);
        }

        @Override
        public BigInteger getSerialNumber() {
            return InvokeDynamicSupport.bootstrap("getSerialNumber", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSerialNumber(), 0, this);
        }

        @Override
        public Principal getIssuerDN() {
            return InvokeDynamicSupport.bootstrap("getIssuerDN", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getIssuerDN(), 0, this);
        }

        @Override
        public Principal getSubjectDN() {
            return InvokeDynamicSupport.bootstrap("getSubjectDN", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSubjectDN(), 0, this);
        }

        @Override
        public Date getNotBefore() {
            return InvokeDynamicSupport.bootstrap("getNotBefore", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getNotBefore(), 0, this);
        }

        @Override
        public Date getNotAfter() {
            return InvokeDynamicSupport.bootstrap("getNotAfter", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getNotAfter(), 0, this);
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return InvokeDynamicSupport.bootstrap("getTBSCertificate", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getTBSCertificate(), 0, this);
        }

        @Override
        public byte[] getSignature() {
            return InvokeDynamicSupport.bootstrap("getSignature", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSignature(), 0, this);
        }

        @Override
        public String getSigAlgName() {
            return InvokeDynamicSupport.bootstrap("getSigAlgName", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSigAlgName(), 0, this);
        }

        @Override
        public String getSigAlgOID() {
            return InvokeDynamicSupport.bootstrap("getSigAlgOID", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSigAlgOID(), 0, this);
        }

        @Override
        public byte[] getSigAlgParams() {
            return InvokeDynamicSupport.bootstrap("getSigAlgParams", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSigAlgParams(), 0, this);
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return InvokeDynamicSupport.bootstrap("getIssuerUniqueID", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getIssuerUniqueID(), 0, this);
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return InvokeDynamicSupport.bootstrap("getSubjectUniqueID", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getSubjectUniqueID(), 0, this);
        }

        @Override
        public boolean[] getKeyUsage() {
            return InvokeDynamicSupport.bootstrap("getKeyUsage", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getKeyUsage(), 0, this);
        }

        @Override
        public int getBasicConstraints() {
            return (int)InvokeDynamicSupport.bootstrap("getBasicConstraints", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getBasicConstraints(), 0, this);
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return InvokeDynamicSupport.bootstrap("getEncoded", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getEncoded(), 0, this);
        }

        @Override
        public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            InvokeDynamicSupport.bootstrap("verify", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$verify(java.security.PublicKey ), 0, this, publicKey);
        }

        @Override
        public void verify(PublicKey publicKey, String string2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            InvokeDynamicSupport.bootstrap("verify", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$verify(java.security.PublicKey java.lang.String ), 0, this, publicKey, string2);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$toString(), 0, this);
        }

        @Override
        public PublicKey getPublicKey() {
            return InvokeDynamicSupport.bootstrap("getPublicKey", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_WrappedX509Certificate$getPublicKey(), 0, this);
        }

        public /* synthetic */ WrappedX509Certificate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WrappedX509Certificate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VerbatimX509Certificate
    extends WrappedX509Certificate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] encodedVerbatim;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_VerbatimX509Certificate$__constructor__(X509Certificate wrapped, byte[] encodedVerbatim) {
            this.encodedVerbatim = encodedVerbatim;
        }

        private final byte[] $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_VerbatimX509Certificate$getEncoded() throws CertificateEncodingException {
            return this.encodedVerbatim;
        }

        private void __constructor__(X509Certificate x509Certificate, byte[] byArray) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_VerbatimX509Certificate$__constructor__(x509Certificate, byArray);
        }

        public VerbatimX509Certificate(X509Certificate x509Certificate, byte[] byArray) {
            super(x509Certificate);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_VerbatimX509Certificate$__constructor__(java.security.cert.X509Certificate byte[] ), 0, this, x509Certificate, byArray);
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return InvokeDynamicSupport.bootstrap("getEncoded", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_VerbatimX509Certificate$getEncoded(), 0, this);
        }

        public /* synthetic */ VerbatimX509Certificate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VerbatimX509Certificate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ByteBufferDataSource
    implements DataSource,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ByteBuffer mBuf;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_ByteBufferDataSource$__constructor__(ByteBuffer buf) {
            this.mBuf = buf.slice();
        }

        private final long $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_ByteBufferDataSource$size() {
            return this.mBuf.capacity();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_ByteBufferDataSource$feedIntoMessageDigests(MessageDigest[] mds, long offset, int size) throws IOException {
            MessageDigest[] messageDigestArray = this.mBuf;
            synchronized (this.mBuf) {
                this.mBuf.position((int)offset);
                this.mBuf.limit((int)offset + size);
                ByteBuffer region = this.mBuf.slice();
                // ** MonitorExit[var6_4] (shouldn't be in output)
                for (MessageDigest md : mds) {
                    region.position(0);
                    md.update(region);
                }
                return;
            }
        }

        private void __constructor__(ByteBuffer byteBuffer) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_ByteBufferDataSource$__constructor__(byteBuffer);
        }

        public ByteBufferDataSource(ByteBuffer byteBuffer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_ByteBufferDataSource$__constructor__(java.nio.ByteBuffer ), 0, this, byteBuffer);
        }

        @Override
        public long size() {
            return (long)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_ByteBufferDataSource$size(), 0, this);
        }

        @Override
        public void feedIntoMessageDigests(MessageDigest[] messageDigestArray, long l, int n) throws IOException {
            InvokeDynamicSupport.bootstrap("feedIntoMessageDigests", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_ByteBufferDataSource$feedIntoMessageDigests(java.security.MessageDigest[] long int ), 0, this, messageDigestArray, l, n);
        }

        public /* synthetic */ ByteBufferDataSource() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteBufferDataSource)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class MemoryMappedFileDataSource
    implements DataSource,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static Os OS;
        private static long MEMORY_PAGE_SIZE_BYTES;
        private FileDescriptor mFd;
        private long mFilePosition;
        private long mSize;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_MemoryMappedFileDataSource$__constructor__(FileDescriptor fd, long position, long size) {
            this.mFd = fd;
            this.mFilePosition = position;
            this.mSize = size;
        }

        private final long $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_MemoryMappedFileDataSource$size() {
            return this.mSize;
        }

        private final void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_MemoryMappedFileDataSource$feedIntoMessageDigests(MessageDigest[] mds, long offset, int size) throws IOException {
            long filePosition = this.mFilePosition + offset;
            long mmapFilePosition = filePosition / MEMORY_PAGE_SIZE_BYTES * MEMORY_PAGE_SIZE_BYTES;
            int dataStartOffsetInMmapRegion = (int)(filePosition - mmapFilePosition);
            long mmapRegionSize = size + dataStartOffsetInMmapRegion;
            long mmapPtr = 0L;
            try {
                mmapPtr = OS.mmap(0L, mmapRegionSize, OsConstants.PROT_READ, OsConstants.MAP_SHARED | OsConstants.MAP_POPULATE, this.mFd, mmapFilePosition);
                DirectByteBuffer buf = new DirectByteBuffer(size, mmapPtr + (long)dataStartOffsetInMmapRegion, this.mFd, null, true);
                for (MessageDigest md : mds) {
                    ((ByteBuffer)buf).position(0);
                    md.update(buf);
                }
            }
            catch (ErrnoException e) {
                throw new IOException("Failed to mmap " + mmapRegionSize + " bytes", e);
            }
            finally {
                if (mmapPtr != 0L) {
                    try {
                        OS.munmap(mmapPtr, mmapRegionSize);
                    }
                    catch (ErrnoException errnoException) {}
                }
            }
        }

        static void __staticInitializer__() {
            OS = Libcore.os;
            MEMORY_PAGE_SIZE_BYTES = OS.sysconf(OsConstants._SC_PAGESIZE);
        }

        private void __constructor__(FileDescriptor fileDescriptor, long l, long l2) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_MemoryMappedFileDataSource$__constructor__(fileDescriptor, l, l2);
        }

        public MemoryMappedFileDataSource(FileDescriptor fileDescriptor, long l, long l2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_MemoryMappedFileDataSource$__constructor__(java.io.FileDescriptor long long ), 0, this, fileDescriptor, l, l2);
        }

        @Override
        public long size() {
            return (long)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_MemoryMappedFileDataSource$size(), 0, this);
        }

        @Override
        public void feedIntoMessageDigests(MessageDigest[] messageDigestArray, long l, int n) throws IOException {
            InvokeDynamicSupport.bootstrap("feedIntoMessageDigests", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_MemoryMappedFileDataSource$feedIntoMessageDigests(java.security.MessageDigest[] long int ), 0, this, messageDigestArray, l, n);
        }

        static {
            RobolectricInternals.classInitializing(MemoryMappedFileDataSource.class);
        }

        public /* synthetic */ MemoryMappedFileDataSource() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryMappedFileDataSource)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface DataSource
    extends InstrumentedInterface {
        public long size();

        public void feedIntoMessageDigests(MessageDigest[] var1, long var2, int var4) throws IOException;
    }

    public static class SignatureNotFoundException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 1L;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureNotFoundException$__constructor__(String message) {
        }

        private void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureNotFoundException$__constructor__(String message, Throwable cause) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureNotFoundException$__constructor__(string2);
        }

        public SignatureNotFoundException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureNotFoundException$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(String string2, Throwable throwable) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureNotFoundException$__constructor__(string2, throwable);
        }

        public SignatureNotFoundException(String string2, Throwable throwable) {
            super(string2, throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureNotFoundException$__constructor__(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
        }

        public /* synthetic */ SignatureNotFoundException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SignatureNotFoundException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SignatureInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ByteBuffer signatureBlock;
        private long apkSigningBlockOffset;
        private long centralDirOffset;
        private long eocdOffset;
        private ByteBuffer eocd;

        private void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureInfo$__constructor__(ByteBuffer signatureBlock, long apkSigningBlockOffset, long centralDirOffset, long eocdOffset, ByteBuffer eocd) {
            this.signatureBlock = signatureBlock;
            this.apkSigningBlockOffset = apkSigningBlockOffset;
            this.centralDirOffset = centralDirOffset;
            this.eocdOffset = eocdOffset;
            this.eocd = eocd;
        }

        private /* synthetic */ void $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureInfo$__constructor__(ByteBuffer x0, long x1, long x2, long x3, ByteBuffer x4, 1 x5) {
        }

        private void __constructor__(ByteBuffer byteBuffer, long l, long l2, long l3, ByteBuffer byteBuffer2) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureInfo$__constructor__(byteBuffer, l, l2, l3, byteBuffer2);
        }

        private SignatureInfo(ByteBuffer byteBuffer, long l, long l2, long l3, ByteBuffer byteBuffer2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureInfo$__constructor__(java.nio.ByteBuffer long long long java.nio.ByteBuffer ), 0, this, byteBuffer, l, l2, l3, byteBuffer2);
        }

        private /* synthetic */ void __constructor__(ByteBuffer byteBuffer, long l, long l2, long l3, ByteBuffer byteBuffer2, 1 var9_6) {
            this.$$robo$$android_util_apk_ApkSignatureSchemeV2Verifier_SignatureInfo$__constructor__(byteBuffer, l, l2, l3, byteBuffer2, var9_6);
        }

        public /* synthetic */ SignatureInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SignatureInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

