/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.SystemClock;
import com.android.internal.util.XmlUtils;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import libcore.util.ZoneInfoDB;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimeUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "TimeUtils";
    private static Object sLastLockObj;
    private static ArrayList<TimeZone> sLastZones;
    private static String sLastCountry;
    private static Object sLastUniqueLockObj;
    private static ArrayList<TimeZone> sLastUniqueZoneOffsets;
    private static String sLastUniqueCountry;
    private static SimpleDateFormat sLoggingFormat;
    public static int HUNDRED_DAY_FIELD_LEN = 19;
    private static int SECONDS_PER_MINUTE = 60;
    private static int SECONDS_PER_HOUR = 3600;
    private static int SECONDS_PER_DAY = 86400;
    public static long NANOS_PER_MS = 1000000L;
    private static Object sFormatSync;
    private static char[] sFormatStr;
    private static char[] sTmpFormatStr;

    private void $$robo$$android_util_TimeUtils$__constructor__() {
    }

    private static final TimeZone $$robo$$android_util_TimeUtils$getTimeZone(int offset, boolean dst, long when, String country) {
        TimeZone best = null;
        Date d = new Date(when);
        TimeZone current = TimeZone.getDefault();
        String currentName = current.getID();
        int currentOffset = current.getOffset(when);
        boolean currentDst = current.inDaylightTime(d);
        for (TimeZone tz : TimeUtils.getTimeZones(country)) {
            if (tz.getID().equals(currentName) && currentOffset == offset && currentDst == dst) {
                return current;
            }
            if (best != null || tz.getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
            best = tz;
        }
        return best;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ArrayList<TimeZone> $$robo$$android_util_TimeUtils$getTimeZonesWithUniqueOffsets(String country) {
        Object object = sLastUniqueLockObj;
        synchronized (object) {
            if (country != null && country.equals(sLastUniqueCountry)) {
                return sLastUniqueZoneOffsets;
            }
        }
        ArrayList<TimeZone> zones = TimeUtils.getTimeZones(country);
        ArrayList<TimeZone> uniqueTimeZones = new ArrayList<TimeZone>();
        for (TimeZone zone : zones) {
            boolean found = false;
            for (int i = 0; i < uniqueTimeZones.size(); ++i) {
                if (((TimeZone)uniqueTimeZones.get(i)).getRawOffset() != zone.getRawOffset()) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniqueTimeZones.add(zone);
        }
        Object object2 = sLastUniqueLockObj;
        synchronized (object2) {
            sLastUniqueZoneOffsets = uniqueTimeZones;
            sLastUniqueCountry = country;
            return sLastUniqueZoneOffsets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ArrayList<TimeZone> $$robo$$android_util_TimeUtils$getTimeZones(String country) {
        Object object = sLastLockObj;
        synchronized (object) {
            if (country != null && country.equals(sLastCountry)) {
                return sLastZones;
            }
        }
        ArrayList<TimeZone> tzs = new ArrayList<TimeZone>();
        if (country == null) {
            return tzs;
        }
        Resources r = Resources.getSystem();
        try (XmlResourceParser parser = r.getXml(0x1110014);){
            XmlUtils.beginDocument(parser, "timezones");
            while (true) {
                String zoneIdString;
                TimeZone tz;
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (!element.equals("timezone")) {
                    break;
                }
                String code = parser.getAttributeValue(null, "code");
                if (!country.equals(code) || parser.next() != 4 || (tz = TimeZone.getTimeZone(zoneIdString = parser.getText())).getID().startsWith("GMT")) continue;
                tzs.add(tz);
            }
        }
        Object object2 = sLastLockObj;
        synchronized (object2) {
            sLastZones = tzs;
            sLastCountry = country;
            return sLastZones;
        }
    }

    private static final String $$robo$$android_util_TimeUtils$getTimeZoneDatabaseVersion() {
        return ZoneInfoDB.getInstance().getVersion();
    }

    private static final int $$robo$$android_util_TimeUtils$accumField(int amt, int suffix, boolean always, int zeropad) {
        if (amt > 999) {
            int num = 0;
            while (amt != 0) {
                ++num;
                amt /= 10;
            }
            return num + suffix;
        }
        if (amt > 99 || always && zeropad >= 3) {
            return 3 + suffix;
        }
        if (amt > 9 || always && zeropad >= 2) {
            return 2 + suffix;
        }
        if (always || amt > 0) {
            return 1 + suffix;
        }
        return 0;
    }

    private static final int $$robo$$android_util_TimeUtils$printFieldLocked(char[] formatStr, int amt, char suffix, int pos, boolean always, int zeropad) {
        if (always || amt > 0) {
            int startPos = pos;
            if (amt > 999) {
                int tmp;
                for (tmp = 0; amt != 0 && tmp < sTmpFormatStr.length; ++tmp, amt /= 10) {
                    int dig = amt % 10;
                    TimeUtils.sTmpFormatStr[tmp] = (char)(dig + 48);
                }
                --tmp;
                while (tmp >= 0) {
                    formatStr[pos] = sTmpFormatStr[tmp];
                    ++pos;
                    --tmp;
                }
            } else {
                int dig;
                if (always && zeropad >= 3 || amt > 99) {
                    dig = amt / 100;
                    formatStr[pos] = (char)(dig + 48);
                    ++pos;
                    amt -= dig * 100;
                }
                if (always && zeropad >= 2 || amt > 9 || startPos != pos) {
                    dig = amt / 10;
                    formatStr[pos] = (char)(dig + 48);
                    ++pos;
                    amt -= dig * 10;
                }
                formatStr[pos] = (char)(amt + 48);
                ++pos;
            }
            formatStr[pos] = suffix;
            ++pos;
        }
        return pos;
    }

    private static final int $$robo$$android_util_TimeUtils$formatDurationLocked(long duration, int fieldLen) {
        int prefix;
        if (sFormatStr.length < fieldLen) {
            sFormatStr = new char[fieldLen];
        }
        char[] formatStr = sFormatStr;
        if (duration == 0L) {
            int pos = 0;
            --fieldLen;
            while (pos < fieldLen) {
                formatStr[pos++] = 32;
            }
            formatStr[pos] = 48;
            return pos + 1;
        }
        if (duration > 0L) {
            prefix = 43;
        } else {
            prefix = 45;
            duration = -duration;
        }
        int millis = (int)(duration % 1000L);
        int seconds = (int)Math.floor(duration / 1000L);
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (seconds >= 86400) {
            days = seconds / 86400;
            seconds -= days * 86400;
        }
        if (seconds >= 3600) {
            hours = seconds / 3600;
            seconds -= hours * 3600;
        }
        if (seconds >= 60) {
            minutes = seconds / 60;
            seconds -= minutes * 60;
        }
        int pos = 0;
        if (fieldLen != 0) {
            int myLen;
            myLen += TimeUtils.accumField(millis, 2, true, (myLen += TimeUtils.accumField(seconds, 1, (myLen += TimeUtils.accumField(minutes, 1, (myLen += TimeUtils.accumField(hours, 1, (myLen = TimeUtils.accumField(days, 1, false, 0)) > 0, 2)) > 0, 2)) > 0, 2)) > 0 ? 3 : 0) + 1;
            while (myLen < fieldLen) {
                formatStr[pos] = 32;
                ++pos;
                ++myLen;
            }
        }
        formatStr[pos] = prefix;
        int start = ++pos;
        boolean zeropad = fieldLen != 0;
        pos = TimeUtils.printFieldLocked(formatStr, days, 'd', pos, false, 0);
        pos = TimeUtils.printFieldLocked(formatStr, hours, 'h', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, minutes, 'm', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, seconds, 's', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, millis, 'm', pos, true, zeropad && pos != start ? 3 : 0);
        formatStr[pos] = 115;
        return pos + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_util_TimeUtils$formatDuration(long duration, StringBuilder builder) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, 0);
            builder.append(sFormatStr, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_util_TimeUtils$formatDuration(long duration, PrintWriter pw, int fieldLen) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, fieldLen);
            pw.print(new String(sFormatStr, 0, len));
        }
    }

    private static final void $$robo$$android_util_TimeUtils$formatDuration(long duration, PrintWriter pw) {
        TimeUtils.formatDuration(duration, pw, 0);
    }

    private static final void $$robo$$android_util_TimeUtils$formatDuration(long time, long now, PrintWriter pw) {
        if (time == 0L) {
            pw.print("--");
            return;
        }
        TimeUtils.formatDuration(time - now, pw, 0);
    }

    private static final String $$robo$$android_util_TimeUtils$formatUptime(long time) {
        long diff = time - SystemClock.uptimeMillis();
        if (diff > 0L) {
            return time + " (in " + diff + " ms)";
        }
        if (diff < 0L) {
            return time + " (" + -diff + " ms ago)";
        }
        return time + " (now)";
    }

    private static final String $$robo$$android_util_TimeUtils$logTimeOfDay(long millis) {
        Calendar c = Calendar.getInstance();
        if (millis >= 0L) {
            c.setTimeInMillis(millis);
            return String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c);
        }
        return Long.toString(millis);
    }

    private static final String $$robo$$android_util_TimeUtils$formatForLogging(long millis) {
        if (millis <= 0L) {
            return "unknown";
        }
        return sLoggingFormat.format(new Date(millis));
    }

    static void __staticInitializer__() {
        sLastLockObj = new Object();
        sLastZones = null;
        sLastCountry = null;
        sLastUniqueLockObj = new Object();
        sLastUniqueZoneOffsets = null;
        sLastUniqueCountry = null;
        sLoggingFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sFormatSync = new Object();
        sFormatStr = new char[29];
        sTmpFormatStr = new char[29];
    }

    private void __constructor__() {
        this.$$robo$$android_util_TimeUtils$__constructor__();
    }

    public TimeUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_TimeUtils$__constructor__(), 0, this);
    }

    public static TimeZone getTimeZone(int n, boolean bl, long l, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeZone", $$robo$$android_util_TimeUtils$getTimeZone(int boolean long java.lang.String ), 0, (int)n, (boolean)bl, (long)l, (String)string2);
    }

    public static ArrayList<TimeZone> getTimeZonesWithUniqueOffsets(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeZonesWithUniqueOffsets", $$robo$$android_util_TimeUtils$getTimeZonesWithUniqueOffsets(java.lang.String ), 0, (String)string2);
    }

    public static ArrayList<TimeZone> getTimeZones(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeZones", $$robo$$android_util_TimeUtils$getTimeZones(java.lang.String ), 0, (String)string2);
    }

    public static String getTimeZoneDatabaseVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getTimeZoneDatabaseVersion", $$robo$$android_util_TimeUtils$getTimeZoneDatabaseVersion(), 0);
    }

    private static int accumField(int n, int n2, boolean bl, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("accumField", $$robo$$android_util_TimeUtils$accumField(int int boolean int ), 0, (int)n, (int)n2, (boolean)bl, (int)n3);
    }

    private static int printFieldLocked(char[] cArray, int n, char c, int n2, boolean bl, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("printFieldLocked", $$robo$$android_util_TimeUtils$printFieldLocked(char[] int char int boolean int ), 0, (char[])cArray, (int)n, (char)c, (int)n2, (boolean)bl, (int)n3);
    }

    private static int formatDurationLocked(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("formatDurationLocked", $$robo$$android_util_TimeUtils$formatDurationLocked(long int ), 0, (long)l, (int)n);
    }

    public static void formatDuration(long l, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("formatDuration", $$robo$$android_util_TimeUtils$formatDuration(long java.lang.StringBuilder ), 0, (long)l, (StringBuilder)stringBuilder);
    }

    public static void formatDuration(long l, PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("formatDuration", $$robo$$android_util_TimeUtils$formatDuration(long java.io.PrintWriter int ), 0, (long)l, (PrintWriter)printWriter, (int)n);
    }

    public static void formatDuration(long l, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrapStatic("formatDuration", $$robo$$android_util_TimeUtils$formatDuration(long java.io.PrintWriter ), 0, (long)l, (PrintWriter)printWriter);
    }

    public static void formatDuration(long l, long l2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrapStatic("formatDuration", $$robo$$android_util_TimeUtils$formatDuration(long long java.io.PrintWriter ), 0, (long)l, (long)l2, (PrintWriter)printWriter);
    }

    public static String formatUptime(long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatUptime", $$robo$$android_util_TimeUtils$formatUptime(long ), 0, (long)l);
    }

    public static String logTimeOfDay(long l) {
        return InvokeDynamicSupport.bootstrapStatic("logTimeOfDay", $$robo$$android_util_TimeUtils$logTimeOfDay(long ), 0, (long)l);
    }

    public static String formatForLogging(long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatForLogging", $$robo$$android_util_TimeUtils$formatForLogging(long ), 0, (long)l);
    }

    static {
        RobolectricInternals.classInitializing(TimeUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

